unit UniInstance;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms;

function InstanceRunning(AInstanceName: string): Boolean;

implementation

uses simpleipc;

var
  Server: TSimpleIPCServer;

function InstanceRunning(AInstanceName: string): Boolean;
var
  Client: TSimpleIPCClient;
begin
  Result := False;
  Client := TSimpleIPCClient.Create(Application);
  try
    Client.ServerID := AInstanceName;
    Result := Client.ServerRunning;
  finally
    Client.Free;
  end;

  if not Result then
  begin
    Server := TSimpleIPCServer.Create(Application);
    Server.ServerID := AInstanceName;
    Server.Global := True;
    Server.StartServer;
  end;
end;

end.

