unit FindInModules;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, ExtCtrls,
  ComCtrls, Types;

type

  TFindPos = class
  public
    ModuleName: string;
    Row, Col: Integer;
    AExpression: string;
  end;

  { TSearchInModuleForm }

  TSearchInModuleForm = class(TForm)
    Button1: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Edit1: TEdit;
    FindDialog1: TFindDialog;
    Label1: TLabel;
    ListBox1: TListBox;
    Panel1: TPanel;
    procedure Button1Click(Sender: TObject);
    procedure Edit1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure ListBox1DrawItem(Control: TWinControl; Index: Integer;
      ARect: TRect; State: TOwnerDrawState);
    procedure ListBox1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState
      );
  private
    StrList: TStringList;
    FindString: string;
  public
    procedure FindInNode(Node: TTreeNode);
    procedure OpenCurrentPosition;
  end;

var
  SearchInModuleForm: TSearchInModuleForm;

implementation

{$R *.lfm}

uses ProjectManager, LCLType, Editor, character, LazUTF8;

{ TSearchInModuleForm }

procedure TSearchInModuleForm.Button1Click(Sender: TObject);
var
  Node: TTreeNode;
begin
  if Edit1.Text = '' then Exit;

  ListBox1.Clear;
  if CheckBox1.Checked then
    FindString := Edit1.Text
  else
    FindString := LowerCase(Edit1.Text);
  Node := ProjManager.TreeObj.Items.GetFirstNode;
  FindInNode(Node);
end;

procedure TSearchInModuleForm.Edit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then Button1.Click;
end;

procedure TSearchInModuleForm.FormClose(Sender: TObject;
  var CloseAction: TCloseAction);
begin
  CloseAction := caFree;
end;

procedure TSearchInModuleForm.FormCreate(Sender: TObject);
begin
  StrList := TStringList.Create;
end;

procedure TSearchInModuleForm.FormDestroy(Sender: TObject);
begin
  StrList.Free;
  SearchInModuleForm := nil;
end;

procedure TSearchInModuleForm.ListBox1DblClick(Sender: TObject);
begin
  OpenCurrentPosition;
end;

procedure TSearchInModuleForm.ListBox1DrawItem(Control: TWinControl;
  Index: Integer; ARect: TRect; State: TOwnerDrawState);
var
  FindPos: TFindPos;
  R: TRect;
  W, H, Delta: Integer;
  S: string;
begin
  FindPos := TFindPos(ListBox1.Items.Objects[Index]);
  ListBox1.Canvas.Font.Color := clBlack;
  ListBox1.Canvas.Brush.Color := clWhite;
  if odSelected in State then
  begin
    ListBox1.Canvas.Font.Color := clNavy;
    ListBox1.Canvas.Brush.Color := clSkyBlue;
  end;
  ListBox1.Canvas.FillRect(ARect);
  R := ARect;

  ListBox1.Canvas.Font.Color:= clBlack;
  ListBox1.Canvas.Font.Style := [fsBold];
  S := FindPos.ModuleName + ' ';
  W := ListBox1.Canvas.TextWidth(S);
  H := ListBox1.Canvas.TextHeight('W');
  Delta := (R.Bottom - R.Top - H) div 2;
  ListBox1.Canvas.TextRect(R, R.Left, R.Top + Delta, S);
  Inc(R.Left, W);

  S := '(' + IntToStr(FindPos.Row) + ':' + IntToStr(FindPos.Col) + ') ';
  W := ListBox1.Canvas.TextWidth(S);
  ListBox1.Canvas.Font.Color:= clMaroon;
  ListBox1.Canvas.TextRect(R, R.Left, R.Top + Delta, S);
  Inc(R.Left, W);

  H := ListBox1.Canvas.TextHeight('W');
  Delta := (R.Bottom - R.Top - H) div 2;
  ListBox1.Canvas.Font.Style := [];
  ListBox1.Canvas.Font.Color:= clBlack;
  ListBox1.Canvas.TextRect(R, R.Left, R.Top + Delta, FindPos.AExpression);
end;

procedure TSearchInModuleForm.ListBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then OpenCurrentPosition;
end;

procedure TSearchInModuleForm.FindInNode(Node: TTreeNode);
var
  I, N, L, M: Integer;
  ChNode: TTreeNode;
  FindPos: TFindPos;
  SourceString, AChar, BChar, DelimStr: string;
  B: Boolean;
begin
  DelimStr := ' ,=()/*-+|@^$&#@!<>;:"''';
  while Node <> nil do
  begin

    if Node.Data <> nil then
    begin
      StrList.Text:= PNodeObject(Node.Data)^.Code;
      for I := 0 to StrList.Count - 1 do
      begin
        if CheckBox1.Checked then
          SourceString:= StrList.Strings[I]
        else
          SourceString:= LowerCase(StrList.Strings[I]);

        N := UTF8Pos(FindString, SourceString);
        if N > 0 then
        begin
          B := False;
          L := UTF8Length(FindString);
          if CheckBox2.Checked then
          begin
            if SourceString = FindString then
               B := True
            else
            if N = 1 then
            begin
              M := N + L;
              BChar := UTF8Copy(SourceString, M, 1);
              if LastDelimiter(DelimStr, BChar) > 0 then
                  B := True;
            end
            else
            begin
              M := N - 1;
              AChar:= UTF8Copy(SourceString, M, 1);
              if LastDelimiter(DelimStr, AChar) > 0 then
              begin
                M := N + L;
                L := UTF8Length(SourceString);
                if M <= L then
                begin
                  BChar:= UTF8Copy(SourceString, M, 1);
                  if LastDelimiter(DelimStr, BChar) > 0 then
                    B := True;
                end
                else B := True;
              end;
            end
          end
          else
            B := True;

          if B then
          begin
            FindPos := TFindPos.Create;
            FindPos.ModuleName := Node.Text;
            FindPos.Row := I + 1;
            FindPos.Col := N;
            FindPos.AExpression := StrList.Strings[I];
            ListBox1.Items.AddObject(FindPos.ModuleName + ' (' +IntToStr(FindPos.Row) + ':' + IntToStr(FindPos.Col) + ') ' + FindPos.AExpression, FindPos);
          end;

        end;
      end;
    end;

    if Node.HasChildren then
    begin
      ChNode := Node.GetFirstChild;
      FindInNode(ChNode);
    end;

    Node := Node.GetNextSibling;

  end;
end;

procedure TSearchInModuleForm.OpenCurrentPosition;
var
  FindPos: TFindPos;
  PM: TPageModule;
begin
  if ListBox1.ItemIndex >= 0 then
  begin
    FindPos := TFindPos(ListBox1.Items.Objects[ListBox1.ItemIndex]);
    if EditorForm = nil then CreateEditor;
    EditorForm.GoModulePos(FindPos.ModuleName, FindPos.Row, FindPos.Col);
  end;
end;

end.

