unit SuZEOSImport;

interface

uses SysUtils, Classes, dpCompil, TypInfo, dpEvntHadlrs, DB;

type

  { TZEOSImport }

  TZEOSImport = class(TClassImporter)
    {TZAbstractRODataset support}
    function ZAbsRODataSet_FetchAll(Instence: TObject; var Params: Variant): Variant;
    function ZAbsRODataSet_ExecSQL(Instence: TObject; var Params: Variant): Variant;
    function ZAbsRODataSet_RowsAffected(Instence: TObject; var Params: Variant): Variant;
    function ZAbsRODataSet_PN(Instence: TObject; var Params: Variant): Variant;
    function ZAbsRODataSet_Prepare(Instence: TObject; var Params: Variant): Variant;
    function ZAbsRODataSet_Unprepare(Instence: TObject; var Params: Variant): Variant;

    function ZAbsRODataSet_PreparedGet(Instence: Pointer): Variant;
    procedure ZAbsRODataSet_PreparedSet(Instence: Pointer; AValue: Variant);

    {TZAbstractDataset}
    function ZAbasDataset_ApplyUpdates(Instence: TObject; var Params: Variant): Variant;
    function ZAbasDataset_CommitUpdates(Instence: TObject; var Params: Variant): Variant;
    function ZAbasDataset_CancelUpdates(Instence: TObject; var Params: Variant): Variant;
    function ZAbasDataset_RevertRecord(Instence: TObject; var Params: Variant): Variant;
    function ZAbasDataset_RefreshCurrentRow(Instence: TObject; var Params: Variant): Variant;
    function ZAbasDataset_EmptyDataSet(Instence: TObject; var Params: Variant): Variant;

    function ZAbasDataset_UpdatesPending(Instence: Pointer): Variant;

    {TZStoredProc}
    function ZStoredProc_ExecProc(Instence: TObject; var Params: Variant): Variant;

    {TZUpdateSQL support}
    function ZUpdateSQL_GetParamsCount(Instence: Pointer): Variant;
    function ZUpdateSQL_DataSetGet(Instence: Pointer): Variant;
    procedure ZUpdateSQL_DataSetSet(Instence: Pointer; AValue: Variant);

    {TZConnection support}
    function ZConn_Connect(Instence: TObject; var Params: Variant): Variant;
    function ZConn_Disconnect(Instence: TObject; var Params: Variant): Variant;
    function ZConn_Reconnect(Instence: TObject; var Params: Variant): Variant;
    function ZConn_Ping(Instence: TObject; var Params: Variant): Variant;
    function ZConn_StartTransaction(Instence: TObject; var Params: Variant): Variant;
    function ZConn_Commit(Instence: TObject; var Params: Variant): Variant;
    function ZConn_Rollback(Instence: TObject; var Params: Variant): Variant;
    function ZConn_PrepareTransaction(Instence: TObject; var Params: Variant): Variant;
    function ZConn_CommitPrepared(Instence: TObject; var Params: Variant): Variant;
    function ZConn_RollbackPrepared(Instence: TObject; var Params: Variant): Variant;
    function ZConn_PingServer(Instence: TObject; var Params: Variant): Variant;

    function ZConn_ExecuteDirect(Instence: TObject; var Params: Variant): Variant;
    function ZConn_GetProtocolNames(Instence: TObject; var Params: Variant): Variant;
    function ZConn_GetCatalogNames(Instence: TObject; var Params: Variant): Variant;
    function ZConn_GetSchemaNames(Instence: TObject; var Params: Variant): Variant;
    function ZConn_GetTableNames(Instence: TObject; var Params: Variant): Variant;
    function ZConn_GetStoredProcNames(Instence: TObject; var Params: Variant): Variant;
    function ZConn_ShowSQLHourGlass(Instence: TObject; var Params: Variant): Variant;
    function ZConn_HideSQLHourGlass(Instence: TObject; var Params: Variant): Variant;

    function ZConn_GetInTransaction(Instence: Pointer): Variant;
    function ZConn_ClientVersionStr(Instence: Pointer): Variant;
    function ZConn_ServerVersionStr(Instence: Pointer): Variant;

    {TZSequence support}
    function ZSequence_GetCurrentValue(Instence: TObject; var Params: Variant): Variant;
    function ZSequence_GetNextValue(Instence: TObject; var Params: Variant): Variant;
    function ZSequence_GetCurrentValueSQL(Instence: TObject; var Params: Variant): Variant;
    function ZSequence_GetNextValueSQL(Instence: TObject; var Params: Variant): Variant;
    function ZSequence_CloseSequence(Instence: TObject; var Params: Variant): Variant;

    {TZSQLMonitor support}
    function ZSQLMonitor_Save(Instence: TObject; var Params: Variant): Variant;
    function ZSQLMonitor_SaveToFile(Instence: TObject; var Params: Variant): Variant;

    {TZIBEventAlerter}
    function ZIBEventAlerter_RegisterEvents(Instence: TObject; var Params: Variant): Variant;
    function ZIBEventAlerter_UnRegisterEvents(Instence: TObject; var Params: Variant): Variant;

    {TZSQLProcessor}
    function ZSQLProces_LoadFromStream(Instence: TObject; var Params: Variant): Variant;
    function ZSQLProces_LoadFromFile(Instence: TObject; var Params: Variant): Variant;
    function ZSQLProces_Execute(Instence: TObject; var Params: Variant): Variant;
    function ZSQLProces_Parse(Instence: TObject; var Params: Variant): Variant;
    function ZSQLProces_Clear(Instence: TObject; var Params: Variant): Variant;
    function ZSQLProces_PN(Instence: TObject; var Params: Variant): Variant;
    function ZSQLProces_GetStatement(Instence: TObject; var Params: Variant): Variant;

    function ZSQLProces_GetStatementCount(Instence: Pointer): Variant;
  private
    function ZParams_FindParam(Instance: TObject; var Params: Variant): Variant;
    function ZParams_FlushParameterConSettings(Instance: TObject;
      var Params: Variant): Variant;
    function ZParams_IsEqual(Instance: TObject; var Params: Variant): Variant;
    function ZParams_ItemsGet(Instance: TObject; var Params: Variant): Variant;
    function ZParams_ItemsSet(Instance: TObject; var Params: Variant): Variant;
    function ZParams_ParamByName(Instance: TObject; var Params: Variant
      ): Variant;
    function ZParams_ParamValuesGet(Instance: TObject; var Params: Variant
      ): Variant;
    function ZParams_ParamValuesSet(Instance: TObject; var Params: Variant
      ): Variant;
    function ZParam_AsBooleanGet(Instance: Pointer): Variant;
    procedure ZParam_AsBooleanSet(Instance: Pointer; AValue: Variant);
    function ZParam_AsCardinalGet(Instance: Pointer): Variant;
    procedure ZParam_AsCardinalSet(Instance: Pointer; AValue: Variant);
    function ZParam_AsCurrencyGet(Instance: Pointer): Variant;
    procedure ZParam_AsCurrencySet(Instance: Pointer; AValue: Variant);
    function ZParam_AsDateGet(Instance: Pointer): Variant;
    procedure ZParam_AsDateSet(Instance: Pointer; AValue: Variant);
    function ZParam_AsDateTimeGet(Instance: Pointer): Variant;
    procedure ZParam_AsDateTimeSet(Instance: Pointer; AValue: Variant);
    function ZParam_AsDoubleGet(Instance: Pointer): Variant;
    procedure ZParam_AsDoubleSet(Instance: Pointer; AValue: Variant);
    function ZParam_AsFloatGet(Instance: Pointer): Variant;
    procedure ZParam_AsFloatSet(Instance: Pointer; AValue: Variant);
    function ZParam_AsInt64Get(Instance: Pointer): Variant;
    procedure ZParam_AsInt64Set(Instance: Pointer; AValue: Variant);
    function ZParam_AsIntegerGet(Instance: Pointer): Variant;
    procedure ZParam_AsIntegerSet(Instance: Pointer; AValue: Variant);
    function ZParam_AsLargeIntGet(Instance: Pointer): Variant;
    procedure ZParam_AsLargeIntSet(Instance: Pointer; AValue: Variant);
    function ZParam_AsMemoGet(Instance: Pointer): Variant;
    procedure ZParam_AsMemoSet(Instance: Pointer; AValue: Variant);
    function ZParam_AsStringGet(Instance: Pointer): Variant;
    procedure ZParam_AsStringSet(Instance: Pointer; AValue: Variant);
    function ZParam_AsTimeGet(Instance: Pointer): Variant;
    procedure ZParam_AsTimeSet(Instance: Pointer; AValue: Variant);
    function ZParam_BoundGet(Instance: Pointer): Variant;
    function ZParam_Clear(Instance: TObject; var Params: Variant): Variant;
    function ZParam_IsNullGet(Instance: Pointer): Variant;
    procedure ZParam_IsNullSet(Instance: Pointer; AValue: Variant);
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
       override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
  end;


implementation

uses
  ZConnection, ZDataset, ZSequence, ZSqlUpdate, ZStoredProcedure,
  ZSqlProcessor, ZSqlMetadata, ZSqlMonitor, ZIBEventAlerter,
  ZAbstractRODataset, ZAbstractDataset, ZAbstractConnection, ZPgEventAlerter,
  ZDatasetParam;

type
  TUpdateRecordHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(DataSet: TDataSet; UpdateKind: TUpdateKind;
      var UpdateAction: TUpdateAction);
  end;

  TEventAlertHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; EventName: string; EventCount: longint;
      var CancelAlerts: boolean);
  end;

  { TZPgNotifyEventHandler }

  TZPgNotifyEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Event: string;
      ProcessID: Integer; Payload: string);
  end;

{ TZPgNotifyEventHandler }

function TZPgNotifyEventHandler.GetHandlerAdres: Pointer;
begin
  Result:= @TZPgNotifyEventHandler.CallHandler;
end;

procedure TZPgNotifyEventHandler.CallHandler(Sender: TObject; Event: string;
  ProcessID: Integer; Payload: string);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Event;
  Proc.Param[2].Value := ProcessID;
  Proc.Param[3].Value := Payload;
  Proc.Exec;
end;

procedure TZEOSImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TZUpdateMode));
  AddType(TypeInfo(TZWhereMode));
end;

procedure TZEOSImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddClass(TZAbstractConnection).ClassImporter := Self;
  AddClass(TZConnection);//.ClassImporter := Self;
  AddClass(TZAbstractRODataset).ClassImporter := Self;
  AddClass(TZAbstractDataset).ClassImporter := Self;
  AddClass(TZReadOnlyQuery);
  AddClass(TZParams).ClassImporter := Self;
  AddClass(TZParam).ClassImporter := Self;
  AddClass(TZQuery);
  AddClass(TZTable);
  AddClass(TZUpdateSQL).ClassImporter := Self;
  AddClass(TZStoredProc).ClassImporter := Self;
  AddClass(TZSequence).ClassImporter := Self;
  AddClass(TZLoggingEvent);
  AddClass(TZSQLMonitor).ClassImporter := Self;
  AddClass(TZSQLMetadata);
  AddClass(TZSQLProcessor).ClassImporter := Self;
  AddClass(TZIBEventAlerter).ClassImporter := Self;
  AddClass(TZIBEventAlerter).ClassImporter := Self;
  AddClass(TZPgEventAlerter);
end;

procedure TZEOSImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TZAbstractRODataset then
  begin
    AType.AddMethod('procedure FetchAll', @ZAbsRODataSet_FetchAll);
    AType.AddMethod('procedure ExecSQL', @ZAbsRODataSet_ExecSQL);
    AType.AddMethod('function RowsAffected: LongInt', @ZAbsRODataSet_RowsAffected);
    AType.AddMethod('function ParamByName(const Value: string): TZParam', @ZAbsRODataSet_PN);
    AType.AddMethod('function PN(const Value: string): TZParam', @ZAbsRODataSet_PN);
    AType.AddMethod('procedure Prepare', @ZAbsRODataSet_Prepare);
    AType.AddMethod('procedure Unprepare', @ZAbsRODataSet_Unprepare);
    AType.AddProp('Prepared', 'Boolean', @ZAbsRODataSet_PreparedGet, @ZAbsRODataSet_PreparedSet);
  end
  else
  if AType.ValueClassType = TZStoredProc then
  begin
    AType.AddMethod('procedure ExecProc', @ZStoredProc_ExecProc);
  end
  else
  if AType.ValueClassType = TZAbstractConnection then
  begin
    AType.AddMethod('procedure Connect', @ZConn_Connect);
    AType.AddMethod('procedure Disconnect', @ZConn_Disconnect);
    AType.AddMethod('procedure Reconnect', @ZConn_Reconnect);
    AType.AddMethod('function Ping: Boolean', @ZConn_Ping);
    AType.AddMethod('procedure StartTransaction', @ZConn_StartTransaction);
    AType.AddMethod('procedure Commit', @ZConn_Commit);
    AType.AddMethod('procedure Rollback', @ZConn_Rollback);
    AType.AddMethod('procedure PrepareTransaction(const transactionid: string)', @ZConn_PrepareTransaction);
    AType.AddMethod('procedure CommitPrepared(const transactionid: string)', @ZConn_CommitPrepared);
    AType.AddMethod('procedure RollbackPrepared(const transactionid: string)', @ZConn_RollbackPrepared);
    AType.AddMethod('function PingServer: Boolean', @ZConn_PingServer);
    AType.AddMethod('function ExecuteDirect(SQL:string):boolean', @ZConn_ExecuteDirect);
    AType.AddMethod('procedure GetProtocolNames(List: TStrings)', @ZConn_GetProtocolNames);
    AType.AddMethod('procedure GetCatalogNames(List: TStrings)', @ZConn_GetCatalogNames);
    AType.AddMethod('procedure GetSchemaNames(List: TStrings)', @ZConn_GetSchemaNames);
    AType.AddMethod('procedure GetTableNames(const Pattern: string; List: TStrings)', @ZConn_GetTableNames);
    AType.AddMethod('procedure GetStoredProcNames(const Pattern: string; List: TStrings)', @ZConn_GetStoredProcNames);
    AType.AddMethod('procedure ShowSQLHourGlass', @ZConn_ShowSQLHourGlass);
    AType.AddMethod('procedure HideSQLHourGlass', @ZConn_HideSQLHourGlass);

    AType.AddProp('InTransaction', 'Boolean', @ZConn_GetInTransaction);
    AType.AddProp('ClientVersionStr', 'String', @ZConn_ClientVersionStr);
    AType.AddProp('ServerVersionStr', 'String', @ZConn_ServerVersionStr);
  end
  {else
  if AType.ValueClassType = TZConnection then
  begin

  end}
  else
  if AType.ValueClassType = TZAbstractDataset then
  begin
    AType.AddMethod('procedure ApplyUpdates', @ZAbasDataset_ApplyUpdates);
    AType.AddMethod('procedure CommitUpdates', @ZAbasDataset_CommitUpdates);
    AType.AddMethod('procedure CancelUpdates', @ZAbasDataset_CancelUpdates);
    AType.AddMethod('procedure RevertRecord', @ZAbasDataset_RevertRecord);
    AType.AddMethod('procedure RefreshCurrentRow(const RefreshDetails:Boolean)', @ZAbasDataset_RefreshCurrentRow);
    AType.AddMethod('procedure EmptyDataSet', @ZAbasDataset_EmptyDataSet);
    AType.AddProp('UpdatesPending', 'Boolean', @ZAbasDataset_UpdatesPending);
  end
  else
  if AType.ValueClassType = TZUpdateSQL then
  begin
    AType.AddProp('DataSet', 'TDataSet', @ZUpdateSQL_DataSetGet, @ZUpdateSQL_DataSetSet);
    AType.AddProp('ParamCount', 'Word', @ZUpdateSQL_GetParamsCount);
  end
  else
  if AType.ValueClassType = TZSequence then
  begin
    AType.AddMethod('function GetCurrentValue: Int64', @ZSequence_GetCurrentValue);
    AType.AddMethod('function GetNextValue: Int64', @ZSequence_GetNextValue);
    AType.AddMethod('function  GetCurrentValueSQL: string', @ZSequence_GetCurrentValueSQL);
    AType.AddMethod('function  GetNextValueSQL: string', @ZSequence_GetNextValueSQL);
    AType.AddMethod('procedure CloseSequence', @ZSequence_CloseSequence);
  end
  else
  if AType.ValueClassType = TZSQLMonitor then
  begin
    AType.AddMethod('procedure Save', @ZSQLMonitor_Save);
    AType.AddMethod('procedure SaveToFile(const FileName: string)', @ZSQLMonitor_SaveToFile);
  end
  else
  if AType.ValueClassType = TZIBEventAlerter then
  begin
    AType.AddMethod('procedure RegisterEvents', @ZIBEventAlerter_RegisterEvents);
    AType.AddMethod('procedure UnRegisterEvents', @ZIBEventAlerter_UnRegisterEvents);
  end
  else
  if AType.ValueClassType = TZSQLProcessor then
  begin
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @ZSQLProces_LoadFromStream);
    AType.AddMethod('procedure LoadFromFile(const FileName: string)', @ZSQLProces_LoadFromFile);
    AType.AddMethod('procedure Execute', @ZSQLProces_Execute);
    AType.AddMethod('procedure Parse', @ZSQLProces_Parse);
    AType.AddMethod('procedure Clear', @ZSQLProces_Clear);
    AType.AddMethod('function ParamByName(const Value: string): TParam', @ZSQLProces_PN);
    AType.AddMethod('function PN(const Value: string): TParam', @ZSQLProces_PN);
    AType.AddProp('StatementCount', 'Integer', @ZSQLProces_GetStatementCount);
    AType.AddIndexedProp('Statements', 'string', 'Integer', @ZSQLProces_GetStatement);
  end
  else
  if AType.ValueClassType = TZParams then
  begin
    AType.AddMethod('function ParamByName(const Value: string): TZParam', @ZParams_ParamByName);
    AType.AddMethod('function PN(const Value: string): TZParam', @ZParams_ParamByName);
    AType.AddMethod('function FindParam(const Value: string): TZParam', @ZParams_FindParam);
    AType.AddMethod('procedure FlushParameterConSettings', @ZParams_FlushParameterConSettings);
    AType.AddMethod('function IsEqual(Value: TZParams): Boolean', @ZParams_IsEqual);
    AType.AddIndexedProp('Items', 'TZParam', 'Integer', @ZParams_ItemsGet, @ZParams_ItemsSet);
    AType.AddIndexedProp('ParamValues', 'Variant', 'string', @ZParams_ParamValuesGet, @ZParams_ParamValuesSet);
  end
  else
  if AType.ValueClassType = TZParam then
  begin
    AType.AddProp('AsBoolean', 'Boolean', @ZParam_AsBooleanGet, @ZParam_AsBooleanSet);
    AType.AddProp('AsCardinal', 'Cardinal', @ZParam_AsCardinalGet, @ZParam_AsCardinalSet);
    AType.AddProp('AsCurrency', 'Currency', @ZParam_AsCurrencyGet, @ZParam_AsCurrencySet);
    AType.AddProp('AsDouble', 'Double', @ZParam_AsDoubleGet, @ZParam_AsDoubleSet);
    AType.AddProp('AsDate', 'TDate', @ZParam_AsDateGet, @ZParam_AsDateSet);
    AType.AddProp('AsDateTime', 'TDateTime', @ZParam_AsDateTimeGet, @ZParam_AsDateTimeSet);
    AType.AddProp('AsFloat', 'Double', @ZParam_AsFloatGet, @ZParam_AsFloatSet);
    AType.AddProp('AsInteger', 'Integer', @ZParam_AsIntegerGet, @ZParam_AsIntegerSet);
    AType.AddProp('AsInt64', 'Int64', @ZParam_AsInt64Get, @ZParam_AsInt64Set);
    AType.AddProp('AsLargeInt', 'LargeInt', @ZParam_AsLargeIntGet, @ZParam_AsLargeIntSet);
    AType.AddProp('AsMemo', 'String', @ZParam_AsMemoGet, @ZParam_AsMemoSet);
    AType.AddProp('AsString', 'String', @ZParam_AsStringGet, @ZParam_AsStringSet);
    AType.AddProp('AsTime', 'TTime', @ZParam_AsTimeGet, @ZParam_AsTimeSet);
    AType.AddProp('IsNull', 'Boolean', @ZParam_IsNullGet, @ZParam_IsNullSet);
    AType.AddProp('Bound', 'Boolean', @ZParam_BoundGet);
    AType.AddMethod('procedure Clear', @ZParam_Clear);
  end;
end;

procedure TZEOSImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TUpdateRecordEvent), TUpdateRecordHandler);
  RegisterHandler(TypeInfo(TEventAlert), TEventAlertHandler);
  RegisterHandler(TypeInfo(TZPgNotifyEvent), TZPgNotifyEventHandler);
end;

function TUpdateRecordHandler.GetHandlerAdres: Pointer;
begin
  Result := @TUpdateRecordHandler.CallHandler;
end;

procedure TUpdateRecordHandler.CallHandler(DataSet: TDataSet; UpdateKind: TUpdateKind;
      var UpdateAction: TUpdateAction);
begin
  if Proc.ParamCount = 3 then
  begin
    Proc.Param[0].Value := TSuPtr(DataSet);
    Proc.Param[1].Value := UpdateKind;
    Proc.Param[2].Value := UpdateAction;
    Proc.Exec;
    UpdateAction := Proc.Param[2].Value;
  end;
end;

function TEventAlertHandler.GetHandlerAdres: Pointer;
begin
  Result := @TEventAlertHandler.CallHandler;
end;                         

procedure TEventAlertHandler.CallHandler(Sender: TObject; EventName: string; EventCount: longint;
      var CancelAlerts: boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := EventName;
  Proc.Param[2].Value := EventCount;
  Proc.Param[3].Value := CancelAlerts;
  Proc.Exec;
  CancelAlerts := Proc.Param[3].Value;
end;

{TZAbstractRODataset support}
function TZEOSImport.ZAbsRODataSet_FetchAll(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractRODataset(Instence).FetchAll
end;

function TZEOSImport.ZAbsRODataSet_ExecSQL(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractRODataset(Instence).ExecSQL
end;

function TZEOSImport.ZAbsRODataSet_RowsAffected(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TZAbstractRODataset(Instence).RowsAffected
end;

function TZEOSImport.ZAbsRODataSet_PN(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TZAbstractRODataset(Instence).ParamByName(Params[0]));
end;

function TZEOSImport.ZAbsRODataSet_Prepare(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractRODataset(Instence).Prepare
end;

function TZEOSImport.ZAbsRODataSet_Unprepare(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractRODataset(Instence).Unprepare
end;

function TZEOSImport.ZAbsRODataSet_PreparedGet(Instence: Pointer): Variant;
begin
  Result := TZAbstractRODataset(Instence).Prepared
end;

procedure TZEOSImport.ZAbsRODataSet_PreparedSet(Instence: Pointer; AValue: Variant);
begin
  TZAbstractRODataset(Instence).Prepared := AValue
end;

{TZAbstractDataset}
function TZEOSImport.ZAbasDataset_ApplyUpdates(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractDataset(Instence).ApplyUpdates
end;

function TZEOSImport.ZAbasDataset_CommitUpdates(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractDataset(Instence).CommitUpdates
end;

function TZEOSImport.ZAbasDataset_CancelUpdates(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractDataset(Instence).CancelUpdates
end;

function TZEOSImport.ZAbasDataset_RevertRecord(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractDataset(Instence).RevertRecord
end;

function TZEOSImport.ZAbasDataset_RefreshCurrentRow(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractDataset(Instence).RefreshCurrentRow(Params[0]);
end;

function TZEOSImport.ZAbasDataset_EmptyDataSet(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractDataset(Instence).EmptyDataSet
end;

function TZEOSImport.ZAbasDataset_UpdatesPending(Instence: Pointer): Variant;
begin
  Result := TZAbstractDataset(Instence).UpdatesPending
end;

{TZStoredProc}
function TZEOSImport.ZStoredProc_ExecProc(Instence: TObject; var Params: Variant): Variant;
begin
  TZStoredProc(Instence).ExecProc
end;

{TZUpdateSQL support}

function TZEOSImport.ZUpdateSQL_GetParamsCount(Instence: Pointer): Variant;
begin
  Result := TZUpdateSQL(Instence).ParamCount
end;

function TZEOSImport.ZUpdateSQL_DataSetGet(Instence: Pointer): Variant;
begin
  Result := TSuPtr(TZUpdateSQL(Instence).DataSet)
end;

procedure TZEOSImport.ZUpdateSQL_DataSetSet(Instence: Pointer; AValue: Variant);
begin
  TZUpdateSQL(Instence).DataSet := TDataSet(TSuPtr(AValue))
end;

{TZConnection support}
function TZEOSImport.ZConn_Connect(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).Connect
end;

function TZEOSImport.ZConn_Disconnect(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).Disconnect
end;

function TZEOSImport.ZConn_Reconnect(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).Reconnect
end;

function TZEOSImport.ZConn_Ping(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TZAbstractConnection(Instence).Ping
end;

function TZEOSImport.ZConn_StartTransaction(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).StartTransaction
end;

function TZEOSImport.ZConn_Commit(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).Commit
end;

function TZEOSImport.ZConn_Rollback(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).Rollback
end;

function TZEOSImport.ZConn_PrepareTransaction(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).PrepareTransaction(Params[0]);
end;

function TZEOSImport.ZConn_CommitPrepared(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).CommitPrepared(Params[0]);
end;

function TZEOSImport.ZConn_RollbackPrepared(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).RollbackPrepared(Params[0]);
end;

function TZEOSImport.ZConn_PingServer(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TZAbstractConnection(Instence).PingServer
end;

function TZEOSImport.ZConn_ExecuteDirect(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TZAbstractConnection(Instence).ExecuteDirect(Params[0])
end;

function TZEOSImport.ZConn_GetProtocolNames(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).GetProtocolNames(TStrings(TSuPtr(Params[0])));
end;

function TZEOSImport.ZConn_GetCatalogNames(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).GetCatalogNames(TStrings(TSuPtr(Params[0])));
end;

function TZEOSImport.ZConn_GetSchemaNames(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).GetSchemaNames(TStrings(TSuPtr(Params[0])));
end;

function TZEOSImport.ZConn_GetTableNames(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).GetTableNames(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TZEOSImport.ZConn_GetStoredProcNames(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).GetStoredProcNames(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TZEOSImport.ZConn_ShowSQLHourGlass(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).ShowSQLHourGlass
end;

function TZEOSImport.ZConn_HideSQLHourGlass(Instence: TObject; var Params: Variant): Variant;
begin
  TZAbstractConnection(Instence).HideSQLHourGlass
end;

function TZEOSImport.ZConn_GetInTransaction(Instence: Pointer): Variant;
begin
  Result := TZAbstractConnection(Instence).InTransaction
end;

function TZEOSImport.ZConn_ClientVersionStr(Instence: Pointer): Variant;
begin
  Result := TZAbstractConnection(Instence).ClientVersionStr
end;

function TZEOSImport.ZConn_ServerVersionStr(Instence: Pointer): Variant;
begin
  Result := TZAbstractConnection(Instence).ServerVersionStr
end;

{TZSequence support}

function TZEOSImport.ZSequence_GetCurrentValue(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TZSequence(Instence).GetCurrentValue
end;

function TZEOSImport.ZSequence_GetNextValue(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TZSequence(Instence).GetNextValue
end;

function TZEOSImport.ZSequence_GetCurrentValueSQL(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TZSequence(Instence).GetCurrentValueSQL
end;

function TZEOSImport.ZSequence_GetNextValueSQL(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TZSequence(Instence).GetNextValueSQL
end;

function TZEOSImport.ZSequence_CloseSequence(Instence: TObject; var Params: Variant): Variant;
begin
  TZSequence(Instence).CloseSequence;
end;

{TZSQLMonitor support}

function TZEOSImport.ZSQLMonitor_Save(Instence: TObject; var Params: Variant): Variant;
begin
  TZSQLMonitor(Instence).Save
end;

function TZEOSImport.ZSQLMonitor_SaveToFile(Instence: TObject; var Params: Variant): Variant;
begin
  TZSQLMonitor(Instence).SaveToFile(Params[0]);
end;

{TZIBEventAlerter}
function TZEOSImport.ZIBEventAlerter_RegisterEvents(Instence: TObject; var Params: Variant): Variant;
begin
  TZIBEventAlerter(Instence).RegisterEvents
end;

function TZEOSImport.ZIBEventAlerter_UnRegisterEvents(Instence: TObject; var Params: Variant): Variant;
begin
  TZIBEventAlerter(Instence).UnRegisterEvents
end;

{TZSQLProcessor}
function TZEOSImport.ZSQLProces_LoadFromStream(Instence: TObject; var Params: Variant): Variant;
begin
  TZSQLProcessor(Instence).LoadFromStream(TStream(TSuPtr(Params[0])));
end;

function TZEOSImport.ZSQLProces_LoadFromFile(Instence: TObject; var Params: Variant): Variant;
begin
  TZSQLProcessor(Instence).LoadFromFile(Params[0]);
end;

function TZEOSImport.ZSQLProces_Execute(Instence: TObject; var Params: Variant): Variant;
begin
  TZSQLProcessor(Instence).Execute
end;

function TZEOSImport.ZSQLProces_Parse(Instence: TObject; var Params: Variant): Variant;
begin
  TZSQLProcessor(Instence).Parse
end;

function TZEOSImport.ZSQLProces_Clear(Instence: TObject; var Params: Variant): Variant;
begin
  TZSQLProcessor(Instence).Clear
end;

function TZEOSImport.ZSQLProces_PN(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr( TZSQLProcessor(Instence).ParamByName(Params[0]))
end;

function TZEOSImport.ZSQLProces_GetStatement(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TZSQLProcessor(Instence).Statements[Params[0]]
end;

function TZEOSImport.ZSQLProces_GetStatementCount(Instence: Pointer): Variant;
begin
  Result := TZSQLProcessor(Instence).StatementCount
end;

function TZEOSImport.ZParams_FindParam(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TZParams(Instance).FindParam(Params[0]));
end;

function TZEOSImport.ZParams_FlushParameterConSettings(Instance: TObject;
  var Params: Variant): Variant;
begin
  TZParams(Instance).FlushParameterConSettings;
end;

function TZEOSImport.ZParams_IsEqual(Instance: TObject; var Params: Variant
  ): Variant;
var
  AValue: TZParams;
begin
  AValue := TZParams(TSuPtr(Params[0]));
  Result := TZParams(Instance).IsEqual(AValue);
end;

function TZEOSImport.ZParams_ItemsGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TZParams(Instance).Items[Params[0]]);
end;

function TZEOSImport.ZParams_ItemsSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TZParams(Instance).Items[Params[0]] := TZParam(TSuPtr(Params[1]));
end;

function TZEOSImport.ZParams_ParamByName(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TZParams(Instance).ParamByName(Params[0]));
end;

function TZEOSImport.ZParams_ParamValuesGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TZParams(Instance).ParamValues[Params[0]];
end;

function TZEOSImport.ZParams_ParamValuesSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TZParams(Instance).ParamValues[Params[0]] := Params[1];
end;

function TZEOSImport.ZParam_AsBooleanGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).AsBoolean;
end;

procedure TZEOSImport.ZParam_AsBooleanSet(Instance: Pointer; AValue: Variant);
begin
  TZParam(Instance).AsBoolean := AValue;
end;

function TZEOSImport.ZParam_AsCardinalGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).AsCardinal;
end;

procedure TZEOSImport.ZParam_AsCardinalSet(Instance: Pointer; AValue: Variant);
begin
  TZParam(Instance).AsCardinal := AValue;
end;

function TZEOSImport.ZParam_AsCurrencyGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).AsCurrency;
end;

procedure TZEOSImport.ZParam_AsCurrencySet(Instance: Pointer; AValue: Variant);
begin
  TZParam(Instance).AsCurrency := AValue;
end;

function TZEOSImport.ZParam_AsDateGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).AsDate;
end;

procedure TZEOSImport.ZParam_AsDateSet(Instance: Pointer; AValue: Variant);
var
  D: TDateTime;
begin
  D := AValue;
  TZParam(Instance).AsDate := D;
end;

function TZEOSImport.ZParam_AsDateTimeGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).AsDateTime;
end;

procedure TZEOSImport.ZParam_AsDateTimeSet(Instance: Pointer; AValue: Variant);
begin
  TZParam(Instance).AsDateTime := AValue;
end;

function TZEOSImport.ZParam_AsDoubleGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).AsDouble;
end;

procedure TZEOSImport.ZParam_AsDoubleSet(Instance: Pointer; AValue: Variant);
begin
  TZParam(Instance).AsDouble := AValue;
end;

function TZEOSImport.ZParam_AsFloatGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).AsFloat;
end;

procedure TZEOSImport.ZParam_AsFloatSet(Instance: Pointer; AValue: Variant);
begin
  TZParam(Instance).AsFloat := AValue;
end;

function TZEOSImport.ZParam_AsInt64Get(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).AsInt64;
end;

procedure TZEOSImport.ZParam_AsInt64Set(Instance: Pointer; AValue: Variant);
begin
  TZParam(Instance).AsInt64 := AValue;
end;

function TZEOSImport.ZParam_AsIntegerGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).AsInteger;
end;

procedure TZEOSImport.ZParam_AsIntegerSet(Instance: Pointer; AValue: Variant);
begin
  TZParam(Instance).AsInteger := AValue;
end;

function TZEOSImport.ZParam_AsLargeIntGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).AsLargeInt;
end;

procedure TZEOSImport.ZParam_AsLargeIntSet(Instance: Pointer; AValue: Variant);
begin
  TZParam(Instance).AsLargeInt := AValue;
end;

function TZEOSImport.ZParam_AsMemoGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).AsMemo;
end;

procedure TZEOSImport.ZParam_AsMemoSet(Instance: Pointer; AValue: Variant);
begin
  TZParam(Instance).AsMemo := AValue;
end;

function TZEOSImport.ZParam_AsStringGet(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).AsString;
end;

procedure TZEOSImport.ZParam_AsStringSet(Instance: Pointer; AValue: Variant);
begin
  TZParam(Instance).AsString := AValue;
end;

function TZEOSImport.ZParam_AsTimeGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).AsTime;
end;

procedure TZEOSImport.ZParam_AsTimeSet(Instance: Pointer; AValue: Variant);
var
  D: TDateTime;
begin
  D := AValue;
  TZParam(Instance).AsTime := D;
end;

function TZEOSImport.ZParam_BoundGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).Bound;
end;

function TZEOSImport.ZParam_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TZParam(Instance).Clear;
end;

function TZEOSImport.ZParam_IsNullGet(Instance: Pointer): Variant;
begin
  Result := TZParam(Instance).IsNull;
end;

procedure TZEOSImport.ZParam_IsNullSet(Instance: Pointer; AValue: Variant);
begin
  TZParam(Instance).IsNull := AValue;
end;


end.
