unit dpi_Classes;

{$mode objfpc}{$H+}
{$M+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo, Forms, Clipbrd, zipper, dpi_mettyps;

type
  TxZipper = class(TZipper)
  published
    Property BufferSize;
    Property OnPercent;
    Property OnProgress;
    Property OnStartFile;
    Property OnEndFile;
    property Files;
    property InMemSize;
    property Entries;
  end;

  TxUnZipper = class(TUnZipper)
  published
    Property BufferSize;
    Property OnOpenInputStream;
    Property OnCloseInputStream;
   // Property OnCreateStream;
    //Property OnDoneStream;
    Property OnPercent;
    Property OnProgress;
    Property OnStartFile;
    Property OnEndFile;
    //Property FileComment;
    Property Files;
    Property Entries;
  end;

  { TFormatSettings }

  TFormatSet = class
  protected
  public
    F: TFormatSettings;
    constructor Create;
  published
    property CurrencyFormat: Byte read F.CurrencyFormat write F.CurrencyFormat;
    property NegCurrFormat: Byte read F.NegCurrFormat write F.NegCurrFormat;
    property ThousandSeparator: Char read F.ThousandSeparator write F.ThousandSeparator;
    property DecimalSeparator: Char read F.DecimalSeparator write F.DecimalSeparator;
    property CurrencyDecimals: Byte read F.CurrencyDecimals write F.CurrencyDecimals;
    property DateSeparator: Char read F.DateSeparator write F.DateSeparator;
    property TimeSeparator: Char read F.TimeSeparator write F.TimeSeparator;
    property ListSeparator: Char read F.ListSeparator write F.ListSeparator;
    property CurrencyString: string read F.CurrencyString write F.CurrencyString;
    property ShortDateFormat: string read F.ShortDateFormat write F.ShortDateFormat;
    property LongDateFormat: string read F.LongDateFormat write F.LongDateFormat;
    property TimeAMString: string read F.TimeAMString write F.TimeAMString;
    property  TimePMString: string read F.TimePMString write F.TimePMString;
    property  ShortTimeFormat: string read F.ShortTimeFormat write F.ShortTimeFormat;
    property  LongTimeFormat: string read F.LongTimeFormat write F.LongTimeFormat;
    //property  ShortMonthNames: TMonthNameArray read F.ShortMonthNames write F.ShortMonthNames;
    //property  LongMonthNames: TMonthNameArray read F.LongMonthNames write F.LongMonthNames;
    //property  ShortDayNames: TWeekNameArray read F.TWeekNameArray write F.TWeekNameArray;
    //property  LongDayNames: TWeekNameArray read F.LongDayNames write F.LongDayNames;
    property  TwoDigitYearCenturyWindow: Word read F.TwoDigitYearCenturyWindow write F.TwoDigitYearCenturyWindow;
  end;

  { TClassesImporter }

  TClassesImporter = class(TClassImporter)
    function ControlChSizing_Control(Instance: Pointer): Variant;
    function ControlChSizing_IsEqual(Instance: TObject; var Params: Variant
      ): Variant;
    function ControlChSizing_SetGridSpacing(Instance: TObject;
      var Params: Variant): Variant;
    function MemoryStream_Clear(Instance: TObject; var Params: Variant
      ): Variant;
    function MemoryStream_LoadFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function MemoryStream_LoadFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function TStrings_ConvertAnsiToUTF8(Instance: TObject; var Params: Variant
      ): Variant;
    function TStrings_ConvertUTF8ToAnsi(Instance: TObject; var Params: Variant
      ): Variant;
    function TWinControl_AddControl(Instance: TObject; var Params: Variant
      ): Variant;
    function TWinControl_ChildSizingGet(Instance: Pointer): Variant;
    procedure TWinControl_ChildSizingSet(Instance: Pointer; AValue: Variant);
    function TWinControl_Focused(Instance: TObject; var Params: Variant
      ): Variant;
    function UnZipper_FileCommentGet(Instance: Pointer): Variant;
    function UnZipper_FileNameGet(Instance: Pointer): Variant;
    procedure UnZipper_FileNameSet(Instance: Pointer; AValue: Variant);
    function UnZipper_OutputPathGet(Instance: Pointer): Variant;
    procedure UnZipper_OutputPathSet(Instance: Pointer; AValue: Variant);
    function ZipFileEntries_AddFileEntries(Instance: TObject;
      var Params: Variant): Variant;
    function ZipFileEntries_AddFileEntry(Instance: TObject; var Params: Variant
      ): Variant;
    function ZipFileEntries_EntriesGet(Instance: TObject; var Params: Variant
      ): Variant;
    function ZipFileEntries_EntriesSet(Instance: TObject; var Params: Variant
      ): Variant;
    function ZipFileEntries_UTF8NameToCP1251(Instance: TObject;
      var Params: Variant): Variant;
    function ZipFileEntries_UTF8NameToCP866(Instance: TObject;
      var Params: Variant): Variant;
    function ZipFileEntry_IsDirectory(Instance: TObject; var Params: Variant
      ): Variant;
    function ZipFileEntry_IsLink(Instance: TObject; var Params: Variant
      ): Variant;
    function GetClipboard(Instance: TObject; var Params: Variant
      ): Variant;
    function Zipper_FileCommentGet(Instance: Pointer): Variant;
    procedure Zipper_FileCommentSet(Instance: Pointer; AValue: Variant);
    function Zipper_FileNameGet(Instance: Pointer): Variant;
    procedure Zipper_FileNameSet(Instance: Pointer; AValue: Variant);

  private
    function Control_BoundsRect_Get(Instance: Pointer): Variant;
    procedure Control_BoundsRect_Set(Instance: Pointer; AValue: Variant);
    function Control_ClientRect_Get(Instance: Pointer): Variant;
    function CustomControlCanvas_Get(Instance: Pointer): Variant;
    function CustomMemoryStream_SaveToFile(Instance: TObject;
      var Params: Variant): Variant;
    function CustomMemoryStream_SaveToStream(Instance: TObject;
      var Params: Variant): Variant;
    function Excep_Create(Instance: TObject; var Params: Variant): Variant;
    function StringStram_Encoding(Instance: Pointer): Variant;
    function StringStram_OwnsEncoding(Instance: Pointer): Variant;
    function StringStream_CreateCodePage(Instance: TObject; var Params: Variant
      ): Variant;
    function StringStream_CreateEncoding(Instance: TObject; var Params: Variant
      ): Variant;
    function TEncoding_ANSI_Get(Instance: Pointer): Variant;
    function TEncoding_ASCII_Get(Instance: Pointer): Variant;
    function TEncoding_BigEndianUnicode_Get(Instance: Pointer): Variant;
    function TEncoding_CodePage_Get(Instance: Pointer): Variant;
    function TEncoding_Default_Get(Instance: Pointer): Variant;
    function TEncoding_EncodingName_Get(Instance: Pointer): Variant;
    function TEncoding_GetEncoding(Instance: TObject; var Params: Variant
      ): Variant;
    function TEncoding_GetEncodingOfName(Instance: TObject; var Params: Variant
      ): Variant;
    function TEncoding_IsSingleByte_Get(Instance: Pointer): Variant;
    function TEncoding_SystemEncoding_Get(Instance: Pointer): Variant;
    function TEncoding_Unicode_Get(Instance: Pointer): Variant;
    function TEncoding_UTF7_Get(Instance: Pointer): Variant;
    function TEncoding_UTF8_Get(Instance: Pointer): Variant;
    function Thread_CurrentThreadGet(Instance: Pointer): Variant;
    function Thread_ExternalThreadGet(Instance: Pointer): Variant;
    function Thread_FinishedGet(Instance: Pointer): Variant;
    function Thread_FreeOnTerminateGet(Instance: Pointer): Variant;
    procedure Thread_FreeOnTerminateSet(Instance: Pointer; AValue: Variant);
    function Thread_HandleGet(Instance: Pointer): Variant;
    function Thread_IsSingleProcessorGet(Instance: Pointer): Variant;
    function Thread_PriorityGet(Instance: Pointer): Variant;
    procedure Thread_PrioritySet(Instance: Pointer; AValue: Variant);
    function Thread_ProcessorCountGet(Instance: Pointer): Variant;
    function Thread_Resume(Instance: TObject; var Params: Variant): Variant;
    function Thread_Start(Instance: TObject; var Params: Variant): Variant;
    function Thread_Suspend(Instance: TObject; var Params: Variant): Variant;
    function Thread_SuspendedGet(Instance: Pointer): Variant;
    procedure Thread_SuspendedSet(Instance: Pointer; AValue: Variant);
    function Thread_Terminate(Instance: TObject; var Params: Variant): Variant;
    function Thread_ThreadIDGet(Instance: Pointer): Variant;
    function Thread_WaitFor(Instance: TObject; var Params: Variant): Variant;
    function TMouse_Capture_get(Instance: Pointer): Variant;
    procedure TMouse_Capture_set(Instance: Pointer; AValue: Variant);
    function TMouse_CursorPos_get(Instance: Pointer): Variant;
    procedure TMouse_CursorPos_set(Instance: Pointer; AValue: Variant);
    function TMouse_DragImmediate_get(Instance: Pointer): Variant;
    procedure TMouse_DragImmediate_set(Instance: Pointer; AValue: Variant);
    function TMouse_DragThreshold_get(Instance: Pointer): Variant;
    procedure TMouse_DragThreshold_set(Instance: Pointer; AValue: Variant);
    function TMouse_IsDragging_get(Instance: Pointer): Variant;
    function TMouse_WheelScrollLines_get(Instance: Pointer): Variant;
    function TStream_ReadAnsiString(Instance: TObject; var Params: Variant
      ): Variant;
    function TStrings_BeginUpdate(Instance: TObject; var Params: Variant
      ): Variant;
    function TStrings_ConvertDosToUTF8(Instance: TObject; var Params: Variant
      ): Variant;
    function TStrings_ConvertUTF8ToDos(Instance: TObject; var Params: Variant
      ): Variant;
    function TStrings_DefaultEncoding_Get(Instance: Pointer): Variant;
    procedure TStrings_DefaultEncoding_Set(Instance: Pointer; AValue: Variant);
    function TStrings_Encoding_Get(Instance: Pointer): Variant;
    function TStrings_EndUpdate(Instance: TObject; var Params: Variant
      ): Variant;
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure AddConsts(AddConst: TAddConstProc); override;
    procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
    procedure AddMethods(AddMethod: TAddMethodProc); override;
    function Create_Object(AClass: TClass): TObject; override;
  published
    {TObject}
    function TObject_Create(Instence: TObject; var Params: Variant): Variant;
    function TObject_Free(Instence: TObject; var Params: Variant): Variant;
    function TObject_Destroy(Instence: TObject; var Params: Variant): Variant;
    function TObject_ClassName(Instance: TObject; var Params: Variant): Variant;
    function TObject_ClassNameIs(Instance: TObject; var Params: Variant): Variant;
    {Exception}
    function Excep_MessageGet(Instance: Pointer): Variant;
    procedure Excep_MessageSet(Instance: Pointer; AValue: Variant);
    {TPersistent}
    function TPersistent_Assign(Instance: TObject; var Params: Variant): Variant;
    function TPersistent_GetNamePath(Instance: TObject; var Params: Variant): Variant;

    {TStream}
    function TStream_Size_Get(Instance: Pointer): Variant;
    procedure TStream_Size_Set(Instance: Pointer; AValue: Variant);
    function TStream_Position_Get(Instance: Pointer): Variant;
    procedure TStream_Position_Set(Instance: Pointer; AValue: Variant);
    function TStream_Seek(Instance: TObject; var Params: Variant): Variant;
    function TStream_Write(Instance: TObject; var Params: Variant): Variant;
    function TStream_Read(Instance: TObject; var Params: Variant): Variant;
    function TStream_CopyFrom(Instance: TObject; var Params: Variant): Variant;
    {THandleStream}
    function HandleStream_Handle(Instance: Pointer): Variant;

    {TFileStream}
    function TFileStream_Create(Instance: TObject; var Params: Variant): Variant;

    {TStringStream}
    function StringStream_Create(Instance: TObject; var Params: Variant): Variant;
    function StringStream_WriteString(Instance: TObject; var Params: Variant): Variant;
    function StringStream_ReadString(Instance: TObject; var Params: Variant): Variant;
    function StringStram_DataString(Instance: Pointer): Variant;

    {TList}
    function TList_Count(Instance: TObject; var Params: Variant): Variant;
    function TList_Add(Instance: TObject; var Params: Variant): Variant;
    function TList_Insert(Instance: TObject; var Params: Variant): Variant;
    function TList_Remove(Instance: TObject; var Params: Variant): Variant;
    function TList_IndexOf(Instance: TObject; var Params: Variant): Variant;
    function TList_Delete(Instance: TObject; var Params: Variant): Variant;
    function TList_Clear(Instance: TObject; var Params: Variant): Variant;
    function TList_Items_Get(Instance: TObject; var Params: Variant): Variant;
    function TList_Items_Set(Instance: TObject; var Params: Variant): Variant;
    {TStrings}
    function TStrings_Count(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Add(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Append(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Insert(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Delete(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Clear(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Strings_Get(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Strings_Set(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Values_Get(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Values_Set(Instance: TObject; var Params: Variant): Variant;
    function TStrings_IndexOf(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Text_Get(Instance: Pointer): Variant;
    procedure TStrings_Text_Set(Instance: Pointer; AValue: Variant);
    function TStrings_AddObject(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Objects_Get(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Objects_Set(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Delimeter_Get(Instance: Pointer): Variant;
    procedure TStrings_Delimeter_Set(Instance: Pointer; AValue: Variant);
    function TStrings_DelimetedText_Get(Instance: Pointer): Variant;
    procedure TStrings_DelimetedText_Set(Instance: Pointer; AValue: Variant);
    function TStrings_SaveToFile(Instance: TObject; var Params: Variant): Variant;
    function TStrings_LoadFromFile(Instance: TObject; var Params: Variant): Variant;
    function TStrings_SaveToStream(Instance: TObject; var Params: Variant): Variant;
    function TStrings_LoadFromStream(Instance: TObject; var Params: Variant): Variant;
    function TStrings_IndexOfName(Instance: TObject; var Params: Variant): Variant;
    function TStrings_IndexOfObject(Instance: TObject; var Params: Variant): Variant;
    function TStrings_InsertObject(Instance: TObject; var Params: Variant): Variant;
    function TStrings_Move(Instance: TObject; var Params: Variant): Variant;
    function TStrings_CommaText_Get(Instance: Pointer): Variant;
    procedure TStrings_CommaText_Set(Instance: Pointer; AValue: Variant);
    function TStrings_Names_Get(Instance: TObject; var Params: Variant): Variant;
    {TStingList}
    function TStringList_Find(Instance: TObject; var Params: Variant): Variant;
    function TStringList_Sort(Instance: TObject; var Params: Variant): Variant;
    function TStingList_Sorted_Get(Instance: Pointer): Variant;
    procedure TStringList_Sorted_Set(Instance: Pointer; AValue: Variant);
    {TCollection}
    function Collection_Clear(Instance: TObject; var Params: Variant): Variant;
    function Collection_Count(Instance: Pointer): Variant;
    function Collection_Owner(Instance: TObject; var Params: Variant): Variant;
    function Collection_Add(Instance: TObject; var Params: Variant): Variant;
    function Collection_Items_Get(Instance: TObject; var Params: Variant): Variant;
    function Collection_Items_Set(Instance: TObject; var Params: Variant): Variant;
    {TCollectionItem}
    function CollectionItem_Create(Instance: TObject; var Params: Variant): Variant;
    function CollectionItem_Collection_Get(Instance: Pointer): Variant;
    procedure CollectionItem_Collection_Set(Instance: Pointer; AValue: Variant);
    function CollectionItem_ID(Instance: Pointer): Variant;
    function CollectionItem_Index(Instance: Pointer): Variant;
    function CollectionItem_DisplayNameGet(Instance: Pointer): Variant;
    procedure CollectionItem_DisplayNameSet(Instance: Pointer; AValue: Variant);
    {TComponent}
    function Component_FindComponent(Instance: TObject; var Params: Variant): Variant;
    function TComponent_Components_Get(Instance: TObject; var Params: Variant): Variant;
    function Component_Create(Instance: TObject; var Params: Variant): Variant;
    function TComponent_OwnerGet(Instance: Pointer): Variant;
    function TComponent_NameGet(Instance: Pointer): Variant;
    procedure TComponent_NameSet(Instance: Pointer; AValue: Variant);
    function TComponent_ComponentCount(Instance: Pointer): Variant;
    function TComponent_ComponentIndex_Get(Instance: Pointer): Variant;
    procedure TComponent_ComponentIndex_Set(Instance: Pointer; AValue: Variant);
    {TControl}
    function Control_Left_Get(Instance: Pointer): Variant;
    procedure Control_Left_Set(Instance: Pointer; AValue: Variant);
    function Control_Width_Get(Instance: Pointer): Variant;
    procedure Control_Width_Set(Instance: Pointer; AValue: Variant);
    function Control_Top_Get(Instance: Pointer): Variant;
    procedure Control_Top_Set(Instance: Pointer; AValue: Variant);
    function Control_Height_Get(Instance: Pointer): Variant;
    procedure Control_Height_Set(Instance: Pointer; AValue: Variant);
    function Control_Parent_Get(Instance: Pointer): Variant;
    procedure Control_Parent_Set(Instance: Pointer; AValue: Variant);
    function Control_ClientWidth_Get(Instance: Pointer): Variant;
    procedure Control_ClientWidth_Set(Instance: Pointer; AValue: Variant);
    function Control_ClientHeight_Get(Instance: Pointer): Variant;
    procedure Control_ClientHeight_Set(Instance: Pointer; AValue: Variant);
    function Control_Hide(Instance: TObject; var Params: Variant): Variant;
    function Control_Show(Instance: TObject; var Params: Variant): Variant;
    function Control_Repaint(Instance: TObject; var Params: Variant): Variant;
    function Control_Refresh(Instance: TObject; var Params: Variant): Variant;
    function Control_Invalidate(Instance: TObject; var Params: Variant): Variant;
    function Control_SetBounds(Instance: TObject; var Params: Variant): Variant;
    function Control_BeginDrag(Instance: TObject; var Params: Variant): Variant;
    function Control_ClientToScreen(Instance: TObject; var Params: Variant): Variant;
    function Control_ScreenToClient(Instance: TObject; var Params: Variant): Variant;
    {TWinControl}
    function TWinControl_SetFocus(Instance: TObject; var Params: Variant): Variant;
    function TWinControl_FindChildControl(Instance: TObject; var Params: Variant): Variant;
    function TWinControl_ControlCount(Instance: Pointer): Variant;
    function TWinControl_Handle(Instance: Pointer): Variant;
    function TWinControl_Controls_Get(Instance: TObject; var Params: Variant): Variant;
    {TDataModule}
    function TDataModule_Create(Instance: TObject; var Params: Variant): Variant;
    {TClipboard}
    function TClipbrd_GetText(Instance: Pointer): Variant;
    procedure TClipbrd_SetText(Instance: Pointer; AValue: Variant);
    {TZipper}
    function Zipper_Clear(Instance: TObject; var Params: Variant): Variant;
    function Zipper_SaveToFile(Instance: TObject; var Params: Variant): Variant;
    function Zipper_SaveToStream(Instance: TObject; var Params: Variant
      ): Variant;
    function Zipper_ZipAllFiles(Instance: TObject; var Params: Variant
      ): Variant;
    function Zipper_ZipFiles(Instance: TObject; var Params: Variant): Variant;
    function Zipper_ZipFilesWithName(Instance: TObject; var Params: Variant
      ): Variant;
    {TUnZipper}
    function UnZipper_Clear(Instance: TObject; var Params: Variant): Variant;
    function UnZipper_Examine(Instance: TObject; var Params: Variant): Variant;
    function UnZipper_UnZipAllFiles(Instance: TObject; var Params: Variant
      ): Variant;
    function UnZipper_UnZipAllFilesWithName(Instance: TObject;
      var Params: Variant): Variant;
    function UnZipper_UnZipFiles(Instance: TObject; var Params: Variant
      ): Variant;
    function UnZipper_UnZipFilesWithName(Instance: TObject; var Params: Variant
      ): Variant;
  end;

implementation

uses Controls, Graphics, dpUtils, dpEvntHadlrs, LCLType, ExtCtrls, GraphMath,
  FileUtil, TextStrings, Dialogs;

type

  { TProgressEventHandler }

  TProgressEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender : TObject; Const Pct : Double);
  end;

  { TOnEndOfFileEventHandler }

  TOnEndOfFileEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender : TObject; Const Ratio : Double);
  end;

  { TOnStartFileEventHandler }

  TOnStartFileEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    Procedure CallHandler(Sender : TObject; Const AFileName : String);
  end;

  { TCustomInputStreamEventHandler }

  TCustomInputStreamEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; var AStream: TStream);
  end;

{ TFormatSet }

constructor TFormatSet.Create;
begin
  inherited Create;
  F := DefaultFormatSettings;
end;

{ TCustomInputStreamEventHandler }

function TCustomInputStreamEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TCustomInputStreamEventHandler.CallHandler;
end;

procedure TCustomInputStreamEventHandler.CallHandler(Sender: TObject;
  var AStream: TStream);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(AStream);
  Proc.Exec;
  AStream := TStream(TSuPtr( Proc.Param[1].Value ));
end;

{ TOnStartFileEventHandler }

function TOnStartFileEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnStartFileEventHandler.CallHandler;
end;

procedure TOnStartFileEventHandler.CallHandler(Sender: TObject;
  const AFileName: String);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := AFileName;
  Proc.Exec;
end;

{ TOnEndOfFileEventHandler }

function TOnEndOfFileEventHandler.GetHandlerAdres: Pointer;
begin
  Result:= @TOnEndOfFileEventHandler.CallHandler;
end;

procedure TOnEndOfFileEventHandler.CallHandler(Sender: TObject;
  const Ratio: Double);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Ratio;
  Proc.Exec;
end;

{ TProgressEventHandler }

function TProgressEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TProgressEventHandler.CallHandler;
end;

procedure TProgressEventHandler.CallHandler(Sender: TObject; const Pct: Double);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Pct;
  Proc.Exec;
end;

//

{TClassesImporter}

procedure TClassesImporter.AddConsts(AddConst: TAddConstProc);
begin
  {From windows.pas}
  AddConst('MB_OK', 'Integer', MB_OK);
  AddConst('MB_OKCANCEL', 'Integer', MB_OKCANCEL);
  AddConst('MB_ABORTRETRYIGNORE', 'Integer', MB_ABORTRETRYIGNORE);
  AddConst('MB_YESNOCANCEL', 'Integer', MB_YESNOCANCEL);
  AddConst('MB_YESNO', 'Integer', MB_YESNO);
  AddConst('MB_RETRYCANCEL', 'Integer', MB_RETRYCANCEL);
  AddConst('MB_ICONHAND', 'Integer', MB_ICONHAND);
  AddConst('MB_ICONQUESTION', 'Integer', MB_ICONQUESTION);
  AddConst('MB_ICONEXCLAMATION', 'Integer', MB_ICONEXCLAMATION);
  AddConst('MB_ICONWARNING', 'Integer', MB_ICONWARNING);
  AddConst('MB_ICONERROR', 'Integer', MB_ICONERROR);
  AddConst('MB_ICONINFORMATION', 'Integer', MB_ICONINFORMATION);
  AddConst('MB_ICONSTOP', 'Integer', MB_ICONSTOP);

  AddConst('IDOK', 'Integer', IDOK);
  AddConst('IDCANCEL', 'Integer', IDCANCEL);
  AddConst('IDABORT', 'Integer', IDABORT);
  AddConst('IDRETRY', 'Integer', IDRETRY);
  AddConst('IDIGNORE', 'Integer', IDIGNORE);
  AddConst('IDYES', 'Integer', IDYES);
  AddConst('IDNO', 'Integer', IDNO);
  AddConst('IDCLOSE', 'Integer', IDCLOSE);
  AddConst('IDHELP', 'Integer', IDHELP);

  AddConst('VK_LBUTTON', 'Integer', VK_LBUTTON);
  AddConst('VK_RBUTTON', 'Integer', VK_RBUTTON);
  AddConst('VK_CANCEL', 'Integer', VK_CANCEL);
  AddConst('VK_MBUTTON', 'Integer', VK_MBUTTON);
  AddConst('VK_XBUTTON1', 'Integer', VK_XBUTTON1);
  AddConst('VK_XBUTTON2', 'Integer', VK_XBUTTON2);
  AddConst('VK_BACK', 'Integer', VK_BACK);
  AddConst('VK_TAB', 'Integer', VK_TAB);
  AddConst('VK_CLEAR', 'Integer', VK_CLEAR);
  AddConst('VK_RETURN', 'Integer', VK_RETURN);
  AddConst('VK_SHIFT', 'Integer', VK_SHIFT);
  AddConst('VK_CONTROL', 'Integer', VK_CONTROL);
  AddConst('VK_MENU', 'Integer', VK_MENU);
  AddConst('VK_PAUSE', 'Integer', VK_PAUSE);
  AddConst('VK_CAPITAL', 'Integer', VK_CAPITAL);
  AddConst('VK_KANA', 'Integer', VK_KANA);
  AddConst('VK_HANGUL', 'Integer', VK_HANGUL);
  AddConst('VK_JUNJA', 'Integer', VK_JUNJA);
  AddConst('VK_FINAL', 'Integer', VK_FINAL);
  AddConst('VK_HANJA', 'Integer', VK_HANJA);
  AddConst('VK_KANJI', 'Integer', VK_KANJI);
  AddConst('VK_CONVERT', 'Integer', VK_CONVERT);
  AddConst('VK_NONCONVERT', 'Integer', VK_NONCONVERT);
  AddConst('VK_ACCEPT', 'Integer', VK_ACCEPT);
  AddConst('VK_MODECHANGE', 'Integer', VK_MODECHANGE);
  AddConst('VK_ESCAPE', 'Integer', VK_ESCAPE);
  AddConst('VK_SPACE', 'Integer', VK_SPACE);
  AddConst('VK_PRIOR', 'Integer', VK_PRIOR);
  AddConst('VK_NEXT', 'Integer', VK_NEXT);
  AddConst('VK_END', 'Integer', VK_END);
  AddConst('VK_HOME', 'Integer', VK_HOME);
  AddConst('VK_LEFT', 'Integer', VK_LEFT);
  AddConst('VK_UP', 'Integer', VK_UP);
  AddConst('VK_RIGHT', 'Integer', VK_RIGHT);
  AddConst('VK_DOWN', 'Integer', VK_DOWN);
  AddConst('VK_SELECT', 'Integer', VK_SELECT);
  AddConst('VK_PRINT', 'Integer', VK_PRINT);
  AddConst('VK_EXECUTE', 'Integer', VK_EXECUTE);
  AddConst('VK_SNAPSHOT', 'Integer', VK_SNAPSHOT);
  AddConst('VK_INSERT', 'Integer', VK_INSERT);
  AddConst('VK_DELETE', 'Integer', VK_DELETE);
  AddConst('VK_HELP', 'Integer', VK_HELP);
  AddConst('VK_LWIN', 'Integer', VK_LWIN);
  AddConst('VK_RWIN', 'Integer', VK_RWIN);
  AddConst('VK_APPS', 'Integer', VK_APPS);
  AddConst('VK_SLEEP', 'Integer', VK_SLEEP);
  AddConst('VK_NUMPAD0', 'Integer', VK_NUMPAD0);
  AddConst('VK_NUMPAD1', 'Integer', VK_NUMPAD1);
  AddConst('VK_NUMPAD2', 'Integer', VK_NUMPAD2);
  AddConst('VK_NUMPAD3', 'Integer', VK_NUMPAD3);
  AddConst('VK_NUMPAD4', 'Integer', VK_NUMPAD4);
  AddConst('VK_NUMPAD5', 'Integer', VK_NUMPAD5);
  AddConst('VK_NUMPAD6', 'Integer', VK_NUMPAD6);
  AddConst('VK_NUMPAD7', 'Integer', VK_NUMPAD7);
  AddConst('VK_NUMPAD8', 'Integer', VK_NUMPAD8);
  AddConst('VK_NUMPAD9', 'Integer', VK_NUMPAD9);
  AddConst('VK_MULTIPLY', 'Integer', VK_MULTIPLY);
  AddConst('VK_ADD', 'Integer', VK_ADD);
  AddConst('VK_SEPARATOR', 'Integer', VK_SEPARATOR);
  AddConst('VK_SUBTRACT', 'Integer', VK_SUBTRACT);
  AddConst('VK_DECIMAL', 'Integer', VK_DECIMAL);
  AddConst('VK_DIVIDE', 'Integer', VK_DIVIDE);
  AddConst('VK_F1', 'Integer', VK_F1);
  AddConst('VK_F2', 'Integer', VK_F2);
  AddConst('VK_F3', 'Integer', VK_F3);
  AddConst('VK_F4', 'Integer', VK_F4);
  AddConst('VK_F5', 'Integer', VK_F5);
  AddConst('VK_F6', 'Integer', VK_F6);
  AddConst('VK_F7', 'Integer', VK_F7);
  AddConst('VK_F8', 'Integer', VK_F8);
  AddConst('VK_F9', 'Integer', VK_F9);
  AddConst('VK_F10', 'Integer', VK_F10);
  AddConst('VK_F11', 'Integer', VK_F11);
  AddConst('VK_F12', 'Integer', VK_F12);
  AddConst('VK_F13', 'Integer', VK_F13);
  AddConst('VK_F14', 'Integer', VK_F14);
  AddConst('VK_F15', 'Integer', VK_F15);
  AddConst('VK_F16', 'Integer', VK_F16);
  AddConst('VK_F17', 'Integer', VK_F17);
  AddConst('VK_F18', 'Integer', VK_F18);
  AddConst('VK_F19', 'Integer', VK_F19);
  AddConst('VK_F20', 'Integer', VK_F20);
  AddConst('VK_F21', 'Integer', VK_F21);
  AddConst('VK_F22', 'Integer', VK_F22);
  AddConst('VK_F23', 'Integer', VK_F23);
  AddConst('VK_F24', 'Integer', VK_F24);
  AddConst('VK_NUMLOCK', 'Integer', VK_NUMLOCK);
  AddConst('VK_SCROLL', 'Integer', VK_SCROLL);
  AddConst('VK_LSHIFT', 'Integer', VK_LSHIFT);
  AddConst('VK_RSHIFT', 'Integer', VK_RSHIFT);
  AddConst('VK_LCONTROL', 'Integer', VK_LCONTROL);
  AddConst('VK_RCONTROL', 'Integer', VK_RCONTROL);
  AddConst('VK_LMENU', 'Integer', VK_LMENU);
  AddConst('VK_RMENU', 'Integer', VK_RMENU);
  AddConst('VK_BROWSER_BACK', 'Integer', VK_BROWSER_BACK);
  AddConst('VK_BROWSER_FORWARD', 'Integer', VK_BROWSER_FORWARD);
  AddConst('VK_BROWSER_REFRESH', 'Integer', VK_BROWSER_REFRESH);
  AddConst('VK_BROWSER_STOP', 'Integer', VK_BROWSER_STOP);
  AddConst('VK_BROWSER_SEARCH', 'Integer', VK_BROWSER_SEARCH);
  AddConst('VK_BROWSER_FAVORITES', 'Integer', VK_BROWSER_FAVORITES);
  AddConst('VK_BROWSER_HOME', 'Integer', VK_BROWSER_HOME);
  AddConst('VK_VOLUME_MUTE', 'Integer', VK_VOLUME_MUTE);
  AddConst('VK_VOLUME_DOWN', 'Integer', VK_VOLUME_DOWN);
  AddConst('VK_VOLUME_UP', 'Integer', VK_VOLUME_UP);
  AddConst('VK_MEDIA_NEXT_TRACK', 'Integer', VK_MEDIA_NEXT_TRACK);
  AddConst('VK_MEDIA_PREV_TRACK', 'Integer', VK_MEDIA_PREV_TRACK);
  AddConst('VK_MEDIA_STOP', 'Integer', VK_MEDIA_STOP);
  AddConst('VK_MEDIA_PLAY_PAUSE', 'Integer', VK_MEDIA_PLAY_PAUSE);
  AddConst('VK_LAUNCH_MAIL', 'Integer', VK_LAUNCH_MAIL);
  AddConst('VK_LAUNCH_MEDIA_SELECT', 'Integer', VK_LAUNCH_MEDIA_SELECT);
  AddConst('VK_LAUNCH_APP1', 'Integer', VK_LAUNCH_APP1);
  AddConst('VK_LAUNCH_APP2', 'Integer', VK_LAUNCH_APP2);
  AddConst('VK_OEM_1', 'Integer', VK_OEM_1);
  AddConst('VK_OEM_PLUS', 'Integer', VK_OEM_PLUS);
  AddConst('VK_OEM_COMMA', 'Integer', VK_OEM_COMMA);
  AddConst('VK_OEM_MINUS', 'Integer', VK_OEM_MINUS);
  AddConst('VK_OEM_PERIOD', 'Integer', VK_OEM_PERIOD);
  AddConst('VK_OEM_2', 'Integer', VK_OEM_2);
  AddConst('VK_OEM_3', 'Integer', VK_OEM_3);
  AddConst('VK_OEM_4', 'Integer', VK_OEM_4);
  AddConst('VK_OEM_5', 'Integer', VK_OEM_5);
  AddConst('VK_OEM_6', 'Integer', VK_OEM_6);
  AddConst('VK_OEM_7', 'Integer', VK_OEM_7);
  AddConst('VK_OEM_8', 'Integer', VK_OEM_8);
  AddConst('VK_OEM_102', 'Integer', VK_OEM_102);
  AddConst('VK_PROCESSKEY', 'Integer', VK_PROCESSKEY);
  AddConst('VK_ATTN', 'Integer', VK_ATTN);
  AddConst('VK_CRSEL', 'Integer', VK_CRSEL);
  AddConst('VK_EXSEL', 'Integer', VK_EXSEL);
  AddConst('VK_EREOF', 'Integer', VK_EREOF);
  AddConst('VK_PLAY', 'Integer', VK_PLAY);
  AddConst('VK_ZOOM', 'Integer', VK_ZOOM);
  AddConst('VK_NONAME', 'Integer', VK_NONAME);
  AddConst('VK_PA1', 'Integer', VK_PA1);
  AddConst('VK_OEM_CLEAR', 'Integer', VK_OEM_CLEAR);
  AddConst('VK_A', 'Integer', VK_A);
  AddConst('VK_B', 'Integer', VK_B);
  AddConst('VK_C', 'Integer', VK_C);
  AddConst('VK_D', 'Integer', VK_D);
  AddConst('VK_E', 'Integer', VK_E);
  AddConst('VK_F', 'Integer', VK_F);
  AddConst('VK_G', 'Integer', VK_G);
  AddConst('VK_H', 'Integer', VK_H);
  AddConst('VK_I', 'Integer', VK_I);
  AddConst('VK_J', 'Integer', VK_J);
  AddConst('VK_K', 'Integer', VK_K);
  AddConst('VK_L', 'Integer', VK_L);
  AddConst('VK_M', 'Integer', VK_M);
  AddConst('VK_N', 'Integer', VK_N);
  AddConst('VK_O', 'Integer', VK_O);
  AddConst('VK_P', 'Integer', VK_P);
  AddConst('VK_Q', 'Integer', VK_Q);
  AddConst('VK_R', 'Integer', VK_R);
  AddConst('VK_S', 'Integer', VK_S);
  AddConst('VK_T', 'Integer', VK_T);
  AddConst('VK_U', 'Integer', VK_U);
  AddConst('VK_V', 'Integer', VK_V);
  AddConst('VK_W', 'Integer', VK_W);
  AddConst('VK_X', 'Integer', VK_X);
  AddConst('VK_Y', 'Integer', VK_Y);
  AddConst('VK_Z', 'Integer', VK_Z);

  AddConst('OS_FAT', 'Integer', 0);
  AddConst('OS_UNIX', 'Integer', 3);
end;

procedure TClassesImporter.AddSimpleTypes(AddType: TAddSimpleTypeProc);
begin
  AddType('TThreadID', btInt);
end;

procedure TClassesImporter.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TNotifyEvent), TSuNotifyHandler);
  RegisterHandler(TypeInfo(TKeyEvent), TSuKeyEventHandler);
  RegisterHandler(TypeInfo(TKeyPressEvent), TSuKeyPressHandler);
  RegisterHandler(TypeInfo(TUTF8KeyPressEvent), TUTF8KeyPressHandler);
  RegisterHandler(TypeInfo(TMouseEvent), TSuMouseHandler);
  RegisterHandler(TypeInfo(TMouseMoveEvent), TSuMouseMoveHandler);
  RegisterHandler(TypeInfo(TDragDropEvent), TDragDropHandler);
  RegisterHandler(TypeInfo(TDragOverEvent), TDragOverHandler);
  RegisterHandler(TypeInfo(TStartDragEvent), TStartDragHandler);
  RegisterHandler(TypeInfo(TEndDragEvent), TEndDragHandler);
  RegisterHandler(TypeInfo(TDockDropEvent), TDockDropHandler);
  RegisterHandler(TypeInfo(TDockOverEvent), TDockOverHandler);
  RegisterHandler(TypeInfo(TUnDockEvent), TUnDockHandler);
  RegisterHandler(TypeInfo(TStartDockEvent), TStartDockHandler);
  RegisterHandler(TypeInfo(TGetSiteInfoEvent), TGetSiteInfoHandler);
  RegisterHandler(TypeInfo(TCanResizeEvent), TCanResizeHandler);
  RegisterHandler(TypeInfo(TConstrainedResizeEvent), TConstrainedResizeHandler);
  RegisterHandler(TypeInfo(TMouseWheelEvent), TMouseWheelHandler);
  RegisterHandler(TypeInfo(TMouseWheelUpDownEvent), TMouseWheelUpDownHandler);
  RegisterHandler(TypeInfo(TContextPopupEvent), TContextPopupHandler);
  RegisterHandler(TypeInfo(TAlignInsertBeforeEvent), TAlignInsertBeforeHandler);
  {Zipper}
  RegisterHandler(TypeInfo(TProgressEvent), TProgressEventHandler);
  RegisterHandler(TypeInfo(TOnEndOfFileEvent), TOnEndOfFileEventHandler);
  RegisterHandler(TypeInfo(TOnStartFileEvent), TOnStartFileEventHandler);
  RegisterHandler(TypeInfo(TCustomInputStreamEvent), TCustomInputStreamEventHandler);
end;

procedure TClassesImporter.AddMethods(AddMethod: TAddMethodProc);
begin
  AddMethod('function Clipboard: TClipboard', @GetClipboard);
  AddMethod('function БуферОбмена: TClipboard', @GetClipboard);
end;

function TClassesImporter.Create_Object(AClass: TClass): TObject;
begin
  Result := nil;
  if AClass = TStream then Result := TStream.Create
  else
  if AClass = TMemoryStream then Result := TMemoryStream.Create
  else
  if AClass = TList then Result := TList.Create
  else
  if AClass = TxZipper then Result := TxZipper.Create
  else
  if AClass = TxUnZipper then Result := TxUnZipper.Create
  else
  if AClass = TStringList then Result := TStringList.Create
  else
  if AClass = TFormatSet then
  begin
    Result := TFormatSet.Create;
  end;
end;

function TClassesImporter.ControlChSizing_Control(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TControlChildSizing(Instance).Control );
end;

function TClassesImporter.ControlChSizing_IsEqual(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TControlChildSizing(Instance).IsEqual(TControlChildSizing( TSuPtr(Params[0]) ));
end;

function TClassesImporter.ControlChSizing_SetGridSpacing(Instance: TObject;
  var Params: Variant): Variant;
begin
  TControlChildSizing(Instance).SetGridSpacing(Params[0]);
end;

function TClassesImporter.MemoryStream_Clear(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMemoryStream(Instance).Clear;
end;

function TClassesImporter.MemoryStream_LoadFromFile(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TMemoryStream(Instance).LoadFromFile(S);
end;

function TClassesImporter.MemoryStream_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMemoryStream(Instance).LoadFromStream(TStream(TSuPtr(Params[0])));
end;

function TClassesImporter.TStrings_ConvertAnsiToUTF8(Instance: TObject;
  var Params: Variant): Variant;
begin
  TStrings(Instance).Text := dp_AnsiToUTF8(TStrings(Instance).Text);
end;

function TClassesImporter.TStrings_ConvertUTF8ToAnsi(Instance: TObject;
  var Params: Variant): Variant;
begin
  TStrings(Instance).Text:= dp_UTF8ToAnsi(TStrings(Instance).Text);
end;

function TClassesImporter.TWinControl_AddControl(Instance: TObject;
  var Params: Variant): Variant;
var
  AControl: TControl;
  AType: TDpType;
  WControl: TWinControl;
  AOwner: TComponent;
  PR: PRect;
begin
  WControl := TWinControl(Instance);
  if WControl is TCustomForm then AOwner := WControl
  else AOwner := WControl.Owner;

  AType := Compiler.FindType(Params[0], nil, True);
  AControl := TControlClass(AType.ValueClassType).Create(AOwner);
  AControl.Name:= Params[1];
  PR := PRect( TSuPtr(Params[2]) );
  AControl.BoundsRect := PR^;
  AControl.Parent := WControl;
  Result := TSuPtr(AControl);
end;

function TClassesImporter.TWinControl_ChildSizingGet(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( TWinControl(Instance).ChildSizing );
end;

procedure TClassesImporter.TWinControl_ChildSizingSet(Instance: Pointer;
  AValue: Variant);
begin
  TWinControl(Instance).ChildSizing := TControlChildSizing( TSuPtr( AValue ) );
end;

function TClassesImporter.TWinControl_Focused(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TWinControl(Instance).Focused;
end;

function TClassesImporter.UnZipper_FileCommentGet(Instance: Pointer): Variant;
begin
  Result := TUnZipper(Instance).FileComment;
end;

function TClassesImporter.UnZipper_FileNameGet(Instance: Pointer): Variant;
begin
  Result := TUnZipper(Instance).FileName;
end;

procedure TClassesImporter.UnZipper_FileNameSet(Instance: Pointer;
  AValue: Variant);
var
  S: string;
begin
  S := AValue;
  TUnZipper(Instance).FileName := S;
end;

function TClassesImporter.UnZipper_OutputPathGet(Instance: Pointer): Variant;
begin
  Result := TUnZipper(Instance).OutputPath;
end;

procedure TClassesImporter.UnZipper_OutputPathSet(Instance: Pointer;
  AValue: Variant);
var
   S: string;
begin
  S := AValue;
  TUnZipper(Instance).OutputPath := S;
end;

function TClassesImporter.ZipFileEntries_AddFileEntries(Instance: TObject;
  var Params: Variant): Variant;
begin
  TZipFileEntries(Instance).AddFileEntries(TStrings(TSuPtr(Params[0])));
end;

function TClassesImporter.ZipFileEntries_AddFileEntry(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];

  if S2 = '' then
    Result := TSuPtr(TZipFileEntries(Instance).AddFileEntry(S1))
  else
  begin
    Result := TSuPtr(TZipFileEntries(Instance).AddFileEntry(S1, S2));
  end;
end;

function TClassesImporter.ZipFileEntries_EntriesGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TZipFileEntries(Instance).Entries[Params[0]] );
end;

function TClassesImporter.ZipFileEntries_EntriesSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TZipFileEntries(Instance).Entries[Params[0]] := TZipFileEntry(TSuPtr(Params[1]));
end;

function TClassesImporter.ZipFileEntries_UTF8NameToCP1251(Instance: TObject;
  var Params: Variant): Variant;
var
  I: Integer;
  FE: TZipFileEntry;
  Entries: TZipFileEntries;
begin
  Entries := TZipFileEntries(Instance);
  for I := 0 to Entries.Count - 1 do
  begin
    FE := Entries.Entries[I];
    FE.ArchiveFileName := dp_UTF8ToAnsi(FE.ArchiveFileName);
  end;
end;

function ZipUnixAttrsToFatAttrs(const Name: String; Attrs: Longint): Longint;

const
  OS_FAT = 0;
  OS_UNIX = 3;

  UNIX_MASK = $F000;
  UNIX_FIFO = $1000;
  UNIX_CHAR = $2000;
  UNIX_DIR  = $4000;
  UNIX_BLK  = $6000;
  UNIX_FILE = $8000;
  UNIX_LINK = $A000;
  UNIX_SOCK = $C000;


  UNIX_RUSR = $0100;
  UNIX_WUSR = $0080;
  UNIX_XUSR = $0040;

  UNIX_RGRP = $0020;
  UNIX_WGRP = $0010;
  UNIX_XGRP = $0008;

  UNIX_ROTH = $0004;
  UNIX_WOTH = $0002;
  UNIX_XOTH = $0001;

  UNIX_DEFAULT = UNIX_RUSR or UNIX_WUSR or UNIX_XUSR or UNIX_RGRP or UNIX_ROTH;

begin
  Result := faArchive;

  if (Pos('.', Name) = 1) and (Name <> '.') and (Name <> '..') then
    Result := Result + faHidden;
  case (Attrs and UNIX_MASK) of
    UNIX_DIR:  Result := Result + faDirectory;
    UNIX_LINK: Result := Result + faSymLink;
    UNIX_FIFO, UNIX_CHAR, UNIX_BLK, UNIX_SOCK:
               Result := Result + faSysFile;
  end;

  if (Attrs and UNIX_WUSR) = 0 then
    Result := Result + faReadOnly;
end;

function TClassesImporter.ZipFileEntries_UTF8NameToCP866(Instance: TObject;
  var Params: Variant): Variant;
var
  I: Integer;
  FE: TZipFileEntry;
  Entries: TZipFileEntries;
begin
  Entries := TZipFileEntries(Instance);
  for I := 0 to Entries.Count - 1 do
  begin
    FE := Entries.Entries[I];
    FE.ArchiveFileName := dp_UTF8ToDOSCP(FE.ArchiveFileName);
  end;
end;

function TClassesImporter.ZipFileEntry_IsDirectory(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TZipFileEntry(Instance).IsDirectory;
end;

function TClassesImporter.ZipFileEntry_IsLink(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TZipFileEntry(Instance).IsLink;
end;

function TClassesImporter.GetClipboard(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(Clipboard);
end;

function TClassesImporter.Zipper_FileCommentGet(Instance: Pointer): Variant;
begin
  Result := TZipper(Instance).FileComment;
end;

procedure TClassesImporter.Zipper_FileCommentSet(Instance: Pointer;
  AValue: Variant);
var
  S: string;
begin
  S := AValue;
  TZipper(Instance).FileComment := S;
end;

function TClassesImporter.Zipper_FileNameGet(Instance: Pointer): Variant;
begin
  Result := TZipper(Instance).FileName;
end;

procedure TClassesImporter.Zipper_FileNameSet(Instance: Pointer; AValue: Variant
  );
var
  S: string;
begin
  S := AValue;
  TZipper(Instance).FileName := S;
end;

function TClassesImporter.Control_BoundsRect_Get(Instance: Pointer): Variant;
begin
  Compiler.RetRect := TControl(Instance).BoundsRect;
  Result := TSuPtr(PRect(@Compiler.RetRect));
end;

procedure TClassesImporter.Control_BoundsRect_Set(Instance: Pointer;
  AValue: Variant);
begin
  TControl(Instance).BoundsRect := PRect(TSuPtr(AValue))^;
end;

function TClassesImporter.Control_ClientRect_Get(Instance: Pointer): Variant;
begin
  Compiler.RetRect := TControl(Instance).ClientRect;
  Result := TSuPtr(PRect(@Compiler.RetRect));
end;

function TClassesImporter.CustomControlCanvas_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TCustomControl(Instance).Canvas );
end;

function TClassesImporter.CustomMemoryStream_SaveToFile(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TCustomMemoryStream(Instance).SaveToFile(S);
end;

function TClassesImporter.CustomMemoryStream_SaveToStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomMemoryStream(Instance).SaveToStream(TStream(TSuPtr(Params[0])));
end;

function TClassesImporter.Excep_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( Exception.Create(Params[0]));
end;

function TClassesImporter.StringStram_Encoding(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TStringStream(Instance).Encoding );
end;

function TClassesImporter.StringStram_OwnsEncoding(Instance: Pointer): Variant;
begin
  Result := TStringStream(Instance).OwnsEncoding;
end;

function TClassesImporter.StringStream_CreateCodePage(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
  ACodePage: Integer;
begin
  S := Params[0];
  ACodePage:= Params[1];
  Result := TSuPtr( TStringStream.Create(S, ACodePage) );
end;

function TClassesImporter.StringStream_CreateEncoding(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
  AEncoding: TEncoding;
  AOwnsEncoding: Boolean;
begin
  S := Params[0];
  AEncoding := TEncoding(TSuPtr(Params[1]));
  AOwnsEncoding:= Params[2];
  Result := TSuPtr( TStringStream.Create(S, AEncoding, AOwnsEncoding) );
end;

function TClassesImporter.TEncoding_ANSI_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TEncoding(Instance).ANSI );
end;

function TClassesImporter.TEncoding_ASCII_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TEncoding(Instance).ASCII );
end;

function TClassesImporter.TEncoding_BigEndianUnicode_Get(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( TEncoding(Instance).BigEndianUnicode );
end;

function TClassesImporter.TEncoding_CodePage_Get(Instance: Pointer): Variant;
begin
  Result := TEncoding(Instance).CodePage;
end;

function TClassesImporter.TEncoding_Default_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TEncoding(Instance).Default );
end;

function TClassesImporter.TEncoding_EncodingName_Get(Instance: Pointer
  ): Variant;
begin
  Result := TEncoding(Instance).EncodingName;
end;

function TClassesImporter.TEncoding_GetEncoding(Instance: TObject;
  var Params: Variant): Variant;
var
  ACodePage: Integer;
begin
  ACodePage := Params[0];
  Result := TSuPtr( TEncoding(Instance).GetEncoding(ACodePage) );
end;

function TClassesImporter.TEncoding_GetEncodingOfName(Instance: TObject;
  var Params: Variant): Variant;
var
  S: UnicodeString;
begin
  S := Params[0];
  Result := TSuPtr( TEncoding(Instance).GetEncoding(S) );
end;

function TClassesImporter.TEncoding_IsSingleByte_Get(Instance: Pointer
  ): Variant;
begin
  Result := TEncoding(Instance).IsSingleByte;
end;

function TClassesImporter.TEncoding_SystemEncoding_Get(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( TEncoding(Instance).SystemEncoding );
end;

function TClassesImporter.TEncoding_Unicode_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TEncoding(Instance).Unicode );
end;

function TClassesImporter.TEncoding_UTF7_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TEncoding(Instance).UTF7 );
end;

function TClassesImporter.TEncoding_UTF8_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TEncoding(Instance).UTF8 );
end;

function TClassesImporter.Thread_CurrentThreadGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TThread(Instance).CurrentThread );
end;

function TClassesImporter.Thread_ExternalThreadGet(Instance: Pointer): Variant;
begin
  Result := TThread(Instance).ExternalThread;
end;

function TClassesImporter.Thread_FinishedGet(Instance: Pointer): Variant;
begin
  Result := TThread(Instance).Finished;
end;

function TClassesImporter.Thread_FreeOnTerminateGet(Instance: Pointer): Variant;
begin
  Result := TThread(Instance).FreeOnTerminate;
end;

procedure TClassesImporter.Thread_FreeOnTerminateSet(Instance: Pointer;
  AValue: Variant);
begin
  TThread(Instance).FreeOnTerminate := AValue;
end;

function TClassesImporter.Thread_HandleGet(Instance: Pointer): Variant;
begin
  Result := TThread(Instance).Handle;
end;

function TClassesImporter.Thread_IsSingleProcessorGet(Instance: Pointer
  ): Variant;
begin
  Result := TThread(Instance).IsSingleProcessor;
end;

function TClassesImporter.Thread_PriorityGet(Instance: Pointer): Variant;
begin
  Result := TThread(Instance).Priority;
end;

procedure TClassesImporter.Thread_PrioritySet(Instance: Pointer; AValue: Variant
  );
begin
  TThread(Instance).Priority := AValue;
end;

function TClassesImporter.Thread_ProcessorCountGet(Instance: Pointer): Variant;
begin
  Result := TThread(Instance).ProcessorCount;
end;

function TClassesImporter.Thread_Resume(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TThread(Instance).Resume;
end;

function TClassesImporter.Thread_Start(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TThread(Instance).Start;
end;

function TClassesImporter.Thread_Suspend(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TThread(Instance).Suspend;
end;

function TClassesImporter.Thread_SuspendedGet(Instance: Pointer): Variant;
begin
  Result := TThread(Instance).Suspended;
end;

procedure TClassesImporter.Thread_SuspendedSet(Instance: Pointer;
  AValue: Variant);
begin
  TThread(Instance).Suspended := AValue;
end;

function TClassesImporter.Thread_Terminate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TThread(Instance).Terminate;
end;

function TClassesImporter.Thread_ThreadIDGet(Instance: Pointer): Variant;
begin
  Result := TThread(Instance).ThreadID;
end;

function TClassesImporter.Thread_WaitFor(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TThread(Instance).WaitFor;
end;

function TClassesImporter.TMouse_Capture_get(Instance: Pointer): Variant;
begin
  Result := TMouse(Instance).Capture;
end;

procedure TClassesImporter.TMouse_Capture_set(Instance: Pointer; AValue: Variant
  );
var
  H: HWND;
begin
  H := THandle(PtrUInt(AValue));
  TMouse(Instance).Capture := H;
end;

var
  MCursPos: TPoint;

function TClassesImporter.TMouse_CursorPos_get(Instance: Pointer): Variant;
begin
  MCursPos := TMouse(Instance).CursorPos;
  Result := TSuPtr(@MCursPos);
end;

procedure TClassesImporter.TMouse_CursorPos_set(Instance: Pointer;
  AValue: Variant);
var
  P: PPoint;
begin
  P := PPoint(TSuPtr(AValue));
  TMouse(Instance).CursorPos := P^;
end;

function TClassesImporter.TMouse_DragImmediate_get(Instance: Pointer): Variant;
begin
  Result := TMouse(Instance).DragImmediate;
end;

procedure TClassesImporter.TMouse_DragImmediate_set(Instance: Pointer;
  AValue: Variant);
begin
  TMouse(Instance).DragImmediate := AValue;
end;

function TClassesImporter.TMouse_DragThreshold_get(Instance: Pointer): Variant;
begin
  Result := TMouse(Instance).DragThreshold;
end;

procedure TClassesImporter.TMouse_DragThreshold_set(Instance: Pointer;
  AValue: Variant);
begin
  TMouse(Instance).DragThreshold := AValue;
end;

function TClassesImporter.TMouse_IsDragging_get(Instance: Pointer): Variant;
begin
  Result := TMouse(Instance).IsDragging;
end;

function TClassesImporter.TMouse_WheelScrollLines_get(Instance: Pointer
  ): Variant;
begin
  Result := TMouse(Instance).WheelScrollLines;
end;

function TClassesImporter.TStream_ReadAnsiString(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TStream(Instance).ReadAnsiString;
end;

function TClassesImporter.TStrings_BeginUpdate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TStrings(Instance).BeginUpdate;
end;

function TClassesImporter.TStrings_ConvertDosToUTF8(Instance: TObject;
  var Params: Variant): Variant;
begin
  TStrings(Instance).Text := dp_DOSCPToUTF8(TStrings(Instance).Text);
end;

function TClassesImporter.TStrings_ConvertUTF8ToDos(Instance: TObject;
  var Params: Variant): Variant;
begin
  TStrings(Instance).Text  := dp_UTF8ToDOSCP(TStrings(Instance).Text);
end;

function TClassesImporter.TStrings_DefaultEncoding_Get(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( TStrings(Instance).DefaultEncoding );
end;

procedure TClassesImporter.TStrings_DefaultEncoding_Set(Instance: Pointer;
  AValue: Variant);
begin
  TStrings(Instance).DefaultEncoding := TEncoding( TSuPtr(AValue) );
end;

function TClassesImporter.TStrings_Encoding_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TStrings(Instance).Encoding );
end;

function TClassesImporter.TStrings_EndUpdate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TStrings(Instance).EndUpdate;
end;

procedure TClassesImporter.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TShiftState));
  AddType(TypeInfo(TMouseButton));

  AddType(TypeInfo(TAlign));
  AddType(TypeInfo(TAlignSet));

  AddType(TypeInfo(TAnchorKind));
  AddType(TypeInfo(TAnchors));

  AddType(TypeInfo(TAlignment));
  AddType(TypeInfo(TVerticalAlignment));

  AddType(TypeInfo(TDragState));
  AddType(TypeInfo(TDragMode));
  AddType(TypeInfo(TDragKind));

  AddType(TypeInfo(TBevelCut));
  AddType(TypeInfo(TSeekOrigin));


  AddType(TypeInfo(TControlChildrenLayout));
  AddType(TypeInfo(TChildControlResizeStyle));

  AddType(TypeInfo(TFormBorderStyle));
  AddType(TypeInfo(TBorderStyle));
  AddType(TypeInfo(TControlRoleForForm));
  AddType(TypeInfo(TControlRolesForForm));
  //AddType(TypeInfo(TBevelCut));

  AddType(TypeInfo(TThreadPriority));
end;

procedure TClassesImporter.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
begin
  AddClass(TObject, 'ТОбъект').ClassImporter := Self;
  AddClass(Exception, 'Исключение').ClassImporter := Self;
  AddClass(TPersistent, 'ТПостоянный').ClassImporter := Self;
  AddClass(TStream, 'ТПоток').ClassImporter := Self;
  AddClass(THandleStream).ClassImporter := Self;
  AddClass(TCustomMemoryStream).ClassImporter := Self;
  AddClass(TMemoryStream, 'ТПотокПамяти').ClassImporter := Self;
  AddClass(TFileStream, 'ТПотокФайла').ClassImporter := Self;
  AddClass(TStringStream, 'ТПотокСтроки').ClassImporter := Self;
  AddClass(TList, 'ТСписок').ClassImporter := Self;
  AddClass(TEncoding).ClassImporter := Self;
  AddClass(TStrings, 'ТСтроки').ClassImporter := Self;
  AddClass(TStringList, 'ТСписокСтрок').ClassImporter := Self;
  AddClass(TCollection, 'ТКоллекция').ClassImporter := Self;
  AddClass(TCollectionItem, 'ТЭлементКоллекции').ClassImporter := Self;
  AddClass(TComponent, 'ТКомпонент').ClassImporter := Self;
  AddClass(TDataModule, 'ТМодульДанных').ClassImporter := Self;
  AddClass(TControl, 'ТЭлементУправления').ClassImporter := Self;
  AddClass(TControlChildSizing).ClassImporter := Self;
  AddClass(TWinControl, 'ТОконЭлементУправления').ClassImporter := Self;
  AddClass(TCustomControl).ClassImporter := Self;
  AddClass(TClipboard).ClassImporter := Self;
  AddClass(TZipFileEntries).ClassImporter := Self;
  AddClass(TZipFileEntry).ClassImporter := Self;
  AddClass(TZipper).ClassImporter := Self;
  AddClass(TFullZipFileEntries).ClassImporter := Self;
  AddClass(TUnZipper).ClassImporter := Self;
  AddClass(TxZipper).ClassImporter := Self;
  AddClass(TxUnZipper).ClassImporter := Self;
  AddClass(TMouse).ClassImporter := Self;
  AddClass(TThread, 'ТНить').ClassImporter := Self;
  AddClass(TFormatSet, 'ТНастройкиФормата').ClassImporter := Self;
end;

procedure TClassesImporter.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TObject then
  begin
    AType.AddMethod('constructor Create', @TObject_Create);
    AType.AddMethod('конструктор Создать', @TObject_Create);
    AType.AddMethod('procedure Free', @TObject_Free);
    AType.AddMethod('процедура Освободить', @TObject_Free);
    AType.AddMethod('destructor Destroy', @TObject_Destroy);
    AType.AddMethod('деструктор Разрушить', @TObject_Destroy);
    AType.AddMethod('function ClassName: String', @TObject_ClassName);
    AType.AddMethod('функция ИмяКласса: строка', @TObject_ClassName);
    AType.AddMethod('function ClassNameIs(AName: string): Boolean', @TObject_ClassNameIs);
    AType.AddMethod('функция ИмяКлассаЕсть(ЭИмя: строка): Логическое', @TObject_ClassNameIs);
  end
  else
  if AType.ValueClassType = Exception then
  begin
    AType.AddMethod('constructor Create(const msg : string)', @Excep_Create);
    AType.AddProp('Message', 'string', @Excep_MessageGet, @Excep_MessageSet);
    AType.AddProp('Сообщение', 'строка', @Excep_MessageGet, @Excep_MessageSet);
  end
  else
  if AType.ValueClassType = TPersistent then
  begin
    AType.AddMethod('procedure Assign(Source: TPersistent)', @TPersistent_Assign);
    AType.AddMethod('процедура Присвоить(Источник: ТПостоянный)', @TPersistent_Assign);
    AType.AddMethod('function GetNamePath: string', @TPersistent_GetNamePath);
  end
  else
  if AType.ValueClassType = TStream then
  begin
    AType.AddProp('Size', 'Int64', @TStream_Size_Get, @TStream_Size_Set);
    AType.AddMethod('function Seek(Offset: Integer; Origin: Word): Integer', @TStream_Seek);
    AType.AddMethod('function Write(var Buffer: Pointer; Count: Integer): Integer', @TStream_Write);
    AType.AddMethod('function Read(var Buffer: Pointer; Count: Integer): Integer', @TStream_Read);
    AType.AddMethod('function CopyFrom(Source: TStream; Count: Int64): Int64', @TStream_CopyFrom);
    AType.AddMethod('function ReadAnsiString : String', @TStream_ReadAnsiString);
    AType.AddProp('Position', 'Integer', @TStream_Position_Get, @TStream_Position_Set);
  end
  else
  if AType.ValueClassType = THandleStream then
  begin
    AType.AddProp('Handle', 'THandle', @HandleStream_Handle);
  end
  else
  if AType.ValueClassType = TCustomMemoryStream then
  begin
    AType.AddMethod('procedure SaveToStream(Stream: TStream)', @CustomMemoryStream_SaveToStream);
    AType.AddMethod('procedure SaveToFile(const FileName: string)', @CustomMemoryStream_SaveToFile);
  end
  else
  if AType.ValueClassType = TMemoryStream then
  begin
    AType.AddMethod('procedure Clear', @MemoryStream_Clear);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @MemoryStream_LoadFromStream);
    AType.AddMethod('procedure LoadFromFile(const FileName: string)', @MemoryStream_LoadFromFile);
  end
  else
  if AType.ValueClassType = TFileStream then
  begin
    AType.AddMethod('constructor Create(FileName: string; Mode: Word)', @TFileStream_Create);
  end
  else
  if AType.ValueClassType = TStringStream then
  begin
    AType.AddMethod('constructor Create(const AString: string)', @StringStream_Create);
    AType.AddMethod('constructor CreateEncoding(const AString: string; AEncoding: TEncoding; AOwnsEncoding: Boolean = True)', @StringStream_CreateEncoding);
    AType.AddMethod('constructor CreateCodePage(const AString: string; ACodePage: Integer)', @StringStream_CreateCodePage);
    AType.AddMethod('procedure WriteString(const AString: string)', @StringStream_WriteString);
    AType.AddMethod('function ReadString(Count: Longint): string', @StringStream_ReadString);
    AType.AddProp('DataString', 'string', @StringStram_DataString);
    AType.AddProp('Encoding', 'TEncoding', @StringStram_Encoding);
    AType.AddProp('OwnsEncoding', 'Boolean', @StringStram_OwnsEncoding);
  end
  else
  if AType.ValueClassType = TList then
  begin
    AType.AddMethod('function Count: Integer', @TList_Count);
    AType.AddMethod('function Add(P: Pointer): Integer', @TList_Add);
    AType.AddMethod('procedure Insert(Index: Integer; Item: Pointer)', @TList_Insert);
    AType.AddMethod('procedure Delete(Index: Integer)', @TList_Delete);
    AType.AddMethod('function Remove(Item: Pointer): Integer', @TList_Remove);
    AType.AddMethod('function IndexOf(Item: Pointer): Integer', @TList_IndexOf);
    AType.AddMethod('procedure Clear', @TList_Clear);
    AType.AddIndexedProp('Items', 'Pointer', 'Integer', @TList_Items_Get, @TList_Items_Set);
  end
  else
  if AType.ValueClassType = TEncoding then
  begin
    AType.AddProp('CodePage', 'Cardinal', @TEncoding_CodePage_Get);
    AType.AddProp('EncodingName', 'string', @TEncoding_EncodingName_Get);
    AType.AddProp('IsSingleByte', 'Boolean', @TEncoding_IsSingleByte_Get);
    AType.AddProp('ANSI', 'TEncoding', @TEncoding_ANSI_Get);
    AType.AddProp('ASCII', 'TEncoding', @TEncoding_ASCII_Get);
    AType.AddProp('BigEndianUnicode', 'TEncoding', @TEncoding_BigEndianUnicode_Get);
    AType.AddProp('Default', 'TEncoding', @TEncoding_Default_Get);
    AType.AddProp('SystemEncoding', 'TEncoding', @TEncoding_SystemEncoding_Get);
    AType.AddProp('Unicode', 'TEncoding', @TEncoding_Unicode_Get);
    AType.AddProp('UTF7', 'TEncoding', @TEncoding_UTF7_Get);
    AType.AddProp('UTF8', 'TEncoding', @TEncoding_UTF8_Get);
    AType.AddMethod('function GetEncoding(CodePage: Integer): TEncoding', @TEncoding_GetEncoding);
    AType.AddMethod('function GetEncodingOfName(const EncodingName: string): TEncoding', @TEncoding_GetEncodingOfName);
  end
  else
  if AType.ValueClassType = TStrings then
  begin
    AType.AddProp('Text', 'string', @TStrings_Text_Get, @TStrings_Text_Set);
    AType.AddProp('Текст', 'строка', @TStrings_Text_Get, @TStrings_Text_Set);
    AType.AddMethod('function Count: Integer', @TStrings_Count);
    AType.AddMethod('функция Количество: Целое', @TStrings_Count);
    AType.AddMethod('function Add(S: string): Integer', @TStrings_Add);
    AType.AddMethod('функция Добавить(Стр: строка): Целое', @TStrings_Add);
    AType.AddMethod('procedure Append(S: string)', @TStrings_Append);
    AType.AddMethod('процедура Прибавить(Стр: строка)', @TStrings_Append);
    AType.AddMethod('procedure Insert(Index: Integer; S: string)', @TStrings_Insert);
    AType.AddMethod('procedure Delete(Index: Integer)', @TStrings_Delete);
    AType.AddMethod('procedure Clear', @TStrings_Clear);
    AType.AddMethod('procedure Очистить', @TStrings_Clear);
    AType.AddIndexedProp('Strings', 'string', 'Integer', @TStrings_Strings_Get, @TStrings_Strings_Set);
    AType.AddIndexedProp('Строки', 'строка', 'целое', @TStrings_Strings_Get, @TStrings_Strings_Set);
    AType.AddIndexedProp('Values', 'string', 'string', @TStrings_Values_Get, @TStrings_Values_Set);
    AType.AddIndexedProp('Значения', 'строка', 'строка', @TStrings_Values_Get, @TStrings_Values_Set);
    AType.AddMethod('function IndexOf(S: string): Integer', @TStrings_IndexOf);
    AType.AddMethod('function AddObject(S: string; AObject: TObject): Integer', @TStrings_AddObject);
    AType.AddIndexedProp('Objects', 'TObject', 'Integer', @TStrings_Objects_Get, @TStrings_Objects_Set);
    AType.AddProp('Delimeter', 'Char', @TStrings_Delimeter_Get, @TStrings_Delimeter_Set);
    AType.AddProp('DelimetedText', 'String', @TStrings_DelimetedText_Get, @TStrings_DelimetedText_Set);
    AType.AddMethod('procedure SaveToFile(FileName: string)', @TStrings_SaveToFile);
    AType.AddMethod('procedure LoadFromFile(FileName: string)', @TStrings_LoadFromFile);
    AType.AddMethod('procedure SaveToStream(Stream: TStream)', @TStrings_SaveToStream);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @TStrings_LoadFromStream);
    AType.AddMethod('function IndexOfName(const Name: string): Integer', @TStrings_IndexOfName);
    AType.AddMethod('function IndexOfObject(AObject: TObject): Integer', @TStrings_IndexOfObject);
    AType.AddMethod('procedure InsertObject(Index: Integer; const S: string; AObject: TObject)', @TStrings_InsertObject);
    AType.AddMethod('procedure Move(CurIndex, NewIndex: Integer)', @TStrings_Move);
    AType.AddMethod('procedure ConvertAnsiToUTF8', @TStrings_ConvertAnsiToUTF8);
    AType.AddMethod('procedure ConvertUTF8ToAnsi', @TStrings_ConvertUTF8ToAnsi);
    AType.AddMethod('procedure ConvertUTF8ToDosCp', @TStrings_ConvertUTF8ToDos);
    AType.AddMethod('procedure ConvertDosCpToUTF8', @TStrings_ConvertDosToUTF8);
    AType.AddMethod('procedure BeginUpdate', @TStrings_BeginUpdate);
    AType.AddMethod('procedure EndUpdate', @TStrings_EndUpdate);
    AType.AddProp('CommaText', 'String', @TStrings_CommaText_Get, @TStrings_CommaText_Set);
    AType.AddProp('Encoding', 'TEncoding', @TStrings_Encoding_Get);
    AType.AddProp('DefaultEncoding', 'TEncoding', @TStrings_DefaultEncoding_Get, @TStrings_DefaultEncoding_Set);
    AType.AddIndexedProp('Names', 'string', 'Integer', @TStrings_Names_Get, nil);
  end
  else
  if AType.ValueClassType = TStringList then
  begin
    AType.AddMethod('function Find(const S: string; var Index: Integer): Boolean', @TStringList_Find);
    AType.AddMethod('procedure Sort', @TStringList_Sort);
    AType.AddProp('Sorted', 'Boolean', @TStingList_Sorted_Get, @TStringList_Sorted_Set);
  end
  else
  if AType.ValueClassType = TCollection then
  begin
    AType.AddMethod('procedure Clear', @Collection_Clear);
    AType.AddProp('Count', 'Integer', @Collection_Count, nil);
    AType.AddMethod('function Owner: TPersistent', @Collection_Owner);
    AType.AddMethod('function Add: TCollectionItem', @Collection_Add);
    AType.AddIndexedProp('Items', 'TCollectionItem', 'Integer', @Collection_Items_Get, @Collection_Items_Set);
  end
  else
  if AType.ValueClassType = TCollectionItem then
  begin
    AType.AddMethod('constructor Create(Collection: TCollection)', @CollectionItem_Create);
    AType.AddProp('Collection', 'TCollection', @CollectionItem_Collection_Get, @CollectionItem_Collection_Set);
    AType.AddProp('ID', 'Integer', @CollectionItem_ID);
    AType.AddProp('Index', 'Integer', @CollectionItem_Index);
    AType.AddProp('DisplayName', 'string', @CollectionItem_DisplayNameGet, @CollectionItem_DisplayNameSet);
  end
  else
  if AType.ValueClassType = TComponent then
  begin
    AType.AddMethod('function FindComponent(ComponentName: string): TComponent', @Component_FindComponent);
    AType.AddMethod('функция НайтиКомпонент(ИмяКомпонента: строка): ТКомпонент', @Component_FindComponent);
    AType.AddMethod('constructor Create(AOwner: TComponent)', @Component_Create);
    AType.AddMethod('конструктор Создать(АВладелец: ТКомпонент)', @Component_Create);
    AType.AddProp('Owner', 'TComponent', @TComponent_OwnerGet, nil);
    AType.AddProp('Владелец', 'ТКомпонент', @TComponent_OwnerGet, nil);
    AType.AddProp('ComponentCount', 'Integer', @TComponent_ComponentCount, nil);
    AType.AddProp('КоличествоКомпонент', 'Целое', @TComponent_ComponentCount, nil);
    AType.AddProp('ComponentIndex', 'Integer', @TComponent_ComponentIndex_Get, @TComponent_ComponentIndex_Set);
    AType.AddProp('ИнедекКомпонента', 'Целое', @TComponent_ComponentIndex_Get, @TComponent_ComponentIndex_Set);
    AType.AddIndexedProp('Components', 'TComponent', 'Integer', @TComponent_Components_Get, nil);
    AType.AddIndexedProp('Компоненты', 'ТКомпонент', 'Целое', @TComponent_Components_Get, nil);
  end
  else
  if AType.ValueClassType = TControl then
  begin
    AType.AddProp('Parent', 'TWinControl', @Control_Parent_Get, @Control_Parent_Set);
    AType.AddProp('ClientWidth', 'Integer', @Control_ClientWidth_Get, @Control_ClientWidth_Set);
    AType.AddProp('ClientHeight', 'Integer', @Control_ClientHeight_Get, @Control_ClientHeight_Set);
    AType.AddProp('BoundsRect', 'TRect', @Control_BoundsRect_Get, @Control_BoundsRect_Set);
    AType.AddProp('ClientRect', 'TRect', @Control_ClientRect_Get);
    AType.AddMethod('procedure Hide', @Control_Hide);
    AType.AddMethod('procedure Show', @Control_Show);
    AType.AddMethod('procedure Repaint', @Control_Repaint);
    AType.AddMethod('procedure Refresh', @Control_Refresh);
    AType.AddMethod('procedure Invalidate', @Control_Invalidate);
    AType.AddMethod('procedure BeginDrag(Immediate: Boolean; Threshold: Integer)', @Control_BeginDrag);
    AType.AddMethod('procedure SetBounds(ALeft, ATop, ARight, ABottom: Integer)', @Control_SetBounds);
    AType.AddMethod('function ClientToScreen(const Point: TPoint): TPoint', @Control_ClientToScreen);
    AType.AddMethod('function ScreenToClient(const Point: TPoint): TPoint', @Control_ScreenToClient);
  end
  else
  if AType.ValueClassType = TWinControl then
  begin
    AType.AddMethod('procedure SetFocus', @TWinControl_SetFocus);
    AType.AddMethod('function Focused: Boolean', @TWinControl_Focused);
    AType.AddMethod('function FindChildControl(const ControlName: string): TControl', @TWinControl_FindChildControl);
    AType.AddMethod('function AddControl(AClass, AName: string; Bounds: TRect): TControl', @TWinControl_AddControl);
    AType.AddProp('ControlCount', 'Integer', @TWinControl_ControlCount, nil);
    AType.AddProp('Handle', 'Integer', @TWinControl_Handle, nil);
    AType.AddIndexedProp('Controls', 'TControl', 'Integer', @TWinControl_Controls_Get, nil);
  end
  else
  if AType.ValueClassType = TCustomControl then
  begin
    AType.AddProp('Canvas', 'TCanvas', @CustomControlCanvas_Get);
  end
  else
  if AType.ValueClassType = TDataModule then
  begin
    AType.AddMethod('constructor Create(AOwner: TComponent)', @TDataModule_Create);
    AType.AddMethod('Конструктор Создать(АВладелец: ТКомпонент)', @TDataModule_Create);
  end
  else
  if AType.ValueClassType = TClipboard then
  begin
    AType.AddProp('AsText', 'String', @TClipbrd_GetText, @TClipbrd_SetText);
    AType.AddProp('КакТекст', 'строка', @TClipbrd_GetText, @TClipbrd_SetText);
  end
  else
  if AType.ValueClassType = TZipper then
  begin

    AType.AddMethod('procedure ZipAllFiles', @Zipper_ZipAllFiles);
    AType.AddMethod('procedure SaveToFile(AFileName: string', @Zipper_SaveToFile);
    AType.AddMethod('procedure SaveToStream(AStream: TStream)', @Zipper_SaveToStream);
    AType.AddMethod('procedure ZipFilesWithName(AFileName : String; FileList : TStrings)', @Zipper_ZipFilesWithName);
    AType.AddMethod('procedure ZipFiles(FileList : TStrings)', @Zipper_ZipFiles);
    AType.AddMethod('procedure Clear', @Zipper_Clear);
    AType.AddProp('FileName', 'string', @Zipper_FileNameGet, @Zipper_FileNameSet);
    AType.AddProp('FileComment', 'string', @Zipper_FileCommentGet, @Zipper_FileCommentSet);
  end
  else
  if AType.ValueClassType = TUnZipper then
  begin
    AType.AddMethod('procedure UnZipAllFiles', @UnZipper_UnZipAllFiles);
    AType.AddMethod('procedure UnZipFilesWithName(AFileName: String; FileList : TStrings)', @UnZipper_UnZipFilesWithName);
    AType.AddMethod('procedure UnZipFiles(FileList: TStrings)', @UnZipper_UnZipFiles);
    AType.AddMethod('procedure UnZipAllFilesWithName(AFileName: String)', @UnZipper_UnZipAllFilesWithName);
    AType.AddMethod('procedure Clear', @UnZipper_Clear);
    AType.AddMethod('procedure Examine', @UnZipper_Examine);
    AType.AddProp('OutputPath', 'string', @UnZipper_OutputPathGet, @UnZipper_OutputPathSet);
    AType.AddProp('FileName', 'string', @UnZipper_FileNameGet, @UnZipper_FileNameSet);
    AType.AddProp('FileComment', 'string', @UnZipper_FileCommentGet);
  end
  else
  if AType.ValueClassType = TZipFileEntries then
  begin
    AType.AddMethod('function AddFileEntry(Const ADiskFileName: String; AArchiveFileName: String = ''''): TZipFileEntry', @ZipFileEntries_AddFileEntry);
    AType.AddMethod('procedure AddFileEntries(Const List : TStrings)', @ZipFileEntries_AddFileEntries);
    AType.AddMethod('procedure UTF8NamesToCP1251', @ZipFileEntries_UTF8NameToCP1251);
    AType.AddMethod('procedure UTF8NamesToCP866', @ZipFileEntries_UTF8NameToCP866);
    AType.AddIndexedProp('Entries', 'TZipFileEntry', 'Integer', @ZipFileEntries_EntriesGet, @ZipFileEntries_EntriesSet);

  end
  else
  if AType.ValueClassType = TZipFileEntry then
  begin
    AType.AddMethod('function IsDirectory: Boolean', @ZipFileEntry_IsDirectory);
    AType.AddMethod('function IsLink: Boolean', @ZipFileEntry_IsLink);
  end
  else
  if AType.ValueClassType = TControlChildSizing then
  begin
    AType.AddMethod('function IsEqual(Sizing: TControlChildSizing): boolean', @ControlChSizing_IsEqual);
    AType.AddMethod('procedure SetGridSpacing(Spacing: integer)', @ControlChSizing_SetGridSpacing);
    AType.AddProp('Control', 'TWinControl', @ControlChSizing_Control);
  end
  else
  if AType.ValueClassType = TThread then
  begin
    AType.AddMethod('procedure Start', @Thread_Start);
    AType.AddMethod('procedure Resume', @Thread_Resume);
    AType.AddMethod('procedure Suspend', @Thread_Suspend);
    AType.AddMethod('procedure Terminate', @Thread_Terminate);
    AType.AddMethod('function WaitFor: Integer', @Thread_WaitFor);
    AType.AddProp('CurrentThread', 'TThread', @Thread_CurrentThreadGet);
    AType.AddProp('ProcessorCount', 'LongWord', @Thread_ProcessorCountGet);
    AType.AddProp('IsSingleProcessor', 'Boolean', @Thread_IsSingleProcessorGet);
    AType.AddProp('FreeOnTerminate', 'Boolean', @Thread_FreeOnTerminateGet, @Thread_FreeOnTerminateSet);
    AType.AddProp('Handle', 'TThreadID', @Thread_HandleGet);
    AType.AddProp('ExternalThread', 'Boolean', @Thread_ExternalThreadGet);
    AType.AddProp('Priority', 'TThreadPriority', @Thread_PriorityGet, @Thread_PrioritySet);
    AType.AddProp('Suspended', 'Boolean', @Thread_SuspendedGet, @Thread_SuspendedSet);
    AType.AddProp('Finished', 'Boolean', @Thread_FinishedGet);
    AType.AddProp('ThreadID', 'TThreadID', @Thread_ThreadIDGet);
  end
  else
  if AType.ValueClassType = TMouse then
  begin
    AType.AddProp('Capture', 'HWND', @TMouse_Capture_get, @TMouse_Capture_set);
    AType.AddProp('CursorPos', 'TPoint', @TMouse_CursorPos_get, @TMouse_CursorPos_set);
    AType.AddProp('IsDragging', 'Boolean', @TMouse_IsDragging_get);
    AType.AddProp('WheelScrollLines', 'Integer', @TMouse_WheelScrollLines_get);
    AType.AddProp('DragImmediate', 'Boolean', @TMouse_DragImmediate_get, @TMouse_DragImmediate_set);
    AType.AddProp('DragThreshold', 'Integer', @TMouse_DragThreshold_get, @TMouse_DragThreshold_set);
  end
  else
  if AType.ValueClassType = TFormatSet then
  begin
    //AType.AddMethod();
  end;
end;

function TClassesImporter.TObject_Create(Instence: TObject;
      var Params: Variant): Variant;
var
  AClass: TClass;
  NonPersClass: TPersistentClass;
  AType, AClassType: TDpType;
  Obj: TObject;
  s: string;
begin
  AType := TDpType(TSuPtr(Params[0]));
  AClass := AType.ValueClassType;

  //AClassType := Compiler.FindType(AClass.ClassName, nil, False);
  //if (AClassType <> nil) and (AClassType <> AType) then AType := AClassType;

  if AClass = TObject then
    Obj := TObject.Create
  else
  if AClass = TStringList then
    Obj := TStringList.Create
  else
  if AType.ClassImporter <> nil then
    Obj := AType.ClassImporter.Create_Object(AClass);

  if Obj = nil then Obj := AClass.Create;
  Result := TSuPtr(Obj);
end;

function TClassesImporter.TObject_Free(Instence: TObject;
      var Params: Variant): Variant;
begin
  Compiler.DeleteObjectData(Instence);
  Instence.Free;
end;

function TClassesImporter.TObject_Destroy(Instence: TObject;
      var Params: Variant): Variant;
begin

end;

function TClassesImporter.TObject_ClassName(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := Instance.ClassName;
end;

function TClassesImporter.TObject_ClassNameIs(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := Instance.ClassNameIs(Params[0]);
end;

{Exception}

function TClassesImporter.Excep_MessageGet(Instance: Pointer): Variant;
begin
  Result := Exception(Instance).Message
end;

procedure TClassesImporter.Excep_MessageSet(Instance: Pointer; AValue: Variant);
begin
  Exception(Instance).Message := AValue
end;

{TPersistent}

function TClassesImporter.TPersistent_Assign(Instance: TObject;
      var Params: Variant): Variant;
begin
  TPersistent(Instance).Assign(TPersistent(TSuPtr(Params[0])));
end;

function TClassesImporter.TPersistent_GetNamePath(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TPersistent(Instance).GetNamePath;
end;

{TStream}

function TClassesImporter.TStream_Size_Get(Instance: Pointer): Variant;
begin
  Result := TStream(Instance).Size;
end;

procedure TClassesImporter.TStream_Size_Set(Instance: Pointer; AValue: Variant);
begin
  TStream(Instance).Size := AValue;
end;

function TClassesImporter.TStream_Position_Get(Instance: Pointer): Variant;
begin
   Result := TStream(Instance).Position;
end;

procedure TClassesImporter.TStream_Position_Set(Instance: Pointer; AValue: Variant);
begin
  TStream(Instance).Position := AValue;
end;

function TClassesImporter.TStream_Seek(Instance: TObject;
    var Params: Variant): Variant;
begin
  Result := TStream(Instance).Seek(Params[0], Params[1]);
end;

function TClassesImporter.TStream_Write(Instance: TObject;
    var Params: Variant): Variant;
var
  S: AnsiString;
  V: Variant;
  I: Integer;
  SI: SmallInt;
  SHI: ShortInt;
  B: Byte;
  Bool: Boolean;
  Dbl: Double;
begin
  V := Params[0];
  case TVarData(V).VType of
    varSmallint:
    begin
      SI := TVarData(V).VSmallInt;
      Result := TStream(Instance).Write(SI, SizeOf(SmallInt));
    end;
    varInteger:
    begin
      I := TVarData(V).VInteger;
      Result := TStream(Instance).Write(I, SizeOf(Integer));
    end;
    varShortInt:
    begin
      SHI := TVArDAta(V).VShortInt;
      Result := TStream(Instance).Write(SHI, SizeOf(ShortInt));
    end;
    varByte:
    begin
      B := TVArDAta(V).VByte;
      Result := TStream(Instance).Write(B, SizeOf(Byte));
    end;
    varBoolean:
    begin
      Bool := TVarData(V).VBoolean;
      Result := TStream(Instance).Write(Bool, SizeOf(Boolean));
    end;
    varDouble:
    begin
      Dbl := TVarData(V).VDouble;
      Result := TStream(Instance).Write(Dbl, SizeOf(Double));
    end;
    varString, varOleStr:
    begin
      S := AnsiString(V);
      if S <> '' then
        Result := TStream(Instance).Write(S[1], Params[1]);
    end;
  end;
end;

function TClassesImporter.TStream_Read(Instance: TObject;
    var Params: Variant): Variant;
var
  S: AnsiString;
  V: Variant;
  I: Integer;
  SI: SmallInt;
  SHI: ShortInt;
  B: Byte;
  Bool: Boolean;
  Dbl: Double;
begin
  Result := 0;
  V := Params[0];
  case TVarData(V).VType of
    varSmallint:
    begin
      SI := TVarData(V).VSmallInt;
      Result := TStream(Instance).Read(SI, SizeOf(SmallInt));
      Params[0] := SI;
    end;
    varInteger:
    begin
      I := TVarData(V).VInteger;
      Result := TStream(Instance).Read(I, SizeOf(Integer));
      Params[0] := I;
    end;
    varShortInt:
    begin
      SHI := TVArDAta(V).VShortInt;
      Result := TStream(Instance).Read(SHI, SizeOf(ShortInt));
      Params[0] := SHI;
    end;
    varByte:
    begin
      B := TVArDAta(V).VByte;
      Result := TStream(Instance).Read(B, SizeOf(Byte));
      Params[0] := B;
    end;
    varBoolean:
    begin
      Bool := TVarData(V).VBoolean;
      Result := TStream(Instance).Read(Bool, SizeOf(Boolean));
      Params[0] := Bool;
    end;
    varDouble:
    begin
      Dbl := TVarData(V).VDouble;
      Result := TStream(Instance).Read(Dbl, SizeOf(Double));
      Params[0] := Dbl;
    end;
    varString, varOleStr:
    begin
      I := Params[1];
      if I > 0 then
      begin
        SetLength(S, I);
        Result := TStream(Instance).Read(S[1], I);
        Params[0] := S;
      end;
    end;
  end;
end;

function TClassesImporter.TStream_CopyFrom(Instance: TObject; var Params: Variant): Variant;
begin
  Result := TStream(Instance).CopyFrom(TSTream(TSuPtr(Params[0])), Params[1])
end;

function TClassesImporter.HandleStream_Handle(Instance: Pointer): Variant;
begin
  Result := THandleStream(Instance).Handle;
end;

{TFileStream}

function TClassesImporter.TFileStream_Create(Instance: TObject;
      var Params: Variant): Variant;
var
  S: string;
  F: TFileStream;
begin
  S := Params[0];
  F := TFileStream.Create(S, Params[1]);
  Result := TSuPtr(F);
end;

function TClassesImporter.StringStream_Create(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TSuPtr(TStringStream.Create(S));
end;

function TClassesImporter.StringStream_WriteString(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TStringStream(Instance).WriteString(S);
end;

function TClassesImporter.StringStream_ReadString(Instance: TObject;
  var Params: Variant): Variant;
var
  L: LongInt;
begin
  L := Params[0];
  Result := TStringStream(Instance).ReadString(L);
end;

function TClassesImporter.StringStram_DataString(Instance: Pointer): Variant;
begin
  Result := TStringStream(Instance).DataString;
end;

{TList}
function TClassesImporter.TList_Count(Instance: TObject;
    var Params: Variant): Variant;
begin
  Result := TList(Instance).Count;
end;

function TClassesImporter.TList_Add(Instance: TObject;
    var Params: Variant): Variant;
var
  IO: TIdentObject;
  Obj: TObject;
  P: Pointer;
begin
  Obj := TObject( (TSuPtr(Params[0])) );
  P := Obj;
  if Obj is TIdentObject then
  begin
    IO := TIdentObject(Obj);
    P := Pointer( TSuPtr(IO.Value) );
  end;
  Result := TList(Instance).Add(P);
end;

function TClassesImporter.TList_Insert(Instance: TObject;
  var Params: Variant): Variant;
var
  IO: TIdentObject;
  Obj: TObject;
  P: Pointer;
begin
  Obj := TObject( (TSuPtr(Params[0])) );
  P := Obj;
  if Obj is TIdentObject then
  begin
    IO := TIdentObject(Obj);
    P := Pointer( TSuPtr(IO.Value) );
  end;
  TList(Instance).Insert(Params[0], P);
end;

function TClassesImporter.TList_Remove(Instance: TObject;
  var Params: Variant): Variant;
var
  IO: TIdentObject;
  Obj: TObject;
  P: Pointer;
begin
  Obj := TObject( (TSuPtr(Params[0])) );
  P := Obj;
  if Obj is TIdentObject then
  begin
    IO := TIdentObject(Obj);
    P := Pointer( TSuPtr(IO.Value) );
  end;
  Result := TList(Instance).Remove(P);
end;

function TClassesImporter.TList_IndexOf(Instance: TObject;
  var Params: Variant): Variant;
var
  IO: TIdentObject;
  Obj: TObject;
  P: Pointer;
begin
  Obj := TObject( (TSuPtr(Params[0])) );
  P := Obj;
  if Obj is TIdentObject then
  begin
    IO := TIdentObject(Obj);
    P := Pointer( TSuPtr(IO.Value) );
  end;
  Result := TList(Instance).IndexOf(P);
end;

function TClassesImporter.TList_Delete(Instance: TObject;
    var Params: Variant): Variant;
begin
  TList(Instance).Delete(Params[0]);
end;

function TClassesImporter.TList_Clear(Instance: TObject;
    var Params: Variant): Variant;
begin
  TList(Instance).Clear;
end;

function TClassesImporter.TList_Items_Get(Instance: TObject;
    var Params: Variant): Variant;
begin
  Result := TSuPtr(TList(Instance).Items[Params[0]]);
end;

function TClassesImporter.TList_Items_Set(Instance: TObject;
    var Params: Variant): Variant;
var
  IO: TIdentObject;
  Obj: TObject;
  P: Pointer;
begin
  Obj := TObject( (TSuPtr(Params[1])) );
  P := Obj;
  if Obj is TIdentObject then
  begin
    IO := TIdentObject(Obj);
    P := Pointer( TSuPtr(IO.Value) );
  end;
  TList(Instance).Items[Params[0]] := P;
end;

{TStrings}

function TClassesImporter.TStrings_Count(Instance: TObject;
    var Params: Variant): Variant;
begin
  Result := TStrings(Instance).Count;
end;

function TClassesImporter.TStrings_Add(Instance: TObject;
    var Params: Variant): Variant;
begin
  Result := TStrings(Instance).Add(Params[0]);
end;

function TClassesImporter.TStrings_Append(Instance: TObject;
    var Params: Variant): Variant;
begin
  TStrings(Instance).Append(Params[0]);
end;

function TClassesImporter.TStrings_Insert(Instance: TObject;
    var Params: Variant): Variant;
begin
  TStrings(Instance).Insert(Params[0], Params[1]);
end;

function TClassesImporter.TStrings_Delete(Instance: TObject;
    var Params: Variant): Variant;
begin
  TStrings(Instance).Delete(Params[0]);
end;

function TClassesImporter.TStrings_Clear(Instance: TObject;
    var Params: Variant): Variant;
begin
  TStrings(Instance).Clear;
end;

function TClassesImporter.TStrings_Strings_Get(Instance: TObject;
    var Params: Variant): Variant;
begin
  Result := TStrings(Instance).Strings[Params[0]];
end;

function TClassesImporter.TStrings_Strings_Set(Instance: TObject;
    var Params: Variant): Variant;
begin
  TStrings(Instance).Strings[Params[0]] := Params[1];
end;

function TClassesImporter.TStrings_Values_Get(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TStrings(Instance).Values[Params[0]];
end;

function TClassesImporter.TStrings_Values_Set(Instance: TObject;
  var Params: Variant): Variant;
begin
  TStrings(Instance).Values[Params[0]] := Params[1];
end;

function TClassesImporter.TStrings_IndexOf(Instance: TObject;
    var Params: Variant): Variant;
begin
  Result := TStrings(Instance).IndexOf(Params[0]);
end;

function TClassesImporter.TStrings_Text_Get(Instance: Pointer): Variant;
begin
  Result := TStrings(Instance).Text;
end;

procedure TClassesImporter.TStrings_Text_Set(Instance: Pointer; AValue: Variant);
begin
  TStrings(Instance).Text := AValue;
end;

function TClassesImporter.TStrings_AddObject(Instance: TObject;
    var Params: Variant): Variant;
begin
  TStrings(Instance).AddObject(Params[0], TObject(TSuPtr(Params[1])));
end;

function TClassesImporter.TStrings_Objects_Get(Instance: TObject;
    var Params: Variant): Variant;
begin
  Result := TSuPtr(TStrings(Instance).Objects[Params[0]])
end;

function TClassesImporter.TStrings_Objects_Set(Instance: TObject;
    var Params: Variant): Variant;
begin
  TStrings(Instance).Objects[Params[0]] := TObject(TSuPtr(Params[1]));
end;

function TClassesImporter.TStrings_Delimeter_Get(Instance: Pointer): Variant;
begin
  Result := TStrings(Instance).Delimiter;
end;

procedure TClassesImporter.TStrings_Delimeter_Set(Instance: Pointer; AValue: Variant);
var
  S: string;
  C: Char;
begin
  S := AValue;
  C := #0;
  if Length(S) > 0 then C := S[1];

  TStrings(Instance).Delimiter := C;
end;

function TClassesImporter.TStrings_DelimetedText_Get(Instance: Pointer): Variant;
begin
  Result := TStrings(Instance).DelimitedText;
end;

procedure TClassesImporter.TStrings_DelimetedText_Set(Instance: Pointer; AValue: Variant);
begin
  TStrings(Instance).DelimitedText := AValue;
end;

function TClassesImporter.TStrings_SaveToFile(Instance: TObject;
    var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TStrings(Instance).SaveToFile(S);
end;

function TClassesImporter.TStrings_LoadFromFile(Instance: TObject;
    var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  if Instance is TTextStrings then
    TTextStrings(Instance).LoadFromFile(S)
  else
    TStrings(Instance).LoadFromFile(S);
end;

function TClassesImporter.TStrings_SaveToStream(Instance: TObject;
    var Params: Variant): Variant;
var
  S: TStream;
begin
  S := TStream(TSuPtr(Params[0]));
  TStrings(Instance).SaveToStream(S);
end;

function TClassesImporter.TStrings_LoadFromStream(Instance: TObject;
    var Params: Variant): Variant;
var
  S: TStream;
  DStr: string;
begin
  S := TStream(TSuPtr(Params[0]));
  TStrings(Instance).LoadFromStream(S);
end;

function TClassesImporter.TStrings_IndexOfName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TStrings(Instance).IndexOfName(Params[0])
end;

function TClassesImporter.TStrings_IndexOfObject(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TStrings(Instance).IndexOfObject(TObject(TSuPtr(Params[0])))
end;

function TClassesImporter.TStrings_InsertObject(Instance: TObject;
  var Params: Variant): Variant;
begin
  TStrings(Instance).InsertObject(Params[0], Params[1], TObject(TSuPtr(Params[2])));
end;

function TClassesImporter.TStrings_Move(Instance: TObject;
  var Params: Variant): Variant;
begin
  TStrings(Instance).Move(Params[0], Params[1]);
end;

function TClassesImporter.TStrings_CommaText_Get(Instance: Pointer): Variant;
begin
  Result := TStrings(Instance).CommaText;
end;

procedure TClassesImporter.TStrings_CommaText_Set(Instance: Pointer; AValue: Variant);
begin
  TStrings(Instance).CommaText := AValue;
end;

function TClassesImporter.TStrings_Names_Get(Instance: TObject; var Params: Variant): Variant;
begin
  Result := TStrings(Instance).Names[Params[0]]
end;

{TStingList}
function TClassesImporter.TStringList_Find(Instance: TObject;
  var Params: Variant): Variant;
var
  I: Integer;
begin
  I := Params[1];
  Result := TStringList(Instance).Find(Params[0], I);
  Params[1] := I;
end;

function TClassesImporter.TStringList_Sort(Instance: TObject;
  var Params: Variant): Variant;
begin
  TStringList(Instance).Sort;
end;

function TClassesImporter.TStingList_Sorted_Get(Instance: Pointer): Variant;
begin
  Result := TStringList(Instance).Sorted;
end;

procedure TClassesImporter.TStringList_Sorted_Set(Instance: Pointer; AValue: Variant);
begin
  TStringList(Instance).Sorted := AValue;
end;

{TCollection}

function TClassesImporter.Collection_Clear(Instance: TObject;
    var Params: Variant): Variant;
begin
  TCollection(Instance).Clear;
end;

function TClassesImporter.Collection_Count(Instance: Pointer): Variant;
begin
  Result := TCollection(Instance).Count;
end;

function TClassesImporter.Collection_Owner(Instance: TObject;
    var Params: Variant): Variant;
begin
  Result := TSuPtr(TCollection(Instance).Owner);
end;

function TClassesImporter.Collection_Add(Instance: TObject;
    var Params: Variant): Variant;
begin
  Result := TSuPtr(TCollection(Instance).Add);
end;

function TClassesImporter.Collection_Items_Get(Instance: TObject;
    var Params: Variant): Variant;
begin
  Result := TSuPtr(TCollection(Instance).Items[Params[0]]);
end;

function TClassesImporter.Collection_Items_Set(Instance: TObject;
    var Params: Variant): Variant;
begin
  TCollection(Instance).Items[Params[0]] := TCollectionItem(TSuPtr(Params[1]));
end;

{TCollectionItem}

function TClassesImporter.CollectionItem_Create(Instance: TObject; var Params: Variant): Variant;
var
  CC: TCollectionItemClass;
  AType: TDpType;
begin
  AType := TDpType(TSuPtr(Params[1]));
  CC := TCollectionItemClass(AType.ValueClassType);
  Result := TSuPtr(CC.Create(TCollection(TSuPtr(Params[0]))));
end;

function TClassesImporter.CollectionItem_Collection_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TCollectionItem(Instance).Collection);
end;

procedure TClassesImporter.CollectionItem_Collection_Set(Instance: Pointer; AValue: Variant);
begin
  TCollectionItem(Instance).Collection := TCollection(TSuPtr(AValue));
end;

function TClassesImporter.CollectionItem_ID(Instance: Pointer): Variant;
begin
  Result := TCollectionItem(Instance).ID;
end;

function TClassesImporter.CollectionItem_Index(Instance: Pointer): Variant;
begin
  Result := TCollectionItem(Instance).Index;
end;

function TClassesImporter.CollectionItem_DisplayNameGet(Instance: Pointer
  ): Variant;
begin
  Result := TCollectionItem(Instance).DisplayName;
end;

procedure TClassesImporter.CollectionItem_DisplayNameSet(Instance: Pointer;
  AValue: Variant);
begin
  TCollectionItem(Instance).DisplayName := AValue;
end;

{TComponent}

function TClassesImporter.Component_FindComponent(Instance: TObject;
    var Params: Variant): Variant;
var
  C: TComponent;
  I: Integer;
  AName: string;
begin
  Result := 0;
  C := TComponent(Instance);
  AName := Params[0];
  for I := 0 to C.ComponentCount - 1 do
  begin
    if AnsiCompareText(AName, C.Components[I].Name) = 0 then
    begin
      Result := TSuPtr(C.Components[I]);
      Break;
    end;
  end;
end;

function TClassesImporter.TComponent_Components_Get(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TComponent(Instance).Components[Params[0]]);
end;

function TClassesImporter.Component_Create(Instance: TObject;
    var Params: Variant): Variant;
var
  AType: TDpType;
  CompClass: TComponentClass;
begin
  AType := TDpType(TSuPtr(Params[1]));
  CompClass := TComponentClass(AType.ValueClassType);
  Result := TSuPtr(CompClass.Create(TComponent(TSuPtr(Params[0]))));
end;

function TClassesImporter.TComponent_OwnerGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TComponent(Instance).Owner);
end;

function TClassesImporter.TComponent_NameGet(Instance: Pointer): Variant;
begin
  Result := TComponent(Instance).Name;
end;

procedure TClassesImporter.TComponent_NameSet(Instance: Pointer; AValue: Variant);
begin
  TComponent(Instance).Name := AValue;
end;

function TClassesImporter.TComponent_ComponentCount(Instance: Pointer): Variant;
begin
  Result := TComponent(Instance).ComponentCount;
end;

function TClassesImporter.TComponent_ComponentIndex_Get(Instance: Pointer): Variant;
begin
  Result := TComponent(Instance).ComponentIndex;
end;

procedure TClassesImporter.TComponent_ComponentIndex_Set(Instance: Pointer; AValue: Variant);
begin
  TComponent(Instance).ComponentIndex := AValue;
end;

{TControl}

function TClassesImporter.Control_Left_Get(Instance: Pointer): Variant;
begin
  Result := TControl(Instance).Left;
end;

procedure TClassesImporter.Control_Left_Set(Instance: Pointer; AValue: Variant);
begin
  TControl(Instance).Left := AValue;
end;

function TClassesImporter.Control_Width_Get(Instance: Pointer): Variant;
begin
  Result := TControl(Instance).Width;
end;

procedure TClassesImporter.Control_Width_Set(Instance: Pointer; AValue: Variant);
begin
  TControl(Instance).Width := AValue;
end;

function TClassesImporter.Control_Top_Get(Instance: Pointer): Variant;
begin
  Result := TControl(Instance).Top
end;

procedure TClassesImporter.Control_Top_Set(Instance: Pointer; AValue: Variant);
begin
  TControl(Instance).Top := AValue;
end;

function TClassesImporter.Control_Height_Get(Instance: Pointer): Variant;
begin
  Result := TControl(Instance).Height;
end;

procedure TClassesImporter.Control_Height_Set(Instance: Pointer; AValue: Variant);
begin
  TControl(Instance).Height := AValue
end;

function TClassesImporter.Control_Parent_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TControl(Instance).Parent);
end;

procedure TClassesImporter.Control_Parent_Set(Instance: Pointer; AValue: Variant);
begin
  TControl(Instance).Parent := TWinControl(TSuPtr(AValue));
end;

function TClassesImporter.Control_ClientWidth_Get(Instance: Pointer): Variant;
begin
  REsult :=  TControl(Instance).ClientWidth;
end;

procedure TClassesImporter.Control_ClientWidth_Set(Instance: Pointer; AValue: Variant);
begin
  TControl(Instance).ClientWidth := AValue;
end;

function TClassesImporter.Control_ClientHeight_Get(Instance: Pointer): Variant;
begin
  Result := TControl(Instance).ClientHeight;
end;

procedure TClassesImporter.Control_ClientHeight_Set(Instance: Pointer; AValue: Variant);
begin
  TControl(Instance).ClientHeight := AValue;
end;

function TClassesImporter.Control_Hide(Instance: TObject; var Params: Variant): Variant;
begin
  TControl(Instance).Hide;
end;

function TClassesImporter.Control_Show(Instance: TObject; var Params: Variant): Variant;
begin
  TControl(Instance).Show;
end;

function TClassesImporter.Control_Repaint(Instance: TObject; var Params: Variant): Variant;
begin
  TControl(Instance).Repaint;
end;

function TClassesImporter.Control_Refresh(Instance: TObject; var Params: Variant): Variant;
begin
  TControl(Instance).Refresh;
end;

function TClassesImporter.Control_Invalidate(Instance: TObject; var Params: Variant): Variant;
begin
  TControl(Instance).Invalidate;
end;

function TClassesImporter.Control_SetBounds(Instance: TObject; var Params: Variant): Variant;
begin
  TControl(Instance).SetBounds(Params[0], Params[1], Params[2], Params[3]);
end;

function TClassesImporter.Control_BeginDrag(Instance: TObject; var Params: Variant): Variant;
begin
  TControl(Instance).BeginDrag(Params[0], Params[1]);
end;

function TClassesImporter.Control_ClientToScreen(Instance: TObject; var Params: Variant): Variant;
begin
  Compiler.RetPoint := TControl(Instance).ClientToScreen(PPoint(TSuPtr(Params[0]))^);
  Result := TSuPtr(@Compiler.RetPoint);
end;

function TClassesImporter.Control_ScreenToClient(Instance: TObject; var Params: Variant): Variant;
begin
  Compiler.RetPoint := TControl(Instance).ScreenToClient(PPoint(TSuPtr(Params[0]))^);
  Result := TSuPtr(@Compiler.RetPoint);
end;

{TWinControl}

function TClassesImporter.TWinControl_SetFocus(Instance: TObject;
  var Params: Variant): Variant;
begin
  TWinControl(Instance).SetFocus;
end;

function TClassesImporter.TWinControl_FindChildControl(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TWinControl(Instance).FindChildControl(Params[0]));
end;

function TClassesImporter.TWinControl_ControlCount(Instance: Pointer): Variant;
begin
  Result := TWinControl(Instance).ControlCount;
end;

function TClassesImporter.TWinControl_Handle(Instance: Pointer): Variant;
begin
  Result := TWinControl(Instance).Handle;
end;

function TClassesImporter.TWinControl_Controls_Get(Instance: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TWinControl(Instance).Controls[Params[0]]);
end;

{TDataModule}

function TClassesImporter.TDataModule_Create(Instance: TObject;
  var Params: Variant): Variant;
var
  DM: TDataModule;
  AType: TDpType;
  C: TComponent;
begin
  AType := TDpType(TSuPtr(Params[1]));
  if Assigned(Compiler.OnCreateDataModule) then
  begin
    C := TComponent(TSuPtr(Params[0]));
    DM := Compiler.OnCreateDataModule(C, AType);
    Result := TSuPtr(DM);
    if DM <> nil then DM.FreeNotification(Compiler);
  end;
end;

{TClipboard}
function TClassesImporter.TClipbrd_GetText(Instance: Pointer): Variant;
begin
  Result := TClipboard(Instance).AsText;
end;

procedure TClassesImporter.TClipbrd_SetText(Instance: Pointer; AValue: Variant);
begin
  TClipboard(Instance).AsText := AValue;
end;

{TZipper}

function TClassesImporter.Zipper_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxZipper(Instance).Clear;
end;

function TClassesImporter.Zipper_SaveToFile(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TZipper(Instance).SaveToFile(S);
end;

function TClassesImporter.Zipper_SaveToStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TZipper(Instance).SaveToStream(TStream(TSuPtr(Params[0])));
end;

function TClassesImporter.Zipper_ZipAllFiles(Instance: TObject;
  var Params: Variant): Variant;
begin
  TZipper(Instance).ZipAllFiles;
end;

function TClassesImporter.Zipper_ZipFiles(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TZipper(Instance).ZipFiles(TStringList(TSuPtr(Params[0])));
end;

function TClassesImporter.Zipper_ZipFilesWithName(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
  SL: TStringList;
begin
  S := Params[0];
  SL := TStringList(TSuPtr(Params[1]));
  TZipper(Instance).ZipFiles(S, SL);
end;

{TUnZipper}

function TClassesImporter.UnZipper_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TUnZipper(Instance).Clear;
end;

function TClassesImporter.UnZipper_Examine(Instance: TObject;
  var Params: Variant): Variant;
begin
  TUnZipper(Instance).Examine;
end;

function TClassesImporter.UnZipper_UnZipAllFiles(Instance: TObject;
  var Params: Variant): Variant;
begin
  TUnZipper(Instance).UnZipAllFiles;
end;

function TClassesImporter.UnZipper_UnZipAllFilesWithName(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TUnZipper(Instance).UnZipAllFiles(S);
end;

function TClassesImporter.UnZipper_UnZipFiles(Instance: TObject;
  var Params: Variant): Variant;
begin
  TUnZipper(Instance).UnZipFiles(TStrings(TSuPtr(Params[0])));
end;

function TClassesImporter.UnZipper_UnZipFilesWithName(Instance: TObject;
  var Params: Variant): Variant;
var
  AName: string;
  SL: TStrings;
begin
  AName:= Params[0];
  SL := TStrings(TSuPtr(Params[1]));
  TUnZipper(Instance).UnZipFiles(AName, SL);
end;

end.

