unit dpi_Additional;

{$mode objfpc}{$H+}
{$M+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo;

type
  { TAdditionalImport }

  TAdditionalImport = class(TClassImporter)
    function CheckListBox_CheckAll(Instance: TObject; var Params: Variant
      ): Variant;
    function CheckListBox_GetChecked(Instance: TObject; var Params: Variant
      ): Variant;
    function CheckListBox_SetChecked(Instance: TObject; var Params: Variant
      ): Variant;
    function CheckListBox_Toggle(Instance: TObject; var Params: Variant
      ): Variant;
    function ColorBox_ItemsGet(Instance: Pointer): Variant;
    procedure ColorBox_ItemsSet(Instance: Pointer; AValue: Variant);
    function CustomStringGrid_AutoSizeColumn(Instance: TObject;
      var Params: Variant): Variant;
    function CustomStringGrid_AutoSizeColumns(Instance: TObject;
      var Params: Variant): Variant;
    function CustomStringGrid_CellsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomStringGrid_CellsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomStringGrid_Clean(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomStringGrid_ColGet(Instance: Pointer): Variant;
    procedure CustomStringGrid_ColSet(Instance: Pointer; AValue: Variant);
    function CustomStringGrid_ColsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomStringGrid_ColsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomStringGrid_CopyToClipboard(Instance: TObject;
      var Params: Variant): Variant;
    function CustomStringGrid_DeleteCol(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomStringGrid_DeleteRow(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomStringGrid_EditorModeGet(Instance: Pointer): Variant;
    procedure CustomStringGrid_EditorModeSet(Instance: Pointer; AValue: Variant
      );
    function CustomStringGrid_LoadFromCSVFile(Instance: TObject;
      var Params: Variant): Variant;
    function CustomStringGrid_LoadFromCSVStream(Instance: TObject;
      var Params: Variant): Variant;
    function CustomStringGrid_ObjectsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomStringGrid_ObjectsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomStringGrid_RowGet(Instance: Pointer): Variant;
    procedure CustomStringGrid_RowSet(Instance: Pointer; AValue: Variant);
    function CustomStringGrid_RowsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomStringGrid_RowsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomStringGrid_SaveToCSVFile(Instance: TObject;
      var Params: Variant): Variant;
    function CustomStringGrid_SaveToCSVStream(Instance: TObject;
      var Params: Variant): Variant;
    function GridColumns_ItemsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function GridColumns_ItemsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function ImageGetPicture(Instance: Pointer): Variant;
    procedure ImageSetPicture(Instance: Pointer; AValue: Variant);
    function TrayIcon_AnimateGet(Instance: Pointer): Variant;
    function TrayIcon_AnimateIntervalGet(Instance: Pointer): Variant;
    procedure TrayIcon_AnimateIntervalSet(Instance: Pointer; AValue: Variant);
    procedure TrayIcon_AnimateSet(Instance: Pointer; AValue: Variant);
    function TrayIcon_Hide(Instance: TObject; var Params: Variant): Variant;
    function TrayIcon_IconsGet(Instance: Pointer): Variant;
    procedure TrayIcon_IconsSet(Instance: Pointer; AValue: Variant);
    function TrayIcon_Show(Instance: TObject; var Params: Variant): Variant;
    function TrayIcon_ShowBalloonHint(Instance: TObject; var Params: Variant
      ): Variant;
    function TrayIcon_ShowIconGet(Instance: Pointer): Variant;
    procedure TrayIcon_ShowIconSet(Instance: Pointer; AValue: Variant);
    function ValueListEditor_Clear(Instance: TObject; var Params: Variant
      ): Variant;
    function ValueListEditor_FindRow(Instance: TObject; var Params: Variant
      ): Variant;
    function ValueListEditor_FixedRowsGet(Instance: Pointer): Variant;
    procedure ValueListEditor_FixedRowsSet(Instance: Pointer; AValue: Variant);
    function ValueListEditor_InsertRow(Instance: TObject; var Params: Variant
      ): Variant;
    function ValueListEditor_IsEmptyRow(Instance: TObject; var Params: Variant
      ): Variant;
    function ValueListEditor_KeysGet(Instance: TObject; var Params: Variant
      ): Variant;
    function ValueListEditor_KeysSet(Instance: TObject; var Params: Variant
      ): Variant;
    function ValueListEditor_ModifiedGet(Instance: Pointer): Variant;
    procedure ValueListEditor_ModifiedSet(Instance: Pointer; AValue: Variant);
    function ValueListEditor_ValuesGet(Instance: TObject; var Params: Variant
      ): Variant;
    function ValueListEditor_ValuesSet(Instance: TObject; var Params: Variant
      ): Variant;
  public
    procedure AddConsts(AddConst: TAddConstProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
  published
    function TImageCanvasGet(Instance: Pointer): Variant;
    function TBitBtnClick(Instance: TObject; var Params: Variant): Variant;
    function TSpeedButtonClick(Instance: TObject; var Params: Variant): Variant;
  end;

implementation

uses dpUtils, Buttons, MaskEdit, ExtCtrls, Forms, CheckLst,
  StdCtrls, ColorBox, PairSplitter, ValEdit, ImgList, Grids, Graphics;

type

  { TCheckListClickedHandler }

  TCheckListClickedHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Index: integer);
  end;

  { TOnDrawCellHandler }

  TOnDrawCellHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; aCol, aRow: Integer; aRect: TRect;
              aState:TGridDrawState);
  end;

  { TOnPrepareCanvasEventHandler }

  TOnPrepareCanvasEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(sender: TObject; aCol, aRow: Integer;
              aState: TGridDrawState);
  end;

  { TOnCompareCellsHandler }

  TOnCompareCellsHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; ACol, ARow, BCol,BRow: Integer;
               var Result: integer);
  end;

  { TOnSelectCellEventHandler }

  TOnSelectCellEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; aCol, aRow: Integer;
              var CanSelect: Boolean);
  end;

  { TOnSelectEventHandler }

  TOnSelectEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; aCol, aRow: Integer);
  end;

  { TValidateEntryEventHandler }

  TValidateEntryEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(sender: TObject; aCol, aRow: Integer;
              const OldValue: string; var NewValue: String);
  end;

  { TGetCellHintEventHandler }

  TGetCellHintEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; ACol, ARow: Integer;
                                 var HintText: String);
  end;

  PGridDrawState = ^TGridDrawState;

{ TGetCellHintEventHandler }

function TGetCellHintEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TGetCellHintEventHandler.CallHandler;
end;

procedure TGetCellHintEventHandler.CallHandler(Sender: TObject; ACol,
  ARow: Integer; var HintText: String);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := ACol;
  Proc.Param[2].Value := ARow;
  Proc.Param[3].Value := HintText;
  Proc.Exec;
  HintText:= Proc.Param[3].Value;
end;

{ TValidateEntryEventHandler }

function TValidateEntryEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TValidateEntryEventHandler.CallHandler;
end;

procedure TValidateEntryEventHandler.CallHandler(sender: TObject; aCol,
  aRow: Integer; const OldValue: string; var NewValue: String);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := aCol;
  Proc.Param[2].Value := aRow;
  Proc.Param[3].Value := OldValue;
  Proc.Param[4].Value := NewValue;
  Proc.Exec;
  NewValue:= Proc.Param[4].Value;
end;

{ TOnSelectEventHandler }

function TOnSelectEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnSelectCellEventHandler.CallHandler;
end;

procedure TOnSelectEventHandler.CallHandler(Sender: TObject; aCol, aRow: Integer
  );
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := aCol;
  Proc.Param[2].Value := aRow;
  Proc.Exec;
end;

{ TOnSelectCellEventHandler }

function TOnSelectCellEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnSelectCellEventHandler.CallHandler;
end;

procedure TOnSelectCellEventHandler.CallHandler(Sender: TObject; aCol,
  aRow: Integer; var CanSelect: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := aCol;
  Proc.Param[2].Value := aRow;
  Proc.Param[3].Value := CanSelect;
  Proc.Exec;
  CanSelect := Proc.Param[3].Value;
end;

{ TOnCompareCellsHandler }

function TOnCompareCellsHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnCompareCellsHandler.CallHandler;
end;

procedure TOnCompareCellsHandler.CallHandler(Sender: TObject; ACol, ARow, BCol,
  BRow: Integer; var Result: integer);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := ACol;
  Proc.Param[2].Value := ARow;
  Proc.Param[3].Value := BCol;
  Proc.Param[4].Value := BRow;
  Proc.Param[5].Value := Result;
  Proc.Exec;
  Result:= Proc.Param[5].Value;
end;

{ TOnPrepareCanvasEventHandler }

function TOnPrepareCanvasEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnPrepareCanvasEventHandler.CallHandler;
end;

procedure TOnPrepareCanvasEventHandler.CallHandler(sender: TObject; aCol,
  aRow: Integer; aState: TGridDrawState);
var
  PState: PGridDrawState;
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := aCol;
  Proc.Param[2].Value:= aRow;
  PState := PGridDrawState(TSuPtr(Proc.Param[3].Value));
  PState^ := aState;
  Proc.Exec;
end;

{ TOnDrawCellHandler }

function TOnDrawCellHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnDrawCellHandler.CallHandler;
end;

procedure TOnDrawCellHandler.CallHandler(Sender: TObject; aCol, aRow: Integer;
  aRect: TRect; aState: TGridDrawState);
var
  R: TRect;
  PR: PRect;
  PState: PGridDrawState;
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := aCol;
  Proc.Param[2].Value:= aRow;
  R := aRect;;
  PR := @R;
  Proc.Param[3].Value := TSuPtr(PR);
  PState := PGridDrawState(TSuPtr(Proc.Param[4].Value));
  PState^ := aState;
  Proc.Exec;
end;

{ TCheckListClickedHandler }

function TCheckListClickedHandler.GetHandlerAdres: Pointer;
begin
  Result := @TCheckListClickedHandler.CallHandler;
end;

procedure TCheckListClickedHandler.CallHandler(Sender: TObject; Index: integer);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Index;
  Proc.Exec;
end;

function TAdditionalImport.CheckListBox_CheckAll(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCheckListBox(Instance).CheckAll(Params[0], Params[1], Params[2]);
end;

function TAdditionalImport.CheckListBox_GetChecked(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCheckListBox(Instance).Checked[Params[0]];
end;

function TAdditionalImport.CheckListBox_SetChecked(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCheckListBox(Instance).Checked[Params[0]] := Params[1];
end;

function TAdditionalImport.CheckListBox_Toggle(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCheckListBox(Instance).Toggle(Params[0]);
end;

function TAdditionalImport.ColorBox_ItemsGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TColorBox(Instance).Items );
end;

procedure TAdditionalImport.ColorBox_ItemsSet(Instance: Pointer; AValue: Variant
  );
begin
  TColorBox(Instance).Items := TStrings(TSuPtr(AValue));
end;

function TAdditionalImport.CustomStringGrid_AutoSizeColumn(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).AutoSizeColumn(Params[0]);
end;

function TAdditionalImport.CustomStringGrid_AutoSizeColumns(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).AutoSizeColumns;
end;

function TAdditionalImport.CustomStringGrid_CellsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomStringGrid(Instance).Cells[Params[0], Params[1]];
end;

function TAdditionalImport.CustomStringGrid_CellsSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).Cells[Params[0], Params[1]] := Params[2];
end;

function TAdditionalImport.CustomStringGrid_Clean(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).Clean;
end;

function TAdditionalImport.CustomStringGrid_ColGet(Instance: Pointer): Variant;
begin
  Result := TCustomStringGrid(Instance).Col;
end;

procedure TAdditionalImport.CustomStringGrid_ColSet(Instance: Pointer;
  AValue: Variant);
begin
  TCustomStringGrid(Instance).Col := AValue;
end;

function TAdditionalImport.CustomStringGrid_ColsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TCustomStringGrid(Instance).Cols[Params[0]] );
end;

function TAdditionalImport.CustomStringGrid_ColsSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).Cols[Params[0]] := TStrings( TSuPtr( Params[1] ) );
end;

function TAdditionalImport.CustomStringGrid_CopyToClipboard(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).CopyToClipboard(Params[0]);
end;

function TAdditionalImport.CustomStringGrid_DeleteCol(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).DeleteCol(Params[0]);
end;

function TAdditionalImport.CustomStringGrid_DeleteRow(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).DeleteRow(Params[0]);
end;

function TAdditionalImport.CustomStringGrid_EditorModeGet(Instance: Pointer
  ): Variant;
begin
  Result := TCustomStringGrid(Instance).EditorMode;
end;

procedure TAdditionalImport.CustomStringGrid_EditorModeSet(Instance: Pointer;
  AValue: Variant);
begin
  TCustomStringGrid(Instance).EditorMode := AValue;
end;

function TAdditionalImport.CustomStringGrid_LoadFromCSVFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).LoadFromCSVFile(Params[0], Params[1], Params[2]);
end;

function TAdditionalImport.CustomStringGrid_LoadFromCSVStream(
  Instance: TObject; var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).LoadFromCSVStream(TStream( TSuPtr( Params[0] ) ), Params[1], Params[2]);
end;

function TAdditionalImport.CustomStringGrid_ObjectsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TCustomStringGrid(Instance).Objects[Params[0], Params[1]] );
end;

function TAdditionalImport.CustomStringGrid_ObjectsSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).Objects[Params[0], Params[1]] := TObject( TSuPtr(Params[2]) );
end;

function TAdditionalImport.CustomStringGrid_RowGet(Instance: Pointer): Variant;
begin
  Result := TCustomStringGrid(Instance).Row;
end;

procedure TAdditionalImport.CustomStringGrid_RowSet(Instance: Pointer;
  AValue: Variant);
begin
  TCustomStringGrid(Instance).Row := AValue;
end;

function TAdditionalImport.CustomStringGrid_RowsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TCustomStringGrid(Instance).Rows[Params[0]] );
end;

function TAdditionalImport.CustomStringGrid_RowsSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).Rows[Params[0]] := TStrings(TSuPtr(Params[1]));
end;

function TAdditionalImport.CustomStringGrid_SaveToCSVFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).SaveToCSVFile(Params[0], Params[1], Params[2], Params[3]);
end;

function TAdditionalImport.CustomStringGrid_SaveToCSVStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomStringGrid(Instance).SaveToCSVStream(TStream(TSuPtr(Params[0])), Params[1], Params[2], Params[3]);
end;

function TAdditionalImport.GridColumns_ItemsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TGridColumns(Instance).Items[Params[0]] );
end;

function TAdditionalImport.GridColumns_ItemsSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TGridColumns(Instance).Items[Params[0]] := TGridColumn(TSuPtr(Params[1]));
end;

function TAdditionalImport.ImageGetPicture(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TCustomImage(Instance).Picture );
end;

procedure TAdditionalImport.ImageSetPicture(Instance: Pointer; AValue: Variant);
begin
  TCustomImage(Instance).Picture := TPicture(TSuPtr(AValue));
end;

function TAdditionalImport.TrayIcon_AnimateGet(Instance: Pointer): Variant;
begin
  Result := TTrayIcon(Instance).Animate;
end;

function TAdditionalImport.TrayIcon_AnimateIntervalGet(Instance: Pointer
  ): Variant;
begin
  Result := TTrayIcon(Instance).AnimateInterval;
end;

procedure TAdditionalImport.TrayIcon_AnimateIntervalSet(Instance: Pointer;
  AValue: Variant);
begin
  TTrayIcon(Instance).AnimateInterval:= AValue;
end;

procedure TAdditionalImport.TrayIcon_AnimateSet(Instance: Pointer;
  AValue: Variant);
begin
  TTrayIcon(Instance).Animate:= AValue;
end;

function TAdditionalImport.TrayIcon_Hide(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TTrayIcon(Instance).Hide;
end;

function TAdditionalImport.TrayIcon_IconsGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TTrayIcon(Instance).Icons);
end;

procedure TAdditionalImport.TrayIcon_IconsSet(Instance: Pointer; AValue: Variant
  );
begin
  TTrayIcon(Instance).Icons := TCustomImageList( TSuPtr( AValue ) );
end;

function TAdditionalImport.TrayIcon_Show(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TTrayIcon(Instance).Show;
end;

function TAdditionalImport.TrayIcon_ShowBalloonHint(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTrayIcon(Instance).ShowBalloonHint;
end;

function TAdditionalImport.TrayIcon_ShowIconGet(Instance: Pointer): Variant;
begin
  Result := TTrayIcon(Instance).ShowIcon;
end;

procedure TAdditionalImport.TrayIcon_ShowIconSet(Instance: Pointer;
  AValue: Variant);
begin
  TTrayIcon(Instance).ShowIcon := AValue;
end;

function TAdditionalImport.ValueListEditor_Clear(Instance: TObject;
  var Params: Variant): Variant;
begin
  TValueListEditor(Instance).Clear;
end;

function TAdditionalImport.ValueListEditor_FindRow(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow: Integer;
begin
  ARow:= Params[1];
  Result := TValueListEditor(Instance).FindRow(Params[0], ARow);
  Params[1] := ARow;
end;

function TAdditionalImport.ValueListEditor_FixedRowsGet(Instance: Pointer
  ): Variant;
begin
  Result := TValueListEditor(Instance).FixedRows;
end;

procedure TAdditionalImport.ValueListEditor_FixedRowsSet(Instance: Pointer;
  AValue: Variant);
begin
  TValueListEditor(Instance).FixedRows := AValue;
end;

function TAdditionalImport.ValueListEditor_InsertRow(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TValueListEditor(Instance).InsertRow(Params[0], Params[1], Params[2]);
end;

function TAdditionalImport.ValueListEditor_IsEmptyRow(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TValueListEditor(Instance).IsEmptyRow(Params[0]);
end;

function TAdditionalImport.ValueListEditor_KeysGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TValueListEditor(Instance).Keys[Params[0]];
end;

function TAdditionalImport.ValueListEditor_KeysSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TValueListEditor(Instance).Keys[Params[0]] := Params[1];
end;

function TAdditionalImport.ValueListEditor_ModifiedGet(Instance: Pointer
  ): Variant;
begin
  Result := TValueListEditor(Instance).Modified;
end;

procedure TAdditionalImport.ValueListEditor_ModifiedSet(Instance: Pointer;
  AValue: Variant);
begin
  TValueListEditor(Instance).Modified:= AValue;
end;

function TAdditionalImport.ValueListEditor_ValuesGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TValueListEditor(Instance).Values[Params[0]];
end;

function TAdditionalImport.ValueListEditor_ValuesSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TValueListEditor(Instance).Values[Params[0]] := Params[1];
end;

procedure TAdditionalImport.AddConsts(AddConst: TAddConstProc);
begin
  AddConst('gdSelected', 'Integer', gdSelected);
  AddConst('gdFocused', 'Integer', gdFocused);
  AddConst('gdFixed', 'Integer', gdFixed);
  AddConst('gdHot', 'Integer', gdHot);
  AddConst('gdPushed', 'Integer', gdPushed);
  AddConst('gdRowHighlight', 'Integer', gdRowHighlight);
end;

procedure TAdditionalImport.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
begin
  AddClass(TCustomBitBtn).ClassImporter := Self;
  AddClass(TBitBtn);
  AddClass(TCustomSpeedButton).ClassImporter := Self;
  AddClass(TSpeedButton);
  AddClass(TStaticText).ClassImporter := Self;
  AddClass(TCustomImage).ClassImporter := Self;
  AddClass(TImage);
  AddClass(TShape).ClassImporter := Self;
  AddClass(TBevel).ClassImporter := Self;
  AddClass(TLabeledEdit);
  AddClass(TSplitter).ClassImporter := Self;
  AddClass(TTrayIcon).ClassImporter := Self;
  AddClass(TMaskEdit);
  AddClass(TCheckListBox).ClassImporter := Self;
  AddClass(TScrollBox);
  AddClass(TApplicationProperties);
  AddClass(TPairSplitterSide);//.ClassImporter := Self;
  AddClass(TPairSplitter);
  AddClass(TColorBox).ClassImporter := Self;
  AddClass(TColorListBox);
  AddClass(TGridColumn);
  AddClass(TGridColumns).ClassImporter := Self;
  AddClass(TCustomStringGrid).ClassImporter := Self;
  AddClass(TStringGrid);
  AddClass(TValueListEditor).ClassImporter := Self;

end;

procedure TAdditionalImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TBalloonFlags));
  //AddType(TypeInfo(TGridDrawStat));
  AddType(TypeInfo(TGridDrawState));
  AddType(TypeInfo(TGridOption));
  AddType(TypeInfo(TGridOptions));
  AddType(TypeInfo(TGridOption2));
  AddType(TypeInfo(TGridOptions2));
end;

procedure TAdditionalImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TCustomImage then
  begin
    AType.AddProp('Canvas', 'TCanvas', @TImageCanvasGet);
    AType.AddProp('Picture', 'TPicture', @ImageGetPicture, @ImageSetPicture);
  end
  else
  if AType.ValueClassType = TCustomBitBtn then
  begin
    AType.AddMethod('procedure Click', @TBitBtnClick);
  end
  else
  if AType.ValueClassType = TCustomSpeedButton then
  begin
    AType.AddMethod('procedure Click', @TSpeedButtonClick);
  end
  else
  if AType.ValueClassType = TTrayIcon then
  begin
    AType.AddMethod('function Hide: Boolean', @TrayIcon_Hide);
    AType.AddMethod('function Show: Boolean', @TrayIcon_Show);
    AType.AddMethod('procedure ShowBalloonHint', @TrayIcon_ShowBalloonHint);
    AType.AddProp('Animate', 'Boolean',  @TrayIcon_AnimateGet,  @TrayIcon_AnimateSet);
    AType.AddProp('AnimateInterval', 'Cardinal',  @TrayIcon_AnimateIntervalGet,  @TrayIcon_AnimateIntervalSet);
    AType.AddProp('Icons', 'TCustomImageList',  @TrayIcon_IconsGet,  @TrayIcon_IconsSet);
    AType.AddProp('ShowIcon', 'Boolean',  @TrayIcon_ShowIconGet,  @TrayIcon_ShowIconSet);
  end
  else
  if AType.ValueClassType = TGridColumns then
  begin
    AType.AddIndexedProp('Items', 'TGridColumn', 'Integer', @GridColumns_ItemsGet, @GridColumns_ItemsSet);
  end
  else
  if AType.ValueClassType = TCustomStringGrid then
  begin
    AType.AddMethod('procedure Clean', @CustomStringGrid_Clean);
    AType.AddMethod('procedure CopyToClipboard(AUseSelection: boolean = false)', @CustomStringGrid_CopyToClipboard);
    AType.AddMethod('procedure LoadFromCSVStream(AStream: TStream; ADelimiter: Char='',''; WithHeader: boolean=true)', @CustomStringGrid_LoadFromCSVStream);
    AType.AddMethod('procedure LoadFromCSVFile(AFilename: string; ADelimiter: Char='',''; WithHeader: boolean=true)', @CustomStringGrid_LoadFromCSVFile);
    AType.AddMethod('procedure SaveToCSVStream(AStream: TStream; ADelimiter: Char='',''; WithHeader: boolean=true; VisibleColumnsOnly: boolean=false)', @CustomStringGrid_SaveToCSVStream);
    AType.AddMethod('procedure SaveToCSVFile(AFileName: string; ADelimiter: Char='',''; WithHeader: boolean=true; VisibleColumnsOnly: boolean=false)', @CustomStringGrid_SaveToCSVFile);
    AType.AddMethod('procedure AutoSizeColumns', @CustomStringGrid_AutoSizeColumns);
    AType.AddMethod('procedure AutoSizeColumn(aCol: Integer)', @CustomStringGrid_AutoSizeColumn);
    AType.AddMethod('procedure DeleteCol(Index: Integer)', @CustomStringGrid_DeleteCol);
    AType.AddMethod('procedure DeleteRow(Index: Integer)', @CustomStringGrid_DeleteRow);

    AType.AddIndexedProp('Cells', 'string', 'Integer, Integer', @CustomStringGrid_CellsGet, @CustomStringGrid_CellsSet);
    AType.AddIndexedProp('Cols', 'TStrings', 'Integer', @CustomStringGrid_ColsGet, @CustomStringGrid_ColsSet);
    AType.AddIndexedProp('Rows', 'TStrings', 'Integer', @CustomStringGrid_RowsGet, @CustomStringGrid_RowsSet);
    AType.AddProp('EditorMode', 'Boolean', @CustomStringGrid_EditorModeGet, @CustomStringGrid_EditorModeSet);
    AType.AddProp('Col', 'Integer', @CustomStringGrid_ColGet, @CustomStringGrid_ColSet);
    AType.AddProp('Row', 'Integer', @CustomStringGrid_RowGet, @CustomStringGrid_RowSet);
    AType.AddIndexedProp('Objects', 'TObject', 'Integer, Integer', @CustomStringGrid_ObjectsGet, @CustomStringGrid_ObjectsSet);
  end
  else
  if AType.ValueClassType = TValueListEditor then
  begin
    AType.AddMethod('procedure Clear', @ValueListEditor_Clear);
    AType.AddMethod('function FindRow(const KeyName: string; out aRow: Integer): Boolean', @ValueListEditor_FindRow);
    AType.AddMethod('function InsertRow(const KeyName, Value: string; Append: Boolean): Integer', @ValueListEditor_InsertRow);
    AType.AddMethod('function IsEmptyRow(aRow: Integer): Boolean', @ValueListEditor_IsEmptyRow);
    AType.AddProp('Modified', 'Boolean', @ValueListEditor_ModifiedGet, @ValueListEditor_ModifiedSet);
    AType.AddProp('FixedRows', 'Integer', @ValueListEditor_FixedRowsGet, @ValueListEditor_FixedRowsSet);
    AType.AddIndexedProp('Keys', 'string', 'Integer', @ValueListEditor_KeysGet, @ValueListEditor_KeysSet);
    AType.AddIndexedProp('Values', 'string', 'string', @ValueListEditor_ValuesGet, @ValueListEditor_ValuesSet);
  end
  else
  if AType.ValueClassType = TCheckListBox then
  begin
    AType.AddMethod('procedure CheckAll(AState: TCheckBoxState; aAllowGrayed: Boolean = True; aAllowDisabled: Boolean = True)', @CheckListBox_CheckAll);
    AType.AddMethod('procedure Toggle(AIndex: Integer)', @CheckListBox_Toggle);
    AType.AddIndexedProp('Checked', 'Boolean', 'Integer', @CheckListBox_GetChecked, @CheckListBox_SetChecked);
  end
  else
  if AType.ValueClassType = TColorBox then
  begin
    AType.AddProp('Items', 'TStrings', @ColorBox_ItemsGet, @ColorBox_ItemsSet);
  end;
end;

procedure TAdditionalImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TCheckListClicked), TCheckListClickedHandler);
  RegisterHandler(TypeInfo(TOnDrawCell), TOnDrawCellHandler);
  RegisterHandler(TypeInfo(TOnPrepareCanvasEvent), TOnPrepareCanvasEventHandler);
  RegisterHandler(TypeInfo(TOnCompareCells), TOnCompareCellsHandler);
  RegisterHandler(TypeInfo(TOnSelectCellEvent), TOnSelectCellEventHandler);
  RegisterHandler(TypeInfo(TOnSelectEvent), TOnSelectEventHandler);
  RegisterHandler(TypeInfo(TValidateEntryEvent), TValidateEntryEventHandler);
  RegisterHandler(TypeInfo(TGetCellHintEvent), TGetCellHintEventHandler);

end;

function TAdditionalImport.TImageCanvasGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TCustomImage(Instance).Canvas);
end;

function TAdditionalImport.TBitBtnClick(Instance: TObject; var Params: Variant): Variant;
begin
  TCustomBitBtn(Instance).Click;
end;

function TAdditionalImport.TSpeedButtonClick(Instance: TObject; var Params: Variant): Variant;
begin
  TCustomSpeedButton(Instance).Click;
end;

end.

