{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit dpCompilmsg;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, dpUtils;

type
  TCompilerError = (
    ceUnknownIdentifier,
    ceIdentifierExpected,
    ceCommentError,
    ceStringError,
    ceCharError,
    ceSyntaxError,
    ceUnexpectedEndOfFile,
    ceSemicolonExpected,
    ceBeginExpected,
    cePeriodExpected,
    ceIdentifierRedeclared,
    ceColonExpected,
    ceUnknownType,
    ceCloseRoundExpected,
    ceTypeMismatch,
    ceTypeExpected,
    ceTypeRedeclared,
    ceInternalError,
    ceAssignmentExpected,
    ceThenExpected,
    ceDoExpected,
    ceNoResult,
    ceOpenRoundExpected,
    ceCommaExpected,
    ceToExpected,
    ceIsExpected,
    ceOfExpected,
    ceCloseBlockExpected,
    ceVariableExpected,
    ceConstExpected,
    ceStringExpected,
    ceEndExpected,
    ceUnSetLabel,
    ceOpenBlockExpected,
    ceWriteOnlyProperty,
    ceReadOnlyProperty,
    ceReadOnlyVar,
    ceClassTypeExpected,
    ceCustomError,
    ceDivideByZero,
    ceMathError,
    ceInvalidnumberOfParameters,
    ceErrorTypeInExpression,
    ceOperatorNoAcceptOperandTip,
    ceInvalidParameterType,
    ceCallMethodHasNoParam,
    ceValueInVarParam,
    ceNoMethodInClass,
    ceExceptFinallyExpected,
    ceUntilExpected,
    ceBreakNotInCycle,
    ceErrorTypeInSet,
    ceContinueNotInCycle,
    ceCrossRefUnits,
    ceProcPointer,
    ceProcFunctionExpected,
    ceFuncProcExpected,
    ceReadExpected);

    TSuMessageType = (dsmMsg, dsmError, dsmWarning, dsmHint);

    TDpCompilerMessage = class
    private
      FRow: Integer;
      FCol: Integer;
      FModuleName: String;
      FMessageType: TSuMessageType;
      FMessageCode: Integer;
      FMessage: String;
    protected
      function GetMessageStr: String;
    public
      constructor Create(ACol, ARow: Integer; AModuleName: AnsiString;
        AMessageCode: Integer; AParam: AnsiString; AMsgType: TSuMessageType; ALanguage: TSuLanguage); virtual;
      property Row: Integer read FRow write FRow;
      property Col: Integer read FCol write FCol;
      property ModuleName: string read FModuleName write FModuleName;
      property MessageStr: string read GetMessageStr;
      property MessageCode: Integer read FMessageCode;
      property MessageType: TSuMessageType read FMessageType write FMessageType;
    end;

    TSuMessage = procedure(AMessage: TDpCompilerMessage) of object;

const
  ce_UnknownIdentifier = 'Неизвестный идентификатор ''%s''';
  ce_IdentifierExpected = 'Ожидается идентификатор';
  ce_CommentError = 'Ошибка в комментарии';
  ce_StringError = 'Ошибочная строка';
  ce_CharError = 'Ошибочный символ';
  ce_SyntaxError = 'Синтаксическая ошибка';
  ce_UnexpectedEndOfFile = 'Неожиданный конец файла';
  ce_SemicolonExpected = 'Ожидается '';''';
  ce_BeginExpected = 'Ожидается ''BEGIN''';
  ce_PeriodExpected = 'Ожидается ''.''';
  ce_IdentifierRedeclared = 'Идентификатор ''%S'' объявлен повторно';
  ce_ColonExpected = 'Ожидается '':''';
  ce_UnknownType = 'Неизвестный тип ''%S''';
  ce_CloseRoundExpected = 'Ожидается '')''';
  ce_TypeMismatch = 'Несовместимые типы ''%S''';
  ce_TypeExpected = 'Ожидается указание типа';
  ce_TypeRedeclared = 'Тип ''%S'' объявлен повторно';
  ce_InternalError = 'Внешняя ошибка ''%S''';
  ce_AssignmentExpected = 'Ожидается ''=''';
  ce_AssignmentPasExpected = 'Ожидается '':=''';
  ce_ThenExpected = 'Ожидается ''THEN''';
  ce_DoExpected = 'Ожидается ''DO''';
  ce_NoResult = 'Нет Result';
  ce_OpenRoundExpected = 'Ожидается ''(''';
  ce_CommaExpected = 'Ожидается '',''';
  ce_ToExpected = 'Ожидается ''TO''';
  ce_IsExpected = 'Ожидается ''IS''';
  ce_OfExpected = 'Ожидается ''OF''';
  ce_CloseBlockExpected = 'Ожидается '']''';
  ce_VariableExpected = 'Ожидается переменная';
  ce_ConstExpected = 'Ожидается константа';
  ce_StringExpected = 'Ожидается строка';
  ce_EndExpected = 'Ожидается ''END''';
  ce_UnSetLabel = 'Label ''%s'' not set';
  ce_OpenBlockExpected = 'Ожидается ''[''';
  ce_WriteOnlyProperty = 'Свойство ''%S'' только для записи';
  ce_ReadOnlyProperty = 'Свойство ''%S'' только для чтения';
  ce_ReadOnlyVar = 'Переменная или параметр ''%S'' только для чтения';
  ce_ClassTypeExpected = 'Ожидается тип класса';
  ce_CustomError = 'Ошибка: %S';
  ce_DivideByZero = 'Деление на 0';
  ce_MathError = 'Математическая ошибка';
  ce_InvalidnumberOfParameters = 'Неверное количество параметров';
  ce_ErrorTypeInExpression = 'Выражение возвращает неподходящий тип для данной операции';
  ce_OperatorNoAcceptOperandTip = 'Оператор не применим к данному типу опреанда';
  ce_InvalidParameterType = 'Неверный тип параметра';
  ce_CallMethodHasNoParam = 'Вызываемый метод не имеет параметров';
  ce_ValueInVarParam = 'Значение не может быть передано поссылке, требуется идентификатор';
  ce_NoMethodInClass = 'Метод ''%S'' в объявлении класса не найден';
  ce_ExceptFinallyExpected = 'Ожидается Except или Finally';
  ce_UntilExpected = 'Ожидается Until';
  ce_BreakNotInCycle = 'Инструкция Break применена вне цикла';
  ce_ErrorTypeInSet = 'Множество не может использовать значение с типом %S';
  ce_ContinueNotInCycle = 'Инструкция Continue применена вне цикла';
  ce_CrossRefUnits = 'Перекрестная ссылка модулей';
  ce_ProcPointer = 'Ожидается адрес метода';
  ce_ProcFunctionExpected = 'Ожидается функция вместо процедуры %Ы';
  ce_FuncProcExpected = 'Ожидается процедура вместо функции %S';

  ch_BadBegin = 'begin применен неуместно';
  ce_ReadExpected = 'Ожидается Read';

implementation

constructor TDpCompilerMessage.Create(ACol, ARow: Integer; AModuleName: AnsiString;
        AMessageCode: Integer; AParam: AnsiString; AMsgType: TSuMessageType; ALanguage: TSuLanguage);
var
  Param: string;
begin
  inherited Create;
  FRow := ARow;
  FCol := ACol;
  FModuleName := AModuleName;
  FMessageType := AMsgType;
  FMessageCode := AMessageCode;
  Param := AParam;

  case AMsgType of
    dsmMsg: FMessage :=  Param;

    dsmError:
    begin
      case TCompilerError(AMessageCode) of
        ceUnknownIdentifier: FMessage := Format(ce_UnknownIdentifier, [Param]);
        ceIdentifierExpected: FMessage := Format(ce_IdentifierExpected, [Param]);
        ceCommentError: FMessage := ce_CommentError;
        ceStringError: FMessage := ce_StringError;
        ceCharError: FMessage := ce_CharError;
        ceSyntaxError: FMessage := ce_SyntaxError;
        ceUnexpectedEndOfFile: FMessage := ce_UnexpectedEndOfFile;
        ceSemicolonExpected: FMessage := ce_SemicolonExpected;
        ceBeginExpected: FMessage := ce_BeginExpected;
        cePeriodExpected: FMessage := ce_PeriodExpected;
        ceIdentifierRedeclared: FMessage := Format(ce_IdentifierRedeclared, [Param]);
        ceColonExpected: FMessage := ce_ColonExpected;
        ceUnknownType: FMessage := Format(ce_UnknownType, [Param]);
        ceCloseRoundExpected: FMessage := ce_CloseRoundExpected;
        ceTypeMismatch: FMessage := Format(ce_TypeMismatch, [Param]);
        ceTypeExpected: FMessage := ce_TypeExpected;
        ceTypeRedeclared: FMessage := Format(ce_TypeRedeclared, [Param]);
        ceInternalError: FMessage := Format(ce_InternalError, [Param]);
        ceAssignmentExpected:
        begin
          FMessage := ce_AssignmentExpected;
          if ALanguage = slPascal then
            FMessage := ce_AssignmentPasExpected;
        end;

        ceThenExpected: FMessage := ce_ThenExpected;
        ceDoExpected: FMessage := ce_DoExpected;
        ceNoResult: FMessage := ce_NoResult;
        ceOpenRoundExpected: FMessage := ce_OpenRoundExpected;
        ceCommaExpected: FMessage := ce_CommaExpected;
        ceToExpected: FMessage := ce_ToExpected;
        ceIsExpected: FMessage := ce_IsExpected;
        ceOfExpected: FMessage := ce_OfExpected;
        ceCloseBlockExpected: FMessage := ce_CloseBlockExpected;
        ceVariableExpected: FMessage := ce_VariableExpected;
        ceConstExpected: FMessage := ce_ConstExpected;
        ceStringExpected: FMessage := ce_StringExpected;
        ceEndExpected: FMessage := ce_EndExpected;
        ceUnSetLabel: FMessage := ce_UnSetLabel;
        ceOpenBlockExpected: FMessage := ce_OpenBlockExpected;
        ceWriteOnlyProperty: FMessage := Format(ce_WriteOnlyProperty, [Param]);
        ceReadOnlyProperty: FMessage := Format(ce_ReadOnlyProperty, [Param]);
        ceReadOnlyVar: FMessage := Format(ce_ReadOnlyVar, [Param]);
        ceClassTypeExpected: FMessage := ce_ClassTypeExpected;
        ceCustomError:
        begin
          if AParam = '' then FMessage := ce_CustomError
          else FMessage := Param;
        end;
        ceDivideByZero: FMessage := ce_DivideByZero;
        ceMathError: FMessage := ce_MathError;
        ceInvalidnumberOfParameters: FMessage := ce_InvalidnumberOfParameters;
        ceErrorTypeInExpression: FMessage := ce_ErrorTypeInExpression;
        ceOperatorNoAcceptOperandTip: FMessage := ce_OperatorNoAcceptOperandTip;
        ceInvalidParameterType: FMessage := ce_InvalidParameterType;
        ceCallMethodHasNoParam: FMessage := ce_CallMethodHasNoParam;
        ceValueInVarParam: FMessage := ce_ValueInVarParam;
        ceNoMethodInClass: FMessage := Format(ce_NoMethodInClass, [Param]);
        ceExceptFinallyExpected: FMessage := ce_ExceptFinallyExpected;
        ceUntilExpected: FMessage := ce_UntilExpected;
        ceBreakNotInCycle: FMessage := ce_BreakNotInCycle;
        ceErrorTypeInSet: FMessage := Format(ce_ErrorTypeInSet, [Param]);
        ceContinueNotInCycle: FMessage := ce_ContinueNotInCycle;
        ceCrossRefUnits: FMessage := ce_CrossRefUnits;
        ceProcPointer: FMessage:= Format(ce_ProcPointer, [Param]);
        ceProcFunctionExpected: FMessage:= Format(ce_ProcFunctionExpected, [Param]);
        ceFuncProcExpected: FMessage:= Format(ce_FuncProcExpected, [Param]);
        ceReadExpected: FMessage := ce_ReadExpected;
      end;
    end;
    dsmWarning: FMessage := Param;
    dsmHint: FMessage := Param;
  end;

end;

function TDpCompilerMessage.GetMessageStr: String;
var
  S: String;
begin
  S := '';
  case FMessageType of
    dsmMsg: S := '';
    dsmError: S := 'Ошибка';
    dsmWarning: S := 'Предупреждение';
    dsmHint: S := 'Подсказка';
  end;
  Result := '';
  if S <> '' then Result := Result + '[' + S + '] ';

  Result := Result + FModuleName + '(' + IntToStr(FRow) + ',' +
    IntToStr(FCol) + '): ' + FMessage;
end;

end.

