{------------------------------------------------------------------------------}
{                                                                              }
{                              Yuriy Kopnin                                    }
{                            Package VisuaTech                                 }
{                                 LGPL                                         }
{                                                                              }
{------------------------------------------------------------------------------}

{ $Id: grids.pas 37777 2012-06-25 10:26:51Z martin $}
unit xGrids;

{$mode objfpc}{$H+}
{$define NewCols}

interface

uses
  Types, Classes, SysUtils, Math, Maps, LCLStrConsts, LCLProc, LCLType, LCLIntf,
  FileUtil, FPCanvas, Controls, GraphType, Graphics, Forms, DynamicArray,
  LMessages, XMLConf, StdCtrls, LResources, MaskEdit, Buttons, Clipbrd, Themes;

const
  //GRIDFILEVERSION = 1; // Original
  //GRIDFILEVERSION = 2; // Introduced goSmoothScroll
  GRIDFILEVERSION = 3; // Introduced Col/Row FixedAttr and NormalAttr

const
  GM_SETVALUE   = LM_INTERFACELAST + 100;
  GM_GETVALUE   = LM_INTERFACELAST + 101;
  GM_SETGRID    = LM_INTERFACELAST + 102;
  GM_SETBOUNDS  = LM_INTERFACELAST + 103;
  GM_SELECTALL  = LM_INTERFACELAST + 104;
  GM_SETMASK    = LM_INTERFACELAST + 105;
  GM_SETPOS     = LM_INTERFACELAST + 106;
  GM_READY      = LM_INTERFACELAST + 107;
  GM_GETGRID    = LM_INTERFACELAST + 108;


const
  EO_AUTOSIZE     =   $1;
  EO_HOOKKEYDOWN  =   $2;
  EO_HOOKKEYPRESS =   $4;
  EO_HOOKKEYUP    =   $8;
  EO_SELECTALL    =   $10;
  EO_IMPLEMENTED  =   $20;

const
  DEFCOLWIDTH     = 64;
  DEFROWHEIGHT    = 20;
  DEFBUTTONWIDTH  = 25;

type
  xEGridException = class(Exception);

type
  TxGridOption = (
    xgoFixedVertLine,      // Ya
    xgoFixedHorzLine,      // Ya
    xgoVertLine,           // Ya
    xgoHorzLine,           // Ya
    xgoRangeSelect,        // Ya
    xgoDrawFocusSelected,  // Ya
    xgoRowSizing,          // Ya
    xgoColSizing,          // Ya
    xgoRowMoving,          // Ya
    xgoColMoving,          // Ya
    xgoEditing,            // Ya
    xgoAutoAddRows,        // JuMa
    xgoTabs,               // Ya
    xgoRowSelect,          // Ya
    xgoAlwaysShowEditor,   // Ya
    xgoThumbTracking,      // ya
    // Additional Options
    xgoColSpanning,        // Enable cellextent calcs
    xgoRelaxedRowSelect,   // User can see focused cell on xgoRowSelect
    xgoDblClickAutoSize,   // dblclicking columns borders (on hdrs) resize col.
    xgoSmoothScroll,       // Switch scrolling mode (pixel scroll is by default)
    xgoFixedRowNumbering,  // Ya
    xgoScrollKeepVisible,  // keeps focused cell visible while scrolling
    xgoHeaderHotTracking,  // Header cells change look when mouse is over them
    xgoHeaderPushedLook,   // Header cells looks pushed when clicked
    xgoSelectionActive,    // Setting grid.Selection moves also cell cursor
    xgoFixedColSizing,     // Allow to resize fixed columns
    xgoDontScrollPartCell, // clicking partially visible cells will not scroll
    xgoCellHints,          // show individual cell hints
    xgoTruncCellHints,     // show cell hints if cell text is too long
    xgoCellEllipsis,        // show "..." if cell text is too long
    xgoRowHightLight
  );
  TxGridOptions = set of TxGridOption;

  TxGridSaveOptions = (
    soxDesign,             // Save grid structure (col/row count and Options)
    soxAttributes,         // Save grid attributes (Font,Brush,TextStyle)
    soxContent,            // Save Grid Content (Text in stringgrid)
    soxPosition            // Save Grid cursor and selection position
  );
  TxSaveOptions = set of TxGridSaveOptions;

  TxGridDrawState = set of (xgdSelected, xgdFocused, xgdFixed, xgdHot, xgdPushed);
  TxGridState =(xgsNormal, xgsSelecting, xgsRowSizing, xgsColSizing, xgsRowMoving,
    xgsColMoving, xgsHeaderClicking, xgsButtonColumnClicking);

  TxGridZone = (xgzNormal, xgzFixedCols, xgzFixedRows, xgzFixedCells, xgzInvalid);
  TxGridZoneSet = set of TxGridZone;

  TxAutoAdvance = (aaNone,aaDown,aaRight,aaLeft, aaRightDown, aaLeftDown,
    aaRightUp, aaLeftUp);

  TItemType = (itxNormal,itxCell,itxColumn,itxRow,itxFixed,itxFixedColumn,itxFixedRow,itxSelected);

  TxColumnButtonStyle = (
    cbsxAuto,
    cbsxEllipsis,
    cbsxNone,
    cbsxPickList,
    cbsxCheckboxColumn,
    cbsxButton,
    cbsxButtonColumn
  );

  TxTitleStyle = (tsxLazarus, tsxStandard, tsxNative);

  TxGridFlagsOption = (gfxEditorUpdateLock, gfxNeedsSelectActive, gfxEditorTab,
    gfxRevEditorTab, gfxVisualChange, gfxDefRowHeightChanged, gfxColumnsLocked,
    gfxEditingDone, gfxSizingStarted, gfxPainting, gfxUpdatingSize);
  TxGridFlags = set of TxGridFlagsOption;

  TxPrefixOption = (poxNone, poxHeaderClick);

  TxMouseWheelOption = (mwxCursor, mwxGrid);

  TxCellHintPriority = (chpxAll, chpxAllNoDefault, chpxTruncOnly);
  // The grid can display three types of hint: the default hint (Hint property),
  // individual cell hints (OnCellHint event), and hints for truncated cells.
  // TCellHintPriority determines how the overall hint is combined when more
  // multiple hint texts are to be displayed.

const
  soxAll: TxSaveOptions = [soxDesign, soxAttributes, soxContent, soxPosition];
  xconstRubberSpace: byte = 2;
  xconstCellPadding: byte = 3;

type

  TCustomXGrid = class;
  TxGridColumn = class;


  PCellProps= ^TCellProps;
  TCellProps=record
    Attr: pointer;
    Data: TObject;
    Text: pchar;
  end;

  PColRowProps= ^TColRowProps;
  TColRowProps=record
    Size: Integer;
    FixedAttr: pointer;
    NormalAttr: pointer;
  end;

  PGridMessage=^TxGridMessage;
  TxGridMessage=record
    LclMsg: TLMessage;
    Grid: TCustomXGrid;
    Col,Row: Integer;
    Value: string;
    CellRect: TRect;
    Options: Integer;
  end;

 type
  { Default cell editor for TStringGrid }
  { TxStringCellEditor }

  TxStringCellEditor=class(TCustomMaskEdit)
  private
    FGrid: TCustomXGrid;
    FCol,FRow:Integer;
  protected
    procedure WndProc(var TheMessage : TLMessage); override;
    procedure Change; override;
    procedure KeyDown(var Key : Word; Shift : TShiftState); override;
    procedure msg_SetMask(var Msg: TxGridMessage); message GM_SETMASK;
    procedure msg_SetValue(var Msg: TxGridMessage); message GM_SETVALUE;
    procedure msg_GetValue(var Msg: TxGridMessage); message GM_GETVALUE;
    procedure msg_SetGrid(var Msg: TxGridMessage); message GM_SETGRID;
    procedure msg_SelectAll(var Msg: TxGridMessage); message GM_SELECTALL;
    procedure msg_SetPos(var Msg: TxGridMessage); message GM_SETPOS;
    procedure msg_GetGrid(var Msg: TxGridMessage); message GM_GETGRID;
  public
    constructor Create(Aowner : TComponent); override;
    procedure EditingDone; override;
    property EditText;
    property OnEditingDone;
  end;

  { TxButtonCellEditor }

  TxButtonCellEditor = class(TButton)
  private
    FGrid: TCustomXGrid;
    FCol,FRow: Integer;
  protected
    procedure msg_SetGrid(var Msg: TxGridMessage); message GM_SETGRID;
    procedure msg_SetBounds(var Msg: TxGridMessage); message GM_SETBOUNDS;
    procedure msg_SetPos(var Msg: TxGridMessage); message GM_SETPOS;
    procedure msg_Ready(var Msg: TxGridMessage); message GM_READY;
    procedure msg_GetGrid(var Msg: TxGridMessage); message GM_GETGRID;
  public
    property Col: Integer read FCol;
    property Row: Integer read FRow;
  end;

  { TxPickListCellEditor }

  TxPickListCellEditor = class(TCustomComboBox)
  private
    FGrid: TCustomXGrid;
    FCol,FRow: Integer;
  protected
    procedure WndProc(var TheMessage : TLMessage); override;
    procedure KeyDown(var Key : Word; Shift : TShiftState); override;
    procedure DropDown; override;
    procedure CloseUp; override;
    procedure Select; override;
    procedure Change; override;
    procedure msg_GetValue(var Msg: TxGridMessage); message GM_GETVALUE;
    procedure msg_SetGrid(var Msg: TxGridMessage); message GM_SETGRID;
    procedure msg_SetValue(var Msg: TxGridMessage); message GM_SETVALUE;
    procedure msg_SetPos(var Msg: TxGridMessage); message GM_SETPOS;
    procedure msg_GetGrid(var Msg: TxGridMessage); message GM_GETGRID;
  public
    procedure EditingDone; override;
    property BorderStyle;
    property OnEditingDone;
  end;

  { TxCompositeCellEditor }

  TxEditorItem = record
    Editor: TWinControl;
    Align: TAlign;
    ActiveControl: boolean;
  end;

  TxCompositeCellEditor = class(TWinControl)
  private
    FGrid: TCustomXGrid;
    FCol,FRow: Integer;
    FEditors: array of TxEditorItem;
    FReadOnly: Boolean;
    procedure DispatchMsg(msg: TxGridMessage);
    function GetActiveControl: TWinControl;
    function GetMaxLength: Integer;
    procedure SetMaxLength(AValue: Integer);
    procedure SetReadOnly(AValue: Boolean);
  protected
    function  DoUTF8KeyPress(var UTF8Key: TUTF8Char): boolean; override;
    procedure msg_GetValue(var Msg: TxGridMessage); message GM_GETVALUE;
    procedure msg_SetGrid(var Msg: TxGridMessage); message GM_SETGRID;
    procedure msg_SetValue(var Msg: TxGridMessage); message GM_SETVALUE;
    procedure msg_SetBounds(var Msg: TxGridMessage); message GM_SETBOUNDS;
    procedure msg_SetMask(var Msg: TxGridMessage); message GM_SETMASK;
    procedure msg_SelectAll(var Msg: TxGridMessage); message GM_SELECTALL;
    procedure CMControlChange(var Message: TLMEssage); message CM_CONTROLCHANGE;
    procedure msg_SetPos(var Msg: TxGridMessage); message GM_SETPOS;
    procedure msg_GetGrid(var Msg: TxGridMessage); message GM_GETGRID;
    procedure VisibleChanging; override;
    function  SendChar(AChar: TUTF8Char): Integer;
    procedure WndProc(var TheMessage : TLMessage); override;
  public
    destructor Destroy; override;
    procedure AddEditor(aEditor: TWinControl; aAlign: TAlign; ActiveCtrl:boolean);
    procedure SetFocus; override;
    property MaxLength: Integer read GetMaxLength write SetMaxLength;
    property ReadOnly: Boolean read FReadOnly write SetReadOnly default False;
  end;


  TOnDrawCell =
    procedure(Sender: TObject; aCol, aRow: Integer; aRect: TRect;
              aState:TxGridDrawState) of object;

  TOnSelectCellEvent =
    procedure(Sender: TObject; aCol, aRow: Integer;
              var CanSelect: Boolean) of object;

  TOnSelectEvent =
    procedure(Sender: TObject; aCol, aRow: Integer) of object;

  TGridOperationEvent =
    procedure (Sender: TObject; IsColumn:Boolean;
               sIndex, tIndex: Integer) of object;

  THdrEvent =
    procedure(Sender: TObject; IsColumn: Boolean; Index: Integer) of object;

  TOnCompareCells =
    procedure (Sender: TObject; ACol, ARow, BCol,BRow: Integer;
               var Result: integer) of object;

  TSelectEditorEvent =
    procedure(Sender: TObject; aCol, aRow: Integer;
              var Editor: TWinControl) of object;

  TOnPrepareCanvasEvent =
    procedure(sender: TObject; aCol, aRow: Integer;
              aState: TxGridDrawState) of object;

  TUserCheckBoxBitmapEvent =
    procedure(Sender: TObject; const aCol, aRow: Integer;
              const CheckedState: TCheckboxState;
              var ABitmap: TBitmap) of object;

  TValidateEntryEvent =
    procedure(sender: TObject; aCol, aRow: Integer;
              const OldValue: string; var NewValue: String) of object;

  TToggledCheckboxEvent = procedure(sender: TObject; aCol, aRow: Integer;
                                    aState: TCheckboxState) of object;

  THeaderSizingEvent = procedure(sender: TObject; const IsColumn: boolean;
                                    const aIndex, aSize: Integer) of object;

  TGetCellHintEvent = procedure (Sender: TObject; ACol, ARow: Integer;
                                 var HintText: String) of object;

  { TxVirtualGrid }

  TxVirtualGrid=class
    private
      FColCount: Integer;
      FRowCount: Integer;
      FCells, FCols, FRows: TPointerPointerArray;
      function  GetCells(Col, Row: Integer): PCellProps;
      function  Getrows(Row: Integer): PColRowprops;
      function  Getcols(Col: Integer): PColRowprops;
      procedure SetCells(Col, Row: Integer; const AValue: PCellProps);
      procedure Setrows(Row: Integer; const Avalue: PColRowprops);
      procedure Setcolcount(const Avalue: Integer);
      procedure Setrowcount(const Avalue: Integer);
      procedure Setcols(Col: Integer; const Avalue: PColRowprops);
    protected
      procedure doDestroyItem(Sender: TObject; Col,Row:Integer; var Item: Pointer);
      procedure doNewItem(Sender: TObject; Col,Row:Integer; var Item: Pointer);
      procedure DeleteColRow(IsColumn: Boolean; index: Integer);
      procedure MoveColRow(IsColumn: Boolean; FromIndex, ToIndex: Integer);
      procedure ExchangeColRow(IsColumn:Boolean; index,WithIndex: Integer);
      procedure InsertColRow(IsColumn:Boolean; Index: Integer);
      procedure DisposeCell(var P: PCellProps); virtual;
      procedure DisposeColRow(var p: PColRowProps); virtual;
    public
      constructor Create;
      destructor Destroy; override;
      procedure Clear;
      function GetDefaultCell: PcellProps;
      function GetDefaultColRow: PColRowProps;

      property ColCount: Integer read FColCount write SetColCount;
      property RowCount: Integer read FRowCount write SetRowCount;

      property Celda[Col,Row: Integer]: PCellProps read GetCells write SetCells;
      property Cols[Col: Integer]: PColRowProps read GetCols write SetCols;
      property Rows[Row: Integer]: PColRowProps read GetRows write SetRows;
  end;

  { TxGridColumnTitle }

  TxGridColumnTitle = class(TPersistent)
  private
    FColumn: TxGridColumn;
    FCaption: PChar;
    FColor: ^TColor;
    FAlignment: ^TAlignment;
    FFont: TFont;
    FImageIndex: Integer;

    FImageLayout: TButtonLayout;
    FIsDefaultTitleFont: boolean;
    FLayout: ^TTextLayout;
    FPrefixOption: TxPrefixOption;
    //**************
    FxCaption: PChar;
    FWordWrap: Boolean;
    FxImageIndex: Integer;
    FxWordWrap: Boolean;
    function GetxCaption: string;
    function IsxCaptionStored: Boolean;
    procedure SetWordWrap(AValue: Boolean);
    procedure SetxImageIndex(AValue: Integer);
    procedure SetxWordWrap(AValue: Boolean);
    //***********
    procedure FontChanged(Sender: TObject);
    function GetAlignment: TAlignment;
    function GetCaption: string;
    function GetColor: TColor;
    function GetFont: TFont;
    function GetLayout: TTextLayout;
    function IsAlignmentStored: boolean;
    function IsCaptionStored: boolean;
    function IsColorStored: boolean;
    function IsFontStored: boolean;
    function IsLayoutStored: boolean;
    procedure SetAlignment(const AValue: TAlignment);
    procedure SetColor(const AValue: TColor);
    procedure SetFont(const AValue: TFont);
    procedure SetImageIndex(const AValue: Integer);
    procedure SetImageLayout(const AValue: TButtonLayout);
    procedure SetLayout(const AValue: TTextLayout);
    procedure SetPrefixOption(const AValue: TxPrefixOption);
    property IsDefaultFont: boolean read FIsDefaultTitleFont;
  protected

    function  GetDefaultCaption: string; virtual;
    function  GetxDefaultCaption: string; virtual;
    function  GetDefaultAlignment: TAlignment;
    function  GetDefaultColor: TColor;
    function  GetDefaultLayout: TTextLayout;
    function  GetOwner: TPersistent; override;
    procedure SetCaption(const AValue: TCaption); virtual;
    procedure SetxCaption(const AValue: TCaption); virtual;
  public
    FOldImageIndex: Integer;
    FOldxImageIndex: Integer;
    constructor Create(TheColumn: TxGridColumn); virtual;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    procedure FillTitleDefaultFont;
    function IsDefault: boolean;
    property Column: TxGridColumn read FColumn;
  published
    property Alignment: TAlignment read GetAlignment write SetAlignment stored IsAlignmentStored;
    property Caption: TCaption read GetCaption write SetCaption stored IsCaptionStored;
    property Color: TColor read GetColor write SetColor stored IsColorStored;
    property Font: TFont read GetFont write SetFont stored IsFontStored;
    property ImageIndex: Integer read FImageIndex write SetImageIndex default -1;
    property xImageIndex: Integer read FxImageIndex write SetxImageIndex default -1;
    property ImageLayout: TButtonLayout read FImageLayout write SetImageLayout default blGlyphRight;
    property Layout: TTextLayout read GetLayout write SetLayout stored IsLayoutStored;
    property PrefixOption: TxPrefixOption read FPrefixOption write SetPrefixOption default poxNone;
    property xCaption: TCaption read GetxCaption write SetxCaption stored IsxCaptionStored;
    property WordWrap: Boolean read FWordWrap write SetWordWrap;
    property xWordWrap: Boolean read FxWordWrap write SetxWordWrap;
  end;

  { TxGridColumn }

  TxGridColumn = class(TCollectionItem)
  private
    FButtonStyle: TxColumnButtonStyle;
    FDropDownRows: Longint;
    FTitle: TxGridColumnTitle;
    FWidthChanged: boolean;
    FAlignment: ^TAlignment;
    FColor: ^TColor;
    FLayout: ^TTextLayout;
    FVisible: ^Boolean;
    FReadOnly: ^Boolean;
    FWidth: ^Integer;
    FFont: TFont;
    FisDefaultFont: Boolean;
    FPickList: TStrings;
    FMinSize, FMaxSize, FSizePriority: ^Integer;
    FValueChecked,FValueUnchecked: PChar;
    FCanShowEditor: Boolean;
    FTag: Integer;
    procedure FontChanged(Sender: TObject);
    function GetAlignment: TAlignment;
    function GetColor: TColor;
    function GetExpanded: Boolean;
    function GetFont: TFont;
    function GetGrid: TCustomXGrid;
    function GetLayout: TTextLayout;
    function GetMaxSize: Integer;
    function GetMinSize: Integer;
    function GetSizePriority: Integer;
    function GetReadOnly: Boolean;
    function GetVisible: Boolean;
    function GetWidth: Integer;
    function IsAlignmentStored: boolean;
    function IsCanShowEditorStored: Boolean;
    function IsColorStored: boolean;
    function IsFontStored: boolean;
    function IsLayoutStored: boolean;
    function IsMinSizeStored: boolean;
    function IsMaxSizeStored: boolean;
    function IsReadOnlyStored: boolean;
    function IsSizePriorityStored: boolean;
    function IsValueCheckedStored: boolean;
    function IsValueUncheckedStored: boolean;
    function IsVisibleStored: boolean;
    function IsWidthStored: boolean;
    procedure SetAlignment(const AValue: TAlignment);
    procedure SetButtonStyle(const AValue: TxColumnButtonStyle);
    procedure SetColor(const AValue: TColor);
    procedure SetExpanded(const AValue: Boolean);
    procedure SetFont(const AValue: TFont);
    procedure SetLayout(const AValue: TTextLayout);
    procedure SetMaxSize(const AValue: Integer);
    procedure SetMinSize(const Avalue: Integer);
    procedure SetPickList(const AValue: TStrings);
    procedure SetReadOnly(const AValue: Boolean);
    procedure SetSizePriority(const AValue: Integer);
    procedure SetTitle(const AValue: TxGridColumnTitle);
    procedure SetValueChecked(const AValue: string);
    procedure SetValueUnchecked(const AValue: string);
    procedure SetVisible(const AValue: Boolean);
    procedure SetWidth(const AValue: Integer);
  protected
    function  GetDisplayName: string; override;
    function  GetDefaultAlignment: TAlignment; virtual;
    function  GetDefaultColor: TColor; virtual;
    function  GetDefaultLayout: TTextLayout; virtual;
    function  GetDefaultMaxSize: Integer; virtual;
    function  GetDefaultMinSize: Integer; virtual;
    function  GetDefaultReadOnly: boolean; virtual;
    function  GetDefaultSizePriority: Integer;
    function  GetDefaultVisible: boolean; virtual;
    function  GetDefaultValueChecked: string; virtual;
    function  GetDefaultValueUnchecked: string; virtual;
    function  GetDefaultWidth: Integer; virtual;
    function  GetPickList: TStrings; virtual;
    function  GetValueChecked: string;
    function  GetValueUnchecked: string;
    procedure ColumnChanged; virtual;
    procedure AllColumnsChange;
    function  CreateTitle: TxGridColumnTitle; virtual;
    procedure SetIndex(Value: Integer); override;

    property  IsDefaultFont: boolean read FIsDefaultFont;
  public
    constructor Create(ACollection: TCollection); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    procedure FillDefaultFont;
    function  IsDefault: boolean; virtual;
    property Grid: TCustomXGrid read GetGrid;
    property WidthChanged: boolean read FWidthChanged;

  published
    property Alignment: TAlignment read GetAlignment write SetAlignment stored IsAlignmentStored;
    property ButtonStyle: TxColumnButtonStyle read FButtonStyle write SetButtonStyle default cbsxAuto;
    property Color: TColor read GetColor write SetColor stored IsColorStored;
    property DropDownRows: Longint read FDropDownRows write FDropDownRows default 7;
    property Expanded: Boolean read GetExpanded write SetExpanded default True;
    property Font: TFont read GetFont write SetFont stored IsFontStored;
    property Layout: TTextLayout read GetLayout write SetLayout stored IsLayoutStored;
    property MinSize: Integer read GetMinSize write SetMinSize stored IsMinSizeStored;
    property MaxSize: Integer read GetMaxSize write SetMaxSize stored isMaxSizeStored;
    property PickList: TStrings read GetPickList write SetPickList;
    property ReadOnly: Boolean read GetReadOnly write SetReadOnly stored IsReadOnlyStored;
    property SizePriority: Integer read GetSizePriority write SetSizePriority stored IsSizePriorityStored default 1;
    property Tag: Integer read FTag write FTag default 0;
    property Title: TxGridColumnTitle read FTitle write SetTitle;
    property Width: Integer read GetWidth write SetWidth stored IsWidthStored default DEFCOLWIDTH;
    property Visible: Boolean read GetVisible write SetVisible stored IsVisibleStored default true;
    property ValueChecked: string read GetValueChecked write SetValueChecked
      stored IsValueCheckedStored;
    property ValueUnchecked: string read GetValueUnchecked write SetValueUnchecked
      stored IsValueUncheckedStored;
    property CanShowEditor: Boolean read FCanShowEditor write FCanShowEditor stored IsCanShowEditorStored;
  end;

  TxGridPropertyBackup=record
    ValidData: boolean;
    FixedRowCount: Integer;
    FixedColCount: Integer;
    RowCount: Integer;
    ColCount: Integer;
  end;

  { TxGridColumns }

  TxGridColumns = class(TCollection)
  private
    FGrid: TCustomXGrid;
    function GetColumn(Index: Integer): TxGridColumn;
    function GetEnabled: Boolean;
    procedure SetColumn(Index: Integer; Value: TxGridColumn);
    function GetVisibleCount: Integer;
  protected
    function GetOwner: TPersistent; override;
    procedure Update(Item: TCollectionItem); override;
    procedure TitleFontChanged;
    procedure FontChanged;
    procedure RemoveColumn(Index: Integer);
    procedure MoveColumn(FromIndex,ToIndex: Integer); virtual;
    procedure ExchangeColumn(Index,WithIndex: Integer);
    procedure InsertColumn(Index: Integer);
  public
    constructor Create(AGrid: TCustomXGrid; aItemClass: TCollectionItemClass);
    function Add: TxGridColumn;
    procedure Clear;
    function RealIndex(Index: Integer): Integer;
    function IndexOf(Column: TxGridColumn): Integer;
    function IsDefault: boolean;
    function HasIndex(Index: Integer): boolean;
    function VisibleIndex(Index: Integer): Integer;
    property Grid: TCustomXGrid read FGrid;
    property Items[Index: Integer]: TxGridColumn read GetColumn write SetColumn; default;
    property VisibleCount: Integer read GetVisibleCount;
    property Enabled: Boolean read GetEnabled;
  end;

  type
    TxGridCoord = TPoint;
    TxGridRect  = TRect;

    TxSizingRec = record
      Index: Integer;
      OffIni,OffEnd: Integer;
      DeltaOff: Integer;
      PrevLine: boolean;
      PrevOffset: Integer;
    end;

    TxGridDataCache=record
      FixedWidth: Integer;    // Sum( Fixed ColsWidths[i] )
      FixedHeight: Integer;   // Sum( Fixed RowsHeights[i] )
      GridWidth: Integer;     // Sum( ColWidths[i] )
      GridHeight: Integer;    // Sum( RowHeights[i] )
      ClientWidth: Integer;   // Width-VertScrollbar.Size
      ClientHeight: Integer;  // Height-HorzScrollbar.Size
      ClientRect: TRect;      // Cache for ClientRect - GetBorderWidth need for Bidi
      ScrollWidth: Integer;   // ClientWidth-FixedWidth
      ScrollHeight: Integer;  // ClientHeight-FixedHeight
      VisibleGrid: TRect;     // Visible non fixed rectangle of cellcoordinates
      MaxClientXY: Tpoint;    // VisibleGrid.BottomRight (pixel) coordinates
      ValidRows: boolean;     // true if there are not fixed columns to show
      ValidCols: boolean;     // true if there are not fixed rows to show
      ValidGrid: boolean;     // true if there are not fixed cells to show
      AccumWidth: TList;      // Accumulated width per column
      AccumHeight: TList;     // Accumulated Height per row
      TLColOff,TLRowOff: Integer;   // TopLeft Offset in pixels
      MaxTopLeft: TPoint;     // Max Top left ( cell coorditates)
      HotCell: TPoint;        // currently hot cell
      HotCellPainted: boolean;// HotCell was already painter?
      HotGridZone: TxGridZone; // GridZone of last MouseMove
      ClickCell: TPoint;      // Cell coords of the latest mouse click
      ClickMouse: TPoint;     // mouse coords of the latest mouse click
      PushedCell: TPoint;     // Cell coords of cell being pushed
      PushedMouse: TPoint;    // mouse Coords of the cell being pushed
      ClickCellPushed: boolean;   // Header Cell is currently pushed?
      FullVisibleGrid: TRect; // visible cells excluding partially visible cells
      MouseCell: TPoint;      // Cell which contains the mouse
    end;

type

  { TCustomXGrid }

  TCustomXGrid=class(TCustomControl)
  private
    FAlternateColor: TColor;
    FAutoAdvance: TxAutoAdvance;
    FAutoEdit: boolean;
    FAutoFillColumns: boolean;
    FBorderColor: TColor;
    FDefaultDrawing: Boolean;
    FEditor: TWinControl;
    FEditorHidingCount: Integer;
    FEditorMode: Boolean;
    FEditorOldValue: string;
    FEditorShowing: Boolean;
    FEditorKey: Boolean;
    FEditorOptions: Integer;
    FExtendedSelect: boolean;
    FFastEditing: boolean;
    FAltColorStartNormal: boolean;
    FFlat: Boolean;
    FOnUserCheckboxBitmap: TUserCheckboxBitmapEvent;
    //FSortOrder: TxSortOrder;
    //FSortColumn: Integer;
    FImageList: TImageList;
    FTitleImageList: TImageList;
    FTitleStyle: TxTitleStyle;

    FOnCompareCells: TOnCompareCells;
    FGridLineStyle: TPenStyle;
    FGridLineWidth: Integer;
    FDefColWidth, FDefRowHeight: Integer;
    FCol,FRow, FFixedCols, FFixedRows: Integer;
    //FOnEditButtonClick: TNotifyEvent;
    FOnButtonClick: TOnSelectEvent;
    FOnPickListSelect: TNotifyEvent;
    FOnCheckboxToggled: TToggledCheckboxEvent;
    FOnPrepareCanvas: TOnPrepareCanvasEvent;
    FOnSelectEditor: TSelectEditorEvent;
    FOnValidateEntry: TValidateEntryEvent;
    FGridLineColor: TColor;
    FFixedcolor, FFixedHotColor, FFocusColor, FSelectedColor: TColor;
    FSelectedUnfocusedColor: TColor;
    FFocusRectVisible: boolean;
    FCols,FRows: TList;
    FsaveOptions: TxSaveOptions;
    FScrollBars: TScrollStyle;
    FSelectActive: Boolean;
    FTopLeft: TPoint;
    FPivot: TPoint;
    FRange: TRect;
    FDragDx: Integer;
    FMoveLast: TPoint;
    FUpdateCount: Integer;
    FGCache: TxGridDataCache;
    FOptions: TxGridOptions;
    FOnDrawCell: TOnDrawcell;
    FOnBeforeSelection: TOnSelectEvent;
    FOnSelection: TOnSelectEvent;
    FOnTopLeftChanged: TNotifyEvent;
    FUseXORFeatures: boolean;
    FVSbVisible, FHSbVisible: boolean;
    FDefaultTextStyle: TTextStyle;
    FLastWidth: Integer;
    FTitleFont, FLastFont: TFont;
    FTitleFontIsDefault: boolean;
    FColumns: TxGridColumns;
    FButtonEditor: TxButtonCellEditor;
    FStringEditor: TxStringCellEditor;
    FButtonStringEditor: TxCompositeCellEditor;
    FPickListEditor: TxPickListCellEditor;
    FExtendedColSizing: boolean;
    FExtendedRowSizing: boolean;
    FUpdatingAutoFillCols: boolean;
    FGridBorderStyle: TBorderStyle;
    FGridFlags: TxGridFlags;
    FGridPropBackup: TxGridPropertyBackup;
    //FStrictSort: boolean;
    FIgnoreClick: boolean;
    FAllowOutboundEvents: boolean;
    FColumnClickSorts: boolean;
    FHeaderHotZones: TxGridZoneSet;
    FHeaderPushZones: TxGridZoneSet;
    FCheckedBitmap, FUnCheckedBitmap, FGrayedBitmap: TBitmap;
    FSavedCursor: TCursor;
    FSizing: TxSizingRec;
    FRowAutoInserted: Boolean;
    FMouseWheelOption: TxMouseWheelOption;
    FSavedHint: String;
    FCellHintPriority: TxCellHintPriority;
    FOnGetCellHint: TGetCellHintEvent;
    FAscImgInd: Integer;
    FDescImgInd: Integer;
    FRowHighLightColor: TColor;
    procedure AdjustCount(IsColumn:Boolean; OldValue, NewValue:Integer);
    procedure CacheVisibleGrid;
    procedure CancelSelection;
    procedure CheckFixedCount(aCol,aRow,aFCol,aFRow: Integer);
    procedure CheckCount(aNewColCount, aNewRowCount: Integer; FixEditor: boolean=true);
    procedure CheckIndex(IsColumn: Boolean; Index: Integer);
    function  CheckTopLeft(aCol,aRow: Integer; CheckCols,CheckRows: boolean): boolean;
    function  IsCellButtonColumn(ACell: TPoint): boolean;
    function  GetSelectedColumn: TxGridColumn;
    function  IsDefRowHeightStored: boolean;
    function  IsImageListStored: boolean;
    function  IsTitleImageListStored: boolean;
    procedure SetAlternateColor(const AValue: TColor);
    procedure SetAutoFillColumns(const AValue: boolean);
    procedure SetBorderColor(const AValue: TColor);
    //procedure SetColumnClickSorts(const AValue: boolean);
    procedure SetColumns(const AValue: TxGridColumns);
    procedure SetEditorOptions(const AValue: Integer);
    procedure SetEditorBorderStyle(const AValue: TBorderStyle);
    procedure SetAltColorStartNormal(const AValue: boolean);
    procedure SetFlat(const AValue: Boolean);
    procedure SetFocusRectVisible(const AValue: Boolean);
    procedure SetImageList(const AValue: TImageList);
    procedure SetRowHighLightColor(AValue: TColor);
    procedure SetSelectedUnfocusedColor(AValue: TColor);
    procedure SetTitleImageList(const AValue: TImageList);
    procedure SetTitleFont(const AValue: TFont);
    procedure SetTitleStyle(const AValue: TxTitleStyle);
    procedure SetUseXorFeatures(const AValue: boolean);
    function  doColSizing(X,Y: Integer): Boolean;
    function  doRowSizing(X,Y: Integer): Boolean;
    procedure doColMoving(X,Y: Integer);
    procedure doRowMoving(X,Y: Integer);
    procedure doTopleftChange(DimChg: Boolean);
    procedure DrawXORVertLine(X: Integer);
    procedure DrawXORHorzLine(Y: Integer);
    function  EditorCanProcessKey(var Key: TUTF8Char): boolean;

    procedure EditorPos;
    procedure EditorShowChar(Ch: TUTF8Char);
    procedure EditorSetMode(const AValue: Boolean);
    procedure EditorSetValue;
    function  EditorAlwaysShown: Boolean;
    procedure FixPosition(IsColumn: Boolean; aIndex: Integer);
    function  GetLeftCol: Integer;
    function  GetColCount: Integer;
    function  GetColWidths(Acol: Integer): Integer;
    function  GetColumns: TxGridColumns;
    function  GetEditorBorderStyle: TBorderStyle;
    function  GetBorderWidth: Integer;
    function  GetRowCount: Integer;
    function  GetRowHeights(Arow: Integer): Integer;
    function  GetSelection: TxGridRect;
    function  GetTopRow: Longint;
    function  GetVisibleColCount: Integer;
    function  GetVisibleGrid: TRect;
    function  GetVisibleRowCount: Integer;
    procedure HeadersMouseMove(const X,Y:Integer);
    procedure InternalAutoFillColumns;
    function  InternalNeedBorder: boolean;
    procedure InternalSetColWidths(aCol,aValue: Integer);
    procedure InternalUpdateColumnWidths;
    procedure InvalidateMovement(DCol,DRow: Integer; OldRange: TRect);
    function  IsAltColorStored: boolean;
    function  IsColumnsStored: boolean;
    function  IsPushCellActive: boolean;
    procedure LoadColumns(cfg: TXMLConfig; Version: integer);
    function  LoadResBitmapImage(const ResName: string): TBitmap;
    procedure OnTitleFontChanged(Sender: TObject);
    procedure ReadColumns(Reader: TReader);
    procedure ReadColWidths(Reader: TReader);
    procedure ReadRowHeights(Reader: TReader);
    procedure ResetHotCell;
    procedure ResetPushedCell(ResetColRow: boolean=True);
    procedure SaveColumns(cfg: TXMLConfig; Version: integer);
    function  ScrollToCell(const aCol,aRow: Integer; wResetOffs: boolean): Boolean;
    function  ScrollGrid(Relative:Boolean; DCol,DRow: Integer): TPoint;
    procedure SetCol(AValue: Integer);
    procedure SetColwidths(Acol: Integer; Avalue: Integer);
    procedure SetRawColWidths(ACol: Integer; AValue: Integer);
    procedure SetColCount(AValue: Integer);
    procedure SetDefColWidth(AValue: Integer);
    procedure SetDefRowHeight(AValue: Integer);
    procedure SetDefaultDrawing(const AValue: Boolean);
    procedure SetEditor(AValue: TWinControl);
    procedure SetFixedRows(const AValue: Integer);
    procedure SetFocusColor(const AValue: TColor);
    procedure SetGridLineColor(const AValue: TColor);
    procedure SetGridLineStyle(const AValue: TPenStyle);
    procedure SetGridLineWidth(const AValue: Integer);
    procedure SetLeftCol(const AValue: Integer);
    procedure SetOptions(const AValue: TxGridOptions);
    procedure SetRow(AValue: Integer);
    procedure SetRowCount(AValue: Integer);
    procedure SetRowheights(Arow: Integer; Avalue: Integer);
    procedure SetScrollBars(const AValue: TScrollStyle);
    procedure SetSelectActive(const AValue: Boolean);
    procedure SetSelection(const AValue: TxGridRect);
    procedure SetTopRow(const AValue: Integer);
    function  StartColSizing(const X, Y: Integer): boolean;
    procedure ChangeCursor(ACursor: Integer = MAXINT);
    procedure TryScrollTo(aCol,aRow: integer);
    procedure UpdateCachedSizes;
    procedure UpdateSBVisibility;
    procedure UpdateSizes;
    procedure WriteColumns(Writer: TWriter);
    procedure WriteColWidths(Writer: TWriter);
    procedure WriteRowHeights(Writer: TWriter);
    procedure WMEraseBkgnd(var message: TLMEraseBkgnd); message LM_ERASEBKGND;
    procedure WMGetDlgCode(var Msg: TLMNoParams); message LM_GETDLGCODE;
    procedure WMChar(var message: TLMChar); message LM_CHAR;
  protected
    fGridState: TxGridState;

    class procedure WSRegisterClass; override;
    function  EditorGetValue(validate:boolean=false): boolean;
    procedure AdjustEditorBounds(NewCol,NewRow:Integer); virtual;
    procedure AssignTo(Dest: TPersistent); override;
    procedure AutoAdjustColumn(aCol: Integer); virtual;
    procedure BeforeMoveSelection(const DCol,DRow: Integer); virtual;
    function  BoxRect(ALeft,ATop,ARight,ABottom: Longint): TRect;
    procedure CacheMouseDown(const X,Y:Integer);
    procedure CalcAutoSizeColumn(const Index: Integer; var AMin,AMax,APriority: Integer); virtual;
    procedure CalcFocusRect(var ARect: TRect);
    function  CalcMaxTopLeft: TPoint;
    procedure CalcScrollbarsRange;
    function  CanEditShow: Boolean; virtual;
    function  CanGridAcceptKey(Key: Word; Shift: TShiftState): Boolean; virtual;
    procedure CellClick(const aCol,aRow: Integer; const Button:TMouseButton; P: TPoint); virtual;
    procedure CheckLimits(var aCol,aRow: Integer);
    procedure CheckLimitsWithError(const aCol, aRow: Integer);
    procedure CMBiDiModeChanged(var Message: TLMessage); message CM_BIDIMODECHANGED;
    procedure CMMouseEnter(var Message: TLMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message :TLMessage); message CM_MouseLeave;
    procedure ColRowDeleted(IsColumn: Boolean; index: Integer); virtual;
    procedure ColRowExchanged(IsColumn: Boolean; index,WithIndex: Integer); virtual;
    procedure ColRowInserted(IsColumn: boolean; index: integer); virtual;
    procedure ColRowMoved(IsColumn: Boolean; FromIndex,ToIndex: Integer); virtual;
    function  ColRowToOffset(IsCol, Relative: Boolean; Index:Integer;
                             var StartPos, EndPos: Integer): Boolean;
    function  ColumnIndexFromGridColumn(Column: Integer): Integer;
    function  ColumnFromGridColumn(Column: Integer): TxGridColumn;
    procedure ColumnsChanged(aColumn: TxGridColumn);
    procedure ColWidthsChanged; virtual;
    function  CreateColumns: TxGridColumns; virtual;
    procedure CheckNewCachedSizes(var AGCache:TxGridDataCache); virtual;
    procedure CreateWnd; override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure Click; override;
    procedure DblClick; override;
    procedure DefineProperties(Filer: TFiler); override;
    procedure DestroyHandle; override;
    //function  DialogChar(var Message: TLMKey): boolean; override;
    //function  DoCompareCells(Acol,ARow,Bcol,BRow: Integer): Integer; virtual;
    procedure DoCopyToClipboard; virtual;
    procedure DoCutToClipboard; virtual;
    procedure DoEditButtonClick(const ACol,ARow: Integer); virtual;
    procedure DoEditorHide; virtual;
    procedure DoEditorShow; virtual;
    procedure DoExit; override;
    procedure DoEnter; override;
    function  DoMouseWheel(Shift: TShiftState; WheelDelta: Integer; MousePos: TPoint): Boolean; override;
    function  DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    function  DoMouseWheelUp(Shift: TShiftState; MousePos: TPoint): Boolean; override;
    procedure DoOnChangeBounds; override;
    procedure DoOPDeleteColRow(IsColumn: Boolean; index: Integer);
    procedure DoOPExchangeColRow(IsColumn: Boolean; index, WithIndex: Integer);
    procedure DoOPInsertColRow(IsColumn: boolean; index: integer);
    procedure DoOPMoveColRow(IsColumn: Boolean; FromIndex, ToIndex: Integer);
    procedure DoPasteFromClipboard; virtual;
    procedure DoPrepareCanvas(aCol,aRow:Integer; aState: TxGridDrawState); virtual;
    procedure DoSetBounds(ALeft, ATop, AWidth, AHeight: integer); override;
    function  DoUTF8KeyPress(var UTF8Key: TUTF8Char): boolean; override;
    procedure DrawBorder;
    procedure DrawAllRows; virtual;
    procedure DrawFillRect(aCanvas:TCanvas; R:TRect);// Use FillRect after calc the new rect depened on Right To Left
    procedure DrawCell(aCol,aRow:Integer; aRect:TRect; aState:TxGridDrawState); virtual;
    procedure DrawCellGrid(aCol,aRow: Integer; aRect: TRect; aState: TxGridDrawState); virtual;
    procedure DrawTextInCell(aCol,aRow: Integer; aRect: TRect; aState: TxGridDrawState); virtual;
    procedure DrawThemedCell(aCol,aRow: Integer; aRect: TRect; aState: TxGridDrawState);
    procedure DrawCellText(aCol,aRow: Integer; aRect: TRect; aState: TxGridDrawState; aText: String); virtual;
    procedure DrawGridCheckboxBitmaps(const aCol,aRow: Integer; const aRect: TRect;
                                        const aState: TCheckboxState); virtual;
    procedure DrawButtonCell(const aCol,aRow: Integer; aRect: TRect; const aState:TxGridDrawState);
    procedure DrawColRowMoving;
    procedure DrawColumnText(aCol,aRow: Integer; aRect: TRect; aState:TxGridDrawState); virtual;
    procedure DrawColumnTitleImage(var ARect: TRect; AColumnIndex: Integer; AIndex: Integer);
    procedure DrawEdges;
    procedure DrawFocusRect(aCol,aRow:Integer; ARect:TRect); virtual;
    procedure DrawRow(aRow: Integer); virtual;
    procedure EditButtonClicked(Sender: TObject);
    procedure EditordoGetValue; virtual;
    procedure EditordoSetValue; virtual;
    function  EditorCanAcceptKey(const ch: TUTF8Char): boolean; virtual;
    function  EditorIsReadOnly: boolean; virtual;
    procedure EditorHide; virtual;
    function  EditorLocked: boolean;
    Function  EditingAllowed(ACol : Integer = -1) : Boolean; virtual; // Returns true if grid and current column allow editing
    procedure EditorSelectAll;
    procedure EditorShow(const SelAll: boolean); virtual;
    procedure EditorShowInCell(const aCol,aRow:Integer); virtual;
    procedure EditorTextChanged(const aCol,aRow: Integer; const aText:string); virtual;
    procedure EditorWidthChanged(aCol,aWidth: Integer); virtual;
    function  FirstGridColumn: integer; virtual;
    function  FixedGrid: boolean;
    procedure FontChanged(Sender: TObject); override;
    procedure GetAutoFillColumnInfo(const Index: Integer; var aMin,aMax,aPriority: Integer); virtual;
    function  GetCellHintText(ACol, ARow: Integer): string; virtual;
    function  GetCells(ACol, ARow: Integer): string; virtual;
    function  GetColumnAlignment(Column: Integer; ForTitle: Boolean): TAlignment;
    function  GetColumnColor(Column: Integer; ForTitle: Boolean): TColor;
    function  GetColumnFont(Column: Integer; ForTitle: Boolean): TFont;
    function  GetColumnLayout(Column: Integer; ForTitle: boolean): TTextLayout;
    function  GetColumnReadonly(Column: Integer): boolean;
    function  GetColumnTitle(Column: Integer): string;
    function  GetColumnWidth(Column: Integer): Integer;
    function  GetDeltaMoveNext(const Inverse: boolean; var ACol,ARow: Integer): boolean; virtual;
    function  GetDefaultColumnAlignment(Column: Integer): TAlignment; virtual;
    function  GetDefaultColumnWidth(Column: Integer): Integer; virtual;
    function  GetDefaultColumnLayout(Column: Integer): TTextLayout; virtual;
    function  GetDefaultColumnReadOnly(Column: Integer): boolean; virtual;
    function  GetDefaultColumnTitle(Column: Integer): string; virtual;
    function  GetDefaultEditor(Column: Integer): TWinControl; virtual;
    function  GetDefaultRowHeight: integer; virtual;
    function  GetGridDrawState(ACol, ARow: Integer): TxGridDrawState;
    function  GetImageForCheckBox(const aCol,aRow: Integer;
                                  CheckBoxView: TCheckBoxState): TBitmap; virtual;
    function  GetScrollBarPosition(Which: integer): Integer;
    procedure GetSBVisibility(out HsbVisible,VsbVisible:boolean);virtual;
    procedure GetSBRanges(const HsbVisible,VsbVisible: boolean;
                  out HsbRange,VsbRange,HsbPage,VsbPage,HsbPos,VsbPos:Integer); virtual;
    procedure GetSelectedState(AState: TxGridDrawState; out IsSelected:boolean); virtual;
    function  GetEditMask(ACol, ARow: Longint): string; virtual;
    function  GetEditText(ACol, ARow: Longint): string; virtual;
    function  GetFixedcolor: TColor; virtual;
    function  GetFirstVisibleColumn: Integer;
    function  GetFirstVisibleRow: Integer;
    function  GetLastVisibleColumn: Integer;
    function  GetLastVisibleRow: Integer;
    function  GetSelectedColor: TColor; virtual;
    function  GetTitleShowPrefix(Column: Integer): boolean;
    function  GetTruncCellHintText(ACol, ARow: Integer): string; virtual;
    function  GridColumnFromColumnIndex(ColumnIndex: Integer): Integer;
    procedure GridMouseWheel(shift: TShiftState; Delta: Integer); virtual;
    procedure HeaderClick(IsColumn: Boolean; index: Integer; P: TPoint); virtual;
    procedure HeaderSized(IsColumn: Boolean; index: Integer); virtual;
    procedure HeaderSizing(const IsColumn:boolean; const AIndex,ASize:Integer); virtual;
    procedure HideCellHintWindow;
    procedure InternalSetColCount(ACount: Integer);
    procedure InvalidateCell(aCol, aRow: Integer; Redraw: Boolean); overload;
    procedure InvalidateFromCol(ACol: Integer);
    procedure InvalidateGrid;
    procedure InvalidateFocused;
    function  GetIsCellTitle(aCol,aRow: Integer): boolean; virtual;
    function  GetIsCellSelected(aCol, aRow: Integer): boolean; virtual;
    procedure KeyDown(var Key : Word; Shift : TShiftState); override;
    procedure KeyUp(var Key : Word; Shift : TShiftState); override;
    procedure LoadContent(cfg: TXMLConfig; Version: Integer); virtual;
    procedure Loaded; override;
    procedure LockEditor;
    function  MouseButtonAllowed(Button: TMouseButton): boolean; virtual;
    procedure MouseDown(Button: TMouseButton; Shift:TShiftState; X,Y:Integer); override;
    procedure MouseMove(Shift: TShiftState; X,Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift:TShiftState; X,Y:Integer); override;
    function  MoveExtend(Relative: Boolean; DCol, DRow: Integer): Boolean;
    function  MoveNextAuto(const Inverse: boolean): boolean;
    function  MoveNextSelectable(Relative:Boolean; DCol, DRow: Integer): Boolean;
    procedure MoveSelection; virtual;
    function  OffsetToColRow(IsCol,Fisical:Boolean; Offset:Integer;
                             var Index,Rest:Integer): boolean;
    procedure Paint; override;
    procedure PickListItemSelected(Sender: TObject);
    function RowHighLightUse: Boolean; virtual;
    procedure DoRowHighLight(aCol,aRow: Integer; aState:TxGridDrawState); virtual;
    procedure PrepareCanvas(aCol,aRow: Integer; aState:TxGridDrawState); virtual;
    procedure PrepareCellHints(ACol, ARow: Integer); virtual;
    procedure ResetEditor;
    procedure ResetOffset(chkCol, ChkRow: Boolean);
    procedure ResetSizes; virtual;
    procedure ResizeColumn(aCol, aWidth: Integer);
    procedure ResizeRow(aRow, aHeight: Integer);
    procedure RowHeightsChanged; virtual;
    procedure SaveContent(cfg: TXMLConfig); virtual;
    procedure ScrollBarRange(Which:Integer; aRange,aPage,aPos: Integer);
    procedure ScrollBarPosition(Which, Value: integer);
    function  ScrollBarIsVisible(Which:Integer): Boolean;
    procedure ScrollBarPage(Which: Integer; aPage: Integer);
    procedure ScrollBarShow(Which: Integer; aValue: boolean);
    function  ScrollBarAutomatic(Which: TScrollStyle): boolean; virtual;
    procedure SelectEditor; virtual;
    function  SelectCell(ACol, ARow: Integer): Boolean; virtual;
    procedure SetCanvasFont(aFont: TFont);
    procedure SetColor(Value: TColor); override;
    procedure SetColRow(const ACol,ARow: Integer);
    procedure SetEditText(ACol, ARow: Longint; const Value: string); virtual;
    procedure SetBorderStyle(NewStyle: TBorderStyle); override;
    procedure SetFixedcolor(const AValue: TColor); virtual;
    procedure SetFixedCols(const AValue: Integer); virtual;
    procedure SetSelectedColor(const AValue: TColor); virtual;
    procedure ShowCellHintWindow(APoint: TPoint);
    procedure SizeChanged(OldColCount, OldRowCount: Integer); virtual;
    //procedure Sort(ColSorting: Boolean; index,IndxFrom,IndxTo:Integer); virtual;
    procedure TopLeftChanged; virtual;
    function  TryMoveSelection(Relative: Boolean; var DCol, DRow: Integer): Boolean;
    procedure UnLockEditor;
    procedure UnprepareCellHints; virtual;
    procedure UpdateHorzScrollBar(const aVisible: boolean; const aRange,aPage,aPos: Integer); virtual;
    procedure UpdateSelectionRange;
    procedure UpdateVertScrollbar(const aVisible: boolean; const aRange,aPage,aPos: Integer); virtual;
    procedure UpdateBorderStyle;
    function  ValidateEntry(const ACol,ARow:Integer; const OldValue:string; var NewValue:string): boolean; virtual;
    procedure VisualChange; virtual;
    procedure WMHScroll(var message : TLMHScroll); message LM_HSCROLL;
    procedure WMVScroll(var message : TLMVScroll); message LM_VSCROLL;
    procedure WMKillFocus(var message: TLMKillFocus); message LM_KILLFOCUS;
    procedure WMSetFocus(var message: TLMSetFocus); message LM_SETFOCUS;
    procedure WndProc(var TheMessage : TLMessage); override;

    property AllowOutboundEvents: boolean read FAllowOutboundEvents write FAllowOutboundEvents default true;
    property AlternateColor: TColor read FAlternateColor write SetAlternateColor stored IsAltColorStored;
    property AutoAdvance: TxAutoAdvance read FAutoAdvance write FAutoAdvance default aaRight;
    property AutoEdit: boolean read FAutoEdit write FAutoEdit default true;
    property AutoFillColumns: boolean read FAutoFillColumns write SetAutoFillColumns default false;
    property BorderStyle:TBorderStyle read FGridBorderStyle write SetBorderStyle default bsSingle;
    property BorderColor: TColor read FBorderColor write SetBorderColor default cl3DDKShadow;
    property CellHintPriority: TxCellHintPriority read FCellHintPriority write FCellHintPriority default chpxTruncOnly;

    property ColCount: Integer read GetColCount write SetColCount default 5;
    //property ColumnClickSorts: boolean read FColumnClickSorts write SetColumnClickSorts default false;
    property Columns: TxGridColumns read GetColumns write SetColumns stored IsColumnsStored;
    property ColWidths[aCol: Integer]: Integer read GetColWidths write SetColWidths;
    property DefaultColWidth: Integer read FDefColWidth write SetDefColWidth default DEFCOLWIDTH;
    property DefaultRowHeight: Integer read FDefRowHeight write SetDefRowHeight stored IsDefRowHeightStored;
    property DefaultDrawing: Boolean read FDefaultDrawing write SetDefaultDrawing default True;
    property DefaultTextStyle: TTextStyle read FDefaultTextStyle write FDefaultTextStyle;
    property DragDx: Integer read FDragDx write FDragDx;
    property Editor: TWinControl read FEditor write SetEditor;
    property EditorBorderStyle: TBorderStyle read GetEditorBorderStyle write SetEditorBorderStyle;
    property EditorMode: Boolean read FEditorMode write EditorSetMode;
    property EditorKey: boolean read FEditorKey write FEditorKey;
    property EditorOptions: Integer read FEditorOptions write SetEditorOptions;
    property EditorShowing: boolean read FEditorShowing write FEditorShowing;
    property ExtendedColSizing: boolean read FExtendedColSizing write FExtendedColSizing;
    property ExtendedRowSizing: boolean read FExtendedRowSizing write FExtendedRowSizing;
    property ExtendedSelect: boolean read FExtendedSelect write FExtendedSelect default true;
    property FastEditing: boolean read FFastEditing write FFastEditing;
    property AltColorStartNormal: boolean read FAltColorStartNormal write SetAltColorStartNormal;
    property FixedCols: Integer read FFixedCols write SetFixedCols default 1;
    property FixedRows: Integer read FFixedRows write SetFixedRows default 1;
    property FixedColor: TColor read GetFixedColor write SetFixedcolor default clBtnFace;
    property FixedHotColor: TColor read FFixedHotColor write FFixedHotColor default cl3DLight;
    property Flat: Boolean read FFlat write SetFlat default false;
    property FocusColor: TColor read FFocusColor write SetFocusColor;
    property FocusRectVisible: Boolean read FFocusRectVisible write SetFocusRectVisible;
    property GCache: TxGridDataCache read FGCAChe;
    property GridFlags: TxGridFlags read FGridFlags write FGridFlags;
    property GridHeight: Integer read FGCache.GridHeight;
    property GridLineColor: TColor read FGridLineColor write SetGridLineColor default clSilver;
    property GridLineStyle: TPenStyle read FGridLineStyle write SetGridLineStyle;
    property GridLineWidth: Integer read FGridLineWidth write SetGridLineWidth default 1;
    property GridWidth: Integer read FGCache.GridWidth;
    property HeaderHotZones: TxGridZoneSet read FHeaderHotZones write FHeaderHotZones default [xgzFixedCols];
    property HeaderPushZones: TxGridZoneSet read FHeaderPushZones write FHeaderPushZones default [xgzFixedCols];

    property InplaceEditor: TWinControl read FEditor;
    property IsCellSelected[aCol,aRow: Integer]: boolean read GetIsCellSelected;
    property LeftCol:Integer read GetLeftCol write SetLeftCol;
    property MouseWheelOption: TxMouseWheelOption read FMouseWheelOption write FMouseWheelOption default mwxCursor;
    property Options: TxGridOptions read FOptions write SetOptions default
      [xgoFixedVertLine, xgoFixedHorzLine, xgoVertLine, xgoHorzLine, xgoRangeSelect,
       xgoSmoothScroll ];

    property RowCount: Integer read GetRowCount write SetRowCount default 5;
    property RowHeights[aRow: Integer]: Integer read GetRowHeights write SetRowHeights;
    property SaveOptions: TxSaveOptions read FsaveOptions write FSaveOptions;
    property SelectActive: Boolean read FSelectActive write SetSelectActive;
    property SelectedColor: TColor read GetSelectedColor write SetSelectedColor;
    property SelectedColumn: TxGridColumn read GetSelectedColumn;
    property Selection: TxGridRect read GetSelection write SetSelection;
    property ScrollBars: TScrollStyle read FScrollBars write SetScrollBars default ssAutoBoth;
    //property StrictSort: boolean read FStrictSort write FStrictSort;
    property TitleFont: TFont read FTitleFont write SetTitleFont;
    property TitleStyle: TxTitleStyle read FTitleStyle write SetTitleStyle default tsxLazarus;
    property TopRow: Integer read GetTopRow write SetTopRow;
    property UseXORFeatures: boolean read FUseXORFeatures write SetUseXorFeatures default false;
    property VisibleColCount: Integer read GetVisibleColCount stored false;
    property VisibleRowCount: Integer read GetVisibleRowCount stored false;

    property OnBeforeSelection: TOnSelectEvent read FOnBeforeSelection write FOnBeforeSelection;
    property OnCheckboxToggled: TToggledcheckboxEvent read FOnCheckboxToggled write FOnCheckboxToggled;
    property OnCompareCells: TOnCompareCells read FOnCompareCells write FOnCompareCells;
    property OnPrepareCanvas: TOnPrepareCanvasEvent read FOnPrepareCanvas write FOnPrepareCanvas;
    property OnDrawCell: TOnDrawCell read FOnDrawCell write FOnDrawCell;
    // Deprecated in favor of OnButtonClick.
    //property OnEditButtonClick: TNotifyEvent read FOnEditButtonClick write FOnEditButtonClick; deprecated;
    property OnButtonClick: TOnSelectEvent read FOnButtonClick write FOnButtonClick;
    property OnPickListSelect: TNotifyEvent read FOnPickListSelect write FOnPickListSelect;
    property OnSelection: TOnSelectEvent read fOnSelection write fOnSelection;
    property OnSelectEditor: TSelectEditorEvent read FOnSelectEditor write FOnSelectEditor;
    property OnTopLeftChanged: TNotifyEvent read FOnTopLeftChanged write FOnTopLeftChanged;
    property OnUserCheckboxBitmap: TUserCheckboxBitmapEvent read FOnUserCheckboxBitmap write FOnUserCheckboxBitmap;
    property OnValidateEntry: TValidateEntryEvent read FOnValidateEntry write FOnValidateEntry;
    //Bidi functions
    function FlipRect(ARect: TRect): TRect;
    function FlipPoint(P: TPoint): TPoint;
    function FlipX(X: Integer): Integer;
    // Hint-related
    property OnGetCellHint : TGetCellHintEvent read FOnGetCellHint write FOnGetCellHint;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Invalidate; override;
    procedure EditingDone; override;

    { Exposed procs }
    procedure AutoAdjustColumns;
    procedure BeginUpdate;
    function  CellRect(ACol, ARow: Integer): TRect;
    function EditorRect(aCol, aRow: Integer): TRect; virtual;
    function  CellToGridZone(aCol,aRow: Integer): TxGridZone;
    procedure CheckPosition;
    procedure Clear;

    function  EditorByStyle(Style: TxColumnButtonStyle): TWinControl; virtual;
    procedure EditorKeyDown(Sender: TObject; var Key:Word; Shift:TShiftState);
    procedure EditorKeyPress(Sender: TObject; var Key: Char);
    procedure EditorKeyUp(Sender: TObject; var key:Word; shift:TShiftState);
    procedure EndUpdate(aRefresh: boolean = true);
    procedure EraseBackground(DC: HDC); override;

    procedure InvalidateCell(aCol, aRow: Integer); overload;
    procedure InvalidateCol(ACol: Integer);
    procedure InvalidateRange(const aRange: TRect);
    procedure InvalidateRow(ARow: Integer);
    function  IscellVisible(aCol, aRow: Integer): Boolean;
    function  IsFixedCellVisible(aCol, aRow: Integer): boolean;
    procedure LoadFromFile(FileName: string);
    function  MouseCoord(X,Y: Integer): TxGridCoord;
    function  MouseToCell(const Mouse: TPoint): TPoint; overload;
    procedure MouseToCell(X,Y: Integer; var ACol,ARow: Longint); overload;
    function  MouseToLogcell(Mouse: TPoint): TPoint;
    function  MouseToGridZone(X,Y: Integer): TxGridZone;
    procedure SaveToFile(FileName: string);
    procedure SetFocus; override;

    //property SortOrder: TxSortOrder read FSortOrder write FSortOrder;
    property TabStop default true;
    property ImageList: TImageList read FImageList write SetImageList;
    property TitleImageList: TImageList read FTitleImageList write SetTitleImageList;
    property AscImgInd: Integer read FAscImgInd write FAscImgInd;
    property Col: Integer read FCol write SetCol;
    property DescImgInd: Integer read FDescImgInd write FDescImgInd;
    property Row: Integer read FRow write SetRow;
    property RowHighLightColor: TColor read FRowHighLightColor write SetRowHighLightColor;
    property SelectedUnfocusedColor: TColor read FSelectedUnfocusedColor write SetSelectedUnfocusedColor;
  end;

  TGetEditEvent = procedure (Sender: TObject; ACol, ARow: Integer; var Value: string) of object;
  TSetEditEvent = procedure (Sender: TObject; ACol, ARow: Integer; const Value: string) of object;
  TGetCheckboxStateEvent = procedure (Sender: TObject; ACol, ARow: Integer; var Value: TCheckboxState) of object;
  TSetCheckboxStateEvent = procedure (Sender: TObject; ACol, ARow: Integer; const Value: TCheckboxState) of object;


procedure DrawRubberRect(Canvas: TCanvas; aRect: TRect; Color: TColor);
function  GetWorkingCanvas(const Canvas: TCanvas): TCanvas;
procedure FreeWorkingCanvas(canvas: TCanvas);

implementation

uses
  WSXGrids, LazUTF8;

{$WARN SYMBOL_DEPRECATED OFF}
{$IFDEF FPC_HAS_CPSTRING}
  {$WARN IMPLICIT_STRING_CAST OFF}
  {$WARN IMPLICIT_STRING_CAST_LOSS OFF}
{$ENDIF}

function BidiFlipX(X: Integer; const Width: Integer; const Flip: Boolean): Integer;
begin
  if Flip then
    //-1 because it zero based
    Result := Width - X - 1
  else
    Result := X;
end;

function BidiFlipX(X: Integer; const ParentRect: TRect; const Flip: Boolean): Integer;
begin
  Result := BidiFlipX(X, ParentRect.Right, Flip);
end;

function BidiFlipPoint(P: TPoint; const ParentRect: TRect; const Flip: Boolean): TPoint;
begin
  Result := P;
  Result.Y := BidiFlipX(Result.Y, ParentRect, Flip);
end;
  
function PointIgual(const P1,P2: TPoint): Boolean;
begin
  result:=(P1.X=P2.X)and(P1.Y=P2.Y);
end;

function NormalizarRect(const R:TRect): TRect;
begin
  Result.Left:=Min(R.Left, R.Right);
  Result.Top:=Min(R.Top, R.Bottom);
  Result.Right:=Max(R.Left, R.Right);
  Result.Bottom:=Max(R.Top, R.Bottom);
end;

procedure SwapInt(var I1,I2: Integer);
var
  Tmp: Integer;
begin
  Tmp:=I1;
  I1:=I2;
  I2:=Tmp;
end;

{$ifdef GridTraceMsg}
function TransMsg(const S: String; const TheMsg: TLMessage): String;
begin
  case TheMsg.Msg of
    CM_BASE..CM_MOUSEWHEEL:
      case TheMsg.Msg of
        CM_MOUSEENTER:            exit; //Result := 'CM_MOUSEENTER';
        CM_MOUSELEAVE:            exit; //Result := 'CM_MOUSELEAVE';
        CM_TEXTCHANGED:           Result := 'CM_TEXTCHANGED';
        CM_UIACTIVATE:            Result := 'CM_UIACTIVATE';
        CM_CONTROLLISTCHANGE:     Result := 'CM_CONTROLLISTCHANGE';

        CM_PARENTCOLORCHANGED:    Result := 'CM_PARENTCOLORCHANGED';
        CM_PARENTSHOWHINTCHANGED: Result := 'CM_PARENTSHOWHINTCHANGED';
        CM_PARENTBIDIMODECHANGED: Result := 'CM_PARENTBIDIMODECHANGED';
        CM_CONTROLCHANGE:         Result := 'CM_CONTROLCHANGE';
        CM_SHOWINGCHANGED:        Result := 'CM_SHOWINGCHANGED';
        CM_VISIBLECHANGED:        Result := 'CM_VISIBLECHANGED';
        CM_HITTEST:               exit;//Result := 'CM_HITTEST';
        else                      Result := 'CM_BASE + '+ IntToStr(TheMsg.Msg - CM_BASE);
      end;
    else
      case TheMsg.Msg of
        //CN_BASE MESSAGES
        CN_COMMAND:               Result := 'CN_COMMAND';
        CN_KEYDOWN:               Result := 'CN_KEYDOWN';
        CN_KEYUP:                 Result := 'CN_KEYUP';
        CN_CHAR:                  Result := 'CN_CHAR';

        // NORMAL MESSAGES
        LM_SETFOCUS:              Result := 'LM_SetFocus';
        LM_LBUTTONDOWN:           Result := 'LM_MOUSEDOWN';
        LM_LBUTTONUP:             Result := 'LM_LBUTTONUP';
        LM_LBUTTONDBLCLK:         Result := 'LM_LBUTTONDBLCLK';
        LM_RBUTTONDOWN:           Result := 'LM_RBUTTONDOWN';
        LM_RBUTTONUP:             Result := 'LM_RBUTTONUP';
        LM_RBUTTONDBLCLK:         Result := 'LM_RBUTTONDBLCLK';
        LM_GETDLGCODE:            Result := 'LM_GETDLGCODE';
        LM_KEYDOWN:               Result := 'LM_KEYDOWN';
        LM_KEYUP:                 Result := 'LM_KEYUP';
        LM_CAPTURECHANGED:        Result := 'LM_CAPTURECHANGED';
        LM_ERASEBKGND:            Result := 'LM_ERASEBKGND';
        LM_KILLFOCUS:             Result := 'LM_KILLFOCUS';
        LM_CHAR:                  Result := 'LM_CHAR';
        LM_SHOWWINDOW:            Result := 'LM_SHOWWINDOW';
        LM_SIZE:                  Result := 'LM_SIZE';
        LM_WINDOWPOSCHANGED:      Result := 'LM_WINDOWPOSCHANGED';
        LM_HSCROLL:               Result := 'LM_HSCROLL';
        LM_VSCROLL:               Result := 'LM_VSCROLL';
        LM_MOUSEMOVE:             exit;//Result := 'LM_MOUSEMOVE';
        LM_MOUSEWHEEL:            Result := 'LM_MOUSEWHEEL';
        1105:                     exit;//Result := '?EM_SETWORDBREAKPROCEX?';
        else                      Result := GetMessageName(TheMsg.Msg);
      end;
  end;
  Result:= S + '['+IntToHex(TheMsg.msg, 8)+'] W='+IntToHex(TheMsg.WParam,8)+
    ' L='+IntToHex(TheMsg.LParam,8)+' '+Result;
  DebugLn(Result);
end;
{$Endif GridTraceMsg}

function dbgs(zone: TxGridZone):string; overload;
begin
  case Zone of
    xgzFixedCells: Result := 'gzFixedCells';
    xgzFixedCols:  Result := 'gzFixedCols';
    xgzFixedRows:  Result := 'gzFixedRows';
    xgzNormal:     Result := 'gzNormal';
    xgzInvalid:    Result := 'gzInvalid';
    else
      result:= 'gz-error';
  end;
end;

function dbgs(zones: TxGridZoneSet):string; overload;
  procedure add(const s:string);
  begin
    if result<>'' then
      result := result + ',' + s
    else
      result := s;
  end;
begin
  result:='';
  if xgzFixedCells in zones then add('gzFixedCells');
  if xgzFixedCols  in zones then add('gzFixedCols');
  if xgzFixedRows  in zones then add('gzFixedRows');
  if xgzNormal in zones then add('gzNormal');
  if xgzInvalid in zones then add('gzInvalid');
  result := '['+result+']';
end;

{$ifdef DbgScroll}
function SbToStr(Which: Integer): string;
begin
  case Which of
    SB_VERT: result := 'vert';
    SB_HORZ: result := 'horz';
    SB_BOTH: result := 'both';
    else
      result := '????';
  end;
end;
{$endif}

procedure CfgSetFontValue(cfg: TXMLConfig; AKey: WideString; AFont: TFont);
begin
  cfg.SetValue(AKey + '/name/value', AFont.Name);
  cfg.SetValue(AKey + '/size/value', AFont.Size);
  cfg.SetValue(AKey + '/color/value', ColorToString(AFont.Color));
  cfg.SetValue(AKey + '/style/value', Integer(AFont.Style));
end;

procedure CfgGetFontValue(cfg: TXMLConfig; AKey: WideString; AFont: TFont);
begin
  AFont.Name := cfg.GetValue(AKey + '/name/value', 'default');
  AFont.Size := cfg.GetValue(AKey + '/size/value', 0);
  AFont.Color:= StringToColor(cfg.GetValue(AKey + '/color/value', 'clWindowText'));
  AFont.Style:= TFontStyles(cfg.GetValue(AKey + '/style/value', 0));
end;

procedure DrawRubberRect(Canvas: TCanvas; aRect: TRect; Color: TColor);
  procedure DrawVertLine(X1,Y1,Y2: integer);
  begin
    if Y2<Y1 then
      while Y2<Y1 do begin
        Canvas.Pixels[X1, Y1] := Color;
        dec(Y1, xconstRubberSpace);
      end
    else
      while Y1<Y2 do begin
        Canvas.Pixels[X1, Y1] := Color;
        inc(Y1, xconstRubberSpace);
      end;
  end;
  procedure DrawHorzLine(X1,Y1,X2: integer);
  begin
    if X2<X1 then
      while X2<X1 do begin
        Canvas.Pixels[X1, Y1] := Color;
        dec(X1, xconstRubberSpace);
      end
    else
      while X1<X2 do begin
        Canvas.Pixels[X1, Y1] := Color;
        inc(X1, xconstRubberSpace);
      end;
  end;
begin
  with aRect do begin
    DrawHorzLine(Left, Top, Right-1);
    DrawVertLine(Right-1, Top, Bottom-1);
    DrawHorzLine(Right-1, Bottom-1, Left);
    DrawVertLine(Left, Bottom-1, Top);
  end;
end;

function GetWorkingCanvas(const Canvas: TCanvas): TCanvas;
var
  DC: HDC;
begin

  if (Canvas=nil) or (not Canvas.HandleAllocated) then begin
    DC := GetDC(0);
    Result := TCanvas.Create;
    Result.Handle := DC;
  end else
    Result := Canvas;

end;

procedure FreeWorkingCanvas(canvas: TCanvas);
begin

  ReleaseDC(0, Canvas.Handle);
  Canvas.Free;

end;

function Between(const AValue,AMin,AMax: Integer): boolean;
begin
  if AMin<AMax then
    result := InRange(AValue, AMin, AMax)
  else
    result := InRange(AValue, AMax, AMin);
end;

{ TCustomXGrid }

function TCustomXGrid.GetRowHeights(Arow: Integer): Integer;
begin
  if (aRow<RowCount) and (aRow>=0) then
    Result:=integer(PtrUInt(FRows[aRow]))
  else
    Result:=-1;
  if Result<0 then Result:=fDefRowHeight;
end;

function TCustomXGrid.GetTopRow: Longint;
begin
  Result:=fTopLeft.y;
end;

function TCustomXGrid.GetVisibleColCount: Integer;
begin
  with FGCache do begin
    Result := VisibleGrid.Right-VisibleGrid.Left;
    if GridWidth<=ClientWidth then
      inc(Result)
  end;
end;

function TCustomXGrid.GetVisibleRowCount: Integer;
begin
  with FGCache do begin
    Result:=VisibleGrid.bottom-VisibleGrid.top;
    if GridHeight<=ClientHeight then
      inc(Result);
  end;
end;

procedure TCustomXGrid.HeadersMouseMove(const X, Y: Integer);
var
  P: TPoint;
  Gz: TxGridZone;
  ButtonColumn: boolean;
  OldAOE: boolean;
begin

  with FGCache do begin

    Gz := MouseToGridZone(X,Y);
    oldAOE := AllowOutboundEvents;
    AllowOutboundEvents := false;
    P := MouseToCell(Point(X,Y));
    AllowOutBoundEvents := OldAOE;
    ButtonColumn := IsCellButtonColumn(P);

    if (gz<>HotGridZone) or (P.x<>HotCell.x) or (P.y<>HotCell.y) then begin
      ResetHotCell;
      if (P.x>=0) and (P.y>=0) then begin
        if ButtonColumn or (xgoHeaderHotTracking in Options) then begin
          InvalidateCell(P.X, P.Y);
          HotCell := P;
        end;
      end;
    end;

    if ButtonColumn or (xgoHeaderPushedLook in Options) then begin
      if ClickCellPushed then begin
        if (P.X<>PushedCell.x) or (P.Y<>PushedCell.Y) then
          ResetPushedCell(False);
      end else
      if IsPushCellActive() then begin
        if (P.X=PushedCell.X) and (P.Y=PushedCell.Y) then begin
          ClickCellPushed:=True;
          InvalidateCell(P.X, P.Y);
        end;
      end;
    end;

    HotGridZone := Gz;
  end;
end;

procedure TCustomXGrid.InternalAutoFillColumns;
  procedure SetColumnWidth(aCol,aWidth: Integer);
  begin
    if csLoading in ComponentState then
      SetRawColWidths(aCol, aWidth)
    else
      SetColWidths(aCol, aWidth);
  end;
var
  I, ForcedIndex: Integer;
  Count: Integer;
  aPriority, aMin, aMax: Integer;
  AvailableSize: Integer;
  TotalWidth: Integer;     // total grid's width
  FixedSizeWidth: Integer; // total width of Fixed Sized Columns
begin
  if not AutoFillColumns then
    exit;

  if FUpdatingAutoFillCols then
    exit;

  FUpdatingAutoFillCols:=True;
  try
    // if needed, last size can be obtained from FLastWidth
    // when InternalAutoFillColumns is called from DoChangeBounds
    // for example.

    // Insert the algorithm that modify ColWidths accordingly
    //
    // For testing purposes, a simple algortihm is implemented:
    // if SizePriority=0, column size should be unmodified
    // if SizePriority<>0 means variable size column, its size
    // is the average avalilable size.

    Count := 0;
    FixedSizeWidth := 0;
    TotalWidth := 0;
    for i:=0 to ColCount-1 do begin
      GetAutoFillColumnInfo(i, aMin, aMax, aPriority);
      AvailableSize := GetColWidths(i);
      if aPriority>0 then
        Inc(Count)
      else
        Inc(FixedSizeWidth, AvailableSize);
      Inc(TotalWidth, AvailableSize);
    end;

    if Count=0 then begin
      //it's an autofillcolumns grid, so at least one
      // of the columns must fill completely the grid's
      // available width, let it be that column the last
      ForcedIndex := ColCount-1;
      if ForcedIndex>=FixedCols then
        Dec(FixedSizeWidth, GetColWidths(ForcedIndex));
      Count := 1;
    end else
      ForcedIndex := -1;

    AvailableSize := ClientWidth - FixedSizeWidth - GetBorderWidth;
    if AvailableSize<0 then begin
      // There is no space available to fill with
      // Variable Size Columns, what to do?

      // Simply set all Variable Size Columns
      // to 0, decreasing the size beyond this
      // shouldn't be allowed.
      for i:=0 to ColCount-1 do begin
        GetAutoFillColumnInfo(i, aMin, aMax, aPriority);
        if aPriority>0 then
          SetColumnWidth(i, 0);
      end;
    end else begin
      // Simpler case: There is actually available space to
      //     to be shared for variable size columns.
      FixedSizeWidth := AvailableSize mod Count; // space left after filling columns
      AvailableSize := AvailableSize div Count;
      for i:=0 to ColCount-1 do begin
        GetAutoFillColumnInfo(i, aMin, aMax, aPriority);
        if (APriority>0) or (i=ForcedIndex) then begin
          if i=ColCount-1 then
            // the last column gets all space left
            SetColumnWidth(i, AvailableSize + FixedSizeWidth)
          else
            SetColumnWidth(i, AvailableSize);
        end;
      end;
    end;
  finally
    FUpdatingAutoFillCols:=False;
  end;
end;

function TCustomXGrid.InternalNeedBorder: boolean;
begin
  result := FFlat and (FGridBorderStyle = bsSingle);
end;

procedure TCustomXGrid.InternalSetColCount(ACount: Integer);
var
  OldC: Integer;
  NewRowCount: Integer;
begin
  OldC := FCols.Count;
  if ACount=OldC then Exit;
  if ACount<1 then
    Clear
  else begin
    NewRowCount := RowCount;
    if (OldC=0) and FGridPropBackup.ValidData then begin
      NewRowCount := FGridPropBackup.RowCount;
      FFixedRows := Min(FGridPropBackup.FixedRowCount, NewRowCount);
      FFixedCols := Min(FGridPropBackup.FixedColCount, ACount);
    end;
    CheckFixedCount(ACount, NewRowCount, FFixedCols, FFixedRows);
    CheckCount(ACount, NewRowCount);
    AdjustCount(True, OldC, ACount);
    FGridPropBackup.ValidData := false;
  end;
end;

procedure TCustomXGrid.InternalSetColWidths(aCol, aValue: Integer);
var
  OldSize,NewSize: Integer;
  R: TRect;
  Bigger: boolean;
begin
  NewSize := AValue;
  if NewSize<0 then begin
    AValue:=-1;
    NewSize := FDefColWidth;
  end;

  OldSize := integer(PtrUInt(FCols[ACol]));
  if NewSize<>OldSize then begin

    if OldSize<0 then
      OldSize := fDefColWidth;

    Bigger := NewSize>OldSize;
    SetRawColWidths(ACol, AValue);

    if not (csLoading in ComponentState) and HandleAllocated then begin

      if FUpdateCount=0 then begin
        UpdateSizes;
        R := CellRect(aCol, 0);
        R.Bottom := FGCache.MaxClientXY.Y+GetBorderWidth+1;
        if UseRightToLeftAlignment then begin
          //Bigger or not bigger i will refresh
          R.Left := FGCache.ClientRect.Left;
          if aCol=FTopLeft.x then
            R.Right := FGCache.ClientRect.Right - FGCache.FixedWidth;
        end
        else begin
          if Bigger then
            R.Right := FGCache.MaxClientXY.X+GetBorderWidth+1
          else
            R.Right := FGCache.ClientWidth;
          if aCol=FTopLeft.x then
            R.Left := FGCache.FixedWidth;
        end;
        InvalidateRect(handle, @R, False);
      end;

      if (FEditor<>nil)and(Feditor.Visible)and(ACol<=FCol) then
        EditorWidthChanged(aCol, aValue);
      ColWidthsChanged;
    end;

  end;
end;

procedure TCustomXGrid.InternalUpdateColumnWidths;
var
  i: Integer;
  C: TxGridColumn;
begin
  for i:= FixedCols to ColCount-1 do begin
    C := ColumnFromGridColumn(i);
    if C<>nil then
      SetRawColWidths(i, C.Width);
  end;
end;

procedure TCustomXGrid.InvalidateMovement(DCol, DRow: Integer; OldRange: TRect);

  procedure doInvalidateRange(Col1,Row1,Col2,Row2: Integer);
  begin
    InvalidateRange(Rect(Col1,Row1,Col2,Row2));
  end;

begin
  if SelectActive then
  begin

    if DCol>FCol then
    begin
      // expanded cols
      if not (xgoRowSelect in Options) then
        doInvalidateRange(FCol, OldRange.Top, DCol, Oldrange.Bottom)

      else if (xgoRelaxedRowSelect in Options) and (DRow=FRow) then
        InvalidateRow(DRow)

    end else if DCol<FCol then
    begin
      // shrunk cols
      if not (xgoRowSelect in Options) then
        doInvalidateRange(DCol,OldRange.Top,FCol,OldRange.Bottom)

      else if (xgoRelaxedRowSelect in Options) and (DRow=FRow) then
        InvalidateRow(DRow)

    end;

    if DRow>FRow then
      // expanded rows
      doInvalidateRange(OldRange.Left, FRow, OldRange.Right, DRow)

    else if DRow<FRow then
      // shrunk rows
      doInvalidateRange(OldRange.Left, DRow, OldRange.Right, FRow);

    if not (xgoRowSelect in Options) then
    begin

      // Above rules do work only if either rows or cols remain
      // constant, if both rows and cols change there may be gaps
      //
      // four cases are left.
      //

      if (DCol>FCol)and(DRow<FRow) then // (1: I   Cuadrant)
        // Rect(FCol+1,FRow-1,DCol,DRow) normalized -v
        doInvalidateRange(FCol+1, DRow, DCol, FRow-1)
      else
      if (DCol<FCol)and(DRow<FRow) then // (2: II  Cuadrant)
        // Rect(FCol-1,FRow-1,DCol,DRow) normalized -v
        doInvalidateRange(DCol, DRow, FCol-1, FRow-1)
      else
      if (DCol<FCol)and(DRow>FRow) then // (3: III Cuadrant)
        // Rect(FCol-1,FRow+1,DCol,DRow) normalized -v
        doInvalidateRange(DCol, FRow+1, FCol-1, DRow)
      else
      if (DCol>FCol)and(DRow>FRow) then // (4: IV  Cuadrant)
        // normalization not needed
        doInvalidateRange(FCol+1,FRow+1,DCol,DRow);

    end;

  end
  else
  begin

    if (OldRange.Right-OldRange.Left>0) or
      (OldRange.Bottom-OldRange.Top>0) then
      // old selected range gone, invalidate old area
      InvalidateRange(OldRange)
    else
    begin
      if xgoRowHightLight in Options then
        InvalidateRow(FRow)
      else
        // Single cell
        InvalidateCell(FCol, FRow);
    end;

    // and invalidate current selecion, cell or full row
    if (xgoRowSelect in Options) or (xgoRowHightLight in Options) then
      InvalidateRow(Drow)
    else
      InvalidateCell(DCol, DRow);

  end;

end;

function TCustomXGrid.IsColumnsStored: boolean;
begin
  result := Columns.Enabled;
end;

function TCustomXGrid.IsPushCellActive: boolean;
begin
  with FGCache do
    result := (PushedCell.X<>-1) and (PushedCell.Y<>-1);
end;

function TCustomXGrid.LoadResBitmapImage(const ResName: string): TBitmap;
var
  C: TCustomBitmap;
begin
  C := CreateBitmapFromLazarusResource(ResName);
  if C<>nil then begin
    Result := TBitmap.Create;
    Result.Assign(C);
    C.Free;
  end else
    Result:=nil;
end;

function TCustomXGrid.MouseButtonAllowed(Button: TMouseButton): boolean;
begin
  result := (Button=mbLeft);
end;

function TCustomXGrid.IsImageListStored: boolean;
begin
  Result := FImageList <> nil;
end;

function TCustomXGrid.IsTitleImageListStored: boolean;
begin
  Result := FTitleImageList <> nil;
end;

function TCustomXGrid.GetLeftCol: Integer;
begin
  result:=fTopLeft.x;
end;

function TCustomXGrid.GetColCount: Integer;
begin
  Result:=FCols.Count;
end;

function TCustomXGrid.GetRowCount: Integer;
begin
  Result:=FRows.Count;
end;

function TCustomXGrid.GetColWidths(Acol: Integer): Integer;
var
  C: TxGridColumn;
begin
  if not Columns.Enabled or (aCol<FixedCols) then begin
    if (aCol<ColCount) and (aCol>=0) then
      Result:=integer(PtrUInt(FCols[aCol]))
    else
      Result:=-1;
    if result<0 then
      Result:=fDefColWidth;
  end else begin
    C := ColumnFromGridColumn(Acol);
    if C<>nil then
      Result := C.Width
    else
      result := FDefColWidth;
  end;
end;

procedure TCustomXGrid.SetEditor(AValue: TWinControl);
var
  Msg: TxGridMessage;
begin
  if FEditor=AValue then exit;

  if (FEditor<>nil) and FEditor.Visible then
    EditorHide;

  FEditor:=AValue;
  if FEditor<>nil then begin

    if FEditor.Parent=nil then
      FEditor.Visible:=False;

    if FEditor.Parent<>Self then
      FEditor.Parent:=Self;

    Msg.LclMsg.msg:=GM_SETGRID;
    Msg.Grid:=Self;
    Msg.Options:=0;
    FEditor.Dispatch(Msg);

    FEditorOptions := Msg.Options + 1; // force new editor setup
    SetEditorOptions(Msg.Options);
  end;
end;

procedure TCustomXGrid.SetFixedCols(const AValue: Integer);
begin
  if FFixedCols=AValue then begin
    if FixedGrid and FGridPropBackup.ValidData then begin
      // user modified fixed properties in fixed grid
      // update stored values
      FGridPropBackup.FixedColCount := AValue;
    end;
    exit;
  end;
  CheckFixedCount(ColCount, RowCount, AValue, FFixedRows);

  if EditorMode then
    EditorMode:=False;

  FFixedCols:=AValue;
  FTopLeft.x:=AValue;

  if Columns.Enabled then begin

    FCol:=AValue;
    UpdateSelectionRange;
    if not (csLoading in componentState) then
      doTopleftChange(true);

    ColumnsChanged(nil)

  end else begin

    if not (csLoading in componentState) then
      doTopleftChange(true);

    MoveNextSelectable(False, FixedCols, FRow);
    UpdateSelectionRange;
  end;
end;

procedure TCustomXGrid.SetFixedRows(const AValue: Integer);
begin
  if FFixedRows=AValue then begin
    if FixedGrid and FGridPropBackup.ValidData then begin
      // user modified fixed properties in fixed grid
      // update stored values
      FGridPropBackup.FixedRowCount := AValue;
    end;
    exit;
  end;
  CheckFixedCount(ColCount, RowCount, FFixedCols, AValue);

  if EditorMode then
    EditorMode:=False;

  FFixedRows:=AValue;
  FTopLeft.y:=AValue;

  if not (csLoading in ComponentState) then
    doTopleftChange(true);

  MoveNextSelectable(False, FCol, FixedRows);
  UpdateSelectionRange;
end;

procedure TCustomXGrid.SetGridLineColor(const AValue: TColor);
begin
  if FGridLineColor=AValue then exit;
  FGridLineColor:=AValue;
  Invalidate;
end;

procedure TCustomXGrid.SetLeftCol(const AValue: Integer);
begin
  TryScrollTo(AValue, FTopLeft.Y);
end;

procedure TCustomXGrid.SetOptions(const AValue: TxGridOptions);
begin
  if FOptions=AValue then exit;
  FOptions:=AValue;
  UpdateSelectionRange;
  if xgoAlwaysShowEditor in Options then begin
    SelectEditor;
    EditorShow(true);
  end else begin
    EditorHide;
  end;
  VisualChange;
end;

procedure TCustomXGrid.SetScrollBars(const AValue: TScrollStyle);
begin
  if FScrollBars=AValue then exit;
  FScrollBars:=AValue;
  VisualChange;
end;

procedure TCustomXGrid.SetTopRow(const AValue: Integer);
begin
  TryScrollTo(FTopLeft.X, Avalue);
end;

function TCustomXGrid.StartColSizing(const X, Y: Integer):boolean;
var
  OrgIndex, TmpIndex: Integer;
  ACase: Integer;
begin

  with FSizing do begin

    OrgIndex := FGCache.ClickCell.X;
    Index := OrgIndex;
    ColRowToOffset(true, true, Index, OffIni, OffEnd);

    if (OffEnd-FGCache.ClickMouse.X) <  (FGCache.ClickMouse.X-OffIni) then begin
      if X>FGCache.ClickMouse.X then
        ACase := 4  // dragging right side to the right
      else
        ACase := 3; // dragging right side to the left
    end else begin
      if X>FGCache.ClickMouse.X then
        ACase := 2  // dragging left side to the right
      else
        ACase := 1; // dragging left side to the left
    end;

    if UseRightToLeftAlignment then begin
      case ACase of
        1: ACase := 4;
        2: ACase := 3;
        3: ACase := 2;
        4: ACase := 1;
      end;
    end;

    case ACase of
      3: ; // current column is the right one to resize
      4:   // find following covered column (visible 0-width) at the right side
        begin
          TmpIndex := Index;
          while (TmpIndex<ColCount-1) and (ColWidths[TmpIndex+1]=0) do begin
            Inc(TmpIndex);
            if not Columns.Enabled or ColumnFromGridColumn(TmpIndex).Visible then
              Index := TmpIndex;
          end;
        end;
      2:   // find previous visible (width>0) or covered column
        begin
          Dec(Index);
          while (Index>FixedCols) do begin
            if not Columns.Enabled or ColumnFromGridColumn(Index).Visible then
              break;
            Dec(Index);
          end;
        end;
      1:   // find previous visible (width>0) column
        begin
          Dec(Index);
          while (Index>FixedCols) do begin
            if ColWidths[Index]>0 then
              break;
            Dec(Index);
          end;
        end;
    end;

    if OrgIndex<>Index then
      ColRowToOffset(True, True, Index, OffIni, OffEnd);

    // if precision on changing cursor from normal to split is expanded, there
    // will be a starting big jump on size, to fix it, uncomment next lines
    // TODO: check for RTL
    //DeltaOff := OffEnd - FGCache.ClickMouse.X;
    DeltaOff := 0;

    if xgoFixedColSizing in Options then
      result := (Index>=0)
    else
      result := (Index>=FixedCols);
  end;

end;

procedure TCustomXGrid.ChangeCursor(ACursor: Integer = MAXINT);
begin
  if ACursor=MAXINT then
    Cursor := FSavedCursor
  else begin
    FSavedCursor := Cursor;
    Cursor := TCursor(ACursor);
  end;
end;

procedure TCustomXGrid.SetRowheights(Arow: Integer; Avalue: Integer);
var
  OldSize,NewSize: Integer;
  R: TRect;
  Bigger: boolean;
begin

  NewSize := AValue;
  if NewSize<0 then begin
    AValue:=-1;
    NewSize := FDefRowHeight;
  end;

  OldSize := integer(PtrUInt(FRows[ARow]));
  if AValue<>OldSize then begin

    if OldSize<0 then
      OldSize := FDefRowHeight;

    bigger := NewSize > OldSize;

    FRows[ARow]:=Pointer(PtrInt(AValue));

    if not (csLoading in ComponentState) and HandleAllocated then begin
      if FUpdateCount=0 then begin
        UpdateSizes;

        R := CellRect(0, aRow);
        if UseRightToLeftAlignment then
        begin
          R.Left := FlipX(FGCache.MaxClientXY.X+GetBorderWidth);
          R.Right := R.Right + 1;
        end
        else
          R.Right := FGCache.MaxClientXY.X+GetBorderWidth+1;
        if bigger then
          R.Bottom := FGCache.MaxClientXY.Y+GetBorderWidth+1
        else
          R.Bottom := FGCache.ClientHeight;
        if aRow=FTopLeft.y then
          R.Top := FGCache.FixedHeight;

        InvalidateRect(handle, @R, False);
      end;

      if (FEditor<>nil)and(Feditor.Visible)and(ARow<=FRow) then EditorPos;
      RowHeightsChanged;
    end;

  end;
end;

procedure TCustomXGrid.SetColwidths(Acol: Integer; Avalue: Integer);
var
  c: TxGridColumn;
  OldWidth: Integer;
begin
  if not Columns.Enabled or (aCol<FFixedCols) then
    internalSetColWidths(aCol, aValue)
  else begin
    C := ColumnFromGridColumn(ACol);
    if C<>nil then begin
      OldWidth := C.Width;
      C.Width := AValue;
      SetRawColWidths(ACol, AValue);
      if OldWidth<>C.Width then
        EditorWidthChanged(aCol, C.Width);
    end;
  end;
end;

procedure TCustomXGrid.SetRawColWidths(ACol: Integer; AValue: Integer);
begin
  FCols[ACol]:=Pointer(PtrInt(Avalue));
end;

procedure TCustomXGrid.AdjustCount(IsColumn: Boolean; OldValue,
  NewValue: Integer);
  procedure AddDel(Lst: TList; aCount: Integer);
  begin
    while lst.Count<aCount do Lst.Add(Pointer(-1)); // default width/height
    Lst.Count:=aCount;
  end;
var
  OldCount, NewCount: integer;
begin
  if IsColumn then begin
    AddDel(FCols, NewValue);
    FGCache.AccumWidth.Count:=NewValue;
    // calc initial accumulated widths of new columns
    OldCount := OldValue;
    while (OldValue>0) and (OldCount<NewValue) do begin
      FGCache.AccumWidth[OldCount] :=
        FGCache.AccumWidth[OldCount-1] + GetColWidths(OldCount);
      Inc(OldCount);
    end;
    OldCount:=RowCount;
    if (OldValue=0)and(NewValue>=0) then begin
      FTopLeft.X:=FFixedCols;
      if RowCount=0 then begin
        if FGridPropBackup.ValidData then begin
          NewCount := FGridPropBackup.RowCount;
          FFixedRows := Min(FGridPropBackup.FixedRowCount, NewCount);
        end
        else
          NewCount := 1;
        FTopLeft.Y:=FFixedRows;
        AddDel(FRows, NewCount);
        FGCache.AccumHeight.Count:=NewCount;
      end;
    end;
    SizeChanged(OldValue, OldCount);
    FixPosition(True, Col);
  end else begin
    AddDel(FRows, NewValue);
    FGCache.AccumHeight.Count:=NewValue;
    // calc initial accumulated heights of new rows
    OldCount := OldValue;
    while (OldValue>0) and (OldCount<NewValue) do begin
      FGCache.AccumHeight[OldCount] :=
        FGCache.AccumHeight[OldCount-1] + GetRowHeights(OldCount);
      Inc(OldCount);
    end;
    OldCount:=ColCount;
    if (OldValue=0)and(NewValue>=0) then begin
      FTopleft.Y:=FFixedRows;
      //DebugLn('TCustomXGrid.AdjustCount B ',DbgSName(Self),' FTopLeft=',dbgs(FTopLeft));
      if FCols.Count=0 then begin
        if FGridPropBackup.ValidData then begin
          NewCount := FGridPropBackup.ColCount;
          FFixedCols := Min(FGridPropBackup.FixedColCount, NewCount);
        end
        else begin
          NewCount := 1;
          FFixedCols := 0;
        end;
        FTopLeft.X:=FFixedCols;
        AddDel(FCols, NewCount);
        FGCache.AccumWidth.Count:=NewCount;
      end;
    end;
    SizeChanged(OldCount, OldValue);
    FixPosition(False, Row);
  end;
end;

procedure TCustomXGrid.AdjustEditorBounds(NewCol,NewRow:Integer);
begin
  SetColRow(NewCol,NewRow);
  if EditorMode then
    EditorPos;
end;

procedure TCustomXGrid.AssignTo(Dest: TPersistent);
var
  Target: TCustomXGrid;
begin
  if Dest is TCustomXGrid then begin

    Target := TCustomXGrid(Dest);
    Target.BeginUpdate;

    // structure
    Target.FixedCols := 0;
    Target.FixedRows := 0;
    if Columns.Enabled then
      Target.Columns.Assign(Columns)
    else begin
      Target.ColCount :=ColCount;
    end;
    Target.RowCount := RowCount;
    Target.FixedCols := FixedCols;
    Target.FixedRows := FixedRows;
    Target.DefaultRowHeight := DefaultRowHeight;
    if not IsDefRowHeightStored then
      Target.GridFlags := Target.GridFlags - [gfxDefRowHeightChanged];
    Target.DefaultColWidth := DefaultColWidth;
    if not Columns.Enabled then
      Target.FCols.Assign(FCols);
    Target.FRows.Assign(FRows);

    // Options
    Target.Options := Options;
    Target.Color := Color;
    Target.FixedColor := FixedColor;
    Target.AlternateColor := AlternateColor;
    Target.Font := Font;
    Target.TitleFont := TitleFont;

    // position
    Target.TopRow := TopRow;
    Target.LeftCol := LeftCol;
    Target.Col := Col;
    Target.Row := Row;
    Target.FRange := FRange;

    Target.EndUpdate;

  end else
    inherited AssignTo(Dest);
end;

procedure TCustomXGrid.SetColCount(AValue: Integer);
begin
  if Columns.Enabled then
    raise xEGridException.Create('Use Columns property to add/remove columns');
  InternalSetColCount(AValue);
end;

procedure TCustomXGrid.SetRowCount(AValue: Integer);
var
  OldR, NewColCount: Integer;
begin
  OldR := FRows.Count;
  if AValue<>OldR then begin
    if AValue>=1 then begin
      NewColCount := ColCount;
      if (OldR=0) and FGridPropBackup.ValidData then begin
        NewColCount := FGridPropBackup.ColCount;
        FFixedCols := Min(FGridPropBackup.FixedColCount, NewColCount);
        FFixedRows := Min(FGridPropBackup.FixedRowCount, AValue);
        FTopLeft.X := FFixedCols;
        FTopLeft.Y := FFixedRows;
        // ignore backedup value of rowcount because
        // finally rowcount will be AValue
        FGridPropBackup.RowCount := AValue;
      end;
      if Columns.Enabled then begin
        // setup custom columns
        Self.ColumnsChanged(nil);
        FGridPropBackup.ValidData := false;
        // still need to adjust rowcount?
        if AValue=FRows.Count then
          exit;
      end;
      CheckFixedCount(NewColCount, AValue, FFixedCols, FFixedRows);
      CheckCount(NewColCount, AValue);
      AdjustCount(False, OldR, AValue);
    end else
      Clear;
  end;
end;

procedure TCustomXGrid.SetDefColWidth(AValue: Integer);
var
  i: Integer;
begin
  if AValue=fDefColwidth then
    Exit;
  FDefColWidth:=AValue;
  if not AutoFillColumns then begin
    for i:=0 to ColCount-1 do
      FCols[i] := Pointer(-1);
    VisualChange;
  end;
end;

procedure TCustomXGrid.SetDefRowHeight(AValue: Integer);
var
  i: Integer;
begin
  if (AValue<>fDefRowHeight) or (csLoading in ComponentState) then begin
    include(FGridFlags, gfxDefRowHeightChanged);
    FDefRowheight:=AValue;
    for i:=0 to RowCount-1 do
      FRows[i] := Pointer(-1);
    VisualChange;
  end;
end;

procedure TCustomXGrid.SetCol(AValue: Integer);
begin
  if AValue=FCol then Exit;
  if not AllowOutboundEvents then
    CheckLimitsWithError(AValue, FRow);
  MoveExtend(False, AValue, FRow);
  Click;
end;

procedure TCustomXGrid.SetRow(AValue: Integer);
begin
  if AValue=FRow then Exit;
  if not AllowOutBoundEvents then
    CheckLimitsWithError(FCol, AValue);
  MoveExtend(False, FCol, AValue);
  Click;
end;

{procedure TCustomXGrid.Sort(ColSorting: Boolean; index, IndxFrom, IndxTo: Integer);
  procedure QuickSort(L,R: Integer);
  var
    I,J: Integer;
    P{,Q}: Integer;
  begin
    repeat
      I:=L;
      J:=R;
      P:=(L+R) div 2;
      repeat
        if ColSorting then begin
          while DoCompareCells(index, P, index, I)>0 do I:=I+1;
          while DoCompareCells(index, P, index, J)<0 do J:=J-1;
        end else begin
          while DoCompareCells(P, index, I, index)>0 do I:=I+1;
          while DoCompareCells(P, index, J, index)<0 do J:=J-1;
        end;
        if I<=J then begin

          if I<>J then
            if not FStrictSort or
              (ColSorting     and (DoCompareCells(index, I, index, J)<>0)) or
              (not ColSorting and (DoCompareCells(I, index, J, index)<>0))
            then
              DoOPExchangeColRow(not ColSorting, I,J);

          if P=I then
            P:=J
          else if P=J then
            P:=I;

          I:=I+1;
          J:=J-1;
        end;
      until I>J;

      if L<J then
        QuickSort(L,J);

      L:=I;
    until I>=R;
  end;
begin
  if RowCount>FixedRows then begin
    CheckIndex(ColSorting, Index);
    CheckIndex(not ColSorting, IndxFrom);
    CheckIndex(not ColSorting, IndxTo);
    BeginUpdate;
    QuickSort(IndxFrom, IndxTo);
    EndUpdate;
  end;
end; }

procedure TCustomXGrid.doTopleftChange(DimChg: Boolean);
begin
  TopLeftChanged;
  VisualChange;
end;

procedure TCustomXGrid.DrawXORVertLine(X: Integer);
var
  OldPenMode: TPenMode;
  OldPenColor: TColor;
begin
  OldPenMode := Canvas.Pen.Mode;
  OldPenColor := Canvas.Pen.Color;
  Canvas.Pen.Color := clWhite;
  Canvas.Pen.Mode := pmXOR;
  Canvas.MoveTo(X,0);
  Canvas.LineTo(X,FGCache.MaxClientXY.Y);
  Canvas.Pen.Mode := OldPenMode;
  Canvas.Pen.Color := OldPenColor;
end;

procedure TCustomXGrid.DrawXORHorzLine(Y: Integer);
var
  OldPenMode: TPenMode;
  OldPenColor: TColor;
begin
  OldPenMode := Canvas.Pen.Mode;
  OldPenColor := Canvas.Pen.Color;
  Canvas.Pen.Color := clWhite;
  Canvas.Pen.Mode := pmXOR;
  if UseRightToLeftAlignment then begin
    Canvas.MoveTo(FlipX(FGCache.MaxClientXY.X)+1,Y);
    Canvas.LineTo(FGCache.ClientRect.Right,Y);
  end
  else begin
    Canvas.MoveTo(0,Y);
    Canvas.LineTo(FGCache.MaxClientXY.X,Y);
  end;
  Canvas.Pen.Mode := OldPenMode;
  Canvas.Pen.Color := OldPenColor;
end;

function TCustomXGrid.EditorCanProcessKey(var Key: TUTF8Char): boolean;
begin
  result := EditorCanAcceptKey(Key) and not EditorIsReadOnly;
  if not Result then
    Key := '';
end;

procedure TCustomXGrid.VisualChange;
begin
  if FUpdateCount<>0 then
    exit;

  {$ifdef DbgVisualChange}
  DebugLn('TCustomXGrid.VisualChange INIT ',DbgSName(Self));
  {$endif}

  UpdateSizes;

  Invalidate;
  {$ifdef DbgVisualChange}
  DebugLn('TCustomXGrid.VisualChange END ',DbgSName(Self));
  {$endif}
end;

procedure TCustomXGrid.ResetSizes;
begin
  //DebugLn('TCustomXGrid.VisualChange ',DbgSName(Self));
  if (FCols=nil) or ([csLoading,csDestroying]*ComponentState<>[])
  or (not HandleAllocated) then
    exit; // not yet initialized or already destroyed

  UpdateCachedSizes;
  CheckNewCachedSizes(FGCache);
  CacheVisibleGrid;
  {$Ifdef DbgVisualChange}
  DebugLn('TCustomXGrid.ResetSizes %s Width=%d Height=%d',[DbgSName(Self),Width,Height]);
  DebugLn('  Cache: ClientWidth=%d ClientHeight=%d GWidth=%d GHeight=%d',
    [FGCAche.ClientWidth, FGCache.ClientHeight,FGCache.GridWidth, FGCache.GridHeight]);
  DebugLn('  Reald: ClientWidth=%d ClientHeight=%d',[ClientWidth, ClientHeight]);
  DebugLn('  MaxTopLeft',dbgs(FGCache.MaxTopLeft));
  {$Endif}
  CalcScrollBarsRange;
end;

procedure TCustomXGrid.CreateParams(var Params: TCreateParams);
const
  ClassStylesOff = CS_VREDRAW or CS_HREDRAW;
begin
  inherited CreateParams(Params);
  with Params do begin
    WindowClass.Style := WindowClass.Style and DWORD(not ClassStylesOff);
    Style := Style or WS_VSCROLL or WS_HSCROLL or WS_CLIPCHILDREN;
  end;
end;

procedure TCustomXGrid.Click;
begin
  {$IFDEF dbgGrid} DebugLn('FIgnoreClick=', dbgs(FIgnoreClick)); {$ENDIF}
  if not FIgnoreClick then
    inherited Click;
end;

procedure TCustomXGrid.ScrollBarRange(Which: Integer; aRange,aPage,aPos: Integer);
var
  ScrollInfo: TScrollInfo;
begin
  if HandleAllocated then begin
    {$Ifdef DbgScroll}
    DebugLn('ScrollbarRange: Which=%s Range=%d Page=%d Pos=%d',
      [SbToStr(Which),aRange,aPage,aPos]);
    {$endif}
    FillChar(ScrollInfo, SizeOf(ScrollInfo), 0);
    ScrollInfo.cbSize := SizeOf(ScrollInfo);
    ScrollInfo.fMask := SIF_RANGE or SIF_PAGE or SIF_DISABLENOSCROLL;
    if not (gfxPainting in FGridFlags) then
      ScrollInfo.fMask := ScrollInfo.fMask or SIF_POS;
    {$ifdef Unix}
    ScrollInfo.fMask := ScrollInfo.fMask or SIF_UPDATEPOLICY;
    if xgoThumbTracking in Options then
      ScrollInfo.ntrackPos := SB_POLICY_CONTINUOUS
    else
      ScrollInfo.ntrackPos := SB_POLICY_DISCONTINUOUS;
    {$endif}
    ScrollInfo.nMin := 0;
    ScrollInfo.nMax := aRange;
    ScrollInfo.nPos := aPos;
    if APage<0 then
      APage := 0;
    ScrollInfo.nPage := APage;
    if (Which=SB_HORZ) and UseRightToLeftAlignment then begin
      ScrollInfo.nPos := ScrollInfo.nMax-ScrollInfo.nPage-ScrollInfo.nPos;
      {$Ifdef DbgScroll}
      DebugLn('ScrollbarRange: RTL nPos=%d',[ScrollInfo.nPos]);
      {$endif}
    end;
    SetScrollInfo(Handle, Which, ScrollInfo, True);
  end;
end;

procedure TCustomXGrid.ScrollBarPosition(Which, Value: integer);
var
  ScrollInfo: TScrollInfo;
  Vis: Boolean;
begin
  if HandleAllocated then begin
    {$Ifdef DbgScroll}
    DebugLn('ScrollbarPosition: Which=',SbToStr(Which), ' Value= ',IntToStr(Value));
    {$endif}
    if Which = SB_VERT then Vis := FVSbVisible else
    if Which = SB_HORZ then Vis := FHSbVisible
    else vis := false;
    FillChar(ScrollInfo, SizeOf(ScrollInfo), 0);
    ScrollInfo.cbSize := SizeOf(ScrollInfo);
    if (Which=SB_HORZ) and Vis and UseRightToLeftAlignment then begin
      ScrollInfo.fMask := SIF_PAGE or SIF_RANGE;
      GetScrollInfo(Handle, SB_HORZ, ScrollInfo);
      Value := (ScrollInfo.nMax-ScrollInfo.nPage)-Value;
      {$Ifdef DbgScroll}
      DebugLn('ScrollbarPosition: Which=',SbToStr(Which), ' RTL Value= ',IntToStr(Value));
      {$endif}
    end;
    ScrollInfo.fMask := SIF_POS;
    ScrollInfo.nPos:= Value;
    SetScrollInfo(Handle, Which, ScrollInfo, Vis);
  end;
end;

function TCustomXGrid.ScrollBarIsVisible(Which: Integer): Boolean;
begin
  Result:=false;
  if HandleAllocated then begin
    {$IFNDEF MSWINDOWS}
    Result:= getScrollbarVisible(handle, Which);
    {$ELSE}
    // Is up to the widgetset to implement GetScrollbarvisible
    // FVSbVisible, FHSbVisible are supposed to be update (if used ScrolLBarShow)
    // how can we know if GetScrollbarVisible is indeed implemented?....
    if Which = SB_VERT then result := FVSbVisible else
    if Which = SB_HORZ then result := FHsbVisible else
    if Which = SB_BOTH then result := FHsbVisible and FVsbVisible;
    {$ENDIF}
  end;
end;

procedure TCustomXGrid.ScrollBarPage(Which: Integer; aPage: Integer);
var
  ScrollInfo: TScrollInfo;
begin
  if HandleAllocated then begin
    {$Ifdef DbgScroll}
    DebugLn('ScrollbarPage: Which=',SbToStr(Which), ' Avalue=',dbgs(aPage));
    {$endif}
    ScrollInfo.cbSize := SizeOf(ScrollInfo);
    ScrollInfo.fMask := SIF_PAGE;
    ScrollInfo.nPage:= aPage;
    SetScrollInfo(Handle, Which, ScrollInfo, True);
  end;
end;

procedure TCustomXGrid.ScrollBarShow(Which: Integer; aValue: boolean);
begin
  if HandleAllocated then begin
    {$Ifdef DbgScroll}
    DebugLn('ScrollbarShow: Which=',SbToStr(Which), ' Avalue=',dbgs(AValue));
    {$endif}
    ShowScrollBar(Handle,Which,aValue);
    if Which in [SB_BOTH, SB_VERT] then FVSbVisible := AValue else
    if Which in [SB_BOTH, SB_HORZ] then FHSbVisible := AValue;
  end;
end;

function TCustomXGrid.ScrollBarAutomatic(Which: TScrollStyle): boolean;
begin
  result:=false;
  if (Which=ssVertical)or(Which=ssHorizontal) then begin
    if Which=ssVertical then Which:=ssAutoVertical
    else Which:=ssAutoHorizontal;
    Result:= FScrollBars in [Which, ssAutoBoth];
  end;
end;

{ Returns a reactagle corresponding to a fisical cell[aCol,aRow] }
function TCustomXGrid.CellRect(ACol, ARow: Integer): TRect;
begin
  //Result:=ColRowToClientCellRect(aCol,aRow);
  ColRowToOffset(True, True, ACol, Result.Left, Result.Right);
  ColRowToOffSet(False,True, ARow, Result.Top, Result.Bottom);
end;

function TCustomXGrid.EditorRect(aCol, aRow: Integer): TRect;
begin
  Result := CellRect(aCol, aRow);
end;

// The visible grid Depends on  TopLeft and ClientWidht,ClientHeight,
// Col/Row Count, So it Should be called inmediately after changing
// those properties.
function TCustomXGrid.GetVisibleGrid: TRect;
var
  w: Integer;
begin

  if (FTopLeft.X<0)or(FTopLeft.y<0)or(csLoading in ComponentState) then begin
    Result := Rect(0,0,-1,-1);
    FGCache.MaxClientXY := point(0,0);
    Exit;
  end;
  // visible TopLeft Cell
  Result.TopLeft:=fTopLeft;
  Result.BottomRight:=Result.TopLeft;

  // Left Margin of next visible Column and Rightmost visible cell
  if ColCount>FixedCols then begin
    W:=GetColWidths(Result.Left) + FGCache.FixedWidth;
    if xgoSmoothScroll in Options then
      W := W - FGCache.TLColOff;
    while (Result.Right<ColCount-1)and(W<FGCache.ClientWidth) do begin
      Inc(Result.Right);
      W:=W+GetColWidths(Result.Right);
    end;
    FGCache.MaxClientXY.X := W;
  end else begin
    FGCache.MaxClientXY.X := FGCache.FixedWidth;
    Result.Right := Result.Left - 1; // no visible cells here
  end;

  // Top Margin of next visible Row and Bottom most visible cell
  if RowCount>FixedRows then begin
    W:=GetRowheights(Result.Top) + FGCache.FixedHeight;
    if xgoSmoothScroll in Options then
      W := W - FGCache.TLRowOff;
    while (Result.Bottom<RowCount-1)and(W<FGCache.ClientHeight) do begin
      Inc(Result.Bottom);
      W:=W+GetRowHeights(Result.Bottom);
    end;
    FGCache.MaxClientXY.Y := W;
  end else begin
    FGCache.MaxClientXY.Y := FGCache.FixedHeight;
    Result.Bottom := Result.Top - 1; // no visible cells here
  end;
end;

{ Scroll the grid until cell[aCol,aRow] is shown }
function TCustomXGrid.ScrollToCell(const aCol,aRow: Integer; wResetOffs:boolean): Boolean;
var
  RNew: TRect;
  OldTopLeft:TPoint;
  Xinc,YInc: Integer;
  CHeight,CWidth: Integer;
begin
  OldTopLeft:=fTopLeft;
  CHeight := FGCache.ClientHeight + GetBorderWidth;
  CWidth  := FGCache.ClientWidth  + GetBorderWidth;

  {$IFDEF dbgGridScroll}
  DebugLn('aCol=%d aRow=%d FixHeight=%d CHeight=%d FixWidth=%d CWidth=%d',
          [aCol,aRow,FGCache.FixedHeight,CHeight, FGCache.FixedWidth, CWidth]);
  {$Endif}

  while (fTopLeft.x>=0) and
        (fTopLeft.x<ColCount)and
        (fTopLeft.y>=0) and
        (fTopLeft.y<RowCount) do
  begin
    RNew:=CellRect(aCol,aRow);
    if UseRightToLeftAlignment then begin
      XInc := RNew.Right;
      RNew.Right := FlipX(RNew.Left);
      RNew.Left := FlipX(XInc);
    end;

    Xinc := 0;
    if RNew.Right <= FGCache.FixedWidth+GetBorderWidth then
      Xinc := -1              // hidden at the left of fixedwidth line
    else
    if RNew.Left >= CWidth then
      Xinc := 1               // hidden at the right of clientwidth line
    else
    if (RNew.Left > FGCache.FixedWidth+GetBorderWidth) and
       (RNew.Left < CWidth) and (CWidth < RNew.Right) and
       (not (xgoDontScrollPartCell in Options)) then begin
      Xinc := 1;              // partially visible at the right
      FGCache.TLColOff := 0;  // cancel col-offset for next calcs
    end;

    Yinc := 0;
    if RNew.Bottom <= FGCache.FixedHeight+GetBorderWidth then
      Yinc := -1              // hidden at the top of fixedheight line
    else
    if (RNew.Top >= CHeight) then
      YInc := 1               // hidden at the bottom of clientheight line
    else
    if (RNew.Top > FGCache.FixedHeight+GetBorderWidth) and
       (RNew.Top < CHeight) and (CHeight < RNew.Bottom) and
       (not (xgoDontScrollPartCell in Options)) then begin
      Yinc := 1;              // partially visible at bottom
      FGCache.TLRowOff := 0;  // cancel row-offset for next calcs
    end;

    {$IFDEF dbgGridScroll}
    with FTopLeft,RNew,FGCache do
    DebugLn('  TL.C=%d TL.R=%d RNew:L=%d T=%d R=%d B=%d Xinc=%d YInc=%d ColOff=%d RowOff=%d',
      [X,Y,Left,Top,Right,Bottom,XInc,YInc,TLColOff,TLRowOff]);
    {$ENDIF}

    with FTopLeft do
    if ((XInc=0)and(YInc=0)) or // the cell is already visible
       ((X=aCol)and(Y=aRow)) or // the cell is visible by definition
       ((X+XInc<0)or(Y+Yinc<0)) or // topleft can't be lower 0
       ((X+XInc>=ColCount)) or // leftmost column can't be equal/higher than colcount
       ((Y+Yinc>=RowCount)) // topmost column can't be equal/higher than rowcount
    then
      Break;
    Inc(FTopLeft.x, XInc);
    Inc(FTopLeft.y, YInc);
  end;

  Result:=not PointIgual(OldTopleft,FTopLeft);
  if result then begin
    // current TopLeft has changed, reset ColOffset or RowOffset
    // because these values are not valid for new TopLeft column/row.
    if OldTopLeft.x<>FTopLeft.x then
      FGCache.TLColOff:=0;
    if OldTopLeft.y<>FTopLeft.y then
      FGCache.TLRowOff:=0;
    doTopleftChange(False);
  end else
  if not (xgoSmoothScroll in Options) or wResetOffs then
    ResetOffset(True, True);

end;

{Returns a valid TopLeft from a proposed TopLeft[DCol,DRow] which are
 relative or absolute coordinates }
function TCustomXGrid.ScrollGrid(Relative: Boolean; DCol, DRow: Integer): TPoint;
begin
  Result:=FTopLeft;
  if not Relative then begin
    DCol:=DCol-Result.x;
    DRow:=DRow-Result.y;
  end;

  if DCol<>0 then begin
    if DCol+Result.x<FFixedCols then DCol:=Result.x-FFixedCols else
    if DCol+Result.x>ColCount-1 then DCol:=ColCount-1-Result.x;
  end;
  if DRow<>0 then begin
    if DRow+Result.y<FFixedRows then DRow:=Result.y-FFixedRows else
    if DRow+Result.y>RowCount-1 then DRow:=RowCount-1-Result.y;
  end;

  Inc(Result.x, DCol);
  Inc(Result.y, DRow);
end;

procedure TCustomXGrid.TopLeftChanged;
begin
  if Assigned(OnTopLeftChanged) and not (csDesigning in ComponentState) then
    OnTopLeftChanged(Self);
end;

procedure TCustomXGrid.HeaderClick(IsColumn: Boolean; index: Integer; P: TPoint
  );
{var
  ColOfs: Integer;}
begin
  {if IsColumn and FColumnClickSorts then begin
    // Prepare glyph images if not done already.
    if FTitleImageList = nil then
      FTitleImageList := TImageList.Create(Self);
    if FAscImgInd = -1 then begin
      FAscImgInd := TitleImageList.AddLazarusResource('sortasc');
      FDescImgInd := TitleImageList.AddLazarusResource('sortdesc');
    end;
    // Determine the sort order.
    if index = FSortColumn then begin
      case FSortOrder of        // Same column clicked again -> invert the order.
        soxAscending:  FSortOrder:=soxDescending;
        soxDescending: FSortOrder:=soxAscending;
      end;
    end
    else begin
      FSortOrder := soxAscending;          // Ascending order to start with.
      // Remove glyph from previous column.
      ColOfs := FSortColumn - FFixedCols;
      if (ColOfs > -1) and (ColOfs < FColumns.Count ) then
        with FColumns[ColOfs].Title do
          ImageIndex := FOldImageIndex;
    end;
    // Show the sort glyph only if clicked column has a TxGridColumn defined.
    ColOfs := index - FFixedCols;
    if (ColOfs > -1) and (ColOfs < FColumns.Count)
    and (FAscImgInd < TitleImageList.Count)
    and (FDescImgInd < TitleImageList.Count) then
      with FColumns[ColOfs].Title do begin
        // Save previous ImageIndex of the clicked column.
        if (index <> FSortColumn) then
          FOldImageIndex := ImageIndex;
        case FSortOrder of                // Show the right sort glyph.
          soxAscending:  ImageIndex := FAscImgInd;
          soxDescending: ImageIndex := FDescImgInd;
        end;
      end;
    FSortColumn := index;
    Sort(True, index, FFixedRows, RowCount-1);
  end; }
end;

procedure TCustomXGrid.HeaderSized(IsColumn: Boolean; index: Integer);
begin
end;

procedure TCustomXGrid.ColRowMoved(IsColumn: Boolean; FromIndex,ToIndex: Integer);
begin
end;

procedure TCustomXGrid.ColRowExchanged(IsColumn: Boolean; index,
  WithIndex: Integer);
begin
end;

procedure TCustomXGrid.ColRowInserted(IsColumn: boolean; index: integer);
begin
end;

procedure TCustomXGrid.DrawFocusRect(aCol, aRow: Integer; ARect: TRect);
begin
end;

procedure TCustomXGrid.AutoAdjustColumn(aCol: Integer);
begin
end;

procedure TCustomXGrid.SizeChanged(OldColCount, OldRowCount: Integer);
begin
end;

procedure TCustomXGrid.ColRowDeleted(IsColumn: Boolean; index: Integer);
begin
end;

function TCustomXGrid.CanEditShow: Boolean;
begin
  Result := EditingAllowed(FCol) and not (csDesigning in ComponentState)
            and CanFocus;
end;

procedure TCustomXGrid.Paint;
{$ifdef DbgPaint}
var
  R: TRect;
{$endif}
begin
  //
  {$ifdef DbgPaint}
  R := Canvas.ClipRect;
  DebugLn('TCustomXGrid.Paint %s Row=%d Clip=%s',[DbgSName(Self),Row,Dbgs(R)]);
  {$endif}
  if gfxVisualChange in fGridFlags then begin
    {$ifdef DbgVisualChange}
    DebugLnEnter('Resetting Sizes in Paint INIT');
    {$endif}
    FGridFlags := FGridFlags + [gfxPainting];
    ResetSizes;
    FGridFlags := FGridFlags - [gfxVisualChange, gfxPainting];
    {$ifdef DbgVisualChange}
    DebugLnExit('Resetting Sizes in Paint DONE');
    {$endif}
  end;
  inherited Paint;
  if FUpdateCount=0 then begin
    DrawEdges;
    DrawAllRows;
    DrawColRowMoving;
    DrawBorder;
  end;
end;

procedure TCustomXGrid.PickListItemSelected(Sender: TObject);
begin
  if Assigned(OnPickListSelect) then
    OnPickListSelect(Self);
end;

function TCustomXGrid.RowHighLightUse: Boolean;
begin
  Result := False;
end;

procedure TCustomXGrid.DoRowHighLight(aCol, aRow: Integer;
  aState: TxGridDrawState);
begin

end;

procedure TCustomXGrid.PrepareCanvas(aCol, aRow: Integer; aState: TxGridDrawState);
var
  AColor: TColor;
  CurrentTextStyle: TTextStyle;
  IsSelected, Bl: boolean;
  ColumnFont: TFont;
  ARGBColor, ARGBWhite: LongInt;
  R, G, B: Byte;

begin
  if DefaultDrawing then begin
    Canvas.Pen.Mode := pmCopy;
    GetSelectedState(aState, IsSelected);
    if IsSelected then
    begin
      if Focused then
        Canvas.Brush.Color := SelectedColor
      else
        Canvas.Brush.Color := SelectedUnfocusedColor;
      SetCanvasFont(GetColumnFont(aCol, False));
      if not IsCellButtonColumn(point(aCol,aRow)) then
          Canvas.Font.Color := clHighlightText;
      FLastFont:=nil;
    end
    else
    begin
      AColor := GetColumnColor(aCol, xgdFixed in AState);
      if (xgdFixed in AState) and (xgdHot in aState) then
        aColor := FFixedHotColor;
      if not (xgdFixed in AState) and (FAlternateColor<>AColor) then
      begin
        if AColor=Color then
        begin
          // column color = grid Color, Allow override color
          // 1. default color after fixed rows
          // 2. always use absolute alternate color based in odd & even row
          if (FAltColorStartNormal and Odd(ARow-FixedRows)) {(1)} or
             (not FAltColorStartNormal and Odd(ARow)) {(2)} then
              AColor := FAlternateColor;
        end;
      end;



      if (xgoRowHightLight in FOptions) and (Row = aRow) then
      begin
        if (AColor = clWindow) or (AColor = clWhite) then AColor := RowHighLightColor
        else
        begin
          ARGBColor := ColorToRGB(AColor);
          R := GetRValue(ARGBColor);
          G := GetGValue(ARGBColor);
          B := GetBValue(ARGBColor);
          if R > 30 then R := R - 30
          else R := 0;
          if G > 30 then G := G - 30
          else G := 0;
          if B > 30 then B := B - 30
          else B := 0;
          AColor := RGBToColor(R, G, B);
        end;
      end;

      Canvas.Brush.Color := AColor;
      if not RowHighLightUse then
        SetCanvasFont(GetColumnFont(aCol, ((xgdFixed in aState) and (aRow < FFixedRows))))
      else
      begin
        Bl := (xgdFixed in aState) and (aRow < FFixedRows);
        ColumnFont := GetColumnFont(aCol, Bl);
        SetCanvasFont(ColumnFont);
        //Canvas.Font := ColumnFont;

        if Bl then  Canvas.Font.Color := ColumnFont.Color
        else
        if (((xgoRowHightLight in FOptions) or (xgoRowSelect in FOptions)) and (Row <> aRow))
          or (not (xgoRowHightLight in FOptions) and not (xgoRowSelect in FOptions))
          and not (xgdFixed in aState) then
            DoRowHighLight(aCol, aRow, aState);

      end;
    end;
    CurrentTextStyle := DefaultTextStyle;
    CurrentTextStyle.Alignment := BidiFlipAlignment(GetColumnAlignment(aCol, xgdFixed in AState), UseRightToLeftAlignment);
    CurrentTextStyle.Layout := GetColumnLayout(aCol, xgdFixed in AState);
    CurrentTextStyle.ShowPrefix := ((xgdFixed in aState) and (aRow < FFixedRows)) and GetTitleShowPrefix(aCol);
    CurrentTextStyle.RightToLeft := UseRightToLeftReading;
    CurrentTextStyle.EndEllipsis := (xgoCellEllipsis in Options);
    Canvas.TextStyle := CurrentTextStyle;
  end else begin
    Canvas.TextStyle := DefaultTextStyle;
    Canvas.Brush.Color := clWindow;
    Canvas.Font.Color := clWindowText;
  end;

  DoPrepareCanvas(aCol, aRow, aState);
end;

procedure TCustomXGrid.PrepareCellHints(ACol, ARow: Integer);
begin
end;

procedure TCustomXGrid.UnprepareCellHints;
begin
end;

procedure TCustomXGrid.ResetEditor;
begin
  EditorGetValue(True);
  if EditorAlwaysShown then
    EditorShow(True);
end;

procedure TCustomXGrid.ResetHotCell;
begin
  with FGCache do begin
    if HotCellPainted and (HotCell.x < ColCount) and (HotCell.y < RowCount) then
      InvalidateCell(HotCell.X, HotCell.Y);
    HotCell := Point(-1,-1);
    HotCellPainted := False;
    HotGridZone := xgzInvalid;
  end;
end;

procedure TCustomXGrid.ResetPushedCell(ResetColRow: boolean=True);
begin
  with FGCache do begin
    if ClickCellPushed then
      InvalidateCell(PushedCell.X, PushedCell.Y);
    if ResetColRow then
      PushedCell := Point(-1,-1);
    ClickCellPushed := False;
  end;
end;

procedure TCustomXGrid.ResetOffset(chkCol, ChkRow: Boolean);
begin
  with FGCache do begin
    if ChkCol then ChkCol:=TLColOff<>0;
    if ChkCol then TlColOff:=0;
    if ChkRow then ChkRow:=TLRowOff<>0;
    if ChkRow then TlRowOff:=0;
    if ChkRow or ChkCol then begin
      CacheVisibleGrid;
      Invalidate;
    end;
  end;
end;

procedure TCustomXGrid.ResizeColumn(aCol, aWidth: Integer);
begin
  if aWidth<0 then
    aWidth:=0;
  ColWidths[aCol] := aWidth;
end;

procedure TCustomXGrid.ResizeRow(aRow, aHeight: Integer);
begin
  if aHeight<0 then
    aHeight:=0;
  RowHeights[aRow] := aHeight;
end;

procedure TCustomXGrid.HeaderSizing(const IsColumn: boolean; const AIndex,
  ASize: Integer);
begin
end;

procedure TCustomXGrid.ShowCellHintWindow(APoint: TPoint);
var
  cell: TPoint;
  txt1, txt2, txt: String;
  w: Integer;
  gds: TxGridDrawState;
begin
  if ([xgoCellHints, xgoTruncCellHints]*Options = []) then
    exit;

  cell := MouseToCell(APoint);
  if (cell.x = -1) or (cell.y = -1) then
    exit;

  txt := '';
  txt1 := '';
  txt2 := '';
  PrepareCellHints(cell.x, cell.y); // in DBGrid, set the active record to cell.y
  try
    if (xgoCellHints in Options) then
      txt1 := GetCellHintText(cell.x, cell.y);
    if (xgoTruncCellHints in Options) then begin
      txt2 := GetTruncCellHintText(cell.x, cell.y);
      gds := GetGridDrawState(cell.x, cell.y);
      PrepareCanvas(cell.x, cell.y, gds);
      w := Canvas.TextWidth(txt2) + xconstCellPadding*2;
      if w < ColWidths[cell.x] then
        txt2 := '';
    end;
  finally
    UnprepareCellHints;
  end;

  if FCellHintPriority = chpxTruncOnly then begin
    if (txt2 <> '') then
      txt := txt2
    else
      txt := txt1;
  end else begin
    if (txt1 <> '') and (txt2 <> '') then
      txt := txt1 + #13 + txt2
    else if txt1 <> '' then
      txt := txt1
    else if txt2 <> '' then
      txt := txt2;
    if (FCellHintPriority = chpxAll) and (txt <> '') then
      txt := FSavedHint + #13 + txt;
  end;
  if (txt = '') and (FSavedHint <> '') then
    txt := FSavedHint;

  if (txt <> '') and not EditorMode and not (csDesigning in ComponentState) then begin
    Hint := txt;
    Application.ActivateHint(APoint, true);
  end else
    HideCellHintWindow;
end;

procedure TCustomXGrid.HideCellHintWindow;
begin
  Hint := FSavedHint;
  Application.CancelHint;
end;

function TCustomXGrid.SelectCell(ACol, ARow: Integer): Boolean;
begin
  Result:=true;
  //Result:=MoveExtend(False, aCol, aRow);
end;

procedure TCustomXGrid.SetCanvasFont(aFont: TFont);
begin
  if (aFont<>FLastFont) or
    not Canvas.Font.IsEqual(aFont) then
  begin
    Canvas.Font := aFont;
    FLastFont := AFont;
  end;
end;

procedure TCustomXGrid.SetColor(Value: TColor);
begin
  if AlternateColor = Color then
    FAlternateColor := Value;
  inherited SetColor(Value);
end;

procedure TCustomXGrid.SetColRow(const ACol, ARow: Integer);
begin
  FCol := ACol;
  FRow := ARow;
  UpdateSelectionRange;
end;

procedure TCustomXGrid.DrawBorder;
var
  R: TRect;
begin
  if InternalNeedBorder then begin
    R := Rect(0,0,ClientWidth-1, Clientheight-1);
    with R, Canvas do begin
      Pen.Color := fBorderColor;
      Pen.Width := 1;
      MoveTo(0,0);
      LineTo(0,Bottom);
      LineTo(Right, Bottom);
      LineTo(Right, 0);
      LineTo(0,0);
    end;
  end;
end;

procedure TCustomXGrid.DrawColRowMoving;
{$ifdef AlternativeMoveIndicator}
var
  x, y, dx, dy: Integer;
  R: TRect;
{$endif}
begin
  if (FGridState=xgsColMoving)and(fMoveLast.x>=0) then begin
    {$ifdef AlternativeMoveIndicator}
    dx := 4;
    dy := 4;
    Canvas.pen.Width := 1;
    Canvas.Pen.Color := clBlack;
    Canvas.Brush.Color := clWhite;
    R := CellRect(FMoveLast.X, 0);
    Y := R.Top + (R.Bottom-R.Top) div 2;
    X := R.Left - 2*dx;
    Canvas.Polygon([Point(x,y+dy),point(x,y-dy),point(x+dx,y), point(x,y+dy)]);
    X := R.Left + 2*dx;
    Canvas.Polygon([Point(x,y+dy),point(x,y-dy),point(x-dx,y), point(x,y+dy)]);
    {$else}
    Canvas.Pen.Width:=3;
    Canvas.Pen.Color:=clRed;
    Canvas.MoveTo(fMoveLast.y, 0);
    Canvas.Lineto(fMovelast.y, FGCache.MaxClientXY.Y);
    Canvas.Pen.Width:=1;
    {$endif}
  end else
  if (FGridState=xgsRowMoving)and(FMoveLast.y>=0) then begin
    {$ifdef AlternativeMoveIndicator}
    dx := 4;
    dy := 4;
    Canvas.pen.Width := 1;
    Canvas.Pen.Color := clBlack;
    Canvas.Brush.Color := clWhite;
    R := CellRect(0, FMoveLast.Y);
    X := R.Left + (R.Right-R.Left) div 2;
    Y := R.Top - 2*dy;
    Canvas.Polygon([Point(x-dx,y),point(x+dx,y),point(x,y+dy), point(x-dx,y)]);
    Y := R.Top + 2*dy;
    Canvas.Polygon([Point(x-dx,y),point(x+dx,y),point(x,y-dy), point(x-dx,y)]);
    {$else}
    Canvas.Pen.Width:=3;
    Canvas.Pen.Color:=clRed;
    if UseRightToLeftAlignment then begin
      Canvas.MoveTo(FGCache.ClientRect.Right, FMoveLast.X);
      Canvas.LineTo(FlipX(FGCache.MaxClientXY.X), FMoveLast.X);
    end
    else begin
      Canvas.MoveTo(0, FMoveLast.X);
      Canvas.LineTo(FGCache.MaxClientXY.X, FMoveLast.X);
    end;
    Canvas.Pen.Width:=1;
    {$endif}
  end;
end;

procedure TCustomXGrid.DrawColumnText(aCol, aRow: Integer; aRect: TRect;
  aState: TxGridDrawState);
var
  c: TxGridColumn;
begin
  c := ColumnFromGridColumn(ACol);
  if (C <> nil) and (C.Title.ImageIndex >= 0) and (TitleImageList <> nil) then
    DrawColumnTitleImage(aRect, aCol, C.Title.ImageIndex);
  DrawCellText(aCol,aRow,aRect,aState,GetColumnTitle(aCol));
end;

procedure TCustomXGrid.DrawColumnTitleImage(var ARect: TRect;
  AColumnIndex: Integer; AIndex: Integer);
const
  BORDER = 2;
var
  c: TxGridColumn;
  w, h, rw, rh: Integer;
  needStretch: Boolean;
  r: TRect;
begin
  if TitleImageList = nil then exit;
  c := ColumnFromGridColumn(AColumnIndex);
  if
    (c = nil) or
    not InRange(AIndex, 0, TitleImageList.Count - 1)
  then
    exit;
  w := TitleImageList.Width;
  h := TitleImageList.Height;
  rw := ARect.Right - ARect.Left - BORDER * 2;
  rh := ARect.Bottom - ARect.Top - BORDER * 2;
  if rw < w then begin
    w := rw;
    needStretch := true;
  end;
  if rh < h then begin
    h := rh;
    needStretch := true;
  end;
  case c.Title.ImageLayout of
    blGlyphRight, blGlyphLeft:
      r.Top := ARect.Top + (rh - h) div 2 + BORDER;
    blGlyphTop, blGlyphBottom:
      r.Left := ARect.Left + (rw - w) div 2 + BORDER;
  end;
  case c.Title.ImageLayout of
    blGlyphRight: begin
      Dec(ARect.Right, w + BORDER * 2);
      r.Left := ARect.Right + BORDER;
    end;
    blGlyphLeft: begin
      r.Left := ARect.Left + BORDER;
      Inc(ARect.Left, w + BORDER * 2);
    end;
    blGlyphTop: begin
      r.Top := ARect.Top + BORDER;
      Inc(ARect.Top, w + BORDER * 2);
    end;
    blGlyphBottom: begin
      Dec(ARect.Bottom, w + BORDER * 2);
      r.Top := ARect.Bottom + BORDER;
    end;
  end;
  if needStretch then begin
    r.Right := r.Left + w;
    r.Bottom := r.Top + h;
    TitleImageList.StretchDraw(Canvas, AIndex, r);
  end
  else
    TitleImageList.Draw(Canvas, r.Left, r.Top, AIndex);
end;

procedure TCustomXGrid.DrawCell(aCol, aRow: Integer; aRect: TRect;
  aState: TxGridDrawState);
begin
  PrepareCanvas(aCol, aRow, aState);
  DrawFillRect(Canvas, aRect);
  DrawCellGrid(aCol,aRow,aRect,aState);
end;

procedure TCustomXGrid.DrawAllRows;
var
  i: Integer;
begin
  // Draw Rows
  with FGCache.VisibleGrid do
    for i:=Top to Bottom do
      DrawRow(i);
  // Draw Fixed Rows
  for i:=0 to FFixedRows-1 do
    DrawRow(i);
end;

procedure TCustomXGrid.DrawFillRect(aCanvas: TCanvas; R: TRect);
begin
  if UseRightToLeftAlignment then
    OffsetRect(R, 1, 0);
  aCanvas.FillRect(R);
end;

function VerticalIntersect(const aRect,bRect: TRect): boolean;
begin
  result := (aRect.Top < bRect.Bottom) and (aRect.Bottom > bRect.Top);
end;

function HorizontalIntersect(const aRect,bRect: TRect): boolean;
begin
  result := (aRect.Left < bRect.Right) and (aRect.Right > bRect.Left);
end;

procedure TCustomXGrid.DrawRow(aRow: Integer);
var
  gds: TxGridDrawState;
  aCol: Integer;
  Rs: Boolean;
  R: TRect;
  ClipArea: Trect;

  procedure DoDrawCell;
  var
    Rgn: HRGN;
  begin
    with FGCache do begin
      if (aCol=HotCell.x) and (aRow=HotCell.y) and not IsPushCellActive() then begin
        Include(gds, xgdHot);
        HotCellPainted := True;
      end;
      if ClickCellPushed and (aCol=PushedCell.x) and (aRow=PushedCell.y) then begin
        Include(gds, xgdPushed);
      end;
    end;

    Canvas.SaveHandleState;
    try
      Rgn := CreateRectRgn(R.Left, R.Top, R.Right, R.Bottom);
      SelectClipRgn(Canvas.Handle, Rgn);
      DrawCell(aCol, aRow, R, gds);
      DeleteObject(Rgn);
    finally
      Canvas.RestoreHandleState;
    end;
  end;
begin

  // Upper and Lower bounds for this row
  ColRowToOffSet(False, True, aRow, R.Top, R.Bottom);
  // is this row within the ClipRect?
  ClipArea := Canvas.ClipRect;
  if (R.Top>=R.Bottom) or not VerticalIntersect(R, ClipArea) then begin
    {$IFDEF DbgVisualChange}
    DebugLn('Drawrow: Skipped row: ', IntToStr(aRow));
    {$ENDIF}
    exit;
  end;

  // Draw columns in this row
  with FGCache.VisibleGrid do begin
    for aCol:=left to Right do begin
      ColRowToOffset(True, True, aCol, R.Left, R.Right);
      if (R.Left>=R.Right) or not HorizontalIntersect(R, ClipArea) then
        continue;
      Rs := (xgoRowSelect in Options);
      gds := GetGridDrawState(ACol, ARow);
      DoDrawCell;
    end;

    // Draw the focus Rect
    if FFocusRectVisible and (ARow=FRow) and
       ((Rs and (ARow>=Top) and (ARow<=Bottom)) or IsCellVisible(FCol,ARow))
    then begin
      if EditorMode then begin
      //if EditorAlwaysShown and (FEditor<>nil) and FEditor.Visible then begin
        //DebugLn('No Draw Focus Rect');
      end else begin
        ColRowToOffset(True, True, FCol, R.Left, R.Right);
        // is this column within the ClipRect?
        if HorizontalIntersect(R, ClipArea) then
          DrawFocusRect(FCol,FRow, R);
      end;
    end;

  end;


  // Draw Fixed Columns
  For aCol:=0 to FFixedCols-1 do begin
    gds:=[xgdFixed];
    ColRowToOffset(True, True, aCol, R.Left, R.Right);
    // is this column within the ClipRect?
    if (R.Left<R.Right) and HorizontalIntersect(R, ClipArea) then
      DoDrawCell;
  end;
end;

procedure TCustomXGrid.EditButtonClicked(Sender: TObject);
begin
  //Копнин
  //if Assigned(OnEditButtonClick) or Assigned(OnButtonClick) then begin
    if Sender=FButtonEditor then
      DoEditButtonClick(FButtonEditor.Col, FButtonEditor.Row)
    else
      DoEditButtonClick(FCol, FRow);
  //end;
end;

procedure TCustomXGrid.DrawEdges;
var
  P:  TPoint;
  Cr: TRect;
begin
  P:=FGCache.MaxClientXY;
  Cr:=Bounds(0,0, FGCache.ClientWidth, FGCache.ClientHeight);
  if P.x<Cr.Right then begin
    if UseRightToLeftAlignment then
      Cr.Right:=Cr.Right - P.x
    else
      Cr.Left:=P.x;
    Canvas.Brush.Color:= Color;
    Canvas.FillRect(cr);
    if UseRightToLeftAlignment then begin
      Cr.Left := Cr.Right;
      Cr.Right:=FGCache.ClientWidth;
    end
    else begin
      Cr.Right:=Cr.Left;
      Cr.Left:=0;
    end;
  end;
  if P.y<Cr.Bottom then begin
    Cr.Top:=p.y;
    Canvas.Brush.Color:= Color;
    Canvas.FillRect(cr);
  end;
end;

procedure TCustomXGrid.DrawCellGrid(aCol,aRow: Integer; aRect: TRect; aState: TxGridDrawState);
var
  dv,dh: Boolean;
begin

  with Canvas, aRect do begin

    // fixed cells
    if (xgdFixed in aState) then begin
      Dv := xgoFixedVertLine in Options;
      Dh := xgoFixedHorzLine in Options;
      Pen.Style := psSolid;
      if FGridLineWidth > 0 then
        Pen.Width := 1
      else
        Pen.Width := 0;
      if not FFlat then begin
        if FTitleStyle=tsxNative then
          exit
        else
        if FGridLineWidth > 0 then begin
          if xgdPushed in aState then
            Pen.Color := cl3DShadow
          else
            Pen.Color := cl3DHilight;
          if UseRightToLeftAlignment then begin
            //the light still on the left but need to new x
            MoveTo(Right, Top);
            LineTo(Left + 1, Top);
            LineTo(Left + 1, Bottom);
          end else begin
            MoveTo(Right - 1, Top);
            LineTo(Left, Top);
            LineTo(Left, Bottom);
          end;
          if FTitleStyle=tsxStandard then begin
            // more contrast
            if xgdPushed in aState then
              Pen.Color := cl3DHilight
            else
              Pen.Color := cl3DShadow;
            if UseRightToLeftAlignment then begin
              MoveTo(Left+2, Bottom-2);
              LineTo(Right, Bottom-2);
              LineTo(Right, Top);
            end else begin
              MoveTo(Left+1, Bottom-2);
              LineTo(Right-2, Bottom-2);
              LineTo(Right-2, Top);
            end;
          end;
        end;
      end;
      Pen.Color := cl3DDKShadow;
    end else begin
      Dv := xgoVertLine in Options;
      Dh := xgoHorzLine in Options;
      Pen.Style := fGridLineStyle;
      Pen.Color := fGridLineColor;
      Pen.Width := fGridLineWidth;
    end;

    // non-fixed cells
    if fGridLineWidth > 0 then begin
      if Dh then begin
        MoveTo(Left, Bottom - 1);
        LineTo(Right, Bottom - 1);
      end;
      if Dv then begin
        if UseRightToLeftAlignment then begin
          MoveTo(Left, Top);
          LineTo(Left, Bottom);
        end else begin
          MoveTo(Right - 1, Top);
          LineTo(Right - 1, Bottom);
        end;
      end;
    end;

  end; // with canvas,rect
end;

procedure TCustomXGrid.DrawTextInCell(aCol, aRow: Integer; aRect: TRect;
  aState: TxGridDrawState);
begin
  //
end;

procedure TCustomXGrid.DrawThemedCell(aCol, aRow: Integer; aRect: TRect;
  aState: TxGridDrawState);
var
  details: TThemedElementDetails;
begin
  if xgdPushed in aState then
    Details := ThemeServices.GetElementDetails(thHeaderItemPressed)
  else
  if xgdHot in aState then
    Details := ThemeServices.GetElementDetails(thHeaderItemHot)
  else
    Details := ThemeServices.GetElementDetails(thHeaderItemNormal);
  ThemeSErvices.DrawElement(Canvas.Handle, Details, aRect, nil);
end;

procedure TCustomXGrid.DrawCellText(aCol, aRow: Integer; aRect: TRect;
  aState: TxGridDrawState; aText: String);
begin
  with ARect do begin

    dec(Right, xconstCellPadding);
    case Canvas.TextStyle.Alignment of
      Classes.taLeftJustify: Inc(Left, xconstCellPadding);
      Classes.taRightJustify: Dec(Right, 1);
    end;
    case Canvas.TextStyle.Layout of
      tlTop: Inc(Top, xconstCellPadding);
      tlBottom: Dec(Bottom, xconstCellPadding);
    end;

    if Right<Left then
      Right:=Left;
    if Left>Right then
      Left:=Right;
    if Bottom<Top then
      Bottom:=Top;
    if Top>Bottom then
      Top:=Bottom;

    if (Left<>Right) and (Top<>Bottom) then
      Canvas.TextRect(aRect,Left,Top, aText);
  end;
end;

procedure TCustomXGrid.DrawGridCheckboxBitmaps(const aCol,aRow: Integer;
  const aRect: TRect; const aState: TCheckboxState);
const
  arrtb:array[TCheckboxState] of TThemedButton =
    (tbCheckBoxUncheckedNormal, tbCheckBoxCheckedNormal, tbCheckBoxMixedNormal);
var
  ChkBitmap: TBitmap;
  XPos,YPos: Integer;
  details: TThemedElementDetails;
  PaintRect: TRect;
  CSize: TSize;
  bmpAlign: TAlignment;
begin

  if Columns.Enabled then
    bmpAlign := GetColumnAlignment(aCol, false)
  else
    bmpAlign := taCenter;

  if (TitleStyle=tsxNative) and not assigned(OnUserCheckboxBitmap) then begin
    Details := ThemeServices.GetElementDetails(arrtb[AState]);
    CSize := ThemeServices.GetDetailSize(Details);
    with PaintRect do begin
      case bmpAlign of
        taCenter: Left := Trunc((aRect.Left + aRect.Right - CSize.cx)/2);
        taLeftJustify: Left := ARect.Left + xconstCellPadding;
        taRightJustify: Left := ARect.Right - CSize.Cx - xconstCellPadding - 1;
      end;
      Top  := Trunc((aRect.Top + aRect.Bottom - CSize.cy)/2);
      PaintRect := Bounds(Left, Top, CSize.cx, CSize.cy);
    end;
    ThemeServices.DrawElement(Canvas.Handle, Details, PaintRect, nil);
  end else begin
    ChkBitmap := GetImageForCheckBox(aCol, aRow, AState);
    if ChkBitmap<>nil then begin
      case bmpAlign of
        taCenter: XPos := Trunc((aRect.Left+aRect.Right-ChkBitmap.Width)/2);
        taLeftJustify: XPos := ARect.Left + xconstCellPadding;
        taRightJustify: XPos := ARect.Right - ChkBitmap.Width - xconstCellPadding - 1;
      end;
      YPos := Trunc((aRect.Top+aRect.Bottom-ChkBitmap.Height)/2);
      Canvas.Draw(XPos, YPos, ChkBitmap);
    end;
  end;
end;

procedure TCustomXGrid.DrawButtonCell(const aCol, aRow: Integer; aRect: TRect;
  const aState: TxGridDrawState);
var
  details: TThemedElementDetails;
begin
  InflateRect(aRect, -2, 0);
  if xgdPushed in aState then
    Details := ThemeServices.GetElementDetails(tbPushButtonPressed)
  else
  if xgdHot in aState then
    Details := ThemeServices.GetElementDetails(tbPushButtonHot)
  else
    Details := ThemeServices.GetElementDetails(tbPushButtonNormal);
  ThemeSErvices.DrawElement(Canvas.Handle, Details, aRect, nil);
end;

procedure TCustomXGrid.OnTitleFontChanged(Sender: TObject);
begin
  FTitleFontIsDefault := False;
  if FColumns.Enabled then begin
    FColumns.TitleFontChanged;
    ColumnsChanged(nil);
  end;
end;

procedure TCustomXGrid.ReadColumns(Reader: TReader);
begin
  Columns.Clear;
  Reader.ReadValue;
  Reader.ReadCollection(Columns);
end;

procedure TCustomXGrid.ReadColWidths(Reader: TReader);
var
  i: integer;
begin
  with Reader do begin
    ReadListBegin;
    for i:=0 to ColCount-1 do
      ColWidths[I] := ReadInteger;
    ReadListEnd;
  end;
end;

procedure TCustomXGrid.ReadRowHeights(Reader: TReader);
var
  i: integer;
begin
  with Reader do begin
    ReadListBegin;
    for i:=0 to RowCount-1 do
      RowHeights[I] := ReadInteger;
    ReadListEnd;
  end;
end;

procedure TCustomXGrid.WMEraseBkgnd(var message: TLMEraseBkgnd);
begin
  message.Result:=1;
end;

procedure TCustomXGrid.WMGetDlgCode(var Msg: TLMNoParams);
begin
  Msg.Result := DLGC_WANTARROWS or DLGC_WANTCHARS or DLGC_WANTALLKEYS;
  if xgoTabs in Options then Msg.Result:= Msg.Result or DLGC_WANTTAB;
end;

procedure TCustomXGrid.WMHScroll(var message: TLMHScroll);
var
  C,TL,CTL,aPos: Integer;
  R: TRect;
  ScrollInfo: TScrollInfo;
  aCode: Smallint;

  function NextColWidth(aCol: Integer; Delta: Integer): integer;
  begin
    repeat
      result := GetColWidths(aCol);
      aCol := aCol + Delta;
    until (Result<>0) or (aCol>=ColCount) or (aCol<0);
  end;

begin

  {$IfDef dbgScroll}
  DebugLn('HSCROLL: Code=%d Position=%d',[message.ScrollCode, message.Pos]);
  {$Endif}

  if not FGCache.ValidGrid or not HandleAllocated then
    exit;

  aCode := message.ScrollCode;
  if UseRightToLeftAlignment then begin
    ScrollInfo.cbSize:=SizeOf(ScrollInfo);
    ScrollInfo.fMask:= SIF_PAGE or SIF_RANGE;
    GetScrollInfo(Handle, SB_HORZ, ScrollInfo);
    aPos := (ScrollInfo.nMax-ScrollInfo.nPage)-Message.Pos;
    case aCode of
      SB_LINERIGHT: aCode := SB_LINELEFT;
      SB_LINELEFT: aCode := SB_LINERIGHT;
      SB_PAGERIGHT: aCode := SB_PAGELEFT;
      SB_PAGELEFT: aCode := SB_PAGERIGHT;
    end;
    {$IfDef dbgScroll}
    DebugLn('HSCROLL: (RTL) Code=%d Position=%d',[aCode, aPos]);
    {$Endif}
  end else
    aPos := Message.Pos;

  with FGCache do begin
    TL:=  integer(PtrUInt(AccumWidth[ MaxTopLeft.X ])) - FixedWidth;
    CTL:= integer(PtrUInt(AccumWidth[ FTopLeft.X ])) - FixedWidth + TLColOff;
  end;

  case aCode of
    SB_TOP:        C := 0;
    SB_BOTTOM:
    begin
      if not (xgoSmoothScroll in Options) then
        TL := TL + 1;
      C := TL;
    end;
      // Scrolls one line left / right
    SB_LINERIGHT:  C := CTL + NextColWidth( FTopLeft.X, 1);
    SB_LINELEFT:   C := CTL - NextColWidth( FTopLeft.X - 1, -1);
      // Scrolls one page of lines up / down
    SB_PAGERIGHT:  C := CTL + FGCache.ClientWidth;
    SB_PAGELEFT:   C := CTL - FGCache.ClientWidth;
      // Scrolls to the current scroll bar position
    SB_THUMBPOSITION:
      C := aPos;
    SB_THUMBTRACK:
      if xgoThumbTracking in Options then
        C := aPos
      else
        Exit;
      // Ends scrolling
    SB_ENDSCROLL:
      Exit;
  end;

  {$Ifdef dbgScroll}
  DebugLn('HSCROLL: C=%d TL=%d CTL=%d',[C,TL,CTL]);
  {$Endif}

  if C > TL then C := TL else
  if C < 0 then C := 0;


  {$Ifdef dbgScroll}
  DebugLn('HSCROLL: Pos=%d FixedWidth=%d FTL.x=%d Col=%d',
    [C,FGCache.FixedWidth, FTopLeft.X, Col]);
  {$Endif}
  ScrollBarPosition(SB_HORZ, C);
  C:= C + FGCache.FixedWidth + GetBorderWidth;
  {$Ifdef dbgScroll}
  DebugLn('HSCROLL: NewPosition=%d',[C]);
  {$Endif}
  if UseRightToLeftAlignment then
    C := FlipX(C);
  //TL:=OffsetToColRow(True, False, C, FGCache.TLColOff);
  if not OffsetToColRow(True, False, C, TL, FGCache.TLColOff) then begin
    {$Ifdef dbgScroll}
    DebugLn('HSCROLL: Offset=INVALID');
    {$Endif}
    exit;
  end;
  {$Ifdef dbgScroll}
  DebugLn('HSCROLL: Offset=%d TL=%d TLColOff=%d',[C,TL,FGCache.TLColOff]);
  {$Endif}


  if TL<>FTopLeft.X then begin
    TryScrollTo(Tl, FTopLeft.Y);
  end else
  if xgoSmoothScroll in Options then begin
    CacheVisibleGrid;
    R.Topleft := Point(FGCache.FixedWidth, 0);
    R.BottomRight := Point(FGCache.ClientWidth, FGCache.ClientHeight);
    if not (csCustomPaint in ControlState) then begin
      if UseRightToLeftAlignment then begin
        C := FlipX(R.Right);
        R.Right := FlipX(R.Left)+ 1;
        R.Left := C + 1;
      end;
      InvalidateRect(Handle, @R, false);
    end;
  end;

  if EditorMode then
    EditorPos;
end;

procedure TCustomXGrid.WMVScroll(var message: TLMVScroll);
var
  C, TL, CTL: Integer;
  R: TRect;

  function NextRowHeight(aRow: Integer; Delta: Integer): integer;
  begin
    repeat
      result := GetRowHeights(aRow);
      aRow := aRow + Delta;
    until (Result<>0) or (aRow>=RowCount) or (aRow<0);
  end;

begin
  {$IfDef dbgScroll}
  DebugLn('VSCROLL: Code=%d Position=%d',[message.ScrollCode, message.Pos]);
  {$Endif}

  if not FGCache.ValidGrid or not HandleAllocated then
    exit;

  with FGCache do begin
    TL:=  integer(PtrUInt(AccumHeight[ MaxTopLeft.Y ])) - FixedHeight;
    CTL:= integer(PtrUInt(AccumHeight[ FTopLeft.Y ])) - FixedHeight + TLRowOff;
  end;

  case message.ScrollCode of
      // Scrolls to start / end of the text
    SB_TOP:        C := 0;
    SB_BOTTOM:
    begin
      if not (xgoSmoothScroll in Options) then
        TL := TL + 1;
      C := TL;
    end;
      // Scrolls one line up / down
    SB_LINEDOWN:   C := CTL + NextRowHeight(FTopleft.Y, 1);
    SB_LINEUP:     C := CTL - NextRowHeight(FTopleft.Y-1, -1);
      // Scrolls one page of lines up / down
    SB_PAGEDOWN:   C := CTL + FGCache.ClientHeight;
    SB_PAGEUP:     C := CTL - FGCache.ClientHeight;
      // Scrolls to the current scroll bar position
    SB_THUMBPOSITION:
      C := Message.Pos;
    SB_THUMBTRACK:
      if xgoThumbTracking in Options then
        C := Message.Pos
      else
        Exit;
      // Ends scrolling
    SB_ENDSCROLL: Exit;
  end;

  if C > TL then C := TL else
  if C < 0 then C := 0;

  {$Ifdef dbgScroll}
  DebugLn('VSCROLL: Pos=%d FixedHeight=%d FTL.y=%d Row=%d',
    [C,FGCache.FixedHeight, FTopLeft.Y, Row]);
  {$Endif}
  ScrollBarPosition(SB_VERT, C);
  C:= C + FGCache.FixedHeight + GetBorderWidth;
  {$Ifdef dbgScroll}
  DebugLn('VSCROLL: NewPosition=%d',[C]);
  {$Endif}
  if not OffsetToColRow(False, False, C, TL, FGCache.TLRowOff) then begin
    {$Ifdef dbgScroll}
    DebugLn('VSCROLL: Offset=INVALID');
    {$Endif}
    exit;
  end;
  {$Ifdef dbgScroll}
  DebugLn('VSCROLL: Offset=%d TL=%d TLRowOff=%d',[C,TL,FGCache.TLRowOff]);
  {$Endif}

  if not (xgoSmoothScroll in Options) then
    FGCache.TLRowOff:=0;

  if TL<>FTopLeft.Y then begin
    TryScrollTo(FTopLeft.X, Tl);
  end else
  if xgoSmoothScroll in Options then begin
    CacheVisibleGrid;
    with FGCache do
      R.TopLeft := Point(0,
        TWSCustomXGridClass(WidgetSetClass).InvalidateStartY(FixedHeight, TLRowOff));
    R.BottomRight:=FGCache.MaxClientXY;
    if FGcache.MaxClientXY.Y<FGCache.ClientHeight then
      R.BottomRight.y := FGCache.ClientHeight;
    if not (csCustomPaint in ControlState) then
      InvalidateRect(Handle, @R, false);
  end;

  if EditorMode then
    EditorPos;
end;

procedure TCustomXGrid.WMKillFocus(var message: TLMKillFocus);
begin
  {$ifdef dbgGrid}
  if csDestroying in ComponentState then exit;

  DbgOut('*** grid.WMKillFocus, FocusedWnd=%x WillFocus=',[Message.FocusedWnd]);
  if EditorMode and (Message.FocusedWnd = FEditor.Handle) then
    DebugLn('Editor')
  else begin
    DbgOut('ExternalWindow: ');
    if GetProp(Message.FocusedWnd, 'WinControl')<>nil then
      DebugLn(dbgsname(TObject(GetProp(Message.FocusedWnd, 'WinControl'))))
    else
      DebugLn(' Unknown Window');
  end;
  {$endif}
  inherited WMKillFocus(Message);
end;

procedure TCustomXGrid.WMSetFocus(var message: TLMSetFocus);
begin
  {$ifdef dbgGrid}
  DbgOut('*** grid.WMSetFocus, FocusedWnd=', dbgs(Message.FocusedWnd),'[',dbgs(pointer(Message.FocusedWnd)),'] ');
  if EditorMode and (Message.FocusedWnd = FEditor.Handle) then
    DebugLn('Editor')
  else begin
    if Message.FocusedWnd=Self.Handle then
      DebugLn('Same Grid!')
    else
      DebugLn('ExternalWindow');
  end;
  {$endif}
  inherited WMSetFocus(Message);
end;

procedure TCustomXGrid.WMChar(var message: TLMChar);
var
  Ch: Char;
begin
  Ch:=Char(message.CharCode);
  {$Ifdef GridTraceMsg}
  DebugLn(ClassName,'.WMchar CharCode= ', IntToStr(message.CharCode));
  {$Endif}
  if EditingAllowed(FCol) and (Ch in [^H, #32..#255]) then begin
    EditorShowChar(Ch);
    message.CharCode := 0;
    message.Result := 1;
  end else
    inherited;
end;

class procedure TCustomXGrid.WSRegisterClass;
begin
  inherited WSRegisterClass;
  if RegisterCustomXGrid then
  begin
    {$I dbgrid_images.lrs}
  end;
end;


procedure TCustomXGrid.WndProc(var TheMessage: TLMessage);
begin
  {$ifdef GridTraceMsg}
  TransMsg('GRID: ', TheMessage);
  {$endif}
  case TheMessage.Msg of
    LM_HSCROLL, LM_VSCROLL:
      if csDesigning in ComponentState then
        exit;
    {$IFDEF MSWINDOWS}
    // Ignore LM_SIZE while another sizing is being processed.
    // Windows sends WM_SIZE when showing/hiding scrollbars.
    // Scrollbars can be shown/hidden when processing DoOnChangeBounds.
    LM_SIZE:
      if gfxUpdatingSize in FGridFlags then
        exit;
    {$ENDIF}
  end;
  inherited WndProc(TheMessage);
end;

procedure TCustomXGrid.CreateWnd;
begin
  //DebugLn('TCustomXGrid.CreateWnd ',DbgSName(Self));
  inherited CreateWnd;
  CheckPosition;
  VisualChange;
end;

{ Scroll grid to the given Topleft[aCol,aRow] as needed }
procedure TCustomXGrid.TryScrollTo(aCol, aRow: integer);
var
  TryTL: TPoint;
  NewCol,NewRow: Integer;
begin
  TryTL:=ScrollGrid(False,aCol, aRow);
  if not PointIgual(TryTL, FTopLeft) then begin
    NewCol := TryTL.X - FTopLeft.X + Col;
    NewRow := TryTL.Y - FTopLeft.Y + Row;
    FTopLeft:=TryTL;
    {$ifdef dbgscroll}
    DebugLn('TryScrollTo: TopLeft=%s NewCol=%d NewRow=%d',
      [dbgs(FTopLeft), NewCol, NewRow]);
    {$endif}
    //
    doTopleftChange(False);
    if xgoScrollKeepVisible in Options then
      MoveNextSelectable(False, NewCol, NewRow);
  end;
end;

procedure TCustomXGrid.SetGridLineWidth(const AValue: Integer);
begin
  if FGridLineWidth = AValue then
    exit;
  FGridLineWidth := AValue;
  Invalidate;
end;

procedure TCustomXGrid.UpdateCachedSizes;
var
  i: Integer;
begin
  if AutoFillColumns then
    InternalAutoFillColumns;

  // Calculate New Cached Values
  FGCache.GridWidth:=0;
  FGCache.FixedWidth:=0;
  for i:=0 to ColCount-1 do begin
    FGCache.AccumWidth[i]:=Pointer(PtrInt(FGCache.GridWidth));
    FGCache.GridWidth:=FGCache.GridWidth + GetColWidths(i);
    if i<FixedCols then
      FGCache.FixedWidth:=FGCache.GridWidth;
  end;

  FGCache.Gridheight:=0;
  FGCache.FixedHeight:=0;
  for i:=0 to RowCount-1 do begin
    FGCache.AccumHeight[i]:=Pointer(PtrInt(FGCache.Gridheight));
    FGCache.Gridheight:=FGCache.Gridheight+GetRowHeights(i);
    if i<FixedRows then
      FGCache.FixedHeight:=FGCache.GridHeight;
  end;

  FGCache.ClientRect := ClientRect;
  FGCache.ClientWidth := ClientWidth;
  FGCache.ClientHeight := ClientHeight;

  FGCache.ScrollWidth := FGCache.ClientWidth-FGCache.FixedWidth;
  FGCache.ScrollHeight := FGCache.ClientHeight-FGCache.FixedHeight;
  FGCache.MaxTopLeft:=CalcMaxTopLeft;

  {$ifdef dbgVisualChange}
  DebugLn('TCustomXGrid.updateCachedSizes: ');
  with FGCache do
  DebugLn(' GWidth=%d GHeight=%d FWidth=%d FHeight=%d CWidth=%d CHeight=%d MTL.X=%d MTL.Y=%d',
    [GridWidth,GridHeight,FixedWidth,FixedHeight,ClientWidth,ClientHeight,
     MaxTopLeft.X, MaxTopLeft.Y]);
  {$endif}
end;

procedure TCustomXGrid.GetSBVisibility(out HsbVisible,VsbVisible:boolean);
var
  autoVert,autoHorz: boolean;
  ClientW,ClientH: Integer;
  BarW,BarH: Integer;
begin
  AutoVert := ScrollBarAutomatic(ssVertical);
  AutoHorz := ScrollBarAutomatic(ssHorizontal);

  // get client bounds free of bars
  ClientW  := ClientWidth;
  ClientH  := ClientHeight;
  BarW := GetSystemMetrics(SM_CXVSCROLL) +
          GetSystemMetrics(SM_SWSCROLLBARSPACING);
  if ScrollBarIsVisible(SB_VERT) then
    ClientW := ClientW + BarW;
  BarH := GetSystemMetrics(SM_CYHSCROLL) +
          GetSystemMetrics(SM_SWSCROLLBARSPACING);
  if ScrollBarIsVisible(SB_HORZ) then
    ClientH := ClientH + BarH;

  // first find out if scrollbars need to be visible by
  // comparing against client bounds free of bars
  HsbVisible := (FScrollBars in [ssHorizontal, ssBoth]) or
                (AutoHorz and (FGCache.GridWidth>ClientW));

  VsbVisible := (FScrollBars in [ssVertical, ssBoth]) or
                (AutoVert and (FGCache.GridHeight>ClientH));

  // then for automatic scrollbars check if grid bounds are
  // in some part of area occupied by scrollbars
  if not HsbVisible and AutoHorz and VsbVisible then
    HsbVisible := FGCache.GridWidth  > (ClientW-BarW);

  if not VsbVisible and AutoVert and HsbVisible then
    VsbVisible := FGCache.GridHeight > (ClientH-BarH);

  if AutoHorz then
    HsbVisible := HsbVisible and not AutoFillColumns;

  // update new cached client values according to visibility
  // of scrollbars
  if HsbVisible then
    FGCache.ClientHeight := ClientH - BarH;
  if VsbVisible then
    FGCache.ClientWidth := ClientW - BarW;

  {$ifdef dbgscroll}
  DebugLn('TCustomXGrid.GetSBVisibility:');
  DebugLn(['  Horz=',HsbVisible,' GW=',FGCache.GridWidth,
    ' CW=',ClientWidth,' CCW=',FGCache.ClientWidth,' BarW=',BarW]);
  DebugLn(['  Vert=',VsbVisible,' GH=',FGCache.GridHeight,
    ' CH=',ClientHeight,' CCH=',FGCache.ClientHeight,' BarH=',BarH]);
  {$endif}
end;

procedure TCustomXGrid.GetSBRanges(const HsbVisible, VsbVisible: boolean; out
  HsbRange, VsbRange, HsbPage, VsbPage, HsbPos, VsbPos: Integer);
begin
  with FGCache do begin

    HsbRange := 0;
    HsbPos := 0;
    if HsbVisible then begin
      if not (xgoSmoothScroll in Options) then begin
        if (MaxTopLeft.x>=0) and (MaxTopLeft.x<=ColCount-1) then
          HsbRange := integer(PtrUInt(AccumWidth[MaxTopLeft.x]))+ClientWidth-FixedWidth
      end
      else
        HsbRange:=GridWidth - GetBorderWidth;
      if (FTopLeft.x>=0) and (FTopLeft.x<=ColCount-1) then
        HsbPos := integer(PtrUInt(AccumWidth[FTopLeft.x]))+TLColOff-FixedWidth;
    end;

    VsbRange := 0;
    VsbPos := 0;
    if VsbVisible then begin
      if not (xgoSmoothScroll in Options) then begin
        if (MaxTopLeft.y>=0) and (MaxTopLeft.y<=RowCount-1)  then
          VsbRange := integer(PtrUInt(AccumHeight[MaxTopLeft.y]))+ClientHeight-FixedHeight
      end
      else
        VSbRange:= GridHeight - GetBorderWidth;
      if (FTopLeft.y>=0) and (FTopLeft.y<=RowCount-1) then
        VsbPos := integer(PtrUInt(AccumHeight[FTopLeft.y]))+TLRowOff-FixedHeight;
    end;

    HsbPage := ClientWidth;
    VSbPage := ClientHeight;

    {$ifdef dbgscroll}
    DebugLn('GetSBRanges: HRange=%d HPage=%d HPos=%d VRange=%d VPage=%d VPos=%d',
      [HSbRange,HsbPage,HsbPos, VsbRange, VsbPage, VsbPos]);
    {$endif}
  end;
end;

procedure TCustomXGrid.GetSelectedState(AState: TxGridDrawState; out
  IsSelected: boolean);
begin
  IsSelected := (xgdSelected in aState);
  if IsSelected and (xgdFocused in aState) then
    IsSelected := (xgoDrawFocusSelected in Options) or
          ((xgoRowSelect in Options) and not (xgoRelaxedRowSelect in Options));
end;

procedure TCustomXGrid.UpdateSBVisibility;
var
  HSbVisible, VSbVisible: boolean;
begin
  GetSBVisibility(HSbVisible, VSbVisible);
  ScrollBarShow(SB_VERT, VSbVisible);
  ScrollBarShow(SB_HORZ, HSbVisible);
end;

procedure TCustomXGrid.UpdateSizes;
begin
  Include(FGridFlags, gfxVisualChange);
  UpdateCachedSizes;
  CacheVisibleGrid;
  CalcScrollbarsRange;
end;

procedure TCustomXGrid.UpdateSelectionRange;
begin
  if xgoRowSelect in Options then begin
    FRange:=Rect(FFixedCols, FRow, ColCount-1, FRow);
  end
  else
    FRange:=Rect(FCol,FRow,FCol,FRow);
end;

procedure TCustomXGrid.WriteColumns(Writer: TWriter);
begin
  if Columns.IsDefault then
    Writer.WriteCollection(nil)
  else
    Writer.WriteCollection(Columns);
end;

procedure TCustomXGrid.WriteColWidths(Writer: TWriter);
var
  i: Integer;
begin
  with writer do begin
    WriteListBegin;
    for i:=0 to ColCount-1 do
      WriteInteger(ColWidths[i]);
    WriteListEnd;
  end;
end;

procedure TCustomXGrid.WriteRowHeights(Writer: TWriter);
var
  i: integer;
begin
  with writer do begin
    WriteListBegin;
    for i:=0 to RowCount-1 do
      WriteInteger(RowHeights[i]);
    WriteListEnd;
  end;
end;

procedure TCustomXGrid.CheckFixedCount(aCol,aRow,aFCol,aFRow: Integer);
begin
  if AFRow<0 then
    raise xEGridException.Create('FixedRows<0');
  if AFCol<0 then
    raise xEGridException.Create('FixedCols<0');

  if csLoading in ComponentState then
    exit;

  if (aCol=0)and(aFCol=0) then // fixed grid
  else if (aFCol>ACol) then
    raise xEGridException.Create(rsFixedColsTooBig);

  if (aRow=0)and(aFRow=0) then // fixed grid
  else if (aFRow>ARow) then
    raise xEGridException.Create(rsFixedRowsTooBig);
end;

procedure TCustomXGrid.CheckCount(aNewColCount, aNewRowCount: Integer; FixEditor: boolean=true);
var
  NewCol,NewRow: Integer;
begin
  if HandleAllocated then begin
    if Col >= aNewColCount then NewCol := aNewColCount-1
    else                        NewCol := Col;
    if Row >= aNewRowCount then NewRow := aNewRowCount-1
    else                        NewRow := Row;
    if (NewCol>=0) and (NewRow>=0) and ((NewCol <> Col) or (NewRow <> Row)) then
    begin
      CheckTopleft(NewCol, NewRow , NewCol<>Col, NewRow<>Row);
      if FixEditor and (aNewColCount<>FFixedCols) and (aNewRowCount<>FFixedRows) then
        MoveNextSelectable(false, NewCol, NewRow);
    end;
  end;
end;

procedure TCustomXGrid.CheckIndex(IsColumn: Boolean; Index: Integer);
begin
  if (IsColumn and ((Index<0) or (Index>ColCount-1))) or
     (not IsColumn and ((Index<0) or (Index>RowCount-1))) then
    raise xEGridException.Create(rsGridIndexOutOfRange);
end;

function TCustomXGrid.CheckTopLeft(aCol,aRow: Integer; CheckCols, CheckRows: boolean): boolean;
var
  OldTopLeft: TPoint;
  W: Integer;
begin
  OldTopLeft := FTopLeft;
  Result:= False;

  with FTopleft do begin
    if CheckCols and (X>FixedCols) then begin
      W := FGCache.ScrollWidth-ColWidths[aCol]-integer(PtrUInt(FGCache.AccumWidth[aCol]));
      while (x>FixedCols)and(W+integer(PtrUInt(FGCache.AccumWidth[x]))>=ColWidths[x-1]) do
      begin
        Dec(x);
      end;
    end;
  end;

  with FTopleft do begin
    if CheckRows and (Y > FixedRows) then begin
      W := FGCache.ScrollHeight-RowHeights[aRow]-integer(PtrUInt(FGCache.AccumHeight[aRow]));
      while (y>FixedRows)and(W+integer(PtrUInt(FGCache.AccumHeight[y]))>=RowHeights[y-1]) do
      begin
        Dec(y);
      end;
      //DebugLn('TCustomXGrid.CheckTopLeft A ',DbgSName(Self),' FTopLeft=',dbgs(FTopLeft));
    end;
  end;

  Result := not PointIgual(OldTopleft,FTopLeft);
  if Result then
    doTopleftChange(False)
end;

function TCustomXGrid.IsCellButtonColumn(ACell: TPoint): boolean;
var
  Column: TxGridColumn;
begin
  Column := ColumnFromGridColumn(ACell.X);
  result := (Column<>nil) and (Column.ButtonStyle=cbsxButtonColumn) and
            (ACell.y>=FixedRows);
end;

function TCustomXGrid.GetIsCellTitle(aCol, aRow: Integer): boolean;
begin
  result := (FixedRows>0) and (aRow=0) and Columns.Enabled and (aCol>=FirstGridColumn)
end;

function TCustomXGrid.GetIsCellSelected(aCol, aRow: Integer): boolean;
begin
  Result:=  (FRange.Left<=aCol)   and
            (aCol<=FRange.Right)  and
            (FRange.Top<=aRow)    and
            (aRow<=FRange.Bottom);
end;

function TCustomXGrid.GetSelectedColumn: TxGridColumn;
begin
  Result := ColumnFromGridColumn(Col);
end;

function TCustomXGrid.IsDefRowHeightStored: boolean;
begin
  result := (gfxDefRowHeightChanged in GridFlags);
end;

function TCustomXGrid.IsAltColorStored: boolean;
begin
  result := FAlternateColor <> Color;
end;

procedure TCustomXGrid.SetAlternateColor(const AValue: TColor);
begin
  if FAlternateColor=AValue then exit;
  FAlternateColor:=AValue;
  Invalidate;
end;

function TCustomXGrid.GetEditorBorderStyle: TBorderStyle;
begin
  result := bsSingle;
  if FEditor = FstringEditor then
    Result := FStringEditor.BorderStyle
  else if FEditor = FPickListEditor then
    Result := FStringEditor.BorderStyle;
end;

function TCustomXGrid.GetBorderWidth: Integer;
begin
  if InternalNeedBorder then
    Result := 1
  else
    Result := 0
end;

function TCustomXGrid.GetImageForCheckBox(const aCol,aRow: Integer;
    CheckBoxView: TCheckBoxState): TBitmap;
begin
  if CheckboxView=cbUnchecked then
    Result := FUncheckedBitmap
  else if CheckboxView=cbChecked then
    Result := FCheckedBitmap
  else
    Result := FGrayedBitmap;

  if Assigned(OnUserCheckboxBitmap) then
    OnUserCheckboxBitmap(Self, aCol, aRow, CheckBoxView, Result);
end;


function TCustomXGrid.GetColumns: TxGridColumns;
begin
  result := FColumns;
end;

function TCustomXGrid.CreateColumns: TxGridColumns;
begin
  result := TxGridColumns.Create(Self, TxGridColumn);
end;

procedure TCustomXGrid.CheckNewCachedSizes(var AGCache:TxGridDataCache);
begin

end;

procedure TCustomXGrid.SetAutoFillColumns(const AValue: boolean);
begin
  FAutoFillColumns := AValue;
  if FAutoFillColumns then
  begin
    VisualChange;
    if FTopleft.x<>FixedCols then begin
      FTopLeft.x := FixedCols;
      TopLeftChanged;
    end;
  end;
end;

procedure TCustomXGrid.SetBorderColor(const AValue: TColor);
begin
  if FBorderColor=AValue then exit;
  FBorderColor:=AValue;
  if BorderStyle<>bsNone then
    Invalidate;
end;

{procedure TCustomXGrid.SetColumnClickSorts(const AValue: boolean);
begin
  if FColumnClickSorts=AValue then exit;
  FColumnClickSorts:=AValue;
end;}

procedure TCustomXGrid.SetColumns(const AValue: TxGridColumns);
begin
  FColumns.Assign(Avalue);
end;

procedure TCustomXGrid.SetEditorOptions(const AValue: Integer);
begin
  if FEditorOptions<>AValue then begin
    if FEditor=nil then exit;
    FEditorOptions:=AValue;
    if FEditorOptions and EO_HOOKKEYDOWN = EO_HOOKKEYDOWN then begin
      FEditor.OnKeyDown:=@EditorKeyDown;
    end;
    if FEditorOptions and EO_HOOKKEYPRESS = EO_HOOKKEYPRESS then begin
      FEditor.OnKeyPress := @EditorKeyPress;
    end;
    if FEditorOptions and EO_HOOKKEYUP = EO_HOOKKEYUP then begin
      FEditor.OnKeyUp := @EditorKeyUp;
    end;

    {$IfDef DbgGrid}
    DBGOut('SetEditor-> Editor=',FEditor.Name,' ');
    if FEditorOptions and EO_AUTOSIZE = EO_AUTOSIZE then DBGOut('EO_AUTOSIZE ');
    if FEditorOptions and EO_HOOKKEYDOWN = EO_HOOKKEYDOWN then DBGOut('EO_HOOKKEYDOWN ');
    if FEditorOptions and EO_HOOKKEYPRESS = EO_HOOKKEYPRESS then DBGOut('EO_HOOKKEYPRESS ');
    if FEditorOptions and EO_HOOKKEYUP = EO_HOOKKEYUP then DBGOut('EO_HOOKKEYUP ');
    if FEditorOptions and EO_SELECTALL= EO_SELECTALL then DBGOut('EO_SELECTALL ');
    DebugLn;
    {$Endif}
  end;
end;

procedure TCustomXGrid.SetEditorBorderStyle(const AValue: TBorderStyle);
begin
  // supposedly instances cannot access protected properties
  // of parent classes, so why the next works?
  {
  if FEditor.BorderStyle <> AValue then begin
    FEditor.BorderStyle := AValue;
    if EditorMode then
      EditorPos;
  end;
  }
  if FStringEditor.BorderStyle<>AValue then begin
    FStringEditor.BorderStyle := AValue;
    if (FEditor = FStringEditor) and EditorMode then
      EditorPos;
  end;
  if FPicklistEditor.BorderStyle<>AValue then begin
    FPicklistEditor.BorderStyle := AValue;
    if (FEditor = FPicklistEditor) and EditorMode then
      EditorPos;
  end;
end;

procedure TCustomXGrid.SetAltColorStartNormal(const AValue: boolean);
begin
  if FAltColorStartNormal=AValue then exit;
  FAltColorStartNormal:=AValue;
  if IsAltColorStored then
    Invalidate;
end;

procedure TCustomXGrid.SetFlat(const AValue: Boolean);
begin
  if FFlat=AValue then exit;
  FFlat:=AValue;
  if FGridBorderStyle=bsSingle then
    UpdateBorderStyle
  else
    Invalidate;
end;

procedure TCustomXGrid.SetFocusRectVisible(const AValue: Boolean);
begin
  if FFocusRectVisible<>AValue then begin
    FFocusRectVisible := AValue;
    Invalidate;
  end;
end;

procedure TCustomXGrid.SetTitleFont(const AValue: TFont);
begin
  FTitleFont.Assign(AValue);
  VisualChange;
end;

procedure TCustomXGrid.SetImageList(const AValue: TImageList);
begin
  if FImageList = AValue then exit;
  FImageList := AValue;
  VisualChange;
end;

procedure TCustomXGrid.SetRowHighLightColor(AValue: TColor);
begin
  if FRowHighLightColor <> AValue then
    FRowHighLightColor:=AValue;
end;

procedure TCustomXGrid.SetSelectedUnfocusedColor(AValue: TColor);
begin
  if FSelectedUnfocusedColor <> AValue then
    FSelectedUnfocusedColor:=AValue;
end;

procedure TCustomXGrid.SetTitleImageList(const AValue: TImageList);
begin
  if FTitleImageList = AValue then exit;
  FTitleImageList := AValue;
  VisualChange;
end;

procedure TCustomXGrid.SetTitleStyle(const AValue: TxTitleStyle);
begin
  if FTitleStyle=AValue then exit;
  FTitleStyle:=AValue;
  Invalidate;
end;

procedure TCustomXGrid.SetUseXorFeatures(const AValue: boolean);
begin
  if FUseXORFeatures=AValue then exit;
  FUseXORFeatures:=AValue;
  Invalidate;
end;

procedure TCustomXGrid.SetBorderStyle(NewStyle: TBorderStyle);
begin
  if FGridBorderStyle<>NewStyle then begin
    FGridBorderStyle := NewStyle;
    UpdateBorderStyle;
  end;
end;

{ Save to the cache the current visible grid (excluding fixed cells) }
procedure TCustomXGrid.CacheVisibleGrid;
var
  R: TRect;
begin
  with FGCache do begin
    VisibleGrid:=GetVisibleGrid;
    with VisibleGrid do begin
      ValidRows := (left>=0) and (Right>=Left) and (ColCount>0) and (RowCount>0);
      ValidCols := (top>=0) and (bottom>=Top) and (ColCount>0) and (RowCount>0);
      ValidGrid := ValidRows and ValidCols;
    end;
    FullVisibleGrid := VisibleGrid;
    if ValidGrid then
      with FullVisibleGrid do begin
        if xgoSmoothScroll in Options then begin
          if TLColOff>0 then
            Left := Min(Left+1, Right);
          if TLRowOff>0 then
            Top  := Min(Top+1, Bottom);
        end;
        R := CellRect(Right, Bottom);
        if R.Right>(ClientWidth+GetBorderWidth) then
          Right := Max(Right-1, Left);
        if R.Bottom>(ClientHeight+GetBorderWidth) then
          Bottom := Max(Bottom-1, Top);
      end;
  end;
end;

procedure TCustomXGrid.CancelSelection;
begin
  with FRange do
    if (Bottom-Top>0) or
      ((Right-Left>0) and not (xgoRowSelect in Options)) then begin
      InvalidateRange(FRange);
      if xgoRowSelect in Options then
        FRange:=Rect(FFixedCols, FRow, ColCount-1, FRow)
      else
        FRange:=Rect(FCol,FRow,FCol,FRow);
    end;
  SelectActive := False;
end;

function TCustomXGrid.GetSelection: TxGridRect;
begin
  Result:=FRange;
end;

procedure TCustomXGrid.SetDefaultDrawing(const AValue: Boolean);
begin
  if FDefaultDrawing=AValue then exit;
  FDefaultDrawing:=AValue;
  Invalidate;
end;

procedure TCustomXGrid.SetFocusColor(const AValue: TColor);
begin
  if FFocusColor=AValue then exit;
  FFocusColor:=AValue;
  InvalidateCell(FCol,FRow);
end;

procedure TCustomXGrid.SetGridLineStyle(const AValue: TPenStyle);
begin
  if FGridLineStyle=AValue then exit;
  FGridLineStyle:=AValue;
  Invalidate;
end;

procedure TCustomXGrid.SetSelectActive(const AValue: Boolean);
begin
  if FSelectActive=AValue then exit;
  FSelectActive:=AValue and
    (not EditingAllowed(FCol) or (ExtendedSelect and not EditorAlwaysShown));
  if FSelectActive then FPivot:=Point(FCol,FRow);
end;

procedure TCustomXGrid.SetSelection(const AValue: TxGridRect);
var
  OldSelectActive: boolean;
begin
  if xgoRangeSelect in Options then
  with AValue do begin
    if (Left<0)and(Top<0)and(Right<0)and(Bottom<0) then
      CancelSelection
    else begin
      fRange:=NormalizarRect(aValue);
      if fRange.Right>=ColCount then fRange.Right:=ColCount-1;
      if fRange.Bottom>=RowCount then fRange.Bottom:=RowCount-1;
      if fRange.Left<FixedCols then fRange.Left := FixedCols;
      if fRange.Top<FixedRows then fRange.Top := FixedRows;
      if xgoSelectionActive in Options then begin
        OldSelectActive := FSelectActive;
        FPivot := FRange.TopLeft;
        FSelectActive := True;
        MoveExtend(false, FRange.Right, FRange.Bottom);
        FSelectActive := OldSelectActive;
      end;
      Invalidate;
    end;
  end;
end;

function TCustomXGrid.doColSizing(X, Y: Integer): Boolean;
var
  Offset: Integer;

  procedure FindPrevColumn;
  begin
    with FSizing do begin
      Dec(Index);
      while (Index>FixedCols) and (ColWidths[Index]=0) do
        Dec(Index);
    end;
  end;

begin
  Result:=False;

  with FSizing do
  if xgsColSizing = fGridState then begin

    if not (gfxSizingStarted in FGridFlags) then
      if not StartColSizing(X,Y) then
        exit;
    Include(FGridFlags, gfxSizingStarted);

    if FUseXORFeatures then begin

      if UseRightToLeftAlignment then begin
        if (OffEnd - x) <=0 then
          x:= OffEnd;
      end
      else
      if (X-OffIni)<=0 then
        X := OffIni;

      if X<>PrevOffset then begin
        if PrevLine then
          DrawXorVertLine(PrevOffset);
        DrawXorVertLine(X);
        PrevLine:=True;
        PrevOffset:=X;
      end;

    end else begin
      if UseRightToLeftAlignment then
        ResizeColumn(Index, OffEnd - X + DeltaOff)
      else
        ResizeColumn(Index, X - OffIni + DeltaOff);
    end;
    HeaderSizing(true, Index, X - OffIni + DeltaOff);
    exit(true);
  end else
  if (fGridState=xgsNormal) and
     ((Y<FGCache.FixedHeight) or (FExtendedColSizing and (Y<FGCache.MaxClientXY.Y))) and
     ((xgoFixedColSizing in Options) or ((ColCount>FixedCols) and (FlipX(X)>FGCache.FixedWidth)))
  then begin

    // find closest cell and cell boundaries
    if (FlipX(X)>FGCache.GridWidth-1) then
      Index := ColCount-1
    else
      OffsetToColRow(True, True, X, Index, Offset);
    ColRowToOffset(True, true, Index, OffIni, OffEnd);

    if OffEnd>FGCache.ClientWidth then
      Offset := FGCache.ClientWidth
    else if (OffEnd-X)<(X-OffIni) then begin
      Offset := OffEnd;
      if UseRightToLeftAlignment then
        FindPrevColumn;
    end else begin
      Offset := OffIni;
      if not UseRightToLeftAlignment then
        FindPrevColumn;
    end;

    // check if cursor is near boundary and it's a valid column
    if (Abs(Offset-x)<=2) then begin
      if xgoFixedColSizing in Options then
        Offset := 0
      else
        Offset := FFixedCols;
      if Index>=Offset then begin
        // start resizing
        if Cursor<>crHSplit then begin
          PrevLine := false;
          PrevOffset := -1;
          ChangeCursor(crHSplit);
        end;
        exit(true);
      end;
    end;

  end;

  if (cursor=crHSplit) then
    ChangeCursor;
end;

function TCustomXGrid.doRowSizing(X, Y: Integer): Boolean;
var
  Offset: Integer;
begin
  Result:=False;

  with FSizing do
  if xgsRowSizing = fGridState then begin
    if FUseXORFeatures then begin
      if (y-OffIni)<=0 then
        y:= OffIni;
      if y<>PrevOffset then begin
        if PrevLine then
          DrawXorHorzLine(PrevOffset);
        DrawXorHorzLine(Y);
        PrevLine:=True;
        PrevOffset:=y;
      end;
    end else
      ResizeRow(Index, y-OffIni);
    HeaderSizing(false, Index, y-OffIni);
    Result:=True;
  end else
  if (fGridState=xgsNormal) and (RowCount>FixedRows) and
     ((FlipX(X)<FGCache.FixedWidth) or
      (FExtendedRowSizing and (FlipX(X)<FGCache.MaxClientXY.X))) and
     (Y>FGCache.FixedHeight) then
  begin

    // find closest cell and cell boundaries
    if Y>FGCache.GridHeight-1 then
      Index := RowCount-1
    else
      OffsetToColRow(False, True, Y, Index, OffEnd{dummy});
    ColRowToOffset(False, True, Index, OffIni, OffEnd);

    // find out what cell boundary is closer to Y
    if OffEnd>FGCache.ClientHeight then
      Offset := FGCache.ClientHeight
    else
    if (OffEnd-Y)<(Y-OffIni) then
      Offset := OffEnd
    else begin
      Offset := OffIni;
      Dec(Index);
      ColRowToOffset(False, True, Index, OffIni, OffEnd);
    end;

    // check if it's not fixed row and if cursor is close enough to
    // selected boundary
    if (Index>=FFixedRows)and(Abs(Offset-Y)<=2) then begin
      // start resizing
      if Cursor<>crVSplit then begin
        ChangeCursor(crVSplit);
        PrevLine := False;
        PrevOffset := -1;
      end;
      exit(true);
    end

  end;

  if (cursor=crVSplit) then
    ChangeCursor;
end;

procedure TCustomXGrid.doColMoving(X, Y: Integer);
var
  CurCell: TPoint;
  R: TRect;
begin
  CurCell:=MouseToCell(Point(X,Y));

  with FGCache do begin

    if (Abs(ClickMouse.X-X)>FDragDX) and (Cursor<>crMultiDrag) then begin
      ChangeCursor(crMultiDrag);
      FMoveLast:=Point(-1,-1);
      ResetOffset(True, False);
    end;

    if (Cursor=crMultiDrag) and
       (CurCell.X>=FFixedCols) and
       ((CurCell.X<=ClickCell.X) or (CurCell.X>ClickCell.X)) and
       (CurCell.X<>FMoveLast.X) then begin

      R := CellRect(CurCell.X, CurCell.Y);
      if CurCell.X<=ClickCell.X then
        FMoveLast.Y := R.Left
      else
        FMoveLast.Y := R.Right;

      FMoveLast.X := CurCell.X;
      {$ifdef AlternativeMoveIndicator}
      InvalidateRow(0);
      {$else}
      Invalidate;
      {$endif}
    end;
  end;
end;

procedure TCustomXGrid.doRowMoving(X, Y: Integer);
var
  CurCell: TPoint;
  R: TRect;
begin
  CurCell:=MouseToCell(Point(X,Y));

  with FGCache do begin

    if (Cursor<>crMultiDrag) and (Abs(ClickMouse.Y-Y)>FDragDX) then begin
      ChangeCursor(crMultiDrag);
      FMoveLast:=Point(-1,-1);
      ResetOffset(False, True);
    end;

    if (Cursor=crMultiDrag)and
       (CurCell.Y>=FFixedRows) and
       ((CurCell.Y<=ClickCell.Y) or (CurCell.Y>ClickCell.Y))and
       (CurCell.Y<>FMoveLast.Y) then begin

      R:=CellRect(CurCell.X, CurCell.Y);
      if CurCell.Y<=ClickCell.Y then
        FMoveLast.X:=R.Top
      else
        FMoveLast.X:=R.Bottom;
      FMoveLast.Y:=CurCell.Y;
      Invalidate;
    end;
  end;
end;


function TCustomXGrid.OffsetToColRow(IsCol, Fisical: Boolean; Offset: Integer;
  var Index, Rest: Integer): boolean;
begin
  Index:=0;
  Rest:=0;
  Result := False;
  if IsCol and UseRightToLeftAlignment then
    Offset := FlipX(Offset);
  Offset := Offset - GetBorderWidth;
  if Offset<0 then Exit; // Out of Range;

  with FGCache do begin
    if IsCol then begin
      // begin to count Cols from 0 but ...
      if Fisical and (Offset>FixedWidth-1) then begin
        Index := FTopLeft.X;  // In scrolled view, then begin from FTopLeft col
        if (Index>=0) and (Index<ColCount) then begin
          Offset:=Offset-FixedWidth+integer(PtrUInt(AccumWidth[Index]));
          if xgoSmoothScroll in Options then
            Offset:=Offset+TLColOff;
        end;
        if (Index<0) or (Index>=ColCount) or (Offset>GridWidth-1) then begin
          if AllowOutboundEvents then
            Index := ColCount-1
          else
            Index := -1;
          exit;
        end;
      end;

      while Offset>(integer(PtrUInt(AccumWidth[Index]))+GetColWidths(Index)-1) do
        Inc(Index);

      Rest:=Offset;
      if Index<>0 then Rest:=Offset-integer(PtrUInt(AccumWidth[Index]));

    end else begin

      //DebugLn('TCustomXGrid.OffsetToColRow ',DbgSName(Self),' Fisical=',dbgs(Fisical),' Offset=',dbgs(Offset),' FixedHeight=',dbgs(FixedHeight),' FTopLeft=',dbgs(FTopLeft),' RowCount=',dbgs(RowCount),' TLRowOff=',dbgs(TLRowOff));
      if Fisical and (Offset>FixedHeight-1) then begin
        Index:=FTopLeft.Y;
        if (Index>=0) and (Index<RowCount) then
          Offset:=Offset-FixedHeight+integer(PtrUInt(AccumHeight[Index]))+TLRowOff;
        if (Index<0) or (Index>=RowCount) or (Offset>GridHeight-1) then begin
          if AllowOutboundEvents then
            Index := RowCount-1
          else
            Index := -1;
          Exit; // Out of Range
        end;
      end;

      while Offset>(integer(PtrUInt(AccumHeight[Index]))+GetRowHeights(Index)-1) do
        Inc(Index);

      Rest:=Offset;
      if Index<>0 then Rest:=Offset-integer(PtrUInt(AccumHeight[Index]));

    end;
  end;
  result := True;
end;

{ ------------------------------------------------------------------------------
  Example:
  IsCol=true, Index:=100, TopLeft.x:=98, FixedCols:=1, all ColWidths:=20
  Relative => StartPos := WidthfixedCols+WidthCol98+WidthCol99
  not Relative = Absolute => StartPos := WidthCols(0..99) }
function TCustomXGrid.ColRowToOffset(IsCol, Relative: Boolean; Index:Integer;
  var StartPos, EndPos: Integer): Boolean;
var
  Dim: Integer;
begin
  Result:=false;
  with FGCache do begin
    if IsCol then begin
      StartPos:=integer(PtrUInt(AccumWidth[index]));
      Dim:=GetColWidths(index);
    end else begin
      StartPos:=integer(PtrUInt(AccumHeight[index]));
      Dim:= GetRowHeights(index);
    end;
    StartPos := StartPos + GetBorderWidth;
    if not Relative then begin
      EndPos:=StartPos + Dim;
      Exit;
    end;
    if IsCol then begin
      if index>=FFixedCols then begin
        StartPos:=StartPos-integer(PtrUInt(AccumWidth[FTopLeft.X])) + FixedWidth;
        if xgoSmoothScroll in Options then
          StartPos := StartPos - TLColOff;
      end;
    end else begin
      if index>=FFixedRows then begin
        StartPos:=StartPos-integer(PtrUInt(AccumHeight[FTopLeft.Y])) + FixedHeight;
        if xgoSmoothScroll in Options then
          StartPos := StartPos - TLRowOff;
      end;
    end;
    if IsCol and UseRightToLeftAlignment then
    begin
      EndPos := FlipX(StartPos) + 1;
      StartPos := EndPos - Dim;
    end
    else
      EndPos:=StartPos + Dim;
  end;
  Result:=true;
end;

function TCustomXGrid.ColumnIndexFromGridColumn(Column: Integer): Integer;
begin
  if Columns.Enabled and (Column>=FirstGridColumn) then
    result := Columns.RealIndex(Column - FirstGridColumn)
  else
    result := -1;
end;

function TCustomXGrid.ColumnFromGridColumn(Column: Integer): TxGridColumn;
var
  ColIndex: Integer;
begin
  ColIndex := ColumnIndexFromGridColumn(Column);
  if ColIndex>=0 then
    result := Columns[ColIndex]
  else
    result := nil;
end;

procedure TCustomXGrid.ColumnsChanged(aColumn: TxGridColumn);
var
  aCol: Integer;
begin
  if csDestroying in ComponentState then
    exit;

  if AColumn=nil then begin
    if Columns.Enabled then begin
      if FirstGridColumn + Columns.VisibleCount <> ColCount then
        InternalSetColCount( FirstGridColumn + Columns.VisibleCount )
      else
        VisualChange;
    end else
    if not (csLoading in ComponentState) then
      ColCount := FixedCols;
  end else begin
    aCol := Columns.IndexOf(AColumn);
    if ACol>=0 then begin
      VisualChange;
      {
      if aColumn.WidthChanged then
        VisualChange
      else
        InvalidateCol(FixedCols + ACol);
      }
    end;
  end;

end;

function TCustomXGrid.MouseToGridZone(X, Y: Integer): TxGridZone;
var
  aBorderWidth: Integer;
begin
  aBorderWidth := GetBorderWidth;
  if FlipX(X)<FGCache.FixedWidth+aBorderWidth then begin
    // in fixedwidth zone
    if Y<FGcache.FixedHeight+aBorderWidth then
      Result:= xgzFixedCells
    else
    if RowCount>FixedRows then
      Result:= xgzFixedRows
    else
      Result:= xgzInvalid
  end
  else if Y<FGCache.FixedHeight+aBorderWidth then begin
    // if fixedheight zone
    if FlipX(X)<FGCache.FixedWidth+aBorderWidth then
      Result:=xgzFixedCells
    else
    if ColCount>FixedCols then
      Result:=xgzFixedCols
    else
      Result:=xgzInvalid
  end
  else if not FixedGrid then begin
    // in normal cell zone (though, might be outbounds)
    if AllowOutboundEvents or
      ((FlipX(X)<=FGCache.GridWidth) and (Y<=FGCache.GridHeight)) then
      result := xgzNormal
    else
      result := xgzInvalid
  end
  else
    result := xgzInvalid;
end;

function TCustomXGrid.CellToGridZone(aCol, aRow: Integer): TxGridZone;
begin
  if (aCol<FFixedCols) then
    if aRow<FFixedRows then
      Result:= xgzFixedCells
    else
      Result:= xgzFixedRows
  else
  if (aRow<FFixedRows) then
    if aCol<FFixedCols then
      Result:= xgzFixedCells
    else
      Result:= xgzFixedCols
  else
    Result := xgzNormal;
end;

procedure TCustomXGrid.DoOPExchangeColRow(IsColumn: Boolean; index, WithIndex: Integer);
var
  ColRow: integer;
begin

  if IsColumn and Columns.Enabled then begin
    Columns.ExchangeColumn( ColumnIndexFromGridColumn(Index),
      ColumnIndexFromGridColumn(WithIndex));
    ColRowExchanged(IsColumn, index, WithIndex);
    exit;
  end;
  if IsColumn then
    FCols.Exchange(index, WithIndex)
  else
    FRows.Exchange(index, WithIndex);
  ColRowExchanged(IsColumn, index, WithIndex);
  VisualChange;

  // adjust editor bounds
  if IsColumn then
    ColRow := FCol
  else
    ColRow := FRow;

  if Between(ColRow, Index, WithIndex) then begin
    if ColRow=Index then
      ColRow:=WithIndex
    else
    if ColRow=WithIndex then
      ColRow:=Index;
    if IsColumn then
      AdjustEditorBounds(ColRow, FRow)
    else
      AdjustEditorBounds(FCol, ColRow);
  end;
end;

procedure TCustomXGrid.DoOPInsertColRow(IsColumn: boolean; index: integer);
var
  NewCol,NewRow: Integer;
begin
  if Index<0 then
    Index:=0;

  NewCol := Col;
  NewRow := Row;
  if IsColumn then begin
    if Index>ColCount-1 then
      Index := ColCount-1;
    if columns.Enabled then begin
      Columns.InsertColumn(ColumnIndexFromGridColumn(index));
      ColRowInserted(true, index);
      exit;
    end else begin
      FCols.Insert(Index, pointer(-1));
      FGCache.AccumWidth.Insert(Index, nil);
    end;
  end else begin
    Frows.Insert(Index, pointer(-1));
    FGCache.AccumHeight.Insert(Index, nil);
  end;
  ColRowInserted(IsColumn, index);
  VisualChange;

  // adjust editor bounds
  if IsColumn then begin
    if NewCol<FixedCols then
      NewCol := FixedCols
    else
    if Index<=NewCol then
      Inc(NewCol);
  end else begin
    if NewRow<FixedRows then
      NewRow := FixedRows
    else
    if Index<=NewRow then
      Inc(NewRow);
  end;
  AdjustEditorBounds(NewCol, NewRow)
end;

procedure TCustomXGrid.DoOPMoveColRow(IsColumn: Boolean; FromIndex,
  ToIndex: Integer);
var
  ColRow: Integer;
begin
  if FromIndex=ToIndex then
    exit;

  CheckIndex(IsColumn, FromIndex);
  CheckIndex(IsColumn, ToIndex);

  // move custom columns if they are not locked
  if IsColumn and Columns.Enabled and (not(gfxColumnsLocked in FGridFlags)) then begin
    Columns.MoveColumn(ColumnIndexFromGridColumn(FromIndex),
      ColumnIndexFromGridColumn(ToIndex));
    // done
    exit;
  end;

  // move grids content
  if IsColumn then
    FCols.Move(FromIndex, ToIndex)
  else
    FRows.Move(FromIndex, ToIndex);
  ColRowMoved(IsColumn, FromIndex, ToIndex);

  if not IsColumn or not Columns.Enabled then
    VisualChange;

  // adjust editor bounds
  if IsColumn then
    ColRow:=FCol
  else
    ColRow:=FRow;
  if Between(ColRow, FromIndex, ToIndex) then begin
    if ColRow=FromIndex then
      ColRow := ToIndex
    else
    if FromIndex<ColRow then
      ColRow := ColRow-1
    else
      ColRow := ColRow+1;
    if IsColumn then
      AdjustEditorBounds(ColRow, FRow)
    else
      AdjustEditorBounds(FCol, ColRow);
  end;

end;

procedure TCustomXGrid.DoOPDeleteColRow(IsColumn: Boolean; index: Integer);
  procedure doDeleteColumn;
  var
    tmpIndex: Integer;
  begin
    CheckFixedCount(ColCount-1, RowCount, FFixedCols, FFixedRows);
    CheckCount(ColCount-1, RowCount, false);

    // before deleteing column hide editor
    if EditorMode and (Index=Col) then
      EditorMode:=False;

    if Columns.Enabled then
      tmpIndex := ColumnIndexFromGridColumn(Index);

    if Index<FixedCols then begin
      Dec(FFixedCols);
      FTopLeft.x := FFixedCols;
    end;

    FCols.Delete(Index);
    FGCache.AccumWidth.Delete(Index);

    ColRowDeleted(True, Index);

    if Columns.Enabled then
      Columns.RemoveColumn(tmpIndex);

    FixPosition(True, Index);
  end;
  procedure doDeleteRow;
  begin
    CheckFixedCount(ColCount, RowCount-1, FFixedCols, FFixedRows);
    CheckCount(ColCount, RowCount-1, false);
    // before deleteing row hide editor
    if EditorMode and (Index=Row) then
      EditorMode:=False;
    if Index<FixedRows then begin
      Dec(FFixedRows);
      FTopLeft.y := FFixedRows;
    end;
    FRows.Delete(Index);
    FGCache.AccumHeight.Delete(Index);
    ColRowDeleted(False,Index);
    FixPosition(False, Index);
  end;
begin
  CheckIndex(IsColumn,Index);
  if IsColumn then
    doDeleteColumn
  else
    doDeleteRow;
end;

function TCustomXGrid.EditorByStyle(Style: TxColumnButtonStyle): TWinControl;
begin
  case Style of
    cbsxNone, cbsxCheckboxColumn, cbsxButtonColumn:
      Result := nil;
    cbsxEllipsis:
      Result := FButtonStringEditor;
    cbsxButton:
      Result := FButtonEditor;
    cbsxPickList:
      Result := FPicklistEditor;
    cbsxAuto:
      begin
        Result := FStringEditor;
      end;
  end;
end;

procedure TCustomXGrid.MouseDown(Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
var
  WasFocused: boolean;

  procedure DoPushCell;
  begin
    with FGCache do
    begin
      PushedCell := ClickCell;
      ClickCellPushed:=True;
      InvalidateCell(PushedCell.x, PushedCell.y);
    end;
  end;

  function DoAutoEdit: boolean;
  begin
    result := FAutoEdit and EditingAllowed(FCol) and
      (FGCache.ClickCell.X=Col) and (FGCache.ClickCell.Y=Row);
    if result then begin
      SelectEditor;
      EditorShow(True);
    end;
  end;

begin
  inherited MouseDown(Button, Shift, X, Y);

  if (csDesigning in componentState) or not MouseButtonAllowed(Button) then
    Exit;

  {$IfDef dbgGrid} DebugLn('MouseDown INIT'); {$Endif}

  FIgnoreClick := True;

  {$IFDEF dbgGrid}
  DebugLn('Mouse was in ', dbgs(FGCache.HotGridZone));
  {$ENDIF}

  CacheMouseDown(X,Y);

  case FGCache.HotGridZone of

    xgzFixedCells:
      begin
        if (xgoColSizing in Options) and (xgoFixedColSizing in Options) and
           (Cursor=crHSplit) then
          fGridState:= xgsColSizing
        else begin
          FGridState := xgsHeaderClicking;
          if ((xgoHeaderPushedLook in Options) and
              (FGCache.HotGridZone in FHeaderPushZones)) then
            DoPushCell;
        end;
      end;

    xgzFixedCols:
      begin
        if (xgoColSizing in Options) and (Cursor=crHSplit) then

          fGridState:= xgsColSizing

        else begin
          // ColMoving or Clicking
          fGridState:=xgsColMoving;
          FMoveLast:=Point(-1,-1);
          if ((xgoHeaderPushedLook in Options) and
              (FGCache.HotGridZone in FHeaderPushZones)) then
            DoPushCell;
        end;
      end;

    xgzFixedRows:
      if (xgoRowSizing in Options)and(Cursor=crVSplit) then

        fGridState:= xgsRowSizing

      else begin
        // RowMoving or Clicking
        fGridState:=xgsRowMoving;
        FMoveLast:=Point(-1,-1);
        if ((xgoHeaderPushedLook in Options) and
            (FGCache.HotGridZone in FHeaderPushZones)) then
          DoPushCell;
      end;

    xgzNormal:
      begin
        FIgnoreClick := False;
        WasFocused := Focused;
        if not WasFocused then
          SetFocus;

        if IsCellButtonColumn(FGCache.ClickCell) then
        begin
          fGridState := xgsButtonColumnClicking;
          DoPushCell;
          Exit;
        end
        else
        if FExtendedColSizing and
          (Cursor=crHSplit) and
          (xgoColSizing in Options) then begin
          // extended column sizing
          fGridState:= xgsColSizing;

        end
        else
        if not FixedGrid then
        begin
          // normal selecting
            if not DragManager.IsDragging then
              fGridState:=xgsSelecting;

          if not EditingAllowed(FCol) or
            (ExtendedSelect and not EditorAlwaysShown) then
          begin

            if ssShift in Shift then
              SelectActive:=(xgoRangeSelect in Options)
            else
            begin
              // shift is not pressed any more cancel SelectActive if necessary
              if SelectActive then
                CancelSelection;

              if not SelectActive then begin

                if not DoAutoEdit then
                  // delay select active until mouse reachs another cell
                  // do that only if editor is not shown
                  GridFlags := GridFlags + [gfxNeedsSelectActive];

                FPivot:=FGCache.ClickCell;

              end;
            end;

          end
          else
          if DoAutoEdit then
          begin
            {$ifDef dbgGrid} DebugLn('MouseDown (autoedit) END'); {$Endif}
            Exit;
          end;

          if not MoveExtend(False, FGCache.ClickCell.X, FGCache.ClickCell.Y) then begin
            if EditorAlwaysShown then begin
              SelectEditor;
              EditorShow(true);
            end;
            MoveSelection;
          end;

        end;
      end;
  end;



  {$ifDef dbgGrid} DebugLn('MouseDown END'); {$Endif}
end;

procedure TCustomXGrid.MouseMove(Shift: TShiftState; X, Y: Integer);
var
  p: TPoint;
  obe: boolean;  // stored "AllowOutboundEvents"
begin
  inherited MouseMove(Shift, X, Y);

  if Dragging then
    exit;

  HeadersMouseMove(X,Y);

  case FGridState of

    xgsHeaderClicking, xgsButtonColumnClicking:
      ;

    xgsSelecting:
      if not FixedGrid and (not EditingAllowed(-1) or
        (ExtendedSelect and not EditorAlwaysShown)) then begin
        P:=MouseToLogcell(Point(X,Y));
        if gfxNeedsSelectActive in GridFlags then
          SelectActive := (P.x<>FPivot.x)or(P.y<>FPivot.y);
        MoveExtend(False, P.x, P.y);
      end;

    xgsColMoving:
      if xgoColMoving in Options then
        doColMoving(X,Y);

    xgsRowMoving:
      if xgoRowMoving in Options then
        doRowMoving(X,Y);

    else
      begin
        if xgoColSizing in Options then
          doColSizing(X,Y);

        if xgoRowSizing in Options then
          doRowSizing(X,Y);

        obe := AllowOutboundEvents;
        AllowOutboundEvents := false;
        try
          p := MouseCoord(X, Y);
        finally
          AllowOutboundEvents := obe;
        end;
        with FGCache do
          if (MouseCell.X <> p.X) or (MouseCell.Y <> p.Y) then begin
            Application.CancelHint;
            ShowCellHintWindow(Point(X,Y));
            MouseCell := p;
          end;
      end;
  end;
end;

procedure TCustomXGrid.MouseUp(Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
var
   Cur: TPoint;
begin
  inherited MouseUp(Button, Shift, X, Y);
  {$IfDef dbgGrid}DebugLn('MouseUP INIT');{$Endif}

  Cur:=MouseToCell(Point(x,y));

  case fGridState of

    xgsHeaderClicking, xgsButtonColumnClicking:
      if (Cur.X=FGCache.ClickCell.X) and (Cur.Y=FGCache.ClickCell.Y) then begin
        if fGridState=xgsHeaderClicking then
          HeaderClick(True, FGCache.ClickCell.X, FGCache.ClickMouse)
        else
        //Копнин Ю if Assigned(OnEditButtonClick) or Assigned(OnButtonClick) then
          DoEditButtonClick(Cur.X, Cur.Y);
      end;

    xgsNormal:
      if not FixedGrid and (Cur.X=FGCache.ClickCell.X) and (Cur.Y=FGCache.ClickCell.Y) then
        CellClick(cur.x, cur.y, Button, Point(X, Y));

    xgsSelecting:
      begin
        if SelectActive then
          MoveExtend(False, Cur.x, Cur.y)
        else
          CellClick(cur.x, cur.y, Button, Point(x,y));
      end;

    xgsColMoving:
      begin
        //DebugLn('Move Col From ',Fsplitter.x,' to ', FMoveLast.x);
        if FMoveLast.X>=0 then begin
          if FMoveLast.X=FGCache.ClickCell.X then
            {$ifdef AlternativeMoveIndicator}
            InvalidateRow(0);
            {$else}
            Invalidate;
            {$endif}
          DoOPMoveColRow(True, FGCache.ClickCell.X, FMoveLast.X);
          ChangeCursor;
        end else
          if Cur.X=FGCache.ClickCell.X then
            HeaderClick(True, FGCache.ClickCell.X, FGCache.ClickMouse);
      end;

    xgsRowMoving:
      begin
        //DebugLn('Move Row From ',Fsplitter.Y,' to ', FMoveLast.Y);
        if FMoveLast.Y>=0 then begin
          if FMoveLast.Y=FGCache.ClickCell.Y then
            {$ifdef AlternativeMoveIndicator}
            InvalidateCol(0);
            {$else}
            Invalidate;
            {$endif}
          DoOPMoveColRow(False, FGCache.ClickCell.Y, FMoveLast.Y);
          ChangeCursor;
        end else
          if Cur.Y=FGCache.ClickCell.Y then
            HeaderClick(False, FGCache.ClickCell.Y, FGCache.ClickMouse);
      end;

    xgsColSizing:
      if gfxSizingStarted in FGridFlags then
      with FSizing do begin
        if FUseXORFeatures then begin
          if PrevLine then
            DrawXorVertLine(PrevOffset);
          PrevLine := False;
          PrevOffset := -1;
        end;
        if UseRightToLeftAlignment then
          ResizeColumn(Index, OffEnd - X + DeltaOff)
        else
          ResizeColumn(Index, X - OffIni + DeltaOff);
        HeaderSized(True, Index);
      end;

    xgsRowSizing:
      with FSizing do begin
        if FUseXORFeatures then begin
          if PrevLine then
            DrawXorHorzLine(PrevOffset);
          PrevLine := False;
          PrevOffset := -1;
        end;
        ResizeRow(Index, Y - OffIni);
        HeaderSized(False, Index);
      end;

  end;

  fGridState:=xgsNormal;
  GridFlags := GridFlags - [gfxNeedsSelectActive, gfxSizingStarted];

  if IsPushCellActive() then begin
    ResetPushedCell;
  end;
  FGCache.ClickCell := point(-1, -1);

  {$IfDef dbgGrid}DebugLn('MouseUP  END  RND=', FloatToStr(Random));{$Endif}
end;

procedure TCustomXGrid.DblClick;
var
  OldWidth: Integer;
begin
  {$IfDef dbgGrid}DebugLn('DoubleClick INIT');{$Endif}
  SelectActive:=False;
  fGridState:=xgsNormal;
  if (xgoColSizing in Options) and (Cursor=crHSplit) then begin
    if (xgoDblClickAutoSize in Options) then begin
      OldWidth := ColWidths[FSizing.Index];
      AutoAdjustColumn( FSizing.Index );
      if OldWidth<>ColWidths[FSizing.Index] then
        ChangeCursor;
    end {else
      DebugLn('Got Doubleclick on Col Resizing: AutoAdjust?');}
  end else
  if  (xgoDblClickAutoSize in Options) and
      (xgoRowSizing in Options) and
      (Cursor=crVSplit) then begin
      {
        DebugLn('Got DoubleClick on Row Resizing: AutoAdjust?');
      }
  end
  else
    Inherited DblClick;
  {$IfDef dbgGrid}DebugLn('DoubleClick END');{$Endif}
end;

procedure TCustomXGrid.DefineProperties(Filer: TFiler);
  function SonRowsIguales(aGrid: TCustomXGrid): boolean;
  var
    i: Integer;
  begin
    result := aGrid.RowCount = RowCount;
    if Result then
      for i:=0 to RowCount-1 do
        if aGrid.RowHeights[i]<>RowHeights[i] then begin
          result := false;
          break;
        end;
  end;
  function SonColsIguales(aGrid: TCustomXGrid): boolean;
  var
    i: Integer;
  begin
    result := aGrid.ColCount = ColCount;
    if Result then
      for i:=0 to ColCount-1 do
        if aGrid.ColWidths[i]<>ColWidths[i] then begin
          result := false;
          break;
        end;
  end;
  function SonDefault(IsColumn: Boolean; L1: TList): boolean;
  var
    i: Integer;
    DefValue, Value: Integer;
  begin
    Result := True;
    if IsColumn then DefValue := DefaultColWidth
    else             DefValue := DefaultRowHeight;
    for i:=0 to L1.Count-1 do begin
      Value := integer(PtrUInt(L1[i]));
      Result := (Value = DefValue) or (Value<0);
      if not Result then
        break;
    end;
  end;
  function NeedWidths: boolean;
  begin
    if Filer.Ancestor is TCustomXGrid then
      Result := not SonColsIguales(TCustomXGrid(Filer.Ancestor))
    else
      Result := not SonDefault(True, FCols);
    //result := Result and not AutoFillColumns;
  end;
  function NeedHeights: boolean;
  begin
    if Filer.Ancestor is TCustomXGrid then
      Result := not SonRowsIguales(TCustomXGrid(Filer.Ancestor))
    else
      Result := not SonDefault(false, FRows);
  end;
  function HasColumns: boolean;
  var
    C: TxGridColumns;
  begin
    if Filer.Ancestor is TCustomXGrid then
      C := TCustomXGrid(Filer.Ancestor).Columns
    else
      C := Columns;
    if C<>nil then
      result := not C.IsDefault
    else
      result := false;
  end;
begin
  inherited DefineProperties(Filer);
  with Filer do begin
    //DefineProperty('Columns',    @ReadColumns,    @WriteColumns,    HasColumns);
    DefineProperty('ColWidths',  @ReadColWidths,  @WriteColWidths,  NeedWidths);
    DefineProperty('RowHeights', @ReadRowHeights, @WriteRowHeights, NeedHeights);
  end;
end;

procedure TCustomXGrid.DestroyHandle;
begin
  inherited DestroyHandle;
  editorGetValue;
end;

{function TCustomXGrid.DialogChar(var Message: TLMKey): boolean;
var
  i: Integer;
begin
  for i:=0 to Columns.Count-1 do
    if Columns[i].Visible and (Columns[i].Title.PrefixOption<>poxNone) then
      if IsAccel(Message.CharCode, Columns[i].Title.Caption) then begin
        result := true;
        //P := CellRect();
        HeaderClick(True, GridColumnFromColumnIndex(i), );
        exit;
      end;
  result := inherited DialogChar(Message);
end;}

{function TCustomXGrid.DoCompareCells(Acol, ARow, Bcol, BRow: Integer): Integer;
begin
  result := 0;
  if Assigned(OnCompareCells) then
    OnCompareCells(Self, ACol, ARow, BCol, BRow, Result);
end;}

procedure TCustomXGrid.DoCopyToClipboard;
begin
end;

procedure TCustomXGrid.DoCutToClipboard;
begin
end;

procedure TCustomXGrid.DoEditButtonClick(const ACol, ARow: Integer);
var
  OldCol,OldRow: Integer;
begin
  OldCol:=FCol;
  OldRow:=FRow;
  try
    FCol:=ACol;
    FRow:=ARow;
    //if Assigned(OnEditButtonClick) then
      //OnEditButtonClick(Self);
    if Assigned(OnButtonClick) then
      OnButtonClick(Self, ACol, ARow);
  finally
    if (FCol=ACol) and (FRow=ARow) then
    begin
      // didn't change FRow or FCol, restore old index.
      FCol:=OldCol;
      FRow:=OldRow;
    end;
  end;
end;

procedure TCustomXGrid.DoEditorHide;
var
  ParentForm: TCustomForm;
begin
  {$ifdef dbgGrid}DebugLn('grid.DoEditorHide [',Editor.ClassName,'] INIT');{$endif}
  if gfxEditingDone in FGridFlags then begin
    ParentForm := GetParentForm(Self);
    ParentForm.ActiveControl := self;
  end;
  Editor.Visible:=False;
  //if ParentForm.Active then SetFocus;
  {$ifdef dbgGrid}DebugLn('grid.DoEditorHide [',Editor.ClassName,'] END');{$endif}
end;
procedure TCustomXGrid.DoEditorShow;
begin
  //DebugLn(['TCustomXGrid.DoEditorShow ']);
  {$ifdef dbgGrid}DebugLn('grid.DoEditorShow [',Editor.ClassName,'] INIT');{$endif}
  ScrollToCell(FCol,FRow,true);
  Editor.Parent := nil;
  EditorSetValue;
  Editor.Parent:=Self;
  Editor.Visible:=True;
  if Focused and Editor.CanFocus then
    Editor.SetFocus;
  InvalidateCell(FCol,FRow,True);
  {$ifdef dbgGrid}DebugLn('grid.DoEditorShow [',Editor.ClassName,'] END');{$endif}
end;

procedure TCustomXGrid.DoOnChangeBounds;
var
  PrevSpace: Integer;
  NewTopLeft, AvailSpace: TPoint;
begin
  inherited DoOnChangeBounds;

  FGridFlags := FGridFlags + [gfxUpdatingSize];

  AVailSpace.x := ClientWidth - FGCache.MaxClientXY.x;
  AVailSpace.y := ClientHeight - FGCache.MaxClientXY.y;
  NewTopLeft := FTopLeft;

  while (AvailSpace.x>0) and (NewTopLeft.x>FixedCols) do begin
    PrevSpace := GetColWidths(NewTopLeft.x-1);
    if AvailSpace.x>(PrevSpace-FGCache.TLColOff) then
      Dec(NewTopLeft.x, 1);
    Dec(AvailSpace.x, PrevSpace);
  end;

  while (AvailSpace.y>0) and (NewTopLeft.y>FixedRows) do begin
    PrevSpace := GetRowHeights(NewTopLeft.y-1);
    if AvailSpace.y>PrevSpace then
      Dec(NewTopLeft.y, 1);
    Dec(AvailSpace.y, PrevSpace);
  end;

  if not PointIgual(FTopleft,NewTopLeft) then begin
    FTopLeft := NewTopleft;
    FGCache.TLColOff := 0;
    FGCache.TLRowOff := 0;
    if xgoSmoothScroll in options then begin
      // TODO: adjust new TLColOff and TLRowOff
    end;
    DoTopLeftChange(True);
  end else
    VisualChange;

  FGridFlags := FGridFlags - [gfxUpdatingSize];
end;

procedure TCustomXGrid.DoPasteFromClipboard;
begin
  //
end;

procedure TCustomXGrid.DoPrepareCanvas(aCol,aRow:Integer; aState: TxGridDrawState);
begin
  if Assigned(OnPrepareCanvas) then
    OnPrepareCanvas(Self, aCol, aRow, aState);
end;

procedure TCustomXGrid.DoSetBounds(ALeft, ATop, AWidth, AHeight: integer);
begin
  FLastWidth := ClientWidth;
  inherited DoSetBounds(ALeft, ATop, AWidth, AHeight);
end;

function TCustomXGrid.DoUTF8KeyPress(var UTF8Key: TUTF8Char): boolean;
begin
  Result := inherited DoUTF8KeyPress(UTF8Key);
  if EditingAllowed(FCol) and (not result) and (Length(UTF8Key)>1) then begin
    EditorShowChar(UTF8Key);
    UTF8Key := '';
    Result := true
  end;
end;

function TCustomXGrid.FlipRect(ARect: TRect): TRect;
begin
  Result := BidiFlipRect(ARect, GCache.ClientRect, UseRightToLeftAlignment);
end;

function TCustomXGrid.FlipPoint(P: TPoint): TPoint;
begin
  Result := BidiFlipPoint(P, GCache.ClientRect, UseRightToLeftAlignment);
end;

function TCustomXGrid.FlipX(X: Integer): Integer;
begin
  Result := BidiFlipX(X, GCache.ClientRect, UseRightToLeftAlignment);
end;

procedure TCustomXGrid.DoExit;
begin
  {$IfDef dbgGrid}DebugLn('DoExit - INIT');{$Endif}
  if FEditorShowing then begin
    {$IfDef dbgGrid}DebugLn('DoExit - EditorShowing');{$Endif}
  end else begin
    {$IfDef dbgGrid}DebugLn('DoExit - Ext');{$Endif}
    if not EditorAlwaysShown then
      InvalidateFocused;
    ResetEditor;
    if FgridState=xgsSelecting then begin
      if SelectActive then
        FSelectActive := False;
      FGridState := xgsNormal;
    end;
  end;
  inherited DoExit;
  {$IfDef dbgGrid}DebugLn('DoExit - END');{$Endif}
end;

procedure TCustomXGrid.DoEnter;
begin
  {$IfDef dbgGrid}DebugLn('DoEnter - INIT');{$Endif}
  inherited DoEnter;
  if EditorLocked then begin
    {$IfDef dbgGrid}DebugLn('DoEnter - EditorLocked');{$Endif}
  end else begin
    {$IfDef dbgGrid}DebugLn('DoEnter - Ext');{$Endif}
    if EditorAlwaysShown then begin
      // try to show editor only if focused cell is visible area
      // so a mouse click would use click coords to show up
      if IsCellVisible(Col,Row) then begin
        SelectEditor;
        if Feditor<>nil then
          EditorShow(true);
      end else begin
      {$IfDef dbgGrid}DebugLn('DoEnter - Ext - Cell was not visible');{$Endif}
      end;
    end else
      InvalidateFocused;
  end;
  {$IfDef dbgGrid}DebugLn('DoEnter - END');{$Endif}
end;

function TCustomXGrid.DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
  MousePos: TPoint): Boolean;
begin
  if FMouseWheelOption=mwxCursor then
    FSelectActive := false;
  Result:=inherited DoMouseWheel(Shift, WheelDelta, MousePos);
end;

function TCustomXGrid.DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint
  ): Boolean;
begin
  {$ifdef dbgScroll}DebugLn('doMouseWheelDown INIT');{$endif}
  Result:=inherited DoMouseWheelDown(Shift, MousePos);
  if not Result then begin
    GridMouseWheel(Shift, 1);
    Result := True; // handled, no further scrolling by the widgetset
  end;
  {$ifdef dbgScroll}DebugLn('doMouseWheelDown END');{$endif}
end;

function TCustomXGrid.DoMouseWheelUp(Shift: TShiftState; MousePos: TPoint
  ): Boolean;
begin
  {$ifdef dbgScroll}DebugLn('doMouseWheelUP INIT');{$endif}
  Result:=inherited DoMouseWheelUp(Shift, MousePos);
  if not Result then begin
    GridMouseWheel(Shift, -1);
    Result := True; // handled, no further scrolling by the widgetset
  end;
  {$ifdef dbgScroll}DebugLn('doMouseWheelUP END');{$endif}
end;

procedure TCustomXGrid.KeyDown(var Key: Word; Shift: TShiftState);
var
  Sh: Boolean;
  R: TRect;
  Relaxed: Boolean;
  DeltaCol,DeltaRow: Integer;

  procedure MoveSel(Rel: Boolean; aCol,aRow: Integer);
  begin
    // Always reset Offset in keyboard Events
    FGCache.TLColOff:=0;
    FGCache.TLRowOff:=0;
    SelectActive:=Sh;
    Include(FGridFlags, gfxEditingDone);
    if MoveNextSelectable(Rel, aCol, aRow) then
      Click;
    Exclude(FGridFlags, gfxEditingDone);
    Key := 0; { Flag key as handled, even if selected cell did not move }
  end;

  procedure TabCheckEditorKey;
  begin
    if FEditorKey then begin
      {$IFDEF dbggrid}
      DebugLn('Got TAB, shift=',dbgs(sh));
      {$endif}
      if sh then
        GridFlags := GridFlags + [gfxRevEditorTab]
      else
        GridFlags := GridFlags + [gfxEditorTab];
    end;
  end;

const
  cBidiMove:array[Boolean] of Integer = (1, -1);
begin
  {$ifdef dbgGrid}DebugLn('Grid.KeyDown INIT Key=',IntToStr(Key));{$endif}
  inherited KeyDown(Key, Shift);
  //if not FGCache.ValidGrid then Exit;
  if not CanGridAcceptKey(Key, Shift) then
    Key:=0;  // Allow CanGridAcceptKey to override Key behaviour
  Sh:=(ssShift in Shift);
  Relaxed := not (xgoRowSelect in Options) or (xgoRelaxedRowSelect in Options);

  case Key of
    VK_TAB:
      begin
        if xgoTabs in Options then begin
          if GetDeltaMoveNext(Sh, DeltaCol,DeltaRow) then begin
            Sh := False;
            MoveSel(True, DeltaCol, DeltaRow);
            Key:=0;
          end else
          if (AutoAdvance=aaNone) or
             ((AutoAdvance=aaDown) and (Row>=GetLastVisibleRow)) or
             (sh and (Col<=GetFirstVisibleColumn)) or
             ((not sh) and (Col>=GetLastVisibleColumn)) then
            TabCheckEditorKey
          else
            Key := 0;
        end else
          TabCheckEditorKey;
      end;
    VK_LEFT:
      begin
        if Relaxed then
          MoveSel(True, -cBidiMove[UseRightToLeftAlignment], 0)
        else
          MoveSel(True, 0,-1);
      end;
    VK_RIGHT:
      begin
        if Relaxed then
          MoveSel(True, cBidiMove[UseRightToLeftAlignment], 0)
        else
          MoveSel(True, 0, 1);
      end;
    VK_UP:
      begin
        MoveSel(True, 0, -1);
      end;
    VK_DOWN:
      begin
        MoveSel(True, 0, 1);
      end;
    VK_PRIOR:
      begin
        R:=FGCache.FullVisiblegrid;
        MoveSel(True, 0, R.Top-R.Bottom);
      end;
    VK_NEXT:
      begin
        R:=FGCache.FullVisibleGrid;
        MoveSel(True, 0, R.Bottom-R.Top);
      end;
    VK_HOME:
      begin
        if ssCtrl in Shift then MoveSel(False, FCol, FFixedRows)
        else
          if Relaxed then MoveSel(False, FFixedCols, FRow)
          else            MoveSel(False, FCol, FFixedRows);
      end;
    VK_END:
      begin
        if ssCtrl in Shift then MoveSel(False, FCol, RowCount-1)
        else
          if Relaxed then MoveSel(False, ColCount-1, FRow)
          else            MoveSel(False, FCol, RowCount-1);
      end;
    VK_F4:
      begin
        if not FEditorKey and EditingAllowed(FCol) then begin
          EditorShow(False);
          Key:=0;
        end ;
      end;
    VK_RETURN:
      begin
        if not FEditorKey and EditingAllowed(FCol) then begin
          EditorShow(True);
          Key := 0;
        end;
      end;
    VK_BACK:
      begin
        // Workaround: LM_CHAR doesnt trigger with BACKSPACE
        if not FEditorKey and EditingAllowed(FCol) then begin
          EditorShowChar(^H);
          key:=0;
        end;
      end;
    VK_C:
      if not FEditorKey then begin
        if ssCtrl in Shift then begin
//          Key := 0;
          doCopyToClipboard;
        end;
      end;
    VK_V:
      if not FEditorKey then begin
        if ssCtrl in Shift then begin
//          Key := 0;
          doPasteFromClipboard;
        end;
      end;
    VK_X:
      if not FEditorKey then begin
        if ssCtrl in Shift then begin
//          Key := 0;
          doCutToClipboard;
        end;
      end;
  end;
  if FEditorKey then
    FRowAutoInserted:=False;
  {$ifdef dbgGrid}DebugLn('Grid.KeyDown END Key=',IntToStr(Key));{$endif}
end;


procedure TCustomXGrid.KeyUp(var Key: Word; Shift: TShiftState);
begin
  inherited KeyUp(Key, Shift);
end;

{ Convert a fisical Mouse coordinate into fisical a cell coordinate }
function TCustomXGrid.MouseToCell(const Mouse: TPoint): TPoint;
begin
  MouseToCell(Mouse.X, Mouse.Y, Result.X, Result.Y);
end;

procedure TCustomXGrid.MouseToCell(X, Y: Integer; var ACol, ARow: Longint);
var
  dummy: Integer;
begin
  // Do not raise Exception if out of range
  OffsetToColRow(True, True, X, ACol, dummy);
  if ACol<0 then
    ARow := -1
  else begin
    OffsetToColRow(False,True, Y, ARow, dummy);
    if ARow<0 then
      ACol := -1;
  end;
end;

{ Convert a fisical Mouse coordinate into a logical cell coordinate }
function TCustomXGrid.MouseToLogcell(Mouse: TPoint): TPoint;
var
  gz: TxGridZone;
begin
  Gz:=MouseToGridZone(Mouse.x, Mouse.y);
  Result:=MouseToCell(Mouse);
  if gz<>xgzNormal then begin
    if (gz=xgzFixedRows)or(gz=xgzFixedCells) then begin
      Result.x:= fTopLeft.x-1;
      if Result.x<FFixedCols then Result.x:=FFixedCols;
    end;
    if (gz=xgzFixedCols)or(gz=xgzFixedCells) then begin
      Result.y:=fTopleft.y-1;
      if Result.y<fFixedRows then Result.y:=FFixedRows;
    end;
  end;
end;

function TCustomXGrid.MouseCoord(X, Y: Integer): TxGridCoord;
begin
  Result := MouseToCell(Point(X,Y));
end;

function TCustomXGrid.IscellVisible(aCol, aRow: Integer): Boolean;
begin
  with FGCache.VisibleGrid do
    Result:= (Left<=ACol)and(aCol<=Right)and(Top<=aRow)and(aRow<=Bottom);
end;

function TCustomXGrid.IsFixedCellVisible(aCol, aRow: Integer): boolean;
begin
  with FGCache.VisibleGrid do
    result := ((aCol<FixedCols) and ((aRow<FixedRows) or ((aRow>=Top)and(aRow<=Bottom)))) or
              ((aRow<FixedRows) and ((aCol<FixedCols) or ((aCol>=Left)and(aCol<=Right))));
end;

procedure TCustomXGrid.InvalidateCol(ACol: Integer);
var
  R: TRect;
begin
  {$ifdef dbgPaint} DebugLn('InvalidateCol  Col=',IntToStr(aCol)); {$Endif}
  if not HandleAllocated then
    exit;
  R:=CellRect(aCol, FTopLeft.y);
  R.Top:=0; // Full Column
  R.Bottom:=FGCache.MaxClientXY.Y;
  InvalidateRect(Handle, @R, True);
end;

procedure TCustomXGrid.InvalidateFromCol(ACol: Integer);
var
  R: TRect;
begin
  {$IFDEF dbgPaint} DebugLn('InvalidateFromCol  Col=',IntToStr(aCol)); {$Endif}
  if not HandleAllocated then
    exit;
  R:=CellRect(aCol, FTopLeft.y);
  R.Top:=0; // Full Column
  R.BottomRight := FGCache.MaxClientXY;
  InvalidateRect(Handle, @R, True);
end;

procedure TCustomXGrid.InvalidateRow(ARow: Integer);
var
  R: TRect;
begin
  {$ifdef DbgPaint} DebugLn('InvalidateRow  Row=',IntToStr(aRow)); {$Endif}
  if not HandleAllocated then
    exit;
  //R:=CellRect(fTopLeft.x, aRow);
  R:=CellRect(1, aRow);
  if UseRightToLeftAlignment then begin
    R.Left:=FlipX(FGCache.MaxClientXY.X);
    R.Right:=FGCache.ClientRect.Right;
  end
  else begin
    R.Left:=0; // Full row
    R.Right:=FGCache.MaxClientXY.X;
  end;
  InvalidateRect(Handle, @R, True);
end;

procedure TCustomXGrid.InvalidateFocused;
begin
  if FGCache.ValidGrid then begin
    {$ifdef dbgGrid}DebugLn('InvalidateFocused');{$Endif}
    if xgoRowSelect in Options then
      InvalidateRow(Row)
    else
      InvalidateCell(Col,Row);
  end;
end;

function TCustomXGrid.MoveExtend(Relative: Boolean; DCol, DRow: Integer): Boolean;
var
  OldRange: TRect;
  ForceReset: boolean;
begin
  Result:=TryMoveSelection(Relative,DCol,DRow);
  if (not Result) then Exit;

  Result:=EditorGetValue(true);
  if (not Result) then Exit;

  {$IfDef dbgGrid}DebugLn(' MoveExtend INIT FCol= ',IntToStr(FCol), ' FRow= ',IntToStr(FRow));{$Endif}
  BeforeMoveSelection(DCol,DRow);

  OldRange := FRange;

  if xgoRowSelect in Options then
    FRange:=Rect(FFixedCols, DRow, Colcount-1, DRow)
  else
    FRange:=Rect(DCol,DRow,DCol,DRow);

  if SelectActive and (xgoRangeSelect in Options) then
    if xgoRowSelect in Options then begin
      FRange.Top:=Min(fPivot.y, DRow);
      FRange.Bottom:=Max(fPivot.y, DRow);
    end else
      FRange:=NormalizarRect(Rect(Fpivot.x,FPivot.y, DCol, DRow));

  ForceReset := ((DCol=FTopLeft.x) and (FGCache.TLColOff<>0)) or
    ((DRow=FTopLeft.y) and (FGCache.TLRowOff<>0));

  if not ScrollToCell(DCol, DRow, ForceReset) then
    InvalidateMovement(DCol, DRow, OldRange);

  FCol := DCol;
  FRow := DRow;

  MoveSelection;
  SelectEditor;

  if (FEditor<>nil) and EditorAlwaysShown then begin
    // if editor visibility was changed on BeforeMoveSelection or MoveSelection
    // make sure editor will be updated.
    // TODO: cell coords of last time editor was visible
    //       could help here too, if they are not the same as the
    //       current cell, editor should be hidden first too.
    if FEditor.Visible then
      EditorHide;
    EditorShow(true);
  end;

  {$IfDef dbgGrid}DebugLn(' MoveExtend END FCol= ',IntToStr(FCol), ' FRow= ',IntToStr(FRow));{$Endif}
end;

function TCustomXGrid.MoveNextAuto(const Inverse: boolean): boolean;
var
  aCol,aRow: Integer;
begin
  Result := GetDeltaMoveNext(Inverse, ACol, ARow);
  if result then begin
    FGCache.TLColOff:=0;
    FGCache.TLRowOff:=0;
    MoveNextSelectable(true, aCol, aRow);
  end;
end;

function TCustomXGrid.MoveNextSelectable(Relative: Boolean; DCol, DRow: Integer
  ): Boolean;
var
  CInc,RInc: Integer;
  NCol,NRow: Integer;
  SelOk: Boolean;
  i: Integer;
begin
  // Reference
  if not Relative then begin
    NCol:=DCol;
    NRow:=DRow;
    DCol:=NCol-FCol;
    DRow:=NRow-FRow;
  end else begin
    NCol:=FCol+DCol;
    NRow:=FRow+DRow;
    if (xgoEditing in options) and (xgoAutoAddRows in options) then begin
      if (DRow=1) and (NRow>=RowCount) then begin
        // If the last row has data, add a new row.
        if not FRowAutoInserted then
          for i:=FixedCols to ColCount-1 do
            if GetCells(i, FRow)<>'' then begin
              RowCount:=RowCount+1;
              FRowAutoInserted:=True;
              Break;
            end;
      end
      else if FRowAutoInserted and (DRow=-1) then begin
        RowCount:=RowCount-1;
        FRowAutoInserted:=False;
      end;
    end;
  end;

  Checklimits(NCol, NRow);

  // Increment
  if DCol<0 then CInc:=-1 else
  if DCol>0 then CInc:= 1
  else           CInc:= 0;
  if DRow<0 then RInc:=-1 else
  if DRow>0 then RInc:= 1
  else           RInc:= 0;

  // Calculate
  SelOk:=SelectCell(NCol,NRow);
  Result:=False;
  while not SelOk do begin
    if  (NRow+RInc>RowCount-1)or(NRow+RInc<FFixedRows) or
        (NCol+CInc>ColCount-1)or(NCol+CInc<FFixedCols) then Exit;
    Inc(NCol, CInc);
    Inc(NRow, RInc);
    SelOk:=SelectCell(NCol, NRow);
  end;
  Result:=MoveExtend(False, NCol, NRow);

  // whether or not a movement was valid if xgoAlwaysShowEditor
  // is set, editor should pop up.
  if not EditorMode and EditorAlwaysShown then begin
    SelectEditor;
    if Feditor<>nil then
      EditorShow(true);
  end;
end;

function TCustomXGrid.TryMoveSelection(Relative: Boolean; var DCol, DRow: Integer
  ): Boolean;
begin
  Result:=False;

  if FixedGrid then
    exit;

  if Relative then begin
    Inc(DCol, FCol);
    Inc(DRow, FRow);
  end;

  CheckLimits(DCol, DRow);

  // Change on Focused cell?
  if (DCol=FCol) and (DRow=FRow) then
    SelectCell(DCol,DRow)
  else
    Result:=SelectCell(DCol,DRow);
end;

procedure TCustomXGrid.UnLockEditor;
begin
  Dec(FEditorHidingCount);
  {$ifdef dbgGrid}DebugLn('==< LockEditor: ', dbgs(FEditorHidingCount)); {$endif}
end;

procedure TCustomXGrid.UpdateHorzScrollBar(const aVisible: boolean;
  const aRange,aPage,aPos: Integer);
begin
  {$ifdef DbgScroll}
  DebugLn('TCustomXGrid.UpdateHorzScrollbar: Vis=%s Range=%d Page=%d aPos=%d',
    [dbgs(aVisible),aRange, aPage, aPos]);
  {$endif}
  ScrollBarShow(SB_HORZ, aVisible);
  if aVisible then
    ScrollBarRange(SB_HORZ, aRange, aPage, aPos);
end;

procedure TCustomXGrid.UpdateVertScrollbar(const aVisible: boolean;
  const aRange,aPage,aPos: Integer);
begin
  {$ifdef DbgScroll}
  DebugLn('TCustomXGrid.UpdateVertScrollbar: Vis=%s Range=%d Page=%d aPos=%d',
    [dbgs(aVisible),aRange, aPage, aPos]);
  {$endif}
  ScrollBarShow(SB_VERT, aVisible);
  if aVisible then
    ScrollbarRange(SB_VERT, aRange, aPage, aPos );
end;

procedure TCustomXGrid.UpdateBorderStyle;
var
  ABorderStyle: TBorderStyle;
begin
  if not Flat and (FGridBorderStyle=bsSingle) then
    ABorderStyle := bsSingle
  else
    ABorderStyle := bsNone;
  inherited SetBorderStyle(ABorderStyle);
  if HandleAllocated and ([csDestroying,csLoading]*ComponentState=[]) then
  begin
    VisualChange;
    if CheckTopLeft(Col, Row, True, True) then
      VisualChange;
  end;
end;

function TCustomXGrid.ValidateEntry(const ACol, ARow: Integer;
  const OldValue:string; var NewValue:string): boolean;
begin
  result := true;
  if assigned(OnValidateEntry) then begin
    try
      OnValidateEntry(Self, ACol, ARow, OldValue, NewValue);
    except
      on E:Exception do begin
        result := false;
        if FGridState=xgsSelecting then
          FGridState := xgsNormal;
        Application.HandleException(E);
      end;
    end;
  end;
end;

procedure TCustomXGrid.BeforeMoveSelection(const DCol,DRow: Integer);
begin
  if Assigned(OnBeforeSelection) then OnBeforeSelection(Self, DCol, DRow);
end;

procedure TCustomXGrid.CalcAutoSizeColumn(const Index: Integer; var AMin, AMax,
  APriority: Integer);
begin
  APriority := 0;
end;

procedure TCustomXGrid.CalcFocusRect(var ARect: TRect);
{
var
  dx,dy: integer;
}
begin
  if xgoRowSelect in Options then begin
    aRect.Left := FGCache.FixedWidth + 1;
    aRect.Right := FGCache.MaxClientXY.x;
    FlipRect(aRect);
  end;
  if xgoHorzLine in Options then dec(aRect.Bottom, 1);
  if xgoVertLine in Options then
    if UseRightToLeftAlignment then
      inc(aRect.Left, 1)
    else
      dec(aRect.Right, 1);
  {
  if not (xgoHorzLine in Options) then begin
    aRect.Bottom := aRect.Bottom + 1;
    Dec(aRect.Botton, 1);
  end;
  if not (xgoVertLine in Options) then begin
    aRect.Right := aRect.Right + 1;
    Dec(aRect.Botton, 1);
  end;
  }
end;

procedure TCustomXGrid.CalcScrollbarsRange;
var
  HsbVisible, VsbVisible: boolean;
  HsbRange,VsbRange: Integer;
  HsbPage, VsbPage: Integer;
  HsbPos, VsbPos: Integer;
begin
  with FGCache do begin
    GetSBVisibility(HsbVisible, VsbVisible);
    GetSBRanges(HsbVisible,VsbVisible,HsbRange,VsbRange,HsbPage,VsbPage,HsbPos,VsbPos);
    UpdateVertScrollBar(VsbVisible, VsbRange, VsbPage, VsbPos);
    UpdateHorzScrollBar(HsbVisible, HsbRange, HsbPage, HsbPos);
    {$ifdef DbgScroll}
    DebugLn('VRange=',dbgs(VsbRange),' Visible=',dbgs(VSbVisible));
    DebugLn('HRange=',dbgs(HsbRange),' Visible=',dbgs(HSbVisible));
    {$endif}
  end;
end;

function TCustomXGrid.CalcMaxTopLeft: TPoint;
var
  i: Integer;
  W,H: Integer;
begin
  Result:=Point(ColCount-1, RowCount-1);
  W:=0;
  for i:=ColCount-1 downto FFixedCols do begin
    W:=W+GetColWidths(i);
    if W<=FGCache.ScrollWidth then
      Result.x:=i
    else
      Break;
  end;
  H:=0;
  for i:=RowCount-1 downto FFixedRows do begin
    H:=H+GetRowHeights(i);
    if H<=FGCache.ScrollHeight then
      Result.y:=i
    else
      Break;
  end;
end;

procedure TCustomXGrid.CellClick(const aCol, aRow: Integer;
  const Button: TMouseButton; P: TPoint);
begin
end;

procedure TCustomXGrid.CheckLimits(var aCol, aRow: Integer);
begin
  if aCol<FFixedCols then aCol:=FFixedCols else
  if aCol>ColCount-1 then acol:=ColCount-1;
  if aRow<FFixedRows then aRow:=FFixedRows else
  if aRow>RowCount-1 then aRow:=RowCount-1;
end;

// We don't want to do this inside CheckLimits() because keyboard handling
// shouldn't raise an error whereas setting the Row or Col property it should.
procedure TCustomXGrid.CheckLimitsWithError(const aCol, aRow: Integer);
begin
  if (aCol < 0) or (aRow < 0) or (aCol >= ColCount) or (aRow >= RowCount) then
    raise xEGridException.Create(rsGridIndexOutOfRange);
end;

procedure TCustomXGrid.CMBiDiModeChanged(var Message: TLMessage);
begin
  VisualChange;
  inherited CMBidiModeChanged(Message);
end;

procedure TCustomXGrid.CMMouseEnter(var Message: TLMessage);
begin
  inherited;
  FSavedHint := Hint;
end;

procedure TCustomXGrid.CMMouseLeave(var Message: TLMessage);
begin
  if [xgoCellHints, xgoTruncCellHints] * Options <> [] then
    Hint := FSavedHint;
  ResetHotCell;
  inherited CMMouseLeave(Message);
end;

// This procedure checks if cursor cell position is allowed
// if not it tries to find a suitable position based on
// AutoAdvance and SelectCell.
procedure TCustomXGrid.CheckPosition;
var
  OldAA: TxAutoAdvance;
  DeltaCol,DeltaRow: Integer;
begin
  // first tries to find if current position is allowed
  if SelectCell(Col,Row) then
    exit;

  // current position is not valid, look for another position
  OldAA := FAutoAdvance;

  if OldAA=aaNone then
    FAutoAdvance := aaRightDown;

  try
    // try first normal movement then inverse movement
    if GetDeltaMoveNext(false, DeltaCol,DeltaRow) or
       GetDeltaMoveNext(true,  DeltaCol,DeltaRow)
    then begin
      MoveNextSelectable(True, DeltaCol, DeltaRow)
    end else begin
      // some combinations of AutoAdvance and current position
      // will always fail, for example if user set current
      // column not selectable and autoadvance is aaDown will
      // fail always, in this case as a last resource do a full
      // scan until a cell is available
      for DeltaCol:=FixedCols to ColCount-1 do
        for DeltaRow:=FixedRows to RowCount-1 do begin
          if SelectCell(DeltaCol,DeltaRow) then begin
            // found one selectable cell
            MoveNextSelectable(False, DeltaCol,DeltaRow);
            exit;
          end;
        end;
      // user has created weird situation.
      // can't do more about it.
    end;

  finally
    FAutoAdvance := OldAA;
  end;
end;

procedure TCustomXGrid.MoveSelection;
begin
  if Assigned(OnSelection) then OnSelection(Self, FCol, FRow);
end;

procedure TCustomXGrid.BeginUpdate;
begin
  Inc(FUpdateCount);
end;

function TCustomXGrid.BoxRect(ALeft, ATop, ARight, ABottom: Longint): TRect;
begin
  if ARight<ALeft then
    SwapInt(ALeft, ARight);
  if ABottom<ATop then
    SwapInt(ATop, ABottom);

  Result := CellRect(ALeft, ATop);
  with CellRect(ARight, ABottom) do
    Result.BottomRight := BottomRight;

  IntersectRect(Result, Result, FGCache.VisibleGrid);
end;

procedure TCustomXGrid.CacheMouseDown(const X, Y: Integer);
begin
  FGCache.ClickMouse := Point(X,Y);
  FGCache.ClickCell  := MouseToCell(FGCache.ClickMouse);
end;

procedure TCustomXGrid.EndUpdate(aRefresh: boolean = true);
begin
  Dec(FUpdateCount);
  if (FUpdateCount=0) and aRefresh then
    VisualChange;
end;

procedure TCustomXGrid.EraseBackground(DC: HDC);
begin
  //
end;

procedure TCustomXGrid.InvalidateCell(aCol, aRow: Integer);
begin
  InvalidateCell(ACol,ARow, False);
end;

procedure TCustomXGrid.InvalidateCell(aCol, aRow: Integer; Redraw: Boolean);
var
  R: TRect;
begin
  {$IfDef dbgPaint}
    DebugLn(['InvalidateCell  Col=',aCol,
      ' Row=',aRow,' Redraw=', Redraw]);
  {$Endif}
  if HandleAllocated and (IsCellVisible(aCol, aRow) or IsFixedCellVisible(aCol, aRow)) then begin
    R:=CellRect(aCol, aRow);
    InvalidateRect(Handle, @R, Redraw);
  end;
end;

procedure TCustomXGrid.InvalidateRange(const aRange: TRect);
var
  RIni,RFin: TRect;
begin
  if not HandleAllocated then
    exit;
  RIni := CellRect(aRange.Left, aRange.Top);
  RFin := CellRect(aRange.Right, aRange.Bottom);
  if UseRightToLeftAlignment then
    RIni.Left := RFin.Left
  else
    RIni.Right := RFin.Right;
  RIni.Bottom:= RFin.Bottom;
  InvalidateRect(Handle, @RIni, False);
end;

procedure TCustomXGrid.InvalidateGrid;
begin
  if FUpdateCount=0 then Invalidate;
end;

procedure TCustomXGrid.Invalidate;
begin
  if FUpdateCount=0 then begin
    {$IfDef dbgPaint} DebugLn('Invalidate');{$Endif}
    inherited Invalidate;
  end;
end;

procedure TCustomXGrid.EditingDone;
begin
  if not FEditorShowing then
    inherited EditingDone;
end;

function TCustomXGrid.EditorGetValue(validate:boolean=false): boolean;
var
  CurValue,NewValue: string;
begin
  result := true;
  if not (csDesigning in ComponentState) and (Editor<>nil) and Editor.Visible then begin

    if validate then begin
      CurValue := GetCells(FCol,FRow);
      NewValue := CurValue;
      result := ValidateEntry(FCol,FRow,FEditorOldValue,NewValue);
      if (CurValue<>NewValue) then begin
        SetEditText(FCol,FRow,NewValue);
        if result then
          EditorHide
        else
          EditorDoSetValue;
        exit;
      end;
    end;

    if result then begin
      EditorDoGetValue;
      EditorHide;
    end;
  end;
end;

procedure TCustomXGrid.EditorSetValue;
begin
  if not (csDesigning in ComponentState) then begin
    EditorPos;
    EditordoSetValue;
  end;
end;

procedure TCustomXGrid.EditorHide;
begin
  if not EditorLocked and (Editor<>nil) and Editor.HandleAllocated
    and Editor.Visible then
  begin
    FEditorMode:=False;
    {$ifdef dbgGrid}DebugLn('EditorHide [',Editor.ClassName,'] INIT FCol=',IntToStr(FCol),' FRow=',IntToStr(FRow));{$endif}
    LockEditor;
    try
      DoEditorHide;
      Application.ProcessMessages;
      if CanFocus then SetFocus;
    finally
      UnLockEditor;
    end;
    {$ifdef dbgGrid}DebugLn('EditorHide END');{$endif}
  end;
end;

function TCustomXGrid.EditorLocked: boolean;
begin
  Result := FEditorHidingCount <> 0;
end;

function TCustomXGrid.EditingAllowed(ACol: Integer = -1): Boolean;
var
  C: TxGridColumn;
begin
  Result:=(xgoEditing in options) and (ACol>=0) and (ACol<ColCount);
  if Result and Columns.Enabled then begin
    C:=ColumnFromGridColumn(ACol);
    Result := (C<>nil) and C.CanShowEditor;
  end;
end;

procedure TCustomXGrid.EditorShow(const SelAll: boolean);
begin
  if ([csLoading,csDestroying,csDesigning]*ComponentState<>[])
  or (not Enabled) or (not IsVisible)
  or (not HandleAllocated) then
    Exit;

  if EditingAllowed(FCol) and CanEditShow and
     (not FEditorShowing) and (FEditor<>nil) and (not Editor.Visible) then
  begin
    {$ifdef dbgGrid} DebugLn('EditorShow [',Editor.ClassName,'] INIT FCol=',IntToStr(FCol),' FRow=',IntToStr(FRow));{$endif}
    FEditorMode:=True;
    FEditorOldValue := GetCells(FCol,FRow);
    FEditorShowing:=True;
    doEditorShow;
    FEditorShowing:=False;
    if SelAll then
      EditorSelectAll;
    FGridState := xgsNormal;
    {$ifdef dbgGrid} DebugLn('EditorShow END');{$endif}
  end;
end;

procedure TCustomXGrid.EditorShowInCell(const aCol, aRow: Integer);
var
  OldCol,OldRow: Integer;
begin
  OldCol:=FCol;
  OldRow:=FRow;
  try
    EditorGetValue;
    FCol:=aCol;
    FRow:=aRow;
    SelectEditor;
    EditorShow(True);
  finally
    if (FCol=aCol)and(FRow=aRow) then
    begin
      // Current col,row didn't change, restore old ones
      FCol:=OldCol;
      FRow:=OldRow;
    end;
  end;
end;

procedure TCustomXGrid.EditorTextChanged(const aCol,aRow: Integer; const aText:string);
begin
  SetEditText(aCol, aRow, aText);
end;

procedure TCustomXGrid.EditorWidthChanged(aCol, aWidth: Integer);
begin
  EditorPos;
end;

function TCustomXGrid.FirstGridColumn: integer;
begin
  result := FixedCols;
end;

function TCustomXGrid.FixedGrid: boolean;
begin
  result := (FixedCols=ColCount) or (FixedRows=RowCount)
end;

procedure TCustomXGrid.FontChanged(Sender: TObject);
begin
  if csCustomPaint in ControlState then
    Canvas.Font := Font
  else
  begin
    inherited FontChanged(Sender);
    if FColumns.Enabled then
      FColumns.FontChanged;
    if FTitleFontIsDefault then begin
      FTitleFont.Assign(Font);
      FTitleFontIsDefault := True;
    end;
  end;
end;

procedure TCustomXGrid.EditorPos;
var
  msg: TxGridMessage;
begin
  {$ifdef dbgGrid} DebugLn('Grid.EditorPos INIT');{$endif}
  if FEditor<>nil then begin

    // send editor position
    Msg.LclMsg.msg:=GM_SETPOS;
    Msg.Grid:=Self;
    Msg.Col:=FCol;
    Msg.Row:=FRow;
    FEditor.Dispatch(Msg);

    // send editor bounds
    Msg.CellRect:= EditorRect(FCol,FRow);
    if (Msg.CellRect.Top<FGCache.FixedHeight) or
       (UseRightToLeftAlignment and (Msg.CellRect.Right-1>FlipX(FGCache.FixedWidth))) or
       (not UseRightToLeftAlignment and (Msg.CellRect.Left<FGCache.FixedWidth)) then
    begin
      // editor is not in visible area, hide it complety
      // to avoid showing it in fixed cell area
      with msg.CellRect do
        Msg.CellRect := Rect(-Right, -Bottom, -Left, -Top);
    end;
    if FEditorOptions and EO_AUTOSIZE = EO_AUTOSIZE then begin
      if EditorBorderStyle = bsNone then
          InflateRect(Msg.CellRect, -1, -1);
      FEditor.BoundsRect := Msg.CellRect;
    end else begin
      Msg.LclMsg.msg:=GM_SETBOUNDS;
      Msg.Grid:=Self;
      Msg.Col:=FCol;
      Msg.Row:=FRow;
      FEditor.Dispatch(Msg);
    end;
  end;
  {$ifdef dbgGrid} DebugLn('Grid.EditorPos END');{$endif}
end;

procedure TCustomXGrid.EditorSelectAll;
var
  Msg: TxGridMessage;
begin
  {$ifdef dbgGrid}DebugLn('EditorSelectALL INIT');{$endif}
  if FEditor<>nil then
    if FEditorOptions and EO_SELECTALL = EO_SELECTALL then begin
      Msg.LclMsg.msg:=GM_SELECTALL;
      FEditor.Dispatch(Msg);
    end;
  {$ifdef dbgGrid}DebugLn('EditorSelectALL END');{$endif}
end;

procedure TCustomXGrid.EditordoGetValue;
var
  msg: TxGridMessage;
begin
  if (FEditor<>nil) and FEditor.Visible then begin
    Msg.LclMsg.msg:=GM_GETVALUE;
    Msg.grid:=Self;
    Msg.Col:=FCol;
    Msg.Row:=FRow;
    Msg.Value:=GetCells(FCol, FRow);
    FEditor.Dispatch(Msg);
    SetEditText(Msg.Col, Msg.Row, Msg.Value);
  end;
end;

procedure TCustomXGrid.EditordoSetValue;
var
  msg: TxGridMessage;
begin
  if FEditor<>nil then begin
    // Set the editor mask
    Msg.LclMsg.msg:=GM_SETMASK;
    Msg.Grid:=Self;
    Msg.Col:=FCol;
    Msg.Row:=FRow;
    Msg.Value:=GetEditMask(FCol, FRow);
    FEditor.Dispatch(Msg);
    // Set the editor value
    Msg.LclMsg.msg:=GM_SETVALUE;
    Msg.Grid:=Self;
    Msg.Col:=FCol;
    Msg.Row:=FRow;
    Msg.Value:=GetEditText(Fcol, FRow);
    FEditor.Dispatch(Msg);
  end;
end;

function TCustomXGrid.EditorCanAcceptKey(const ch: TUTF8Char): boolean;
begin
  result := True;
end;

function TCustomXGrid.EditorIsReadOnly: boolean;
begin
  result := GetColumnReadonly(Col);
end;

procedure TCustomXGrid.GetAutoFillColumnInfo(const Index: Integer; var aMin,aMax,aPriority: Integer);
var
  C: TxGridColumn;
begin
  if Index<FixedCols then
    APriority := 0
  else if Columns.Enabled then begin
    C := ColumnFromGridColumn(Index);
    if C<>nil then begin
      aMin := C.MinSize;
      aMax := C.MaxSize;
      aPriority := C.SizePriority;
    end else
      APriority := 1;
  end else
    APriority := 1;
end;

function TCustomXGrid.GetCellHintText(ACol, ARow: Integer): string;
begin
  Result := '';
  if Assigned(FOnGetCellHint) then
    FOnGetCellHint(self, ACol, ARow, result);
end;

function TCustomXGrid.GetTruncCellHintText(ACol, ARow: Integer): string;
begin
  Result := GetCells(ACol, ARow);
end;

function TCustomXGrid.GetCells(ACol, ARow: Integer): string;
begin
  result := '';
end;

procedure TCustomXGrid.EditorKeyDown(Sender: TObject; var Key:Word; Shift:TShiftState);
begin
  {$ifdef dbgGrid}DebugLn('Grid.EditorKeyDown Key=',dbgs(Key),' INIT');{$endif}
  FEditorKey:=True; // Just a flag to see from where the event comes
  KeyDown(Key, shift);
  case Key of
    VK_LEFT, VK_RIGHT, VK_UP, VK_DOWN,
    VK_PRIOR, VK_NEXT:
    begin
      if ssShift in Shift then begin
        FeditorKey:=False;
        exit;
      end;
    end;
    {
    VK_TAB:
      begin
        if xgoTabs in Options then begin
          MoveNextAuto;
          Key := 0;
        end;
      end;
    }
    VK_RETURN:
      begin
        Key := 0;
        Include(FGridFlags, gfxEditingDone);
        if not MoveNextAuto(ssShift in Shift) then
          ResetEditor;
        Exclude(FGridFlags, gfxEditingDone);
      end;
  end;
  FEditorKey:=False;
  {$ifdef dbgGrid}DebugLn('Grid.EditorKeyDown Key=',dbgs(Key),' END');{$endif}
end;

procedure TCustomXGrid.EditorKeyPress(Sender: TObject; var Key: Char);
var
  AChar: TUTF8Char;
{$ifdef dbgGrid}
function PrintKey:String;
begin
  Result := Dbgs(ord(key))+' $' + IntToHex(ord(key),2);
  if Key>#31 then
    Result := Key + ' ' + Result
end;
{$endif}
begin
  {$ifdef dbgGrid}DebugLn('Grid.EditorKeyPress: INIT Key=',PrintKey);{$Endif}
  FEditorKey := True;
  KeyPress(Key); // grid must get all keypresses, even if they are from the editor
  {$ifdef dbgGrid}DebugLn('Grid.EditorKeyPress: inter Key=',PrintKey);{$Endif}
  case Key of
    ^C,^V,^X:;
    ^M, #27: Key:=#0; // key is already handled in KeyDown
    else begin
      AChar := Key;
      if not EditorCanAcceptKey(AChar) or EditorIsReadOnly then
        Key := #0
      else
        Key := AChar[1];
    end;
  end;
  FEditorKey := False;
  {$ifdef dbgGrid}DebugLn('Grid.EditorKeyPress: END Key=',PrintKey);{$Endif}
end;

procedure TCustomXGrid.EditorKeyUp(Sender: TObject; var key: Word;
  shift: TShiftState);
begin
  FEditorKey := True;
  KeyUp(Key, Shift);
  FEditorKey := False;
end;

procedure TCustomXGrid.SelectEditor;
var
  aEditor: TWinControl;
begin
  aEditor := GetDefaultEditor(Col);
  if EditingAllowed(FCol) and Assigned(OnSelectEditor) then begin
    // in some situations there are only non-selectable cells
    // if xgoAlwaysShowEditor is on set initially editor to nil,
    // user can modify this value in OnSelectEditor if needed
    if not SelectCell(FCol,FRow) then
      aEditor:=nil;
    OnSelectEditor(Self, fCol, FRow, aEditor);
  end;
  if aEditor<>Editor then
    Editor := aEditor;
end;

function TCustomXGrid.EditorAlwaysShown: Boolean;
begin
  Result:=EditingAllowed(FCol) and (xgoAlwaysShowEditor in Options) and not FixedGrid;
end;

//
procedure TCustomXGrid.FixPosition(IsColumn: Boolean; aIndex: Integer);
var
  OldCol,OldRow: Integer;

  procedure FixSelection;
  begin
    if FRow > FRows.Count - 1 then
      FRow := FRows.Count - 1
    else if (FRow < FixedRows) and (FixedRows<FRows.Count) then
      FRow := FixedRows;
    if FCol > FCols.Count - 1 then
      FCol := FCols.Count - 1
    else if (FCol < FixedCols) and (FixedCols<FCols.Count) then
      FCol := FixedCols;
  end;
  procedure FixTopLeft;
  var
    oldTL: TPoint;
    VisCount: Integer;
  begin
    OldTL:=FTopLeft;
    VisCount := FGCache.VisibleGrid.Right-FGCache.VisibleGrid.Left+1;
    if OldTL.X+VisCount>FCols.Count then begin
      OldTL.X := FCols.Count - VisCount;
      if OldTL.X<FixedCols then
        OldTL.X := FixedCols;
    end;
    VisCount := FGCache.VisibleGrid.Bottom-FGCache.VisibleGrid.Top+1;
    if OldTL.Y+VisCount>FRows.Count then begin
      OldTL.Y := FRows.Count - VisCount;
      if OldTL.Y<FixedRows then
        OldTL.Y:=FixedRows;
    end;
    if not PointIgual(OldTL, FTopleft) then begin
      fTopLeft := OldTL;
      //DebugLn('TCustomXGrid.FixPosition ',DbgSName(Self),' FTopLeft=',dbgs(FTopLeft));
      topleftChanged;
    end;
  end;
  procedure FixEditor;
  var
    ColRow: Integer;
  begin
    if FixedGrid then begin
      EditorMode:=False;
      exit;
    end;
    if IsColumn then
      ColRow:=OldCol
    else
      ColRow:=OldRow;
    {$ifdef dbgeditor}
    DebugLn('FixEditor: aIndex=%d ColRow=%d EditorMode=%s',[aIndex,ColRow,dbgs(EditorMode)]);
    {$endif}
    // Changed index is same as current colrow, new colrow may change
    if AIndex=ColRow then begin
      EditorMode:=False;
      if EditorAlwaysShown then begin
        SelectEditor;
        EditorMode:=True;
      end;
    end else
    // Changed index in before current colrow, just translate editor
    if (AIndex<ColRow) and EditorMode then begin
      if IsColumn then
        AdjustEditorBounds(ColRow-1, OldRow)
      else
        AdjustEditorBounds(OldCol, ColRow-1)
    end;
    // else: changed index is after current colrow, it doesn't affect editor
  end;
begin
  OldCol := Col;
  OldRow := Row;
  FixTopleft;
  FixSelection;
  CheckPosition;
  UpdateSelectionRange;
  VisualChange;
  FixEditor;
end;

procedure TCustomXGrid.EditorShowChar(Ch: TUTF8Char);
begin
  SelectEditor;
  if FEDitor<>nil then begin
    if EditorCanAcceptKey(ch) and not EditorIsReadOnly then begin
      EditorShow(true);
      TWSCustomXGridClass(WidgetSetClass).SendCharToEditor(Editor, Ch);
    end;
  end;
end;

procedure TCustomXGrid.EditorSetMode(const AValue: Boolean);
begin
  {$ifdef dbgGrid}DebugLn('Grid.EditorSetMode=',dbgs(Avalue),' INIT');{$endif}
  if not AValue then
    EditorHide
  else
    EditorShow(false);
  {$ifdef dbgGrid}DebugLn('Grid.EditorSetMode END');{$endif}
end;

function TCustomXGrid.GetSelectedColor: TColor;
begin
  Result:=FSelectedColor;
end;

function TCustomXGrid.GetTitleShowPrefix(Column: Integer): boolean;
var
  C: TxGridColumn;
begin
  C := ColumnFromGridColumn(Column);
  if C<>nil then
    result := C.Title.PrefixOption<>poxNone
  else
    result := false;
end;

function TCustomXGrid.GridColumnFromColumnIndex(ColumnIndex: Integer): Integer;
begin
  {$ifdef NewCols}
  result := ColumnIndex + FirstGridColumn;
  if Result>ColCount-1 then
    Result := -1;
  {$else}
  result := Columns.VisibleIndex(ColumnIndex);
  if result>=0 then
    result := result + FixedCols;
  {$endif}
end;

procedure TCustomXGrid.GridMouseWheel(shift: TShiftState; Delta: Integer);
begin
  if ssCtrl in Shift then
    MoveNextSelectable(true, Delta, 0)
  else
    MoveNextSelectable(true, 0, Delta);
end;

function TCustomXGrid.GetEditMask(ACol, ARow: Longint): string;
begin
  result:='';
end;

function TCustomXGrid.GetEditText(ACol, ARow: Longint): string;
begin
  result:='';
end;

function TCustomXGrid.GetColumnAlignment(Column: Integer; ForTitle: Boolean): TAlignment;
var
  C: TxGridColumn;
begin
  C := ColumnFromGridColumn(Column);
  if C<>nil then
    if ForTitle then
      Result := C.Title.Alignment
    else
      Result := C.Alignment
  else
    result := GetDefaultColumnAlignment(Column);
end;

function TCustomXGrid.GetColumnColor(Column: Integer; ForTitle: Boolean): TColor;
var
  C: TxGridColumn;
begin
  C := ColumnFromGridColumn(Column);
  if C<>nil then
    if ForTitle then
      result := C.Title.Color
    else
      result := C.Color
  else
    if ForTitle then
      result := FixedColor
    else
      result := Self.Color;
end;

function TCustomXGrid.GetColumnFont(Column: Integer; ForTitle: Boolean): TFont;
var
  C: TxGridColumn;
begin
  C := ColumnFromGridColumn(Column);
  if C<>nil then
    if ForTitle then
      Result := C.Title.Font
    else
      Result := C.Font
  else begin
    if ForTitle then
      Result := TitleFont
    else
      Result := Self.Font;
  end;
end;

function TCustomXGrid.GetColumnLayout(Column: Integer; ForTitle: boolean): TTextLayout;
var
  C: TxGridColumn;
begin
  C := ColumnFromGridColumn(Column);
  if C<>nil then
    if ForTitle then
      Result := C.Title.Layout
    else
      Result := C.Layout
  else
    result := GetDefaultColumnLayout(Column);
end;

function TCustomXGrid.GetColumnReadonly(Column: Integer): boolean;
var
  C: TxGridColumn;
begin
  C := ColumnFromGridColumn(Column);
  if C<>nil then
    result := C.ReadOnly
  else
    result := GetDefaultColumnReadOnly(Column);
end;

function TCustomXGrid.GetColumnTitle(Column: Integer): string;
var
  C: TxGridColumn;
begin
  C := ColumnFromGridColumn(Column);
  if C<>nil then
    Result := C.Title.Caption
  else
    result := GetDefaultColumnTitle(Column);
end;

function TCustomXGrid.GetColumnWidth(Column: Integer): Integer;
var
  C: TxGridColumn;
begin
  C := ColumnFromGridColumn(Column);
  if C<>nil then
    Result := C.Width
  else
    Result := GetDefaultColumnWidth(Column);
end;

// return the relative cell coordinate of the next cell
// considering AutoAdvance property and selectable cells.
function TCustomXGrid.GetDeltaMoveNext(const Inverse: boolean;
  var ACol, ARow: Integer): boolean;
var

  DeltaCol,DeltaRow: Integer;

  function CalcNextStep: boolean;
  var
    aa: TxAutoAdvance;
    cCol,cRow: Integer;
  begin

    DeltaCol := 0;
    DeltaRow := 0;

    aa := FAutoAdvance;
    if UseRightToLeftAlignment then
      case FAutoAdvance of
        aaLeftUp:     aa := aaRightUp;
        aaLeftDown:   aa := aaRightDown;
        aaLeft:       aa := aaRight;
        aaRightUp:    aa := aaLeftUp;
        aaRightDown:  aa := aaLeftDown;
        aaRight:      aa := aaLeft;
      end;
    // invert direction if necessary
    if Inverse then
      case aa of
        aaRight:      aa := aaLeft;
        aaLeft:       aa := aaRight;
        aaRightDown:  aa := aaLeftUp;
        aaLeftDown:   aa := aaRightUp;
        aaRightUP:    aa := aaLeftDown;
        aaLeftUP:     aa := aaRightDown;
      end;

    case aa of
      aaRight:
        DeltaCol := 1;

      aaLeft:
        DeltaCol := -1;

      aaDown:
        DeltaRow := 1;

      aaRightDown:
        if ACol<ColCount-1 then
          DeltaCol := 1
        else begin
          DeltaCol := FixedCols-ACol;
          DeltaRow := 1;
        end;

      aaRightUP:
        if ACol<ColCount-1 then
          DeltaCol := 1
        else begin
          DeltaCol := FixedCols-ACol;
          DeltaRow := -1;
        end;

      aaLeftUP:
        if ACol>FixedCols then
          DeltaCol := -1
        else begin
          DeltaCol := ColCount-1-ACol;
          DeltaRow := -1;
        end;

      aaLeftDown:
        if ACol>FixedCols then
          DeltaCol := -1
        else begin
          DeltaCol := ColCount-1-ACol;
          DeltaRow := 1;
        end;
    end;

    CCol := ACol + DeltaCol;
    CRow := ARow + DeltaRow;

    // is CCol,CRow within range?
    result :=
      (CCol<=ColCount-1)and(CCol>=FixedCols)and
      (CRow<=RowCount-1)and(CRow>=FixedRows);
  end;
begin

  ACol := FCol;
  ARow := FRow;

  result := False;

  if FAutoAdvance=aaNone then
    exit; // quick case, no auto movement allowed

  if [xgoRowSelect,xgoRelaxedRowSelect]*Options=[xgoRowSelect] then begin
    if Inverse then
      ACol := FixedCols
    else
      ACol := ColCount-1;
  end;

  // browse the grid in autoadvance order
  while CalcNextStep do begin
    ACol := ACol + DeltaCol;
    ARow := ARow + DeltaRow;
    // is cell ACol,ARow selectable?
    result := SelectCell(ACol,ARow);
    if Result then
      break;
  end;

  if result then begin
    // return relative position
    ACol := ACol - FCol;
    ARow := ARow - FRow;
  end else begin
    // no available next cell, return delta anyway
    ACol := DeltaCol;
    ARow := DeltaRow;
  end;
end;

function TCustomXGrid.GetDefaultColumnAlignment(Column: Integer): TAlignment;
begin
  result := DefaultTextStyle.Alignment;
end;

function TCustomXGrid.GetDefaultEditor(Column: Integer): TWinControl;
var
  C: TxGridColumn;
  bs: TxColumnButtonStyle;
begin
  result := nil;
  if EditingAllowed(Col) then begin
    C := ColumnFromGridColumn(Column);
    if C<>nil then begin
      bs := C.ButtonStyle;
      if (bs=cbsxAuto) and (C.PickList<>nil) and (C.PickList.Count>0) then
        bs := cbsxPickList
    end else
      bs := cbsxAuto;

    result := EditorByStyle( Bs );

    // by default do the editor setup here
    // if user wants to change our setup, this can
    // be done in OnSelectEditor
    if (bs=cbsxPickList) and (C<>nil) and (C.PickList<>nil) and
        (result = FPicklistEditor) then begin
      FPickListEditor.Items.Assign(C.PickList);
      FPickListEditor.DropDownCount := C.DropDownRows;
    end

  end;
end;

function TCustomXGrid.GetDefaultRowHeight: integer;
var
  TmpCanvas: TCanvas;
begin
  tmpCanvas := GetWorkingCanvas(Canvas);
  tmpCanvas.Font := Font;
  result := tmpCanvas.TextHeight('Fj')+7;
  if tmpCanvas<>Canvas then
    FreeWorkingCanvas(tmpCanvas);
end;

function TCustomXGrid.GetGridDrawState(ACol, ARow: Integer): TxGridDrawState;
begin
  Result := [];
  if ARow < FFixedRows then
    include(Result, xgdFixed)
  else begin
    if (aCol = FCol) and (aRow = FRow) then
      Result := Result + [xgdFocused, xgdSelected]
    else
    if IsCellSelected[aCol, aRow] then
      include(Result, xgdSelected);
  end;
  with FGCache do begin
    if (ACol = HotCell.x) and (ARow = HotCell.y) and not IsPushCellActive()
      then Include(Result, xgdHot);
    if ClickCellPushed and (ACol = PushedCell.x) and (ARow = PushedCell.y)
      then Include(Result, xgdPushed);
  end;
end;

function TCustomXGrid.GetScrollBarPosition(Which: integer): Integer;
var
  ScrollInfo: TScrollInfo;
begin
  if HandleAllocated then begin
    ScrollInfo.cbSize := SizeOf(ScrollInfo);
    ScrollInfo.fMask := SIF_POS;
    GetScrollInfo(Handle, Which, ScrollInfo);
    Result:=ScrollInfo.nPos;
  end;
end;

function TCustomXGrid.GetDefaultColumnWidth(Column: Integer): Integer;
begin
  result := FDefColWidth;
end;

function TCustomXGrid.GetDefaultColumnLayout(Column: Integer): TTextLayout;
begin
  result := DefaultTextStyle.Layout;
end;

function TCustomXGrid.GetDefaultColumnReadOnly(Column: Integer): boolean;
begin
  result := false;
end;

function TCustomXGrid.GetDefaultColumnTitle(Column: Integer): string;
begin
  result := '';
end;

procedure TCustomXGrid.SetEditText(ACol, ARow: Longint; const Value: string);
begin
end;

function TCustomXGrid.CanGridAcceptKey(Key: Word; Shift: TShiftState): Boolean;
begin
  Result := True;
end;

procedure TCustomXGrid.SetSelectedColor(const AValue: TColor);
begin
  if FSelectedColor<>AValue then begin
    FSelectedColor:=AValue;
    Invalidate;
  end;
end;

procedure TCustomXGrid.SetFixedcolor(const AValue: TColor);
begin
  if FFixedColor<>AValue then begin
    FFixedColor:=Avalue;
    Invalidate;
  end;
end;

function TCustomXGrid.GetFixedcolor: TColor;
begin
  result:=FFixedColor;
end;

function TCustomXGrid.GetFirstVisibleColumn: Integer;
begin
  result := FixedCols;
  while (result<ColCount) and (ColWidths[result]=0) do
    inc(result); // extreme case may return colcount
end;

function TCustomXGrid.GetFirstVisibleRow: Integer;
begin
  result := FixedRows;
  while (result<RowCount) and (RowHeights[result]=0) do
    inc(result); // ditto
end;

function TCustomXGrid.GetLastVisibleColumn: Integer;
begin
  result := ColCount-1;
  while (result>=0) and (ColWidths[result]=0) do
    dec(result); // extreme case may return -1
end;

function TCustomXGrid.GetLastVisibleRow: Integer;
begin
  result := RowCount-1;
  while (result>=0) and (RowHeights[result]=0) do
    dec(result); // ditto
end;

procedure TCustomXGrid.ColWidthsChanged;
begin
  //
end;
procedure TCustomXGrid.RowHeightsChanged;
begin
  //
end;

procedure TCustomXGrid.SaveColumns(cfg: TXMLConfig; Version: integer);
var
  Path,cPath: string;
  i: Integer;
  c: TxGridColumn;
begin
  Path := 'grid/design/columns/';
  cfg.SetValue(Path + 'columnsenabled', True);
  cfg.SetValue(Path + 'columncount', columns.Count);
  for i := 0 to columns.Count - 1 do begin
    c := Columns[i];
    cPath := Path + 'column' + IntToStr(i);
    cfg.setValue(cPath + '/index/value', c.Index);
    if c.IsWidthStored then
      cfg.setValue(cPath + '/width/value', c.Width);
    if c.IsAlignmentStored then
      cfg.setValue(cPath + '/alignment/value', ord(c.Alignment));
    if c.IsLayoutStored then
      cfg.setValue(cPath + '/layout/value', ord(c.Layout));
    cfg.setValue(cPath + '/buttonstyle/value', ord(c.ButtonStyle));
    if c.IsColorStored then
      cfg.setValue(cPath + '/color/value', colortostring(c.Color));
    if c.IsValueCheckedStored then
      cfg.setValue(cPath + '/valuechecked/value', c.ValueChecked);
    if c.IsValueUncheckedStored then
      cfg.setValue(cPath + '/valueunchecked/value', c.ValueUnChecked);
    if c.PickList.Count>0 then
      cfg.SetValue(cPath + '/picklist/value', c.PickList.CommaText);
    if c.IsSizePriorityStored then
      cfg.SetValue(cPath + '/sizepriority', c.SizePriority);
    if not c.IsDefaultFont then
      CfgSetFontValue(cfg, cPath + '/font', c.Font);
    cfg.setValue(cPath + '/title/caption/value', c.Title.Caption);
    if not c.Title.IsDefaultFont then
      CfgSetFontValue(cfg, cPath + '/title/font', c.Title.Font);
  end;
end;

procedure TCustomXGrid.SaveContent(cfg: TXMLConfig);
var
  i,j,k: Integer;
  Path: string;
begin
  cfg.SetValue('grid/version', GRIDFILEVERSION);

  Cfg.SetValue('grid/saveoptions/create', soxDesign in SaveOptions);
  if soxDesign in SaveOptions then begin
    Cfg.SetValue('grid/design/columncount',  ColCount);
    Cfg.SetValue('grid/design/rowcount',  RowCount);
    Cfg.SetValue('grid/design/fixedcols', FixedCols);
    Cfg.SetValue('grid/design/fixedrows', Fixedrows);
    Cfg.SetValue('grid/design/defaultcolwidth', DefaultColWidth);
    Cfg.SetValue('grid/design/isdefaultrowheight', ord(IsDefRowHeightStored));
    Cfg.SetValue('grid/design/defaultrowheight',DefaultRowHeight);

    if Columns.Enabled then
      saveColumns(cfg, GRIDFILEVERSION)
    else begin
      j:=0;
      for i:=0 to ColCount-1 do begin
        k:=integer(PtrUInt(FCols[i]));
        if (k>=0)and(k<>DefaultColWidth) then begin
          inc(j);
          cfg.SetValue('grid/design/columns/columncount',j);
          cfg.SetValue('grid/design/columns/column'+IntToStr(j)+'/index', i);
          cfg.SetValue('grid/design/columns/column'+IntToStr(j)+'/width', k);
        end;
      end;
    end;

    j:=0;
    for i:=0 to RowCount-1 do begin
      k:=integer(PtrUInt(FRows[i]));
      if (k>=0)and(k<>DefaultRowHeight) then begin
        inc(j);
        cfg.SetValue('grid/design/rows/rowcount',j);
        cfg.SetValue('grid/design/rows/row'+IntToStr(j)+'/index', i);
        cfg.SetValue('grid/design/rows/row'+IntToStr(j)+'/height',k);
      end;
    end;

    Path:='grid/design/options/';
    Cfg.SetValue(Path+'goFixedVertLine/value', xgoFixedVertLine in options);
    Cfg.SetValue(Path+'goFixedHorzLine/value', xgoFixedHorzLine in options);
    Cfg.SetValue(Path+'goVertLine/value',  xgoVertLine in options);
    Cfg.SetValue(Path+'goHorzLine/value',  xgoHorzLine in options);
    Cfg.SetValue(Path+'goRangeSelect/value', xgoRangeSelect in options);
    Cfg.SetValue(Path+'goDrawFocusSelected/value', xgoDrawFocusSelected in options);
    Cfg.SetValue(Path+'goRowSizing/value', xgoRowSizing in options);
    Cfg.SetValue(Path+'goColSizing/value', xgoColSizing in options);
    Cfg.SetValue(Path+'goRowMoving/value', xgoRowMoving in options);
    Cfg.SetValue(Path+'goColMoving/value', xgoColMoving in options);
    Cfg.SetValue(Path+'goEditing/value', xgoEditing in options);
    Cfg.SetValue(Path+'goAutoAddRows/value', xgoAutoAddRows in options);
    Cfg.SetValue(Path+'goTabs/value', xgoTabs in options);
    Cfg.SetValue(Path+'goRowSelect/value', xgoRowSelect in options);
    Cfg.SetValue(Path+'goAlwaysShowEditor/value', xgoAlwaysShowEditor in options);
    Cfg.SetValue(Path+'goThumbTracking/value', xgoThumbTracking in options);
    Cfg.SetValue(Path+'goColSpanning/value', xgoColSpanning in options);
    cfg.SetValue(Path+'goRelaxedRowSelect/value', xgoRelaxedRowSelect in options);
    cfg.SetValue(Path+'goDblClickAutoSize/value', xgoDblClickAutoSize in options);
    Cfg.SetValue(Path+'goSmoothScroll/value', xgoSmoothScroll in Options);
    Cfg.SetValue(Path + 'goRowHigthLight/value', xgoRowHightLight in Options);
  end;

  Cfg.SetValue('grid/saveoptions/position', soxPosition in SaveOptions);
  if soxPosition in SaveOptions then begin
    Cfg.SetValue('grid/position/topleftcol',ftopleft.x);
    Cfg.SetValue('grid/position/topleftrow',ftopleft.y);
    Cfg.SetValue('grid/position/col',fCol);
    Cfg.SetValue('grid/position/row',fRow);
    if xgoRangeSelect in Options then begin
      Cfg.SetValue('grid/position/selection/left',Selection.left);
      Cfg.SetValue('grid/position/selection/top',Selection.top);
      Cfg.SetValue('grid/position/selection/right',Selection.right);
      Cfg.SetValue('grid/position/selection/bottom',Selection.bottom);
    end;
  end;
end;

procedure TCustomXGrid.LoadColumns(cfg: TXMLConfig; Version: integer);
var
  i, k: integer;
  path, cPath, s: string;
  c: TxGridColumn;
begin
  Path := 'grid/design/columns/';
  k := cfg.getValue(Path + 'columncount', 0);
  for i := 0 to k - 1 do
    Columns.Add;
  for i := 0 to k - 1 do begin
    c := Columns[i];
    cPath := Path + 'column' + IntToStr(i);
    c.index := cfg.getValue(cPath + '/index/value', i);
    s := cfg.GetValue(cPath + '/width/value', '');
    if s<>'' then
      c.Width := StrToIntDef(s, 64);
    s := cfg.getValue(cPath + '/alignment/value', '');
    if s<>'' then
      c.Alignment := TAlignment(StrToIntDef(s, 0));
    s := cfg.GetValue(cPath + '/layout/value', '');
    if s<>'' then
      c.Layout := TTextLayout(StrToIntDef(s, 0));
    s := cfg.getValue(cPath + '/buttonstyle/value', '0');
    c.ButtonStyle := TxColumnButtonStyle(StrToInt(s));
    s := cfg.getValue(cPath + '/color/value', '');
    if s<>'' then
      c.Color := StringToColor(s);
    s := cfg.getValue(cPath + '/valuechecked/value', '');
    if s<>'' then
      c.ValueChecked := s;
    s := cfg.getValue(cPath + '/valueunchecked/value', '');
    if s<>'' then
      c.ValueUnChecked := s;
    s := cfg.GetValue(cPath + '/picklist/value', '');
    if s<>'' then
      c.PickList.CommaText := s;
    s := cfg.GetValue(cPath + '/sizepriority/value', '');
    if s<>'' then
      c.SizePriority := StrToIntDef(s, 0);
    s := cfg.GetValue(cPath + '/font/name/value', '');
    if s<>'' then
      cfgGetFontValue(cfg, cPath + '/font', c.Font);
    c.Title.Caption := cfg.getValue(cPath + '/title/caption/value', 'title ' + IntToStr(i));
    s := cfg.GetValue(cPath + '/title/font/name/value', '');
    if s<>'' then
      cfgGetFontValue(cfg, cPath + '/title/font', c.Title.Font);
  end;
end;


procedure TCustomXGrid.LoadContent(cfg: TXMLConfig; Version: Integer);
var
  CreateSaved: Boolean;
  Opt: TxGridOptions;
  i,j,k: Integer;
  Path: string;

    procedure GetValue(optStr:string; aOpt:TxGridOption);
    begin
      if Cfg.GetValue(Path+OptStr+'/value', False) then Opt:=Opt+[aOpt];
    end;

begin
  if soxDesign in FSaveOptions then begin
    CreateSaved:=Cfg.GetValue('grid/saveoptions/create', false);
    if CreateSaved then begin
      Clear;
      Columns.Clear;
      FixedCols:=0;
      FixedRows:=0;

      if cfg.getValue('grid/design/columns/columnsenabled', False) then
        LoadColumns(cfg, version)
      else
        ColCount := Cfg.GetValue('grid/design/columncount', 5);

      RowCount:=Cfg.GetValue('grid/design/rowcount', 5);
      FixedCols:=Cfg.GetValue('grid/design/fixedcols', 1);
      FixedRows:=Cfg.GetValue('grid/design/fixedrows', 1);
      k := Cfg.GetValue('grid/design/isdefaultrowheight', -1);
      if k<>0 then
        DefaultRowheight:=Cfg.GetValue('grid/design/defaultrowheight', DEFROWHEIGHT);
      DefaultColWidth:=Cfg.getValue('grid/design/defaultcolwidth', DEFCOLWIDTH);

      if not Columns.Enabled then begin
        Path:='grid/design/columns/';
        k:=cfg.getValue(Path+'columncount',0);
        for i:=1 to k do begin
          j:=cfg.getValue(Path+'column'+IntToStr(i)+'/index',-1);
          if (j>=0)and(j<=ColCount-1) then begin
            ColWidths[j]:=cfg.getValue(Path+'column'+IntToStr(i)+'/width',-1);
          end;
        end;
      end;

      Path:='grid/design/rows/';
      k:=cfg.getValue(Path+'rowcount',0);
      for i:=1 to k do begin
        j:=cfg.getValue(Path+'row'+IntToStr(i)+'/index',-1);
        if (j>=0)and(j<=RowCount-1) then begin
          RowHeights[j]:=cfg.getValue(Path+'row'+IntToStr(i)+'/height',-1);
        end;
      end;

      Opt:=[];
      Path:='grid/design/options/';
      GetValue('goFixedVertLine', xgoFixedVertLine);
      GetValue('goFixedHorzLine', xgoFixedHorzLine);
      GetValue('goVertLine',xgoVertLine);
      GetValue('goHorzLine',xgoHorzLine);
      GetValue('goRangeSelect',xgoRangeSelect);
      GetValue('goDrawFocusSelected',xgoDrawFocusSelected);
      GetValue('goRowSizing',xgoRowSizing);
      GetValue('goColSizing',xgoColSizing);
      GetValue('goRowMoving',xgoRowMoving);
      GetValue('goColMoving',xgoColMoving);
      GetValue('goEditing',xgoEditing);
      GetValue('goAutoAddRows',xgoAutoAddRows);
      GetValue('goRowSelect',xgoRowSelect);
      GetValue('goTabs',xgoTabs);
      GetValue('goAlwaysShowEditor',xgoAlwaysShowEditor);
      GetValue('goThumbTracking',xgoThumbTracking);
      GetValue('goColSpanning', xgoColSpanning);
      GetValue('goRelaxedRowSelect',xgoRelaxedRowSelect);
      GetValue('goDblClickAutoSize',xgoDblClickAutoSize);
      GetValue('goRowHighLight', xgoRowHightLight);
      if Version>=2 then
      begin
        GetValue('goSmoothScroll',xgoSmoothScroll);
      end;

      Options:=Opt;
    end;

    CreateSaved:=Cfg.GetValue('grid/saveoptions/position', false);
    if CreateSaved then
    begin
      i:=Cfg.GetValue('grid/position/topleftcol',-1);
      j:=Cfg.GetValue('grid/position/topleftrow',-1);
      if CellToGridZone(i,j)=xgzNormal then begin
        tryScrollto(i,j);
      end;
      i:=Cfg.GetValue('grid/position/col',-1);
      j:=Cfg.GetValue('grid/position/row',-1);
      if (i>=FFixedCols)and(i<=ColCount-1) and
         (j>=FFixedRows)and(j<=RowCount-1) then begin
        MoveExtend(false, i,j);
      end;
      if xgoRangeSelect in Options then begin
        FRange.left:=Cfg.getValue('grid/position/selection/left',FCol);
        FRange.Top:=Cfg.getValue('grid/position/selection/top',FRow);
        FRange.Right:=Cfg.getValue('grid/position/selection/right',FCol);
        FRange.Bottom:=Cfg.getValue('grid/position/selection/bottom',FRow);
      end;
    end;
  end;
end;

procedure TCustomXGrid.Loaded;
begin
  inherited Loaded;
  VisualChange;
end;

procedure TCustomXGrid.LockEditor;
begin
  inc(FEditorHidingCount);
  {$ifdef dbgGrid}DebugLn('==> LockEditor: ', dbgs(FEditorHidingCount)); {$endif}
end;

constructor TCustomXGrid.Create(AOwner: TComponent);
begin
  // Inherited create Calls SetBounds->WM_SIZE->VisualChange so
  // fGrid needs to be created before that
  FTitleImageList := nil;
  FCols:=TList.Create;
  FRows:=TList.Create;
  FGCache.AccumWidth:=TList.Create;
  FGCache.AccumHeight:=TList.Create;
  FGCache.ClickCell := point(-1, -1);
  inherited Create(AOwner);

  FColumns := CreateColumns;

  FTitleFont := TFont.Create;
  FTitleFont.OnChange := @OnTitleFontChanged;
  FTitleFontIsDefault := True;

  FAutoAdvance := aaRight;
  FAutoEdit := True;
  FFocusRectVisible := True;
  FDefaultDrawing := True;
  FOptions:=
    [xgoFixedVertLine, xgoFixedHorzLine, xgoVertLine, xgoHorzLine, xgoRangeSelect,
     xgoSmoothScroll ];
  FScrollbars:=ssAutoBoth;
  fGridState:=xgsNormal;
  FDefColWidth:=DEFCOLWIDTH;
  FDefRowHeight:=GetDefaultRowHeight;
  FGridLineColor:=clSilver;
  FGridLineStyle:=psSolid;
  FGridLineWidth := 1;
  fFocusColor:=clRed;
  FFixedColor:=clBtnFace;
  FFixedHotColor:=cl3DLight;
  FSelectedColor:= clHighlight;
  FSelectedUnfocusedColor := RGBToColor(210, 210, 210);
  FRowHighLightColor := clCream;
  FRange:=Rect(-1,-1,-1,-1);
  FDragDx:=3;
  SetBounds(0,0,200,100);
  ColCount:=5;
  RowCount:=5;
  FixedCols:=1;
  FixedRows:=1;
  Editor:=nil;
  FBorderColor := cl3DDKShadow;
  FGridBorderStyle := bsSingle;
  UpdateBorderStyle;
  FIgnoreClick := False;

  ParentColor := False;
  Color:=clWindow;
  FAlternateColor := Color;
  FAltColorStartNormal := true;

  FDefaultTextStyle := Canvas.TextStyle;
  FDefaultTextStyle.Wordbreak := False;
  FDefaultTextStyle.SingleLine:= True;

  FCellHintPriority := chpxTruncOnly;

  FButtonEditor := TxButtonCellEditor.Create(nil);
  FButtonEditor.Name:='ButtonEditor';
  FButtonEditor.Caption:='...';
  FButtonEditor.Visible:=False;
  FButtonEditor.Width:=25;
  FButtonEditor.OnClick := @EditButtonClicked;

  FStringEditor := TxStringCellEditor.Create(nil);
  FStringEditor.name :='StringEditor';
  FStringEditor.Text:='';
  FStringEditor.Visible:=False;
  FStringEditor.Align:=alNone;
  FStringEditor.BorderStyle := bsNone;

  FPicklistEditor := TxPickListCellEditor.Create(nil);
  FPickListEditor.Name := 'PickListEditor';
  FPickListEditor.Visible := False;
  FPickListEditor.AutoSize := false;

  FButtonStringEditor := TxCompositeCellEditor.Create(nil);
  FButtonStringEditor.Name:='ButtonTextEditor';
  FButtonStringEditor.Visible:=False;
  FButtonStringEditor.AddEditor(FStringEditor, alClient, true);
  FButtonStringEditor.AddEditor(FButtonEditor, alRight, false);

  FFastEditing := True;
  TabStop := True;
  FAllowOutboundEvents:=True;

  FHeaderHotZones := [xgzFixedCols];
  FHeaderPushZones := [xgzFixedCols];
  ResetHotCell;
  ResetPushedCell;
  //FSortOrder := soxAscending;
  //FSortColumn:=-1;
  FAscImgInd:=-1;
  FDescImgInd:=-1;
  // Default bitmaps for cbsCheckedColumn
  FUnCheckedBitmap := LoadResBitmapImage('dbgriduncheckedcb');
  FCheckedBitmap := LoadResBitmapImage('dbgridcheckedcb');
  FGrayedBitmap := LoadResBitmapImage('dbgridgrayedcb');
end;

destructor TCustomXGrid.Destroy;
begin
  {$Ifdef DbgGrid}DebugLn('TCustomXGrid.Destroy');{$Endif}
  FUncheckedBitmap.Free;
  FCheckedBitmap.Free;
  FGrayedBitmap.Free;
  FreeThenNil(FButtonStringEditor);
  FreeThenNil(FPickListEditor);
  FreeThenNil(FStringEditor);
  FreeThenNil(FButtonEditor);
  FreeThenNil(FColumns);
  FreeThenNil(FGCache.AccumWidth);
  FreeThenNil(FGCache.AccumHeight);
  FreeThenNil(FCols);
  FreeThenNil(FRows);
  FreeThenNil(FTitleFont);
  inherited Destroy;
end;

procedure TCustomXGrid.SaveToFile(FileName: string);
var
  Cfg: TXMLConfig;
begin
  if FileExists(FileName) then DeleteFile(FileName);

  Cfg:=TXMLConfig.Create(nil);
  Try
    Cfg.FileName := FileName;
    SaveContent(Cfg);
  Finally
    Cfg.Flush;
    FreeThenNil(Cfg);
  end;
end;

type
  TWinCtrlAccess=class(TWinControl);

procedure TCustomXGrid.SetFocus;
var
  NextControl: TWinControl;
  ParentForm: TCustomForm;
  ForwardTab: boolean;
begin
  {$IFDEF dbgGrid}
  DebugLn('TCustomXGrid.SetFocus INIT.');
  {$ENDIF}
  if (Editor<>nil) and Editor.Focused and
    ([gfxEditorTab,gfxRevEditorTab]*GridFlags<>[]) then begin
    // Editor was doing TAB. Focus next control instead
    ForwardTab:= gfxEditorTab in GridFlags;
    GridFlags:=GridFlags-[gfxEditorTab,gfxRevEditorTab];
    ParentForm:=GetParentForm(Self);
    if ParentForm<>nil then begin
      NextControl:=TWinCtrlAccess(Pointer(ParentForm)).FindNextControl(Self,
                                                      ForwardTab, true, false);
      if NextControl<>nil then begin
        {$IFDEF dbgGrid}
        DebugLn('   Was tabbing, will focus: ',dbgsname(NextControl));
        {$ENDIF}
        if (NextControl<>Self) and (NextControl<>Editor) then begin
          NextControl.SetFocus;
          exit;
        end;
      end;
    end;
  end;
  inherited SetFocus;
  {$IFDEF dbgGrid}
  DebugLn('TCustomXGrid.SetFocus END');
  {$ENDIF}
end;

procedure TCustomXGrid.LoadFromFile(FileName: string);
var
  Cfg: TXMLConfig;
  Version: Integer;
begin
  if not FileExists(FileName) then
    raise Exception.Create(rsGridFileDoesNotExist);

  Cfg:=TXMLConfig.Create(nil);
  Try
    Cfg.Filename := FileName;
    Version:=cfg.GetValue('grid/version',-1);
    if Version=-1 then raise Exception.Create(rsNotAValidGridFile);
    BeginUpdate;
    LoadContent(Cfg, Version);
    EndUpdate;
  Finally
    FreeThenNil(Cfg);
  end;
end;

procedure TCustomXGrid.Clear;
var
  OldR,OldC: Integer;
begin
  // save some properties
  FGridPropBackup.ValidData := True;
  FGridPropBackup.FixedRowCount := FFixedRows;
  FGridPropBackup.FixedColCount := FFixedCols;
  FGridPropBackup.ColCount      := ColCount;
  FGridPropBackup.RowCount      := RowCount;


  // clear structure
  OldR:=RowCount;
  OldC:=ColCount;
  FFixedCols:=0;
  FFixedRows:=0;
  FRows.Count:=0;
  FCols.Count:=0;
  FTopLeft:=Point(-1,-1);
  FRange:=Rect(-1,-1,-1,-1);
  FGCache.TLColOff := 0;
  FGCache.TlRowOff := 0;
  FGCache.HotCellPainted := false;
  ResetHotCell;
  VisualChange;
  SizeChanged(OldR,OldC);
end;

procedure TCustomXGrid.AutoAdjustColumns;
var
  i: Integer;
begin
  For i:=0 to ColCount do
    AutoAdjustColumn(i);
end;

{ TxVirtualGrid }

function TxVirtualGrid.GetCells(Col, Row: Integer): PCellProps;
begin
  // todo: Check range
  Result:=nil;
  if (Col<0) or (Row<0) or (Col>=ColCount) or (Row>=RowCount) then
    raise xEGridException.CreateFmt(rsIndexOutOfRange, [Col, Row]);
  Result:=FCells[Col,Row];
end;

function TxVirtualGrid.Getrows(Row: Integer): PColRowprops;
begin
  Result:= FRows[Row, 0];
end;

function TxVirtualGrid.Getcols(Col: Integer): PColRowProps;
begin
  result:=FCols[Col, 0];
end;

procedure TxVirtualGrid.SetCells(Col, Row: Integer; const AValue: PCellProps);
var
   Cell: PCellProps;
begin
  // todo: Check range
  Cell:=FCells[Col,Row];
  if Cell<>nil then
    DisposeCell(Cell);
  Cell:=AValue;
  FCells[Col,Row]:=Cell;
end;

procedure TxVirtualGrid.Setrows(Row: Integer; const Avalue: PColRowProps);
var
   C: PColRowProps;
begin
  // todo: Check range
  C:=FRows[Row,0];
  if C<>nil then DisposeColRow(C);
  FRows[Row,0]:=AValue;
end;

procedure TxVirtualGrid.Setcolcount(const Avalue: Integer);
begin
  if FColCount=Avalue then Exit;
  {$Ifdef dbgMem}
    DebugLn('TVirtualGrid.SetColCount Value=',AValue);
  {$Endif}
  FColCount:=AValue;
  {$Ifdef dbgMem}
    DBGOut('TVirtualGrid.SetColCount->FCOLS: ');
  {$Endif}
  FCols.SetLength(FColCount, 1);
  {$Ifdef dbgMem}
    DBGOut('TVirtualGrid.SetColCount->FCELLS(',FColCount,',',FRowCount,'): ');
  {$Endif}
  FCells.SetLength(FColCount, FRowCount);
end;


procedure TxVirtualGrid.Setrowcount(const Avalue: Integer);
begin
  if FRowCount=AValue then Exit;
  {$Ifdef dbgMem}
    DebugLn('TVirtualGrid.SetRowCount Value=',AValue);
  {$Endif}
  FRowCount:=AValue;
  {$Ifdef dbgMem}
    DBGOut('TVirtualGrid.SetRowCount->FROWS: ');
  {$Endif}
  FRows.SetLength(FRowCount,1);
  {$Ifdef dbgMem}
    DBGOut('TVirtualGrid.SetRowCount->FCELLS(',FColCount,',',FRowCount,'): ');
  {$Endif}
  FCells.SetLength(FColCount, FRowCount);
end;

procedure TxVirtualGrid.Setcols(Col: Integer; const Avalue: PColRowProps);
var
   C: PColRowProps;
begin
  // todo: Check range
  C:=FCols[Col,0];
  if C<>nil then DisposeColRow(C);
  FCols[Col,0]:=AValue;
end;

procedure TxVirtualGrid.Clear;
begin
  {$Ifdef dbgMem}DBGOut('FROWS: ');{$Endif}FRows.Clear;
  {$Ifdef dbgMem}DBGOut('FCOLS: ');{$Endif}FCols.Clear;
  {$Ifdef dbgMem}DBGOut('FCELLS: ');{$Endif}FCells.Clear;
  FColCount:=0;
  FRowCount:=0;
end;

procedure TxVirtualGrid.Disposecell(var P: Pcellprops);
begin
  if P<>nil then begin
    if P^.Text<>nil then StrDispose(P^.Text);
    Dispose(P);
    P:=nil;
  end;
end;

procedure TxVirtualGrid.DisposeColRow(var p: PColRowProps);
begin
  if P<>nil then begin
    Dispose(P);
    P:=nil;
  end;
end;

function TxVirtualGrid.GetDefaultCell: PcellProps;
begin
  New(Result);
  Result^.Text:=nil;
  Result^.Attr:=nil;
end;

function TxVirtualGrid.GetDefaultColRow: PColRowProps;
begin
  New(Result);
  Result^.FixedAttr:=nil;
  Result^.NormalAttr:=nil;
  Result^.Size:=-1;
end;

procedure TxVirtualGrid.Dodestroyitem (Sender: Tobject; Col,Row: Integer;
  var Item: Pointer);
begin
  {$Ifdef dbgMem}
    DebugLn('TVirtualGrid.doDestroyItem Col=',Col,' Row= ',
            Row,' Item=',Integer(Item));
  {$endif}
  if Item<>nil then begin
    if (Sender=FCols)or(Sender=FRows) then begin
      DisposeColRow(PColRowProps(Item));
    end else begin
      DisposeCell(PCellProps(Item));
    end;
    Item:=nil;
  end;
end;

procedure TxVirtualGrid.doNewitem(Sender: Tobject; Col,Row:Integer;
  var Item: Pointer);
begin
  {$Ifdef dbgMem}
    DebugLn('TVirtualGrid.doNewItem Col=',Col,' Row= ',
            Row,' Item=',Integer(Item));
  {$endif}
  if Sender=FCols then begin
    // Procesar Nueva Columna
    Item:=GetDefaultColRow;
  end else
  if Sender=FRows then begin
    // Procesar Nuevo Renglon
    Item:=GetDefaultColRow;
  end else begin
    // Procesar Nueva Celda
    Item:=nil;
  end;
end;

constructor TxVirtualGrid.Create;
begin
  Inherited Create;
  {$Ifdef DbgGrid}DebugLn('TVirtualGrid.Create');{$Endif}
  FCells:=TPointerPointerArray.Create;
  FCells.OnDestroyItem:=@doDestroyItem;
  FCells.OnNewItem:=@doNewItem;
  FCols:= TPointerPointerArray.Create;
  FCols.OnDestroyItem:=@doDestroyItem;
  FCols.OnNewItem:=@doNewItem;
  FRows:=TPointerPointerArray.Create;
  FRows.OnDestroyItem:=@doDestroyItem;
  FRows.OnNewItem:=@doNewItem;
  RowCount:=4;
  ColCount:=4;
end;

destructor TxVirtualGrid.Destroy;
begin
  {$Ifdef DbgGrid}DebugLn('TVirtualGrid.Destroy');{$Endif}
  Clear;
  FreeThenNil(FRows);
  FreeThenNil(FCols);
  FreeThenNil(FCells);
  inherited Destroy;
end;

procedure TxVirtualGrid.DeleteColRow(IsColumn: Boolean; index: Integer);
begin
  FCells.DeleteColRow(IsColumn, index);
  if IsColumn then begin
    FCols.DeleteColRow(True, index);
    Dec(FColCount);
  end else begin
    FRows.DeleteColRow(True, index);
    Dec(fRowCount);
  end;
end;

procedure TxVirtualGrid.MoveColRow(IsColumn: Boolean; FromIndex, ToIndex: Integer);
begin
  FCells.MoveColRow(IsColumn, FromIndex, ToIndex);
  if IsColumn then FCols.MoveColRow(True, FromIndex, ToIndex)
  else             FRows.MoveColRow(True, FromIndex, ToIndex);
end;

procedure TxVirtualGrid.ExchangeColRow(IsColumn: Boolean; index,
  WithIndex: Integer);
begin
  FCells.ExchangeColRow(IsColumn, index, WithIndex);
  if IsColumn then FCols.ExchangeColRow(true, index, WithIndex)
  else             FRows.ExchangeColRow(True, index, WithIndex);
end;

procedure TxVirtualGrid.InsertColRow(IsColumn: Boolean; Index: Integer);
begin
  if IsColumn then begin
    ColCount := ColCount + 1;
    MoveColRow(true, ColCount-1, Index);
  end else begin
    RowCount := RowCount + 1;
    MoveColRow(false, RowCount-1, Index);
  end;
end;

procedure TxStringCellEditor.WndProc(var TheMessage: TLMessage);
begin
	{$IfDef GridTraceMsg}
	TransMsg('StrCellEditor: ', TheMessage);
	{$Endif}
  if FGrid<>nil then
    case TheMessage.Msg of
      LM_CLEAR,
      LM_CUT,
      LM_PASTE:
        begin
          if FGrid.EditorIsReadOnly then
            exit;
        end;
    end;
  inherited WndProc(TheMessage);
end;

{ TxStringCellEditor }

procedure TxStringCellEditor.Change;
begin
  {$IfDef DbgGrid} DebugLn('TStringCellEditor.Change INIT text=',Text);{$ENDIF}
  inherited Change;
  if (FGrid<>nil) and Visible then begin
    FGrid.SetEditText(FCol, FRow, Text);
  end;
  {$IfDef DbgGrid} DebugLn('TStringCellEditor.Change END');{$ENDIF}
end;

procedure TxStringCellEditor.EditingDone;
begin
  inherited EditingDone;
  if FGrid<>nil then
    FGrid.EditingDone;
end;

procedure TxStringCellEditor.KeyDown(var Key: Word; Shift: TShiftState);
  function AllSelected: boolean;
  begin
    result := (SelLength>0) and (SelLength = UTF8Length(Text));
  end;
  function AtStart: Boolean;
  begin
    Result:= (SelStart=0);
  end;
  function AtEnd: Boolean;
  begin
    result := ((SelStart+1)>UTF8Length(Text)) or AllSelected;
  end;
  procedure doEditorKeyDown;
  begin
    if FGrid<>nil then
      FGrid.EditorkeyDown(Self, key, shift);
  end;
  procedure doGridKeyDown;
  begin
    if FGrid<>nil then
      FGrid.KeyDown(Key, shift);
  end;
  function GetFastEntry: boolean;
  begin
    if FGrid<>nil then
      Result := FGrid.FastEditing
    else
      Result := False;
  end;
  procedure CheckEditingKey;
  begin
    if (FGrid=nil) or FGrid.EditorIsReadOnly then
      Key := 0;
  end;
var
  IntSel: boolean;
begin
  {$IfDef dbgGrid}
  DebugLn('TStringCellEditor.KeyDown INIT: Key=', Dbgs(Key),
    ' SelStart=',Dbgs(SelStart),' SelLenght=',dbgs(SelLength),
    ' Len(text)=',dbgs(Length(Text)),' Utf8Len(Text)=',dbgs(UTF8Length(Text)));
  {$Endif}
  inherited KeyDown(Key,Shift);
  case Key of
    VK_F2:
      if AllSelected then begin
        SelLength := 0;
        SelStart := Length(Text);
      end;
    VK_DELETE, VK_BACK:
    begin
      CheckEditingKey;
    end;
    VK_UP, VK_DOWN:
      doGridKeyDown;
    VK_LEFT, VK_RIGHT:
      if GetFastEntry then begin
        IntSel:=
          ((Key=VK_LEFT) and not AtStart) or
          ((Key=VK_RIGHT) and not AtEnd);
      if not IntSel then begin
          doGridKeyDown;
      end;
    end;
    VK_END, VK_HOME:
      ;
    else
      doEditorKeyDown;
  end;
  {$IfDef dbgGrid}
  DebugLn('TStringCellEditor.KeyDown END: Key=', Dbgs(Key),
    ' SelStart=',Dbgs(SelStart),' SelLenght=',Dbgs(SelLength));
  {$Endif}
end;

procedure TxStringCellEditor.msg_SetMask(var Msg: TxGridMessage);
begin
  EditMask:=msg.Value;
end;


procedure TxStringCellEditor.msg_SetValue(var Msg: TxGridMessage);
begin
  Text:=Msg.Value;
  SelStart := UTF8Length(Text);
end;

procedure TxStringCellEditor.msg_GetValue(var Msg: TxGridMessage);
begin
  Msg.Col:=FCol;
  Msg.Row:=FRow;
  Msg.Value:=Text;
end;

procedure TxStringCellEditor.msg_SetGrid(var Msg: TxGridMessage);
begin
  FGrid:=Msg.Grid;
  Msg.Options:=EO_AUTOSIZE or EO_SELECTALL or EO_HOOKKEYPRESS or EO_HOOKKEYUP;
end;

procedure TxStringCellEditor.msg_SelectAll(var Msg: TxGridMessage);
begin
  SelectAll;
end;

procedure TxStringCellEditor.msg_SetPos(var Msg: TxGridMessage);
begin
  FCol := Msg.Col;
  FRow := Msg.Row;
end;

procedure TxStringCellEditor.msg_GetGrid(var Msg: TxGridMessage);
begin
  Msg.Grid := FGrid;
  Msg.Options:= EO_IMPLEMENTED;
end;

constructor TxStringCellEditor.Create(Aowner: TComponent);
begin
  inherited Create(Aowner);
  AutoSize := false;
end;

{ TxGridColumnTitle }

procedure TxGridColumnTitle.FontChanged(Sender: TObject);
begin
  FisDefaultTitleFont := False;
  FColumn.ColumnChanged;
end;

function TxGridColumnTitle.GetAlignment: TAlignment;
begin
  if FAlignment = nil then
    result := GetDefaultAlignment
  else
    result := FAlignment^;
end;

function TxGridColumnTitle.GetCaption: string;
begin
  if FCaption = nil then
    result := GetDefaultCaption
  else
    result := FCaption;
end;

function TxGridColumnTitle.GetColor: TColor;
begin
  if FColor = nil then
    result := GetDefaultColor
  else
    result := FColor^;
end;

procedure TxGridColumnTitle.FillTitleDefaultFont;
var
  AGrid: TCustomXGrid;
begin
  AGrid :=  FColumn.Grid;
  if AGrid<>nil then
    FFont.Assign( AGrid.TitleFont )
  else
    FFont.Assign( FColumn.Font );
  FIsDefaultTitleFont := True;
end;

function TxGridColumnTitle.GetFont: TFont;
begin
  Result := FFont;
end;

function TxGridColumnTitle.GetLayout: TTextLayout;
begin
  if FLayout = nil then
    result := GetDefaultLayout
  else
    result := FLayout^;
end;

function TxGridColumnTitle.IsAlignmentStored: boolean;
begin
  result := FAlignment <> nil;
end;

function TxGridColumnTitle.IsCaptionStored: boolean;
begin
  result := true;
end;

function TxGridColumnTitle.IsColorStored: boolean;
begin
  result := FColor <> nil;
end;

function TxGridColumnTitle.IsFontStored: boolean;
begin
  result := not IsDefaultFont;
end;

function TxGridColumnTitle.IsLayoutStored: boolean;
begin
  result := FLayout <> nil;
end;

procedure TxGridColumnTitle.SetAlignment(const AValue: TAlignment);
begin
  if Falignment = nil then begin
    if AValue = GetDefaultAlignment then
      exit;
    New(Falignment)
  end else if FAlignment^ = AValue then
    exit;
  FAlignment^ := AValue;
  FColumn.ColumnChanged;
end;

procedure TxGridColumnTitle.SetCaption(const AValue: TCaption);
begin
  if (FCaption=nil)or(AValue<>FCaption^) then begin
    if FCaption<>nil then
      StrDispose(FCaption);
    FCaption := StrNew(PChar(AValue));
    FColumn.ColumnChanged;
  end;
end;

function TxGridColumnTitle.GetxCaption: string;
begin
  if FxCaption = nil then
    result := GetxDefaultCaption
  else
    result := FxCaption;
end;

function TxGridColumnTitle.IsxCaptionStored: Boolean;
begin
  result := true;
end;

procedure TxGridColumnTitle.SetWordWrap(AValue: Boolean);
begin
  if FWordWrap <> AValue then
  begin
    FWordWrap := AValue;
    Column.ColumnChanged;
  end;
end;

procedure TxGridColumnTitle.SetxImageIndex(AValue: Integer);
begin
  if FxImageIndex=AValue then Exit;
  FxImageIndex:=AValue;
  FColumn.ColumnChanged;
end;

procedure TxGridColumnTitle.SetxWordWrap(AValue: Boolean);
begin
  if FxWordWrap = AValue then Exit;
  FxWordWrap := AValue;
  Column.ColumnChanged;
end;

procedure TxGridColumnTitle.SetxCaption(const AValue: TCaption);
begin
  if (FxCaption = nil) or ( AValue <> FxCaption^) then
  begin
    if FxCaption <> nil then  StrDispose(FxCaption);
    FxCaption := StrNew(PChar(AValue));
    Column.ColumnChanged;
  end;
end;

procedure TxGridColumnTitle.SetColor(const AValue: TColor);
begin
  if FColor=nil then begin
    if AValue = GetDefaultColor then
      exit;
    New(FColor)
  end else if FColor^=AValue then
    exit;
  FColor^ := AValue;
  FColumn.ColumnChanged;
end;

procedure TxGridColumnTitle.SetFont(const AValue: TFont);
begin
  if not FFont.IsEqual(AValue) then
    FFont.Assign(AValue);
end;

procedure TxGridColumnTitle.SetImageIndex(const AValue: Integer);
begin
  if FImageIndex = AValue then exit;
  FImageIndex := AValue;
  FColumn.ColumnChanged;
end;

procedure TxGridColumnTitle.SetImageLayout(const AValue: TButtonLayout);
begin
  if FImageLayout = AValue then exit;
  FImageLayout := AValue;
  FColumn.ColumnChanged;
end;

procedure TxGridColumnTitle.SetLayout(const AValue: TTextLayout);
begin
  if FLayout = nil then begin
    if AValue = GetDefaultLayout then
      exit;
    New(FLayout)
  end else if FLayout^ = AValue then
    exit;
  FLayout^ := AValue;
  FColumn.ColumnChanged;
end;

procedure TxGridColumnTitle.SetPrefixOption(const AValue: TxPrefixOption);
begin
  if FPrefixOption=AValue then exit;
  FPrefixOption:=AValue;
  FColumn.ColumnChanged;
end;

procedure TxGridColumnTitle.Assign(Source: TPersistent);
begin
  if Source is TxGridColumnTitle then begin
    Alignment := TxGridColumnTitle(Source).Alignment;
    Layout := TxGridColumnTitle(Source).Layout;
    Caption := TxGridColumnTitle(Source).Caption;
    Color := TxGridColumnTitle(Source).Color;
    Font := TxGridColumnTitle(Source).Font;
    ImageIndex := TxGridColumnTitle(Source).ImageIndex;
  end else
    inherited Assign(Source);
end;

function TxGridColumnTitle.GetDefaultCaption: string;
begin
  Result := ''
end;

function TxGridColumnTitle.GetxDefaultCaption: string;
begin
  Result := ''
end;

function TxGridColumnTitle.GetDefaultAlignment: TAlignment;
begin
  result := taLeftJustify
end;

function TxGridColumnTitle.GetDefaultColor: TColor;
begin
  if FColumn.Grid <> nil then
    result := FColumn.Grid.FixedColor
  else
    result := clBtnFace
end;

function TxGridColumnTitle.GetDefaultLayout: TTextLayout;
begin
  result := tlCenter
end;

function TxGridColumnTitle.GetOwner: TPersistent;
begin
  Result := FColumn;
end;

constructor TxGridColumnTitle.Create(TheColumn: TxGridColumn);
begin
  inherited Create;
  FColumn := TheColumn;
  FIsDefaultTitleFont := True;
  FFont := TFont.Create;
  FillTitleDefaultFont;
  FFont.OnChange := @FontChanged;
  FImageIndex := -1;
  FOldImageIndex := -1;
  FxImageIndex := -1;
  FOldxImageIndex := -1;
  FImageLayout := blGlyphRight;
end;

destructor TxGridColumnTitle.Destroy;
begin
  if FFont<>nil then FFont.Free;
  if FAlignment<>nil then Dispose(FAlignment);
  if FColor<>nil then Dispose(FColor);
  if FCaption<>nil then StrDispose(FCaption); //DisposeStr(FCaption);
  if FLayout<>nil then Dispose(FLayout);
  inherited Destroy;
end;

function TxGridColumnTitle.IsDefault: boolean;
begin
  Result :=  (FAlignment = nil) and (FColor = nil) and (FCaption = nil) and
    IsDefaultFont and (FLayout = nil) and
    (FImageIndex = 0) and (FImageLayout = blGlyphRight);
end;

{ TxGridColumn }

procedure TxGridColumn.FontChanged(Sender: TObject);
begin
  FisDefaultFont := False;
  ColumnChanged;
end;

function TxGridColumn.GetAlignment: TAlignment;
begin
  if FAlignment=nil then
    Result := GetDefaultAlignment
  else
    Result := FAlignment^;
end;

function TxGridColumn.GetColor: TColor;
begin
  if FColor=nil then
    result := GetDefaultColor
  else
    result := FColor^
end;

function TxGridColumn.GetExpanded: Boolean;
begin
  result := True;
end;

function TxGridColumn.GetFont: TFont;
begin
  result := FFont;
end;

function TxGridColumn.GetGrid: TCustomXGrid;
begin
  if Collection is TxGridColumns then
    result := (Collection as TxGridColumns).Grid
  else
    result := nil;
end;

function TxGridColumn.GetLayout: TTextLayout;
begin
  if FLayout=nil then
    result := GetDefaultLayout
  else
    result := FLayout^;
end;

function TxGridColumn.GetMaxSize: Integer;
begin
  if FMaxSize=nil then
    result := GetDefaultMaxSize
  else
    result := FMaxSize^;
end;

function TxGridColumn.GetMinSize: Integer;
begin
  if FMinSize=nil then
    result := GetDefaultMinSize
  else
    result := FMinSize^;
end;

function TxGridColumn.GetSizePriority: Integer;
begin
  if not Visible then
    result := 0
  else
  if FSizePriority=nil then
    result := GetDefaultSizePriority
  else
    result := FSizePriority^;
end;

function TxGridColumn.GetPickList: TStrings;
begin
  Result := FPickList;
end;

function TxGridColumn.GetReadOnly: Boolean;
begin
  if FReadOnly=nil then
    result := GetDefaultReadOnly
  else
    result := FReadOnly^;
end;

function TxGridColumn.GetValueChecked: string;
begin
  if FValueChecked = nil then
    Result := GetDefaultValueChecked
  else
    Result := FValueChecked;
end;

function TxGridColumn.GetValueUnchecked: string;
begin
  if FValueUnChecked = nil then
    Result := GetDefaultValueUnChecked
  else
    Result := FValueUnChecked;
end;

function TxGridColumn.GetVisible: Boolean;
begin
  if FVisible=nil then begin
    result := GetDefaultVisible;
  end else
    result := FVisible^;
end;

function TxGridColumn.GetWidth: Integer;
begin
  {$ifdef newcols}
  if not Visible then
    exit(0);
  {$endif}
  if FWidth=nil then
    result := GetDefaultWidth
  else
    result := FWidth^;
end;

function TxGridColumn.IsAlignmentStored: boolean;
begin
  result := FAlignment <> nil;
end;

function TxGridColumn.IsCanShowEditorStored: Boolean;
begin
  Result := FCanShowEditor = False;
end;

function TxGridColumn.IsColorStored: boolean;
begin
  result := FColor <> nil;
end;

function TxGridColumn.IsFontStored: boolean;
begin
  result := not FisDefaultFont;
end;

function TxGridColumn.IsLayoutStored: boolean;
begin
  result := FLayout <> nil;
end;

function TxGridColumn.IsMinSizeStored: boolean;
begin
  result := FMinSize <> nil;
end;

function TxGridColumn.IsMaxSizeStored: boolean;
begin
  result := FMaxSize <> nil;
end;

function TxGridColumn.IsReadOnlyStored: boolean;
begin
  result := FReadOnly <> nil;
end;

function TxGridColumn.IsSizePriorityStored: boolean;
begin
  result := FSizePriority <> nil;
end;

function TxGridColumn.IsValueCheckedStored: boolean;
begin
  result := FValueChecked <> nil;
end;

function TxGridColumn.IsValueUncheckedStored: boolean;
begin
  Result := FValueUnchecked <> nil;
end;

function TxGridColumn.IsVisibleStored: boolean;
begin
  result := (FVisible<>nil) and not FVisible^;
end;

function TxGridColumn.IsWidthStored: boolean;
begin
  result := FWidth <> nil;
end;

procedure TxGridColumn.SetAlignment(const AValue: TAlignment);
begin
  if FAlignment = nil then begin
    if AValue=GetDefaultAlignment then
      exit;
    New(FAlignment);
  end else if FAlignment^ = AValue then
    exit;
  FAlignment^ := AValue;
  ColumnChanged;
end;

procedure TxGridColumn.SetButtonStyle(const AValue: TxColumnButtonStyle);
begin
  if FButtonStyle=AValue then exit;
  FButtonStyle:=AValue;
  ColumnChanged;
end;

procedure TxGridColumn.SetColor(const AValue: TColor);
begin
  if FColor = nil then begin
    if AValue=GetDefaultColor then
      exit;
    New(FColor)
  end else if FColor^ = AValue then
   exit;
  FColor^ := AValue;
  ColumnChanged;
end;

procedure TxGridColumn.SetExpanded(const AValue: Boolean);
begin
  //todo
end;

procedure TxGridColumn.SetFont(const AValue: TFont);
begin
  if not FFont.IsEqual(AValue) then
    FFont.Assign(AValue);
end;

procedure TxGridColumn.SetLayout(const AValue: TTextLayout);
begin
  if FLayout = nil then begin
    if AValue=GetDefaultLayout then
      exit;
    New(FLayout)
  end else if FLayout^ = AValue then
    exit;
  FLayout^ := AValue;
  ColumnChanged;
end;

procedure TxGridColumn.SetMaxSize(const AValue: Integer);
begin
  if FMaxSize = nil then begin
    if AValue = GetDefaultMaxSize then
      exit;
    New(FMaxSize)
  end else if FMaxSize^ = AVAlue then
    exit;
  FMaxSize^ := AValue;
  ColumnChanged;
end;

procedure TxGridColumn.SetMinSize(const Avalue: Integer);
begin
  if FMinSize = nil then begin
    if AValue = GetDefaultMinSize then
      exit;
    New(FMinSize)
  end else if FMinSize^ = AVAlue then
    exit;
  FMinSize^ := AValue;
  ColumnChanged;
end;

procedure TxGridColumn.SetPickList(const AValue: TStrings);
begin
  if AValue=nil then
    FPickList.Clear
  else
    FPickList.Assign(AValue);
end;

procedure TxGridColumn.SetReadOnly(const AValue: Boolean);
begin
  if FReadOnly = nil then
  begin
    New(FReadOnly)
  end
  else
  if FReadOnly^ = AValue then exit;
  FReadOnly^ := Avalue;
  ColumnChanged;
end;

procedure TxGridColumn.SetSizePriority(const AValue: Integer);
begin
  if FSizePriority = nil then begin
    if AValue = GetDefaultSizePriority then
      exit;
    New(FSizePriority)
  end else if FSizePriority^ = AVAlue then
    exit;
  FSizePriority^ := AValue;
  ColumnChanged;
end;

procedure TxGridColumn.SetTitle(const AValue: TxGridColumnTitle);
begin
  FTitle.Assign(AValue);
end;

procedure TxGridColumn.SetValueChecked(const AValue: string);
begin
  if (FValueChecked=nil)or(CompareText(AValue, FValueChecked)<>0) then begin
    if FValueChecked<>nil then
      StrDispose(FValueChecked)
    else
    if CompareText(AValue, GetDefaultValueChecked)=0 then
      exit;
    FValueChecked := StrNew(PChar(AValue));
    Changed(False);
  end;
end;

procedure TxGridColumn.SetValueUnchecked(const AValue: string);
begin
  if (FValueUnchecked=nil)or(CompareText(AValue, FValueUnchecked)<>0) then begin
    if FValueUnchecked<>nil then
      StrDispose(FValueUnchecked)
    else
      if CompareText(AValue, GetDefaultValueUnchecked)=0 then
        exit;
    FValueUnchecked := StrNew(PChar(AValue));
    Changed(False);
  end;
end;

procedure TxGridColumn.SetVisible(const AValue: Boolean);
begin
  if FVisible = nil then begin
    if AValue=GetDefaultVisible then
      exit;
    New(FVisible)
  end else if FVisible^ = AValue then
    exit;
  FVisible^ := AValue;
  AllColumnsChange;
end;

procedure TxGridColumn.SetWidth(const AValue: Integer);
begin
  if (AValue=0) and not Visible then
    exit;
  if FWidth = nil then begin
    if AValue=GetDefaultWidth then
      exit;
    New(FWidth)
  end else if FWidth^ = AVAlue then
    exit;
  FWidth^ := AValue;
  FWidthChanged:=true;
  ColumnChanged;
end;

function TxGridColumn.GetDefaultReadOnly: boolean;
begin
  result := false;
end;

function TxGridColumn.GetDefaultLayout: TTextLayout;
begin
  result := tlCenter
end;

function TxGridColumn.GetDefaultVisible: boolean;
begin
  Result := True;
end;

function TxGridColumn.GetDefaultValueChecked: string;
begin
  result := '1';
end;

function TxGridColumn.GetDefaultValueUnchecked: string;
begin
  result := '0';
end;

function TxGridColumn.GetDefaultWidth: Integer;
var
  tmpGrid: TCustomXGrid;
begin
  tmpGrid := Grid;
  if tmpGrid<>nil then
    result := tmpGrid.DefaultColWidth
  else
    result := DEFCOLWIDTH;
end;

function TxGridColumn.GetDefaultMaxSize: Integer;
begin
  // get a better default
  Result := 200;
end;

function TxGridColumn.GetDefaultMinSize: Integer;
begin
  // get a better default
  result := 10;
end;

function TxGridColumn.GetDefaultColor: TColor;
var
  TmpGrid: TCustomXGrid;
begin
  TmpGrid := Grid;
  if TmpGrid<>nil then
    result := TmpGrid.Color
  else
    result := clWindow
end;

function TxGridColumn.GetDefaultSizePriority: Integer;
begin
  Result := 1;
end;

procedure TxGridColumn.Assign(Source: TPersistent);
begin
  if Source is TxGridColumn then begin
    //DebugLn('Assigning TxGridColumn[',dbgs(Index),'] a TxGridColumn')
    Collection.BeginUpdate;
    try
      Alignment := TxGridColumn(Source).Alignment;
      ButtonStyle := TxGridColumn(Source).ButtonStyle;
      Color := TxGridColumn(Source).Color;
      DropDownRows := TxGridColumn(Source).DropDownRows;
      //Expanded := TxGridColumn(Source).Expanded; //todo
      Font := TxGridColumn(Source).Font;
      Layout := TxGridColumn(Source).Layout;
      MinSize := TxGridColumn(Source).MinSize;
      MaxSize := TxGridColumn(Source).MaxSize;
      PickList := TxGridColumn(Source).PickList;
      ReadOnly := TxGridColumn(Source).ReadOnly;
      SizePriority := TxGridColumn(Source).SizePriority;
      Title := TxGridColumn(Source).Title;
      Width := TxGridColumn(Source).Width;
      Visible := TxGridColumn(Source).Visible;
    finally
      Collection.EndUpdate;
    end;
  end else
    inherited Assign(Source);
end;

function TxGridColumn.GetDisplayName: string;
begin
  if Title.Caption<>'' then
    Result := Title.Caption
  else
    Result := 'GridColumn';
end;

function TxGridColumn.GetDefaultAlignment: TAlignment;
begin
  if ButtonStyle in [cbsxCheckboxColumn,cbsxButtonColumn] then
    result := taCenter
  else
    result := taLeftJustify;
end;

procedure TxGridColumn.ColumnChanged;
begin
  Changed(False);
  FWidthChanged := False;
end;

procedure TxGridColumn.AllColumnsChange;
begin
  Changed(True);
  FWidthChanged := False;
end;

function TxGridColumn.CreateTitle: TxGridColumnTitle;
begin
  result := TxGridColumnTitle.Create(Self);
end;

procedure TxGridColumn.SetIndex(Value: Integer);
var
  AGrid: TCustomXGrid;
  CurCol,DstCol: Integer;
begin
  AGrid := Grid;
  if (Value<>Index) and (AGrid<>nil) then begin
    // move grid content
    CurCol := Grid.GridColumnFromColumnIndex(Index);
    DstCol := Grid.GridColumnFromColumnIndex(Value);
    if (CurCol>=0) and (DstCol>=0) then begin
      AGrid.GridFlags:=AGrid.GridFlags + [gfxColumnsLocked];
      AGrid.DoOPMoveColRow(true, CurCol, DstCol);
      AGrid.GridFlags:=AGrid.GridFlags - [gfxColumnsLocked];
    end;
  end;
  // move column item index
  inherited SetIndex(Value);
end;

constructor TxGridColumn.Create(ACollection: TCollection);
begin
  inherited Create(ACollection);
  FTitle := CreateTitle;
  FCanShowEditor := True;
  FIsDefaultFont := True;
  FFont := TFont.Create;
  FillDefaultFont;
  FFont.OnChange := @FontChanged;

  FPickList:= TStringList.Create;
  FButtonStyle := cbsxAuto;
  FDropDownRows := 7;
end;

destructor TxGridColumn.Destroy;
begin
  if FAlignment<>nil then Dispose(FAlignment);
  if FColor<>nil then Dispose(FColor);
  if FVisible<>nil then Dispose(FVisible);
  if FReadOnly<>nil then Dispose(FReadOnly);
  if FWidth<>nil then Dispose(FWidth);
  if FLayout<>nil then Dispose(FLayout);
  if FMaxSize<>nil then Dispose(FMaxSize);
  if FMinSize<>nil then Dispose(FMinSize);
  if FSizePriority<>nil then Dispose(FSizePriority);
  if FValueChecked<>nil then StrDispose(FValueChecked);
  if FValueUnchecked<>nil then StrDispose(FValueUnchecked);

  FreeThenNil(FPickList);
  FreeThenNil(FFont);
  FreeThenNil(FTitle);
  inherited Destroy;
end;

procedure TxGridColumn.FillDefaultFont;
var
  AGrid: TCustomXGrid;
begin
  AGrid := Grid;
  if (AGrid<>nil) then begin
    FFont.Assign(AGrid.Font);
    FIsDefaultFont := True;
  end;
end;

function TxGridColumn.IsDefault: boolean;
begin
  result := FTitle.IsDefault and (FAlignment=nil) and (FColor=nil)
    and (FVisible=nil) and (FReadOnly=nil) and (FWidth=nil) and FIsDefaultFont
    and (FLayout=nil) and (FMaxSize=nil) and (FMinSize=nil)
    and (FSizePriority=nil);
end;

{ TxGridColumns }

function TxGridColumns.GetColumn(Index: Integer): TxGridColumn;
begin
  result := TxGridColumn( inherited Items[Index] );
end;

function TxGridColumns.GetEnabled: Boolean;
begin
  result := VisibleCount > 0;
end;

procedure TxGridColumns.SetColumn(Index: Integer; Value: TxGridColumn);
begin
  Items[Index].Assign( Value );
end;

function TxGridColumns.GetVisibleCount: Integer;
{$ifNdef newcols}
var
  i: Integer;
{$endif}
begin
  {$ifdef newcols}
  result := Count;
  {$else}
  result := 0;
  for i:=0 to Count-1 do
    if Items[i].Visible then
      inc(result);
  {$endif}
end;

function TxGridColumns.GetOwner: TPersistent;
begin
  Result := FGrid;
end;

procedure TxGridColumns.Update(Item: TCollectionItem);
begin
  //if (FGrid<>nil) and not (csLoading in FGrid.ComponentState) then
    FGrid.ColumnsChanged(TxGridColumn(Item));
end;

procedure TxGridColumns.TitleFontChanged;
var
  c: TxGridColumn;
  i: Integer;
begin
  for i:=0 to Count-1 do begin
    c := Items[i];
    if (c<>nil)and(c.Title.IsDefaultFont) then begin
      c.Title.FillTitleDefaultFont;
    end;
  end;
end;

procedure TxGridColumns.FontChanged;
var
  c: TxGridColumn;
  i: Integer;
begin
  for i:=0 to Count-1 do begin
    c := Items[i];
    if (c<>nil)and(c.IsDefaultFont) then begin
      c.FillDefaultFont;
    end;
  end;
end;

procedure TxGridColumns.RemoveColumn(Index: Integer);
begin
  if HasIndex(Index) then
    Delete(Index)
  else
    raise Exception.Create('Index out of range')
end;

procedure TxGridColumns.MoveColumn(FromIndex, ToIndex: Integer);
begin
  if HasIndex(FromIndex) then
    if HasIndex(ToIndex) then
      Items[FromIndex].Index := ToIndex
    else
      raise Exception.Create('ToIndex out of range')
  else
    raise Exception.Create('FromIndex out of range')
end;

procedure TxGridColumns.ExchangeColumn(Index, WithIndex: Integer);
begin
  if HasIndex(Index) then
    if HasIndex(WithIndex) then begin
      BeginUpdate;
      Items[WithIndex].Index := Index;
      Items[Index+1].Index := WithIndex;
      EndUpdate;
    end else
      raise Exception.Create('WithIndex out of range')
  else
    raise Exception.Create('Index out of range')
end;

procedure TxGridColumns.InsertColumn(Index: Integer);
begin
  FGrid.BeginUpdate;
  Add;
  MoveColumn(Count-1, Index);
  FGrid.EndUpdate;
end;

constructor TxGridColumns.Create(AGrid: TCustomXGrid;
  aItemClass: TCollectionItemClass);
begin
  inherited Create( aItemClass );
  FGrid := AGrid;
end;

function TxGridColumns.Add: TxGridColumn;
begin
  result := TxGridColumn( inherited add );
end;

procedure TxGridColumns.Clear;
begin
  BeginUpdate;
  inherited Clear;
  EndUpdate
end;

function TxGridColumns.RealIndex(Index: Integer): Integer;
{$ifNdef NewCols}
var
  i: Integer;
{$endif}
begin
  {$ifdef NewCols}
  if Index>Count-1 then
    result := -1
  else
    result := Index;
  {$else}
  result := -1;
  if Index>=0 then
    for i:=0 to Count-1 do begin
      if Items[i].Visible then begin
        Dec(index);
        if Index<0 then begin
          result := i;
          exit;
        end;
      end;
    end;
  {$endif}
end;

function TxGridColumns.IndexOf(Column: TxGridColumn): Integer;
var
  i: Integer;
begin
  result := -1;
  for i:=0 to Count-1 do
    if Items[i]=Column then begin
      result := i;
      break;
    end;
end;

function TxGridColumns.IsDefault: boolean;
var
  i: Integer;
begin
  result := True;
  for i:=0 to Count-1 do
    result := Result and Items[i].IsDefault;
end;

function TxGridColumns.HasIndex(Index: Integer): boolean;
begin
  result := (index>-1)and(index<count);
end;

function TxGridColumns.VisibleIndex(Index: Integer): Integer;
var
  i: Integer;
begin
  result := -1;
  if HasIndex(Index) and Items[Index].Visible then
    for i:=0 to Index do
      if Items[i].Visible then
        inc(result);
end;

{ TxButtonCellEditor }

procedure TxButtonCellEditor.msg_SetGrid(var Msg: TxGridMessage);
begin
  FGrid:=Msg.Grid;
  Msg.Options:=EO_HOOKKEYDOWN or EO_HOOKKEYPRESS or EO_HOOKKEYUP;
end;

procedure TxButtonCellEditor.msg_SetBounds(var Msg: TxGridMessage);
begin
  with Msg.CellRect do begin
    if Right-Left>DEFBUTTONWIDTH then
      Left:=Right-DEFBUTTONWIDTH;
    SetBounds(Left, Top, Right-Left, Bottom-Top);
  End;
end;

procedure TxButtonCellEditor.msg_SetPos(var Msg: TxGridMessage);
begin
  FCol := Msg.Col;
  FRow := Msg.Row;
end;

procedure TxButtonCellEditor.msg_Ready(var Msg: TxGridMessage);
begin
  Width := DEFBUTTONWIDTH;
end;

procedure TxButtonCellEditor.msg_GetGrid(var Msg: TxGridMessage);
begin
  Msg.Grid := FGrid;
  Msg.Options:= EO_IMPLEMENTED;
end;

{ TxPickListCellEditor }
procedure TxPickListCellEditor.WndProc(var TheMessage: TLMessage);
begin
  {$IfDef GridTraceMsg}
  TransMsg('PicklistEditor: ', TheMessage);
  {$Endif}
  if TheMessage.msg=LM_KILLFOCUS then begin
    if HWND(TheMessage.WParam) = HWND(Handle) then begin
      // lost the focus but it returns to ourselves
      // eat the message.
      TheMessage.Result := 0;
      exit;
    end;
  end;
  inherited WndProc(TheMessage);
end;

procedure TxPickListCellEditor.KeyDown(var Key: Word; Shift: TShiftState);
  function AllSelected: boolean;
  begin
    result := (SelLength>0) and (SelLength=Length(Text));
  end;
  function AtStart: Boolean;
  begin
    Result:= (SelStart=0);
  end;
  function AtEnd: Boolean;
  begin
    result := ((SelStart+1)>Length(Text)) or AllSelected;
  end;
  procedure doEditorKeyDown;
  begin
    if FGrid<>nil then
      FGrid.EditorkeyDown(Self, key, shift);
  end;
  procedure doGridKeyDown;
  begin
    if FGrid<>nil then
      FGrid.KeyDown(Key, shift);
  end;
  function GetFastEntry: boolean;
  begin
    if FGrid<>nil then
      Result := FGrid.FastEditing
    else
      Result := False;
  end;
  procedure CheckEditingKey;
  begin
    // if editor is not readonly, start editing
    // else not interested
    if (FGrid=nil) or FGrid.EditorIsReadOnly then
      Key := 0;
  end;
var
  IntSel: boolean;
begin
  {$IfDef dbgGrid}
  DebugLn('TPickListCellEditor.KeyDown INIT: Key=',Dbgs(Key));
  {$Endif}
  inherited KeyDown(Key,Shift);
  case Key of

    VK_F2:
      if AllSelected then begin
        SelLength := 0;
        SelStart := Length(Text);
      end;

    VK_RETURN:
      if DroppedDown then begin
        CheckEditingKey;
        DroppedDown := False;
        if Key<>0 then begin
          doEditorKeyDown;
          Key:=0;
        end;
      end else
        doEditorKeyDown;

    VK_DELETE:
      CheckEditingKey;

    VK_UP, VK_DOWN:
      if not DroppedDown then
        doGridKeyDown;

    VK_LEFT, VK_RIGHT:
      if GetFastEntry then begin
        IntSel:=
          ((Key=VK_LEFT) and not AtStart) or
          ((Key=VK_RIGHT) and not AtEnd);
        if not IntSel then begin
            doGridKeyDown;
      end;
    end;

    VK_END, VK_HOME:
      ;
    else
      doEditorKeyDown;
  end;
  {$IfDef dbgGrid}
  DebugLn('TPickListCellEditor.KeyDown END: Key=',Dbgs(Key));
  {$Endif}
end;

procedure TxPickListCellEditor.EditingDone;
begin
  {$ifdef dbgGrid}DebugLn('TPickListCellEditor.EditingDone INIT');{$ENDIF}
  inherited EditingDone;
  if FGrid<>nil then
    FGrid.EditingDone;
  {$ifdef dbgGrid}DebugLn('TPickListCellEditor.EditingDone END');{$ENDIF}
end;

procedure TxPickListCellEditor.DropDown;
begin
  {$ifDef dbgGrid} DebugLn('TPickListCellEditor.DropDown INIT'); {$Endif}
  inherited DropDown;
  {$ifDef dbgGrid} DebugLn('TPickListCellEditor.DropDown END'); {$Endif}
end;

procedure TxPickListCellEditor.CloseUp;
begin
  {$ifDef dbgGrid} DebugLn('TPickListCellEditor.CloseUp INIT'); {$Endif}
  inherited CloseUp;
  {$ifDef dbgGrid} DebugLn('TPickListCellEditor.CloseUp END'); {$Endif}
end;

procedure TxPickListCellEditor.Select;
begin
  if FGrid<>nil then begin
    FGrid.EditorTextChanged(FCol, FRow, Text);
    FGrid.PickListItemSelected(Self);
  end;
  inherited Select;
end;

procedure TxPickListCellEditor.Change;
begin
  if FGrid<>nil then
    FGrid.EditorTextChanged(FCol, FRow, Text);
  inherited Change;
end;

procedure TxPickListCellEditor.msg_GetValue(var Msg: TxGridMessage);
begin
  Msg.Col := FCol;
  Msg.Row := FRow;
  Msg.Value:=Text;
end;

procedure TxPickListCellEditor.msg_SetGrid(var Msg: TxGridMessage);
begin
  FGrid:=Msg.Grid;
  Msg.Options:=EO_AUTOSIZE or EO_SELECTALL or EO_HOOKKEYPRESS or EO_HOOKKEYUP;
end;

procedure TxPickListCellEditor.msg_SetValue(var Msg: TxGridMessage);
begin
  Text := Msg.Value;
  SelStart := Length(Text);
end;

procedure TxPickListCellEditor.msg_SetPos(var Msg: TxGridMessage);
begin
  FCol := Msg.Col;
  FRow := Msg.Row;
end;

procedure TxPickListCellEditor.msg_GetGrid(var Msg: TxGridMessage);
begin
  Msg.Grid := FGrid;
  Msg.Options:= EO_IMPLEMENTED;
end;

{ TxCompositeCellEditor }

procedure TxCompositeCellEditor.DispatchMsg(msg: TxGridMessage);
var
  i: Integer;
begin
  for i:=0 to Length(FEditors)-1 do
    if FEditors[i].Editor<>nil then
      Feditors[i].Editor.Dispatch(msg);
end;

function TxCompositeCellEditor.GetMaxLength: Integer;
var
  AEditor: TWinControl;
begin
  result := 0;
  AEditor := GetActiveControl;
  if AEditor is TCustomEdit then
    result := TCustomEdit(AEditor).MaxLength;
end;

procedure TxCompositeCellEditor.SetMaxLength(AValue: Integer);
var
  AEditor: TWinControl;
begin
  AEditor := GetActiveControl;
  if AEditor is TCustomEdit then
    TCustomEdit(AEditor).MaxLength := AValue;
end;

procedure TxCompositeCellEditor.SetReadOnly(AValue: Boolean);
var
  i: Integer;
begin
  if FReadOnly <> AValue then
  begin
    FReadOnly:=AValue;
    for i:=0 to Length(Feditors)-1 do
    if (FEditors[i].Editor<>nil) and
       (FEditors[i].Editor is TxStringCellEditor) then
    begin
      TxStringCellEditor(FEditors[i].Editor).ReadOnly := AValue;
    end;
  end;
end;

function TxCompositeCellEditor.GetActiveControl: TWinControl;
var
  i: Integer;
begin
  result := nil;
  for i:=0 to Length(Feditors)-1 do
    if (FEditors[i].Editor<>nil) and
       (FEditors[i].ActiveControl) then begin
      Result := FEditors[i].Editor;
      break;
    end;
end;

procedure TxCompositeCellEditor.msg_GetValue(var Msg: TxGridMessage);
var
  i: Integer;
  DefaultValue: string;
  LocalMsg: TxGridMessage;
begin
  Msg.Col := FCol;
  Msg.Row := FRow;

  DefaultValue := Msg.Value;
  for i:=0 to Length(FEditors)-1 do begin

    if FEditors[i].Editor=nil then
      continue;

    LocalMsg := Msg;
    Feditors[i].Editor.Dispatch(LocalMsg);
    if CompareText(DEfaultValue, LocalMsg.Value)<>0 then begin
      // on multiple editors, simply return the first one has
      // a different value than default value
      Msg := LocalMsg;
      break;
    end;

  end;
end;

procedure TxCompositeCellEditor.msg_SetGrid(var Msg: TxGridMessage);
var
  LocalMsg,ResMsg: TxGridMessage;
  i: Integer;
begin
  FGrid:=Msg.Grid;
  ResMsg := Msg;
  for i:=0 to Length(FEditors)-1 do begin
    if FEditors[i].Editor=nil then
      continue;

    LocalMsg := Msg;
    Feditors[i].Editor.Dispatch(LocalMsg);

    if LocalMsg.Options and EO_SELECTALL <> 0 then
      ResMsg.Options := ResMsg.Options or EO_SELECTALL;
    if LocalMsg.Options and EO_HOOKKEYDOWN <> 0 then
      ResMsg.Options := ResMsg.Options or EO_HOOKKEYDOWN;
    if LocalMsg.Options and EO_HOOKKEYPRESS <> 0 then
      ResMsg.Options := ResMsg.Options or EO_HOOKKEYPRESS;
    if LocalMsg.Options and EO_HOOKKEYUP <> 0 then
      ResMsg.Options := ResMsg.Options or EO_HOOKKEYUP;

  end;
  Msg := ResMsg;
end;

procedure TxCompositeCellEditor.msg_SetValue(var Msg: TxGridMessage);
begin
  DispatchMsg(msg);
end;

procedure TxCompositeCellEditor.msg_SetBounds(var Msg: TxGridMessage);
begin
  with Msg.CellRect do
    SetBounds(Left, Top, Right-Left, Bottom-Top);
end;

procedure TxCompositeCellEditor.msg_SetMask(var Msg: TxGridMessage);
begin
  DispatchMsg(Msg);
end;

procedure TxCompositeCellEditor.msg_SelectAll(var Msg: TxGridMessage);
begin
  DispatchMsg(Msg);
end;

procedure TxCompositeCellEditor.CMControlChange(var Message: TLMEssage);
begin
  if (Message.WParam<>0) and (not Boolean(Message.LParam)) then
    TControl(Message.WParam).Align:=alNone;
end;

procedure TxCompositeCellEditor.msg_SetPos(var Msg: TxGridMessage);
begin
  FCol := Msg.Col;
  FRow := Msg.Row;
  DispatchMsg(Msg);
end;

procedure TxCompositeCellEditor.msg_GetGrid(var Msg: TxGridMessage);
begin
  Msg.Grid := FGrid;
  Msg.Options:= EO_IMPLEMENTED;
end;

procedure TxCompositeCellEditor.VisibleChanging;
var
  i: Integer;
  Msg: TxGridMessage;
begin
  inherited VisibleChanging;

  if Visible then begin
    // hidding: hide all editors
    for i:=0 to Length(Feditors)-1 do
      if FEditors[i].Editor<>nil then
        FEDitors[i].Editor.Visible:= not Visible;
  end else begin
    Msg.LclMsg.msg:=GM_READY;
    // showing: show all editors
    for i:=0 to Length(Feditors)-1 do begin
      if FEditors[i].Editor=nil then
        continue;
      FEditors[i].Editor.Parent := Self;
      FEditors[i].Editor.Visible:= True;
      FEditors[i].Editor.Align:=FEditors[i].Align;
      // notify now that it's now shown
      FEditors[i].Editor.Dispatch(Msg);
    end;
  end;
end;

procedure TxCompositeCellEditor.SetFocus;
var
  ActCtrl: TWinControl;
begin
  if Visible then begin
    ActCtrl := GetActiveControl;
    if ActCtrl<>nil then begin
      ActCtrl.Visible:=true;
      ActCtrl.SetFocus;
      exit;
    end;
  end;
  inherited SetFocus;
end;

procedure TxCompositeCellEditor.WndProc(var TheMessage: TLMessage);
begin
  with TheMessage do
  if msg=LM_CHAR then begin
    Result := SendChar(Char(WParam));
    if Result=1 then
      exit;
  end;
  inherited WndProc(TheMessage);
end;

function TxCompositeCellEditor.DoUTF8KeyPress(var UTF8Key: TUTF8Char): boolean;
begin
  Result:=inherited DoUTF8KeyPress(UTF8Key);
  if not Result and (Length(UTF8Key)>1) then begin
    if SendChar(UTF8Key)=1 then begin
      UTF8Key := '';
      Result := true;
    end;
  end;
end;

function TxCompositeCellEditor.SendChar(AChar: TUTF8Char): Integer;
var
  ActCtrl: TWinControl;
begin
  Result := 0;
  ActCtrl := GetActiveControl;
  if (ActCtrl<>nil) and ActCtrl.HandleAllocated then begin
    TWSCustomXGridClass(FGrid.WidgetSetClass).SendCharToEditor(ActCtrl, AChar);
    Result:=1;
  end;
end;

destructor TxCompositeCellEditor.Destroy;
begin
  SetLength(FEditors, 0);
  inherited destroy;
end;

procedure TxCompositeCellEditor.AddEditor(aEditor: TWinControl; aAlign: TAlign;
  ActiveCtrl: boolean);
var
  i: Integer;
begin
  i := Length(FEditors);
  SetLength(FEditors, i+1);
  FEditors[i].Editor := aEditor;
  FEditors[i].Align := aAlign;
  FEditors[i].ActiveControl:=ActiveCtrl;
end;


end.
