unit DesSelection;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls;


type

  { TDesignerSelections }

  TDesignerSelections = class
  private
    FList: TList;
  protected

    function Equals(const List: TDesignerSelections): Boolean;
    function Get(Index: Integer): TPersistent;
    function GetCount: Integer;

  public
    function ControlInSelection(AComponent: TPersistent): Boolean;
    function Add(const Item: TPersistent): Integer;
    procedure Clear;
    property Count: Integer read GetCount;
    constructor Create; virtual;
    destructor Destroy; override;
    constructor Copy(const Selections: TDesignerSelections);
    procedure Assign(const Selections: TDesignerSelections);
    property Items[Index: Integer]: TPersistent read Get; default;
  end;


implementation

{ TDesignerSelections }

function TDesignerSelections.ControlInSelection(AComponent: TPersistent): Boolean;
var
  I: Integer;
begin
  Result := False;
  for I := 0 to Count - 1 do
  begin
    if Items[I] = AComponent then
    begin
      Result := True;
      Break;
    end;
  end;
end;

function TDesignerSelections.Add(const Item: TPersistent): Integer;
var I: Integer;
begin
  I := 0;
  while I < FList.Count do
  begin
    if (TPersistent(FList.Items[I]) = Item) and (FList.Count > 1) then
    begin
      FList.Delete(I);
      Result := -I;
      Exit;
    end;
    Inc(I);
  end;
  Result := FList.Add(Item);
end;

procedure TDesignerSelections.Clear;
begin
  FList.Clear;
end;

constructor TDesignerSelections.Copy(const Selections: TDesignerSelections);
var
  I: Integer;
begin
  Create;
  for I := 0 to Selections.Count - 1 do
    Add(Selections[I]);
end;

procedure TDesignerSelections.Assign(const Selections: TDesignerSelections);
var
  I: Integer;
begin
  Clear;
  for I := 0 to Selections.Count - 1 do
    Add(Selections.Items[I]);
end;

constructor TDesignerSelections.Create;
begin
  inherited;
  FList := TList.Create;
end;

destructor TDesignerSelections.Destroy;
begin
  FList.Free;
  inherited;
end;

function TDesignerSelections.Equals(const List: TDesignerSelections): Boolean;
var
  I: Integer;
begin
  Result := False;
  if List.Count <> Count then Exit;
  for I := 0 to Count - 1 do
    if Items[I] <> List[I] then Exit;
  Result := True;
end;

function TDesignerSelections.Get(Index: Integer): TPersistent;
begin
  Result := TPersistent(FList[Index]);
end;

function TDesignerSelections.GetCount: Integer;
begin
  Result := FList.Count;
end;

function CreateSelectionList: TDesignerSelections;
begin
  Result := TDesignerSelections.Create;
end;

end.

