unit SuSynapse;

{$mode objfpc}{$H+}

interface

uses
  SysUtils, Classes, dpCompil, TypInfo, Variants, smtpsend, blcksock, synautil,
  synacode, dpi_mettyps;

type

  { TTCPThread }

  TTCPSockServer = class;
  TTCPThread = class;
  TOnReciveData = procedure (ASocket: TTCPBlockSocket) of object;
  TOnReciveSockData = procedure (ASocket: TTCPBlockSocket; AThread: TTCPThread) of object;

  { TSimpleTCPThread }

  TSimpleTCPThread = class(TThread)
  private
    FSocket: TTCPBlockSocket;
    FAddress: string;
    FPort: string;
    FSleepInterval: Integer;
    FOnReciveData: TOnReciveData;
    WorkSocket: TTCPBlockSocket;
    FOnStatus: THookSocketStatus;
    AStatSocket: TObject;
    AReason: THookSocketReason;
    StatValue: string;
  protected
    procedure Execute;override;
    procedure ProcessingData;
    procedure CallOnStatus;
    procedure DoStatus(Sender: TObject; Reason: THookSocketReason; const Value: string);
  public
    constructor Create(CreateSuspended: boolean);
    destructor Destroy; override;
  published
    property Socket:TTCPBlockSocket read FSocket;
    property OnReciveData: TOnReciveData read FOnReciveData write FOnReciveData;
    property Address: string read FAddress write FAddress;
    property Port: string read FPort write FPort;
    property SleepInterval: Integer read FSleepInterval write FSleepInterval;
    property OnStatus: THookSocketStatus read FOnStatus write FOnStatus;
  end;

  TTCPThread = class(TThread)
  private
    FSocket: TTCPBlockSocket;
    FSleepInterval: Integer;
    FOnReciveData: TOnReciveSockData;
    FOnStatus: THookSocketStatus;
    AStatSocket: TObject;
    AReason: THookSocketReason;
    StatValue: string;
    {Обрабатывает полученные от клиента данные и отправляет их обратно}
  protected
    procedure Execute;override;
    procedure ProcessingData;
    procedure CallOnStatus;
    procedure DoStatus(Sender: TObject; Reason: THookSocketReason; const Value: string);
  public
    //ASocket - дескриптор сокета из очереди подключений.
    constructor Create(ASyspended: boolean; ASocket: integer);
    destructor Destroy; override;
    property Socket:TTCPBlockSocket read FSocket;
    property SleepInterval: Integer read FSleepInterval write FSleepInterval;
    property OnReciveData: TOnReciveSockData read FOnReciveData write FOnReciveData;
    property OnStatus: THookSocketStatus read FOnStatus write FOnStatus;
   end;

  { TTCPSockServer }
  TOnNewTCPThread = procedure (AThread: TTCPThread) of object;

  TTCPSockServer = class(TThread)
  private
     FPort: string;
     FAddress: string;
     FSocket: TTCPBlockSocket;//объект сокета
     FThreadList: TList; //список дескрипторов потоков для работы с клиентами
     FSleepInterval: Integer;
     FOnReciveData: TOnReciveSockData;
     FOnNewTCPThread: TOnNewTCPThread;
     FOnStatus: THookSocketStatus;
     AStatSocket: TObject;
     AReason: THookSocketReason;
     StatValue: string;
     FThreadSockStatus: Boolean;
  protected
     procedure DoNewTCPThread;
     procedure Execute; override;
     procedure CallOnStatus;
     procedure DoStatus(Sender: TObject; Reason: THookSocketReason; const Value: string);
  public
     constructor Create(CreateSuspended: boolean{; const AIP,APort: string});
     destructor Destroy;override;
     property Socket: TTCPBlockSocket read FSocket;
     property ThreadList: TList read FThreadList;
  published
     property Port: string read FPort write FPort;
     property Address: string read FAddress write FAddress;
     property SleepInterval: Integer read FSleepInterval write FSleepInterval;
     property OnReciveData: TOnReciveSockData read FOnReciveData write FOnReciveData;
     property OnNewTCPThread: TOnNewTCPThread read FOnNewTCPThread write FOnNewTCPThread;
     property OnTerminate;
     property OnStatus: THookSocketStatus read FOnStatus write FOnStatus;
     property ThreadSockStatus: Boolean read FThreadSockStatus write FThreadSockStatus;
  end;

  { TSynapseImport }

  TSynapseImport = class(TClassImporter)
    function BlockSerial_ATCommand(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_ATConnect(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_ATResultRead(Instance: Pointer): Variant;
    function BlockSerial_CanRead(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_CanReadEx(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_CanWrite(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_CarrierRead(Instance: Pointer): Variant;
    function BlockSerial_CloseSocket(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_Config(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_Connect(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_cpomComportAccessible(Instance: TObject;
      var Params: Variant): Variant;
    function BlockSerial_cpomReleaseComport(Instance: TObject;
      var Params: Variant): Variant;
    function BlockSerial_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_CTSRead(Instance: Pointer): Variant;
    function BlockSerial_DCB_BaudRateRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_BaudRateWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_DCB_ByteSizeRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_ByteSizeWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_DCB_DCBlengthRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_DCBlengthWrite(Instance: Pointer; AValue: Variant
      );
    function BlockSerial_DCB_EofCharRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_EofCharWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_DCB_ErrorCharRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_ErrorCharWrite(Instance: Pointer; AValue: Variant
      );
    function BlockSerial_DCB_EvtCharRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_EvtCharWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_DCB_FlagsRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_FlagsWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_DCB_ParityRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_ParityWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_DCB_StopBitsRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_StopBitsWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_DCB_wReserved1Read(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_wReserved1Write(Instance: Pointer; AValue: Variant
      );
    function BlockSerial_DCB_wReservedRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_wReservedWrite(Instance: Pointer; AValue: Variant
      );
    function BlockSerial_DCB_XoffCharRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_XoffCharWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_DCB_XoffLimRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_XoffLimWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_DCB_XonCharRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_XonCharWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_DCB_XonLimRead(Instance: Pointer): Variant;
    procedure BlockSerial_DCB_XonLimWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_DeviceRead(Instance: Pointer): Variant;
    function BlockSerial_DSRRead(Instance: Pointer): Variant;
    procedure BlockSerial_DTRWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_EnableRTSToggle(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_ExceptCheck(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_Flush(Instance: TObject; var Params: Variant): Variant;
    function BlockSerial_GetCommState(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_GetErrorDescr(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_GetVersion(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_InstanceActiveRead(Instance: Pointer): Variant;
    function BlockSerial_LastErrorDescRead(Instance: Pointer): Variant;
    function BlockSerial_LastErrorRead(Instance: Pointer): Variant;
    procedure BlockSerial_MaxBandwidthWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_MaxRecvBandwidthRead(Instance: Pointer): Variant;
    procedure BlockSerial_MaxRecvBandwidthWrite(Instance: Pointer;
      AValue: Variant);
    function BlockSerial_MaxSendBandwidthRead(Instance: Pointer): Variant;
    procedure BlockSerial_MaxSendBandwidthWrite(Instance: Pointer;
      AValue: Variant);
    function BlockSerial_ModemStatus(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_Purge(Instance: TObject; var Params: Variant): Variant;
    function BlockSerial_RaiseSynaError(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_RecvBlock(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_RecvByte(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_RecvInteger(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_RecvPacket(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_RecvStream(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_RecvStreamIndy(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_RecvStreamRaw(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_RecvStreamSize(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_Recvstring(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_RecvTerminated(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_RingRead(Instance: Pointer): Variant;
    procedure BlockSerial_RTSWrite(Instance: Pointer; AValue: Variant);
    function BlockSerial_SendBlock(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_SendByte(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_SendingData(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_SendInteger(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_SendStream(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_SendStreamIndy(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_SendStreamRaw(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_SendString(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_SerialCheck(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_SetBreak(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_SetCommState(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_SetSynaError(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_SizeRecvBufferRead(Instance: Pointer): Variant;
    procedure BlockSerial_SizeRecvBufferWrite(Instance: Pointer; AValue: Variant
      );
    function BlockSerial_WaitingData(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSerial_WaitingDataEx(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_AbortSocket(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_Accept(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_Bind(Instance: TObject; var Params: Variant): Variant;
    function BlockSocket_CanRead(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_CanReadEx(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_CanWrite(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_CloseSocket(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_Connect(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_CreateAlternate(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_CreateSocket(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_CreateSocketByName(Instance: TObject;
      var Params: Variant): Variant;
    function BlockSocket_EnableReuse(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_ExceptCheck(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_GetLocalSinIP(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_GetLocalSinPort(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_GetRemoteSinIP(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_GetRemoteSinPort(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_GetSinLocal(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_GetSinRemote(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_GetSins(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_GetSocketProtocol(Instance: TObject;
      var Params: Variant): Variant;
    function BlockSocket_GetSocketType(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_IP6usedGet(Instance: Pointer): Variant;
    function BlockSocket_LastErrorDescGet(Instance: Pointer): Variant;
    function BlockSocket_LastErrorGet(Instance: Pointer): Variant;
    function BlockSocket_LineBufferGet(Instance: Pointer): Variant;
    procedure BlockSocket_LineBufferSet(Instance: Pointer; AValue: Variant);
    function BlockSocket_Listen(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_LocalName(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_NonBlockModeGet(Instance: Pointer): Variant;
    procedure BlockSocket_NonBlockModeSet(Instance: Pointer; AValue: Variant);
    function BlockSocket_RecvBlock(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_RecvByte(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_RecvCounterGet(Instance: Pointer): Variant;
    function BlockSocket_RecvInteger(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_RecvPacket(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_RecvStream(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_RecvStreamRaw(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_RecvStreamSize(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_RecvString(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_RecvTerminated(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_ResetLastError(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_ResolveIPToName(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_ResolveName(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_ResolveNameToIP(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_ResolvePort(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SendBlock(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SendByte(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SendCounterGet(Instance: Pointer): Variant;
    function BlockSocket_SendInteger(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SendStream(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SendStreamRaw(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SendString(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SetLinger(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SetRecvTimeout(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SetRemoteSin(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SetSendTimeout(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SetTimeout(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SizeRecvBufferGet(Instance: Pointer): Variant;
    procedure BlockSocket_SizeRecvBufferSet(Instance: Pointer; AValue: Variant);
    function BlockSocket_SizeSendBufferGet(Instance: Pointer): Variant;
    procedure BlockSocket_SizeSendBufferSet(Instance: Pointer; AValue: Variant);
    function BlockSocket_SockCheck(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_TTLGet(Instance: Pointer): Variant;
    procedure BlockSocket_TTLSet(Instance: Pointer; AValue: Variant);
    function BlockSocket_WaitingData(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_WaitingDataEx(Instance: TObject; var Params: Variant
      ): Variant;
    function Call_HttpGetText(Instance: TObject; var Params: Variant): Variant;
    function Call_HttpGetBinary(Instance: TObject; var Params: Variant): Variant;
    function Call_HttpGetTextTimeout(Instance: TObject; var Params: Variant
      ): Variant;
    function Call_HttpPostBinary(Instance: TObject; var Params: Variant): Variant;
    function Call_HttpPostURL(Instance: TObject; var Params: Variant): Variant;
    function Call_HttpPostFile(Instance: TObject; var Params: Variant): Variant;

    function Call_FtpGetFile(Instance: TObject; var Params: Variant): Variant;
    function Call_FtpPutFile(Instance: TObject; var Params: Variant): Variant;

    function Call_SendTo(Instance: TObject; var Params: Variant): Variant;
    function Call_SendToEx(Instance: TObject; var Params: Variant): Variant;
    function Call_SendToRaw(Instance: TObject; var Params: Variant): Variant;

    function Call_SendToExSSL(Instance: TObject; var Params: Variant): Variant;
    function Call_SendToRawSSL(Instance: TObject; var Params: Variant): Variant;
    function Call_SendMail(Instance: TObject; var Params: Variant): Variant;

    function Call_CharsetConversion(Instance: TObject; var Params: Variant): Variant;

    function Call_DecodeBase64(Instance: TObject; var Params: Variant): Variant;
    function Call_EncodeBase64(Instance: TObject; var Params: Variant): Variant;
    function Call_EncodeURLElement(Instance: TObject; var Params: Variant): Variant;
    function Call_EncodeURL(Instance: TObject; var Params: Variant): Variant;
    function Call_DecodeURL(Instance: TObject; var Params: Variant): Variant;

    function Call_GetSerialPortNames(Instance: TObject; var Params: Variant): Variant;

    function CustomSSL_Accept(Instance: TObject; var Params: Variant): Variant;
    function CustomSSL_Assign(Instance: TObject; var Params: Variant): Variant;
    function CustomSSL_BiShutdown(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_Connect(Instance: TObject; var Params: Variant): Variant;
    function CustomSSL_Create(Instance: TObject; var Params: Variant): Variant;
    function CustomSSL_GetCertInfo(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_GetCipherAlgBits(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_GetCipherBits(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_GetCipherName(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_GetPeerFingerprint(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_GetPeerIssuer(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_GetPeerName(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_GetPeerNameHash(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_GetPeerSerialNo(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_GetPeerSubject(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_GetSSLVersion(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_GetVerifyCert(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_LastError(Instance: Pointer): Variant;
    function CustomSSL_LastErrorDesc(Instance: Pointer): Variant;
    function CustomSSL_LibName(Instance: TObject; var Params: Variant): Variant;
    function CustomSSL_LibVersion(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_Shutdown(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomSSL_SSLEnabled(Instance: Pointer): Variant;
    function CustomSSL_WaitingData(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPListRec_Assign(Instance: TObject; var Params: Variant): Variant;
    function FTPListRec_DirectoryGet(Instance: Pointer): Variant;
    procedure FTPListRec_DirectorySet(Instance: Pointer; AValue: Variant);
    function FTPListRec_FileNameGet(Instance: Pointer): Variant;
    procedure FTPListRec_FileNameSet(Instance: Pointer; AValue: Variant);
    function FTPListRec_FileSizeGet(Instance: Pointer): Variant;
    procedure FTPListRec_FileSizeSet(Instance: Pointer; AValue: Variant);
    function FTPListRec_FileTimeGet(Instance: Pointer): Variant;
    procedure FTPListRec_FileTimeSet(Instance: Pointer; AValue: Variant);
    function FTPListRec_MaskGet(Instance: Pointer): Variant;
    procedure FTPListRec_MaskSet(Instance: Pointer; AValue: Variant);
    function FTPListRec_OriginalLineGet(Instance: Pointer): Variant;
    procedure FTPListRec_OriginalLineSet(Instance: Pointer; AValue: Variant);
    function FTPListRec_PermissionGet(Instance: Pointer): Variant;
    procedure FTPListRec_PermissionSet(Instance: Pointer; AValue: Variant);
    function FTPListRec_ReadableGet(Instance: Pointer): Variant;
    procedure FTPListRec_ReadableSet(Instance: Pointer; AValue: Variant);
    function FTPList_Assign(Instance: TObject; var Params: Variant): Variant;
    function FTPList_Clear(Instance: TObject; var Params: Variant): Variant;
    function FTPList_Count(Instance: TObject; var Params: Variant): Variant;
    function FTPList_ItemsGet(Instance: TObject; var Params: Variant): Variant;
    function FTPList_Lines(Instance: Pointer): Variant;
    function FTPList_List(Instance: Pointer): Variant;
    function FTPList_Masks(Instance: Pointer): Variant;
    function FTPList_ParseLines(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPList_UnparsedLines(Instance: Pointer): Variant;
    function FTPSend_Abort(Instance: TObject; var Params: Variant): Variant;
    function FTPSend_AppendFile(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_ChangeToParentDir(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_ChangeToRootDir(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_ChangeWorkingDir(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_Create(Instance: TObject; var Params: Variant): Variant;
    function FTPSend_CreateDir(Instance: TObject; var Params: Variant): Variant;
    function FTPSend_DataRead(Instance: TObject; var Params: Variant): Variant;
    function FTPSend_DataWrite(Instance: TObject; var Params: Variant): Variant;
    function FTPSend_DeleteDir(Instance: TObject; var Params: Variant): Variant;
    function FTPSend_DeleteFile(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_FileSize(Instance: TObject; var Params: Variant): Variant;
    function FTPSend_FTPCommand(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_GetCurrentDir(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_List(Instance: TObject; var Params: Variant): Variant;
    function FTPSend_Login(Instance: TObject; var Params: Variant): Variant;
    function FTPSend_Logout(Instance: TObject; var Params: Variant): Variant;
    function FTPSend_NoOp(Instance: TObject; var Params: Variant): Variant;
    function FTPSend_ParseRemote(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_ParseRemoteEPSV(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_ReadResult(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_RenameFile(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_RetrieveFile(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_StoreFile(Instance: TObject; var Params: Variant): Variant;
    function FTPSend_StoreUniqueFile(Instance: TObject; var Params: Variant
      ): Variant;
    function FTPSend_TelnetAbort(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPSend_Abort(Instance: TObject; var Params: Variant): Variant;
    function HTTPSend_Clear(Instance: TObject; var Params: Variant): Variant;
    function HTTPSend_Create(Instance: TObject; var Params: Variant): Variant;
    function HTTPSend_DecodeStatus(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPSend_HTTPMethod(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_AddFlagsMess(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_AppendMess(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_Capability(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_CheckFolder(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_CloseFolder(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_CopyMess(Instance: TObject; var Params: Variant): Variant;
    function IMAPSend_Create(Instance: TObject; var Params: Variant): Variant;
    function IMAPSend_CreateFolder(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_DeleteFolder(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_DeleteMess(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_DelFlagsMess(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_ExpungeFolder(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_FetchHeader(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_FetchMess(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_FindCap(Instance: TObject; var Params: Variant): Variant;
    function IMAPSend_GetFlagsMess(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_GetUID(Instance: TObject; var Params: Variant): Variant;
    function IMAPSend_IMAPcommand(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_IMAPuploadCommand(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_List(Instance: TObject; var Params: Variant): Variant;
    function IMAPSend_ListSearch(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_ListSearchSubscribed(Instance: TObject;
      var Params: Variant): Variant;
    function IMAPSend_ListSubscribed(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_Login(Instance: TObject; var Params: Variant): Variant;
    function IMAPSend_Logout(Instance: TObject; var Params: Variant): Variant;
    function IMAPSend_MessageSize(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_NoOp(Instance: TObject; var Params: Variant): Variant;
    function IMAPSend_RenameFolder(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_SearchMess(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_SelectFolder(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_SelectROFolder(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_SetFlagsMess(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_StartTLS(Instance: TObject; var Params: Variant): Variant;
    function IMAPSend_StatusFolder(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_SubscribeFolder(Instance: TObject; var Params: Variant
      ): Variant;
    function IMAPSend_UnsubscribeFolder(Instance: TObject; var Params: Variant
      ): Variant;
    function MessHeader_Clear(Instance: TObject; var Params: Variant): Variant;
    function MessHeader_Create(Instance: TObject; var Params: Variant): Variant;
    function MessHeader_DecodeHeaders(Instance: TObject; var Params: Variant
      ): Variant;
    function MessHeader_EncodeHeaders(Instance: TObject; var Params: Variant
      ): Variant;
    function MessHeader_FindHeader(Instance: TObject; var Params: Variant
      ): Variant;
    function MessHeader_FindHeaderList(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_AddPart(Instance: TObject; var Params: Variant): Variant;
    function MimeMess_AddPartBinary(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_AddPartBinaryFromFile(Instance: TObject;
      var Params: Variant): Variant;
    function MimeMess_AddPartHTML(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_AddPartHTMLBinary(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_AddPartHTMLBinaryFromFile(Instance: TObject;
      var Params: Variant): Variant;
    function MimeMess_AddPartHTMLFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_AddPartMess(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_AddPartMessFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_AddPartMultipart(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_AddPartText(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_AddPartTextEx(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_AddPartTextFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_Clear(Instance: TObject; var Params: Variant): Variant;
    function MimeMess_Create(Instance: TObject; var Params: Variant): Variant;
    function MimeMess_DecodeMessage(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_DecodeMessageBinary(Instance: TObject; var Params: Variant
      ): Variant;
    function MimeMess_EncodeMessage(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_AddSubPart(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_Assign(Instance: TObject; var Params: Variant): Variant;
    function MimePart_AssignSubParts(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_CanSubPart(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_Clear(Instance: TObject; var Params: Variant): Variant;
    function MimePart_ClearSubParts(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_ComposeParts(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_Create(Instance: TObject; var Params: Variant): Variant;
    function MimePart_DecodePart(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_DecodePartHeader(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_DecomposeParts(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_DecomposePartsBinary(Instance: TObject;
      var Params: Variant): Variant;
    function MimePart_DeleteSubPart(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_EncodePart(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_EncodePartHeader(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_GetSubPart(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_GetSubPartCount(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_MimeTypeFromExt(Instance: TObject; var Params: Variant
      ): Variant;
    function MimePart_WalkPart(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_Capability(Instance: TObject; var Params: Variant
      ): Variant;
    function Pop3Send_Create(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_CustomCommand(Instance: TObject; var Params: Variant
      ): Variant;
    function Pop3Send_Dele(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_FindCap(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_List(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_Login(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_Logout(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_NoOp(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_Reset(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_Retr(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_RetrStream(Instance: TObject; var Params: Variant
      ): Variant;
    function Pop3Send_StartTLS(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_Stat(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_Top(Instance: TObject; var Params: Variant): Variant;
    function Pop3Send_Uidl(Instance: TObject; var Params: Variant): Variant;
    function SMTPSend_Create(Instance: TObject; var Params: Variant): Variant;
    function SMTPSend_EnhCodeString(Instance: TObject; var Params: Variant
      ): Variant;
    function SMTPSend_Etrn(Instance: TObject; var Params: Variant): Variant;
    function SMTPSend_FindCap(Instance: TObject; var Params: Variant): Variant;
    function SMTPSend_Login(Instance: TObject; var Params: Variant): Variant;
    function SMTPSend_Logout(Instance: TObject; var Params: Variant): Variant;
    function SMTPSend_MailData(Instance: TObject; var Params: Variant): Variant;
    function SMTPSend_MailFrom(Instance: TObject; var Params: Variant): Variant;
    function SMTPSend_MailTo(Instance: TObject; var Params: Variant): Variant;
    function SMTPSend_NoOp(Instance: TObject; var Params: Variant): Variant;
    function SMTPSend_Reset(Instance: TObject; var Params: Variant): Variant;
    function SMTPSend_StartTLS(Instance: TObject; var Params: Variant): Variant;
    function SMTPSend_Verify(Instance: TObject; var Params: Variant): Variant;
    function SocksBlockSocket_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function SocksBlockSocket_SocksLastErrorGet(Instance: Pointer): Variant;
    function SocksBlockSocket_SocksOpen(Instance: TObject; var Params: Variant
      ): Variant;
    function SocksBlockSocket_SocksRequest(Instance: TObject;
      var Params: Variant): Variant;
    function SocksBlockSocket_SocksResponse(Instance: TObject;
      var Params: Variant): Variant;
    function SocksBlockSocket_UsingSocksGet(Instance: Pointer): Variant;
    function SynaOption_EnabledGet(Instance: Pointer): Variant;
    procedure SynaOption_EnabledSet(Instance: Pointer; AValue: Variant);
    function SynaOption_OptionGet(Instance: Pointer): Variant;
    procedure SynaOption_OptionSet(Instance: Pointer; AValue: Variant);
    function SynaOption_ValueGet(Instance: Pointer): Variant;
    procedure SynaOption_ValueSet(Instance: Pointer; AValue: Variant);
    function TCPBlockSocket_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function TCPBlockSocket_HTTPTunnel(Instance: Pointer): Variant;
    function TCPBlockSocket_SSL(Instance: Pointer): Variant;
    function TCPBlockSocket_SSLAcceptConnection(Instance: TObject;
      var Params: Variant): Variant;
    function TCPBlockSocket_SSLDoConnect(Instance: TObject; var Params: Variant
      ): Variant;
    function TCPBlockSocket_SSLDoShutdown(Instance: TObject; var Params: Variant
      ): Variant;
    function UDPBlockSocket_AddMulticast(Instance: TObject; var Params: Variant
      ): Variant;
    function UDPBlockSocket_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function UDPBlockSocket_DropMulticast(Instance: TObject; var Params: Variant
      ): Variant;
    function UDPBlockSocket_EnableBroadcast(Instance: TObject;
      var Params: Variant): Variant;
    function UDPBlockSocket_EnableMulticastLoop(Instance: TObject;
      var Params: Variant): Variant;
    function UDPBlockSocket_MulticastTTLGet(Instance: Pointer): Variant;
    procedure UDPBlockSocket_MulticastTTLSet(Instance: Pointer; AValue: Variant
      );
    {function (Instance: TObject; var Params: Variant): Variant;}
  private
    function BlockSocket_RecvStreamIndy(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SendStreamIndy(Instance: TObject; var Params: Variant
      ): Variant;
    function BlockSocket_SocketGet(Instance: Pointer): Variant;
    procedure BlockSocket_SocketSet(Instance: Pointer; AValue: Variant);
    function Call_GetDllSSLName(Instance: TObject; var Params: Variant
      ): Variant;
    function Call_GetSSLFileName(Instance: TObject; var Params: Variant
      ): Variant;
    function HTTPSend_PostFile(Instance: TObject; var Params: Variant): Variant;
    function SimpleTCPThread_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function TCPSockServer_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function TCPSockServer_Socket(Instance: Pointer): Variant;
    function TCPSockServer_ThreadList(Instance: Pointer): Variant;
    function TCPThread_Socket(Instance: Pointer): Variant;
  protected
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
       override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure AddMethods(AddMethod: TAddMethodProc); override;
    procedure AddConsts(AddConst: TAddConstProc); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
    procedure AddVars(AddVar: TAddVarProc); override;
  end;

function SendToRawSSL(const MailFrom, MailTo, SMTPHost: string;
    const MailData: TStrings; const Username, Password: string): Boolean;

function SendToExSSL(const MailFrom, MailTo, Subject, SMTPHost: string;
  const MailData: TStrings; const Username, Password: string): Boolean;

function SendMail(const MailFrom, MailTo: string;
  const MailData: TStrings; SMTP: TSMTPSend): Boolean;

implementation

uses httpsend, FileUtil, ftpsend, pop3send, mimemess, mimepart,
  synachar, imapsend, dpEvnthadlrs, synaser, Forms, LazUTF8,
  ssl_openssl11, ssl_openssl11_lib;

type

  { TOnReciveDataHandler }

  TOnReciveDataHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(ASocket: TTCPBlockSocket);
  end;

  { TOnReciveSocketDataHandler }

  TOnReciveSocketDataHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(ASocket: TTCPBlockSocket; AThread: TTCPThread);
  end;

  { TOnNewTCPThreadHandler }

  TOnNewTCPThreadHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(AThread: TTCPThread);
  end;

  { THookSocketStatusHandler }

  THookSocketStatusHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject;
        Reason: THookSocketReason; const Value: String);
  end;

  { THookDataFilterHandler }

  THookDataFilterHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; var Value: AnsiString);
  end;

  { THookVerifyCertHandler }

  THookVerifyCertHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    function CallHandler(Sender: TObject): boolean;
  end;

  {THookSerialStatusHandler}
  THookSerialStatusHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Reason: THookSerialReason;
    const Value: string);
  end;

{ TOnReciveDataHandler }

function TOnReciveDataHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnReciveDataHandler.CallHandler;
end;

procedure TOnReciveDataHandler.CallHandler(ASocket: TTCPBlockSocket);
begin
  Proc.Param[0].Value := TSuPtr(ASocket);
  Proc.Exec;
end;

{ TSimpleTCPThread }

procedure TSimpleTCPThread.Execute;
var
  ASocket: TTCPBlockSocket;
begin
  //создаем новый сокет
  if Assigned(FOnStatus) then
    FSocket.OnStatus := @DoStatus;
  FSocket.CreateSocket;

  //FSocket.Bind(FSocket.LocalName, FPort);
  FSocket.Bind(FAddress, FPort);
  if FSocket.LastError=0 then //связываение с прошло успешно
     FSocket.Listen //переходим в режим ожидания
  else
    raise Exception.Create(FSocket.LastErrorDesc);//ошибка связывания - показываем её пользователю

  repeat
     if FSocket.CanRead(100) then //можем произвести чтение
     begin
       ASocket := TTCPBlockSocket.Create;
       try
         if Assigned(FOnStatus) then  ASocket.OnStatus := @DoStatus;
         ASocket.Socket := FSocket.Accept;
         ASocket.GetSins;
         if ASocket.CanRead(2000) then
         begin
           WorkSocket := ASocket;
           Synchronize(@ProcessingData);
         end;
         ASocket.CloseSocket;
         Sleep(FSleepInterval);
       finally
         ASocket.Free;
       end;
     end;

   until Terminated;//"гуляем" по циклу до тех пор, пока пользователь не остановит
end;

procedure TSimpleTCPThread.ProcessingData;
begin
  if Assigned(FOnReciveData) then
  begin
    FOnReciveData(WorkSocket);
  end;
end;

procedure TSimpleTCPThread.CallOnStatus;
begin
  if Assigned(FOnStatus) then FOnStatus(AStatSocket, AReason, StatValue);
end;

procedure TSimpleTCPThread.DoStatus(Sender: TObject; Reason: THookSocketReason;
  const Value: string);
begin
  AReason:= Reason;
  StatValue:= Value;
  AStatSocket := Sender;
  Synchronize(@CallOnStatus);
end;

constructor TSimpleTCPThread.Create(CreateSuspended: boolean);
begin
  inherited Create(CreateSuspended);
  FSleepInterval := 10;
  FSocket := TTCPBlockSocket.Create;
end;

destructor TSimpleTCPThread.Destroy;
begin
  FSocket.CloseSocket;
  FSocket.Free;
  inherited Destroy;
end;

{ TOnNewTCPThreadHandler }

function TOnNewTCPThreadHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnNewTCPThreadHandler.CallHandler;
end;

procedure TOnNewTCPThreadHandler.CallHandler(AThread: TTCPThread);
begin
  Proc.Param[0].Value := TSuPtr(AThread);
  Proc.Exec;
end;

{ TOnReciveStrDataHandler }

function TOnReciveSocketDataHandler.GetHandlerAdres: Pointer;
begin
  Result := @TOnReciveSocketDataHandler.CallHandler;
end;

procedure TOnReciveSocketDataHandler.CallHandler(ASocket: TTCPBlockSocket;
  AThread: TTCPThread);
begin
  Proc.Param[0].Value := TSuPtr(ASocket);
  Proc.Param[1].Value := TSuPtr(AThread);
  Proc.Exec;
end;

{ TTCPThread }

procedure TTCPThread.Execute;
//var
//  S:string;
begin
  while not Terminated  do
  begin
    //есть данные ожидающие чтения
    if FSocket.WaitingData > 0 then
      Synchronize(@ProcessingData);
    sleep(FSleepInterval);//"спим" миллисекунд
  end;
end;

procedure TTCPThread.ProcessingData;
begin
    if Assigned(FOnReciveData) then
      FOnReciveData(FSocket, Self);
end;

procedure TTCPThread.CallOnStatus;
begin
  if Assigned(FOnStatus) then FOnStatus(AStatSocket, AReason, StatValue);
end;

procedure TTCPThread.DoStatus(Sender: TObject; Reason: THookSocketReason;
  const Value: string);
begin
  AReason:= Reason;
  StatValue:= Value;
  AStatSocket := Sender;
  Synchronize(@CallOnStatus);
end;

constructor TTCPThread.Create(ASyspended: boolean; ASocket: integer);
begin
  inherited Create(ASyspended);
  FSleepInterval := 10;;
  FSocket := TTCPBlockSocket.Create;
  FSocket.Socket := ASocket;
  FSocket.GetSins;
end;

destructor TTCPThread.Destroy;
begin
  FSocket.Free;
  inherited Destroy;
end;

{ TTCPSockServer }

procedure TTCPSockServer.DoNewTCPThread;
begin
  if Assigned(FOnNewTCPThread) then
    FOnNewTCPThread(TTCPThread(FThreadList.Items[FThreadList.Count - 1]));
end;

procedure TTCPSockServer.Execute;
var T:TTCPThread;
begin
  //создаем новый сокет
  if Assigned(FOnStatus) then FSocket.OnStatus:= @DoStatus;
  FSocket.CreateSocket;

  //FSocket.Bind(FSocket.LocalName, FPort);
  FSocket.Bind(FAddress, FPort);
  if FSocket.LastError=0 then //связываение с прошло успешно
     FSocket.Listen //переходим в режим ожидания
  else
    raise Exception.Create(FSocket.LastErrorDesc);//ошибка связывания - показываем её пользователю

  repeat
     if FSocket.CanRead(100) then //можем произвести чтение
     begin
       //получаем дескриптор сокета и создаем новую нить для клиента
       T := TTCPThread.Create(True, FSocket.Accept);
       T.SleepInterval := FSleepInterval;
       if Assigned(FOnReciveData) then
         T.OnReciveData := FOnReciveData;
       if Assigned(OnTerminate) then
         T.OnTerminate:= OnTerminate;
       //определяем обработчик события ONStatus для новой нити
       if Assigned(FOnStatus) and FThreadSockStatus then
       begin
         T.OnStatus:= FOnStatus;
         T.Socket.OnStatus:= @T.DoStatus;
       end;
       //добавляем указатель на нить в список
       FThreadList.Add(pointer(T));
       //запускаем нить на выполнение
       Synchronize(@DoNewTCPThread);
       T.Start;
     end;
   until Terminated;//"гуляем" по циклу до тех пор, пока пользователь не остановит
end;

procedure TTCPSockServer.CallOnStatus;
begin
  if Assigned(FOnStatus) then FOnStatus(AStatSocket, AReason, StatValue);
end;

procedure TTCPSockServer.DoStatus(Sender: TObject; Reason: THookSocketReason;
  const Value: string);
begin
  AReason:= Reason;
  StatValue:= Value;
  AStatSocket := Sender;
  Synchronize(@CallOnStatus);
end;

constructor TTCPSockServer.Create(CreateSuspended: boolean);
begin
  inherited Create(CreateSuspended);
  FThreadSockStatus := True;
  FSocket:=TTCPBlockSocket.Create;
  FAddress := FSocket.LocalName;
  FSleepInterval := 10;
  FThreadList:=TList.Create;
end;

destructor TTCPSockServer.Destroy;
var T:TTCPThread;
begin
  //завершаем все работающие нити
  while FThreadList.Count>0 do
  begin
      T := TTCPThread(FThreadList.Extract(FThreadList.Last));
      T.Terminate;
      T.WaitFor;
      T.Free;
  end;
  //освобождаем память
  FThreadList.Free;
  FSocket.Free;
  inherited Destroy;
end;

function THookSerialStatusHandler.GetHandlerAdres: Pointer;
begin
  Result := @THookSerialStatusHandler.CallHandler;
end;

procedure THookSerialStatusHandler.CallHandler(Sender: TObject;
  Reason: THookSerialReason; const Value: string);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Reason;
  Proc.Param[2].Value := Value;
  Proc.Exec;
end;


{ THookVerifyCertHandler }

function THookVerifyCertHandler.GetHandlerAdres: Pointer;
begin
  Result := @THookVerifyCertHandler.CallHandler;
end;

function THookVerifyCertHandler.CallHandler(Sender: TObject): boolean;
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Result := Proc.Value;
end;

{ THookDataFilterHandler }

function THookDataFilterHandler.GetHandlerAdres: Pointer;
begin
  Result := @THookDataFilterHandler.CallHandler;
end;

procedure THookDataFilterHandler.CallHandler(Sender: TObject;
  var Value: AnsiString);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Value;
  Proc.Exec;
  Value := Proc.Param[1].Value;
end;

{ THookSocketStatusHandler }

function THookSocketStatusHandler.GetHandlerAdres: Pointer;
begin
  Result := @THookSocketStatusHandler.CallHandler;
end;

procedure THookSocketStatusHandler.CallHandler(Sender: TObject;
  Reason: THookSocketReason; const Value: String);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := Reason;
  Proc.Param[2].Value := Value;
  Proc.Exec;
end;


function SendToRawSSL(const MailFrom, MailTo, SMTPHost: string;
  const MailData: TStrings; const Username, Password: string): Boolean;
var
  SMTP: TSMTPSend;
  s, t: string;
begin
  Result := False;
  SMTP := TSMTPSend.Create;
  try
    SMTP.AutoTLS := True;
    SMTP.FullSSL := True;
    SMTP.TargetHost := Trim(SeparateLeft(SMTPHost, ':'));
    s := Trim(SeparateRight(SMTPHost, ':'));
    if (s <> '') and (s <> SMTPHost) then
      SMTP.TargetPort := s;
    SMTP.Username := Username;
    SMTP.Password := Password;
    if SMTP.Login then
    begin
      if SMTP.MailFrom(GetEmailAddr(MailFrom), Length(MailData.Text)) then
      begin
        s := MailTo;
        repeat
          t := GetEmailAddr(Trim(FetchEx(s, ',', '"')));
          if t <> '' then
            Result := SMTP.MailTo(t);
          if not Result then
            Break;
        until s = '';
        if Result then
          Result := SMTP.MailData(MailData);
      end;
      SMTP.Logout;
    end;
  finally
    SMTP.Free;
  end;
end;

function SendToExSSL(const MailFrom, MailTo, Subject, SMTPHost: string;
  const MailData: TStrings; const Username, Password: string): Boolean;
var
  t: TStrings;
begin
  t := TStringList.Create;
  try
    t.Assign(MailData);
    t.Insert(0, '');
    t.Insert(0, 'X-mailer: Synapse - Delphi & Kylix TCP/IP library by Lukas Gebauer');
    t.Insert(0, 'Subject: ' + Subject);
    t.Insert(0, 'Date: ' + Rfc822DateTime(now));
    t.Insert(0, 'To: ' + MailTo);
    t.Insert(0, 'From: ' + MailFrom);
    Result := SendToRawSSL(MailFrom, MailTo, SMTPHost, t, Username, Password);
  finally
    t.Free;
  end;
end;

function SendMail(const MailFrom, MailTo: string;
  const MailData: TStrings; SMTP: TSMTPSend): Boolean;
var
  S, t: string;
begin
  Result := False;
  if SMTP.MailFrom(GetEmailAddr(MailFrom), Length(MailData.Text)) then
  begin
        s := MailTo;
        repeat
          t := GetEmailAddr(Trim(FetchEx(s, ',', '"')));
          if t <> '' then
            Result := SMTP.MailTo(t);
          if not Result then
            Break;
        until s = '';
        if Result then
          Result := SMTP.MailData(MailData);
  end;
end;

{ TSynapseImport }

function TSynapseImport.BlockSerial_ATCommand(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TBlockSerial(Instance).ATCommand(S);
end;

function TSynapseImport.BlockSerial_ATConnect(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TBlockSerial(Instance).ATConnect(S);
end;

function TSynapseImport.BlockSerial_ATResultRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).ATResult;
end;

function TSynapseImport.BlockSerial_CanRead(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).CanRead(Params[0]);
end;

function TSynapseImport.BlockSerial_CanReadEx(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).CanReadEx(Params[0]);
end;

function TSynapseImport.BlockSerial_CanWrite(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).CanWrite(Params[0]);
end;

function TSynapseImport.BlockSerial_CarrierRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).Carrier;
end;

function TSynapseImport.BlockSerial_CloseSocket(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSerial(Instance).CloseSocket;
end;

function TSynapseImport.BlockSerial_Config(Instance: TObject;
  var Params: Variant): Variant;
var
  baud, bits, stop: integer;
  parity: char;
  sofflow, hardflow: Boolean;
  s: string;
begin
  baud := Params[0];
  bits := Params[1];
  S := Params[2];
  parity := Char('');
  if S <> '' then
    parity := S[1];
  stop := Params[3];
  sofflow := Params[4];
  hardflow := Params[5];
  TBlockSerial(Instance).Config(baud, bits, parity, stop, sofflow, hardflow);
end;

function TSynapseImport.BlockSerial_Connect(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSerial(Instance).Connect(Params[0]);
end;

function TSynapseImport.BlockSerial_cpomComportAccessible(Instance: TObject;
  var Params: Variant): Variant;
begin
  {$IFDEF UNIX}
  Result := TBlockSerial(Instance).cpomComportAccessible;
  {$ELSE}
  Result := False;
  {$ENDIF}
end;

function TSynapseImport.BlockSerial_cpomReleaseComport(Instance: TObject;
  var Params: Variant): Variant;
begin
  {$IFDEF UNIX}
    TBlockSerial(Instance).cpomReleaseComport;
  {$ENDIF}
end;

function TSynapseImport.BlockSerial_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TBlockSerial.Create);
end;

function TSynapseImport.BlockSerial_CTSRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).CTS;
end;

function TSynapseImport.BlockSerial_DCB_BaudRateRead(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).DCB.BaudRate;
end;

procedure TSynapseImport.BlockSerial_DCB_BaudRateWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).DCB.BaudRate := AValue;
end;

function TSynapseImport.BlockSerial_DCB_ByteSizeRead(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).DCB.ByteSize;
end;

procedure TSynapseImport.BlockSerial_DCB_ByteSizeWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).DCB.ByteSize := AValue;
end;

function TSynapseImport.BlockSerial_DCB_DCBlengthRead(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).DCB.DCBlength;
end;

procedure TSynapseImport.BlockSerial_DCB_DCBlengthWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).DCB.DCBlength := AValue;
end;

function TSynapseImport.BlockSerial_DCB_EofCharRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).DCB.EofChar;
end;

procedure TSynapseImport.BlockSerial_DCB_EofCharWrite(Instance: Pointer;
  AValue: Variant);
var
  S: string;
  C: Char;
begin
  S := AValue;
  C := Char('');
  if S <> '' then C := S[1];
  TBlockSerial(Instance).DCB.EofChar := C;
end;

function TSynapseImport.BlockSerial_DCB_ErrorCharRead(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).DCB.ErrorChar;
end;

procedure TSynapseImport.BlockSerial_DCB_ErrorCharWrite(Instance: Pointer;
  AValue: Variant);
var
  S: string;
  C: Char;
begin
  S := AValue;
  C := Char('');
  if S <> '' then C := S[1];
  TBlockSerial(Instance).DCB.ErrorChar := C;
end;

function TSynapseImport.BlockSerial_DCB_EvtCharRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).DCB.EvtChar;
end;

procedure TSynapseImport.BlockSerial_DCB_EvtCharWrite(Instance: Pointer;
  AValue: Variant);
var
  S: string;
  C: Char;
begin
  S := AValue;
  C := Char('');
  if S <> '' then C := S[1];
  TBlockSerial(Instance).DCB.EvtChar := C;
end;

function TSynapseImport.BlockSerial_DCB_FlagsRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).DCB.Flags;
end;

procedure TSynapseImport.BlockSerial_DCB_FlagsWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).DCB.Flags := AValue;
end;

function TSynapseImport.BlockSerial_DCB_ParityRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).DCB.Parity;
end;

procedure TSynapseImport.BlockSerial_DCB_ParityWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).DCB.Parity := AValue;
end;

function TSynapseImport.BlockSerial_DCB_StopBitsRead(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).DCB.StopBits;
end;

procedure TSynapseImport.BlockSerial_DCB_StopBitsWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).DCB.StopBits := AValue;
end;

function TSynapseImport.BlockSerial_DCB_wReserved1Read(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).DCB.wReserved1;
end;

procedure TSynapseImport.BlockSerial_DCB_wReserved1Write(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).DCB.wReserved1 := AValue;
end;

function TSynapseImport.BlockSerial_DCB_wReservedRead(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).DCB.wReserved;
end;

procedure TSynapseImport.BlockSerial_DCB_wReservedWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).DCB.wReserved := AValue;
end;

function TSynapseImport.BlockSerial_DCB_XoffCharRead(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).DCB.XoffChar;
end;

procedure TSynapseImport.BlockSerial_DCB_XoffCharWrite(Instance: Pointer;
  AValue: Variant);
var
  S: string;
  C: Char;
begin
  S := AValue;
  C := Char('');
  if S <> '' then C := S[1];
  TBlockSerial(Instance).DCB.XoffChar := C;
end;

function TSynapseImport.BlockSerial_DCB_XoffLimRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).DCB.XoffLim;
end;

procedure TSynapseImport.BlockSerial_DCB_XoffLimWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).DCB.XoffLim := AValue;
end;

function TSynapseImport.BlockSerial_DCB_XonCharRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).DCB.XonChar;
end;

procedure TSynapseImport.BlockSerial_DCB_XonCharWrite(Instance: Pointer;
  AValue: Variant);
var
  S: string;
  C: Char;
begin
  S := AValue;
  C := Char('');
  if S <> '' then C := S[1];
  TBlockSerial(Instance).DCB.XonChar := C;
end;

function TSynapseImport.BlockSerial_DCB_XonLimRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).DCB.XonLim;
end;

procedure TSynapseImport.BlockSerial_DCB_XonLimWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).DCB.XonLim := AValue;
end;

function TSynapseImport.BlockSerial_DeviceRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).Device;
end;

function TSynapseImport.BlockSerial_DSRRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).DSR;
end;

procedure TSynapseImport.BlockSerial_DTRWrite(Instance: Pointer; AValue: Variant
  );
begin
  TBlockSerial(Instance).DTR := AValue;
end;

function TSynapseImport.BlockSerial_EnableRTSToggle(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSerial(Instance).EnableRTSToggle(Params[0]);
end;

function TSynapseImport.BlockSerial_ExceptCheck(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSerial(Instance).ExceptCheck;
end;

function TSynapseImport.BlockSerial_Flush(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TBlockSerial(Instance).Flush;
end;

function TSynapseImport.BlockSerial_GetCommState(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSerial(Instance).GetCommState;
end;

function TSynapseImport.BlockSerial_GetErrorDescr(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).GetErrorDesc(Params[0]);
end;

function TSynapseImport.BlockSerial_GetVersion(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).GetVersion;
end;

function TSynapseImport.BlockSerial_InstanceActiveRead(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).InstanceActive;
end;

function TSynapseImport.BlockSerial_LastErrorDescRead(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).LastErrorDesc;
end;

function TSynapseImport.BlockSerial_LastErrorRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).LastError;
end;

procedure TSynapseImport.BlockSerial_MaxBandwidthWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).MaxBandwidth := AValue;
end;

function TSynapseImport.BlockSerial_MaxRecvBandwidthRead(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).MaxRecvBandwidth;
end;

procedure TSynapseImport.BlockSerial_MaxRecvBandwidthWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).MaxRecvBandwidth := AValue;
end;

function TSynapseImport.BlockSerial_MaxSendBandwidthRead(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).MaxSendBandwidth;
end;

procedure TSynapseImport.BlockSerial_MaxSendBandwidthWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).MaxSendBandwidth := AValue;
end;

function TSynapseImport.BlockSerial_ModemStatus(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).ModemStatus;
end;

function TSynapseImport.BlockSerial_Purge(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TBlockSerial(Instance).Purge;
end;

function TSynapseImport.BlockSerial_RaiseSynaError(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSerial(Instance).RaiseSynaError(Params[0]);
end;

function TSynapseImport.BlockSerial_RecvBlock(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).RecvBlock(Params[0]);
end;

function TSynapseImport.BlockSerial_RecvByte(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).RecvByte(Params[0]);
end;

function TSynapseImport.BlockSerial_RecvInteger(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).RecvInteger(Params[0]);
end;

function TSynapseImport.BlockSerial_RecvPacket(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).RecvPacket(Params[0]);
end;

function TSynapseImport.BlockSerial_RecvStream(Instance: TObject;
  var Params: Variant): Variant;
var
  Stream: TStream;
begin
  Stream := TStream( TSuPtr(Params[0]) );
  TBlockSerial(Instance).RecvStream(Stream, Params[1]);
end;

function TSynapseImport.BlockSerial_RecvStreamIndy(Instance: TObject;
  var Params: Variant): Variant;
var
  Stream: TStream;
begin
  Stream := TStream( TSuPtr(Params[0]) );
  TBlockSerial(Instance).RecvStreamIndy(Stream, Params[1]);
end;

function TSynapseImport.BlockSerial_RecvStreamRaw(Instance: TObject;
  var Params: Variant): Variant;
var
  Stream: TStream;
begin
  Stream := TStream( TSuPtr(Params[0]) );
  TBlockSerial(Instance).RecvStreamRaw(Stream, Params[1]);
end;

function TSynapseImport.BlockSerial_RecvStreamSize(Instance: TObject;
  var Params: Variant): Variant;
var
  Stream: TStream;
begin
  Stream := TStream( TSuPtr(Params[0]) );
  TBlockSerial(Instance).RecvStreamSize(Stream, Params[1], Params[2]);
end;

function TSynapseImport.BlockSerial_Recvstring(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).Recvstring(Params[0]);
end;

function TSynapseImport.BlockSerial_RecvTerminated(Instance: TObject;
  var Params: Variant): Variant;
var
  Term: string;
begin
  Term := Params[1];
  Result := TBlockSerial(Instance).RecvTerminated(Params[0], Term);
end;

function TSynapseImport.BlockSerial_RingRead(Instance: Pointer): Variant;
begin
  Result := TBlockSerial(Instance).Ring;
end;

procedure TSynapseImport.BlockSerial_RTSWrite(Instance: Pointer; AValue: Variant
  );
begin
  TBlockSerial(Instance).RTS := AValue;
end;

function TSynapseImport.BlockSerial_SendBlock(Instance: TObject;
  var Params: Variant): Variant;
var
  AData: string;
begin
  AData := Params[0];
  TBlockSerial(Instance).SendBlock(AData);
end;

function TSynapseImport.BlockSerial_SendByte(Instance: TObject;
  var Params: Variant): Variant;
var
  B: Byte;
begin
  B := Params[0];
  TBlockSerial(Instance).SendByte(B);
end;

function TSynapseImport.BlockSerial_SendingData(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).SendingData;
end;

function TSynapseImport.BlockSerial_SendInteger(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSerial(Instance).SendInteger(Params[0]);
end;

function TSynapseImport.BlockSerial_SendStream(Instance: TObject;
  var Params: Variant): Variant;
var
  Stream: TStream;
begin
  Stream := TStream( TSuPtr(Params[0]) );
  TBlockSerial(Instance).SendStream(Stream);
end;

function TSynapseImport.BlockSerial_SendStreamIndy(Instance: TObject;
  var Params: Variant): Variant;
var
  Stream: TStream;
begin
  Stream := TStream( TSuPtr(Params[0]) );
  TBlockSerial(Instance).SendStreamIndy(Stream);
end;

function TSynapseImport.BlockSerial_SendStreamRaw(Instance: TObject;
  var Params: Variant): Variant;
var
  Stream: TStream;
begin
  Stream := TStream( TSuPtr(Params[0]) );
  TBlockSerial(Instance).SendStreamRaw(Stream);
end;

function TSynapseImport.BlockSerial_SendString(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TBlockSerial(Instance).SendString(S);
end;

function TSynapseImport.BlockSerial_SerialCheck(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).SerialCheck(Params[0]);
end;

function TSynapseImport.BlockSerial_SetBreak(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSerial(Instance).SetBreak(Params[0]);
end;

function TSynapseImport.BlockSerial_SetCommState(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSerial(Instance).SetCommState;
end;

function TSynapseImport.BlockSerial_SetSynaError(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSerial(Instance).SetSynaError(Params[0]);
end;

function TSynapseImport.BlockSerial_SizeRecvBufferRead(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSerial(Instance).SizeRecvBuffer;
end;

procedure TSynapseImport.BlockSerial_SizeRecvBufferWrite(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSerial(Instance).SizeRecvBuffer := AValue;
end;

function TSynapseImport.BlockSerial_WaitingData(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).WaitingData;
end;

function TSynapseImport.BlockSerial_WaitingDataEx(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSerial(Instance).WaitingDataEx;
end;

function TSynapseImport.BlockSocket_AbortSocket(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).AbortSocket;
end;

function TSynapseImport.BlockSocket_Accept(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TBlockSocket(Instance).Accept);
end;

function TSynapseImport.BlockSocket_Bind(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TBlockSocket(Instance).Bind(Params[0], Params[1]);
end;

function TSynapseImport.BlockSocket_CanRead(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).CanRead(Params[0]);
end;

function TSynapseImport.BlockSocket_CanReadEx(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).CanReadEx(Params[0]);
end;

function TSynapseImport.BlockSocket_CanWrite(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).CanWrite(Params[0]);
end;

function TSynapseImport.BlockSocket_CloseSocket(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).CloseSocket;
end;

function TSynapseImport.BlockSocket_Connect(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).Connect(Params[0], Params[1]);
end;

function TSynapseImport.BlockSocket_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TBlockSocket.Create);
end;

function TSynapseImport.BlockSocket_CreateAlternate(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TBlockSocket.CreateAlternate(Params[0]));
end;

function TSynapseImport.BlockSocket_CreateSocket(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).CreateSocket;
end;

function TSynapseImport.BlockSocket_CreateSocketByName(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).CreateSocketByName(Params[0]);
end;

function TSynapseImport.BlockSocket_EnableReuse(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).EnableReuse(Params[0]);
end;

function TSynapseImport.BlockSocket_ExceptCheck(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).ExceptCheck;
end;

function TSynapseImport.BlockSocket_GetLocalSinIP(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).GetLocalSinIP;
end;

function TSynapseImport.BlockSocket_GetLocalSinPort(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).GetLocalSinPort;
end;

function TSynapseImport.BlockSocket_GetRemoteSinIP(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).GetRemoteSinIP;
end;

function TSynapseImport.BlockSocket_GetRemoteSinPort(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).GetRemoteSinPort;
end;

function TSynapseImport.BlockSocket_GetSinLocal(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).GetSinLocal;
end;

function TSynapseImport.BlockSocket_GetSinRemote(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).GetSinRemote;
end;

function TSynapseImport.BlockSocket_GetSins(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).GetSins;
end;

function TSynapseImport.BlockSocket_GetSocketProtocol(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).GetSocketProtocol;
end;

function TSynapseImport.BlockSocket_GetSocketType(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).GetSocketType;
end;

function TSynapseImport.BlockSocket_IP6usedGet(Instance: Pointer): Variant;
begin
  Result := TBlockSocket(Instance).IP6used;
end;

function TSynapseImport.BlockSocket_LastErrorDescGet(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSocket(Instance).LastErrorDesc;
end;

function TSynapseImport.BlockSocket_LastErrorGet(Instance: Pointer): Variant;
begin
  Result := TBlockSocket(Instance).LastError;
end;

function TSynapseImport.BlockSocket_LineBufferGet(Instance: Pointer): Variant;
begin
  Result := TBlockSocket(Instance).LineBuffer;
end;

procedure TSynapseImport.BlockSocket_LineBufferSet(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSocket(Instance).LineBuffer := AValue;
end;

function TSynapseImport.BlockSocket_Listen(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).Listen;
end;

function TSynapseImport.BlockSocket_LocalName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).LocalName;
end;

function TSynapseImport.BlockSocket_NonBlockModeGet(Instance: Pointer): Variant;
begin
  Result := TBlockSocket(Instance).NonBlockMode;
end;

procedure TSynapseImport.BlockSocket_NonBlockModeSet(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSocket(Instance).NonBlockMode := AValue;
end;

function TSynapseImport.BlockSocket_RecvBlock(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).RecvBlock(Params[0]);
end;

function TSynapseImport.BlockSocket_RecvByte(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).RecvByte(Params[0]);
end;

function TSynapseImport.BlockSocket_RecvCounterGet(Instance: Pointer): Variant;
begin
  Result := TBlockSocket(Instance).RecvCounter;
end;

function TSynapseImport.BlockSocket_RecvInteger(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).RecvInteger(Params[0]);
end;

function TSynapseImport.BlockSocket_RecvPacket(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).RecvPacket(Params[0]);
end;

function TSynapseImport.BlockSocket_RecvStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).RecvStream(TStream(TSuPtr(Params[0])), Params[1]);
end;

function TSynapseImport.BlockSocket_RecvStreamRaw(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).RecvStreamRaw(TStream(TSuPtr(Params[0])), Params[1]);
end;

function TSynapseImport.BlockSocket_RecvStreamSize(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).RecvStreamSize(TStream(TSuPtr(Params[0])), Params[1], Params[2]);
end;

function TSynapseImport.BlockSocket_RecvString(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).RecvString(Params[0]);
end;

function TSynapseImport.BlockSocket_RecvTerminated(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).RecvTerminated(Params[0], Params[1]);
end;

function TSynapseImport.BlockSocket_ResetLastError(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).ResetLastError;
end;

function TSynapseImport.BlockSocket_ResolveIPToName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).ResolveIPToName(Params[0]);
end;

function TSynapseImport.BlockSocket_ResolveName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).ResolveName(Params[0]);
end;

function TSynapseImport.BlockSocket_ResolveNameToIP(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).ResolveNameToIP(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TSynapseImport.BlockSocket_ResolvePort(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).ResolvePort(Params[0]);
end;

function TSynapseImport.BlockSocket_SendBlock(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).SendBlock(Params[0]);
end;

function TSynapseImport.BlockSocket_SendByte(Instance: TObject;
  var Params: Variant): Variant;
var
  B: Byte;
begin
  B := Params[0];
  TBlockSocket(Instance).SendByte(B);
end;

function TSynapseImport.BlockSocket_SendCounterGet(Instance: Pointer): Variant;
begin
  Result := TBlockSocket(Instance).SendCounter;
end;

function TSynapseImport.BlockSocket_SendInteger(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).SendInteger(Params[0]);
end;

function TSynapseImport.BlockSocket_SendStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).SendStream(TStream(TSuPtr(Params[0])));
end;

function TSynapseImport.BlockSocket_SendStreamRaw(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).SendStreamRaw(TStream(TSuPtr(Params[0])));
end;

function TSynapseImport.BlockSocket_SendString(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).SendString(Params[0]);
end;

function TSynapseImport.BlockSocket_SetLinger(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).SetLinger(Params[0], Params[1]);
end;

function TSynapseImport.BlockSocket_SetRecvTimeout(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).SetRecvTimeout(Params[0]);
end;

function TSynapseImport.BlockSocket_SetRemoteSin(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).SetRemoteSin(Params[0], Params[1]);
end;

function TSynapseImport.BlockSocket_SetSendTimeout(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).SetSendTimeout(Params[0]);
end;

function TSynapseImport.BlockSocket_SetTimeout(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).SetTimeout(Params[0]);
end;

function TSynapseImport.BlockSocket_SizeRecvBufferGet(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSocket(Instance).SizeRecvBuffer;
end;

procedure TSynapseImport.BlockSocket_SizeRecvBufferSet(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSocket(Instance).SizeRecvBuffer := AValue;
end;

function TSynapseImport.BlockSocket_SizeSendBufferGet(Instance: Pointer
  ): Variant;
begin
  Result := TBlockSocket(Instance).SizeSendBuffer;
end;

procedure TSynapseImport.BlockSocket_SizeSendBufferSet(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSocket(Instance).SizeSendBuffer:= AValue;
end;

function TSynapseImport.BlockSocket_SockCheck(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).SockCheck(Params[0]);
end;

function TSynapseImport.BlockSocket_TTLGet(Instance: Pointer): Variant;
begin
  Result := TBlockSocket(Instance).TTL;
end;

procedure TSynapseImport.BlockSocket_TTLSet(Instance: Pointer; AValue: Variant);
begin
  TBlockSocket(Instance).TTL := AValue;
end;

function TSynapseImport.BlockSocket_WaitingData(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).WaitingData;
end;

function TSynapseImport.BlockSocket_WaitingDataEx(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TBlockSocket(Instance).WaitingDataEx;
end;

function TSynapseImport.Call_HttpGetText(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := HttpGetText(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TSynapseImport.Call_HttpGetBinary(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := HttpGetBinary(Params[0], TStream(TSuPtr(Params[1])));
end;

function TSynapseImport.Call_HttpGetTextTimeout(Instance: TObject;
  var Params: Variant): Variant;
var
  HTTP: THTTPSend;
  SL: TStringList;
  URL: string;
begin
  URL := Params[0];
  SL := TStringList( TSuPtr(Params[1]) );
  HTTP := THTTPSend.Create;
  HTTP.Protocol := '1.1';
  HTTP.Timeout := Params[2];
  try
    Result := HTTP.HTTPMethod('GET', URL);
    if Result then
      SL.LoadFromStream(HTTP.Document, True);
  finally
    HTTP.Free;
  end;
end;

function TSynapseImport.Call_HttpPostBinary(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := HttpPostBinary(Params[0], TStream(TSuPtr(Params[1])));
end;

function TSynapseImport.Call_HttpPostURL(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := HttpPostURL(Params[0], Params[1], TStream(TSuPtr(Params[2])));
end;

function TSynapseImport.Call_HttpPostFile(Instance: TObject; var Params: Variant
  ): Variant;
begin
  //0 = URL
  //1 = FieldName,
  //2 = FileName: string;
  //3 = Data: TStream;
  //4 = ResultData: TStrings
  HttpPostFile(Params[0], Params[1], Params[2], TStream(TSuPtr(Params[3])), TStrings(TSuPtr(Params[4])));
end;

function TSynapseImport.Call_FtpGetFile(Instance: TObject; var Params: Variant
  ): Variant;
var
  LocalFileName: string;
begin
  LocalFileName := Params[3];
  Result := FtpGetFile(Params[0], Params[1], Params[2] , LocalFileName, Params[4], Params[5]);
end;

function TSynapseImport.Call_FtpPutFile(Instance: TObject; var Params: Variant
  ): Variant;
var
  LocalFileName: string;
begin
  LocalFileName := Params[3];
  Result := FtpPutFile(Params[0], Params[1], Params[2] , LocalFileName, Params[4], Params[5]);
end;

function TSynapseImport.Call_SendTo(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := SendTo(Params[0], Params[1], Params[2], Params[3], TStrings(TSuPtr( Params[4] )));
 // function SendTo(const MailFrom[0], MailTo[1], Subject[2], SMTPHost[3]: string; const MailData: TStrings [4]): Boolean;
end;

function TSynapseImport.Call_SendToEx(Instance: TObject; var Params: Variant
  ): Variant;
begin
   //function SendToEx(const MailFrom[0], MailTo[1], Subject[2], SMTPHost[3]: string; const MailData[4]: TStrings; const Username[5], Password[6]: string): Boolean;
  Result := SendToEx(Params[0], Params[1], Params[2], Params[3], TStrings(TSuPtr(Params[4])), Params[5], Params[6]);
end;

function TSynapseImport.Call_SendToRaw(Instance: TObject; var Params: Variant
  ): Variant;
begin
  //function SendToRaw(const MailFrom[0], MailTo[1], SMTPHost[2]: string; const MailData: TStrings[3]; const Username[4], Password: string[5]): Boolean;
  Result := SendToRaw(Params[0], Params[1], Params[2], TStrings(TSuPtr(Params[3])), Params[4], Params[5]);
end;

function TSynapseImport.Call_SendToExSSL(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := SendToExSSL(Params[0], Params[1], Params[2], Params[3], TStrings(TSuPtr(Params[4])), Params[5], Params[6]);
end;

function TSynapseImport.Call_SendToRawSSL(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := SendToRawSSL(Params[0], Params[1], Params[2], TStrings(TSuPtr(Params[3])), Params[4], Params[5]);
end;

function TSynapseImport.Call_SendMail(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := SendMail(Params[0], Params[1], TStrings(TSuPtr(Params[2])), TSMTPSend(TSuPtr(Params[3])));
end;

function TSynapseImport.Call_CharsetConversion(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := CharsetConversion(Params[0], Params[1], Params[2]);
end;

function TSynapseImport.Call_DecodeBase64(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := DecodeBase64(Params[0]);
end;

function TSynapseImport.Call_EncodeBase64(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := EncodeBase64(Params[0]);
end;

function TSynapseImport.Call_EncodeURLElement(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := EncodeURLElement(Params[0]);
end;

function TSynapseImport.Call_EncodeURL(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := EncodeURL(Params[0]);
end;

function TSynapseImport.Call_DecodeURL(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := DecodeURL(Params[0]);
end;

function TSynapseImport.Call_GetSerialPortNames(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := GetSerialPortNames;
end;

function TSynapseImport.CustomSSL_Accept(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TCustomSSL(Instance).Accept;
end;

function TSynapseImport.CustomSSL_Assign(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TCustomSSL(Instance).Assign(TCustomSSL(TSuPtr(Params[0])));
end;

function TSynapseImport.CustomSSL_BiShutdown(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).BiShutdown;
end;

function TSynapseImport.CustomSSL_Connect(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TCustomSSL(Instance).Connect;
end;

function TSynapseImport.CustomSSL_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TCustomSSL.Create(TTCPBlockSocket(TSuPtr(Params[0]))));
end;

function TSynapseImport.CustomSSL_GetCertInfo(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).GetCertInfo;
end;

function TSynapseImport.CustomSSL_GetCipherAlgBits(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).GetCipherAlgBits;
end;

function TSynapseImport.CustomSSL_GetCipherBits(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).GetCipherBits;
end;

function TSynapseImport.CustomSSL_GetCipherName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).GetCipherName;
end;

function TSynapseImport.CustomSSL_GetPeerFingerprint(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).GetPeerFingerprint;
end;

function TSynapseImport.CustomSSL_GetPeerIssuer(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).GetPeerIssuer;
end;

function TSynapseImport.CustomSSL_GetPeerName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).GetPeerName;
end;

function TSynapseImport.CustomSSL_GetPeerNameHash(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).GetPeerNameHash;
end;

function TSynapseImport.CustomSSL_GetPeerSerialNo(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).GetPeerSerialNo;
end;

function TSynapseImport.CustomSSL_GetPeerSubject(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).GetPeerSubject;
end;

function TSynapseImport.CustomSSL_GetSSLVersion(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).GetSSLVersion;
end;

function TSynapseImport.CustomSSL_GetVerifyCert(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).GetVerifyCert;
end;

function TSynapseImport.CustomSSL_LastError(Instance: Pointer): Variant;
begin
  Result := TCustomSSL(Instance).LastError;
end;

function TSynapseImport.CustomSSL_LastErrorDesc(Instance: Pointer): Variant;
begin
  Result := TCustomSSL(Instance).LastErrorDesc;
end;

function TSynapseImport.CustomSSL_LibName(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TCustomSSL(Instance).LibName;
end;

function TSynapseImport.CustomSSL_LibVersion(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).LibVersion;
end;

function TSynapseImport.CustomSSL_Shutdown(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).Shutdown;
end;

function TSynapseImport.CustomSSL_SSLEnabled(Instance: Pointer): Variant;
begin
  Result := TCustomSSL(Instance).SSLEnabled;
end;

function TSynapseImport.CustomSSL_WaitingData(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCustomSSL(Instance).WaitingData;
end;

function TSynapseImport.FTPListRec_Assign(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TFTPListRec(Instance).Assign(TFTPListRec(TSuPtr(Params[0])));
end;

function TSynapseImport.FTPListRec_DirectoryGet(Instance: Pointer): Variant;
begin
  Result := TFTPListRec(Instance).Directory;
end;

procedure TSynapseImport.FTPListRec_DirectorySet(Instance: Pointer;
  AValue: Variant);
begin
  TFTPListRec(Instance).Directory := AValue;
end;

function TSynapseImport.FTPListRec_FileNameGet(Instance: Pointer): Variant;
begin
  Result := TFTPListRec(Instance).FileName;
end;

procedure TSynapseImport.FTPListRec_FileNameSet(Instance: Pointer;
  AValue: Variant);
begin
  TFTPListRec(Instance).FileName := AValue;
end;

function TSynapseImport.FTPListRec_FileSizeGet(Instance: Pointer): Variant;
begin
  Result := TFTPListRec(Instance).FileSize;
end;

procedure TSynapseImport.FTPListRec_FileSizeSet(Instance: Pointer;
  AValue: Variant);
begin
  TFTPListRec(Instance).FileSize := AValue;
end;

function TSynapseImport.FTPListRec_FileTimeGet(Instance: Pointer): Variant;
begin
  Result := TFTPListRec(Instance).FileTime;
end;

procedure TSynapseImport.FTPListRec_FileTimeSet(Instance: Pointer;
  AValue: Variant);
begin
  TFTPListRec(Instance).FileTime := AValue;
end;

function TSynapseImport.FTPListRec_MaskGet(Instance: Pointer): Variant;
begin
  Result := TFTPListRec(Instance).Mask;
end;

procedure TSynapseImport.FTPListRec_MaskSet(Instance: Pointer; AValue: Variant);
begin
  TFTPListRec(Instance).Mask := AValue;
end;

function TSynapseImport.FTPListRec_OriginalLineGet(Instance: Pointer): Variant;
begin
  Result := TFTPListRec(Instance).OriginalLine;
end;

procedure TSynapseImport.FTPListRec_OriginalLineSet(Instance: Pointer;
  AValue: Variant);
begin
  TFTPListRec(Instance).OriginalLine := AValue;
end;

function TSynapseImport.FTPListRec_PermissionGet(Instance: Pointer): Variant;
begin
  Result := TFTPListRec(Instance).Permission;
end;

procedure TSynapseImport.FTPListRec_PermissionSet(Instance: Pointer;
  AValue: Variant);
begin
  TFTPListRec(Instance).Permission := AValue;
end;

function TSynapseImport.FTPListRec_ReadableGet(Instance: Pointer): Variant;
begin
  Result := TFTPListRec(Instance).Readable;
end;

procedure TSynapseImport.FTPListRec_ReadableSet(Instance: Pointer;
  AValue: Variant);
begin
  TFTPListRec(Instance).Readable := AValue;
end;

function TSynapseImport.FTPList_Assign(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TFTPList(Instance).Assign(TFTPList(TSuPtr(Params[0])));
end;

function TSynapseImport.FTPList_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TFTPList(Instance).Clear;
end;

function TSynapseImport.FTPList_Count(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TFTPList(Instance).Count;
end;

function TSynapseImport.FTPList_ItemsGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TFTPList(Instance).Items[Params[0]]);
end;

function TSynapseImport.FTPList_Lines(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TFTPList(Instance).Lines);
end;

function TSynapseImport.FTPList_List(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TFTPList(Instance).List);
end;

function TSynapseImport.FTPList_Masks(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TFTPList(Instance).Masks);
end;

function TSynapseImport.FTPList_ParseLines(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFTPList(Instance).ParseLines;
end;

function TSynapseImport.FTPList_UnparsedLines(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TFTPList(Instance).UnparsedLines);
end;

function TSynapseImport.FTPSend_Abort(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TFTPSend(Instance).Abort;
end;

function TSynapseImport.FTPSend_AppendFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFTPSend(Instance).AppendFile(Params[0]);
end;

function TSynapseImport.FTPSend_ChangeToParentDir(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFTPSend(Instance).ChangeToParentDir;
end;

function TSynapseImport.FTPSend_ChangeToRootDir(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFTPSend(Instance).ChangeToRootDir;
end;

function TSynapseImport.FTPSend_ChangeWorkingDir(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFTPSend(Instance).ChangeWorkingDir(Params[0]);
end;

function TSynapseImport.FTPSend_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TFTPSend.Create);
end;

function TSynapseImport.FTPSend_CreateDir(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TFTPSend(Instance).CreateDir(Params[0]);
end;

function TSynapseImport.FTPSend_DataRead(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TFTPSend(Instance).DataRead(TStream(TSuPtr(Params[0])));
end;

function TSynapseImport.FTPSend_DataWrite(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TFTPSend(Instance).DataWrite(TStream(TSuPtr(Params[0])));
end;

function TSynapseImport.FTPSend_DeleteDir(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TFTPSend(Instance).DeleteDir(Params[0]);
end;

function TSynapseImport.FTPSend_DeleteFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFTPSend(Instance).DeleteFile(Params[0]);
end;

function TSynapseImport.FTPSend_FileSize(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TFTPSend(Instance).FileSize(Params[0]);
end;

function TSynapseImport.FTPSend_FTPCommand(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFTPSend(Instance).FTPCommand(Params[0]);
end;

function TSynapseImport.FTPSend_GetCurrentDir(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFTPSend(Instance).GetCurrentDir;
end;

function TSynapseImport.FTPSend_List(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TFTPSend(Instance).List(Params[0], Params[1]);
end;

function TSynapseImport.FTPSend_Login(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TFTPSend(Instance).Login;
end;

function TSynapseImport.FTPSend_Logout(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TFTPSend(Instance).Logout;
end;

function TSynapseImport.FTPSend_NoOp(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TFTPSend(Instance).NoOp;
end;

function TSynapseImport.FTPSend_ParseRemote(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFTPSend(Instance).ParseRemote(Params[0]);
end;

function TSynapseImport.FTPSend_ParseRemoteEPSV(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFTPSend(Instance).ParseRemoteEPSV(Params[0]);
end;

function TSynapseImport.FTPSend_ReadResult(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFTPSend(Instance).ReadResult;
end;

function TSynapseImport.FTPSend_RenameFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFTPSend(Instance).RenameFile(Params[0], Params[1]);
end;

function TSynapseImport.FTPSend_RetrieveFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFTPSend(Instance).RetrieveFile(Params[0], Params[1]);
end;

function TSynapseImport.FTPSend_StoreFile(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TFTPSend(Instance).StoreFile(Params[0], Params[1]);
end;

function TSynapseImport.FTPSend_StoreUniqueFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TFTPSend(Instance).StoreUniqueFile;
end;

function TSynapseImport.FTPSend_TelnetAbort(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFTPSend(Instance).TelnetAbort;
end;

function TSynapseImport.HTTPSend_Abort(Instance: TObject; var Params: Variant
  ): Variant;
begin
  THTTPSend(Instance).Abort;
end;

function TSynapseImport.HTTPSend_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  THTTPSend(Instance).Clear;
end;

function TSynapseImport.HTTPSend_Create(Instance: TObject; var Params: Variant
  ): Variant;
var
  HTTP: THTTPSend;
begin
  HTTP := THTTPSend.Create;
  HTTP.Protocol:= '1.1';
  Result := TSuPtr(HTTP);
end;

function TSynapseImport.HTTPSend_DecodeStatus(Instance: TObject;
  var Params: Variant): Variant;
begin
  THTTPSend(Instance).DecodeStatus(Params[0]);
end;

function TSynapseImport.HTTPSend_HTTPMethod(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := THTTPSend(Instance).HTTPMethod(Params[0], Params[1]);
end;

function TSynapseImport.IMAPSend_AddFlagsMess(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).AddFlagsMess(Params[0], Params[1]);
end;

function TSynapseImport.IMAPSend_AppendMess(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).AppendMess(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TSynapseImport.IMAPSend_Capability(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).Capability;
end;

function TSynapseImport.IMAPSend_CheckFolder(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).CheckFolder;
end;

function TSynapseImport.IMAPSend_CloseFolder(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).CloseFolder;
end;

function TSynapseImport.IMAPSend_CopyMess(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TIMAPSend(Instance).CopyMess(Params[0], Params[1]);
end;

function TSynapseImport.IMAPSend_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TIMAPSend.Create );
end;

function TSynapseImport.IMAPSend_CreateFolder(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).CreateFolder(Params[0]);
end;

function TSynapseImport.IMAPSend_DeleteFolder(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).DeleteFolder(Params[0]);
end;

function TSynapseImport.IMAPSend_DeleteMess(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).DeleteMess(Params[0]);
end;

function TSynapseImport.IMAPSend_DelFlagsMess(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).DelFlagsMess(Params[0], Params[1]);
end;

function TSynapseImport.IMAPSend_ExpungeFolder(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).ExpungeFolder;
end;

function TSynapseImport.IMAPSend_FetchHeader(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).FetchHeader(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TSynapseImport.IMAPSend_FetchMess(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).FetchMess(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TSynapseImport.IMAPSend_FindCap(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TIMAPSend(Instance).FindCap(Params[0]);
end;

function TSynapseImport.IMAPSend_GetFlagsMess(Instance: TObject;
  var Params: Variant): Variant;
var
  Flags: string;
begin
  Flags:= Params[1];
  Result := TIMAPSend(Instance).GetFlagsMess(Params[0], Flags);
  Params[1] := Flags;
end;

function TSynapseImport.IMAPSend_GetUID(Instance: TObject; var Params: Variant
  ): Variant;
var
  UID: Integer;
begin
  UID := Params[1];
  Result := TIMAPSend(Instance).GetUID(Params[0], UID);
  Params[1] := UID;
end;

function TSynapseImport.IMAPSend_IMAPcommand(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).IMAPcommand(Params[0]);
end;

function TSynapseImport.IMAPSend_IMAPuploadCommand(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).IMAPuploadCommand(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TSynapseImport.IMAPSend_List(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TIMAPSend(Instance).List(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TSynapseImport.IMAPSend_ListSearch(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).ListSearch(Params[0], Params[1], TStrings(TSuPtr(Params[2])));
end;

function TSynapseImport.IMAPSend_ListSearchSubscribed(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).ListSearchSubscribed(Params[0], Params[1], TStrings(TSuPtr(Params[2])));
end;

function TSynapseImport.IMAPSend_ListSubscribed(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).ListSubscribed(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TSynapseImport.IMAPSend_Login(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TIMAPSend(Instance).Login;
end;

function TSynapseImport.IMAPSend_Logout(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TIMAPSend(Instance).Logout;
end;

function TSynapseImport.IMAPSend_MessageSize(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).MessageSize(Params[0]);
end;

function TSynapseImport.IMAPSend_NoOp(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TIMAPSend(Instance).NoOp;
end;

function TSynapseImport.IMAPSend_RenameFolder(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).RenameFolder(Params[0], Params[1]);
end;

function TSynapseImport.IMAPSend_SearchMess(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).SearchMess(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TSynapseImport.IMAPSend_SelectFolder(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).SelectFolder(Params[0]);
end;

function TSynapseImport.IMAPSend_SelectROFolder(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).SelectROFolder(Params[0]);
end;

function TSynapseImport.IMAPSend_SetFlagsMess(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).SetFlagsMess(Params[0], Params[1]);
end;

function TSynapseImport.IMAPSend_StartTLS(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TIMAPSend(Instance).StartTLS;
end;

function TSynapseImport.IMAPSend_StatusFolder(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).StatusFolder(Params[0], Params[1]);
end;

function TSynapseImport.IMAPSend_SubscribeFolder(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).SubscribeFolder(Params[0]);
end;

function TSynapseImport.IMAPSend_UnsubscribeFolder(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIMAPSend(Instance).UnsubscribeFolder(Params[0]);
end;

function TSynapseImport.MessHeader_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TMessHeader(Instance).Clear;
end;

function TSynapseImport.MessHeader_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TMessHeader.Create);
end;

function TSynapseImport.MessHeader_DecodeHeaders(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMessHeader(Instance).DecodeHeaders(TStrings(TSuPtr(Params[0])));
end;

function TSynapseImport.MessHeader_EncodeHeaders(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMessHeader(Instance).EncodeHeaders(TStrings(TSuPtr(Params[0])));
end;

function TSynapseImport.MessHeader_FindHeader(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TMessHeader(Instance).FindHeader(Params[0]);
end;

function TSynapseImport.MessHeader_FindHeaderList(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMessHeader(Instance).FindHeaderList(Params[0], TStrings(TSuPtr(Params[0])));
end;

function TSynapseImport.MimeMess_AddPart(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TMimeMess(Instance).AddPart(TMimePart(TSuPtr(Params[0]))));
end;

function TSynapseImport.MimeMess_AddPartBinary(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TMimeMess(Instance).AddPartBinary(TStream(TSuPtr(Params[0])), Params[1], TMimePart(TSuPtr(Params[2]))) );
end;

function TSynapseImport.MimeMess_AddPartBinaryFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TMimeMess(Instance).AddPartBinaryFromFile(Params[0], TMimePart(TSuPtr(Params[1]))) );
end;

function TSynapseImport.MimeMess_AddPartHTML(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TMimeMess(Instance).AddPartHTML(TStrings(TSuPtr(Params[0])), TMimePart(TSuPtr(Params[1]))) );
end;

function TSynapseImport.MimeMess_AddPartHTMLBinary(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TMimeMess(Instance).AddPartHTMLBinary(TStream(TSuPtr(Params[0])), Params[1], Params[2], TMimePart(TSuPtr(Params[3]))) );
end;

function TSynapseImport.MimeMess_AddPartHTMLBinaryFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TMimeMess(Instance).AddPartHTMLFromFile(Params[0], TMimePart(TSuPtr(Params[1]))) );
end;

function TSynapseImport.MimeMess_AddPartHTMLFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TMimeMess(Instance).AddPartHTMLFromFile(Params[0], TMimePart(TSuPtr(Params[1]))) );
end;

function TSynapseImport.MimeMess_AddPartMess(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TMimeMess(Instance).AddPartMess(TStrings(TSuPtr(Params[0])), TMimePart(TSuPtr(Params[1]))) );
end;

function TSynapseImport.MimeMess_AddPartMessFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TMimeMess(Instance).AddPartMessFromFile(Params[0], TMimePart(TSuPtr(Params[1]))) );
end;

function TSynapseImport.MimeMess_AddPartMultipart(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TMimeMess(Instance).AddPartMultipart(Params[0], TMimePart(TSuPtr(Params[1]))));
end;

function TSynapseImport.MimeMess_AddPartText(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TMimeMess(Instance).AddPartText(TStrings(TSuPtr(Params[0])), TMimePart(TSuPtr(Params[1]))) );
end;

function TSynapseImport.MimeMess_AddPartTextEx(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TMimeMess(Instance).AddPartTextEx(TStrings(TSuPtr(Params[0])), TMimePart(TSuPtr(Params[1])), Params[2], Params[3], Params[4]) );
end;

function TSynapseImport.MimeMess_AddPartTextFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TMimeMess(Instance).AddPartTextFromFile(Params[0], TMimePart(TSuPtr(Params[1]))) );
end;

function TSynapseImport.MimeMess_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TMimeMess(Instance).Clear;
end;

function TSynapseImport.MimeMess_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TMimeMess.Create );
end;

function TSynapseImport.MimeMess_DecodeMessage(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimeMess(Instance).DecodeMessage;
end;

function TSynapseImport.MimeMess_DecodeMessageBinary(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimeMess(Instance).DecodeMessageBinary(TStrings(TSuPtr(Params[0])), TMemoryStream(TSuPtr(Params[1])));
end;

function TSynapseImport.MimeMess_EncodeMessage(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimeMess(Instance).EncodeMessage;
end;

function TSynapseImport.MimePart_AddSubPart(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TMimePart(Instance).AddSubPart );
end;

function TSynapseImport.MimePart_Assign(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TMimePart(Instance).Assign(TMimePart(TSuPtr(Params[0])));
end;

function TSynapseImport.MimePart_AssignSubParts(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimePart(Instance).AssignSubParts(TMimePart(TSuPtr(Params[0])));
end;

function TSynapseImport.MimePart_CanSubPart(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TMimePart(Instance).CanSubPart;
end;

function TSynapseImport.MimePart_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TMimePart(Instance).Clear;
end;

function TSynapseImport.MimePart_ClearSubParts(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimePart(Instance).ClearSubParts;
end;

function TSynapseImport.MimePart_ComposeParts(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimePart(Instance).ComposeParts;
end;

function TSynapseImport.MimePart_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TMimePart.Create );
end;

function TSynapseImport.MimePart_DecodePart(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimePart(Instance).DecodePart;
end;

function TSynapseImport.MimePart_DecodePartHeader(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimePart(Instance).DecodePartHeader;
end;

function TSynapseImport.MimePart_DecomposeParts(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimePart(Instance).DecomposeParts;
end;

function TSynapseImport.MimePart_DecomposePartsBinary(Instance: TObject;
  var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[1];
  S2 := Params[2];
  TMimePart(Instance).DecomposePartsBinary(TStrings(TSuPtr(Params[0])), PAnsiChar(S1), PAnsiChar(s2));
end;

function TSynapseImport.MimePart_DeleteSubPart(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimePart(Instance).DeleteSubPart(Params[0]);
end;

function TSynapseImport.MimePart_EncodePart(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimePart(Instance).EncodePart;
end;

function TSynapseImport.MimePart_EncodePartHeader(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimePart(Instance).EncodePartHeader;
end;

function TSynapseImport.MimePart_GetSubPart(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TMimePart(Instance).GetSubPart(Params[0]));
end;

function TSynapseImport.MimePart_GetSubPartCount(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TMimePart(Instance).GetSubPartCount;
end;

function TSynapseImport.MimePart_MimeTypeFromExt(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMimePart(Instance).MimeTypeFromExt(Params[0]);
end;

function TSynapseImport.MimePart_WalkPart(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TMimePart(Instance).WalkPart;
end;

function TSynapseImport.Pop3Send_Capability(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TPOP3Send(Instance).Capability;
end;

function TSynapseImport.Pop3Send_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TPOP3Send.Create);
end;

function TSynapseImport.Pop3Send_CustomCommand(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TPOP3Send(Instance).CustomCommand(Params[0], Params[1]);
end;

function TSynapseImport.Pop3Send_Dele(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TPOP3Send(Instance).Dele(Params[0]);
end;

function TSynapseImport.Pop3Send_FindCap(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TPOP3Send(Instance).FindCap(Params[0]);
end;

function TSynapseImport.Pop3Send_List(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TPOP3Send(Instance).List(Params[0]);
end;

function TSynapseImport.Pop3Send_Login(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TPOP3Send(Instance).Login;
end;

function TSynapseImport.Pop3Send_Logout(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TPOP3Send(Instance).Logout;
end;

function TSynapseImport.Pop3Send_NoOp(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TPOP3Send(Instance).NoOp;
end;

function TSynapseImport.Pop3Send_Reset(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TPOP3Send(Instance).Reset;
end;

function TSynapseImport.Pop3Send_Retr(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TPOP3Send(Instance).Retr(Params[0]);
end;

function TSynapseImport.Pop3Send_RetrStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TPOP3Send(Instance).RetrStream(Params[0], TStream(TSuPtr(Params[0])));
end;

function TSynapseImport.Pop3Send_StartTLS(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TPOP3Send(Instance).StartTLS;
end;

function TSynapseImport.Pop3Send_Stat(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TPOP3Send(Instance).Stat;
end;

function TSynapseImport.Pop3Send_Top(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TPOP3Send(Instance).Top(Params[0], Params[1]);
end;

function TSynapseImport.Pop3Send_Uidl(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TPOP3Send(Instance).Uidl(Params[0]);
end;

function TSynapseImport.SMTPSend_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TSMTPSend.Create );
end;

function TSynapseImport.SMTPSend_EnhCodeString(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSMTPSend(Instance).EnhCodeString;
end;

function TSynapseImport.SMTPSend_Etrn(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSMTPSend(Instance).Etrn(Params[0]);
end;

function TSynapseImport.SMTPSend_FindCap(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSMTPSend(Instance).FindCap(Params[0]);
end;

function TSynapseImport.SMTPSend_Login(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSMTPSend(Instance).Login;
end;

function TSynapseImport.SMTPSend_Logout(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSMTPSend(Instance).Logout;
end;

function TSynapseImport.SMTPSend_MailData(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSMTPSend(Instance).MailData(TStrings(TSuPtr(Params[0])));
end;

function TSynapseImport.SMTPSend_MailFrom(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSMTPSend(Instance).MailFrom(Params[0], Params[1]);
end;

function TSynapseImport.SMTPSend_MailTo(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSMTPSend(Instance).MailTo(Params[0]);
end;

function TSynapseImport.SMTPSend_NoOp(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSMTPSend(Instance).NoOp;
end;

function TSynapseImport.SMTPSend_Reset(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSMTPSend(Instance).Reset;
end;

function TSynapseImport.SMTPSend_StartTLS(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSMTPSend(Instance).StartTLS;
end;

function TSynapseImport.SMTPSend_Verify(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSMTPSend(Instance).Verify(Params[0]);
end;

function TSynapseImport.SocksBlockSocket_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TSocksBlockSocket.Create);
end;

function TSynapseImport.SocksBlockSocket_SocksLastErrorGet(Instance: Pointer
  ): Variant;
begin
  Result := TSocksBlockSocket(Instance).SocksLastError;
end;

function TSynapseImport.SocksBlockSocket_SocksOpen(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSocksBlockSocket(Instance).SocksOpen;
end;

function TSynapseImport.SocksBlockSocket_SocksRequest(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSocksBlockSocket(Instance).SocksRequest(Params[0], Params[1], Params[2]);
end;

function TSynapseImport.SocksBlockSocket_SocksResponse(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSocksBlockSocket(Instance).SocksResponse;
end;

function TSynapseImport.SocksBlockSocket_UsingSocksGet(Instance: Pointer
  ): Variant;
begin
  Result := TSocksBlockSocket(Instance).UsingSocks;
end;

function TSynapseImport.SynaOption_EnabledGet(Instance: Pointer): Variant;
begin
  Result := TSynaOption(Instance).Enabled;
end;

procedure TSynapseImport.SynaOption_EnabledSet(Instance: Pointer;
  AValue: Variant);
begin
  TSynaOption(Instance).Enabled := AValue;
end;

function TSynapseImport.SynaOption_OptionGet(Instance: Pointer): Variant;
begin
  Result := TSynaOption(Instance).Option;
end;

procedure TSynapseImport.SynaOption_OptionSet(Instance: Pointer; AValue: Variant
  );
begin
  TSynaOption(Instance).Option := AValue;
end;

function TSynapseImport.SynaOption_ValueGet(Instance: Pointer): Variant;
begin
  Result := TSynaOption(Instance).Value;
end;

procedure TSynapseImport.SynaOption_ValueSet(Instance: Pointer; AValue: Variant
  );
begin
  TSynaOption(Instance).Value := AValue;
end;

function TSynapseImport.TCPBlockSocket_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TTCPBlockSocket.Create);
end;

function TSynapseImport.TCPBlockSocket_HTTPTunnel(Instance: Pointer): Variant;
begin
  Result := TTCPBlockSocket(Instance).HTTPTunnel;
end;

function TSynapseImport.TCPBlockSocket_SSL(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TTCPBlockSocket(Instance).SSL);
end;

function TSynapseImport.TCPBlockSocket_SSLAcceptConnection(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TTCPBlockSocket(Instance).SSLAcceptConnection;
end;

function TSynapseImport.TCPBlockSocket_SSLDoConnect(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTCPBlockSocket(Instance).SSLDoConnect;
end;

function TSynapseImport.TCPBlockSocket_SSLDoShutdown(Instance: TObject;
  var Params: Variant): Variant;
begin
  TTCPBlockSocket(Instance).SSLDoShutdown;
end;

function TSynapseImport.UDPBlockSocket_AddMulticast(Instance: TObject;
  var Params: Variant): Variant;
begin
  TUDPBlockSocket(Instance).AddMulticast(Params[0]);
end;

function TSynapseImport.UDPBlockSocket_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TUDPBlockSocket.Create);
end;

function TSynapseImport.UDPBlockSocket_DropMulticast(Instance: TObject;
  var Params: Variant): Variant;
begin
  TUDPBlockSocket(Instance).DropMulticast(Params[0]);
end;

function TSynapseImport.UDPBlockSocket_EnableBroadcast(Instance: TObject;
  var Params: Variant): Variant;
begin
  TUDPBlockSocket(Instance).EnableBroadcast(Params[0]);

end;

function TSynapseImport.UDPBlockSocket_EnableMulticastLoop(Instance: TObject;
  var Params: Variant): Variant;
begin
  TUDPBlockSocket(Instance).EnableMulticastLoop(Params[0]);
end;

function TSynapseImport.UDPBlockSocket_MulticastTTLGet(Instance: Pointer
  ): Variant;
begin
  Result := TUDPBlockSocket(Instance).MulticastTTL;
end;

procedure TSynapseImport.UDPBlockSocket_MulticastTTLSet(Instance: Pointer;
  AValue: Variant);
begin
  TUDPBlockSocket(Instance).MulticastTTL := AValue;
end;

function TSynapseImport.BlockSocket_RecvStreamIndy(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).RecvStreamIndy(TStream(TSuPtr(Params[0])), Params[1]);
end;

function TSynapseImport.BlockSocket_SendStreamIndy(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlockSocket(Instance).SendStreamIndy(TStream( TSuPtr( Params[0]) ));
end;

function TSynapseImport.BlockSocket_SocketGet(Instance: Pointer): Variant;
begin
  Result := TBlockSocket(Instance).Socket;
end;

procedure TSynapseImport.BlockSocket_SocketSet(Instance: Pointer;
  AValue: Variant);
begin
  TBlockSocket(Instance).Socket := AValue;
end;

function TSynapseImport.Call_GetDllSSLName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := DLLSSLName;
end;

function TSynapseImport.Call_GetSSLFileName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := SSLLibFile;
end;

function TSynapseImport.HTTPSend_PostFile(Instance: TObject; var Params: Variant
  ): Variant;
var
  URL, FileName, ContentType, S: string;
  EndBinaryStr: string;
  Stream: TStream;
  SS: TStringStream;
  HTTP: THTTPSend;
begin
  URL := Params[0];
  FileName:= Params[1];
  ContentType := Params[2];
  Stream := TStream(TSuPtr(Params[3]));
  HTTP := THTTPSend(Instance);
  EndBinaryStr:= 'END_OF_BINARY_DATA';
  HTTP.MimeType := 'multipart/form-data; boundary=' + EndBinaryStr;
  S := '--' + EndBinaryStr + CRLF + 'Content-Disposition: form-data; name="file"; filename="'+ FileName +'"' +
    CRLF + 'Content-Type: ' + ContentType + CRLF + CRLF;
  SS := TStringStream.Create(S);
  try
    SS.Seek(0, soBeginning);
    HTTP.Document.CopyFrom(SS, SS.Size);
    Stream.Seek(0, soBeginning);
    HTTP.Document.CopyFrom(Stream, Stream.Size);
  finally
    SS.Free;
  end;

  S := CRLF + '--' + EndBinaryStr + '--' + CRLF;
  SS := TStringStream.Create(S);
  try
    SS.Seek(0, soBeginning);
    HTTP.Document.CopyFrom(SS, SS.Size);
  finally
    SS.Free;
  end;
  Result := HTTP.HTTPMethod('POST', URL);
  HTTP.Document.Seek(0, soBeginning);
  //Stream.CopyFrom(HTTP.Document, HTTP.Document.Size);
end;

function TSynapseImport.SimpleTCPThread_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TSimpleTCPThread.Create( Params[0] ) );
end;

function TSynapseImport.TCPSockServer_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TTCPSockServer.Create( Params[0] ) );
end;

function TSynapseImport.TCPSockServer_Socket(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TTCPSockServer(Instance).Socket );
end;

function TSynapseImport.TCPSockServer_ThreadList(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TTCPSockServer(Instance).FThreadList );
end;

function TSynapseImport.TCPThread_Socket(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TTCPThread(Instance).FSocket);
end;

procedure TSynapseImport.AddTypes(AddType: TAddTypeProc);
begin
  {blcksock}
  AddType(TypeInfo(THookSocketReason));
  AddType(TypeInfo(TSocketFamily));
  AddType(TypeInfo(TSocksType));
  AddType(TypeInfo(TSSLType));
  AddType(TypeInfo(TSynaOptionType));
  {httpsend}
  AddType(TypeInfo(TTransferEncoding));
  {Pop3Send}
  AddType(TypeInfo(TPOP3AuthType));
  {mimemess}
  AddType(TypeInfo(TMessPriority));
  {synachar}
  AddType(TypeInfo(TMimeChar));
  {mimepart}
  AddType(TypeInfo(TMimeEncoding));
  AddType(TypeInfo(TMimePrimary));
  {synaser}
  AddType(TypeInfo(THookSerialReason));
  { AddType(TypeInfo());}
end;

procedure TSynapseImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  {blcksock}
  AddClass(TSynaOption).ClassImporter := Self;
  AddClass(TBlockSocket).ClassImporter := Self;
  AddClass(TSocksBlockSocket).ClassImporter := Self;
  AddClass(TTCPBlockSocket).ClassImporter := Self;
  AddClass(TDgramBlockSocket);
  AddClass(TUDPBlockSocket).ClassImporter := Self;
  AddClass(TICMPBlockSocket);
  AddClass(TRAWBlockSocket);
  AddClass(TPGMMessageBlockSocket);
  AddClass(TPGMStreamBlockSocket);
  AddClass(TCustomSSL).ClassImporter := Self;
  AddClass(TSSLNone);
  AddClass(TSynaClient).ClassImporter := Self;

  {httpsend}
  AddClass(THTTPSend).ClassImporter := Self;

  {ftpsend}
  AddClass(TFTPListRec).ClassImporter := Self;
  AddClass(TFTPList).ClassImporter := Self;
  AddClass(TFTPSend).ClassImporter := Self;

  {Pop3Send}
  AddClass(TPOP3Send).ClassImporter := Self;

  {mimemess}
  AddClass(TMessHeader).ClassImporter := Self;
  AddClass(TMimeMess).ClassImporter := Self;

  {mimepart}
  AddClass(TMimePart).ClassImporter := Self;

  {smtpsend}
  AddClass(TSMTPSend).ClassImporter := Self;

  {imapsend}
  AddClass(TIMAPSend).ClassImporter := Self;

  {synaser}
  AddClass(TBlockSerial).ClassImporter := Self;

  AddClass(TTCPSockServer).ClassImporter := Self;
  AddClass(TTCPThread).ClassImporter := Self;

  AddClass(TSimpleTCPThread).ClassImporter := Self;

  {
  AddClass().ClassImporter := Self;}
end;

procedure TSynapseImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TSynaOption then
  begin
    AType.AddProp('Option', 'TSynaOptionType', @SynaOption_OptionGet, @SynaOption_OptionSet);
    AType.AddProp('Enabled', 'Boolean', @SynaOption_EnabledGet, @SynaOption_EnabledSet);
    AType.AddProp('Value', 'Integer', @SynaOption_ValueGet, @SynaOption_ValueSet);
  end
  else
  if AType.ValueClassType = TBlockSocket then
  begin
    AType.AddMethod('constructor Create', @BlockSocket_Create);
    AType.AddMethod('constructor CreateAlternate(Stub: string)', @BlockSocket_CreateAlternate);
    AType.AddMethod('procedure CreateSocket', @BlockSocket_CreateSocket);
    AType.AddMethod('procedure CreateSocketByName(const Value: String)', @BlockSocket_CreateSocketByName);
    AType.AddMethod('procedure CloseSocket', @BlockSocket_CloseSocket);
    AType.AddMethod('procedure AbortSocket', @BlockSocket_AbortSocket);
    AType.AddMethod('procedure Bind(IP, Port: string)', @BlockSocket_Bind);
    AType.AddMethod('procedure Connect(IP, Port: string)', @BlockSocket_Connect);
    AType.AddMethod('procedure Listen', @BlockSocket_Listen);
    AType.AddMethod('function Accept: Pointer', @BlockSocket_Accept);
    AType.AddMethod('procedure SetLinger(Enable: Boolean; Linger: Integer)', @BlockSocket_SetLinger);
    AType.AddMethod('procedure GetSinLocal', @BlockSocket_GetSinLocal);
    AType.AddMethod('procedure GetSinRemote', @BlockSocket_GetSinRemote);
    AType.AddMethod('procedure GetSins', @BlockSocket_GetSins);
    AType.AddMethod('procedure ResetLastError', @BlockSocket_ResetLastError);
    AType.AddMethod('function SockCheck(SockResult: Integer): Integer', @BlockSocket_SockCheck);
    AType.AddMethod('procedure ExceptCheck', @BlockSocket_ExceptCheck);
    AType.AddMethod('function LocalName: string', @BlockSocket_LocalName);
    AType.AddMethod('procedure ResolveNameToIP(Name: string; const IPList: TStrings)', @BlockSocket_ResolveNameToIP);
    AType.AddMethod('function ResolveName(Name: string): string', @BlockSocket_ResolveName);
    AType.AddMethod('function ResolveIPToName(IP: string): string', @BlockSocket_ResolveIPToName);
    AType.AddMethod('function ResolvePort(Port: string): Word', @BlockSocket_ResolvePort);
    AType.AddMethod('procedure SetRemoteSin(IP, Port: string)', @BlockSocket_SetRemoteSin);
    AType.AddMethod('function GetLocalSinIP: string; virtual', @BlockSocket_GetLocalSinIP);
    AType.AddMethod('function GetRemoteSinIP: string', @BlockSocket_GetRemoteSinIP);
    AType.AddMethod('function GetLocalSinPort: Integer', @BlockSocket_GetLocalSinPort);
    AType.AddMethod('function GetRemoteSinPort: Integer', @BlockSocket_GetRemoteSinPort);
    AType.AddMethod('function CanRead(Timeout: Integer): Boolean', @BlockSocket_CanRead);
    AType.AddMethod('function CanReadEx(Timeout: Integer): Boolean', @BlockSocket_CanReadEx);
    AType.AddMethod('function CanWrite(Timeout: Integer): Boolean', @BlockSocket_CanWrite);
    AType.AddMethod('procedure EnableReuse(Value: Boolean)', @BlockSocket_EnableReuse);
    AType.AddMethod('procedure SetTimeout(Timeout: Integer)', @BlockSocket_SetTimeout);
    AType.AddMethod('procedure SetSendTimeout(Timeout: Integer)', @BlockSocket_SetSendTimeout);
    AType.AddMethod('procedure SetRecvTimeout(Timeout: Integer)', @BlockSocket_SetRecvTimeout);
    AType.AddMethod('function GetSocketType: integer', @BlockSocket_GetSocketType);
    AType.AddMethod('function GetSocketProtocol: integer', @BlockSocket_GetSocketProtocol);

    AType.AddMethod('function RecvByte(Timeout: Integer): Byte', @BlockSocket_RecvByte);
    AType.AddMethod('function RecvInteger(Timeout: Integer): Integer', @BlockSocket_RecvInteger);
    AType.AddMethod('function RecvString(Timeout: Integer): AnsiString', @BlockSocket_RecvString);
    AType.AddMethod('function RecvTerminated(Timeout: Integer; const Terminator: AnsiString): AnsiString', @BlockSocket_RecvTerminated);
    AType.AddMethod('function RecvPacket(Timeout: Integer): AnsiString', @BlockSocket_RecvPacket);
    AType.AddMethod('function RecvBlock(Timeout: Integer): AnsiString', @BlockSocket_RecvBlock);
    AType.AddMethod('procedure RecvStreamRaw(const Stream: TStream; Timeout: Integer)', @BlockSocket_RecvStreamRaw);
    AType.AddMethod('procedure RecvStreamSize(const Stream: TStream; Timeout: Integer; Size: Integer)', @BlockSocket_RecvStreamSize);
    AType.AddMethod('procedure RecvStream(const Stream: TStream; Timeout: Integer)', @BlockSocket_RecvStream);
    AType.AddMethod('procedure RecvStreamIndy(const Stream: TStream; Timeout: Integer)', @BlockSocket_RecvStreamIndy);

    AType.AddMethod('function WaitingData: Integer', @BlockSocket_WaitingData);
    AType.AddMethod('function WaitingDataEx: Integer', @BlockSocket_WaitingDataEx);

    AType.AddMethod('procedure SendString(Data: AnsiString)', @BlockSocket_SendString);
    AType.AddMethod('procedure SendByte(Data: Byte)', @BlockSocket_SendByte);
    AType.AddMethod('procedure SendInteger(Data: integer)', @BlockSocket_SendInteger);
    AType.AddMethod('procedure SendBlock(const Data: AnsiString)', @BlockSocket_SendBlock);
    AType.AddMethod('procedure SendStreamRaw(const Stream: TStream)', @BlockSocket_SendStreamRaw);
    AType.AddMethod('procedure SendStream(const Stream: TStream)', @BlockSocket_SendStream);
    AType.AddMethod('procedure SendStreamIndy(const Stream: TStream)', @BlockSocket_SendStreamIndy);

    AType.AddProp('LastError', 'Integer', @BlockSocket_LastErrorGet);
    AType.AddProp('LastErrorDesc', 'string', @BlockSocket_LastErrorDescGet);
    AType.AddProp('LineBuffer', 'AnsiString', @BlockSocket_LineBufferGet, @BlockSocket_LineBufferSet);
    AType.AddProp('SizeRecvBuffer', 'Integer', @BlockSocket_SizeRecvBufferGet, @BlockSocket_SizeRecvBufferSet);
    AType.AddProp('SizeSendBuffer', 'Integer', @BlockSocket_SizeSendBufferGet, @BlockSocket_SizeSendBufferSet);
    AType.AddProp('NonBlockMode', 'Boolean', @BlockSocket_NonBlockModeGet, @BlockSocket_NonBlockModeSet);
    AType.AddProp('TTL', 'Integer', @BlockSocket_TTLGet, @BlockSocket_TTLSet);
    AType.AddProp('IP6used', 'Boolean', @BlockSocket_IP6usedGet);
    AType.AddProp('RecvCounter', 'Integer', @BlockSocket_RecvCounterGet);
    AType.AddProp('SendCounter', 'Integer', @BlockSocket_SendCounterGet);
    AType.AddProp('Socket', 'LongInt', @BlockSocket_SocketGet, @BlockSocket_SocketSet);
  end
  else
  if AType.ValueClassType = TSocksBlockSocket then
  begin
    AType.AddMethod('constructor Create', @SocksBlockSocket_Create);
    AType.AddMethod('function SocksOpen: Boolean', @SocksBlockSocket_SocksOpen);
    AType.AddMethod('function SocksRequest(Cmd: Byte; const IP, Port: string): Boolean', @SocksBlockSocket_SocksRequest);
    AType.AddMethod('function SocksResponse: Boolean', @SocksBlockSocket_SocksResponse);

    AType.AddProp('UsingSocks', 'Boolean', @SocksBlockSocket_UsingSocksGet);
    AType.AddProp('SocksLastError', 'integer', @SocksBlockSocket_SocksLastErrorGet);
  end
  else
  if AType.ValueClassType = TTCPBlockSocket then
  begin
    AType.AddMethod('constructor Create', @TCPBlockSocket_Create);
    AType.AddMethod('procedure SSLDoConnect', @TCPBlockSocket_SSLDoConnect);
    AType.AddMethod('procedure SSLDoShutdown', @TCPBlockSocket_SSLDoShutdown);
    AType.AddMethod('function SSLAcceptConnection: Boolean', @TCPBlockSocket_SSLAcceptConnection);

    AType.AddProp('SSL', 'TCustomSSL', @TCPBlockSocket_SSL);
    AType.AddProp('HTTPTunnel', 'Boolean', @TCPBlockSocket_HTTPTunnel);
  end
  else
  if AType.ValueClassType = TUDPBlockSocket then
  begin
    AType.AddMethod('Constructor Create', @UDPBlockSocket_Create);
    AType.AddMethod('procedure EnableBroadcast(Value: Boolean)', @UDPBlockSocket_EnableBroadcast);
    AType.AddMethod('procedure AddMulticast(MCastIP:string)', @UDPBlockSocket_AddMulticast);
    AType.AddMethod('procedure DropMulticast(MCastIP:string)', @UDPBlockSocket_DropMulticast);
    AType.AddMethod('procedure EnableMulticastLoop(Value: Boolean)', @UDPBlockSocket_EnableMulticastLoop);

    AType.AddProp('MulticastTTL', 'Integer', @UDPBlockSocket_MulticastTTLGet, @UDPBlockSocket_MulticastTTLSet);
  end
  else
  if AType.ValueClassType = TCustomSSL then
  begin
    AType.AddMethod('constructor Create(const Value: TTCPBlockSocket)', @CustomSSL_Create);
    AType.AddMethod('procedure Assign(const Value: TCustomSSL)', @CustomSSL_Assign);
    AType.AddMethod('function LibVersion: String', @CustomSSL_LibVersion);
    AType.AddMethod('function LibName: String', @CustomSSL_LibName);
    AType.AddMethod('function Connect: boolean', @CustomSSL_Connect);
    AType.AddMethod('function Accept: boolean', @CustomSSL_Accept);
    AType.AddMethod('function Shutdown: boolean', @CustomSSL_Shutdown);
    AType.AddMethod('function BiShutdown: boolean', @CustomSSL_BiShutdown);
    AType.AddMethod('function WaitingData: Integer', @CustomSSL_WaitingData);
    AType.AddMethod('function GetSSLVersion: string', @CustomSSL_GetSSLVersion);
    AType.AddMethod('function GetPeerSubject: string', @CustomSSL_GetPeerSubject);
    AType.AddMethod('function GetPeerSerialNo: integer', @CustomSSL_GetPeerSerialNo);
    AType.AddMethod('function GetPeerIssuer: string', @CustomSSL_GetPeerIssuer);
    AType.AddMethod('function GetPeerName: string', @CustomSSL_GetPeerName);
    AType.AddMethod('function GetPeerNameHash: cardinal', @CustomSSL_GetPeerNameHash);
    AType.AddMethod('function GetPeerFingerprint: string', @CustomSSL_GetPeerFingerprint);
    AType.AddMethod('function GetCertInfo: string', @CustomSSL_GetCertInfo);
    AType.AddMethod('function GetCipherName: string', @CustomSSL_GetCipherName);
    AType.AddMethod('function GetCipherBits: integer', @CustomSSL_GetCipherBits);
    AType.AddMethod('function GetCipherAlgBits: integer', @CustomSSL_GetCipherAlgBits);
    AType.AddMethod('function GetVerifyCert: integer', @CustomSSL_GetVerifyCert);

    AType.AddProp('SSLEnabled', 'Boolean', @CustomSSL_SSLEnabled);
    AType.AddProp('LastError', 'integer', @CustomSSL_LastError);
    AType.AddProp('LastErrorDesc', 'string', @CustomSSL_LastErrorDesc);
  end
  else
  if AType.ValueClassType = THTTPSend then
  begin
    AType.AddMethod('constructor Create', @HTTPSend_Create);
    AType.AddMethod('procedure Clear', @HTTPSend_Clear);
    AType.AddMethod('procedure DecodeStatus(const Value: string)', @HTTPSend_DecodeStatus);
    AType.AddMethod('function HTTPMethod(const AMethod, URL: string): Boolean', @HTTPSend_HTTPMethod);
    AType.AddMethod('procedure Abort', @HTTPSend_Abort);
    AType.AddMethod('function PostFile(URL, FileName, ContentType: string; Stream: TStream): Boolean', @HTTPSend_PostFile);
  end
  else
  if AType.ValueClassType = TFTPListRec then
  begin
    AType.AddMethod('procedure Assign(Value: TFTPListRec)', @FTPListRec_Assign);

    AType.AddProp('FileName', 'string', @FTPListRec_FileNameGet, @FTPListRec_FileNameSet);
    AType.AddProp('Directory', 'Boolean', @FTPListRec_DirectoryGet, @FTPListRec_DirectorySet);
    AType.AddProp('Readable', 'Boolean', @FTPListRec_ReadableGet, @FTPListRec_ReadableSet);
    AType.AddProp('FileSize', 'int64', @FTPListRec_FileSizeGet, @FTPListRec_FileSizeSet);
    AType.AddProp('FileTime', 'TDateTime', @FTPListRec_FileTimeGet, @FTPListRec_FileTimeSet);
    AType.AddProp('OriginalLine', 'string', @FTPListRec_OriginalLineGet, @FTPListRec_OriginalLineSet);
    AType.AddProp('Mask', 'string', @FTPListRec_MaskGet, @FTPListRec_MaskSet);
    AType.AddProp('Permission', 'string', @FTPListRec_PermissionGet, @FTPListRec_PermissionSet);
  end
  else
  if AType.ValueClassType = TFTPList then
  begin
    AType.AddMethod('procedure Clear', @FTPList_Clear);
    AType.AddMethod('function Count: integer', @FTPList_Count);
    AType.AddMethod('procedure Assign(Value: TFTPList)', @FTPList_Assign);
    AType.AddMethod('procedure ParseLines', @FTPList_ParseLines);

    AType.AddProp('List', 'TList', @FTPList_List);
    AType.AddIndexedProp('Items', 'TFTPListRec', 'Integer', @FTPList_ItemsGet);
    AType.AddProp('Lines', 'TStringList', @FTPList_Lines);
    AType.AddProp('Masks', 'TStringList', @FTPList_Masks);
    AType.AddProp('UnparsedLines', 'TStringList', @FTPList_UnparsedLines);
  end
  else
  if AType.ValueClassType = TFTPSend then
  begin
    AType.AddMethod('constructor Create', @FTPSend_Create);
    AType.AddMethod('function ReadResult: Integer', @FTPSend_ReadResult);
    AType.AddMethod('procedure ParseRemote(Value: string)', @FTPSend_ParseRemote);
    AType.AddMethod('procedure ParseRemoteEPSV(Value: string)', @FTPSend_ParseRemoteEPSV);
    AType.AddMethod('function FTPCommand(const Value: string): integer', @FTPSend_FTPCommand);
    AType.AddMethod('function Login: Boolean', @FTPSend_Login);
    AType.AddMethod('function Logout: Boolean', @FTPSend_Logout);
    AType.AddMethod('procedure Abort', @FTPSend_Abort);
    AType.AddMethod('procedure TelnetAbort', @FTPSend_TelnetAbort);
    AType.AddMethod('function List(Directory: string; NameList: Boolean): Boolean', @FTPSend_List);
    AType.AddMethod('function RetrieveFile(const FileName: string; Restore: Boolean): Boolean', @FTPSend_RetrieveFile);
    AType.AddMethod('function StoreFile(const FileName: string; Restore: Boolean): Boolean', @FTPSend_StoreFile);
    AType.AddMethod('function StoreUniqueFile: Boolean', @FTPSend_StoreUniqueFile);
    AType.AddMethod('function AppendFile(const FileName: string): Boolean', @FTPSend_AppendFile);
    AType.AddMethod('function RenameFile(const OldName, NewName: string): Boolean', @FTPSend_RenameFile);
    AType.AddMethod('function DeleteFile(const FileName: string): Boolean', @FTPSend_DeleteFile);
    AType.AddMethod('function FileSize(const FileName: string): int64', @FTPSend_FileSize);
    AType.AddMethod('function NoOp: Boolean', @FTPSend_NoOp);
    AType.AddMethod('function ChangeWorkingDir(const Directory: string): Boolean', @FTPSend_ChangeWorkingDir);
    AType.AddMethod('function ChangeToParentDir: Boolean', @FTPSend_ChangeToParentDir);
    AType.AddMethod('function ChangeToRootDir: Boolean', @FTPSend_ChangeToRootDir);
    AType.AddMethod('function DeleteDir(const Directory: string): Boolean', @FTPSend_DeleteDir);
    AType.AddMethod('function CreateDir(const Directory: string): Boolean', @FTPSend_CreateDir);
    AType.AddMethod('function GetCurrentDir: String', @FTPSend_GetCurrentDir);
    AType.AddMethod('function DataRead(const DestStream: TStream): Boolean', @FTPSend_DataRead);
    AType.AddMethod('function DataWrite(const SourceStream: TStream): Boolean', @FTPSend_DataWrite);
  end
  else
  if AType.ValueClassType = TPOP3Send then
  begin
    AType.AddMethod('constructor Create', @Pop3Send_Create);
    AType.AddMethod('function CustomCommand(const Command: string; MultiLine: Boolean): boolean', @Pop3Send_CustomCommand);
    AType.AddMethod('function Capability: Boolean', @Pop3Send_Capability);
    AType.AddMethod('function Login: Boolean', @Pop3Send_Login);
    AType.AddMethod('function Logout: Boolean', @Pop3Send_Logout);
    AType.AddMethod('function Reset: Boolean', @Pop3Send_Reset);
    AType.AddMethod('function NoOp: Boolean', @Pop3Send_NoOp);
    AType.AddMethod('function Stat: Boolean', @Pop3Send_Stat);
    AType.AddMethod('function List(Value: Integer): Boolean', @Pop3Send_List);
    AType.AddMethod('function Retr(Value: Integer): Boolean', @Pop3Send_Retr);
    AType.AddMethod('function RetrStream(Value: Integer; Stream: TStream): Boolean', @Pop3Send_RetrStream);
    AType.AddMethod('function Dele(Value: Integer): Boolean', @Pop3Send_Dele);
    AType.AddMethod('function Top(Value, Maxlines: Integer): Boolean', @Pop3Send_Top);
    AType.AddMethod('function Uidl(Value: Integer): Boolean', @Pop3Send_Uidl);
    AType.AddMethod('function StartTLS: Boolean', @Pop3Send_StartTLS);
    AType.AddMethod('function FindCap(const Value: string): string', @Pop3Send_FindCap);
  end
  else
  if AType.ValueClassType = TMessHeader then
  begin
    AType.AddMethod('constructor Create', @MessHeader_Create);
    AType.AddMethod('procedure Clear', @MessHeader_Clear);
    AType.AddMethod('procedure EncodeHeaders(const Value: TStrings)', @MessHeader_EncodeHeaders);
    AType.AddMethod('procedure DecodeHeaders(const Value: TStrings)', @MessHeader_DecodeHeaders);
    AType.AddMethod('function FindHeader(Value: string): string', @MessHeader_FindHeader);
    AType.AddMethod('procedure FindHeaderList(Value: string; const HeaderList: TStrings)', @MessHeader_FindHeaderList);
  end
  else
  if AType.ValueClassType = TMimeMess then
  begin
    AType.AddMethod('constructor Create', @MimeMess_Create);
    AType.AddMethod('procedure Clear', @MimeMess_Clear);
    AType.AddMethod('function AddPart(const PartParent: TMimePart): TMimePart', @MimeMess_AddPart);
    AType.AddMethod('function AddPartMultipart(const MultipartType: String; const PartParent: TMimePart): TMimePart', @MimeMess_AddPartMultipart);
    AType.AddMethod('function AddPartText(const Value: TStrings; const PartParent: TMimePart): TMimepart', @MimeMess_AddPartText);
    AType.AddMethod('function AddPartTextEx(const Value: TStrings; const PartParent: TMimePart; PartCharset: TMimeChar; Raw: Boolean; PartEncoding: TMimeEncoding): TMimepart;', @MimeMess_AddPartTextEx);
    AType.AddMethod('function AddPartHTML(const Value: TStrings; const PartParent: TMimePart): TMimepart', @MimeMess_AddPartHTML);
    AType.AddMethod('function AddPartTextFromFile(const FileName: String; const PartParent: TMimePart): TMimepart', @MimeMess_AddPartTextFromFile);
    AType.AddMethod('function AddPartHTMLFromFile(const FileName: String; const PartParent: TMimePart): TMimepart', @MimeMess_AddPartHTMLFromFile);
    AType.AddMethod('function AddPartBinary(const Stream: TStream; const FileName: string; const PartParent: TMimePart): TMimepart', @MimeMess_AddPartBinary);
    AType.AddMethod('function AddPartBinaryFromFile(const FileName: string; const PartParent: TMimePart): TMimepart', @MimeMess_AddPartBinaryFromFile);
    AType.AddMethod('function AddPartHTMLBinary(const Stream: TStream; const FileName, Cid: string; const PartParent: TMimePart): TMimepart', @MimeMess_AddPartHTMLBinary);
    AType.AddMethod('function AddPartHTMLBinaryFromFile(const FileName, Cid: string; const PartParent: TMimePart): TMimepart', @MimeMess_AddPartHTMLBinaryFromFile);
    AType.AddMethod('function AddPartMess(const Value: TStrings; const PartParent: TMimePart): TMimepart', @MimeMess_AddPartMess);
    AType.AddMethod('function AddPartMessFromFile(const FileName: string; const PartParent: TMimePart): TMimepart', @MimeMess_AddPartMessFromFile);
    AType.AddMethod('procedure EncodeMessage', @MimeMess_EncodeMessage);
    AType.AddMethod('procedure DecodeMessage', @MimeMess_DecodeMessage);
    AType.AddMethod('procedure DecodeMessageBinary(AHeader:TStrings; AData:TMemoryStream)', @MimeMess_DecodeMessageBinary);

  end
  else
  if AType.ValueClassType = TMimePart then
  begin
    AType.AddMethod('constructor Create', @MimePart_Create);
    AType.AddMethod('procedure Assign(Value: TMimePart)', @MimePart_Assign);
    AType.AddMethod('procedure AssignSubParts(Value: TMimePart)', @MimePart_AssignSubParts);
    AType.AddMethod('procedure Clear', @MimePart_Clear);
    AType.AddMethod('procedure DecodePart', @MimePart_DecodePart);
    AType.AddMethod('procedure DecodePartHeader', @MimePart_DecodePartHeader);
    AType.AddMethod('procedure EncodePart', @MimePart_EncodePart);
    AType.AddMethod('procedure EncodePartHeader', @MimePart_EncodePartHeader);
    AType.AddMethod('procedure MimeTypeFromExt(Value: string)', @MimePart_MimeTypeFromExt);
    AType.AddMethod('function GetSubPartCount: integer', @MimePart_GetSubPartCount);
    AType.AddMethod('function GetSubPart(index: integer): TMimePart', @MimePart_GetSubPart);
    AType.AddMethod('procedure DeleteSubPart(index: integer)', @MimePart_DeleteSubPart);
    AType.AddMethod('procedure ClearSubParts', @MimePart_ClearSubParts);
    AType.AddMethod('function AddSubPart: TMimePart', @MimePart_AddSubPart);
    AType.AddMethod('procedure DecomposeParts', @MimePart_DecomposeParts);
    AType.AddMethod('procedure DecomposePartsBinary(AHeader:TStrings; AStx,AEtx: string)', @MimePart_DecomposePartsBinary);
    AType.AddMethod('procedure ComposeParts', @MimePart_ComposeParts);
    AType.AddMethod('procedure WalkPart', @MimePart_WalkPart);
    AType.AddMethod('function CanSubPart: boolean', @MimePart_CanSubPart);
  end
  else
  if AType.ValueClassType = TSMTPSend then
  begin
    AType.AddMethod('constructor Create', @SMTPSend_Create);
    AType.AddMethod('function Login: Boolean', @SMTPSend_Login);
    AType.AddMethod('function Logout: Boolean', @SMTPSend_Logout);
    AType.AddMethod('function Reset: Boolean', @SMTPSend_Reset);
    AType.AddMethod('function NoOp: Boolean', @SMTPSend_NoOp);
    AType.AddMethod('function MailFrom(const Value: string; Size: Integer): Boolean', @SMTPSend_MailFrom);
    AType.AddMethod('function MailTo(const Value: string): Boolean', @SMTPSend_MailTo);
    AType.AddMethod('function MailData(const Value: Tstrings): Boolean', @SMTPSend_MailData);
    AType.AddMethod('function Etrn(const Value: string): Boolean', @SMTPSend_Etrn);
    AType.AddMethod('function Verify(const Value: string): Boolean', @SMTPSend_Verify);
    AType.AddMethod('function StartTLS: Boolean', @SMTPSend_StartTLS);
    AType.AddMethod('function EnhCodeString: string', @SMTPSend_EnhCodeString);
    AType.AddMethod('function FindCap(const Value: string): string', @SMTPSend_FindCap);
  end
  else
  if AType.ValueClassType = TIMAPSend then
  begin
    AType.AddMethod('constructor Create', @IMAPSend_Create);
    AType.AddMethod('function IMAPcommand(Value: string): string', @IMAPSend_IMAPcommand);
    AType.AddMethod('function IMAPuploadCommand(Value: string; const Data:TStrings): string', @IMAPSend_IMAPuploadCommand);
    AType.AddMethod('function Capability: Boolean', @IMAPSend_Capability);
    AType.AddMethod('function Login: Boolean', @IMAPSend_Login);
    AType.AddMethod('function Logout: Boolean', @IMAPSend_Logout);
    AType.AddMethod('function NoOp: Boolean', @IMAPSend_NoOp);
    AType.AddMethod('function List(FromFolder: string; const FolderList: TStrings): Boolean', @IMAPSend_List);
    AType.AddMethod('function ListSearch(FromFolder, Search: string; const FolderList: TStrings): Boolean', @IMAPSend_ListSearch);
    AType.AddMethod('function ListSubscribed(FromFolder: string; const FolderList: TStrings): Boolean', @IMAPSend_ListSubscribed);
    AType.AddMethod('function ListSearchSubscribed(FromFolder, Search: string; const FolderList: TStrings): Boolean', @IMAPSend_ListSearchSubscribed);
    AType.AddMethod('function CreateFolder(FolderName: string): Boolean', @IMAPSend_CreateFolder);
    AType.AddMethod('function DeleteFolder(FolderName: string): Boolean', @IMAPSend_DeleteFolder);
    AType.AddMethod('function RenameFolder(FolderName, NewFolderName: string): Boolean', @IMAPSend_RenameFolder);
    AType.AddMethod('function SubscribeFolder(FolderName: string): Boolean', @IMAPSend_SubscribeFolder);
    AType.AddMethod('function UnsubscribeFolder(FolderName: string): Boolean', @IMAPSend_UnsubscribeFolder);
    AType.AddMethod('function SelectFolder(FolderName: string): Boolean', @IMAPSend_SelectFolder);
    AType.AddMethod('function SelectROFolder(FolderName: string): Boolean', @IMAPSend_SelectROFolder);
    AType.AddMethod('function CloseFolder: Boolean', @IMAPSend_CloseFolder);
    AType.AddMethod('function StatusFolder(FolderName, Value: string): integer', @IMAPSend_StatusFolder);
    AType.AddMethod('function ExpungeFolder: Boolean', @IMAPSend_ExpungeFolder);
    AType.AddMethod('function CheckFolder: Boolean', @IMAPSend_CheckFolder);
    AType.AddMethod('function AppendMess(ToFolder: string; const Mess: TStrings): Boolean', @IMAPSend_AppendMess);
    AType.AddMethod('function DeleteMess(MessID: integer): boolean', @IMAPSend_DeleteMess);
    AType.AddMethod('function FetchMess(MessID: integer; const Mess: TStrings): Boolean', @IMAPSend_FetchMess);
    AType.AddMethod('function FetchHeader(MessID: integer; const Headers: TStrings): Boolean', @IMAPSend_FetchHeader);
    AType.AddMethod('function MessageSize(MessID: integer): integer', @IMAPSend_MessageSize);
    AType.AddMethod('function CopyMess(MessID: integer; ToFolder: string): Boolean', @IMAPSend_CopyMess);
    AType.AddMethod('function SearchMess(Criteria: string; const FoundMess: TStrings): Boolean', @IMAPSend_SearchMess);
    AType.AddMethod('function SetFlagsMess(MessID: integer; Flags: string): Boolean', @IMAPSend_SetFlagsMess);
    AType.AddMethod('function GetFlagsMess(MessID: integer; var Flags: string): Boolean', @IMAPSend_GetFlagsMess);
    AType.AddMethod('function AddFlagsMess(MessID: integer; Flags: string): Boolean', @IMAPSend_AddFlagsMess);
    AType.AddMethod('function DelFlagsMess(MessID: integer; Flags: string): Boolean', @IMAPSend_DelFlagsMess);
    AType.AddMethod('function StartTLS: Boolean', @IMAPSend_StartTLS);
    AType.AddMethod('function GetUID(MessID: integer; var UID : Integer): Boolean', @IMAPSend_GetUID);
    AType.AddMethod('function FindCap(const Value: string): string', @IMAPSend_FindCap);
  end
  else
  if AType.ValueClassType = TBlockSerial then
  begin
    AType.AddMethod('constructor Create', @BlockSerial_Create);
    AType.AddMethod('function GetVersion: string', @BlockSerial_GetVersion);
    AType.AddMethod('procedure CloseSocket', @BlockSerial_CloseSocket);
    AType.AddMethod('procedure Config(baud, bits: integer; parity: char; stop: integer; softflow, hardflow: boolean)', @BlockSerial_Config);
    AType.AddMethod('procedure Connect(comport: string)', @BlockSerial_Connect);
    AType.AddMethod('procedure SetCommState', @BlockSerial_SetCommState);
    AType.AddMethod('procedure GetCommState', @BlockSerial_GetCommState);
    AType.AddMethod('procedure SendByte(data: byte)', @BlockSerial_SendByte);
    AType.AddMethod('procedure SendString(data: AnsiString)', @BlockSerial_SendString);
    AType.AddMethod('procedure SendInteger(Data: integer)', @BlockSerial_SendInteger);
    AType.AddMethod('procedure SendBlock(const Data: AnsiString)', @BlockSerial_SendBlock);
    AType.AddMethod('procedure SendStreamRaw(const Stream: TStream)', @BlockSerial_SendStreamRaw);
    AType.AddMethod('procedure SendStream(const Stream: TStream)', @BlockSerial_SendStream);
    AType.AddMethod('procedure SendStreamIndy(const Stream: TStream)', @BlockSerial_SendStreamIndy);
    AType.AddMethod('function RecvPacket(Timeout: Integer): AnsiString', @BlockSerial_RecvPacket);
    AType.AddMethod('function RecvByte(timeout: integer): byte', @BlockSerial_RecvByte);
    AType.AddMethod('function RecvTerminated(Timeout: Integer; const Terminator: AnsiString): AnsiString', @BlockSerial_RecvTerminated);
    AType.AddMethod('function Recvstring(timeout: integer): AnsiString', @BlockSerial_Recvstring);
    AType.AddMethod('function RecvInteger(Timeout: Integer): Integer', @BlockSerial_RecvInteger);
    AType.AddMethod('function RecvBlock(Timeout: Integer): AnsiString', @BlockSerial_RecvBlock);
    AType.AddMethod('procedure RecvStreamRaw(const Stream: TStream; Timeout: Integer)', @BlockSerial_RecvStreamRaw);
    AType.AddMethod('procedure RecvStreamSize(const Stream: TStream; Timeout: Integer; Size: Integer)', @BlockSerial_RecvStreamSize);
    AType.AddMethod('procedure RecvStream(const Stream: TStream; Timeout: Integer)', @BlockSerial_RecvStream);
    AType.AddMethod('procedure RecvStreamIndy(const Stream: TStream; Timeout: Integer)', @BlockSerial_RecvStreamIndy);
    AType.AddMethod('function WaitingData: integer', @BlockSerial_WaitingData);
    AType.AddMethod('function WaitingDataEx: integer', @BlockSerial_WaitingDataEx);
    AType.AddMethod('function SendingData: integer', @BlockSerial_SendingData);
    AType.AddMethod('procedure EnableRTSToggle(value: boolean)', @BlockSerial_EnableRTSToggle);
    AType.AddMethod('procedure Flush', @BlockSerial_Flush);
    AType.AddMethod('procedure Purge', @BlockSerial_Purge);
    AType.AddMethod('function CanRead(Timeout: integer): boolean', @BlockSerial_CanRead);
    AType.AddMethod('function CanWrite(Timeout: integer): boolean', @BlockSerial_CanWrite);
    AType.AddMethod('function CanReadEx(Timeout: integer): boolean', @BlockSerial_CanReadEx);
    AType.AddMethod('function ModemStatus: integer', @BlockSerial_ModemStatus);
    AType.AddMethod('procedure SetBreak(Duration: integer)', @BlockSerial_SetBreak);
    AType.AddMethod('function ATCommand(value: AnsiString): AnsiString', @BlockSerial_ATCommand);
    AType.AddMethod('function ATConnect(value: AnsiString): AnsiString', @BlockSerial_ATConnect);
    AType.AddMethod('function SerialCheck(SerialResult: integer): integer', @BlockSerial_SerialCheck);
    AType.AddMethod('procedure ExceptCheck', @BlockSerial_ExceptCheck);
    AType.AddMethod('procedure SetSynaError(ErrNumber: integer)', @BlockSerial_SetSynaError);
    AType.AddMethod('procedure RaiseSynaError(ErrNumber: integer)', @BlockSerial_RaiseSynaError);
    AType.AddMethod('function cpomComportAccessible: boolean', @BlockSerial_cpomComportAccessible);
    AType.AddMethod('procedure cpomReleaseComport', @BlockSerial_cpomReleaseComport);
    AType.AddMethod('function GetErrorDescr(ErrorCode: integer): string', @BlockSerial_GetErrorDescr);

    AType.AddProp('Device', 'string', @BlockSerial_DeviceRead);
    AType.AddProp('LastError', 'integer', @BlockSerial_LastErrorRead);
    AType.AddProp('LastErrorDesc', 'string', @BlockSerial_LastErrorDescRead);
    AType.AddProp('ATResult', 'Boolean', @BlockSerial_ATResultRead);
    AType.AddProp('RTS', 'Boolean', nil, @BlockSerial_RTSWrite);
    AType.AddProp('CTS', 'Boolean', @BlockSerial_CTSRead);
    AType.AddProp('DTR', 'Boolean', nil, @BlockSerial_DTRWrite);
    AType.AddProp('DSR', 'Boolean', @BlockSerial_DSRRead);
    AType.AddProp('Carrier', 'Boolean', @BlockSerial_CarrierRead);
    AType.AddProp('Ring', 'Boolean', @BlockSerial_RingRead);
    AType.AddProp('InstanceActive', 'Boolean', @BlockSerial_InstanceActiveRead);
    AType.AddProp('MaxSendBandwidth', 'Integer', @BlockSerial_MaxSendBandwidthRead, @BlockSerial_MaxSendBandwidthWrite);
    AType.AddProp('MaxRecvBandwidth', 'Integer', @BlockSerial_MaxRecvBandwidthRead, @BlockSerial_MaxRecvBandwidthWrite);
    AType.AddProp('MaxBandwidth', 'Integer', nil, @BlockSerial_MaxBandwidthWrite);
    AType.AddProp('SizeRecvBuffer', 'integer', @BlockSerial_SizeRecvBufferRead, @BlockSerial_SizeRecvBufferWrite);

    AType.AddProp('DCB_DCBlength', 'word', @BlockSerial_DCB_DCBlengthRead, @BlockSerial_DCB_DCBlengthWrite);
    AType.AddProp('DCB_BaudRate', 'word', @BlockSerial_DCB_BaudRateRead, @BlockSerial_DCB_BaudRateWrite);
    AType.AddProp('DCB_Flags', 'Longint', @BlockSerial_DCB_FlagsRead, @BlockSerial_DCB_FlagsWrite);
    AType.AddProp('DCB_wReserved', 'word', @BlockSerial_DCB_wReservedRead, @BlockSerial_DCB_wReservedWrite);
    AType.AddProp('DCB_XonLim', 'word', @BlockSerial_DCB_XonLimRead, @BlockSerial_DCB_XonLimWrite);
    AType.AddProp('DCB_XoffLim', 'word', @BlockSerial_DCB_XoffLimRead, @BlockSerial_DCB_XoffLimWrite);
    AType.AddProp('DCB_ByteSize', 'byte', @BlockSerial_DCB_ByteSizeRead, @BlockSerial_DCB_ByteSizeWrite);
    AType.AddProp('DCB_Parity', 'byte', @BlockSerial_DCB_ParityRead, @BlockSerial_DCB_ParityWrite);
    AType.AddProp('DCB_StopBits', 'byte', @BlockSerial_DCB_StopBitsRead, @BlockSerial_DCB_StopBitsWrite);
    AType.AddProp('DCB_XonChar', 'Char', @BlockSerial_DCB_XonCharRead, @BlockSerial_DCB_XonCharWrite);
    AType.AddProp('DCB_XoffChar', 'Char', @BlockSerial_DCB_XoffCharRead, @BlockSerial_DCB_XoffCharWrite);
    AType.AddProp('DCB_ErrorChar', 'Char', @BlockSerial_DCB_ErrorCharRead, @BlockSerial_DCB_ErrorCharWrite);
    AType.AddProp('DCB_EofChar', 'Char', @BlockSerial_DCB_EofCharRead, @BlockSerial_DCB_EofCharWrite);
    AType.AddProp('DCB_EvtChar', 'Char', @BlockSerial_DCB_EvtCharRead, @BlockSerial_DCB_EvtCharWrite);
    AType.AddProp('DCB_wReserved1', 'word', @BlockSerial_DCB_wReserved1Read, @BlockSerial_DCB_wReserved1Write);
  end
  else
  if AType.ValueClassType = TTCPSockServer then
  begin
    AType.AddMethod('constructor Create(CreateSuspended: boolean)', @TCPSockServer_Create);

    AType.AddProp('Socket', 'TTCPBlockSocket', @TCPSockServer_Socket);
    AType.AddProp('ThreadList', 'TList', @TCPSockServer_ThreadList);

  end
  else
  if AType.ValueClassType = TTCPThread then
  begin
     AType.AddProp('Socket', 'TTCPBlockSocket', @TCPThread_Socket);
  end
  else
  if AType.ValueClassType = TSimpleTCPThread then
  begin
    AType.AddMethod('constructor Create(CreateSuspended: boolean)', @SimpleTCPThread_Create);
  end;
end;

procedure TSynapseImport.AddMethods(AddMethod: TAddMethodProc);
begin
  {from httpsend}
  AddMethod('function HttpGetText(const URL: string; const Response: TStrings): Boolean', @Call_HttpGetText);
  AddMethod('function HttpGetTextTimeout(const URL: string; const Response: TStrings; TimeOut: Integer): Boolean', @Call_HttpGetTextTimeout);
  AddMethod('function HttpGetBinary(const URL: string; const Response: TStream): Boolean', @Call_HttpGetBinary);
  AddMethod('function HttpPostBinary(const URL: string; const Data: TStream): Boolean', @Call_HttpPostBinary);
  AddMethod('function HttpPostURL(const URL, URLData: string; const Data: TStream): Boolean', @Call_HttpPostURL);
  AddMethod('function HttpPostFile(const URL, FieldName, FileName: string; const Data: TStream; const ResultData: TStrings): Boolean', @Call_HttpPostFile);
  {from ftpsend}
  AddMethod('function FtpGetFile(const IP, Port, FileName, LocalFile, User, Pass: string): Boolean', @Call_FtpGetFile);
  AddMethod('function FtpPutFile(const IP, Port, FileName, LocalFile, User, Pass: string): Boolean;', @Call_FtpPutFile);
  {smtpsend}
  AddMethod('function SendTo(const MailFrom, MailTo, Subject, SMTPHost: string; const MailData: TStrings): Boolean', @Call_SendTo);
  AddMethod('function SendToEx(const MailFrom, MailTo, Subject, SMTPHost: string; const MailData: TStrings; const Username, Password: string): Boolean', @Call_SendToEx);
  AddMethod('function SendToRaw(const MailFrom, MailTo, SMTPHost: string; const MailData: TStrings; const Username, Password: string): Boolean', @Call_SendToRaw);

  AddMethod('function SendToRawSSL(const MailFrom, MailTo, SMTPHost: string; const MailData: TStrings; const Username, Password: string): Boolean', @Call_SendToRawSSL);
  AddMethod('function SendToExSSL(const MailFrom, MailTo, Subject, SMTPHost: string; const MailData: TStrings; const Username, Password: string): Boolean', @Call_SendToExSSL);
  AddMethod('function SendMail(const MailFrom, MailTo: string; const MailData: TStrings; ASMTPSend: TSMTPSend): Boolean', @Call_SendMail);
  AddMethod('function GetDllSSLName: string', @Call_GetDllSSLName);
  AddMethod('function GetSSLFileName: string', @Call_GetSSLFileName);
  {synachar}
  AddMethod('function CharsetConversion(const Value: AnsiString; CharFrom: TMimeChar; CharTo: TMimeChar): AnsiString', @Call_CharsetConversion);
  {synacode}
  AddMethod('function DecodeBase64(const Value: AnsiString): AnsiString', @Call_DecodeBase64);
  AddMethod('function EncodeBase64(const Value: AnsiString): AnsiString', @Call_EncodeBase64);
  AddMethod('function EncodeURLElement(const Value: AnsiString): AnsiString', @Call_EncodeURLElement);
  AddMethod('function EncodeURL(const Value: AnsiString): AnsiString', @Call_EncodeURL);
  AddMethod('function DecodeURL(const Value: AnsiString): AnsiString', @Call_DecodeURL);
  {synaser}
  AddMethod('function GetSerialPortNames: string', @Call_GetSerialPortNames);
{AddMethod('', @Call_);}
end;

procedure TSynapseImport.AddConsts(AddConst: TAddConstProc);
begin
  {from httpsend}
  AddConst('cHttpProtocol', 'string', cHttpProtocol);
end;

procedure TSynapseImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(THookSocketStatus), THookSocketStatusHandler);
  RegisterHandler(TypeInfo(THookDataFilter), THookDataFilterHandler);
  RegisterHandler(TypeInfo(THookCreateSocket), TSuNotifyHandler);
  RegisterHandler(TypeInfo(THookAfterConnect), TSuNotifyHandler);
  RegisterHandler(TypeInfo(THookVerifyCert), THookVerifyCertHandler);
  RegisterHandler(TypeInfo(THookHeartbeat), TSuNotifyHandler);
  RegisterHandler(TypeInfo(THookSerialStatus), THookSerialStatusHandler);
  RegisterHandler(TypeInfo(TOnReciveSockData), TOnReciveSocketDataHandler);
  RegisterHandler(TypeInfo(TOnNewTCPThread), TOnNewTCPThreadHandler);
  RegisterHandler(TypeInfo(TOnReciveData), TOnReciveDataHandler);
end;

procedure TSynapseImport.AddVars(AddVar: TAddVarProc);
begin
  inherited AddVars(AddVar);
end;

end.

