unit SuIBX;

{$mode objfpc}{$H+}

interface

uses
  SysUtils, Classes, dpCompil, TypInfo, Variants, Controls, dpUtils,
  dpi_mettyps;

type

  { TIBXImport }

  TIBXImport = class(TClassImporter)
    function IBBase_CheckDatabase(Instance: TObject; var Params: Variant
      ): Variant;
    function IBBase_CheckTransaction(Instance: TObject; var Params: Variant
      ): Variant;
    function IBBase_DatabaseGet(Instance: Pointer): Variant;
    procedure IBBase_DatabaseSet(Instance: Pointer; AValue: Variant);
    function IBBase_Owner(Instance: Pointer): Variant;
    function IBBase_TransactionGet(Instance: Pointer): Variant;
    procedure IBBase_TransactionSet(Instance: Pointer; AValue: Variant);
    function IBBatchInput_ReadParameters(Instance: TObject; var Params: Variant
      ): Variant;
    function IBBatchMove_ChangedCount(Instance: Pointer): Variant;
    function IBBatchMove_Execute(Instance: TObject; var Params: Variant
      ): Variant;
    function IBBatchMove_KeyViolCount(Instance: Pointer): Variant;
    function IBBatchMove_MovedCount(Instance: Pointer): Variant;
    function IBBatchMove_ProblemCount(Instance: Pointer): Variant;
    function IBBatchOutput_WriteColumns(Instance: TObject; var Params: Variant
      ): Variant;
    function IBBatch_Columns(Instance: Pointer): Variant;
    function IBBatch_FilenameGet(Instance: Pointer): Variant;
    procedure IBBatch_FilenameSet(Instance: Pointer; AValue: Variant);
    function IBBatch_Params(Instance: Pointer): Variant;
    function IBBatch_ReadyFile(Instance: TObject; var Params: Variant): Variant;
    function IBBlobStream_CheckReadable(Instance: TObject; var Params: Variant
      ): Variant;
    function IBBlobStream_CheckWritable(Instance: TObject; var Params: Variant
      ): Variant;
    function IBBlobStream_DatabaseGet(Instance: Pointer): Variant;
    procedure IBBlobStream_DatabaseSet(Instance: Pointer; AValue: Variant);
    function IBBlobStream_Finalize(Instance: TObject; var Params: Variant
      ): Variant;
    function IBBlobStream_LoadFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function IBBlobStream_LoadFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function IBBlobStream_ModeGet(Instance: Pointer): Variant;
    procedure IBBlobStream_ModeSet(Instance: Pointer; AValue: Variant);
    function IBBlobStream_ModifiedGet(Instance: Pointer): Variant;
    function IBBlobStream_SaveToFile(Instance: TObject; var Params: Variant
      ): Variant;
    function IBBlobStream_SaveToStream(Instance: TObject; var Params: Variant
      ): Variant;
    function IBBlobStream_Truncate(Instance: TObject; var Params: Variant
      ): Variant;
    function IBConfigService_ActivateShadow(Instance: TObject;
      var Params: Variant): Variant;
    function IBConfigService_BringDatabaseOnline(Instance: TObject;
      var Params: Variant): Variant;
    function IBConfigService_SetAsyncMode(Instance: TObject; var Params: Variant
      ): Variant;
    function IBConfigService_SetDBSqlDialect(Instance: TObject;
      var Params: Variant): Variant;
    function IBConfigService_SetPageBuffers(Instance: TObject;
      var Params: Variant): Variant;
    function IBConfigService_SetReadOnly(Instance: TObject; var Params: Variant
      ): Variant;
    function IBConfigService_SetReserveSpace(Instance: TObject;
      var Params: Variant): Variant;
    function IBConfigService_SetSweepInterval(Instance: TObject;
      var Params: Variant): Variant;
    function IBConfigService_ShutdownDatabase(Instance: TObject;
      var Params: Variant): Variant;
    function IBControlAndQueryService_Eof(Instance: Pointer): Variant;
    function IBControlAndQueryService_GetNextChunk(Instance: TObject;
      var Params: Variant): Variant;
    function IBControlAndQueryService_GetNextLine(Instance: TObject;
      var Params: Variant): Variant;
    function IBControlService_IsServiceRunning(Instance: Pointer): Variant;
    function IBControlService_ServiceStart(Instance: TObject;
      var Params: Variant): Variant;
    function IBCustomDataSet_ApplyUpdates(Instance: TObject; var Params: Variant
      ): Variant;
    function IBCustomDataSet_CachedUpdateStatus(Instance: TObject;
      var Params: Variant): Variant;
    function IBCustomDataSet_CancelUpdates(Instance: TObject;
      var Params: Variant): Variant;
    function IBCustomDataSet_FetchAll(Instance: TObject; var Params: Variant
      ): Variant;
    function IBCustomDataSet_FullRefresh(Instance: TObject; var Params: Variant
      ): Variant;
    function IBCustomDataSet_LocateNext(Instance: TObject; var Params: Variant
      ): Variant;
    function IBCustomDataSet_RefreshVisibleRows(Instance: TObject;
      var Params: Variant): Variant;
    function IBCustomService_Attach(Instance: TObject; var Params: Variant
      ): Variant;
    function IBCustomService_Detach(Instance: TObject; var Params: Variant
      ): Variant;
    function IBCustomService_ServiceParamBySPBGet(Instance: TObject;
      var Params: Variant): Variant;
    function IBCustomService_ServiceParamBySPBSet(Instance: TObject;
      var Params: Variant): Variant;
    function IBDatabaseInfo_Allocation(Instance: Pointer): Variant;
    function IBDatabaseInfo_BackoutCount(Instance: Pointer): Variant;
    function IBDatabaseInfo_BaseLevel(Instance: Pointer): Variant;
    function IBDatabaseInfo_CurrentMemory(Instance: Pointer): Variant;
    function IBDatabaseInfo_DBFileName(Instance: Pointer): Variant;
    function IBDatabaseInfo_DBImplementationClass(Instance: Pointer): Variant;
    function IBDatabaseInfo_DBImplementationNo(Instance: Pointer): Variant;
    function IBDatabaseInfo_DBSiteName(Instance: Pointer): Variant;
    function IBDatabaseInfo_DBSQLDialect(Instance: Pointer): Variant;
    function IBDatabaseInfo_DeleteCount(Instance: Pointer): Variant;
    function IBDatabaseInfo_ExpungeCount(Instance: Pointer): Variant;
    function IBDatabaseInfo_Fetches(Instance: Pointer): Variant;
    function IBDatabaseInfo_ForcedWrites(Instance: Pointer): Variant;
    function IBDatabaseInfo_InsertCount(Instance: Pointer): Variant;
    function IBDatabaseInfo_Marks(Instance: Pointer): Variant;
    function IBDatabaseInfo_MaxMemory(Instance: Pointer): Variant;
    function IBDatabaseInfo_NoReserve(Instance: Pointer): Variant;
    function IBDatabaseInfo_NumBuffers(Instance: Pointer): Variant;
    function IBDatabaseInfo_ODSMajorVersion(Instance: Pointer): Variant;
    function IBDatabaseInfo_ODSMinorVersion(Instance: Pointer): Variant;
    function IBDatabaseInfo_PageSize(Instance: Pointer): Variant;
    function IBDatabaseInfo_PurgeCount(Instance: Pointer): Variant;
    function IBDatabaseInfo_ReadIdxCount(Instance: Pointer): Variant;
    function IBDatabaseInfo_ReadOnly(Instance: Pointer): Variant;
    function IBDatabaseInfo_Reads(Instance: Pointer): Variant;
    function IBDatabaseInfo_ReadSeqCount(Instance: Pointer): Variant;
    function IBDatabaseInfo_SweepInterval(Instance: Pointer): Variant;
    function IBDatabaseInfo_UpdateCount(Instance: Pointer): Variant;
    function IBDatabaseInfo_UserNames(Instance: Pointer): Variant;
    function IBDatabaseInfo_Version(Instance: Pointer): Variant;
    function IBDatabaseInfo_Writes(Instance: Pointer): Variant;
    function IBDataBase_GenID(Instance: TObject; var Params: Variant): Variant;
    function IBDataSet_FindParam(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataSet_OrderFieldsGet(Instance: Pointer): Variant;
    procedure IBDataSet_OrderFieldsSet(Instance: Pointer; AValue: Variant);
    function IBDataSet_ParamByName(Instance: TObject; var Params: Variant
      ): Variant;
    function IBCustomDataSet_RecordModified(Instance: TObject;
      var Params: Variant): Variant;
    function IBCustomDataSet_RevertRecord(Instance: TObject; var Params: Variant
      ): Variant;
    function IBCustomDataSet_Undelete(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_AddTransaction(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_CheckActive(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_CheckDatabaseName(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_CheckInactive(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_CloseDataSets(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_CreateDatabase(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_DropDatabase(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_FindDefaultTransaction(Instance: TObject;
      var Params: Variant): Variant;
    function IBDataBase_FindTransaction(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_ForceClose(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_GetFieldNames(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_GetTableNames(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_HandleIsSharedGet(Instance: Pointer): Variant;
    function IBDataBase_IndexOfDBConst(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_InternalTransactionGet(Instance: Pointer): Variant;
    function IBDataBase_IsReadOnlyGet(Instance: Pointer): Variant;
    function IBDataBase_RemoveTransaction(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_RemoveTransactions(Instance: TObject;
      var Params: Variant): Variant;
    function IBDataBase_SQLObjectCountGet(Instance: Pointer): Variant;
    function IBDataBase_SQLObjectsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_TestConnected(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataBase_TransactionCountGet(Instance: Pointer): Variant;
    function IBDataBase_TransactionsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataSet_BatchInput(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataSet_BatchOutput(Instance: TObject; var Params: Variant
      ): Variant;
    function IBDataSet_ExecSQL(Instance: TObject; var Params: Variant): Variant;
    function IBDataSet_Params(Instance: Pointer): Variant;
    function IBDataSet_Prepare(Instance: TObject; var Params: Variant): Variant;
    function IBDataSet_QDelete(Instance: Pointer): Variant;
    function IBDataSet_QInsert(Instance: Pointer): Variant;
    function IBDataSet_QModify(Instance: Pointer): Variant;
    function IBDataSet_QRefresh(Instance: Pointer): Variant;
    function IBDataSet_QSelect(Instance: Pointer): Variant;
    function IBDataSet_StatementType(Instance: Pointer): Variant;
    function IBDataSet_UnPrepare(Instance: TObject; var Params: Variant
      ): Variant;
    function IBEvents_DeferredRegisterGet(Instance: Pointer): Variant;
    procedure IBEvents_DeferredRegisterSet(Instance: Pointer; AValue: Variant);
    function IBEvents_RegisterEvents(Instance: TObject; var Params: Variant
      ): Variant;
    function IBEvents_UnRegisterEvents(Instance: TObject; var Params: Variant
      ): Variant;
    function IBExtract_ExtractObject(Instance: TObject; var Params: Variant
      ): Variant;
    function IBExtract_GetArrayField(Instance: TObject; var Params: Variant
      ): Variant;
    function IBExtract_GetCharacterSets(Instance: TObject; var Params: Variant
      ): Variant;
    function IBExtract_GetFieldType(Instance: TObject; var Params: Variant
      ): Variant;
    function IBInputDelimitedFile_ColDelimiterGet(Instance: Pointer): Variant;
    procedure IBInputDelimitedFile_ColDelimiterSet(Instance: Pointer;
      AValue: Variant);
    function IBInputDelimitedFile_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function IBInputDelimitedFile_GetColumn(Instance: TObject;
      var Params: Variant): Variant;
    function IBInputDelimitedFile_ReadBlanksAsNullGet(Instance: Pointer
      ): Variant;
    procedure IBInputDelimitedFile_ReadBlanksAsNullSet(Instance: Pointer;
      AValue: Variant);
    function IBInputDelimitedFile_RowDelimiterGet(Instance: Pointer): Variant;
    procedure IBInputDelimitedFile_RowDelimiterSet(Instance: Pointer;
      AValue: Variant);
    function IBInputDelimitedFile_SkipTitlesGet(Instance: Pointer): Variant;
    procedure IBInputDelimitedFile_SkipTitlesSet(Instance: Pointer;
      AValue: Variant);
    function IBOutputDelimitedFile_ColDelimiterGet(Instance: Pointer): Variant;
    procedure IBOutputDelimitedFile_ColDelimiterSet(Instance: Pointer;
      AValue: Variant);
    function IBOutputDelimitedFile_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function IBOutputDelimitedFile_OutputTitlesGet(Instance: Pointer): Variant;
    procedure IBOutputDelimitedFile_OutputTitlesSet(Instance: Pointer;
      AValue: Variant);
    function IBOutputDelimitedFile_RowDelimiterGet(Instance: Pointer): Variant;
    procedure IBOutputDelimitedFile_RowDelimiterSet(Instance: Pointer;
      AValue: Variant);
    function IBQuery_BatchInput(Instance: TObject; var Params: Variant
      ): Variant;
    function IBQuery_BatchOutput(Instance: TObject; var Params: Variant
      ): Variant;
    function IBQuery_ExecSQL(Instance: TObject; var Params: Variant): Variant;
    function IBQuery_FindParam(Instance: TObject; var Params: Variant): Variant;
    function IBQuery_GenerateParamNamesGet(Instance: Pointer): Variant;
    procedure IBQuery_GenerateParamNamesSet(Instance: Pointer; AValue: Variant);
    function IBQuery_GetParamsCount(Instance: Pointer): Variant;
    function IBQuery_OutParamByName(Instance: TObject; var Params: Variant
      ): Variant;
    function IBQuery_OutParamCount(Instance: Pointer): Variant;
    function IBQuery_OutParams(Instance: Pointer): Variant;
    function IBQuery_ParamByName(Instance: TObject; var Params: Variant
      ): Variant;
    function IBQuery_Prepare(Instance: TObject; var Params: Variant): Variant;
    function IBQuery_PreparedGet(Instance: Pointer): Variant;
    procedure IBQuery_PreparedSet(Instance: Pointer; AValue: Variant);
    function IBQuery_QSelect(Instance: Pointer): Variant;
    function IBQuery_RowsAffected(Instance: Pointer): Variant;
    function IBQuery_StatementType(Instance: Pointer): Variant;
    function IBQuery_Text(Instance: Pointer): Variant;
    function IBQuery_UnPrepare(Instance: TObject; var Params: Variant): Variant;
    function IBSecurityService_AddUser(Instance: TObject; var Params: Variant
      ): Variant;
    function IBSecurityService_DeleteUser(Instance: TObject; var Params: Variant
      ): Variant;
    function IBSecurityService_DisplayUser(Instance: TObject;
      var Params: Variant): Variant;
    function IBSecurityService_DisplayUsers(Instance: TObject;
      var Params: Variant): Variant;
    function IBSecurityService_ModifyUser(Instance: TObject; var Params: Variant
      ): Variant;
    function IBSecurityService_UserInfo(Instance: TObject; var Params: Variant
      ): Variant;
    function IBSecurityService_UserInfoCount(Instance: Pointer): Variant;
    function IBSQLMonitor_Release(Instance: TObject; var Params: Variant
      ): Variant;
    function IBSQL_Base(Instance: Pointer): Variant;
    function IBSQL_BatchInput(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_BatchOutput(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_Bof(Instance: Pointer): Variant;
    function IBSQL_CheckClosed(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_CheckOpen(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_CheckValidStatement(Instance: TObject; var Params: Variant
      ): Variant;
    function IBSQL_Close(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_Current(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_Eof(Instance: Pointer): Variant;
    function IBSQL_ExecQuery(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_FieldByName(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_FieldCount(Instance: Pointer): Variant;
    function IBSQL_FieldIndex(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_Fields(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_FreeHandle(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_GenerateParamNamesGet(Instance: Pointer): Variant;
    procedure IBSQL_GenerateParamNamesSet(Instance: Pointer; AValue: Variant);
    function IBSQL_GetUniqueRelationName(Instance: TObject; var Params: Variant
      ): Variant;
    function IBSQL_Next(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_Open(Instance: Pointer): Variant;
    function IBSQL_ParamByName(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_Params(Instance: Pointer): Variant;
    function IBSQL_Plan(Instance: Pointer): Variant;
    function IBSQL_Prepare(Instance: TObject; var Params: Variant): Variant;
    function IBSQL_Prepared(Instance: Pointer): Variant;
    function IBSQL_RecordCount(Instance: Pointer): Variant;
    function IBSQL_RowsAffected(Instance: Pointer): Variant;
    function IBSQL_SQLType(Instance: Pointer): Variant;
    function IBSQL_UniqueRelationName(Instance: Pointer): Variant;
    function IBStoredProc_ExecProc(Instance: TObject; var Params: Variant
      ): Variant;
    function IBStoredProc_FindOutParam(Instance: TObject; var Params: Variant
      ): Variant;
    function IBStoredProc_OutParam(Instance: TObject; var Params: Variant
      ): Variant;
    function IBStoredProc_OutParamCount(Instance: Pointer): Variant;
    function IBStoredProc_ParamByName(Instance: TObject; var Params: Variant
      ): Variant;
    function IBStoredProc_ParamCount(Instance: Pointer): Variant;
    function IBStoredProc_Params(Instance: Pointer): Variant;
    function IBStoredProc_Prepare(Instance: TObject; var Params: Variant
      ): Variant;
    function IBStoredProc_PreparedGet(Instance: Pointer): Variant;
    procedure IBStoredProc_PreparedSet(Instance: Pointer; AValue: Variant);
    function IBStoredProc_StoredProcedureNames(Instance: Pointer): Variant;
    function IBStoredProc_UnPrepare(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTable_AddIndex(Instance: TObject; var Params: Variant): Variant;
    function IBTable_CreateTable(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTable_DeleteIndex(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTable_DeleteTable(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTable_EmptyTable(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTable_Exists(Instance: Pointer): Variant;
    function IBTable_GetDetailLinkFields(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTable_GetIndexNames(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTable_GotoCurrent(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTable_IndexFieldCount(Instance: Pointer): Variant;
    function IBTable_IndexFieldsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTable_IndexFieldsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTable_TableNames(Instance: Pointer): Variant;
    function IBTransaction_AddDatabase(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTransaction_CheckDatabasesInList(Instance: TObject;
      var Params: Variant): Variant;
    function IBTransaction_CheckInTransaction(Instance: TObject;
      var Params: Variant): Variant;
    function IBTransaction_CheckNotInTransaction(Instance: TObject;
      var Params: Variant): Variant;
    function IBTransaction_Commit(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTransaction_CommitRetaining(Instance: TObject;
      var Params: Variant): Variant;
    function IBTransaction_FindDatabase(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTransaction_FindDefaultDatabase(Instance: TObject;
      var Params: Variant): Variant;
    function IBTransaction_GetDatabase(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTransaction_GetDatabaseCount(Instance: Pointer): Variant;
    function IBTransaction_GetInTransaction(Instance: Pointer): Variant;
    function IBTransaction_GetSQLObject(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTransaction_GetSQLObjectCount(Instance: Pointer): Variant;
    function IBTransaction_HandleIsShared(Instance: Pointer): Variant;
    function IBTransaction_RemoveDatabase(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTransaction_RemoveDatabases(Instance: TObject;
      var Params: Variant): Variant;
    function IBTransaction_Rollback(Instance: TObject; var Params: Variant
      ): Variant;
    function IBTransaction_RollbackRetaining(Instance: TObject;
      var Params: Variant): Variant;
    function IBTransaction_StartTransaction(Instance: TObject;
      var Params: Variant): Variant;
    function IBUpdateSQL_DataSet(Instance: Pointer): Variant;
    function IBUpdateSQL_Query(Instance: TObject; var Params: Variant): Variant;
    function IBUpdateSQL_SQLGet(Instance: TObject; var Params: Variant
      ): Variant;
    function IBUpdateSQL_SQLSet(Instance: TObject; var Params: Variant
      ): Variant;
    function IBValidationService_FetchLimboTransactionInfo(Instance: TObject;
      var Params: Variant): Variant;
    function IBValidationService_FixLimboTransactionErrors(Instance: TObject;
      var Params: Variant): Variant;
    function IBValidationService_LimboTransactionInfo(Instance: TObject;
      var Params: Variant): Variant;
    function IBValidationService_LimboTransactionInfoCount(Instance: Pointer
      ): Variant;
    function IBXSQLDA_AddName(Instance: TObject; var Params: Variant): Variant;
    function IBXSQLDA_ByName(Instance: TObject; var Params: Variant): Variant;
    function IBXSQLDA_CountGet(Instance: Pointer): Variant;
    procedure IBXSQLDA_CountSet(Instance: Pointer; AValue: Variant);
    function IBXSQLDA_ModifiedGet(Instance: Pointer): Variant;
    function IBXSQLDA_NamesGet(Instance: Pointer): Variant;
    function IBXSQLDA_RecordSizeGet(Instance: Pointer): Variant;
    function IBXSQLDA_UniqueRelationNameGet(Instance: Pointer): Variant;
    function IBXSQLDA_Vars(Instance: TObject; var Params: Variant): Variant;
    function IBXSQLVAR_AsBooleanGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsBooleanSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_AsCurrencyGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsCurrencySet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_AsDateGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsDateSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_AsDateTimeGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsDateTimeSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_AsDoubleGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsDoubleSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_AsFloatGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsFloatSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_AsInt64Get(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsInt64Set(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_AsIntegerGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsIntegerSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_AsLongGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsLongSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_AsShortGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsShortSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_Assign(Instance: TObject; var Params: Variant): Variant;
    function IBXSQLVAR_AsStringGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsStringSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_AsTimeGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsTimeSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_AsVariantGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_AsVariantSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_Clear(Instance: TObject; var Params: Variant): Variant;
    function IBXSQLVAR_IndexGet(Instance: Pointer): Variant;
    function IBXSQLVAR_IsNullableGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_IsNullableSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_IsNullGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_IsNullSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_LoadFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function IBXSQLVAR_LoadFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function IBXSQLVAR_ModifiedGet(Instance: Pointer): Variant;
    procedure IBXSQLVAR_ModifiedSet(Instance: Pointer; AValue: Variant);
    function IBXSQLVAR_NameGet(Instance: Pointer): Variant;
    function IBXSQLVAR_SaveToFile(Instance: TObject; var Params: Variant
      ): Variant;
    function IBXSQLVAR_SaveToStream(Instance: TObject; var Params: Variant
      ): Variant;
    function IBXSQLVAR_SizeGet(Instance: Pointer): Variant;
    function IBXSQLVAR_SQLTypeGet(Instance: Pointer): Variant;
    function LimboTransactionInfo_ActionGet(Instance: Pointer): Variant;
    procedure LimboTransactionInfo_ActionSet(Instance: Pointer; AValue: Variant
      );
    function LimboTransactionInfo_AdviseGet(Instance: Pointer): Variant;
    procedure LimboTransactionInfo_AdviseSet(Instance: Pointer; AValue: Variant
      );
    function LimboTransactionInfo_HostSiteGet(Instance: Pointer): Variant;
    procedure LimboTransactionInfo_HostSiteSet(Instance: Pointer;
      AValue: Variant);
    function LimboTransactionInfo_IDGet(Instance: Pointer): Variant;
    procedure LimboTransactionInfo_IDSet(Instance: Pointer; AValue: Variant);
    function LimboTransactionInfo_MultiDatabaseGet(Instance: Pointer): Variant;
    procedure LimboTransactionInfo_MultiDatabaseSet(Instance: Pointer;
      AValue: Variant);
    function LimboTransactionInfo_RemoteDatabasePathGet(Instance: Pointer
      ): Variant;
    procedure LimboTransactionInfo_RemoteDatabasePathSet(Instance: Pointer;
      AValue: Variant);
    function LimboTransactionInfo_RemoteSiteGet(Instance: Pointer): Variant;
    procedure LimboTransactionInfo_RemoteSiteSet(Instance: Pointer;
      AValue: Variant);
    function LimboTransactionInfo_StateGet(Instance: Pointer): Variant;
    procedure LimboTransactionInfo_StateSet(Instance: Pointer; AValue: Variant);
    function UserInfo_FirstNameGet(Instance: Pointer): Variant;
    procedure UserInfo_FirstNameSet(Instance: Pointer; AValue: Variant);
    function UserInfo_GroupIDGet(Instance: Pointer): Variant;
    procedure UserInfo_GroupIDSet(Instance: Pointer; AValue: Variant);
    function UserInfo_LastNameGet(Instance: Pointer): Variant;
    procedure UserInfo_LastNameSet(Instance: Pointer; AValue: Variant);
    function UserInfo_MiddleNameGet(Instance: Pointer): Variant;
    procedure UserInfo_MiddleNameSet(Instance: Pointer; AValue: Variant);
    function UserInfo_UserIDGet(Instance: Pointer): Variant;
    procedure UserInfo_UserIDSet(Instance: Pointer; AValue: Variant);
    function UserInfo_UserNameGet(Instance: Pointer): Variant;
    procedure UserInfo_UserNameSet(Instance: Pointer; AValue: Variant);

    function IBSQLMinitor_EnableMonitoring(Instance: TObject; var Params: Variant
      ): Variant;
    function IBSQLMinitor_DisableMonitoring(Instance: TObject; var Params: Variant
      ): Variant;
    function IBSQLMinitor_MonitoringEnabled(Instance: TObject; var Params: Variant
      ): Variant;
    function IBError_SetIBDataBaseErrorMessages(Instance: TObject; var Params: Variant
      ): Variant;
  private
    function IBSQL_Handle(Instance: Pointer): Variant;
  public
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
      override;
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
    procedure AddMethods(AddMethod: TAddMethodProc); override;
  end;

implementation

uses
  IBQuery, IBCustomDataSet, IBDatabase, IBSQL, IBStoredProc, IBUpdateSQL,
  IBEvents, IBDatabaseInfo, IBSQLMonitor, IBBatchMove, IBTable, IBExtract,
  IBServices, db, IB, IBBlob;

type

   { TIBDatabaseLoginEventHandler }

   TIBDatabaseLoginEventHandler = class(TDpEventHandler)
   public
     function GetHandlerAdres: Pointer; override;
     procedure CallHandler(Database: TIBDatabase; LoginParams: TStrings);
   end;

   { TLoginEventHandler }

   TLoginEventHandler = class(TDpEventHandler)
   public
     function GetHandlerAdres: Pointer; override;
     procedure CallHandler(Database: TIBCustomService; LoginParams: TStrings);
   end;

   { TSQLEventHandler }

   TSQLEventHandler = class(TDpEventHandler)
   public
     function GetHandlerAdres: Pointer; override;
     procedure CallHandler(EventText: String; EventTime: TDateTime);
   end;

   { TEventAlertHandler }

   TEventAlertHandler = class(TDpEventHandler)
   public
     function GetHandlerAdres: Pointer; override;
     procedure CallHandler(Sender: TObject; EventName: string; EventCount: longint; var CancelAlerts: Boolean);
   end;

   { TIBUpdateErrorEventHandler }

   TIBUpdateErrorEventHandler = class(TDpEventHandler)
   public
     function GetHandlerAdres: Pointer; override;
     procedure CallHandler(DataSet: TDataSet; E: EDatabaseError; UpdateKind: TUpdateKind; var UpdateAction: TIBUpdateAction);
   end;

   { TIBUpdateRecordEventHandler }

   TIBUpdateRecordEventHandler = class(TDpEventHandler)
   public
     function GetHandlerAdres: Pointer; override;
     procedure CallHandler(DataSet: TDataSet; UpdateKind: TUpdateKind; var UpdateAction: TIBUpdateAction);
   end;

{ TIBUpdateRecordEvent }

function TIBUpdateRecordEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TIBUpdateRecordEventHandler.CallHandler;
end;

procedure TIBUpdateRecordEventHandler.CallHandler(DataSet: TDataSet;
  UpdateKind: TUpdateKind; var UpdateAction: TIBUpdateAction);
begin
  Proc.Param[0].Value := TSuPtr(DataSet);
  Proc.Param[1].Value := UpdateKind;
  Proc.Param[2].Value := UpdateAction;
  Proc.Exec;
  UpdateAction := Proc.Param[2].Value;
end;

{ TIBUpdateErrorEventHandler }

function TIBUpdateErrorEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TIBUpdateErrorEventHandler.CallHandler;
end;

procedure TIBUpdateErrorEventHandler.CallHandler(DataSet: TDataSet;
  E: EDatabaseError; UpdateKind: TUpdateKind; var UpdateAction: TIBUpdateAction
  );
begin
  Proc.Param[0].Value := TSuPtr(DataSet);
  Proc.Param[1].Value := TSuPtr(E);
  Proc.Param[2].Value := UpdateKind;
  Proc.Param[3].Value := UpdateAction;
  Proc.Exec;
  UpdateAction:= Proc.Param[3].Value;
end;

{ TEventAlertHandler }

function TEventAlertHandler.GetHandlerAdres: Pointer;
begin
  Result := @TEventAlertHandler.CallHandler;
end;

procedure TEventAlertHandler.CallHandler(Sender: TObject; EventName: string;
  EventCount: longint; var CancelAlerts: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := EventName;
  Proc.Param[2].Value := EventCount;
  Proc.Param[3].Value := CancelAlerts;
  Proc.Exec;
  CancelAlerts := Proc.Param[3].Value;
end;

{ TSQLEventHandler }

function TSQLEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TSQLEventHandler.CallHandler;
end;

procedure TSQLEventHandler.CallHandler(EventText: String; EventTime: TDateTime);
begin
  Proc.Param[0].Value := EventText;
  Proc.Param[1].Value := EventTime;
  Proc.Exec;
end;

{ TLoginEventHandler }

function TLoginEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TLoginEventHandler.CallHandler;
end;

procedure TLoginEventHandler.CallHandler(Database: TIBCustomService;
  LoginParams: TStrings);
begin
  Proc.Param[0].Value := TSuPtr(Database);
  Proc.Param[1].Value := TSuPtr(LoginParams);
  Proc.Exec;
end;

{ TIBDatabaseLoginEventHandler }

function TIBDatabaseLoginEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TIBDatabaseLoginEventHandler.CallHandler;
end;

procedure TIBDatabaseLoginEventHandler.CallHandler(Database: TIBDatabase;
  LoginParams: TStrings);
begin
  Proc.Param[0].Value := TSuPtr(Database);
  Proc.Param[1].Value := TSuPtr(LoginParams);
  Proc.Exec;
end;

{ TIBXImport }

function TIBXImport.IBBase_CheckDatabase(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBBase(Instance).CheckDatabase;
end;

function TIBXImport.IBBase_CheckTransaction(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBBase(Instance).CheckTransaction;
end;

function TIBXImport.IBBase_DatabaseGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBBase(Instance).Database );
end;

procedure TIBXImport.IBBase_DatabaseSet(Instance: Pointer; AValue: Variant);
begin
  TIBBase(Instance).Database := TIBDataBase(TSuPtr(AValue));
end;

function TIBXImport.IBBase_Owner(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TIBBase(Instance).Owner);
end;

function TIBXImport.IBBase_TransactionGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBBase(Instance).Transaction );
end;

procedure TIBXImport.IBBase_TransactionSet(Instance: Pointer; AValue: Variant);
begin
  TIBBase(Instance).Transaction := TIBTransaction(TSuPtr(AValue));
end;

function TIBXImport.IBBatchInput_ReadParameters(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBBatchInput(Instance).ReadParameters;
end;

function TIBXImport.IBBatchMove_ChangedCount(Instance: Pointer): Variant;
begin
  Result := TIBBatchMove(Instance).ChangedCount;
end;

function TIBXImport.IBBatchMove_Execute(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBBatchMove(Instance).Execute;
end;

function TIBXImport.IBBatchMove_KeyViolCount(Instance: Pointer): Variant;
begin
  Result := TIBBatchMove(Instance).KeyViolCount;
end;

function TIBXImport.IBBatchMove_MovedCount(Instance: Pointer): Variant;
begin
  Result := TIBBatchMove(Instance).MovedCount;
end;

function TIBXImport.IBBatchMove_ProblemCount(Instance: Pointer): Variant;
begin
  Result := TIBBatchMove(Instance).ProblemCount;
end;

function TIBXImport.IBBatchOutput_WriteColumns(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBBatchOutput(Instance).WriteColumns;
end;

function TIBXImport.IBBatch_Columns(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBBatch(Instance).Columns );
end;

function TIBXImport.IBBatch_FilenameGet(Instance: Pointer): Variant;
begin
  Result := TIBBatch(Instance).Filename;
end;

procedure TIBXImport.IBBatch_FilenameSet(Instance: Pointer; AValue: Variant);
begin
  TIBBatch(Instance).Filename := AValue;
end;

function TIBXImport.IBBatch_Params(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBBatch(Instance).Params );
end;

function TIBXImport.IBBatch_ReadyFile(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBBatch(Instance).ReadyFile;
end;

function TIBXImport.IBBlobStream_CheckReadable(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBBlobStream(Instance).CheckReadable;
end;

function TIBXImport.IBBlobStream_CheckWritable(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBBlobStream(Instance).CheckWritable;
end;

function TIBXImport.IBBlobStream_DatabaseGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBBlobStream(Instance).Database );
end;

procedure TIBXImport.IBBlobStream_DatabaseSet(Instance: Pointer; AValue: Variant
  );
begin
  TIBBlobStream(Instance).Database := TIBDataBase( TSuPtr(AValue) );
end;

function TIBXImport.IBBlobStream_Finalize(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBBlobStream(Instance).Finalize(False);
end;

function TIBXImport.IBBlobStream_LoadFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBBlobStream(Instance).LoadFromFile(Params[0]);
end;

function TIBXImport.IBBlobStream_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBBlobStream(Instance).LoadFromStream(TStream( TSuPtr(Params[0]) ));
end;

function TIBXImport.IBBlobStream_ModeGet(Instance: Pointer): Variant;
begin
  Result := TIBBlobStream(Instance).Mode;
end;

procedure TIBXImport.IBBlobStream_ModeSet(Instance: Pointer; AValue: Variant);
begin
  TIBBlobStream(Instance).Mode := AValue;
end;

function TIBXImport.IBBlobStream_ModifiedGet(Instance: Pointer): Variant;
begin
  Result := TIBBlobStream(Instance).Modified;
end;

function TIBXImport.IBBlobStream_SaveToFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBBlobStream(Instance).SaveToFile(Params[0]);
end;

function TIBXImport.IBBlobStream_SaveToStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBBlobStream(Instance).SaveToStream(TStream( TSuPtr(Params[0]) ));
end;

function TIBXImport.IBBlobStream_Truncate(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBBlobStream(Instance).Truncate;
end;

function TIBXImport.IBConfigService_ActivateShadow(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBConfigService(Instance).ActivateShadow;
end;

function TIBXImport.IBConfigService_BringDatabaseOnline(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBConfigService(Instance).BringDatabaseOnline;
end;

function TIBXImport.IBConfigService_SetAsyncMode(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBConfigService(Instance).SetAsyncMode(Params[0]);
end;

function TIBXImport.IBConfigService_SetDBSqlDialect(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBConfigService(Instance).SetDBSqlDialect(Params[0]);
end;

function TIBXImport.IBConfigService_SetPageBuffers(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBConfigService(Instance).SetPageBuffers(Params[0]);
end;

function TIBXImport.IBConfigService_SetReadOnly(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBConfigService(Instance).SetReadOnly(Params[0]);
end;

function TIBXImport.IBConfigService_SetReserveSpace(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBConfigService(Instance).SetReserveSpace(Params[0]);
end;

function TIBXImport.IBConfigService_SetSweepInterval(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBConfigService(Instance).SetSweepInterval(Params[0]);
end;

function TIBXImport.IBConfigService_ShutdownDatabase(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBConfigService(Instance).ShutdownDatabase(Params[0], Params[1]);
end;

function TIBXImport.IBControlAndQueryService_Eof(Instance: Pointer): Variant;
begin
  Result := TIBControlAndQueryService(Instance).Eof;
end;

function TIBXImport.IBControlAndQueryService_GetNextChunk(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBControlAndQueryService(Instance).GetNextChunk;
end;

function TIBXImport.IBControlAndQueryService_GetNextLine(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBControlAndQueryService(Instance).GetNextLine;
end;

function TIBXImport.IBControlService_IsServiceRunning(Instance: Pointer
  ): Variant;
begin
  Result := TIBControlService(Instance).IsServiceRunning;
end;

function TIBXImport.IBControlService_ServiceStart(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBControlService(Instance).ServiceStart;
end;

function TIBXImport.IBCustomDataSet_ApplyUpdates(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBCustomDataSet(Instance).ApplyUpdates;
end;

function TIBXImport.IBCustomDataSet_CachedUpdateStatus(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBCustomDataSet(Instance).CachedUpdateStatus;
end;

function TIBXImport.IBCustomDataSet_CancelUpdates(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBCustomDataSet(Instance).CancelUpdates;
end;

function TIBXImport.IBCustomDataSet_FetchAll(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBCustomDataSet(Instance).FetchAll;
end;

function TIBXImport.IBCustomDataSet_FullRefresh(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBCustomDataSet(Instance).FullRefresh;
end;

type
  PLocateOptions = ^TLocateOptions;

function TIBXImport.IBCustomDataSet_LocateNext(Instance: TObject;
  var Params: Variant): Variant;
var
  L: TLocateOptions;
  S: PLocateOptions;
begin
  L := [];
  S := PLocateOptions(TSuPtr(Params[2]));
  L := S^;
  Result := TIBCustomDataSet(Instance).LocateNext(Params[0], Params[1], L);
end;

function TIBXImport.IBCustomDataSet_RefreshVisibleRows(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBCustomDataSet(Instance).RefreshVisibleRows;
end;

function TIBXImport.IBCustomService_Attach(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBCustomService(Instance).Attach;
end;

function TIBXImport.IBCustomService_Detach(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBCustomService(Instance).Detach;
end;

function TIBXImport.IBCustomService_ServiceParamBySPBGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBCustomService(Instance).ServiceParamBySPB[Params[0]];
end;

function TIBXImport.IBCustomService_ServiceParamBySPBSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBCustomService(Instance).ServiceParamBySPB[Params[0]] := Params[1];
end;

function TIBXImport.IBDatabaseInfo_Allocation(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).Allocation;
end;

function TIBXImport.IBDatabaseInfo_BackoutCount(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDatabaseInfo(Instance).BackoutCount );
end;

function TIBXImport.IBDatabaseInfo_BaseLevel(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).BaseLevel;
end;

function TIBXImport.IBDatabaseInfo_CurrentMemory(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).CurrentMemory;
end;

function TIBXImport.IBDatabaseInfo_DBFileName(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).DBFileName;
end;

function TIBXImport.IBDatabaseInfo_DBImplementationClass(Instance: Pointer
  ): Variant;
begin
  Result := TIBDatabaseInfo(Instance).DBImplementationClass;
end;

function TIBXImport.IBDatabaseInfo_DBImplementationNo(Instance: Pointer
  ): Variant;
begin
  Result := TIBDatabaseInfo(Instance).DBImplementationNo;
end;

function TIBXImport.IBDatabaseInfo_DBSiteName(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).DBSiteName;
end;

function TIBXImport.IBDatabaseInfo_DBSQLDialect(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).DBSQLDialect;
end;

function TIBXImport.IBDatabaseInfo_DeleteCount(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDatabaseInfo(Instance).DeleteCount );
end;

function TIBXImport.IBDatabaseInfo_ExpungeCount(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDatabaseInfo(Instance).ExpungeCount );
end;

function TIBXImport.IBDatabaseInfo_Fetches(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).Fetches;
end;

function TIBXImport.IBDatabaseInfo_ForcedWrites(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).ForcedWrites;
end;

function TIBXImport.IBDatabaseInfo_InsertCount(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDatabaseInfo(Instance).InsertCount );
end;

function TIBXImport.IBDatabaseInfo_Marks(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).Marks;
end;

function TIBXImport.IBDatabaseInfo_MaxMemory(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).MaxMemory;
end;

function TIBXImport.IBDatabaseInfo_NoReserve(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).NoReserve;
end;

function TIBXImport.IBDatabaseInfo_NumBuffers(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).NumBuffers;
end;

function TIBXImport.IBDatabaseInfo_ODSMajorVersion(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).ODSMajorVersion;
end;

function TIBXImport.IBDatabaseInfo_ODSMinorVersion(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).ODSMinorVersion;
end;

function TIBXImport.IBDatabaseInfo_PageSize(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).PageSize;
end;

function TIBXImport.IBDatabaseInfo_PurgeCount(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDatabaseInfo(Instance).PurgeCount );
end;

function TIBXImport.IBDatabaseInfo_ReadIdxCount(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDatabaseInfo(Instance).ReadIdxCount );
end;

function TIBXImport.IBDatabaseInfo_ReadOnly(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).ReadOnly;
end;

function TIBXImport.IBDatabaseInfo_Reads(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).Reads;
end;

function TIBXImport.IBDatabaseInfo_ReadSeqCount(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDatabaseInfo(Instance).ReadSeqCount );
end;

function TIBXImport.IBDatabaseInfo_SweepInterval(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).SweepInterval;
end;

function TIBXImport.IBDatabaseInfo_UpdateCount(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDatabaseInfo(Instance).UpdateCount );
end;

function TIBXImport.IBDatabaseInfo_UserNames(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDatabaseInfo(Instance).UserNames );
end;

function TIBXImport.IBDatabaseInfo_Version(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).Version;
end;

function TIBXImport.IBDatabaseInfo_Writes(Instance: Pointer): Variant;
begin
  Result := TIBDatabaseInfo(Instance).Writes;
end;

function TIBXImport.IBDataBase_GenID(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TIBDataBase(Instance).GenID(Params[0], Params[1]);
end;

function TIBXImport.IBDataSet_FindParam(Instance: TObject; var Params: Variant
  ): Variant;
var
  P: TIBXSQLVAR;
begin
  P := TIBDataSet(Instance).FindParam(Params[0]);
  Result := TSuPtr( P );
end;

function TIBXImport.IBDataSet_OrderFieldsGet(Instance: Pointer): Variant;
begin
  Result := TIBCustomDataSet(Instance).OrderFields;
end;

procedure TIBXImport.IBDataSet_OrderFieldsSet(Instance: Pointer; AValue: Variant
  );
begin
  TIBCustomDataSet(Instance).OrderFields := AValue;
end;

function TIBXImport.IBDataSet_ParamByName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TIBCustomDataSet(Instance).ParamByName(Params[0]));
end;

function TIBXImport.IBCustomDataSet_RecordModified(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBCustomDataSet(Instance).RecordModified(Params[0]);
end;

function TIBXImport.IBCustomDataSet_RevertRecord(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBCustomDataSet(Instance).RevertRecord;
end;

function TIBXImport.IBCustomDataSet_Undelete(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBCustomDataSet(Instance).Undelete;
end;

function TIBXImport.IBDataBase_AddTransaction(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBDataBase(Instance).AddTransaction(TIBTransaction(TSuPtr(Params[0])));
end;

function TIBXImport.IBDataBase_CheckActive(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBDataBase(Instance).CheckActive;
end;

function TIBXImport.IBDataBase_CheckDatabaseName(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBDataBase(Instance).CheckDatabaseName;
end;

function TIBXImport.IBDataBase_CheckInactive(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBDataBase(Instance).CheckInactive;
end;

function TIBXImport.IBDataBase_CloseDataSets(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBDataBase(Instance).CloseDataSets;
end;

function TIBXImport.IBDataBase_CreateDatabase(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBDataBase(Instance).CreateDatabase;
end;

function TIBXImport.IBDataBase_DropDatabase(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBDataBase(Instance).DropDatabase;
end;

function TIBXImport.IBDataBase_FindDefaultTransaction(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBDataBase(Instance).FindDefaultTransaction );
end;

function TIBXImport.IBDataBase_FindTransaction(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBDataBase(Instance).FindTransaction(TIBTransaction(TSuPtr(Params[0])));
end;

function TIBXImport.IBDataBase_ForceClose(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBDataBase(Instance).ForceClose;
end;

function TIBXImport.IBDataBase_GetFieldNames(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBDataBase(Instance).GetFieldNames(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TIBXImport.IBDataBase_GetTableNames(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBDataBase(Instance).GetTableNames(TStrings(TSuPtr(Params[0])), Params[1]);
end;

function TIBXImport.IBDataBase_HandleIsSharedGet(Instance: Pointer): Variant;
begin
  Result := TIBDataBase(Instance).HandleIsShared;
end;

function TIBXImport.IBDataBase_IndexOfDBConst(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBDataBase(Instance).IndexOfDBConst(Params[0]);
end;

function TIBXImport.IBDataBase_InternalTransactionGet(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( TIBDataBase(Instance).InternalTransaction );
end;

function TIBXImport.IBDataBase_IsReadOnlyGet(Instance: Pointer): Variant;
begin
  Result := TIBDataBase(Instance).IsReadOnly;
end;

function TIBXImport.IBDataBase_RemoveTransaction(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBDataBase(Instance).RemoveTransaction(Params[0]);
end;

function TIBXImport.IBDataBase_RemoveTransactions(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBDataBase(Instance).RemoveTransactions;
end;

function TIBXImport.IBDataBase_SQLObjectCountGet(Instance: Pointer): Variant;
begin
  Result := TIBDataBase(Instance).SQLObjectCount;
end;

function TIBXImport.IBDataBase_SQLObjectsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBDataBase(Instance).SQLObjects[Params[0]] );
end;

function TIBXImport.IBDataBase_TestConnected(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBDataBase(Instance).TestConnected;
end;

function TIBXImport.IBDataBase_TransactionCountGet(Instance: Pointer): Variant;
begin
  Result := TIBDataBase(Instance).TransactionCount;
end;

function TIBXImport.IBDataBase_TransactionsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBDataBase(Instance).Transactions[Params[0]] );
end;

function TIBXImport.IBDataSet_BatchInput(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBDataSet(Instance).BatchInput(TIBBatchInput(TSuPtr(Params[0])));
end;

function TIBXImport.IBDataSet_BatchOutput(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBDataSet(Instance).BatchOutput(TIBBatchOutput(TSuPtr(Params[0])));
end;

function TIBXImport.IBDataSet_ExecSQL(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBDataSet(Instance).ExecSQL;
end;

function TIBXImport.IBDataSet_Params(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TIBDataSet(Instance).Params);
end;

function TIBXImport.IBDataSet_Prepare(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBDataSet(Instance).Prepare;
end;

function TIBXImport.IBDataSet_QDelete(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDataSet(Instance).QSelect );
end;

function TIBXImport.IBDataSet_QInsert(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDataSet(Instance).QInsert );
end;

function TIBXImport.IBDataSet_QModify(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDataSet(Instance).QModify );
end;

function TIBXImport.IBDataSet_QRefresh(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDataSet(Instance).QRefresh );
end;

function TIBXImport.IBDataSet_QSelect(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBDataSet(Instance).QSelect );
end;

function TIBXImport.IBDataSet_StatementType(Instance: Pointer): Variant;
begin
  Result := TIBDataSet(Instance).StatementType;
end;

function TIBXImport.IBDataSet_UnPrepare(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBDataSet(Instance).UnPrepare;
end;

function TIBXImport.IBEvents_DeferredRegisterGet(Instance: Pointer): Variant;
begin
  Result := TIBEvents(Instance).DeferredRegister;
end;

procedure TIBXImport.IBEvents_DeferredRegisterSet(Instance: Pointer;
  AValue: Variant);
begin
  TIBEvents(Instance).DeferredRegister := AValue;
end;

function TIBXImport.IBEvents_RegisterEvents(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBEvents(Instance).RegisterEvents;
end;

function TIBXImport.IBEvents_UnRegisterEvents(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBEvents(Instance).UnRegisterEvents;
end;

type
  PExtractTypes = ^TExtractTypes;

function TIBXImport.IBExtract_ExtractObject(Instance: TObject;
  var Params: Variant): Variant;
var
  ExtTp: PExtractTypes;
begin
  ExtTp:= PExtractTypes(TSuPtr(Params[2]));
  TIBExtract(Instance).ExtractObject(Params[0], Params[1], ExtTp^);
end;

function TIBXImport.IBExtract_GetArrayField(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBExtract(Instance).GetArrayField(Params[0]);
end;

function TIBXImport.IBExtract_GetCharacterSets(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBExtract(Instance).GetCharacterSets(Params[0], Params[1], Params[2]);
end;

function TIBXImport.IBExtract_GetFieldType(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBExtract(Instance).GetFieldType(Params[0], Params[1], Params[2], Params[3], Params[4], Params[5]);
end;

function TIBXImport.IBInputDelimitedFile_ColDelimiterGet(Instance: Pointer
  ): Variant;
begin
  Result := TIBInputDelimitedFile(Instance).ColDelimiter;
end;

procedure TIBXImport.IBInputDelimitedFile_ColDelimiterSet(Instance: Pointer;
  AValue: Variant);
begin
  TIBInputDelimitedFile(Instance).ColDelimiter := AValue;
end;

function TIBXImport.IBInputDelimitedFile_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBInputDelimitedFile.Create );
end;

function TIBXImport.IBInputDelimitedFile_GetColumn(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := TIBInputDelimitedFile(Instance).GetColumn(S);
  Params[0] := S;
end;

function TIBXImport.IBInputDelimitedFile_ReadBlanksAsNullGet(Instance: Pointer
  ): Variant;
begin
  Result := TIBInputDelimitedFile(Instance).ReadBlanksAsNull;
end;

procedure TIBXImport.IBInputDelimitedFile_ReadBlanksAsNullSet(
  Instance: Pointer; AValue: Variant);
begin
  TIBInputDelimitedFile(Instance).ReadBlanksAsNull:= AValue;
end;

function TIBXImport.IBInputDelimitedFile_RowDelimiterGet(Instance: Pointer
  ): Variant;
begin
  Result := TIBInputDelimitedFile(Instance).RowDelimiter;
end;

procedure TIBXImport.IBInputDelimitedFile_RowDelimiterSet(Instance: Pointer;
  AValue: Variant);
begin
  TIBInputDelimitedFile(Instance).RowDelimiter := AValue;
end;

function TIBXImport.IBInputDelimitedFile_SkipTitlesGet(Instance: Pointer
  ): Variant;
begin
  Result := TIBInputDelimitedFile(Instance).SkipTitles;
end;

procedure TIBXImport.IBInputDelimitedFile_SkipTitlesSet(Instance: Pointer;
  AValue: Variant);
begin
  TIBInputDelimitedFile(Instance).SkipTitles := AValue;
end;

function TIBXImport.IBOutputDelimitedFile_ColDelimiterGet(Instance: Pointer
  ): Variant;
begin
  Result := TIBOutputDelimitedFile(Instance).ColDelimiter;
end;

procedure TIBXImport.IBOutputDelimitedFile_ColDelimiterSet(Instance: Pointer;
  AValue: Variant);
begin
  TIBOutputDelimitedFile(Instance).ColDelimiter := AValue;
end;

function TIBXImport.IBOutputDelimitedFile_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TIBOutputDelimitedFile.Create);
end;

function TIBXImport.IBOutputDelimitedFile_OutputTitlesGet(Instance: Pointer
  ): Variant;
begin
  Result := TIBOutputDelimitedFile(Instance).OutputTitles;
end;

procedure TIBXImport.IBOutputDelimitedFile_OutputTitlesSet(Instance: Pointer;
  AValue: Variant);
begin
  TIBOutputDelimitedFile(Instance).OutputTitles := AValue;
end;

function TIBXImport.IBOutputDelimitedFile_RowDelimiterGet(Instance: Pointer
  ): Variant;
begin
  Result := TIBOutputDelimitedFile(Instance).RowDelimiter;
end;

procedure TIBXImport.IBOutputDelimitedFile_RowDelimiterSet(Instance: Pointer;
  AValue: Variant);
begin
  TIBOutputDelimitedFile(Instance).RowDelimiter := AValue;
end;

function TIBXImport.IBQuery_BatchInput(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBQuery(Instance).BatchInput(TIBBatchInput(TSuPtr(Params[0])));
end;

function TIBXImport.IBQuery_BatchOutput(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBQuery(Instance).BatchOutput(TIBBatchOutput(TSuPtr(Params[0])));
end;

function TIBXImport.IBQuery_ExecSQL(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBQuery(Instance).ExecSQL;
end;

function TIBXImport.IBQuery_FindParam(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TIBQuery(Instance).FindParam( Params[0]) );
end;

function TIBXImport.IBQuery_GenerateParamNamesGet(Instance: Pointer): Variant;
begin
  Result := TIBQuery(Instance).GenerateParamNames;
end;

procedure TIBXImport.IBQuery_GenerateParamNamesSet(Instance: Pointer;
  AValue: Variant);
begin
  TIBQuery(Instance).GenerateParamNames := AValue;
end;

function TIBXImport.IBQuery_GetParamsCount(Instance: Pointer): Variant;
begin
  Result := TIBQuery(Instance).ParamCount;
end;

function TIBXImport.IBQuery_OutParamByName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBQuery(Instance).OutParamByName(Params[0]) );
end;

function TIBXImport.IBQuery_OutParamCount(Instance: Pointer): Variant;
begin
  Result := TIBQuery(Instance).OutParamCount;
end;

function TIBXImport.IBQuery_OutParams(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBQuery(Instance).OutParams );
end;

function TIBXImport.IBQuery_ParamByName(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TIBQuery(Instance).ParamByName(Params[0]) );
end;

function TIBXImport.IBQuery_Prepare(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBQuery(Instance).Prepare;
end;

function TIBXImport.IBQuery_PreparedGet(Instance: Pointer): Variant;
begin
  Result := TIBQuery(Instance).Prepared;
end;

procedure TIBXImport.IBQuery_PreparedSet(Instance: Pointer; AValue: Variant);
begin
  TIBQuery(Instance).Prepared := AValue;
end;

function TIBXImport.IBQuery_QSelect(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TIBQuery(Instance).QSelect);
end;

function TIBXImport.IBQuery_RowsAffected(Instance: Pointer): Variant;
begin
  Result := TIBQuery(Instance).RowsAffected;
end;

function TIBXImport.IBQuery_StatementType(Instance: Pointer): Variant;
begin
  Result := TIBQuery(Instance).StatementType;
end;

function TIBXImport.IBQuery_Text(Instance: Pointer): Variant;
begin
  Result := TIBQuery(Instance).Text;
end;

function TIBXImport.IBQuery_UnPrepare(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBQuery(Instance).UnPrepare;
end;

function TIBXImport.IBSecurityService_AddUser(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBSecurityService(Instance).AddUser;
end;

function TIBXImport.IBSecurityService_DeleteUser(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBSecurityService(Instance).DeleteUser;
end;

function TIBXImport.IBSecurityService_DisplayUser(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBSecurityService(Instance).DisplayUser(Params[0]);
end;

function TIBXImport.IBSecurityService_DisplayUsers(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBSecurityService(Instance).DisplayUsers;
end;

function TIBXImport.IBSecurityService_ModifyUser(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBSecurityService(Instance).ModifyUser;
end;

function TIBXImport.IBSecurityService_UserInfo(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBSecurityService(Instance).UserInfo[Params[0]] );
end;

function TIBXImport.IBSecurityService_UserInfoCount(Instance: Pointer): Variant;
begin
  Result := TIBSecurityService(Instance).UserInfoCount;
end;

function TIBXImport.IBSQLMonitor_Release(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBSQLMonitor(Instance).Release;
end;

function TIBXImport.IBSQL_Base(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBSQL(Instance).Base );
end;

function TIBXImport.IBSQL_BatchInput(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBSQL(Instance).BatchInput(TIBBatchInput(TSuPtr(Params[0])));
end;

function TIBXImport.IBSQL_BatchOutput(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBSQL(Instance).BatchOutput(TIBBatchOutput(TSuPtr(Params[0])));
end;

function TIBXImport.IBSQL_Bof(Instance: Pointer): Variant;
begin
  Result := TIBSQL(Instance).Bof;
end;

function TIBXImport.IBSQL_CheckClosed(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBSQL(Instance).CheckClosed;
end;

function TIBXImport.IBSQL_CheckOpen(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBSQL(Instance).CheckOpen;
end;

function TIBXImport.IBSQL_CheckValidStatement(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBSQL(Instance).CheckValidStatement;
end;

function TIBXImport.IBSQL_Close(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBSQL(Instance).Close;
end;

function TIBXImport.IBSQL_Current(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TIBSQL(Instance).Current );
end;

function TIBXImport.IBSQL_Eof(Instance: Pointer): Variant;
begin
  Result := TIBSQL(Instance).Eof;
end;

function TIBXImport.IBSQL_ExecQuery(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBSQL(Instance).ExecQuery;
end;

function TIBXImport.IBSQL_FieldByName(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TIBSQL(Instance).FieldByName(Params[0]) );
end;

function TIBXImport.IBSQL_FieldCount(Instance: Pointer): Variant;
begin
  Result := TIBSQL(Instance).FieldCount;
end;

function TIBXImport.IBSQL_FieldIndex(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TIBSQL(Instance).FieldIndex[Params[0]];
end;

function TIBXImport.IBSQL_Fields(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TIBSQL(Instance).Fields[Params[0]] );
end;

function TIBXImport.IBSQL_FreeHandle(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBSQL(Instance).FreeHandle;
end;

function TIBXImport.IBSQL_GenerateParamNamesGet(Instance: Pointer): Variant;
begin
  Result := TIBSQL(Instance).GenerateParamNames;
end;

procedure TIBXImport.IBSQL_GenerateParamNamesSet(Instance: Pointer;
  AValue: Variant);
begin
  TIBSQL(Instance).GenerateParamNames := AValue;
end;

function TIBXImport.IBSQL_GetUniqueRelationName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBSQL(Instance).GetUniqueRelationName;
end;

function TIBXImport.IBSQL_Next(Instance: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBSQL(Instance).Next );
end;

function TIBXImport.IBSQL_Open(Instance: Pointer): Variant;
begin
  Result := TIBSQL(Instance).Open;
end;

function TIBXImport.IBSQL_ParamByName(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TIBSQL(Instance).ParamByName(Params[0]) );
end;

function TIBXImport.IBSQL_Params(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBSQL(Instance).Params );
end;

function TIBXImport.IBSQL_Plan(Instance: Pointer): Variant;
begin
  Result := TIBSQL(Instance).Plan;
end;

function TIBXImport.IBSQL_Prepare(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBSQL(Instance).Prepare;
end;

function TIBXImport.IBSQL_Prepared(Instance: Pointer): Variant;
begin
  Result := TIBSQL(Instance).Prepared;
end;

function TIBXImport.IBSQL_RecordCount(Instance: Pointer): Variant;
begin
  Result := TIBSQL(Instance).RecordCount;
end;

function TIBXImport.IBSQL_RowsAffected(Instance: Pointer): Variant;
begin
  Result := TIBSQL(Instance).RowsAffected;
end;

function TIBXImport.IBSQL_SQLType(Instance: Pointer): Variant;
begin
  Result := TIBSQL(Instance).SQLType;
end;

function TIBXImport.IBSQL_UniqueRelationName(Instance: Pointer): Variant;
begin
  Result := TIBSQL(Instance).UniqueRelationName;
end;

function TIBXImport.IBStoredProc_ExecProc(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBStoredProc(Instance).ExecProc;
end;

function TIBXImport.IBStoredProc_FindOutParam(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TIBStoredProc(Instance).FindOutParam(Params[0]));
end;

function TIBXImport.IBStoredProc_OutParam(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TIBStoredProc(Instance).OutParam(Params[0]) );
end;

function TIBXImport.IBStoredProc_OutParamCount(Instance: Pointer): Variant;
begin
  Result := TIBStoredProc(Instance).OutParamCount;
end;

function TIBXImport.IBStoredProc_ParamByName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBStoredProc(Instance).ParamByName(Params[0]) );
end;

function TIBXImport.IBStoredProc_ParamCount(Instance: Pointer): Variant;
begin
  Result := TIBStoredProc(Instance).ParamCount;
end;

function TIBXImport.IBStoredProc_Params(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBStoredProc(Instance).Params );
end;

function TIBXImport.IBStoredProc_Prepare(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBStoredProc(Instance).Prepare;
end;

function TIBXImport.IBStoredProc_PreparedGet(Instance: Pointer): Variant;
begin
  Result := TIBStoredProc(Instance).Prepared;
end;

procedure TIBXImport.IBStoredProc_PreparedSet(Instance: Pointer; AValue: Variant
  );
begin
  TIBStoredProc(Instance).Prepared := AValue;
end;

function TIBXImport.IBStoredProc_StoredProcedureNames(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( TIBStoredProc(Instance).StoredProcedureNames );
end;

function TIBXImport.IBStoredProc_UnPrepare(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBStoredProc(Instance).UnPrepare;
end;

type
  PIndexOptions = ^TIndexOptions;

function TIBXImport.IBTable_AddIndex(Instance: TObject; var Params: Variant
  ): Variant;
var
  Opt: PIndexOptions;
begin
  Opt := PIndexOptions(TSuPtr(Params[2]));
  TIBTable(Instance).AddIndex(Params[0], Params[1], Opt^, Params[3]);
end;

function TIBXImport.IBTable_CreateTable(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBTable(Instance).CreateTable;
end;

function TIBXImport.IBTable_DeleteIndex(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBTable(Instance).DeleteIndex(Params[0]);
end;

function TIBXImport.IBTable_DeleteTable(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBTable(Instance).DeleteTable;
end;

function TIBXImport.IBTable_EmptyTable(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBTable(Instance).EmptyTable;
end;

function TIBXImport.IBTable_Exists(Instance: Pointer): Variant;
begin
  Result := TIBTable(Instance).Exists;
end;

function TIBXImport.IBTable_GetDetailLinkFields(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBTable(Instance).GetDetailLinkFields(TList(TSuPtr(Params[0])), TList(TSuPtr(Params[1])));
end;

function TIBXImport.IBTable_GetIndexNames(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBTable(Instance).GetIndexNames(TStrings(TSuPtr(Params[0])));
end;

function TIBXImport.IBTable_GotoCurrent(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBTable(Instance).GotoCurrent(TIBTable(TSuPtr(Params[0])));
end;

function TIBXImport.IBTable_IndexFieldCount(Instance: Pointer): Variant;
begin
  Result := TIBTable(Instance).FieldCount;
end;

function TIBXImport.IBTable_IndexFieldsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBTable(Instance).IndexFields[Params[0]] );
end;

function TIBXImport.IBTable_IndexFieldsSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBTable(Instance).IndexFields[Params[0]] := TField(TSuPtr(Params[1]));
end;

function TIBXImport.IBTable_TableNames(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBTable(Instance).TableNames );
end;

function TIBXImport.IBTransaction_AddDatabase(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBTransaction(Instance).AddDatabase(TIBDataBase(TSuPtr(Params[0])));
end;

function TIBXImport.IBTransaction_CheckDatabasesInList(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBTransaction(Instance).CheckDatabasesInList;
end;

function TIBXImport.IBTransaction_CheckInTransaction(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBTransaction(Instance).CheckInTransaction;
end;

function TIBXImport.IBTransaction_CheckNotInTransaction(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBTransaction(Instance).CheckNotInTransaction;
end;

function TIBXImport.IBTransaction_Commit(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBTransaction(Instance).Commit;
end;

function TIBXImport.IBTransaction_CommitRetaining(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBTransaction(Instance).CommitRetaining;
end;

function TIBXImport.IBTransaction_FindDatabase(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TIBTransaction(Instance).FindDatabase(TIBDataBase(TSuPtr(Params[0])));
end;

function TIBXImport.IBTransaction_FindDefaultDatabase(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBTransaction(Instance).FindDefaultDatabase );
end;

function TIBXImport.IBTransaction_GetDatabase(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBTransaction(Instance).Databases[Params[0]] );
end;

function TIBXImport.IBTransaction_GetDatabaseCount(Instance: Pointer): Variant;
begin
  Result := TIBTransaction(Instance).DatabaseCount;
end;

function TIBXImport.IBTransaction_GetInTransaction(Instance: Pointer): Variant;
begin
  Result := TIBTransaction(Instance).InTransaction;
end;

function TIBXImport.IBTransaction_GetSQLObject(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBTransaction(Instance).SQLObjects[Params[0]] );
end;

function TIBXImport.IBTransaction_GetSQLObjectCount(Instance: Pointer): Variant;
begin
  Result := TIBTransaction(Instance).SQLObjectCount;
end;

function TIBXImport.IBTransaction_HandleIsShared(Instance: Pointer): Variant;
begin
  Result := TIBTransaction(Instance).HandleIsShared;
end;

function TIBXImport.IBTransaction_RemoveDatabase(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBTransaction(Instance).RemoveDatabase(Params[0]);
end;

function TIBXImport.IBTransaction_RemoveDatabases(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBTransaction(Instance).RemoveDatabases;
end;

function TIBXImport.IBTransaction_Rollback(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBTransaction(Instance).Rollback;
end;

function TIBXImport.IBTransaction_RollbackRetaining(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBTransaction(Instance).RollbackRetaining;
end;

function TIBXImport.IBTransaction_StartTransaction(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBTransaction(Instance).StartTransaction;
end;

function TIBXImport.IBUpdateSQL_DataSet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TIBUpdateSQL(Instance).DataSet );
end;

function TIBXImport.IBUpdateSQL_Query(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TIBUpdateSQL(Instance).Query[Params[0]] );
end;

function TIBXImport.IBUpdateSQL_SQLGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TIBUpdateSQL(Instance).SQL[Params[0]] );
end;

function TIBXImport.IBUpdateSQL_SQLSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBUpdateSQL(Instance).SQL[Params[0]] := TStrings(TSuPtr(Params[1]));
end;

function TIBXImport.IBValidationService_FetchLimboTransactionInfo(
  Instance: TObject; var Params: Variant): Variant;
begin
  TIBValidationService(Instance).FetchLimboTransactionInfo;
end;

function TIBXImport.IBValidationService_FixLimboTransactionErrors(
  Instance: TObject; var Params: Variant): Variant;
begin
  TIBValidationService(Instance).FixLimboTransactionErrors;
end;

function TIBXImport.IBValidationService_LimboTransactionInfo(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TIBValidationService(Instance).LimboTransactionInfo[Params[0]] );
end;

function TIBXImport.IBValidationService_LimboTransactionInfoCount(
  Instance: Pointer): Variant;
begin
  Result := TIBValidationService(Instance).LimboTransactionInfoCount;
end;

function TIBXImport.IBXSQLDA_AddName(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBXSQLDA(Instance).AddName(Params[0], Params[1]);
end;

function TIBXImport.IBXSQLDA_ByName(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TIBXSQLDA(Instance).ByName(Params[0]) );
end;

function TIBXImport.IBXSQLDA_CountGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLDA(Instance).Count;
end;

procedure TIBXImport.IBXSQLDA_CountSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLDA(Instance).Count := AValue;
end;

function TIBXImport.IBXSQLDA_ModifiedGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLDA(Instance).Modified;
end;

function TIBXImport.IBXSQLDA_NamesGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLDA(Instance).Names;
end;

function TIBXImport.IBXSQLDA_RecordSizeGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLDA(Instance).RecordSize;
end;

function TIBXImport.IBXSQLDA_UniqueRelationNameGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLDA(Instance).UniqueRelationName;
end;

function TIBXImport.IBXSQLDA_Vars(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TIBXSQLDA(Instance).Vars[Params[0]] );
end;

function TIBXImport.IBXSQLVAR_AsBooleanGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).AsBoolean;
end;

procedure TIBXImport.IBXSQLVAR_AsBooleanSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).AsBoolean := AValue;
end;

function TIBXImport.IBXSQLVAR_AsCurrencyGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).AsCurrency;
end;

procedure TIBXImport.IBXSQLVAR_AsCurrencySet(Instance: Pointer; AValue: Variant
  );
begin
  TIBXSQLVAR(Instance).AsCurrency := AValue;
end;

function TIBXImport.IBXSQLVAR_AsDateGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).AsDate;
end;

procedure TIBXImport.IBXSQLVAR_AsDateSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).AsDate:= AValue;
end;

function TIBXImport.IBXSQLVAR_AsDateTimeGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).AsDateTime;
end;

procedure TIBXImport.IBXSQLVAR_AsDateTimeSet(Instance: Pointer; AValue: Variant
  );
begin
  TIBXSQLVAR(Instance).AsDateTime := AValue;
end;

function TIBXImport.IBXSQLVAR_AsDoubleGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).AsDouble;
end;

procedure TIBXImport.IBXSQLVAR_AsDoubleSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).AsDouble := AValue;
end;

function TIBXImport.IBXSQLVAR_AsFloatGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).AsFloat;
end;

procedure TIBXImport.IBXSQLVAR_AsFloatSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).AsFloat := AValue;
end;

function TIBXImport.IBXSQLVAR_AsInt64Get(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).AsInt64;
end;

procedure TIBXImport.IBXSQLVAR_AsInt64Set(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).AsInt64 := AValue;
end;

function TIBXImport.IBXSQLVAR_AsIntegerGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).AsInteger;
end;

procedure TIBXImport.IBXSQLVAR_AsIntegerSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).AsInteger := AValue;
end;

function TIBXImport.IBXSQLVAR_AsLongGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).AsLong;
end;

procedure TIBXImport.IBXSQLVAR_AsLongSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).AsLong := AValue;
end;

function TIBXImport.IBXSQLVAR_AsShortGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).AsShort;
end;

procedure TIBXImport.IBXSQLVAR_AsShortSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).AsShort := AValue;
end;

function TIBXImport.IBXSQLVAR_Assign(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBXSQLVAR(Instance).Assign(TIBXSQLVAR(TSuPtr(Params[0])));
end;

function TIBXImport.IBXSQLVAR_AsStringGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).AsString;
end;

procedure TIBXImport.IBXSQLVAR_AsStringSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).AsString := AValue;
end;

function TIBXImport.IBXSQLVAR_AsTimeGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).AsTime;
end;

procedure TIBXImport.IBXSQLVAR_AsTimeSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).AsTime := AValue;
end;

function TIBXImport.IBXSQLVAR_AsVariantGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).Value;
end;

procedure TIBXImport.IBXSQLVAR_AsVariantSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).Value := AValue;
end;

function TIBXImport.IBXSQLVAR_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBXSQLVAR(Instance).Clear;
end;

function TIBXImport.IBXSQLVAR_IndexGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).Index;
end;

function TIBXImport.IBXSQLVAR_IsNullableGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).IsNullable;
end;

procedure TIBXImport.IBXSQLVAR_IsNullableSet(Instance: Pointer; AValue: Variant
  );
begin
  TIBXSQLVAR(Instance).IsNullable := AValue;
end;

function TIBXImport.IBXSQLVAR_IsNullGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).IsNull;
end;

procedure TIBXImport.IBXSQLVAR_IsNullSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).IsNull := AValue;
end;

function TIBXImport.IBXSQLVAR_LoadFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBXSQLVAR(Instance).LoadFromFile(Params[0]);
end;

function TIBXImport.IBXSQLVAR_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBXSQLVAR(Instance).LoadFromStream(TStream(TSuPtr(Params[0])));
end;

function TIBXImport.IBXSQLVAR_ModifiedGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).Modified;
end;

procedure TIBXImport.IBXSQLVAR_ModifiedSet(Instance: Pointer; AValue: Variant);
begin
  TIBXSQLVAR(Instance).Modified := AValue;
end;

function TIBXImport.IBXSQLVAR_NameGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).Name;
end;

function TIBXImport.IBXSQLVAR_SaveToFile(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIBXSQLVAR(Instance).SaveToFile(Params[0]);
end;

function TIBXImport.IBXSQLVAR_SaveToStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TIBXSQLVAR(Instance).SaveToStream(TStream(TSuPtr(Params[0])));
end;

function TIBXImport.IBXSQLVAR_SizeGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).Size;
end;

function TIBXImport.IBXSQLVAR_SQLTypeGet(Instance: Pointer): Variant;
begin
  Result := TIBXSQLVAR(Instance).SQLType;
end;

function TIBXImport.LimboTransactionInfo_ActionGet(Instance: Pointer): Variant;
begin
  Result := TLimboTransactionInfo(Instance).Action;
end;

procedure TIBXImport.LimboTransactionInfo_ActionSet(Instance: Pointer;
  AValue: Variant);
begin
  TLimboTransactionInfo(Instance).Action := AValue;
end;

function TIBXImport.LimboTransactionInfo_AdviseGet(Instance: Pointer): Variant;
begin
  Result := TLimboTransactionInfo(Instance).Advise;
end;

procedure TIBXImport.LimboTransactionInfo_AdviseSet(Instance: Pointer;
  AValue: Variant);
begin
  TLimboTransactionInfo(Instance).Advise := AValue;
end;

function TIBXImport.LimboTransactionInfo_HostSiteGet(Instance: Pointer
  ): Variant;
begin
  Result := TLimboTransactionInfo(Instance).HostSite;
end;

procedure TIBXImport.LimboTransactionInfo_HostSiteSet(Instance: Pointer;
  AValue: Variant);
begin
  TLimboTransactionInfo(Instance).HostSite := AValue;
end;

function TIBXImport.LimboTransactionInfo_IDGet(Instance: Pointer): Variant;
begin
  Result := TLimboTransactionInfo(Instance).ID;
end;

procedure TIBXImport.LimboTransactionInfo_IDSet(Instance: Pointer;
  AValue: Variant);
begin
  TLimboTransactionInfo(Instance).ID := AValue;
end;

function TIBXImport.LimboTransactionInfo_MultiDatabaseGet(Instance: Pointer
  ): Variant;
begin
  Result := TLimboTransactionInfo(Instance).MultiDatabase;
end;

procedure TIBXImport.LimboTransactionInfo_MultiDatabaseSet(Instance: Pointer;
  AValue: Variant);
begin
  TLimboTransactionInfo(Instance).MultiDatabase := AValue;
end;

function TIBXImport.LimboTransactionInfo_RemoteDatabasePathGet(Instance: Pointer
  ): Variant;
begin
  Result := TLimboTransactionInfo(Instance).RemoteDatabasePath;
end;

procedure TIBXImport.LimboTransactionInfo_RemoteDatabasePathSet(
  Instance: Pointer; AValue: Variant);
begin
  TLimboTransactionInfo(Instance).RemoteDatabasePath := AValue;
end;

function TIBXImport.LimboTransactionInfo_RemoteSiteGet(Instance: Pointer
  ): Variant;
begin
  Result := TLimboTransactionInfo(Instance).RemoteSite;
end;

procedure TIBXImport.LimboTransactionInfo_RemoteSiteSet(Instance: Pointer;
  AValue: Variant);
begin
  TLimboTransactionInfo(Instance).RemoteSite := AValue;
end;

function TIBXImport.LimboTransactionInfo_StateGet(Instance: Pointer): Variant;
begin
  Result := TLimboTransactionInfo(Instance).State;
end;

procedure TIBXImport.LimboTransactionInfo_StateSet(Instance: Pointer;
  AValue: Variant);
begin
  TLimboTransactionInfo(Instance).State := AValue;
end;

function TIBXImport.UserInfo_FirstNameGet(Instance: Pointer): Variant;
begin
  Result := TUserInfo(Instance).FirstName;
end;

procedure TIBXImport.UserInfo_FirstNameSet(Instance: Pointer; AValue: Variant);
begin
  TUserInfo(Instance).FirstName := AValue;
end;

function TIBXImport.UserInfo_GroupIDGet(Instance: Pointer): Variant;
begin
  Result := TUserInfo(Instance).GroupID;
end;

procedure TIBXImport.UserInfo_GroupIDSet(Instance: Pointer; AValue: Variant);
begin
  TUserInfo(Instance).GroupID := AValue;
end;

function TIBXImport.UserInfo_LastNameGet(Instance: Pointer): Variant;
begin
  Result := TUserInfo(Instance).LastName;
end;

procedure TIBXImport.UserInfo_LastNameSet(Instance: Pointer; AValue: Variant);
begin
  TUserInfo(Instance).LastName := AValue;
end;

function TIBXImport.UserInfo_MiddleNameGet(Instance: Pointer): Variant;
begin
  Result := TUserInfo(Instance).MiddleName;
end;

procedure TIBXImport.UserInfo_MiddleNameSet(Instance: Pointer; AValue: Variant);
begin
  TUserInfo(Instance).MiddleName := AValue;
end;

function TIBXImport.UserInfo_UserIDGet(Instance: Pointer): Variant;
begin
  Result := TUserInfo(Instance).UserID;
end;

procedure TIBXImport.UserInfo_UserIDSet(Instance: Pointer; AValue: Variant);
begin
  TUserInfo(Instance).UserID := AValue;
end;

function TIBXImport.UserInfo_UserNameGet(Instance: Pointer): Variant;
begin
  Result := TUserInfo(Instance).UserName;
end;

procedure TIBXImport.UserInfo_UserNameSet(Instance: Pointer; AValue: Variant);
begin
  TUserInfo(Instance).UserName := AValue;
end;

function TIBXImport.IBSQLMinitor_EnableMonitoring(Instance: TObject;
  var Params: Variant): Variant;
begin
  EnableMonitoring;
end;

function TIBXImport.IBSQLMinitor_DisableMonitoring(Instance: TObject;
  var Params: Variant): Variant;
begin
  DisableMonitoring;
end;

function TIBXImport.IBSQLMinitor_MonitoringEnabled(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := MonitoringEnabled;
end;

type
  PIBDataBaseErrorMessages = ^TIBDataBaseErrorMessages;

function TIBXImport.IBError_SetIBDataBaseErrorMessages(Instance: TObject;
  var Params: Variant): Variant;
var
  V: TIBDataBaseErrorMessages;
begin
  V := PIBDataBaseErrorMessages(TSuPtr(Params[0]))^;
  SetIBDataBaseErrorMessages(V);
end;

function TIBXImport.IBSQL_Handle(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TIBSQL(Instance).Handle);
end;

procedure TIBXImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TTransactionAction));
  AddType(TypeInfo(TCachedUpdateStatus));
  AddType(TypeInfo(TIBGeneratorApplyOnEvent));
  AddType(TypeInfo(TIBUpdateAction));
  AddType(TypeInfo(TProtocol));
  AddType(TypeInfo(TOutputBufferOption));
  AddType(TypeInfo(TPropertyOption));
  AddType(TypeInfo(TPropertyOptions));
  AddType(TypeInfo(TShutdownMode));
  AddType(TypeInfo(TStatOption));
  AddType(TypeInfo(TStatOptions));
  AddType(TypeInfo(TBackupOption));
  AddType(TypeInfo(TBackupOptions));
  AddType(TypeInfo(TRestoreOption));
  AddType(TypeInfo(TRestoreOptions));
  AddType(TypeInfo(TDetailCondition));
  AddType(TypeInfo(TDetailConditions));
  AddType(TypeInfo(TValidateOption));
  AddType(TypeInfo(TValidateOptions));
  AddType(TypeInfo(TSecurityAction));
  AddType(TypeInfo(TSecurityModifyParam));
  AddType(TypeInfo(TSecurityModifyParams));
  AddType(TypeInfo(TTraceFlag));
  AddType(TypeInfo(TTraceFlags));
  AddType(TypeInfo(TBatchMode));
  AddType(TypeInfo(TIBSQLTypes));
  AddType(TypeInfo(TExtractObjectTypes));
  AddType(TypeInfo(TExtractType));
  AddType(TypeInfo(TExtractTypes));
  AddType(TypeInfo(TTransactionState));
  AddType(TypeInfo(TTransactionAdvise));
  AddType(TypeInfo(TIBDataBaseErrorMessage));
  AddType(TypeInfo(TIBDataBaseErrorMessages));

  {AddType(TypeInfo());}

end;

procedure TIBXImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  {Firebird}
  AddClass(TIBStringField);
  AddClass(TIBBCDField);
  AddClass(TIBBooleanField);
  AddClass(TIBBlobStream).ClassImporter := Self;
  AddClass(TIBDataBase).ClassImporter := Self;
  AddClass(TIBTransaction).ClassImporter := Self;
  AddClass(TIBBase).ClassImporter := Self;
  AddClass(TIBXSQLVAR).ClassImporter := Self;
  AddClass(TIBXSQLDA).ClassImporter := Self;
  AddClass(TIBCustomDataSet).ClassImporter := Self;
  AddClass(TIBDataSet).ClassImporter := Self;
  AddClass(TIBQuery).ClassImporter := Self;
  AddClass(TIBUpdateSQL).ClassImporter := Self;
  AddClass(TIBSQL).ClassImporter := Self;
  AddClass(TIBStoredProc).ClassImporter := Self;
  AddClass(TIBEvents).ClassImporter := Self;
  AddClass(TIBDatabaseInfo).ClassImporter := Self;
  AddClass(TIBSQLMonitor).ClassImporter := Self;
  AddClass(TIBBatchMove).ClassImporter := Self;
  AddClass(TIBTable).ClassImporter := Self;
  AddClass(TIBExtract).ClassImporter := Self;
  AddClass(TIBBatch).ClassImporter := Self;
  AddClass(TIBBatchInput).ClassImporter := Self;
  AddClass(TIBBatchOutput).ClassImporter := Self;
  AddClass(TIBOutputDelimitedFile).ClassImporter := Self;
  AddClass(TIBInputDelimitedFile).ClassImporter := Self;


  {Firebird Admin}
  AddClass(TIBCustomService).ClassImporter := Self;
  AddClass(TIBControlService).ClassImporter := Self;
  AddClass(TIBControlAndQueryService).ClassImporter := Self;
  AddClass(TIBConfigService).ClassImporter := Self;
  AddClass(TIBStatisticalService);
  AddClass(TIBLogService);
  AddClass(TIBBackupRestoreService);
  AddClass(TIBBackupService);
  AddClass(TIBRestoreService);

  AddClass(TLimboTransactionInfo).ClassImporter := Self;
  AddClass(TIBValidationService).ClassImporter := Self;

  AddClass(TUserInfo).ClassImporter := Self;
  AddClass(TIBSecurityService).ClassImporter := Self;
end;

procedure TIBXImport.AddSimpleTypes(AddType: TAddSimpleTypeProc);
begin
  AddType('Long', btInt);
  AddType('Short', btInt);
  AddType('Float', btFloat);
  AddType('TIBFileName', btString);
end;

procedure TIBXImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TIBDataBase then
  begin
    AType.AddMethod('procedure CloseDataSets', @IBDataBase_CloseDataSets);
    AType.AddMethod('procedure CheckActive', @IBDataBase_CheckActive);
    AType.AddMethod('procedure CheckInactive', @IBDataBase_CheckInactive);
    AType.AddMethod('procedure CreateDatabase', @IBDataBase_CreateDatabase);
    AType.AddMethod('procedure DropDatabase', @IBDataBase_DropDatabase);
    AType.AddMethod('procedure ForceClose', @IBDataBase_ForceClose);
    AType.AddMethod('procedure GetFieldNames(const TableName: string; List: TStrings)', @IBDataBase_GetFieldNames);
    AType.AddMethod('procedure GetTableNames(List: TStrings; SystemTables: Boolean = False)', @IBDataBase_GetTableNames);
    AType.AddMethod('function IndexOfDBConst(st: String): Integer', @IBDataBase_IndexOfDBConst);
    AType.AddMethod('function TestConnected: Boolean', @IBDataBase_TestConnected);
    AType.AddMethod('procedure CheckDatabaseName', @IBDataBase_CheckDatabaseName);
    AType.AddMethod('function AddTransaction(TR: TIBTransaction): Integer', @IBDataBase_AddTransaction);
    AType.AddMethod('function FindTransaction(TR: TIBTransaction): Integer', @IBDataBase_FindTransaction);
    AType.AddMethod('function FindDefaultTransaction: TIBTransaction', @IBDataBase_FindDefaultTransaction);
    AType.AddMethod('procedure RemoveTransaction(Idx: Integer)', @IBDataBase_RemoveTransaction);
    AType.AddMethod('procedure RemoveTransactions', @IBDataBase_RemoveTransactions);
    AType.AddMethod('function GenID(const GeneratorName: string; Increment: Integer = 1): LargeInt', @IBDataBase_GenID);

    AType.AddProp('IsReadOnly', 'Boolean', @IBDataBase_IsReadOnlyGet);
    AType.AddProp('SQLObjectCount', 'Integer', @IBDataBase_SQLObjectCountGet);
    AType.AddIndexedProp('SQLObjects', 'TIBBase', 'Integer', @IBDataBase_SQLObjectsGet);
    AType.AddProp('HandleIsShared', 'Boolean', @IBDataBase_HandleIsSharedGet);
    AType.AddProp('TransactionCount', 'Integer', @IBDataBase_TransactionCountGet);
    AType.AddIndexedProp('Transactions', 'TIBTransaction', 'Integer', @IBDataBase_TransactionsGet);
    AType.AddProp('InternalTransaction', 'TIBTransaction', @IBDataBase_InternalTransactionGet);
  end
  else
  if AType.ValueClassType = TIBTransaction then
  begin
    AType.AddMethod('procedure Commit', @IBTransaction_Commit);
    AType.AddMethod('procedure CommitRetaining', @IBTransaction_CommitRetaining);
    AType.AddMethod('procedure Rollback', @IBTransaction_Rollback);
    AType.AddMethod('procedure RollbackRetaining', @IBTransaction_RollbackRetaining);
    AType.AddMethod('procedure StartTransaction', @IBTransaction_StartTransaction);
    AType.AddMethod('procedure CheckInTransaction', @IBTransaction_CheckInTransaction);
    AType.AddMethod('procedure CheckNotInTransaction', @IBTransaction_CheckNotInTransaction);
    AType.AddMethod('function AddDatabase(db: TIBDatabase): Integer', @IBTransaction_AddDatabase);
    AType.AddMethod('function FindDatabase(db: TIBDatabase): Integer', @IBTransaction_FindDatabase);
    AType.AddMethod('function FindDefaultDatabase: TIBDatabase', @IBTransaction_FindDefaultDatabase);
    AType.AddMethod('procedure RemoveDatabase(Idx: Integer)', @IBTransaction_RemoveDatabase);
    AType.AddMethod('procedure RemoveDatabases', @IBTransaction_RemoveDatabases);
    AType.AddMethod('procedure CheckDatabasesInList', @IBTransaction_CheckDatabasesInList);

    AType.AddProp('InTransaction', 'Boolean', @IBTransaction_GetInTransaction);
    AType.AddProp('DatabaseCount', 'Integer', @IBTransaction_GetDatabaseCount);
    AType.AddIndexedProp('Databases', 'TIBDatabase', 'Integer', @IBTransaction_GetDatabase);
    AType.AddProp('SQLObjectCount', 'Integer', @IBTransaction_GetSQLObjectCount);
    AType.AddIndexedProp('SQLObjects', 'TIBBase', 'Integer', @IBTransaction_GetSQLObject);
    AType.AddProp('HandleIsShared', 'Boolean', @IBTransaction_HandleIsShared);
  end
  else
  if AType.ValueClassType = TIBBase then
  begin
    AType.AddMethod('procedure CheckDatabase',  @IBBase_CheckDatabase);
    AType.AddMethod('procedure CheckTransaction',  @IBBase_CheckTransaction);
    AType.AddProp('Database', 'TIBDatabase', @IBBase_DatabaseGet, @IBBase_DatabaseSet);
    AType.AddProp('Transaction', 'TIBTransaction', @IBBase_TransactionGet, @IBBase_TransactionSet);
    AType.AddProp('Owner', 'TObject', @IBBase_Owner);
  end
  else
  if AType.ValueClassType = TIBXSQLVAR then
  begin
    AType.AddMethod('procedure Assign(Source: TIBXSQLVAR)', @IBXSQLVAR_Assign);
    AType.AddMethod('procedure Clear', @IBXSQLVAR_Clear);
    AType.AddMethod('procedure LoadFromFile(const FileName: String)', @IBXSQLVAR_LoadFromFile);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @IBXSQLVAR_LoadFromStream);
    AType.AddMethod('procedure SaveToFile(const FileName: String)', @IBXSQLVAR_SaveToFile);
    AType.AddMethod('procedure SaveToStream(Stream: TStream)', @IBXSQLVAR_SaveToStream);

    AType.AddProp('AsDate', 'TDateTime', @IBXSQLVAR_AsDateGet, @IBXSQLVAR_AsDateSet);
    AType.AddProp('AsTime', 'TDateTime', @IBXSQLVAR_AsTimeGet, @IBXSQLVAR_AsTimeSet);
    AType.AddProp('AsDateTime', 'TDateTime', @IBXSQLVAR_AsDateTimeGet, @IBXSQLVAR_AsDateTimeSet);
    AType.AddProp('AsDouble', 'Double', @IBXSQLVAR_AsDoubleGet, @IBXSQLVAR_AsDoubleSet);
    AType.AddProp('AsFloat', 'Float', @IBXSQLVAR_AsFloatGet, @IBXSQLVAR_AsFloatSet);
    AType.AddProp('AsCurrency', 'Currency', @IBXSQLVAR_AsCurrencyGet, @IBXSQLVAR_AsCurrencySet);
    AType.AddProp('AsInt64', 'Int64', @IBXSQLVAR_AsInt64Get, @IBXSQLVAR_AsInt64Set);
    AType.AddProp('AsInteger', 'Integer', @IBXSQLVAR_AsIntegerGet, @IBXSQLVAR_AsIntegerSet);
    AType.AddProp('AsLong', 'Long', @IBXSQLVAR_AsLongGet, @IBXSQLVAR_AsLongSet);
    AType.AddProp('AsShort', 'Short', @IBXSQLVAR_AsShortGet, @IBXSQLVAR_AsShortSet);
    AType.AddProp('AsString', 'String', @IBXSQLVAR_AsStringGet, @IBXSQLVAR_AsStringSet);
    AType.AddProp('AsVariant', 'Variant', @IBXSQLVAR_AsVariantGet, @IBXSQLVAR_AsVariantSet);
    AType.AddProp('AsBoolean', 'Boolean', @IBXSQLVAR_AsBooleanGet, @IBXSQLVAR_AsBooleanSet);
    AType.AddProp('Value', 'Variant', @IBXSQLVAR_AsVariantGet, @IBXSQLVAR_AsVariantSet);
    AType.AddProp('IsNull', 'Boolean', @IBXSQLVAR_IsNullGet, @IBXSQLVAR_IsNullSet);
    AType.AddProp('IsNullable', 'Boolean', @IBXSQLVAR_IsNullableGet, @IBXSQLVAR_IsNullableSet);
    AType.AddProp('Index', 'Integer', @IBXSQLVAR_IndexGet);
    AType.AddProp('Modified', 'Boolean', @IBXSQLVAR_ModifiedGet, @IBXSQLVAR_ModifiedSet);
    AType.AddProp('Name', 'string', @IBXSQLVAR_NameGet);
    AType.AddProp('Size', 'Integer', @IBXSQLVAR_SizeGet);
    AType.AddProp('SQLType', 'Integer', @IBXSQLVAR_SQLTypeGet);
  end
  else
  if AType.ValueClassType = TIBXSQLDA then
  begin
    AType.AddMethod('procedure AddName(FieldName: String; Idx: Integer)', @IBXSQLDA_AddName);
    AType.AddMethod('function ByName(Idx: String): TIBXSQLVAR', @IBXSQLDA_ByName);
    AType.AddProp('Count', 'Integer', @IBXSQLDA_CountGet, @IBXSQLDA_CountSet);
    AType.AddProp('Modified', 'Boolean', @IBXSQLDA_ModifiedGet);
    AType.AddProp('Names', 'String', @IBXSQLDA_NamesGet);
    AType.AddProp('RecordSize', 'Integer', @IBXSQLDA_RecordSizeGet);
    AType.AddIndexedProp('Vars', 'TIBXSQLVAR', 'Integer', @IBXSQLDA_Vars);
    AType.AddProp('UniqueRelationName', 'String', @IBXSQLDA_UniqueRelationNameGet);
  end
  else
  if AType.ValueClassType = TIBCustomDataSet then
  begin
    AType.AddMethod('procedure ApplyUpdates', @IBCustomDataSet_ApplyUpdates);
    AType.AddMethod('function CachedUpdateStatus: TCachedUpdateStatus', @IBCustomDataSet_CachedUpdateStatus);
    AType.AddMethod('procedure CancelUpdates', @IBCustomDataSet_CancelUpdates);
    AType.AddMethod('procedure FetchAll', @IBCustomDataSet_FetchAll);
    AType.AddMethod('procedure FullRefresh', @IBCustomDataSet_FullRefresh);
    AType.AddMethod('procedure RefreshVisibleRows', @IBCustomDataSet_RefreshVisibleRows);
    AType.AddMethod('function LocateNext(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean', @IBCustomDataSet_LocateNext);
    AType.AddMethod('procedure RecordModified(Value: Boolean)', @IBCustomDataSet_RecordModified);
    AType.AddMethod('procedure RevertRecord', @IBCustomDataSet_RevertRecord);
    AType.AddMethod('procedure Undelete', @IBCustomDataSet_Undelete);
  end
  else
  if AType.ValueClassType = TIBDataSet then
  begin
    AType.AddMethod('procedure Prepare', @IBDataSet_Prepare);
    AType.AddMethod('procedure UnPrepare', @IBDataSet_UnPrepare);
    AType.AddMethod('procedure BatchInput(InputObject: TIBBatchInput)', @IBDataSet_BatchInput);
    AType.AddMethod('procedure BatchOutput(OutputObject: TIBBatchOutput)', @IBDataSet_BatchOutput);
    AType.AddMethod('procedure ExecSQL', @IBDataSet_ExecSQL);
    AType.AddMethod('function ParamByName(ParamName: String): TIBXSQLVAR', @IBDataSet_ParamByName);
    AType.AddMethod('function PN(ParamName: String): TIBXSQLVAR', @IBDataSet_ParamByName);
    AType.AddMethod('function FindParam(ParamName: string): TIBXSQLVAR', @IBDataSet_FindParam);

    AType.AddProp('QDelete', 'TIBSQL', @IBDataSet_QDelete);
    AType.AddProp('QInsert', 'TIBSQL', @IBDataSet_QInsert);
    AType.AddProp('QRefresh', 'TIBSQL', @IBDataSet_QRefresh);
    AType.AddProp('QSelect', 'TIBSQL', @IBDataSet_QSelect);
    AType.AddProp('QModify', 'TIBSQL', @IBDataSet_QModify);
    AType.AddProp('StatementType', 'TIBSQLTypes', @IBDataSet_StatementType);
    AType.AddProp('Params', 'TIBXSQLDA', @IBDataSet_Params);
    AType.AddProp('OrderFields', 'string', @IBDataSet_OrderFieldsGet, @IBDataSet_OrderFieldsSet);
  end
  else
  if AType.ValueClassType = TIBQuery then
  begin
    AType.AddMethod('procedure Prepare', @IBQuery_Prepare);
    AType.AddMethod('procedure UnPrepare', @IBQuery_UnPrepare);
    AType.AddMethod('procedure BatchInput(InputObject: TIBBatchInput)', @IBQuery_BatchInput);
    AType.AddMethod('procedure BatchOutput(OutputObject: TIBBatchOutput)', @IBQuery_BatchOutput);
    AType.AddMethod('procedure ExecSQL', @IBQuery_ExecSQL);
    AType.AddMethod('function ParamByName(const Value: string): TParam', @IBQuery_ParamByName);
    AType.AddMethod('function PN(const Value: string): TParam', @IBQuery_ParamByName);
    AType.AddMethod('function FindParam(const Value: string): TParam', @IBQuery_FindParam);
    AType.AddMethod('function OutParamByName(const Value: string): TParam', @IBQuery_OutParamByName);

    AType.AddProp('Prepared', 'Boolean', @IBQuery_PreparedGet, @IBQuery_PreparedSet);
    AType.AddProp('ParamCount', 'Word', @IBQuery_GetParamsCount);
    AType.AddProp('StatementType', 'TIBSQLTypes', @IBQuery_StatementType);
    AType.AddProp('RowsAffected', 'Integer', @IBQuery_RowsAffected);
    AType.AddProp('GenerateParamNames', 'Boolean', @IBQuery_GenerateParamNamesGet, @IBQuery_GenerateParamNamesSet);
    AType.AddProp('Text', 'string', @IBQuery_Text);
    AType.AddProp('QSelect', 'TIBSQL', @IBQuery_QSelect);
    AType.AddProp('OutParams', 'TParams', @IBQuery_OutParams);
    AType.AddProp('OutParamCount', 'Integer', @IBQuery_OutParamCount);
  end
  else
  if AType.ValueClassType = TIBStoredProc then
  begin
    //AType.AddMethod('procedure CopyParams(Value: TParams)', @IBStoredProc_CopyParams);
    AType.AddMethod('procedure ExecProc', @IBStoredProc_ExecProc);
    AType.AddMethod('function PN(const Value: string): TIBXSQLVAR', @IBStoredProc_ParamByName);
    AType.AddMethod('function ParamByName(const Value: string): TIBXSQLVAR', @IBStoredProc_ParamByName);
    AType.AddMethod('procedure Prepare', @IBStoredProc_Prepare);
    AType.AddMethod('procedure UnPrepare', @IBStoredProc_UnPrepare);
    AType.AddMethod('function FindOutParam(const ParamName: string): TParam', @IBStoredProc_FindOutParam);
    AType.AddMethod('function OutParam(const ParamName: string): TParam', @IBStoredProc_OutParam);

    AType.AddProp('ParamCount', 'Word', @IBStoredProc_ParamCount);
    AType.AddProp('OutParamCount', 'Word', @IBStoredProc_OutParamCount);
    AType.AddProp('Prepared', 'Boolean', @IBStoredProc_PreparedGet, @IBStoredProc_PreparedSet);
    AType.AddProp('StoredProcedureNames', 'TStrings', @IBStoredProc_StoredProcedureNames);
    AType.AddProp('Params', 'TParams', @IBStoredProc_Params);
  end
  else
  if AType.ValueClassType = TIBUpdateSQL then
  begin
    AType.AddProp('DataSet', 'TIBCustomDataSet', @IBUpdateSQL_DataSet);
    AType.AddIndexedProp('Query', 'TIBSQL', 'TUpdateKind', @IBUpdateSQL_Query);
    AType.AddIndexedProp('SQL', 'TStrings', 'TUpdateKind', @IBUpdateSQL_SQLGet, @IBUpdateSQL_SQLSet);
  end
  else
  if AType.ValueClassType = TIBSQL then
  begin
    AType.AddMethod('procedure BatchInput(InputObject: TIBBatchInput)', @IBSQL_BatchInput);
    AType.AddMethod('procedure BatchOutput(OutputObject: TIBBatchOutput)', @IBSQL_BatchOutput);
    AType.AddMethod('procedure CheckClosed', @IBSQL_CheckClosed);
    AType.AddMethod('procedure CheckOpen', @IBSQL_CheckOpen);
    AType.AddMethod('procedure CheckValidStatement', @IBSQL_CheckValidStatement);
    AType.AddMethod('procedure Close', @IBSQL_Close);
    AType.AddMethod('function Current: TIBXSQLDA', @IBSQL_Current);
    AType.AddMethod('procedure ExecQuery', @IBSQL_ExecQuery);
    AType.AddMethod('function FieldByName(FieldName: String): TIBXSQLVAR', @IBSQL_FieldByName);
    AType.AddMethod('function FN(FieldName: String): TIBXSQLVAR', @IBSQL_FieldByName);
    AType.AddMethod('function ParamByName(ParamName: String): TIBXSQLVAR', @IBSQL_ParamByName);
    AType.AddMethod('function PN(ParamName: String): TIBXSQLVAR', @IBSQL_ParamByName);
    AType.AddMethod('procedure FreeHandle', @IBSQL_FreeHandle);
    AType.AddMethod('function Next: TIBXSQLDA', @IBSQL_Next);
    AType.AddMethod('procedure Prepare', @IBSQL_Prepare);
    AType.AddMethod('function GetUniqueRelationName: String', @IBSQL_GetUniqueRelationName);

    AType.AddProp('Bof', 'Boolean', @IBSQL_Bof);
    AType.AddProp('Eof', 'Boolean', @IBSQL_Eof);
    AType.AddIndexedProp('Fields', 'TIBXSQLVAR', 'Integer', @IBSQL_Fields);
    AType.AddIndexedProp('FieldIndex', 'Integer', 'String', @IBSQL_FieldIndex);
    AType.AddProp('FieldCount', 'Integer', @IBSQL_FieldCount);
    AType.AddProp('Open', 'Boolean', @IBSQL_Open);
    AType.AddProp('Params', 'TIBXSQLDA', @IBSQL_Params);
    AType.AddProp('Plan', 'String', @IBSQL_Plan);
    AType.AddProp('Prepared', 'Boolean', @IBSQL_Prepared);
    AType.AddProp('RecordCount', 'Integer', @IBSQL_RecordCount);
    AType.AddProp('RowsAffected', 'Integer', @IBSQL_RowsAffected);
    AType.AddProp('SQLType', 'TIBSQLTypes', @IBSQL_SQLType);
    AType.AddProp('GenerateParamNames', 'Boolean', @IBSQL_GenerateParamNamesGet, @IBSQL_GenerateParamNamesSet);
    AType.AddProp('UniqueRelationName', 'String', @IBSQL_UniqueRelationName);
    AType.AddProp('Base', 'TIBBase', @IBSQL_Base);
    AType.AddProp('Handle', 'LongInt', @IBSQL_Handle);
  end
  else
  if AType.ValueClassType = TIBEvents then
  begin
    AType.AddMethod('procedure RegisterEvents', @IBEvents_RegisterEvents);
    AType.AddMethod('procedure UnRegisterEvents', @IBEvents_UnRegisterEvents);
    AType.AddProp('DeferredRegister', 'boolean', @IBEvents_DeferredRegisterGet, @IBEvents_DeferredRegisterSet);
  end
  else
  if AType.ValueClassType = TIBDatabaseInfo then
  begin
    AType.AddProp('Allocation', 'Long', @IBDatabaseInfo_Allocation);
    AType.AddProp('BaseLevel', 'Long', @IBDatabaseInfo_BaseLevel);
    AType.AddProp('DBFileName', 'String', @IBDatabaseInfo_DBFileName);
    AType.AddProp('DBSiteName', 'String', @IBDatabaseInfo_DBSiteName);
    AType.AddProp('DBImplementationNo', 'Long', @IBDatabaseInfo_DBImplementationNo);
    AType.AddProp('DBImplementationClass', 'Long', @IBDatabaseInfo_DBImplementationClass);
    AType.AddProp('NoReserve', 'Long', @IBDatabaseInfo_NoReserve);
    AType.AddProp('ODSMinorVersion', 'Long', @IBDatabaseInfo_ODSMinorVersion);
    AType.AddProp('ODSMajorVersion', 'Long', @IBDatabaseInfo_ODSMajorVersion);
    AType.AddProp('PageSize', 'Long', @IBDatabaseInfo_PageSize);
    AType.AddProp('Version', 'String', @IBDatabaseInfo_Version);
    AType.AddProp('CurrentMemory', 'Long', @IBDatabaseInfo_CurrentMemory);
    AType.AddProp('ForcedWrites', 'Long', @IBDatabaseInfo_ForcedWrites);
    AType.AddProp('MaxMemory', 'Long', @IBDatabaseInfo_MaxMemory);
    AType.AddProp('NumBuffers', 'Long', @IBDatabaseInfo_NumBuffers);
    AType.AddProp('SweepInterval', 'Long', @IBDatabaseInfo_SweepInterval);
    AType.AddProp('UserNames', 'TStringList', @IBDatabaseInfo_UserNames);
    AType.AddProp('Fetches', 'Long', @IBDatabaseInfo_Fetches);
    AType.AddProp('Marks', 'Long', @IBDatabaseInfo_Marks);
    AType.AddProp('Reads', 'Long', @IBDatabaseInfo_Reads);
    AType.AddProp('Writes', 'Long', @IBDatabaseInfo_Writes);
    AType.AddProp('BackoutCount', 'TStringList', @IBDatabaseInfo_BackoutCount);
    AType.AddProp('DeleteCount', 'TStringList', @IBDatabaseInfo_DeleteCount);
    AType.AddProp('ExpungeCount', 'TStringList', @IBDatabaseInfo_ExpungeCount);
    AType.AddProp('InsertCount', 'TStringList', @IBDatabaseInfo_InsertCount);
    AType.AddProp('PurgeCount', 'TStringList', @IBDatabaseInfo_PurgeCount);
    AType.AddProp('ReadIdxCount', 'TStringList', @IBDatabaseInfo_ReadIdxCount);
    AType.AddProp('ReadSeqCount', 'TStringList', @IBDatabaseInfo_ReadSeqCount);
    AType.AddProp('UpdateCount', 'TStringList', @IBDatabaseInfo_UpdateCount);
    AType.AddProp('DBSQLDialect', 'Long', @IBDatabaseInfo_DBSQLDialect);
    AType.AddProp('ReadOnly', 'Long', @IBDatabaseInfo_ReadOnly);
  end
  else
  if AType.ValueClassType = TIBSQLMonitor then
  begin
    AType.AddMethod('procedure Release', @IBSQLMonitor_Release);
  end
  else
  if AType.ValueClassType = TIBBatchMove then
  begin
    AType.AddMethod('procedure Execute', @IBBatchMove_Execute);
    AType.AddProp('ChangedCount', 'Longint', @IBBatchMove_ChangedCount);
    AType.AddProp('KeyViolCount', 'Longint', @IBBatchMove_KeyViolCount);
    AType.AddProp('MovedCount', 'Longint', @IBBatchMove_MovedCount);
    AType.AddProp('ProblemCount', 'Longint', @IBBatchMove_ProblemCount);
  end
  else
  if AType.ValueClassType = TIBTable then
  begin
    AType.AddMethod('procedure AddIndex(const Name, Fields: string; Options: TIndexOptions; const DescFields: string = '''')', @IBTable_AddIndex);
    AType.AddMethod('procedure CreateTable', @IBTable_CreateTable);
    AType.AddMethod('procedure DeleteIndex(const Name: string)', @IBTable_DeleteIndex);
    AType.AddMethod('procedure DeleteTable', @IBTable_DeleteTable);
    AType.AddMethod('procedure EmptyTable', @IBTable_EmptyTable);
    AType.AddMethod('procedure GetIndexNames(List: TStrings)', @IBTable_GetIndexNames);
    AType.AddMethod('procedure GetDetailLinkFields(MasterFields, DetailFields: TList)', @IBTable_GetDetailLinkFields);
    AType.AddMethod('procedure GotoCurrent(Table: TIBTable)', @IBTable_GotoCurrent);
    AType.AddProp('Exists', 'Boolean', @IBTable_Exists);
    AType.AddProp('IndexFieldCount', 'Integer', @IBTable_IndexFieldCount);
    AType.AddProp('TableNames', 'TStrings', @IBTable_TableNames);
    AType.AddIndexedProp('IndexFields', 'TField', 'Integer', @IBTable_IndexFieldsGet, @IBTable_IndexFieldsSet);
  end
  else
  if AType.ValueClassType = TIBExtract then
  begin
    AType.AddMethod('function GetArrayField(FieldName : String) : String', @IBExtract_GetArrayField);
    AType.AddMethod('function GetFieldType(FieldType, FieldSubType, FieldScale, FieldSize, FieldPrec, FieldLen : Integer) : String', @IBExtract_GetFieldType);
    AType.AddMethod('function GetCharacterSets(CharSetId, Collation: integer; ACollateOnly: Boolean): String', @IBExtract_GetCharacterSets);
    AType.AddMethod('procedure ExtractObject(ObjectType : TExtractObjectTypes; ObjectName : String = ''; ExtractTypes : TExtractTypes = [])', @IBExtract_ExtractObject);
  end
  else
  if AType.ValueClassType = TIBBatch then
  begin
    AType.AddMethod('procedure ReadyFile', @IBBatch_ReadyFile);
    AType.AddProp('Columns', 'TIBXSQLDA', @IBBatch_Columns);
    AType.AddProp('Filename', 'String', @IBBatch_FilenameGet, @IBBatch_FilenameSet);
    AType.AddProp('Params', 'TIBXSQLDA', @IBBatch_Params);
  end
  else
  if AType.ValueClassType = TIBBatchInput then
  begin
    AType.AddMethod('function ReadParameters: Boolean', @IBBatchInput_ReadParameters);
  end
  else
  if AType.ValueClassType = TIBBatchOutput then
  begin
    AType.AddMethod('function WriteColumns: Boolean', @IBBatchOutput_WriteColumns);
  end
  else
  if AType.ValueClassType = TIBOutputDelimitedFile then
  begin
    AType.AddMethod('constructor Create', @IBOutputDelimitedFile_Create);
    AType.AddProp('ColDelimiter', 'string', @IBOutputDelimitedFile_ColDelimiterGet, @IBOutputDelimitedFile_ColDelimiterSet);
    AType.AddProp('OutputTitles', 'Boolean', @IBOutputDelimitedFile_OutputTitlesGet, @IBOutputDelimitedFile_OutputTitlesSet);
    AType.AddProp('RowDelimiter', 'string', @IBOutputDelimitedFile_RowDelimiterGet, @IBOutputDelimitedFile_RowDelimiterSet);
  end
  else
  if AType.ValueClassType = TIBInputDelimitedFile then
  begin
    AType.AddMethod('constructor Create', @IBInputDelimitedFile_Create);
    AType.AddMethod('function GetColumn(var Col: string): Integer', @IBInputDelimitedFile_GetColumn);
    AType.AddProp('ColDelimiter', 'string', @IBInputDelimitedFile_ColDelimiterGet, @IBInputDelimitedFile_ColDelimiterSet);
    AType.AddProp('ReadBlanksAsNull', 'Boolean', @IBInputDelimitedFile_ReadBlanksAsNullGet, @IBInputDelimitedFile_ReadBlanksAsNullSet);
    AType.AddProp('RowDelimiter', 'string', @IBInputDelimitedFile_RowDelimiterGet, @IBInputDelimitedFile_RowDelimiterSet);
    AType.AddProp('SkipTitles', 'Boolean', @IBInputDelimitedFile_SkipTitlesGet, @IBInputDelimitedFile_SkipTitlesSet);
  end
  else
  if AType.ValueClassType = TIBCustomService then
  begin
    AType.AddMethod('procedure Attach', @IBCustomService_Attach);
    AType.AddMethod('procedure Detach', @IBCustomService_Detach);
    AType.AddIndexedProp('ServiceParamBySPB', 'String', 'Integer', @IBCustomService_ServiceParamBySPBGet, @IBCustomService_ServiceParamBySPBSet);
  end
  else
  if AType.ValueClassType = TIBControlService then
  begin
    AType.AddMethod('procedure ServiceStart', @IBControlService_ServiceStart);
    AType.AddProp('IsServiceRunning', 'Boolean', @IBControlService_IsServiceRunning);
  end
  else
  if AType.ValueClassType = TIBControlAndQueryService then
  begin
    AType.AddMethod('function GetNextLine: String', @IBControlAndQueryService_GetNextLine);
    AType.AddMethod('function GetNextChunk: String', @IBControlAndQueryService_GetNextChunk);
    AType.AddProp('Eof', 'boolean', @IBControlAndQueryService_Eof);
  end
  else
  if AType.ValueClassType = TIBConfigService then
  begin
    AType.AddMethod('procedure ShutdownDatabase (Options: TShutdownMode; Wait: Integer)', @IBConfigService_ShutdownDatabase);
    AType.AddMethod('procedure SetSweepInterval (Value: Integer)', @IBConfigService_SetSweepInterval);
    AType.AddMethod('procedure SetDBSqlDialect (Value: Integer)', @IBConfigService_SetDBSqlDialect);
    AType.AddMethod('procedure SetPageBuffers (Value: Integer)', @IBConfigService_SetPageBuffers);
    AType.AddMethod('procedure ActivateShadow', @IBConfigService_ActivateShadow);
    AType.AddMethod('procedure BringDatabaseOnline', @IBConfigService_BringDatabaseOnline);
    AType.AddMethod('procedure SetReserveSpace (Value: Boolean)', @IBConfigService_SetReserveSpace);
    AType.AddMethod('procedure SetAsyncMode (Value: Boolean)', @IBConfigService_SetAsyncMode);
    AType.AddMethod('procedure SetReadOnly (Value: Boolean)', @IBConfigService_SetReadOnly);
  end
  else
  if AType.ValueClassType = TLimboTransactionInfo then
  begin
    AType.AddProp('MultiDatabase', 'Boolean', @LimboTransactionInfo_MultiDatabaseGet, @LimboTransactionInfo_MultiDatabaseSet);
    AType.AddProp('ID', 'Integer', @LimboTransactionInfo_IDGet, @LimboTransactionInfo_IDSet);
    AType.AddProp('HostSite', 'String', @LimboTransactionInfo_HostSiteGet, @LimboTransactionInfo_HostSiteSet);
    AType.AddProp('RemoteSite', 'String', @LimboTransactionInfo_RemoteSiteGet, @LimboTransactionInfo_RemoteSiteSet);
    AType.AddProp('RemoteDatabasePath', 'String', @LimboTransactionInfo_RemoteDatabasePathGet, @LimboTransactionInfo_RemoteDatabasePathSet);
    AType.AddProp('State', 'TTransactionState', @LimboTransactionInfo_StateGet, @LimboTransactionInfo_StateSet);
    AType.AddProp('Advise', 'TTransactionAdvise', @LimboTransactionInfo_AdviseGet, @LimboTransactionInfo_AdviseSet);
    AType.AddProp('Action', 'TTransactionAction', @LimboTransactionInfo_ActionGet, @LimboTransactionInfo_ActionSet);
  end
  else
  if AType.ValueClassType = TIBValidationService then
  begin
    AType.AddMethod('procedure FetchLimboTransactionInfo', @IBValidationService_FetchLimboTransactionInfo);
    AType.AddMethod('procedure FixLimboTransactionErrors', @IBValidationService_FixLimboTransactionErrors);
    AType.AddIndexedProp('LimboTransactionInfo', 'TLimboTransactionInfo', 'integer', @IBValidationService_LimboTransactionInfo);
    AType.AddProp('LimboTransactionInfoCount', 'Integer', @IBValidationService_LimboTransactionInfoCount);
  end
  else
  if AType.ValueClassType = TUserInfo then
  begin
    AType.AddProp('UserName', 'string', @UserInfo_UserNameGet, @UserInfo_UserNameSet);
    AType.AddProp('FirstName', 'string', @UserInfo_FirstNameGet, @UserInfo_FirstNameSet);
    AType.AddProp('MiddleName', 'string', @UserInfo_MiddleNameGet, @UserInfo_MiddleNameSet);
    AType.AddProp('LastName', 'string', @UserInfo_LastNameGet, @UserInfo_LastNameSet);
    AType.AddProp('GroupID', 'Integer', @UserInfo_GroupIDGet, @UserInfo_GroupIDSet);
    AType.AddProp('UserID', 'Integer', @UserInfo_UserIDGet, @UserInfo_UserIDSet);
  end
  else
  if AType.ValueClassType = TIBSecurityService then
  begin
    AType.AddMethod('procedure DisplayUsers', @IBSecurityService_DisplayUsers);
    AType.AddMethod('procedure DisplayUser(UserName: string)', @IBSecurityService_DisplayUser);
    AType.AddMethod('procedure AddUser', @IBSecurityService_AddUser);
    AType.AddMethod('procedure DeleteUser', @IBSecurityService_DeleteUser);
    AType.AddMethod('procedure ModifyUser', @IBSecurityService_ModifyUser);
    AType.AddIndexedProp('UserInfo', 'TUserInfo', 'Integer', @IBSecurityService_UserInfo);
    AType.AddProp('UserInfoCount', 'Integer', @IBSecurityService_UserInfoCount);
  end
  else
  if AType.ValueClassType = TIBBlobStream then
  begin
    AType.AddMethod('procedure Finalize', @IBBlobStream_Finalize);
    AType.AddMethod('procedure LoadFromFile(Filename: string)', @IBBlobStream_LoadFromFile);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @IBBlobStream_LoadFromStream);
    AType.AddMethod('procedure SaveToFile(Filename: string)', @IBBlobStream_SaveToFile);
    AType.AddMethod('procedure SaveToStream(Stream: TStream)', @IBBlobStream_SaveToStream);
    AType.AddMethod('procedure Truncate', @IBBlobStream_Truncate);
    AType.AddMethod('procedure CheckReadable', @IBBlobStream_CheckReadable);
    AType.AddMethod('procedure CheckWritable', @IBBlobStream_CheckWritable);
    AType.AddProp('Mode', 'TBlobStreamMode', @IBBlobStream_ModeGet, @IBBlobStream_ModeSet);
    AType.AddProp('Modified', 'Boolean', @IBBlobStream_ModifiedGet);
    AType.AddProp('Database', 'TIBDatabase', @IBBlobStream_DatabaseGet, @IBBlobStream_DatabaseSet);
  end;
end;

procedure TIBXImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TIBDatabaseLoginEvent), TIBDatabaseLoginEventHandler);
  RegisterHandler(TypeInfo(TLoginEvent), TLoginEventHandler);
  RegisterHandler(TypeInfo(TSQLEvent), TSQLEventHandler);
  RegisterHandler(TypeInfo(TEventAlert), TEventAlertHandler);
  RegisterHandler(TypeInfo(TIBUpdateErrorEvent), TIBUpdateErrorEventHandler);
  RegisterHandler(TypeInfo(TIBUpdateRecordEvent), TIBUpdateRecordEventHandler);
end;

procedure TIBXImport.AddMethods(AddMethod: TAddMethodProc);
begin
  AddMethod('procedure EnableMonitoring', @IBSQLMinitor_EnableMonitoring);
  AddMethod('procedure DisableMonitoring', @IBSQLMinitor_DisableMonitoring);
  AddMethod('function MonitoringEnabled: Boolean', @IBSQLMinitor_MonitoringEnabled);
  AddMethod('procedure SetIBDataBaseErrorMessages(Value: TIBDataBaseErrorMessages)', @IBError_SetIBDataBaseErrorMessages);
end;

end.

