{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit EnvOptions;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, SynHighlighterPas, SynEdit, Forms, Controls,
  Graphics, Dialogs, ComCtrls, StdCtrls, Spin, ExtCtrls, ColorBox, Buttons;

type

  { TEnvOptForm }

  TEnvOptForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    FirstSelectThenDrag: TCheckBox;
    ColorBox3: TColorBox;
    FontSizeEdit: TEdit;
    FontEdit: TEdit;
    FontDialog1: TFontDialog;
    GroupBox1: TGroupBox;
    Label8: TLabel;
    Panel1: TPanel;
    IconSizeGroup: TRadioGroup;
    TabSheet4: TTabSheet;
    SingleButtonBox: TCheckBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    RadioGroup3: TRadioGroup;
    SpeedButton1: TSpeedButton;
    SynPasSyn1: TSynPasSyn;
    ColorBox1: TColorBox;
    ColorBox2: TColorBox;
    Label2: TLabel;
    Label3: TLabel;
    ListBox1: TListBox;
    ShowHints: TCheckBox;
    PaintGird: TCheckBox;
    Label1: TLabel;
    PageControl1: TPageControl;
    GridStepEdit: TSpinEdit;
    MoveOjbParam: TRadioGroup;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TranscriptGroup: TRadioGroup;
    procedure CheckBox1Change(Sender: TObject);
    procedure CheckBox2Change(Sender: TObject);
    procedure CheckBox3Change(Sender: TObject);
    procedure ColorBox1Change(Sender: TObject);
    procedure ColorBox2Change(Sender: TObject);
    procedure FontEditChange(Sender: TObject);
    procedure FontSizeEditChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    SynEdit: TSynEdit;
  public
  end;

var
  EnvOptForm: TEnvOptForm;

implementation

uses SynEditHighlighter;

{$R *.lfm}

{ TEnvOptForm }

procedure TEnvOptForm.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  CloseAction:= caHide;
end;

procedure TEnvOptForm.FormCreate(Sender: TObject);
begin
  SynEdit := TSynEdit.Create(Self);
  SynEdit.Parent := Panel1;
  SynEdit.Align:= alClient;
  //SynEdit.Left:= 210;
  //SynEdit.Top := 8;
  //SynEdit.Width:= 446;
  //SynEdit.Height:= 378;
  SynEdit.Lines.Add('{Comment}');
  SynEdit.Lines.Add('');
  SynEdit.Lines.Add('procedure  TForm1.Button1Click(Sender: TObject);');
  SynEdit.Lines.Add('var');
  SynEdit.Lines.Add('  I, Num: Integer;');
  SynEdit.Lines.Add('begin');
  SynEdit.Lines.Add('  Num := 12365 + (125.36 / 25.36);');
  SynEdit.Lines.Add('  for I := 1 to 3 do');
  SynEdit.Lines.Add('  begin');
  SynEdit.Lines.Add('     //Comment');
  SynEdit.Lines.Add('    ShowMessage(''Value = '' + IntToStr(I));');
  SynEdit.Lines.Add('  end;');
  SynEdit.Lines.Add('end;');
  SynEdit.Font.Quality := fqDefault;
  SynEdit.Highlighter := SynPasSyn1;
end;

procedure TEnvOptForm.ColorBox2Change(Sender: TObject);
var
  Attri: TSynHighlighterAttributes;
begin
  Attri := TSynHighlighterAttributes(ListBox1.Items.Objects[ListBox1.ItemIndex]);
  Attri.Background:= ColorBox2.Selected;
end;

procedure TEnvOptForm.FontEditChange(Sender: TObject);
begin
  SynEdit.Font.Name := FontEdit.Text;
end;

procedure TEnvOptForm.FontSizeEditChange(Sender: TObject);
begin
  if FontSizeEdit.Text <> '' then
    SynEdit.Font.Size := StrToInt(FontSizeEdit.Text)
  else
    SynEdit.Font.Size := 10;
end;

procedure TEnvOptForm.CheckBox2Change(Sender: TObject);
var
  Attri: TSynHighlighterAttributes;
begin
  Attri := TSynHighlighterAttributes(ListBox1.Items.Objects[ListBox1.ItemIndex]);
  if CheckBox2.Checked then
    Attri.Style := Attri.Style + [fsBold]
  else
    Attri.Style := Attri.Style - [fsBold];
end;

procedure TEnvOptForm.CheckBox3Change(Sender: TObject);
var
  Attri: TSynHighlighterAttributes;
begin
  Attri := TSynHighlighterAttributes(ListBox1.Items.Objects[ListBox1.ItemIndex]);
  if CheckBox3.Checked then
    Attri.Style := Attri.Style + [fsItalic]
  else
    Attri.Style := Attri.Style - [fsItalic];
end;

procedure TEnvOptForm.ColorBox1Change(Sender: TObject);
var
  Attri: TSynHighlighterAttributes;
begin
  Attri := TSynHighlighterAttributes(ListBox1.Items.Objects[ListBox1.ItemIndex]);
  Attri.Foreground:= ColorBox1.Selected;
end;


procedure TEnvOptForm.CheckBox1Change(Sender: TObject);
var
  Attri: TSynHighlighterAttributes;
begin
  Attri := TSynHighlighterAttributes(ListBox1.Items.Objects[ListBox1.ItemIndex]);
  if CheckBox1.Checked then
    Attri.Style := Attri.Style + [fsUnderline]
  else
    Attri.Style := Attri.Style - [fsUnderline];
end;

procedure TEnvOptForm.FormShow(Sender: TObject);
begin
  ListBox1.Items.AddObject('Комментарии', SynPasSyn1.CommentAttri);
  ListBox1.Items.AddObject('Ключевые слова', SynPasSyn1.KeyAttri);
  ListBox1.Items.AddObject('Строки', SynPasSyn1.StringAttri);
  ListBox1.Items.AddObject('Числа', SynPasSyn1.NumberAttri);
  ListBox1.Items.AddObject('Символы', SynPasSyn1.SymbolAttri);
end;

procedure TEnvOptForm.ListBox1Click(Sender: TObject);
var
  Attri: TSynHighlighterAttributes;
begin
  if ListBox1.ItemIndex >= 0 then
  begin
    Attri := TSynHighlighterAttributes(ListBox1.Items.Objects[ListBox1.ItemIndex]);
    ColorBox1.OnChange := nil;
    ColorBox2.OnChange := nil;
    CheckBox1.OnChange := nil;
    CheckBox2.OnChange := nil;
    CheckBox3.OnChange := nil;
    ColorBox1.Selected := Attri.Foreground;
    ColorBox2.Selected := Attri.Background;
    CheckBox1.Checked := fsUnderline in Attri.Style;
    CheckBox2.Checked := fsBold in Attri.Style;
    CheckBox3.Checked := fsItalic in Attri.Style;
    ColorBox1.OnChange := @ColorBox1Change;
    ColorBox2.OnChange := @ColorBox2Change;
    CheckBox1.OnChange := @CheckBox1Change;
    CheckBox2.OnChange := @CheckBox2Change;
    CheckBox3.OnChange := @CheckBox3Change;
  end;
end;

procedure TEnvOptForm.SpeedButton1Click(Sender: TObject);
begin
  FontDialog1.Font.Name:= FontEdit.Text;
  if FontSizeEdit.Text <> '' then;
  FontDialog1.Font.Size := StrToInt(FontSizeEdit.Text);
  if FontDialog1.Execute then
  begin
    FontEdit.Text := FontDialog1.Font.Name;
    FontSizeEdit.Text := IntToStr(FontDialog1.Font.Size);
    SynEdit.Font.Name := FontEdit.Text;
    SynEdit.Font.Size := FontDialog1.Font.Size;
  end;
end;

end.

