unit dpi_fpspreadsheet;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, dpCompil, fpspreadsheet, dpUtils,
  xlsbiff2, xlsbiff5, xlsbiff8, fpsopendocument, xlsxooxml, fpsTypes,
  fpspreadsheetgrid, fpspreadsheetctrls, dpi_mettyps;

type
  {TSpFormula = class
  private
    AFormula: TsFormula;
  published
    property FormulaStr: string read AFormula.FormulaStr write AFormula.FormulaStr;
    property DoubleValue: Double read AFormula.DoubleValue write AFormula.DoubleValue;
  end;}


  PsUsedFormattingFields = ^TsUsedFormattingFields;

  { TSpradSheetImport }

  TSpradSheetImport = class(TClassImporter)
    function sCellCombobox_AddColor(Instance: TObject; var Params: Variant
      ): Variant;
    function sPalette_AddColor(Instance: TObject; var Params: Variant): Variant;
    function sPalette_AddExcelColors(Instance: TObject; var Params: Variant
      ): Variant;
    function sPalette_AddUniqueColor(Instance: TObject; var Params: Variant
      ): Variant;
    function sPalette_Clear(Instance: TObject; var Params: Variant): Variant;
    function sPalette_CollectFromWorkbook(Instance: TObject; var Params: Variant
      ): Variant;
    function sPalette_ColorUsedInWorkbook(Instance: TObject; var Params: Variant
      ): Variant;
    function sPalette_Count(Instance: TObject; var Params: Variant): Variant;
    function sPalette_Create(Instance: TObject; var Params: Variant): Variant;
    function sPalette_FindClosestColorIndex(Instance: TObject;
      var Params: Variant): Variant;
    function sPalette_FindColor(Instance: TObject; var Params: Variant
      ): Variant;
    function sPalette_GetColors(Instance: TObject; var Params: Variant
      ): Variant;
    function sPalette_SetColors(Instance: TObject; var Params: Variant
      ): Variant;
    function sPalette_Trim(Instance: TObject; var Params: Variant): Variant;
    function sWorkbookSource_CreateNewWorkbook(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkbookSource_LoadFromSpreadsheetFile(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkbookSource_LoadFromWorkbook(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkbookSource_SaveToSpreadsheetFile(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkbookSource_WorkbookGet(Instance: Pointer): Variant;
    function sWorkbookSource_WorksheetGet(Instance: Pointer): Variant;
    function sWorkbook_AddFont(Instance: TObject; var Params: Variant): Variant;
    function sWorkbook_AddWorksheet(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_Create(Instance: TObject; var Params: Variant): Variant;
    function sWorkbook_FindFont(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_GetFirstWorksheet(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_GetFontCount(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_GetWorksheetByIndex(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkbook_GetWorksheetByName(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_GetWorksheetCount(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_InitFonts(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_ReadFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_ReadFromFileFormat(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_ReadFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_RemoveAllFonts(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_RemoveAllWorksheets(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkbook_SetDefaultFont(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_WriteToFile(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_WriteToFileFormat(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_WriteToStream(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_AutoColWidth(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_AutoRowHeight(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_BackgroundColorGet(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_BackgroundColorSet(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_BackgroundColorsGet(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_BackgroundColorsSet(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_BeginUpdate(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_CellBorderGet(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_CellBorderSet(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_CellBordersGet(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_CellBordersSet(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_CellsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_CellsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_Clear(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_ColGet(Instance: Pointer): Variant;
    procedure sWorkSheetGird_ColSet(Instance: Pointer; AValue: Variant);
    function sWorkSheetGird_Convert_Font_to_sFont(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_Convert_sFont_to_Font(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_DeleteCol(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_DeleteRow(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_EditingDone(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_EndUpdate(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_GetCellComment(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetCellFont(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_GetCellFontColor(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetCellFontColors(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetCellFontName(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetCellFontNames(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetCellFonts(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_GetCellFontSize(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetCellFontSizes(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetCellFontStyle(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetCellFontStyles(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetCellLineColor(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetCellLineColors(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetCellLineStyle(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetCellLineStyles(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetColWidths(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_GetDefaultColWidth(Instance: Pointer): Variant;
    function sWorkSheetGird_GetDefaultRowHeight(Instance: Pointer): Variant;
    function sWorkSheetGird_GetGridCol(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_GetGridRow(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_GetHorAlignment(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetHorAlignments(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetHyperlink(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_GetNumberFormat(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetRowHeights(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_GetSelectionBottom(Instance: Pointer): Variant;
    function sWorkSheetGird_GetSelectionLeft(Instance: Pointer): Variant;
    function sWorkSheetGird_GetSelectionRight(Instance: Pointer): Variant;
    function sWorkSheetGird_GetSelectionTop(Instance: Pointer): Variant;
    function sWorkSheetGird_GetSheets(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_GetTextRotation(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetTextRotations(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetVertAlignment(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetVertAlignments(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetWordwrap(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_GetWordwraps(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_GetWorksheetCol(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetWorksheetRow(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_GetZoomFactor(Instance: Pointer): Variant;
    function sWorkSheetGird_HeaderCountGet(Instance: Pointer): Variant;
    function sWorkSheetGird_InsertCol(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_InsertRow(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_LoadFromSpreadsheetFile(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_LoadFromWorkbook(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_MergeCells(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_NewWorkbook(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_RemoveWorkbookSource(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_RowGet(Instance: Pointer): Variant;
    procedure sWorkSheetGird_RowSet(Instance: Pointer; AValue: Variant);
    function sWorkSheetGird_SaveToSpreadsheetFile(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SelectSheetByIndex(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetBorderLine(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_SetBorderLines(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_SetCellComment(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetCellFont(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_SetCellFontColor(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetCellFontColors(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetCellFontName(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetCellFontNames(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetCellFonts(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_SetCellFontSize(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetCellFontSizes(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetCellFontStyle(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetCellFontStyles(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetCellLineColor(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetCellLineColors(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetCellLineStyle(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetCellLineStyles(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetColWidths(Instance: TObject; var Params: Variant
      ): Variant;
    procedure sWorkSheetGird_SetDefaultColWidth(Instance: Pointer;
      AValue: Variant);
    procedure sWorkSheetGird_SetDefaultRowHeight(Instance: Pointer;
      AValue: Variant);
    function sWorkSheetGird_SetHorAlignment(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetHorAlignments(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetHyperlink(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_SetNumberFormat(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetRowHeights(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_SetSelection(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_SetTextRotation(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetTextRotations(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetVertAlignment(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetVertAlignments(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_SetWordwrap(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_SetWordwraps(Instance: TObject; var Params: Variant
      ): Variant;
    procedure sWorkSheetGird_SetZoomFactor(Instance: Pointer; AValue: Variant);
    function sWorkSheetGird_UnmergeCells(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkSheetGird_UpdateColWidth(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_UpdateColWidths(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_UpdateRowHeight(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_UpdateRowHeights(Instance: TObject;
      var Params: Variant): Variant;
    function sWorkSheetGird_WorkbookGet(Instance: Pointer): Variant;
    function sWorkSheetGird_WorksheetGet(Instance: Pointer): Variant;
    function sWorksheet_ActiveCellColGet(Instance: Pointer): Variant;
    function sWorksheet_ActiveCellRowGet(Instance: Pointer): Variant;
    function sWorksheet_BottomMarginGet(Instance: Pointer): Variant;
    procedure sWorksheet_BottomMarginSet(Instance: Pointer; AValue: Variant);
    function sWorksheet_CalcAutoRowHeight(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_CellPosToText(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_CopyCell(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_CopyFormat(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_Create(Instance: TObject; var Params: Variant): Variant;
    function sWorksheet_DefaultColWidthGet(Instance: Pointer): Variant;
    procedure sWorksheet_DefaultColWidthSet(Instance: Pointer; AValue: Variant);
    function sWorksheet_DefaultRowHeightGet(Instance: Pointer): Variant;
    procedure sWorksheet_DefaultRowHeightSet(Instance: Pointer; AValue: Variant
      );
    function sWorksheet_DeleteCol(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_DeleteRow(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_EraseCell(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_FindMergedRange(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_FitHeightToPagesGet(Instance: Pointer): Variant;
    procedure sWorksheet_FitHeightToPagesSet(Instance: Pointer; AValue: Variant
      );
    function sWorksheet_FitWidthToPagesGet(Instance: Pointer): Variant;
    procedure sWorksheet_FitWidthToPagesSet(Instance: Pointer; AValue: Variant);
    function sWorksheet_FooterMarginGet(Instance: Pointer): Variant;
    procedure sWorksheet_FooterMarginSet(Instance: Pointer; AValue: Variant);
    function sWorksheet_GetCellCount(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_GetCellCountInCol(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_GetCellCountInRow(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_GetColWidth(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_GetLastColIndex(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_GetLastRowIndex(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_GetRowHeight(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_HasComment(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_HasHyperlink(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_HeaderMarginGet(Instance: Pointer): Variant;
    procedure sWorksheet_HeaderMarginSet(Instance: Pointer; AValue: Variant);
    function sWorksheet_InsertCol(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_InsertRow(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_IsMerged(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_LeftMarginGet(Instance: Pointer): Variant;
    procedure sWorksheet_LeftMarginSet(Instance: Pointer; AValue: Variant);
    function sWorksheet_LeftPaneWidthGet(Instance: Pointer): Variant;
    procedure sWorksheet_LeftPaneWidthSet(Instance: Pointer; AValue: Variant);
    function sWorksheet_MergeCells(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_MergeCellsRange(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_OptionsGet(Instance: Pointer): Variant;
    procedure sWorksheet_OptionsSet(Instance: Pointer; AValue: Variant);
    function sWorksheet_PageOrientationGet(Instance: Pointer): Variant;
    procedure sWorksheet_PageOrientationSet(Instance: Pointer; AValue: Variant);
    function sWorksheet_ReadAsDateTime(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_ReadAsNumber(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_ReadAsUTF8Text(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_ReadBackgroundColor(Instance: TObject;
      var Params: Variant): Variant;
    function sWorksheet_ReadComment(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_ReadFormulaAsString(Instance: TObject;
      var Params: Variant): Variant;
    function sWorksheet_ReadHyperlink(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_ReadUsedFormatting(Instance: TObject;
      var Params: Variant): Variant;
    function sWorksheet_RemoveAllCols(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_RemoveAllRows(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_RemoveCol(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_RemoveHyperlink(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_RemoveRow(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_RightMarginGet(Instance: Pointer): Variant;
    procedure sWorksheet_RightMarginSet(Instance: Pointer; AValue: Variant);
    function sWorksheet_TopMarginGet(Instance: Pointer): Variant;
    procedure sWorksheet_TopMarginSet(Instance: Pointer; AValue: Variant);
    function sWorksheet_TopPaneHeightGet(Instance: Pointer): Variant;
    procedure sWorksheet_TopPaneHeightSet(Instance: Pointer; AValue: Variant);
    function sWorksheet_WorkbookGet(Instance: Pointer): Variant;
    function sWorksheet_WriteBackground(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteBackgroundColor(Instance: TObject;
      var Params: Variant): Variant;
    function sWorksheet_WriteBlank(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteBoolValue(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteBorderColor(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteBorderLineStyle(Instance: TObject;
      var Params: Variant): Variant;
    function sWorksheet_WriteBorders(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteBorderStyleColor(Instance: TObject;
      var Params: Variant): Variant;
    function sWorksheet_WriteCellValueAsString(Instance: TObject;
      var Params: Variant): Variant;
    function sWorksheet_WriteColWidth(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteComment(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteCurrency(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteCurrencyF(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteDateTime(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteDateTimeF(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteDecimals(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteFont(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteFontColor(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteFontF(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteFontName(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteFontSize(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteFontStyle(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteFormula(Instance: TObject; var Params: Variant
      ): Variant;
    //function sWorksheet_WriteFormula(Instance: TObject; var Params: Variant
    //  ): Variant;
    function sWorksheet_WriteHorAlignment(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteHyperlink(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteNumber(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteNumberF(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteNumberFormat(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteRowHeight(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteTextRotation(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteUsedFormatting(Instance: TObject;
      var Params: Variant): Variant;
    function sWorksheet_WriteUTF8Text(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorksheet_WriteVertAlignment(Instance: TObject;
      var Params: Variant): Variant;
    function sWorksheet_WriteWordwrap(Instance: TObject; var Params: Variant
      ): Variant;
  private
    function Call_GetColString(Instance: TObject; var Params: Variant): Variant;
    function sWorkbook_GetLastWorksheet(Instance: TObject; var Params: Variant
      ): Variant;
    function sWorkbook_GetNextWorksheet(Instance: TObject; var Params: Variant
      ): Variant;
  public
    PUF: PsUsedFormattingFields;
    procedure AddConsts(AddConst: TAddConstProc); override;
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure AddMethods(AddMethod: TAddMethodProc); override;
  end;

implementation

uses
  FileUtil, Graphics, fpsutils, fpsPalette, math;

type
  PsCellBorders = ^TsCellBorders;
  PsFontStyles = ^TsFontStyles;
  PsSheetOptions = ^TsSheetOptions;

var
  CellBord: TsCellBorders;
  AFntStyle: TsFontStyles;

{ TSpradSheetImport }

{function TSpradSheetImport.spFormula_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TSpFormula.Create );
end;}

function TSpradSheetImport.sCellCombobox_AddColor(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsCellCombobox(Instance).AddColor(Params[0], Params[1]);
end;

function TSpradSheetImport.sPalette_AddColor(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsPalette(Instance).AddColor(Params[0], Params[1]);
end;

function TSpradSheetImport.sPalette_AddExcelColors(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsPalette(Instance).AddExcelColors;
end;

function TSpradSheetImport.sPalette_AddUniqueColor(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsPalette(Instance).AddUniqueColor(Params[0], Params[1]);
end;

function TSpradSheetImport.sPalette_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TsPalette(Instance).Clear;
end;

function TSpradSheetImport.sPalette_CollectFromWorkbook(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsPalette(Instance).CollectFromWorkbook(TsWorkbook(TSuPtr(Params[0])));
end;

function TSpradSheetImport.sPalette_ColorUsedInWorkbook(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsPalette(Instance).ColorUsedInWorkbook(Params[0], TsWorkbook(TSuPtr(Params[1])));
end;

function TSpradSheetImport.sPalette_Count(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TsPalette(Instance).Count;
end;

function TSpradSheetImport.sPalette_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TsPalette.Create );
end;

function TSpradSheetImport.sPalette_FindClosestColorIndex(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsPalette(Instance).FindClosestColorIndex(Params[0], Params[1]);
end;

function TSpradSheetImport.sPalette_FindColor(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsPalette(Instance).FindColor(Params[0], Params[1]);
end;

function TSpradSheetImport.sPalette_GetColors(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsPalette(Instance).Colors[Params[0]];
end;

function TSpradSheetImport.sPalette_SetColors(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsPalette(Instance).Colors[Params[0]] := Params[1];
end;

function TSpradSheetImport.sPalette_Trim(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TsPalette(Instance).Trim(Params[0]);
end;

function TSpradSheetImport.sWorkbookSource_CreateNewWorkbook(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorkbookSource(Instance).CreateNewWorkbook;
end;

function TSpradSheetImport.sWorkbookSource_LoadFromSpreadsheetFile(
  Instance: TObject; var Params: Variant): Variant;
begin
  TsWorkbookSource(Instance).LoadFromSpreadsheetFile(Params[0], Params[1], Params[2]);
end;

function TSpradSheetImport.sWorkbookSource_LoadFromWorkbook(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorkbookSource(Instance).LoadFromWorkbook(TsWorkbook(TSuPtr(Params[0])), Params[1]);
end;

function TSpradSheetImport.sWorkbookSource_SaveToSpreadsheetFile(
  Instance: TObject; var Params: Variant): Variant;
begin
  TsWorkbookSource(Instance).SaveToSpreadsheetFile(Params[0], Params[1]);
end;

function TSpradSheetImport.sWorkbookSource_WorkbookGet(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( TsWorkbookSource(Instance).Workbook );
end;

function TSpradSheetImport.sWorkbookSource_WorksheetGet(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( TsWorkbookSource(Instance).Worksheet );
end;

function TSpradSheetImport.sWorkbook_AddFont(Instance: TObject;
  var Params: Variant): Variant;
var
  AFontName: String;
  ASize: Single;
  AStyle: PsFontStyles;
  AColor: TsColor;
begin
  AFontName:= Params[0];
  ASize:= Params[1];
  AStyle := PsFontStyles(TSuPtr(Params[2]));
  AColor:= Params[3];
  Result := TsWorkbook(Instance).AddFont(AFontName, ASize, AStyle^, AColor);
end;

function TSpradSheetImport.sWorkbook_AddWorksheet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TsWorkbook(Instance).AddWorksheet(Params[0]));
end;

function TSpradSheetImport.sWorkbook_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TsWorkbook.Create );
end;

function TSpradSheetImport.sWorkbook_FindFont(Instance: TObject;
  var Params: Variant): Variant;
var
  AFontName: String;
  ASize: Single;
  AStyle: PsFontStyles;
  AColor: TsColor;
begin
  AFontName:= Params[0];
  ASize:= Params[1];
  AStyle := PsFontStyles(TSuPtr(Params[2]));
  AColor:= Params[3];
  Result := TsWorkbook(Instance).FindFont(AFontName, ASize, AStyle^, AColor);
end;

function TSpradSheetImport.sWorkbook_GetFirstWorksheet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TsWorkbook(Instance).GetFirstWorksheet );
end;

function TSpradSheetImport.sWorkbook_GetFontCount(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorkbook(Instance).GetFontCount;
end;

function TSpradSheetImport.sWorkbook_GetWorksheetByIndex(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TsWorkbook(Instance).GetWorksheetByIndex(Params[0]) );
end;

function TSpradSheetImport.sWorkbook_GetWorksheetByName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TsWorkbook(Instance).GetWorksheetByName(Params[0]) );
end;

function TSpradSheetImport.sWorkbook_GetWorksheetCount(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorkbook(Instance).GetWorksheetCount;
end;

function TSpradSheetImport.sWorkbook_InitFonts(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorkbook(Instance).InitFonts;
end;

function TSpradSheetImport.sWorkbook_ReadFromFile(Instance: TObject;
  var Params: Variant): Variant;
var
  FlName: string;
begin
  FlName:= Params[0];
  TsWorkbook(Instance).ReadFromFile(FlName);
end;

function TSpradSheetImport.sWorkbook_ReadFromFileFormat(Instance: TObject;
  var Params: Variant): Variant;
var
  FlName: String;
  AFormat: TsSpreadsheetFormat;
begin
  FlName:= Params[0];
  AFormat:= Params[1];
  TsWorkbook(Instance).ReadFromFile(FlName, AFormat);
end;

function TSpradSheetImport.sWorkbook_ReadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorkbook(Instance).ReadFromStream(TStream(TSuPtr(Params[0])), Params[1]);
end;

function TSpradSheetImport.sWorkbook_RemoveAllFonts(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorkbook(Instance).RemoveAllFonts;
end;

function TSpradSheetImport.sWorkbook_RemoveAllWorksheets(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorkbook(Instance).RemoveAllWorksheets;
end;

function TSpradSheetImport.sWorkbook_SetDefaultFont(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorkbook(Instance).SetDefaultFont(Params[0], Params[1]);
end;

function TSpradSheetImport.sWorkbook_WriteToFile(Instance: TObject;
  var Params: Variant): Variant;
var
  AFileName: string;
  AOverride: Boolean;
begin
  AFileName:= Params[0];
  AOverride:= Params[1];
  TsWorkbook(Instance).WriteToFile(AFileName, AOverride);
end;

function TSpradSheetImport.sWorkbook_WriteToFileFormat(Instance: TObject;
  var Params: Variant): Variant;
var
  AFileName: string;
  AFormat: TsSpreadsheetFormat;
  AOverwriteExisting: Boolean;
begin
  AFileName:= Params[0];
  AFormat:= Params[1];
  AOverwriteExisting:= Params[2];
  TsWorkbook(Instance).WriteToFile(AFileName, AFormat, AOverwriteExisting);
end;

function TSpradSheetImport.sWorkbook_WriteToStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorkbook(Instance).WriteToStream(TStream(TSuPtr(Params[0])), Params[1]);
end;

function TSpradSheetImport.sWorkSheetGird_AutoColWidth(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).AutoColWidth(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_AutoRowHeight(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).AutoRowHeight(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_BackgroundColorGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).BackgroundColor[Params[0], Params[1]];
end;

function TSpradSheetImport.sWorkSheetGird_BackgroundColorSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).BackgroundColor[Params[0], Params[1]] := Params[2];
end;

function TSpradSheetImport.sWorkSheetGird_BackgroundColorsGet(
  Instance: TObject; var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).BackgroundColors[Params[0], Params[1], Params[2], Params[3]];
end;

function TSpradSheetImport.sWorkSheetGird_BackgroundColorsSet(
  Instance: TObject; var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).BackgroundColors[Params[0], Params[1], Params[2], Params[3]] := Params[4];
end;

function TSpradSheetImport.sWorkSheetGird_BeginUpdate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).BeginUpdate;
end;

function TSpradSheetImport.sWorkSheetGird_CellBorderGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  CellBord := TsWorksheetGrid(Instance).CellBorder[Params[0], Params[1]];
  Result := TSuPtr(@CellBord);
end;

function TSpradSheetImport.sWorkSheetGird_CellBorderSet(Instance: TObject;
  var Params: Variant): Variant;
var
  ABorders: PsCellBorders;
begin
  ABorders:= PsCellBorders(TSuPtr(Params[2]));
  TsWorksheetGrid(Instance).CellBorder[Params[0], Params[1]] := ABorders^;
end;

function TSpradSheetImport.sWorkSheetGird_CellBordersGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  CellBord := TsWorksheetGrid(Instance).CellBorders[Params[0], Params[1], Params[2], Params[3]];
  Result := TSuPtr(@CellBord);
end;

function TSpradSheetImport.sWorkSheetGird_CellBordersSet(Instance: TObject;
  var Params: Variant): Variant;
var
  ABorders: PsCellBorders;
begin
  ABorders := PsCellBorders(TSuPtr( Params[4] ));
  TsWorksheetGrid(Instance).CellBorders[Params[0], Params[1], Params[2], Params[3]] := ABorders^;
end;

function TSpradSheetImport.sWorkSheetGird_CellsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).Cells[Params[0], Params[1]];
end;

function TSpradSheetImport.sWorkSheetGird_CellsSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).Cells[Params[0], Params[1]] := Params[2];
end;

function TSpradSheetImport.sWorkSheetGird_Clear(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).Clear;
end;

function TSpradSheetImport.sWorkSheetGird_ColGet(Instance: Pointer): Variant;
begin
  Result := TsWorksheetGrid(Instance).Col;
end;

procedure TSpradSheetImport.sWorkSheetGird_ColSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheetGrid(Instance).Col := AValue;
end;

function TSpradSheetImport.sWorkSheetGird_Convert_Font_to_sFont(
  Instance: TObject; var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).Convert_Font_to_sFont(TFont(TSuPtr(Params[0])), TsFont(TSuPtr(Params[1])));
end;

function TSpradSheetImport.sWorkSheetGird_Convert_sFont_to_Font(
  Instance: TObject; var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).Convert_sFont_to_Font(TsFont(TSuPtr(Params[0])), TFont(TSuPtr(Params[1])));
end;

function TSpradSheetImport.sWorkSheetGird_DeleteCol(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).DeleteCol(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_DeleteRow(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).DeleteRow(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_EditingDone(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).EditingDone;
end;

function TSpradSheetImport.sWorkSheetGird_EndUpdate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).EndUpdate(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_GetCellComment(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).CellComment[Params[0], Params[1]];
end;

function TSpradSheetImport.sWorkSheetGird_GetCellFont(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TsWorksheetGrid(Instance).CellFont[Params[0], Params[1]] );
end;

function TSpradSheetImport.sWorkSheetGird_GetCellFontColor(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(newinstance).CellFontColor[Params[0], Params[1]];
end;

function TSpradSheetImport.sWorkSheetGird_GetCellFontColors(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).CellFontColors[Params[0], Params[1], Params[2], Params[3]];
end;

function TSpradSheetImport.sWorkSheetGird_GetCellFontName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).CellFontName[Params[0], Params[1]];
end;

function TSpradSheetImport.sWorkSheetGird_GetCellFontNames(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).CellFontNames[Params[0], Params[1], Params[2], Params[3]];
end;

function TSpradSheetImport.sWorkSheetGird_GetCellFonts(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TsWorksheetGrid(Instance).CellFonts[Params[0], Params[1], Params[2], Params[3]]);
end;

function TSpradSheetImport.sWorkSheetGird_GetCellFontSize(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).CellFontSize[Params[0], Params[1]];
end;

function TSpradSheetImport.sWorkSheetGird_GetCellFontSizes(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).CellFontSizes[Params[0], Params[1], Params[2], Params[3]];
end;

function TSpradSheetImport.sWorkSheetGird_GetCellFontStyle(Instance: TObject;
  var Params: Variant): Variant;
begin
  AFntStyle := TsWorksheetGrid(Instance).CellFontStyle[Params[0], Params[1]];
  Result := TSuPtr(@AFntStyle);
end;

function TSpradSheetImport.sWorkSheetGird_GetCellFontStyles(Instance: TObject;
  var Params: Variant): Variant;
begin
  AFntStyle := TsWorksheetGrid(Instance).CellFontStyles[Params[0], Params[1], Params[2], Params[3]];
  Result := TSuPtr(@AFntStyle);
end;

function TSpradSheetImport.sWorkSheetGird_GetCellLineColor(Instance: TObject;
  var Params: Variant): Variant;
var
  bs: TsCellBorderStyle;
begin
  bs := TsWorksheetGrid(Instance).CellBorderStyle[Params[0], Params[1], Params[2]];
  Result := bs.Color;
end;

function TSpradSheetImport.sWorkSheetGird_GetCellLineColors(Instance: TObject;
  var Params: Variant): Variant;
var
  bs: TsCellBorderStyle;
begin
  bs := TsWorksheetGrid(Instance).CellBorderStyles[Params[0], Params[1], Params[2], Params[3], Params[4]];
  Result := bs.Color;
end;

function TSpradSheetImport.sWorkSheetGird_GetCellLineStyle(Instance: TObject;
  var Params: Variant): Variant;
var
  bs: TsCellBorderStyle;
begin
  bs := TsWorksheetGrid(Instance).CellBorderStyle[Params[0], Params[1], Params[2]];
  Result := bs.LineStyle;
end;

function TSpradSheetImport.sWorkSheetGird_GetCellLineStyles(Instance: TObject;
  var Params: Variant): Variant;
var
  bs: TsCellBorderStyle;
begin
  bs := TsWorksheetGrid(Instance).CellBorderStyles[Params[0], Params[1], Params[2], Params[3], Params[4]];
  Result := bs.LineStyle;
end;

function TSpradSheetImport.sWorkSheetGird_GetColWidths(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).ColWidths[Params[0]];
end;

function TSpradSheetImport.sWorkSheetGird_GetDefaultColWidth(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheetGrid(Instance).DefaultColWidth;
end;

function TSpradSheetImport.sWorkSheetGird_GetDefaultRowHeight(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheetGrid(Instance).DefaultRowHeight;
end;

function TSpradSheetImport.sWorkSheetGird_GetGridCol(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).GetGridCol(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_GetGridRow(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).GetGridRow(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_GetHorAlignment(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).HorAlignment[Params[0],  Params[1]];
end;

function TSpradSheetImport.sWorkSheetGird_GetHorAlignments(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).HorAlignments[Params[0],  Params[1], Params[2], Params[3]];
end;

function TSpradSheetImport.sWorkSheetGird_GetHyperlink(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).Hyperlink[Params[0], Params[1]];
end;

function TSpradSheetImport.sWorkSheetGird_GetNumberFormat(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).NumberFormat[Params[0], Params[1]];
end;

function TSpradSheetImport.sWorkSheetGird_GetRowHeights(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).RowHeights[Params[0]];
end;

function TSpradSheetImport.sWorkSheetGird_GetSelectionBottom(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheetGrid(Instance).Selection.Bottom;
end;

function TSpradSheetImport.sWorkSheetGird_GetSelectionLeft(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheetGrid(Instance).Selection.Left;
end;

function TSpradSheetImport.sWorkSheetGird_GetSelectionRight(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheetGrid(Instance).Selection.Right;
end;

function TSpradSheetImport.sWorkSheetGird_GetSelectionTop(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheetGrid(Instance).Selection.Top;
end;

function TSpradSheetImport.sWorkSheetGird_GetSheets(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).GetSheets(TStrings( TSuPtr(Params[0]) ));
end;

function TSpradSheetImport.sWorkSheetGird_GetTextRotation(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).TextRotation[Params[0], Params[1]];
end;

function TSpradSheetImport.sWorkSheetGird_GetTextRotations(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).TextRotations[Params[0], Params[1], Params[2], Params[3]];
end;

function TSpradSheetImport.sWorkSheetGird_GetVertAlignment(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).VertAlignment[Params[0], Params[1]];
end;

function TSpradSheetImport.sWorkSheetGird_GetVertAlignments(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).VertAlignments[Params[0], Params[1], Params[2], Params[3]];
end;

function TSpradSheetImport.sWorkSheetGird_GetWordwrap(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).Wordwrap[Params[0], Params[1]];
end;

function TSpradSheetImport.sWorkSheetGird_GetWordwraps(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).Wordwraps[Params[0], Params[1], Params[2], Params[3]];
end;

function TSpradSheetImport.sWorkSheetGird_GetWorksheetCol(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).GetWorksheetCol(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_GetWorksheetRow(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheetGrid(Instance).GetWorksheetRow(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_GetZoomFactor(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheetGrid(Instance).ZoomFactor;
end;

function TSpradSheetImport.sWorkSheetGird_HeaderCountGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheetGrid(Instance).HeaderCount;
end;

function TSpradSheetImport.sWorkSheetGird_InsertCol(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).InsertCol(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_InsertRow(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).InsertRow(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_LoadFromSpreadsheetFile(
  Instance: TObject; var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).LoadFromSpreadsheetFile(Params[0], Params[1], Params[2]);
end;

function TSpradSheetImport.sWorkSheetGird_LoadFromWorkbook(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).LoadFromWorkbook(TsWorkbook(TSuPtr(Params[0])), Params[1]);
end;

function TSpradSheetImport.sWorkSheetGird_MergeCells(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).MergeCells(Params[0], Params[1], Params[2], Params[3]);
end;

function TSpradSheetImport.sWorkSheetGird_NewWorkbook(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).NewWorkbook(Params[0], Params[1]);
end;

function TSpradSheetImport.sWorkSheetGird_RemoveWorkbookSource(
  Instance: TObject; var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).RemoveWorkbookSource;
end;

function TSpradSheetImport.sWorkSheetGird_RowGet(Instance: Pointer): Variant;
begin
  Result := TsWorksheetGrid(Instance).Row;
end;

procedure TSpradSheetImport.sWorkSheetGird_RowSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheetGrid(Instance).Row := AValue;
end;

function TSpradSheetImport.sWorkSheetGird_SaveToSpreadsheetFile(
  Instance: TObject; var Params: Variant): Variant;
var
  B: Boolean;
begin
  B := Params[1];
  TsWorksheetGrid(Instance).SaveToSpreadsheetFile(Params[0], B);
end;

function TSpradSheetImport.sWorkSheetGird_SelectSheetByIndex(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).SelectSheetByIndex(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_SetBorderLine(Instance: TObject;
  var Params: Variant): Variant;
var
  ACol, ARow: Integer;
  ABorders: PsCellBorders;
  LineStyle: TsLineStyle;
  bs: TsCellBorderStyle;
begin
  ACol := Params[0];
  ARow := Params[1];
  ABorders := PsCellBorders(TSuPtr(Params[2]));
  LineStyle := Params[3];
  TsWorksheetGrid(Instance).BeginUpdate;
  try
    TsWorksheetGrid(Instance).CellBorder[ACol, ARow] := ABorders^;
    if cbNorth in ABorders^ then
    begin
      bs := TsWorksheetGrid(Instance).CellBorderStyle[ACol, ARow, cbNorth];
      bs.LineStyle := LineStyle;
      TsWorksheetGrid(Instance).CellBorderStyle[ACol, ARow, cbNorth] := bs;;
    end;
    if cbWest in ABorders^ then
    begin
      bs := TsWorksheetGrid(Instance).CellBorderStyle[ACol, ARow, cbWest];
      bs.LineStyle := LineStyle;
      TsWorksheetGrid(Instance).CellBorderStyle[ACol, ARow, cbWest] := bs;;
    end;
    if cbEast in ABorders^ then
    begin
      bs := TsWorksheetGrid(Instance).CellBorderStyle[ACol, ARow, cbEast];
      bs.LineStyle := LineStyle;
      TsWorksheetGrid(Instance).CellBorderStyle[ACol, ARow, cbEast] := bs;;
    end;
    if cbSouth in ABorders^ then
    begin
      bs := TsWorksheetGrid(Instance).CellBorderStyle[ACol, ARow, cbSouth];
      bs.LineStyle := LineStyle;
      TsWorksheetGrid(Instance).CellBorderStyle[ACol, ARow, cbSouth] := bs;;
    end;
    if cbDiagUp in ABorders^ then
    begin
      bs := TsWorksheetGrid(Instance).CellBorderStyle[ACol, ARow, cbDiagUp];
      bs.LineStyle := LineStyle;
      TsWorksheetGrid(Instance).CellBorderStyle[ACol, ARow, cbDiagUp] := bs;;
    end;
    if cbDiagDown in ABorders^ then
    begin
      bs := TsWorksheetGrid(Instance).CellBorderStyle[ACol, ARow, cbDiagDown];
      bs.LineStyle := LineStyle;
      TsWorksheetGrid(Instance).CellBorderStyle[ACol, ARow, cbDiagDown] := bs;;
    end;
  finally
    TsWorksheetGrid(Instance).EndUpdate;
  end;
end;

function TSpradSheetImport.sWorkSheetGird_SetBorderLines(Instance: TObject;
  var Params: Variant): Variant;
var
  ALeft, ATop, ARight, ABottom: Integer;
  ABorders: PsCellBorders;
  LineStyle: TsLineStyle;
  bs: TsCellBorderStyle;
begin
  ALeft := Params[0];
  ATop := Params[1];
  ARight := Params[2];
  ABottom := Params[3];
  ABorders := PsCellBorders(TSuPtr(Params[4]));
  LineStyle := Params[5];
  TsWorksheetGrid(Instance).BeginUpdate;
  try
    TsWorksheetGrid(Instance).CellBorders[ALeft, ATop, ARight, ABottom] := ABorders^;
    if cbNorth in ABorders^ then
    begin
      bs := TsWorksheetGrid(Instance).CellBorderStyles[ALeft, ATop, ARight, ABottom, cbNorth];
      bs.LineStyle := LineStyle;
      TsWorksheetGrid(Instance).CellBorderStyles[ALeft, ATop, ARight, ABottom, cbNorth] := bs;;
    end;
    if cbWest in ABorders^ then
    begin
      bs := TsWorksheetGrid(Instance).CellBorderStyles[ALeft, ATop, ARight, ABottom, cbWest];
      bs.LineStyle := LineStyle;
      TsWorksheetGrid(Instance).CellBorderStyles[ALeft, ATop, ARight, ABottom, cbWest] := bs;;
    end;
    if cbEast in ABorders^ then
    begin
      bs := TsWorksheetGrid(Instance).CellBorderStyles[ALeft, ATop, ARight, ABottom, cbEast];
      bs.LineStyle := LineStyle;
      TsWorksheetGrid(Instance).CellBorderStyles[ALeft, ATop, ARight, ABottom, cbEast] := bs;;
    end;
    if cbSouth in ABorders^ then
    begin
      bs := TsWorksheetGrid(Instance).CellBorderStyles[ALeft, ATop, ARight, ABottom, cbSouth];
      bs.LineStyle := LineStyle;
      TsWorksheetGrid(Instance).CellBorderStyles[ALeft, ATop, ARight, ABottom, cbSouth] := bs;;
    end;
    if cbDiagUp in ABorders^ then
    begin
      bs := TsWorksheetGrid(Instance).CellBorderStyles[ALeft, ATop, ARight, ABottom, cbDiagUp];
      bs.LineStyle := LineStyle;
      TsWorksheetGrid(Instance).CellBorderStyles[ALeft, ATop, ARight, ABottom, cbDiagUp] := bs;;
    end;
    if cbDiagDown in ABorders^ then
    begin
      bs := TsWorksheetGrid(Instance).CellBorderStyles[ALeft, ATop, ARight, ABottom, cbDiagDown];
      bs.LineStyle := LineStyle;
      TsWorksheetGrid(Instance).CellBorderStyles[ALeft, ATop, ARight, ABottom, cbDiagDown] := bs;;
    end;

  finally
    TsWorksheetGrid(Instance).EndUpdate;
  end;
end;

function TSpradSheetImport.sWorkSheetGird_SetCellComment(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).CellComment[Params[0], Params[1]] := Params[2];
end;

function TSpradSheetImport.sWorkSheetGird_SetCellFont(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).CellFont[Params[0], Params[1]] := TFont(TSuPtr(Params[2]));
end;

function TSpradSheetImport.sWorkSheetGird_SetCellFontColor(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).CellFontColor[Params[0], Params[1]] := Params[2];
end;

function TSpradSheetImport.sWorkSheetGird_SetCellFontColors(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).CellFontColors[Params[0], Params[1], Params[2], Params[3]] := Params[4];
end;

function TSpradSheetImport.sWorkSheetGird_SetCellFontName(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).CellFontName[Params[0], Params[1]] := Params[2];
end;

function TSpradSheetImport.sWorkSheetGird_SetCellFontNames(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).CellFontNames[Params, Params[1], Params[2], Params[3]] := Params[4];
end;

function TSpradSheetImport.sWorkSheetGird_SetCellFonts(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).CellFonts[Params[0], Params[1], Params[2], Params[3]] := TFont(TSuPtr(Params[4]));
end;

function TSpradSheetImport.sWorkSheetGird_SetCellFontSize(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).CellFontSize[Params[0], Params[1]] := Params[2];
end;

function TSpradSheetImport.sWorkSheetGird_SetCellFontSizes(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).CellFontSizes[Params[0], Params[1], Params[2], Params[3]] := Params[4];
end;

function TSpradSheetImport.sWorkSheetGird_SetCellFontStyle(Instance: TObject;
  var Params: Variant): Variant;
var
  PStyle: PsFontStyles;
begin
  PStyle := PsFontStyles(TSuPtr(Params[2]));
  TsWorksheetGrid(Instance).CellFontStyle[Params[0], Params[1]] := PStyle^;
end;

function TSpradSheetImport.sWorkSheetGird_SetCellFontStyles(Instance: TObject;
  var Params: Variant): Variant;
var
  AStyle: TsFontStyles;
begin
  AStyle := PsFontStyles(TSuPtr(Params[4]))^;
  TsWorksheetGrid(Instance).CellFontStyles[Params[0], Params[1], Params[2], Params[3]] := AStyle;
end;

function TSpradSheetImport.sWorkSheetGird_SetCellLineColor(Instance: TObject;
  var Params: Variant): Variant;
var
  bs: TsCellBorderStyle;
begin
  bs := TsWorksheetGrid(Instance).CellBorderStyle[Params[0], Params[1], Params[2]];
  bs.Color := Params[3];
  TsWorksheetGrid(Instance).CellBorderStyle[Params[0], Params[1], Params[2]] := bs;
end;

function TSpradSheetImport.sWorkSheetGird_SetCellLineColors(Instance: TObject;
  var Params: Variant): Variant;
var
  bs: TsCellBorderStyle;
begin
  bs := TsWorksheetGrid(Instance).CellBorderStyles[Params[0], Params[1], Params[2], Params[3], Params[4]];
  bs.Color := Params[4];
  TsWorksheetGrid(Instance).CellBorderStyles[Params[0], Params[1], Params[2], Params[3], Params[4]] := bs;
end;

function TSpradSheetImport.sWorkSheetGird_SetCellLineStyle(Instance: TObject;
  var Params: Variant): Variant;
var
  bs: TsCellBorderStyle;
begin
  bs := TsWorksheetGrid(Instance).CellBorderStyle[Params[0], Params[1], Params[2]];
  bs.LineStyle := Params[3];
  TsWorksheetGrid(Instance).CellBorderStyle[Params[0], Params[1], Params[2]] := bs;
end;

function TSpradSheetImport.sWorkSheetGird_SetCellLineStyles(Instance: TObject;
  var Params: Variant): Variant;
var
  bs: TsCellBorderStyle;
begin
  bs := TsWorksheetGrid(Instance).CellBorderStyles[Params[0], Params[1], Params[2], Params[3], Params[4]];
  bs.LineStyle := Params[5];
  TsWorksheetGrid(Instance).CellBorderStyles[Params[0], Params[1], Params[2], Params[3], Params[4]] := bs;
end;

function TSpradSheetImport.sWorkSheetGird_SetColWidths(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).ColWidths[Params[0]] := Params[1];
end;

procedure TSpradSheetImport.sWorkSheetGird_SetDefaultColWidth(
  Instance: Pointer; AValue: Variant);
begin
  TsWorksheetGrid(Instance).DefaultColWidth := AValue;
end;

procedure TSpradSheetImport.sWorkSheetGird_SetDefaultRowHeight(
  Instance: Pointer; AValue: Variant);
begin
  TsWorksheetGrid(Instance).DefaultRowHeight := AValue;
end;

function TSpradSheetImport.sWorkSheetGird_SetHorAlignment(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).HorAlignment[Params[0], Params[1]] := Params[2];
end;

function TSpradSheetImport.sWorkSheetGird_SetHorAlignments(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).HorAlignments[Params[0], Params[1], Params[2], Params[3]] := Params[4];
end;

function TSpradSheetImport.sWorkSheetGird_SetHyperlink(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).Hyperlink[Params[0], Params[1]] := Params[2];
end;

function TSpradSheetImport.sWorkSheetGird_SetNumberFormat(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).NumberFormat[Params[0], Params[1]] := Params[2];
end;

function TSpradSheetImport.sWorkSheetGird_SetRowHeights(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).RowHeights[Params[0]] := Params[1];
end;

function TSpradSheetImport.sWorkSheetGird_SetSelection(Instance: TObject;
  var Params: Variant): Variant;
var
  R: TRect;
begin
  R.Left := Params[0];
  R.Top := Params[1];
  R.Right := Params[2];
  R.Bottom := Params[3];
  TsWorksheetGrid(Instance).Selection := R;
end;

function TSpradSheetImport.sWorkSheetGird_SetTextRotation(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).TextRotation[Params[0], Params[1]] := Params[2];
end;

function TSpradSheetImport.sWorkSheetGird_SetTextRotations(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).TextRotations[Params[0], Params[1], Params[2], Params[3]] := Params[4];
end;

function TSpradSheetImport.sWorkSheetGird_SetVertAlignment(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).VertAlignment[Params[0], Params[1]] := Params[2];
end;

function TSpradSheetImport.sWorkSheetGird_SetVertAlignments(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).VertAlignments[Params[0], Params[1], Params[2], Params[3]] := Params[4];
end;

function TSpradSheetImport.sWorkSheetGird_SetWordwrap(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).Wordwrap[Params[0], Params[1]] := Params[2];
end;

function TSpradSheetImport.sWorkSheetGird_SetWordwraps(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).Wordwraps[Params[0], Params[1], Params[2], Params[3]] := Params[4];
end;

procedure TSpradSheetImport.sWorkSheetGird_SetZoomFactor(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheetGrid(Instance).ZoomFactor := AValue;
end;

function TSpradSheetImport.sWorkSheetGird_UnmergeCells(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).UnmergeCells(Params[0], Params[1]);
end;

function TSpradSheetImport.sWorkSheetGird_UpdateColWidth(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).UpdateColWidth(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_UpdateColWidths(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).UpdateColWidths(Params[0]);
end;

function TSpradSheetImport.sWorkSheetGird_UpdateRowHeight(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).UpdateRowHeight(Params[0], Params[1]);
end;

function TSpradSheetImport.sWorkSheetGird_UpdateRowHeights(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheetGrid(Instance).UpdateRowHeights(Params[0], Params[1]);
end;

function TSpradSheetImport.sWorkSheetGird_WorkbookGet(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( TsWorksheetGrid(Instance).Workbook );
end;

function TSpradSheetImport.sWorkSheetGird_WorksheetGet(Instance: Pointer
  ): Variant;
begin
  Result := TSuPtr( TsWorksheetGrid(Instance).Worksheet );
end;

function TSpradSheetImport.sWorksheet_ActiveCellColGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet(Instance).ActiveCellCol;
end;

function TSpradSheetImport.sWorksheet_ActiveCellRowGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet(Instance).ActiveCellRow;
end;

function TSpradSheetImport.sWorksheet_BottomMarginGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet(Instance).PageLayout.BottomMargin;
end;

procedure TSpradSheetImport.sWorksheet_BottomMarginSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).PageLayout.BottomMargin := AValue;
end;

function TSpradSheetImport.sWorksheet_CalcAutoRowHeight(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheet(Instance).CalcAutoRowHeight(Params[0]);
end;

function TSpradSheetImport.sWorksheet_CellPosToText(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheet(Instance).CellPosToText(Params[0], Params[1]);
end;

function TSpradSheetImport.sWorksheet_CopyCell(Instance: TObject;
  var Params: Variant): Variant;
var
  WS: TsWorksheet;
begin
  WS := TsWorksheet( TSuPtr(Params[4]) );
  TsWorksheet(Instance).CopyCell(Params[0], Params[1], Params[2], Params[3], WS);
end;

function TSpradSheetImport.sWorksheet_CopyFormat(Instance: TObject;
  var Params: Variant): Variant;
var
  ACell: PCell;
begin
  ACell:= TsWorksheet(Instance).GetCell(Params[0], Params[1]);
  TsWorksheet(Instance).CopyFormat(ACell, Params[2], Params[3]);
end;

function TSpradSheetImport.sWorksheet_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TsWorksheet.Create);
end;

function TSpradSheetImport.sWorksheet_DefaultColWidthGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet(Instance).ReadDefaultColWidth(suChars);
end;

procedure TSpradSheetImport.sWorksheet_DefaultColWidthSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).WriteDefaultColWidth(AValue, suChars);
end;

function TSpradSheetImport.sWorksheet_DefaultRowHeightGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet(Instance).ReadDefaultRowHeight(suChars);
end;

procedure TSpradSheetImport.sWorksheet_DefaultRowHeightSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).WriteDefaultRowHeight(AValue, suChars);
end;

function TSpradSheetImport.sWorksheet_DeleteCol(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).DeleteCol(Params[0]);
end;

function TSpradSheetImport.sWorksheet_DeleteRow(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).DeleteRow(Params[0]);
end;

function TSpradSheetImport.sWorksheet_EraseCell(Instance: TObject;
  var Params: Variant): Variant;
var
  Cell: PCell;
  ARow, ACol: Cardinal;
begin
  ARow := Params[0];
  ACol := Params[1];
  Cell := TsWorksheet(Instance).GetCell(ARow, ACol);
  TsWorksheet(Instance).EraseCell(Cell);
end;

function TSpradSheetImport.sWorksheet_FindMergedRange(Instance: TObject;
  var Params: Variant): Variant;
var
  Cell: PCell;

  ARow, ACol, ARow1, ACol1, ARow2, ACol2: Cardinal;
begin
  ARow := Params[0];
  ACol := Params[1];
  Cell := TsWorksheet(Instance).GetCell(ARow, ACol);
  Result := TsWorksheet(Instance).FindMergedRange(Cell, ARow1, ACol1, ARow2, ACol2);
  Params[2] := ARow1;
  Params[3] := ACol1;
  Params[4] := ARow2;
  Params[5] := ACol2;
end;

function TSpradSheetImport.sWorksheet_FitHeightToPagesGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet(Instance).PageLayout.FitHeightToPages;
end;

procedure TSpradSheetImport.sWorksheet_FitHeightToPagesSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).PageLayout.FitHeightToPages := AValue;
end;

function TSpradSheetImport.sWorksheet_FitWidthToPagesGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet(Instance).PageLayout.FitHeightToPages;
end;

procedure TSpradSheetImport.sWorksheet_FitWidthToPagesSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).PageLayout.FitWidthToPages := AValue;
end;

function TSpradSheetImport.sWorksheet_FooterMarginGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet(Instance).PageLayout.FooterMargin;
end;

procedure TSpradSheetImport.sWorksheet_FooterMarginSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).PageLayout.FooterMargin := AValue;
end;

function TSpradSheetImport.sWorksheet_GetCellCount(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheet(Instance).GetCellCount;
end;

function TSpradSheetImport.sWorksheet_GetCellCountInCol(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheet(Instance).GetCellCountInCol(Params[0]);
end;

function TSpradSheetImport.sWorksheet_GetCellCountInRow(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheet(Instance).GetCellCountInRow(Params[0]);
end;

function TSpradSheetImport.sWorksheet_GetColWidth(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheet(Instance).GetColWidth(Params[0]);
end;

function TSpradSheetImport.sWorksheet_GetLastColIndex(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheet(Instance).GetLastColIndex;
end;

function TSpradSheetImport.sWorksheet_GetLastRowIndex(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheet(Instance).GetLastRowIndex;
end;

function TSpradSheetImport.sWorksheet_GetRowHeight(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheet(Instance).GetRowHeight(Params[0]);
end;

function TSpradSheetImport.sWorksheet_HasComment(Instance: TObject;
  var Params: Variant): Variant;
var
  Cell: PCell;
  ARow, ACol: Cardinal;
begin
  ARow := Params[0];
  ACol := Params[1];
  Cell := TsWorksheet(Instance).GetCell(ARow, ACol);
  Result := TsWorksheet(Instance).HasComment(Cell);
end;

function TSpradSheetImport.sWorksheet_HasHyperlink(Instance: TObject;
  var Params: Variant): Variant;
var
  Cell: PCell;
  ARow, Acol: Cardinal;
begin
  ARow := Params[0];
  ACol := Params[1];
  Cell := TsWorksheet(Instance).GetCell(ARow, Acol);
  Result := TsWorksheet(Instance).HasHyperlink(Cell);
end;

function TSpradSheetImport.sWorksheet_HeaderMarginGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet(Instance).PageLayout.HeaderMargin;
end;

procedure TSpradSheetImport.sWorksheet_HeaderMarginSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).PageLayout.HeaderMargin := AValue;
end;

function TSpradSheetImport.sWorksheet_InsertCol(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).InsertCol(Params[0]);
end;

function TSpradSheetImport.sWorksheet_InsertRow(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).InsertRow(Params[0]);
end;

function TSpradSheetImport.sWorksheet_IsMerged(Instance: TObject;
  var Params: Variant): Variant;
var
  Cell: PCell;
  ARow, ACol: Cardinal;
begin
  ARow := Params[0];
  ACol := Params[1];
  Cell := TsWorksheet(Instance).GetCell(ARow, ACol);
  Result := TsWorksheet(Instance).IsMerged(Cell);
end;

function TSpradSheetImport.sWorksheet_LeftMarginGet(Instance: Pointer): Variant;
begin
  Result := TsWorksheet(Instance).PageLayout.LeftMargin;
end;

procedure TSpradSheetImport.sWorksheet_LeftMarginSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).PageLayout.LeftMargin := AValue;
end;

function TSpradSheetImport.sWorksheet_LeftPaneWidthGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet(Instance).LeftPaneWidth;
end;

procedure TSpradSheetImport.sWorksheet_LeftPaneWidthSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).LeftPaneWidth:= AValue;
end;

function TSpradSheetImport.sWorksheet_MergeCells(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow1, ACol1, ARow2, ACol2: Cardinal;
begin
  ARow1 := Params[0];
  ACol1 := Params[1];
  ARow2 := Params[2];
  ACol2 := Params[3];
  TsWorksheet(Instance).MergeCells(ARow1, ACol1, ARow2, ACol2);
end;

function TSpradSheetImport.sWorksheet_MergeCellsRange(Instance: TObject;
  var Params: Variant): Variant;
var
  ARange: string;
begin
  ARange := Params[0];
  TsWorksheet(Instance).MergeCells(ARange);
end;

function TSpradSheetImport.sWorksheet_OptionsGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( @TsWorksheet(Instance).Options );
end;

procedure TSpradSheetImport.sWorksheet_OptionsSet(Instance: Pointer;
  AValue: Variant);
var
  P: PsSheetOptions;
begin
  P := PsSheetOptions(TSuPtr(AValue));
  TsWorksheet(Instance).Options := P^;
end;

function TSpradSheetImport.sWorksheet_PageOrientationGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet( Instance ).PageLayout.Orientation;
end;

procedure TSpradSheetImport.sWorksheet_PageOrientationSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).PageLayout.Orientation := AValue;
end;

function TSpradSheetImport.sWorksheet_ReadAsDateTime(Instance: TObject;
  var Params: Variant): Variant;
var
  D: TDateTime;
begin
  Result := TsWorksheet(Instance).ReadAsDateTime(Params[0], Params[1], D);
  Params[2] := D;
end;

function TSpradSheetImport.sWorksheet_ReadAsNumber(Instance: TObject;
  var Params: Variant): Variant;
var
  X: Double;
begin
  X := TsWorksheet(Instance).ReadAsNumber(Params[0], Params[1]);
  if IsNan(X) then X := 0;
  Result := X;
end;

function TSpradSheetImport.sWorksheet_ReadAsUTF8Text(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheet(Instance).ReadAsUTF8Text(Params[0], Params[1]);
end;

function TSpradSheetImport.sWorksheet_ReadBackgroundColor(Instance: TObject;
  var Params: Variant): Variant;
var
  ACell: PCell;
begin
  ACell := TsWorksheet(Instance).GetCell(Params[0], Params[1]);
  Result := TsWorksheet(Instance).ReadBackgroundColor(ACell);
end;

function TSpradSheetImport.sWorksheet_ReadComment(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow, ACol: Cardinal;
begin
  ARow := Params[0];
  ACol := Params[1];
  Result := TsWorksheet(Instance).ReadComment(ARow, ACol);
end;

function TSpradSheetImport.sWorksheet_ReadFormulaAsString(Instance: TObject;
  var Params: Variant): Variant;
var
  ACell: PCell;
  ACol, ARow: Cardinal;
  Alocalized: Boolean;
begin
  ARow := Params[0];
  ACol := Params[1];
  Alocalized := Params[2];
  ACell := TsWorksheet(Instance).GetCell(ARow, ACol);
  Result := TsWorksheet(Instance).ReadFormulaAsString(ACell, Alocalized);
end;

function TSpradSheetImport.sWorksheet_ReadHyperlink(Instance: TObject;
  var Params: Variant): Variant;
var
  Cell: PCell;
  ARow, ACol: Cardinal;
begin
  ARow := Params[0];
  ACol := Params[1];
  Cell := TsWorksheet(Instance).GetCell(ARow, ACol);
  Result := TsWorksheet(Instance).ReadHyperlink(Cell).Target;
end;

function TSpradSheetImport.sWorksheet_ReadUsedFormatting(Instance: TObject;
  var Params: Variant): Variant;
var
  ACell: PCell;
begin
  ACell := TsWorksheet(Instance).GetCell(Params[0], Params[1]);
  PUF^ := TsWorksheet(Instance).ReadUsedFormatting(ACell);
  Result := TSuPtr(PUF);
end;

function TSpradSheetImport.sWorksheet_RemoveAllCols(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).RemoveAllCols;
end;

function TSpradSheetImport.sWorksheet_RemoveAllRows(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).RemoveAllRows;
end;

function TSpradSheetImport.sWorksheet_RemoveCol(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).RemoveCol(Params[0]);
end;

function TSpradSheetImport.sWorksheet_RemoveHyperlink(Instance: TObject;
  var Params: Variant): Variant;
var
  Cell: PCell;
begin
  Cell := TsWorksheet(Instance).GetCell(Params[0], Params[1]);
  TsWorksheet(Instance).RemoveHyperlink(Cell);
end;

function TSpradSheetImport.sWorksheet_RemoveRow(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).RemoveRow(Params[0]);
end;

function TSpradSheetImport.sWorksheet_RightMarginGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet(Instance).PageLayout.RightMargin;
end;

procedure TSpradSheetImport.sWorksheet_RightMarginSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).PageLayout.RightMargin := AValue;
end;

function TSpradSheetImport.sWorksheet_TopMarginGet(Instance: Pointer): Variant;
begin
  Result := TsWorksheet(Instance).PageLayout.TopMargin;
end;

procedure TSpradSheetImport.sWorksheet_TopMarginSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).PageLayout.TopMargin := AValue;
end;

function TSpradSheetImport.sWorksheet_TopPaneHeightGet(Instance: Pointer
  ): Variant;
begin
  Result := TsWorksheet(Instance).TopPaneHeight;
end;

procedure TSpradSheetImport.sWorksheet_TopPaneHeightSet(Instance: Pointer;
  AValue: Variant);
begin
  TsWorksheet(Instance).TopPaneHeight := AValue;
end;

function TSpradSheetImport.sWorksheet_WorkbookGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TsWorksheet(Instance).Workbook );
end;

function TSpradSheetImport.sWorksheet_WriteBackground(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteBackground(Params[0], Params[1], Params[2], Params[3], Params[4]);
end;

function TSpradSheetImport.sWorksheet_WriteBackgroundColor(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteBackgroundColor(Params[0], Params[1], Params[2]);
end;

function TSpradSheetImport.sWorksheet_WriteBlank(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteBlank(Params[0], Params[1]);
end;

function TSpradSheetImport.sWorksheet_WriteBoolValue(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteBoolValue(Params[0], Params[1], Params[2]);
end;

function TSpradSheetImport.sWorksheet_WriteBorderColor(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteBorderColor(Params[0], Params[1], Params[2], Params[3]);
end;

function TSpradSheetImport.sWorksheet_WriteBorderLineStyle(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteBorderLineStyle(Params[0], Params[1], Params[2], Params[3]);
end;

function TSpradSheetImport.sWorksheet_WriteBorders(Instance: TObject;
  var Params: Variant): Variant;
var
  ABorders: PsCellBorders;
begin
  ABorders:= PsCellBorders(TSuPtr(Params[2]));
  TsWorksheet(Instance).WriteBorders(Params[0], Params[1], ABorders^);
end;

function TSpradSheetImport.sWorksheet_WriteBorderStyleColor(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow, ACol: Cardinal;
  ABorder: TsCellBorder;
  ALineStyle: TsLineStyle;
  AColor: TsColor;
begin
  ARow := Params[0];
  ACol := Params[1];
  ABorder:= Params[2];
  ALineStyle:= Params[3];
  AColor:= Params[4];
  TsWorksheet(Instance).WriteBorderStyle(ARow, ACol, ABorder, ALineStyle, AColor);
end;

function TSpradSheetImport.sWorksheet_WriteCellValueAsString(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteCellValueAsString(Params[0], Params[1], Params[2]);
end;

function TSpradSheetImport.sWorksheet_WriteColWidth(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteColWidth(Params[0], Params[1]);
end;

function TSpradSheetImport.sWorksheet_WriteComment(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow, ACol: Cardinal;
  Comm: string;
begin
  ARow := Params[0];
  ACol := Params[1];
  Comm := Params[2];
  TsWorksheet(Instance).WriteComment(ARow, ACol, Comm);
end;

function TSpradSheetImport.sWorksheet_WriteCurrency(Instance: TObject;
  var Params: Variant): Variant;
var
  ACol, ARow: Cardinal;
  ACur: Currency;
begin
  ARow:= Params[0];
  ACol:= Params[1];
  ACur := Params[2];
  TsWorksheet(Instance).WriteCurrency(ARow, ACol, ACur);
end;

function TSpradSheetImport.sWorksheet_WriteCurrencyF(Instance: TObject;
  var Params: Variant): Variant;
var
  ACol, ARow: Cardinal;
  AValue: Double;
  AFormat: TsNumberFormat;
  AFormatStr: string;
begin
  ARow:= Params[0];
  ACol:= Params[1];
  AValue:= Params[2];
  AFormat:= Params[3];
  AFormatStr:= Params[4];
  TsWorksheet(Instance).WriteCurrency(ARow, ACol, AValue, AFormat, AFormatStr);
end;

function TSpradSheetImport.sWorksheet_WriteDateTime(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow, ACol: Integer;
  ADat: TDateTime;
begin
  ARow:= Params[0];
  ACol:= Params[1];
  ADat:= Params[2];
  TsWorksheet(Instance).WriteDateTime(ARow, ACol, ADat);
end;

function TSpradSheetImport.sWorksheet_WriteDateTimeF(Instance: TObject;
  var Params: Variant): Variant;
var
  AFormat: string;
  D: TDateTime;
begin
  D := Params[2];
  AFormat := Params[3];
  TsWorksheet(Instance).WriteDateTime(Params[0], Params[1], D, AFormat);
end;

function TSpradSheetImport.sWorksheet_WriteDecimals(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow, ACol: Cardinal;
  ADec: Byte;
begin
  ARow:= Params[0];
  ACol:= Params[1];
  ADec:= Params[3];
  TsWorksheet(Instance).WriteDecimals(ARow, ACol, ADec);
end;

function TSpradSheetImport.sWorksheet_WriteFont(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow, ACol: Cardinal;
  AFontIndex: Integer;
begin
  ARow:= Params[0];
  ACol:= Params[1];
  AFontIndex := Params[2];
  TsWorksheet(Instance).WriteFont(ARow, ACol, AFontIndex);
end;

function TSpradSheetImport.sWorksheet_WriteFontColor(Instance: TObject;
  var Params: Variant): Variant;
begin
    Result := TsWorksheet(Instance).WriteFontColor(Params[0], Params[1], Params[2]);
end;

function TSpradSheetImport.sWorksheet_WriteFontF(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow, ACol: Cardinal;
  AFontName: String;
  AFontSize: Single;
  AFontStyle: PsFontStyles;
  AFontColor: TsColor;
begin
  ARow := Params[0];
  ACol := Params[1];
  AFontName:= Params[2];
  AFontSize := Params[3];
  AFontStyle := PsFontStyles( TSuPtr( Params[4] ) );
  AFontColor:= Params[5];
  Result := TsWorksheet(Instance).WriteFont(ARow, ACol, AFontName, AFontSize, AFontStyle^, AFontColor);
end;

function TSpradSheetImport.sWorksheet_WriteFontName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheet(Instance).WriteFontName(Params[0], Params[1], Params[2]);
end;

function TSpradSheetImport.sWorksheet_WriteFontSize(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TsWorksheet(Instance).WriteFontSize(Params[0], Params[1], Params[2]);
end;

function TSpradSheetImport.sWorksheet_WriteFontStyle(Instance: TObject;
  var Params: Variant): Variant;
var
  AStyle: PsFontStyles;
begin
  AStyle := PsFontStyles(TSuPtr( Params[2] ));
  Result := TsWorksheet(Instance).WriteFontStyle(Params[0], Params[1], AStyle^);
end;

function TSpradSheetImport.sWorksheet_WriteFormula(Instance: TObject;
  var Params: Variant): Variant;
var
  ACol, ARow: Cardinal;
  AFormula: string;
  ALocalized: Boolean;
begin
  ARow := Params[0];
  ACol := Params[1];
  AFormula := Params[2];
  ALocalized := Params[3];
  TsWorksheet(Instance).WriteFormula(ARow, ACol, AFormula, ALocalized);
end;

function TSpradSheetImport.sWorksheet_WriteHorAlignment(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteHorAlignment(Params[0], Params[1], Params[2]);
end;

function TSpradSheetImport.sWorksheet_WriteHyperlink(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow, ACol: Cardinal;
  ATarger, AToolTip: string;
begin
  ARow := Params[0];
  ACol := Params[1];
  ATarger := Params[2];
  AToolTip := Params[3];
  TsWorksheet(Instance).WriteHyperlink(ARow, ACol, ATarger, AToolTip);
end;

function TSpradSheetImport.sWorksheet_WriteNumber(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow, ACol: Cardinal;
  ANum: Double;
begin
  ARow:= Params[0];
  ACol:= Params[1];
  ANum:= Params[2];
  TsWorksheet(Instance).WriteNumber(ARow, ACol, ANum);
end;

function TSpradSheetImport.sWorksheet_WriteNumberF(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow, ACol: Cardinal;
  ANum: Double;
  AFormat: TsNumberFormat;
  AFormatStr: string;
begin
  ARow:= Params[0];
  ACol:= Params[1];
  ANum:= Params[2];
  AFormat:= Params[3];
  AFormatStr:= Params[4];
  TsWorksheet(Instance).WriteNumber(ARow, ACol, ANum, AFormat, AFormatStr);
end;

function TSpradSheetImport.sWorksheet_WriteNumberFormat(Instance: TObject;
  var Params: Variant): Variant;
var
  ARow, ACol: Cardinal;
  ANumberFormat: TsNumberFormat;
  AFormatString: String;
begin
  ARow:= Params[0];
  ACol:= Params[1];
  ANumberFormat:= Params[2];
  AFormatString:=Params[3];
  TsWorksheet(Instance).WriteNumberFormat(ARow, ACol, ANumberFormat, AFormatString);
end;

function TSpradSheetImport.sWorksheet_WriteRowHeight(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteRowHeight(Params[0], Params[1]);
end;

function TSpradSheetImport.sWorksheet_WriteTextRotation(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteTextRotation(Params[0], Params[1], Params[2]);
end;

function TSpradSheetImport.sWorksheet_WriteUsedFormatting(Instance: TObject;
  var Params: Variant): Variant;
var
  UF: PsUsedFormattingFields;
begin
  UF := PsUsedFormattingFields(TSuPtr( Params[2] ));
  TsWorksheet(Instance).WriteUsedFormatting(Params[0], Params[1], UF^);
end;

function TSpradSheetImport.sWorksheet_WriteUTF8Text(Instance: TObject;
  var Params: Variant): Variant;
var
  ACol, ARow: Integer;
  AText: String;
begin
  ARow := Params[0];
  ACol := Params[1];
  AText := Params[2];
  TsWorksheet(Instance).WriteUTF8Text(ARow, ACol, AText);
end;

function TSpradSheetImport.sWorksheet_WriteVertAlignment(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteVertAlignment(Params[0], Params[1], Params[2]);
end;

function TSpradSheetImport.sWorksheet_WriteWordwrap(Instance: TObject;
  var Params: Variant): Variant;
begin
  TsWorksheet(Instance).WriteWordwrap(Params[0], Params[1], Params[2]);
end;

function TSpradSheetImport.Call_GetColString(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := GetColString(Params[0]);
end;

function TSpradSheetImport.sWorkbook_GetLastWorksheet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TsWorkbook(Instance).GetLastWorksheet );
end;

function TSpradSheetImport.sWorkbook_GetNextWorksheet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TsWorkbook(Instance).GetNextWorksheet( TsWorksheet( TSuPtr(Params[0]) ) ) );
end;

procedure TSpradSheetImport.AddConsts(AddConst: TAddConstProc);
begin
  AddConst('scBlack','Integer', scBlack);
  AddConst('scWhite','Integer', scWhite);
  AddConst('scNotDefined','Integer', scNotDefined);
  AddConst('scTransparent','Integer', scTransparent);
  AddConst('sfidUnknown','Integer', sfidUnknown);
end;

procedure TSpradSheetImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TCellContentType));
  AddType(TypeInfo(TsUsedFormattingField));
  AddType(TypeInfo(TsUsedFormattingFields));
  AddType(TypeInfo(TsNumberFormat));
  AddType(TypeInfo(TsTextRotation));
  AddType(TypeInfo(TsHorAlignment));
  AddType(TypeInfo(TsVertAlignment));
  AddType(TypeInfo(TsFontStyle));
  AddType(TypeInfo(TsFontStyles));
  AddType(TypeInfo(TsFontPosition));
  AddType(TypeInfo(TsCellBorder));
  AddType(TypeInfo(TsCellBorders));
  AddType(TypeInfo(TsLineStyle));
  AddType(TypeInfo(TsSheetOption));
  AddType(TypeInfo(TsSheetOptions));
  AddType(TypeInfo(TsPageOrientation));
  AddType(TypeInfo(TsSpreadsheetFormat));
  AddType(TypeInfo(TsFillStyle));

end;

procedure TSpradSheetImport.AddSimpleTypes(AddType: TAddSimpleTypeProc);
begin
  AddType('TsColor', btInt);
  AddType('TsColorValue', btInt);
  AddType('TsSpreadFormatID', btInt);
end;

procedure TSpradSheetImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  //AddClass(TSpFormula).ClassImporter := Self;
  AddClass(TsFont);
  AddClass(TsPalette).ClassImporter := Self;
  AddClass(TsWorksheet).ClassImporter := Self;
  AddClass(TsWorkbook).ClassImporter := Self;
  AddClass(TsWorkbookSource).ClassImporter := Self;
  AddClass(TsWorksheetGrid).ClassImporter := Self;
  AddClass(TsWorkbookTabControl);
  AddClass(TsCellEdit);
  AddClass(TsCellIndicator);
  AddClass(TsCellCombobox).ClassImporter := Self;
  AddClass(TsSpreadsheetInspector);
end;

procedure TSpradSheetImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TsWorksheet then
  begin
    //UTF8FormatSettings := DefaultFormatSettings;
    AType.AddMethod('constructor Create', @sWorksheet_Create);
    AType.AddMethod('function CellPosToText(ARow, ACol: Cardinal): string', @sWorksheet_CellPosToText);
    AType.AddMethod('function ReadAsUTF8Text(ARow, ACol: Cardinal): ansistring', @sWorksheet_ReadAsUTF8Text);
    AType.AddMethod('function ReadAsNumber(ARow, ACol: Cardinal): Double', @sWorksheet_ReadAsNumber);
    AType.AddMethod('function ReadAsDateTime(ARow, ACol: Cardinal; out AResult: TDateTime): Boolean', @sWorksheet_ReadAsDateTime);
    AType.AddMethod('function ReadFormulaAsString(ARow, ACol: Cardinal, ALocalized: Boolean = false): String', @sWorksheet_ReadFormulaAsString);
    AType.AddMethod('function ReadUsedFormatting(ARow, ACol: Cardinal): TsUsedFormattingFields', @sWorksheet_ReadUsedFormatting);
    AType.AddMethod('function ReadBackgroundColor(ARow, ACol: Cardinal): TsColor', @sWorksheet_ReadBackgroundColor);

    AType.AddMethod('procedure WriteBlank(ARow, ACol: Cardinal)', @sWorksheet_WriteBlank);
    AType.AddMethod('procedure WriteBoolValue(ARow, ACol: Cardinal; AValue: Boolean)', @sWorksheet_WriteBoolValue);
    AType.AddMethod('procedure WriteCellValueAsString(ARow, ACol: Cardinal; AValue: String)', @sWorksheet_WriteCellValueAsString);
    AType.AddMethod('procedure WriteCurrencyF(ARow, ACol: Cardinal; AValue: Double; AFormat: TsNumberFormat; AFormatString: String)', @sWorksheet_WriteCurrencyF);
    AType.AddMethod('procedure WriteCurrency(ARow, ACol: Cardinal; AValue: Double)', @sWorksheet_WriteCurrency);
    AType.AddMethod('procedure WriteDateTimeF(ARow, ACol: Cardinal; AValue: TDateTime; AFormatStr: String)', @sWorksheet_WriteDateTimeF);
    AType.AddMethod('procedure WriteDateTime(ARow, ACol: Cardinal; AValue: TDateTime)', @sWorksheet_WriteDateTime);
    //AType.AddMethod('procedure WriteFormula(ARow, ACol: Cardinal; AFormula: TspFormula)', @sWorksheet_WriteFormula);
    AType.AddMethod('procedure WriteNumberF(ARow, ACol: Cardinal; ANumber: double; AFormat: TsNumberFormat; AFormatString: String)', @sWorksheet_WriteNumberF);
    AType.AddMethod('procedure WriteNumber(ARow, ACol: Cardinal; ANumber: double)', @sWorksheet_WriteNumber);
    AType.AddMethod('procedure WriteUTF8Text(ARow, ACol: Cardinal; AText: ansistring)', @sWorksheet_WriteUTF8Text);
    AType.AddMethod('procedure WriteBackground(ARow, ACol: Cardinal; AStyle: TsFillStyle; APatternColor: TsColor = scTransparent; ABackgroundColor: TsColor = scTransparent)', @sWorksheet_WriteBackground);
    AType.AddMethod('procedure WriteBackgroundColor(ARow, ACol: Cardinal; AColor: TsColor)', @sWorksheet_WriteBackgroundColor);
    AType.AddMethod('procedure WriteBorderColor(ARow, ACol: Cardinal; ABorder: TsCellBorder; AColor: TsColor)', @sWorksheet_WriteBorderColor);
    AType.AddMethod('procedure WriteBorderLineStyle(ARow, ACol: Cardinal; ABorder: TsCellBorder; ALineStyle: TsLineStyle)', @sWorksheet_WriteBorderLineStyle);
    AType.AddMethod('procedure WriteBorders(ARow, ACol: Cardinal; ABorders: TsCellBorders)', @sWorksheet_WriteBorders);
    AType.AddMethod('procedure WriteBorderStyleColor(ARow, ACol: Cardinal; ABorder: TsCellBorder; ALineStyle: TsLineStyle; AColor: TsColor)', @sWorksheet_WriteBorderStyleColor);
    AType.AddMethod('procedure WriteDecimals(ARow, ACol: Cardinal; ADecimals: byte)', @sWorksheet_WriteDecimals);
    AType.AddMethod('function  WriteFontF(ARow, ACol: Cardinal; const AFontName: String; AFontSize: Single; AFontStyle: TsFontStyles; AFontColor: TsColor): Integer', @sWorksheet_WriteFontF);
    AType.AddMethod('procedure WriteFont(ARow, ACol: Cardinal; AFontIndex: Integer)', @sWorksheet_WriteFont);
    AType.AddMethod('function WriteFontColor(ARow, ACol: Cardinal; AFontColor: TsColor): Integer', @sWorksheet_WriteFontColor);
    AType.AddMethod('function WriteFontName(ARow, ACol: Cardinal; AFontName: String): Integer', @sWorksheet_WriteFontName);
    AType.AddMethod('function WriteFontSize(ARow, ACol: Cardinal; ASize: Single): Integer', @sWorksheet_WriteFontSize);
    AType.AddMethod('function WriteFontStyle(ARow, ACol: Cardinal; AStyle: TsFontStyles): Integer', @sWorksheet_WriteFontStyle);
    AType.AddMethod('procedure WriteHorAlignment(ARow, ACol: Cardinal; AValue: TsHorAlignment)', @sWorksheet_WriteHorAlignment);
    AType.AddMethod('procedure WriteNumberFormat(ARow, ACol: Cardinal; ANumberFormat: TsNumberFormat; const AFormatString: String = '')', @sWorksheet_WriteNumberFormat);
    AType.AddMethod('procedure WriteTextRotation(ARow, ACol: Cardinal; ARotation: TsTextRotation)', @sWorksheet_WriteTextRotation);
    AType.AddMethod('procedure WriteUsedFormatting(ARow, ACol: Cardinal; AUsedFormatting: TsUsedFormattingFields)', @sWorksheet_WriteUsedFormatting);
    AType.AddMethod('procedure WriteVertAlignment(ARow, ACol: Cardinal; AValue: TsVertAlignment)', @sWorksheet_WriteVertAlignment);
    AType.AddMethod('procedure WriteWordwrap(ARow, ACol: Cardinal; AValue: boolean)', @sWorksheet_WriteWordwrap);
    AType.AddMethod('procedure WriteFormula(ARow, ACol: Cardinal; AFormula: String; ALocalized: Boolean = false)', @sWorksheet_WriteFormula);

    AType.AddMethod('procedure CopyCell(AFromRow, AFromCol, AToRow, AToCol: Cardinal; AFromWorksheet: TsWorksheet)', @sWorksheet_CopyCell);
    AType.AddMethod('procedure CopyFormat(AFromRow, AFromCol, AToRow, AToCol: Cardinal)', @sWorksheet_CopyFormat);
    AType.AddMethod('function GetCellCount: Cardinal', @sWorksheet_GetCellCount);
    AType.AddMethod('function GetLastColIndex: Cardinal', @sWorksheet_GetLastColIndex);
    AType.AddMethod('function GetLastRowIndex: Cardinal', @sWorksheet_GetLastRowIndex);
    AType.AddMethod('function CalcAutoRowHeight(ARow: Cardinal): Single', @sWorksheet_CalcAutoRowHeight);
    AType.AddMethod('function GetCellCountInRow(ARow: Cardinal): Cardinal', @sWorksheet_GetCellCountInRow);
    AType.AddMethod('function GetCellCountInCol(ACol: Cardinal): Cardinal', @sWorksheet_GetCellCountInCol);
    AType.AddMethod('function GetRowHeight(ARow: Cardinal): Single', @sWorksheet_GetRowHeight);
    AType.AddMethod('function GetColWidth(ACol: Cardinal): Single', @sWorksheet_GetColWidth);
    AType.AddMethod('procedure WriteRowHeight(ARow: Cardinal; AHeight: Single)', @sWorksheet_WriteRowHeight);
    AType.AddMethod('procedure WriteColWidth(ACol: Cardinal; AWidth: Single)', @sWorksheet_WriteColWidth);

    AType.AddMethod('procedure DeleteCol(ACol: Cardinal)', @sWorksheet_DeleteCol);
    AType.AddMethod('procedure DeleteRow(ARow: Cardinal)', @sWorksheet_DeleteRow);
    AType.AddMethod('procedure InsertCol(ACol: Cardinal)', @sWorksheet_InsertCol);
    AType.AddMethod('procedure InsertRow(ARow: Cardinal)', @sWorksheet_InsertRow);
    AType.AddMethod('procedure RemoveAllRows', @sWorksheet_RemoveAllRows);
    AType.AddMethod('procedure RemoveAllCols', @sWorksheet_RemoveAllCols);
    AType.AddMethod('procedure RemoveCol(ACol: Cardinal)', @sWorksheet_RemoveCol);
    AType.AddMethod('procedure RemoveRow(ARow: Cardinal)', @sWorksheet_RemoveRow);
    AType.AddMethod('procedure EraseCell(ARow, ACol: Cardinal)', @sWorksheet_EraseCell);

    AType.AddMethod('function HasComment(ARow, ACol: Cardinal): Boolean', @sWorksheet_HasComment);
    AType.AddMethod('function ReadComment(ARow, ACol: Cardinal): String', @sWorksheet_ReadComment);
    AType.AddMethod('procedure WriteComment(ARow, ACol: Cardinal; AText: String)', @sWorksheet_WriteComment);

    AType.AddMethod('function HasHyperlink(ARow, ACol: Cardinal): Boolean', @sWorksheet_HasHyperlink);
    AType.AddMethod('procedure WriteHyperlink(ARow, ACol: Cardinal; ATarget: String; ATooltip: String = '')', @sWorksheet_WriteHyperlink);
    AType.AddMethod('function ReadHyperlink(ARow, ACol: Cardinal): string', @sWorksheet_ReadHyperlink);
    AType.AddMethod('procedure RemoveHyperlink(ARow, ACol: Cardinal)', @sWorksheet_RemoveHyperlink);

    AType.AddMethod('procedure MergeCells(ARow1, ACol1, ARow2, ACol2: Cardinal)', @sWorksheet_MergeCells);
    AType.AddMethod('procedure MergeCellsRange(ARange: String)', @sWorksheet_MergeCellsRange);
    AType.AddMethod('function IsMerged(ARow, Acol: Cardinal): Boolean', @sWorksheet_IsMerged);
    AType.AddMethod('function FindMergedRange(ARow, Acol: Cardinal; out ARow1, ACol1, ARow2, ACol2: Cardinal): Boolean', @sWorksheet_FindMergedRange);

    AType.AddProp('Workbook', 'TsWorkbook', @sWorksheet_WorkbookGet);
    AType.AddProp('Options', 'TsSheetOptions', @sWorksheet_OptionsGet, @sWorksheet_OptionsSet);
    AType.AddProp('LeftPaneWidth', 'Integer', @sWorksheet_LeftPaneWidthGet, @sWorksheet_LeftPaneWidthSet);
    AType.AddProp('TopPaneHeight', 'Integer', @sWorksheet_TopPaneHeightGet, @sWorksheet_TopPaneHeightSet);
    AType.AddProp('DefaultColWidth', 'Single', @sWorksheet_DefaultColWidthGet, @sWorksheet_DefaultColWidthSet);
    AType.AddProp('DefaultRowHeight', 'Single', @sWorksheet_DefaultRowHeightGet, @sWorksheet_DefaultRowHeightSet);
    AType.AddProp('ActiveCellCol', 'Cardinal', @sWorksheet_ActiveCellColGet);
    AType.AddProp('ActiveCellRow', 'Cardinal', @sWorksheet_ActiveCellRowGet);
    AType.AddProp('Orientation', 'TsPageOrientation', @sWorksheet_PageOrientationGet, @sWorksheet_PageOrientationSet);
    AType.AddProp('LeftMargin', 'Double', @sWorksheet_LeftMarginGet, @sWorksheet_LeftMarginSet);
    AType.AddProp('RightMargin', 'Double', @sWorksheet_RightMarginGet, @sWorksheet_RightMarginSet);
    AType.AddProp('TopMargin', 'Double', @sWorksheet_TopMarginGet, @sWorksheet_TopMarginSet);
    AType.AddProp('BottomMargin', 'Double', @sWorksheet_BottomMarginGet, @sWorksheet_BottomMarginSet);
    AType.AddProp('HeaderMargin', 'Double', @sWorksheet_HeaderMarginGet, @sWorksheet_HeaderMarginSet);
    AType.AddProp('FooterMargin', 'Double', @sWorksheet_FooterMarginGet, @sWorksheet_FooterMarginSet);
    AType.AddProp('FitWidthToPages', 'Integer', @sWorksheet_FitWidthToPagesGet, @sWorksheet_FitWidthToPagesSet);
    AType.AddProp('FitHeightToPages', 'Integer', @sWorksheet_FitHeightToPagesGet, @sWorksheet_FitHeightToPagesSet);
  end
  else
  if AType.ValueClassType = TsWorkbook then
  begin
    AType.AddMethod('constructor Create', @sWorkbook_Create);
    AType.AddMethod('procedure ReadFromFileFormat(AFileName: string; AFormat: TsSpreadsheetFormat)', @sWorkbook_ReadFromFileFormat);
    AType.AddMethod('procedure ReadFromFile(AFileName: string)', @sWorkbook_ReadFromFile);
    AType.AddMethod('procedure ReadFromStream(AStream: TStream; AFormat: TsSpreadsheetFormat)', @sWorkbook_ReadFromStream);
    AType.AddMethod('procedure WriteToFileFormat(const AFileName: string; const AFormat: TsSpreadsheetFormat; const AOverwriteExisting: Boolean = False)', @sWorkbook_WriteToFileFormat);
    AType.AddMethod('procedure WriteToFile(const AFileName: String; const AOverwriteExisting: Boolean = False)', @sWorkbook_WriteToFile);
    AType.AddMethod('procedure WriteToStream(AStream: TStream; AFormat: TsSpreadsheetFormat)', @sWorkbook_WriteToStream);
    AType.AddMethod('function AddWorksheet(AName: string): TsWorksheet', @sWorkbook_AddWorksheet);
    AType.AddMethod('function GetFirstWorksheet: TsWorksheet', @sWorkbook_GetFirstWorksheet);
    AType.AddMethod('function  GetLastWorksheet: TsWorksheet', @sWorkbook_GetLastWorksheet);
    AType.AddMethod('function  GetNextWorksheet(AWorksheet: TsWorksheet): TsWorksheet;', @sWorkbook_GetNextWorksheet);
    AType.AddMethod('function GetWorksheetByIndex(AIndex: Cardinal): TsWorksheet', @sWorkbook_GetWorksheetByIndex);
    AType.AddMethod('function GetWorksheetByName(AName: String): TsWorksheet', @sWorkbook_GetWorksheetByName);
    AType.AddMethod('function GetWorksheetCount: Cardinal', @sWorkbook_GetWorksheetCount);
    AType.AddMethod('procedure RemoveAllWorksheets', @sWorkbook_RemoveAllWorksheets);
    AType.AddMethod('function AddFont(const AFontName: String; ASize: Single; AStyle: TsFontStyles; AColor: TsColor): Integer', @sWorkbook_AddFont);
    AType.AddMethod('function FindFont(const AFontName: String; ASize: Single; AStyle: TsFontStyles; AColor: TsColor): Integer', @sWorkbook_FindFont);
    AType.AddMethod('function GetFontCount: Integer', @sWorkbook_GetFontCount);
    AType.AddMethod('procedure InitFonts', @sWorkbook_InitFonts);
    AType.AddMethod('procedure RemoveAllFonts', @sWorkbook_RemoveAllFonts);
    AType.AddMethod('procedure SetDefaultFont(const AFontName: String; ASize: Single)', @sWorkbook_SetDefaultFont);
  end
  else
  if AType.ValueClassType = TsWorkbookSource then
  begin
    AType.AddMethod('procedure CreateNewWorkbook', @sWorkbookSource_CreateNewWorkbook);
    AType.AddMethod('procedure LoadFromSpreadsheetFile(AFileName: string; AFormatID: TsSpreadFormatID = sfidUnknown; AWorksheetIndex: Integer = -1)', @sWorkbookSource_LoadFromSpreadsheetFile);
    AType.AddMethod('procedure SaveToSpreadsheetFile(AFileName: string; AOverwriteExisting: Boolean = true)', @sWorkbookSource_SaveToSpreadsheetFile);
    AType.AddMethod('procedure LoadFromWorkbook(AWorkbook: TsWorkbook; AWorksheetIndex: Integer = -1)', @sWorkbookSource_LoadFromWorkbook);

    AType.AddProp('Workbook', 'TsWorkbook', @sWorkbookSource_WorkbookGet);
    AType.AddProp('Worksheet', 'TsWorksheet', @sWorkbookSource_WorksheetGet);
  end
  else
  if AType.ValueClassType = TsWorksheetGrid then
  begin
    AType.AddMethod('procedure AutoColWidth(ACol: Integer)', @sWorkSheetGird_AutoColWidth);
    AType.AddMethod('procedure AutoRowHeight(ARow: Integer)', @sWorkSheetGird_AutoRowHeight);
    AType.AddMethod('procedure BeginUpdate', @sWorkSheetGird_BeginUpdate);
    AType.AddMethod('procedure Clear', @sWorkSheetGird_Clear);
    AType.AddMethod('procedure EndUpdate(ARefresh: Boolean = true)', @sWorkSheetGird_EndUpdate);
    AType.AddMethod('function GetGridCol(ASheetCol: Cardinal): Integer', @sWorkSheetGird_GetGridCol);
    AType.AddMethod('function GetGridRow(ASheetRow: Cardinal): Integer', @sWorkSheetGird_GetGridRow);
    AType.AddMethod('procedure GetSheets(const ASheets: TStrings)', @sWorkSheetGird_GetSheets);
    AType.AddMethod('function GetWorksheetCol(AGridCol: Integer): Cardinal', @sWorkSheetGird_GetWorksheetCol);
    AType.AddMethod('function GetWorksheetRow(AGridRow: Integer): Cardinal', @sWorkSheetGird_GetWorksheetRow);
    AType.AddMethod('procedure InsertCol(AGridCol: Integer)', @sWorkSheetGird_InsertCol);
    AType.AddMethod('procedure InsertRow(AGridRow: Integer)', @sWorkSheetGird_InsertRow);
    AType.AddMethod('procedure DeleteCol(AGridCol: Integer)', @sWorkSheetGird_DeleteCol);
    AType.AddMethod('procedure DeleteRow(AGridRow: Integer)', @sWorkSheetGird_DeleteRow);
    AType.AddMethod('procedure EditingDone', @sWorkSheetGird_EditingDone);
    AType.AddMethod('procedure LoadFromSpreadsheetFile(AFileName: string; AFormatID: TsSpreadFormatID = sfidUnknown; AWorksheetIndex: Integer = -1)', @sWorkSheetGird_LoadFromSpreadsheetFile);
    AType.AddMethod('procedure LoadFromWorkbook(AWorkbook: TsWorkbook; AWorksheetIndex: Integer = -1)', @sWorkSheetGird_LoadFromWorkbook);
    AType.AddMethod('procedure NewWorkbook(AColCount, ARowCount: Integer)', @sWorkSheetGird_NewWorkbook);
    AType.AddMethod('procedure SaveToSpreadsheetFile(AFileName: string; AOverwriteExisting: Boolean = true)', @sWorkSheetGird_SaveToSpreadsheetFile);
    AType.AddMethod('procedure SelectSheetByIndex(AIndex: Integer)', @sWorkSheetGird_SelectSheetByIndex);
    AType.AddMethod('procedure MergeCells(ALeft, ATop, ARight, ABottom: Integer)', @sWorkSheetGird_MergeCells);
    AType.AddMethod('procedure UnmergeCells(ACol, ARow: Integer)', @sWorkSheetGird_UnmergeCells);
    AType.AddMethod('procedure UpdateColWidth(ACol: Integer)', @sWorkSheetGird_UpdateColWidth);
    AType.AddMethod('procedure UpdateRowHeight(ARow: Integer; AEnforceCalcRowHeight: Boolean = false)', @sWorkSheetGird_UpdateRowHeight);
    AType.AddMethod('procedure UpdateColWidths(AStartIndex: Integer = 0)', @sWorkSheetGird_UpdateColWidths);
    AType.AddMethod('procedure UpdateRowHeights(AStartRow: Integer = -1; AEnforceCalcRowHeight: Boolean = false)', @sWorkSheetGird_UpdateRowHeights);
    AType.AddMethod('procedure Convert_sFont_to_Font(sFont: TsFont; AFont: TFont)', @sWorkSheetGird_Convert_sFont_to_Font);
    AType.AddMethod('procedure Convert_Font_to_sFont(AFont: TFont; sFont: TsFont)', @sWorkSheetGird_Convert_Font_to_sFont);
    AType.AddMethod('procedure RemoveWorkbookSource', @sWorkSheetGird_RemoveWorkbookSource);
    AType.AddMethod('procedure SetBorderLine(ACol, ARow: Integer; ABorders: TsCellBorders; AStyle: TsLineStyle)', @sWorkSheetGird_SetBorderLine);
    AType.AddMethod('procedure SetBorderLines(SelectionLeft, SelectionTop, SelectionRight, SelectionBottom: Integer; ABorders: TsCellBorders; AStyle: TsLineStyle)', @sWorkSheetGird_SetBorderLines);
    AType.AddProp('Worksheet', 'TsWorksheet',  @sWorkSheetGird_WorksheetGet);
    AType.AddProp('Workbook', 'TsWorkbook',  @sWorkSheetGird_WorkbookGet);
    AType.AddProp('HeaderCount', 'Integer',  @sWorkSheetGird_HeaderCountGet);
    AType.AddProp('Row', 'Integer',  @sWorkSheetGird_RowGet, @sWorkSheetGird_RowSet);
    AType.AddProp('Col', 'Integer',  @sWorkSheetGird_ColGet, @sWorkSheetGird_ColSet);
    AType.AddIndexedProp('BackgroundColor', 'TsColor', 'Integer, Integer', @sWorkSheetGird_BackgroundColorGet, @sWorkSheetGird_BackgroundColorSet);
    AType.AddIndexedProp('BackgroundColors', 'TsColor', 'Integer, Integer, Integer, Integer', @sWorkSheetGird_BackgroundColorsGet, @sWorkSheetGird_BackgroundColorsSet);
    AType.AddIndexedProp('CellBorder', 'TsCellBorders', 'Integer, Integer', @sWorkSheetGird_CellBorderGet, @sWorkSheetGird_CellBorderSet);
    AType.AddIndexedProp('CellBorders', 'TsCellBorders', 'Integer, Integer, Integer, Integer', @sWorkSheetGird_CellBordersGet, @sWorkSheetGird_CellBordersSet);
    AType.AddIndexedProp('CellComment', 'String', 'Integer, Integer', @sWorkSheetGird_GetCellComment, @sWorkSheetGird_SetCellComment);
    AType.AddIndexedProp('CellFont', 'TFont', 'Integer, Integer', @sWorkSheetGird_GetCellFont, @sWorkSheetGird_SetCellFont);
    AType.AddIndexedProp('CellFonts', 'TFont', 'Integer, Integer, Integer, Integer', @sWorkSheetGird_GetCellFonts, @sWorkSheetGird_SetCellFonts);
    AType.AddIndexedProp('CellFontColor', 'TsColor', 'Integer, Integer', @sWorkSheetGird_GetCellFontColor, @sWorkSheetGird_SetCellFontColor);
    AType.AddIndexedProp('CellFontColors', 'TsColor', 'Integer, Integer, Integer, Integer', @sWorkSheetGird_GetCellFontColors, @sWorkSheetGird_SetCellFontColors);
    AType.AddIndexedProp('CellFontName', 'String', 'Integer, Integer', @sWorkSheetGird_GetCellFontName, @sWorkSheetGird_SetCellFontName);
    AType.AddIndexedProp('CellFontNames', 'String', 'Integer, Integer, Integer, Integer', @sWorkSheetGird_GetCellFontNames, @sWorkSheetGird_SetCellFontNames);
    AType.AddIndexedProp('CellFontStyle', 'TsFontStyles', 'Integer, Integer', @sWorkSheetGird_GetCellFontStyle, @sWorkSheetGird_SetCellFontStyle);
    AType.AddIndexedProp('CellFontStyles', 'TsFontStyles', 'Integer, Integer, Integer, Integer', @sWorkSheetGird_GetCellFontStyles, @sWorkSheetGird_SetCellFontStyles);
    AType.AddIndexedProp('CellFontSize', 'Single', 'Integer, Integer', @sWorkSheetGird_GetCellFontSize, @sWorkSheetGird_SetCellFontSize);
    AType.AddIndexedProp('CellFontSizes', 'Single', 'Integer, Integer, Integer, Integer', @sWorkSheetGird_GetCellFontSizes, @sWorkSheetGird_SetCellFontSizes);
    AType.AddIndexedProp('HorAlignment', 'TsHorAlignment', 'Integer, Integer', @sWorkSheetGird_GetHorAlignment, @sWorkSheetGird_SetHorAlignment);
    AType.AddIndexedProp('HorAlignments', 'TsHorAlignment', 'Integer, Integer, Integer, Integer', @sWorkSheetGird_GetHorAlignments, @sWorkSheetGird_SetHorAlignments);
    AType.AddIndexedProp('Cells', 'Variant', 'Integer, Integer', @sWorkSheetGird_CellsGet, @sWorkSheetGird_CellsSet);
    AType.AddIndexedProp('NumberFormat', 'String', 'Integer, Integer', @sWorkSheetGird_GetNumberFormat, @sWorkSheetGird_SetNumberFormat);
    AType.AddIndexedProp('Hyperlink', 'String', 'Integer, Integer', @sWorkSheetGird_GetHyperlink, @sWorkSheetGird_SetHyperlink);
    AType.AddIndexedProp('TextRotation', 'TsTextRotation', 'Integer, Integer', @sWorkSheetGird_GetTextRotation, @sWorkSheetGird_SetTextRotation);
    AType.AddIndexedProp('TextRotations', 'TsTextRotation', 'Integer, Integer, Integer, Integer', @sWorkSheetGird_GetTextRotations, @sWorkSheetGird_SetTextRotations);
    AType.AddIndexedProp('VertAlignment', 'TsVertAlignment', 'Integer, Integer', @sWorkSheetGird_GetVertAlignment, @sWorkSheetGird_SetVertAlignment);
    AType.AddIndexedProp('VertAlignments', 'TsVertAlignment', 'Integer, Integer, Integer, Integer', @sWorkSheetGird_GetVertAlignments, @sWorkSheetGird_SetVertAlignments);
    AType.AddIndexedProp('Wordwrap', 'Boolean', 'Integer, Integer', @sWorkSheetGird_GetWordwrap, @sWorkSheetGird_SetWordwrap);
    AType.AddIndexedProp('Wordwraps', 'Boolean', 'Integer, Integer, Integer, Integer', @sWorkSheetGird_GetWordwraps, @sWorkSheetGird_SetWordwraps);
    AType.AddIndexedProp('CellLineStyle', 'TsLineStyle', 'Integer, Integer, TsCellBorder', @sWorkSheetGird_GetCellLineStyle, @sWorkSheetGird_SetCellLineStyle);
    AType.AddIndexedProp('CellLineStyles', 'TsLineStyle', 'Integer, Integer, Integer, Integer, TsCellBorder', @sWorkSheetGird_GetCellLineStyles, @sWorkSheetGird_SetCellLineStyles);
    AType.AddIndexedProp('CellLineColor', 'TsColor', 'Integer, Integer, TsCellBorder', @sWorkSheetGird_GetCellLineColor, @sWorkSheetGird_SetCellLineColor);
    AType.AddIndexedProp('CellLineColors', 'TsColor', 'Integer, Integer, Integer, Integer, TsCellBorder', @sWorkSheetGird_GetCellLineColors, @sWorkSheetGird_SetCellLineColors);

    AType.AddProp('ZoomFactor', 'Double', @sWorkSheetGird_GetZoomFactor, @sWorkSheetGird_SetZoomFactor);
    AType.AddIndexedProp('ColWidths', 'Integer', 'Integer', @sWorkSheetGird_GetColWidths, @sWorkSheetGird_SetColWidths);
    AType.AddIndexedProp('RowHeights', 'Integer', 'Integer', @sWorkSheetGird_GetRowHeights, @sWorkSheetGird_SetRowHeights);
    AType.AddProp('DefaultColWidth', 'Integer', @sWorkSheetGird_GetDefaultColWidth, @sWorkSheetGird_SetDefaultColWidth);
    AType.AddProp('DefaultRowHeight', 'Integer', @sWorkSheetGird_GetDefaultRowHeight, @sWorkSheetGird_SetDefaultRowHeight);
    AType.AddProp('SelectionLeft', 'Integer', @sWorkSheetGird_GetSelectionLeft);
    AType.AddProp('SelectionTop', 'Integer', @sWorkSheetGird_GetSelectionTop);
    AType.AddProp('SelectionRight', 'Integer', @sWorkSheetGird_GetSelectionRight);
    AType.AddProp('SelectionBottom', 'Integer', @sWorkSheetGird_GetSelectionBottom);
    AType.AddMethod('procedure SetSelection(ALeft, ATop, ARight, ABottom: Integer)', @sWorkSheetGird_SetSelection);
    //AType.AddIndexedProp('', '', 'Integer, Integer', @sWorkSheetGird_Get, @sWorkSheetGird_Set);
    //AType.AddIndexedProp('', '', 'Integer, Integer, Integer, Integer', @sWorkSheetGird_Get, @sWorkSheetGird_Set);
  end
  else
  if AType.ValueClassType = TsPalette then
  begin
    AType.AddMethod('constructor Create', @sPalette_Create);
    AType.AddMethod('procedure AddExcelColors', @sPalette_AddExcelColors);
    AType.AddMethod('function AddColor(AColor: TsColor; ABigEndian: Boolean = false): Integer', @sPalette_AddColor);
    AType.AddMethod('function AddUniqueColor(AColor: TsColor; ABigEndian: Boolean = false): Integer', @sPalette_AddUniqueColor);
    AType.AddMethod('procedure Clear', @sPalette_Clear);
    AType.AddMethod('procedure CollectFromWorkbook(AWorkbook: TsWorkbook)', @sPalette_CollectFromWorkbook);
    AType.AddMethod('function ColorUsedInWorkbook(APaletteIndex: Integer; AWorkbook: TsWorkbook): Boolean', @sPalette_ColorUsedInWorkbook);
    AType.AddMethod('function FindClosestColorIndex(AColor: TsColor; AMaxPaletteCount: Integer = -1): Integer', @sPalette_FindClosestColorIndex);
    AType.AddMethod('function FindColor(AColor: TsColor; AMaxPaletteCount: Integer = -1): Integer', @sPalette_FindColor);
    AType.AddMethod('function Count: Integer', @sPalette_Count);
    AType.AddMethod('procedure Trim(AMaxSize: Integer)', @sPalette_Trim);
    AType.AddIndexedProp('Colors', 'TsColor', 'Integer', @sPalette_GetColors, @sPalette_SetColors);
  end
  else
  if AType.ValueClassType = TsCellCombobox then
  begin
    AType.AddMethod('procedure AddColor(AColor: TsColor; AColorName: String)', @sCellCombobox_AddColor);
  end;
end;

procedure TSpradSheetImport.AddMethods(AddMethod: TAddMethodProc);
begin
  AddMethod('function GetColString(AColIndex: Integer): String', @Call_GetColString);
end;


end.


