{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}

unit DManagerMain;

{$mode objfpc}{$H+}

interface

{$I SetComponent.inc}

uses
  Classes, SysUtils, UTF8Process, FileUtil, Forms, Controls, Graphics, Dialogs,
  StdCtrls, LCLType, ExtCtrls, ComCtrls, ActnList, Menus;

type

  { TMainForm }

  TMainForm = class(TForm)
    ActClose: TAction;
    ActDesign: TAction;
    ActAdd: TAction;
    ActEdit: TAction;
    ActDelete: TAction;
    ActCreateShortCut: TAction;
    ActRowUp: TAction;
    ActRunWithRestart: TAction;
    ActOpenFolder: TAction;
    ActRun: TAction;
    ActionList1: TActionList;
    Button1: TButton;
    Button10: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    ImageList1: TImageList;
    ListBox1: TListBox;
    ListBox2: TListBox;
    Memo1: TMemo;
    Memo2: TMemo;
    MenuItem1: TMenuItem;
    MenuItem10: TMenuItem;
    MenuItem11: TMenuItem;
    MenuItem12: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem6: TMenuItem;
    MenuItem7: TMenuItem;
    MenuItem8: TMenuItem;
    MenuItem9: TMenuItem;
    OpenDialog1: TOpenDialog;
    PageControl1: TPageControl;
    Panel1: TPanel;
    PopupMenu1: TPopupMenu;
    SelectDirectoryDialog1: TSelectDirectoryDialog;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    Timer1: TTimer;
    procedure ActAddExecute(Sender: TObject);
    procedure ActCloseExecute(Sender: TObject);
    procedure ActCreateShortCutExecute(Sender: TObject);
    procedure ActDeleteExecute(Sender: TObject);
    procedure ActDesignExecute(Sender: TObject);
    procedure ActEditExecute(Sender: TObject);
    procedure ActOpenFolderExecute(Sender: TObject);
    procedure ActRowUpExecute(Sender: TObject);
    procedure ActRunExecute(Sender: TObject);
    procedure ActRunWithRestartExecute(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure ListBox1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState
      );
    procedure Timer1Timer(Sender: TObject);
  private
    { private declarations }
    List: TStringList;
    eVarList: TStringList;
    function GetPanelCaption: string;
  public
    ADir: string;
    APath: string;
    ExeDir: string;
    UpdCnofig: string;
    eVarsFile: string;
    function NameExist(AName: string): Boolean;
    procedure AExecute(aExeName: string; AutoRestart: Integer = 0);
  end;

var
  MainForm: TMainForm;

implementation

uses ManEdit, httpsend, ftpsend, synautil, LazUTF8, LCLIntf,
  expandenvvar, ssl_openssl11_lib
  {$IfDef WINDOWS}, winshortcut, windows, windirs {$EndIf};
{$R *.lfm}

{ TMainForm }

procedure TMainForm.FormShow(Sender: TObject);
begin
  ListBox1.SetFocus;
end;

procedure TMainForm.ListBox1Click(Sender: TObject);
begin
  if ListBox1.ItemIndex < 0 then Panel1.Caption:= ''
  else
  begin
    Panel1.Caption:= ' ' + GetPanelCaption;
  end;
end;

procedure TMainForm.ListBox1DblClick(Sender: TObject);
begin
  ActRun.Execute;
end;

procedure TMainForm.ListBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    VK_RETURN:
    begin
      if Shift = [ssCtrl] then
        ActEdit.Execute
      else
        ActRun.Execute;
    end;
  end;
end;

procedure TMainForm.Timer1Timer(Sender: TObject);
var
  I, N, Len: Integer;
  Pr: TProcessUTF8;
  S: string;
begin
  Timer1.Enabled:=False;
  try
    I := ListBox2.Count - 1;
    while I >= 0 do
    begin
      Pr := TProcessUTF8(ListBox2.Items.Objects[I]);
      if (Pr <> nil) and not Pr.Running then
      begin
        if Pr.Tag > 0 then
        begin
           Pr.Execute;
           Pr.Tag := Pr.Tag + 1;
           S := ListBox2.Items.Strings[I];
           Len:= Length(S);
           N := Pos('{', S) ;
           if N > 0 then
             Delete(S, N, Len - N + 1);
           S := S + '{' + IntToStr(Pr.Tag - 1) + '}';
           ListBox2.Items.Strings[I] := S;
        end
        else
        begin
          Pr.Free;
          ListBox2.Items.Delete(I);
        end;

      end;
      Dec(I);
    end;
  finally
    if ListBox2.Count > 0 then Timer1.Enabled := True;
  end;
end;

function TMainForm.GetPanelCaption: string;
var
  S: string;
  Prot, Path, User, Pass, Host, Port, Para: string;
begin
  Result := List.Values[ListBox1.Items.Strings[ListBox1.ItemIndex]];
  if Result <> '' then
  begin
    S := UTF8LowerCase(Result);
    if (Pos('ftp', S) = 1) or (Pos('http', S) = 1) then
    begin
      ParseURL(Result, Prot, User, Pass, Host, Port, Path, Para);
      Result := Prot + '://' + Host + Path;
    end;
  end;
end;

function TMainForm.NameExist(AName: string): Boolean;
var
  I: Integer;
begin
  Result := False;
  for I := 0 to ListBox1.Count - 1 do
  begin
    if SameText(AName, ListBox1.Items.Strings[I]) then
    begin
      Result := True;
      Break;
    end;
  end;
end;

procedure TMainForm.AExecute(aExeName: string; AutoRestart: Integer);
var
  AConfig, CurDir, S: string;
  Pr: TProcessUTF8;
  SL: TStringList;
  I: Integer;
  AName, AValue: string;
begin

  if ListBox1.ItemIndex >= 0 then
  begin;
    SL := TStringList.Create;
    try
      if FileExists(ExeDir + 'evars.cfg') then
        SL.LoadFromFile(ExeDir + 'evars.cfg');

      for I := 0 to SL.Count - 1 do
      begin
        SL.GetNameValue(I, AName, AValue);
        expandenvvar.SetEnvironmentVariable(UTF8UpperCase(AName), AValue);
      end;

      SL.Assign(Memo2.Lines);
      for I := 0 to SL.Count - 1 do
      begin
        SL.GetNameValue(I, AName, AValue);
        expandenvvar.SetEnvironmentVariable(UTF8UpperCase(AName), AValue);
      end;


    finally
      SL.Free;
    end;
    S := List.Values[ListBox1.Items.Strings[ListBox1.ItemIndex]];
    AConfig := ExpandEnvironmentVariables(S);
    Pr := TProcessUTF8.Create(Self);
    //Pr.StartupOptions := Pr.StartupOptions + [suoUseShowWindow];
    Pr.Parameters.Clear;
    Pr.CurrentDirectory := CurDir;
    Pr.Executable := CurDir + aExeName;
    Pr.Parameters.Add(AConfig);
    Pr.Tag := AutoRestart;
    Pr.Execute;
    Timer1.Enabled:=True;
    ListBox2.Items.AddObject(aExeName + ': ' + AConfig, Pr);
  end;
end;

procedure TMainForm.ActCloseExecute(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.ActAddExecute(Sender: TObject);
var
  I: Integer;
  AName: string;
begin
  ManEditForm := TManEditForm.Create(Self);
  try
    ManEditForm.CheckName := True;
    if ManEditForm.ShowModal = mrOK then
    begin
      AName:= Trim(ManEditForm.xLabeledEdit1.Text);
      I := List.Add(AName + '=' + Trim(ManEditForm.xEditButton1.Text));
      ListBox1.Items.Add(AName);
      List.SaveToFile(APath);
      ListBox1.ItemIndex := I;
      Panel1.Caption:= ' ' + GetPanelCaption;
    end;
  finally
    ManEditForm.Free;
  end;
end;

procedure TMainForm.ActCreateShortCutExecute(Sender: TObject);
var
  AName, ExName, DirName, AConfig, DesktopPath: string;
  {$IfDef WINDOWS}
  TempDirName, TempExName, TempConf, TempDesktop, TempComment: RawByteString;
  IObject: IUnknown;
  {$EndIf}
  {$IfDef LINUX}
  IconFile, UDir, UDirsFile, S: string;
  SL: TStringList;
  {$EndIf}
begin
  if ListBox1.ItemIndex < 0 then Exit;

  AName := ListBox1.Items.Strings[ListBox1.ItemIndex];
  DirName := ExtractFilePath(Application.ExeName);
  AConfig := List.Values[AName];
  {$IfDef WINDOWS}
  TempDirName := Utf8ToAnsi(DirName);
  SetCodePage(TempDirName, GetACP, True);
  DesktopPath := GetWindowsSpecialDir(CSIDL_DESKTOPDIRECTORY);
  DesktopPath := DesktopPath + AName + '.lnk';
  TempDesktop:= Utf8ToAnsi(DesktopPath);
  SetCodePage(TempDesktop, GetACP, True);
  ExName := DirName + 'CrossMachine.exe';
  TempExName := Utf8ToAnsi(ExName);
  SetCodePage(TempExName, GetACP, True);
  TempConf := Utf8ToAnsi(AConfig);
  SetCodePage(TempConf, GetACP, True);
  TempComment := 'Приложение Дизель-Паскаль';
  SetCodePage(TempComment, GetACP, True);

  CreateLinkEx(PChar(TempExName), PChar(TempConf), PChar(TempDirName), PChar(DesktopPath), PChar(TempComment));
  {$EndIf}

  {$IfDef LINUX}
  UDir := GetUserDir;
  ExName := DirName + 'CrossMachine';
  IconFile := DirName + 'CrossMachine.png';
  DesktopPath := '';

  if DirectoryExists(UDir + '.config/') then
  begin
    UDirsFile := UDir + '.config/user-dirs.dirs';
    if FileExists(UDirsFile) then
    begin
      SL := TStringList.Create;
      try
        SL.LoadFromFile(UDirsFile);
        S := SL.Values['XDG_DESKTOP_DIR'];
        if S <> '' then
        begin
          if S[1] = '"' then
          begin
            Delete(S, 1, 1);
            Delete(S, Length(S), 1);
          end;
          if Pos('$HOME/', S) = 1 then
          begin
            Delete(S, 1, 6);
            S := UDir + S;
          end;
          DesktopPath := S;
        end;
      finally
        SL.Free;
      end;
    end;
  end;

  //if DesktopPath = '' then
  //begin
  //  if DirectoryExists(UDir + 'Рабочий стол') then
  //    DesktopPath:= UDir + 'Рабочий стол'
  //  else
  //  if DirectoryExists(UDir + 'Desktop') then
  //    DesktopPath:= UDir + 'Desktop'
  //  else
  //  if DirectoryExists(UDir + 'desktop') then
  //    DesktopPath:= UDir + 'desktop';
  //end;



  if DesktopPath = '' then
  begin
    SelectDirectoryDialog1.InitialDir:= UDir;
    if SelectDirectoryDialog1.Execute then
      DesktopPath:= SelectDirectoryDialog1.FileName;
  end;

  if DesktopPath = '' then Exit;

  SL := TStringList.Create;
  try
    SL.Append('[Desktop Entry]');
    SL.Append('Version=1.0');
    SL.Append('Type=Application');
    SL.Append('Name=' + AName);
    SL.Append('Comment=Приложение Дизель-Паскаль');
    SL.Append('Exec=' + ExName + ' ' + AConfig);
    SL.Append('Icon=' + IconFile);
    SL.Append('Path=' + DirName);
    SL.Append('Terminal=false');
    SL.Append('StartupNotify=false');

    SL.SaveToFile(DesktopPath + DirectorySeparator + AName + '.desktop');
  finally
    SL.Free;
  end;
  {$EndIf}
end;

procedure TMainForm.ActDeleteExecute(Sender: TObject);
var
  S: string;
begin
  if ListBox1.ItemIndex >= 0 then
  begin
    S := ListBox1.Items.Strings[ListBox1.ItemIndex];
    if Application.MessageBox(PChar('Удалить запись: ' + S + '?'), PChar(Caption), MB_YESNO or MB_ICONQUESTION) = IDYES then
    begin
      List.Delete(ListBox1.ItemIndex);
      ListBox1.Items.Delete(ListBox1.ItemIndex);
      Panel1.Caption := '';
      List.SaveToFile(APath);
      if ListBox1.ItemIndex < 0 then
        Panel1.Caption := ''
      else
        Panel1.Caption:= ' ' + GetPanelCaption;
    end;
  end;
end;

procedure TMainForm.ActDesignExecute(Sender: TObject);
var
  S: string;
begin
  if ListBox1.ItemIndex >= 0 then
  begin;
    S := List.Values[ListBox1.Items.Strings[ListBox1.ItemIndex]];
    if ExtractFileExt(S) = '.sm9' then
    begin
      ShowMessage('Дизайнер не поддерживает загрузку зашифрованных файлов');
      Exit;
    end;
  end;
  AExecute('CrossDesigner')
end;

procedure TMainForm.ActEditExecute(Sender: TObject);
var
  AName: string;
begin
  if ListBox1.ItemIndex >= 0 then
  begin
    ManEditForm := TManEditForm.Create(Self);
    try
      ManEditForm.CheckName := False;
      AName := ListBox1.Items.Strings[ListBox1.ItemIndex];
      ManEditForm.xLabeledEdit1.Text := AName;
      ManEditForm.xEditButton1.Text:= List.Values[AName];
      if ManEditForm.ShowModal = mrOK then
      begin
        AName:= Trim(ManEditForm.xLabeledEdit1.Text);
        List.Strings[ListBox1.ItemIndex] := AName + '=' + ManEditForm.xEditButton1.Text;
        ListBox1.Items.Strings[ListBox1.ItemIndex] := AName;
        List.SaveToFile(APath);
        Panel1.Caption:= ' ' + GetPanelCaption;
      end;
    finally
      ManEditForm.Free;
    end;
  end;
end;

procedure TMainForm.ActOpenFolderExecute(Sender: TObject);
var
  AName, App: string;
begin
  if ListBox1.ItemIndex < 0 then Exit;

  AName := ListBox1.Items.Strings[ListBox1.ItemIndex];
  App := List.Values[AName];
  if Pos('http://', App) = 0 then
      OpenURL(ExtractFilePath(App))
end;

procedure TMainForm.ActRowUpExecute(Sender: TObject);
var
  S: string;
  I, UpI: Integer;
begin
  if (ListBox1.Count > 0) and (ListBox1.ItemIndex > 0) then
  begin
    I := ListBox1.ItemIndex;
    UpI := I - 1;
    S := ListBox1.Items.Strings[I];
    ListBox1.Items.Strings[I] := ListBox1.Items.Strings[UpI];
    ListBox1.Items.Strings[UpI] := S;
    S := List.Strings[I];
    List.Strings[I] := List.Strings[UpI];
    List.Strings[UpI] := S;
    List.SaveToFile(APath);
    ListBox1.ItemIndex := UpI;
  end;
end;

procedure TMainForm.ActRunExecute(Sender: TObject);
begin
  AExecute('CrossMachine', 0);
end;

procedure TMainForm.ActRunWithRestartExecute(Sender: TObject);
begin
  AExecute('CrossMachine', 1);
end;

procedure TMainForm.Button10Click(Sender: TObject);
begin
  Memo2.Lines.SaveToFile(eVarsFile);
end;

procedure TMainForm.Button6Click(Sender: TObject);
var
  Pr: TProcessUTF8;
begin
  if ListBox2.ItemIndex >= 0 then
  begin
    Pr := TProcessUTF8(ListBox2.Items.Objects[ListBox2.ItemIndex]);
    Pr.Tag := 0;
    if Pr.Running then
    begin
      Pr.Terminate(0);
    end;
    Application.ProcessMessages;
    if not Pr.Running then
    begin
      Pr.Free;
      ListBox2.Items.Delete(ListBox2.ItemIndex);
    end;
  end;
end;

procedure TMainForm.Button7Click(Sender: TObject);
var
  S, AFile, CurPath, CurFile, FN: string;
  I: Integer;
  MemStream: TMemoryStream;
  FlStream: TFileStream;
  FTP: TFTPSend;
  Prot, User, Pass, Host, Port, Path, Para: string;
begin
  if Memo1.Lines.Count = 0 then Exit;
  CurPath := ExtractFilePath(Application.ExeName);
  S := Memo1.Lines.Strings[0];
  if S <> '' then
  begin
    if Pos('http://', S) = 1 then
    begin
      S := S + '/';
      MemStream := TMemoryStream.Create;
      try
        for I := 1 to Memo1.Lines.Count - 1 do
        begin
          FN := Memo1.Lines.Strings[I];
          AFile := S + FN;
          CurFile := CurPath + FN;
          MemStream.Clear;
          if HttpGetBinary(AFile, MemStream) then
          begin
            FlStream := TFileStream.Create(CurFile, fmCreate);
            try
              MemStream.Seek(0, soFromBeginning);
              FlStream.CopyFrom(MemStream, MemStream.Size);
            finally
              FlStream.Free;
            end;
          end;
        end;
      finally
        MemStream.Free;
      end;
      ShowMessage('Обновление успешно завершено');
    end
    else
    if Pos('ftp://', S) = 1 then
    begin
      FTP := TFTPSend.Create;
      try
        ParseURL(S, Prot, User, Pass, Host, Port, Path, Para);
        FTP.TargetHost := Host;
        FTP.TargetPort := Port;
        FTP.UserName := User;
        FTP.Password := Pass;
        if FTP.Login then
        begin
          for I := 1 to Memo1.Lines.Count - 1 do
          begin
            FN := Memo1.Lines.Strings[I];
            CurFile := CurPath + FN;
            if Path <> '' then
              AFile:= Path + '/' + FN
            else
              AFile:= FN;
            if FTP.RetrieveFile(AFile, False) then
            begin
              FTP.DataStream.SaveToFile(CurFile);
            end
            else
             ShowMessage('Не удалось получить файл: ' + AFile);
          end;
          FTP.Logout;
          ShowMessage('Обновление успешно завершено');
        end
        else
          ShowMessage('Не удалось подключиться по ftp протоколу');
      finally
        FTP.Free;
      end;

    end
    else
    if DirectoryExists(S) then
    begin
      S := S + DirectorySeparator;
      for I := 1 to Memo1.Lines.Count - 1 do
      begin
        FN := Memo1.Lines.Strings[I];
        AFile := S + FN;
        CurFile := CurPath + FN;
        if FileExists(AFile) then
        begin
          if not FileUtil.CopyFile(AFile, CurFile) then
          begin
            ShowMessage('Не могу скопировать файл' + AFile + #13#10'Обновление остановлено');
            Break;
          end
        end
        else
          ShowMessage(AFile + ' не существует');
      end;
      ShowMessage('Обновление успешно завершено');
    end;
  end;
end;

procedure TMainForm.Button8Click(Sender: TObject);
begin
  Memo1.Lines.SaveToFile(UpdCnofig);
end;

procedure TMainForm.Button9Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    Memo1.Lines.LoadFromFile(OpenDialog1.FileName);
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  S: string;
  I: Integer;
  Ext: String;
begin
  ListBox1.ScrollWidth := 0;
  ListBox2.ScrollWidth := 0;
  S := ParamStr(1);

  if Pos('-v', S) > 0 then
  begin
    Button2.Visible := False;
    Button3.Visible := False;
    Button4.Visible := False;
    Button5.Visible := False;
    ActDesign.Enabled := False;
  end;

  List := TStringList.Create;
  eVarList := TStringList.Create;

  {$IfDef PORTABLEVERS}
    ADir := ExtractFilePath(Application.ExeName);
  {$Else}
     {$IfDef UNIX}
        ADir := GetUserDir + '.DieselPascal' + DirectorySeparator;
     {$Else}
        ADir := GetUserDir + 'DieselPascal' + DirectorySeparator;
     {$EndIf}
  {$EndIf}
  APath := ADir + 'Manager.cfg';
  UpdCnofig := ADir + 'UpdateFiles.cfg';


  if not DirectoryExists(ADir) then
    CreateDir(ADir);

  ExeDir := ExtractFilePath(Application.ExeName);

  expandenvvar.SetEnvironmentVariable('DIESEL_LOCALSET_DIR', ADir);
  expandenvvar.SetEnvironmentVariable('DIESEL_EXE_DIR', ExeDir);

  if FileExists(APath) then
  begin
    List.LoadFromFile(APath);
    for I := 0 to List.Count - 1 do
    begin
      ListBox1.Items.Add(List.Names[I]);
    end;
    if ListBox1.Count > 0 then
    begin
      ListBox1.ItemIndex := 0;
      ListBox1.Click;
    end;
  end;
  if FileExists(UpdCnofig) then
    Memo1.Lines.LoadFromFile(UpdCnofig);

  eVarsFile := ADir + 'evars.cfg';
  if FileExists(eVarsFile) then
    Memo2.Lines.LoadFromFile(eVarsFile);

  Ext := ExtractFileExt(Application.ExeName);
  if not FileExists(ExeDir + 'CrossDesigner' + Ext) then
  begin
    Button2.Visible := False;
    ActDesign.Enabled := False;
  end;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  List.Free;
  eVarList.Free;
end;

end.

