unit DASQLEdits;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, SQLEditor, PropEdits, DBAccess;

type

  { TDASQLPropertyEditor }

  TDASQLPropertyEditor = class(TSQLPropertyEditor)
  protected
    MainMetadata: TDAMetaData;
    SubMetadata: TDAMetaData;
    IndexedColumn: TDAMetaData;
    PKeyMetadata: TDAMetaData;
  public
    procedure LoadMetadata(MetaTypes: TMetadataTypes); override;
  end;

implementation

uses ComCtrls;

{ TDASQLPropertyEditor }

procedure TDASQLPropertyEditor.LoadMetadata(MetaTypes: TMetadataTypes);
var
  Connect: Boolean;
  Node: TTreeNode;
  S: string;
  B: Boolean;

begin
  ClearNameList;
  if (MainMetadata = nil) or (IndexedColumn = nil) or
     (SubMetadata = nil) or (PKeyMetadata = nil) then Exit;

  MainMetadata.Connection := TCustomDADataSet(GetComponent(0)).Connection;
  SubMetadata.Connection := MainMetadata.Connection;
  IndexedColumn.Connection := MainMetadata.Connection;
  PKeyMetadata.Connection := MainMetadata.Connection;
  if MainMetadata.Connection = nil then Exit;
  Connect:= MainMetadata.Connection.Connected;
  if not Connect then MainMetadata.Connection.Open;
  if not MainMetadata.Connection.Connected then Exit;
  try
    PKeyMetadata.MetaDataKind := 'Constraints';
    IndexedColumn.MetaDataKind := 'IndexColumns';
    if mtTable in MetaTypes then
    begin
      MainMetadata.MetaDataKind := 'Tables';
      MainMetadata.Restrictions.Values['TABLE_TYPE'] := 'TABLE';
      SubMetadata.MetaDataKind := 'Columns';

      MainMetadata.Open;
      try
        while not MainMetadata.EOF do
        begin
          S := MainMetadata.FieldByName('TABLE_NAME').AsString;
          Node := AddTable(S);
          SubMetadata.Restrictions.Values['TABLE_NAME'] := S;
          IndexedColumn.Restrictions.Values['TABLE_NAME'] := S;
          PKeyMetadata.Restrictions.Values['TABLE_NAME'] := S;
          PKeyMetadata.Restrictions.Values['CONSTRAINT_TYPE'] := 'PRIMARY KEY';
          IndexedColumn.Open;
          SubMetadata.Open;
          while not SubMetadata.Eof do
          begin
            B := False;
            if IndexedColumn.Locate('COLUMN_NAME', SubMetadata.FieldByName('COLUMN_NAME').AsString, []) then
            begin
              PKeyMetadata.Open;
              if not PKeyMetadata.IsEmpty then
              begin
                if PKeyMetadata.Locate('INDEX_NAME', IndexedColumn.FieldByName('INDEX_NAME').AsString, []) then
                   B := True;
              end;
              PKeyMetadata.Close;
            end;
            AddField(Node, SubMetadata.FieldByName('COLUMN_NAME').AsString, B);
            SubMetadata.Next;
          end;
          SubMetadata.Close;
          IndexedColumn.Close;
          MainMetadata.Next;
        end;
      finally
        MainMetadata.Close;
      end;
    end;

    if mtView in MetaTypes then
    begin
      MainMetadata.MetaDataKind := 'Tables';
      MainMetadata.Restrictions.Values['TABLE_TYPE'] := 'VIEW';
      SubMetadata.MetaDataKind := 'Columns';
      MainMetadata.Open;
      try
        while not MainMetadata.EOF do
        begin
          S := MainMetadata.FieldByName('TABLE_NAME').AsString;
          Node := AddView(S);
          SubMetadata.Restrictions.Values['TABLE_NAME'] := S;
          SubMetadata.Open;
          while not SubMetadata.Eof do
          begin
            AddField(Node, SubMetadata.FieldByName('COLUMN_NAME').AsString);
            SubMetadata.Next;
          end;
          SubMetadata.Close;
          MainMetadata.Next;
        end;
      finally
        MainMetadata.Close;
      end;
    end;

    if mtStoredProc in MetaTypes then
    begin
      MainMetadata.MetaDataKind := 'Procedures';
      SubMetadata.MetaDataKind := 'ProcedureParameters';
      MainMetadata.Open;
      try
        while not MainMetadata.EOF do
        begin
          S := MainMetadata.FieldByName('PROCEDURE_NAME').AsString;
          Node := AddProcedure(S);
          SubMetadata.Restrictions.Values['PROCEDURE_NAME'] := S;
          SubMetadata.Open;
          while not SubMetadata.Eof do
          begin
            AddProcParam(Node, SubMetadata.FieldByName('PARAMETER_NAME').AsString, SubMetadata.FieldByName('DIRECTION').AsString = 'IN');
            SubMetadata.Next;
          end;
          SubMetadata.Close;
          MainMetadata.Next;
        end;
      finally
        MainMetadata.Close;
      end;
    end;
  finally
    if not Connect then MainMetadata.Connection.Close;
  end;

end;

end.

