unit dpUtils;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, variants;

type
  TSuLanguage = (slPPlus, slPascal);
  TdpAnsiFunction = (af1250, af1251, af1252, af1253, af1254, af1255, af1256, af1257, af1258);
  TdpDOSFunction = (df437, df850, df852, df866, df874);

  TSuPtr = PtrInt;
  TDpString = string;

  TsuBaseType = (btInt, btBool, btFloat, btChar, btString, btClass,
    btArray, btVariant, btEnum, btSet, btEvent, btRecord, btPointer, btIntf,
    btDisp, btOrdinal, btPointerProc);

  TsuIdentType = (itUnknown, itUnitName, itConst, itVar, itParam,
    itProc, itType, itValue, itClassVar, itClassComponent, itProp, itClassProp);

  TObjectList = class
  private
    FList: TList;
  protected
    function GetItems(Index: Integer): TObject;
  public
    constructor Create;
    destructor Destroy; override;
    procedure Clear; virtual;
    function Add(AObject: TObject): Integer; virtual;
    procedure Delete(Index: Integer);
    function Count: Integer;
    procedure Remove(AObject: TObject);
    property Items[Index: Integer]: TObject read GetItems;
  end;

TConstArray = array of TVarRec;

procedure VariantToVarRec(var V: Variant; var VR: TConstArray);
procedure ClearVarRec(var VR: TConstArray);
function dp_UTF8ToAnsi(S: string): string;
function dp_AnsiToUTF8(S: string): string;
function dp_UTF8ToDOSCP(S: string): string;
function dp_DOSCPToUTF8(S: string): string;

var
  DefaultAnsiFunciton: TdpAnsiFunction = af1251;
  DefaultDosFunction: TdpDOSFunction = df866;

implementation

uses LConvEncoding;

{TObjectList}

constructor TObjectList.Create;
begin
  inherited;
  FList := TList.Create;
end;

destructor TObjectList.Destroy;
begin
  Clear;
  FList.Free;
  inherited Destroy;
end;

procedure TObjectList.Clear;
begin
  while FList.Count > 0 do
  begin
      TObject(FList.Items[0]).Free;
      FList.Delete(0);
  end;
end;

function TObjectList.Add(AObject: TObject): Integer;
begin
  Result := FList.Add(AObject);
end;

procedure TObjectList.Delete(Index: Integer);
begin
  FList.Delete(Index);
end;

function TObjectList.Count: Integer;
begin
  Result := FList.Count;
end;

procedure TObjectList.Remove(AObject: TObject);
begin
  FList.Remove(AObject);
end;

function TObjectList.GetItems(Index: Integer): TObject;
begin
  Result := TObject(FList.Items[Index]);
end;

procedure VariantToVarRec(var V: Variant; var VR: TConstArray);
var
  I, L: Integer;
begin
  L := VarArrayHighBound(V, 1);
  SetLength(VR, L);

  for I := 0 to L - 1 do
    case TVarData(V[I]).VType of
      varSmallint, varInteger, varByte:
      begin
        VR[I].VType := vtInteger;
        VR[I].VInteger := V[I];
      end;

      varSingle, varDouble, varCurrency, varDate:
      begin
        VR[I].VType := vtExtended;
        New(VR[I].VExtended);
        VR[I].VExtended^ := V[I];
      end;
      varBoolean:
      begin
        VR[I].VType := vtBoolean;
        VR[I].VBoolean := V[I];
      end;
      varString, varOleStr:
      begin
        VR[I].VType := vtAnsiString;
        AnsiString(VR[I].VAnsiString) := Ansistring(V[I]);
      end;
      varUString:
      begin
        VR[I].VType := vtUnicodeString;
        UnicodeString(VR[I].VUnicodeString) := string(V[I]);
      end;
      varVariant:
      begin
        VR[I].VType := vtVariant;
        New(VR[I].VVariant);
        VR[I].VVariant^ := V[I];
      end;
    end;
end;

procedure ClearVarRec(var VR: TConstArray);
var
  I: Integer;
begin
  for I := 0 to Length(VR) - 1 do
  begin
    if VR[I].VType in [vtExtended, vtString, vtVariant] then
      Dispose(VR[I].VExtended);
  end;
  Finalize(VR);
end;

function dp_UTF8ToAnsi(S: string): string;
begin
  case DefaultAnsiFunciton of
    af1250: Result := UTF8ToCP1250(S, True);
    af1251: Result := UTF8ToCP1251(S, True);
    af1252: Result := UTF8ToCP1252(S, True);
    af1253: Result := UTF8ToCP1253(S, True);
    af1254: Result := UTF8ToCP1254(S, True);
    af1255: Result := UTF8ToCP1255(S, True);
    af1256: Result := UTF8ToCP1256(S, True);
    af1257: Result := UTF8ToCP1257(S, True);
    af1258: Result := UTF8ToCP1258(S, True);
  else
    Result := S;
  end;
end;

function dp_AnsiToUTF8(S: string): string;
begin
  case DefaultAnsiFunciton of
    af1250: Result := CP1250ToUTF8(S);
    af1251: Result := CP1251ToUTF8(S);
    af1252: Result := CP1252ToUTF8(S);
    af1253: Result := CP1253ToUTF8(S);
    af1254: Result := CP1254ToUTF8(S);
    af1255: Result := CP1255ToUTF8(S);
    af1256: Result := CP1256ToUTF8(S);
    af1257: Result := CP1257ToUTF8(S);
    af1258: Result := CP1258ToUTF8(S);
  else
    Result := S;
  end;
end;

function dp_UTF8ToDOSCP(S: string): string;
begin
  case DefaultDosFunction of
    df437: Result := UTF8ToCP437(S);
    df850: Result := UTF8ToCP850(S);
    df852: Result := UTF8ToCP852(S);
    df866: Result := UTF8ToCP866(S);
    df874: Result := UTF8ToCP874(S);
  else
    Result := S;
  end;
end;

function dp_DOSCPToUTF8(S: string): string;
begin
  case DefaultDosFunction of
    df437: Result := CP437ToUTF8(S);
    df850: Result := CP850ToUTF8(S);
    df852: Result := CP852ToUTF8(S);
    df866: Result := CP866ToUTF8(S);
    df874: Result := CP874ToUTF8(S);
  else
    Result := S;
  end;
end;


end.

