unit dpi_Stdctrls;

{$mode objfpc}{$H+}
{$M+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo, Forms;

type

  { TStdImport }

  TStdImport = class(TClassImporter)
    function ListBox_AddItem(Instance: TObject; var Params: Variant): Variant;
    function ListBox_Clear(Instance: TObject; var Params: Variant): Variant;
    function ListBox_GetIndexAtXY(Instance: TObject; var Params: Variant
      ): Variant;
    function ListBox_ItemVisible(Instance: TObject; var Params: Variant
      ): Variant;
    function ListBox_LockSelectionChange(Instance: TObject; var Params: Variant
      ): Variant;
    function ListBox_SelectAll(Instance: TObject; var Params: Variant): Variant;
    function ListBox_UnlockSelectionChange(Instance: TObject;
      var Params: Variant): Variant;
    function Memo_LoadFromFile(Instance: TObject; var Params: Variant): Variant;
    function Memo_SaveToFile(Instance: TObject; var Params: Variant): Variant;
    function TCombo_ItemIndex_Get(Instance: Pointer): Variant;
    procedure TCombo_ItemIndex_Set(Instance: Pointer; AValue: Variant);
    function TEdit_Clear(Instance: TObject; var Params: Variant): Variant;
    function TEdit_ClearSelection(Instance: TObject; var Params: Variant
      ): Variant;
  private
    function TLabel_CaptionGet(Instance: Pointer): Variant;
    procedure TLabel_CaptionSet(Instance: Pointer; AValue: Variant);
    function TMenuItem_Add(Instance: TObject; var Params: Variant): Variant;
    function TMenuItem_AddSeparator(Instance: TObject; var Params: Variant
      ): Variant;
    function TMenuItem_Clear(Instance: TObject; var Params: Variant): Variant;
    function TMenuItem_Count_Get(Instance: Pointer): Variant;
    function TMenuItem_Delete(Instance: TObject; var Params: Variant): Variant;
    function TMenuItem_Find(Instance: TObject; var Params: Variant): Variant;
    function TMenuItem_HasBitmap(Instance: TObject; var Params: Variant
      ): Variant;
    function TMenuItem_HasIcon(Instance: TObject; var Params: Variant): Variant;
    function TMenuItem_HasParent(Instance: TObject; var Params: Variant
      ): Variant;
    function TMenuItem_IndexOf(Instance: TObject; var Params: Variant): Variant;
    function TMenuItem_IndexOfCaption(Instance: TObject; var Params: Variant
      ): Variant;
    function TMenuItem_Insert(Instance: TObject; var Params: Variant): Variant;
    function TMenuItem_IsCheckItem(Instance: TObject; var Params: Variant
      ): Variant;
    function TMenuItem_IsInMenuBar(Instance: TObject; var Params: Variant
      ): Variant;
    function TMenuItem_IsLine(Instance: TObject; var Params: Variant): Variant;
    function TMenuItem_Items_Get(Instance: TObject; var Params: Variant
      ): Variant;
    function TMenuItem_MenuIndex_Get(Instance: Pointer): Variant;
    procedure TMenuItem_MenuIndex_Set(Instance: Pointer; AValue: Variant);
    function TMenuItem_Menu_Get(Instance: Pointer): Variant;
    function TMenuItem_Parent_Get(Instance: Pointer): Variant;
    function TMenuItem_Remove(Instance: TObject; var Params: Variant): Variant;
    function TMenuItem_VisibleIndexOf(Instance: TObject; var Params: Variant
      ): Variant;
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure RegisterPublic(AType: TDpType); override;
  published
    function TButton_Click(Instance: TObject;
      var Params: Variant): Variant;

    function TAction_Execute(Instance: TObject;
      var Params: Variant): Variant;
    function TAction_Update(Instance: TObject;
      var Params: Variant): Variant;
    function TACtion_ActionComponentGet(Instance: Pointer): Variant;
    procedure TAction_ActionComponentSet(Instance: Pointer; AValue: Variant);
    function TCAction_CaptionGet(Instance: Pointer): Variant;
    procedure TCAction_CaptionSet(Instance: Pointer; AValue: Variant);

    function TMenuItem_Click(Instance: TObject;
      var Params: Variant): Variant;
    {TPopupMenu}
    function PopupMenu_PopupComponentGet(Instance: Pointer): Variant;
    procedure PopupMenu_PopupComponentSet(Instance: Pointer; AValue: Variant);
    function PopupMenu_PopupPointGet(Instance: Pointer): Variant;
    function PopupMenu_Popup(Instance: TObject; var Params: Variant): Variant;

    {TCustomEdit}
    function TEDit_SelLengthGet(Instance: Pointer): Variant;
    procedure TEDit_SelLengthSet(Instance: Pointer; AValue: Variant);
    function TEDit_SelStartGet(Instance: Pointer): Variant;
    procedure TEDit_SelStartSet(Instance: Pointer; AValue: Variant);
    function TEDit_SelTextGet(Instance: Pointer): Variant;
    procedure TEDit_SelTextSet(Instance: Pointer; AValue: Variant);
    function TEDit_TextGet(Instance: Pointer): Variant;
    procedure TEDit_TextSet(Instance: Pointer; AValue: Variant);
    function TEdit_SelectAll(Instence: TObject; var Params: Variant): Variant;
    {TCustomComboBox}
    function TCombo_DroppedDown_Get(Instance: Pointer): Variant;
    procedure TCombo_DroppedDown_Set(Instance: Pointer; AValue: Variant);
    function TCombo_Items_Get(Instance: Pointer): Variant;
    procedure TCombo_Items_Set(Instance: Pointer; AValue: Variant);
    {TListBox}
    function TListBox_ItemIndex_Get(Instance: Pointer): Variant;
    procedure TListBox_ItemIndex_Set(Instance: Pointer; AValue: Variant);
    function TListBox_Count_Get(Instance: Pointer): Variant;
    function TListBox_Items_Get(Instance: Pointer): Variant;
    procedure TListBox_Items_Set(Instance: Pointer; AValue: Variant);

    function TListBox_SelCount_Get(Instance: Pointer): Variant;
    function TListBox_Selected_Get(Instance: TObject;
      var Params: Variant): Variant;
    function TListBox_Selected_Set(Instance: TObject;
      var Params: Variant): Variant;
    {TCustomEdit}
    function TEdit_Undo(Instance: TObject;
      var Params: Variant): Variant;
    {TCustomActionList}
    function TActList_ActionCount(Instance: Pointer): Variant;
    function TActList_ActionsGet(Instance: TObject; var Params: Variant): Variant;
    function TActList_ActionsSet(Instance: TObject; var Params: Variant): Variant;

    {TCheckGroup}
    function CheckGroup_Rows(Instance: TObject; var Params: Variant): Variant;
    function CheckGroup_CheckedGet(Instance: TObject; var Params: Variant): Variant;
    function CheckGroup_CheckedSet(Instance: TObject; var Params: Variant): Variant;
    function CheckGroup_CheckEnabledGet(Instance: TObject; var Params: Variant): Variant;
    function CheckGroup_CheckEnabledSet(Instance: TObject; var Params: Variant): Variant;

    {TButton}
    procedure TButton_CaptionSet(Instance: Pointer; AValue: Variant);
    function TButton_CaptionGet(Instance: Pointer): Variant;
  end;

implementation

uses Controls, StdCtrls, Menus, ExtCtrls, ActnList, dpUtils, FileUtil;

function TStdImport.ListBox_AddItem(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TListBox(Instance).AddItem(Params[0], TObject( TSuPtr(Params[1]) ));
end;

function TStdImport.ListBox_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TListBox(Instance).Clear;
end;

function TStdImport.ListBox_GetIndexAtXY(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TListBox(Instance).GetIndexAtXY(Params[0], Params[1]);
end;

function TStdImport.ListBox_ItemVisible(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TListBox(Instance).ItemVisible(Params[0]);
end;

function TStdImport.ListBox_LockSelectionChange(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListBox(Instance).LockSelectionChange;
end;

function TStdImport.ListBox_SelectAll(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TListBox(Instance).SelectAll;
end;

function TStdImport.ListBox_UnlockSelectionChange(Instance: TObject;
  var Params: Variant): Variant;
begin
  TListBox(Instance).UnlockSelectionChange;
end;

function TStdImport.Memo_LoadFromFile(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  TCustomMemo(Instance).Lines.LoadFromFile(S);
end;

function TStdImport.Memo_SaveToFile(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  TCustomMemo(Instance).Lines.SaveToFile(S);
end;

function TStdImport.TCombo_ItemIndex_Get(Instance: Pointer): Variant;
begin
  Result := TCustomComboBox(Instance).ItemIndex;
end;

procedure TStdImport.TCombo_ItemIndex_Set(Instance: Pointer; AValue: Variant);
begin
  TCustomComboBox(Instance).ItemIndex:= AValue;
end;

function TStdImport.TEdit_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TCustomEdit(Instance).Clear;
end;

function TStdImport.TEdit_ClearSelection(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TCustomEdit(Instance).ClearSelection;
end;

function TStdImport.TLabel_CaptionGet(Instance: Pointer): Variant;
begin
  Result := TLabel(Instance).Caption;
end;

procedure TStdImport.TLabel_CaptionSet(Instance: Pointer; AValue: Variant);
begin
  TLabel(Instance).Caption := AValue;
end;

function TStdImport.TMenuItem_Add(Instance: TObject; var Params: Variant
  ): Variant;
var
  Item: TMenuItem;
begin
  Item := TMenuItem( TSuPtr(Params[0]) );
  TMenuItem(Instance).Add(Item);
end;

function TStdImport.TMenuItem_AddSeparator(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMenuItem(Instance).AddSeparator;
end;

function TStdImport.TMenuItem_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TMenuItem(Instance).Clear;
end;

function TStdImport.TMenuItem_Count_Get(Instance: Pointer): Variant;
begin
  Result := TMenuItem(Instance).Count;
end;

function TStdImport.TMenuItem_Delete(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TMenuItem(Instance).Delete(Params[0]);
end;

function TStdImport.TMenuItem_Find(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TMenuItem(Instance).Find(Params[0]) );
end;

function TStdImport.TMenuItem_HasBitmap(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TMenuItem(Instance).HasBitmap;
end;

function TStdImport.TMenuItem_HasIcon(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TMenuItem(Instance).HasIcon;
end;

function TStdImport.TMenuItem_HasParent(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TMenuItem(Instance).HasParent;
end;

function TStdImport.TMenuItem_IndexOf(Instance: TObject; var Params: Variant
  ): Variant;
var
  Item: TMenuItem;
begin
  Item := TMenuItem( TSuPtr(Params[0]) );
  Result := TMenuItem(Instance).IndexOf(Item);
end;

function TStdImport.TMenuItem_IndexOfCaption(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TMenuItem(Instance).IndexOfCaption(Params[0]);
end;

function TStdImport.TMenuItem_Insert(Instance: TObject; var Params: Variant
  ): Variant;
var
  Item: TMenuItem;
begin
  Item := TMenuItem(TSuPtr(Params[1]));
  TMenuItem(Instance).Insert(Params[0], Item);
end;

function TStdImport.TMenuItem_IsCheckItem(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TMenuItem(Instance).IsCheckItem;
end;

function TStdImport.TMenuItem_IsInMenuBar(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TMenuItem(Instance).IsInMenuBar;
end;

function TStdImport.TMenuItem_IsLine(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TMenuItem(Instance).IsLine;
end;

function TStdImport.TMenuItem_Items_Get(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TMenuItem(Instance).Items[Params[0]] );
end;

function TStdImport.TMenuItem_MenuIndex_Get(Instance: Pointer): Variant;
begin
  Result := TMenuItem(Instance).MenuIndex;
end;

procedure TStdImport.TMenuItem_MenuIndex_Set(Instance: Pointer; AValue: Variant
  );
begin
  TMenuItem(Instance).MenuIndex := AValue;
end;

function TStdImport.TMenuItem_Menu_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TMenuItem(Instance).Menu );
end;

function TStdImport.TMenuItem_Parent_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TMenuItem(Instance).Parent );
end;

function TStdImport.TMenuItem_Remove(Instance: TObject; var Params: Variant
  ): Variant;
var
  Item: TMenuItem;
begin
  Item := TMenuItem(TSuPtr(Params[0]));
  TMenuItem(Instance).Remove(Item);
end;

function TStdImport.TMenuItem_VisibleIndexOf(Instance: TObject;
  var Params: Variant): Variant;
var
  Item: TMenuItem;
begin
  Item := TMenuItem(TSuPtr(Params[0]));
  Result := TMenuItem(Instance).VisibleIndexOf(Item);
end;

procedure TStdImport.TListBox_Items_Set(Instance: Pointer; AValue: Variant);
begin
  TListBox(Instance).Items := TStrings( TSuPtr(AValue) );
end;

procedure TStdImport.TButton_CaptionSet(Instance: Pointer; AValue: Variant);
begin
  TButton(Instance).Caption := AValue;
end;

function TStdImport.TButton_CaptionGet(Instance: Pointer): Variant;
begin
  Result := TCustomButton(Instance).Caption;
end;

procedure TStdImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TEditCharCase));
  AddType(TypeInfo(TEchoMode));
  AddType(TypeInfo(TScrollStyle));
  AddType(TypeInfo(TScrollCode));
  AddType(TypeInfo(TComboBoxStyle));
  AddType(TypeInfo(TListBoxStyle));
  AddType(TypeInfo(TListBoxOption));
  AddType(TypeInfo(TListBoxOptions));
  AddType(TypeInfo(TStaticBorderStyle));
  AddType(TypeInfo(TCheckBoxState));
  AddType(TypeInfo(TPopupAlignment));
  AddType(TypeInfo(TTrackButton));
  AddType(TypeInfo(TGlyphShowMode));
end;

procedure TStdImport.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
var
  AType: TDpType;
begin
  AddClass(TMenuItem, 'ТЭлементМеню').ClassImporter := Self;
  AddClass(TMainMenu, 'ТГлавноеМеню');
  AddClass(TPopupMenu, 'ТВсплывающееМеню').ClassImporter := Self;
  AddClass(TLabel, 'ТЛэйбл').ClassImporter := Self;
  AddClass(TCustomEdit).ClassImporter := Self;
  AddClass(TEdit, 'ТРедактор');
  //AddClass(TTextStrings).ClassImporter := Self;
  AddClass(TCustomMemo).ClassImporter := Self;
  AddClass(TMemo, 'ТБлокнот');
  AddClass(TCustomButton).ClassImporter := Self;
  AddClass(TButton, 'ТКнопка');
  AddClass(TCustomCheckBox);
  AddClass(TCheckBox, 'ТЧекБокс');
  AddClass(TRadioButton).ClassImporter := Self;
  AddClass(TCustomListBox).ClassImporter := Self;
  AddClass(TToggleBox);
  AddClass(TListBox, 'ТЛистБокс').ClassImporter := Self;
  AddClass(TCustomComboBox).ClassImporter := Self;
  AddClass(TComboBox, 'ТКомбоБокс');
  AddClass(TScrollBar);
  AddClass(TGroupBox, 'ТГроупБокс');
  AddClass(TRadioGroup, 'ТРадиоГруппа');
  AddClass(TCheckGroup).ClassImporter := Self;
  AddClass(TPanel, 'ТПанель');

  AddClass(TBasicAction).ClassImporter := Self;
  AddClass(TCustomAction).ClassImporter := Self;
  AddClass(TAction, 'ТДействие');
  AddClass(TCustomActionList).ClassImporter := Self;
  AddClass(TActionList, 'ТСписокДействий');
  AddClass(TDragObject);
  AddClass(TDragDockObject);
end;

procedure TStdImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TCustomEdit then
  begin
    AType.AddProp('SelLength', 'Integer', @TEDit_SelLengthGet, @TEDit_SelLengthSet);
    AType.AddProp('SelStart', 'Integer', @TEDit_SelStartGet, @TEDit_SelStartSet);
    AType.AddProp('SelText', 'string', @TEDit_SelTextGet, @TEDit_SelTextSet);
    AType.AddMethod('procedure SelectAll', @TEdit_SelectAll);
    AType.AddMethod('procedure Undo', @TEdit_Undo);
    AType.AddMethod('procedure ClearSelection', @TEdit_ClearSelection);
    AType.AddMethod('procedure Clear', @TEdit_Clear);

    AType.AddProp('Текст', 'строка', @TEDit_TextGet, @TEDit_TextSet);
  end
  else
  if AType.ValueClassType = TMenuItem then
  begin
    AType.AddMethod('procedure Click', @TMenuItem_Click);
    AType.AddMethod('процедура Нажать', @TMenuItem_Click);
    AType.AddMethod('function Find(const ACaption: string): TMenuItem', @TMenuItem_Find);
    AType.AddMethod('function HasIcon: boolean', @TMenuItem_HasIcon);
    AType.AddMethod('function HasParent: Boolean', @TMenuItem_HasParent);
    AType.AddMethod('procedure Add(Item: TMenuItem)', @TMenuItem_Add);
    AType.AddMethod('procedure AddSeparator', @TMenuItem_AddSeparator);
    AType.AddMethod('function IndexOf(Item: TMenuItem): Integer', @TMenuItem_IndexOf);
    AType.AddMethod('function IndexOfCaption(const ACaption: string): Integer', @TMenuItem_IndexOfCaption);
    AType.AddMethod('function VisibleIndexOf(Item: TMenuItem): Integer', @TMenuItem_VisibleIndexOf);
    AType.AddMethod('procedure Delete(Index: Integer)', @TMenuItem_Delete);
    AType.AddMethod('procedure Insert(Index: Integer; Item: TMenuItem)', @TMenuItem_Insert);
    AType.AddMethod('procedure Remove(Item: TMenuItem)', @TMenuItem_Remove);
    AType.AddMethod('function IsCheckItem: boolean', @TMenuItem_IsCheckItem);
    AType.AddMethod('function IsLine: Boolean', @TMenuItem_IsLine);
    AType.AddMethod('function IsInMenuBar: boolean', @TMenuItem_IsInMenuBar);
    AType.AddMethod('procedure Clear', @TMenuItem_Clear);
    AType.AddMethod('function HasBitmap: boolean', @TMenuItem_HasBitmap);
    AType.AddProp('Count', 'Integer', @TMenuItem_Count_Get);
    AType.AddProp('MenuIndex', 'Integer', @TMenuItem_MenuIndex_Get, @TMenuItem_MenuIndex_Set);
    AType.AddProp('Menu', 'TMenu', @TMenuItem_Menu_Get);
    AType.AddProp('Parent', 'TMenuItem', @TMenuItem_Parent_Get);
    AType.AddIndexedProp('Items', 'TMenuItem', 'Integer', @TMenuItem_Items_Get);
  end
  else
  if AType.ValueClassType = TPopupMenu then
  begin
    AType.AddMethod('procedure Popup(X, Y: Integer)', @PopupMenu_Popup);
    AType.AddProp('PopupComponent', 'TComponent', @PopupMenu_PopupComponentGet, @PopupMenu_PopupComponentSet);
    AType.AddProp('PopupPoint', 'TPoint', @PopupMenu_PopupPointGet);
  end
  else
  if AType.ValueClassType = TCustomButton then
  begin
    AType.AddMethod('procedure Click', @TButton_Click);
    AType.AddMethod('процедура Нажать', @TButton_Click);

    AType.AddProp('Надпись', 'строка', @TButton_CaptionGet, @TButton_CaptionSet);
  end
  else
  if AType.ValueClassType = TBasicAction then
  begin
    AType.AddMethod('procedure Execute', @TAction_Execute);
    AType.AddMethod('function Update: Boolean', @TAction_Update);
    AType.AddProp('ACtionComponent', 'TComponent', @TACtion_ActionComponentGet, @TAction_ActionComponentSet);

    AType.AddMethod('процедура Выполнить', @TAction_Execute);
  end
  else
  if AType.ValueClassType = TCustomAction then
  begin
    AType.AddProp('Caption', 'string', @TCAction_CaptionGet, @TCAction_CaptionSet);
    AType.AddProp('Надпись', 'строка', @TCAction_CaptionGet, @TCAction_CaptionSet);
  end
  else
  if AType.ValueClassType = TCustomComboBox then
  begin
    AType.AddProp('DroppedDown', 'Boolean', @TCombo_DroppedDown_Get, @TCombo_DroppedDown_Set);
    AType.AddProp('ItemIndex', 'Integer', @TCombo_ItemIndex_Get, @TCombo_ItemIndex_Set);
  end
  else
  if AType.ValueClassType = TCustomListBox then
  begin
    AType.AddMethod('procedure Clear', @ListBox_Clear);
    AType.AddMethod('procedure SelectAll', @ListBox_SelectAll);
    AType.AddMethod('procedure LockSelectionChange', @ListBox_LockSelectionChange);
    AType.AddMethod('procedure UnlockSelectionChange', @ListBox_UnlockSelectionChange);
    AType.AddMethod('function ItemVisible(Index: Integer): boolean', @ListBox_ItemVisible);
    AType.AddMethod('function GetIndexAtXY(X, Y: integer): integer', @ListBox_GetIndexAtXY);
    AType.AddMethod('procedure AddItem(const Item: String; AnObject: TObject)', @ListBox_AddItem);
    AType.AddProp('ItemIndex', 'Integer', @TListBox_ItemIndex_Get, @TListBox_ItemIndex_Set);
    AType.AddProp('SelCount', 'Integer', @TListBox_SelCount_Get, nil);
    AType.AddProp('Count', 'Integer', @TListBox_Count_Get);
    AType.AddIndexedProp('Selected', 'Boolean', 'Integer', @TListBox_Selected_Get, @TListBox_Selected_Set);

    AType.AddMethod('процедура Очистить', @ListBox_Clear);
    AType.AddProp('ИндексЭлемента', 'Целое', @TListBox_ItemIndex_Get, @TListBox_ItemIndex_Set);
    AType.AddProp('Количество', 'Целое', @TListBox_Count_Get);
    AType.AddProp('Элементы', 'TStrings', @TListBox_Items_Get, @TListBox_Items_Set);
  end
  else
  if AType.ValueClassType = TCustomActionList then
  begin
    AType.AddProp('ActionCount', 'Integer', @TActList_ActionCount);
    AType.AddIndexedProp('Actions', 'TContainedAction', 'Integer', @TActList_ActionsGet, @TActList_ActionsSet);
  end
  else
  if AType.ValueClassType = TCheckGroup then
  begin
    AType.AddMethod('function Rows: integer', @CheckGroup_Rows);
    AType.AddIndexedProp('Checked', 'Boolean', 'Integer', @CheckGroup_CheckedGet, @CheckGroup_CheckedSet);
    AType.AddIndexedProp('CheckEnabled', 'Boolean', 'Integer', @CheckGroup_CheckEnabledGet, @CheckGroup_CheckEnabledSet);
  end
  else
  if AType.ValueClassType = TCustomMemo then
  begin
    AType.AddMethod('procedure SaveToFile(AFileName: string)', @Memo_SaveToFile);
    AType.AddMethod('procedure LoadFromFile(AFileName: string)', @Memo_LoadFromFile);
  end
  else
  if AType.ValueClassType = TLabel then
  begin
    AType.AddProp('Надпись', 'строка', @TLabel_CaptionGet, @TLabel_CaptionSet);
  end;

end;

{TButton}

function TStdImport.TButton_Click(Instance: TObject;
      var Params: Variant): Variant;
begin
  TButton(Instance).Click;
end;

{TAction}

function TStdImport.TAction_Execute(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TBasicAction(Instance).Execute;
end;

function TStdImport.TAction_Update(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TBasicAction(Instance).Update;
end;

function TStdImport.TACtion_ActionComponentGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TBasicAction(Instance).ActionComponent)
end;

procedure TStdImport.TAction_ActionComponentSet(Instance: Pointer; AValue: Variant);
begin
  TBasicAction(Instance).ActionComponent := TComponent(TSuPtr(AValue));
end;

function TStdImport.TCAction_CaptionGet(Instance: Pointer): Variant;
begin
  Result := TCustomAction(Instance).Caption;
end;

procedure TStdImport.TCAction_CaptionSet(Instance: Pointer; AValue: Variant);
var
  S: string;
begin
  S := AValue;
  TCustomAction(Instance).Caption := S;
end;

function TStdImport.TMenuItem_Click(Instance: TObject;
      var Params: Variant): Variant;
begin
  TMenuItem(Instance).Click;
end;

{TPopupMenu}

function TStdImport.PopupMenu_PopupComponentGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TPopupMenu(Instance).PopupComponent);
end;

procedure TStdImport.PopupMenu_PopupComponentSet(Instance: Pointer; AValue: Variant);
begin
  TPopupMenu(Instance).PopupComponent := TComponent(TSuPtr(AValue))
end;

function TStdImport.PopupMenu_PopupPointGet(Instance: Pointer): Variant;
begin
  Result := THandle(@TPopupMenu(Instance).PopupPoint);
end;

function TStdImport.PopupMenu_Popup(Instance: TObject;
  var Params: Variant): Variant;
begin
  TPopupMenu(Instance).Popup(Params[0], Params[1]);
end;

{TCustomEdit}

function TStdImport.TEDit_SelLengthGet(Instance: Pointer): Variant;
begin
  Result := TCustomEdit(Instance).SelLength
end;

procedure TStdImport.TEDit_SelLengthSet(Instance: Pointer; AValue: Variant);
begin
  TCustomEdit(Instance).SelLength := AValue;
end;

function TStdImport.TEDit_SelStartGet(Instance: Pointer): Variant;
begin
  Result := TCustomEdit(Instance).SelStart
end;

procedure TStdImport.TEDit_SelStartSet(Instance: Pointer; AValue: Variant);
begin
  TCustomEdit(Instance).SelStart := AValue;
end;

function TStdImport.TEDit_SelTextGet(Instance: Pointer): Variant;
begin
  Result := TCustomEdit(Instance).SelText
end;

procedure TStdImport.TEDit_SelTextSet(Instance: Pointer; AValue: Variant);
begin
  TCustomEdit(Instance).SelText := AValue
end;

function TStdImport.TEDit_TextGet(Instance: Pointer): Variant;
begin
  Result := TCustomEdit(Instance).Text;
end;

procedure TStdImport.TEDit_TextSet(Instance: Pointer; AValue: Variant);
begin
  TCustomEdit(Instance).Text := string(AValue);
end;

function TStdImport.TEdit_SelectAll(Instence: TObject;
  var Params: Variant): Variant;
begin
  TCustomEdit(Instence).SelectAll;
end;

{TCustomComboBox}

function TStdImport.TCombo_DroppedDown_Get(Instance: Pointer): Variant;
begin
  Result := TCustomComboBox(Instance).DroppedDown;
end;

procedure TStdImport.TCombo_DroppedDown_Set(Instance: Pointer; AValue: Variant);
begin
  TCustomComboBox(Instance).DroppedDown := AValue;
end;

function TStdImport.TCombo_Items_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TCustomComboBox(Instance).Items);
end;

procedure TStdImport.TCombo_Items_Set(Instance: Pointer; AValue: Variant);
begin
  TCustomComboBox(Instance).Items := TStrings(TSuPtr(AValue))
end;

{TListBox}
function TStdImport.TListBox_ItemIndex_Get(Instance: Pointer): Variant;
begin
  Result := TCustomListBox(Instance).ItemIndex;
end;

procedure TStdImport.TListBox_ItemIndex_Set(Instance: Pointer; AValue: Variant);
begin
  TCustomListBox(Instance).ItemIndex := AValue;
end;

function TStdImport.TListBox_Count_Get(Instance: Pointer): Variant;
begin
  Result := TCustomListBox(Instance).Count;
end;

function TStdImport.TListBox_Items_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TListBox(Instance).Items);
end;

function TStdImport.TListBox_SelCount_Get(Instance: Pointer): Variant;
begin
  Result := TCustomListBox(Instance).SelCount;
end;

function TStdImport.TListBox_Selected_Get(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TCustomListBox(Instance).Selected[Params[0]];
end;

function TStdImport.TListBox_Selected_Set(Instance: TObject;
      var Params: Variant): Variant;
begin
  TCustomListBox(Instance).Selected[Params[0]] := Params[1];
end;

function TStdImport.TEdit_Undo(Instance: TObject;
      var Params: Variant): Variant;
begin
  TCustomEdit(Instance).Undo;
end;

{TCustomActionList}
function TStdImport.TActList_ActionCount(Instance: Pointer): Variant;
begin
  Result := TCustomActionList(Instance).ActionCount
end;

function TStdImport.TActList_ActionsGet(Instance: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(TCustomActionList(Instance).Actions[Params[0]]);
end;

function TStdImport.TActList_ActionsSet(Instance: TObject; var Params: Variant): Variant;
begin
  TCustomActionList(Instance).Actions[Params[0]] := TContainedAction(TSuPtr(Params[1]));
end;

function TStdImport.CheckGroup_Rows(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TCheckGroup(Instance).Rows;
end;

function TStdImport.CheckGroup_CheckedGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TCheckGroup(Instance).Checked[Params[0]];
end;

function TStdImport.CheckGroup_CheckedSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TCheckGroup(Instance).Checked[Params[0]] := Params[1];
end;

function TStdImport.CheckGroup_CheckEnabledGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TCheckGroup(Instance).CheckEnabled[Params[0]];
end;

function TStdImport.CheckGroup_CheckEnabledSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCheckGroup(Instance).CheckEnabled[Params[0]] := Params[1];
end;

end.


