unit dpi_DataAccess;

{$mode objfpc}{$H+}
{$M+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo, dpi_mettyps;

type

  { TDataAccImport }

  TDataAccImport = class(TClassImporter)
    function BufDataSet_CreateDataset(Instance: TObject; var Params: Variant
      ): Variant;
    function BufDataSet_LoadFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function BufDataSet_LoadFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function BufDataSet_SaveToFile(Instance: TObject; var Params: Variant
      ): Variant;
    function BufDataSet_SaveToStream(Instance: TObject; var Params: Variant
      ): Variant;
    function DbfFieldDefs_Add(Instance: TObject; var Params: Variant): Variant;
    function DbfFieldDefs_AddFieldDef(Instance: TObject; var Params: Variant
      ): Variant;
    function DbfFieldDefs_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function DbfFieldDefs_Items(Instance: TObject; var Params: Variant
      ): Variant;
    function Dbf_AbsolutePath(Instance: Pointer): Variant;
    function Dbf_AddIndex(Instance: TObject; var Params: Variant): Variant;
    function Dbf_CancelRange(Instance: TObject; var Params: Variant): Variant;
    function Dbf_CheckMasterRange(Instance: TObject; var Params: Variant
      ): Variant;
    function Dbf_CloseIndexFile(Instance: TObject; var Params: Variant
      ): Variant;
    function Dbf_CodePage(Instance: Pointer): Variant;
    function Dbf_CompactIndexFile(Instance: TObject; var Params: Variant
      ): Variant;
    function Dbf_CopyFrom(Instance: TObject; var Params: Variant): Variant;
    function Dbf_CreateTable(Instance: TObject; var Params: Variant): Variant;
    function Dbf_CreateTableEx(Instance: TObject; var Params: Variant): Variant;
    function Dbf_DbfFieldDefs(Instance: Pointer): Variant;
    function Dbf_DeleteIndex(Instance: TObject; var Params: Variant): Variant;
    function Dbf_DisableResyncOnPostGet(Instance: Pointer): Variant;
    function Dbf_EmptyTable(Instance: TObject; var Params: Variant): Variant;
    function Dbf_EndExclusive(Instance: TObject; var Params: Variant): Variant;
    function Dbf_ExactRecordCount(Instance: Pointer): Variant;
    function Dbf_GetAllIndexFiles(Instance: TObject; var Params: Variant
      ): Variant;
    function Dbf_GetFileNames(Instance: TObject; var Params: Variant): Variant;
    function Dbf_GetIndexNames(Instance: TObject; var Params: Variant): Variant;
    function Dbf_Get_LanguageID(Instance: Pointer): Variant;
    function Dbf_IsDeleted(Instance: TObject; var Params: Variant): Variant;
    function Dbf_KeySize(Instance: Pointer): Variant;
    function Dbf_LanguageStr(Instance: Pointer): Variant;
    function Dbf_LockTable(Instance: TObject; var Params: Variant): Variant;
    function Dbf_OpenIndexFile(Instance: TObject; var Params: Variant): Variant;
    function Dbf_PackTable(Instance: TObject; var Params: Variant): Variant;
    function Dbf_PhysicalRecNoGet(Instance: Pointer): Variant;
    procedure Dbf_PhysicalRecNoSet(Instance: Pointer; AValue: Variant);
    function Dbf_PhysicalRecordCount(Instance: Pointer): Variant;
    function Dbf_RecNo(Instance: TObject; var Params: Variant): Variant;
    function Dbf_RecordCount(Instance: Pointer): Variant;
    function Dbf_RegenerateIndexes(Instance: TObject; var Params: Variant
      ): Variant;
    function Dbf_RepageIndexFile(Instance: TObject; var Params: Variant
      ): Variant;
    function Dbf_RestructureTable(Instance: TObject; var Params: Variant
      ): Variant;
    function Dbf_SearchKey(Instance: TObject; var Params: Variant): Variant;
    function Dbf_SetRange(Instance: TObject; var Params: Variant): Variant;
    procedure Dbf_Set_LanguageID(Instance: Pointer; AValue: Variant);
    function Dbf_TryExclusive(Instance: TObject; var Params: Variant): Variant;
    function Dbf_Undelete(Instance: TObject; var Params: Variant): Variant;
    function Dbf_UnlockTable(Instance: TObject; var Params: Variant): Variant;
    function Dbf_UpdateIndexDefs(Instance: TObject; var Params: Variant
      ): Variant;
    procedure DisableResyncOnPostSet(Instance: Pointer; AValue: Variant);
    function MemDataSet_Clear(Instance: TObject; var Params: Variant): Variant;
    function MemDataSet_CopyFromDataset(Instance: TObject; var Params: Variant
      ): Variant;
    function MemDataSet_CreateTable(Instance: TObject; var Params: Variant
      ): Variant;
    function MemDataSet_DataSize(Instance: TObject; var Params: Variant
      ): Variant;
    function MemDataSet_GetFileModified(Instance: Pointer): Variant;
    function MemDataSet_LoadFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function MemDataSet_LoadFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function MemDataSet_SaveToFile(Instance: TObject; var Params: Variant
      ): Variant;
    function MemDataSet_SaveToStream(Instance: TObject; var Params: Variant
      ): Variant;
    function xDBFIndexDefs_Add(Instance: TObject; var Params: Variant): Variant;
    function xDBFIndexDefs_Create(Instance: TObject; var Params: Variant
      ): Variant;
    function xDBFIndexDefs_GetIndexByField(Instance: TObject;
      var Params: Variant): Variant;
    function xDBFIndexDefs_GetIndexByName(Instance: TObject; var Params: Variant
      ): Variant;
    function xDBFIndexDefs_ItemsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function xDBFIndexDefs_ItemsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function xDBFIndexDefs_Update(Instance: TObject; var Params: Variant
      ): Variant;
    function FixedFormatDataSet_DefaultRecordLengthGet(Instance: Pointer
      ): Variant;
    procedure FixedFormatDataSet_DefaultRecordLengthSet(Instance: Pointer;
      AValue: Variant);
    function FixedFormatDataSet_LoadFromStream(Instance: TObject;
      var Params: Variant): Variant;
    function FixedFormatDataSet_RemoveBlankRecords(Instance: TObject;
      var Params: Variant): Variant;
    function FixedFormatDataSet_RemoveExtraColumns(Instance: TObject;
      var Params: Variant): Variant;
    function FixedFormatDataSet_SaveFileAs(Instance: TObject;
      var Params: Variant): Variant;
    function FixedFormatDataSet_SavetoStream(Instance: TObject;
      var Params: Variant): Variant;
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure AddMethods(AddMethod: TAddMethodProc); override;
    procedure AddConsts(AddConst: TAddConstProc); override;
  published
    function DbfLangualeID_Get(Instance: Pointer): Variant;
    procedure DbfLangualeID_Set(Instance: Pointer; AValue: Variant);
    function DbfLangualeStr_Get(Instance: Pointer): Variant;

    function DbfGlobals_DefaultOpenCodePage_Get(Instence: Pointer): Variant;
    procedure DbfGlobals_DefaultOpenCodePage_Set(Instence: Pointer; AValue: Variant);
    function DbfGlobals_DefaultCreateCodePage_Get(Instence: Pointer): Variant;
    procedure DbfGlobals_DefaultCreateCodePage_Set(Instence: Pointer; AValue: Variant);
    function DbfGlobals_DefaultCreateLangId_Get(Instence: Pointer): Variant;
    procedure DbfGlobals_DefaultCreateLangId_Set(Instence: Pointer; AValue: Variant);
    function Call_DBFGlobals(Instence: TObject; var Params: Variant): Variant;
    function Call_dbfLangIDToCodePage(Instence: TObject; var Params: Variant): Variant;

  end;

implementation

uses xdbf_dbffile, dpUtils, xdbf, xdbf_fields, db, xdbf_common, xdbf_idxfile,
  BufDataset, SdfData, FileUtil, xdbf_lang, memds;

function TDataAccImport.BufDataSet_CreateDataset(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBufDataset(Instance).CreateDataset;
end;

function TDataAccImport.BufDataSet_LoadFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBufDataset(Instance).LoadFromFile(Params[0], Params[1]);
end;

function TDataAccImport.BufDataSet_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBufDataset(Instance).LoadFromStream(TStream( TSuPtr(Params[0])), Params[1]);
end;

function TDataAccImport.BufDataSet_SaveToFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBufDataset(Instance).SaveToFile(Params[0], Params[1]);
end;

function TDataAccImport.BufDataSet_SaveToStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBufDataset(Instance).SaveToStream(TStream(TSuPtr(Params[0])), Params[1]);
end;

function TDataAccImport.DbfFieldDefs_Add(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TDbfFieldDefs(Instance).Add(Params[0], Params[1], Params[2], Params[3]);
end;

function TDataAccImport.DbfFieldDefs_AddFieldDef(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TDbfFieldDefs(Instance).AddFieldDef );
end;

function TDataAccImport.DbfFieldDefs_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TDbfFieldDefs.Create(TPersistent(TSuPtr(Params[0]))) );
end;

function TDataAccImport.DbfFieldDefs_Items(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TDbfFieldDefs(Instance).Items[Params[0]]);
end;

function TDataAccImport.Dbf_AbsolutePath(Instance: Pointer): Variant;
begin
  Result := TxDbf(Instance).AbsolutePath;
end;

type
  PIndexOptions = ^TIndexOptions;

function TDataAccImport.Dbf_AddIndex(Instance: TObject; var Params: Variant
  ): Variant;
var
  Opt: PIndexOptions;
begin
  Opt := PIndexOptions(TSuPtr(Params[2]));
  TxDbf(Instance).AddIndex(Params[0], Params[1], Opt^, Params[3]);
end;

function TDataAccImport.Dbf_CancelRange(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).CancelRange;
end;

function TDataAccImport.Dbf_CheckMasterRange(Instance: TObject;
  var Params: Variant): Variant;
begin
  TxDbf(Instance).CheckMasterRange;
end;

function TDataAccImport.Dbf_CloseIndexFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TxDbf(Instance).CloseIndexFile(Params[0]);
end;

function TDataAccImport.Dbf_CodePage(Instance: Pointer): Variant;
begin
  Result := TxDbf(Instance).CodePage;
end;

function TDataAccImport.Dbf_CompactIndexFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TxDbf(Instance).CompactIndexFile(Params[0]);
end;

function TDataAccImport.Dbf_CopyFrom(Instance: TObject; var Params: Variant
  ): Variant;
var
  D: TDataSet;
begin
  D := TDataSet(TSuPtr(Params[0]));
  TxDbf(Instance).CopyFrom(D, Params[1], Params[2], Params[3]);
end;

function TDataAccImport.Dbf_CreateTable(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).CreateTable;
end;

function TDataAccImport.Dbf_CreateTableEx(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).CreateTableEx(TDbfFieldDefs(TSuPtr(Params[0])));
end;

function TDataAccImport.Dbf_DbfFieldDefs(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TxDbf(Instance).DbfFieldDefs )
end;

function TDataAccImport.Dbf_DeleteIndex(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).DeleteIndex(Params[0]);
end;

function TDataAccImport.Dbf_DisableResyncOnPostGet(Instance: Pointer): Variant;
begin
  Result := TxDbf(Instance).DisableResyncOnPost;
end;

function TDataAccImport.Dbf_EmptyTable(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).EmptyTable;
end;

function TDataAccImport.Dbf_EndExclusive(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).EndExclusive;
end;

function TDataAccImport.Dbf_ExactRecordCount(Instance: Pointer): Variant;
begin
  Result := TxDbf(Instance).ExactRecordCount;
end;

function TDataAccImport.Dbf_GetAllIndexFiles(Instance: TObject;
  var Params: Variant): Variant;
begin
  TxDbf(Instance).GetAllIndexFiles(TStrings(TSuPtr(Params[0])));
end;

type
  PDbfFileNames = ^TDbfFileNames;

function TDataAccImport.Dbf_GetFileNames(Instance: TObject; var Params: Variant
  ): Variant;
var
  FNam: PDbfFileNames;
  S: TStrings;
begin
  S := TStrings(TSuPtr(Params[0]));
  FNam := PDbfFileNames(TSuPtr(Params[1]));
  TxDbf(Instance).GetFileNames(S, FNam^);
end;

function TDataAccImport.Dbf_GetIndexNames(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).GetIndexNames(TStrings(TSuPtr(Params[0])));
end;

function TDataAccImport.Dbf_Get_LanguageID(Instance: Pointer): Variant;
begin
  Result := TxDbf(Instance).LanguageID;
end;

function TDataAccImport.Dbf_IsDeleted(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TxDbf(Instance).IsDeleted;
end;

function TDataAccImport.Dbf_KeySize(Instance: Pointer): Variant;
begin
  Result := TxDbf(Instance).KeySize;
end;

function TDataAccImport.Dbf_LanguageStr(Instance: Pointer): Variant;
begin
  Result := TxDbf(Instance).LanguageStr;
end;

function TDataAccImport.Dbf_LockTable(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TxDbf(Instance).LockTable(Params[0]);
end;

function TDataAccImport.Dbf_OpenIndexFile(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).OpenIndexFile(Params[0]);
end;

function TDataAccImport.Dbf_PackTable(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).PackTable;
end;

function TDataAccImport.Dbf_PhysicalRecNoGet(Instance: Pointer): Variant;
begin
  Result := TxDbf(Instance).PhysicalRecNo;
end;

procedure TDataAccImport.Dbf_PhysicalRecNoSet(Instance: Pointer; AValue: Variant
  );
begin
  TxDbf(Instance).PhysicalRecNo := AValue;
end;

function TDataAccImport.Dbf_PhysicalRecordCount(Instance: Pointer): Variant;
begin
  Result := TxDbf(Instance).PhysicalRecordCount;
end;

function TDataAccImport.Dbf_RecNo(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TxDbf(Instance).RecNo;
end;

function TDataAccImport.Dbf_RecordCount(Instance: Pointer): Variant;
begin
  Result := TxDbf(Instance).RecordCount;
end;

function TDataAccImport.Dbf_RegenerateIndexes(Instance: TObject;
  var Params: Variant): Variant;
begin
  TxDbf(Instance).RegenerateIndexes;
end;

function TDataAccImport.Dbf_RepageIndexFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TxDbf(Instance).RepageIndexFile(Params[0]);
end;

function TDataAccImport.Dbf_RestructureTable(Instance: TObject;
  var Params: Variant): Variant;
begin
  TxDbf(Instance).RestructureTable(TDbfFieldDefs(TSuPtr(Params[0])), Params[1]);
end;

function TDataAccImport.Dbf_SearchKey(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).SearchKey(Params[0], Params[1], Params[2]);
end;

function TDataAccImport.Dbf_SetRange(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).SetRange(Params[0], Params[1], Params[2]);
end;

procedure TDataAccImport.Dbf_Set_LanguageID(Instance: Pointer; AValue: Variant);
begin
  TxDbf(Instance).LanguageID := AValue;
end;

function TDataAccImport.Dbf_TryExclusive(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).TryExclusive;
end;

function TDataAccImport.Dbf_Undelete(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).Undelete;
end;

function TDataAccImport.Dbf_UnlockTable(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TxDbf(Instance).UnlockTable;
end;

function TDataAccImport.Dbf_UpdateIndexDefs(Instance: TObject;
  var Params: Variant): Variant;
begin
  TxDbf(Instance).UpdateIndexDefs;
end;

procedure TDataAccImport.DisableResyncOnPostSet(Instance: Pointer;
  AValue: Variant);
begin
  TxDbf(Instance).DisableResyncOnPost := AValue;
end;

function TDataAccImport.MemDataSet_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TMemDataset(Instance).Clear(Params[0]);
end;

function TDataAccImport.MemDataSet_CopyFromDataset(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMemDataset(Instance).CopyFromDataset(TDataSet(TSuPtr(Params[0])), Params[1]);
end;

function TDataAccImport.MemDataSet_CreateTable(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMemDataset(Instance).CreateTable;
end;

function TDataAccImport.MemDataSet_DataSize(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TMemDataset(Instance).DataSize;
end;

function TDataAccImport.MemDataSet_GetFileModified(Instance: Pointer): Variant;
begin
  Result := TMemDataset(Instance).FileModified;
end;

function TDataAccImport.MemDataSet_LoadFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMemDataset(Instance).LoadFromFile(Params[0]);
end;

function TDataAccImport.MemDataSet_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMemDataset(Instance).LoadFromStream(TStream( TSuPtr(Params[0]) ));
end;

function TDataAccImport.MemDataSet_SaveToFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMemDataset(Instance).SaveToFile(Params[0], Params[1]);
end;

function TDataAccImport.MemDataSet_SaveToStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TMemDataset(Instance).SaveToStream(TStream( TSuPtr( Params[0])), Params[1]);
end;

function TDataAccImport.xDBFIndexDefs_Add(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TDbfIndexDefs(Instance).Add);
end;

function TDataAccImport.xDBFIndexDefs_Create(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr(TDbfIndexDefs.Create(TxDbf(TSuPtr(Params[0]))));
end;

function TDataAccImport.xDBFIndexDefs_GetIndexByField(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TDbfIndexDefs(Instance).GetIndexByField(Params[0]) );
end;

function TDataAccImport.xDBFIndexDefs_GetIndexByName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TDbfIndexDefs(Instance).GetIndexByName(Params[0]) );
end;

function TDataAccImport.xDBFIndexDefs_ItemsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TDbfIndexDefs(Instance).Items[Params[0]] );
end;

function TDataAccImport.xDBFIndexDefs_ItemsSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TDbfIndexDefs(Instance).Items[Params[0]] := TDbfIndexDef(TSuPtr(Params[1]));
end;

function TDataAccImport.xDBFIndexDefs_Update(Instance: TObject;
  var Params: Variant): Variant;
begin
  TDbfIndexDefs(Instance).Update;
end;

function TDataAccImport.FixedFormatDataSet_DefaultRecordLengthGet(
  Instance: Pointer): Variant;
begin
  Result := TFixedFormatDataSet(Instance).DefaultRecordLength;
end;

procedure TDataAccImport.FixedFormatDataSet_DefaultRecordLengthSet(
  Instance: Pointer; AValue: Variant);
begin
  TFixedFormatDataSet(Instance).DefaultRecordLength := AValue;
end;

function TDataAccImport.FixedFormatDataSet_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFixedFormatDataSet(Instance).LoadFromStream(TStream( TSuPtr(Params[0]) ));
end;

function TDataAccImport.FixedFormatDataSet_RemoveBlankRecords(
  Instance: TObject; var Params: Variant): Variant;
begin
  TFixedFormatDataSet(Instance).RemoveBlankRecords;
end;

function TDataAccImport.FixedFormatDataSet_RemoveExtraColumns(
  Instance: TObject; var Params: Variant): Variant;
begin
  TFixedFormatDataSet(Instance).RemoveExtraColumns;
end;

function TDataAccImport.FixedFormatDataSet_SaveFileAs(Instance: TObject;
  var Params: Variant): Variant;
var
  StrFileName: string;
begin
  StrFileName := Params[0];
  TFixedFormatDataSet(Instance).SaveFileAs(StrFileName);
end;

function TDataAccImport.FixedFormatDataSet_SavetoStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TFixedFormatDataSet(Instance).SavetoStream( TStream( TSuPtr(Params[0]) ) );
end;

procedure TDataAccImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TDbfFileName));
  AddType(TypeInfo(TDbfFileNames));
  AddType(TypeInfo(TDbfLanguageAction));
  AddType(TypeInfo(TDbfOpenMode));
  AddType(TypeInfo(TDbfStorage));
  AddType(TypeInfo(TDbfTranslationMode));
  AddType(TypeInfo(TSearchKeyType));
  //BufDataSet
  AddType(TypeInfo(TDataPacketFormat));
end;

procedure TDataAccImport.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
begin
  AddClass(TBufDataset).ClassImporter := Self;
  AddClass(TDbfIndexDefs).ClassImporter := Self;
  AddClass(TDbfFieldDefs).ClassImporter := Self;
  AddClass(TDbfGlobals).ClassImporter := Self;
  AddClass(TxDbf).ClassImporter := Self;
  AddClass(TDbfIndexDef);
  AddClass(TDbfFieldDef);
  AddClass(TFixedFormatDataSet).ClassImporter := Self;
  AddClass(TSdfDataSet);
  AddClass(TMemDataset).ClassImporter := Self;
end;

procedure TDataAccImport.AddMethods(AddMethod: TAddMethodProc);
begin
  AddMethod('function DBFGlobals: TDbfGlobals', @Call_DBFGlobals);
  AddMethod('function dbfLangIDToCodePage(LangID: Cardinal): Cardinal', @Call_dbfLangIDToCodePage);
end;

procedure TDataAccImport.AddConsts(AddConst: TAddConstProc);
begin
  AddConst('FoxLangId_Russia_866', 'Integer', FoxLangId_Russia_866);
  AddConst('FoxLangId_Russia_1251', 'Integer', FoxLangId_Russia_1251);
end;

procedure TDataAccImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TxDbf then
  begin
    AType.AddProp('RecordCount', 'Integer', @Dbf_RecordCount);
    AType.AddProp('LanguageID', 'Byte', @Dbf_Get_LanguageID, @Dbf_Set_LanguageID);
    AType.AddProp('LanguageStr', 'string', @Dbf_LanguageStr);

    AType.AddProp('AbsolutePath', 'string', @Dbf_AbsolutePath);
    AType.AddProp('DbfFieldDefs', 'TDbfFieldDefs', @Dbf_DbfFieldDefs);
    AType.AddProp('PhysicalRecNo', 'Integer', @Dbf_PhysicalRecNoGet, @Dbf_PhysicalRecNoSet);
    AType.AddProp('CodePage', 'Cardinal', @Dbf_CodePage);
    AType.AddProp('ExactRecordCount', 'Integer', @Dbf_ExactRecordCount);
    AType.AddProp('PhysicalRecordCount', 'Integer', @Dbf_PhysicalRecordCount);
    AType.AddProp('KeySize', 'Integer', @Dbf_KeySize);
    AType.AddProp('DisableResyncOnPost', 'Boolean', @Dbf_DisableResyncOnPostGet, @DisableResyncOnPostSet);

    AType.AddMethod('procedure CreateTable', @Dbf_CreateTable);
    AType.AddMethod('procedure CreateTableEx(ADbfFieldDefs: TDbfFieldDefs)', @Dbf_CreateTableEx);
    AType.AddMethod('function RecNo: Integer', @Dbf_RecNo);
    AType.AddMethod('procedure CopyFrom(DataSet: TDataSet; FileName: string; DateTimeAsString: Boolean; Level: Integer)', @Dbf_CopyFrom);
    AType.AddMethod('function SearchKey(Key: Variant; SearchType: TSearchKeyType; KeyIsANSI: boolean = false): Boolean', @Dbf_SearchKey);
    AType.AddMethod('procedure SetRange(LowRange: Variant; HighRange: Variant; KeyIsANSI: boolean = false)', @Dbf_SetRange);
    AType.AddMethod('procedure GetIndexNames(Strings: TStrings)', @Dbf_GetIndexNames);
    AType.AddMethod('procedure GetAllIndexFiles(Strings: TStrings)', @Dbf_GetAllIndexFiles);
    AType.AddMethod('procedure OpenIndexFile(IndexFile: string)', @Dbf_OpenIndexFile);
    AType.AddMethod('procedure DeleteIndex(const AIndexName: string)', @Dbf_DeleteIndex);
    AType.AddMethod('procedure CloseIndexFile(const AIndexName: string)', @Dbf_CloseIndexFile);
    AType.AddMethod('procedure RepageIndexFile(const AIndexFile: string)', @Dbf_RepageIndexFile);
    AType.AddMethod('procedure CompactIndexFile(const AIndexFile: string)', @Dbf_CompactIndexFile);
    AType.AddMethod('procedure AddIndex(const AIndexName, AFields: String; Options: TIndexOptions; const DescFields: String='''')', @Dbf_AddIndex);
    AType.AddMethod('function  IsDeleted: Boolean', @Dbf_IsDeleted);
    AType.AddMethod('procedure Undelete', @Dbf_Undelete);
    AType.AddMethod('procedure PackTable', @Dbf_PackTable);
    AType.AddMethod('procedure EmptyTable', @Dbf_EmptyTable);

    AType.AddMethod('procedure RegenerateIndexes', @Dbf_RegenerateIndexes);
    AType.AddMethod('procedure CancelRange', @Dbf_CancelRange);
    AType.AddMethod('procedure CheckMasterRange', @Dbf_CheckMasterRange);
    AType.AddMethod('procedure UpdateIndexDefs', @Dbf_UpdateIndexDefs);
    AType.AddMethod('procedure GetFileNames(Strings: TStrings; Files: TDbfFileNames)', @Dbf_GetFileNames);
    AType.AddMethod('procedure TryExclusive', @Dbf_TryExclusive);
    AType.AddMethod('procedure EndExclusive', @Dbf_EndExclusive);
    AType.AddMethod('function  LockTable(const Wait: Boolean): Boolean', @Dbf_LockTable);
    AType.AddMethod('procedure UnlockTable', @Dbf_UnlockTable);
    AType.AddMethod('procedure RestructureTable(ADbfFieldDefs: TDbfFieldDefs; Pack: Boolean)', @Dbf_RestructureTable);
  end
  else
  if AType.ValueClassType = TDbfGlobals then
  begin
    AType.AddProp('DefaultOpenCodePage', 'Integer', @DbfGlobals_DefaultOpenCodePage_Get, @DbfGlobals_DefaultOpenCodePage_Set);
    AType.AddProp('DefaultCreateCodePage', 'Integer', @DbfGlobals_DefaultCreateCodePage_Get, @DbfGlobals_DefaultCreateCodePage_Set);
    AType.AddProp('DefaultCreateLangId', 'Byte', @DbfGlobals_DefaultCreateLangId_Get, @DbfGlobals_DefaultCreateLangId_Set);
  end
  else
  if AType.ValueClassType = TDbfFieldDefs then
  begin
    AType.AddMethod('function AddFieldDef: TDbfFieldDef', @DbfFieldDefs_AddFieldDef);
    AType.AddIndexedProp('Items', 'TDbfFieldDef', 'Integer', @DbfFieldDefs_Items);
    AType.AddMethod('constructor Create(Owner: TPersistent)', @DbfFieldDefs_Create);
    AType.AddMethod('procedure Add(const Name: string; DataType: TFieldType; Size: Integer = 0; Required: Boolean = False)', @DbfFieldDefs_Add);
  end
  else
  if AType.ValueClassType = TDbfIndexDefs then
  begin
    AType.AddMethod('constructor Create(AOwner: TxDbf)', @xDBFIndexDefs_Create);
    AType.AddMethod('function  Add: TDbfIndexDef', @xDBFIndexDefs_Add);
    AType.AddMethod('function  GetIndexByName(const Name: string): TDbfIndexDef', @xDBFIndexDefs_GetIndexByName);
    AType.AddMethod('function  GetIndexByField(const Name: string): TDbfIndexDef', @xDBFIndexDefs_GetIndexByField);
    AType.AddMethod('procedure Update', @xDBFIndexDefs_Update);
    AType.AddIndexedProp('Items', 'TDbfIndexDef', 'Integer', @xDBFIndexDefs_ItemsGet, @xDBFIndexDefs_ItemsSet);
  end
  else
  if AType.ValueClassType = TBufDataset then
  begin
    AType.AddMethod('procedure CreateDataset', @BufDataSet_CreateDataset);
    AType.AddMethod('procedure LoadFromStream(AStream : TStream; Format: TDataPacketFormat = dfAny)', @BufDataSet_LoadFromStream);
    AType.AddMethod('procedure SaveToStream(AStream : TStream; Format: TDataPacketFormat = dfBinary)', @BufDataSet_SaveToStream);
    AType.AddMethod('procedure LoadFromFile(AFileName: string = ''; Format: TDataPacketFormat = dfAny)', @BufDataSet_LoadFromFile);
    AType.AddMethod('procedure SaveToFile(AFileName: string = ''; Format: TDataPacketFormat = dfBinary)', @BufDataSet_SaveToFile);
    //AType.AddMethod('', @BufDataSet_);

  end
  else
  if AType.ValueClassType = TFixedFormatDataSet then
  begin
    AType.AddMethod('procedure RemoveBlankRecords', @FixedFormatDataSet_RemoveBlankRecords);
    AType.AddMethod('procedure RemoveExtraColumns', @FixedFormatDataSet_RemoveExtraColumns);
    AType.AddMethod('procedure SaveFileAs(strFileName : String)', @FixedFormatDataSet_SaveFileAs);
    AType.AddMethod('procedure LoadFromStream(Stream :TStream)', @FixedFormatDataSet_LoadFromStream);
    AType.AddMethod('procedure SavetoStream(Stream :TStream)', @FixedFormatDataSet_SavetoStream);
    AType.AddProp('DefaultRecordLength', 'Cardinal', @FixedFormatDataSet_DefaultRecordLengthGet, @FixedFormatDataSet_DefaultRecordLengthSet);
  end
  else
  if AType.ValueClassType = TMemDataset then
  begin
    AType.AddMethod('procedure CreateTable', @MemDataSet_CreateTable);
    AType.AddMethod('function DataSize: Integer', @MemDataSet_DataSize);
    AType.AddMethod('procedure Clear(ClearDefs : Boolean)', @MemDataSet_Clear);
    AType.AddMethod('procedure SaveToFile(AFileName : String; SaveData : Boolean)', @MemDataSet_SaveToFile);
    AType.AddMethod('procedure SaveToStream(F : TStream; SaveData : Boolean)', @MemDataSet_SaveToStream);
    AType.AddMethod('procedure LoadFromStream(F : TStream)', @MemDataSet_LoadFromStream);
    AType.AddMethod('procedure LoadFromFile(AFileName : String)', @MemDataSet_LoadFromFile);
    AType.AddMethod('procedure CopyFromDataset(DataSet : TDataSet; CopyData : Boolean)', @MemDataSet_CopyFromDataset);
    AType.AddProp('FileModified', 'Boolean', @MemDataSet_GetFileModified);
  end;
end;

function TDataAccImport.DbfLangualeID_Get(Instance: Pointer): Variant;
begin
  Result := TxDBF(Instance).LanguageID;
end;

procedure TDataAccImport.DbfLangualeID_Set(Instance: Pointer; AValue: Variant);
begin
  TxDBF(Instance).LanguageID := AValue;
end;

function TDataAccImport.DbfLangualeStr_Get(Instance: Pointer): Variant;
begin
  Result := TxDBF(Instance).LanguageStr;
end;

function TDataAccImport.DbfGlobals_DefaultOpenCodePage_Get(Instence: Pointer): Variant;
begin
  Result := TDbfGlobals(Instence).DefaultOpenCodePage;
end;

procedure TDataAccImport.DbfGlobals_DefaultOpenCodePage_Set(Instence: Pointer; AValue: Variant);
begin
  TDbfGlobals(Instence).DefaultOpenCodePage := AValue;
end;

function TDataAccImport.DbfGlobals_DefaultCreateCodePage_Get(Instence: Pointer): Variant;
begin
  Result := TDbfGlobals(Instence).DefaultCreateCodePage;
end;

procedure TDataAccImport.DbfGlobals_DefaultCreateCodePage_Set(Instence: Pointer; AValue: Variant);
begin
  TDbfGlobals(Instence).DefaultCreateCodePage := AValue;
end;

function TDataAccImport.DbfGlobals_DefaultCreateLangId_Get(Instence: Pointer): Variant;
begin
  Result := TDbfGlobals(Instence).DefaultCreateLangId;
end;

procedure TDataAccImport.DbfGlobals_DefaultCreateLangId_Set(Instence: Pointer; AValue: Variant);
begin
  TDbfGlobals(Instence).DefaultCreateLangId := AValue
end;

function TDataAccImport.Call_DBFGlobals(Instence: TObject; var Params: Variant): Variant;
begin
  Result := TSuPtr(DbfGlobals);
end;

function TDataAccImport.Call_dbfLangIDToCodePage(Instence: TObject;
  var Params: Variant): Variant;
var
  L: Byte;
begin
  Result := 0;
  L := Params[0];
  Result := LangId_To_CodePage[L];
end;

end.

