#!/bin/bash

function smb_mount_archive()(
  function show_greetings(){
    echo " ";
    echo " Utility to mount archive, usual set of remote directories.";
    echo " Copyright (c) 2019-2025 Alexey Kuryakin kouriakine@mail.ru";
    echo " Version: 20250115";
    echo " ";
    echo "Hello, $(whoami).";
    echo "Detected $(lsb_release -is).";
    echo " ";
  };
  function show_title(){
    echo " ";
    echo " $*";
    echo " ";
  };
  function init_variables(){
    umount="0";
    for arg in $*; do if [ "$arg" = "-u" ]; then umount="1"; fi; done;
    for arg in $*; do if [ "$arg" = "--umount" ]; then umount="1"; fi; done;
  };
  function install_cifs_utils() {
    if [ -z "$(which cifscreds)" ]; then sudo aptitude install cifs-utils; fi;
    if [ -n "$(which cifscreds)" ]; then echo "OK, cifs-utils installed"; fi;
  };
  function skip(){
    return;
  };
  function call(){
   $*;
  };
  function execute(){
   echo "$*";
   call  $* ;
  };
  function do_smb_mount(){
    local server="$1"; shift;
    local domain="$1"; shift;
    local person="$1"; shift;
    local passwd="$(echo $1 | base64 -d)"; shift;
    local folder="$1"; shift;
    local rights="$1"; shift;
    local usr_id="$1"; shift;
    local grp_id="$1"; shift;
    local target="/mnt/smb/$server/$folder";
    if [ "$folder" == "." ]; then target="/mnt/smb/$server"; fi;
    execute sudo mkdir -p $target;
    execute sudo chmod $rights $target;
    execute sudo chown root:root $target;
    execute sudo chown $usr_id:$grp_id $target;
    for dir in $*; do
      execute sudo umount $target/$dir;
      if [ "$umount" == "1" ]; then continue; fi;
      execute sudo mkdir -p $target/$dir;
      execute sudo chown $usr_id:$grp_id $target/$dir;
      local mounting="sudo mount -t cifs //$server/$dir $target/$dir -o iocharset=utf8,vers=1.0,uid=$usr_id,gid=$grp_id,rw,domain=$domain,username=$person,password";
      echo "$mounting=******"; 
            $mounting=$passwd;
    done;
  };
  show_greetings;
  init_variables $*;
  install_cifs_utils;
  show_title "STORAGE...";
  do_smb_mount storage storage main d3d3LmNydy1kYXEucnUK main 777 alex users    alex biana david masha tanya nadya fedor yana milana photos postbox internet scratch crw-daq archive;
  do_smb_mount storage storage boss d3d3LmNydy1kYXEucnUK root 600 root root     Volume_1 Volume_2 Volume_3 Volume_4;
  show_title "DATABOX...";
  do_smb_mount databox databox main d3d3LmNydy1kYXEucnUK main 777 alex users    cartoon movie music distributions repository;
  do_smb_mount databox databox boss d3d3LmNydy1kYXEucnUK root 600 root root     Volume_1 Volume_2 Volume_3 Volume_4;
  show_title "DATANAS...";
  do_smb_mount datanas datanas main d3d3LmNydy1kYXEucnUK main 777 alex users    alex biana david masha tanya nadya fedor yana milana photos postbox internet scratch crw-daq archive;
  do_smb_mount datanas datanas main d3d3LmNydy1kYXEucnUK main 777 alex users    cartoon movie music distributions repository;
  do_smb_mount datanas datanas boss d3d3LmNydy1kYXEucnUK root 600 root root     Volume_1 Volume_2 Volume_3 Volume_4;
  show_title "ARCHIVE...";
  do_smb_mount archive archive main d3d3LmNydy1kYXEucnUK main 777 alex users    mailbox shareddocs scanner-inbox crwbox scratch internet;
  do_smb_mount archive archive boss d3d3LmNydy1kYXEucnUK root 600 root root     mailbox shareddocs scanner-inbox crwbox scratch internet;
  show_title "Done";
);
smb_mount_archive $*;
