////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Tab Window Format Dialog.                                             //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231118 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_tabwindowformatdialog; // Form TabWindow Format Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, Spin,
 ColorBox, lcltype, lclintf,
 Form_CrwDaqSysChild, Form_TabWindow,
 _crw_alloc, _crw_str, _crw_eldraw,
 _crw_appforms, _crw_apptools, _crw_apputils;

type

  { TFormTabWindowFormatDialog }

  TFormTabWindowFormatDialog = class(TMasterForm)
    PanelFormat: TPanel;
    LabelWidth: TLabel;
    SpinEditWidth: TSpinEdit;
    LabelDigit: TLabel;
    SpinEditDigit: TSpinEdit;
    RadioGroupColor: TRadioGroup;
    PanelButtons: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    ButtonApply: TButton;
    ButtonResetFont: TButton;
    ButtonResetColors: TButton;
    RadioGroupFmtCh: TRadioGroup;
    ColorBox: TColorBox;
    procedure ColorBoxChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonApplyClick(Sender: TObject);
    procedure ButtonResetFontClick(Sender: TObject);
    procedure ButtonResetColorsClick(Sender: TObject);
    procedure RadioGroupColorSelectionChanged(Sender: TObject);
  private
    { Private declarations }
    myTabWin : TFormTabWindow;
    function ActualTabWindow:TFormTabWindow;
  public
    { Public declarations }
    procedure ColorBoxUpdate;
    procedure Apply(Form:TFormTabWindow);
  end;

function FormTabWindowFormatDialogExecute(Form:TFormTabWindow):Integer;

implementation

{$R *.lfm}

const
 FormTabWindowFormatDialog : TFormTabWindowFormatDialog = nil;

procedure TFormTabWindowFormatDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('Параметры окна таблицы','Table window options');
 SmartUpdate(LabelWidth,RusEng('Ширина числового поля','Width of numeral'));
 SmartUpdate(LabelDigit,RusEng('Точность, значащих цифр','Precision, decimals'));
 SmartUpdate(RadioGroupColor,RusEng('Цвет','Color'));
 RadioGroupColor.Items.Text:=RusEng('Цвет фона Имен'+EOL+
                                    'Цвет фона Значений'+EOL+
                                    'Цвет Текста',
                                    'Ground of Names'+EOL+
                                    'Ground of Values'+EOL+
                                    'Color of Text');
 RadioGroupFmtCh.Caption:=RusEng('Формат вещественных чисел','Float data format');
 RadioGroupFmtCh.Items.Text:=RusEng('f - фиксированный, как 123.45'+EOL+
                                    'g - генеральный = адаптивный'+EOL+
                                    'e - экспонента, как 1.2345E+002',
                                    'f - fixed point, like 123.45'+EOL+
                                    'g - general format, adaptive'+EOL+
                                    'e - exponent, like 1.2345E+02');
 ButtonResetColors.Caption:=RusEng('Сброс Цветов','Reset Colors');
 ButtonResetFont.Caption:=RusEng('Сброс Шрифта','Reset Font');
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
 SmartUpdate(ButtonApply,RusEng('Принять','Apply'));
 ColorBox.Selected:=clBtnFace;
 RadioGroupColor.ItemIndex:=1;
 RadioGroupFmtCh.ItemIndex:=0;
 ColorBoxUpdate;
end;

function TFormTabWindowFormatDialog.ActualTabWindow:TFormTabWindow;
begin
 Result:=nil;
 if Assigned(Self) then
 if FormExists(myTabWin) then Result:=myTabWin;
end;

procedure TFormTabWindowFormatDialog.Apply(Form:TFormTabWindow);
begin
 if Ok then
 try
  if (Form is TFormTabWindow) then begin
   Form.LockDraw;
   try
    Form.LedWidth:=SpinEditWidth.Value;
    Form.LedDigit:=SpinEditDigit.Value;
    Form.LedFmtCh:=StrFetch('fge',RadioGroupFmtCh.ItemIndex+1);
    Form.ShouldResize;
    Form.UpdateSize;
   finally
    Form.UnlockDraw;
   end;
  end;
 except
  on E:Exception do BugReport(E,Self,'Apply');
 end;
end;

function FormTabWindowFormatDialogExecute(Form:TFormTabWindow):Integer;
var
 SaveGridColor,SaveFixedColor,SaveTextColor:TColor; SaveFormFont:TFontParams;
 SaveLedWidth,SaveLedDigit:Integer; SaveLedFmtCh:Char;
begin
 Result:=mrCancel;
 if CanShowModal(FormTabWindowFormatDialog) then
 try
  if (Form is TFormTabWindow) then begin
   if not Assigned(FormTabWindowFormatDialog) then begin
    Application.CreateForm(TFormTabWindowFormatDialog, FormTabWindowFormatDialog);
    FormTabWindowFormatDialog.Master:=@FormTabWindowFormatDialog;
   end;
   if Assigned(FormTabWindowFormatDialog) then begin
    SaveFixedColor:=Form.StringGridItems.FixedColor;
    SaveGridColor:=Form.StringGridItems.Color;
    SaveFont(Form.Font,SaveFormFont);
    SaveTextColor:=Form.Font.Color;
    SaveLedWidth:=Form.LedWidth;
    SaveLedDigit:=Form.LedDigit;
    SaveLedFmtCh:=Form.LedFmtCh;
    FormTabWindowFormatDialog.myTabWin:=Form;
    FormTabWindowFormatDialog.RadioGroupColor.ItemIndex:=1;
    FormTabWindowFormatDialog.ColorBox.Selected:=SaveGridColor;
    FormTabWindowFormatDialog.SpinEditWidth.Value:=Form.LedWidth;
    FormTabWindowFormatDialog.SpinEditDigit.Value:=Form.LedDigit;
    FormTabWindowFormatDialog.RadioGroupFmtCh.ItemIndex:=Pos(Form.LedFmtCh,'fge')-1;
    LocateFormToCenterOfScreen(FormTabWindowFormatDialog);
    if (mrVoice(FormTabWindowFormatDialog.ShowModal)=mrOk) then begin
     Result:=mrOk;
     FormTabWindowFormatDialog.Apply(Form);
    end else begin
     Form.LockDraw;
     try
      Form.StringGridItems.Color:=SaveGridColor;
      Form.StringGridItems.FixedColor:=SaveFixedColor;
      RestoreFont(Form.Font,SaveFormFont);
      Form.Font.Color:=SaveTextColor;
      Form.LedWidth:=SaveLedWidth;
      Form.LedDigit:=SaveLedDigit;
      Form.LedFmtCh:=SaveLedFmtCh;
      Form.ShouldResize;
      Form.UpdateSize;
     finally
      Form.UnlockDraw;
     end;
    end;
    FormTabWindowFormatDialog.myTabWin:=nil;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'FormTabWindowFormatDialogExecute');
 end;
end;


procedure TFormTabWindowFormatDialog.ColorBoxUpdate;
begin
 if Ok then
 try
  if ActualTabWindow.Ok then
  with ActualTabWindow do begin
   case RadioGroupColor.ItemIndex of
    0 : ColorBox.Selected:=StringGridItems.FixedColor;
    1 : ColorBox.Selected:=StringGridItems.Color;
    2 : ColorBox.Selected:=Font.Color;
   end;
  end;
 except
  on E:Exception do BugReport(E,Self,'ColorBoxUpdate');
 end;
end;


procedure TFormTabWindowFormatDialog.ColorBoxChange(Sender: TObject);
begin
 if Ok then
 try
  if ActualTabWindow.Ok then
  with ActualTabWindow do begin
   LockDraw;
   try
    case RadioGroupColor.ItemIndex of
     0 : StringGridItems.FixedColor:=ColorBox.Selected;
     1 : StringGridItems.Color:=ColorBox.Selected;
     2 : Font.Color:=ColorBox.Selected;
    end;
   finally
    UnlockDraw;
   end;
  end;
 except
  on E:Exception do BugReport(E,Self,'ColorBoxChange');
 end;
end;

procedure TFormTabWindowFormatDialog.ButtonApplyClick(Sender: TObject);
begin
 if Ok then
 try
  if ActualTabWindow.Ok then Apply(ActualTabWindow);
 except
  on E:Exception do BugReport(E,Self,'ButtonApplyClick');
 end;
end;

procedure TFormTabWindowFormatDialog.ButtonResetFontClick(Sender: TObject);
begin
 if Ok then
 try
  if ActualTabWindow.Ok then
  with ActualTabWindow do begin
   LockDraw;
   try
    ResetFont;
   finally
    UnlockDraw;
   end;
  end;
 except
  on E:Exception do BugReport(E,Self,'ButtonResetFontClick');
 end;
end;

procedure TFormTabWindowFormatDialog.ButtonResetColorsClick(Sender: TObject);
begin
 if Ok then
 try
  if ActualTabWindow.Ok then
  with ActualTabWindow do begin
   LockDraw;
   try
    ResetColors;
    RadioGroupColor.ItemIndex:=1;
    ColorBox.Selected:=StringGridItems.Color;
   finally
    UnlockDraw;
   end;
  end;
 except
  on E:Exception do BugReport(E,Self,'ButtonResetColorsClick');
 end;
end;

procedure TFormTabWindowFormatDialog.RadioGroupColorSelectionChanged(Sender: TObject);
begin
 ColorBoxUpdate;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_tabwindowformatdialog;
begin
end;

procedure Free_form_tabwindowformatdialog;
begin
end;

initialization

 Init_form_tabwindowformatdialog;

finalization

 Free_form_tabwindowformatdialog;

end.

//////////////
// END OF FILE
//////////////

