////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Spectr Zon Fit Roi Remove Bugs.                                       //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231205 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_spectrzonfitroiremovebugs; // Form Spectr Zon Fit Roi Remove Bugs

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, Spin,
 lcltype, lclintf, Grids, CheckLst,
 Form_SpectrZonFitWindow,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_sort, _crw_ef, _crw_ee, _crw_zm,
 _crw_curves, _crw_riff, _crw_calib,
 _crw_daqsys, _crw_daqdev,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormSpectrZonFitRoiRemoveBugs = class(TMasterForm)
    GroupBox1: TGroupBox;
    CheckListBox1: TCheckListBox;
    Label1: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    GroupBox2: TGroupBox;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    CheckListBox2: TCheckListBox;
    Label5: TLabel;
    RadioGroup1: TRadioGroup;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    GroupBox3: TGroupBox;
    CheckListBox3: TCheckListBox;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function FormSpectrZonFitRoiRemoveBugsExecute(var Data:TRoiBugsData; Roi:Boolean=true):Integer;

implementation

{$R *.lfm}

procedure SetHeight(Component:TComponent; Index:Integer; var Terminate:Boolean; Custom:Pointer);
begin
 if Component is TEdit then (Component as TEdit).Height:=16;
end;

function FormSpectrZonFitRoiRemoveBugsExecute(var Data:TRoiBugsData; Roi:Boolean=true):Integer;
const
 TheForm : TFormSpectrZonFitRoiRemoveBugs = nil;
var
 Save : TRoiBugsData;
begin
 Result:=mrCancel;
 if CanShowModal(TheForm) then
 try
  if not TheForm.Ok then begin
   Application.CreateForm(TFormSpectrZonFitRoiRemoveBugs, TheForm);
   TheForm.Master:=@TheForm;
  end;
  if TheForm.Ok then begin
   if Roi then TheForm.Caption:='Remove ROI bugs' else TheForm.Caption:='Remove zone bugs';
   TheForm.CheckListBox1.Enabled:=Roi;
   TheForm.Edit1.Enabled:=Roi;
   TheForm.Edit2.Enabled:=Roi;
   ForEachComponent(TheForm,SetHeight,nil);
   TheForm.CheckListBox1.Checked[0]:=HasFlags(Data.Zone.Bug,1);
   TheForm.CheckListBox1.Checked[1]:=HasFlags(Data.Zone.Bug,2);
   TheForm.CheckListBox1.Checked[2]:=HasFlags(Data.Zone.Bug,4);
   TheForm.Edit1.Text:=Format('%g',[Data.Zone.Width.Fw]);
   TheForm.Edit2.Text:=Format('%g',[Data.Zone.Width.Ch]);
   TheForm.CheckListBox2.Checked[0]:=HasFlags(Data.Peak.Bug,1);
   TheForm.CheckListBox2.Checked[1]:=HasFlags(Data.Peak.Bug,2);
   TheForm.CheckListBox2.Checked[2]:=HasFlags(Data.Peak.Bug,4);
   TheForm.CheckListBox2.Checked[3]:=HasFlags(Data.Peak.Bug,8);
   TheForm.Edit3.Text:=Format('%g',[Data.Peak.Ampl.Fw]);
   TheForm.Edit4.Text:=Format('%g',[Data.Peak.Ampl.Ch]);
   TheForm.Edit5.Text:=Format('%g',[Data.Peak.Fwhm.Fw]);
   TheForm.Edit6.Text:=Format('%g',[Data.Peak.Fwhm.Ch]);
   TheForm.Edit7.Text:=Format('%g',[Data.Peak.Dist.Fw]);
   TheForm.Edit8.Text:=Format('%g',[Data.Peak.Dist.Ch]);
   TheForm.RadioGroup1.ItemIndex:=Data.Peak.Act;
   TheForm.CheckListBox3.Checked[0]:=HasFlags(Data.Fixed,$01);
   TheForm.CheckListBox3.Checked[1]:=HasFlags(Data.Fixed,$02);
   TheForm.CheckListBox3.Checked[2]:=HasFlags(Data.Fixed,$04);
   TheForm.CheckListBox3.Checked[3]:=HasFlags(Data.Fixed,$08);
   TheForm.CheckListBox3.Checked[4]:=HasFlags(Data.Fixed,$10);
   TheForm.CheckListBox3.Checked[5]:=HasFlags(Data.Fixed,$20);
   TheForm.CheckListBox3.Checked[6]:=HasFlags(Data.Fixed,$40);
   Save:=Data;
   if (mrVoice(TheForm.ShowModal)=mrOk) then begin
    Result:=mrOk;
    Data.Zone.Bug:=ord(TheForm.CheckListBox1.Checked[0]) * 1 +
                   ord(TheForm.CheckListBox1.Checked[1]) * 2 +
                   ord(TheForm.CheckListBox1.Checked[2]) * 4;
    SmartStr2Real(TheForm.Edit1.Text,Data.Zone.Width.Fw);
    SmartStr2Real(TheForm.Edit2.Text,Data.Zone.Width.Ch);
    Data.Peak.Bug:=ord(TheForm.CheckListBox2.Checked[0]) * 1 +
                   ord(TheForm.CheckListBox2.Checked[1]) * 2 +
                   ord(TheForm.CheckListBox2.Checked[2]) * 4 +
                   ord(TheForm.CheckListBox2.Checked[3]) * 8;
    SmartStr2Real(TheForm.Edit3.Text,Data.Peak.Ampl.Fw);
    SmartStr2Real(TheForm.Edit4.Text,Data.Peak.Ampl.Ch);
    SmartStr2Real(TheForm.Edit5.Text,Data.Peak.Fwhm.Fw);
    SmartStr2Real(TheForm.Edit6.Text,Data.Peak.Fwhm.Ch);
    SmartStr2Real(TheForm.Edit7.Text,Data.Peak.Dist.Fw);
    SmartStr2Real(TheForm.Edit8.Text,Data.Peak.Dist.Ch);
    Data.Peak.Act:=TheForm.RadioGroup1.ItemIndex;
    Data.Fixed:=ord(TheForm.CheckListBox3.Checked[0]) * 1 +
                ord(TheForm.CheckListBox3.Checked[1]) * 2 +
                ord(TheForm.CheckListBox3.Checked[2]) * 4 +
                ord(TheForm.CheckListBox3.Checked[3]) * 8 +
                ord(TheForm.CheckListBox3.Checked[4]) * $10 +
                ord(TheForm.CheckListBox3.Checked[5]) * $20 +
                ord(TheForm.CheckListBox3.Checked[6]) * $40;
   end else begin
    Data:=Save;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'FormSpectrZonFitRoiRemoveBugsExecute');
 end;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_spectrzonfitroiremovebugs;
begin
end;

procedure Free_form_spectrzonfitroiremovebugs;
begin
end;

initialization

 Init_form_spectrzonfitroiremovebugs;

finalization

 Free_form_spectrzonfitroiremovebugs;

end.

//////////////
// END OF FILE
//////////////

