////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// This unit containts Command Line arguments parser.                         //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231115 - Created by A.K.                                                 //
////////////////////////////////////////////////////////////////////////////////

unit unit_crwdaq_session; // Unit to initialize CRW-DAQ session.

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 {$IFDEF UNIX} Unix, BaseUnix, Linux, termio, {$ENDIF}
 sysutils, classes, strutils, math,
 Forms, Controls, Graphics, Dialogs, ExtCtrls, StdCtrls, ComCtrls, Buttons,
 Spin, Menus, FileUtil, process, lcltype,
 _crw_alloc, _crw_cmdargs, _crw_environ, _crw_zm, _crw_fifo, _crw_ascio,
 _crw_base32, _crw_base64, _crw_sort, _crw_fpu, _crw_lsqpoly, _crw_ef,
 _crw_plut, _crw_fft, _crw_fft24, _crw_delauna, _crw_guiutils, _crw_svd,
 _crw_spline, _crw_proc, _crw_rtc, _crw_dynar, _crw_simplex, _crw_hash,
 _crw_crypt, _crw_utf8, _crw_str, _crw_hl, _crw_bsencode, _crw_funmin,
 _crw_lsqmin, _crw_colors, _crw_fsm, _crw_fio, _crw_polling, _crw_meta,
 _crw_daqtags, _crw_rtdtc, _crw_couple, _crw_th123, _crw_riff, _crw_snd,
 _crw_mmt, _crw_ee, _crw_syscal, _crw_curves, _crw_daqevnt, _crw_calib,
 _crw_dim, _crw_dimq, _crw_dimc, _crw_dims, _crw_az, _crw_cgi, _crw_lmd,
 _crw_spcfld, _crw_guard, _crw_spk, _crw_pio, _crw_pkk4, _crw_i8255,
 pcrelib, perlregex, _crw_regexp, _crw_serio, _crw_wine, _crw_vbox,
 _crw_uart, _crw_eldraw, _crw_uac, _crw_sysid, _crw_lm, _crw_wmctrl,
 _crw_adodb_tlb, _crw_dbcon, _crw_opc, _crw_opcc, _crw_netif,
 _crw_smirtl, _crw_smiuirtl, _crw_pipe, _crw_tcp, _crw_pipeio,
 _crw_assoc, _crw_apputils, _crw_appforms, _crw_apptools, _crw_sever,
 _crw_sharm, _crw_task, _crw_sesman, _crw_dima, _crw_syslog,
 _crw_fonts, _crw_lttb, _crw_dbapi, _crw_crwapi, _crw_dcc32,
 Form_ListBoxSelection, Form_CheckListBoxSelection, Form_Calculator,
 Form_VoicePreset, Form_UartTerminal, Form_TextEditDialog,
 Form_StringGridEditDialog, Form_LoginDialog, Form_RecodeCodePageDialog,
 Form_RegExpCalculator;

function StartSession(arg:LongString):Boolean;

implementation

uses form_crwdaq;

function SysLogEcho(n:SizeInt; Line:LongString; Custom:Pointer):Boolean;
begin
 Result:=True;
 if (Line='') then Exit;
 SysLog.INFO(SeverityOfSysPrint,sdr_SysPrint,Line);
end;

function SysLogVoice(n:SizeInt; Line:LongString; Custom:Pointer):Boolean;
begin
 Result:=True;
 if (Line='') then Exit;
 SysLog.INFO(SeverityOfSysVoice,sdr_SysSound,Line);
end;

procedure CrwDaqSystemEcho(const Msg:LongString);
begin
 if (Msg<>'') then begin
  StdOutputFifo.PutText(Msg);
  if SysLog.Notable(SeverityOfSysPrint)
  then ForEachStringLine(Msg,SysLogEcho,nil);
 end;
end;

procedure CrwDaqBlasterLogger(const Msg:LongString);
begin
 if (Msg<>'') then begin
  DebugOutText(stdfSound,Msg);
  if SysLog.Notable(SeverityOfSysVoice)
  then ForEachStringLine(Msg,SysLogVoice,nil);
 end;
end;

procedure CrwDaqPollSession;
var line:LongString;
begin
 if SessionManager.HasIpcServer then
 try
  while SessionManager.ReadIpcMessage(line) do begin
   if Assigned(FormCrwDaq)
   then FormCrwDaq.HandleSessionIpc(line);
  end;
 except
  on E:Exception do BugReport(E,nil,'CrwDaqPollSession');
 end;
end;

procedure InitializeSysLog;
var n:Integer;
begin
 SysLog.LogFile:=DefaultSysLogFileName;
 SysLog.INFO(sev_Notify,'Start session.');
 InitKnownSeverityLevels; n:=LoadKnownSeverityLevels;
 DebugOut(stdfDebug,Format('%d Severity Level(s) loaded from INI file.',[n]));
end;

 {
 Start session:
 if StartSession('1')   then ... - run single instance - session 1.
 if StartSession('$ 1') then ... - use option --session N or run session 1.
 if StartSession('? 9') then ... - run first found free session in range [1..9].
 }
function StartSession(arg:LongString):Boolean;
begin
Result:=SessionManager.Start(arg);
if Result then begin
 DefaultFormatSettings.DecimalSeparator:='.';
 TheUACEchoProcedure:=StandardEchoProcedure;
 SessionManager.RedirectStdIo;
 SessionManager.OpenLeakageLog;
 SessionManager.OpenReadIniLog;
 SessionManager.OpenDebugLog;
 SessionManager.OpenErrorLog;
 SessionManager.OpenSoundLog;
 SessionManager.SetGuardIniPath;
 SessionManager.SetSystemEcho(CrwDaqSystemEcho);
 SessionManager.SetBlasterLogger(CrwDaqBlasterLogger);
 SessionManager.SetSystemSendToMainConsole(SystemCalculatorFifoPutText);
 DefaultCanShowModalLimit:=3;
 SetEnv('CRW_DAQ_SYS_TMP_DIR',SessionManager.SystemTmpDir);
 SetEnv('CRW_DAQ_VAR_TMP_DIR',SessionManager.VarTmpDir);
 SetEnvironPrinter(0); SetEnvironLpPageIndents;
 InitializeSysLog;
end;
if SessionManager.HasIpcServer then Tick55Actions.Add(CrwDaqPollSession);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_unit_crwdaq_session;
begin
end;

procedure Free_unit_crwdaq_session;
begin
end;

initialization

 Init_unit_crwdaq_session;

finalization

 Free_unit_crwdaq_session;

end.

//////////////
// END OF FILE
//////////////

