////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form DAQ Pascal Property Dialog.                                           //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231209 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_daqpascalpropertydialog; // Form DAQ Pascal Property Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd,
 lcltype, lclintf,
 Form_TextEditor, Form_DaqDeviceControl,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard, _crw_sect,
 _crw_daqsys, _crw_daqdev, _crw_daqpascaldevice,
 _crw_gloss, _crw_sesman,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormDaqPascalPropertyDialog = class(TDaqDevicePropertyDialog)
    PanelControls: TPanel;
    CheckBoxDebugMode: TCheckBox;
    BitBtnConsole: TBitBtn;
    BitBtnEditor: TBitBtn;
    BitBtnNotepad: TBitBtn;
    BitBtnCompile: TBitBtn;
    CheckBoxConfirmCompile: TCheckBox;
    BitBtnClose: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxDebugModeClick(Sender: TObject);
    procedure BitBtnConsoleClick(Sender: TObject);
    procedure BitBtnEditorClick(Sender: TObject);
    procedure BitBtnNotepadClick(Sender: TObject);
    procedure BitBtnCompileClick(Sender: TObject);
    procedure BitBtnCloseClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function  Device:TProgramDevice;
    procedure UpdateButtonState;
  end;

function NewFormDaqPascalPropertyDialog(aDevice:TProgramDevice):TFormDaqPascalPropertyDialog;

implementation

{$R *.lfm}

function NewFormDaqPascalPropertyDialog(aDevice:TProgramDevice):TFormDaqPascalPropertyDialog;
begin
 Result:=nil;
 if (aDevice is TProgramDevice) then
 try
  Application.CreateForm(TFormDaqPascalPropertyDialog, Result);
  Result.LinkedDevice:=aDevice;
  if aDevice.DaqPascal.Ok then
  Result.CheckBoxDebugMode.Checked:=aDevice.DaqPascal.DebugMode;
  Result.UpdateButtonState;
 except
  on E:Exception do BugReport(E,nil,'NewFormDaqPascalPropertyDialog');
 end;
end;

function TFormDaqPascalPropertyDialog.Device:TProgramDevice;
begin
 if (LinkedDevice is TProgramDevice)
 then Result:=TProgramDevice(LinkedDevice)
 else Result:=nil;
end;

procedure TFormDaqPascalPropertyDialog.FormCreate(Sender: TObject);
const nPad=24;
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 RestoreFont(CheckBoxDebugMode.Font,DefaultSansFont);
 RestoreFont(CheckBoxConfirmCompile.Font,DefaultSansFont);
 CheckBoxDebugMode.Caption:=RusEng('Включить режим отладки','Switch on debug mode');
 CheckBoxConfirmCompile.Caption:=RusEng('Подтвердить компиляцию','Confirm compiling');
 BitBtnConsole.Caption:=Pad(RusEng('Открыть консольное окно','Open console window'),nPad);
 BitBtnEditor.Caption:=Pad(RusEng('Редактировать программу','Open source editor'),nPad);
 BitBtnNotepad.Caption:=Pad(RusEng('Открыть внешний редактор','Open external editor'),nPad);
 BitBtnCompile.Caption:=Pad(RusEng('Компилировать программу','Compile the program'),nPad);
 BitBtnClose.Caption:=RusEng('Закрыть','Close');
end;

procedure TFormDaqPascalPropertyDialog.UpdateButtonState;
begin
 if Ok then if Device.Ok then with Device do
 if IsSameText(Copy(DaqPascal.SrcFile,1,Length(Daq.SitePath)),Daq.SitePath)
 then BitBtnNotepad.Enabled:=false;
end;

procedure TFormDaqPascalPropertyDialog.CheckBoxDebugModeClick(Sender: TObject);
begin
 if Device.Ok and Device.DaqPascal.Ok then
 Device.DaqPascal.DebugMode:=CheckBoxDebugMode.Checked;
end;

procedure TFormDaqPascalPropertyDialog.BitBtnConsoleClick(Sender: TObject);
begin
 if Device.Ok and Device.DaqPascal.Ok then
 try
  HideFormDaqDeviceControl;
  Device.OpenConsole;
  Close;
 except
  on E:Exception do BugReport(E,Self,'BitBtnConsoleClick');
 end;
end;

procedure TFormDaqPascalPropertyDialog.BitBtnEditorClick(Sender: TObject);
begin
 if Device.Ok and Device.DaqPascal.Ok then
 try
  if Device.OpenDaqPascalEditor then Device.UsesInternEditor:=true;
  HideFormDaqDeviceControl;
  Close;
 except
  on E:Exception do BugReport(E,Self,'BitBtnEditorClick');
 end;
end;

procedure TFormDaqPascalPropertyDialog.BitBtnNotepadClick(Sender: TObject);
begin
 if Device.Ok and Device.DaqPascal.Ok then
 try
  if Device.OpenExternEditor then Device.UsesExternEditor:=true;
  HideFormDaqDeviceControl;
  Close;
 except
  on E:Exception do BugReport(E,Self,'BitBtnNotepadClick');
 end;
end;

procedure TFormDaqPascalPropertyDialog.BitBtnCompileClick(Sender: TObject);
var mr:Integer; comp:Boolean;
begin
 if Device.Ok and Device.DaqPascal.Ok then
 try
  if CheckBoxConfirmCompile.Checked then begin
   mr:=YesNo(RusEng('ВНИМАНИЕ! Компиляция программы ведет к её перезапуску.'+EOL
                   +'Вы уверены, что хотите откомпилировать программу '+Device.Name+'?'+EOL
                   ,'ATTENTION! Program compiling cause program device restart.'+EOL
                   +'Are you sure you want to compile program device '+Device.Name+'?'+EOL));
   if (mr<>mrYes) then Exit;
  end;
  comp:=Device.ReCompile;
  HideFormDaqDeviceControl;
  Device.NotifyCompile(comp);
  Close;
 except
  on E:Exception do BugReport(E,Self,'BitBtnCompileClick');
 end;
end;

procedure TFormDaqPascalPropertyDialog.BitBtnCloseClick(Sender: TObject);
begin
 Close;
end;

procedure TFormDaqPascalPropertyDialog.FormActivate(Sender: TObject);
begin
 LocateFormToCenterOfMouse(Self);
 ActiveControl:=BitBtnConsole;
 UpdateButtonState;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_daqpascalpropertydialog;
begin
end;

procedure Free_form_daqpascalpropertydialog;
begin
end;

initialization

 Init_form_daqpascalpropertydialog;

finalization

 Free_form_daqpascalpropertydialog;

end.

//////////////
// END OF FILE
//////////////

