////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form DAQ History Warning.                                                  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231201 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_daqhistorywarning; // Form DAQ History Warning

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Spin,
 lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard, _crw_curves,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormDaqHistoryWarning = class(TMasterForm)
    PanelInfo: TPanel;
    ImageStop: TImage;
    MemoInfo: TMemo;
    ButtonSave: TButton;
    ButtonClear: TButton;
    SpinEditHistLen: TSpinEdit;
    LabelHistLen: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ButtonSaveClick(Sender: TObject);
    procedure ButtonClearClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  FormDaqHistoryWarning : TFormDaqHistoryWarning = nil;

procedure OpenFormDaqHistoryWarning(Lim0,Lim1,Lim2:Integer; const List:LongString);
procedure KillFormDaqHistoryWarning;

implementation

{$R *.lfm}

uses
 _crw_daqsys,
 Form_DaqControlDialog;

procedure OpenFormDaqHistoryWarning(Lim0,Lim1,Lim2:Integer; const List:LongString);
begin
 if FormDaqHistoryWarning is TFormDaqHistoryWarning then begin
  FormDaqHistoryWarning.Show;
 end else begin
  Application.CreateForm(TFormDaqHistoryWarning,FormDaqHistoryWarning);
  FormDaqHistoryWarning.Master:=@FormDaqHistoryWarning;
  LocateFormToCenterOfScreen(FormDaqHistoryWarning);
  FormDaqHistoryWarning.Show;
 end;
 if FormDaqHistoryWarning is TFormDaqHistoryWarning then begin
  FormDaqHistoryWarning.SpinEditHistLen.Value:=Lim0;
  FormDaqHistoryWarning.MemoInfo.Text:=RusEng(
   'ВНИМАНИЕ!'+EOL+
   'В памяти накопилось много (более '+d2s(Lim1)+') точек. '+
   'Это может привести к замедлению работы программы или переполнению оперативной памяти. '+
   'Сейчас самое время сохранить данные на диск и очистить память, иначе память очистится автоматически до '+
   d2s(Lim0)+' точек при достижении длины истории '+d2s(Lim2)+' точек.'+EOL+
   'Список кривых, в которых слишком много точек:'+EOL+
   List);
 end;
end;

procedure KillFormDaqHistoryWarning;
begin
 Kill(TObject(FormDaqHistoryWarning));
end;

procedure TFormDaqHistoryWarning.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('ПОРА ОЧИСТИТЬ ПАМЯТЬ','IT''S TIME TO CLEAR MEMORY');
 SmartUpdate(ButtonSave,RusEng('Сохранить в файл','Save data to file'));
 SmartUpdate(ButtonClear,RusEng('Очистить историю','Clear history'));
 SmartUpdate(LabelHistLen,RusEng('Длина истории','History length'));
end;

procedure TFormDaqHistoryWarning.ButtonSaveClick(Sender: TObject);
begin
 if FormDaqControlDialog.Ok then FormDaqControlDialog.ActionDaqSaveExecute(Sender);
end;

procedure TFormDaqHistoryWarning.ButtonClearClick(Sender: TObject);
begin
 Daq.LimitHistoryLength(SpinEditHistLen.Value);
 Hide;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_daqhistorywarning;
begin
end;

procedure Free_form_daqhistorywarning;
begin
end;

initialization

 Init_form_daqhistorywarning;

finalization

 Free_form_daqhistorywarning;

end.

//////////////
// END OF FILE
//////////////

