////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form DAQ History Length Dialog.                                            //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231201 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_daqhistlendialog; // Form DAQ History Length Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Spin,
 lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormDaqHistLenDialog = class(TMasterForm)
    LabelHistLen: TLabel;
    SpinEditHistLen: TSpinEdit;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure LabelHistLenClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function  FormDaqHistLenDialogExecute(var HistLen:Integer; const Params:LongString=''):Integer;
procedure KillFormDaqHistLenDialog;

implementation

{$R *.lfm}

const
  FormDaqHistLenDialog : TFormDaqHistLenDialog = nil;

function FormDaqHistLenDialogExecute(var HistLen:Integer; const Params:LongString=''):Integer;
begin
 Result:=mrCancel;
 if CanShowModal(FormDaqHistLenDialog) then
 try
  if not Assigned(FormDaqHistLenDialog) then begin
   Application.CreateForm(TFormDaqHistLenDialog, FormDaqHistLenDialog);
   FormDaqHistLenDialog.Master:=@FormDaqHistLenDialog;
  end;
  if Assigned(FormDaqHistLenDialog) then with FormDaqHistLenDialog do begin
   if IsNonEmptyStr(Params) then ApplyParams(Params);
   SpinEditHistLen.Value:=HistLen;
   if (mrVoice(ShowModal)=mrOk) then begin
    Result:=mrOk;
    HistLen:=SpinEditHistLen.Value;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'FormDaqHistLenDialogExecute');
 end;
end;

procedure KillFormDaqHistLenDialog;
begin
 Kill(TObject(FormDaqHistLenDialog));
end;

procedure TFormDaqHistLenDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 Caption:=RusEng('Очистка выбранных данных','Clear custom data curves');
 SmartUpdate(LabelHistLen,RusEng('Сохранить историю # точек','Keep history # data points'));
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
end;

procedure TFormDaqHistLenDialog.LabelHistLenClick(Sender: TObject);
begin
 SmartFocus(SpinEditHistLen);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_daqhistlendialog;
begin
end;

procedure Free_form_daqhistlendialog;
begin
end;

initialization

 Init_form_daqhistlendialog;

finalization

 Free_form_daqhistlendialog;

end.

//////////////
// END OF FILE
//////////////

