////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form DAQ Help Viewer.                                                      //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231201 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_daqhelpviewer; // Form DAQ Help Viewer

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
  lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_appforms, _crw_apptools, _crw_apputils;

type

  { TFormDaqHelpViewer }

  TFormDaqHelpViewer = class(TMasterForm)
    GroupBoxHelpTopics: TGroupBox;
    ListBoxHelpTopics: TListBox;
    GroupBoxHelpTopic: TGroupBox;
    MemoHelpTopic: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListBoxHelpTopicsClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    myHelpFile:LongString;
  public
    { Public declarations }
    procedure UpdateHelpTopic;
  end;

procedure OpenFormDaqHelpViewer(HelpFile:LongString);
procedure KillFormDaqHelpViewer;

implementation

{$R *.lfm}

const
  FormDaqHelpViewer : TFormDaqHelpViewer = nil;

function ReadHelpTopicList(HelpFile:LongString):LongString;
var TopicList,Section:TText; Topic:LongString; i:Integer;
var Temp:TParsingBuffer;
begin
 Result:='';
 HelpFile:=UnifyFileAlias(HelpFile);
 if FileExists(HelpFile) then
 try
  Topic:='';
  TopicList:=NewText;
  Section:=ExtractListSection(HelpFile,'[HelpTopicList]',efAsIs or efDelCom);
  for i:=0 to Section.Count-1 do
  if (ScanVarString(svConfig,StrCopyBuff(Temp,Section[i]),'HelpTopic%s',Topic)<>nil)
  then TopicList.Addln(TrimChars(Topic,[' ','='],[' ','=']));
  Result:=TopicList.Text;
  Kill(TopicList);
  Kill(Section);
 except
  Result:='';
 end;
end;

function ReadHelpTopic(HelpFile,Topic:LongString):LongString;
begin
 Result:='';
 HelpFile:=UnifyFileAlias(HelpFile);
 if FileExists(HelpFile) and IsNonEmptyStr(Topic) then
 try
  Result:=ExtractTextSection(HelpFile,'[HelpTopic "'+Topic+'"]',efAsIs);
 except
  Result:='';
 end;
end;

procedure OpenFormDaqHelpViewer(HelpFile:LongString);
begin
 if not Assigned(FormDaqHelpViewer) then begin
  Application.CreateForm(TFormDaqHelpViewer, FormDaqHelpViewer);
  FormDaqHelpViewer.Master:=@FormDaqHelpViewer;
 end;
 if Assigned(FormDaqHelpViewer) then begin
  HelpFile:=UnifyFileAlias(HelpFile);
  FormDaqHelpViewer.Show;
  FormDaqHelpViewer.BringToFront;
  FormDaqHelpViewer.myHelpFile:=HelpFile;
  FormDaqHelpViewer.ListBoxHelpTopics.Items.Text:=ReadHelpTopicList(HelpFile);
  FormDaqHelpViewer.ListBoxHelpTopics.ItemIndex:=0;
  FormDaqHelpViewer.UpdateHelpTopic;
 end;
end;

procedure KillFormDaqHelpViewer;
begin
 Kill(TObject(FormDaqHelpViewer));
end;

procedure TFormDaqHelpViewer.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 Caption:=RusEng('Справка DAQ','DAQ help');
 SmartUpdate(GroupBoxHelpTopics,RusEng('Список справок DAQ','List of DAQ help topics'));
 myHelpFile:='';
end;

procedure TFormDaqHelpViewer.FormDestroy(Sender: TObject);
begin
 myHelpFile:='';
 inherited;
end;

procedure TFormDaqHelpViewer.UpdateHelpTopic;
var Topic:LongString;
begin
 if Ok then begin
  if InRange(ListBoxHelpTopics.ItemIndex,0,ListBoxHelpTopics.Items.Count-1)
  then Topic:=ListBoxHelpTopics.Items[ListBoxHelpTopics.ItemIndex]
  else Topic:='';
  if IsEmptyStr(Topic)
  then MemoHelpTopic.Text:=''
  else MemoHelpTopic.Text:=ReadHelpTopic(myHelpFile,Topic);
  if (MemoHelpTopic.Lines.Count=0)
  then SmartUpdate(GroupBoxHelpTopic,RusEng('Справка на тему "','Help on topics "')+
                               Topic+RusEng('" не найдена!','" not found!'))
  else SmartUpdate(GroupBoxHelpTopic,RusEng('Справка на тему "','Help on topics "')+Topic+'".');
 end;
end;

procedure TFormDaqHelpViewer.ListBoxHelpTopicsClick(Sender: TObject);
begin
 UpdateHelpTopic;
end;

procedure TFormDaqHelpViewer.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Action:=caFree;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_daqhelpviewer;
begin
end;

procedure Free_form_daqhelpviewer;
begin
end;

initialization

 Init_form_daqhelpviewer;

finalization

 Free_form_daqhelpviewer;

end.

//////////////
// END OF FILE
//////////////

