////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Curve Tools Read Table Dialog.                                        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231124 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_curvetoolsreadtabledialog; // Form Curve Tools Read Table Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd,
 lcltype, lclintf,
 Form_CrwDaqSysChild,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard, _crw_sort,
 _crw_ef, _crw_zm, _crw_curves,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormCurveToolsReadTableDialog = class(TMasterForm)
    PanelFormat: TPanel;
    LabelFormat: TLabel;
    ComboBoxFormat: TComboBox;
    PanelManual: TPanel;
    LabelManual: TLabel;
    MemoManual: TMemo;
    PanelButtons: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure LabelFormatClick(Sender: TObject);
    procedure LabelManualClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    TableFormatHistory : LongInt;
    function TableFormat:LongString;
  end;

function CurveToolsReadTableDialogExecute(const Form:TForm; const aParams:LongString=''):LongInt;
function FormCurveToolsReadTableDialogTableFormat:LongString;

implementation

{$R *.lfm}

uses
 Form_TextEditor,
 Form_CurveWindow;

const
  FormCurveToolsReadTableDialog : TFormCurveToolsReadTableDialog = nil;

function CurveToolsReadTableDialogExecute(const Form:TForm; const aParams:LongString=''):LongInt;
var apFlags:Integer;
begin
 Result:=mrCancel;
 if Form is TFormTextEditor then
 if CanShowModal(FormCurveToolsReadTableDialog) then
 try
  if not Assigned(FormCurveToolsReadTableDialog) then begin
   Application.CreateForm(TFormCurveToolsReadTableDialog, FormCurveToolsReadTableDialog);
   FormCurveToolsReadTableDialog.Master:=@FormCurveToolsReadTableDialog;
  end;
  if Assigned(FormCurveToolsReadTableDialog) then with FormCurveToolsReadTableDialog do begin
   apFlags:=ApplyParams(aParams);
   if not HasFlags(apFlags,apf_FormPos)
   then LocateFormToCenterOfScreen(FormCurveToolsReadTableDialog);
   if mrVoice(ShowModal)=mrOk then begin
    RecordComboBoxHistory(ComboBoxFormat,TableFormatHistory);
    Result:=mrOk;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'CurveToolsReadTableDialogExecute');
 end;
end;

function FormCurveToolsReadTableDialogTableFormat:LongString;
begin
 Result:=FormCurveToolsReadTableDialog.TableFormat;
end;

procedure TFormCurveToolsReadTableDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('Диалог для чтения таблицы кривых','Dialog to read table of curve');
 SmartUpdate(LabelFormat,RusEng('Задайте формат чтения таблицы:','Set format of table to read:'));
 SmartUpdate(LabelManual,RusEng('Краткое описание форматирования:','Short manual:'));
 SmartUpdate(MemoManual,RusEng(
  'Формат таблицы задается строкой, состоящей списка описаний, разделенных пробелами.'+EOL+
  'Каждое описание имеет вид xn:c или yn:c, где x-указание абсциссу, у-указание на ординату, n-номер кривой, c-номер столбца.'+EOL+
  'Например, x5:6 указывает, что авсциссу пятой кривой надо читать из шестого столбца таблицы.'+EOL+
  'Нулевой столбец означает, что в качестве значения надо брать номер точки.'+EOL+
  'В списке описаний должны содержаться описания для обоих (x и y) осей читаемой кривой.'+EOL+
  'Примеры:'+EOL+
  'x1:1 y1:2 x2:3 y2:4 x3:5 y3:6'+EOL+
  'x1:0 y1:1 x2:0 y2:2',
  'Table format contains list of format items with space delimiters.'+EOL+
  'Each item has format xn:c or yn:c, where x means x-axis, у means y-axis, n-number of curve, c-number of column.'+EOL+
  'For example, x5:6 means, that you read curve number 5 from table column number 6.'+EOL+
  'Zero column means the number of point.'+EOL+
  'Both x and y descriptions must present in format list for each curve to read.'+EOL+
  'Examples:'+EOL+
  'x1:1 y1:2 x2:3 y2:4 x3:5 y3:6'+EOL+
  'x1:0 y1:1 x2:0 y2:2'));
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
 TableFormatHistory:=50;
end;

function TFormCurveToolsReadTableDialog.TableFormat:LongString;
begin
 if Ok then Result:=ComboBoxFormat.Text else Result:='';
end;

procedure TFormCurveToolsReadTableDialog.LabelFormatClick(Sender: TObject);
begin
 SmartFocus(ComboBoxFormat);
end;

procedure TFormCurveToolsReadTableDialog.LabelManualClick(Sender: TObject);
begin
 SmartFocus(MemoManual);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_curvetoolsreadtabledialog;
begin
end;

procedure Free_form_curvetoolsreadtabledialog;
begin
end;

initialization

 Init_form_curvetoolsreadtabledialog;

finalization

 Free_form_curvetoolsreadtabledialog;

end.

//////////////
// END OF FILE
//////////////

