////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Curve Edit Window Style Dialog.                                       //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231124 - Modified for FPC (A.K.)                                         //
// 20240625 - ApplyParams                                                     //
////////////////////////////////////////////////////////////////////////////////

unit form_curveeditwindowstyledialog; // Form Curve Edit Window Style Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons,
 lcltype, lclintf, ColorBox,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo, _crw_ef,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_appforms, _crw_apptools, _crw_apputils;

type

  { TFormCurveEditWindowStyleDialog }

  TFormCurveEditWindowStyleDialog = class(TMasterForm)
    ColorBox: TColorBox;
    GroupBoxColorBox: TGroupBox;
    PanelButtons: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    ButtonDefault: TButton;
    PanelControls: TPanel;
    GroupBoxCaptions: TGroupBox;
    LabelCaption: TLabel;
    LabelTitle: TLabel;
    LabelLegend: TLabel;
    EditCaption: TEdit;
    EditTitle: TEdit;
    EditLegend: TEdit;
    GroupBoxColor: TGroupBox;
    RadioGroupColor: TRadioGroup;
    procedure ColorBoxChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonDefaultClick(Sender: TObject);
    procedure LabelCaptionClick(Sender: TObject);
    procedure LabelTitleClick(Sender: TObject);
    procedure LabelLegendClick(Sender: TObject);
    procedure RadioGroupColorClick(Sender: TObject);
  private
    { Private declarations }
    myFormLink  : TForm;
    myColorLock : Boolean;
    procedure UpdateColor(index:LongInt; Direction:Integer=1);
  public
    { Public declarations }
  end;

procedure RunCurveWindowStyleDialog(Form:TForm; const aParams:LongString='');

implementation

{$R *.lfm}

uses
 Form_CurveWindow;

const
  FormCurveEditWindowStyleDialog : TFormCurveEditWindowStyleDialog = nil;

procedure RunCurveWindowStyleDialog(Form:TForm; const aParams:LongString='');
var SaveGroundColor,SaveBoxColor,SaveRectColor,SaveNumberColor,SaveGridColor,SaveLegendColor:TColor;
var ii,apFlags:Integer;
begin
 if CanShowModal(FormCurveEditWindowStyleDialog) then
 try
  if (Form is TFormCurveWindow) then
  if not (Form as TFormCurveWindow).CheckIsDataProtected then begin
   if not Assigned(FormCurveEditWindowStyleDialog)  then begin
    Application.CreateForm(TFormCurveEditWindowStyleDialog, FormCurveEditWindowStyleDialog);
    FormCurveEditWindowStyleDialog.Master:=@FormCurveEditWindowStyleDialog;
   end;
   if Assigned(FormCurveEditWindowStyleDialog) then begin
    apFlags:=FormCurveEditWindowStyleDialog.ApplyParams(aParams);
    if not HasFlags(apFlags,apf_FormPos)
    then LocateFormToCenterOfScreen(FormCurveEditWindowStyleDialog);
    FormCurveEditWindowStyleDialog.myFormLink:=Form;
    with (Form as TFormCurveWindow) do begin
     SaveGroundColor:=GroundColor;
     SaveNumberColor:=NumberColor;
     SaveLegendColor:=LegendColor;
     SaveBoxColor:=BoxColor;
     SaveRectColor:=RectColor;
     SaveGridColor:=GridColor;
     ii:=FormCurveEditWindowStyleDialog.RadioGroupColor.ItemIndex;
     FormCurveEditWindowStyleDialog.UpdateColor(ii+1,-1);
     FormCurveEditWindowStyleDialog.EditCaption.Text:=Caption;
     FormCurveEditWindowStyleDialog.EditTitle.Text:=ReplaceAlignStr(Title,false);
     FormCurveEditWindowStyleDialog.EditLegend.Text:=ReplaceAlignStr(Legend,false);
     if mrVoice(FormCurveEditWindowStyleDialog.ShowModal)=mrOk then begin
      try
       LockDraw;
       Caption:=FormCurveEditWindowStyleDialog.EditCaption.Text;
       Title:=ReplaceAlignStr(FormCurveEditWindowStyleDialog.EditTitle.Text,true);
       Legend:=ReplaceAlignStr(FormCurveEditWindowStyleDialog.EditLegend.Text,true);
      finally
       UnlockDraw;
      end;
     end else begin
      try
       LockDraw;
       GroundColor:=SaveGroundColor;
       NumberColor:=SaveNumberColor;
       LegendColor:=SaveLegendColor;
       BoxColor:=SaveBoxColor;
       RectColor:=SaveRectColor;
       GridColor:=SaveGridColor;
      finally
       UnlockDraw;
      end;
     end;
    end;
    FormCurveEditWindowStyleDialog.myFormLink:=nil;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'RunCurveWindowStyleDialog');
 end;
end;

procedure TFormCurveEditWindowStyleDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('Диалог выбора имени,цвета и стиля окна',
                 'Window name,color and style selection dialog');
 SmartUpdate(GroupBoxCaptions,RusEng('Текстовая информация','Text imnformation'));
 SmartUpdate(LabelCaption,RusEng('Имя окна:','Name:'));
 SmartUpdate(LabelTitle,RusEng('Заголовок:','Title:'));
 SmartUpdate(LabelLegend,RusEng('Легенда:','Legend:'));
 SmartUpdate(GroupBoxColor,RusEng('Цвет','Color'));
 SmartUpdate(RadioGroupColor,RusEng('Выбрать цвет объекта:','Select color of:'));
 RadioGroupColor.Items.Text:=RusEng(
                             'Фон окна'+EOL+
                             'Фон графика'+EOL+
                             'Рамка графика'+EOL+
                             'Текст по осям'+EOL+
                             'Разметка осей'+EOL+
                             'Заголовки'+EOL+
                             'Левый  маркер РОИ'+EOL+
                             'Правый маркер РОИ',
                             'Ground'+EOL+
                             'Box'+EOL+
                             'Rect'+EOL+
                             'Grid text'+EOL+
                             'Grid lines'+EOL+
                             'Legend'+EOL+
                             'Left  ROI marker'+EOL+
                             'Right ROI marker');
 RadioGroupColor.ItemIndex:=0;
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
 SmartUpdate(ButtonDefault,RusEng('Сделать палитрой по умолчанию','Save as default palette'));
 SmartUpdate(GroupBoxColorBox,RusEng('Цвет выбранного объекта:','Color of selected object:'));
 ColorBox.Font.Name:=Font.Name;
 ColorBox.Font.Size:=16;
end;

procedure TFormCurveEditWindowStyleDialog.UpdateColor(Index:LongInt; Direction:Integer=1);
begin
 if (myFormLink is TFormCurveWindow) then
 with TFormCurveWindow(myFormLink) do begin
  if (Direction>0) then begin
   if not myColorLock then
   case Index of
    1:GroundColor:=ColorBox.Selected;
    2:BoxColor:=ColorBox.Selected;
    3:RectColor:=ColorBox.Selected;
    4:NumberColor:=ColorBox.Selected;
    5:GridColor:=ColorBox.Selected;
    6:LegendColor:=ColorBox.Selected;
    7:RoiLColor:=ColorBox.Selected;
    8:RoiRColor:=ColorBox.Selected;
   end;
  end;
  if (Direction<0) then begin
   case Index of
    1:ColorBox.Selected:=GroundColor;
    2:ColorBox.Selected:=BoxColor;
    3:ColorBox.Selected:=RectColor;
    4:ColorBox.Selected:=NumberColor;
    5:ColorBox.Selected:=GridColor;
    6:ColorBox.Selected:=LegendColor;
    7:ColorBox.Selected:=RoiLColor;
    8:ColorBox.Selected:=RoiRColor;
   end;
  end;
 end;
end;

procedure TFormCurveEditWindowStyleDialog.ColorBoxChange(Sender: TObject);
begin
 UpdateColor(RadioGroupColor.ItemIndex+1);
end;

procedure TFormCurveEditWindowStyleDialog.ButtonDefaultClick(Sender: TObject);
begin
 if (myFormLink is TFormCurveWindow) then
 with TFormCurveWindow(myFormLink) do begin
  DefGroundColor:=GroundColor;
  DefBoxColor:=BoxColor;
  DefRectColor:=RectColor;
  DefNumberColor:=NumberColor;
  DefGridColor:=GridColor;
  DefLegendColor:=LegendColor;
  DefRoiLColor:=RoiLColor;
  DefRoiRColor:=RoiRColor;
 end;
end;

procedure TFormCurveEditWindowStyleDialog.LabelCaptionClick(Sender: TObject);
begin
 SmartFocus(EditCaption);
end;

procedure TFormCurveEditWindowStyleDialog.LabelTitleClick(Sender: TObject);
begin
 SmartFocus(EditTitle);
end;

procedure TFormCurveEditWindowStyleDialog.LabelLegendClick(Sender: TObject);
begin
 SmartFocus(EditLegend);
end;

procedure TFormCurveEditWindowStyleDialog.RadioGroupColorClick(Sender: TObject);
begin
 try
  myColorLock:=true;
  UpdateColor(RadioGroupColor.ItemIndex+1,-1);
 finally
  myColorLock:=false;
 end;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_curveeditwindowstyledialog;
begin
end;

procedure Free_form_curveeditwindowstyledialog;
begin
end;

initialization

 Init_form_curveeditwindowstyledialog;

finalization

 Free_form_curveeditwindowstyledialog;

end.

//////////////
// END OF FILE
//////////////

