unit unit_resourcemonitorconsole;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math, process,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd,
 lcltype, lclintf,
 {$IFDEF WINDOWS} JwaTlHelp32, {$ENDIF}
 Form_CrwDaqSysChild, Form_Calculator,
 Form_ListBoxSelection, Form_UartTerminal,
 Form_TextEditor, Form_CurveWindow,
 Form_SurfWindow, Form_ConsoleWindow,
 Form_CircuitWindow, Form_TabWindow,
 unit_crwdaqmessages,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard, _crw_riff,
 _crw_ef, _crw_ee, _crw_pio, _crw_couple,
 _crw_polling, _crw_task, _crw_daqtags,
 _crw_sysid, _crw_proc,
 _crw_appforms, _crw_apptools, _crw_apputils;

procedure OpenResourceMonitorConsole(Locate:Boolean=true);
procedure KillResourceMonitorConsole;
procedure PollResourceMonitorConsole;

const
 TimerActionsCpuKernLoad  : Int64   = 0;
 TimerActionsCpuUserLoad  : Int64   = 0;
 PostWindowsMessagesCount : Int64   = 0;
 SentWindowsMessagesCount : Int64   = 0;
 ResMonStatObjects                  = $00000001;
 ResMonStatMemorys                  = $00000002;
 ResMonStatHandles                  = $00000004;
 ResMonStatThreads                  = $00000008;
 ResMonStatDefault                  = {$IFDEF WINDOWS}$0007{$ELSE}$000F{$ENDIF};
 ResMonStatFlags          : Integer = ResMonStatDefault;

implementation

uses _crw_daqsys, _crw_daqdev;   

const
 Fifo : TFifo              = nil;
 Form : TFormConsoleWindow = nil;

procedure OpenResourceMonitorConsole(Locate:Boolean=true);
begin
 try
  if not Fifo.Ok then begin
   Fifo:=NewFifo(1024*64,'FIFO:\RESOURCE_MONITOR_CONSOLE',2);
   Fifo.Master:=@Fifo;
  end;
  if not Form.Ok then begin
   Form:=NewConsoleWindow(RusEng('КОНСОЛЬ МОНИТОРА РЕСУРСОВ','RESOURCE MONITOR CONSOLE'),
                                 nil,  false, nil,
                                 Fifo, false, nil);
   Form.Master:=@Form;
   Form.CloseAction:=caFree;
   Form.StartMonitoring;
   SecondActions.Add(PollResourceMonitorConsole);
   DoneSubSystems.Add(KillResourceMonitorConsole);
   Echo(Format(RusEng('Монитор ресурсов начал работу %s.',
                      'Resource monitor started work %s.'),
                      [StdDateTimeStr(msecnow)]));
   Locate:=true;
  end;
  if Fifo.Ok and Form.Ok then begin
   Form.Show;
   Form.WindowState:=wsNormal;
   SdiMan.ActivateChild(Form);
   if Locate then begin
    Form.Width:=640;
    Form.Height:=480;
    LocateFormToCenterOfScreen(Form);
   end;
  end else KillResourceMonitorConsole;
 except
  on E:Exception do BugReport(E,nil,'OpenResourceMonitorConsole');
 end;
end;

procedure KillResourceMonitorConsole;
begin
 try
  Kill(Form);
  Kill(Fifo);
  SecondActions.Remove(PollResourceMonitorConsole);
  DoneSubSystems.Remove(KillResourceMonitorConsole);
  Echo(Format(RusEng('Монитор ресурсов завершил работу %s.',
                     'Resource monitor stopped working %s.'),
                     [StdDateTimeStr(msecnow)]));
 except
  on E:Exception do BugReport(E,nil,'KillResourceMonitorConsole');
 end;
end;

procedure PollingLeng(Index:LongInt; const aObject:TObject; var Terminate:Boolean; CustomData:Pointer);
begin
 if (aObject is TPolling) and Assigned(CustomData)
 then Integer(CustomData^):=Max(Integer(CustomData^),Length(TPolling(aObject).Name));
end;

type TPollingReportRec=packed record prcl:DWORD; sums,sumk,sumu,sumf:Double; num,len:Integer; end;
procedure PollingReport(Index:LongInt; const aObject:TObject; var Terminate:Boolean; CustomData:Pointer);
var s,k,u,f:Double; p,l:Integer;
begin
 if Assigned(CustomData) then
 if (aObject is TPolling) then
 with TPolling(aObject) do begin
  l:=TPollingReportRec(CustomData^).len;
  if not GetCpuLoad(s,k,u,f) then begin s:=0; k:=0; u:=0; f:=0; end;
  p:=GetAbsolutePriority(TPollingReportRec(CustomData^).prcl,Priority);
  Fifo.PutText(Format('%-*.*s | %6.2f | %6.2f | %6.2f | %6.0f | %2.2d',[l, l, Name, s, k, u, f, p])+EOL);
  if Assigned(CustomData) then with TPollingReportRec(CustomData^) do begin
   sums:=sums+s; sumk:=sumk+k; sumu:=sumu+u; sumf:=sumf+f; inc(num);
  end;
 end;
end;

{$IFDEF SKIP_DRAFT}
// Nice To Level - ?
{$ENDIF ~SKIP_DRAFT}

function CalculateNiceToWindowsPriorityLevel(nice:Integer):Integer;
const tpa:array[0..6] of TThreadPriority=(tpNormal,tpLower,tpHigher,tpLowest,tpHighest,tpIdle,tpTimeCritical);
const ppa:array[0..5] of TProcessPriority=(ppNormal,ppBelowNormal,ppAboveNormal,ppIdle,ppHigh,ppRealTime);
var n,m,d,ppi,tpi:Integer; pp,ppx:TProcessPriority; tp,tpx:TThreadPriority;
begin
 nice:=EnsureRange(nice,MIN_NICE,MAX_NICE);
 ppx:=ppNormal; tpx:=tpNormal; m:=MaxInt;
 for ppi:=Low(ppa) to High(ppa) do
 for tpi:=Low(tpa) to High(tpa) do begin
  pp:=ppa[ppi]; tp:=tpa[tpi];
  n:=SchedOtherPriorityToNice(pp,tp);
  d:=abs(nice-n);
  if (d<m) then begin
   ppx:=pp;
   tpx:=tp;
   m:=d;
  end;
  if (d=0) then Break;
 end;
 Result:=WindowsPriorityToLevel(ppx,tpx);
end;

const NiceInitFlag:Boolean=false;
var NiceToLevelTable:packed array[MIN_NICE..MAX_NICE] of Integer;

function NiceToWindowsPriorityLevel(nice:Integer):Integer;
var n:Integer;
begin
 nice:=EnsureRange(nice,MIN_NICE,MAX_NICE);
 if NiceInitFlag then Result:=NiceToLevelTable[nice] else begin
  for n:=MIN_NICE to MAX_NICE
  do NiceToLevelTable[n]:=CalculateNiceToWindowsPriorityLevel(n);
  NiceInitFlag:=true;
 end;
end;

{$IFDEF WINDOWS}
function GetCurrentThreadPriorityLevel:Integer;
var prcl:DWORD;
begin
 prcl:=ProcessPriorityToClass(GetProcessPriority);
 case GetThreadPriority(GetCurrentThread) of
  THREAD_PRIORITY_IDLE          : Result:=GetAbsolutePriority(prcl,tpIdle);
  THREAD_PRIORITY_LOWEST        : Result:=GetAbsolutePriority(prcl,tpLowest);
  THREAD_PRIORITY_BELOW_NORMAL  : Result:=GetAbsolutePriority(prcl,tpLower);
  THREAD_PRIORITY_NORMAL        : Result:=GetAbsolutePriority(prcl,tpNormal);
  THREAD_PRIORITY_ABOVE_NORMAL  : Result:=GetAbsolutePriority(prcl,tpHigher);
  THREAD_PRIORITY_HIGHEST       : Result:=GetAbsolutePriority(prcl,tpHighest);
  THREAD_PRIORITY_TIME_CRITICAL : Result:=GetAbsolutePriority(prcl,tpTimeCritical);
  else                            Result:=GetAbsolutePriority(prcl,tpNormal);
 end;
end;
{$ENDIF ~WINDOWS}
{$IFDEF UNIX}
function GetCurrentThreadPriorityLevel:Integer;
var nice:Integer;
begin
 Result:=ProcessPriorityToLevel(GetProcessPriority);
 Exit;
 {$IFDEF SKIP_DRAFT}
 // Nice To Level - ?
 {$ENDIF ~SKIP_DRAFT}
 nice:=GetProcessNice(GetCurrentProcessID);
 Result:=NiceToWindowsPriorityLevel(nice);
end;
{$ENDIF ~UNIX}

const
 CurrOnIdleCounter:Int64=0;

procedure Callback_OnIdleCounter;
begin
 Inc(CurrOnIdleCounter);
end;

procedure PollResourceMonitorConsole;
const
 LastTickCount : Int64 = 0;
 LastProcKTime : Int64 = 0;
 LastMainKTime : Int64 = 0;
 LastProcUTime : Int64 = 0;
 LastMainUTime : Int64 = 0;
 LastDrawKTime : Int64 = 0;
 LastDrawUTime : Int64 = 0;
 LastPostMsg   : Int64 = 0;
 LastSentMsg   : Int64 = 0;
 LastWndProc   : Int64 = 0;
 LastPostDpc   : SizeInt = 0;
 LastHandDpc   : SizeInt = 0;
 LastOnIdle    : Int64   = 0;
var
 {$IFDEF WINDOWS}
 pwssMin,pwssMax:PtrUInt; hCnt:DWORD;
 {$ENDIF ~WINDOWS}
 CurrPid:TPid; CurrTickCount:Int64;
 snum:LongString; prcl,prpr,prth:DWORD;
 CpuProcKern,CpuProcUser,CpuProcSumm:Double;
 CpuMainKern,CpuMainUser,CpuMainSumm:Double;
 CpuOtheKern,CpuOtheUser,CpuOtheSumm:Double;
 CpuDrawKern,CpuDrawUser,CpuDrawSumm:Double;
 PostMsgRate,SentMsgRate,WndProcRate:Double;
 PostDpcRate,HandDpcRate,OnIdleRate:Double;
 CurrThreads,TotalThreads,TotalProcesses:Integer;
 CurrProcKTime,CurrProcUTime:Int64;
 CurrMainKTime,CurrMainUTime:Int64;
 CurrDrawKTime,CurrDrawUTime:Int64;
 prr:TPollingReportRec;
 fphs:TFPCHeapStatus;
 mmhs:THeapStatus;
 cp,dp:Integer;
 seplen:LongString;
 procedure Add(const s:LongString);
 begin
  Fifo.PutText(s+EOL);
 end;
begin
 try
  seplen:='';
  if Form.Ok and Fifo.Ok then begin
   Add('');
   Add('Resource usage report at '+StdDateTimeStr(msecnow));
   // Daq status
   if Daq.Ok and Daq.Timer.isStart then begin
    Add('---------------');
    Add('DAQ Statistics:');
    Add('---------------');
    Add(Format('Tag.Count            = %d', [ CountTags                          ]));
    Add(Format('Curve.Count          = %d', [ Daq.Curves.Count                   ]));
    Add(Format('Device.Count         = %d', [ FullDaqDeviceList.Count            ]));
    Add(Format('Sensor.Count         = %d', [ FullCircuitWindowList.SensorsCount ]));
    Add(Format('Tab_Window.Count     = %d', [ Daq.TabWinList.Count               ]));
    Add(Format('Curve_Window.Count   = %d', [ Daq.CurWinList.Count               ]));
    Add(Format('Spectr_Window.Count  = %d', [ Daq.SpeWinList.Count               ]));
    Add(Format('Circuit_Window.Count = %d', [ Daq.CirWinList.Count               ]));
    if (Daq.TabWinList.Count>0) then with TableWindowsProfiler do begin
     Add('----------------------------');
     Add('DAQ Tab_Window`s Statistics:');
     Add('----------------------------');
     Add(Format('DrawView       = %12.1f Hz, %20d total', [ RateFactor * Rate.DrawView,     Curr.DrawView    ]));
     Add(Format('MonitorCall    = %12.1f Hz, %20d total', [ RateFactor * Rate.MonitorCall,  Curr.MonitorCall ]));
     Add(Format('MonitorDraw    = %12.1f Hz, %20d total', [ RateFactor * Rate.MonitorDraw,  Curr.MonitorDraw ]));
    end;
    if (Daq.CurWinList.Count>0) then with CurveWindowsProfiler do begin
     Add('------------------------------');
     Add('DAQ Curve_Window`s Statistics:');
     Add('------------------------------');
     Add(Format('DrawView       = %12.1f Hz, %20d total', [ RateFactor * Rate.DrawView,     Curr.DrawView     ]));
     Add(Format('DrawCurve      = %12.1f Hz, %20d total', [ RateFactor * Rate.DrawCurve,    Curr.DrawCurve    ]));
     Add(Format('DrawPoint      = %12.1f Hz, %20d total', [ RateFactor * Rate.DrawPoint,    Curr.DrawPoint    ]));
     Add(Format('MonitorCall    = %12.1f Hz, %20d total', [ RateFactor * Rate.MonitorCall,  Curr.MonitorCall  ]));
     Add(Format('MonitorDraw    = %12.1f Hz, %20d total', [ RateFactor * Rate.MonitorDraw,  Curr.MonitorDraw  ]));
     Add(Format('MonitorCurve   = %12.1f Hz, %20d total', [ RateFactor * Rate.MonitorCurve, Curr.MonitorCurve ]));
     Add(Format('MonitorPoint   = %12.1f Hz, %20d total', [ RateFactor * Rate.MonitorPoint, Curr.MonitorPoint ]));
    end;
    if (Daq.CirWinList.Count>0) then with CircuitWindowsProfiler do begin
     Add('--------------------------------');
     Add('DAQ Circuit_Window`s Statistics:');
     Add('--------------------------------');
     Add(Format('DrawView       = %12.1f Hz, %20d total', [ RateFactor * Rate.DrawView,       Curr.DrawView       ]));
     Add(Format('MakeBitmap     = %12.1f Hz, %20d total', [ RateFactor * Rate.MakeBitmap,     Curr.MakeBitmap     ]));
     Add(Format('DrawSensor     = %12.1f Hz, %20d total', [ RateFactor * Rate.DrawSensor,     Curr.DrawSensor     ]));
     Add(Format('PollSensor     = %12.1f Hz, %20d total', [ RateFactor * Rate.PollSensor,     Curr.PollSensor     ]));
     Add(Format('TagEvalCall    = %12.1f Hz, %20d total', [ RateFactor * Rate.TagEvalCall,    Curr.TagEvalCall    ]));
     Add(Format('LedEvalCall    = %12.1f Hz, %20d total', [ RateFactor * Rate.LedEvalCall,    Curr.LedEvalCall    ]));
     Add(Format('PainterCall    = %12.1f Hz, %20d total', [ RateFactor * Rate.PainterCall,    Curr.PainterCall    ]));
     Add(Format('PainterApiCall = %12.1f Hz, %20d total', [ RateFactor * Rate.PainterApiCall, Curr.PainterApiCall ]));
     Add(Format('PainterApiDraw = %12.1f Hz, %20d total', [ RateFactor * Rate.PainterApiDraw, Curr.PainterApiDraw ]));
     Add(Format('MonitorCall    = %12.1f Hz, %20d total', [ RateFactor * Rate.MonitorCall,    Curr.MonitorCall    ]));
     Add(Format('MonitorDraw    = %12.1f Hz, %20d total', [ RateFactor * Rate.MonitorDraw,    Curr.MonitorDraw    ]));
    end;
   end;
   // Object regystry
   if HasFlags(ResMonStatFlags,ResMonStatObjects) then begin
    Add('---------------');
    Add('ObjectRegistry:');
    Add('---------------');
    Add(Format('Count    = %d',[ObjectRegistry.Count]));
    Add(Format('Space    = %d',[ObjectRegistry.Space]));
    Add(Format('Capacity = %d',[ObjectRegistry.Capacity]));
   end;
   // Memory resources
   if HasFlags(ResMonStatFlags,ResMonStatMemorys) then begin
    Add('-------------');
    Add('MemoryStatus:');
    Add('-------------');
    Add(Format('AllocMemSize  = %10d bytes',  [GetAllocMemSize]));
    Add(Format('AllocMemCount = %10d blocks', [GetAllocMemCount]));
    Add(Format('MemoryLoad    = %3d %s',      [ReadProcMemInfo('MemLoad'),'%']));
    Add(Format('TotalPhys     = %10d bytes',  [ReadProcMemInfo('MemTotal')]));
    Add(Format('AvailPhys     = %10d bytes',  [ReadProcMemInfo('MemAvailable')]));
    Add(Format('TotalPageFile = %10d bytes',  [ReadProcMemInfo('SwapTotal')]));
    Add(Format('AvailPageFile = %10d bytes',  [ReadProcMemInfo('SwapFree')]));
    {$IFDEF WINDOWS}
    //Add(Format('TotalVirtual  = %10d bytes',  [ReadProcMemInfo(ms.dwTotalVirtual]));
    //Add(Format('AvailVirtual  = %10d bytes',  [ReadProcMemInfo(ms.dwAvailVirtual]));
    pwssmin:=0; pwssmax:=0;
    if GetProcessWorkingSetSize(GetCurrentProcess,pwssMin,pwssMax) then begin
     Add(Format('WorkingSetMin = %10d bytes',  [pwssMin]));
     Add(Format('WorkingSetMax = %10d bytes',  [pwssMax]));
    end;
    {$ENDIF ~WINDOWS}
    mmhs:=GetHeapStatus;
    fphs:=GetFPCHeapStatus;
    Add('-------------------');
    Add('Memory Heap Status:');
    Add('-------------------');
    Add(Format('TotalAddrSpace   = %u',[mmhs.TotalAddrSpace]));
    Add(Format('TotalUncommitted = %u',[mmhs.TotalUncommitted]));
    Add(Format('TotalCommitted   = %u',[mmhs.TotalCommitted]));
    Add(Format('TotalAllocated   = %u',[mmhs.TotalAllocated]));
    Add(Format('TotalFree        = %u',[mmhs.TotalFree]));
    Add(Format('FreeSmall        = %u',[mmhs.FreeSmall]));
    Add(Format('FreeBig          = %u',[mmhs.FreeBig]));
    Add(Format('Unused           = %u',[mmhs.Unused]));
    Add(Format('Overhead         = %u',[mmhs.Overhead]));
    Add(Format('HeapErrorCode    = %u',[mmhs.HeapErrorCode]));
    Add(Format('FpcMaxHeapSize   = %u',[fphs.MaxHeapSize]));
    Add(Format('FpcMaxHeapUsed   = %u',[fphs.MaxHeapUsed]));
    Add(Format('FpcCurrHeapSize  = %u',[fphs.CurrHeapSize]));
    Add(Format('FpcCurrHeapUsed  = %u',[fphs.CurrHeapUsed]));
    Add(Format('FpcCurrHeapFree  = %u',[fphs.CurrHeapFree]));
   end;
   // SYSTEM resources
   if HasFlags(ResMonStatFlags,ResMonStatHandles) then begin
    Add('-----------------');
    Add('System resources:');
    Add('-----------------');
    {$IFDEF WINDOWS}
    hCnt:=0;
    Add(Format('GDI    objects = %8d     (of %8d max)',[GetGuiResources(GetCurrentProcess,GR_GDIOBJECTS),GetGdiProcessHandleQuota]));
    Add(Format('USER   objects = %8d     (of %8d max)',[GetGuiResources(GetCurrentProcess,GR_USEROBJECTS),GetUserProcessHandleQuota]));
    if GetProcessHandleCount(GetCurrentProcess,hCnt) then Add(Format('KERNEL objects = %8d     (of %8d max)',[hCnt,GetKernelProcessHandleQuota]));
    {$ENDIF ~WINDOWS}
    {$IFDEF UNIX}
    Add(Format('Process open files = %d',[ForEachProcPidFd(0,nil,nil)]));
    {$ENDIF ~UNIX}
   end;
   // Threads and processes
   CurrThreads:=0; TotalThreads:=0;
   if HasFlags(ResMonStatFlags,ResMonStatThreads) then begin
    // Child processes
    dp:=TTask.DetachedPidList.Count;
    cp:=ForEachStringLine(GetListOfProcesses(0,GetCurrentProcessId,''),nil,nil);
    Add(Format('Children Processes = %u, detached %u',[cp,dp]));
    // Threads
    TotalThreads:=GetNumberOfThreadsByPid(GetCurrentProcessId,CurrThreads,true);
    Add(Format('Number of Threads  = %u of total %u',[CurrThreads,TotalThreads]));
   end;
   // CPU usage
   CurrProcKTime:=0; CurrProcUTime:=0; CurrMainKTime:=0; CurrMainUTime:=0;
   CurrTickCount:=GetTickCount64;
   if (CurrTickCount>LastTickCount)
   and GetProcessTimesAsFileTime(CurrProcKTime,CurrProcUTime)
   and GetThreadTimesAsFileTime(CurrMainKTime,CurrMainUTime) then begin
    CpuProcKern:=Max(0,Min(100,0.01*(CurrProcKTime-LastProcKTime)/(CurrTickCount-LastTickCount)));
    CpuProcUser:=Max(0,Min(100,0.01*(CurrProcUTime-LastProcUTime)/(CurrTickCount-LastTickCount)));
    CpuProcSumm:=Max(0,Min(100,CpuProcKern+CpuProcUser));
    CpuMainKern:=Max(0,Min(100,0.01*(CurrMainKTime-LastMainKTime)/(CurrTickCount-LastTickCount)));
    CpuMainUser:=Max(0,Min(100,0.01*(CurrMainUTime-LastMainUTime)/(CurrTickCount-LastTickCount)));
    CpuMainSumm:=Max(0,Min(100,CpuMainKern+CpuMainUser));
    CpuOtheKern:=Max(0,Min(100,CpuProcKern-CpuMainKern));
    CpuOtheUser:=Max(0,Min(100,CpuProcUser-CpuMainUser));
    CpuOtheSumm:=Max(0,Min(100,CpuProcSumm-CpuMainSumm));
    CurrDrawKTime:=TimerActionsCpuKernLoad;
    CurrDrawUTime:=TimerActionsCpuUserLoad;
    CpuDrawKern:=Max(0,Min(100,0.01*(CurrDrawKTime-LastDrawKTime)/(CurrTickCount-LastTickCount)));
    CpuDrawUser:=Max(0,Min(100,0.01*(CurrDrawUTime-LastDrawUTime)/(CurrTickCount-LastTickCount)));
    CpuDrawSumm:=Max(0,Min(100,CpuDrawKern+CpuDrawUser));
    PostMsgRate:=1e3*(PostWindowsMessagesCount-LastPostMsg)/(CurrTickCount-LastTickCount);
    SentMsgRate:=1e3*(SentWindowsMessagesCount-LastSentMsg)/(CurrTickCount-LastTickCount);
    WndProcRate:=1e3*(TMasterFormWndProcCallCount-LastWndProc)/(CurrTickCount-LastTickCount);
    PostDpcRate:=1e3*(LockedGet(CrwdaqStatDPC.PostCount)-LastPostDpc)/(CurrTickCount-LastTickCount);
    HandDpcRate:=1e3*(LockedGet(CrwdaqStatDPC.HandCount)-LastHandDpc)/(CurrTickCount-LastTickCount);
    OnIdleRate:=1e3*(CurrOnIdleCounter-LastOnIdle)/(CurrTickCount-LastTickCount);
    prcl:=ProcessPriorityToClass(GetProcessPriority);
    prpr:=GetAbsolutePriority(prcl,tpNormal);
    prth:=GetCurrentThreadPriorityLevel;
   end else begin
    CurrTickCount:=0;
    CurrProcKTime:=0; CurrProcUTime:=0;
    CurrMainKTime:=0; CurrMainUTime:=0;
    CurrDrawKTime:=0; CurrDrawUTime:=0;
    CpuProcKern:=0;   CpuProcUser:=0;   CpuProcSumm:=0;
    CpuMainKern:=0;   CpuMainUser:=0;   CpuMainSumm:=0;
    CpuOtheKern:=0;   CpuOtheUser:=0;   CpuOtheSumm:=0;
    CpuDrawKern:=0;   CpuDrawUser:=0;   CpuDrawSumm:=0;
    PostMsgRate:=0;
    SentMsgRate:=0;
    WndProcRate:=0;
    PostDpcRate:=0;
    HandDpcRate:=0;
    OnIdleRate:=0;
    prcl:=0;
    prpr:=0;
    prth:=0;
   end;
   Add('-----------------');
   Add('Windows messages:');
   Add('-----------------');
   Add(Format('PostMessage rate = %9.2f msg/sec, Count = %u', [PostMsgRate,LastPostMsg]));
   Add(Format('SendMessage rate = %9.2f msg/sec, Count = %u', [SentMsgRate,LastSentMsg]));
   Add(Format('FormWndProc rate = %9.2f msg/sec, Count = %u', [WndProcRate,LastWndProc]));
   Add(Format('DPC Post    rate = %9.2f msg/sec, Count = %u', [PostDpcRate,LastPostDpc]));
   Add(Format('DPC Handle  rate = %9.2f msg/sec, Count = %u', [HandDpcRate,LastHandDpc]));
   Add(Format('App.OnIdle  rate = %9.2f msg/sec, Count = %u', [OnIdleRate,LastOnIdle]));
   Add('------------------');
   Add('CPU load, percent:');
   Add('------------------');
   prr:=Default(TPollingReportRec); prr.len:=21;
   FullPollingList.ForEach(PollingLeng,@prr.len); seplen:=Pad('',prr.len,'-');
   Add(Format('%-*.*s | %6.6s | %6.6s | %6.6s | %6.6s | %2.2s',[prr.len, prr.len, 'Process/Thread',       'Total',     'Kernel',    'User',      'Poll/s', 'Pr']));
   Add(Format('%-*.*s-|-%6.6s-|-%6.6s-|-%6.6s-|-%6.6s-|-%2.2s',[prr.len, prr.len, seplen,                 '------',    '------',    '------',    '------', '--']));
   Add(Format('%-*.*s | %6.2f | %6.2f | %6.2f | %6.6s | %2.2d',[prr.len, prr.len, 'Process, summary',     CpuProcSumm, CpuProcKern, CpuProcUser, '*',      prpr]));
   Add(Format('%-*.*s | %6.2f | %6.2f | %6.2f | %6.6s | %2.2d',[prr.len, prr.len, 'Main thread',          CpuMainSumm, CpuMainKern, CpuMainUser, '*',      prth]));
   Add(Format('%-*.*s | %6.2f | %6.2f | %6.2f | %6.6s | %2.2d',[prr.len, prr.len, 'Timer actions',        CpuDrawSumm, CpuDrawKern, CpuDrawUser, '*',      prth]));
   Add(Format('%-*.*s | %6.2f | %6.2f | %6.2f | %6.6s | %2.2d',[prr.len, prr.len, 'All Other Threads',    CpuOtheSumm, CpuOtheKern, CpuOtheUser, '*',      prpr]));
   FullPollingList.ForEach(PollingReport,@prr); snum:=Format(' (%d)',[prr.num]);
   Add(Format('%-*.*s | %6.2f | %6.2f | %6.2f | %6.0f | %2.2d',[prr.len, prr.len, 'Polling Threads'+snum, prr.sums,    prr.sumk,    prr.sumu,    prr.sumf, prpr]));
   Add(Format('%-*.*s---%6.6s---%6.6s---%6.6s---%6.6s---%2.2s',[prr.len, prr.len, seplen,                 '------',    '------',    '------',    '------', '--']));
   if HasFlags(ResMonStatFlags,ResMonStatThreads) then begin
    CurrPid:=GetCurrentProcessId; TotalProcesses:=WordCount(GetListOfProcesses(0,0,''),EolnDelims);
    if (TotalThreads=0) or (CurrThreads=0) then TotalThreads:=GetNumberOfThreadsByPid(CurrPid,CurrThreads,true);
    Add(Format('Process %d has %d of total %d threads in %d processes.',[CurrPid,CurrThreads,TotalThreads,TotalProcesses]));
   end;
   if (ResMonStatFlags<>ResMonStatDefault)
   then Add('Use "@polling monitor *" to view default counters.')
   else Add('Use "@polling monitor -1" to view all counters.');
   LastProcKTime:=CurrProcKTime;
   LastProcUTime:=CurrProcUTime;
   LastMainKTime:=CurrMainKTime;
   LastMainUTime:=CurrMainUTime;
   LastDrawKTime:=CurrDrawKTime;
   LastDrawUTime:=CurrDrawUTime;
   LastTickCount:=CurrTickCount;
   LastPostMsg:=PostWindowsMessagesCount;
   LastSentMsg:=SentWindowsMessagesCount;
   LastWndProc:=TMasterFormWndProcCallCount;
   LastPostDpc:=LockedGet(CrwdaqStatDPC.PostCount);
   LastHandDpc:=LockedGet(CrwdaqStatDPC.HandCount);
   LastOnIdle:=CurrOnIdleCounter;
  end else KillResourceMonitorConsole;
 except
  on E:Exception do BugReport(E,nil,'PollResourceMonitorConsole');
 end;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_unit_resourcemonitorconsole;
begin
 OnIdleActions.Add(Callback_OnIdleCounter);
end;

procedure Free_unit_resourcemonitorconsole;
begin
end;

initialization

 Init_unit_resourcemonitorconsole;

finalization

 Free_unit_resourcemonitorconsole;

end.

//////////////
// END OF FILE
//////////////

