//-------------------------- Condition Class ----------------------------------
#include "smixx_common.hxx"
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <vector>
using namespace std;
#include "namelist.hxx"
#include "condition.hxx"
#include "smpcondtyp1.hxx"
#include "smpcondtyp2.hxx"
#include "smpcondtyp3.hxx"
#include "smpcondtyp4.hxx"
#include "registrar.hxx"
#include "smiobject.hxx"
#include "alarm.hxx"
#include "options.hxx"
//------------------------- Externals -----------------------------------
extern Registrar allSMIObjectSets;
//
//                                                              B. Franek
//                                                             12-Aug-1996
// Copyright Information:
//      Copyright (C) 1996-2001 CCLRC. All Rights Reserved.
//-----------------------------------------------------------------------------

Condition::Condition (char lines[][MAXRECL], int *no_lines,
           SMIObject* pobj, State* pstat, Action* pact){
//-------------------------------------------------------------------------
// Input :
// lines[0] ....... the first line of the condition
// Output :
// no_lines ....... number of lines in the condition
//----------------------------------------------------------------------------

	_pParentObject = pobj;
	_pParentState  = pstat;
	_pParentAction = pact;
	
   int il;

   il = 0;
//   cout << "Condition: \n";
//   cout << lines[il] << "\n";
//   cout << lines[il+1] << "\n";

   strcpy(_condition,lines[il]);

//   cout << "Condition is |" << _condition << "|\n";

   il++;
   sscanf(lines[il],"%d %d",&_noOfSmpCond,&_noOfCondIns);
   assert (_noOfSmpCond >= 0);

   assert (_noOfCondIns >= 0);
   assert (_noOfCondIns < _maxCondIns); 

   il++;

	Name objNm; Name setNm;
	SmpCond* pSmpCond;

	if ( _noOfSmpCond > 0 ) {
		int typ;
		SmpCondTyp1* pType1; SmpCondTyp2* pType2;
		SmpCondTyp3* pType3; SmpCondTyp4* pType4; 
		int no_smpcond_lines;
		
		for (int ismp=0; ismp < _noOfSmpCond; ismp++) {

//         cout << lines[il] << "\n";
			sscanf(lines[il],"%d",&typ);
			if (typ == 1) {
	 			pType1 = new SmpCondTyp1(&lines[il],no_smpcond_lines,
				            _pParentAction);
				pSmpCond = pType1;
			}
			else if (typ == 2) {
	 			pType2 = new SmpCondTyp2(&lines[il],no_smpcond_lines,
				              _pParentAction);
				pSmpCond = pType2;
			}
			else if (typ == 3) {
	 			pType3 = new SmpCondTyp3(&lines[il],no_smpcond_lines,
				              _pParentAction);
				pSmpCond = pType3;
			}
			else if (typ == 4) {
	 			pType4 = new SmpCondTyp4(&lines[il],no_smpcond_lines,
				             _pParentObject, _pParentState, _pParentAction );
				pSmpCond = pType4;
			}

			else {
			Name temp = _pParentObject->name();
	 		cout << "  Object : " << temp 
			<< " illegal simple instructionb type " << endl;
			
			Alarm::message("FATAL",temp,"Initialising Condition");
			}
                        _smpConditions += pSmpCond;
			il = il + no_smpcond_lines;
		
		}
		
	}


   char condIns[MAXRECL];  
   char oper[4];   


   if ( _noOfCondIns > 0 ) {
      for (int icins=0; icins < _noOfCondIns; icins++) {
         strcpy(_condIns[icins],lines[il]);
//         sscanf(lines[il],"%s",_condIns[icins]);
         strcpy(condIns,_condIns[icins]);
         condIns[16] = '\0';
//         cout << condIns << "\n";
         decode_instruction(condIns, 
         oper, &_type1[icins], &_num1[icins], &_type2[icins], &_num2[icins]);
         strcpy(_oper[icins],oper);
//         cout << _oper[icins] << _type1[icins] << _num1[icins]
//              << _type2[icins] << _num2[icins] << " \n";
         il++;
      }
   }


  *no_lines = il;

// The following is just a test of simple condition function
//   if ( _noOfSmpCond > 0 ) {
//      cout << endl ;
//      for (int ismp=0; ismp < _noOfSmpCond; ismp++) {
//          pSmpCond = static_cast<SmpCond*>(_smpConditions[ismp]);
//	 cout << (pSmpCond->whatAreYou()).getString() << "\n";
//      }
//   }


  return ;
}  
//------------------- Destructor  BF Mar 2020  ------------------------
Condition::~Condition()
{
	SmpCond* pSmpCond;
	
	for ( int ismp = 0; ismp < _noOfSmpCond; ismp++) {
		pSmpCond = static_cast<SmpCond*>(_smpConditions[ismp]);
		delete pSmpCond;
	}
	
	return;
}
//=================================================================================
void Condition::whatAreYou(int maxStrLen, char* condString) {
//   cout << " Condition::whatAreYou   not implemented yet \n";
	int condStrLen = strlen(_condition);
	
	if ( condStrLen < maxStrLen )
	{
		strcpy(condString,_condition);
	}
	else
	{
		strncpy(condString,_condition,maxStrLen);
	}
	return ;
}

//---------------------------- evaluate -----------------------------------
int Condition::evaluate() {
//
    SmpCond* pSmpCond;
   int flag;
   int ismp;
   int icins;
   vector<int> smpflags;
   int smpflag;     
   int X[_maxCondIns];
	int allGhosts = 1;
//
   if ( _noOfSmpCond == 0 ) { 
#ifdef DEBUG
        cout << "    ELSE \n";
	    cout.flush();
#endif
        flag = 1;     // else evaluates always to true
        goto Fin;        
   }  
//

   for ( ismp = 0; ismp < _noOfSmpCond; ismp++) {
#ifdef DEBUG
         cout << "    T" << ismp+1 << ": " << endl;
#endif
         pSmpCond = static_cast<SmpCond*>(_smpConditions[ismp]);
         smpflag = pSmpCond->evaluate();
	 smpflags.push_back(smpflag);
#ifdef DEBUG
	cout << " evaluates to " << smpflags[ismp] << endl;
#endif
         if (smpflag == -1 ) { 
             flag = -1;
             goto Fin;
         }
	 if (smpflag != -2 ) {allGhosts = 0;} 
   }
//
   if (allGhosts == 1) {
       flag = -2;
       goto Fin;
   }

   if ( _noOfSmpCond == 1 ) {
      flag = smpflags[0];
      goto Fin;
   }


   int oprd1,oprd2;

#ifdef DEBUG
   cout << " \n";
   cout.flush();
#endif

   for ( icins=0; icins < _noOfCondIns; icins++) {
#ifdef DEBUG
        cout << "    " << _condIns[icins];
	    cout.flush();
#endif
        if (_type1[icins] == 'T') {
            oprd1 = smpflags[_num1[icins]-1];
        }
        else {
            oprd1 = X[_num1[icins]-1];
        }
        if (_type2[icins] == 'T') {
            oprd2 = smpflags[_num2[icins]-1];
        }
        else if (_type2[icins] == 'X') {
            oprd2 = X[_num2[icins]-1];
        }
        else { oprd2 = 0; }

	X[icins] = evalBool(_oper[icins],oprd1,oprd2);
#ifdef DEBUG
   cout << "  =  X(" << icins+1 << ")= " << X[icins] << "\n";
   cout.flush();
#endif
   }

   flag = X[_noOfCondIns-1];
   goto Fin;
//
//
   Fin:

	if (flag == -2) {
//debug beg
int dbg; Options::iValue("d",dbg);
if (dbg > 1 )
{
		cout << " Warning! Condition refers only to Ghosts" <<endl
		<< "will be taken as FALSE" << endl;
}
//debug end
		return 0;
	}

   if ( flag == 0 ) {
#ifdef DEBUG
        cout << "    Condition evaluates to FALSE \n";
	    cout.flush();
#endif
   }
   else if ( flag == 1 ) {
#ifdef DEBUG
        cout << "    Condition evaluates to TRUE \n";
	    cout.flush();
#endif
   }
   else if ( flag == -1 ) {
#ifdef DEBUG
        cout << "    Condition can not be evaluated \n";
	    cout.flush();
#endif
   }
   else {
   	Name temp = _pParentObject->name();
   	cout << " Object : " << temp << "  Condition::evaluate() " << endl;
        cout << "    Flag returned by Condition has illegal value :" << flag
             << endl;
        Alarm::message("FATAL",temp," Evaluating Condition....Internal error");
   }

#ifdef DEBUG
   cout << "\n";
   cout.flush();
#endif

   return flag;
}

//--------------------------   decode_instruction   ------------------------
void Condition::decode_instruction
     (char* instruction, 
      char* operation, char* type1, int *num1, char *type2, int *num2) {
//
//  Typical instruction looks like:
//
//0123456789012345..... cols
//and   T005  X056
//not   X003
char line[81];     // internal instruction

char operand1[5];  // T005
char operand2[5];  // X056

char operand1_num[4]; // 005
char operand2_num[4]; // 056

int instruction_len;
instruction_len = strlen(instruction);

if ( instruction_len  < 10 || instruction_len  > 80 ) {
     cout << " Condition instruction has illegal length :" 
          << "0123456789012345 \n"
          << instruction_len
          << endl;
   	Name temp = _pParentObject->name();
        Alarm::message("FATAL",temp," Initialisating....Internal error");
}
 
strcpy(line,instruction);


line[3]  = '\0';
strcpy(operation,line);

line[10] = '\0';
strcpy(operand1,&line[6]);

*type1 = operand1[0];
if( *type1 != 'T' &&  *type1 != 'X' ) {
    cout << " Condition instruction has illegal format :\n"
         << "0123456789012345 \n"
         << instruction << endl;
   	Name temp = _pParentObject->name();
        Alarm::message("FATAL",temp," Initialisating....Internal error");
}
strcpy(operand1_num,&operand1[1]);
sscanf(operand1_num,"%d",num1);


if ( !strcmp(operation,"and") || !strcmp(operation,"or ") ) {
     if ( instruction_len < 16 ) {
         cout << " Condition instruction has illegal format :\n"
              << "0123456789012345 \n"
              << instruction << endl;
 	     
   	Name temp = _pParentObject->name();
        Alarm::message("FATAL",temp," Initialisating....Internal error");
     }
     line[16] = '\0';
     strcpy(operand2,&line[12]);
     *type2 = operand2[0];
     if( *type2 != 'T' &&  *type2 != 'X' ) {
         cout << " Condition instruction has illegal format :\n"
              << "0123456789012345 \n"
              << instruction << endl;
   	Name temp = _pParentObject->name();
        Alarm::message("FATAL",temp," Initialisating....Internal error");
     }
     strcpy(operand2_num,&operand2[1]);
     sscanf(operand2_num,"%d",num2);
}
else if ( !strcmp(operation,"not") ) {
     *type2 = ' ';
     *num2 = 0;
}
else {
     cout << " Condition instruction has illegal format :\n"
          << "0123456789012345 \n"
          << instruction << endl;
   	Name temp = _pParentObject->name();
        Alarm::message("FATAL",temp," Initialisating....Internal error");
}

return;
}
//------------------------------------------------------------------
void Condition::freeze() {
    SmpCond* pSmpCond;
    
	for ( int ismp = 0; ismp < _noOfSmpCond; ismp++) {
	        pSmpCond = static_cast<SmpCond*>(_smpConditions[ismp]);
		pSmpCond->freeze();	
	}
	return;	
}
//------------------------------------------------------------------
void Condition::unfreeze() {
    SmpCond* pSmpCond;
    
	for ( int ismp = 0; ismp < _noOfSmpCond; ismp++) {
	        pSmpCond = static_cast<SmpCond*>(_smpConditions[ismp]);
		pSmpCond->unfreeze();	
	}
	return;	
}
//------------------------------- evalBool ------------------------- 
int Condition::evalBool
	(const char operation[],
		 const int operand1, const int operand2) const {
	if (strcmp(operation,"not") == 0) {
		if (operand1 == 1) {return 0;}
		if (operand1 == 0) {return 1;}
		assert (operand1==-2);
		return -2;
	}

	if (strcmp(operation,"or ") == 0) {
		if (operand1 == 1 || operand2 == 1)   {return 1;}
		if (operand1 == 0 && operand2 == 0)   {return 0;}
		if (operand1 == -2) {return operand2;}
		if (operand2 == -2) {return operand1;}
	}
	else if (strcmp(operation,"and") == 0) {
		if (operand1 == 0 || operand2 == 0)   {return 0;}
		if (operand1 == 1 && operand2 == 1)   {return 1;}
		if (operand1 == -2) {return operand2;}
		if (operand2 == -2) {return operand1;}
	}
	else {}

	cout << "*** Internal error" 
	<< " operation: |" << operation 
	<< "| " << operand1 << " " << operand2;
   	Name temp = _pParentObject->name();
        Alarm::message("FATAL",temp," Processing condition....Internal error");
	return 0;  // this to pacify some compilers
}
//----------------------------------------------  BF  Sep 2008  ------
bool Condition::isObjectDirectlyReferenced( const Name& objName) 
{
	SmpCond* pSmpCond;

	for ( int ismp = 0; ismp < _noOfSmpCond; ismp++)
	{
		pSmpCond = static_cast<SmpCond*>(_smpConditions[ismp]);
		if ( pSmpCond->objectName() == objName ) return true;
	}
	return false;	
}
//----------------------------------------------  BF  Sep 2008  ------
bool Condition::isObjectSetReferenced( const Name& objSetName) 
{
	SmpCond* pSmpCond;

	for ( int ismp = 0; ismp < _noOfSmpCond; ismp++)
	{
		pSmpCond = static_cast<SmpCond*>(_smpConditions[ismp]);
		if ( pSmpCond->objectSetName() == objSetName ) return true;
	}
	return false;
}
//---------------------------------------------- BF Sep 2008 --------
void Condition::removeObjectFromFrozenObjectSets( const Name& objName, const Name& setName)
{
	SmpCond* pSmpCond;
	SmpCondTyp2* pSmpCond2; SmpCondTyp3* pSmpCond3; 
    
	for ( int ismp = 0; ismp < _noOfSmpCond; ismp++)
	{
	        pSmpCond = static_cast<SmpCond*>(_smpConditions[ismp]);
		if ( pSmpCond->type() == 2 )
		{
			pSmpCond2 = static_cast<SmpCondTyp2*>(pSmpCond);
			pSmpCond2->removeObjectFromFrozenObjectSet( objName, setName);
		}
		if ( pSmpCond->type() == 3 )
		{
			pSmpCond3 = static_cast<SmpCondTyp3*>(pSmpCond);
			pSmpCond3->removeObjectFromFrozenObjectSet( objName, setName);
		}

	}
	return;	
}
//---------------------------------------------- BF Oct  2011 --------
void Condition::getCurrentRefObjects(NameList& currRefObjects) 
{
	currRefObjects.removeAll();

// First add directly referenced objects
	SmpCond* pSmpCond;
	
	for ( int ismp = 0; ismp < _noOfSmpCond; ismp++)
	{
		pSmpCond = static_cast<SmpCond*>(_smpConditions[ismp]);
		Name objNm = pSmpCond->objectName();
		if ( objNm == "" ) continue;	
		currRefObjects.add(objNm);
	}
	
// Now add all the objects referenced through the Object Sets
	
	Name objSetName; void* ptnv; SMIObjectSet* ptnSet;
	Name objInSet;
	
	// loop over the simple conditions picking up the sets
	for ( int ismp = 0; ismp < _noOfSmpCond; ismp++)
	{
		pSmpCond = static_cast<SmpCond*>(_smpConditions[ismp]);
		objSetName = pSmpCond->objectSetName();
		if ( objSetName == "" ) continue;
		ptnv = allSMIObjectSets.gimePointer(objSetName);
		if (ptnv == 0)
		{
			cout << "*** Set " << objSetName << " is not declared"
			<< endl;
   			Name temp = _pParentObject->name();
        		Alarm::message("FATAL",temp," Processing Condition....Set not declared");
		}
		ptnSet = static_cast<SMIObjectSet*>(ptnv);
		
		ptnSet->reset();
		while (ptnSet->nextObject(objInSet))
		{
			currRefObjects.add(objInSet);
		}
	}
	return;
}
//-----------------------------------------------------------------
void Condition::getDirectlyRefObjects(NameVector& directlyRefObjects) 
{
	SmpCond* pSmpCond;

	directlyRefObjects.reset();
	
	for ( int ismp = 0; ismp < _noOfSmpCond; ismp++)
	{
		pSmpCond = static_cast<SmpCond*>(_smpConditions[ismp]);
		Name objNm = pSmpCond->objectName();
		if ( objNm == "" ) continue;
		if ( directlyRefObjects.isPresent(objNm) ) continue;
		directlyRefObjects += objNm; 
	}

	return;
}
//-----------------------------------------------------------------------
void Condition::getRefObjectSets(NameVector& refObjectSets) 
{
	SmpCond* pSmpCond;
	
	refObjectSets.reset();

	for ( int ismp = 0; ismp < _noOfSmpCond; ismp++)
	{
		pSmpCond = static_cast<SmpCond*>(_smpConditions[ismp]);
		Name setNm = pSmpCond->objectSetName();
		if ( setNm == "" ) continue;
		if (refObjectSets.isPresent(setNm)) continue;
		refObjectSets += setNm;  // should be exclusive
	}
	return;
}
//-----------------------------------------------------
void Condition::selfTest()
{
	char condStr[256];


	whatAreYou(255,condStr);
	cout << endl << "****  Condition Self Test  *****" << endl;
	cout << " Condition: " << condStr << endl;
	 		
	NameList currRefObjects;
	NameVector dirRefObjects;
	NameVector refObjectSets;
	
	cout << " testing getCurrentRefObjects(NameList& currRefObjects) " << endl;
	getCurrentRefObjects(currRefObjects); currRefObjects.out(""); cout << endl;
	
	cout << " testing getDirectlyRefObjects(NameVector& dirRefObjects) " << endl;
	getDirectlyRefObjects(dirRefObjects); dirRefObjects.out(""); cout << endl;
	
	cout << " testing getRefObjectSets(NameVector& refObjectSets) " << endl;
	getRefObjectSets(refObjectSets); refObjectSets.out(""); cout << endl;

//---------------------
	char testobjs[8][3] = {"O1","O2","O3","O4","O5","O6","O7","O8"};
	char testsets[3][3] = {"S1","S2","S3"};
	Name objNm(""), setNm("");

	cout << " testing isObjectDirectlyReferenced" << endl;

	for (int i=0; i<8; i++)
	{
		objNm = testobjs[i];
		cout << objNm << "  " <<
		 isObjectDirectlyReferenced(objNm) << endl;
	}
	
	cout << " testing isObjectSetReferenced" << endl;

	for (int i=0; i<3; i++)
	{
		setNm = testsets[i];
		cout << setNm << "  " <<
		 isObjectSetReferenced(setNm) << endl;
	}
	
	return;
}
/*
//-----  Test main for decode_instruction-------------------
void main() {
char instruction[17];

char oper[4];

char typ1;
char typ2;

int num1;
int num2;


strcpy(instruction,"or    T002  X056");

cout << instruction << "\n";

decode_instruction (instruction, oper, &typ1, &num1, &typ2, &num2);

cout << " Operation : |" << oper << "| \n";

cout << " First  operand :  Type : |" << typ1 << "|  number : " << num1 << " \n";

cout << " Second operand :  Type : |" << typ2 << "|  number : " << num2 << " \n";

return 0;

}
*/
