@echo off
SetLocal EnableExtensions EnableDelayedExpansion

echo.
echo *****************************************************
echo CRW-DAQ script to install SMI to "CommonProgramFiles"
echo The script expected location is   Crw32exe\Resource\.
echo *****************************************************
echo.

:CheckAccessRights
call net session 1>nul 2>nul || ( echo Access denied. Admin rights required. & goto :EOF )

:SetDirectories
set "TargetDir=%CommonProgramFiles%\CRW-DAQ\Resource\SmiSite"
for %%i in ( "%~dp0\." ) do set "ScriptDir=%%~fi"
set "SourceDir=%ScriptDir%\SmiSite"
echo SourceDir=%SourceDir%
echo TargetDir=%TargetDir%

:CheckOpt_make_checksum
if /I "%~1" == "-m"              goto :MakeCheckSum
if /I "%~1" == "--make-checksum" goto :MakeCheckSum

:CompareVersion
if not exist "%TargetDir%\checksum.md5" goto :UpdateSmi
call fc /b "%SourceDir%\checksum.md5" "%TargetDir%\checksum.md5" 1>nul 2>nul || goto :UpdateSmi
call :PathCheckSum
set /a "UpdateFlag=0"
pushd "%TargetDir%" && ( call checksum -q || set /a "UpdateFlag=1" )
popd
if "%UpdateFlag%" == "1" goto :UpdateSmi
echo.
echo SMI version looks actual. No need to update.
echo.
goto :EOF

:UpdateSmi
echo.
echo SMI should be updated.
echo.
call :SmiTaskKill
call :SmiRemove
call :SmiCopy
goto :EOF

:MakeCheckSum
if not defined SourceDir goto :EOF
if not exist "%SourceDir%" goto :EOF
pushd "%SourceDir%" && call :ExecCheckSum
popd
goto :EOF

:PathCheckSum
call checksum --help 1>nul 2>nul || if defined CRW_DAQ_SYS_HOME_DIR path %CRW_DAQ_SYS_HOME_DIR%\Resource\Shell;%path%
call checksum --help 1>nul 2>nul || if defined CRW_DAQ_SYS_HOME_DIR path %CRW_DAQ_SYS_HOME_DIR%;%path%
call checksum --help 1>nul 2>nul || if defined UnixRoot path %UnixRoot%\add\bin;%path%
goto :EOF

:ExecCheckSum
echo.
echo Making SMI checksum...
echo cd %cd%
echo.
call :PathCheckSum
if exist checksum.md5 del /f /q checksum.md5
set exclude=tmp\ *.ini
set include=*.exe *.dll *.bat *.cmd
call checksum -r -mchecksum %include% -e %exclude% >nul
call checksum -r -mintegrity * -e %exclude% >nul
type checksum.md5
goto :EOF

:SmiTaskKill
echo.
echo Kill SMI processes...
echo.
call :TaskKill smism.exe smigen.exe smitrans.exe monobjects.exe monobjectstate.exe
goto :EOF

:TaskKill
if "%~1" == "" goto :EOF
echo Try to kill task %1 ...
set /a "ntask=0"
for /f "tokens=1" %%i in ('tasklist /nh /fi "imagename eq %~1" 2^>nul') do if /i "%%i" == "%~1" set /a "ntask=1"
if "%ntask%" == "1" ( call taskkill /im %1 || call taskkill /f /im %1 )
if "%ntask%" == "0" ( echo Task %1 is not rinning. )
shift /1 & goto :TaskKill
goto :EOF

:SmiRemove
if not defined TargetDir goto :EOF
if not exist "%TargetDir%" goto :EOF
echo.
echo Remove SMI from "%TargetDir%"...
echo.
call rmdir /q /s "%TargetDir%" && ( echo Success. & goto :EOF )
echo Failure.
goto :EOF

:SmiCopy
if not defined TargetDir goto :EOF
echo.
echo Copy SMI to "%TargetDir%" ...
echo.
if not exist "%TargetDir%" mkdir "%TargetDir%"
call xcopy /d /s /v /c /i /y "%SourceDir%\*" "%TargetDir%"
goto :EOF
