////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user plugin.  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// crwdaq data analysis plugin.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241030 - Sample created by A.K.                                          //
// 20241104 - Translated from DPR source by A.K.                              //
////////////////////////////////////////////////////////////////////////////////

{
[Manual.Rus]
Этот ТЕСТ возбуждает исключения EAccessViolation.
Он служит для проверки системы защиты и обработки исключений.
[]
[Manual.Eng]
This TEST generates EAccessViolation exceptions.
Uses just to test Structured Exception Handling.
[]
}

library test_eaccessviolation;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math, graphics,
 _crw_crwapi;

/////////////////////////////////////////////////////////
{$I _crw_plugin_declare.inc} // Declare CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:ICrwApi):Integer;     //
/////////////////////////////////////////////////////////
var i,n:integer;
begin
 Result:=0; n:=0;
 with CrwApi,SysApi,GuiApi,DanApi do
 try
  RedirectStdIn(Input);
  RedirectStdOut(Output);
  writeln('This TEST generates ACCESS VIOLATION exceptions.');
  writeln('Uses just to test Structured Exception Handling.');
  //
  // !!! There expected to be EAccessViolation !!!
  //
  i:=PInteger(MaxInt)^;    // There expected exception.
  inc(n); writeln('i=',i); // This code should not run.
 finally
  if n=0
  then writeln('Exception raised.')
  else writeln('Exception passed.');
 end;
end;

/////////////////////////////////////////////////////////
{$I _crw_plugin_exports.inc} // Exports CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID;        //
/////////////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////
 
