////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user plugin.  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// crwdaq data analysis plugin.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241030 - Sample created by A.K.                                          //
// 20241104 - Translated from DPR source by A.K.                              //
////////////////////////////////////////////////////////////////////////////////

{
[Manual.Rus]
Демонстрационный пример вывода сообщений на консоль и в окно.
Тест для функций минимизации.
[]
[Manual.Eng]
Demo for console and dialog window output.
[]
[Arguments.Rus]
Аргумент1 = 1
Аргумент2 = 2
[]
[Arguments.Eng]
Argument1 = 1
Argument2 = 2
[]
}

library test_000;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math, graphics,
 _crw_crwapi;

function f1(x:double; Custom:Pointer):double;
begin
 Result:=x*(x*x-2)-5;
end;

function f2(x:double; Custom:Pointer):double;
begin
 if x<>0.0 then Result:=sin(x)/x else Result:=1.0;
end;

procedure Test_zm(Api:ICrwApi);
VAR NOFUN:INTEGER; A,B,RESULT,RELERR,ABSERR,ERREST,FLAG:DOUBLE;
begin
 with Api,SysApi,GuiApi do begin
  writeln('Test macheps = ',MachEps);
  writeln('Test FindZero: expected 2.0945514815');
  writeln('Result:',FindZero(f1,2,3,MachEps,nil):16:14);
  writeln('Test FindMin: expected 0.81650');
  writeln('Result:',FindMin(f1,0,1,sqrt(MachEps),nil):16:14);
  writeln('Test QUANC8:expected RESULT=1.6054129768,FLAG=0');
  A:=0.0;
  B:=2.0;
  RELERR:=1.0E-10;
  ABSERR:=0.0;
  RESULT:=QUANC8(f2,A,B,ABSERR,RELERR,ERREST,NOFUN,FLAG,nil);
  WRITELN('RESULT=',RESULT:16:14);
  WRITELN('ERREST=',ERREST);
  IF(FLAG<>0.0) THEN WRITELN('FLAG=',FLAG);
 end;
end;

/////////////////////////////////////////////////////////
{$I _crw_plugin_declare.inc} // Declare CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:ICrwApi):Integer;     //
/////////////////////////////////////////////////////////
const
 swin = +1; // Source window reference
 twin = -1; // Target window reference
 cwin =  0; // Clipboard window reference
var i:integer; r:double; p:Pointer;
begin
 Result:=0;
 with CrwApi,SysApi,GuiApi,DanApi do
 try
  RedirectStdIn(Input);
  RedirectStdOut(Output);
  VerifyPluginDate(CrwApiEdition,Version);
  VerifyPluginType(Target,ForDataAnalysis);
  writeln(Format('%s',['Hello from DLL! :-)']));
  //exit;
  Test_zm(CrwApi);
  try
   i:=0;
   r:=ln(i);
   writeln(Format('%g',[r]));
  except
   on E:Exception do writeln('dll:',E.Message);
  end;
  i:=0;
  r:=ln(i);
  writeln(Format('%g',[r]));
  writeln('isNan=',isNan(r));
  writeln('isInf=',isInf(r));
  writeln(trunc(ln(-1)));
  Warning('Привет из DLL!');
  p:=Allocate(1024);
  Information(Format('%d',[AllocSize(P)]));
  Deallocate(p);
  writeln(GetDateStr(msecnow)+'-'+GetTimeStr(msecnow));
  writeln(ExtractTextSection(SysIniFile,'[System]',0));
  writeln(ProgName);
  writeln(GetWindowsShellFolder('Desktop'));
  writeln(GetWindowsShellDesktop);
  writeln(GetWindowsShellPrograms);
  writeln(GetWindowsShellStartup);
  writeln(GetWindowsShellStartMenu);
  writeln(GetWindowsShellFavorites);
  writeln(GetWindowsShellFonts);
  writeln(GetWindowsShellHistory);
  writeln(GetWindowsShellPersonal);
  writeln(GetWindowsShellSendTo);
  //CreateFileLink(ProgName,AddBackSlash(GetWindowsShellDesktop)+'CRW32_LINK.LNK','CRW32-DAQ','');
  //CreateFileLink(ProgName,AddBackSlash(GetWindowsShellPrograms)+'CRW32_LINK','CRW32-DAQ','');
 except
  on E:Exception do begin
   if WindowExists(twin) then CurvesCount[twin]:=0;
   Echo(PluginName+RusEng(': ОШИБКА!',': ERROR!')); 
   if UsesBlaster then Voice('EXCEPTION');
   Echo(E.Message); Error(E.Message);
   Result:=-1;
  end;
 end;
end;

/////////////////////////////////////////////////////////
{$I _crw_plugin_exports.inc} // Exports CRWDAQ_PLUGIN. //
/////////////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID;        //
/////////////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////
 
