@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

rem Usage: _root_hist_1d.cmd file.dat
rem Prepare environment for call ROOT
rem Then call ROOT, wait and show GIF

set scriptbase=%~n0
set scriptname=%~nx0
set date_exe=%CRW_DAQ_SYS_HOME_DIR%\resource\shell\date.exe
set send2crwdaq=%CRW_DAQ_SYS_HOME_DIR%\resource\shell\send2crwdaq.exe

:CheckArguments
if "%~1" == "" goto :EOF

call :ShowProgressBar

:Prepare_logFile
set logFile=%~dpn1.log
call :DeleteFile "!logFile!"

:Prepare_datFile
set datFile=%~1

:Prepare_gifFile
set gifFile=%~dpn1.gif
call :DeleteFile "!gifFile!"

:Greetings
echo !Date!-!Time!:       | unix tee -a "!logFile!"
echo Command: "%~f0"      | unix tee -a "!logFile!"
echo Argument: "%~1"      | unix tee -a "!logFile!"
echo StartDir: "!cd!"     | unix tee -a "!logFile!"
echo logFile: "!logFile!" | unix tee -a "!logFile!"
echo datFile: "!datFile!" | unix tee -a "!logFile!"
echo gifFile: "!gifFile!" | unix tee -a "!logFile!"

:Main
for %%i in ("%~dp0.") do (
 echo HomeDir: "%%~fi" | unix tee -a "!logFile!"
 pushd "%%~fi" && (
  echo WorkDir: "!cd!" | unix tee -a "!logFile!"
  call :ExecuteRoot
  call :WaitForFile "!gifFile!" 5
  if exist "!gifFile!" (
   rem gifFile exists, SUCCESS.
   call :ViewFile "!gifFile!"
   unix sleep 1
   call :ShowReportOnSuccess
   call :DeleteFile "!datFile!"
  ) else (
   rem gifFile is not ready, ERROR.
   call :ShowReportOnError
   call :DeleteFile "!datFile!"
  )
 ) & popd
)
call :HideProgressBar
goto :EOF

:ExecuteRoot
rem Execute ROOT data analysis.
rem Uses datFile,gifFile,logFile
SetLocal EnableExtensions EnableDelayedExpansion
rem Repalce \ to / as need for ROOT file names
set datFile=%datFile:\=/%
set gifFile=%gifFile:\=/%
echo datFile: "!datFile!" | unix tee -a "!logFile!"
echo gifFile: "!gifFile!" | unix tee -a "!logFile!"
echo.                     | unix tee -a "!logFile!"
echo Now execute ROOT ... | unix tee -a "!logFile!"
unix root -l -b -x -q %~n0.C 2>&1 | unix tee -a "!logFile!"
echo.                     | unix tee -a "!logFile!"
EndLocal
goto :EOF

:DeleteFile
rem Usage: call :DeleteFile "filename"
rem Check if file exists and delete file.
if "%~1" == "" goto :EOF
if not exist "%~1" goto :EOF
unix rm -f "%~1"
goto :EOF

:ViewFile
rem Usage: call :ViewFile "filename"
rem Check if file exists and delete file.
if "%~1" == "" goto :EOF
if not exist "%~1" goto :EOF
unix start "View %~1" imagine "%~1"
goto :EOF

:Speak
if "%~1" == "" goto :EOF
unix grun -7 spvoice --voice 1 "%~1"
goto :EOF

:WaitForFile
rem Usage: call :WaitForFile FileName TimeoutSec
rem Wait until file exist or timeout
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if exist "%~1" goto :EOF
SetLocal
set /a n=%~2 & if "!n!" GTR "0" ( unix sleep 1 & set /a n=!n!-1 & call :WaitForFile "%~1" !n! )
EndLocal
goto :EOF

:GetDateTime
for /f "tokens=* delims=" %%i in ('%date_exe% +%%Y.%%m.%%d-%%H.%%M.%%S') do set datetime=%%i
goto :EOF

:ShowProgressBar
unix saferun wbusy "CRW-DAQ: Wait for %~n0..." "%~n0 is running, please wait..." /marquee
goto :EOF

:HideProgressBar
unix saferun wbusy "CRW-DAQ: Wait for %~n0..." /stop /sound
goto :EOF

:ShowReportOnSuccess
echo.                 | unix tee -a "!logFile!"
echo Result: SUCCESS. | unix tee -a "!logFile!"
echo.                 | unix tee -a "!logFile!"
call :Speak "The histogram calculations is succeeded."
if exist "!logFile!" start "View !logFile!" unix cat "!logFile!" ^& waitkey 60 "" "Press any key to continue..."
call :GetDateTime
unix grun -7 unix tooltip-notifier text "%datetime% => %scriptname%: Data analysis done - SUCCESS." preset stdOk delay 30000
unix printf "@silent @echo %datetime% => %scriptname%: Data analysis done - SUCCESS.\n" | unix u2d | unix %send2crwdaq%
unix printf "@silent @tty close 0\n" | unix u2d | unix %send2crwdaq%
goto :EOF

:ShowReportOnError
echo.               | unix tee -a "!logFile!"
echo Result: ERROR. | unix tee -a "!logFile!"
echo.               | unix tee -a "!logFile!"
call :Speak "The histogram calculations is failed."
if exist "!datFile!" start "View !datFile!" unix head -n 20 "!datFile!" ^& waitkey 60 "" "Press any key to continue..."
unix sleep 1
if exist "!logFile!" start "View !logFile!" unix cat "!logFile!" ^& waitkey 60 "" "Press any key to continue..."
unix sleep 1
unix wprompt "Error^!" "Could not process !datFile!" Ok 1:10 x
call :GetDateTime
unix grun -7 unix tooltip-notifier text "%datetime% => %scriptname%: Data analysis done - FAILS." preset stdOk delay 60000
unix printf "@silent @echo %datetime% => %scriptname%: Data analysis done - FAILS.\n" | unix u2d | unix %send2crwdaq%
unix printf "@silent @tty close 0\n" | unix u2d | unix %send2crwdaq%
goto :EOF
