---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Unicode Table - mostly used, by themes

Unicode Table: **[Mostly used symbols](https://github.com/artickl/Unicode_Table)**

Based on file from Mike-M on https://habr.com/ru/company/itelma/blog/549366/#comment_22859446

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## PUNCTUATION

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	NB SP	|	\&#0160;	|	U+00A0	|	\&nbsp;	|	no-break space (Alt+255, Ctrl+Shift+Space)	|
|	NNB SP	|	\&#8239;	|	U+202F	|	—	|	narrow no-break space (thousands group separator)	|
|	«	|	\&#0171;	|	U+00AB	|	\&laquo;	|	left-pointing double angle quotation mark	|
|	»	|	\&#0187;	|	U+00BB	|	\&raquo;	|	right-pointing double angle quotation mark	|
|	“	|	\&#8220;	|	U+201C	|	\&ldquo;	|	left double quotation mark (preferred in English)	|
|	”	|	\&#8221;	|	U+201D	|	\&rdquo;	|	right double quotation mark (preferred in English)	|
|	’	|	\&#8217;	|	U+2019	|	\&rsquo;	|	right single quotation mark (preferred for apostrophe)	|
|	′	|	\&#8242;	|	U+2032	|	\&prime;	|	prime (minutes, feet)	|
|	″	|	\&#8243;	|	U+2033	|	\&Prime;	|	double prime (seconds, inches)	|
|	́	|	\&#0769;	|	U+0301	|	—	|	combining acute accent (Alt+0769 after the letter)	|
|	‒	|	\&#8210;	|	U+2012	|	—	|	figure dash (used in phone numbers)	|
|	–	|	\&#8211;	|	U+2013	|	\&ndash;	|	en dash	|
|	—	|	\&#8212;	|	U+2014	|	\&mdash;	|	em dash	|
|	…	|	\&#8230;	|	U+2026	|	\&hellip;	|	horizontal ellipsis (three dot leader)	|
|	❕	|	\&#10069;	|	U+2755	|	—	|	white exclamation mark ornament	|
|	❗	|	\&#10071;	|	U+2757	|	—	|	heavy exclamation mark symbol (obstacles on road)	|
|	❔	|	\&#10068;	|	U+2754	|	—	|	white question mark ornament	|
|	❓	|	\&#10067;	|	U+2753	|	—	|	black question mark ornament	|
|	🯄-	|	\&#129988;	|	U+1FBC4	|	—	|	negative squared question mark	|
|	❘	|	\&#10072;	|	U+2758	|	\&VerticalSeparator;	|	light vertical bar	|
|	❙	|	\&#10073;	|	U+2759	|	—	|	medium vertical bar	|
|	❚	|	\&#10074;	|	U+275A	|	—	|	heavy vertical bar	|
|	¶	|	\&#0182;	|	U+00B6	|	\&para;	|	pilcrow (paragraph) sign	|
|	§	|	\&#0167;	|	U+00A7	|	\&sect;	|	section sign	|
|	№	|	\&#8470;	|	U+2116	|	\&numero;	|	numero sign	|
|	‰	|	\&#8240;	|	U+2030	|	\&permil;	|	per mille sign (permille, per thousand; alcohol in blood)	|
|	˽	|	\&#0765;	|	U+02FD	|	—	|	modifier letter shelf	|

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Currency, Money

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	₽	|	\&#8381;	|	U+20BD	|	—	|	ruble	|
|	€	|	\&#8364;	|	U+20AC	|	\&euro;	|	euro	|
|	¢	|	\&#0162;	|	U+00A2	|	\&cent;	|	cent	|
|	£	|	\&#0163;	|	U+00A3	|	\&pound;	|	pound	|
|	¥	|	\&#0165;	|	U+00A5	|	\&yen;	|	yen	|
|	₿	|	\&#8383;	|	U+20BF	|	—	|	bitcoin	|
|	¤	|	\&#0164;	|	U+00A4	|	\&curren;	|	currency sign	|
|	🪙-	|	\&#129689;	|	U+1FA99	|	—	|	coin	|
|	💱	|	\&#128177;	|	U+1F4B1	|	—	|	currency exchange	|
|	🏧	|	\&#127975;	|	U+1F3E7	|	—	|	automated teller machine (ATM)	|
|	💰	|	\&#128176;	|	U+1F4B0	|	—	|	money bag (may show any currency symbol)	|
|	💳	|	\&#128179;	|	U+1F4B3	|	—	|	credit card	|
|	💵	|	\&#128181;	|	U+1F4B5	|	—	|	banknote with dollar sign	|
|	💶	|	\&#128182;	|	U+1F4B6	|	—	|	banknote with euro sign	|
|	🧾	|	\&#129534;	|	U+1F9FE	|	—	|	receipt	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Bullets (also see Check Marks, Hand Symbols, Geometric Shapes)

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	•	|	\&#8226;	|	U+2022	|	\&bullet;	|	bullet	|
|	◦	|	\&#9702;	|	U+25E6	|	—	|	white bullet	|
|	◉	|	\&#9673;	|	U+25C9	|	—	|	fisheye (tainome, Japanese, a kind of bullet)	|
|	⦿	|	\&#10687;	|	U+29BF	|	\&ofcir;	|	circled bullet	|
|	▪	|	\&#9642;	|	U+25AA	|	\&FilledVerySmallSquare;	|	black small square (square bullet)	|
|	⁃	|	\&#8259;	|	U+2043	|	\&hybull;	|	hyphen bullet	|
|	‣	|	\&#8227;	|	U+2023	|	—	|	triangular bullet	|
|	⁍	|	\&#8269;	|	U+204D	|	—	|	black rightwards bullet	|
|	❯	|	\&#10095;	|	U+276F	|	—	|	heavy right-pointing angle quotation mark ornament	|
|	⁕	|	\&#8277;	|	U+2055	|	—	|	flower punctuation mark (phul, puspika)	|
|	❋	|	\&#10059;	|	U+274B	|	—	|	heavy eight teardrop-spoked propeller asterisk	|
|	✱	|	\&#10033;	|	U+2731	|	—	|	heavy asterisk	|
|	🞵	|	\&#128949;	|	U+1F7B5	|	—	|	light six spoked asterisk	|
|	🞶	|	\&#128950;	|	U+1F7B6	|	—	|	medium six spoked asterisk ("star" on phone devices)	|
|	🞷	|	\&#128951;	|	U+1F7B7	|	—	|	bold six spoked asterisk	|
|	🞸	|	\&#128952;	|	U+1F7B8	|	—	|	heavy six spoked asterisk	|
|	🞹	|	\&#128953;	|	U+1F7B9	|	—	|	very heavy six spoked asterisk	|
|	🞺	|	\&#128954;	|	U+1F7BA	|	—	|	extremely heavy six spoked asterisk	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Check Marks and Ballots

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	✓	|	\&#10003;	|	U+2713	|	\&checkmark;	|	check mark	|
|	🗸	|	\&#128504;	|	U+1F5F8	|	—	|	light check mark (check)	|
|	🮱-	|	\&#129969;	|	U+1FBB1	|	—	|	inverse check mark	|
|	🗹	|	\&#128505;	|	U+1F5F9	|	—	|	ballot box with bold check	|
|	☑	|	\&#9745;	|	U+2611	|	—	|	ballot box with check	|
|	✅	|	\&#9989;	|	U+2705	|	—	|	white heavy check mark (green tick)	|
|	✔	|	\&#10004;	|	U+2714	|	—	|	heavy check mark	|
|	❎	|	\&#10062;	|	U+274E	|	—	|	negative squared cross mark	|
|	🮽-	|	\&#129981;	|	U+1FBBD	|	—	|	negative diagonal cross (diagonals extended unlike ❎)	|
|	✗	|	\&#10007;	|	U+2717	|	\&cross;	|	ballot X	|
|	✘	|	\&#10008;	|	U+2718	|	—	|	heavy ballot X	|
|	🗶	|	\&#128502;	|	U+1F5F6	|	—	|	ballot bold script X	|
|	🗴	|	\&#128500;	|	U+1F5F4	|	—	|	ballot script X (x mark)	|
|	🗵	|	\&#128501;	|	U+1F5F5	|	—	|	ballot box with script X	|
|	🗷	|	\&#128503;	|	U+1F5F7	|	—	|	ballot box with bold script X	|
|	☒	|	\&#9746;	|	U+2612	|	—	|	ballot box with X	|
|	⮿	|	\&#11199;	|	U+2BBF	|	—	|	circled bold X	|
|	❌	|	\&#10060;	|	U+274C	|	—	|	cross mark (forms a game tally pair with ⭕)	|
|	🯀-	|	\&#129984;	|	U+1FBC0	|	—	|	white heavy saltire with rounded corners	|
|	🞨	|	\&#128936;	|	U+1F7A8	|	—	|	thin saltire	|
|	🞩	|	\&#128937;	|	U+1F7A9	|	—	|	light saltire	|
|	🞪	|	\&#128938;	|	U+1F7AA	|	—	|	medium saltire	|
|	🞫	|	\&#128939;	|	U+1F7AB	|	—	|	bold saltire	|
|	🞬	|	\&#128940;	|	U+1F7AC	|	—	|	heavy saltire	|
|	🞭	|	\&#128941;	|	U+1F7AD	|	—	|	very heavy saltire	|
|	🞮	|	\&#128942;	|	U+1F7AE	|	—	|	extremely heavy saltire	|
|	🗳	|	\&#128499;	|	U+1F5F3	|	—	|	ballot box with ballot (vote)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Intellectual Property

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	©	|	\&#0169;	|	U+00A9	|	\&copy;	|	copyright sign	|
|	®	|	\&#0174;	|	U+00AE	|	\&circledR;	|	registered sign	|
|	℗	|	\&#8471;	|	U+2117	|	\&copysr;	|	sound recording copyright (published)	|
|	™	|	\&#8482;	|	U+2122	|	\&trade;	|	trade mark sign	|
|	🕲	|	\&#128370;	|	U+1F572	|	—	|	no piracy	|
|	🄍-	|	\&#127245;	|	U+1F10D	|	—	|	circled zero with slash (no rights reserved)	|
|	🄎-	|	\&#127246;	|	U+1F10E	|	—	|	circled anticlockwise arrow (share alike)	|
|	🄏-	|	\&#127247;	|	U+1F10F	|	—	|	circled crossed dollar sign (non commercial)	|
|	🄯-	|	\&#127279;	|	U+1F12F	|	—	|	copyleft symbol	|
|	🅭-	|	\&#127341;	|	U+1F16D	|	—	|	circled cc (Creative Commons license)	|
|	🅮-	|	\&#127342;	|	U+1F16E	|	—	|	circled c with overlaid backslash (public domain)	|
|	🅯-	|	\&#127343;	|	U+1F16F	|	—	|	circled human figure (attribution, credit)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## EMOTICONS

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	—	|	\&#8205;	|	U+200D	|	\&zwj;	|	Zero Width Joiner: 👩200D✈ = 👩‍✈ (type 200D in the middle and press Alt+X)	|
|	😉	|	\&#128521;	|	U+1F609	|	—	|	winking face	|
|	🙂	|	\&#128578;	|	U+1F642	|	—	|	slightly smiling face	|
|	☺	|	\&#9786;	|	U+263A	|	—	|	white smiling face (have a nice day!)	|
|	😊	|	\&#128522;	|	U+1F60A	|	—	|	smiling face with smiling eyes	|
|	🤭	|	\&#129325;	|	U+1F92D	|	—	|	smiling face with smiling eyes & hand covering mouth	|
|	😃	|	\&#128515;	|	U+1F603	|	—	|	smiling face with open mouth	|
|	😄	|	\&#128516;	|	U+1F604	|	—	|	smiling face with open mouth and smiling eyes	|
|	😅	|	\&#128517;	|	U+1F605	|	—	|	smiling face with open mouth and cold sweat	|
|	😂	|	\&#128514;	|	U+1F602	|	—	|	face with tears of joy	|
|	🥲-	|	\&#129394;	|	U+1F972	|	—	|	smiling face with tear	|
|	🤣	|	\&#129315;	|	U+1F923	|	—	|	rolling on the floor laughing (rofl, rotfl)	|
|	😆	|	\&#128518;	|	U+1F606	|	—	|	smiling face with open mouth and tightly-closed eyes	|
|	😎	|	\&#128526;	|	U+1F60E	|	—	|	smiling face with sunglasses	|
|	😇	|	\&#128519;	|	U+1F607	|	—	|	smiling face with halo	|
|	😏	|	\&#128527;	|	U+1F60F	|	—	|	smirking face	|
|	😀	|	\&#128512;	|	U+1F600	|	—	|	grinning face	|
|	🤩	|	\&#129321;	|	U+1F929	|	—	|	grinning face with star eyes	|
|	😁	|	\&#128513;	|	U+1F601	|	—	|	grinning face with smiling eyes	|
|	🤪	|	\&#129322;	|	U+1F92A	|	—	|	grinning face with one large and one small eye	|
|	😬	|	\&#128556;	|	U+1F62C	|	—	|	grimacing face (should not be depicted with 🤐)	|
|	😛	|	\&#128539;	|	U+1F61B	|	—	|	face with stuck-out tongue	|
|	😜	|	\&#128540;	|	U+1F61C	|	—	|	face with stuck-out tongue and winking eye (kidding)	|
|	😤	|	\&#128548;	|	U+1F624	|	—	|	face with look of triumph (triumph, not anger)	|
|	😌	|	\&#128524;	|	U+1F60C	|	—	|	relieved face (indicates relief, not sleeping)	|
|	🥱	|	\&#129393;	|	U+1F971	|	—	|	yawning face	|
|	🤔	|	\&#129300;	|	U+1F914	|	—	|	thinking face	|
|	🤨	|	\&#129320;	|	U+1F928	|	—	|	face with one eyebrow raised	|
|	😕	|	\&#128533;	|	U+1F615	|	—	|	confused face	|
|	😳	|	\&#128563;	|	U+1F633	|	—	|	flushed face (embarrassed)	|
|	😟	|	\&#128543;	|	U+1F61F	|	—	|	worried face	|
|	😵	|	\&#128565;	|	U+1F635	|	—	|	dizzy face	|
|	😲	|	\&#128562;	|	U+1F632	|	—	|	astonished face	|
|	🤯	|	\&#129327;	|	U+1F92F	|	—	|	shocked face with exploding head	|
|	😞	|	\&#128542;	|	U+1F61E	|	—	|	disappointed face	|
|	😥	|	\&#128549;	|	U+1F625	|	—	|	disappointed but relieved face	|
|	😔	|	\&#128532;	|	U+1F614	|	—	|	pensive face (sorrowful)	|
|	🥺	|	\&#129402;	|	U+1F97A	|	—	|	face with pleading eyes	|
|	🙁	|	\&#128577;	|	U+1F641	|	—	|	slightly frowning face	|
|	☹	|	\&#9785;	|	U+2639	|	—	|	white frowning face	|
|	😦	|	\&#128550;	|	U+1F626	|	—	|	frowning face with open mouth (not shocked/surprised)	|
|	😣	|	\&#128547;	|	U+1F623	|	—	|	persevering face	|
|	😠	|	\&#128544;	|	U+1F620	|	—	|	angry face	|
|	😖	|	\&#128534;	|	U+1F616	|	—	|	confounded face	|
|	😡	|	\&#128545;	|	U+1F621	|	—	|	pouting face (depicts pouting rather than anger)	|
|	🤬	|	\&#129324;	|	U+1F92C	|	—	|	serious face with symbols covering mouth	|
|	😈	|	\&#128520;	|	U+1F608	|	—	|	smiling face with horns (smiling version of 👿)	|
|	👿	|	\&#128127;	|	U+1F47F	|	—	|	imp	|
|	😨	|	\&#128552;	|	U+1F628	|	—	|	fearful face	|
|	😱	|	\&#128561;	|	U+1F631	|	—	|	face screaming in fear	|
|	😢	|	\&#128546;	|	U+1F622	|	—	|	crying face	|
|	😭	|	\&#128557;	|	U+1F62D	|	—	|	loudly crying face	|
|	🤗	|	\&#129303;	|	U+1F917	|	—	|	hugging face	|
|	🫂-	|	\&#129730;	|	U+1FAC2	|	—	|	people hugging	|
|	😗	|	\&#128535;	|	U+1F617	|	—	|	kissing face	|
|	😙	|	\&#128537;	|	U+1F619	|	—	|	kissing face with smiling eyes	|
|	😚	|	\&#128538;	|	U+1F61A	|	—	|	kissing face with closed eyes	|
|	😘	|	\&#128536;	|	U+1F618	|	—	|	face throwing a kiss	|
|	😍	|	\&#128525;	|	U+1F60D	|	—	|	smiling face with heart-shaped eyes	|
|	🥰	|	\&#129392;	|	U+1F970	|	—	|	smiling face with smiling eyes and three hearts	|
|	💏	|	\&#128143;	|	U+1F48F	|	—	|	kiss (two people kissing)	|
|	💑	|	\&#128145;	|	U+1F491	|	—	|	couple with heart	|
|	🙄	|	\&#128580;	|	U+1F644	|	—	|	face with rolling eyes	|
|	😧	|	\&#128551;	|	U+1F627	|	—	|	anguished face	|
|	😫	|	\&#128555;	|	U+1F62B	|	—	|	tired face	|
|	😩	|	\&#128553;	|	U+1F629	|	—	|	weary face	|
|	🥵	|	\&#129397;	|	U+1F975	|	—	|	overheated face	|
|	😪	|	\&#128554;	|	U+1F62A	|	—	|	sleepy face	|
|	😴	|	\&#128564;	|	U+1F634	|	—	|	sleeping face	|
|	😋	|	\&#128523;	|	U+1F60B	|	—	|	face savouring delicious food	|
|	🤤	|	\&#129316;	|	U+1F924	|	—	|	drooling face	|
|	🤑	|	\&#129297;	|	U+1F911	|	—	|	money-mouth face	|
|	🥳	|	\&#129395;	|	U+1F973	|	—	|	face with party horn and party hat	|
|	🤓	|	\&#129299;	|	U+1F913	|	—	|	nerd face	|
|	🥶	|	\&#129398;	|	U+1F976	|	—	|	freezing face	|
|	🤢	|	\&#129314;	|	U+1F922	|	—	|	nauseated face	|
|	🤮	|	\&#129326;	|	U+1F92E	|	—	|	face with open mouth vomiting	|
|	🤧	|	\&#129319;	|	U+1F927	|	—	|	sneezing face (gesundheit)	|
|	🤒	|	\&#129298;	|	U+1F912	|	—	|	face with thermometer	|
|	🤕	|	\&#129301;	|	U+1F915	|	—	|	face with head-bandage	|
|	😷	|	\&#128567;	|	U+1F637	|	—	|	face with medical mask	|
|	😮	|	\&#128558;	|	U+1F62E	|	—	|	face with open mouth	|
|	😰	|	\&#128560;	|	U+1F630	|	—	|	face with open mouth and cold sweat	|
|	😓	|	\&#128531;	|	U+1F613	|	—	|	face with cold sweat	|
|	🤥	|	\&#129317;	|	U+1F925	|	—	|	lying face	|
|	😯	|	\&#128559;	|	U+1F62F	|	—	|	hushed face	|
|	🤫	|	\&#129323;	|	U+1F92B	|	—	|	face with finger covering closed lips	|
|	🤐	|	\&#129296;	|	U+1F910	|	—	|	zipper-mouth face	|
|	🥴	|	\&#129396;	|	U+1F974	|	—	|	face with uneven eyes and wavy mouth	|
|	🥸-	|	\&#129400;	|	U+1F978	|	—	|	disguised face	|
|	😐	|	\&#128528;	|	U+1F610	|	—	|	neutral face	|
|	😑	|	\&#128529;	|	U+1F611	|	—	|	expressionless face	|
|	😒	|	\&#128530;	|	U+1F612	|	—	|	unamused face	|
|	🙃	|	\&#128579;	|	U+1F643	|	—	|	upside-down face	|
|	😶	|	\&#128566;	|	U+1F636	|	—	|	face without mouth	|
|	🤷	|	\&#129335;	|	U+1F937	|	—	|	shrug	|
|	🙅	|	\&#128581;	|	U+1F645	|	—	|	face with no good gesture ("no deal" or "not ok")	|
|	🤦	|	\&#129318;	|	U+1F926	|	—	|	face palm (frustration, disbelief)	|
|	🙋	|	\&#128587;	|	U+1F64B	|	—	|	happy person raising one hand	|
|	🙍	|	\&#128589;	|	U+1F64D	|	—	|	person frowning	|
|	🙎	|	\&#128590;	|	U+1F64E	|	—	|	person with pouting face (pouting rather than anger)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Hand Symbols

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	☞	|	\&#9758;	|	U+261E	|	—	|	white right pointing index (typographic fist)	|
|	☛	|	\&#9755;	|	U+261B	|	—	|	black right pointing index	|
|	🖝	|	\&#128413;	|	U+1F59D	|	—	|	black right pointing backhand index	|
|	👉	|	\&#128073;	|	U+1F449	|	—	|	white right pointing backhand index	|
|	👈	|	\&#128072;	|	U+1F448	|	—	|	white left pointing backhand index	|
|	☝	|	\&#9757;	|	U+261D	|	—	|	white up pointing index	|
|	👇	|	\&#128071;	|	U+1F447	|	—	|	white down pointing backhand index	|
|	🖕	|	\&#128405;	|	U+1F595	|	—	|	reversed hand with middle finger extended (fuck)	|
|	👍	|	\&#128077;	|	U+1F44D	|	—	|	thumbs up sign	|
|	🖒	|	\&#128402;	|	U+1F592	|	—	|	reversed thumbs up sign (like)	|
|	👎	|	\&#128078;	|	U+1F44E	|	—	|	thumbs down sign	|
|	🖓	|	\&#128403;	|	U+1F593	|	—	|	reversed thumbs down sign (dislike)	|
|	👌	|	\&#128076;	|	U+1F44C	|	—	|	ok hand sign	|
|	🖏	|	\&#128399;	|	U+1F58F	|	—	|	turned ok hand sign	|
|	🤏	|	\&#129295;	|	U+1F90F	|	—	|	pinching hand	|
|	🤌-	|	\&#129292;	|	U+1F90C	|	—	|	pinched fingers	|
|	✌	|	\&#9996;	|	U+270C	|	—	|	victory hand (scissors in Rock, Paper, Scissors game)	|
|	🤞	|	\&#129310;	|	U+1F91E	|	—	|	hand with index and middle fingers crossed	|
|	🤘	|	\&#129304;	|	U+1F918	|	—	|	sign of the horns	|
|	🤟	|	\&#129311;	|	U+1F91F	|	—	|	I Love You hand sign (can be abbreviated ILY)	|
|	🖖	|	\&#128406;	|	U+1F596	|	—	|	raised hand with part between fingers (vulcan salute)	|
|	🤙	|	\&#129305;	|	U+1F919	|	—	|	Call Me hand	|
|	✋	|	\&#9995;	|	U+270B	|	—	|	raised hand (paper in Rock, Paper, Scissors game)	|
|	🖐	|	\&#128400;	|	U+1F590	|	—	|	raised hand with fingers splayed (halt)	|
|	✊	|	\&#9994;	|	U+270A	|	—	|	raised fist (rock in Rock, Paper, Scissors game; solidarity)	|
|	👐	|	\&#128080;	|	U+1F450	|	—	|	open hands sign	|
|	👋	|	\&#128075;	|	U+1F44B	|	—	|	waving hand sign	|
|	🤝	|	\&#129309;	|	U+1F91D	|	—	|	handshake	|
|	🙏	|	\&#128591;	|	U+1F64F	|	—	|	person with folded hands (sorrow, regret, praying)	|
|	✍	|	\&#9997;	|	U+270D	|	—	|	writing hand	|
|	🖎	|	\&#128398;	|	U+1F58E	|	—	|	left writing hand	|
|	🤛	|	\&#129307;	|	U+1F91B	|	—	|	left-facing fist	|
|	🤜	|	\&#129308;	|	U+1F91C	|	—	|	right-facing fist	|
|	👊	|	\&#128074;	|	U+1F44A	|	—	|	fisted hand sign (punch)	|
|	💪	|	\&#128170;	|	U+1F4AA	|	—	|	flexed biceps (strong, muscled)	|
|	🤳	|	\&#129331;	|	U+1F933	|	—	|	selfie (typically used with face/figure on the left)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Portrait

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	☯	|	\&#9775;	|	U+262F	|	—	|	Yin Yang (dark-bright, negative-positive)	|
|	♂	|	\&#9794;	|	U+2642	|	\&male;	|	male sign (Mars)	|
|	♀	|	\&#9792;	|	U+2640	|	\&female;	|	female sign	|
|	🯅-	|	\&#129989;	|	U+1FBC5	|	—	|	stick figure	|
|	🯆-	|	\&#129990;	|	U+1FBC6	|	—	|	stick figure with arms raised	|
|	🯉-	|	\&#129993;	|	U+1FBC9	|	—	|	stick figure with dress	|
|	👤	|	\&#128100;	|	U+1F464	|	—	|	bust in silhouette (guest account)	|
|	👥	|	\&#128101;	|	U+1F465	|	—	|	busts in silhouette (accounts)	|
|	👦	|	\&#128102;	|	U+1F466	|	—	|	boy	|
|	🛉	|	\&#128713;	|	U+1F6C9	|	—	|	boys symbol	|
|	👧	|	\&#128103;	|	U+1F467	|	—	|	girl	|
|	🛊	|	\&#128714;	|	U+1F6CA	|	—	|	girls symbol	|
|	🧒	|	\&#129490;	|	U+1F9D2	|	—	|	child (no specified gender)	|
|	👶	|	\&#128118;	|	U+1F476	|	—	|	baby	|
|	👨	|	\&#128104;	|	U+1F468	|	—	|	man	|
|	👩	|	\&#128105;	|	U+1F469	|	—	|	woman	|
|	🧑	|	\&#129489;	|	U+1F9D1	|	—	|	adult (no specified gender)	|
|	👴	|	\&#128116;	|	U+1F474	|	—	|	older man	|
|	👵	|	\&#128117;	|	U+1F475	|	—	|	older woman	|
|	🧓	|	\&#129491;	|	U+1F9D3	|	—	|	older adult (no specified gender)	|
|	👪	|	\&#128106;	|	U+1F46A	|	—	|	family (rated for family)	|
|	👫	|	\&#128107;	|	U+1F46B	|	—	|	man and woman holding hands	|
|	👬	|	\&#128108;	|	U+1F46C	|	—	|	two men holding hands	|
|	👭	|	\&#128109;	|	U+1F46D	|	—	|	two women holding hands	|
|	👯	|	\&#128111;	|	U+1F46F	|	—	|	woman with bunny ears ("two women dancing")	|
|	💃	|	\&#128131;	|	U+1F483	|	—	|	dancer (also used for "let's party")	|
|	🕺	|	\&#128378;	|	U+1F57A	|	—	|	man dancing	|
|	🤵	|	\&#129333;	|	U+1F935	|	—	|	man in tuxedo (appearance for groom, may pair 👰)	|
|	👰	|	\&#128112;	|	U+1F470	|	—	|	bride with veil	|
|	🤰	|	\&#129328;	|	U+1F930	|	—	|	pregnant woman	|
|	🤱	|	\&#129329;	|	U+1F931	|	—	|	breast-feeding	|
|	👱	|	\&#128113;	|	U+1F471	|	—	|	person with blond hair	|
|	🧔	|	\&#129492;	|	U+1F9D4	|	—	|	bearded person	|
|	👳	|	\&#128115;	|	U+1F473	|	—	|	man with turban (may be shown with or without a beard)	|
|	🧕	|	\&#129493;	|	U+1F9D5	|	—	|	person with headscarf (woman's headscarf, hijab)	|
|	🤖	|	\&#129302;	|	U+1F916	|	—	|	robot face	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Role

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	💁	|	\&#128129;	|	U+1F481	|	—	|	information desk person ("sassy" or "carefree")	|
|	👷	|	\&#128119;	|	U+1F477	|	—	|	construction worker	|
|	🤡	|	\&#129313;	|	U+1F921	|	—	|	clown face	|
|	🤹	|	\&#129337;	|	U+1F939	|	—	|	juggling	|
|	👮	|	\&#128110;	|	U+1F46E	|	—	|	police officer	|
|	💂	|	\&#128130;	|	U+1F482	|	—	|	guardsman	|
|	🕵	|	\&#128373;	|	U+1F575	|	—	|	sleuth or spy (investigate)	|
|	🤠	|	\&#129312;	|	U+1F920	|	—	|	face with cowboy hat	|
|	🥷-	|	\&#129399;	|	U+1F977	|	—	|	ninja	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Fairy Tale, Fantasy Beings

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	👸	|	\&#128120;	|	U+1F478	|	—	|	princess	|
|	🤴	|	\&#129332;	|	U+1F934	|	—	|	prince	|
|	🧙	|	\&#129497;	|	U+1F9D9	|	—	|	mage (wizard, witch, sorcerer, sorceress)	|
|	🧞	|	\&#129502;	|	U+1F9DE	|	—	|	genie	|
|	🧚	|	\&#129498;	|	U+1F9DA	|	—	|	fairy	|
|	🧜	|	\&#129500;	|	U+1F9DC	|	—	|	merperson (mermaid, merman)	|
|	🧝	|	\&#129501;	|	U+1F9DD	|	—	|	elf	|
|	🦸	|	\&#129464;	|	U+1F9B8	|	—	|	superhero	|
|	🦹	|	\&#129465;	|	U+1F9B9	|	—	|	supervillain	|
|	👻	|	\&#128123;	|	U+1F47B	|	—	|	ghost	|
|	🧛	|	\&#129499;	|	U+1F9DB	|	—	|	vampire	|
|	🧟	|	\&#129503;	|	U+1F9DF	|	—	|	zombie	|
|	👽	|	\&#128125;	|	U+1F47D	|	—	|	extraterrestrial alien	|
|	🛸	|	\&#128760;	|	U+1F6F8	|	—	|	flying saucer (UFO)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Romance

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🕯	|	\&#128367;	|	U+1F56F	|	—	|	candle	|
|	💋	|	\&#128139;	|	U+1F48B	|	—	|	kiss mark	|
|	🗢	|	\&#128482;	|	U+1F5E2	|	—	|	lips (rated for sex, kiss)	|
|	💌	|	\&#128140;	|	U+1F48C	|	—	|	love letter	|
|	💍	|	\&#128141;	|	U+1F48D	|	—	|	ring (jewelry)	|
|	⚯	|	\&#9903;	|	U+26AF	|	—	|	unmarried partnership symbol	|
|	⚭	|	\&#9901;	|	U+26AD	|	—	|	marriage symbol	|
|	⚮	|	\&#9902;	|	U+26AE	|	—	|	divorce symbol	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Flowers

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	⚘	|	\&#9880;	|	U+2698	|	—	|	flower (botanical term)	|
|	❀	|	\&#10048;	|	U+2740	|	—	|	white florette	|
|	🎕	|	\&#127893;	|	U+1F395	|	—	|	bouquet of flowers (occasion)	|
|	💐	|	\&#128144;	|	U+1F490	|	—	|	bouquet	|
|	🌼	|	\&#127804;	|	U+1F33C	|	—	|	blossom (daisy)	|
|	🌻	|	\&#127803;	|	U+1F33B	|	—	|	sunflower	|
|	🌷	|	\&#127799;	|	U+1F337	|	—	|	tulip	|
|	🌹	|	\&#127801;	|	U+1F339	|	—	|	rose	|
|	🥀	|	\&#129344;	|	U+1F940	|	—	|	wilted flower	|
|	🪴-	|	\&#129716;	|	U+1FAB4	|	—	|	potted plant	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Heart

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	❤	|	\&#10084;	|	U+2764	|	—	|	heavy black heart (red when used in emoji style)	|
|	🖤	|	\&#128420;	|	U+1F5A4	|	—	|	black heart (always black in all variants)	|
|	🤍	|	\&#129293;	|	U+1F90D	|	—	|	white heart	|
|	🎔	|	\&#127892;	|	U+1F394	|	—	|	heart with tip on the left (favorite)	|
|	💓	|	\&#128147;	|	U+1F493	|	—	|	beating heart	|
|	💔	|	\&#128148;	|	U+1F494	|	—	|	broken heart	|
|	💘	|	\&#128152;	|	U+1F498	|	—	|	heart with arrow	|
|	💕	|	\&#128149;	|	U+1F495	|	—	|	two hearts	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## ARROWS

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	⟶	|	\&#10230;	|	U+27F6	|	\&LongRightArrow;	|	long rightwards arrow	|
|	→	|	\&#8594;	|	U+2192	|	\&RightArrow;	|	rightwards arrow	|
|	➝	|	\&#10141;	|	U+279D	|	—	|	triangle-headed rightwards arrow	|
|	➞	|	\&#10142;	|	U+279E	|	—	|	heavy triangle-headed rightwards arrow	|
|	➡	|	\&#10145;	|	U+27A1	|	—	|	black rightwards arrow (fonts may harmonize this)	|
|	⟹	|	\&#10233;	|	U+27F9	|	\&DoubleLongRightArrow;	|	long rightwards double arrow	|
|	⇒	|	\&#8658;	|	U+21D2	|	\&DoubleRightArrow;	|	rightwards double arrow	|
|	⇨	|	\&#8680;	|	U+21E8	|	—	|	rightwards white arrow (group select ISO 9995−07)	|
|	⇢	|	\&#8674;	|	U+21E2	|	—	|	rightwards dashed arrow	|
|	⤑	|	\&#10513;	|	U+2911	|	\&DDotrahd;	|	rightwards arrow with dotted stem	|
|	➛	|	\&#10139;	|	U+279B	|	—	|	drafting point rightwards arrow	|
|	➳	|	\&#10163;	|	U+27B3	|	—	|	white-feathered rightwards arrow	|
|	➼	|	\&#10172;	|	U+27BC	|	—	|	wedge-tailed rightwards arrow	|
|	➔	|	\&#10132;	|	U+2794	|	—	|	heavy wide-headed rightwards arrow	|
|	🡲	|	\&#129138;	|	U+1F872	|	—	|	wide-headed rightwards medium barb arrow	|
|	🠶	|	\&#129078;	|	U+1F836	|	—	|	rightwards finger-post arrow	|
|	⮩	|	\&#11177;	|	U+2BA9	|	—	|	black curved downwards and rightwards arrow	|
|	➥	|	\&#10149;	|	U+27A5	|	—	|	heavy black curved downwards and rightwards arrow	|
|	🡆	|	\&#129094;	|	U+1F846	|	—	|	rightwards heavy arrow	|
|	➧	|	\&#10151;	|	U+27A7	|	—	|	squat black rightwards arrow	|
|	➤	|	\&#10148;	|	U+27A4	|	—	|	black rightwards arrowhead	|
|	⮞	|	\&#11166;	|	U+2B9E	|	—	|	black rightwards equilateral arrowhead	|
|	⟵	|	\&#10229;	|	U+27F5	|	\&LongLeftArrow;	|	long leftwards arrow	|
|	←	|	\&#8592;	|	U+2190	|	\&LeftArrow;	|	leftwards arrow	|
|	⟸	|	\&#10232;	|	U+27F8	|	\&DoubleLongLeftArrow;	|	long leftwards double arrow	|
|	⇐	|	\&#8656;	|	U+21D0	|	\&DoubleLeftArrow;	|	leftwards double arrow	|
|	⇦	|	\&#8678;	|	U+21E6	|	—	|	leftwards white arrow	|
|	⇠	|	\&#8672;	|	U+21E0	|	—	|	leftwards dashed arrow	|
|	↑	|	\&#8593;	|	U+2191	|	\&UpArrow;	|	upwards arrow	|
|	⇑	|	\&#8657;	|	U+21D1	|	\&DoubleUpArrow;	|	upwards double arrow	|
|	⇧	|	\&#8679;	|	U+21E7	|	—	|	upwards white arrow (shift, level 2 select ISO 9995−7)	|
|	⇡	|	\&#8673;	|	U+21E1	|	—	|	upwards dashed arrow	|
|	↓	|	\&#8595;	|	U+2193	|	\&DownArrow;	|	downwards arrow	|
|	⇓	|	\&#8659;	|	U+21D3	|	\&DoubleDownArrow;	|	downwards double arrow	|
|	⇩	|	\&#8681;	|	U+21E9	|	—	|	downwards white arrow	|
|	⇣	|	\&#8675;	|	U+21E3	|	—	|	downwards dashed arrow	|
|	⮷	|	\&#11191;	|	U+2BB7	|	—	|	ribbon arrow right down	|
|	⟷	|	\&#10231;	|	U+27F7	|	\&LongLeftRightArrow;	|	long left right arrow	|
|	⟺	|	\&#10234;	|	U+27FA	|	\&DoubleLongLeftRightArrow;	|	long left right double arrow	|
|	⇔	|	\&#8660;	|	U+21D4	|	\&DoubleLeftRightArrow;	|	left right double arrow	|
|	⇄	|	\&#8644;	|	U+21C4	|	\&RightArrowLeftArrow;	|	rightwards arrow over leftwards arrow	|
|	↔	|	\&#8596;	|	U+2194	|	\&LeftRightArrow;	|	left right arrow	|
|	↕	|	\&#8597;	|	U+2195	|	\&UpDownArrow;	|	up down arrow	|
|	⇅	|	\&#8645;	|	U+21C5	|	\&UpArrowDownArrow;	|	upwards arrow leftwards of downwards arrow	|
|	⇕	|	\&#8661;	|	U+21D5	|	\&DoubleUpDownArrow;	|	up down double arrow	|
|	⇳	|	\&#8691;	|	U+21F3	|	—	|	up down white arrow (scrolling)	|
|	↵	|	\&#8629;	|	U+21B5	|	\&crarr;	|	downwards arrow with corner leftwards (new line)	|
|	⮔	|	\&#11156;	|	U+2B94	|	—	|	four corner arrows circling anticlockwise (loop)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Bubbles

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	💬	|	\&#128172;	|	U+1F4AC	|	—	|	speech balloon (comic book conversation bubble)	|
|	🗨	|	\&#128488;	|	U+1F5E8	|	—	|	left speech bubble	|
|	🗩	|	\&#128489;	|	U+1F5E9	|	—	|	right speech bubble	|
|	🗪	|	\&#128490;	|	U+1F5EA	|	—	|	two speech bubbles (chat)	|
|	🗫	|	\&#128491;	|	U+1F5EB	|	—	|	three speech bubbles (conference)	|
|	💭	|	\&#128173;	|	U+1F4AD	|	—	|	thought balloon	|
|	🗬	|	\&#128492;	|	U+1F5EC	|	—	|	left thought bubble	|
|	🗭	|	\&#128493;	|	U+1F5ED	|	—	|	right thought bubble	|
|	🗮	|	\&#128494;	|	U+1F5EE	|	—	|	left anger bubble (shout left)	|
|	🗯	|	\&#128495;	|	U+1F5EF	|	—	|	right anger bubble (shout right)	|
|	🗰	|	\&#128496;	|	U+1F5F0	|	—	|	mood bubble (new)	|
|	🗱	|	\&#128497;	|	U+1F5F1	|	—	|	lightning mood bubble (updated)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## PHYSICS

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	°	|	\&#0176;	|	U+00B0	|	\&deg;	|	degree sign	|
|	℃	|	\&#8451;	|	U+2103	|	—	|	degree Celsius	|
|	℉	|	\&#8457;	|	U+2109	|	—	|	degree Fahrenheit	|
|	Å	|	\&#0197;	|	U+00C5	|	\&angst;	|	Latin capital letter A with ring above (Angstrom sign)	|
|	㎛	|	\&#8455;	|	U+2107	|	—	|	square Mu M (micrometer, micron)	|
|	⌀	|	\&#8960;	|	U+2300	|	—	|	diameter sign	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Elecrotechnical (includes symbols from IR 181)

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	Ω	|	\&#0937;	|	U+03A9	|	\&ohm;	|	Greek capital letter Omega (Ohm sign)	|
|	µ	|	\&#0181;	|	U+00B5	|	\&micro;	|	micro sign	|
|	⎓	|	\&#9107;	|	U+2393	|	—	|	direct current symbol form two	|
|	∿	|	\&#8767;	|	U+223F	|	\&acd;	|	sine wave (alternating current)	|
|	⏦	|	\&#9190;	|	U+23E6	|	—	|	AC current	|
|	⏚	|	\&#9178;	|	U+23DA	|	—	|	earth ground	|
|	⏛	|	\&#9179;	|	U+23DB	|	—	|	fuse	|
|	⚠	|	\&#9888;	|	U+26A0	|	—	|	warning sign	|
|	⚡	|	\&#9889;	|	U+26A1	|	—	|	high voltage sign (thunder, lightning symbol)	|
|	↯	|	\&#8623;	|	U+21AF	|	—	|	downwards zigzag arrow	|
|	⎍	|	\&#9101;	|	U+238D	|	—	|	monostable symbol	|
|	⎎	|	\&#9102;	|	U+238E	|	—	|	hysteresis symbol	|
|	⎏	|	\&#9103;	|	U+238F	|	—	|	open-circuit-output H-type symbol	|
|	⎐	|	\&#9104;	|	U+2390	|	—	|	open-circuit-output L-type symbol	|
|	⎑	|	\&#9105;	|	U+2391	|	—	|	passive-pull-down-output symbol	|
|	⎒	|	\&#9106;	|	U+2392	|	—	|	passive-pull-up-output symbol	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Greek Letters (also see MATH and Electrotechnical)

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	Δ	|	\&#0916;	|	U+0394	|	\&Delta;	|	Greek capital letter Delta	|
|	α	|	\&#0945;	|	U+03B1	|	\&alpha;	|	Greek small letter Alpha	|
|	β	|	\&#0946;	|	U+03B2	|	\&beta;	|	Greek small letter Beta	|
|	γ	|	\&#0947;	|	U+03B3	|	\&gamma;	|	Greek small letter Gamma	|
|	δ	|	\&#0948;	|	U+03B4	|	\&delta;	|	Greek small letter Delta	|
|	ε	|	\&#0949;	|	U+03B5	|	\&epsilon;	|	Greek small letter Epsilon	|
|	η	|	\&#0951;	|	U+03B7	|	\&eta;	|	Greek small letter Eta	|
|	λ	|	\&#0955;	|	U+03BB	|	\&lambda;	|	Greek small letter Lamda	|
|	ν	|	\&#0957;	|	U+03BD	|	\&nu;	|	Greek small letter Nu	|
|	ρ	|	\&#0961;	|	U+03C1	|	\&rho;	|	Greek small letter Rho	|
|	σ	|	\&#0963;	|	U+03C3	|	\&sigma;	|	Greek small letter Sigma	|
|	τ	|	\&#0964;	|	U+03C4	|	\&tau;	|	Greek small letter Tau	|
|	υ	|	\&#0965;	|	U+03C5	|	\&upsilon;	|	Greek small letter Upsilon	|
|	φ	|	\&#0966;	|	U+03C6	|	\&phi;	|	Greek small letter Phi	|
|	ω	|	\&#0969;	|	U+03C9	|	\&omega;	|	Greek small letter Omega	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## MATH

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	±	|	\&#0177;	|	U+00B1	|	\&PlusMinus;	|	plus-minus sign	|
|	−	|	\&#8722;	|	U+2212	|	\&minus;	|	minus sign	|
|	➖	|	\&#10134;	|	U+2796	|	—	|	heavy minus sign	|
|	×	|	\&#0215;	|	U+00D7	|	\&times;	|	multiplication sign	|
|	✕	|	\&#10005;	|	U+2715	|	—	|	multiplication X	|
|	✖	|	\&#10006;	|	U+2716	|	—	|	heavy multiplication X	|
|	⋅	|	\&#8901;	|	U+22C5	|	\&sdot;	|	dot operator (preferred to 00B7· for multiplication)	|
|	∗	|	\&#8727;	|	U+2217	|	\&lowast;	|	asterisk operator	|
|	÷	|	\&#0247;	|	U+00F7	|	\&divide;	|	division sign	|
|	∶	|	\&#8758;	|	U+2236	|	\&ratio;	|	ratio (preferred to 003A : for denotation of division)	|
|	∕	|	\&#8725;	|	U+2215	|	—	|	division slash	|
|	≈	|	\&#8776;	|	U+2248	|	\&approx;	|	almost equal to (asymptotic to)	|
|	≠	|	\&#8800;	|	U+2260	|	\&NotEqual;	|	not equal to	|
|	≤	|	\&#8804;	|	U+2264	|	\&le;	|	less-than or equal to	|
|	≥	|	\&#8805;	|	U+2265	|	\&ge;	|	greater-than or equal to	|
|	≪	|	\&#8810;	|	U+226A	|	\&Lt;	|	much less-than	|
|	≫	|	\&#8811;	|	U+226B	|	\&Gt;	|	much greater-than	|
|	≷	|	\&#8823;	|	U+2277	|	\&gtrless;	|	greater-than or less-than	|
|	⊕	|	\&#8853;	|	U+2295	|	\&oplus;	|	circled plus	|
|	π	|	\&#0960;	|	U+03C0	|	\&pi;	|	Greek small letter Pi (math constant 3.14)	|
|	∞	|	\&#8734;	|	U+221E	|	\&infin;	|	infinity	|
|	√	|	\&#8730;	|	U+221A	|	\&Sqrt;	|	square root	|
|	∑	|	\&#8721;	|	U+2211	|	\&sum;	|	N-Ary summation	|
|	∫	|	\&#8747;	|	U+222B	|	\&integral;	|	integral	|
|	ƒ	|	\&#0402;	|	U+0192	|	\&fnof;	|	function symbol	|
|	∥	|	\&#8741;	|	U+2225	|	\&DoubleVerticalBar;	|	parallel to	|
|	∦	|	\&#8742;	|	U+2226	|	\&nparallel;	|	not parallel to	|
|	∡	|	\&#8737;	|	U+2221	|	\&measuredangle;	|	measured angle	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Superscript

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	⁰	|	\&#8304;	|	U+2070	|	—	|	superscript zero	|
|	¹	|	\&#0185;	|	U+00B9	|	\&sup1;	|	superscript one	|
|	²	|	\&#0178;	|	U+00B2	|	\&sup2;	|	superscript two	|
|	³	|	\&#0179;	|	U+00B3	|	\&sup3;	|	superscript three	|
|	⁴	|	\&#8308;	|	U+2074	|	—	|	superscript four	|
|	⁵	|	\&#8309;	|	U+2075	|	—	|	superscript five	|
|	⁶	|	\&#8310;	|	U+2076	|	—	|	superscript six	|
|	⁷	|	\&#8311;	|	U+2077	|	—	|	superscript seven	|
|	⁸	|	\&#8312;	|	U+2078	|	—	|	superscript eight	|
|	⁹	|	\&#8313;	|	U+2079	|	—	|	superscript nine	|
|	⁺	|	\&#8314;	|	U+207A	|	—	|	superscript plus sign	|
|	⁻	|	\&#8315;	|	U+207B	|	—	|	superscript minus	|
|	⁼	|	\&#8316;	|	U+207C	|	—	|	superscript equals sign	|
|	⁽	|	\&#8317;	|	U+207D	|	—	|	superscript left parenthesis	|
|	⁾	|	\&#8318;	|	U+207E	|	—	|	superscript right parenthesis	|
|	ⁿ	|	\&#8319;	|	U+207F	|	—	|	superscript latin small letter n	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Digit

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🄋	|	\&#127243;	|	U+1F10B	|	—	|	dingbat circled sans-serif digit zero	|
|	➀	|	\&#10112;	|	U+2780	|	—	|	dingbat circled sans-serif digit one	|
|	➁	|	\&#10113;	|	U+2781	|	—	|	dingbat circled sans-serif digit two	|
|	➂	|	\&#10114;	|	U+2782	|	—	|	dingbat circled sans-serif digit three	|
|	➃	|	\&#10115;	|	U+2783	|	—	|	dingbat circled sans-serif digit four	|
|	➄	|	\&#10116;	|	U+2784	|	—	|	dingbat circled sans-serif digit five	|
|	➅	|	\&#10117;	|	U+2785	|	—	|	dingbat circled sans-serif digit six	|
|	➆	|	\&#10118;	|	U+2786	|	—	|	dingbat circled sans-serif digit seven	|
|	➇	|	\&#10119;	|	U+2787	|	—	|	dingbat circled sans-serif digit eight	|
|	➈	|	\&#10120;	|	U+2788	|	—	|	dingbat circled sans-serif digit nine	|
|	➉	|	\&#10121;	|	U+2789	|	—	|	dingbat circled sans-serif number ten	|
|	🄌	|	\&#127244;	|	U+1F10C	|	—	|	dingbat negative circled sans-serif digit zero	|
|	➊	|	\&#10122;	|	U+278A	|	—	|	dingbat negative circled sans-serif digit one	|
|	➋	|	\&#10123;	|	U+278B	|	—	|	dingbat negative circled sans-serif digit two	|
|	➌	|	\&#10124;	|	U+278C	|	—	|	dingbat negative circled sans-serif digit three	|
|	➍	|	\&#10125;	|	U+278D	|	—	|	dingbat negative circled sans-serif digit four	|
|	➎	|	\&#10126;	|	U+278E	|	—	|	dingbat negative circled sans-serif digit five	|
|	➏	|	\&#10127;	|	U+278F	|	—	|	dingbat negative circled sans-serif digit six	|
|	➐	|	\&#10128;	|	U+2790	|	—	|	dingbat negative circled sans-serif digit seven	|
|	➑	|	\&#10129;	|	U+2791	|	—	|	dingbat negative circled sans-serif digit eight	|
|	➒	|	\&#10130;	|	U+2792	|	—	|	dingbat negative circled sans-serif digit nine	|
|	➓	|	\&#10131;	|	U+2793	|	—	|	dingbat negative circled sans-serif number ten	|
|	🯰-	|	\&#130032;	|	U+1FBF0	|	—	|	segmented digit zero	|
|	🯱-	|	\&#130033;	|	U+1FBF1	|	—	|	segmented digit one	|
|	🯲-	|	\&#130034;	|	U+1FBF2	|	—	|	segmented digit two	|
|	🯳-	|	\&#130035;	|	U+1FBF3	|	—	|	segmented digit three	|
|	🯴-	|	\&#130036;	|	U+1FBF4	|	—	|	segmented digit four	|
|	🯵-	|	\&#130037;	|	U+1FBF5	|	—	|	segmented digit five	|
|	🯶-	|	\&#130038;	|	U+1FBF6	|	—	|	segmented digit six	|
|	🯷-	|	\&#130039;	|	U+1FBF7	|	—	|	segmented digit seven	|
|	🯸-	|	\&#130040;	|	U+1FBF8	|	—	|	segmented digit eight	|
|	🯹-	|	\&#130041;	|	U+1FBF9	|	—	|	segmented digit nine	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Fraction

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	½	|	\&#0189;	|	U+00BD	|	\&frac12;	|	vulgar fraction one half	|
|	⅓	|	\&#8531;	|	U+2153	|	\&frac13;	|	vulgar fraction one third	|
|	¼	|	\&#0188;	|	U+00BC	|	\&frac14;	|	vulgar fraction one quarter	|
|	⅕	|	\&#8533;	|	U+2155	|	\&frac15;	|	vulgar fraction one fifth	|
|	⅒	|	\&#8530;	|	U+2152	|	—	|	vulgar fraction one tenth	|
|	⅔	|	\&#8532;	|	U+2154	|	\&frac23;	|	vulgar fraction two thirds	|
|	¾	|	\&#0190;	|	U+00BE	|	\&frac34;	|	vulgar fraction three quarters	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Roman Numerals

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	Ⅰ	|	\&#8544;	|	U+2160	|	—	|	Roman numeral one	|
|	Ⅱ	|	\&#8545;	|	U+2161	|	—	|	Roman numeral two	|
|	Ⅲ	|	\&#8546;	|	U+2162	|	—	|	Roman numeral three	|
|	Ⅳ	|	\&#8547;	|	U+2163	|	—	|	Roman numeral four	|
|	Ⅴ	|	\&#8548;	|	U+2164	|	—	|	Roman numeral five	|
|	Ⅵ	|	\&#8549;	|	U+2165	|	—	|	Roman numeral six	|
|	Ⅶ	|	\&#8550;	|	U+2166	|	—	|	Roman numeral seven	|
|	Ⅷ	|	\&#8551;	|	U+2167	|	—	|	Roman numeral eight	|
|	Ⅸ	|	\&#8552;	|	U+2168	|	—	|	Roman numeral nine	|
|	Ⅹ	|	\&#8553;	|	U+2169	|	—	|	Roman numeral ten	|
|	Ⅺ	|	\&#8554;	|	U+216A	|	—	|	Roman numeral eleven	|
|	Ⅻ	|	\&#8555;	|	U+216B	|	—	|	Roman numeral twelve	|
|	ⅰ	|	\&#8560;	|	U+2170	|	—	|	small Roman numeral one	|
|	ⅱ	|	\&#8561;	|	U+2171	|	—	|	small Roman numeral two	|
|	ⅲ	|	\&#8562;	|	U+2172	|	—	|	small Roman numeral three	|
|	ⅳ	|	\&#8563;	|	U+2173	|	—	|	small Roman numeral four	|
|	ⅴ	|	\&#8564;	|	U+2174	|	—	|	small Roman numeral five	|
|	ⅵ	|	\&#8565;	|	U+2175	|	—	|	small Roman numeral six	|
|	ⅶ	|	\&#8566;	|	U+2176	|	—	|	small Roman numeral seven	|
|	ⅷ	|	\&#8567;	|	U+2177	|	—	|	small Roman numeral eight	|
|	ⅸ	|	\&#8568;	|	U+2178	|	—	|	small Roman numeral nine	|
|	ⅹ	|	\&#8569;	|	U+2179	|	—	|	small Roman numeral ten	|
|	ⅺ	|	\&#8570;	|	U+217A	|	—	|	small Roman numeral eleven	|
|	ⅻ	|	\&#8571;	|	U+217B	|	—	|	small Roman numeral twelve	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Geometric Shapes

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	⬛	|	\&#11035;	|	U+2B1B	|	—	|	black large square	|
|	■	|	\&#9632;	|	U+25A0	|	—	|	black square (moding mark in ideographic text)	|
|	◼	|	\&#9724;	|	U+25FC	|	\&FilledSmallSquare;	|	black medium square	|
|	⬜	|	\&#11036;	|	U+2B1C	|	—	|	white large square	|
|	□	|	\&#9633;	|	U+25A1	|	\&square;	|	white square (quadrature, aspect square in astrology)	|
|	◻	|	\&#9723;	|	U+25FB	|	\&EmptySmallSquare;	|	white medium square, always (modal operator)	|
|	▢	|	\&#9634;	|	U+25A2	|	—	|	white square with rounded corners	|
|	▨	|	\&#9640;	|	U+25A8	|	—	|	square with upper right to lower left fill	|
|	◧	|	\&#9703;	|	U+25E7	|	—	|	square with left half black	|
|	◩	|	\&#9705;	|	U+25E9	|	—	|	square with upper left diagonal half black	|
|	⧅	|	\&#10693;	|	U+29C5	|	\&bsolb;	|	squared falling diagonal slash	|
|	◫	|	\&#9707;	|	U+25EB	|	—	|	white square with vertical bisecting line	|
|	⊟	|	\&#8863;	|	U+229F	|	\&boxminus;	|	squared minus	|
|	⊞	|	\&#8862;	|	U+229E	|	\&boxplus;	|	squared plus	|
|	⊠	|	\&#8864;	|	U+22A0	|	\&boxtimes;	|	squared times	|
|	⧉	|	\&#10697;	|	U+29C9	|	\&boxbox;	|	two joined squares	|
|	⮻-	|	\&#11195;	|	U+2BBB	|	—	|	overlapping white and black squares	|
|	▬	|	\&#9644;	|	U+25AC	|	—	|	black rectangle	|
|	▭	|	\&#9645;	|	U+25AD	|	\&rect;	|	white rectangle	|
|	▮	|	\&#9646;	|	U+25AE	|	\&marker;	|	black vertical rectangle (histogram marker)	|
|	▯	|	\&#9647;	|	U+25AF	|	—	|	white vertical rectangle	|
|	▰	|	\&#9648;	|	U+25B0	|	—	|	black parallelogram	|
|	▱	|	\&#9649;	|	U+25B1	|	\&fltns;	|	white parallelogram	|
|	⏢	|	\&#9186;	|	U+23E2	|	\&trpezium;	|	white trapezium	|
|	▲	|	\&#9650;	|	U+25B2	|	—	|	black up-pointing triangle	|
|	△	|	\&#9651;	|	U+25B3	|	\&bigtriangleup;	|	white up-pointing triangle (trine)	|
|	▼	|	\&#9660;	|	U+25BC	|	—	|	black down-pointing triangle	|
|	▽	|	\&#9661;	|	U+25BD	|	—	|	white down-pointing triangle (Hamilton operator)	|
|	◢	|	\&#9698;	|	U+25E2	|	—	|	black lower right triangle	|
|	◆	|	\&#9670;	|	U+25C6	|	—	|	black diamond	|
|	◇	|	\&#9671;	|	U+25C7	|	—	|	white diamond	|
|	◈	|	\&#9672;	|	U+25C8	|	—	|	white diamond containing black small diamond	|
|	◊	|	\&#9674;	|	U+25CA	|	\&lozenge;	|	lozenge	|
|	⧫	|	\&#10731;	|	U+29EB	|	\&blacklozenge;	|	black lozenge	|
|	❖	|	\&#10070;	|	U+2756	|	—	|	black diamond minus white x	|
|	⬢	|	\&#11042;	|	U+2B22	|	—	|	black hexagon	|
|	🛑	|	\&#128721;	|	U+1F6D1	|	—	|	octagonal sign (stop sign, may contain the text "stop")	|
|	○	|	\&#9675;	|	U+25CB	|	\&cir;	|	white circle	|
|	●	|	\&#9679;	|	U+25CF	|	—	|	black circle	|
|	◯	|	\&#9711;	|	U+25EF	|	\&bigcirc;	|	large circle	|
|	⬤	|	\&#11044;	|	U+2B24	|	—	|	black large circle	|
|	◐	|	\&#9680;	|	U+25D0	|	—	|	circle with left half black	|
|	◒	|	\&#9682;	|	U+25D2	|	—	|	circle with lower half black	|
|	◗	|	\&#9687;	|	U+25D7	|	—	|	right half black circle	|
|	◙	|	\&#9689;	|	U+25D9	|	—	|	inverse white circle	|
|	⊕	|	\&#8853;	|	U+2295	|	\&oplus;	|	circled plus (direct sum, vector pointing into page)	|
|	⊖	|	\&#8854;	|	U+2296	|	\&ominus;	|	circled minus (symmetric difference)	|
|	⊗	|	\&#8855;	|	U+2297	|	\&otimes;	|	circled times (tensor product, vector pointing into page)	|
|	⭕	|	\&#11093;	|	U+2B55	|	—	|	heavy large circle (basic symbol for speed limit)	|
|	⌓	|	\&#8979;	|	U+2313	|	\&profsurf;	|	segment (position of a surface)	|
|	⌔	|	\&#8980;	|	U+2314	|	—	|	sector	|
|	⬬	|	\&#11052;	|	U+2B2C	|	—	|	black horizontal ellipse	|
|	⬭	|	\&#11053;	|	U+2B2D	|	—	|	white horizontal ellipse	|
|	⬮	|	\&#11054;	|	U+2B2E	|	—	|	black vertical ellipse	|
|	⬯	|	\&#11055;	|	U+2B2F	|	—	|	white vertical ellipse	|
|	★	|	\&#9733;	|	U+2605	|	\&starf;	|	black star	|
|	☆	|	\&#9734;	|	U+2606	|	\&star;	|	white star	|
|	✪	|	\&#10026;	|	U+272A	|	—	|	circled white star	|
|	✦	|	\&#10022;	|	U+2726	|	—	|	black four pointed star	|
|	⯎	|	\&#11214;	|	U+2BCE	|	—	|	white four pointed cusp	|
|	⯨-	|	\&#11240;	|	U+2BE8	|	—	|	left half black star	|
|	⯩-	|	\&#11241;	|	U+2BE9	|	—	|	right half black star	|
|	⯪-	|	\&#11242;	|	U+2BEA	|	—	|	star with left half black	|
|	⯫-	|	\&#11243;	|	U+2BEB	|	—	|	star with right half black	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Colored Circle and Square

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🔴	|	\&#128308;	|	U+1F534	|	—	|	large red circle	|
|	🟡	|	\&#128993;	|	U+1F7E1	|	—	|	large yellow circle	|
|	🟢	|	\&#128994;	|	U+1F7E2	|	—	|	large green circle	|
|	🟠	|	\&#128992;	|	U+1F7E0	|	—	|	large orange circle	|
|	🔵	|	\&#128309;	|	U+1F535	|	—	|	large blue circle	|
|	🟣	|	\&#128995;	|	U+1F7E3	|	—	|	large purple circle	|
|	🟤	|	\&#128996;	|	U+1F7E4	|	—	|	large brown circle	|
|	🟥	|	\&#128997;	|	U+1F7E5	|	—	|	large red square	|
|	🟨	|	\&#129000;	|	U+1F7E8	|	—	|	large yellow square	|
|	🟩	|	\&#129001;	|	U+1F7E9	|	—	|	large green square	|
|	🟧	|	\&#128999;	|	U+1F7E7	|	—	|	large orange square	|
|	🟦	|	\&#128998;	|	U+1F7E6	|	—	|	large blue square	|
|	🟪	|	\&#129002;	|	U+1F7EA	|	—	|	large purple square	|
|	🟫	|	\&#129003;	|	U+1F7EB	|	—	|	large brown square	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## WEATHER, SKY

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🌣	|	\&#127779;	|	U+1F323	|	—	|	white sun (sunny)	|
|	☼	|	\&#9788;	|	U+263C	|	—	|	white sun with rays	|
|	☀	|	\&#9728;	|	U+2600	|	—	|	black sun with rays	|
|	🌞	|	\&#127774;	|	U+1F31E	|	—	|	sun with face	|
|	🌤	|	\&#127780;	|	U+1F324	|	—	|	white sun with small cloud (mostly sunny)	|
|	⛅	|	\&#9925;	|	U+26C5	|	—	|	sun behind cloud (partly cloudy)	|
|	🌥	|	\&#127781;	|	U+1F325	|	—	|	white sun behind cloud (mostly cloudy)	|
|	☁	|	\&#9729;	|	U+2601	|	—	|	cloud (cloudy weather)	|
|	🌩	|	\&#127785;	|	U+1F329	|	—	|	cloud with lightning (lightning, thunderstorm)	|
|	🗲	|	\&#128498;	|	U+1F5F2	|	—	|	lightning mood (lightning bolt)	|
|	🌦	|	\&#127782;	|	U+1F326	|	—	|	white sun behind cloud with rain (showers)	|
|	🌧	|	\&#127783;	|	U+1F327	|	—	|	cloud with rain (rain)	|
|	⛈	|	\&#9928;	|	U+26C8	|	—	|	thunder cloud and rain (thunderstorm)	|
|	🌪	|	\&#127786;	|	U+1F32A	|	—	|	cloud with tornado (tornado, twister)	|
|	☂	|	\&#9730;	|	U+2602	|	—	|	umbrella (rainy weather)	|
|	☔	|	\&#9748;	|	U+2614	|	—	|	umbrella with rain drops (showery weather)	|
|	🌫	|	\&#127787;	|	U+1F32B	|	—	|	fog	|
|	🌬	|	\&#127788;	|	U+1F32C	|	—	|	wind blowing face (wind)	|
|	🌈	|	\&#127752;	|	U+1F308	|	—	|	rainbow	|
|	🌨	|	\&#127784;	|	U+1F328	|	—	|	cloud with snow (snow, snow showers)	|
|	⛄	|	\&#9924;	|	U+26C4	|	—	|	snowman without snow (light snow)	|
|	⛇	|	\&#9927;	|	U+26C7	|	—	|	black snowman (heavy snow)	|
|	❄	|	\&#10052;	|	U+2744	|	—	|	snowflake	|
|	🌂	|	\&#127746;	|	U+1F302	|	—	|	closed umbrella	|
|	🌡	|	\&#127777;	|	U+1F321	|	—	|	thermometer (temperature, warm)	|
|	💧	|	\&#128167;	|	U+1F4A7	|	—	|	droplet	|
|	🌢	|	\&#127778;	|	U+1F322	|	—	|	black droplet	|
|	☽	|	\&#9789;	|	U+263D	|	—	|	first quarter moon (alchemical symbol for silver)	|
|	🌙	|	\&#127769;	|	U+1F319	|	—	|	crescent moon	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## MAP

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🪐	|	\&#129680;	|	U+1FA90	|	—	|	ringed planet	|
|	🌍	|	\&#127757;	|	U+1F30D	|	—	|	earth globe Europe–Africa	|
|	🌐	|	\&#127760;	|	U+1F310	|	—	|	globe with meridians (int. input source, world clocks)	|
|	🗺	|	\&#128506;	|	U+1F5FA	|	—	|	world map	|
|	🗾	|	\&#128510;	|	U+1F5FE	|	—	|	silhouette of Japan	|
|	🅐	|	\&#127312;	|	U+1F150	|	—	|	negative circled latin capital letter A (airport)	|
|	🛦	|	\&#128742;	|	U+1F6E6	|	—	|	up-pointing military airplane (military airport)	|
|	🛧	|	\&#128743;	|	U+1F6E7	|	—	|	up-pointing airplane (commercial airport)	|
|	🛨	|	\&#128744;	|	U+1F6E8	|	—	|	up-pointing small airplane (airfield)	|
|	🅕	|	\&#127317;	|	U+1F155	|	—	|	negative circled latin capital letter F (ferry)	|
|	⚓	|	\&#9875;	|	U+2693	|	—	|	anchor (nautical term, harbor on maps)	|
|	🅗	|	\&#127319;	|	U+1F157	|	—	|	negative circled latin capital letter H (hotel)	|
|	🅜	|	\&#127324;	|	U+1F15C	|	—	|	negative circled latin capital letter M (metro)	|
|	🅛	|	\&#127323;	|	U+1F15B	|	—	|	negative circled latin capital letter L (light rail)	|
|	🄱	|	\&#127281;	|	U+1F131	|	—	|	squared latin capital letter B (bank)	|
|	🛒	|	\&#128722;	|	U+1F6D2	|	—	|	shopping trolley (shopping cart)	|
|	⛾	|	\&#9982;	|	U+26FE	|	—	|	cup on black square (drive-in restaurant)	|
|	🅻	|	\&#127355;	|	U+1F17B	|	—	|	negative squared latin capital letter L (leisure center)	|
|	🅼	|	\&#127356;	|	U+1F17C	|	—	|	negative squared latin capital letter M (museum)	|
|	🅚	|	\&#127322;	|	U+1F15A	|	—	|	negative circled latin capital letter K (kurort, spa)	|
|	⛺	|	\&#9978;	|	U+26FA	|	—	|	tent (camping site)	|
|	🏕	|	\&#127957;	|	U+1F3D5	|	—	|	camping (camping site)	|
|	⛱	|	\&#9969;	|	U+26F1	|	—	|	umbrella on ground (bathing beach)	|
|	🏖	|	\&#127958;	|	U+1F3D6	|	—	|	beach with umbrella	|
|	⛲	|	\&#9970;	|	U+26F2	|	—	|	fountain (park)	|
|	⚛	|	\&#9883;	|	U+269B	|	—	|	atom symbol (nuclear installation on maps)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Signage

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	ℹ	|	\&#8505;	|	U+2139	|	—	|	information source	|
|	🛈	|	\&#128712;	|	U+1F6C8	|	—	|	circled information source (information)	|
|	✆	|	\&#9990;	|	U+2706	|	—	|	telephone location sign	|
|	🚾	|	\&#128702;	|	U+1F6BE	|	—	|	water closet	|
|	🅏	|	\&#127311;	|	U+1F14F	|	—	|	squared WC (water closet, public toilet)	|
|	🆏	|	\&#127375;	|	U+1F18F	|	—	|	negative squared WC	|
|	🚽	|	\&#128701;	|	U+1F6BD	|	—	|	toilet	|
|	🚹	|	\&#128697;	|	U+1F6B9	|	—	|	mens symbol (man symbol, men's restroom)	|
|	🚺	|	\&#128698;	|	U+1F6BA	|	—	|	womens symbol (woman symbol, women's restroom)	|
|	🚻	|	\&#128699;	|	U+1F6BB	|	—	|	restroom (unisex restroom)	|
|	🚼	|	\&#128700;	|	U+1F6BC	|	—	|	baby symbol (baby on board, baby changing station)	|
|	♿	|	\&#9855;	|	U+267F	|	—	|	wheelchair symbol (accessible place)	|
|	🛗-	|	\&#128727;	|	U+1F6D7	|	—	|	elevator	|
|	🚮	|	\&#128686;	|	U+1F6AE	|	—	|	put litter in its place	|
|	🚯	|	\&#128687;	|	U+1F6AF	|	—	|	do not litter	|
|	🚰	|	\&#128688;	|	U+1F6B0	|	—	|	potable water	|
|	🚱	|	\&#128689;	|	U+1F6B1	|	—	|	non-potable water	|
|	🚬	|	\&#128684;	|	U+1F6AC	|	—	|	smoking	|
|	🚭	|	\&#128685;	|	U+1F6AD	|	—	|	no smoking	|
|	🧍	|	\&#129485;	|	U+1F9CD	|	—	|	standing person	|
|	🚶	|	\&#128694;	|	U+1F6B6	|	—	|	pedestrian (walking)	|
|	🚷	|	\&#128695;	|	U+1F6B7	|	—	|	no pedestrians	|
|	🚲	|	\&#128690;	|	U+1F6B2	|	—	|	bicycle	|
|	🚳	|	\&#128691;	|	U+1F6B3	|	—	|	no bicycles	|
|	⛔	|	\&#9940;	|	U+26D4	|	—	|	no entry	|
|	🚫	|	\&#128683;	|	U+1F6AB	|	—	|	no entry sign	|
|	🔞	|	\&#128286;	|	U+1F51E	|	—	|	no one under eighteen symbol	|
|	🚸	|	\&#128696;	|	U+1F6B8	|	—	|	children crossing	|
|	🚿	|	\&#128703;	|	U+1F6BF	|	—	|	shower	|
|	🛀	|	\&#128704;	|	U+1F6C0	|	—	|	bath	|
|	🛁	|	\&#128705;	|	U+1F6C1	|	—	|	bathtub	|
|	🛂	|	\&#128706;	|	U+1F6C2	|	—	|	passport control	|
|	🛃	|	\&#128707;	|	U+1F6C3	|	—	|	customs	|
|	🛄	|	\&#128708;	|	U+1F6C4	|	—	|	baggage claim	|
|	🛅	|	\&#128709;	|	U+1F6C5	|	—	|	left luggage	|
|	🆔	|	\&#127380;	|	U+1F194	|	—	|	squared ID (identification)	|
|	🆘	|	\&#127384;	|	U+1F198	|	—	|	squared SOS (search, hunt for missing person)	|
|	🪧-	|	\&#129703;	|	U+1FAA7	|	—	|	placard	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Recycling

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	♲	|	\&#9842;	|	U+2672	|	—	|	universal recycling symbol	|
|	♻	|	\&#9851;	|	U+267B	|	—	|	black universal recycling symbol	|
|	♳	|	\&#9843;	|	U+2673	|	—	|	recycling symbol for polyethylene terephthalate	|
|	♴	|	\&#9844;	|	U+2674	|	—	|	recycling symbol for high density polyethylene	|
|	♵	|	\&#9845;	|	U+2675	|	—	|	recycling symbol for vinyl, polyvinyl chloride	|
|	♶	|	\&#9846;	|	U+2676	|	—	|	recycling symbol for low density polyethylene	|
|	♷	|	\&#9847;	|	U+2677	|	—	|	recycling symbol for polypropylene	|
|	♸	|	\&#9848;	|	U+2678	|	—	|	recycling symbol for polystyrene	|
|	♹	|	\&#9849;	|	U+2679	|	—	|	recycling symbol for other plastics	|
|	♼	|	\&#9852;	|	U+267C	|	—	|	recycled paper symbol (100% recycled paper content)	|
|	♽	|	\&#9853;	|	U+267D	|	—	|	partially-recycled paper symbol	|
|	♾	|	\&#9854;	|	U+267E	|	—	|	permanent paper sign (non-acid paper)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Geographic place

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🗽	|	\&#128509;	|	U+1F5FD	|	—	|	Statue of Liberty	|
|	🏰	|	\&#127984;	|	U+1F3F0	|	—	|	European castle	|
|	🏜	|	\&#127964;	|	U+1F3DC	|	—	|	desert	|
|	🏝	|	\&#127965;	|	U+1F3DD	|	—	|	desert island (island)	|
|	⛰	|	\&#9968;	|	U+26F0	|	—	|	mountain	|
|	🏔	|	\&#127956;	|	U+1F3D4	|	—	|	snow capped mountain	|
|	🗻	|	\&#128507;	|	U+1F5FB	|	—	|	mount Fuji	|
|	♨	|	\&#9832;	|	U+2668	|	—	|	hot springs	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## VEHICLES

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🛼-	|	\&#128764;	|	U+1F6FC	|	—	|	roller skate	|
|	🛹	|	\&#128761;	|	U+1F6F9	|	—	|	skateboard	|
|	🛴	|	\&#128756;	|	U+1F6F4	|	—	|	scooter	|
|	🛵	|	\&#128757;	|	U+1F6F5	|	—	|	motor scooter	|
|	🛣	|	\&#128739;	|	U+1F6E3	|	—	|	motorway	|
|	🚑	|	\&#128657;	|	U+1F691	|	—	|	ambulance	|
|	🚒	|	\&#128658;	|	U+1F692	|	—	|	fire engine	|
|	🚓	|	\&#128659;	|	U+1F693	|	—	|	police car	|
|	🚗	|	\&#128663;	|	U+1F697	|	—	|	automobile	|
|	🚙	|	\&#128665;	|	U+1F699	|	—	|	recreational vehicle	|
|	🚘	|	\&#128664;	|	U+1F698	|	—	|	oncoming automobile	|
|	🛻-	|	\&#128763;	|	U+1F6FB	|	—	|	pickup truck	|
|	⛟	|	\&#9951;	|	U+26DF	|	—	|	black truck (black lorry)	|
|	🚚	|	\&#128666;	|	U+1F69A	|	—	|	delivery truck	|
|	🚛	|	\&#128667;	|	U+1F69B	|	—	|	articulated lorry	|
|	🚜	|	\&#128668;	|	U+1F69C	|	—	|	tractor	|
|	🚕	|	\&#128661;	|	U+1F695	|	—	|	taxi	|
|	🛺	|	\&#128762;	|	U+1F6FA	|	—	|	auto rickshaw (tuk-tuk, remorque)	|
|	🚌	|	\&#128652;	|	U+1F68C	|	—	|	bus	|
|	🚐	|	\&#128656;	|	U+1F690	|	—	|	minibus	|
|	🚎	|	\&#128654;	|	U+1F68E	|	—	|	trolleybus	|
|	🛤	|	\&#128740;	|	U+1F6E4	|	—	|	railway track (railroad)	|
|	🚊	|	\&#128650;	|	U+1F68A	|	—	|	tram	|
|	🚋	|	\&#128651;	|	U+1F68B	|	—	|	tram car	|
|	🚝	|	\&#128669;	|	U+1F69D	|	—	|	monorail	|
|	🚇	|	\&#128647;	|	U+1F687	|	—	|	metro (subway, underground train)	|
|	🚈	|	\&#128648;	|	U+1F688	|	—	|	light rail	|
|	🚆	|	\&#128646;	|	U+1F686	|	—	|	train (intercity train)	|
|	🚃	|	\&#128643;	|	U+1F683	|	—	|	railway car	|
|	🚅	|	\&#128645;	|	U+1F685	|	—	|	high-speed train with bullet nose	|
|	🚡	|	\&#128673;	|	U+1F6A1	|	—	|	aerial tramway	|
|	✈	|	\&#9992;	|	U+2708	|	—	|	airplane	|
|	🛩	|	\&#128745;	|	U+1F6E9	|	—	|	small airplane	|
|	🚁	|	\&#128641;	|	U+1F681	|	—	|	helicopter	|
|	🛳	|	\&#128755;	|	U+1F6F3	|	—	|	passenger ship (cruise line vacation)	|
|	🚢	|	\&#128674;	|	U+1F6A2	|	—	|	ship (cruise line vacation)	|
|	⛴	|	\&#9972;	|	U+26F4	|	—	|	ferry (ferry boat terminal)	|
|	🚤	|	\&#128676;	|	U+1F6A4	|	—	|	speedboat	|
|	🛥	|	\&#128741;	|	U+1F6E5	|	—	|	motor boat (boat)	|
|	⛵	|	\&#9973;	|	U+26F5	|	—	|	sailboat (marina or yacht harbor)	|
|	🚣	|	\&#128675;	|	U+1F6A3	|	—	|	rowboat	|
|	🚀	|	\&#128640;	|	U+1F680	|	—	|	rocket	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Traffic Signs

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🚦	|	\&#128678;	|	U+1F6A6	|	—	|	vertical traffic light	|
|	🚥	|	\&#128677;	|	U+1F6A5	|	—	|	horizontal traffic light	|
|	⛽	|	\&#9981;	|	U+26FD	|	—	|	fuel pump (petrol station, gas station)	|
|	🅿	|	\&#127359;	|	U+1F17F	|	—	|	negative squared latin capital letter P (parking space)	|
|	🅟	|	\&#127327;	|	U+1F15F	|	—	|	negative circled latin capital letter P (parking space)	|
|	🚏	|	\&#128655;	|	U+1F68F	|	—	|	bus stop	|
|	🚉	|	\&#128649;	|	U+1F689	|	—	|	station (train, subway station)	|
|	⛍	|	\&#9933;	|	U+26CD	|	—	|	disabled car	|
|	🚧	|	\&#128679;	|	U+1F6A7	|	—	|	construction sign	|
|	🚨	|	\&#128680;	|	U+1F6A8	|	—	|	police cars revolving light (rotating beacon)	|
|	🛇	|	\&#128711;	|	U+1F6C7	|	—	|	prohibited sign	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## BUILDINGS

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	⌂	|	\&#8962;	|	U+2302	|	—	|	house (home)	|
|	🛖-	|	\&#128726;	|	U+1F6D6	|	—	|	hut	|
|	🏠	|	\&#127968;	|	U+1F3E0	|	—	|	house building	|
|	🏡	|	\&#127969;	|	U+1F3E1	|	—	|	house with garden (home, house with yard)	|
|	🏘	|	\&#127960;	|	U+1F3D8	|	—	|	house buildings (town)	|
|	🏚	|	\&#127962;	|	U+1F3DA	|	—	|	derelict house building (derelict site, abandoned)	|
|	🏢	|	\&#127970;	|	U+1F3E2	|	—	|	office building	|
|	🏙	|	\&#127961;	|	U+1F3D9	|	—	|	cityscape (skyline, city)	|
|	🏪	|	\&#127978;	|	U+1F3EA	|	—	|	convenience store	|
|	🏬	|	\&#127980;	|	U+1F3EC	|	—	|	department store	|
|	🏛	|	\&#127963;	|	U+1F3DB	|	—	|	classical building (public building)	|
|	🏨	|	\&#127976;	|	U+1F3E8	|	—	|	hotel	|
|	🏥	|	\&#127973;	|	U+1F3E5	|	—	|	hospital	|
|	🏦	|	\&#127974;	|	U+1F3E6	|	—	|	bank	|
|	🏤	|	\&#127972;	|	U+1F3E4	|	—	|	european post office	|
|	🏫	|	\&#127979;	|	U+1F3EB	|	—	|	school	|
|	🏟	|	\&#127967;	|	U+1F3DF	|	—	|	stadium	|
|	🏭	|	\&#127981;	|	U+1F3ED	|	—	|	factory (industrial production site, date of production)	|
|	🏗	|	\&#127959;	|	U+1F3D7	|	—	|	building construction (under construction)	|
|	🧱	|	\&#129521;	|	U+1F9F1	|	—	|	brick	|
|	🪵-	|	\&#129717;	|	U+1FAB5	|	—	|	wood	|
|	🪨-	|	\&#129704;	|	U+1FAA8	|	—	|	rock	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Office

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	✏	|	\&#9999;	|	U+270F	|	—	|	pencil	|
|	🖊	|	\&#128394;	|	U+1F58A	|	—	|	lower left ballpoint pen (ballpoint pen)	|
|	🖍	|	\&#128397;	|	U+1F58D	|	—	|	lower left crayon	|
|	🖌	|	\&#128396;	|	U+1F58C	|	—	|	lower left paintbrush (brush)	|
|	📏	|	\&#128207;	|	U+1F4CF	|	—	|	straight ruler	|
|	📎	|	\&#128206;	|	U+1F4CE	|	—	|	paperclip	|
|	📌	|	\&#128204;	|	U+1F4CC	|	—	|	pushpin	|
|	🖈	|	\&#128392;	|	U+1F588	|	—	|	black pushpin	|
|	📍	|	\&#128205;	|	U+1F4CD	|	—	|	round pushpin	|
|	📑	|	\&#128209;	|	U+1F4D1	|	—	|	bookmark tabs	|
|	📒	|	\&#128210;	|	U+1F4D2	|	—	|	ledger	|
|	📔	|	\&#128212;	|	U+1F4D4	|	—	|	notebook with decorative cover	|
|	📖	|	\&#128214;	|	U+1F4D6	|	—	|	open book (read operator's manual)	|
|	🕮	|	\&#128366;	|	U+1F56E	|	—	|	book	|
|	📚	|	\&#128218;	|	U+1F4DA	|	—	|	books	|
|	📛	|	\&#128219;	|	U+1F4DB	|	—	|	name badge	|
|	💼	|	\&#128188;	|	U+1F4BC	|	—	|	briefcase	|
|	💺	|	\&#128186;	|	U+1F4BA	|	—	|	seat (intended to denote a reserved or ticketed seat)	|
|	🗃	|	\&#128451;	|	U+1F5C3	|	—	|	card file box (archive)	|
|	🗄	|	\&#128452;	|	U+1F5C4	|	—	|	file cabinet	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Accommodation

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🧳	|	\&#129523;	|	U+1F9F3	|	—	|	luggage	|
|	🚪	|	\&#128682;	|	U+1F6AA	|	—	|	door	|
|	🛎	|	\&#128718;	|	U+1F6CE	|	—	|	bellhop bell (reception, services)	|
|	🛋	|	\&#128715;	|	U+1F6CB	|	—	|	couch and lamp (furniture, lifestyles)	|
|	🛌	|	\&#128716;	|	U+1F6CC	|	—	|	sleeping accommodation (hotel, guestrooms)	|
|	🛏	|	\&#128719;	|	U+1F6CF	|	—	|	bed	|
|	🪑	|	\&#129681;	|	U+1FA91	|	—	|	chair	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Household

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	💡	|	\&#128161;	|	U+1F4A1	|	—	|	electric light bulb (idea)	|
|	🪞-	|	\&#129694;	|	U+1FA9E	|	—	|	mirror	|
|	🪥-	|	\&#129701;	|	U+1FAA5	|	—	|	toothbrush	|
|	🧼	|	\&#129532;	|	U+1F9FC	|	—	|	bar of soap	|
|	🧽	|	\&#129533;	|	U+1F9FD	|	—	|	sponge	|
|	🧻	|	\&#129531;	|	U+1F9FB	|	—	|	roll of paper	|
|	🪠-	|	\&#129696;	|	U+1FAA0	|	—	|	plunger	|
|	🧹	|	\&#129529;	|	U+1F9F9	|	—	|	broom	|
|	🧺	|	\&#129530;	|	U+1F9FA	|	—	|	basket	|
|	🪣-	|	\&#129699;	|	U+1FAA3	|	—	|	bucket	|
|	🪤-	|	\&#129700;	|	U+1FAA4	|	—	|	mouse trap	|
|	🪟-	|	\&#129695;	|	U+1FA9F	|	—	|	window	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## TOOLS

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🧰	|	\&#129520;	|	U+1F9F0	|	—	|	toolbox	|
|	🔦	|	\&#128294;	|	U+1F526	|	—	|	electric torch (flashlight)	|
|	🪛-	|	\&#129691;	|	U+1FA9B	|	—	|	screwdriver	|
|	🔧	|	\&#128295;	|	U+1F527	|	—	|	wrench	|
|	🔨	|	\&#128296;	|	U+1F528	|	—	|	hammer	|
|	⚒	|	\&#9874;	|	U+2692	|	—	|	hammer and pick (mining, working day)	|
|	🛠	|	\&#128736;	|	U+1F6E0	|	—	|	hammer and wrench (tools, repair facility)	|
|	🪓	|	\&#129683;	|	U+1FA93	|	—	|	axe	|
|	🪚-	|	\&#129690;	|	U+1FA9A	|	—	|	carpentry saw	|
|	🔩	|	\&#128297;	|	U+1F529	|	—	|	nut and bolt	|
|	🪝-	|	\&#129693;	|	U+1FA9D	|	—	|	hook	|
|	⚖	|	\&#9878;	|	U+2696	|	—	|	scales (legal term, jurisprudence)	|
|	🔬	|	\&#128300;	|	U+1F52C	|	—	|	microscope	|
|	🔭	|	\&#128301;	|	U+1F52D	|	—	|	telescope	|
|	🧲	|	\&#129522;	|	U+1F9F2	|	—	|	magnet	|
|	🧭	|	\&#129517;	|	U+1F9ED	|	—	|	compass	|
|	🪜-	|	\&#129692;	|	U+1FA9C	|	—	|	ladder	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## FOOD

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🍞	|	\&#127838;	|	U+1F35E	|	—	|	bread	|
|	🥖	|	\&#129366;	|	U+1F956	|	—	|	baguette bread (french bread)	|
|	🫓-	|	\&#129747;	|	U+1FAD3	|	—	|	flatbread	|
|	🥪	|	\&#129386;	|	U+1F96A	|	—	|	sandwich	|
|	🥙	|	\&#129369;	|	U+1F959	|	—	|	stuffed flatbread (döner kebab, gyro, shawarma)	|
|	🌭	|	\&#127789;	|	U+1F32D	|	—	|	hot dog	|
|	🍔	|	\&#127828;	|	U+1F354	|	—	|	hamburger (fast food place)	|
|	🍕	|	\&#127829;	|	U+1F355	|	—	|	slice of pizza	|
|	🥞	|	\&#129374;	|	U+1F95E	|	—	|	pancakes (hotcakes, crêpes, blini)	|
|	🥟	|	\&#129375;	|	U+1F95F	|	—	|	dumpling (potsticker, jiaozi, pierogi, empanada)	|
|	🧈	|	\&#129480;	|	U+1F9C8	|	—	|	butter	|
|	🧀	|	\&#129472;	|	U+1F9C0	|	—	|	cheese wedge	|
|	🥚	|	\&#129370;	|	U+1F95A	|	—	|	egg (chicken egg)	|
|	🥗	|	\&#129367;	|	U+1F957	|	—	|	green salad	|
|	🥬	|	\&#129388;	|	U+1F96C	|	—	|	leafy green (represents cooked vegetables such as kale)	|
|	🥩	|	\&#129385;	|	U+1F969	|	—	|	cut of meat (porkchop, chop, steak)	|
|	🥓	|	\&#129363;	|	U+1F953	|	—	|	bacon	|
|	🍗	|	\&#127831;	|	U+1F357	|	—	|	poultry leg	|
|	🍚	|	\&#127834;	|	U+1F35A	|	—	|	cooked rice (bowl of rice)	|
|	🍜	|	\&#127836;	|	U+1F35C	|	—	|	steaming bowl (ramen noodles)	|
|	🍝	|	\&#127837;	|	U+1F35D	|	—	|	spaghetti	|
|	🍟	|	\&#127839;	|	U+1F35F	|	—	|	french fries	|
|	🍠	|	\&#127840;	|	U+1F360	|	—	|	roasted sweet potato	|
|	🍿	|	\&#127871;	|	U+1F37F	|	—	|	popcorn	|
|	🍣	|	\&#127843;	|	U+1F363	|	—	|	sushi	|
|	🫕-	|	\&#129749;	|	U+1FAD5	|	—	|	fondue	|
|	🍦	|	\&#127846;	|	U+1F366	|	—	|	soft ice cream	|
|	🍨	|	\&#127848;	|	U+1F368	|	—	|	ice cream	|
|	🍩	|	\&#127849;	|	U+1F369	|	—	|	doughnut	|
|	🍪	|	\&#127850;	|	U+1F36A	|	—	|	cookie (biscuit)	|
|	🥐	|	\&#129360;	|	U+1F950	|	—	|	croissant	|
|	🧇	|	\&#129479;	|	U+1F9C7	|	—	|	waffle	|
|	🥨	|	\&#129384;	|	U+1F968	|	—	|	pretzel (can indicate twistiness, intricacy)	|
|	🍫	|	\&#127851;	|	U+1F36B	|	—	|	chocolate bar	|
|	🍬	|	\&#127852;	|	U+1F36C	|	—	|	candy	|
|	🍯	|	\&#127855;	|	U+1F36F	|	—	|	honey pot	|
|	🧁	|	\&#129473;	|	U+1F9C1	|	—	|	cupcake	|
|	🍰	|	\&#127856;	|	U+1F370	|	—	|	shortcake	|
|	🥧	|	\&#129383;	|	U+1F967	|	—	|	pie (may be sweet or savory)	|
|	🥫	|	\&#129387;	|	U+1F96B	|	—	|	canned food	|
|	🧂	|	\&#129474;	|	U+1F9C2	|	—	|	salt shaker	|
|	🧊	|	\&#129482;	|	U+1F9CA	|	—	|	ice cube	|
|	🍲	|	\&#127858;	|	U+1F372	|	—	|	pot of food	|
|	🥣	|	\&#129379;	|	U+1F963	|	—	|	bowl with spoon (can indicate breakfast, cereal, etc.)	|
|	🥡	|	\&#129377;	|	U+1F961	|	—	|	takeout box (take-away box, oyster pail)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Vegetables

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🥒	|	\&#129362;	|	U+1F952	|	—	|	cucumber (pickle)	|
|	🍅	|	\&#127813;	|	U+1F345	|	—	|	tomato	|
|	🫑-	|	\&#129745;	|	U+1FAD1	|	—	|	bell pepper	|
|	🌶	|	\&#127798;	|	U+1F336	|	—	|	hot pepper (hot, spicy)	|
|	🥔	|	\&#129364;	|	U+1F954	|	—	|	potato	|
|	🥕	|	\&#129365;	|	U+1F955	|	—	|	carrot	|
|	🥦	|	\&#129382;	|	U+1F966	|	—	|	broccoli	|
|	🧅	|	\&#129477;	|	U+1F9C5	|	—	|	onion	|
|	🧄	|	\&#129476;	|	U+1F9C4	|	—	|	garlic	|
|	🫒-	|	\&#129746;	|	U+1FAD2	|	—	|	olive	|
|	🍄	|	\&#127812;	|	U+1F344	|	—	|	mushroom	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Fruits and Nuts

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🍎	|	\&#127822;	|	U+1F34E	|	—	|	red apple	|
|	🍏	|	\&#127823;	|	U+1F34F	|	—	|	green apple	|
|	🍐	|	\&#127824;	|	U+1F350	|	—	|	pear	|
|	🍇	|	\&#127815;	|	U+1F347	|	—	|	grapes	|
|	🍒	|	\&#127826;	|	U+1F352	|	—	|	cherries (cherry)	|
|	🍓	|	\&#127827;	|	U+1F353	|	—	|	strawberry	|
|	🫐-	|	\&#129744;	|	U+1FAD0	|	—	|	blueberries	|
|	🍉	|	\&#127817;	|	U+1F349	|	—	|	watermelon	|
|	🍌	|	\&#127820;	|	U+1F34C	|	—	|	banana	|
|	🍍	|	\&#127821;	|	U+1F34D	|	—	|	pineapple	|
|	🥝	|	\&#129373;	|	U+1F95D	|	—	|	kiwifruit	|
|	🥑	|	\&#129361;	|	U+1F951	|	—	|	avocado	|
|	🥭	|	\&#129389;	|	U+1F96D	|	—	|	mango	|
|	🍋	|	\&#127819;	|	U+1F34B	|	—	|	lemon	|
|	🥥	|	\&#129381;	|	U+1F965	|	—	|	coconut	|
|	🥜	|	\&#129372;	|	U+1F95C	|	—	|	peanuts	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Beverages

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	☕	|	\&#9749;	|	U+2615	|	—	|	hot beverage (tea or coffee, indicate a wait)	|
|	🥛	|	\&#129371;	|	U+1F95B	|	—	|	glass of milk (milk)	|
|	🍺	|	\&#127866;	|	U+1F37A	|	—	|	beer mug	|
|	🍻	|	\&#127867;	|	U+1F37B	|	—	|	clinking beer mugs (cheers)	|
|	🥂	|	\&#129346;	|	U+1F942	|	—	|	clinking glasses (celebration, formal toasting)	|
|	🍷	|	\&#127863;	|	U+1F377	|	—	|	wine glass	|
|	🍸	|	\&#127864;	|	U+1F378	|	—	|	cocktail glass (lounge)	|
|	🥃	|	\&#129347;	|	U+1F943	|	—	|	tumbler glass (whisky, typically shown with ice)	|
|	🍹	|	\&#127865;	|	U+1F379	|	—	|	tropical drink	|
|	🥤	|	\&#129380;	|	U+1F964	|	—	|	cup with straw (can indicate soda, juice, etc.)	|
|	🧃	|	\&#129475;	|	U+1F9C3	|	—	|	beverage box	|
|	🍾	|	\&#127870;	|	U+1F37E	|	—	|	bottle with popping cork	|
|	🍼	|	\&#127868;	|	U+1F37C	|	—	|	baby bottle	|
|	🫖-	|	\&#129750;	|	U+1FAD6	|	—	|	teapot	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Kitchenware

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🍳	|	\&#127859;	|	U+1F373	|	—	|	cooking (frying pan, cooking utensil)	|
|	🥄	|	\&#129348;	|	U+1F944	|	—	|	spoon	|
|	🍴	|	\&#127860;	|	U+1F374	|	—	|	fork and knife (restaurant, meal)	|
|	🍽	|	\&#127869;	|	U+1F37D	|	—	|	fork and knife with plate (dining)	|
|	🥢	|	\&#129378;	|	U+1F962	|	—	|	chopsticks (kuaizi, hashi, jeotgarak)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## PLANT, TREES

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	⸙	|	\&#11801;	|	U+2E19	|	—	|	palm branch (used as a separator)	|
|	🌴	|	\&#127796;	|	U+1F334	|	—	|	palm tree	|
|	🌵	|	\&#127797;	|	U+1F335	|	—	|	cactus	|
|	🌲	|	\&#127794;	|	U+1F332	|	—	|	evergreen tree	|
|	🌿	|	\&#127807;	|	U+1F33F	|	—	|	herb	|
|	🍀	|	\&#127808;	|	U+1F340	|	—	|	four leaf clover	|
|	🍁	|	\&#127809;	|	U+1F341	|	—	|	maple leaf	|
|	🍂	|	\&#127810;	|	U+1F342	|	—	|	fallen leaf	|
|	🍃	|	\&#127811;	|	U+1F343	|	—	|	leaf fluttering in wind	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## ANIMALS

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🐈	|	\&#128008;	|	U+1F408	|	—	|	cat	|
|	🐕	|	\&#128021;	|	U+1F415	|	—	|	dog (eleventh of the signs of the Asian zodiac)	|
|	🐀	|	\&#128000;	|	U+1F400	|	—	|	rat (first of the signs of the Asian zodiac)	|
|	🐁	|	\&#128001;	|	U+1F401	|	—	|	mouse	|
|	🦔	|	\&#129428;	|	U+1F994	|	—	|	hedgehog	|
|	🦎	|	\&#129422;	|	U+1F98E	|	—	|	lizard	|
|	🦂	|	\&#129410;	|	U+1F982	|	—	|	scorpion (used for scorpio)	|
|	🐍	|	\&#128013;	|	U+1F40D	|	—	|	snake (sixth of the signs of the Asian zodiac)	|
|	🐇	|	\&#128007;	|	U+1F407	|	—	|	rabbit (fourth of the signs of the Asian zodiac)	|
|	🐿	|	\&#128063;	|	U+1F43F	|	—	|	chipmunk (animal, critter, also represents a squirrel)	|
|	🦡	|	\&#129441;	|	U+1F9A1	|	—	|	badger	|
|	🦝	|	\&#129437;	|	U+1F99D	|	—	|	raccoon	|
|	🦫-	|	\&#129451;	|	U+1F9AB	|	—	|	beaver	|
|	🦨	|	\&#129448;	|	U+1F9A8	|	—	|	skunk	|
|	🦊	|	\&#129418;	|	U+1F98A	|	—	|	fox face	|
|	🐖	|	\&#128022;	|	U+1F416	|	—	|	pig, pork on menus (twelfth sign of the Asian zodiac)	|
|	🐗	|	\&#128023;	|	U+1F417	|	—	|	boar	|
|	🐒	|	\&#128018;	|	U+1F412	|	—	|	monkey (ninth of the signs of the Asian zodiac)	|
|	🦧	|	\&#129447;	|	U+1F9A7	|	—	|	orangutan	|
|	🦍	|	\&#129421;	|	U+1F98D	|	—	|	gorilla	|
|	🐄	|	\&#128004;	|	U+1F404	|	—	|	cow, beef (on menus)	|
|	🐂	|	\&#128002;	|	U+1F402	|	—	|	ox (second of the signs of the Asian zodiac)	|
|	🐏	|	\&#128015;	|	U+1F40F	|	—	|	ram (eighth of the signs of the Asian zodiac)	|
|	🐐	|	\&#128016;	|	U+1F410	|	—	|	goat	|
|	🐑	|	\&#128017;	|	U+1F411	|	—	|	sheep	|
|	🦌	|	\&#129420;	|	U+1F98C	|	—	|	deer	|
|	🦁	|	\&#129409;	|	U+1F981	|	—	|	lion face (used for leo)	|
|	🐅	|	\&#128005;	|	U+1F405	|	—	|	tiger (third of the signs of the Asian zodiac)	|
|	🐆	|	\&#128006;	|	U+1F406	|	—	|	leopard	|
|	🦬-	|	\&#129452;	|	U+1F9AC	|	—	|	bison	|
|	🦏	|	\&#129423;	|	U+1F98F	|	—	|	rhinoceros	|
|	🦛	|	\&#129435;	|	U+1F99B	|	—	|	hippopotamus	|
|	🦘	|	\&#129432;	|	U+1F998	|	—	|	kangaroo	|
|	🦥	|	\&#129445;	|	U+1F9A5	|	—	|	sloth	|
|	🐨	|	\&#128040;	|	U+1F428	|	—	|	koala	|
|	🦒	|	\&#129426;	|	U+1F992	|	—	|	giraffe face	|
|	🦓	|	\&#129427;	|	U+1F993	|	—	|	zebra face	|
|	🐎	|	\&#128014;	|	U+1F40E	|	—	|	horse, equestrian sports (seventh sign of Asian zodiac)	|
|	♘	|	\&#9816;	|	U+2658	|	—	|	white chess knight	|
|	♞	|	\&#9822;	|	U+265E	|	—	|	black chess knight	|
|	🦄	|	\&#129412;	|	U+1F984	|	—	|	unicorn face	|
|	🐘	|	\&#128024;	|	U+1F418	|	—	|	elephant	|
|	🐪	|	\&#128042;	|	U+1F42A	|	—	|	dromedary camel (has a single hump)	|
|	🐫	|	\&#128043;	|	U+1F42B	|	—	|	bactrian camel (has two humps)	|
|	🦙	|	\&#129433;	|	U+1F999	|	—	|	llama	|
|	🐉	|	\&#128009;	|	U+1F409	|	—	|	dragon (fifth of the signs of the Asian zodiac)	|
|	🦖	|	\&#129430;	|	U+1F996	|	—	|	T-rex (tyrannosaurus rex)	|
|	🦣-	|	\&#129443;	|	U+1F9A3	|	—	|	mammoth (indicates great size)	|
|	🦤-	|	\&#129444;	|	U+1F9A4	|	—	|	dodo (indicates extinction)	|
|	🐾	|	\&#128062;	|	U+1F43E	|	—	|	paw prints	|
|	💩	|	\&#128169;	|	U+1F4A9	|	—	|	pile of poo (dog dirt; may be with/without a friendly face)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Watery

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🐚	|	\&#128026;	|	U+1F41A	|	—	|	spiral shell	|
|	🐌	|	\&#128012;	|	U+1F40C	|	—	|	snail	|
|	🦪	|	\&#129450;	|	U+1F9AA	|	—	|	oyster	|
|	🦐	|	\&#129424;	|	U+1F990	|	—	|	shrimp	|
|	🦀	|	\&#129408;	|	U+1F980	|	—	|	crab (used for Cancer)	|
|	🦑	|	\&#129425;	|	U+1F991	|	—	|	squid	|
|	🐙	|	\&#128025;	|	U+1F419	|	—	|	octopus	|
|	🦞	|	\&#129438;	|	U+1F99E	|	—	|	lobster	|
|	🐟	|	\&#128031;	|	U+1F41F	|	—	|	fish	|
|	🐋	|	\&#128011;	|	U+1F40B	|	—	|	whale	|
|	🐬	|	\&#128044;	|	U+1F42C	|	—	|	dolphin	|
|	🦈	|	\&#129416;	|	U+1F988	|	—	|	shark	|
|	🐊	|	\&#128010;	|	U+1F40A	|	—	|	crocodile	|
|	🐢	|	\&#128034;	|	U+1F422	|	—	|	turtle (tortoise, terrapin)	|
|	🐧	|	\&#128039;	|	U+1F427	|	—	|	penguin	|
|	🦭-	|	\&#129453;	|	U+1F9AD	|	—	|	seal	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Bugs

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🐛	|	\&#128027;	|	U+1F41B	|	—	|	bug	|
|	🪱-	|	\&#129713;	|	U+1FAB1	|	—	|	worm	|
|	🪲-	|	\&#129714;	|	U+1FAB2	|	—	|	beetle	|
|	🪳-	|	\&#129715;	|	U+1FAB3	|	—	|	cockroach	|
|	🐜	|	\&#128028;	|	U+1F41C	|	—	|	ant	|
|	🦗	|	\&#129431;	|	U+1F997	|	—	|	cricket	|
|	🕷	|	\&#128375;	|	U+1F577	|	—	|	spider	|
|	🕸	|	\&#128376;	|	U+1F578	|	—	|	spider web	|
|	🦠	|	\&#129440;	|	U+1F9A0	|	—	|	microbe (microorganism, covers bacteria, viruses, etc.)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Fowl

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🐣	|	\&#128035;	|	U+1F423	|	—	|	hatching chick	|
|	🐤	|	\&#128036;	|	U+1F424	|	—	|	baby chick	|
|	🐔	|	\&#128020;	|	U+1F414	|	—	|	chicken, hen, poultry (tenth sign of the Asian zodiac)	|
|	🐓	|	\&#128019;	|	U+1F413	|	—	|	rooster, cock (tenth of the signs of the Asian zodiac)	|
|	🦆	|	\&#129414;	|	U+1F986	|	—	|	duck	|
|	🦃	|	\&#129411;	|	U+1F983	|	—	|	turkey	|
|	🪶-	|	\&#129718;	|	U+1FAB6	|	—	|	feather	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Flying

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🦟	|	\&#129439;	|	U+1F99F	|	—	|	mosquito	|
|	🪰-	|	\&#129712;	|	U+1FAB0	|	—	|	fly	|
|	🐝	|	\&#128029;	|	U+1F41D	|	—	|	honeybee	|
|	🐞	|	\&#128030;	|	U+1F41E	|	—	|	lady beetle (ladybird, ladybug, coccinellids)	|
|	🦋	|	\&#129419;	|	U+1F98B	|	—	|	butterfly	|
|	🐦	|	\&#128038;	|	U+1F426	|	—	|	bird	|
|	🕊	|	\&#128330;	|	U+1F54A	|	—	|	dove of peace	|
|	🦜	|	\&#129436;	|	U+1F99C	|	—	|	parrot	|
|	🦇	|	\&#129415;	|	U+1F987	|	—	|	bat	|
|	🦉	|	\&#129417;	|	U+1F989	|	—	|	owl	|
|	🦢	|	\&#129442;	|	U+1F9A2	|	—	|	swan	|
|	🦅	|	\&#129413;	|	U+1F985	|	—	|	eagle	|
|	🦚	|	\&#129434;	|	U+1F99A	|	—	|	peacock	|
|	🦩	|	\&#129449;	|	U+1F9A9	|	—	|	flamingo	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## CLOTHING

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	👕	|	\&#128085;	|	U+1F455	|	—	|	T-shirt	|
|	🩳	|	\&#129651;	|	U+1FA73	|	—	|	shorts	|
|	🧦	|	\&#129510;	|	U+1F9E6	|	—	|	socks	|
|	👔	|	\&#128084;	|	U+1F454	|	—	|	necktie	|
|	👖	|	\&#128086;	|	U+1F456	|	—	|	jeans	|
|	👗	|	\&#128087;	|	U+1F457	|	—	|	dress	|
|	👚	|	\&#128090;	|	U+1F45A	|	—	|	womans clothes	|
|	👙	|	\&#128089;	|	U+1F459	|	—	|	bikini	|
|	🩱	|	\&#129649;	|	U+1FA71	|	—	|	one-piece swimsuit	|
|	🩲	|	\&#129650;	|	U+1FA72	|	—	|	briefs	|
|	👘	|	\&#128088;	|	U+1F458	|	—	|	kimono	|
|	🥼	|	\&#129404;	|	U+1F97C	|	—	|	lab coat	|
|	🧥	|	\&#129509;	|	U+1F9E5	|	—	|	coat	|
|	🧤	|	\&#129508;	|	U+1F9E4	|	—	|	gloves	|
|	🧣	|	\&#129507;	|	U+1F9E3	|	—	|	scarf	|
|	🦺	|	\&#129466;	|	U+1F9BA	|	—	|	safety vest	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Headwear

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🧢	|	\&#129506;	|	U+1F9E2	|	—	|	billed cap (baseball cap)	|
|	👒	|	\&#128082;	|	U+1F452	|	—	|	womans hat	|
|	👑	|	\&#128081;	|	U+1F451	|	—	|	crown	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Footwear

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	👞	|	\&#128094;	|	U+1F45E	|	—	|	mans shoe	|
|	👟	|	\&#128095;	|	U+1F45F	|	—	|	athletic shoe (runner, sneaker, tennis shoe)	|
|	🥾	|	\&#129406;	|	U+1F97E	|	—	|	hiking boot	|
|	🥿	|	\&#129407;	|	U+1F97F	|	—	|	flat shoe	|
|	🩴-	|	\&#129652;	|	U+1FA74	|	—	|	thong sandal	|
|	👡	|	\&#128097;	|	U+1F461	|	—	|	womans sandal	|
|	👠	|	\&#128096;	|	U+1F460	|	—	|	high-heeled shoe	|
|	👢	|	\&#128098;	|	U+1F462	|	—	|	womans boots	|
|	👣	|	\&#128099;	|	U+1F463	|	—	|	footprints	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Glasses

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	👓	|	\&#128083;	|	U+1F453	|	—	|	eyeglasses	|
|	🕶	|	\&#128374;	|	U+1F576	|	—	|	dark sunglasses (cool)	|
|	🥽	|	\&#129405;	|	U+1F97D	|	—	|	goggles	|
|	🤿	|	\&#129343;	|	U+1F93F	|	—	|	diving mask	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Handbags

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	👛	|	\&#128091;	|	U+1F45B	|	—	|	purse	|
|	👝	|	\&#128093;	|	U+1F45D	|	—	|	pouch	|
|	👜	|	\&#128092;	|	U+1F45C	|	—	|	handbag	|
|	🛍	|	\&#128717;	|	U+1F6CD	|	—	|	shopping bags (shopping)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Sewing

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🧵	|	\&#129525;	|	U+1F9F5	|	—	|	spool of thread	|
|	🧶	|	\&#129526;	|	U+1F9F6	|	—	|	ball of yarn	|
|	🪡-	|	\&#129697;	|	U+1FAA1	|	—	|	sewing needle	|
|	🧷	|	\&#129527;	|	U+1F9F7	|	—	|	safety pin	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## PERSONAL CARE

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	✄	|	\&#9988;	|	U+2704	|	—	|	white scissors	|
|	✀	|	\&#9984;	|	U+2700	|	—	|	black safety scissors	|
|	💇	|	\&#128135;	|	U+1F487	|	—	|	haircut (usually indicates a beauty parlor)	|
|	🪒	|	\&#129682;	|	U+1FA92	|	—	|	razor	|
|	🧴	|	\&#129524;	|	U+1F9F4	|	—	|	lotion bottle	|
|	💄	|	\&#128132;	|	U+1F484	|	—	|	lipstick	|
|	💅	|	\&#128133;	|	U+1F485	|	—	|	nail polish (manicure, nail care)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## MEDICAL

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🩺	|	\&#129658;	|	U+1FA7A	|	—	|	stethoscope	|
|	💉	|	\&#128137;	|	U+1F489	|	—	|	syringe	|
|	💊	|	\&#128138;	|	U+1F48A	|	—	|	pill	|
|	🩹	|	\&#129657;	|	U+1FA79	|	—	|	adhesive bandage	|
|	🧘	|	\&#129496;	|	U+1F9D8	|	—	|	person in lotus position (yoga, meditation)	|
|	🧪	|	\&#129514;	|	U+1F9EA	|	—	|	test tube	|
|	🧫	|	\&#129515;	|	U+1F9EB	|	—	|	petri dish	|
|	🩸	|	\&#129656;	|	U+1FA78	|	—	|	drop of blood	|
|	🧬	|	\&#129516;	|	U+1F9EC	|	—	|	DNA double helix	|
|	℞	|	\&#8478;	|	U+211E	|	\&rx;	|	prescription take (recipe)	|
|	🕏-	|	\&#128335;	|	U+1F54F	|	—	|	bowl of hygieia	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Facial Parts

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	👄	|	\&#128068;	|	U+1F444	|	—	|	mouth	|
|	👀	|	\&#128064;	|	U+1F440	|	—	|	eyes	|
|	👁	|	\&#128065;	|	U+1F441	|	—	|	eye (sight)	|
|	👂	|	\&#128066;	|	U+1F442	|	—	|	ear	|
|	👃	|	\&#128067;	|	U+1F443	|	—	|	nose	|
|	👅	|	\&#128069;	|	U+1F445	|	—	|	tongue	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Body Parts

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🧠	|	\&#129504;	|	U+1F9E0	|	—	|	brain	|
|	🫀-	|	\&#129728;	|	U+1FAC0	|	—	|	anatomical heart	|
|	🫁-	|	\&#129729;	|	U+1FAC1	|	—	|	lungs	|
|	🦴	|	\&#129460;	|	U+1F9B4	|	—	|	bone	|
|	🦵	|	\&#129461;	|	U+1F9B5	|	—	|	leg	|
|	🦶	|	\&#129462;	|	U+1F9B6	|	—	|	foot	|
|	🦷	|	\&#129463;	|	U+1F9B7	|	—	|	tooth	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## COMMUNICATION

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	📱	|	\&#128241;	|	U+1F4F1	|	—	|	mobile phone (smartphone)	|
|	📳	|	\&#128243;	|	U+1F4F3	|	—	|	vibration mode	|
|	📴	|	\&#128244;	|	U+1F4F4	|	—	|	mobile phone off	|
|	📵	|	\&#128245;	|	U+1F4F5	|	—	|	no mobile phones	|
|	📶	|	\&#128246;	|	U+1F4F6	|	—	|	antenna with bars (cellular reception)	|
|	📞	|	\&#128222;	|	U+1F4DE	|	—	|	telephone receiver	|
|	🛰	|	\&#128752;	|	U+1F6F0	|	—	|	satellite	|
|	📡	|	\&#128225;	|	U+1F4E1	|	—	|	satellite antenna (position indicator, news)	|
|	🔈	|	\&#128264;	|	U+1F508	|	—	|	speaker (left speaker)	|
|	🔉	|	\&#128265;	|	U+1F509	|	—	|	speaker with one sound wave	|
|	🔊	|	\&#128266;	|	U+1F50A	|	—	|	speaker with three sound waves (sound)	|
|	🕨	|	\&#128360;	|	U+1F568	|	—	|	right speaker	|
|	🔇	|	\&#128263;	|	U+1F507	|	—	|	speaker with cancellation stroke	|
|	📢	|	\&#128226;	|	U+1F4E2	|	—	|	public address loudspeaker	|
|	🕬	|	\&#128364;	|	U+1F56C	|	—	|	bullhorn with sound waves	|
|	📝	|	\&#128221;	|	U+1F4DD	|	—	|	memo	|
|	📧	|	\&#128231;	|	U+1F4E7	|	—	|	e-mail symbol (glyph may show "e" instead of "@")	|
|	📥	|	\&#128229;	|	U+1F4E5	|	—	|	inbox tray	|
|	📤	|	\&#128228;	|	U+1F4E4	|	—	|	outbox tray	|
|	✉	|	\&#9993;	|	U+2709	|	—	|	envelope (sealed envelope)	|
|	🖂	|	\&#128386;	|	U+1F582	|	—	|	back of envelope	|
|	🖃	|	\&#128387;	|	U+1F583	|	—	|	stamped envelope (mail)	|
|	📪	|	\&#128234;	|	U+1F4EA	|	—	|	closed mailbox with lowered flag (letter box, empty)	|
|	📫	|	\&#128235;	|	U+1F4EB	|	—	|	closed mailbox with raised flag (containing mail)	|
|	📮	|	\&#128238;	|	U+1F4EE	|	—	|	postbox (mailbox for sending mail)	|
|	📦	|	\&#128230;	|	U+1F4E6	|	—	|	package	|
|	📰	|	\&#128240;	|	U+1F4F0	|	—	|	newspaper	|
|	🗞	|	\&#128478;	|	U+1F5DE	|	—	|	rolled-up newspaper	|
|	🗟	|	\&#128479;	|	U+1F5DF	|	—	|	page with circled text (classified)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Audio and Video

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	📷	|	\&#128247;	|	U+1F4F7	|	—	|	camera	|
|	📸	|	\&#128248;	|	U+1F4F8	|	—	|	camera with flash	|
|	📹	|	\&#128249;	|	U+1F4F9	|	—	|	video camera (video)	|
|	📺	|	\&#128250;	|	U+1F4FA	|	—	|	television (TV)	|
|	📻	|	\&#128251;	|	U+1F4FB	|	—	|	radio	|
|	📽	|	\&#128253;	|	U+1F4FD	|	—	|	film projector (movies)	|
|	📾	|	\&#128254;	|	U+1F4FE	|	—	|	portable stereo (stereo)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Musical

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	𝄞	|	\&#119070;	|	U+1D11E	|	—	|	musical symbol g clef	|
|	𝅗𝅥	|	\&#119134;	|	U+1D15E	|	—	|	musical symbol half note (minim)	|
|	♩	|	\&#9833;	|	U+2669	|	—	|	quarter note (crotchet)	|
|	♪	|	\&#9834;	|	U+266A	|	\&sung;	|	eighth note (quaver)	|
|	𝅘𝅥𝅯	|	\&#119137;	|	U+1D161	|	—	|	musical symbol sixteenth note (semiquaver)	|
|	🎵	|	\&#127925;	|	U+1F3B5	|	—	|	musical note (music, being in good mood)	|
|	♫	|	\&#9835;	|	U+266B	|	—	|	beamed eighth notes (beamed quavers)	|
|	🎜	|	\&#127900;	|	U+1F39C	|	—	|	beamed ascending musical notes (always ascending)	|
|	🎝	|	\&#127901;	|	U+1F39D	|	—	|	beamed descending musical notes (always descending)	|
|	♬	|	\&#9836;	|	U+266C	|	—	|	beamed sixteenth notes (beamed semiquavers)	|
|	♭	|	\&#9837;	|	U+266D	|	\&flat;	|	music flat sign	|
|	♮	|	\&#9838;	|	U+266E	|	\&natural;	|	music natural sign	|
|	♯	|	\&#9839;	|	U+266F	|	\&sharp;	|	music sharp sign	|
|	🎧	|	\&#127911;	|	U+1F3A7	|	—	|	headphone (music)	|
|	🎤	|	\&#127908;	|	U+1F3A4	|	—	|	microphone (karaoke)	|
|	🎚	|	\&#127898;	|	U+1F39A	|	—	|	level slider (level control)	|
|	🎛	|	\&#127899;	|	U+1F39B	|	—	|	control knobs (audio control)	|
|	🎹	|	\&#127929;	|	U+1F3B9	|	—	|	musical keyboard	|
|	🎸	|	\&#127928;	|	U+1F3B8	|	—	|	guitar	|
|	🎷	|	\&#127927;	|	U+1F3B7	|	—	|	saxophone	|
|	🎺	|	\&#127930;	|	U+1F3BA	|	—	|	trumpet	|
|	🪗-	|	\&#129687;	|	U+1FA97	|	—	|	accordion	|
|	🪕	|	\&#129685;	|	U+1FA95	|	—	|	banjo	|
|	🥁	|	\&#129345;	|	U+1F941	|	—	|	drum with drumsticks	|
|	🪘-	|	\&#129688;	|	U+1FA98	|	—	|	long drum	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## USER INTERFACE

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	⚙	|	\&#9881;	|	U+2699	|	—	|	gear (technology, tools)	|
|	⛭	|	\&#9965;	|	U+26ED	|	—	|	gear without hub	|
|	☰	|	\&#9776;	|	U+2630	|	—	|	trigram for heaven (three lines menu, burger, qian2)	|
|	⋯	|	\&#8943;	|	U+22EF	|	\&ctdot;	|	midline horizontal ellipsis	|
|	⋮	|	\&#8942;	|	U+22EE	|	\&vellip;	|	vertical ellipsis	|
|	⋱	|	\&#8945;	|	U+22F1	|	\&dtdot;	|	down right diagonal ellipsis	|
|	⏯	|	\&#9199;	|	U+23EF	|	—	|	play/pause toggle	|
|	⏪	|	\&#9194;	|	U+23EA	|	—	|	black left-pointing double triangle (fast rewind)	|
|	⏮	|	\&#9198;	|	U+23EE	|	—	|	skip to the start or previous file/track/chapter	|
|	⏩	|	\&#9193;	|	U+23E9	|	—	|	black right-pointing double triangle (fast forward)	|
|	⏭	|	\&#9197;	|	U+23ED	|	—	|	skip to the end or next file/track/chapter	|
|	⏸	|	\&#9208;	|	U+23F8	|	—	|	double vertical bar (pause)	|
|	⏹	|	\&#9209;	|	U+23F9	|	—	|	black square for stop	|
|	⏺	|	\&#9210;	|	U+23FA	|	—	|	black circle for record	|
|	⏏	|	\&#9167;	|	U+23CF	|	—	|	eject	|
|	🔀	|	\&#128256;	|	U+1F500	|	—	|	twisted rightwards arrows (shuffle)	|
|	🔁	|	\&#128257;	|	U+1F501	|	—	|	clockwise rightwards and leftwards (repeat)	|
|	🔂	|	\&#128258;	|	U+1F502	|	—	|	clockwise right/leftwards (repeat one item over)	|
|	🔃	|	\&#128259;	|	U+1F503	|	—	|	clockwise downwards and upwards (reload)	|
|	🔄	|	\&#128260;	|	U+1F504	|	—	|	anticlockwise down/upwards (reload)	|
|	⟳	|	\&#10227;	|	U+27F3	|	—	|	clockwise gapped circle arrow	|
|	⟲	|	\&#10226;	|	U+27F2	|	—	|	anticlockwise gapped circle arrow	|
|	⭮	|	\&#11118;	|	U+2B6E	|	—	|	clockwise triangle-headed open circle arrow	|
|	⭯	|	\&#11119;	|	U+2B6F	|	—	|	anticlockwise triangle-headed open circle arrow	|
|	🔅	|	\&#128261;	|	U+1F505	|	—	|	low brightness symbol	|
|	🔆	|	\&#128262;	|	U+1F506	|	—	|	high brightness symbol	|
|	🆛-	|	\&#127387;	|	U+1F19B	|	—	|	squared three D (3D)	|
|	🆝-	|	\&#127389;	|	U+1F19D	|	—	|	squared two K (2K)	|
|	🆞-	|	\&#127390;	|	U+1F19E	|	—	|	squared four K (4K)	|
|	🆟-	|	\&#127391;	|	U+1F19F	|	—	|	squared eight K (8K)	|
|	🆠-	|	\&#127392;	|	U+1F1A0	|	—	|	squared five point one (5.1-channel surround sound)	|
|	🆡-	|	\&#127393;	|	U+1F1A1	|	—	|	squared seven point one (7.1-channel surround sound)	|
|	🆧-	|	\&#127399;	|	U+1F1A7	|	—	|	squared HDR (high dynamic range)	|
|	🆫-	|	\&#127403;	|	U+1F1AB	|	—	|	squared UHD (ultra-high definition)	|
|	🔋	|	\&#128267;	|	U+1F50B	|	—	|	battery	|
|	🔌	|	\&#128268;	|	U+1F50C	|	—	|	electric plug	|
|	⏻-	|	\&#9211;	|	U+23FB	|	—	|	power symbol (IEC 5009 standby, IEEE 1621 power)	|
|	⏼-	|	\&#9212;	|	U+23FC	|	—	|	power on-off symbol (IEC 5010 power on-off symbol)	|
|	⏽-	|	\&#9213;	|	U+23FD	|	—	|	power on symbol	|
|	⏾-	|	\&#9214;	|	U+23FE	|	—	|	power sleep symbol (from IEEE 1621−2004)	|
|	⭘	|	\&#11096;	|	U+2B58	|	—	|	power off symbol	|
|	🔍	|	\&#128269;	|	U+1F50D	|	—	|	left-pointing magnifying glass (search, zoom)	|
|	🔎	|	\&#128270;	|	U+1F50E	|	—	|	right-pointing magnifying glass (get more details)	|
|	🔒	|	\&#128274;	|	U+1F512	|	—	|	lock (padlock in locked position)	|
|	🔓	|	\&#128275;	|	U+1F513	|	—	|	open lock	|
|	🔐	|	\&#128272;	|	U+1F510	|	—	|	closed lock with key (secure, password, https, SSL)	|
|	🔏	|	\&#128271;	|	U+1F50F	|	—	|	lock with ink pen (privacy)	|
|	⚿	|	\&#9919;	|	U+26BF	|	—	|	squared key (parental lock)	|
|	🔑	|	\&#128273;	|	U+1F511	|	—	|	key	|
|	⍾	|	\&#9086;	|	U+237E	|	—	|	bell symbol (from ISO 2047)	|
|	🔔	|	\&#128276;	|	U+1F514	|	—	|	bell	|
|	🕭	|	\&#128365;	|	U+1F56D	|	—	|	ringing bell	|
|	🔕	|	\&#128277;	|	U+1F515	|	—	|	bell with cancellation stroke	|
|	🔖	|	\&#128278;	|	U+1F516	|	—	|	bookmark	|
|	🏷	|	\&#127991;	|	U+1F3F7	|	—	|	label (price, price tag)	|
|	🔗	|	\&#128279;	|	U+1F517	|	—	|	link symbol	|
|	🔠	|	\&#128288;	|	U+1F520	|	—	|	input symbol for Latin capital letters	|
|	🔡	|	\&#128289;	|	U+1F521	|	—	|	input symbol for Latin small letters	|
|	🔤	|	\&#128292;	|	U+1F524	|	—	|	input symbol for Latin letters	|
|	🔢	|	\&#128290;	|	U+1F522	|	—	|	input symbol for numbers	|
|	🔣	|	\&#128291;	|	U+1F523	|	—	|	input symbol for symbols	|
|	🖿	|	\&#128447;	|	U+1F5BF	|	—	|	black folder	|
|	🗀	|	\&#128448;	|	U+1F5C0	|	—	|	folder (directory)	|
|	🗁	|	\&#128449;	|	U+1F5C1	|	—	|	open folder	|
|	🗋	|	\&#128459;	|	U+1F5CB	|	—	|	empty document	|
|	🗎	|	\&#128462;	|	U+1F5CE	|	—	|	document	|
|	🖹	|	\&#128441;	|	U+1F5B9	|	—	|	document with text	|
|	🖺	|	\&#128442;	|	U+1F5BA	|	—	|	document with text and picture	|
|	🖻	|	\&#128443;	|	U+1F5BB	|	—	|	document with picture (graphic document)	|
|	📄	|	\&#128196;	|	U+1F4C4	|	—	|	page facing up	|
|	🗐	|	\&#128464;	|	U+1F5D0	|	—	|	pages	|
|	🗅	|	\&#128453;	|	U+1F5C5	|	—	|	empty note	|
|	🗈	|	\&#128456;	|	U+1F5C8	|	—	|	note	|
|	📈	|	\&#128200;	|	U+1F4C8	|	—	|	chart with upwards trend	|
|	📉	|	\&#128201;	|	U+1F4C9	|	—	|	chart with downwards trend	|
|	📊	|	\&#128202;	|	U+1F4CA	|	—	|	bar chart	|
|	🗠	|	\&#128480;	|	U+1F5E0	|	—	|	stock chart (finance)	|
|	🗒	|	\&#128466;	|	U+1F5D2	|	—	|	spiral note pad (note, empty calendar)	|
|	📅	|	\&#128197;	|	U+1F4C5	|	—	|	calendar	|
|	📆	|	\&#128198;	|	U+1F4C6	|	—	|	tear-off calendar	|
|	📋	|	\&#128203;	|	U+1F4CB	|	—	|	clipboard	|
|	🗜	|	\&#128476;	|	U+1F5DC	|	—	|	compression (depicts a hand press with a box inside)	|
|	🗑	|	\&#128465;	|	U+1F5D1	|	—	|	wastebasket (trashcan)	|
|	⌫	|	\&#9003;	|	U+232B	|	—	|	erase to the left	|
|	⎌	|	\&#9100;	|	U+238C	|	—	|	undo	|
|	🗔	|	\&#128468;	|	U+1F5D4	|	—	|	desktop window	|
|	🗕	|	\&#128469;	|	U+1F5D5	|	—	|	minimize	|
|	🗖	|	\&#128470;	|	U+1F5D6	|	—	|	maximize	|
|	🗗	|	\&#128471;	|	U+1F5D7	|	—	|	overlap (overlapping offset windows)	|
|	🗘	|	\&#128472;	|	U+1F5D8	|	—	|	clockwise right and left semicircle arrows (refresh)	|
|	🗙	|	\&#128473;	|	U+1F5D9	|	—	|	cancellation X (close)	|
|	🗚	|	\&#128474;	|	U+1F5DA	|	—	|	increase font size	|
|	🗛	|	\&#128475;	|	U+1F5DB	|	—	|	decrease font size	|
|	🔲	|	\&#128306;	|	U+1F532	|	—	|	black square button	|
|	🔳	|	\&#128307;	|	U+1F533	|	—	|	white square button	|
|	🔘	|	\&#128280;	|	U+1F518	|	—	|	radio button	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Computer

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	💻	|	\&#128187;	|	U+1F4BB	|	—	|	personal computer	|
|	🖥	|	\&#128421;	|	U+1F5A5	|	—	|	desktop computer (tower computer)	|
|	🖳	|	\&#128435;	|	U+1F5B3	|	—	|	old personal computer (personal computer)	|
|	🖧	|	\&#128423;	|	U+1F5A7	|	—	|	three networked computers (computer network)	|
|	🖵	|	\&#128437;	|	U+1F5B5	|	—	|	screen (monitor)	|
|	⌨	|	\&#9000;	|	U+2328	|	—	|	keyboard	|
|	🖮	|	\&#128430;	|	U+1F5AE	|	—	|	wired keyboard	|
|	🖱	|	\&#128433;	|	U+1F5B1	|	—	|	three button mouse	|
|	🖦	|	\&#128422;	|	U+1F5A6	|	—	|	keyboard and mouse	|
|	🖴	|	\&#128436;	|	U+1F5B4	|	—	|	hard disk	|
|	💿	|	\&#128191;	|	U+1F4BF	|	—	|	optical disc	|
|	🖸	|	\&#128440;	|	U+1F5B8	|	—	|	optical disc icon (CD, compact disc)	|
|	🖭	|	\&#128429;	|	U+1F5AD	|	—	|	tape cartridge	|
|	🖨	|	\&#128424;	|	U+1F5A8	|	—	|	printer	|
|	🖶	|	\&#128438;	|	U+1F5B6	|	—	|	printer icon	|
|	🖩	|	\&#128425;	|	U+1F5A9	|	—	|	pocket calculator (calculator)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Clock

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	⌚	|	\&#8986;	|	U+231A	|	—	|	watch	|
|	⏰	|	\&#9200;	|	U+23F0	|	—	|	alarm clock	|
|	💤	|	\&#128164;	|	U+1F4A4	|	—	|	sleeping symbol	|
|	⏱	|	\&#9201;	|	U+23F1	|	—	|	stopwatch	|
|	⏲	|	\&#9202;	|	U+23F2	|	—	|	timer clock	|
|	🕐	|	\&#128336;	|	U+1F550	|	—	|	clock face one oclock	|
|	⌛	|	\&#8987;	|	U+231B	|	—	|	hourglass	|
|	⏳	|	\&#9203;	|	U+23F3	|	—	|	hourglass with flowing sand	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## SPORT

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	⚽	|	\&#9917;	|	U+26BD	|	—	|	soccer ball	|
|	🏀	|	\&#127936;	|	U+1F3C0	|	—	|	basketball and hoop (basketball)	|
|	🏐	|	\&#127952;	|	U+1F3D0	|	—	|	volleyball	|
|	🏈	|	\&#127944;	|	U+1F3C8	|	—	|	american football	|
|	🏉	|	\&#127945;	|	U+1F3C9	|	—	|	rugby football	|
|	🤾	|	\&#129342;	|	U+1F93E	|	—	|	handball	|
|	🏒	|	\&#127954;	|	U+1F3D2	|	—	|	ice hockey stick and puck	|
|	🥅	|	\&#129349;	|	U+1F945	|	—	|	goal net	|
|	🏏	|	\&#127951;	|	U+1F3CF	|	—	|	cricket bat and ball	|
|	🏓	|	\&#127955;	|	U+1F3D3	|	—	|	table tennis paddle and ball	|
|	🎾	|	\&#127934;	|	U+1F3BE	|	—	|	tennis racquet and ball (tennis)	|
|	🏸	|	\&#127992;	|	U+1F3F8	|	—	|	badminton racquet and shuttlecock	|
|	🏃	|	\&#127939;	|	U+1F3C3	|	—	|	runner (running, marathon, track and fields)	|
|	🤸	|	\&#129336;	|	U+1F938	|	—	|	person doing cartwheel (gymnastics)	|
|	🎿	|	\&#127935;	|	U+1F3BF	|	—	|	ski and ski boot (skiing)	|
|	⛷	|	\&#9975;	|	U+26F7	|	—	|	skier (ski resort)	|
|	⛸	|	\&#9976;	|	U+26F8	|	—	|	ice skate (ice skating rink)	|
|	🏂	|	\&#127938;	|	U+1F3C2	|	—	|	snowboarder	|
|	🏄	|	\&#127940;	|	U+1F3C4	|	—	|	surfer (surfing)	|
|	🏊	|	\&#127946;	|	U+1F3CA	|	—	|	swimmer	|
|	🤽	|	\&#129341;	|	U+1F93D	|	—	|	water polo	|
|	🛶	|	\&#128758;	|	U+1F6F6	|	—	|	canoe	|
|	🥌	|	\&#129356;	|	U+1F94C	|	—	|	curling stone	|
|	🏋	|	\&#127947;	|	U+1F3CB	|	—	|	weight lifter (health)	|
|	🤼	|	\&#129340;	|	U+1F93C	|	—	|	wrestlers (wrestling)	|
|	🥋	|	\&#129355;	|	U+1F94B	|	—	|	martial arts uniform (judo, karate, taekwondo)	|
|	🥊	|	\&#129354;	|	U+1F94A	|	—	|	boxing glove (boxing)	|
|	🤺	|	\&#129338;	|	U+1F93A	|	—	|	fencer (fencing)	|
|	🏌	|	\&#127948;	|	U+1F3CC	|	—	|	golfer	|
|	🏎	|	\&#127950;	|	U+1F3CE	|	—	|	racing car (race car)	|
|	🏍	|	\&#127949;	|	U+1F3CD	|	—	|	racing motorcycle (motorcycle)	|
|	🏇	|	\&#127943;	|	U+1F3C7	|	—	|	horse racing	|
|	🪂	|	\&#129666;	|	U+1FA82	|	—	|	parachute	|
|	🥏	|	\&#129359;	|	U+1F94F	|	—	|	flying disc	|
|	🛷	|	\&#128759;	|	U+1F6F7	|	—	|	sled (sledge, toboggan)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Flags

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	⚐	|	\&#9872;	|	U+2690	|	—	|	white flag	|
|	⚑	|	\&#9873;	|	U+2691	|	—	|	black flag	|
|	🏳	|	\&#127987;	|	U+1F3F3	|	—	|	waving white flag	|
|	🏁	|	\&#127937;	|	U+1F3C1	|	—	|	chequered flag (motor sports)	|
|	⛳	|	\&#9971;	|	U+26F3	|	—	|	flag in hole (golf course)	|
|	🚩	|	\&#128681;	|	U+1F6A9	|	—	|	triangular flag on post (location information)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Medal

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🏅	|	\&#127941;	|	U+1F3C5	|	—	|	sports medal	|
|	🥇	|	\&#129351;	|	U+1F947	|	—	|	first place medal (gold medal)	|
|	🥈	|	\&#129352;	|	U+1F948	|	—	|	second place medal (silver medal)	|
|	🥉	|	\&#129353;	|	U+1F949	|	—	|	third place medal (bronze medal)	|
|	🏆	|	\&#127942;	|	U+1F3C6	|	—	|	trophy	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## ENTERTAINMENT

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🎞	|	\&#127902;	|	U+1F39E	|	—	|	film frames (film clip)	|
|	🎥	|	\&#127909;	|	U+1F3A5	|	—	|	movie camera (film, movies)	|
|	🎬	|	\&#127916;	|	U+1F3AC	|	—	|	clapper board (film)	|
|	🎦	|	\&#127910;	|	U+1F3A6	|	—	|	cinema (movie theater, movie projector)	|
|	🎭	|	\&#127917;	|	U+1F3AD	|	—	|	performing arts (theater masks, theater)	|
|	🎩	|	\&#127913;	|	U+1F3A9	|	—	|	top hat (drama, performing arts, theater)	|
|	🗣	|	\&#128483;	|	U+1F5E3	|	—	|	speaking head silhouette (rated for strong language)	|
|	🎡	|	\&#127905;	|	U+1F3A1	|	—	|	ferris wheel (amusement park)	|
|	🎣	|	\&#127907;	|	U+1F3A3	|	—	|	fishing pole and fish (fishing)	|
|	🎨	|	\&#127912;	|	U+1F3A8	|	—	|	artist palette (art)	|
|	🎪	|	\&#127914;	|	U+1F3AA	|	—	|	circus tent (event)	|
|	🎫	|	\&#127915;	|	U+1F3AB	|	—	|	ticket (indicates an event)	|
|	🎟	|	\&#127903;	|	U+1F39F	|	—	|	admission tickets (ticket)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Games

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🎮	|	\&#127918;	|	U+1F3AE	|	—	|	video game (video game controller)	|
|	🕹	|	\&#128377;	|	U+1F579	|	—	|	joystick	|
|	🎰	|	\&#127920;	|	U+1F3B0	|	—	|	slot machine	|
|	🎯	|	\&#127919;	|	U+1F3AF	|	—	|	direct hit (archery target, hitting the target)	|
|	🎱	|	\&#127921;	|	U+1F3B1	|	—	|	billiards (magic 8-ball)	|
|	🎳	|	\&#127923;	|	U+1F3B3	|	—	|	bowling	|
|	🧩	|	\&#129513;	|	U+1F9E9	|	—	|	jigsaw puzzle piece	|
|	🎲	|	\&#127922;	|	U+1F3B2	|	—	|	game die	|
|	♠	|	\&#9824;	|	U+2660	|	\&spadesuit;	|	black spade suit	|
|	♣	|	\&#9827;	|	U+2663	|	\&clubsuit;	|	black club suit	|
|	♥	|	\&#9829;	|	U+2665	|	\&heartsuit;	|	black heart suit, valentine	|
|	♦	|	\&#9830;	|	U+2666	|	\&diamondsuit;	|	black diamond suit	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Toys

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🧸	|	\&#129528;	|	U+1F9F8	|	—	|	teddy bear	|
|	🪆-	|	\&#129670;	|	U+1FA86	|	—	|	nesting dolls	|
|	🪁	|	\&#129665;	|	U+1FA81	|	—	|	kite	|
|	🪄-	|	\&#129668;	|	U+1FA84	|	—	|	magic wand	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Celebration

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🎈	|	\&#127880;	|	U+1F388	|	—	|	balloon	|
|	🎀	|	\&#127872;	|	U+1F380	|	—	|	ribbon	|
|	🎁	|	\&#127873;	|	U+1F381	|	—	|	wrapped present	|
|	🎂	|	\&#127874;	|	U+1F382	|	—	|	birthday cake	|
|	🎃	|	\&#127875;	|	U+1F383	|	—	|	Jack-O-Lantern (Hallowe'en)	|
|	🎄	|	\&#127876;	|	U+1F384	|	—	|	Christmas Tree	|
|	🎅	|	\&#127877;	|	U+1F385	|	—	|	Father Christmas (Santa Claus)	|
|	🤶	|	\&#129334;	|	U+1F936	|	—	|	Mother Christmas (Mrs. Claus)	|
|	🎊	|	\&#127882;	|	U+1F38A	|	—	|	confetti ball (congratulations)	|
|	🎆	|	\&#127878;	|	U+1F386	|	—	|	fireworks	|
|	🧨	|	\&#129512;	|	U+1F9E8	|	—	|	firecracker	|
|	🎓	|	\&#127891;	|	U+1F393	|	—	|	graduation cap (mortarboard, education)	|
|	🎖	|	\&#127894;	|	U+1F396	|	—	|	military medal	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## CROSSES, RELIGION

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	☮	|	\&#9774;	|	U+262E	|	—	|	peace symbol	|
|	†	|	\&#8224;	|	U+2020	|	\&dagger;	|	dagger	|
|	‡	|	\&#8225;	|	U+2021	|	\&ddagger;	|	double dagger	|
|	☨	|	\&#9768;	|	U+2628	|	—	|	cross of Lorraine	|
|	✝	|	\&#10013;	|	U+271D	|	—	|	Latin cross	|
|	🕇	|	\&#128327;	|	U+1F547	|	—	|	heavy Latin cross	|
|	✞	|	\&#10014;	|	U+271E	|	—	|	shadowed white Latin cross	|
|	☩	|	\&#9769;	|	U+2629	|	—	|	cross of Jerusalem (simple cross potent)	|
|	☦	|	\&#9766;	|	U+2626	|	—	|	orthodox cross	|
|	✚	|	\&#10010;	|	U+271A	|	—	|	heavy Greek cross	|
|	🮻-	|	\&#129979;	|	U+1FBBB	|	—	|	voided Greek cross	|
|	☪	|	\&#9770;	|	U+262A	|	—	|	star and crescent	|
|	⛤	|	\&#9956;	|	U+26E4	|	—	|	pentagram (pentalpha, pentangle)	|
|	✡	|	\&#10017;	|	U+2721	|	—	|	star of David	|
|	⛪	|	\&#9962;	|	U+26EA	|	—	|	church	|
|	🕍	|	\&#128333;	|	U+1F54D	|	—	|	synagogue	|
|	🕌	|	\&#128332;	|	U+1F54C	|	—	|	mosque	|
|	🛕	|	\&#128725;	|	U+1F6D5	|	—	|	hindu temple	|
|	🛔-	|	\&#128724;	|	U+1F6D4	|	—	|	pagoda	|
|	🛐	|	\&#128720;	|	U+1F6D0	|	—	|	place of worship	|
|	🧎	|	\&#129486;	|	U+1F9CE	|	—	|	kneeling person	|
|	📿	|	\&#128255;	|	U+1F4FF	|	—	|	prayer beads	|
|	♆	|	\&#9798;	|	U+2646	|	—	|	Neptune	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Zodiac, Horoscope, Astrology

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	♈	|	\&#9800;	|	U+2648	|	—	|	Aries, 21 March – 20 April	|
|	♉	|	\&#9801;	|	U+2649	|	—	|	Taurus, 20 April – 21 May	|
|	♊	|	\&#9802;	|	U+264A	|	—	|	Gemini, 21 May – 21 June	|
|	♋	|	\&#9803;	|	U+264B	|	—	|	Cancer, 21 June – 23 July	|
|	♌	|	\&#9804;	|	U+264C	|	—	|	Leo, 23 July – 23 August	|
|	♍	|	\&#9805;	|	U+264D	|	—	|	Virgo, 23 August – 23 September	|
|	♎	|	\&#9806;	|	U+264E	|	—	|	Libra, 23 September – 23 October	|
|	♏	|	\&#9807;	|	U+264F	|	—	|	Scorpius, 23 October – 22 November	|
|	♐	|	\&#9808;	|	U+2650	|	—	|	Sagittarius, 23 November – 22 December	|
|	♑	|	\&#9809;	|	U+2651	|	—	|	Capricorn, 22 December – 20 January	|
|	♒	|	\&#9810;	|	U+2652	|	—	|	Aquarius, 20 January – 19 February	|
|	♓	|	\&#9811;	|	U+2653	|	—	|	Pisces, 19 February – 21 March	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## WEAPON

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	⚔	|	\&#9876;	|	U+2694	|	—	|	crossed swords (military term, battleground, KIA)	|
|	🗡	|	\&#128481;	|	U+1F5E1	|	—	|	dagger knife (rated for violence, hate)	|
|	🔫	|	\&#128299;	|	U+1F52B	|	—	|	pistol (handgun, revolver)	|
|	🥆-	|	\&#129350;	|	U+1F946	|	—	|	rifle (marksmanship, shooting, hunting)	|
|	💣	|	\&#128163;	|	U+1F4A3	|	—	|	bomb	|
|	⌖	|	\&#8982;	|	U+2316	|	\&target;	|	position indicator (true position)	|
|	🪖-	|	\&#129686;	|	U+1FA96	|	—	|	military helmet	|
|	🪃-	|	\&#129667;	|	U+1FA83	|	—	|	boomerang	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Death

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	☠	|	\&#9760;	|	U+2620	|	—	|	skull and crossbones (poison)	|
|	💀	|	\&#128128;	|	U+1F480	|	—	|	skull	|
|	🕱	|	\&#128369;	|	U+1F571	|	—	|	black skull and crossbones	|
|	☢	|	\&#9762;	|	U+2622	|	—	|	radioactive sign	|
|	☣	|	\&#9763;	|	U+2623	|	—	|	biohazard sign	|
|	⚰	|	\&#9904;	|	U+26B0	|	—	|	coffin (buried)	|
|	⚱	|	\&#9905;	|	U+26B1	|	—	|	funeral urn (cremated)	|
|	🪦-	|	\&#129702;	|	U+1FAA6	|	—	|	headstone (tombstone)	|


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## MISCELLANEOUS

| Glyph | HTML dec | Unicode hex | Entity | Description | 
| ---- | --- | --- | --- | --- |
|	🕳	|	\&#128371;	|	U+1F573	|	—	|	hole (portable hole)	|
|	🛢	|	\&#128738;	|	U+1F6E2	|	—	|	oil drum (commodities)	|
|	🔥	|	\&#128293;	|	U+1F525	|	—	|	fire	|
|	🧯	|	\&#129519;	|	U+1F9EF	|	—	|	fire extinguisher	|

FYI: 
- Based on file https://docs.google.com/document/d/1JsQ6V1dpjcTnY3WOOTnYSCHCMcwT1ru0hqUYzJR7Xsc/edit#heading=h.30j0zll
- w/ "HTML dec" required escape '\'
