---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Unicode Table - mostly used, by alphabet


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## A

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| A With Acute, Latin Capital Letter | &amp;#x00C1; | &#x00C1; |
| A With Acute, Latin Small Letter | &amp;#x00E1; | &#x00E1; |
| A With Breve, Latin Small Letter | &amp;#x0103; | &#x0103; |
| A With Caron, Latin Small Letter | &amp;#x01CE; | &#x01CE; |
| A With Circumflex, Latin Capital Letter | &amp;#x00C2; | &#x00C2; |
| A With Circumflex, Latin Small Letter | &amp;#x00E2; | &#x00E2; |
| A With Diaeresis, Latin Capital Letter | &amp;#x00C4; | &#x00C4; |
| A With Diaeresis, Latin Small Letter | &amp;#x00E4; | &#x00E4; |
| A With Dot Above, Latin Small Letter | &amp;#x0227; | &#x0227; |
| A With Dot Below, Latin Small Letter | &amp;#x1EA1; | &#x1EA1; |
| A With Double Grave, Latin Small Letter | &amp;#x0201; | &#x0201; |
| A With Grave, Latin Capital Letter | &amp;#x00C0; | &#x00C0; |
| A With Grave, Latin Small Letter | &amp;#x00E0; | &#x00E0; |
| A With Hook Above, Latin Small Letter | &amp;#x1EA3; | &#x1EA3; |
| A With Inverted Breve, Latin Small Letter | &amp;#x0203; | &#x0203; |
| A With Macron, Latin Small Letter | &amp;#x0101; | &#x0101; |
| A With Ogonek, Latin Small Letter | &amp;#x0105; | &#x0105; |
| A With Right Half Ring, Latin Small Letter | &amp;#x1E9A; | &#x1E9A; |
| A With Ring Above, Latin Capital Letter | &amp;#x00C5; | &#x00C5; |
| A With Ring Above, Latin Small Letter | &amp;#x00E5; | &#x00E5; |
| A With Ring Below, Latin Small Letter | &amp;#x1E01; | &#x1E01; |
| A With Stroke, Latin Capital Letter | &amp;#x023A; | &#x023A; |
| A With Tilde, Latin Capital Letter | &amp;#x00C3; | &#x00C3; |
| A With Tilde, Latin Small Letter | &amp;#x00E3; | &#x00E3; |
| A, Combining Latin Small Letter | &amp;#x0363; | &#x0363; |
| A, Latin Letter Small Capital | &amp;#x1D00; | &#x1D00; |
| A, Latin Small Letter Script | &amp;#x0251; | &#x0251; |
| A, Latin Small Letter Turned | &amp;#x0250; | &#x0250; |
| Abbreviation Mark, Armenian | &amp;#x055F; | &#x055F; |
| Abbreviation Mark, Syriac | &amp;#x070F; | &#x070F; |
| Abbreviation Sign, Devanagari | &amp;#x0970; | &#x0970; |
| Abbreviations, Squared Latin | &amp;#x3371; | &#x3371; |
| Aboriginal Syllabics, Unified Canadian | &amp;#x1400; | &#x1400; |
| Above Right, Combining Comma | &amp;#x0315; | &#x0315; |
| Above Right, Combining Dot | &amp;#x0358; | &#x0358; |
| Above, Cedilla | &amp;#x0312; | &#x0312; |
| Above, Combining Almost Equal To | &amp;#x034C; | &#x034C; |
| Above, Combining Anticlockwise Arrow | &amp;#x20D4; | &#x20D4; |
| Above, Combining Asterisk | &amp;#x20F0; | &#x20F0; |
| Above, Combining Bridge | &amp;#x0346; | &#x0346; |
| Above, Combining Clockwise Arrow | &amp;#x20D5; | &#x20D5; |
| Above, Combining Comma | &amp;#x0313; | &#x0313; |
| Above, Combining Counterclockwise Arrow | &amp;#x20D4; | &#x20D4; |
| Above, Combining Dot | &amp;#x0307; | &#x0307; |
| Above, Combining Double Vertical Line | &amp;#x030E; | &#x030E; |
| Above, Combining Four Dots | &amp;#x20DC; | &#x20DC; |
| Above, Combining Homothetic | &amp;#x034B; | &#x034B; |
| Above, Combining Hook | &amp;#x0309; | &#x0309; |
| Above, Combining Left Angle | &amp;#x031A; | &#x031A; |
| Above, Combining Left Arrow | &amp;#x20D6; | &#x20D6; |
| Above, Combining Left Half Ring | &amp;#x0351; | &#x0351; |
| Above, Combining Left Harpoon | &amp;#x20D0; | &#x20D0; |
| Above, Combining Left Right Arrow | &amp;#x20E1; | &#x20E1; |
| Above, Combining Not Tilde | &amp;#x034A; | &#x034A; |
| Above, Combining Reversed Comma | &amp;#x0314; | &#x0314; |
| Above, Combining Right Arrow | &amp;#x20D7; | &#x20D7; |
| Above, Combining Right Arrowhead | &amp;#x0350; | &#x0350; |
| Above, Combining Right Half Ring | &amp;#x0357; | &#x0357; |
| Above, Combining Right Harpoon | &amp;#x20D1; | &#x20D1; |
| Above, Combining Ring | &amp;#x030A; | &#x030A; |
| Above, Combining Three Dots | &amp;#x20DB; | &#x20DB; |
| Above, Combining Turned Comma | &amp;#x0312; | &#x0312; |
| Above, Combining Vertical Line | &amp;#x030D; | &#x030D; |
| Above, Combining Wide Bridge | &amp;#x20E9; | &#x20E9; |
| Above, Combining X | &amp;#x033D; | &#x033D; |
| Above, Combining Zigzag | &amp;#x035B; | &#x035B; |
| Above, Dot | &amp;#x02D9; | &#x02D9; |
| Above, Double Dot | &amp;#x0308; | &#x0308; |
| Above, Ring | &amp;#x02DA; | &#x02DA; |
| Above, V | &amp;#x030C; | &#x030C; |
| Absolute Continuity | &amp;#x2AA1; | &#x2AA1; |
| Absolute Value | &amp;#x007C; | &#x007C; |
| Abstract Syntax Bracket, Left | &amp;#x301A; | &#x301A; |
| Abstract Syntax Bracket, Right | &amp;#x301B; | &#x301B; |
| AC Current | &amp;#x23E6; | &#x23E6; |
| Accent Below, Combining Acute | &amp;#x0317; | &#x0317; |
| Accent Below, Combining Circumflex | &amp;#x032D; | &#x032D; |
| Accent Below, Combining Grave | &amp;#x0316; | &#x0316; |
| Accent, Acute | &amp;#x00B4; | &#x00B4; |
| Accent, Circumflex | &amp;#x005E; | &#x005E; |
| Accent, Combining Acute | &amp;#x0301; | &#x0301; |
| Accent, Combining Circumflex | &amp;#x0302; | &#x0302; |
| Accent, Combining Double Acute | &amp;#x030B; | &#x030B; |
| Accent, Combining Double Grave | &amp;#x030F; | &#x030F; |
| Accent, Combining Grave | &amp;#x0300; | &#x0300; |
| Accent, Double Acute | &amp;#x02DD; | &#x02DD; |
| Accent, Grave | &amp;#x0060; | &#x0060; |
| Accent, Modifier Letter Acute | &amp;#x02CA; | &#x02CA; |
| Accent, Modifier Letter Circumflex | &amp;#x02C6; | &#x02C6; |
| Accent, Modifier Letter Cross | &amp;#x02DF; | &#x02DF; |
| Accent, Modifier Letter Grave | &amp;#x02CB; | &#x02CB; |
| Accent, Modifier Letter Low Acute | &amp;#x02CF; | &#x02CF; |
| Accent, Modifier Letter Low Grave | &amp;#x02CE; | &#x02CE; |
| Accent, Spacing Acute | &amp;#x00B4; | &#x00B4; |
| Accent, Spacing Circumflex | &amp;#x005E; | &#x005E; |
| Accent, Spacing Grave | &amp;#x0060; | &#x0060; |
| Accent, Swedish Grave | &amp;#x02DF; | &#x02DF; |
| Account Of | &amp;#x2100; | &#x2100; |
| Acknowledge | &amp;#x0006; | &#x0006; |
| Acknowledge, Negative | &amp;#x0015; | &#x0015; |
| Acknowledge, Symbol For | &amp;#x2406; | &#x2406; |
| Acknowledge, Symbol For Negative | &amp;#x2415; | &#x2415; |
| Acrophonic Symbol Three, Epidaurean | &amp;#x205D; | &#x205D; |
| Actuarial Bend | &amp;#x20E7; | &#x20E7; |
| Acute Accent | &amp;#x00B4; | &#x00B4; |
| Acute Accent Below, Combining | &amp;#x0317; | &#x0317; |
| Acute Accent, Combining | &amp;#x0301; | &#x0301; |
| Acute Accent, Combining Double | &amp;#x030B; | &#x030B; |
| Acute Accent, Double | &amp;#x02DD; | &#x02DD; |
| Acute Accent, Modifier Letter | &amp;#x02CA; | &#x02CA; |
| Acute Accent, Modifier Letter Low | &amp;#x02CF; | &#x02CF; |
| Acute Accent, Spacing | &amp;#x00B4; | &#x00B4; |
| Acute Tone Mark, Combining | &amp;#x0341; | &#x0341; |
| Addak, Gurmukhi | &amp;#x0A71; | &#x0A71; |
| Addressed To The Subject | &amp;#x2101; | &#x2101; |
| Adi Shakti | &amp;#x262C; | &#x262C; |
| Ae, Latin Capital Letter | &amp;#x00C6; | &#x00C6; |
| Ae, Latin Capital Ligature | &amp;#x00C6; | &#x00C6; |
| Ae, Latin Letter Small Capital | &amp;#x1D01; | &#x1D01; |
| Ae, Latin Small Letter | &amp;#x00E6; | &#x00E6; |
| Ae, Latin Small Letter Turned | &amp;#x1D02; | &#x1D02; |
| Ae, Latin Small Ligature | &amp;#x00E6; | &#x00E6; |
| Aegean Word Separator Dot | &amp;#x10101; | &#x10101; |
| Aegean Word Separator Line | &amp;#x10100; | &#x10100; |
| Aesculapius, Staff Of | &amp;#x2695; | &#x2695; |
| Afghani Sign | &amp;#x060B; | &#x060B; |
| African Letters For Clicks | &amp;#x01C0; | &#x01C0; |
| Ain, Latin Letter | &amp;#x1D25; | &#x1D25; |
| Ainu, Katakana Extensions For | &amp;#x31F0; | &#x31F0; |
| Airplane | &amp;#x2708; | &#x2708; |
| Aktieselskab | &amp;#x214D; | &#x214D; |
| Al-Lakuna, Sinhala Sign | &amp;#x0DCA; | &#x0DCA; |
| Aldus Leaf | &amp;#x2766; | &#x2766; |
| Alef Symbol | &amp;#x2135; | &#x2135; |
| Alembic | &amp;#x2697; | &#x2697; |
| All Around-Profile | &amp;#x232E; | &#x232E; |
| All Equal To | &amp;#x224C; | &#x224C; |
| All, For | &amp;#x2200; | &#x2200; |
| Almost Equal To | &amp;#x2248; | &#x2248; |
| Almost Equal To Above, Combining | &amp;#x034C; | &#x034C; |
| Almost Equal To, Not | &amp;#x2249; | &#x2249; |
| Alpha, Latin Small Letter | &amp;#x0251; | &#x0251; |
| Alpha, Latin Small Letter Turned | &amp;#x0252; | &#x0252; |
| Alphabetic Presentation Forms | &amp;#xFB00; | &#xFB00; |
| Alphanumeric Symbols, Mathematical | &amp;#x1D400; | &#x1D400; |
| Alphanumerics, Enclosed | &amp;#x2460; | &#x2460; |
| Alternating Current | &amp;#x223F; | &#x223F; |
| Alternative Key Symbol | &amp;#x2387; | &#x2387; |
| Alveolar Click, Latin Letter | &amp;#x01C2; | &#x01C2; |
| Always | &amp;#x25FB; | &#x25FB; |
| Ampersand | &amp;#x0026; | &#x0026; |
| Ampersand, Turned | &amp;#x214B; | &#x214B; |
| Anchor | &amp;#x2693; | &#x2693; |
| Anchor, Interlinear Annotation | &amp;#xFFF9; | &#xFFF9; |
| And, Curly Logical | &amp;#x22CF; | &#x22CF; |
| And, Logical | &amp;#x2227; | &#x2227; |
| And, N-Ary Logical | &amp;#x22C0; | &#x22C0; |
| Ands And Ors, Logical | &amp;#x2A51; | &#x2A51; |
| Angkhankhu, Thai Character | &amp;#x0E5A; | &#x0E5A; |
| Angle | &amp;#x2220; | &#x2220; |
| Angle Above, Combining Left | &amp;#x031A; | &#x031A; |
| Angle Arc | &amp;#x2222; | &#x2222; |
| Angle Below, Combining Left | &amp;#x0349; | &#x0349; |
| Angle Bracket, Left | &amp;#x3008; | &#x3008; |
| Angle Bracket, Left Double | &amp;#x300A; | &#x300A; |
| Angle Bracket, Left-Pointing | &amp;#x2329; | &#x2329; |
| Angle Bracket, Mathematical Left | &amp;#x27E8; | &#x27E8; |
| Angle Bracket, Mathematical Left Double | &amp;#x27EA; | &#x27EA; |
| Angle Bracket, Mathematical Right | &amp;#x27E9; | &#x27E9; |
| Angle Bracket, Mathematical Right Double | &amp;#x27EB; | &#x27EB; |
| Angle Bracket, Right | &amp;#x3009; | &#x3009; |
| Angle Bracket, Right Double | &amp;#x300B; | &#x300B; |
| Angle Bracket, Right-Pointing | &amp;#x232A; | &#x232A; |
| Angle Brackets, Cjk | &amp;#x3008; | &#x3008; |
| Angle Quotation Mark, Left-Pointing Double | &amp;#x00AB; | &#x00AB; |
| Angle Quotation Mark, Right-Pointing Double | &amp;#x00BB; | &#x00BB; |
| Angle Quotation Mark, Single Left-Pointing | &amp;#x2039; | &#x2039; |
| Angle Quotation Mark, Single Right-Pointing | &amp;#x203A; | &#x203A; |
| Angle Quotation Marks, Ornamental | &amp;#x276E; | &#x276E; |
| Angle With Arc, Right | &amp;#x22BE; | &#x22BE; |
| Angle, Measured | &amp;#x2221; | &#x2221; |
| Angle, Right | &amp;#x221F; | &#x221F; |
| Angle, Spherical | &amp;#x2222; | &#x2222; |
| Angled Dash | &amp;#x00AC; | &#x00AC; |
| Angles | &amp;#x221F; | &#x221F; |
| Angles And Measured Angles | &amp;#x299B; | &#x299B; |
| Angstrom Sign | &amp;#x212B; | &#x212B; |
| Ankh | &amp;#x2625; | &#x2625; |
| Annotation Anchor, Interlinear | &amp;#xFFF9; | &#xFFF9; |
| Annotation Separator, Interlinear | &amp;#xFFFA; | &#xFFFA; |
| Annotation Signs, Arabic Koranic | &amp;#x06D6; | &#x06D6; |
| Annotation Signs, Arabic Qur'anic | &amp;#x06D6; | &#x06D6; |
| Annotation Terminator, Interlinear | &amp;#xFFFB; | &#xFFFB; |
| Annotation, Interlinear | &amp;#xFFF9; | &#xFFF9; |
| Annotation, Japanese Kanbun Ideographic | &amp;#x3190; | &#x3190; |
| Annuity Symbol, Combining | &amp;#x20E7; | &#x20E7; |
| Ano Teleia, Greek | &amp;#x00B7; | &#x00B7; |
| Anticlockwise Arrow Above, Combining | &amp;#x20D4; | &#x20D4; |
| Anticlockwise Contour Integral | &amp;#x2233; | &#x2233; |
| Anticlockwise Integration | &amp;#x2A11; | &#x2A11; |
| Anticlockwise Ring Overlay, Combining | &amp;#x20DA; | &#x20DA; |
| Antisigma, Claudian | &amp;#x2183; | &#x2183; |
| Anunasika, Devanagari | &amp;#x0901; | &#x0901; |
| Anusvara, Devanagari Sign | &amp;#x0902; | &#x0902; |
| Anusvara, Khmer | &amp;#x17C6; | &#x17C6; |
| Anusvara, Tibetan | &amp;#x0F7E; | &#x0F7E; |
| Apl Downstile | &amp;#x230A; | &#x230A; |
| Apl Functional Symbols | &amp;#x2336; | &#x2336; |
| Apl Jot | &amp;#x2218; | &#x2218; |
| Apl Overbar | &amp;#x00AF; | &#x00AF; |
| Apl Quote | &amp;#x0027; | &#x0027; |
| Apl Stile | &amp;#x2223; | &#x2223; |
| Apl Tilde | &amp;#x223C; | &#x223C; |
| Apl Upstile | &amp;#x2308; | &#x2308; |
| Apostrophe | &amp;#x0027; | &#x0027; |
| Apostrophe | &amp;#x2019; | &#x2019; |
| Apostrophe, Armenian | &amp;#x055A; | &#x055A; |
| Apostrophe, Modifier Letter | &amp;#x02BC; | &#x02BC; |
| Apostrophe, Modifier Letter Double | &amp;#x02EE; | &#x02EE; |
| Apostrophe, Neutral | &amp;#x02BC; | &#x02BC; |
| Apostrophe-Quote | &amp;#x0027; | &#x0027; |
| Apostrophic C | &amp;#x2183; | &#x2183; |
| Application Program Command | &amp;#x009F; | &#x009F; |
| Application, Function | &amp;#x2061; | &#x2061; |
| Approaches The Limit | &amp;#x2250; | &#x2250; |
| Approximately Equal To | &amp;#x2245; | &#x2245; |
| Approximately Equal To | &amp;#x2257; | &#x2257; |
| Aquarius | &amp;#x2652; | &#x2652; |
| Arabic | &amp;#x0600; | &#x0600; |
| Arabic Alphabet | &amp;#x0621; | &#x0621; |
| Arabic Combining Marks | &amp;#x0653; | &#x0653; |
| Arabic Comma | &amp;#x060C; | &#x060C; |
| Arabic Contextual Form Glyphs | &amp;#xFB50; | &#xFB50; |
| Arabic Contextual Form Glyphs | &amp;#xFE80; | &#xFE80; |
| Arabic Date Separator | &amp;#x060D; | &#x060D; |
| Arabic Decimal Separator | &amp;#x066B; | &#x066B; |
| Arabic Extensions | &amp;#x0671; | &#x0671; |
| Arabic Full Stop | &amp;#x06D4; | &#x06D4; |
| Arabic Harakat | &amp;#x064B; | &#x064B; |
| Arabic Honorifics | &amp;#x0610; | &#x0610; |
| Arabic Kashida | &amp;#x0640; | &#x0640; |
| Arabic Koranic Annotation Signs | &amp;#x06D6; | &#x06D6; |
| Arabic Letter Hamzah On Ha | &amp;#x06C0; | &#x06C0; |
| Arabic Letter Heh With Yeh Above | &amp;#x06C0; | &#x06C0; |
| Arabic Letters, Extended | &amp;#x0671; | &#x0671; |
| Arabic Letters, Extended | &amp;#x0750; | &#x0750; |
| Arabic Ligature Bismillah Ar-Rahman Ar-Raheem | &amp;#xFDFD; | &#xFDFD; |
| Arabic Ligatures | &amp;#xFBEA; | &#xFBEA; |
| Arabic Phrase Separator | &amp;#x066C; | &#x066C; |
| Arabic Points, Glyphs For Spacing Forms Of | &amp;#xFE70; | &#xFE70; |
| Arabic Presentation Forms-A | &amp;#xFB50; | &#xFB50; |
| Arabic Presentation Forms-B | &amp;#xFE70; | &#xFE70; |
| Arabic Punctuation | &amp;#x060C; | &#x060C; |
| Arabic Question Mark | &amp;#x061F; | &#x061F; |
| Arabic Qur'anic Annotation Signs | &amp;#x06D6; | &#x06D6; |
| Arabic Semicolon | &amp;#x061B; | &#x061B; |
| Arabic Subtending Marks | &amp;#x0600; | &#x0600; |
| Arabic Supplement | &amp;#x0750; | &#x0750; |
| Arabic Tatweel | &amp;#x0640; | &#x0640; |
| Arabic Thousands Separator | &amp;#x066C; | &#x066C; |
| Arabic-Indic Digits | &amp;#x0660; | &#x0660; |
| Arabic-Indic Digits, Eastern | &amp;#x06F0; | &#x06F0; |
| Arc | &amp;#x2312; | &#x2312; |
| Arc, Angle | &amp;#x2222; | &#x2222; |
| Arc, Right Angle With | &amp;#x22BE; | &#x22BE; |
| Arch Below, Combining Inverted Double | &amp;#x032B; | &#x032B; |
| Arcs | &amp;#x25DC; | &#x25DC; |
| Area, Asian Scripts | &amp;#xAC00; | &#xAC00; |
| Area, Cjk Ideographs | &amp;#x3400; | &#x3400; |
| Area, Cjk Phonetics And Symbols | &amp;#x2E80; | &#x2E80; |
| Area, Compatibility And Specials | &amp;#xF900; | &#xF900; |
| Area, General Scripts | &amp;#x0000; | &#x0000; |
| Area, Korean Hangul Syllables | &amp;#xAC00; | &#xAC00; |
| Area, Private Use | &amp;#xE000; | &#xE000; |
| Area, Supplementary Cjk Ideographs | &amp;#x20000; | &#x20000; |
| Area, Supplementary General Scripts | &amp;#x10000; | &#x10000; |
| Area, Surrogates | &amp;#xD800; | &#xD800; |
| Area, Symbols | &amp;#x2000; | &#x2000; |
| Argentinian Former Currency | &amp;#x20B3; | &#x20B3; |
| Aries | &amp;#x2648; | &#x2648; |
| Armenian Abbreviation Mark | &amp;#x055F; | &#x055F; |
| Armenian Alphabet | &amp;#x0530; | &#x0530; |
| Armenian Apostrophe | &amp;#x055A; | &#x055A; |
| Armenian Batsaganchakan Nshan | &amp;#x055C; | &#x055C; |
| Armenian Bowt | &amp;#x055D; | &#x055D; |
| Armenian Capital Letters | &amp;#x0531; | &#x0531; |
| Armenian Comma | &amp;#x055D; | &#x055D; |
| Armenian Emphasis Mark | &amp;#x055B; | &#x055B; |
| Armenian Exclamation Mark | &amp;#x055C; | &#x055C; |
| Armenian Full Stop | &amp;#x0589; | &#x0589; |
| Armenian Hartsakan Nshan | &amp;#x055E; | &#x055E; |
| Armenian Hyphen | &amp;#x058A; | &#x058A; |
| Armenian Ligatures | &amp;#xFB13; | &#xFB13; |
| Armenian Patiw | &amp;#x055F; | &#x055F; |
| Armenian Question Mark | &amp;#x055E; | &#x055E; |
| Armenian Shesht | &amp;#x055B; | &#x055B; |
| Armenian Small Letters | &amp;#x0561; | &#x0561; |
| Armenian Vertsaket | &amp;#x0589; | &#x0589; |
| Armenian Yentamna | &amp;#x058A; | &#x058A; |
| Arrow Above, Combining Anticlockwise | &amp;#x20D4; | &#x20D4; |
| Arrow Above, Combining Clockwise | &amp;#x20D5; | &#x20D5; |
| Arrow Above, Combining Counterclockwise | &amp;#x20D4; | &#x20D4; |
| Arrow Above, Combining Left | &amp;#x20D6; | &#x20D6; |
| Arrow Above, Combining Left Right | &amp;#x20E1; | &#x20E1; |
| Arrow Above, Combining Right | &amp;#x20D7; | &#x20D7; |
| Arrow Below, Combining Double Rightwards | &amp;#x0362; | &#x0362; |
| Arrow Below, Combining Left | &amp;#x20EE; | &#x20EE; |
| Arrow Below, Combining Left Right | &amp;#x034D; | &#x034D; |
| Arrow Below, Combining Right | &amp;#x20EF; | &#x20EF; |
| Arrow Below, Combining Upwards | &amp;#x034E; | &#x034E; |
| Arrow Dingbats | &amp;#x2794; | &#x2794; |
| Arrow Indicator, Backward | &amp;#x25C5; | &#x25C5; |
| Arrow Indicator, Forward | &amp;#x25BB; | &#x25BB; |
| Arrow Overlay, Combining Leftwards | &amp;#x20EA; | &#x20EA; |
| Arrow, Downwards | &amp;#x2193; | &#x2193; |
| Arrow, Electric | &amp;#x2301; | &#x2301; |
| Arrow, Leftwards | &amp;#x2190; | &#x2190; |
| Arrow, Rightwards | &amp;#x2192; | &#x2192; |
| Arrow, Upwards | &amp;#x2191; | &#x2191; |
| Arrowhead Above, Combining Right | &amp;#x0350; | &#x0350; |
| Arrowhead Below, Combining Left | &amp;#x0354; | &#x0354; |
| Arrowhead Below, Combining Right | &amp;#x0355; | &#x0355; |
| Arrowhead, Down | &amp;#x2304; | &#x2304; |
| Arrowhead, Up | &amp;#x2303; | &#x2303; |
| Arrowheads, Modifier Letter | &amp;#x02C2; | &#x02C2; |
| Arrows | &amp;#x2190; | &#x2190; |
| Arrows, Dingbat | &amp;#x2794; | &#x2794; |
| Arrows, Double | &amp;#x21CD; | &#x21CD; |
| Arrows, Long | &amp;#x27F5; | &#x27F5; |
| Arrows, Mathematical | &amp;#x2B30; | &#x2B30; |
| Arrows, Miscellaneous | &amp;#x2B00; | &#x2B00; |
| Arrows-A Supplement | &amp;#x27F0; | &#x27F0; |
| Arrows-B, Supplemental | &amp;#x2900; | &#x2900; |
| Ascending Node | &amp;#x260A; | &#x260A; |
| Ascii C0 Control Codes | &amp;#x0000; | &#x0000; |
| Ascii Digits | &amp;#x0030; | &#x0030; |
| Ascii Punctuation And Symbols | &amp;#x0020; | &#x0020; |
| Ascii Variants, Fullwidth | &amp;#xFF01; | &#xFF01; |
| Ash | &amp;#x00E6; | &#x00E6; |
| Asian Scripts Area | &amp;#xAC00; | &#xAC00; |
| Assertion | &amp;#x22A6; | &#x22A6; |
| Asterisk | &amp;#x002A; | &#x002A; |
| Asterisk Above, Combining | &amp;#x20F0; | &#x20F0; |
| Asterisk Below, Combining | &amp;#x0359; | &#x0359; |
| Asterisk Dingbats | &amp;#x2722; | &#x2722; |
| Asterisk Operator | &amp;#x2217; | &#x2217; |
| Asterisk Operator, Circled | &amp;#x229B; | &#x229B; |
| Asterisk, Low | &amp;#x204E; | &#x204E; |
| Asterisks | &amp;#x2722; | &#x2722; |
| Asterisks Aligned Vertically, Two | &amp;#x2051; | &#x2051; |
| Asterism | &amp;#x2042; | &#x2042; |
| Astrological Signs | &amp;#x26B3; | &#x26B3; |
| Astrological Signs, Tibetan | &amp;#x0F15; | &#x0F15; |
| Astrological Symbols | &amp;#x263D; | &#x263D; |
| Astrological Symbols, Weather And | &amp;#x2600; | &#x2600; |
| Asymptotic To | &amp;#x2248; | &#x2248; |
| Asymptotically Equal To | &amp;#x2243; | &#x2243; |
| Asymptotically Equal To, Not | &amp;#x2244; | &#x2244; |
| At Sign | &amp;#x0040; | &#x0040; |
| At, Commercial | &amp;#x0040; | &#x0040; |
| Atom Symbol | &amp;#x269B; | &#x269B; |
| Austral Sign | &amp;#x20B3; | &#x20B3; |
| Avagraha, Devanagari Sign | &amp;#x093D; | &#x093D; |
| Aytham, Tamil | &amp;#x0B83; | &#x0B83; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## B

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| B With Dot Above, Latin Small Letter | &amp;#x1E03; | &#x1E03; |
| B With Dot Below, Latin Small Letter | &amp;#x1E05; | &#x1E05; |
| B With Hook, Latin Capital Letter | &amp;#x0181; | &#x0181; |
| B With Hook, Latin Small Letter | &amp;#x0253; | &#x0253; |
| B With Line Below, Latin Small Letter | &amp;#x1E07; | &#x1E07; |
| B With Stroke, Latin Capital Letter | &amp;#x0243; | &#x0243; |
| B With Stroke, Latin Small Letter | &amp;#x0180; | &#x0180; |
| B With Topbar, Latin Small Letter | &amp;#x0183; | &#x0183; |
| B, Latin Letter Small Capital | &amp;#x0299; | &#x0299; |
| B, Latin Letter Small Capital Barred | &amp;#x1D03; | &#x1D03; |
| B, Script Capital | &amp;#x212C; | &#x212C; |
| Baby Gamma, Latin Small Letter | &amp;#x0264; | &#x0264; |
| Backslash | &amp;#x005C; | &#x005C; |
| Backslash, Combining Enclosing Circle | &amp;#x20E0; | &#x20E0; |
| Backspace | &amp;#x0008; | &#x0008; |
| Backspace, Symbol For | &amp;#x2408; | &#x2408; |
| Backward Arrow Indicator | &amp;#x25C5; | &#x25C5; |
| Backward Difference | &amp;#x2207; | &#x2207; |
| Backward, Partial Line | &amp;#x008C; | &#x008C; |
| Bag Addition | &amp;#x228E; | &#x228E; |
| Bag Bracket, Left | &amp;#x27E6; | &#x27E6; |
| Bag Bracket, Right | &amp;#x27E7; | &#x27E7; |
| Bag Count, Infix | &amp;#x266F; | &#x266F; |
| Bag Membership, Z Notation | &amp;#x22FF; | &#x22FF; |
| Bag Subtraction | &amp;#x2A41; | &#x2A41; |
| Baht, Thai Currency Symbol | &amp;#x0E3F; | &#x0E3F; |
| Balinese | &amp;#x1B00; | &#x1B00; |
| Balinese Digits | &amp;#x1B50; | &#x1B50; |
| Balinese Musical Symbols | &amp;#x1B61; | &#x1B61; |
| Ballot Box | &amp;#x2610; | &#x2610; |
| Ballot Box With Check | &amp;#x2611; | &#x2611; |
| Ballot Box With X | &amp;#x2612; | &#x2612; |
| Ballot X | &amp;#x2717; | &#x2717; |
| Ballot X, Heavy | &amp;#x2718; | &#x2718; |
| Bang | &amp;#x0021; | &#x0021; |
| Bar Dingbats, Vertical | &amp;#x2758; | &#x2758; |
| Bar Symbols, Error | &amp;#x29EE; | &#x29EE; |
| Bar, Broken | &amp;#x00A6; | &#x00A6; |
| Bar, Horizontal | &amp;#x2015; | &#x2015; |
| Bar, Vertical | &amp;#x007C; | &#x007C; |
| Bar, White Vertical | &amp;#x2AFE; | &#x2AFE; |
| Barred B, Latin Letter Small Capital | &amp;#x1D03; | &#x1D03; |
| Barred O, Latin Capital Letter | &amp;#x019F; | &#x019F; |
| Barred O, Latin Small Letter | &amp;#x0275; | &#x0275; |
| Base | &amp;#x22A5; | &#x22A5; |
| Batsaganchakan Nshan, Armenian | &amp;#x055C; | &#x055C; |
| Battleground Symbol | &amp;#x2694; | &#x2694; |
| Beamed Eighth Notes | &amp;#x266B; | &#x266B; |
| Beamed Sixteenth Notes | &amp;#x266C; | &#x266C; |
| Because | &amp;#x2235; | &#x2235; |
| Bell | &amp;#x0007; | &#x0007; |
| Bell Symbol | &amp;#x237E; | &#x237E; |
| Bell, Symbol For | &amp;#x2407; | &#x2407; |
| Below, Combining Acute Accent | &amp;#x0317; | &#x0317; |
| Below, Combining Asterisk | &amp;#x0359; | &#x0359; |
| Below, Combining Breve | &amp;#x032E; | &#x032E; |
| Below, Combining Bridge | &amp;#x032A; | &#x032A; |
| Below, Combining Caron | &amp;#x032C; | &#x032C; |
| Below, Combining Circumflex Accent | &amp;#x032D; | &#x032D; |
| Below, Combining Comma | &amp;#x0326; | &#x0326; |
| Below, Combining Diaeresis | &amp;#x0324; | &#x0324; |
| Below, Combining Dot | &amp;#x0323; | &#x0323; |
| Below, Combining Double Breve | &amp;#x035C; | &#x035C; |
| Below, Combining Double Macron | &amp;#x035F; | &#x035F; |
| Below, Combining Double Rightwards Arrow | &amp;#x0362; | &#x0362; |
| Below, Combining Double Ring | &amp;#x035A; | &#x035A; |
| Below, Combining Double Vertical Line | &amp;#x0348; | &#x0348; |
| Below, Combining Down Tack | &amp;#x031E; | &#x031E; |
| Below, Combining Equals Sign | &amp;#x0347; | &#x0347; |
| Below, Combining Grave Accent | &amp;#x0316; | &#x0316; |
| Below, Combining Inverted Breve | &amp;#x032F; | &#x032F; |
| Below, Combining Inverted Bridge | &amp;#x033A; | &#x033A; |
| Below, Combining Inverted Double Arch | &amp;#x032B; | &#x032B; |
| Below, Combining Left Angle | &amp;#x0349; | &#x0349; |
| Below, Combining Left Arrow | &amp;#x20EE; | &#x20EE; |
| Below, Combining Left Arrowhead | &amp;#x0354; | &#x0354; |
| Below, Combining Left Half Ring | &amp;#x031C; | &#x031C; |
| Below, Combining Left Right Arrow | &amp;#x034D; | &#x034D; |
| Below, Combining Left Tack | &amp;#x0318; | &#x0318; |
| Below, Combining Macron | &amp;#x0331; | &#x0331; |
| Below, Combining Minus Sign | &amp;#x0320; | &#x0320; |
| Below, Combining Palatalized Hook | &amp;#x0321; | &#x0321; |
| Below, Combining Plus Sign | &amp;#x031F; | &#x031F; |
| Below, Combining Retroflex Hook | &amp;#x0322; | &#x0322; |
| Below, Combining Right Arrow | &amp;#x20EF; | &#x20EF; |
| Below, Combining Right Arrowhead | &amp;#x0355; | &#x0355; |
| Below, Combining Right Half Ring | &amp;#x0339; | &#x0339; |
| Below, Combining Right Tack | &amp;#x0319; | &#x0319; |
| Below, Combining Ring | &amp;#x0325; | &#x0325; |
| Below, Combining Seagull | &amp;#x033C; | &#x033C; |
| Below, Combining Square | &amp;#x033B; | &#x033B; |
| Below, Combining Tilde | &amp;#x0330; | &#x0330; |
| Below, Combining Up Tack | &amp;#x031D; | &#x031D; |
| Below, Combining Upwards Arrow | &amp;#x034E; | &#x034E; |
| Below, Combining Vertical Line | &amp;#x0329; | &#x0329; |
| Below, Combining X | &amp;#x0353; | &#x0353; |
| Belt, Latin Small Letter L With | &amp;#x026C; | &#x026C; |
| Bend, Actuarial | &amp;#x20E7; | &#x20E7; |
| Bengali | &amp;#x0980; | &#x0980; |
| Bengali Consonants | &amp;#x0995; | &#x0995; |
| Bengali Currency Signs | &amp;#x09F2; | &#x09F2; |
| Bengali Dependent Vowel Signs | &amp;#x09BE; | &#x09BE; |
| Bengali Digits | &amp;#x09E6; | &#x09E6; |
| Bengali Hasant | &amp;#x09CD; | &#x09CD; |
| Bengali Independent Vowels | &amp;#x0985; | &#x0985; |
| Bengali Isshar | &amp;#x09FA; | &#x09FA; |
| Bengali Rupee Mark | &amp;#x09F2; | &#x09F2; |
| Bengali Rupee Sign | &amp;#x09F3; | &#x09F3; |
| Benzene Ring | &amp;#x232C; | &#x232C; |
| Bernoulli Function | &amp;#x212C; | &#x212C; |
| Bet Symbol | &amp;#x2136; | &#x2136; |
| Beta Symbol, Greek | &amp;#x03D0; | &#x03D0; |
| Beta, Curled | &amp;#x03D0; | &#x03D0; |
| Between | &amp;#x226C; | &#x226C; |
| Beverage, Hot | &amp;#x2615; | &#x2615; |
| Bidirectional Format Characters | &amp;#x202A; | &#x202A; |
| Big 5, Duplicate Characters From | &amp;#xFA0C; | &#xFA0C; |
| Big Reverse Solidus | &amp;#x29F9; | &#x29F9; |
| Big Solidus | &amp;#x29F8; | &#x29F8; |
| Bijection | &amp;#x2916; | &#x2916; |
| Bilabial Click, Latin Letter | &amp;#x0298; | &#x0298; |
| Bilabial Percussive, Latin Letter | &amp;#x02AC; | &#x02AC; |
| Bindu, Devanagari | &amp;#x0902; | &#x0902; |
| Biohazard Sign | &amp;#x2623; | &#x2623; |
| Birga, Mongolian | &amp;#x1800; | &#x1800; |
| Bismillah Ar-Rahman Ar-Raheem, Arabic Ligature | &amp;#xFDFD; | &#xFDFD; |
| Black Circle | &amp;#x25CF; | &#x25CF; |
| Black Circle, Medium | &amp;#x26AB; | &#x26AB; |
| Black Flag | &amp;#x2691; | &#x2691; |
| Black Hourglass | &amp;#x29D7; | &#x29D7; |
| Black Left Pointing Index | &amp;#x261A; | &#x261A; |
| Black Leftwards Bullet | &amp;#x204C; | &#x204C; |
| Black Lenticular Bracket, Left | &amp;#x3010; | &#x3010; |
| Black Lenticular Bracket, Right | &amp;#x3011; | &#x3011; |
| Black Lozenge | &amp;#x29EB; | &#x29EB; |
| Black Medium Small Square | &amp;#x25FE; | &#x25FE; |
| Black Medium Square | &amp;#x25FC; | &#x25FC; |
| Black Nib | &amp;#x2712; | &#x2712; |
| Black Parallelogram | &amp;#x25B0; | &#x25B0; |
| Black Right Pointing Index | &amp;#x261B; | &#x261B; |
| Black Rightwards Bullet | &amp;#x204D; | &#x204D; |
| Black Scissors | &amp;#x2702; | &#x2702; |
| Black Shogi Piece | &amp;#x2617; | &#x2617; |
| Black Small Circle | &amp;#x2022; | &#x2022; |
| Black Smiling Face | &amp;#x263B; | &#x263B; |
| Black Star | &amp;#x2605; | &#x2605; |
| Black Sun With Rays | &amp;#x2600; | &#x2600; |
| Black Telephone | &amp;#x260E; | &#x260E; |
| Black-Letter Capital C | &amp;#x212D; | &#x212D; |
| Black-Letter Capital H | &amp;#x210C; | &#x210C; |
| Black-Letter Capital I | &amp;#x2111; | &#x2111; |
| Black-Letter Capital R | &amp;#x211C; | &#x211C; |
| Black-Letter Capital Z | &amp;#x2128; | &#x2128; |
| Black-Letter Mathematical Symbols | &amp;#x1D504; | &#x1D504; |
| Blank Symbol | &amp;#x2422; | &#x2422; |
| Block Elements | &amp;#x2580; | &#x2580; |
| Block, End Of Transmission | &amp;#x0017; | &#x0017; |
| Block, Full | &amp;#x2588; | &#x2588; |
| Block, Symbol For End Of Transmission | &amp;#x2417; | &#x2417; |
| Bohairic Coptic | &amp;#x2C80; | &#x2C80; |
| Bold Digits | &amp;#x1D7CE; | &#x1D7CE; |
| Bold Digits, Sans-Serif | &amp;#x1D7EC; | &#x1D7EC; |
| Bold Fraktur Mathematical Symbols | &amp;#x1D56C; | &#x1D56C; |
| Bold Greek Mathematical Symbols | &amp;#x1D6A8; | &#x1D6A8; |
| Bold Greek Mathematical Symbols, Sans-Serif | &amp;#x1D756; | &#x1D756; |
| Bold Italic Greek Mathematical Symbols | &amp;#x1D71C; | &#x1D71C; |
| Bold Italic Greek Mathematical Symbols, Sans-Serif | &amp;#x1D790; | &#x1D790; |
| Bold Italic Mathematical Symbols | &amp;#x1D468; | &#x1D468; |
| Bold Italic Mathematical Symbols, Sans-Serif | &amp;#x1D63C; | &#x1D63C; |
| Bold Mathematical Symbols | &amp;#x1D400; | &#x1D400; |
| Bold Mathematical Symbols, Sans-Serif | &amp;#x1D5D4; | &#x1D5D4; |
| Bold Script Mathematical Symbols | &amp;#x1D4D0; | &#x1D4D0; |
| Bom | &amp;#xFEFF; | &#xFEFF; |
| Bopomofo Extensions, Chinese | &amp;#x31A0; | &#x31A0; |
| Bopomofo, Chinese | &amp;#x3100; | &#x3100; |
| Bottom | &amp;#x22A5; | &#x22A5; |
| Bowt, Armenian | &amp;#x055D; | &#x055D; |
| Bowtie | &amp;#x22C8; | &#x22C8; |
| Bowtie Symbols | &amp;#x29D1; | &#x29D1; |
| Bowtie, Large | &amp;#x2A1D; | &#x2A1D; |
| Bowtie, Vertical | &amp;#x29D6; | &#x29D6; |
| Box Drawing | &amp;#x2500; | &#x2500; |
| Box With Check, Ballot | &amp;#x2611; | &#x2611; |
| Box With X, Ballot | &amp;#x2612; | &#x2612; |
| Box, Ballot | &amp;#x2610; | &#x2610; |
| Box, Open | &amp;#x2423; | &#x2423; |
| Box, Shouldered Open | &amp;#x237D; | &#x237D; |
| Box, X In A Rectangle | &amp;#x2327; | &#x2327; |
| Brace, Closing | &amp;#x007D; | &#x007D; |
| Brace, Opening | &amp;#x007B; | &#x007B; |
| Bracket Pieces | &amp;#x239B; | &#x239B; |
| Bracket Pieces | &amp;#x23B0; | &#x23B0; |
| Bracket Variants For Vertical Text | &amp;#x23DC; | &#x23DC; |
| Bracket With Quill, Left Square | &amp;#x2045; | &#x2045; |
| Bracket With Quill, Right Square | &amp;#x2046; | &#x2046; |
| Bracket, Closing Curly | &amp;#x007D; | &#x007D; |
| Bracket, Closing Square | &amp;#x005D; | &#x005D; |
| Bracket, Left Abstract Syntax | &amp;#x301A; | &#x301A; |
| Bracket, Left Angle | &amp;#x3008; | &#x3008; |
| Bracket, Left Bag | &amp;#x27E6; | &#x27E6; |
| Bracket, Left Black Lenticular | &amp;#x3010; | &#x3010; |
| Bracket, Left Chevron | &amp;#x27EA; | &#x27EA; |
| Bracket, Left Corner | &amp;#x300C; | &#x300C; |
| Bracket, Left Curly | &amp;#x007B; | &#x007B; |
| Bracket, Left Double Angle | &amp;#x300A; | &#x300A; |
| Bracket, Left Sequence | &amp;#x27E8; | &#x27E8; |
| Bracket, Left Square | &amp;#x005B; | &#x005B; |
| Bracket, Left Tortoise Shell | &amp;#x3014; | &#x3014; |
| Bracket, Left White Corner | &amp;#x300E; | &#x300E; |
| Bracket, Left White Curly | &amp;#x2983; | &#x2983; |
| Bracket, Left White Lenticular | &amp;#x3016; | &#x3016; |
| Bracket, Left White Square | &amp;#x301A; | &#x301A; |
| Bracket, Left White Tortoise Shell | &amp;#x3018; | &#x3018; |
| Bracket, Left-Pointing Angle | &amp;#x2329; | &#x2329; |
| Bracket, Mathematical Left Angle | &amp;#x27E8; | &#x27E8; |
| Bracket, Mathematical Left Double Angle | &amp;#x27EA; | &#x27EA; |
| Bracket, Mathematical Right Angle | &amp;#x27E9; | &#x27E9; |
| Bracket, Mathematical Right Double Angle | &amp;#x27EB; | &#x27EB; |
| Bracket, Opening Curly | &amp;#x007B; | &#x007B; |
| Bracket, Opening Square | &amp;#x005B; | &#x005B; |
| Bracket, Right Abstract Syntax | &amp;#x301B; | &#x301B; |
| Bracket, Right Angle | &amp;#x3009; | &#x3009; |
| Bracket, Right Bag | &amp;#x27E7; | &#x27E7; |
| Bracket, Right Black Lenticular | &amp;#x3011; | &#x3011; |
| Bracket, Right Chevron | &amp;#x27EB; | &#x27EB; |
| Bracket, Right Corner | &amp;#x300D; | &#x300D; |
| Bracket, Right Curly | &amp;#x007D; | &#x007D; |
| Bracket, Right Double Angle | &amp;#x300B; | &#x300B; |
| Bracket, Right Sequence | &amp;#x27E9; | &#x27E9; |
| Bracket, Right Square | &amp;#x005D; | &#x005D; |
| Bracket, Right Tortoise Shell | &amp;#x3015; | &#x3015; |
| Bracket, Right White Corner | &amp;#x300F; | &#x300F; |
| Bracket, Right White Curly | &amp;#x2984; | &#x2984; |
| Bracket, Right White Lenticular | &amp;#x3017; | &#x3017; |
| Bracket, Right White Square | &amp;#x301B; | &#x301B; |
| Bracket, Right White Tortoise Shell | &amp;#x3019; | &#x3019; |
| Bracket, Right-Pointing Angle | &amp;#x232A; | &#x232A; |
| Brackets | &amp;#x2983; | &#x2983; |
| Brackets, Cjk Angle | &amp;#x3008; | &#x3008; |
| Brackets, Cjk Corner | &amp;#x300C; | &#x300C; |
| Brackets, Corner | &amp;#x2308; | &#x2308; |
| Brackets, Mathematical | &amp;#x27E6; | &#x27E6; |
| Brackets, Ornamental | &amp;#x2768; | &#x2768; |
| Brackets, Vertical | &amp;#x23B4; | &#x23B4; |
| Braille Patterns | &amp;#x2800; | &#x2800; |
| Brazilian Currency | &amp;#x20A2; | &#x20A2; |
| Break Here, No | &amp;#x0083; | &#x0083; |
| Break Permitted Here | &amp;#x0082; | &#x0082; |
| Breathing Mark, Greek Rough | &amp;#x0314; | &#x0314; |
| Breathing Mark, Greek Smooth | &amp;#x0313; | &#x0313; |
| Breve | &amp;#x02D8; | &#x02D8; |
| Breve Below, Combining | &amp;#x032E; | &#x032E; |
| Breve Below, Combining Double | &amp;#x035C; | &#x035C; |
| Breve Below, Combining Inverted | &amp;#x032F; | &#x032F; |
| Breve, Combining | &amp;#x0306; | &#x0306; |
| Breve, Combining Double | &amp;#x035D; | &#x035D; |
| Breve, Combining Double Inverted | &amp;#x0361; | &#x0361; |
| Breve, Combining Inverted | &amp;#x0311; | &#x0311; |
| Bridge Above, Combining | &amp;#x0346; | &#x0346; |
| Bridge Above, Combining Wide | &amp;#x20E9; | &#x20E9; |
| Bridge Below, Combining | &amp;#x032A; | &#x032A; |
| Bridge Below, Combining Inverted | &amp;#x033A; | &#x033A; |
| Broken Bar | &amp;#x00A6; | &#x00A6; |
| Broken Vertical Bar | &amp;#x00A6; | &#x00A6; |
| Buginese | &amp;#x1A00; | &#x1A00; |
| Buhid | &amp;#x1740; | &#x1740; |
| Bullet | &amp;#x2022; | &#x2022; |
| Bullet Operator | &amp;#x2219; | &#x2219; |
| Bullet, Black Leftwards | &amp;#x204C; | &#x204C; |
| Bullet, Black Rightwards | &amp;#x204D; | &#x204D; |
| Bullet, Hyphen | &amp;#x2043; | &#x2043; |
| Bullet, Reversed Rotated Floral Heart | &amp;#x2619; | &#x2619; |
| Bullet, Tainome Japanese | &amp;#x25C9; | &#x25C9; |
| Bullet, Triangular | &amp;#x2023; | &#x2023; |
| Bullet, White | &amp;#x25E6; | &#x25E6; |
| Bullseye | &amp;#x25CE; | &#x25CE; |
| Bullseye, Latin Letter | &amp;#x0298; | &#x0298; |
| Buried Symbol | &amp;#x26B0; | &#x26B0; |
| Burmese | &amp;#x1000; | &#x1000; |
| By Definition, Equal To | &amp;#x225C; | &#x225C; |
| By Definition, Equal To | &amp;#x225D; | &#x225D; |
| By, Measured | &amp;#x225E; | &#x225E; |
| Byte Order Mark | &amp;#xFEFF; | &#xFEFF; |
| Byzantine Musical Symbols | &amp;#x1D000; | &#x1D000; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## C

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| C With Acute, Latin Small Letter | &amp;#x0107; | &#x0107; |
| C With Caron, Latin Small Letter | &amp;#x010D; | &#x010D; |
| C With Cedilla, Latin Capital Letter | &amp;#x00C7; | &#x00C7; |
| C With Cedilla, Latin Small Letter | &amp;#x00E7; | &#x00E7; |
| C With Circumflex, Latin Small Letter | &amp;#x0109; | &#x0109; |
| C With Curl, Latin Small Letter | &amp;#x0255; | &#x0255; |
| C With Dot Above, Latin Small Letter | &amp;#x010B; | &#x010B; |
| C With Hook, Latin Small Letter | &amp;#x0188; | &#x0188; |
| C With Stroke, Latin Capital Letter | &amp;#x023B; | &#x023B; |
| C With Stroke, Latin Small Letter | &amp;#x023C; | &#x023C; |
| C, Apostrophic | &amp;#x2183; | &#x2183; |
| C, Black-Letter Capital | &amp;#x212D; | &#x212D; |
| C, Combining Latin Small Letter | &amp;#x0368; | &#x0368; |
| C, Double-Struck Capital | &amp;#x2102; | &#x2102; |
| C, Latin Letter Small Capital | &amp;#x1D04; | &#x1D04; |
| C, Latin Letter Stretched | &amp;#x0297; | &#x0297; |
| C, Latin Small Letter Reversed | &amp;#x2184; | &#x2184; |
| Cada Una | &amp;#x2106; | &#x2106; |
| Caduceus | &amp;#x2624; | &#x2624; |
| Cambodian | &amp;#x1780; | &#x1780; |
| Canadian Aboriginal Syllabics, Unified | &amp;#x1400; | &#x1400; |
| Canadian Syllabics Full Stop | &amp;#x166E; | &#x166E; |
| Canadian Syllabics Punctuation | &amp;#x166D; | &#x166D; |
| Cancel | &amp;#x0018; | &#x0018; |
| Cancel Character | &amp;#x0094; | &#x0094; |
| Cancel Tag | &amp;#xE007F; | &#xE007F; |
| Cancel, Symbol For | &amp;#x2418; | &#x2418; |
| Cancellation Mark, Lao | &amp;#x0ECC; | &#x0ECC; |
| Cancer | &amp;#x264B; | &#x264B; |
| Candrabindu, Combining | &amp;#x0310; | &#x0310; |
| Candrabindu, Devanagari Sign | &amp;#x0901; | &#x0901; |
| Cantillation Marks, Hebrew | &amp;#x0591; | &#x0591; |
| Cantillation Signs, Tibetan | &amp;#x0FC0; | &#x0FC0; |
| Cap | &amp;#x2229; | &#x2229; |
| Cap, Square | &amp;#x2293; | &#x2293; |
| Capital Letters, Armenian | &amp;#x0531; | &#x0531; |
| Capital Letters, Cyrillic | &amp;#x0400; | &#x0400; |
| Capital Letters, Georgian | &amp;#x10A0; | &#x10A0; |
| Capital Letters, Greek | &amp;#x0391; | &#x0391; |
| Capital Letters, Latin | &amp;#x0041; | &#x0041; |
| Capricorn | &amp;#x2651; | &#x2651; |
| Caps Lock | &amp;#x21EA; | &#x21EA; |
| Caps Lock | &amp;#x21EC; | &#x21EC; |
| Card Suits, Playing | &amp;#x2660; | &#x2660; |
| Cardinal, First Transfinite | &amp;#x2135; | &#x2135; |
| Cardinal, Fourth Transfinite | &amp;#x2138; | &#x2138; |
| Cardinal, Second Transfinite | &amp;#x2136; | &#x2136; |
| Cardinal, Third Transfinite | &amp;#x2137; | &#x2137; |
| Care Of | &amp;#x2105; | &#x2105; |
| Caret | &amp;#x028C; | &#x028C; |
| Caret | &amp;#x2038; | &#x2038; |
| Caret Insertion Point | &amp;#x2041; | &#x2041; |
| Carian | &amp;#x102A0; | &#x102A0; |
| Caron | &amp;#x02C7; | &#x02C7; |
| Caron Below, Combining | &amp;#x032C; | &#x032C; |
| Caron, Combining | &amp;#x030C; | &#x030C; |
| Carriage Return | &amp;#x000D; | &#x000D; |
| Carriage Return, Symbol For | &amp;#x240D; | &#x240D; |
| Cartesian Product | &amp;#x00D7; | &#x00D7; |
| Caution Sign | &amp;#x2621; | &#x2621; |
| Cedi Sign | &amp;#x20B5; | &#x20B5; |
| Cedilla | &amp;#x00B8; | &#x00B8; |
| Cedilla Above | &amp;#x0312; | &#x0312; |
| Cedilla, Combining | &amp;#x0327; | &#x0327; |
| Cedilla, Latin Capital Letter C With | &amp;#x00C7; | &#x00C7; |
| Cedilla, Latin Small Letter C With | &amp;#x00E7; | &#x00E7; |
| Cedilla, Spacing | &amp;#x00B8; | &#x00B8; |
| Ceiling, Left | &amp;#x2308; | &#x2308; |
| Ceiling, Right | &amp;#x2309; | &#x2309; |
| Celsius, Degree | &amp;#x2103; | &#x2103; |
| Cent Sign | &amp;#x00A2; | &#x00A2; |
| Center | &amp;#x2385; | &#x2385; |
| Centigrade, Degrees | &amp;#x2103; | &#x2103; |
| Centre Line Symbol | &amp;#x2104; | &#x2104; |
| Centreline Low Line | &amp;#xFE4E; | &#xFE4E; |
| Centreline Overline | &amp;#xFE4A; | &#xFE4A; |
| Cham | &amp;#xAA00; | &#xAA00; |
| Chandrakkala, Malayalam | &amp;#x0D4D; | &#x0D4D; |
| Character Introducer, Single | &amp;#x009A; | &#x009A; |
| Character Tabulation | &amp;#x0009; | &#x0009; |
| Character Tabulation Set | &amp;#x0088; | &#x0088; |
| Character Tabulation With Justification | &amp;#x0089; | &#x0089; |
| Character Tie | &amp;#x2040; | &#x2040; |
| Chart Components, Form And | &amp;#x2500; | &#x2500; |
| Check Mark | &amp;#x2713; | &#x2713; |
| Check Mark, Heavy | &amp;#x2714; | &#x2714; |
| Check Mark, Not | &amp;#x237B; | &#x237B; |
| Check, Ballot Box With | &amp;#x2611; | &#x2611; |
| Checkers, Symbols For Draughts And | &amp;#x26C0; | &#x26C0; |
| Cherokee | &amp;#x13A0; | &#x13A0; |
| Chess Symbols | &amp;#x2654; | &#x2654; |
| Chess Symbols, Japanese | &amp;#x2616; | &#x2616; |
| Chevron Bracket, Left | &amp;#x27EA; | &#x27EA; |
| Chevron Bracket, Right | &amp;#x27EB; | &#x27EB; |
| Chevrons | &amp;#x00AB; | &#x00AB; |
| Chi Rho | &amp;#x2627; | &#x2627; |
| Chillu Letters, Malayalam | &amp;#x0D7A; | &#x0D7A; |
| Chinese Bopomofo | &amp;#x3100; | &#x3100; |
| Chinese Bopomofo Extensions | &amp;#x31A0; | &#x31A0; |
| Chinese Fifth Or Neutral Tone, Mandarin | &amp;#x02D9; | &#x02D9; |
| Chinese First Tone, Mandarin | &amp;#x02C9; | &#x02C9; |
| Chinese Fourth Tone, Mandarin | &amp;#x02CB; | &#x02CB; |
| Chinese Second Tone, Mandarin | &amp;#x02CA; | &#x02CA; |
| Chinese Third Tone, Mandarin | &amp;#x02C7; | &#x02C7; |
| Chinese, Corner Tone Marks For | &amp;#xA700; | &#xA700; |
| Choice, Dijkstra | &amp;#x2AFE; | &#x2AFE; |
| Choice, N-Ary Dijkstra | &amp;#x2AFF; | &#x2AFF; |
| Christogram | &amp;#x2627; | &#x2627; |
| Circle Backslash, Combining Enclosing | &amp;#x20E0; | &#x20E0; |
| Circle Symbols | &amp;#x29B5; | &#x29B5; |
| Circle, Black | &amp;#x25CF; | &#x25CF; |
| Circle, Black Small | &amp;#x2022; | &#x2022; |
| Circle, Combining Enclosing | &amp;#x20DD; | &#x20DD; |
| Circle, Dotted | &amp;#x25CC; | &#x25CC; |
| Circle, Jis Composition | &amp;#x20DD; | &#x20DD; |
| Circle, Large | &amp;#x25EF; | &#x25EF; |
| Circle, Medium Black | &amp;#x26AB; | &#x26AB; |
| Circle, Medium Small White | &amp;#x26AC; | &#x26AC; |
| Circle, Medium White | &amp;#x26AA; | &#x26AA; |
| Circle, Shadowed White | &amp;#x274D; | &#x274D; |
| Circle, White | &amp;#x25CB; | &#x25CB; |
| Circled Asterisk Operator | &amp;#x229B; | &#x229B; |
| Circled Dash | &amp;#x229D; | &#x229D; |
| Circled Digit Zero | &amp;#x24EA; | &#x24EA; |
| Circled Digits, Dingbat | &amp;#x2776; | &#x2776; |
| Circled Division Sign | &amp;#x2A38; | &#x2A38; |
| Circled Division Slash | &amp;#x2298; | &#x2298; |
| Circled Dot Operator | &amp;#x2299; | &#x2299; |
| Circled Dot Operator, N-Ary | &amp;#x2A00; | &#x2A00; |
| Circled Equals | &amp;#x229C; | &#x229C; |
| Circled Ideographs | &amp;#x3280; | &#x3280; |
| Circled Inverse Numbers | &amp;#x2776; | &#x2776; |
| Circled Katakana | &amp;#x32D0; | &#x32D0; |
| Circled Korean Hangul Elements | &amp;#x3260; | &#x3260; |
| Circled Korean Hangul Syllables | &amp;#x326E; | &#x326E; |
| Circled Latin Letters | &amp;#x24B6; | &#x24B6; |
| Circled Minus | &amp;#x2296; | &#x2296; |
| Circled Numbers | &amp;#x2460; | &#x2460; |
| Circled Numbers | &amp;#x3251; | &#x3251; |
| Circled Numbers | &amp;#x32B1; | &#x32B1; |
| Circled Numbers, Double | &amp;#x24F5; | &#x24F5; |
| Circled Numbers, White On Black | &amp;#x24EB; | &#x24EB; |
| Circled Plus | &amp;#x2295; | &#x2295; |
| Circled Plus Operator, N-Ary | &amp;#x2A01; | &#x2A01; |
| Circled Postal Mark | &amp;#x3036; | &#x3036; |
| Circled Ring Operator | &amp;#x229A; | &#x229A; |
| Circled Times | &amp;#x2297; | &#x2297; |
| Circled Times Operator, N-Ary | &amp;#x2A02; | &#x2A02; |
| Circles | &amp;#x25CB; | &#x25CB; |
| Circumflex Accent | &amp;#x005E; | &#x005E; |
| Circumflex Accent Below, Combining | &amp;#x032D; | &#x032D; |
| Circumflex Accent, Combining | &amp;#x0302; | &#x0302; |
| Circumflex Accent, Modifier Letter | &amp;#x02C6; | &#x02C6; |
| Circumflex Accent, Spacing | &amp;#x005E; | &#x005E; |
| Cjk Angle Brackets | &amp;#x3008; | &#x3008; |
| Cjk Compatibility | &amp;#x3300; | &#x3300; |
| Cjk Compatibility Forms | &amp;#xFE30; | &#xFE30; |
| Cjk Compatibility Ideographs | &amp;#xF900; | &#xF900; |
| Cjk Compatibility Ideographs Supplement | &amp;#x2F800; | &#x2F800; |
| Cjk Corner Brackets | &amp;#x300C; | &#x300C; |
| Cjk Diacritics | &amp;#x302A; | &#x302A; |
| Cjk Ideographic Description Characters | &amp;#x2FF0; | &#x2FF0; |
| Cjk Ideographs Area | &amp;#x3400; | &#x3400; |
| Cjk Ideographs Area, Supplementary | &amp;#x20000; | &#x20000; |
| Cjk Ideographs, Parenthesized | &amp;#x3220; | &#x3220; |
| Cjk Kangxi Radicals | &amp;#x2F00; | &#x2F00; |
| Cjk Letters And Months, Enclosed | &amp;#x3200; | &#x3200; |
| Cjk Phonetics And Symbols Area | &amp;#x2E80; | &#x2E80; |
| Cjk Punctuation, Halfwidth | &amp;#xFF61; | &#xFF61; |
| Cjk Quotation Marks | &amp;#x300C; | &#x300C; |
| Cjk Radicals Supplement | &amp;#x2E80; | &#x2E80; |
| Cjk Strokes | &amp;#x31C0; | &#x31C0; |
| Cjk Symbols And Punctuation | &amp;#x3000; | &#x3000; |
| Cjk Unified Ideographs | &amp;#x4E00; | &#x4E00; |
| Cjk Unified Ideographs Extension A | &amp;#x3400; | &#x3400; |
| Cjk Unified Ideographs Extension B | &amp;#x20000; | &#x20000; |
| Claudian Antisigma | &amp;#x2183; | &#x2183; |
| Claudian Digamma Inversum | &amp;#x2132; | &#x2132; |
| Clear Key | &amp;#x2327; | &#x2327; |
| Clear Screen Symbol | &amp;#x239A; | &#x239A; |
| Clear Weather | &amp;#x2600; | &#x2600; |
| Click, Latin Letter Alveolar | &amp;#x01C2; | &#x01C2; |
| Click, Latin Letter Bilabial | &amp;#x0298; | &#x0298; |
| Click, Latin Letter Dental | &amp;#x01C0; | &#x01C0; |
| Click, Latin Letter Lateral | &amp;#x01C1; | &#x01C1; |
| Click, Latin Letter Retroflex | &amp;#x01C3; | &#x01C3; |
| Clicks, African Letters For | &amp;#x01C0; | &#x01C0; |
| Clockwise Arrow Above, Combining | &amp;#x20D5; | &#x20D5; |
| Clockwise Contour Integral | &amp;#x2232; | &#x2232; |
| Clockwise Integral | &amp;#x2231; | &#x2231; |
| Clockwise Ring Overlay, Combining | &amp;#x20D9; | &#x20D9; |
| Clone | &amp;#x2104; | &#x2104; |
| Clones Of Diacritics, Spacing | &amp;#x02D8; | &#x02D8; |
| Close Up | &amp;#x2050; | &#x2050; |
| Closed Epsilon, Latin Small Letter | &amp;#x029A; | &#x029A; |
| Closed Omega, Latin Small Letter | &amp;#x0277; | &#x0277; |
| Closed Open E, Latin Small Letter | &amp;#x029A; | &#x029A; |
| Closed Reversed Epsilon, Latin Small Letter | &amp;#x025E; | &#x025E; |
| Closed Reversed Open E, Latin Small Letter | &amp;#x025E; | &#x025E; |
| Closing Brace | &amp;#x007D; | &#x007D; |
| Closing Curly Bracket | &amp;#x007D; | &#x007D; |
| Closing Mark, Ideographic | &amp;#x3006; | &#x3006; |
| Closing Parenthesis | &amp;#x0029; | &#x0029; |
| Closing Square Bracket | &amp;#x005D; | &#x005D; |
| Cloud | &amp;#x2601; | &#x2601; |
| Cloudy Weather | &amp;#x2601; | &#x2601; |
| Coffee, Cup Of | &amp;#x2615; | &#x2615; |
| Coffin | &amp;#x26B0; | &#x26B0; |
| Colon | &amp;#x003A; | &#x003A; |
| Colon Equals | &amp;#x2254; | &#x2254; |
| Colon Right Arrow | &amp;#x29F4; | &#x29F4; |
| Colon Sign | &amp;#x20A1; | &#x20A1; |
| Colon, Equals | &amp;#x2255; | &#x2255; |
| Colon, Ethiopic | &amp;#x1365; | &#x1365; |
| Colon, Ethiopic Preface | &amp;#x1366; | &#x1366; |
| Colon, Modifier Letter Half Triangular | &amp;#x02D1; | &#x02D1; |
| Colon, Modifier Letter Triangular | &amp;#x02D0; | &#x02D0; |
| Colon, Mongolian | &amp;#x1804; | &#x1804; |
| Colon, Z Notation Type | &amp;#x2982; | &#x2982; |
| Combining Acute Accent | &amp;#x0301; | &#x0301; |
| Combining Acute Accent Below | &amp;#x0317; | &#x0317; |
| Combining Acute Tone Mark | &amp;#x0341; | &#x0341; |
| Combining Almost Equal To Above | &amp;#x034C; | &#x034C; |
| Combining Alphabet, Korean Hangul Jamo | &amp;#x1100; | &#x1100; |
| Combining Annuity Symbol | &amp;#x20E7; | &#x20E7; |
| Combining Anticlockwise Arrow Above | &amp;#x20D4; | &#x20D4; |
| Combining Anticlockwise Ring Overlay | &amp;#x20DA; | &#x20DA; |
| Combining Asterisk Above | &amp;#x20F0; | &#x20F0; |
| Combining Asterisk Below | &amp;#x0359; | &#x0359; |
| Combining Breve | &amp;#x0306; | &#x0306; |
| Combining Breve Below | &amp;#x032E; | &#x032E; |
| Combining Bridge Above | &amp;#x0346; | &#x0346; |
| Combining Bridge Below | &amp;#x032A; | &#x032A; |
| Combining Candrabindu | &amp;#x0310; | &#x0310; |
| Combining Caron | &amp;#x030C; | &#x030C; |
| Combining Caron Below | &amp;#x032C; | &#x032C; |
| Combining Cedilla | &amp;#x0327; | &#x0327; |
| Combining Characters, Cyrillic | &amp;#x0483; | &#x0483; |
| Combining Circumflex Accent | &amp;#x0302; | &#x0302; |
| Combining Circumflex Accent Below | &amp;#x032D; | &#x032D; |
| Combining Clockwise Arrow Above | &amp;#x20D5; | &#x20D5; |
| Combining Clockwise Ring Overlay | &amp;#x20D9; | &#x20D9; |
| Combining Comma Above | &amp;#x0313; | &#x0313; |
| Combining Comma Above Right | &amp;#x0315; | &#x0315; |
| Combining Comma Below | &amp;#x0326; | &#x0326; |
| Combining Conjoining Macron | &amp;#xFE26; | &#xFE26; |
| Combining Counterclockwise Arrow Above | &amp;#x20D4; | &#x20D4; |
| Combining Counterclockwise Ring Overlay | &amp;#x20DA; | &#x20DA; |
| Combining Diacritical Marks | &amp;#x0300; | &#x0300; |
| Combining Diacritical Marks For Symbols | &amp;#x20D0; | &#x20D0; |
| Combining Diaeresis | &amp;#x0308; | &#x0308; |
| Combining Diaeresis Below | &amp;#x0324; | &#x0324; |
| Combining Dot Above | &amp;#x0307; | &#x0307; |
| Combining Dot Above Right | &amp;#x0358; | &#x0358; |
| Combining Dot Below | &amp;#x0323; | &#x0323; |
| Combining Double Acute Accent | &amp;#x030B; | &#x030B; |
| Combining Double Breve | &amp;#x035D; | &#x035D; |
| Combining Double Breve Below | &amp;#x035C; | &#x035C; |
| Combining Double Grave Accent | &amp;#x030F; | &#x030F; |
| Combining Double Inverted Breve | &amp;#x0361; | &#x0361; |
| Combining Double Low Line | &amp;#x0333; | &#x0333; |
| Combining Double Macron | &amp;#x035E; | &#x035E; |
| Combining Double Macron Below | &amp;#x035F; | &#x035F; |
| Combining Double Overline | &amp;#x033F; | &#x033F; |
| Combining Double Rightwards Arrow Below | &amp;#x0362; | &#x0362; |
| Combining Double Ring Below | &amp;#x035A; | &#x035A; |
| Combining Double Tilde | &amp;#x0360; | &#x0360; |
| Combining Double Vertical Line Above | &amp;#x030E; | &#x030E; |
| Combining Double Vertical Line Below | &amp;#x0348; | &#x0348; |
| Combining Double Vertical Stroke Overlay | &amp;#x20E6; | &#x20E6; |
| Combining Down Tack Below | &amp;#x031E; | &#x031E; |
| Combining Enclosing Circle | &amp;#x20DD; | &#x20DD; |
| Combining Enclosing Circle Backslash | &amp;#x20E0; | &#x20E0; |
| Combining Enclosing Diamond | &amp;#x20DF; | &#x20DF; |
| Combining Enclosing Keycap | &amp;#x20E3; | &#x20E3; |
| Combining Enclosing Screen | &amp;#x20E2; | &#x20E2; |
| Combining Enclosing Square | &amp;#x20DE; | &#x20DE; |
| Combining Enclosing Upward Pointing Triangle | &amp;#x20E4; | &#x20E4; |
| Combining Equals Sign Below | &amp;#x0347; | &#x0347; |
| Combining Fermata | &amp;#x0352; | &#x0352; |
| Combining Four Dots Above | &amp;#x20DC; | &#x20DC; |
| Combining Grapheme Joiner | &amp;#x034F; | &#x034F; |
| Combining Grave Accent | &amp;#x0300; | &#x0300; |
| Combining Grave Accent Below | &amp;#x0316; | &#x0316; |
| Combining Grave Tone Mark | &amp;#x0340; | &#x0340; |
| Combining Greek Dialytika Tonos | &amp;#x0344; | &#x0344; |
| Combining Greek Koronis | &amp;#x0343; | &#x0343; |
| Combining Greek Perispomeni | &amp;#x0342; | &#x0342; |
| Combining Greek Ypogegrammeni | &amp;#x0345; | &#x0345; |
| Combining Hacek | &amp;#x030C; | &#x030C; |
| Combining Half Marks | &amp;#xFE20; | &#xFE20; |
| Combining Homothetic Above | &amp;#x034B; | &#x034B; |
| Combining Hook Above | &amp;#x0309; | &#x0309; |
| Combining Horn | &amp;#x031B; | &#x031B; |
| Combining Inverted Breve | &amp;#x0311; | &#x0311; |
| Combining Inverted Breve Below | &amp;#x032F; | &#x032F; |
| Combining Inverted Bridge Below | &amp;#x033A; | &#x033A; |
| Combining Inverted Double Arch Below | &amp;#x032B; | &#x032B; |
| Combining Japanese Daku-On | &amp;#x3099; | &#x3099; |
| Combining Japanese Han-Daku-On | &amp;#x309A; | &#x309A; |
| Combining Latin Small Letters | &amp;#x0363; | &#x0363; |
| Combining Left Angle Above | &amp;#x031A; | &#x031A; |
| Combining Left Angle Below | &amp;#x0349; | &#x0349; |
| Combining Left Arrow Above | &amp;#x20D6; | &#x20D6; |
| Combining Left Arrow Below | &amp;#x20EE; | &#x20EE; |
| Combining Left Arrowhead Below | &amp;#x0354; | &#x0354; |
| Combining Left Half Ring Above | &amp;#x0351; | &#x0351; |
| Combining Left Half Ring Below | &amp;#x031C; | &#x031C; |
| Combining Left Harpoon Above | &amp;#x20D0; | &#x20D0; |
| Combining Left Right Arrow Above | &amp;#x20E1; | &#x20E1; |
| Combining Left Right Arrow Below | &amp;#x034D; | &#x034D; |
| Combining Left Tack Below | &amp;#x0318; | &#x0318; |
| Combining Leftwards Arrow Overlay | &amp;#x20EA; | &#x20EA; |
| Combining Leftwards Harpoon With Barb Downwards | &amp;#x20ED; | &#x20ED; |
| Combining Long Double Solidus Overlay | &amp;#x20EB; | &#x20EB; |
| Combining Long Solidus Overlay | &amp;#x0338; | &#x0338; |
| Combining Long Stroke Overlay | &amp;#x0336; | &#x0336; |
| Combining Long Vertical Line Overlay | &amp;#x20D2; | &#x20D2; |
| Combining Low Line | &amp;#x0332; | &#x0332; |
| Combining Macron | &amp;#x0304; | &#x0304; |
| Combining Macron Below | &amp;#x0331; | &#x0331; |
| Combining Macron Left Half | &amp;#xFE24; | &#xFE24; |
| Combining Macron Right Half | &amp;#xFE25; | &#xFE25; |
| Combining Marks, Arabic | &amp;#x0653; | &#x0653; |
| Combining Minus Sign Below | &amp;#x0320; | &#x0320; |
| Combining Not Tilde Above | &amp;#x034A; | &#x034A; |
| Combining Ogonek | &amp;#x0328; | &#x0328; |
| Combining Overline | &amp;#x0305; | &#x0305; |
| Combining Palatalized Hook Below | &amp;#x0321; | &#x0321; |
| Combining Plus Sign Below | &amp;#x031F; | &#x031F; |
| Combining Retroflex Hook Below | &amp;#x0322; | &#x0322; |
| Combining Reverse Solidus Overlay | &amp;#x20E5; | &#x20E5; |
| Combining Reversed Comma Above | &amp;#x0314; | &#x0314; |
| Combining Right Arrow Above | &amp;#x20D7; | &#x20D7; |
| Combining Right Arrow Below | &amp;#x20EF; | &#x20EF; |
| Combining Right Arrowhead Above | &amp;#x0350; | &#x0350; |
| Combining Right Arrowhead Below | &amp;#x0355; | &#x0355; |
| Combining Right Half Ring Above | &amp;#x0357; | &#x0357; |
| Combining Right Half Ring Below | &amp;#x0339; | &#x0339; |
| Combining Right Harpoon Above | &amp;#x20D1; | &#x20D1; |
| Combining Right Tack Below | &amp;#x0319; | &#x0319; |
| Combining Rightwards Harpoon With Barb Downwards | &amp;#x20EC; | &#x20EC; |
| Combining Ring Above | &amp;#x030A; | &#x030A; |
| Combining Ring Below | &amp;#x0325; | &#x0325; |
| Combining Ring Overlay | &amp;#x20D8; | &#x20D8; |
| Combining Seagull Below | &amp;#x033C; | &#x033C; |
| Combining Short Solidus Overlay | &amp;#x0337; | &#x0337; |
| Combining Short Stroke Overlay | &amp;#x0335; | &#x0335; |
| Combining Short Vertical Line Overlay | &amp;#x20D3; | &#x20D3; |
| Combining Square Below | &amp;#x033B; | &#x033B; |
| Combining Three Dots Above | &amp;#x20DB; | &#x20DB; |
| Combining Tilde | &amp;#x0303; | &#x0303; |
| Combining Tilde Below | &amp;#x0330; | &#x0330; |
| Combining Tilde Overlay | &amp;#x0334; | &#x0334; |
| Combining Triple Underdot | &amp;#x20E8; | &#x20E8; |
| Combining Turned Comma Above | &amp;#x0312; | &#x0312; |
| Combining Up Tack Below | &amp;#x031D; | &#x031D; |
| Combining Upwards Arrow Below | &amp;#x034E; | &#x034E; |
| Combining Vertical Line Above | &amp;#x030D; | &#x030D; |
| Combining Vertical Line Below | &amp;#x0329; | &#x0329; |
| Combining Vertical Tilde | &amp;#x033E; | &#x033E; |
| Combining Wide Bridge Above | &amp;#x20E9; | &#x20E9; |
| Combining X Above | &amp;#x033D; | &#x033D; |
| Combining X Below | &amp;#x0353; | &#x0353; |
| Combining Zigzag Above | &amp;#x035B; | &#x035B; |
| Comet | &amp;#x2604; | &#x2604; |
| Comma | &amp;#x002C; | &#x002C; |
| Comma Above Right, Combining | &amp;#x0315; | &#x0315; |
| Comma Above, Combining | &amp;#x0313; | &#x0313; |
| Comma Above, Combining Reversed | &amp;#x0314; | &#x0314; |
| Comma Above, Combining Turned | &amp;#x0312; | &#x0312; |
| Comma Below, Combining | &amp;#x0326; | &#x0326; |
| Comma Quotation Mark, Double | &amp;#x201D; | &#x201D; |
| Comma Quotation Mark, Double Reversed | &amp;#x201F; | &#x201F; |
| Comma Quotation Mark, Double Turned | &amp;#x201C; | &#x201C; |
| Comma Quotation Mark, Low Double | &amp;#x201E; | &#x201E; |
| Comma Quotation Mark, Low Single | &amp;#x201A; | &#x201A; |
| Comma Quotation Mark, Single | &amp;#x2019; | &#x2019; |
| Comma Quotation Mark, Single Reversed | &amp;#x201B; | &#x201B; |
| Comma Quotation Mark, Single Turned | &amp;#x2018; | &#x2018; |
| Comma, Arabic | &amp;#x060C; | &#x060C; |
| Comma, Armenian | &amp;#x055D; | &#x055D; |
| Comma, Ethiopic | &amp;#x1363; | &#x1363; |
| Comma, Georgian | &amp;#x00B7; | &#x00B7; |
| Comma, Ideographic | &amp;#x3001; | &#x3001; |
| Comma, Invisible | &amp;#x2063; | &#x2063; |
| Comma, Modifier Letter Reversed | &amp;#x02BD; | &#x02BD; |
| Comma, Modifier Letter Turned | &amp;#x02BB; | &#x02BB; |
| Comma, Mongolian | &amp;#x1802; | &#x1802; |
| Comma, Mongolian Manchu | &amp;#x1808; | &#x1808; |
| Command Key | &amp;#x2318; | &#x2318; |
| Command, Application Program | &amp;#x009F; | &#x009F; |
| Command, Operating System | &amp;#x009D; | &#x009D; |
| Commercial At | &amp;#x0040; | &#x0040; |
| Commercial Minus Sign | &amp;#x2052; | &#x2052; |
| Compass | &amp;#x263C; | &#x263C; |
| Compatibility And Specials Area | &amp;#xF900; | &#xF900; |
| Compatibility Forms, Cjk | &amp;#xFE30; | &#xFE30; |
| Compatibility Ideographs Supplement, Cjk | &amp;#x2F800; | &#x2F800; |
| Compatibility Ideographs, Cjk | &amp;#xF900; | &#xF900; |
| Compatibility Ideographs, Dprk | &amp;#xFA70; | &#xFA70; |
| Compatibility Ideographs, Jis X 0213 | &amp;#xFA30; | &#xFA30; |
| Compatibility Jamo, Korean Hangul | &amp;#x3130; | &#x3130; |
| Compatibility, Cjk | &amp;#x3300; | &#x3300; |
| Complement | &amp;#x2201; | &#x2201; |
| Complex Numbers | &amp;#x2102; | &#x2102; |
| Component, Radial | &amp;#x27DF; | &#x27DF; |
| Components, Form And Chart | &amp;#x2500; | &#x2500; |
| Composite Function | &amp;#x2218; | &#x2218; |
| Composition Circle, Jis | &amp;#x20DD; | &#x20DD; |
| Composition Symbol | &amp;#x2384; | &#x2384; |
| Concatenation, Sequence | &amp;#x2040; | &#x2040; |
| Conical Taper | &amp;#x2332; | &#x2332; |
| Conjoining Macron, Combining | &amp;#xFE26; | &#xFE26; |
| Conjugate Matrix, Hermitian | &amp;#x22B9; | &#x22B9; |
| Conjunction | &amp;#x2227; | &#x2227; |
| Conjunction | &amp;#x260C; | &#x260C; |
| Constant Pi, Mathematical | &amp;#x03C0; | &#x03C0; |
| Constant, Euler | &amp;#x2107; | &#x2107; |
| Constant, Planck | &amp;#x210E; | &#x210E; |
| Constantine's Cross | &amp;#x2627; | &#x2627; |
| Contains As Member | &amp;#x220B; | &#x220B; |
| Contains As Member, Small | &amp;#x220D; | &#x220D; |
| Contains As Normal Subgroup | &amp;#x22B3; | &#x22B3; |
| Contextual Form Glyphs, Arabic | &amp;#xFB50; | &#xFB50; |
| Contextual Form Glyphs, Arabic | &amp;#xFE80; | &#xFE80; |
| Continuity, Absolute | &amp;#x2AA1; | &#x2AA1; |
| Continuous Underline Symbol | &amp;#x2381; | &#x2381; |
| Continuum, Second Transfinite Cardinal | &amp;#x2136; | &#x2136; |
| Contour Integral | &amp;#x222E; | &#x222E; |
| Contour Integral, Anticlockwise | &amp;#x2233; | &#x2233; |
| Contour Integral, Clockwise | &amp;#x2232; | &#x2232; |
| Contour Integral, Counterclockwise | &amp;#x2233; | &#x2233; |
| Contraction Operator | &amp;#x20E9; | &#x20E9; |
| Control | &amp;#x2388; | &#x2388; |
| Control Code Graphics, Quadrant | &amp;#x25F0; | &#x25F0; |
| Control Codes, Graphic Pictures For | &amp;#x2400; | &#x2400; |
| Control Codes, Graphics For | &amp;#x237D; | &#x237D; |
| Control Sequence Introducer | &amp;#x009B; | &#x009B; |
| Controls, Bidirectional Format | &amp;#x202A; | &#x202A; |
| Controls, Mongolian Format | &amp;#x180B; | &#x180B; |
| Coproduct Sign | &amp;#x2210; | &#x2210; |
| Coproduct, N-Ary | &amp;#x2210; | &#x2210; |
| Coptic Letters Derived From Demotic | &amp;#x03E2; | &#x03E2; |
| Coptic, Bohairic | &amp;#x2C80; | &#x2C80; |
| Coptic, Continuous Macrons For | &amp;#xFE24; | &#xFE24; |
| Coptic, Extended | &amp;#x2CB2; | &#x2CB2; |
| Copyright Sign | &amp;#x00A9; | &#x00A9; |
| Copyright, Sound Recording | &amp;#x2117; | &#x2117; |
| Corner Brackets | &amp;#x2308; | &#x2308; |
| Corner Brackets, Cjk | &amp;#x300C; | &#x300C; |
| Corner Tone Marks For Chinese | &amp;#xA700; | &#xA700; |
| Corners, Quine | &amp;#x231C; | &#x231C; |
| Corresponds To | &amp;#x2258; | &#x2258; |
| Corresponds To | &amp;#x2259; | &#x2259; |
| Costa Rican Currency | &amp;#x20A1; | &#x20A1; |
| Countable, First Transfinite Cardinal | &amp;#x2135; | &#x2135; |
| Counterbore | &amp;#x2334; | &#x2334; |
| Counterclockwise Arrow Above, Combining | &amp;#x20D4; | &#x20D4; |
| Counterclockwise Contour Integral | &amp;#x2233; | &#x2233; |
| Counterclockwise Integration | &amp;#x2A11; | &#x2A11; |
| Counterclockwise Ring Overlay, Combining | &amp;#x20DA; | &#x20DA; |
| Countersink | &amp;#x2335; | &#x2335; |
| Credit Sign, Tamil | &amp;#x0BF7; | &#x0BF7; |
| Cremated Symbol | &amp;#x26B1; | &#x26B1; |
| Crescent, Star And | &amp;#x262A; | &#x262A; |
| Croatian Digraphs Matching Serbian Cyrillic Letters | &amp;#x01C4; | &#x01C4; |
| Crops | &amp;#x230C; | &#x230C; |
| Cross Accent, Modifier Letter | &amp;#x02DF; | &#x02DF; |
| Cross Dingbats | &amp;#x2719; | &#x2719; |
| Cross Of Jerusalem | &amp;#x2629; | &#x2629; |
| Cross Of Lorraine | &amp;#x2628; | &#x2628; |
| Cross Ratio | &amp;#x211E; | &#x211E; |
| Cross, Constantine's | &amp;#x2627; | &#x2627; |
| Cross, Dotted | &amp;#x205C; | &#x205C; |
| Cross, East Syriac | &amp;#x2671; | &#x2671; |
| Cross, Latin | &amp;#x271D; | &#x271D; |
| Cross, Long | &amp;#x2020; | &#x2020; |
| Cross, Maltese | &amp;#x2720; | &#x2720; |
| Cross, Orthodox | &amp;#x2626; | &#x2626; |
| Cross, St. Andrew's | &amp;#x2613; | &#x2613; |
| Cross, West Syriac | &amp;#x2670; | &#x2670; |
| Crossed Swords | &amp;#x2694; | &#x2694; |
| Crosses | &amp;#x2719; | &#x2719; |
| Crosshatch | &amp;#x0023; | &#x0023; |
| Cruzeiro Sign | &amp;#x20A2; | &#x20A2; |
| Cube Root | &amp;#x221B; | &#x221B; |
| Cubed | &amp;#x00B3; | &#x00B3; |
| Cuneiform | &amp;#x12000; | &#x12000; |
| Cuneiform Numbers And Punctuation | &amp;#x12400; | &#x12400; |
| Cup | &amp;#x222A; | &#x222A; |
| Cup Of Coffee | &amp;#x2615; | &#x2615; |
| Cup Of Tea | &amp;#x2615; | &#x2615; |
| Cup, Square | &amp;#x2294; | &#x2294; |
| Curled Beta | &amp;#x03D0; | &#x03D0; |
| Curly Bracket, Closing | &amp;#x007D; | &#x007D; |
| Curly Bracket, Left | &amp;#x007B; | &#x007B; |
| Curly Bracket, Left White | &amp;#x2983; | &#x2983; |
| Curly Bracket, Opening | &amp;#x007B; | &#x007B; |
| Curly Bracket, Right | &amp;#x007D; | &#x007D; |
| Curly Bracket, Right White | &amp;#x2984; | &#x2984; |
| Curly Logical And | &amp;#x22CF; | &#x22CF; |
| Curly Logical Or | &amp;#x22CE; | &#x22CE; |
| Currency Sign | &amp;#x00A4; | &#x00A4; |
| Currency Signs, Bengali | &amp;#x09F2; | &#x09F2; |
| Currency Symbol Baht, Thai | &amp;#x0E3F; | &#x0E3F; |
| Currency Symbol Riel, Khmer | &amp;#x17DB; | &#x17DB; |
| Currency Symbol, Florin | &amp;#x0192; | &#x0192; |
| Currency Symbols | &amp;#x20A0; | &#x20A0; |
| Currency, Argentinian Former | &amp;#x20B3; | &#x20B3; |
| Currency, Brazilian | &amp;#x20A2; | &#x20A2; |
| Currency, Costa Rican | &amp;#x20A1; | &#x20A1; |
| Currency, El Salvadorian | &amp;#x20A1; | &#x20A1; |
| Currency, Euro European | &amp;#x20AC; | &#x20AC; |
| Currency, French | &amp;#x20A3; | &#x20A3; |
| Currency, Ghana | &amp;#x20B5; | &#x20B5; |
| Currency, Greek | &amp;#x20AF; | &#x20AF; |
| Currency, Indian | &amp;#x20A8; | &#x20A8; |
| Currency, Iranian | &amp;#xFDFC; | &#xFDFC; |
| Currency, Israeli | &amp;#x20AA; | &#x20AA; |
| Currency, Italian | &amp;#x20A4; | &#x20A4; |
| Currency, Korean | &amp;#x20A9; | &#x20A9; |
| Currency, Laotian | &amp;#x20AD; | &#x20AD; |
| Currency, Mongolian | &amp;#x20AE; | &#x20AE; |
| Currency, Nigerian | &amp;#x20A6; | &#x20A6; |
| Currency, Paraguayan | &amp;#x20B2; | &#x20B2; |
| Currency, Phillipine | &amp;#x20B1; | &#x20B1; |
| Currency, Spanish | &amp;#x20A7; | &#x20A7; |
| Currency, Turkish | &amp;#x20A4; | &#x20A4; |
| Currency, Ukrainian | &amp;#x20B4; | &#x20B4; |
| Currency, Vietnamese | &amp;#x20AB; | &#x20AB; |
| Current Symbol Form Two, Direct | &amp;#x2393; | &#x2393; |
| Current, AC | &amp;#x23E6; | &#x23E6; |
| Current, Alternating | &amp;#x223F; | &#x223F; |
| Current, Direct, Symbol Form Two | &amp;#x2393; | &#x2393; |
| Cursor Down, Fast | &amp;#x21A1; | &#x21A1; |
| Cursor Left, Fast | &amp;#x219E; | &#x219E; |
| Cursor Right, Fast | &amp;#x21A0; | &#x21A0; |
| Cursor Up, Fast | &amp;#x219F; | &#x219F; |
| Cycle | &amp;#x223C; | &#x223C; |
| Cylindricity | &amp;#x232D; | &#x232D; |
| Cypriot Syllabary | &amp;#x10800; | &#x10800; |
| Cyrillic | &amp;#x0400; | &#x0400; |
| Cyrillic Capital Letters | &amp;#x0400; | &#x0400; |
| Cyrillic Combining Characters | &amp;#x0483; | &#x0483; |
| Cyrillic Extended-A | &amp;#x2DE0; | &#x2DE0; |
| Cyrillic Extended-B | &amp;#xA640; | &#xA640; |
| Cyrillic Extensions | &amp;#x0450; | &#x0450; |
| Cyrillic Extensions | &amp;#x048A; | &#x048A; |
| Cyrillic Historic Letters | &amp;#x0460; | &#x0460; |
| Cyrillic Small Letters | &amp;#x0430; | &#x0430; |
| Cyrillic Supplement | &amp;#x0500; | &#x0500; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## D

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| D Retroflex Hook, Latin Small Letter | &amp;#x0256; | &#x0256; |
| D With Caron, Latin Small Letter | &amp;#x010F; | &#x010F; |
| D With Cedilla, Latin Small Letter | &amp;#x1E11; | &#x1E11; |
| D With Circumflex Below, Latin Small Letter | &amp;#x1E13; | &#x1E13; |
| D With Curl, Latin Small Letter | &amp;#x0221; | &#x0221; |
| D With Dot Above, Latin Small Letter | &amp;#x1E0B; | &#x1E0B; |
| D With Dot Below, Latin Small Letter | &amp;#x1E0D; | &#x1E0D; |
| D With Hook, Latin Capital Letter | &amp;#x018A; | &#x018A; |
| D With Hook, Latin Small Letter | &amp;#x0257; | &#x0257; |
| D With Line Below, Latin Small Letter | &amp;#x1E0F; | &#x1E0F; |
| D With Stroke, Latin Small Letter | &amp;#x0111; | &#x0111; |
| D With Tail, Latin Small Letter | &amp;#x0256; | &#x0256; |
| D With Topbar, Latin Small Letter | &amp;#x018C; | &#x018C; |
| D'alembertian | &amp;#x29E0; | &#x29E0; |
| D, Combining Latin Small Letter | &amp;#x0369; | &#x0369; |
| D, Double-Struck Italic Capital | &amp;#x2145; | &#x2145; |
| D, Double-Struck Italic Small | &amp;#x2146; | &#x2146; |
| D, Latin Capital Letter African | &amp;#x0189; | &#x0189; |
| D, Latin Letter Small Capital | &amp;#x1D05; | &#x1D05; |
| Dagger | &amp;#x2020; | &#x2020; |
| Dagger, Double | &amp;#x2021; | &#x2021; |
| Daku-On, Combining Japanese | &amp;#x3099; | &#x3099; |
| Daku-On, Japanese | &amp;#x309B; | &#x309B; |
| Dalet Symbol | &amp;#x2138; | &#x2138; |
| Danda, Devanagari | &amp;#x0964; | &#x0964; |
| Danda, Devanagari Double | &amp;#x0965; | &#x0965; |
| Dash, Angled | &amp;#x00AC; | &#x00AC; |
| Dash, Circled | &amp;#x229D; | &#x229D; |
| Dash, Em | &amp;#x2014; | &#x2014; |
| Dash, En | &amp;#x2013; | &#x2013; |
| Dash, Figure | &amp;#x2012; | &#x2012; |
| Dash, Quotation | &amp;#x2015; | &#x2015; |
| Dash, Swung | &amp;#x2053; | &#x2053; |
| Dash, Wave | &amp;#x301C; | &#x301C; |
| Dash, Wavy | &amp;#x3030; | &#x3030; |
| Dashed Low Line | &amp;#xFE4D; | &#xFE4D; |
| Dashed Overline | &amp;#xFE49; | &#xFE49; |
| Dashes | &amp;#x2010; | &#x2010; |
| Dasia, Greek | &amp;#x0314; | &#x0314; |
| Data Link Escape | &amp;#x0010; | &#x0010; |
| Data Link Escape, Symbol For | &amp;#x2410; | &#x2410; |
| Database Theory Operators | &amp;#x27D5; | &#x27D5; |
| David, Star Of | &amp;#x2721; | &#x2721; |
| Day Sign, Tamil | &amp;#x0BF3; | &#x0BF3; |
| Days, Ideographic Telegraph Symbols For | &amp;#x33E0; | &#x33E0; |
| Db Digraph, Latin Small Letter | &amp;#x0238; | &#x0238; |
| Debit Sign, Tamil | &amp;#x0BF6; | &#x0BF6; |
| Decimal Point | &amp;#x002E; | &#x002E; |
| Decimal Separator | &amp;#x002C; | &#x002C; |
| Decimal Separator Key Symbol | &amp;#x2396; | &#x2396; |
| Decimal Separator, Arabic | &amp;#x066B; | &#x066B; |
| Deergh Viram, Devanagari | &amp;#x0965; | &#x0965; |
| Degree Celsius | &amp;#x2103; | &#x2103; |
| Degree Fahrenheit | &amp;#x2109; | &#x2109; |
| Degree Sign | &amp;#x00B0; | &#x00B0; |
| Degrees Centigrade | &amp;#x2103; | &#x2103; |
| Del | &amp;#x2207; | &#x2207; |
| Delete | &amp;#x007F; | &#x007F; |
| Delete Form Two, Symbol For | &amp;#x2425; | &#x2425; |
| Delete To The Left Key | &amp;#x232B; | &#x232B; |
| Delete To The Right Key | &amp;#x2326; | &#x2326; |
| Delete, Symbol For | &amp;#x2421; | &#x2421; |
| Delta Equal To | &amp;#x225C; | &#x225C; |
| Delta, Latin Small Letter Turned | &amp;#x018D; | &#x018D; |
| Demotic, Coptic Letters Derived From | &amp;#x03E2; | &#x03E2; |
| Dental Click, Latin Letter | &amp;#x01C0; | &#x01C0; |
| Dentistry Notation Symbols | &amp;#x23BE; | &#x23BE; |
| Depth Symbol | &amp;#x21A7; | &#x21A7; |
| Derivative | &amp;#x0307; | &#x0307; |
| Derivative, Double | &amp;#x0308; | &#x0308; |
| Derivative, Fourth | &amp;#x20DC; | &#x20DC; |
| Derivative, Third | &amp;#x20DB; | &#x20DB; |
| Descending Node | &amp;#x260B; | &#x260B; |
| Deseret | &amp;#x10400; | &#x10400; |
| Devanagari | &amp;#x0900; | &#x0900; |
| Devanagari Bindu | &amp;#x0902; | &#x0902; |
| Devanagari Consonants | &amp;#x0915; | &#x0915; |
| Devanagari Danda | &amp;#x0964; | &#x0964; |
| Devanagari Deergh Viram | &amp;#x0965; | &#x0965; |
| Devanagari Dependent Vowel Signs | &amp;#x093E; | &#x093E; |
| Devanagari Digits | &amp;#x0966; | &#x0966; |
| Devanagari Double Danda | &amp;#x0965; | &#x0965; |
| Devanagari Extensions | &amp;#x0951; | &#x0951; |
| Devanagari Independent Vowels | &amp;#x0904; | &#x0904; |
| Devanagari Om | &amp;#x0950; | &#x0950; |
| Devanagari Purna Viram | &amp;#x0964; | &#x0964; |
| Devanagari Sign Anusvara | &amp;#x0902; | &#x0902; |
| Devanagari Sign Avagraha | &amp;#x093D; | &#x093D; |
| Devanagari Sign Candrabindu | &amp;#x0901; | &#x0901; |
| Devanagari Sign Nukta | &amp;#x093C; | &#x093C; |
| Devanagari Sign Virama | &amp;#x094D; | &#x094D; |
| Devanagari Sign Visarga | &amp;#x0903; | &#x0903; |
| Device Controls | &amp;#x0011; | &#x0011; |
| Device Controls, Symbols For | &amp;#x2411; | &#x2411; |
| Dharma, Wheel Of | &amp;#x2638; | &#x2638; |
| Diacritic, Finite Function | &amp;#x20E6; | &#x20E6; |
| Diacritical Marks For Symbols, Combining | &amp;#x20D0; | &#x20D0; |
| Diacritical Marks, Combining | &amp;#x0300; | &#x0300; |
| Diacritics For Greek | &amp;#x0342; | &#x0342; |
| Diacritics For Ipa | &amp;#x0346; | &#x0346; |
| Diacritics For Uralic Phonetic Alphabet | &amp;#x0350; | &#x0350; |
| Diacritics, Cjk | &amp;#x302A; | &#x302A; |
| Diacritics, Double | &amp;#x035C; | &#x035C; |
| Diacritics, Enclosing | &amp;#x20DD; | &#x20DD; |
| Diacritics, Medieval Superscript Letter | &amp;#x0363; | &#x0363; |
| Diacritics, Ordinary | &amp;#x0300; | &#x0300; |
| Diacritics, Overstruck | &amp;#x0334; | &#x0334; |
| Diacritics, Spacing Clones Of | &amp;#x02D8; | &#x02D8; |
| Diaeresis | &amp;#x00A8; | &#x00A8; |
| Diaeresis Below, Combining | &amp;#x0324; | &#x0324; |
| Diaeresis, Combining | &amp;#x0308; | &#x0308; |
| Diaeresis, Spacing | &amp;#x00A8; | &#x00A8; |
| Diagonal Ellipsis, Down Right | &amp;#x22F1; | &#x22F1; |
| Diagonal Ellipsis, Up Right | &amp;#x22F0; | &#x22F0; |
| Dialytika Tonos, Combining Greek | &amp;#x0344; | &#x0344; |
| Dialytika, Greek | &amp;#x0308; | &#x0308; |
| Diameter Sign | &amp;#x2300; | &#x2300; |
| Diamond Operator | &amp;#x22C4; | &#x22C4; |
| Diamond, Combining Enclosing | &amp;#x20DF; | &#x20DF; |
| Diamonds | &amp;#x25C6; | &#x25C6; |
| Diamonds And Lozenges | &amp;#x2B25; | &#x2B25; |
| Dice | &amp;#x2680; | &#x2680; |
| Dictionary And Map Symbols | &amp;#x2690; | &#x2690; |
| Dictionary Punctuation | &amp;#x2E1A; | &#x2E1A; |
| Diesis | &amp;#x2021; | &#x2021; |
| Difference Between | &amp;#x223C; | &#x223C; |
| Difference Between | &amp;#x224F; | &#x224F; |
| Difference Or Sum, Positive | &amp;#x2A24; | &#x2A24; |
| Difference, Backward | &amp;#x2207; | &#x2207; |
| Difference, Forward | &amp;#x2206; | &#x2206; |
| Difference, Sum Or Positive | &amp;#x2A26; | &#x2A26; |
| Difference, Symmetric | &amp;#x2206; | &#x2206; |
| Difference, Symmetric | &amp;#x2238; | &#x2238; |
| Difference, Symmetric | &amp;#x2296; | &#x2296; |
| Differential, Partial | &amp;#x2202; | &#x2202; |
| Digamma Inversum, Claudian | &amp;#x2132; | &#x2132; |
| Digit Zero, Circled | &amp;#x24EA; | &#x24EA; |
| Digits Minus Half, Tibetan | &amp;#x0F2A; | &#x0F2A; |
| Digits Symbols, Mathematical | &amp;#x1D7CE; | &#x1D7CE; |
| Digits, Arabic-Indic | &amp;#x0660; | &#x0660; |
| Digits, Ascii | &amp;#x0030; | &#x0030; |
| Digits, Balinese | &amp;#x1B50; | &#x1B50; |
| Digits, Bengali | &amp;#x09E6; | &#x09E6; |
| Digits, Bold | &amp;#x1D7CE; | &#x1D7CE; |
| Digits, Devanagari | &amp;#x0966; | &#x0966; |
| Digits, Dingbat Circled | &amp;#x2776; | &#x2776; |
| Digits, Double-Struck | &amp;#x1D7D8; | &#x1D7D8; |
| Digits, Eastern Arabic-Indic | &amp;#x06F0; | &#x06F0; |
| Digits, Ethiopic | &amp;#x1369; | &#x1369; |
| Digits, Gujarati | &amp;#x0AE6; | &#x0AE6; |
| Digits, Gurmukhi | &amp;#x0A66; | &#x0A66; |
| Digits, Kannada | &amp;#x0CE6; | &#x0CE6; |
| Digits, Kharoshthi | &amp;#x10A40; | &#x10A40; |
| Digits, Khmer | &amp;#x17E0; | &#x17E0; |
| Digits, Lao | &amp;#x0ED0; | &#x0ED0; |
| Digits, Limbu | &amp;#x1946; | &#x1946; |
| Digits, Malayalam | &amp;#x0D66; | &#x0D66; |
| Digits, Mongolian | &amp;#x1810; | &#x1810; |
| Digits, Monospace | &amp;#x1D7F6; | &#x1D7F6; |
| Digits, Myanmar | &amp;#x1040; | &#x1040; |
| Digits, New Tai Lue | &amp;#x19D0; | &#x19D0; |
| Digits, Oriya | &amp;#x0B66; | &#x0B66; |
| Digits, Osmanya | &amp;#x104A0; | &#x104A0; |
| Digits, Sans-Serif | &amp;#x1D7E2; | &#x1D7E2; |
| Digits, Sans-Serif Bold | &amp;#x1D7EC; | &#x1D7EC; |
| Digits, Subscript | &amp;#x2080; | &#x2080; |
| Digits, Superscript | &amp;#x2070; | &#x2070; |
| Digits, Tamil | &amp;#x0BE7; | &#x0BE7; |
| Digits, Telugu | &amp;#x0C66; | &#x0C66; |
| Digits, Thai | &amp;#x0E50; | &#x0E50; |
| Digits, Tibetan | &amp;#x0F20; | &#x0F20; |
| Digram Symbols, Yijing / I Ching Monogram And | &amp;#x268A; | &#x268A; |
| Digraphs Matching Serbian Cyrillic Letters, Croatian | &amp;#x01C4; | &#x01C4; |
| Digraphs, Phonetic | &amp;#x02A3; | &#x02A3; |
| Digraphs, Yiddish | &amp;#x05F0; | &#x05F0; |
| Dijkstra Choice | &amp;#x2AFE; | &#x2AFE; |
| Dijkstra Choice, N-Ary | &amp;#x2AFF; | &#x2AFF; |
| Dimension Origin | &amp;#x2331; | &#x2331; |
| Dingbat Arrows | &amp;#x2794; | &#x2794; |
| Dingbat Circled Digits | &amp;#x2776; | &#x2776; |
| Dingbats | &amp;#x2700; | &#x2700; |
| Dingbats Series 100, Itc Zapf | &amp;#x2700; | &#x2700; |
| Dingbats, Arrow | &amp;#x2794; | &#x2794; |
| Dingbats, Asterisk | &amp;#x2722; | &#x2722; |
| Dingbats, Cross | &amp;#x2719; | &#x2719; |
| Dingbats, Drop-Shadowed | &amp;#x274D; | &#x274D; |
| Dingbats, Hazard | &amp;#x2620; | &#x2620; |
| Dingbats, Heart | &amp;#x2763; | &#x2763; |
| Dingbats, Miscellaneous | &amp;#x2600; | &#x2600; |
| Dingbats, Music | &amp;#x2669; | &#x2669; |
| Dingbats, Pencil | &amp;#x270E; | &#x270E; |
| Dingbats, Pointing Index Finger | &amp;#x261A; | &#x261A; |
| Dingbats, Quotation Mark | &amp;#x275B; | &#x275B; |
| Dingbats, Scissors | &amp;#x2701; | &#x2701; |
| Dingbats, Snowflake | &amp;#x2744; | &#x2744; |
| Dingbats, Star | &amp;#x2726; | &#x2726; |
| Dingbats, Vertical Bar | &amp;#x2758; | &#x2758; |
| Dingbats, Warning | &amp;#x2620; | &#x2620; |
| Dingbats, Weather | &amp;#x2600; | &#x2600; |
| Dingbats, Zapf | &amp;#x2700; | &#x2700; |
| Direct Current Symbol Form Two | &amp;#x2393; | &#x2393; |
| Direct Product | &amp;#x2299; | &#x2299; |
| Direct Sum | &amp;#x2295; | &#x2295; |
| Directional Format Characters | &amp;#x202A; | &#x202A; |
| Directional Formatting, Pop | &amp;#x202C; | &#x202C; |
| Discontinuous Underline Symbol | &amp;#x2382; | &#x2382; |
| Discretionary Hyphen | &amp;#x00AD; | &#x00AD; |
| Disjunction | &amp;#x2228; | &#x2228; |
| Ditto Mark | &amp;#x3003; | &#x3003; |
| Divides | &amp;#x2223; | &#x2223; |
| Divination, Khmer Numeric Symbols For | &amp;#x17F0; | &#x17F0; |
| Division Sign | &amp;#x00F7; | &#x00F7; |
| Division Sign Operators, Multiplication And | &amp;#x2A2F; | &#x2A2F; |
| Division Sign, Circled | &amp;#x2A38; | &#x2A38; |
| Division Slash | &amp;#x2215; | &#x2215; |
| Division Slash, Circled | &amp;#x2298; | &#x2298; |
| Division Times | &amp;#x22C7; | &#x22C7; |
| Division, Long | &amp;#x27CC; | &#x27CC; |
| Divorce Symbol | &amp;#x26AE; | &#x26AE; |
| Does Not Contain As Member | &amp;#x220C; | &#x220C; |
| Does Not Divide | &amp;#x2224; | &#x2224; |
| Does Not Exist, There | &amp;#x2204; | &#x2204; |
| Does Not Yield | &amp;#x22A3; | &#x22A3; |
| Dollar Sign | &amp;#x0024; | &#x0024; |
| Domain Restriction | &amp;#x25C1; | &#x25C1; |
| Domino Tiles | &amp;#x1F030; | &#x1F030; |
| Dong Sign | &amp;#x20AB; | &#x20AB; |
| Dot | &amp;#x002E; | &#x002E; |
| Dot Above | &amp;#x02D9; | &#x02D9; |
| Dot Above Right, Combining | &amp;#x0358; | &#x0358; |
| Dot Above, Combining | &amp;#x0307; | &#x0307; |
| Dot Above, Double | &amp;#x0308; | &#x0308; |
| Dot Below, Combining | &amp;#x0323; | &#x0323; |
| Dot Below, Myanmar Sign | &amp;#x1037; | &#x1037; |
| Dot Leader, One | &amp;#x2024; | &#x2024; |
| Dot Leader, Three | &amp;#x2026; | &#x2026; |
| Dot Leader, Two | &amp;#x2025; | &#x2025; |
| Dot Minus | &amp;#x2238; | &#x2238; |
| Dot Operator | &amp;#x22C5; | &#x22C5; |
| Dot Operator, Circled | &amp;#x2299; | &#x2299; |
| Dot Operator, Squared | &amp;#x22A1; | &#x22A1; |
| Dot Plus | &amp;#x2214; | &#x2214; |
| Dot Punctuation, Five | &amp;#x2059; | &#x2059; |
| Dot Punctuation, Four | &amp;#x2058; | &#x2058; |
| Dot Punctuation, Three | &amp;#x2056; | &#x2056; |
| Dot Punctuation, Two | &amp;#x205A; | &#x205A; |
| Dot, Greek Middle | &amp;#x00B7; | &#x00B7; |
| Dot, Katakana Middle | &amp;#x30FB; | &#x30FB; |
| Dot, Latin Capital Letter I | &amp;#x0130; | &#x0130; |
| Dot, Middle | &amp;#x00B7; | &#x00B7; |
| Dot, Sesame | &amp;#xFE45; | &#xFE45; |
| Dot, Vertical Line With Middle | &amp;#x237F; | &#x237F; |
| Dot, White Sesame | &amp;#xFE46; | &#xFE46; |
| Dotless I, Latin Small Letter | &amp;#x0131; | &#x0131; |
| Dotless J With Stroke, Latin Small Letter | &amp;#x025F; | &#x025F; |
| Dotless J, Latin Small Letter | &amp;#x0237; | &#x0237; |
| Dotless Mathematical Symbols | &amp;#x1D6A4; | &#x1D6A4; |
| Dots Above, Combining Four | &amp;#x20DC; | &#x20DC; |
| Dots Above, Combining Three | &amp;#x20DB; | &#x20DB; |
| Dots, Mongolian Four | &amp;#x1805; | &#x1805; |
| Dots, Vertical Four | &amp;#x205E; | &#x205E; |
| Dotted Circle | &amp;#x25CC; | &#x25CC; |
| Dotted Cross | &amp;#x205C; | &#x205C; |
| Dotted Fence | &amp;#x2999; | &#x2999; |
| Dotted Mathematical Operators | &amp;#x2234; | &#x2234; |
| Double Acute Accent | &amp;#x02DD; | &#x02DD; |
| Double Acute Accent, Combining | &amp;#x030B; | &#x030B; |
| Double Angle Bracket, Left | &amp;#x300A; | &#x300A; |
| Double Angle Bracket, Mathematical Left | &amp;#x27EA; | &#x27EA; |
| Double Angle Bracket, Mathematical Right | &amp;#x27EB; | &#x27EB; |
| Double Angle Bracket, Right | &amp;#x300B; | &#x300B; |
| Double Angle Quotation Mark, Left-Pointing | &amp;#x00AB; | &#x00AB; |
| Double Angle Quotation Mark, Right-Pointing | &amp;#x00BB; | &#x00BB; |
| Double Apostrophe, Modifier Letter | &amp;#x02EE; | &#x02EE; |
| Double Arch Below, Combining Inverted | &amp;#x032B; | &#x032B; |
| Double Arrows | &amp;#x21CD; | &#x21CD; |
| Double Breve Below, Combining | &amp;#x035C; | &#x035C; |
| Double Breve, Combining | &amp;#x035D; | &#x035D; |
| Double Circled Numbers | &amp;#x24F5; | &#x24F5; |
| Double Comma Quotation Mark | &amp;#x201D; | &#x201D; |
| Double Comma Quotation Mark, Low | &amp;#x201E; | &#x201E; |
| Double Dagger | &amp;#x2021; | &#x2021; |
| Double Danda, Devanagari | &amp;#x0965; | &#x0965; |
| Double Derivative | &amp;#x0308; | &#x0308; |
| Double Diacritics | &amp;#x035C; | &#x035C; |
| Double Dot Above | &amp;#x0308; | &#x0308; |
| Double Exclamation Mark | &amp;#x203C; | &#x203C; |
| Double Grave Accent, Combining | &amp;#x030F; | &#x030F; |
| Double High-Reversed-9 Quotation Mark | &amp;#x201F; | &#x201F; |
| Double Hyphen, Katakana-Hiragana | &amp;#x30A0; | &#x30A0; |
| Double Integral | &amp;#x222C; | &#x222C; |
| Double Intersection | &amp;#x22D2; | &#x22D2; |
| Double Inverted Breve, Combining | &amp;#x0361; | &#x0361; |
| Double Logical And | &amp;#x2A53; | &#x2A53; |
| Double Logical Or | &amp;#x2A54; | &#x2A54; |
| Double Low Line | &amp;#x2017; | &#x2017; |
| Double Low Line, Combining | &amp;#x0333; | &#x0333; |
| Double Low-9 Quotation Mark | &amp;#x201E; | &#x201E; |
| Double Macron Below, Combining | &amp;#x035F; | &#x035F; |
| Double Macron, Combining | &amp;#x035E; | &#x035E; |
| Double Operators | &amp;#x22D0; | &#x22D0; |
| Double Overline, Combining | &amp;#x033F; | &#x033F; |
| Double Pipe | &amp;#x01C1; | &#x01C1; |
| Double Plus | &amp;#x29FA; | &#x29FA; |
| Double Precedes | &amp;#x2ABB; | &#x2ABB; |
| Double Prime | &amp;#x2033; | &#x2033; |
| Double Prime Quotation Mark | &amp;#x301E; | &#x301E; |
| Double Prime Quotation Mark, Low | &amp;#x301F; | &#x301F; |
| Double Prime Quotation Mark, Reversed | &amp;#x301D; | &#x301D; |
| Double Prime, Modifier Letter | &amp;#x02BA; | &#x02BA; |
| Double Prime, Reversed | &amp;#x2036; | &#x2036; |
| Double Punctuation For Vertical Text | &amp;#x2047; | &#x2047; |
| Double Punctuation, Philippine | &amp;#x1736; | &#x1736; |
| Double Question Mark | &amp;#x2047; | &#x2047; |
| Double Quotation Mark, Left | &amp;#x201C; | &#x201C; |
| Double Quotation Mark, Right | &amp;#x201D; | &#x201D; |
| Double Reversed Comma Quotation Mark | &amp;#x201F; | &#x201F; |
| Double Rightwards Arrow Below, Combining | &amp;#x0362; | &#x0362; |
| Double Ring Below, Combining | &amp;#x035A; | &#x035A; |
| Double Slash Overlay, Long | &amp;#x20EB; | &#x20EB; |
| Double Solidus Operator | &amp;#x2AFD; | &#x2AFD; |
| Double Solidus Overlay, Combining Long | &amp;#x20EB; | &#x20EB; |
| Double Subset | &amp;#x22D0; | &#x22D0; |
| Double Succeeds | &amp;#x2ABC; | &#x2ABC; |
| Double Superset | &amp;#x22D1; | &#x22D1; |
| Double Tilde, Combining | &amp;#x0360; | &#x0360; |
| Double Turned Comma Quotation Mark | &amp;#x201C; | &#x201C; |
| Double Underline | &amp;#x0333; | &#x0333; |
| Double Underscore | &amp;#x0333; | &#x0333; |
| Double Underscore, Spacing | &amp;#x2017; | &#x2017; |
| Double Union | &amp;#x22D3; | &#x22D3; |
| Double Vertical Line | &amp;#x2016; | &#x2016; |
| Double Vertical Line Above, Combining | &amp;#x030E; | &#x030E; |
| Double Vertical Line Below, Combining | &amp;#x0348; | &#x0348; |
| Double Vertical Stroke Overlay, Combining | &amp;#x20E6; | &#x20E6; |
| Double Wavy Overline | &amp;#xFE4C; | &#xFE4C; |
| Double-Barred Pipe | &amp;#x01C2; | &#x01C2; |
| Double-Struck Digits | &amp;#x1D7D8; | &#x1D7D8; |
| Double-Struck Greek Letters | &amp;#x213C; | &#x213C; |
| Double-Struck Greek Letters | &amp;#x213D; | &#x213D; |
| Double-Struck Italic Mathematical Symbols | &amp;#x2145; | &#x2145; |
| Double-Struck Mathematical Symbols | &amp;#x1D538; | &#x1D538; |
| Down Arrowhead | &amp;#x2304; | &#x2304; |
| Down Pointing Index, White | &amp;#x261F; | &#x261F; |
| Down Right Diagonal Ellipsis | &amp;#x22F1; | &#x22F1; |
| Down Tack | &amp;#x22A4; | &#x22A4; |
| Down Tack Below, Combining | &amp;#x031E; | &#x031E; |
| Down, Page | &amp;#x21DF; | &#x21DF; |
| Downstile, Apl | &amp;#x230A; | &#x230A; |
| Downwards Arrow | &amp;#x2193; | &#x2193; |
| Dprk Compatibility Ideographs | &amp;#xFA70; | &#xFA70; |
| Drachma Sign | &amp;#x20AF; | &#x20AF; |
| Drafting Symbols | &amp;#x232D; | &#x232D; |
| Dram | &amp;#x0292; | &#x0292; |
| Draughts And Checkers, Symbols For | &amp;#x26C0; | &#x26C0; |
| Drop | &amp;#x264F; | &#x264F; |
| Drop-Shadowed Dingbats | &amp;#x274D; | &#x274D; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## E

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| E With Acute, Latin Capital Letter | &amp;#x00C9; | &#x00C9; |
| E With Acute, Latin Small Letter | &amp;#x00E9; | &#x00E9; |
| E With Breve, Latin Small Letter | &amp;#x0115; | &#x0115; |
| E With Caron, Latin Small Letter | &amp;#x011B; | &#x011B; |
| E With Cedilla, Latin Small Letter | &amp;#x0229; | &#x0229; |
| E With Circumflex Below, Latin Small Letter | &amp;#x1E19; | &#x1E19; |
| E With Circumflex, Latin Capital Letter | &amp;#x00CA; | &#x00CA; |
| E With Circumflex, Latin Small Letter | &amp;#x00EA; | &#x00EA; |
| E With Diaeresis, Latin Capital Letter | &amp;#x00CB; | &#x00CB; |
| E With Diaeresis, Latin Small Letter | &amp;#x00EB; | &#x00EB; |
| E With Dot Above, Latin Small Letter | &amp;#x0117; | &#x0117; |
| E With Dot Below, Latin Small Letter | &amp;#x1EB9; | &#x1EB9; |
| E With Double Grave, Latin Small Letter | &amp;#x0205; | &#x0205; |
| E With Grave, Latin Capital Letter | &amp;#x00C8; | &#x00C8; |
| E With Grave, Latin Small Letter | &amp;#x00E8; | &#x00E8; |
| E With Hook Above, Latin Small Letter | &amp;#x1EBB; | &#x1EBB; |
| E With Hook, Latin Small Letter Reversed Open | &amp;#x025D; | &#x025D; |
| E With Inverted Breve, Latin Small Letter | &amp;#x0207; | &#x0207; |
| E With Macron, Latin Small Letter | &amp;#x0113; | &#x0113; |
| E With Ogonek, Latin Small Letter | &amp;#x0119; | &#x0119; |
| E With Stroke, Latin Capital Letter | &amp;#x0246; | &#x0246; |
| E With Stroke, Latin Small Letter | &amp;#x0247; | &#x0247; |
| E With Tilde Below, Latin Small Letter | &amp;#x1E1B; | &#x1E1B; |
| E With Tilde, Latin Small Letter | &amp;#x1EBD; | &#x1EBD; |
| E, Combining Latin Small Letter | &amp;#x0364; | &#x0364; |
| E, Double-Struck Italic Small | &amp;#x2147; | &#x2147; |
| E, Latin Capital Letter Open | &amp;#x0190; | &#x0190; |
| E, Latin Capital Letter Reversed | &amp;#x018E; | &#x018E; |
| E, Latin Capital Letter Turned | &amp;#x018E; | &#x018E; |
| E, Latin Letter Small Capital | &amp;#x1D07; | &#x1D07; |
| E, Latin Small Letter Closed Open | &amp;#x029A; | &#x029A; |
| E, Latin Small Letter Closed Reversed Open | &amp;#x025E; | &#x025E; |
| E, Latin Small Letter O | &amp;#x0153; | &#x0153; |
| E, Latin Small Letter Open | &amp;#x025B; | &#x025B; |
| E, Latin Small Letter Reversed | &amp;#x0258; | &#x0258; |
| E, Latin Small Letter Reversed Open | &amp;#x025C; | &#x025C; |
| E, Latin Small Letter Turned | &amp;#x01DD; | &#x01DD; |
| E, Latin Small Letter Turned Open | &amp;#x1D08; | &#x1D08; |
| E, Script Capital | &amp;#x2130; | &#x2130; |
| E, Script Small | &amp;#x212F; | &#x212F; |
| Earth | &amp;#x2641; | &#x2641; |
| Earth Ground | &amp;#x23DA; | &#x23DA; |
| East Syriac Cross | &amp;#x2671; | &#x2671; |
| Eastern Arabic-Indic Digits | &amp;#x06F0; | &#x06F0; |
| Editorial Symbols, New Testament | &amp;#x2E00; | &#x2E00; |
| Egressive Airflow | &amp;#x2191; | &#x2191; |
| Eighth Note | &amp;#x266A; | &#x266A; |
| Eighth Notes, Beamed | &amp;#x266B; | &#x266B; |
| Eighths, Fractions | &amp;#x215B; | &#x215B; |
| Eject Media | &amp;#x23CF; | &#x23CF; |
| Ek Onkar, Gurmukhi | &amp;#x0A74; | &#x0A74; |
| El Salvadorian Currency | &amp;#x20A1; | &#x20A1; |
| Electric Arrow | &amp;#x2301; | &#x2301; |
| Electrical Intersection | &amp;#x23E7; | &#x23E7; |
| Electrolysis | &amp;#x21AF; | &#x21AF; |
| Electromotive Force | &amp;#x2130; | &#x2130; |
| Electrotechnical Symbols | &amp;#x238D; | &#x238D; |
| Element Of | &amp;#x2208; | &#x2208; |
| Element Of, Not An | &amp;#x2209; | &#x2209; |
| Element Of, Small | &amp;#x220A; | &#x220A; |
| Element, Unique | &amp;#x2129; | &#x2129; |
| Ellipses | &amp;#x2B2C; | &#x2B2C; |
| Ellipsis, Down Right Diagonal | &amp;#x22F1; | &#x22F1; |
| Ellipsis, Horizontal | &amp;#x2026; | &#x2026; |
| Ellipsis, Lao | &amp;#x0EAF; | &#x0EAF; |
| Ellipsis, Midline Horizontal | &amp;#x22EF; | &#x22EF; |
| Ellipsis, Mongolian | &amp;#x1801; | &#x1801; |
| Ellipsis, Up Right Diagonal | &amp;#x22F0; | &#x22F0; |
| Ellipsis, Vertical | &amp;#x22EE; | &#x22EE; |
| Elliptic Function, Weierstrass | &amp;#x2118; | &#x2118; |
| Em Dash | &amp;#x2014; | &#x2014; |
| Em Quad | &amp;#x2001; | &#x2001; |
| Em Space | &amp;#x2003; | &#x2003; |
| Embedding, Left-To-Right | &amp;#x202A; | &#x202A; |
| Embedding, Right-To-Left | &amp;#x202B; | &#x202B; |
| Emf | &amp;#x2130; | &#x2130; |
| Emphasis Mark, Armenian | &amp;#x055B; | &#x055B; |
| Emphasis Marks, Sidelining | &amp;#xFE45; | &#xFE45; |
| Emphasis Symbol | &amp;#x2383; | &#x2383; |
| Empty Set | &amp;#x2205; | &#x2205; |
| Empty Sets | &amp;#x29B0; | &#x29B0; |
| En Dash | &amp;#x2013; | &#x2013; |
| En Quad | &amp;#x2000; | &#x2000; |
| En Space | &amp;#x2002; | &#x2002; |
| Enclosed Alphanumerics | &amp;#x2460; | &#x2460; |
| Enclosed Cjk Letters And Months | &amp;#x3200; | &#x3200; |
| Enclosed Mathematical Operators | &amp;#x2295; | &#x2295; |
| Enclosing Circle Backslash, Combining | &amp;#x20E0; | &#x20E0; |
| Enclosing Circle, Combining | &amp;#x20DD; | &#x20DD; |
| Enclosing Diacritics | &amp;#x20DD; | &#x20DD; |
| Enclosing Diamond, Combining | &amp;#x20DF; | &#x20DF; |
| Enclosing Keycap, Combining | &amp;#x20E3; | &#x20E3; |
| Enclosing Screen, Combining | &amp;#x20E2; | &#x20E2; |
| Enclosing Square, Combining | &amp;#x20DE; | &#x20DE; |
| Enclosing Upward Pointing Triangle, Combining | &amp;#x20E4; | &#x20E4; |
| End | &amp;#x21F2; | &#x21F2; |
| End Of Guarded Area | &amp;#x0097; | &#x0097; |
| End Of Line | &amp;#x000A; | &#x000A; |
| End Of Medium | &amp;#x0019; | &#x0019; |
| End Of Medium, Symbol For | &amp;#x237F; | &#x237F; |
| End Of Medium, Symbol For | &amp;#x2419; | &#x2419; |
| End Of Proof | &amp;#x220E; | &#x220E; |
| End Of Selected Area | &amp;#x0087; | &#x0087; |
| End Of Text | &amp;#x0003; | &#x0003; |
| End Of Text, Symbol For | &amp;#x2403; | &#x2403; |
| End Of Transmission | &amp;#x0004; | &#x0004; |
| End Of Transmission Block | &amp;#x0017; | &#x0017; |
| End Of Transmission Block, Symbol For | &amp;#x2417; | &#x2417; |
| End Of Transmission Symbol | &amp;#x2301; | &#x2301; |
| End Of Transmission, Symbol For | &amp;#x2404; | &#x2404; |
| Eng, Latin Small Letter | &amp;#x014B; | &#x014B; |
| Enn, Tamil | &amp;#x0BFA; | &#x0BFA; |
| Enotikon, Greek | &amp;#x203F; | &#x203F; |
| Enquiry | &amp;#x0005; | &#x0005; |
| Enquiry, Symbol For | &amp;#x2405; | &#x2405; |
| Enter Key | &amp;#x2324; | &#x2324; |
| Enter Symbol | &amp;#x2386; | &#x2386; |
| Entity &Amp;Iinfin;, Isotech | &amp;#x29DC; | &#x29DC; |
| Envelope | &amp;#x2709; | &#x2709; |
| Eol | &amp;#x000A; | &#x000A; |
| Epidaurean Acrophonic Symbol Three | &amp;#x205D; | &#x205D; |
| Epsilon Symbol, Greek Lunate | &amp;#x03F5; | &#x03F5; |
| Epsilon Symbol, Greek Reversed Lunate | &amp;#x03F6; | &#x03F6; |
| Epsilon, Latin Capital Letter | &amp;#x0190; | &#x0190; |
| Epsilon, Latin Small Letter | &amp;#x025B; | &#x025B; |
| Epsilon, Latin Small Letter Closed | &amp;#x029A; | &#x029A; |
| Epsilon, Latin Small Letter Closed Reversed | &amp;#x025E; | &#x025E; |
| Epsilon, Reversed Straight | &amp;#x03F6; | &#x03F6; |
| Epsilon, Reversed Straight | &amp;#x220D; | &#x220D; |
| Epsilon, Straight | &amp;#x03F5; | &#x03F5; |
| Equal To Above, Combining Almost | &amp;#x034C; | &#x034C; |
| Equal To By Definition | &amp;#x225C; | &#x225C; |
| Equal To By Definition | &amp;#x225D; | &#x225D; |
| Equal To, All | &amp;#x224C; | &#x224C; |
| Equal To, Almost | &amp;#x2248; | &#x2248; |
| Equal To, Approximately | &amp;#x2245; | &#x2245; |
| Equal To, Approximately | &amp;#x2257; | &#x2257; |
| Equal To, Asymptotically | &amp;#x2243; | &#x2243; |
| Equal To, Delta | &amp;#x225C; | &#x225C; |
| Equal To, Geometrically | &amp;#x2251; | &#x2251; |
| Equal To, Greater-Than Or | &amp;#x2265; | &#x2265; |
| Equal To, Less-Than Or | &amp;#x2264; | &#x2264; |
| Equal To, Not | &amp;#x2260; | &#x2260; |
| Equal To, Questioned | &amp;#x225F; | &#x225F; |
| Equal To, Ring | &amp;#x2257; | &#x2257; |
| Equal To, Ring In | &amp;#x2256; | &#x2256; |
| Equality And Inequality Signs | &amp;#x2243; | &#x2243; |
| Equality And Inequality Signs | &amp;#x22D5; | &#x22D5; |
| Equals Colon | &amp;#x2255; | &#x2255; |
| Equals Sign | &amp;#x003D; | &#x003D; |
| Equals Sign Below, Combining | &amp;#x0347; | &#x0347; |
| Equals, Circled | &amp;#x229C; | &#x229C; |
| Equals, Colon | &amp;#x2254; | &#x2254; |
| Equals, Nearly | &amp;#x2252; | &#x2252; |
| Equals, Reversed Tilde | &amp;#x22CD; | &#x22CD; |
| Equals, Star | &amp;#x225B; | &#x225B; |
| Equiangular | &amp;#x225C; | &#x225C; |
| Equiangular To | &amp;#x225A; | &#x225A; |
| Equivalent To | &amp;#x224D; | &#x224D; |
| Equivalent To, Geometrically | &amp;#x224E; | &#x224E; |
| Equivalent To, Strictly | &amp;#x2263; | &#x2263; |
| Equivalent, Tautological | &amp;#x29E6; | &#x29E6; |
| Era Names, Japanese | &amp;#x337B; | &#x337B; |
| Erase To The Left | &amp;#x232B; | &#x232B; |
| Erase To The Right | &amp;#x2326; | &#x2326; |
| Error | &amp;#x212F; | &#x212F; |
| Error Bar Symbols | &amp;#x29EE; | &#x29EE; |
| Escape | &amp;#x001B; | &#x001B; |
| Escape | &amp;#x238B; | &#x238B; |
| Escape, Data Link | &amp;#x0010; | &#x0010; |
| Escape, Symbol For | &amp;#x241B; | &#x241B; |
| Escape, Symbol For Data Link | &amp;#x2410; | &#x2410; |
| Escudo | &amp;#x0024; | &#x0024; |
| Esh Loop, Latin Letter Reversed | &amp;#x01AA; | &#x01AA; |
| Esh, Latin Capital Letter | &amp;#x01A9; | &#x01A9; |
| Esh, Latin Small Letter | &amp;#x0283; | &#x0283; |
| Esh, Latin Small Letter Squat Reversed | &amp;#x0285; | &#x0285; |
| Estimated Symbol | &amp;#x212E; | &#x212E; |
| Estimates | &amp;#x2259; | &#x2259; |
| Eszett | &amp;#x00DF; | &#x00DF; |
| Et, Tironian Sign | &amp;#x204A; | &#x204A; |
| Eth, Latin Capital Letter | &amp;#x00D0; | &#x00D0; |
| Eth, Latin Letter Small Capital | &amp;#x1D06; | &#x1D06; |
| Eth, Latin Small Letter | &amp;#x00F0; | &#x00F0; |
| Ethel | &amp;#x0153; | &#x0153; |
| Ethiopic Colon | &amp;#x1365; | &#x1365; |
| Ethiopic Comma | &amp;#x1363; | &#x1363; |
| Ethiopic Digits | &amp;#x1369; | &#x1369; |
| Ethiopic Extended | &amp;#x2D80; | &#x2D80; |
| Ethiopic Full Stop | &amp;#x1362; | &#x1362; |
| Ethiopic Numbers | &amp;#x1369; | &#x1369; |
| Ethiopic Paragraph Separator | &amp;#x1368; | &#x1368; |
| Ethiopic Preface Colon | &amp;#x1366; | &#x1366; |
| Ethiopic Punctuation | &amp;#x1361; | &#x1361; |
| Ethiopic Question Mark | &amp;#x1367; | &#x1367; |
| Ethiopic Semicolon | &amp;#x1364; | &#x1364; |
| Ethiopic Supplement | &amp;#x1380; | &#x1380; |
| Ethiopic Syllables | &amp;#x1200; | &#x1200; |
| Ethiopic Wordspace | &amp;#x1361; | &#x1361; |
| Euler Constant | &amp;#x2107; | &#x2107; |
| Euro European Currency | &amp;#x20AC; | &#x20AC; |
| Euro Sign | &amp;#x20AC; | &#x20AC; |
| European Latin | &amp;#x0100; | &#x0100; |
| European Paragraph Sign | &amp;#x00A7; | &#x00A7; |
| European Section Sign | &amp;#x00B6; | &#x00B6; |
| Excess | &amp;#x2239; | &#x2239; |
| Exclamation Mark | &amp;#x0021; | &#x0021; |
| Exclamation Mark Ornament, Heavy | &amp;#x2762; | &#x2762; |
| Exclamation Mark, Armenian | &amp;#x055C; | &#x055C; |
| Exclamation Mark, Double | &amp;#x203C; | &#x203C; |
| Exclamation Mark, Inverted | &amp;#x00A1; | &#x00A1; |
| Exclamation Mark, Latin Letter | &amp;#x01C3; | &#x01C3; |
| Exclamation Mark, Limbu | &amp;#x1944; | &#x1944; |
| Exclamation Mark, Question | &amp;#x2048; | &#x2048; |
| Exclamation Question Mark | &amp;#x2049; | &#x2049; |
| Exist, There Does Not | &amp;#x2204; | &#x2204; |
| Existential Quantifier | &amp;#x2203; | &#x2203; |
| Exists, There | &amp;#x2203; | &#x2203; |
| Exponent, Natural | &amp;#x212F; | &#x212F; |
| Extensions For Ainu, Katakana | &amp;#x31F0; | &#x31F0; |
| Ezh Reversed, Latin Small Letter | &amp;#x01B9; | &#x01B9; |
| Ezh With Caron, Latin Small Letter | &amp;#x01EF; | &#x01EF; |
| Ezh, Latin Capital Letter | &amp;#x01B7; | &#x01B7; |
| Ezh, Latin Letter Small Capital | &amp;#x1D23; | &#x1D23; |
| Ezh, Latin Small Letter | &amp;#x0292; | &#x0292; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## F

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| F With Dot Above, Latin Small Letter | &amp;#x1E1F; | &#x1E1F; |
| F With Hook, Latin Small Letter | &amp;#x0192; | &#x0192; |
| F, Latin Small Letter Script | &amp;#x0192; | &#x0192; |
| F, Script Capital | &amp;#x2131; | &#x2131; |
| F, Turned Capital | &amp;#x2132; | &#x2132; |
| F, Turned Small | &amp;#x214E; | &#x214E; |
| Face, Black Smiling | &amp;#x263B; | &#x263B; |
| Face, Postal Mark | &amp;#x3020; | &#x3020; |
| Face, White Frowning | &amp;#x2639; | &#x2639; |
| Face, White Smiling | &amp;#x263A; | &#x263A; |
| Facsimile Sign | &amp;#x213B; | &#x213B; |
| Factorial | &amp;#x0021; | &#x0021; |
| Fahrenheit, Degree | &amp;#x2109; | &#x2109; |
| Fast Cursor Down | &amp;#x21A1; | &#x21A1; |
| Fast Cursor Left | &amp;#x219E; | &#x219E; |
| Fast Cursor Right | &amp;#x21A0; | &#x21A0; |
| Fast Cursor Up | &amp;#x219F; | &#x219F; |
| Feet | &amp;#x2032; | &#x2032; |
| Female Sign | &amp;#x2640; | &#x2640; |
| Feminine Ordinal Indicator | &amp;#x00AA; | &#x00AA; |
| Fence, Dotted | &amp;#x2999; | &#x2999; |
| Fences | &amp;#x2999; | &#x2999; |
| Fences, Wiggly | &amp;#x29D8; | &#x29D8; |
| Fermata, Combining | &amp;#x0352; | &#x0352; |
| Fifths, Fractions | &amp;#x2155; | &#x2155; |
| Figure Dash | &amp;#x2012; | &#x2012; |
| Figure Space | &amp;#x2007; | &#x2007; |
| File Separator | &amp;#x001C; | &#x001C; |
| File Separator, Symbol For | &amp;#x241C; | &#x241C; |
| Fill Space, Ideographic Half | &amp;#x303F; | &#x303F; |
| Filler, Hangul | &amp;#x3164; | &#x3164; |
| Finger Dingbats, Pointing Index | &amp;#x261A; | &#x261A; |
| Finite Function | &amp;#x21FB; | &#x21FB; |
| Finite Function Diacritic | &amp;#x20E6; | &#x20E6; |
| Finite Injection | &amp;#x2915; | &#x2915; |
| Finite Relation | &amp;#x21FC; | &#x21FC; |
| Finite Surjection | &amp;#x2901; | &#x2901; |
| Finite Surjective Injection | &amp;#x2918; | &#x2918; |
| First Quarter Moon | &amp;#x263D; | &#x263D; |
| Fish Tails | &amp;#x297C; | &#x297C; |
| Fisheye | &amp;#x25C9; | &#x25C9; |
| Fist | &amp;#x261E; | &#x261E; |
| Five Dot Punctuation | &amp;#x2059; | &#x2059; |
| Flag, Black | &amp;#x2691; | &#x2691; |
| Flag, White | &amp;#x2690; | &#x2690; |
| Flat Sign, Music | &amp;#x266D; | &#x266D; |
| Flatness | &amp;#x23E5; | &#x23E5; |
| Fleur-De-Lis | &amp;#x269C; | &#x269C; |
| Floor, Left | &amp;#x230A; | &#x230A; |
| Floor, Right | &amp;#x230B; | &#x230B; |
| Floral Heart Bullet, Reversed Rotated | &amp;#x2619; | &#x2619; |
| Florin Currency Symbol | &amp;#x0192; | &#x0192; |
| Folder | &amp;#x0192; | &#x0192; |
| Fongman, Thai Character | &amp;#x0E4F; | &#x0E4F; |
| For All | &amp;#x2200; | &#x2200; |
| Forces | &amp;#x22A9; | &#x22A9; |
| Forfeda Supplement, Ogham | &amp;#x1695; | &#x1695; |
| Forks | &amp;#x2AD9; | &#x2AD9; |
| Form And Chart Components | &amp;#x2500; | &#x2500; |
| Form Feed | &amp;#x000C; | &#x000C; |
| Form Feed | &amp;#x21A1; | &#x21A1; |
| Form Feed, Symbol For | &amp;#x240C; | &#x240C; |
| Format Characters | &amp;#x200C; | &#x200C; |
| Format Characters, Directional | &amp;#x202A; | &#x202A; |
| Format Controls, Mongolian | &amp;#x180B; | &#x180B; |
| Formatting, Pop Directional | &amp;#x202C; | &#x202C; |
| Forward Arrow Indicator | &amp;#x25BB; | &#x25BB; |
| Forward Difference | &amp;#x2206; | &#x2206; |
| Four Dot Mark | &amp;#x205B; | &#x205B; |
| Four Dot Punctuation | &amp;#x2058; | &#x2058; |
| Four Dots Above, Combining | &amp;#x20DC; | &#x20DC; |
| Four Dots, Mongolian | &amp;#x1805; | &#x1805; |
| Four Dots, Vertical | &amp;#x205E; | &#x205E; |
| Four-Per-Em Space | &amp;#x2005; | &#x2005; |
| Fourier Transform | &amp;#x2131; | &#x2131; |
| Fourth Derivative | &amp;#x20DC; | &#x20DC; |
| Fourth Root | &amp;#x221C; | &#x221C; |
| Fourth Tone, Mandarin Chinese | &amp;#x02CB; | &#x02CB; |
| Fourths, Fractions | &amp;#x00BC; | &#x00BC; |
| Fraction Numerator One | &amp;#x215F; | &#x215F; |
| Fraction One Half, Vulgar | &amp;#x00BD; | &#x00BD; |
| Fraction One Quarter, Vulgar | &amp;#x00BC; | &#x00BC; |
| Fraction Slash | &amp;#x2044; | &#x2044; |
| Fraction Three Quarters, Vulgar | &amp;#x00BE; | &#x00BE; |
| Fractions Eighths | &amp;#x215B; | &#x215B; |
| Fractions Fifths | &amp;#x2155; | &#x2155; |
| Fractions Fourths | &amp;#x00BC; | &#x00BC; |
| Fractions Quarters | &amp;#x00BC; | &#x00BC; |
| Fractions Sixths | &amp;#x2159; | &#x2159; |
| Fractions Thirds | &amp;#x2153; | &#x2153; |
| Fractions, Vulgar | &amp;#x2153; | &#x2153; |
| Fraktur Mathematical Symbols | &amp;#x1D504; | &#x1D504; |
| Fraktur Mathematical Symbols, Bold | &amp;#x1D56C; | &#x1D56C; |
| Framus, White | &amp;#x29D6; | &#x29D6; |
| Franc Sign, French | &amp;#x20A3; | &#x20A3; |
| Fricative, Latin Letter Pharyngeal Voiced | &amp;#x0295; | &#x0295; |
| Frown | &amp;#x2322; | &#x2322; |
| Frowning Face, White | &amp;#x2639; | &#x2639; |
| Full Block | &amp;#x2588; | &#x2588; |
| Full Stop | &amp;#x002E; | &#x002E; |
| Full Stop, Arabic | &amp;#x06D4; | &#x06D4; |
| Full Stop, Armenian | &amp;#x0589; | &#x0589; |
| Full Stop, Canadian Syllabics | &amp;#x166E; | &#x166E; |
| Full Stop, Ethiopic | &amp;#x1362; | &#x1362; |
| Full Stop, Georgian | &amp;#x0589; | &#x0589; |
| Full Stop, Ideographic | &amp;#x3002; | &#x3002; |
| Full Stop, Mongolian | &amp;#x1803; | &#x1803; |
| Full Stop, Mongolian Manchu | &amp;#x1809; | &#x1809; |
| Fullwidth Ascii Variants | &amp;#xFF01; | &#xFF01; |
| Fullwidth Forms, Halfwidth And | &amp;#xFF00; | &#xFF00; |
| Fullwidth Symbol Variants | &amp;#xFFE0; | &#xFFE0; |
| Function Application | &amp;#x2061; | &#x2061; |
| Function Symbol | &amp;#x0192; | &#x0192; |
| Function, Bernoulli | &amp;#x212C; | &#x212C; |
| Function, Composite | &amp;#x2218; | &#x2218; |
| Function, Finite | &amp;#x21FB; | &#x21FB; |
| Function, Gamma | &amp;#x0393; | &#x0393; |
| Function, Partial | &amp;#x21F8; | &#x21F8; |
| Function, Total | &amp;#x2192; | &#x2192; |
| Function, Weierstrass Elliptic | &amp;#x2118; | &#x2118; |
| Functional Symbols, Apl | &amp;#x2336; | &#x2336; |
| Funeral Urn | &amp;#x26B1; | &#x26B1; |
| Fuse | &amp;#x23DB; | &#x23DB; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## G

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| G With Acute, Latin Small Letter | &amp;#x01F5; | &#x01F5; |
| G With Breve, Latin Small Letter | &amp;#x011F; | &#x011F; |
| G With Caron, Latin Small Letter | &amp;#x01E7; | &#x01E7; |
| G With Cedilla, Latin Small Letter | &amp;#x0123; | &#x0123; |
| G With Circumflex, Latin Small Letter | &amp;#x011D; | &#x011D; |
| G With Dot Above, Latin Small Letter | &amp;#x0121; | &#x0121; |
| G With Hook, Latin Capital Letter | &amp;#x0193; | &#x0193; |
| G With Hook, Latin Letter Small Capital | &amp;#x029B; | &#x029B; |
| G With Hook, Latin Small Letter | &amp;#x0260; | &#x0260; |
| G With Macron, Latin Small Letter | &amp;#x1E21; | &#x1E21; |
| G With Stroke, Latin Small Letter | &amp;#x01E5; | &#x01E5; |
| G, Latin Letter Small Capital | &amp;#x0262; | &#x0262; |
| G, Latin Small Letter Script | &amp;#x0261; | &#x0261; |
| G, Script Small | &amp;#x210A; | &#x210A; |
| G, Turned Sans-Serif Capital | &amp;#x2141; | &#x2141; |
| Game | &amp;#x2141; | &#x2141; |
| Gamma Function | &amp;#x0393; | &#x0393; |
| Gamma, Double-Struck Capital | &amp;#x213E; | &#x213E; |
| Gamma, Double-Struck Small | &amp;#x213D; | &#x213D; |
| Gamma, Latin Capital Letter | &amp;#x0194; | &#x0194; |
| Gamma, Latin Small Letter | &amp;#x0263; | &#x0263; |
| Gamma, Latin Small Letter Baby | &amp;#x0264; | &#x0264; |
| Gamma, Modifier Letter Small | &amp;#x02E0; | &#x02E0; |
| Gear | &amp;#x2699; | &#x2699; |
| Gemini | &amp;#x264A; | &#x264A; |
| Gender Symbols | &amp;#x26A2; | &#x26A2; |
| Genealogical Symbols | &amp;#x26AD; | &#x26AD; |
| General Punctuation | &amp;#x2000; | &#x2000; |
| General Scripts Area | &amp;#x0000; | &#x0000; |
| General Scripts Area, Supplementary | &amp;#x10000; | &#x10000; |
| Generalized Intersection | &amp;#x22C2; | &#x22C2; |
| Generalized Union | &amp;#x22C3; | &#x22C3; |
| Geometric Proportion | &amp;#x223A; | &#x223A; |
| Geometric Shapes | &amp;#x25A0; | &#x25A0; |
| Geometrically Equal To | &amp;#x2251; | &#x2251; |
| Geometrically Equivalent To | &amp;#x224E; | &#x224E; |
| Georgian | &amp;#x10A0; | &#x10A0; |
| Georgian Alphabet | &amp;#x10D0; | &#x10D0; |
| Georgian Capital Letters | &amp;#x10A0; | &#x10A0; |
| Georgian Comma | &amp;#x00B7; | &#x00B7; |
| Georgian Extensions | &amp;#x10F1; | &#x10F1; |
| Georgian Full Stop | &amp;#x0589; | &#x0589; |
| Georgian Khutsuri | &amp;#x10A0; | &#x10A0; |
| Georgian Mkhedruli | &amp;#x10D0; | &#x10D0; |
| Georgian Paragraph Separator | &amp;#x10FB; | &#x10FB; |
| Georgian Small Letters | &amp;#x10D0; | &#x10D0; |
| Georgian Supplement | &amp;#x2D00; | &#x2D00; |
| German Mark Pre-Wwii | &amp;#x2133; | &#x2133; |
| German Penny Sign | &amp;#x20B0; | &#x20B0; |
| Geta Mark | &amp;#x3013; | &#x3013; |
| Ghana Currency | &amp;#x20B5; | &#x20B5; |
| Gimel Symbol | &amp;#x2137; | &#x2137; |
| Glagolitic | &amp;#x2C00; | &#x2C00; |
| Gleich Stark | &amp;#x29E6; | &#x29E6; |
| Glottal Stop | &amp;#x02BC; | &#x02BC; |
| Glottal Stop, Latin Capital Letter | &amp;#x0241; | &#x0241; |
| Glottal Stop, Latin Letter | &amp;#x0294; | &#x0294; |
| Glottal Stop, Latin Letter Inverted | &amp;#x0296; | &#x0296; |
| Glottal Stop, Latin Letter Reversed | &amp;#x0295; | &#x0295; |
| Glottal Stop, Latin Small Letter | &amp;#x0242; | &#x0242; |
| Glottal Stop, Modifier Letter | &amp;#x02C0; | &#x02C0; |
| Glottal Stop, Modifier Letter Reversed | &amp;#x02C1; | &#x02C1; |
| Glottal Stop, Modifier Letter Small Reversed | &amp;#x02E4; | &#x02E4; |
| Gnaborretni | &amp;#x2E18; | &#x2E18; |
| Go Markers | &amp;#x2686; | &#x2686; |
| Golden Numbers, Runic | &amp;#x16EE; | &#x16EE; |
| Gothic | &amp;#x10330; | &#x10330; |
| Grapheme Joiner, Combining | &amp;#x034F; | &#x034F; |
| Graphic Characters, Terminal | &amp;#x23B7; | &#x23B7; |
| Graphic Characters, Terminal | &amp;#x2596; | &#x2596; |
| Graphic Pictures For Control Codes | &amp;#x2400; | &#x2400; |
| Graphics For Control Codes | &amp;#x237D; | &#x237D; |
| Graphics, Quadrant Control Code | &amp;#x25F0; | &#x25F0; |
| Grave Accent | &amp;#x0060; | &#x0060; |
| Grave Accent Below, Combining | &amp;#x0316; | &#x0316; |
| Grave Accent, Combining | &amp;#x0300; | &#x0300; |
| Grave Accent, Combining Double | &amp;#x030F; | &#x030F; |
| Grave Accent, Modifier Letter | &amp;#x02CB; | &#x02CB; |
| Grave Accent, Modifier Letter Low | &amp;#x02CE; | &#x02CE; |
| Grave Accent, Spacing | &amp;#x0060; | &#x0060; |
| Grave Accent, Swedish | &amp;#x02DF; | &#x02DF; |
| Grave Tone Mark, Combining | &amp;#x0340; | &#x0340; |
| Greater-Than Or Equal To | &amp;#x2265; | &#x2265; |
| Greater-Than Sign | &amp;#x003E; | &#x003E; |
| Greater-Than, Much | &amp;#x226B; | &#x226B; |
| Greater-Than, Very Much | &amp;#x22D9; | &#x22D9; |
| Greek | &amp;#x0370; | &#x0370; |
| Greek Alphabet | &amp;#x0391; | &#x0391; |
| Greek Ano Teleia | &amp;#x00B7; | &#x00B7; |
| Greek Archaic Letters | &amp;#x03D8; | &#x03D8; |
| Greek Beta Symbol | &amp;#x03D0; | &#x03D0; |
| Greek Capital Letters | &amp;#x0391; | &#x0391; |
| Greek Currency | &amp;#x20AF; | &#x20AF; |
| Greek Dasia | &amp;#x0314; | &#x0314; |
| Greek Dialytika | &amp;#x0308; | &#x0308; |
| Greek Dialytika Tonos, Combining | &amp;#x0344; | &#x0344; |
| Greek Enotikon | &amp;#x203F; | &#x203F; |
| Greek Extended | &amp;#x1F00; | &#x1F00; |
| Greek Iota Subscript | &amp;#x0345; | &#x0345; |
| Greek Koronis, Combining | &amp;#x0343; | &#x0343; |
| Greek Letters, Double-Struck | &amp;#x213C; | &#x213C; |
| Greek Lunate Epsilon Symbol | &amp;#x03F5; | &#x03F5; |
| Greek Lunate Sigma Symbol | &amp;#x03F2; | &#x03F2; |
| Greek Mathematical Symbols | &amp;#x1D6A8; | &#x1D6A8; |
| Greek Mathematical Symbols, Bold | &amp;#x1D6A8; | &#x1D6A8; |
| Greek Mathematical Symbols, Bold Italic | &amp;#x1D71C; | &#x1D71C; |
| Greek Mathematical Symbols, Italic | &amp;#x1D6E2; | &#x1D6E2; |
| Greek Mathematical Symbols, Sans-Serif Bold | &amp;#x1D756; | &#x1D756; |
| Greek Mathematical Symbols, Sans-Serif Bold Italic | &amp;#x1D790; | &#x1D790; |
| Greek Middle Dot | &amp;#x00B7; | &#x00B7; |
| Greek Musical Notation, Ancient | &amp;#x1D200; | &#x1D200; |
| Greek Non-Spacing Iota Below | &amp;#x0345; | &#x0345; |
| Greek Numbers, Ancient | &amp;#x10140; | &#x10140; |
| Greek Old Testament | &amp;#x1D516; | &#x1D516; |
| Greek Oxia | &amp;#x0301; | &#x0301; |
| Greek Pentonkion | &amp;#x2059; | &#x2059; |
| Greek Perispomeni, Combining | &amp;#x0342; | &#x0342; |
| Greek Phi Symbol | &amp;#x03D5; | &#x03D5; |
| Greek Pi Symbol | &amp;#x03D6; | &#x03D6; |
| Greek Psili | &amp;#x0313; | &#x0313; |
| Greek Punctuation And Signs | &amp;#x0374; | &#x0374; |
| Greek Question Mark | &amp;#x003B; | &#x003B; |
| Greek Question Mark | &amp;#x037E; | &#x037E; |
| Greek Reversed Lunate Epsilon Symbol | &amp;#x03F6; | &#x03F6; |
| Greek Rough Breathing Mark | &amp;#x0314; | &#x0314; |
| Greek Small Letter Iota, Turned | &amp;#x2129; | &#x2129; |
| Greek Small Letter Lunate Sigma | &amp;#x03F2; | &#x03F2; |
| Greek Small Letter Pi | &amp;#x03C0; | &#x03C0; |
| Greek Small Letters | &amp;#x03B1; | &#x03B1; |
| Greek Smooth Breathing Mark | &amp;#x0313; | &#x0313; |
| Greek Textual Symbols, Ancient | &amp;#x2E0E; | &#x2E0E; |
| Greek Theta Symbol | &amp;#x03D1; | &#x03D1; |
| Greek Tonos | &amp;#x0301; | &#x0301; |
| Greek Varia | &amp;#x0300; | &#x0300; |
| Greek Variant Letterforms | &amp;#x03D0; | &#x03D0; |
| Greek Vrachy | &amp;#x0306; | &#x0306; |
| Greek Ypogegrammeni, Combining | &amp;#x0345; | &#x0345; |
| Greek, Diacritics For | &amp;#x0342; | &#x0342; |
| Greek, Precomposed Polytonic | &amp;#x1F00; | &#x1F00; |
| Ground, Earth | &amp;#x23DA; | &#x23DA; |
| Group Lock | &amp;#x21F0; | &#x21F0; |
| Group Separator | &amp;#x001D; | &#x001D; |
| Group Separator, Symbol For | &amp;#x241D; | &#x241D; |
| Guarani Sign | &amp;#x20B2; | &#x20B2; |
| Guarded Area, End Of | &amp;#x0097; | &#x0097; |
| Guarded Area, Start Of | &amp;#x0096; | &#x0096; |
| Guillemet, Left Pointing | &amp;#x00AB; | &#x00AB; |
| Guillemet, Left Pointing Single | &amp;#x2039; | &#x2039; |
| Guillemet, Right Pointing | &amp;#x00BB; | &#x00BB; |
| Guillemet, Right Pointing Single | &amp;#x203A; | &#x203A; |
| Gujarati | &amp;#x0A80; | &#x0A80; |
| Gujarati Consonants | &amp;#x0A95; | &#x0A95; |
| Gujarati Dependent Vowel Signs | &amp;#x0ABE; | &#x0ABE; |
| Gujarati Digits | &amp;#x0AE6; | &#x0AE6; |
| Gujarati Independent Vowels | &amp;#x0A85; | &#x0A85; |
| Gujarati Rupee Sign | &amp;#x0AF1; | &#x0AF1; |
| Gurmukhi | &amp;#x0A00; | &#x0A00; |
| Gurmukhi Addak | &amp;#x0A71; | &#x0A71; |
| Gurmukhi Consonants | &amp;#x0A15; | &#x0A15; |
| Gurmukhi Dependent Vowel Signs | &amp;#x0A3E; | &#x0A3E; |
| Gurmukhi Digits | &amp;#x0A66; | &#x0A66; |
| Gurmukhi Ek Onkar | &amp;#x0A74; | &#x0A74; |
| Gurmukhi Independent Vowels | &amp;#x0A05; | &#x0A05; |
| Gurmukhi Khanda | &amp;#x262C; | &#x262C; |
| Gurmukhi Tippi | &amp;#x0A70; | &#x0A70; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## H

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| H With Breve Below, Latin Small Letter | &amp;#x1E2B; | &#x1E2B; |
| H With Caron, Latin Small Letter | &amp;#x021F; | &#x021F; |
| H With Cedilla, Latin Small Letter | &amp;#x1E29; | &#x1E29; |
| H With Circumflex, Latin Small Letter | &amp;#x0125; | &#x0125; |
| H With Diaeresis, Latin Small Letter | &amp;#x1E27; | &#x1E27; |
| H With Dot Above, Latin Small Letter | &amp;#x1E23; | &#x1E23; |
| H With Dot Below, Latin Small Letter | &amp;#x1E25; | &#x1E25; |
| H With Fishhook, Latin Small Letter Turned | &amp;#x02AE; | &#x02AE; |
| H With Hook, Latin Small Letter | &amp;#x0266; | &#x0266; |
| H With Line Below, Latin Small Letter | &amp;#x1E96; | &#x1E96; |
| H With Stroke, Latin Small Letter | &amp;#x0127; | &#x0127; |
| H, Black-Letter Capital | &amp;#x210C; | &#x210C; |
| H, Combining Latin Small Letter | &amp;#x036A; | &#x036A; |
| H, Double-Struck Capital | &amp;#x210D; | &#x210D; |
| H, Latin Letter Small Capital | &amp;#x029C; | &#x029C; |
| H, Latin Small Letter Turned | &amp;#x0265; | &#x0265; |
| H, Modifier Letter Small | &amp;#x02B0; | &#x02B0; |
| H, Script Capital | &amp;#x210B; | &#x210B; |
| Hacek, Combining | &amp;#x030C; | &#x030C; |
| Hacek, Modifier Letter | &amp;#x02C7; | &#x02C7; |
| Hair Space | &amp;#x200A; | &#x200A; |
| Halant | &amp;#x094D; | &#x094D; |
| Halanta, Tibetan Mark | &amp;#x0F84; | &#x0F84; |
| Half Fill Space, Ideographic | &amp;#x303F; | &#x303F; |
| Half Integral, Bottom | &amp;#x2321; | &#x2321; |
| Half Integral, Top | &amp;#x2320; | &#x2320; |
| Half Marks, Combining | &amp;#xFE20; | &#xFE20; |
| Half Ring Above, Combining Left | &amp;#x0351; | &#x0351; |
| Half Ring Above, Combining Right | &amp;#x0357; | &#x0357; |
| Half Ring Below, Combining Left | &amp;#x031C; | &#x031C; |
| Half Ring Below, Combining Right | &amp;#x0339; | &#x0339; |
| Half Ring, Armenian Modifier Letter Left | &amp;#x0559; | &#x0559; |
| Half Ring, Armenian Modifier Letter Right | &amp;#x055A; | &#x055A; |
| Half Ring, Modifier Letter Centred Left | &amp;#x02D3; | &#x02D3; |
| Half Ring, Modifier Letter Left | &amp;#x02BF; | &#x02BF; |
| Half Triangular Colon, Modifier Letter | &amp;#x02D1; | &#x02D1; |
| Half, Vulgar Fraction One | &amp;#x00BD; | &#x00BD; |
| Halfwidth And Fullwidth Forms | &amp;#xFF00; | &#xFF00; |
| Halfwidth Cjk Punctuation | &amp;#xFF61; | &#xFF61; |
| Halfwidth Japanese Katakana Variants | &amp;#xFF61; | &#xFF61; |
| Halfwidth Korean Hangul Variants | &amp;#xFFA0; | &#xFFA0; |
| Halfwidth Symbol Variants | &amp;#xFFE8; | &#xFFE8; |
| Hamilton Operator | &amp;#x25BD; | &#x25BD; |
| Hammer And Pick | &amp;#x2692; | &#x2692; |
| Hammer And Sickle | &amp;#x262D; | &#x262D; |
| Hamzah On Ha, Arabic Letter | &amp;#x06C0; | &#x06C0; |
| Han Ideographs | &amp;#x4E00; | &#x4E00; |
| Han-Daku-On, Combining Japanese | &amp;#x309A; | &#x309A; |
| Han-Daku-On, Japanese | &amp;#x309C; | &#x309C; |
| Hand Symbols, Pointing | &amp;#x261A; | &#x261A; |
| Hand, Victory | &amp;#x270C; | &#x270C; |
| Hand, Writing | &amp;#x270D; | &#x270D; |
| Hangul Archaic Letters, Korean | &amp;#x3165; | &#x3165; |
| Hangul Choseong Filler | &amp;#x115F; | &#x115F; |
| Hangul Compatibility Jamo, Korean | &amp;#x3130; | &#x3130; |
| Hangul Elements, Circled Korean | &amp;#x3260; | &#x3260; |
| Hangul Elements, Parenthesized Korean | &amp;#x3200; | &#x3200; |
| Hangul Filler | &amp;#x3164; | &#x3164; |
| Hangul Jamo Combining Alphabet, Korean | &amp;#x1100; | &#x1100; |
| Hangul Jungseong Filler | &amp;#x1160; | &#x1160; |
| Hangul Syllables Area, Korean | &amp;#xAC00; | &#xAC00; |
| Hangul Syllables, Circled Korean | &amp;#x326E; | &#x326E; |
| Hangul Syllables, Parenthesized Korean | &amp;#x320E; | &#x320E; |
| Hangul Variants, Halfwidth Korean | &amp;#xFFA0; | &#xFFA0; |
| Hangzhou Numerals | &amp;#x3021; | &#x3021; |
| Hanunoo | &amp;#x1720; | &#x1720; |
| Harakat, Arabic | &amp;#x064B; | &#x064B; |
| Harbor Symbol | &amp;#x2693; | &#x2693; |
| Harpoon Above, Combining Left | &amp;#x20D0; | &#x20D0; |
| Harpoon Above, Combining Right | &amp;#x20D1; | &#x20D1; |
| Harpoon With Barb Downwards, Combining Leftwards | &amp;#x20ED; | &#x20ED; |
| Harpoon With Barb Downwards, Combining Rightwards | &amp;#x20EC; | &#x20EC; |
| Harpoons | &amp;#x21BC; | &#x21BC; |
| Harpoons, Miscellaneous | &amp;#x294A; | &#x294A; |
| Hartsakan Nshan, Armenian | &amp;#x055E; | &#x055E; |
| Hasant, Bengali | &amp;#x09CD; | &#x09CD; |
| Hasanta, Syloti Nagri Sign | &amp;#xA806; | &#xA806; |
| Hash | &amp;#x0023; | &#x0023; |
| Hat | &amp;#x0302; | &#x0302; |
| Hat | &amp;#x2229; | &#x2229; |
| Have A Nice Day! | &amp;#x263A; | &#x263A; |
| Hazard Dingbats | &amp;#x2620; | &#x2620; |
| Head Marks, Tibetan | &amp;#x0F01; | &#x0F01; |
| Heading, Start Of | &amp;#x0001; | &#x0001; |
| Heading, Symbol For Start Of | &amp;#x2401; | &#x2401; |
| Heart Bullet, Reversed Rotated Floral | &amp;#x2619; | &#x2619; |
| Heart Dingbats | &amp;#x2763; | &#x2763; |
| Heart Ornaments | &amp;#x2763; | &#x2763; |
| Heavy Ballot X | &amp;#x2718; | &#x2718; |
| Heavy Check Mark | &amp;#x2714; | &#x2714; |
| Heavy Exclamation Mark Ornament | &amp;#x2762; | &#x2762; |
| Heavy Multiplication X | &amp;#x2716; | &#x2716; |
| Heavy Sparkle | &amp;#x2748; | &#x2748; |
| Hebrew | &amp;#x0590; | &#x0590; |
| Hebrew Alphabet | &amp;#x05D0; | &#x05D0; |
| Hebrew Cantillation Marks | &amp;#x0591; | &#x0591; |
| Hebrew Letterlike Mathematical Symbols | &amp;#x2135; | &#x2135; |
| Hebrew Points And Punctuation | &amp;#x05B0; | &#x05B0; |
| Hebrew Presentation Forms | &amp;#xFB1D; | &#xFB1D; |
| Hedera | &amp;#x2767; | &#x2767; |
| Heh With Yeh Above, Arabic Letter | &amp;#x06C0; | &#x06C0; |
| Helm Symbol | &amp;#x2388; | &#x2388; |
| Hermes, Staff Of | &amp;#x269A; | &#x269A; |
| Hermitian Conjugate Matrix | &amp;#x22B9; | &#x22B9; |
| Hexagram Symbols, Yijing / I Ching | &amp;#x4DC0; | &#x4DC0; |
| High Surrogates | &amp;#xD800; | &#xD800; |
| High Voltage Sign | &amp;#x26A1; | &#x26A1; |
| High-Reversed-9 Quotation Mark, Double | &amp;#x201F; | &#x201F; |
| High-Reversed-9 Quotation Mark, Single | &amp;#x201B; | &#x201B; |
| Higher Rank Than | &amp;#x227B; | &#x227B; |
| Hilbert Space | &amp;#x210C; | &#x210C; |
| Hiragana | &amp;#x3040; | &#x3040; |
| Hiragana Iteration Mark | &amp;#x309D; | &#x309D; |
| Hiragana Letter Small Ka | &amp;#x3095; | &#x3095; |
| Hiragana Letter Small Ke | &amp;#x3096; | &#x3096; |
| Hiragana Supplement | &amp;#x3095; | &#x3095; |
| Hiragana Voiced Iteration Mark | &amp;#x309E; | &#x309E; |
| Histogram Marker | &amp;#x25AE; | &#x25AE; |
| Holler | &amp;#x2365; | &#x2365; |
| Home | &amp;#x21B8; | &#x21B8; |
| Home | &amp;#x21F1; | &#x21F1; |
| Homothetic | &amp;#x223B; | &#x223B; |
| Homothetic Above, Combining | &amp;#x034B; | &#x034B; |
| Honorifics, Arabic | &amp;#x0610; | &#x0610; |
| Hook Above, Combining | &amp;#x0309; | &#x0309; |
| Hook Below, Combining Palatalized | &amp;#x0321; | &#x0321; |
| Hook Below, Combining Retroflex | &amp;#x0322; | &#x0322; |
| Hook, Modifier Letter Rhotic | &amp;#x02DE; | &#x02DE; |
| Hook, Nasal | &amp;#x0328; | &#x0328; |
| Hoot | &amp;#x2364; | &#x2364; |
| Horizontal Bar | &amp;#x2015; | &#x2015; |
| Horizontal Ellipsis | &amp;#x2026; | &#x2026; |
| Horizontal Ellipsis, Midline | &amp;#x22EF; | &#x22EF; |
| Horizontal Scan Lines | &amp;#x23BA; | &#x23BA; |
| Horizontal Tabulation | &amp;#x0009; | &#x0009; |
| Horizontal Tabulation, Symbol For | &amp;#x2409; | &#x2409; |
| Horn, Combining | &amp;#x031B; | &#x031B; |
| Hot Beverage | &amp;#x2615; | &#x2615; |
| Hot Springs | &amp;#x2668; | &#x2668; |
| Hourglass | &amp;#x231B; | &#x231B; |
| Hourglass, Black | &amp;#x29D7; | &#x29D7; |
| Hours, Ideographic Telegraph Symbols For | &amp;#x3358; | &#x3358; |
| House | &amp;#x2302; | &#x2302; |
| Hryvnia Sign | &amp;#x20B4; | &#x20B4; |
| Ht | &amp;#x0009; | &#x0009; |
| Hv, Latin Small Letter | &amp;#x0195; | &#x0195; |
| Hwair, Latin Capital Letter | &amp;#x01F6; | &#x01F6; |
| Hyphen | &amp;#x2010; | &#x2010; |
| Hyphen Bullet | &amp;#x2043; | &#x2043; |
| Hyphen Or Minus Sign | &amp;#x002D; | &#x002D; |
| Hyphen, Armenian | &amp;#x058A; | &#x058A; |
| Hyphen, Discretionary | &amp;#x00AD; | &#x00AD; |
| Hyphen, Katakana-Hiragana Double | &amp;#x30A0; | &#x30A0; |
| Hyphen, Mongolian Todo Soft | &amp;#x1806; | &#x1806; |
| Hyphen, Non-Breaking | &amp;#x2011; | &#x2011; |
| Hyphen, Papyrological | &amp;#x035C; | &#x035C; |
| Hyphen, Soft | &amp;#x00AD; | &#x00AD; |
| Hyphen-Minus | &amp;#x002D; | &#x002D; |
| Hyphenation Point | &amp;#x2027; | &#x2027; |
| Hyphus | &amp;#x002D; | &#x002D; |
| Hysteresis Symbol | &amp;#x238E; | &#x238E; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## I

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| I Bar, Latin Capital Letter | &amp;#x0197; | &#x0197; |
| I Ching / Yijing Hexagram Symbols | &amp;#x4DC0; | &#x4DC0; |
| I Ching / Yijing Monogram And Digram Symbols | &amp;#x268A; | &#x268A; |
| I Ching / Yijing Trigram Symbols | &amp;#x2630; | &#x2630; |
| I Dot, Latin Capital Letter | &amp;#x0130; | &#x0130; |
| I With Acute, Latin Capital Letter | &amp;#x00CD; | &#x00CD; |
| I With Acute, Latin Small Letter | &amp;#x00ED; | &#x00ED; |
| I With Breve, Latin Small Letter | &amp;#x012D; | &#x012D; |
| I With Caron, Latin Small Letter | &amp;#x01D0; | &#x01D0; |
| I With Circumflex, Latin Capital Letter | &amp;#x00CE; | &#x00CE; |
| I With Circumflex, Latin Small Letter | &amp;#x00EE; | &#x00EE; |
| I With Diaeresis, Latin Capital Letter | &amp;#x00CF; | &#x00CF; |
| I With Diaeresis, Latin Small Letter | &amp;#x00EF; | &#x00EF; |
| I With Dot Above, Latin Capital Letter | &amp;#x0130; | &#x0130; |
| I With Dot Below, Latin Small Letter | &amp;#x1ECB; | &#x1ECB; |
| I With Double Grave, Latin Small Letter | &amp;#x0209; | &#x0209; |
| I With Grave, Latin Capital Letter | &amp;#x00CC; | &#x00CC; |
| I With Grave, Latin Small Letter | &amp;#x00EC; | &#x00EC; |
| I With Hook Above, Latin Small Letter | &amp;#x1EC9; | &#x1EC9; |
| I With Inverted Breve, Latin Small Letter | &amp;#x020B; | &#x020B; |
| I With Macron, Latin Small Letter | &amp;#x012B; | &#x012B; |
| I With Ogonek, Latin Small Letter | &amp;#x012F; | &#x012F; |
| I With Stroke, Latin Capital Letter | &amp;#x0197; | &#x0197; |
| I With Stroke, Latin Small Letter | &amp;#x0268; | &#x0268; |
| I With Tilde Below, Latin Small Letter | &amp;#x1E2D; | &#x1E2D; |
| I With Tilde, Latin Small Letter | &amp;#x0129; | &#x0129; |
| I, Black-Letter Capital | &amp;#x2111; | &#x2111; |
| I, Combining Latin Small Letter | &amp;#x0365; | &#x0365; |
| I, Double-Struck Italic Small | &amp;#x2148; | &#x2148; |
| I, Latin Letter Small Capital | &amp;#x026A; | &#x026A; |
| I, Latin Small Letter Dotless | &amp;#x0131; | &#x0131; |
| I, Latin Small Letter Turned | &amp;#x1D09; | &#x1D09; |
| I, Latin Subscript Small Letter | &amp;#x1D62; | &#x1D62; |
| I, Script Capital | &amp;#x2110; | &#x2110; |
| I, Superscript Latin Small Letter | &amp;#x2071; | &#x2071; |
| Identical To | &amp;#x2261; | &#x2261; |
| Identical To, Not | &amp;#x2262; | &#x2262; |
| Ideograms, Linear B | &amp;#x10080; | &#x10080; |
| Ideographic Annotation, Japanese Kanbun | &amp;#x3190; | &#x3190; |
| Ideographic Closing Mark | &amp;#x3006; | &#x3006; |
| Ideographic Comma | &amp;#x3001; | &#x3001; |
| Ideographic Description Characters, Cjk | &amp;#x2FF0; | &#x2FF0; |
| Ideographic Full Stop | &amp;#x3002; | &#x3002; |
| Ideographic Half Fill Space | &amp;#x303F; | &#x303F; |
| Ideographic Iteration Mark | &amp;#x3005; | &#x3005; |
| Ideographic Iteration Mark, Vertical | &amp;#x303B; | &#x303B; |
| Ideographic Number Zero | &amp;#x3007; | &#x3007; |
| Ideographic Space | &amp;#x3000; | &#x3000; |
| Ideographic Telegraph Symbols For Days | &amp;#x33E0; | &#x33E0; |
| Ideographic Telegraph Symbols For Hours | &amp;#x3358; | &#x3358; |
| Ideographic Telegraph Symbols For Months | &amp;#x32C0; | &#x32C0; |
| Ideographic Tone Marks | &amp;#x302A; | &#x302A; |
| Ideographic Variation Indicator | &amp;#x303E; | &#x303E; |
| Ideographs Area, Cjk | &amp;#x3400; | &#x3400; |
| Ideographs Area, Supplementary Cjk | &amp;#x20000; | &#x20000; |
| Ideographs Extension A, Cjk Unified | &amp;#x3400; | &#x3400; |
| Ideographs Extension B, Cjk Unified | &amp;#x20000; | &#x20000; |
| Ideographs Supplement, Cjk Compatibility | &amp;#x2F800; | &#x2F800; |
| Ideographs, Circled | &amp;#x3280; | &#x3280; |
| Ideographs, Cjk Compatibility | &amp;#xF900; | &#xF900; |
| Ideographs, Cjk Unified | &amp;#x4E00; | &#x4E00; |
| Ideographs, Dprk Compatibility | &amp;#xFA70; | &#xFA70; |
| Ideographs, Han | &amp;#x4E00; | &#x4E00; |
| Ideographs, Jis X 0213 Compatibility | &amp;#xFA30; | &#xFA30; |
| Ideographs, Parenthesized Cjk | &amp;#x3220; | &#x3220; |
| Idle, Symbol For Synchronous | &amp;#x2416; | &#x2416; |
| Idle, Synchronous | &amp;#x0016; | &#x0016; |
| Ij, Latin Small Ligature | &amp;#x0133; | &#x0133; |
| Image Of | &amp;#x22B7; | &#x22B7; |
| Image Of, Square | &amp;#x228F; | &#x228F; |
| Imaginary Part | &amp;#x2111; | &#x2111; |
| Implies | &amp;#x22A2; | &#x22A2; |
| Inches | &amp;#x2033; | &#x2033; |
| Included In Set | &amp;#x2282; | &#x2282; |
| Includes In Set | &amp;#x2283; | &#x2283; |
| Incorporated, Japanese | &amp;#x337F; | &#x337F; |
| Increment | &amp;#x2206; | &#x2206; |
| Independence | &amp;#x2AEB; | &#x2AEB; |
| Independent | &amp;#x2ADD; | &#x2ADD; |
| Independent, Not | &amp;#x2ADC; | &#x2ADC; |
| Index Finger Dingbats, Pointing | &amp;#x261A; | &#x261A; |
| Index, Black Left Pointing | &amp;#x261A; | &#x261A; |
| Index, Black Right Pointing | &amp;#x261B; | &#x261B; |
| Index, White Down Pointing | &amp;#x261F; | &#x261F; |
| Index, White Left Pointing | &amp;#x261C; | &#x261C; |
| Index, White Right Pointing | &amp;#x261E; | &#x261E; |
| Index, White Up Pointing | &amp;#x261D; | &#x261D; |
| Indian Currency | &amp;#x20A8; | &#x20A8; |
| Indicator, Backward Arrow | &amp;#x25C5; | &#x25C5; |
| Indicator, Forward Arrow | &amp;#x25BB; | &#x25BB; |
| Inequality Signs, Equality And | &amp;#x2243; | &#x2243; |
| Inequality Signs, Equality And | &amp;#x22D5; | &#x22D5; |
| Infinity | &amp;#x221E; | &#x221E; |
| Infix Bag Count | &amp;#x266F; | &#x266F; |
| Information Separator Four | &amp;#x001C; | &#x001C; |
| Information Separator One | &amp;#x001F; | &#x001F; |
| Information Separator Three | &amp;#x001D; | &#x001D; |
| Information Separator Two | &amp;#x001E; | &#x001E; |
| Information Source | &amp;#x2139; | &#x2139; |
| Ingressive Airflow | &amp;#x2193; | &#x2193; |
| Injection, Finite | &amp;#x2915; | &#x2915; |
| Injection, Finite Surjective | &amp;#x2918; | &#x2918; |
| Injection, Partial | &amp;#x2914; | &#x2914; |
| Injection, Surjective | &amp;#x2917; | &#x2917; |
| Injection, Total | &amp;#x21A3; | &#x21A3; |
| Insertion Point, Caret | &amp;#x2041; | &#x2041; |
| Insertion Symbol | &amp;#x2380; | &#x2380; |
| Integers | &amp;#x2124; | &#x2124; |
| Integral | &amp;#x222B; | &#x222B; |
| Integral Operator, Quaternion | &amp;#x2A16; | &#x2A16; |
| Integral Signs | &amp;#x222B; | &#x222B; |
| Integral, Anticlockwise Contour | &amp;#x2233; | &#x2233; |
| Integral, Bottom Half | &amp;#x2321; | &#x2321; |
| Integral, Clockwise | &amp;#x2231; | &#x2231; |
| Integral, Clockwise Contour | &amp;#x2232; | &#x2232; |
| Integral, Contour | &amp;#x222E; | &#x222E; |
| Integral, Counterclockwise Contour | &amp;#x2233; | &#x2233; |
| Integral, Double | &amp;#x222C; | &#x222C; |
| Integral, Lower | &amp;#x2A1C; | &#x2A1C; |
| Integral, Riemann | &amp;#x211B; | &#x211B; |
| Integral, Surface | &amp;#x222F; | &#x222F; |
| Integral, Top Half | &amp;#x2320; | &#x2320; |
| Integral, Triple | &amp;#x222D; | &#x222D; |
| Integral, Upper | &amp;#x2A1B; | &#x2A1B; |
| Integral, Volume | &amp;#x2230; | &#x2230; |
| Integrals, Summations And | &amp;#x2A0A; | &#x2A0A; |
| Integration, Anticlockwise | &amp;#x2A11; | &#x2A11; |
| Integration, Counterclockwise | &amp;#x2A11; | &#x2A11; |
| Intercalate | &amp;#x22BA; | &#x22BA; |
| Interest Sign, Place Of | &amp;#x2318; | &#x2318; |
| Interior Product | &amp;#x2A3C; | &#x2A3C; |
| Interior Product, Righthand | &amp;#x2A3D; | &#x2A3D; |
| Interleave | &amp;#x2AF4; | &#x2AF4; |
| Interlinear Annotation | &amp;#xFFF9; | &#xFFF9; |
| Interlinear Annotation Anchor | &amp;#xFFF9; | &#xFFF9; |
| Interlinear Annotation Separator | &amp;#xFFFA; | &#xFFFA; |
| Interlinear Annotation Terminator | &amp;#xFFFB; | &#xFFFB; |
| Interrobang | &amp;#x203D; | &#x203D; |
| Interrobang, Inverted | &amp;#x2E18; | &#x2E18; |
| Interrupt | &amp;#x238A; | &#x238A; |
| Intersection | &amp;#x2229; | &#x2229; |
| Intersection, Double | &amp;#x22D2; | &#x22D2; |
| Intersection, Electrical | &amp;#x23E7; | &#x23E7; |
| Intersection, Generalized | &amp;#x22C2; | &#x22C2; |
| Intersection, N-Ary | &amp;#x22C2; | &#x22C2; |
| Intersection, Proper | &amp;#x22D4; | &#x22D4; |
| Intersections And Unions | &amp;#x2A40; | &#x2A40; |
| Intersyllabic Tsheg, Tibetan Mark | &amp;#x0F0B; | &#x0F0B; |
| Introducer, Control Sequence | &amp;#x009B; | &#x009B; |
| Introducer, Single Character | &amp;#x009A; | &#x009A; |
| Inverse Numbers, Circled | &amp;#x2776; | &#x2776; |
| Inverted Breve Below, Combining | &amp;#x032F; | &#x032F; |
| Inverted Breve, Combining | &amp;#x0311; | &#x0311; |
| Inverted Breve, Combining Double | &amp;#x0361; | &#x0361; |
| Inverted Bridge Below, Combining | &amp;#x033A; | &#x033A; |
| Inverted Double Arch Below, Combining | &amp;#x032B; | &#x032B; |
| Inverted Exclamation Mark | &amp;#x00A1; | &#x00A1; |
| Inverted Glottal Stop, Latin Letter | &amp;#x0296; | &#x0296; |
| Inverted Interrobang | &amp;#x2E18; | &#x2E18; |
| Inverted Lazy S | &amp;#x223E; | &#x223E; |
| Inverted Ohm Sign | &amp;#x2127; | &#x2127; |
| Inverted Question Mark | &amp;#x00BF; | &#x00BF; |
| Inverted R, Latin Letter Small Capital | &amp;#x0281; | &#x0281; |
| Inverted R, Modifier Letter Small Capital | &amp;#x02B6; | &#x02B6; |
| Inverted Undertie | &amp;#x2054; | &#x2054; |
| Invisible Comma | &amp;#x2063; | &#x2063; |
| Invisible Plus | &amp;#x2064; | &#x2064; |
| Invisible Separator | &amp;#x2063; | &#x2063; |
| Invisible Times | &amp;#x2062; | &#x2062; |
| Iota Below, Greek Non-Spacing | &amp;#x0345; | &#x0345; |
| Iota Subscript, Greek | &amp;#x0345; | &#x0345; |
| Iota, Latin Capital Letter | &amp;#x0196; | &#x0196; |
| Iota, Latin Small Letter | &amp;#x0269; | &#x0269; |
| Iota, Turned Greek Small Letter | &amp;#x2129; | &#x2129; |
| Ipa Extensions | &amp;#x0250; | &#x0250; |
| Ipa, Diacritics For | &amp;#x0346; | &#x0346; |
| Iranian Currency | &amp;#xFDFC; | &#xFDFC; |
| Irish Punt | &amp;#x00A3; | &#x00A3; |
| Isotech Entity &Amp;Iinfin; | &amp;#x29DC; | &#x29DC; |
| Israeli Currency | &amp;#x20AA; | &#x20AA; |
| Isshar, Bengali | &amp;#x09FA; | &#x09FA; |
| Isshar, Oriya | &amp;#x0B70; | &#x0B70; |
| Italian Currency | &amp;#x20A4; | &#x20A4; |
| Italian Lira | &amp;#x00A3; | &#x00A3; |
| Italic Greek Mathematical Symbols | &amp;#x1D6E2; | &#x1D6E2; |
| Italic Greek Mathematical Symbols, Bold | &amp;#x1D71C; | &#x1D71C; |
| Italic Greek Mathematical Symbols, Sans-Serif Bold | &amp;#x1D790; | &#x1D790; |
| Italic Mathematical Symbols | &amp;#x1D434; | &#x1D434; |
| Italic Mathematical Symbols, Bold | &amp;#x1D468; | &#x1D468; |
| Italic Mathematical Symbols, Sans-Serif | &amp;#x1D608; | &#x1D608; |
| Italic Mathematical Symbols, Sans-Serif Bold | &amp;#x1D63C; | &#x1D63C; |
| Italic, Old | &amp;#x10300; | &#x10300; |
| Itc Zapf Dingbats Series 100 | &amp;#x2700; | &#x2700; |
| Iteration Mark, Hiragana | &amp;#x309D; | &#x309D; |
| Iteration Mark, Hiragana Voiced | &amp;#x309E; | &#x309E; |
| Iteration Mark, Ideographic | &amp;#x3005; | &#x3005; |
| Iteration Mark, Katakana | &amp;#x30FD; | &#x30FD; |
| Iteration Mark, Katakana Voiced | &amp;#x30FE; | &#x30FE; |
| Iteration Mark, Vertical Ideographic | &amp;#x303B; | &#x303B; |
| Ivy Leaf | &amp;#x2767; | &#x2767; |
| Izafet | &amp;#x06C0; | &#x06C0; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## J

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| J With Caron, Latin Small Letter | &amp;#x01F0; | &#x01F0; |
| J With Circumflex, Latin Small Letter | &amp;#x0135; | &#x0135; |
| J With Crossed-Tail, Latin Small Letter | &amp;#x029D; | &#x029D; |
| J With Stroke, Latin Capital Letter | &amp;#x0248; | &#x0248; |
| J With Stroke, Latin Small Letter | &amp;#x0249; | &#x0249; |
| J With Stroke, Latin Small Letter Dotless | &amp;#x025F; | &#x025F; |
| J, Double-Struck Italic Small | &amp;#x2149; | &#x2149; |
| J, Latin Letter Small Capital | &amp;#x1D0A; | &#x1D0A; |
| J, Latin Small Letter Dotless | &amp;#x0237; | &#x0237; |
| J, Modifier Letter Small | &amp;#x02B2; | &#x02B2; |
| Jack | &amp;#x2749; | &#x2749; |
| Jamo Combining Alphabet, Korean Hangul | &amp;#x1100; | &#x1100; |
| Jamo, Korean Hangul Compatibility | &amp;#x3130; | &#x3130; |
| Japanese Bullet, Tainome | &amp;#x25C9; | &#x25C9; |
| Japanese Chess Symbols | &amp;#x2616; | &#x2616; |
| Japanese Era Names | &amp;#x337B; | &#x337B; |
| Japanese Hiragana | &amp;#x3040; | &#x3040; |
| Japanese Incorporated | &amp;#x337F; | &#x337F; |
| Japanese Industrial Standard Symbol | &amp;#x3004; | &#x3004; |
| Japanese Kanbun Ideographic Annotation | &amp;#x3190; | &#x3190; |
| Japanese Katakana | &amp;#x30A0; | &#x30A0; |
| Japanese Katakana Variants, Halfwidth | &amp;#xFF61; | &#xFF61; |
| Japanese Katakana Words, Squared | &amp;#x3300; | &#x3300; |
| Japanese Katakana, Circled | &amp;#x32D0; | &#x32D0; |
| Japanese Kome | &amp;#x203B; | &#x203B; |
| Jerusalem, Cross Of | &amp;#x2629; | &#x2629; |
| Jis Composition Circle | &amp;#x20DD; | &#x20DD; |
| Jis X 0213 Compatibility Ideographs | &amp;#xFA30; | &#xFA30; |
| Join | &amp;#x2A1D; | &#x2A1D; |
| Joiner, Combining Grapheme | &amp;#x034F; | &#x034F; |
| Joiner, Word | &amp;#x2060; | &#x2060; |
| Joiner, Zero Width | &amp;#x200D; | &#x200D; |
| Jolly Roger | &amp;#x2620; | &#x2620; |
| Jot, Apl | &amp;#x2218; | &#x2218; |
| Jupiter | &amp;#x2643; | &#x2643; |
| Jurisprudence Symbol | &amp;#x2696; | &#x2696; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## K

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| K With Acute, Latin Small Letter | &amp;#x1E31; | &#x1E31; |
| K With Caron, Latin Small Letter | &amp;#x01E9; | &#x01E9; |
| K With Cedilla, Latin Small Letter | &amp;#x0137; | &#x0137; |
| K With Dot Below, Latin Small Letter | &amp;#x1E33; | &#x1E33; |
| K With Hook, Latin Small Letter | &amp;#x0199; | &#x0199; |
| K With Line Below, Latin Small Letter | &amp;#x1E35; | &#x1E35; |
| K, Latin Letter Small Capital | &amp;#x1D0B; | &#x1D0B; |
| K, Latin Small Letter Turned | &amp;#x029E; | &#x029E; |
| Ka, Hiragana Letter Small | &amp;#x3095; | &#x3095; |
| Kabusiki-Gaisya | &amp;#x337F; | &#x337F; |
| Kana Repeat Marks | &amp;#x3031; | &#x3031; |
| Kanbun Ideographic Annotation, Japanese | &amp;#x3190; | &#x3190; |
| Kangxi Radicals, Cjk | &amp;#x2F00; | &#x2F00; |
| Kannada | &amp;#x0C80; | &#x0C80; |
| Kannada Consonants | &amp;#x0C95; | &#x0C95; |
| Kannada Dependent Vowel Signs | &amp;#x0CBE; | &#x0CBE; |
| Kannada Digits | &amp;#x0CE6; | &#x0CE6; |
| Kannada Independent Vowels | &amp;#x0C85; | &#x0C85; |
| Kashida, Arabic | &amp;#x0640; | &#x0640; |
| Katakana | &amp;#x30A0; | &#x30A0; |
| Katakana Digraph Koto | &amp;#x30FF; | &#x30FF; |
| Katakana Extensions For Ainu | &amp;#x31F0; | &#x31F0; |
| Katakana Iteration Mark | &amp;#x30FD; | &#x30FD; |
| Katakana Middle Dot | &amp;#x30FB; | &#x30FB; |
| Katakana Phonetic Extensions | &amp;#x31F0; | &#x31F0; |
| Katakana Variants, Halfwidth Japanese | &amp;#xFF61; | &#xFF61; |
| Katakana Voiced Iteration Mark | &amp;#x30FE; | &#x30FE; |
| Katakana Words, Squared | &amp;#x3300; | &#x3300; |
| Katakana, Circled | &amp;#x32D0; | &#x32D0; |
| Katakana-Hiragana Double Hyphen | &amp;#x30A0; | &#x30A0; |
| Katakana-Hiragana Prolonged Sound Mark | &amp;#x30FC; | &#x30FC; |
| Kayah Li | &amp;#xA900; | &#xA900; |
| Kelvin Sign | &amp;#x212A; | &#x212A; |
| Ket | &amp;#x27E9; | &#x27E9; |
| Key, Clear | &amp;#x2327; | &#x2327; |
| Key, Command | &amp;#x2318; | &#x2318; |
| Key, Delete To The Left | &amp;#x232B; | &#x232B; |
| Key, Delete To The Right | &amp;#x2326; | &#x2326; |
| Key, Enter | &amp;#x2324; | &#x2324; |
| Key, Option | &amp;#x2325; | &#x2325; |
| Keyboard | &amp;#x2328; | &#x2328; |
| Keyboard Symbol For No Break Space | &amp;#x237D; | &#x237D; |
| Keyboard Symbols | &amp;#x21E6; | &#x21E6; |
| Keyboard Symbols | &amp;#x2324; | &#x2324; |
| Keyboard Symbols | &amp;#x2380; | &#x2380; |
| Keyboard Symbols | &amp;#x2396; | &#x2396; |
| Keycap, Combining Enclosing | &amp;#x20E3; | &#x20E3; |
| Khanda, Gurmukhi | &amp;#x262C; | &#x262C; |
| Kharoshthi | &amp;#x10A00; | &#x10A00; |
| Kharoshthi Digits | &amp;#x10A40; | &#x10A40; |
| Khmer | &amp;#x1780; | &#x1780; |
| Khmer Anusvara | &amp;#x17C6; | &#x17C6; |
| Khmer Consonants | &amp;#x1780; | &#x1780; |
| Khmer Currency Symbol Riel | &amp;#x17DB; | &#x17DB; |
| Khmer Dependent Vowel Signs | &amp;#x17B6; | &#x17B6; |
| Khmer Digits | &amp;#x17E0; | &#x17E0; |
| Khmer Independent Vowels | &amp;#x17A5; | &#x17A5; |
| Khmer Numeric Symbols For Divination | &amp;#x17F0; | &#x17F0; |
| Khmer Sign Nikahit | &amp;#x17C6; | &#x17C6; |
| Khmer Sign Reahmuk | &amp;#x17C7; | &#x17C7; |
| Khmer Signs | &amp;#x17C6; | &#x17C6; |
| Khmer Srak Ah | &amp;#x17C7; | &#x17C7; |
| Khmer Srak Am | &amp;#x17C6; | &#x17C6; |
| Khmer Symbols | &amp;#x19E0; | &#x19E0; |
| Khmer Visarga | &amp;#x17C7; | &#x17C7; |
| Khomut, Thai Character | &amp;#x0E5B; | &#x0E5B; |
| Khutsuri, Georgian | &amp;#x10A0; | &#x10A0; |
| Killer, Myanmar | &amp;#x1039; | &#x1039; |
| Kip Sign | &amp;#x20AD; | &#x20AD; |
| Kissen | &amp;#x2311; | &#x2311; |
| Kome, Japanese | &amp;#x203B; | &#x203B; |
| Komi Letters | &amp;#x0500; | &#x0500; |
| Koranic Annotation Signs, Arabic | &amp;#x06D6; | &#x06D6; |
| Korean Combining Alphabet | &amp;#x1100; | &#x1100; |
| Korean Currency | &amp;#x20A9; | &#x20A9; |
| Korean Hangul Archaic Letters | &amp;#x3165; | &#x3165; |
| Korean Hangul Compatibility Jamo | &amp;#x3130; | &#x3130; |
| Korean Hangul Elements, Circled | &amp;#x3260; | &#x3260; |
| Korean Hangul Elements, Parenthesized | &amp;#x3200; | &#x3200; |
| Korean Hangul Jamo Combining Alphabet | &amp;#x1100; | &#x1100; |
| Korean Hangul Syllables | &amp;#xAC00; | &#xAC00; |
| Korean Hangul Syllables, Circled | &amp;#x326E; | &#x326E; |
| Korean Hangul Syllables, Parenthesized | &amp;#x320E; | &#x320E; |
| Korean Hangul Variants, Halfwidth | &amp;#xFFA0; | &#xFFA0; |
| Korean Standard Symbol | &amp;#x327F; | &#x327F; |
| Koronis, Combining Greek | &amp;#x0343; | &#x0343; |
| Koto, Katakana Digraph | &amp;#x30FF; | &#x30FF; |
| Kra, Latin Small Letter | &amp;#x0138; | &#x0138; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## L

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| L B Bar Symbol | &amp;#x2114; | &#x2114; |
| L With Acute, Latin Small Letter | &amp;#x013A; | &#x013A; |
| L With Bar, Latin Capital Letter | &amp;#x023D; | &#x023D; |
| L With Bar, Latin Small Letter | &amp;#x019A; | &#x019A; |
| L With Belt, Latin Small Letter | &amp;#x026C; | &#x026C; |
| L With Caron, Latin Small Letter | &amp;#x013E; | &#x013E; |
| L With Cedilla, Latin Small Letter | &amp;#x013C; | &#x013C; |
| L With Circumflex Below, Latin Small Letter | &amp;#x1E3D; | &#x1E3D; |
| L With Curl, Latin Small Letter | &amp;#x0234; | &#x0234; |
| L With Dot Below, Latin Small Letter | &amp;#x1E37; | &#x1E37; |
| L With Line Below, Latin Small Letter | &amp;#x1E3B; | &#x1E3B; |
| L With Middle Dot, Latin Small Letter | &amp;#x0140; | &#x0140; |
| L With Middle Tilde, Latin Small Letter | &amp;#x026B; | &#x026B; |
| L With Retroflex Hook, Latin Small Letter | &amp;#x026D; | &#x026D; |
| L With Stroke, Latin Letter Small Capital | &amp;#x1D0C; | &#x1D0C; |
| L With Stroke, Latin Small Letter | &amp;#x0142; | &#x0142; |
| L, Latin Letter Small Capital | &amp;#x029F; | &#x029F; |
| L, Modifier Letter Small | &amp;#x02E1; | &#x02E1; |
| L, Reversed Sans-Serif Capital | &amp;#x2143; | &#x2143; |
| L, Script Capital | &amp;#x2112; | &#x2112; |
| L, Script Small | &amp;#x2113; | &#x2113; |
| L, Turned Sans-Serif Capital | &amp;#x2142; | &#x2142; |
| Lambda Bar, Latin Letter | &amp;#x019B; | &#x019B; |
| Language Tag | &amp;#xE0001; | &#xE0001; |
| Lao | &amp;#x0E80; | &#x0E80; |
| Lao Cancellation Mark | &amp;#x0ECC; | &#x0ECC; |
| Lao Consonants | &amp;#x0E81; | &#x0E81; |
| Lao Digits | &amp;#x0ED0; | &#x0ED0; |
| Lao Ellipsis | &amp;#x0EAF; | &#x0EAF; |
| Lao Marks And Signs | &amp;#x0EC8; | &#x0EC8; |
| Lao Niggahita | &amp;#x0ECD; | &#x0ECD; |
| Lao Vowels | &amp;#x0EB0; | &#x0EB0; |
| Laotian Currency | &amp;#x20AD; | &#x20AD; |
| Laplace Operator | &amp;#x2206; | &#x2206; |
| Laplace Transform | &amp;#x2112; | &#x2112; |
| Large Bowtie | &amp;#x2A1D; | &#x2A1D; |
| Large Circle | &amp;#x25EF; | &#x25EF; |
| Large Operators | &amp;#x29F8; | &#x29F8; |
| Last Quarter Moon | &amp;#x263E; | &#x263E; |
| Lateral Click, Latin Letter | &amp;#x01C1; | &#x01C1; |
| Latin Abbreviations, Squared | &amp;#x3371; | &#x3371; |
| Latin Abbreviations, Squared | &amp;#x3380; | &#x3380; |
| Latin Cross | &amp;#x271D; | &#x271D; |
| Latin Extended Additional | &amp;#x1E00; | &#x1E00; |
| Latin Extended-A | &amp;#x0100; | &#x0100; |
| Latin Extended-B | &amp;#x0180; | &#x0180; |
| Latin Extended-C | &amp;#x2C60; | &#x2C60; |
| Latin Extended-D | &amp;#xA720; | &#xA720; |
| Latin Extensions | &amp;#x1D00; | &#x1D00; |
| Latin Letter Ain | &amp;#x1D25; | &#x1D25; |
| Latin Letter Alveolar Click | &amp;#x01C2; | &#x01C2; |
| Latin Letter Bidental Percussive | &amp;#x02AD; | &#x02AD; |
| Latin Letter Bilabial Click | &amp;#x0298; | &#x0298; |
| Latin Letter Bilabial Percussive | &amp;#x02AC; | &#x02AC; |
| Latin Letter Bullseye | &amp;#x0298; | &#x0298; |
| Latin Letter Dental Click | &amp;#x01C0; | &#x01C0; |
| Latin Letter Exclamation Mark | &amp;#x01C3; | &#x01C3; |
| Latin Letter Glottal Stop | &amp;#x0294; | &#x0294; |
| Latin Letter Inverted Glottal Stop | &amp;#x0296; | &#x0296; |
| Latin Letter Lambda Bar | &amp;#x019B; | &#x019B; |
| Latin Letter Lateral Click | &amp;#x01C1; | &#x01C1; |
| Latin Letter Pharyngeal Voiced Fricative | &amp;#x0295; | &#x0295; |
| Latin Letter Retroflex Click | &amp;#x01C3; | &#x01C3; |
| Latin Letter Reversed Esh Loop | &amp;#x01AA; | &#x01AA; |
| Latin Letter Reversed Glottal Stop | &amp;#x0295; | &#x0295; |
| Latin Letter Stretched C | &amp;#x0297; | &#x0297; |
| Latin Letter Voiced Laryngeal Spirant | &amp;#x1D24; | &#x1D24; |
| Latin Letter Wynn | &amp;#x01BF; | &#x01BF; |
| Latin Letter Yr | &amp;#x01A6; | &#x01A6; |
| Latin Letters, Circled | &amp;#x24B6; | &#x24B6; |
| Latin Letters, Parenthesized | &amp;#x249C; | &#x249C; |
| Latin Letters, Phonetic Modifiers Derived From | &amp;#x02B0; | &#x02B0; |
| Latin Ligatures | &amp;#xFB00; | &#xFB00; |
| Latin Lowercase Alphabet | &amp;#x0061; | &#x0061; |
| Latin Small Letter Ae | &amp;#x00E6; | &#x00E6; |
| Latin Small Letter Alpha | &amp;#x0251; | &#x0251; |
| Latin Small Letter Baby Gamma | &amp;#x0264; | &#x0264; |
| Latin Small Letter Closed Epsilon | &amp;#x029A; | &#x029A; |
| Latin Small Letter Closed Omega | &amp;#x0277; | &#x0277; |
| Latin Small Letter Closed Reversed Epsilon | &amp;#x025E; | &#x025E; |
| Latin Small Letter Db Digraph | &amp;#x0238; | &#x0238; |
| Latin Small Letter Eng | &amp;#x014B; | &#x014B; |
| Latin Small Letter Epsilon | &amp;#x025B; | &#x025B; |
| Latin Small Letter Esh | &amp;#x0283; | &#x0283; |
| Latin Small Letter Eth | &amp;#x00F0; | &#x00F0; |
| Latin Small Letter Ezh | &amp;#x0292; | &#x0292; |
| Latin Small Letter Ezh Reversed | &amp;#x01B9; | &#x01B9; |
| Latin Small Letter Ezh With Caron | &amp;#x01EF; | &#x01EF; |
| Latin Small Letter Gamma | &amp;#x0263; | &#x0263; |
| Latin Small Letter Glottal Stop | &amp;#x0242; | &#x0242; |
| Latin Small Letter Hv | &amp;#x0195; | &#x0195; |
| Latin Small Letter Iota | &amp;#x0269; | &#x0269; |
| Latin Small Letter Kra | &amp;#x0138; | &#x0138; |
| Latin Small Letter Lezh | &amp;#x026E; | &#x026E; |
| Latin Small Letter Oi | &amp;#x01A3; | &#x01A3; |
| Latin Small Letter Ou | &amp;#x0223; | &#x0223; |
| Latin Small Letter Phi | &amp;#x0278; | &#x0278; |
| Latin Small Letter Qp Digraph | &amp;#x0239; | &#x0239; |
| Latin Small Letter Rams Horn | &amp;#x0264; | &#x0264; |
| Latin Small Letter Schwa | &amp;#x0259; | &#x0259; |
| Latin Small Letter Squat Reversed Esh | &amp;#x0285; | &#x0285; |
| Latin Small Letter Thorn | &amp;#x00FE; | &#x00FE; |
| Latin Small Letter Tone Six | &amp;#x0185; | &#x0185; |
| Latin Small Letter Turned Ae | &amp;#x1D02; | &#x1D02; |
| Latin Small Letter Turned Alpha | &amp;#x0252; | &#x0252; |
| Latin Small Letter Turned Delta | &amp;#x018D; | &#x018D; |
| Latin Small Letter Turned Oe | &amp;#x1D14; | &#x1D14; |
| Latin Small Letter Upsilon | &amp;#x028A; | &#x028A; |
| Latin Small Letter Yogh | &amp;#x021D; | &#x021D; |
| Latin Small Letters | &amp;#x0061; | &#x0061; |
| Latin Small Letters, Combining | &amp;#x0363; | &#x0363; |
| Latin Small Ligature Ae | &amp;#x00E6; | &#x00E6; |
| Latin Small Ligature Ij | &amp;#x0133; | &#x0133; |
| Latin Small Ligature Oe | &amp;#x0153; | &#x0153; |
| Latin Superscript Modifier Letters | &amp;#x02B0; | &#x02B0; |
| Latin Uppercase Alphabet | &amp;#x0041; | &#x0041; |
| Latin, Basic | &amp;#x0000; | &#x0000; |
| Latin, European | &amp;#x0100; | &#x0100; |
| Latin-1 Punctuation And Symbols | &amp;#x00A0; | &#x00A0; |
| Latin-1 Supplement | &amp;#x00A0; | &#x00A0; |
| Lazy S | &amp;#x223D; | &#x223D; |
| Lazy S, Inverted | &amp;#x223E; | &#x223E; |
| Leader, One Dot | &amp;#x2024; | &#x2024; |
| Leader, Three Dot | &amp;#x2026; | &#x2026; |
| Leader, Two Dot | &amp;#x2025; | &#x2025; |
| Leaf, Aldus | &amp;#x2766; | &#x2766; |
| Leaf, Ivy | &amp;#x2767; | &#x2767; |
| Left Abstract Syntax Bracket | &amp;#x301A; | &#x301A; |
| Left Angle Above, Combining | &amp;#x031A; | &#x031A; |
| Left Angle Below, Combining | &amp;#x0349; | &#x0349; |
| Left Angle Bracket | &amp;#x3008; | &#x3008; |
| Left Angle Bracket, Mathematical | &amp;#x27E8; | &#x27E8; |
| Left Arrow Above, Combining | &amp;#x20D6; | &#x20D6; |
| Left Arrow Below, Combining | &amp;#x20EE; | &#x20EE; |
| Left Arrowhead Below, Combining | &amp;#x0354; | &#x0354; |
| Left Bag Bracket | &amp;#x27E6; | &#x27E6; |
| Left Black Lenticular Bracket | &amp;#x3010; | &#x3010; |
| Left Ceiling | &amp;#x2308; | &#x2308; |
| Left Chevron Bracket | &amp;#x27EA; | &#x27EA; |
| Left Corner Bracket | &amp;#x300C; | &#x300C; |
| Left Curly Bracket | &amp;#x007B; | &#x007B; |
| Left Double Angle Bracket | &amp;#x300A; | &#x300A; |
| Left Double Angle Bracket, Mathematical | &amp;#x27EA; | &#x27EA; |
| Left Double Quotation Mark | &amp;#x201C; | &#x201C; |
| Left Floor | &amp;#x230A; | &#x230A; |
| Left Half Ring Above, Combining | &amp;#x0351; | &#x0351; |
| Left Half Ring Below, Combining | &amp;#x031C; | &#x031C; |
| Left Half Ring, Armenian Modifier Letter | &amp;#x0559; | &#x0559; |
| Left Half Ring, Modifier Letter | &amp;#x02BF; | &#x02BF; |
| Left Half Ring, Modifier Letter Centred | &amp;#x02D3; | &#x02D3; |
| Left Harpoon Above, Combining | &amp;#x20D0; | &#x20D0; |
| Left Hook, Latin Capital Letter N With | &amp;#x019D; | &#x019D; |
| Left Hook, Latin Small Letter N With | &amp;#x0272; | &#x0272; |
| Left Key, Delete To The | &amp;#x232B; | &#x232B; |
| Left Moustache | &amp;#x23B0; | &#x23B0; |
| Left Normal Factor Semidirect Product | &amp;#x22C9; | &#x22C9; |
| Left Parenthesis | &amp;#x0028; | &#x0028; |
| Left Parenthesis, Ornate | &amp;#xFD3E; | &#xFD3E; |
| Left Pointing Guillemet | &amp;#x00AB; | &#x00AB; |
| Left Pointing Index, Black | &amp;#x261A; | &#x261A; |
| Left Pointing Index, White | &amp;#x261C; | &#x261C; |
| Left Pointing Single Guillemet | &amp;#x2039; | &#x2039; |
| Left Right Arrow Above, Combining | &amp;#x20E1; | &#x20E1; |
| Left Right Arrow Below, Combining | &amp;#x034D; | &#x034D; |
| Left Semidirect Product | &amp;#x22CB; | &#x22CB; |
| Left Sequence Bracket | &amp;#x27E8; | &#x27E8; |
| Left Single Quotation Mark | &amp;#x2018; | &#x2018; |
| Left Square Bracket | &amp;#x005B; | &#x005B; |
| Left Square Bracket With Quill | &amp;#x2045; | &#x2045; |
| Left Tack | &amp;#x22A3; | &#x22A3; |
| Left Tack Below, Combining | &amp;#x0318; | &#x0318; |
| Left Tortoise Shell Bracket | &amp;#x3014; | &#x3014; |
| Left White Corner Bracket | &amp;#x300E; | &#x300E; |
| Left White Curly Bracket | &amp;#x2983; | &#x2983; |
| Left White Lenticular Bracket | &amp;#x3016; | &#x3016; |
| Left White Parenthesis | &amp;#x2985; | &#x2985; |
| Left White Square Bracket | &amp;#x301A; | &#x301A; |
| Left White Tortoise Shell Bracket | &amp;#x3018; | &#x3018; |
| Left, Erase To The | &amp;#x232B; | &#x232B; |
| Left, Fast Cursor | &amp;#x219E; | &#x219E; |
| Left-Pointing Angle Bracket | &amp;#x2329; | &#x2329; |
| Left-Pointing Angle Quotation Mark, Single | &amp;#x2039; | &#x2039; |
| Left-Pointing Double Angle Quotation Mark | &amp;#x00AB; | &#x00AB; |
| Left-To-Right Embedding | &amp;#x202A; | &#x202A; |
| Left-To-Right Mark | &amp;#x200E; | &#x200E; |
| Left-To-Right Override | &amp;#x202D; | &#x202D; |
| Leftward Tab | &amp;#x21E4; | &#x21E4; |
| Leftwards Arrow | &amp;#x2190; | &#x2190; |
| Leftwards Arrow Overlay, Combining | &amp;#x20EA; | &#x20EA; |
| Leftwards Bullet, Black | &amp;#x204C; | &#x204C; |
| Leftwards Harpoon With Barb Downwards, Combining | &amp;#x20ED; | &#x20ED; |
| Lenticular Bracket, Left Black | &amp;#x3010; | &#x3010; |
| Lenticular Bracket, Left White | &amp;#x3016; | &#x3016; |
| Lenticular Bracket, Right Black | &amp;#x3011; | &#x3011; |
| Lenticular Bracket, Right White | &amp;#x3017; | &#x3017; |
| Leo | &amp;#x264C; | &#x264C; |
| Lepcha | &amp;#x1C00; | &#x1C00; |
| Less-Than Or Equal To | &amp;#x2264; | &#x2264; |
| Less-Than Sign | &amp;#x003C; | &#x003C; |
| Less-Than, Much | &amp;#x226A; | &#x226A; |
| Less-Than, Very Much | &amp;#x22D8; | &#x22D8; |
| Letterlike Mathematical Symbols, Hebrew | &amp;#x2135; | &#x2135; |
| Letterlike Symbols | &amp;#x2100; | &#x2100; |
| Level 2 Lock | &amp;#x21EB; | &#x21EB; |
| Level 3 Lock | &amp;#x21EF; | &#x21EF; |
| Level 3 Select | &amp;#x21EE; | &#x21EE; |
| Lezh, Latin Small Letter | &amp;#x026E; | &#x026E; |
| Lgroup | &amp;#x27EE; | &#x27EE; |
| Libra | &amp;#x264E; | &#x264E; |
| Ligature Ae, Latin Capital | &amp;#x00C6; | &#x00C6; |
| Ligature Ae, Latin Small | &amp;#x00E6; | &#x00E6; |
| Ligature Ij, Latin Small | &amp;#x0133; | &#x0133; |
| Ligature Oe, Latin Small | &amp;#x0153; | &#x0153; |
| Ligature Tie | &amp;#x0361; | &#x0361; |
| Ligature Tie Below | &amp;#x035C; | &#x035C; |
| Ligatures, Arabic | &amp;#xFBEA; | &#xFBEA; |
| Ligatures, Armenian | &amp;#xFB13; | &#xFB13; |
| Ligatures, Latin | &amp;#xFB00; | &#xFB00; |
| Lightning | &amp;#x2607; | &#x2607; |
| Limbu | &amp;#x1900; | &#x1900; |
| Limbu Digits | &amp;#x1946; | &#x1946; |
| Limbu Exclamation Mark | &amp;#x1944; | &#x1944; |
| Limbu Question Mark | &amp;#x1945; | &#x1945; |
| Limbu Signs | &amp;#x1939; | &#x1939; |
| Limit, Approaches The | &amp;#x2250; | &#x2250; |
| Line Above, Combining Double Vertical | &amp;#x030E; | &#x030E; |
| Line Above, Combining Vertical | &amp;#x030D; | &#x030D; |
| Line Backward, Partial | &amp;#x008C; | &#x008C; |
| Line Below, Combining Double Vertical | &amp;#x0348; | &#x0348; |
| Line Below, Combining Vertical | &amp;#x0329; | &#x0329; |
| Line Feed | &amp;#x000A; | &#x000A; |
| Line Feed | &amp;#x21B4; | &#x21B4; |
| Line Feed, Reverse | &amp;#x008D; | &#x008D; |
| Line Feed, Symbol For | &amp;#x240A; | &#x240A; |
| Line Forward, Partial | &amp;#x008B; | &#x008B; |
| Line Marker | &amp;#x2319; | &#x2319; |
| Line Operators, Vertical | &amp;#x2AEE; | &#x2AEE; |
| Line Overlay, Combining Long Vertical | &amp;#x20D2; | &#x20D2; |
| Line Overlay, Combining Short Vertical | &amp;#x20D3; | &#x20D3; |
| Line Separator | &amp;#x2028; | &#x2028; |
| Line Symbol, Centre | &amp;#x2104; | &#x2104; |
| Line Tabulation | &amp;#x000B; | &#x000B; |
| Line Tabulation Set | &amp;#x008A; | &#x008A; |
| Line With Middle Dot, Vertical | &amp;#x237F; | &#x237F; |
| Line, Beginning Of | &amp;#x2310; | &#x2310; |
| Line, Centreline Low | &amp;#xFE4E; | &#xFE4E; |
| Line, Combining Double Low | &amp;#x0333; | &#x0333; |
| Line, Combining Low | &amp;#x0332; | &#x0332; |
| Line, Dashed Low | &amp;#xFE4D; | &#xFE4D; |
| Line, Double Low | &amp;#x2017; | &#x2017; |
| Line, Double Vertical | &amp;#x2016; | &#x2016; |
| Line, End Of | &amp;#x000A; | &#x000A; |
| Line, Low | &amp;#x005F; | &#x005F; |
| Line, Modifier Letter Low Vertical | &amp;#x02CC; | &#x02CC; |
| Line, Modifier Letter Vertical | &amp;#x02C8; | &#x02C8; |
| Line, New | &amp;#x000A; | &#x000A; |
| Line, Next | &amp;#x0085; | &#x0085; |
| Line, Property | &amp;#x214A; | &#x214A; |
| Line, Vertical | &amp;#x007C; | &#x007C; |
| Line, Wavy | &amp;#x2307; | &#x2307; |
| Line, Wavy Low | &amp;#xFE4F; | &#xFE4F; |
| Linear B Ideograms | &amp;#x10080; | &#x10080; |
| Linear B Syllabary | &amp;#x10000; | &#x10000; |
| Lines, Horizontal Scan | &amp;#x23BA; | &#x23BA; |
| Lines, Vertical | &amp;#x2223; | &#x2223; |
| Lira Sign | &amp;#x20A4; | &#x20A4; |
| Lira, Italian | &amp;#x00A3; | &#x00A3; |
| Lira, Turkish | &amp;#x00A3; | &#x00A3; |
| Liter | &amp;#x2113; | &#x2113; |
| Lock, Caps | &amp;#x21EA; | &#x21EA; |
| Lock, Caps | &amp;#x21EC; | &#x21EC; |
| Lock, Numerics | &amp;#x21ED; | &#x21ED; |
| Logic Operators, Modal | &amp;#x27D8; | &#x27D8; |
| Logic Operators, Modal | &amp;#x27E0; | &#x27E0; |
| Logical And | &amp;#x2227; | &#x2227; |
| Logical And, Curly | &amp;#x22CF; | &#x22CF; |
| Logical And, N-Ary | &amp;#x22C0; | &#x22C0; |
| Logical Ands And Ors | &amp;#x2A51; | &#x2A51; |
| Logical Or | &amp;#x2228; | &#x2228; |
| Logical Or, Curly | &amp;#x22CE; | &#x22CE; |
| Logical Or, N-Ary | &amp;#x22C1; | &#x22C1; |
| Long | &amp;#x0304; | &#x0304; |
| Long Arrows | &amp;#x27F5; | &#x27F5; |
| Long Division | &amp;#x27CC; | &#x27CC; |
| Long Double Slash Overlay | &amp;#x20EB; | &#x20EB; |
| Long S, Latin Small Letter | &amp;#x017F; | &#x017F; |
| Long Slash Overlay | &amp;#x0338; | &#x0338; |
| Long Solidus Overlay, Combining | &amp;#x0338; | &#x0338; |
| Long Stroke Overlay, Combining | &amp;#x0336; | &#x0336; |
| Long Vertical Line Overlay, Combining | &amp;#x20D2; | &#x20D2; |
| Lorraine, Cross Of | &amp;#x2628; | &#x2628; |
| Low Acute Accent, Modifier Letter | &amp;#x02CF; | &#x02CF; |
| Low Asterisk | &amp;#x204E; | &#x204E; |
| Low Double Comma Quotation Mark | &amp;#x201E; | &#x201E; |
| Low Double Prime Quotation Mark | &amp;#x301F; | &#x301F; |
| Low Grave Accent, Modifier Letter | &amp;#x02CE; | &#x02CE; |
| Low Line | &amp;#x005F; | &#x005F; |
| Low Line, Centreline | &amp;#xFE4E; | &#xFE4E; |
| Low Line, Combining | &amp;#x0332; | &#x0332; |
| Low Line, Combining Double | &amp;#x0333; | &#x0333; |
| Low Line, Dashed | &amp;#xFE4D; | &#xFE4D; |
| Low Line, Double | &amp;#x2017; | &#x2017; |
| Low Line, Wavy | &amp;#xFE4F; | &#xFE4F; |
| Low Macron, Modifier Letter | &amp;#x02CD; | &#x02CD; |
| Low Single Comma Quotation Mark | &amp;#x201A; | &#x201A; |
| Low Surrogates | &amp;#xDC00; | &#xDC00; |
| Low Vertical Line, Modifier Letter | &amp;#x02CC; | &#x02CC; |
| Low-9 Quotation Mark, Double | &amp;#x201E; | &#x201E; |
| Low-9 Quotation Mark, Single | &amp;#x201A; | &#x201A; |
| Lower Integral | &amp;#x2A1C; | &#x2A1C; |
| Lower Rank Than | &amp;#x227A; | &#x227A; |
| Lowercase Alphabet, Latin | &amp;#x0061; | &#x0061; |
| Lozenge | &amp;#x25CA; | &#x25CA; |
| Lozenge, Black | &amp;#x29EB; | &#x29EB; |
| Lozenge, Square | &amp;#x2311; | &#x2311; |
| Lunate Epsilon Symbol, Greek | &amp;#x03F5; | &#x03F5; |
| Lunate Epsilon Symbol, Greek Reversed | &amp;#x03F6; | &#x03F6; |
| Lunate Sigma Symbol, Greek | &amp;#x03F2; | &#x03F2; |
| Lycian | &amp;#x10280; | &#x10280; |
| Lydian | &amp;#x10920; | &#x10920; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## M

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| M With Acute, Latin Small Letter | &amp;#x1E3F; | &#x1E3F; |
| M With Dot Above, Latin Small Letter | &amp;#x1E41; | &#x1E41; |
| M With Dot Below, Latin Small Letter | &amp;#x1E43; | &#x1E43; |
| M With Hook, Latin Small Letter | &amp;#x0271; | &#x0271; |
| M With Long Leg, Latin Small Letter Turned | &amp;#x0270; | &#x0270; |
| M, Combining Latin Small Letter | &amp;#x036B; | &#x036B; |
| M, Latin Capital Letter Turned | &amp;#x019C; | &#x019C; |
| M, Latin Letter Small Capital | &amp;#x1D0D; | &#x1D0D; |
| M, Latin Small Letter Sideways Turned | &amp;#x1D1F; | &#x1D1F; |
| M, Latin Small Letter Turned | &amp;#x026F; | &#x026F; |
| M, Script Capital | &amp;#x2133; | &#x2133; |
| M-Matrix | &amp;#x2133; | &#x2133; |
| Maatham, Tamil | &amp;#x0BF4; | &#x0BF4; |
| Macron | &amp;#x00AF; | &#x00AF; |
| Macron Below, Combining | &amp;#x0331; | &#x0331; |
| Macron Below, Combining Double | &amp;#x035F; | &#x035F; |
| Macron Left Half, Combining | &amp;#xFE24; | &#xFE24; |
| Macron Right Half, Combining | &amp;#xFE25; | &#xFE25; |
| Macron, Combining | &amp;#x0304; | &#x0304; |
| Macron, Combining Double | &amp;#x035E; | &#x035E; |
| Macron, Modifier Letter | &amp;#x02C9; | &#x02C9; |
| Macron, Modifier Letter Low | &amp;#x02CD; | &#x02CD; |
| Macron, Spacing | &amp;#x00AF; | &#x00AF; |
| Mahjong Tiles | &amp;#x1F000; | &#x1F000; |
| Malayalam | &amp;#x0D00; | &#x0D00; |
| Malayalam Chandrakkala | &amp;#x0D4D; | &#x0D4D; |
| Malayalam Chillu Letters | &amp;#x0D7A; | &#x0D7A; |
| Malayalam Consonants | &amp;#x0D15; | &#x0D15; |
| Malayalam Dependent Vowel Signs | &amp;#x0D3E; | &#x0D3E; |
| Malayalam Digits | &amp;#x0D66; | &#x0D66; |
| Malayalam Independent Vowels | &amp;#x0D05; | &#x0D05; |
| Malayalam Sign Virama | &amp;#x0D4D; | &#x0D4D; |
| Malayalam Vowel Half-U | &amp;#x0D4D; | &#x0D4D; |
| Male Sign | &amp;#x2642; | &#x2642; |
| Maltese Cross | &amp;#x2720; | &#x2720; |
| Manchu Comma, Mongolian | &amp;#x1808; | &#x1808; |
| Manchu Full Stop, Mongolian | &amp;#x1809; | &#x1809; |
| Mandarin Chinese Fifth Or Neutral Tone | &amp;#x02D9; | &#x02D9; |
| Mandarin Chinese First Tone | &amp;#x02C9; | &#x02C9; |
| Mandarin Chinese Fourth Tone | &amp;#x02CB; | &#x02CB; |
| Mandarin Chinese Second Tone | &amp;#x02CA; | &#x02CA; |
| Mandarin Chinese Third Tone | &amp;#x02C7; | &#x02C7; |
| Map Symbols, Dictionary And | &amp;#x2690; | &#x2690; |
| Maplet | &amp;#x21A6; | &#x21A6; |
| Maps From | &amp;#x27FB; | &#x27FB; |
| Maps From | &amp;#x2906; | &#x2906; |
| Maps To | &amp;#x27FC; | &#x27FC; |
| Maps To | &amp;#x2905; | &#x2905; |
| Maps To | &amp;#x2907; | &#x2907; |
| Mark Pre-Wwii, German | &amp;#x2133; | &#x2133; |
| Marker, Histogram | &amp;#x25AE; | &#x25AE; |
| Marker, Line | &amp;#x2319; | &#x2319; |
| Markers, Go | &amp;#x2686; | &#x2686; |
| Marks, Combining Diacritical | &amp;#x0300; | &#x0300; |
| Marks, Combining Half | &amp;#xFE20; | &#xFE20; |
| Marriage Symbol | &amp;#x26AD; | &#x26AD; |
| Mars | &amp;#x2642; | &#x2642; |
| Masculine Ordinal Indicator | &amp;#x00BA; | &#x00BA; |
| Masu Mark | &amp;#x303C; | &#x303C; |
| Mathematical Alphanumeric Symbols | &amp;#x1D400; | &#x1D400; |
| Mathematical Brackets | &amp;#x27E6; | &#x27E6; |
| Mathematical Constant 3.141592... Pi | &amp;#x03C0; | &#x03C0; |
| Mathematical Digits Symbols | &amp;#x1D7CE; | &#x1D7CE; |
| Mathematical Operators | &amp;#x2200; | &#x2200; |
| Mathematical Operators, Dotted | &amp;#x2234; | &#x2234; |
| Mathematical Operators, Enclosed | &amp;#x2295; | &#x2295; |
| Mathematical Operators, Supplemental | &amp;#x2A00; | &#x2A00; |
| Mathematical Operators, Tilde | &amp;#x223B; | &#x223B; |
| Mathematical Space, Medium | &amp;#x205F; | &#x205F; |
| Mathematical Symbols | &amp;#x27C0; | &#x27C0; |
| Mathematical Symbols | &amp;#x2980; | &#x2980; |
| Mathematical Symbols, Black-Letter | &amp;#x1D504; | &#x1D504; |
| Mathematical Symbols, Bold Fraktur | &amp;#x1D56C; | &#x1D56C; |
| Mathematical Symbols, Bold Greek | &amp;#x1D6A8; | &#x1D6A8; |
| Mathematical Symbols, Bold Italic | &amp;#x1D468; | &#x1D468; |
| Mathematical Symbols, Bold Italic Greek | &amp;#x1D71C; | &#x1D71C; |
| Mathematical Symbols, Bold Script | &amp;#x1D4D0; | &#x1D4D0; |
| Mathematical Symbols, Dotless | &amp;#x1D6A4; | &#x1D6A4; |
| Mathematical Symbols, Double-Struck | &amp;#x1D538; | &#x1D538; |
| Mathematical Symbols, Fraktur | &amp;#x1D504; | &#x1D504; |
| Mathematical Symbols, Greek | &amp;#x1D6A8; | &#x1D6A8; |
| Mathematical Symbols, Hebrew Letterlike | &amp;#x2135; | &#x2135; |
| Mathematical Symbols, Italic | &amp;#x1D434; | &#x1D434; |
| Mathematical Symbols, Italic Greek | &amp;#x1D6E2; | &#x1D6E2; |
| Mathematical Symbols, Monospace | &amp;#x1D670; | &#x1D670; |
| Mathematical Symbols, Sans-Serif | &amp;#x1D5A0; | &#x1D5A0; |
| Mathematical Symbols, Sans-Serif Bold | &amp;#x1D5D4; | &#x1D5D4; |
| Mathematical Symbols, Sans-Serif Bold Greek | &amp;#x1D756; | &#x1D756; |
| Mathematical Symbols, Sans-Serif Bold Italic | &amp;#x1D63C; | &#x1D63C; |
| Mathematical Symbols, Sans-Serif Bold Italic Greek | &amp;#x1D790; | &#x1D790; |
| Mathematical Symbols, Sans-Serif Italic | &amp;#x1D608; | &#x1D608; |
| Mathematical Symbols, Script | &amp;#x1D49C; | &#x1D49C; |
| Mathematical Symbols-A, Miscellaneous | &amp;#x27C0; | &#x27C0; |
| Mathematical Symbols-B, Miscellaneous | &amp;#x2980; | &#x2980; |
| Matrix, Hermitian Conjugate | &amp;#x22B9; | &#x22B9; |
| Measured Angle | &amp;#x2221; | &#x2221; |
| Measured Angles, Angles And | &amp;#x299B; | &#x299B; |
| Measured By | &amp;#x225E; | &#x225E; |
| Med Avdrag Av | &amp;#x2052; | &#x2052; |
| Medieval Superscript Letter Diacritics | &amp;#x0363; | &#x0363; |
| Medieval Superscript Letter Diacritics, Latin | &amp;#x1DD3; | &#x1DD3; |
| Medievalist Punctuation | &amp;#x2E2A; | &#x2E2A; |
| Medium Black Circle | &amp;#x26AB; | &#x26AB; |
| Medium Mathematical Space | &amp;#x205F; | &#x205F; |
| Medium Small Square, Black | &amp;#x25FE; | &#x25FE; |
| Medium Small White Circle | &amp;#x26AC; | &#x26AC; |
| Medium Square, Black | &amp;#x25FC; | &#x25FC; |
| Medium White Circle | &amp;#x26AA; | &#x26AA; |
| Medium, End Of | &amp;#x0019; | &#x0019; |
| Medium, Symbol For End Of | &amp;#x2419; | &#x2419; |
| Member, Contains As | &amp;#x220B; | &#x220B; |
| Member, Does Not Contain As | &amp;#x220C; | &#x220C; |
| Member, Small Contains As | &amp;#x220D; | &#x220D; |
| Membership Signs, Set | &amp;#x2208; | &#x2208; |
| Membership, Z Notation Bag | &amp;#x22FF; | &#x22FF; |
| Mercury | &amp;#x263F; | &#x263F; |
| Merge | &amp;#x2A07; | &#x2A07; |
| Merpadi, Tamil | &amp;#x0BF8; | &#x0BF8; |
| Message Waiting | &amp;#x0095; | &#x0095; |
| Message, Privacy | &amp;#x009E; | &#x009E; |
| Metrical Symbols | &amp;#x23D1; | &#x23D1; |
| Mho | &amp;#x2127; | &#x2127; |
| Micro Sign | &amp;#x00B5; | &#x00B5; |
| Mid Space | &amp;#x2005; | &#x2005; |
| Middle Dot | &amp;#x00B7; | &#x00B7; |
| Middle Dot, Greek | &amp;#x00B7; | &#x00B7; |
| Middle Dot, Katakana | &amp;#x30FB; | &#x30FB; |
| Middle Dot, Latin Small Letter L With | &amp;#x0140; | &#x0140; |
| Middle Dot, Vertical Line With | &amp;#x237F; | &#x237F; |
| Middle Tilde, Latin Capital Letter O With | &amp;#x019F; | &#x019F; |
| Middle Tilde, Latin Small Letter L With | &amp;#x026B; | &#x026B; |
| Midline Horizontal Ellipsis | &amp;#x22EF; | &#x22EF; |
| Midpoint | &amp;#x00B7; | &#x00B7; |
| Mill Sign | &amp;#x20A5; | &#x20A5; |
| Mille Sign, Per | &amp;#x2030; | &#x2030; |
| Milreis | &amp;#x0024; | &#x0024; |
| Minim | &amp;#x264F; | &#x264F; |
| Minim Alternate Glyph | &amp;#x264D; | &#x264D; |
| Mining Symbol | &amp;#x2692; | &#x2692; |
| Minus Sign | &amp;#x2212; | &#x2212; |
| Minus Sign Below, Combining | &amp;#x0320; | &#x0320; |
| Minus Sign Operators, Plus And | &amp;#x2A22; | &#x2A22; |
| Minus Sign, Commercial | &amp;#x2052; | &#x2052; |
| Minus Sign, Hyphen Or | &amp;#x002D; | &#x002D; |
| Minus Sign, Modifier Letter | &amp;#x02D7; | &#x02D7; |
| Minus Tilde | &amp;#x2242; | &#x2242; |
| Minus, Circled | &amp;#x2296; | &#x2296; |
| Minus, Dot | &amp;#x2238; | &#x2238; |
| Minus, Set | &amp;#x2216; | &#x2216; |
| Minus, Squared | &amp;#x229F; | &#x229F; |
| Minus-Or-Plus Sign | &amp;#x2213; | &#x2213; |
| Minutes | &amp;#x2032; | &#x2032; |
| Miny | &amp;#x29FF; | &#x29FF; |
| Mkhedruli, Georgian | &amp;#x10D0; | &#x10D0; |
| Modal Logic Operators | &amp;#x27E0; | &#x27E0; |
| Models | &amp;#x22A7; | &#x22A7; |
| Modifier Letter Extensions | &amp;#x1D2C; | &#x1D2C; |
| Modifier Letters, Latin Superscript | &amp;#x02B0; | &#x02B0; |
| Modifier Letters, Spacing | &amp;#x02B0; | &#x02B0; |
| Modifier Tone Letters | &amp;#xA700; | &#xA700; |
| Modifiers Derived From Latin Letters, Phonetic | &amp;#x02B0; | &#x02B0; |
| Modifiers, Phonetic | &amp;#x02B9; | &#x02B9; |
| Modifiers, Upa | &amp;#x02EF; | &#x02EF; |
| Mongolian | &amp;#x1800; | &#x1800; |
| Mongolian Basic Letters | &amp;#x1820; | &#x1820; |
| Mongolian Birga | &amp;#x1800; | &#x1800; |
| Mongolian Colon | &amp;#x1804; | &#x1804; |
| Mongolian Comma | &amp;#x1802; | &#x1802; |
| Mongolian Currency | &amp;#x20AE; | &#x20AE; |
| Mongolian Digits | &amp;#x1810; | &#x1810; |
| Mongolian Ellipsis | &amp;#x1801; | &#x1801; |
| Mongolian Extensions | &amp;#x1843; | &#x1843; |
| Mongolian Format Controls | &amp;#x180B; | &#x180B; |
| Mongolian Four Dots | &amp;#x1805; | &#x1805; |
| Mongolian Free Variation Selector One | &amp;#x180B; | &#x180B; |
| Mongolian Free Variation Selector Three | &amp;#x180D; | &#x180D; |
| Mongolian Free Variation Selector Two | &amp;#x180C; | &#x180C; |
| Mongolian Full Stop | &amp;#x1803; | &#x1803; |
| Mongolian Manchu Comma | &amp;#x1808; | &#x1808; |
| Mongolian Manchu Full Stop | &amp;#x1809; | &#x1809; |
| Mongolian Nirugu | &amp;#x180A; | &#x180A; |
| Mongolian Punctuation | &amp;#x1800; | &#x1800; |
| Mongolian Sibe Syllable Boundary Marker | &amp;#x1807; | &#x1807; |
| Mongolian Todo Soft Hyphen | &amp;#x1806; | &#x1806; |
| Mongolian Vowel Separator | &amp;#x180E; | &#x180E; |
| Monogram And Digram Symbols, Yijing / I Ching | &amp;#x268A; | &#x268A; |
| Monospace Digits | &amp;#x1D7F6; | &#x1D7F6; |
| Monospace Mathematical Symbols | &amp;#x1D670; | &#x1D670; |
| Monostable Symbol | &amp;#x238D; | &#x238D; |
| Month Sign, Tamil | &amp;#x0BF4; | &#x0BF4; |
| Months, Enclosed Cjk Letters And | &amp;#x3200; | &#x3200; |
| Months, Ideographic Telegraph Symbols For | &amp;#x32C0; | &#x32C0; |
| Moon, First Quarter | &amp;#x263D; | &#x263D; |
| Moon, Last Quarter | &amp;#x263E; | &#x263E; |
| Most Positive | &amp;#x223E; | &#x223E; |
| Moustache, Left | &amp;#x23B0; | &#x23B0; |
| Moustache, Right | &amp;#x23B1; | &#x23B1; |
| Much Greater-Than | &amp;#x226B; | &#x226B; |
| Much Greater-Than, Very | &amp;#x22D9; | &#x22D9; |
| Much Less-Than | &amp;#x226A; | &#x226A; |
| Much Less-Than, Very | &amp;#x22D8; | &#x22D8; |
| Multimap | &amp;#x22B8; | &#x22B8; |
| Multiplication And Division Sign Operators | &amp;#x2A2F; | &#x2A2F; |
| Multiplication Sign | &amp;#x00D7; | &#x00D7; |
| Multiplication X | &amp;#x2715; | &#x2715; |
| Multiplication X, Heavy | &amp;#x2716; | &#x2716; |
| Multiplication, Multiset | &amp;#x228D; | &#x228D; |
| Multiset | &amp;#x228C; | &#x228C; |
| Multiset Multiplication | &amp;#x228D; | &#x228D; |
| Multiset Union | &amp;#x228E; | &#x228E; |
| Music Dingbats | &amp;#x2669; | &#x2669; |
| Music Flat Sign | &amp;#x266D; | &#x266D; |
| Music Natural Sign | &amp;#x266E; | &#x266E; |
| Music Sharp Sign | &amp;#x266F; | &#x266F; |
| Musical Notation, Ancient Greek | &amp;#x1D200; | &#x1D200; |
| Musical Symbols | &amp;#x1D100; | &#x1D100; |
| Musical Symbols, Balinese | &amp;#x1B61; | &#x1B61; |
| Musical Symbols, Basic | &amp;#x2669; | &#x2669; |
| Musical Symbols, Byzantine | &amp;#x1D000; | &#x1D000; |
| Mutton | &amp;#x2003; | &#x2003; |
| Mutton Quad | &amp;#x2001; | &#x2001; |
| Myanmar | &amp;#x1000; | &#x1000; |
| Myanmar Consonants | &amp;#x1000; | &#x1000; |
| Myanmar Dependent Vowel Signs | &amp;#x102C; | &#x102C; |
| Myanmar Digits | &amp;#x1040; | &#x1040; |
| Myanmar Independent Vowels | &amp;#x1021; | &#x1021; |
| Myanmar Killer | &amp;#x1039; | &#x1039; |
| Myanmar Sign Virama | &amp;#x1039; | &#x1039; |
| Myanmar Signs | &amp;#x1036; | &#x1036; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## N

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| N With Acute, Latin Small Letter | &amp;#x0144; | &#x0144; |
| N With Caron, Latin Small Letter | &amp;#x0148; | &#x0148; |
| N With Cedilla, Latin Small Letter | &amp;#x0146; | &#x0146; |
| N With Circumflex Below, Latin Small Letter | &amp;#x1E4B; | &#x1E4B; |
| N With Curl, Latin Small Letter | &amp;#x0235; | &#x0235; |
| N With Dot Above, Latin Small Letter | &amp;#x1E45; | &#x1E45; |
| N With Dot Below, Latin Small Letter | &amp;#x1E47; | &#x1E47; |
| N With Grave, Latin Small Letter | &amp;#x01F9; | &#x01F9; |
| N With Left Hook, Latin Capital Letter | &amp;#x019D; | &#x019D; |
| N With Left Hook, Latin Small Letter | &amp;#x0272; | &#x0272; |
| N With Line Below, Latin Small Letter | &amp;#x1E49; | &#x1E49; |
| N With Long Right Leg, Latin Capital Letter | &amp;#x0220; | &#x0220; |
| N With Long Right Leg, Latin Small Letter | &amp;#x019E; | &#x019E; |
| N With Retroflex Hook, Latin Small Letter | &amp;#x0273; | &#x0273; |
| N With Tilde, Latin Capital Letter | &amp;#x00D1; | &#x00D1; |
| N With Tilde, Latin Small Letter | &amp;#x00F1; | &#x00F1; |
| N, Double-Struck Capital | &amp;#x2115; | &#x2115; |
| N, Latin Letter Small Capital | &amp;#x0274; | &#x0274; |
| N, Latin Letter Small Capital Reversed | &amp;#x1D0E; | &#x1D0E; |
| N-Ary Coproduct | &amp;#x2210; | &#x2210; |
| N-Ary Dijkstra Choice | &amp;#x2AFF; | &#x2AFF; |
| N-Ary Intersection | &amp;#x22C2; | &#x22C2; |
| N-Ary Logical And | &amp;#x22C0; | &#x22C0; |
| N-Ary Logical Or | &amp;#x22C1; | &#x22C1; |
| N-Ary Operators | &amp;#x22C0; | &#x22C0; |
| N-Ary Operators | &amp;#x2A00; | &#x2A00; |
| N-Ary Product | &amp;#x220F; | &#x220F; |
| N-Ary Summation | &amp;#x2211; | &#x2211; |
| N-Ary Summation, Double-Struck | &amp;#x2140; | &#x2140; |
| N-Ary Times Operator | &amp;#x2A09; | &#x2A09; |
| N-Ary Union | &amp;#x22C3; | &#x22C3; |
| N-Ary White Vertical Bar | &amp;#x2AFF; | &#x2AFF; |
| Naal, Tamil | &amp;#x0BF3; | &#x0BF3; |
| Nabla | &amp;#x2207; | &#x2207; |
| Naira Sign | &amp;#x20A6; | &#x20A6; |
| Nand | &amp;#x22BC; | &#x22BC; |
| Narrow No-Break Space | &amp;#x202F; | &#x202F; |
| Nasal Hook | &amp;#x0328; | &#x0328; |
| Natural Exponent | &amp;#x212F; | &#x212F; |
| Natural Number | &amp;#x2115; | &#x2115; |
| Natural Sign, Music | &amp;#x266E; | &#x266E; |
| Nbsp | &amp;#x00A0; | &#x00A0; |
| Nearly Equals | &amp;#x2252; | &#x2252; |
| Necessarily Satisfies | &amp;#x2AF1; | &#x2AF1; |
| Negative Acknowledge | &amp;#x0015; | &#x0015; |
| Negative Acknowledge, Symbol For | &amp;#x2415; | &#x2415; |
| Nel | &amp;#x0085; | &#x0085; |
| Neptune | &amp;#x2646; | &#x2646; |
| Neuter | &amp;#x26B2; | &#x26B2; |
| Neutral Quotation Mark | &amp;#x0022; | &#x0022; |
| Neutral Single Quotation Mark | &amp;#x0027; | &#x0027; |
| Neutral Tone, Mandarin Chinese Fifth Or | &amp;#x02D9; | &#x02D9; |
| New Line | &amp;#x000A; | &#x000A; |
| New Sheqel Sign | &amp;#x20AA; | &#x20AA; |
| New Tai Lue | &amp;#x1980; | &#x1980; |
| New Tai Lue Digits | &amp;#x19D0; | &#x19D0; |
| New Testament Editorial Symbols | &amp;#x2E00; | &#x2E00; |
| New Testament Majority Text | &amp;#x1D510; | &#x1D510; |
| Newline, Symbol For | &amp;#x2424; | &#x2424; |
| Next Line | &amp;#x0085; | &#x0085; |
| Next Page | &amp;#x2398; | &#x2398; |
| Nib, Black | &amp;#x2712; | &#x2712; |
| Nib, White | &amp;#x2711; | &#x2711; |
| Nigerian Currency | &amp;#x20A6; | &#x20A6; |
| Niggahita, Lao | &amp;#x0ECD; | &#x0ECD; |
| Nikahit, Khmer Sign | &amp;#x17C6; | &#x17C6; |
| Nikhahit, Thai Character | &amp;#x0E4D; | &#x0E4D; |
| Nim-Addition | &amp;#x2A27; | &#x2A27; |
| Nirugu, Mongolian | &amp;#x180A; | &#x180A; |
| Nko | &amp;#x07C0; | &#x07C0; |
| Nl | &amp;#x000A; | &#x000A; |
| No | &amp;#x20E0; | &#x20E0; |
| No Break Here | &amp;#x0083; | &#x0083; |
| No Break Space, Keyboard Symbol For | &amp;#x237D; | &#x237D; |
| No-Break Space | &amp;#x00A0; | &#x00A0; |
| No-Break Space, Narrow | &amp;#x202F; | &#x202F; |
| No-Break Space, Zero Width | &amp;#xFEFF; | &#xFEFF; |
| Node, Ascending | &amp;#x260A; | &#x260A; |
| Node, Descending | &amp;#x260B; | &#x260B; |
| Non-Breaking Hyphen | &amp;#x2011; | &#x2011; |
| Non-Breaking Space | &amp;#x00A0; | &#x00A0; |
| Non-Joiner, Zero Width | &amp;#x200C; | &#x200C; |
| Non-Spacing Iota Below, Greek | &amp;#x0345; | &#x0345; |
| Non-Theorem | &amp;#x22A3; | &#x22A3; |
| Nor | &amp;#x22BD; | &#x22BD; |
| Normal Factor Semidirect Product, Left | &amp;#x22C9; | &#x22C9; |
| Normal Factor Semidirect Product, Right | &amp;#x22CA; | &#x22CA; |
| Normal Subgroup Of | &amp;#x22B2; | &#x22B2; |
| Normal Subgroup Signs | &amp;#x22EA; | &#x22EA; |
| Normal Subgroup, Contains As | &amp;#x22B3; | &#x22B3; |
| Not | &amp;#x223C; | &#x223C; |
| Not A Subset Of | &amp;#x2284; | &#x2284; |
| Not A Superset Of | &amp;#x2285; | &#x2285; |
| Not Almost Equal To | &amp;#x2249; | &#x2249; |
| Not An Element Of | &amp;#x2209; | &#x2209; |
| Not Asymptotically Equal To | &amp;#x2244; | &#x2244; |
| Not Check Mark | &amp;#x237B; | &#x237B; |
| Not Equal To | &amp;#x2260; | &#x2260; |
| Not Identical To | &amp;#x2262; | &#x2262; |
| Not Independent | &amp;#x2ADC; | &#x2ADC; |
| Not Parallel To | &amp;#x2226; | &#x2226; |
| Not Sign | &amp;#x00AC; | &#x00AC; |
| Not Sign, Reversed | &amp;#x2310; | &#x2310; |
| Not Sign, Turned | &amp;#x2319; | &#x2319; |
| Not Tilde | &amp;#x2241; | &#x2241; |
| Not Tilde Above, Combining | &amp;#x034A; | &#x034A; |
| Not Yield, Does | &amp;#x22A3; | &#x22A3; |
| Note, Eighth | &amp;#x266A; | &#x266A; |
| Note, Quarter | &amp;#x2669; | &#x2669; |
| Notes, Beamed Eighth | &amp;#x266B; | &#x266B; |
| Notes, Beamed Sixteenth | &amp;#x266C; | &#x266C; |
| Nukta, Devanagari Sign | &amp;#x093C; | &#x093C; |
| Null | &amp;#x0000; | &#x0000; |
| Null Set | &amp;#x2205; | &#x2205; |
| Null, Symbol For | &amp;#x2400; | &#x2400; |
| Number Forms | &amp;#x2150; | &#x2150; |
| Number Sign | &amp;#x0023; | &#x0023; |
| Number Sign, Tamil | &amp;#x0BFA; | &#x0BFA; |
| Number Symbol, Real | &amp;#x210A; | &#x210A; |
| Number Zero, Ideographic | &amp;#x3007; | &#x3007; |
| Number, Natural | &amp;#x2115; | &#x2115; |
| Numbers And Punctuation, Cuneiform | &amp;#x12400; | &#x12400; |
| Numbers Followed By Period | &amp;#x2488; | &#x2488; |
| Numbers, Ancient Greek | &amp;#x10140; | &#x10140; |
| Numbers, Circled | &amp;#x2460; | &#x2460; |
| Numbers, Circled | &amp;#x3251; | &#x3251; |
| Numbers, Circled | &amp;#x32B1; | &#x32B1; |
| Numbers, Circled Inverse | &amp;#x2776; | &#x2776; |
| Numbers, Complex | &amp;#x2102; | &#x2102; |
| Numbers, Double Circled | &amp;#x24F5; | &#x24F5; |
| Numbers, Ethiopic | &amp;#x1369; | &#x1369; |
| Numbers, Parenthesized | &amp;#x2474; | &#x2474; |
| Numbers, Rational | &amp;#x211A; | &#x211A; |
| Numbers, Real | &amp;#x211D; | &#x211D; |
| Numbers, Runic Golden | &amp;#x16EE; | &#x16EE; |
| Numbers, Tamil | &amp;#x0BE7; | &#x0BE7; |
| Numbers, White On Black Circled | &amp;#x24EB; | &#x24EB; |
| Numerals, Hangzhou | &amp;#x3021; | &#x3021; |
| Numerals, Old Italic | &amp;#x10320; | &#x10320; |
| Numerals, Roman | &amp;#x2160; | &#x2160; |
| Numerals, Suzhou | &amp;#x3021; | &#x3021; |
| Numerator One, Fraction | &amp;#x215F; | &#x215F; |
| Numeric Symbols For Divination, Khmer | &amp;#x17F0; | &#x17F0; |
| Numerics Lock | &amp;#x21ED; | &#x21ED; |
| Numero Sign | &amp;#x2116; | &#x2116; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## O

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| O Bar, Latin Capital Letter | &amp;#x019F; | &#x019F; |
| O Bar, Latin Small Letter | &amp;#x0275; | &#x0275; |
| O E, Latin Small Letter | &amp;#x0153; | &#x0153; |
| O Slash, Latin Capital Letter | &amp;#x00D8; | &#x00D8; |
| O Slash, Latin Small Letter | &amp;#x00F8; | &#x00F8; |
| O With Acute, Latin Capital Letter | &amp;#x00D3; | &#x00D3; |
| O With Acute, Latin Small Letter | &amp;#x00F3; | &#x00F3; |
| O With Breve, Latin Small Letter | &amp;#x014F; | &#x014F; |
| O With Caron, Latin Small Letter | &amp;#x01D2; | &#x01D2; |
| O With Circumflex, Latin Capital Letter | &amp;#x00D4; | &#x00D4; |
| O With Circumflex, Latin Small Letter | &amp;#x00F4; | &#x00F4; |
| O With Diaeresis, Latin Capital Letter | &amp;#x00D6; | &#x00D6; |
| O With Diaeresis, Latin Small Letter | &amp;#x00F6; | &#x00F6; |
| O With Dot Above, Latin Small Letter | &amp;#x022F; | &#x022F; |
| O With Dot Below, Latin Small Letter | &amp;#x1ECD; | &#x1ECD; |
| O With Double Acute, Latin Small Letter | &amp;#x0151; | &#x0151; |
| O With Double Grave, Latin Small Letter | &amp;#x020D; | &#x020D; |
| O With Grave, Latin Capital Letter | &amp;#x00D2; | &#x00D2; |
| O With Grave, Latin Small Letter | &amp;#x00F2; | &#x00F2; |
| O With Hook Above, Latin Small Letter | &amp;#x1ECF; | &#x1ECF; |
| O With Horn, Latin Small Letter | &amp;#x01A1; | &#x01A1; |
| O With Inverted Breve, Latin Small Letter | &amp;#x020F; | &#x020F; |
| O With Macron, Latin Small Letter | &amp;#x014D; | &#x014D; |
| O With Middle Tilde, Latin Capital Letter | &amp;#x019F; | &#x019F; |
| O With Ogonek, Latin Small Letter | &amp;#x01EB; | &#x01EB; |
| O With Stroke, Latin Capital Letter | &amp;#x00D8; | &#x00D8; |
| O With Stroke, Latin Small Letter | &amp;#x00F8; | &#x00F8; |
| O With Stroke, Latin Small Letter Sideways | &amp;#x1D13; | &#x1D13; |
| O With Tilde, Latin Capital Letter | &amp;#x00D5; | &#x00D5; |
| O With Tilde, Latin Small Letter | &amp;#x00F5; | &#x00F5; |
| O, Combining Latin Small Letter | &amp;#x0366; | &#x0366; |
| O, Latin Capital Letter Barred | &amp;#x019F; | &#x019F; |
| O, Latin Capital Letter Open | &amp;#x0186; | &#x0186; |
| O, Latin Letter Small Capital | &amp;#x1D0F; | &#x1D0F; |
| O, Latin Letter Small Capital Open | &amp;#x1D10; | &#x1D10; |
| O, Latin Small Letter Barred | &amp;#x0275; | &#x0275; |
| O, Latin Small Letter Bottom Half | &amp;#x1D17; | &#x1D17; |
| O, Latin Small Letter Open | &amp;#x0254; | &#x0254; |
| O, Latin Small Letter Sideways | &amp;#x1D11; | &#x1D11; |
| O, Latin Small Letter Sideways Open | &amp;#x1D12; | &#x1D12; |
| O, Latin Small Letter Top Half | &amp;#x1D16; | &#x1D16; |
| O, Script Small | &amp;#x2134; | &#x2134; |
| Object Replacement Character | &amp;#xFFFC; | &#xFFFC; |
| Octothorpe | &amp;#x0023; | &#x0023; |
| Oe, Latin Letter Small Capital | &amp;#x0276; | &#x0276; |
| Oe, Latin Small Letter Turned | &amp;#x1D14; | &#x1D14; |
| Oe, Latin Small Ligature | &amp;#x0153; | &#x0153; |
| Ogham | &amp;#x1680; | &#x1680; |
| Ogham Forfeda Supplement | &amp;#x1695; | &#x1695; |
| Ogham Punctuation | &amp;#x169B; | &#x169B; |
| Ogham Space Mark | &amp;#x1680; | &#x1680; |
| Ogham Traditional Letters | &amp;#x1681; | &#x1681; |
| Ogonek | &amp;#x02DB; | &#x02DB; |
| Ogonek, Combining | &amp;#x0328; | &#x0328; |
| Ohm Sign | &amp;#x2126; | &#x2126; |
| Ohm Sign, Inverted | &amp;#x2127; | &#x2127; |
| Oi, Latin Small Letter | &amp;#x01A3; | &#x01A3; |
| Ol Chiki | &amp;#x1C50; | &#x1C50; |
| Old Italic | &amp;#x10300; | &#x10300; |
| Old Persian | &amp;#x103A0; | &#x103A0; |
| Old Testament, Greek | &amp;#x1D516; | &#x1D516; |
| Om, Devanagari | &amp;#x0950; | &#x0950; |
| Om, Tibetan Syllable | &amp;#x0F00; | &#x0F00; |
| Omega Pi | &amp;#x03D6; | &#x03D6; |
| Omega, Latin Small Letter Closed | &amp;#x0277; | &#x0277; |
| One Dot Leader | &amp;#x2024; | &#x2024; |
| One Half, Vulgar Fraction | &amp;#x00BD; | &#x00BD; |
| One Quarter, Vulgar Fraction | &amp;#x00BC; | &#x00BC; |
| One, Fraction Numerator | &amp;#x215F; | &#x215F; |
| One, Superscript | &amp;#x00B9; | &#x00B9; |
| Open Box | &amp;#x2423; | &#x2423; |
| Open Box, Shouldered | &amp;#x237D; | &#x237D; |
| Open E With Hook, Latin Small Letter Reversed | &amp;#x025D; | &#x025D; |
| Open E, Latin Capital Letter | &amp;#x0190; | &#x0190; |
| Open E, Latin Small Letter | &amp;#x025B; | &#x025B; |
| Open E, Latin Small Letter Closed | &amp;#x029A; | &#x029A; |
| Open E, Latin Small Letter Closed Reversed | &amp;#x025E; | &#x025E; |
| Open E, Latin Small Letter Reversed | &amp;#x025C; | &#x025C; |
| Open E, Latin Small Letter Turned | &amp;#x1D08; | &#x1D08; |
| Open O, Latin Capital Letter | &amp;#x0186; | &#x0186; |
| Open O, Latin Letter Small Capital | &amp;#x1D10; | &#x1D10; |
| Open O, Latin Small Letter | &amp;#x0254; | &#x0254; |
| Open O, Latin Small Letter Sideways | &amp;#x1D12; | &#x1D12; |
| Opening Brace | &amp;#x007B; | &#x007B; |
| Opening Curly Bracket | &amp;#x007B; | &#x007B; |
| Opening Parenthesis | &amp;#x0028; | &#x0028; |
| Opening Square Bracket | &amp;#x005B; | &#x005B; |
| Operating System Command | &amp;#x009D; | &#x009D; |
| Operators Supplement, Mathematical | &amp;#x2A00; | &#x2A00; |
| Operators, Database Theory | &amp;#x27D5; | &#x27D5; |
| Operators, Dotted Mathematical | &amp;#x2234; | &#x2234; |
| Operators, Double | &amp;#x22D0; | &#x22D0; |
| Operators, Enclosed Mathematical | &amp;#x2295; | &#x2295; |
| Operators, Invisible | &amp;#x2061; | &#x2061; |
| Operators, Large | &amp;#x29F8; | &#x29F8; |
| Operators, Mathematical | &amp;#x2200; | &#x2200; |
| Operators, Modal Logic | &amp;#x27E0; | &#x27E0; |
| Operators, Multiplication And Division Sign | &amp;#x2A2F; | &#x2A2F; |
| Operators, N-Ary | &amp;#x22C0; | &#x22C0; |
| Operators, N-Ary | &amp;#x2A00; | &#x2A00; |
| Operators, Plus And Minus Sign | &amp;#x2A22; | &#x2A22; |
| Operators, Relational | &amp;#x29E3; | &#x29E3; |
| Operators, Specialized Plus Sign | &amp;#x29FA; | &#x29FA; |
| Operators, Supplemental Mathematical | &amp;#x2A00; | &#x2A00; |
| Operators, Tilde Mathematical | &amp;#x223B; | &#x223B; |
| Operators, Vertical Line | &amp;#x2AEE; | &#x2AEE; |
| Opposition | &amp;#x260D; | &#x260D; |
| Optical Character Recognition, Ocr | &amp;#x2440; | &#x2440; |
| Option Key | &amp;#x2325; | &#x2325; |
| Or, Curly Logical | &amp;#x22CE; | &#x22CE; |
| Or, Double Logical | &amp;#x2A54; | &#x2A54; |
| Or, Logical | &amp;#x2228; | &#x2228; |
| Or, N-Ary Logical | &amp;#x22C1; | &#x22C1; |
| Order | &amp;#x2134; | &#x2134; |
| Order Relation Precedence Signs | &amp;#x227A; | &#x227A; |
| Order Relation Precedence Signs | &amp;#x22DE; | &#x22DE; |
| Ordinal Indicator, Feminine | &amp;#x00AA; | &#x00AA; |
| Ordinal Indicator, Masculine | &amp;#x00BA; | &#x00BA; |
| Ordinarily Satisfies | &amp;#x2AE2; | &#x2AE2; |
| Ordinary Diacritics | &amp;#x0300; | &#x0300; |
| Origin, Dimension | &amp;#x2331; | &#x2331; |
| Original Of | &amp;#x22B6; | &#x22B6; |
| Original Of, Square | &amp;#x2290; | &#x2290; |
| Oriya | &amp;#x0B00; | &#x0B00; |
| Oriya Consonants | &amp;#x0B15; | &#x0B15; |
| Oriya Dependent Vowel Signs | &amp;#x0B3E; | &#x0B3E; |
| Oriya Digits | &amp;#x0B66; | &#x0B66; |
| Oriya Independent Vowels | &amp;#x0B05; | &#x0B05; |
| Oriya Isshar | &amp;#x0B70; | &#x0B70; |
| Ornamental Angle Quotation Marks | &amp;#x276E; | &#x276E; |
| Ornamental Brackets | &amp;#x2768; | &#x2768; |
| Ornaments, Heart | &amp;#x2763; | &#x2763; |
| Ornaments, Punctuation | &amp;#x275B; | &#x275B; |
| Ornaments, Quotation Mark | &amp;#x275B; | &#x275B; |
| Ornate Left Parenthesis | &amp;#xFD3E; | &#xFD3E; |
| Ornate Right Parenthesis | &amp;#xFD3F; | &#xFD3F; |
| Ors, Logical Ands And | &amp;#x2A51; | &#x2A51; |
| Orthodox Cross | &amp;#x2626; | &#x2626; |
| Orthogonal To | &amp;#x22A5; | &#x22A5; |
| Osmanya | &amp;#x10480; | &#x10480; |
| Osmanya Digits | &amp;#x104A0; | &#x104A0; |
| Ou, Latin Letter Small Capital | &amp;#x1D15; | &#x1D15; |
| Ou, Latin Small Letter | &amp;#x0223; | &#x0223; |
| Ounce Sign | &amp;#x2125; | &#x2125; |
| Overbar, Apl | &amp;#x00AF; | &#x00AF; |
| Overlay, Combining Anticlockwise Ring | &amp;#x20DA; | &#x20DA; |
| Overlay, Combining Clockwise Ring | &amp;#x20D9; | &#x20D9; |
| Overlay, Combining Counterclockwise Ring | &amp;#x20DA; | &#x20DA; |
| Overlay, Combining Double Vertical Stroke | &amp;#x20E6; | &#x20E6; |
| Overlay, Combining Leftwards Arrow | &amp;#x20EA; | &#x20EA; |
| Overlay, Combining Long Double Solidus | &amp;#x20EB; | &#x20EB; |
| Overlay, Combining Long Solidus | &amp;#x0338; | &#x0338; |
| Overlay, Combining Long Stroke | &amp;#x0336; | &#x0336; |
| Overlay, Combining Long Vertical Line | &amp;#x20D2; | &#x20D2; |
| Overlay, Combining Reverse Solidus | &amp;#x20E5; | &#x20E5; |
| Overlay, Combining Ring | &amp;#x20D8; | &#x20D8; |
| Overlay, Combining Short Solidus | &amp;#x0337; | &#x0337; |
| Overlay, Combining Short Stroke | &amp;#x0335; | &#x0335; |
| Overlay, Combining Short Vertical Line | &amp;#x20D3; | &#x20D3; |
| Overlay, Combining Tilde | &amp;#x0334; | &#x0334; |
| Overlay, Long Double Slash | &amp;#x20EB; | &#x20EB; |
| Overlay, Long Slash | &amp;#x0338; | &#x0338; |
| Overlay, Short Slash | &amp;#x0337; | &#x0337; |
| Overline | &amp;#x00AF; | &#x00AF; |
| Overline | &amp;#x203E; | &#x203E; |
| Overline, Centreline | &amp;#xFE4A; | &#xFE4A; |
| Overline, Combining | &amp;#x0305; | &#x0305; |
| Overline, Combining Double | &amp;#x033F; | &#x033F; |
| Overline, Dashed | &amp;#xFE49; | &#xFE49; |
| Overline, Double Wavy | &amp;#xFE4C; | &#xFE4C; |
| Overline, Wavy | &amp;#xFE4B; | &#xFE4B; |
| Override, Left-To-Right | &amp;#x202D; | &#x202D; |
| Override, Right-To-Left | &amp;#x202E; | &#x202E; |
| Overscore | &amp;#x0305; | &#x0305; |
| Overscore, Spacing | &amp;#x203E; | &#x203E; |
| Overscores And Underscores | &amp;#xFE49; | &#xFE49; |
| Overstruck Diacritics | &amp;#x0334; | &#x0334; |
| Oxia, Greek | &amp;#x0301; | &#x0301; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## P

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| P With Acute, Latin Small Letter | &amp;#x1E55; | &#x1E55; |
| P With Dot Above, Latin Small Letter | &amp;#x1E57; | &#x1E57; |
| P With Hook, Latin Small Letter | &amp;#x01A5; | &#x01A5; |
| P, Double-Struck Capital | &amp;#x2119; | &#x2119; |
| P, Latin Letter Small Capital | &amp;#x1D18; | &#x1D18; |
| P, Script Capital | &amp;#x2118; | &#x2118; |
| Page Down | &amp;#x21DF; | &#x21DF; |
| Page Up | &amp;#x21DE; | &#x21DE; |
| Page, Next | &amp;#x2398; | &#x2398; |
| Page, Previous | &amp;#x2397; | &#x2397; |
| Palatal Hook, Latin Small Letter T With | &amp;#x01AB; | &#x01AB; |
| Palatalized Hook Below, Combining | &amp;#x0321; | &#x0321; |
| Palm Branch | &amp;#x2E19; | &#x2E19; |
| Paluta, Tibetan Mark | &amp;#x0F85; | &#x0F85; |
| Pamudpod, Hanunoo Sign | &amp;#x1734; | &#x1734; |
| Paper Sign, Permanent | &amp;#x267E; | &#x267E; |
| Paper Symbol, Partially-Recycled | &amp;#x267D; | &#x267D; |
| Paper Symbol, Recycled | &amp;#x267C; | &#x267C; |
| Papyrological Hyphen | &amp;#x035C; | &#x035C; |
| Paragraph Separator | &amp;#x2029; | &#x2029; |
| Paragraph Separator, Ethiopic | &amp;#x1368; | &#x1368; |
| Paragraph Separator, Georgian | &amp;#x10FB; | &#x10FB; |
| Paragraph Separator, Urdu | &amp;#x203B; | &#x203B; |
| Paragraph Sign | &amp;#x00B6; | &#x00B6; |
| Paragraph Sign Ornament, Curved Stem | &amp;#x2761; | &#x2761; |
| Paragraph Sign, European | &amp;#x00A7; | &#x00A7; |
| Paraguayan Currency | &amp;#x20B2; | &#x20B2; |
| Parallel To | &amp;#x2225; | &#x2225; |
| Parallel To, Not | &amp;#x2226; | &#x2226; |
| Parallelogram, Black | &amp;#x25B0; | &#x25B0; |
| Parenthesis, Closing | &amp;#x0029; | &#x0029; |
| Parenthesis, Left | &amp;#x0028; | &#x0028; |
| Parenthesis, Left White | &amp;#x2985; | &#x2985; |
| Parenthesis, Opening | &amp;#x0028; | &#x0028; |
| Parenthesis, Ornate Left | &amp;#xFD3E; | &#xFD3E; |
| Parenthesis, Ornate Right | &amp;#xFD3F; | &#xFD3F; |
| Parenthesis, Right | &amp;#x0029; | &#x0029; |
| Parenthesis, Right White | &amp;#x2986; | &#x2986; |
| Parenthesized Cjk Ideographs | &amp;#x3220; | &#x3220; |
| Parenthesized Korean Hangul Elements | &amp;#x3200; | &#x3200; |
| Parenthesized Korean Hangul Syllables | &amp;#x320E; | &#x320E; |
| Parenthesized Latin Letters | &amp;#x249C; | &#x249C; |
| Parenthesized Numbers | &amp;#x2474; | &#x2474; |
| Parted Rule | &amp;#x00A6; | &#x00A6; |
| Partial Differential | &amp;#x2202; | &#x2202; |
| Partial Function | &amp;#x21F8; | &#x21F8; |
| Partial Injection | &amp;#x2914; | &#x2914; |
| Partial Line Backward | &amp;#x008C; | &#x008C; |
| Partial Line Forward | &amp;#x008B; | &#x008B; |
| Partial Relation | &amp;#x21F9; | &#x21F9; |
| Partial Surjection | &amp;#x2900; | &#x2900; |
| Partially-Recycled Paper Symbol | &amp;#x267D; | &#x267D; |
| Partnership Symbol, Unmarried | &amp;#x26AF; | &#x26AF; |
| Patiw, Armenian | &amp;#x055F; | &#x055F; |
| Patru, Tamil | &amp;#x0BF6; | &#x0BF6; |
| Pause | &amp;#x2389; | &#x2389; |
| Pdf | &amp;#x202C; | &#x202C; |
| Peace Symbol | &amp;#x262E; | &#x262E; |
| Pencil | &amp;#x270F; | &#x270F; |
| Pencil Dingbats | &amp;#x270E; | &#x270E; |
| Pencil, Lower Right | &amp;#x270E; | &#x270E; |
| Pencil, Upper Right | &amp;#x2710; | &#x2710; |
| Penny Sign, German | &amp;#x20B0; | &#x20B0; |
| Pentonkion, Greek | &amp;#x2059; | &#x2059; |
| Per Mille Sign | &amp;#x2030; | &#x2030; |
| Per Sign | &amp;#x214C; | &#x214C; |
| Per Ten Thousand Sign | &amp;#x2031; | &#x2031; |
| Per Thousand | &amp;#x2030; | &#x2030; |
| Percent Sign | &amp;#x0025; | &#x0025; |
| Percussive, Latin Letter Bidental | &amp;#x02AD; | &#x02AD; |
| Percussive, Latin Letter Bilabial | &amp;#x02AC; | &#x02AC; |
| Period | &amp;#x002E; | &#x002E; |
| Period, Numbers Followed By | &amp;#x2488; | &#x2488; |
| Perispomeni, Combining Greek | &amp;#x0342; | &#x0342; |
| Permanent Paper Sign | &amp;#x267E; | &#x267E; |
| Perpendicular | &amp;#x22A5; | &#x22A5; |
| Persian, Old | &amp;#x103A0; | &#x103A0; |
| Perspective | &amp;#x2306; | &#x2306; |
| Peseta Sign | &amp;#x20A7; | &#x20A7; |
| Peso Sign | &amp;#x20B1; | &#x20B1; |
| Phags-Pa | &amp;#xA840; | &#xA840; |
| Phaistos Disc | &amp;#x101D0; | &#x101D0; |
| Pharyngeal Voiced Fricative, Latin Letter | &amp;#x0295; | &#x0295; |
| Phi Symbol, Greek | &amp;#x03D5; | &#x03D5; |
| Phi, Latin Small Letter | &amp;#x0278; | &#x0278; |
| Philippine Double Punctuation | &amp;#x1736; | &#x1736; |
| Philippine Single Punctuation | &amp;#x1735; | &#x1735; |
| Phillipine Currency | &amp;#x20B1; | &#x20B1; |
| Phoenician | &amp;#x10900; | &#x10900; |
| Phonetic Digraphs | &amp;#x02A3; | &#x02A3; |
| Phonetic Extensions | &amp;#x1D00; | &#x1D00; |
| Phonetic Extensions, Katakana | &amp;#x31F0; | &#x31F0; |
| Phonetic Modifiers | &amp;#x02B9; | &#x02B9; |
| Phonetic Modifiers Derived From Latin Letters | &amp;#x02B0; | &#x02B0; |
| Phonetics And Symbols Area, Cjk | &amp;#x2E80; | &#x2E80; |
| Phonorecord Sign | &amp;#x2117; | &#x2117; |
| Phul | &amp;#x2055; | &#x2055; |
| Pi Symbol, Greek | &amp;#x03D6; | &#x03D6; |
| Pi, Double-Struck Capital | &amp;#x213F; | &#x213F; |
| Pi, Double-Struck Small | &amp;#x213C; | &#x213C; |
| Pi, Greek Small Letter | &amp;#x03C0; | &#x03C0; |
| Pi, Mathematical Constant 3.141592... | &amp;#x03C0; | &#x03C0; |
| Pictures For Control Codes, Graphic | &amp;#x2400; | &#x2400; |
| Pilcrow Sign | &amp;#x00B6; | &#x00B6; |
| Pilcrow Sign, Reversed | &amp;#x204B; | &#x204B; |
| Pillow | &amp;#x2311; | &#x2311; |
| Pipe | &amp;#x01C0; | &#x01C0; |
| Pipe, Double | &amp;#x01C1; | &#x01C1; |
| Pipe, Double-Barred | &amp;#x01C2; | &#x01C2; |
| Pisces | &amp;#x2653; | &#x2653; |
| Piska | &amp;#x2052; | &#x2052; |
| Pitchfork | &amp;#x22D4; | &#x22D4; |
| Place Of Interest Sign | &amp;#x2318; | &#x2318; |
| Plaintiff | &amp;#x226C; | &#x226C; |
| Planck Constant | &amp;#x210E; | &#x210E; |
| Planck Constant Over Two Pi | &amp;#x210F; | &#x210F; |
| Planet Symbols | &amp;#x263F; | &#x263F; |
| Plastics Recycling Symbols | &amp;#x2673; | &#x2673; |
| Playing Card Suits | &amp;#x2660; | &#x2660; |
| Plus And Minus Sign Operators | &amp;#x2A22; | &#x2A22; |
| Plus Sign | &amp;#x002B; | &#x002B; |
| Plus Sign Below, Combining | &amp;#x031F; | &#x031F; |
| Plus Sign Operators, Specialized | &amp;#x29FA; | &#x29FA; |
| Plus Sign, Modifier Letter | &amp;#x02D6; | &#x02D6; |
| Plus, Circled | &amp;#x2295; | &#x2295; |
| Plus, Dot | &amp;#x2214; | &#x2214; |
| Plus, Double | &amp;#x29FA; | &#x29FA; |
| Plus, Invisible | &amp;#x2064; | &#x2064; |
| Plus, Squared | &amp;#x229E; | &#x229E; |
| Plus, Triple | &amp;#x29FB; | &#x29FB; |
| Plus-Minus Sign | &amp;#x00B1; | &#x00B1; |
| Pluto | &amp;#x2647; | &#x2647; |
| Point, Decimal | &amp;#x002E; | &#x002E; |
| Point, Hyphenation | &amp;#x2027; | &#x2027; |
| Pointers | &amp;#x25BA; | &#x25BA; |
| Pointing Hand Symbols | &amp;#x261A; | &#x261A; |
| Pointing Index Finger Dingbats | &amp;#x261A; | &#x261A; |
| Pointing Index, Black Left | &amp;#x261A; | &#x261A; |
| Pointing Index, Black Right | &amp;#x261B; | &#x261B; |
| Pointing Index, White Down | &amp;#x261F; | &#x261F; |
| Pointing Index, White Left | &amp;#x261C; | &#x261C; |
| Pointing Index, White Right | &amp;#x261E; | &#x261E; |
| Pointing Index, White Up | &amp;#x261D; | &#x261D; |
| Points And Punctuation, Hebrew | &amp;#x05B0; | &#x05B0; |
| Points, Hebrew | &amp;#x05B0; | &#x05B0; |
| Points, Syriac | &amp;#x0730; | &#x0730; |
| Poison | &amp;#x2620; | &#x2620; |
| Political Symbols, Religious And | &amp;#x2625; | &#x2625; |
| Polygonal Symbols | &amp;#x2B12; | &#x2B12; |
| Polytonic Greek, Precomposed | &amp;#x1F00; | &#x1F00; |
| Pop Directional Formatting | &amp;#x202C; | &#x202C; |
| Position Indicator | &amp;#x2316; | &#x2316; |
| Positive Difference Or Sum | &amp;#x2A24; | &#x2A24; |
| Positive Difference, Sum Or | &amp;#x2A26; | &#x2A26; |
| Positive, Most | &amp;#x223E; | &#x223E; |
| Postal Mark | &amp;#x3012; | &#x3012; |
| Postal Mark Face | &amp;#x3020; | &#x3020; |
| Postal Mark, Circled | &amp;#x3036; | &#x3036; |
| Pound Sign | &amp;#x0023; | &#x0023; |
| Pound Sign | &amp;#x00A3; | &#x00A3; |
| Pound Sterling | &amp;#x00A3; | &#x00A3; |
| Pounds | &amp;#x2114; | &#x2114; |
| Power Set | &amp;#x1D4AB; | &#x1D4AB; |
| Precedence Signs, Order Relation | &amp;#x227A; | &#x227A; |
| Precedence Signs, Order Relation | &amp;#x22DE; | &#x22DE; |
| Precedes | &amp;#x227A; | &#x227A; |
| Precedes Under Relation | &amp;#x22B0; | &#x22B0; |
| Precedes, Double | &amp;#x2ABB; | &#x2ABB; |
| Precomposed Polytonic Greek | &amp;#x1F00; | &#x1F00; |
| Prescription Take | &amp;#x211E; | &#x211E; |
| Presentation Forms, Alphabetic | &amp;#xFB00; | &#xFB00; |
| Presentation Forms, Hebrew | &amp;#xFB1D; | &#xFB1D; |
| Presentation Forms-A, Arabic | &amp;#xFB50; | &#xFB50; |
| Presentation Forms-B, Arabic | &amp;#xFE70; | &#xFE70; |
| Previous Page | &amp;#x2397; | &#x2397; |
| Prime | &amp;#x2032; | &#x2032; |
| Prime Quotation Mark, Double | &amp;#x301E; | &#x301E; |
| Prime Quotation Mark, Low Double | &amp;#x301F; | &#x301F; |
| Prime Quotation Mark, Reversed Double | &amp;#x301D; | &#x301D; |
| Prime, Double | &amp;#x2033; | &#x2033; |
| Prime, Modifier Letter | &amp;#x02B9; | &#x02B9; |
| Prime, Modifier Letter Double | &amp;#x02BA; | &#x02BA; |
| Prime, Quadruple | &amp;#x2057; | &#x2057; |
| Prime, Reversed | &amp;#x2035; | &#x2035; |
| Prime, Reversed Double | &amp;#x2036; | &#x2036; |
| Prime, Reversed Triple | &amp;#x2037; | &#x2037; |
| Prime, Triple | &amp;#x2034; | &#x2034; |
| Print Screen Symbol | &amp;#x2399; | &#x2399; |
| Privacy Message | &amp;#x009E; | &#x009E; |
| Private Use Area | &amp;#xE000; | &#xE000; |
| Private Use Area-A, Supplementary | &amp;#xF0000; | &#xF0000; |
| Private Use Area-B, Supplementary | &amp;#x100000; | &#x100000; |
| Private Use One | &amp;#x0091; | &#x0091; |
| Private Use Two | &amp;#x0092; | &#x0092; |
| Product Sign | &amp;#x220F; | &#x220F; |
| Product, Cartesian | &amp;#x00D7; | &#x00D7; |
| Product, Direct | &amp;#x2299; | &#x2299; |
| Product, Interior | &amp;#x2A3C; | &#x2A3C; |
| Product, Left Normal Factor Semidirect | &amp;#x22C9; | &#x22C9; |
| Product, Left Semidirect | &amp;#x22CB; | &#x22CB; |
| Product, N-Ary | &amp;#x220F; | &#x220F; |
| Product, Right Normal Factor Semidirect | &amp;#x22CA; | &#x22CA; |
| Product, Right Semidirect | &amp;#x22CC; | &#x22CC; |
| Product, Righthand Interior | &amp;#x2A3D; | &#x2A3D; |
| Product, Shuffle | &amp;#x29E2; | &#x29E2; |
| Product, Smash | &amp;#x2A33; | &#x2A33; |
| Product, Tensor | &amp;#x2297; | &#x2297; |
| Product, Vector Or Cross | &amp;#x2A2F; | &#x2A2F; |
| Product, Wreath | &amp;#x2240; | &#x2240; |
| Program Command, Application | &amp;#x009F; | &#x009F; |
| Prohibition | &amp;#x20E0; | &#x20E0; |
| Projective | &amp;#x2305; | &#x2305; |
| Proof, End Of | &amp;#x220E; | &#x220E; |
| Proper Intersection | &amp;#x22D4; | &#x22D4; |
| Property Line | &amp;#x214A; | &#x214A; |
| Proportion | &amp;#x2237; | &#x2237; |
| Proportion, Geometric | &amp;#x223A; | &#x223A; |
| Proportional To | &amp;#x221D; | &#x221D; |
| Proportional To | &amp;#x223C; | &#x223C; |
| Proves | &amp;#x22A2; | &#x22A2; |
| Psili, Greek | &amp;#x0313; | &#x0313; |
| Published | &amp;#x2117; | &#x2117; |
| Pullback | &amp;#x27D3; | &#x27D3; |
| Punctuation And Signs, Greek | &amp;#x0374; | &#x0374; |
| Punctuation And Signs, Myanmar | &amp;#x104A; | &#x104A; |
| Punctuation And Signs, Syriac | &amp;#x0700; | &#x0700; |
| Punctuation And Symbols, Ascii | &amp;#x0020; | &#x0020; |
| Punctuation And Symbols, Latin-1 | &amp;#x00A0; | &#x00A0; |
| Punctuation For Vertical Text, Double | &amp;#x2047; | &#x2047; |
| Punctuation Ornaments | &amp;#x275B; | &#x275B; |
| Punctuation Space | &amp;#x2008; | &#x2008; |
| Punctuation, Arabic | &amp;#x060C; | &#x060C; |
| Punctuation, Canadian Syllabics | &amp;#x166D; | &#x166D; |
| Punctuation, Cjk Symbols And | &amp;#x3000; | &#x3000; |
| Punctuation, Cuneiform Numbers And | &amp;#x12400; | &#x12400; |
| Punctuation, Ethiopic | &amp;#x1361; | &#x1361; |
| Punctuation, General | &amp;#x2000; | &#x2000; |
| Punctuation, Halfwidth Cjk | &amp;#xFF61; | &#xFF61; |
| Punctuation, Hebrew Points And | &amp;#x05B0; | &#x05B0; |
| Punctuation, Mongolian | &amp;#x1800; | &#x1800; |
| Punctuation, Ogham | &amp;#x169B; | &#x169B; |
| Punctuation, Philippine Double | &amp;#x1736; | &#x1736; |
| Punctuation, Philippine Single | &amp;#x1735; | &#x1735; |
| Punctuation, Runic | &amp;#x16EB; | &#x16EB; |
| Punctuation, Supplemental | &amp;#x2E00; | &#x2E00; |
| Punt, Irish | &amp;#x00A3; | &#x00A3; |
| Purna Viram, Devanagari | &amp;#x0964; | &#x0964; |
| Pushout | &amp;#x27D4; | &#x27D4; |
| Puspika | &amp;#x2055; | &#x2055; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Q

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| Q With Hook Tail, Latin Capital Letter Small | &amp;#x024A; | &#x024A; |
| Q With Hook Tail, Latin Small Letter | &amp;#x024B; | &#x024B; |
| Q With Hook, Latin Small Letter | &amp;#x02A0; | &#x02A0; |
| Q, Double-Struck Capital | &amp;#x211A; | &#x211A; |
| Q, Rotated Capital | &amp;#x213A; | &#x213A; |
| Q.E.D. | &amp;#x220E; | &#x220E; |
| Qp Digraph, Latin Small Letter | &amp;#x0239; | &#x0239; |
| Quad, Em | &amp;#x2001; | &#x2001; |
| Quad, En | &amp;#x2000; | &#x2000; |
| Quad, Mutton | &amp;#x2001; | &#x2001; |
| Quadrant Control Code Graphics | &amp;#x25F0; | &#x25F0; |
| Quadrature | &amp;#x25A1; | &#x25A1; |
| Quadruple Prime | &amp;#x2057; | &#x2057; |
| Quantic | &amp;#x226C; | &#x226C; |
| Quantifier, Existential | &amp;#x2203; | &#x2203; |
| Quantifier, Universal | &amp;#x2200; | &#x2200; |
| Quarter Moon, First | &amp;#x263D; | &#x263D; |
| Quarter Moon, Last | &amp;#x263E; | &#x263E; |
| Quarter Note | &amp;#x2669; | &#x2669; |
| Quarter, Vulgar Fraction One | &amp;#x00BC; | &#x00BC; |
| Quarters, Fractions | &amp;#x00BC; | &#x00BC; |
| Quarters, Vulgar Fraction Three | &amp;#x00BE; | &#x00BE; |
| Quaternion Integral Operator | &amp;#x2A16; | &#x2A16; |
| Question Exclamation Mark | &amp;#x2048; | &#x2048; |
| Question Mark | &amp;#x003F; | &#x003F; |
| Question Mark, Arabic | &amp;#x061F; | &#x061F; |
| Question Mark, Armenian | &amp;#x055E; | &#x055E; |
| Question Mark, Double | &amp;#x2047; | &#x2047; |
| Question Mark, Ethiopic | &amp;#x1367; | &#x1367; |
| Question Mark, Exclamation | &amp;#x2049; | &#x2049; |
| Question Mark, Greek | &amp;#x003B; | &#x003B; |
| Question Mark, Greek | &amp;#x037E; | &#x037E; |
| Question Mark, Inverted | &amp;#x00BF; | &#x00BF; |
| Question Mark, Limbu | &amp;#x1945; | &#x1945; |
| Question Mark, Turned | &amp;#x00BF; | &#x00BF; |
| Questioned Equal To | &amp;#x225F; | &#x225F; |
| Quill, Left Square Bracket With | &amp;#x2045; | &#x2045; |
| Quill, Right Square Bracket With | &amp;#x2046; | &#x2046; |
| Quine Corners | &amp;#x231C; | &#x231C; |
| Quotation Dash | &amp;#x2015; | &#x2015; |
| Quotation Mark | &amp;#x0022; | &#x0022; |
| Quotation Mark Dingbats | &amp;#x275B; | &#x275B; |
| Quotation Mark Ornaments | &amp;#x275B; | &#x275B; |
| Quotation Mark, Double Comma | &amp;#x201D; | &#x201D; |
| Quotation Mark, Double High-Reversed-9 | &amp;#x201F; | &#x201F; |
| Quotation Mark, Double Low-9 | &amp;#x201E; | &#x201E; |
| Quotation Mark, Double Prime | &amp;#x301E; | &#x301E; |
| Quotation Mark, Double Reversed Comma | &amp;#x201F; | &#x201F; |
| Quotation Mark, Double Turned Comma | &amp;#x201C; | &#x201C; |
| Quotation Mark, Left Double | &amp;#x201C; | &#x201C; |
| Quotation Mark, Left Single | &amp;#x2018; | &#x2018; |
| Quotation Mark, Left-Pointing Double Angle | &amp;#x00AB; | &#x00AB; |
| Quotation Mark, Low Double Comma | &amp;#x201E; | &#x201E; |
| Quotation Mark, Low Double Prime | &amp;#x301F; | &#x301F; |
| Quotation Mark, Low Single Comma | &amp;#x201A; | &#x201A; |
| Quotation Mark, Neutral | &amp;#x0022; | &#x0022; |
| Quotation Mark, Neutral Single | &amp;#x0027; | &#x0027; |
| Quotation Mark, Reversed Double Prime | &amp;#x301D; | &#x301D; |
| Quotation Mark, Right Double | &amp;#x201D; | &#x201D; |
| Quotation Mark, Right Single | &amp;#x2019; | &#x2019; |
| Quotation Mark, Right-Pointing Double Angle | &amp;#x00BB; | &#x00BB; |
| Quotation Mark, Single Comma | &amp;#x2019; | &#x2019; |
| Quotation Mark, Single High-Reversed-9 | &amp;#x201B; | &#x201B; |
| Quotation Mark, Single Left-Pointing Angle | &amp;#x2039; | &#x2039; |
| Quotation Mark, Single Low-9 | &amp;#x201A; | &#x201A; |
| Quotation Mark, Single Reversed Comma | &amp;#x201B; | &#x201B; |
| Quotation Mark, Single Right-Pointing Angle | &amp;#x203A; | &#x203A; |
| Quotation Mark, Single Turned Comma | &amp;#x2018; | &#x2018; |
| Quotation Marks | &amp;#x2018; | &#x2018; |
| Quotation Marks, Cjk | &amp;#x300C; | &#x300C; |
| Quotation Marks, Ornamental Angle | &amp;#x276E; | &#x276E; |
| Quote, Apl | &amp;#x0027; | &#x0027; |
| Qur'anic Annotation Signs, Arabic | &amp;#x06D6; | &#x06D6; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## R

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| R With Acute, Latin Small Letter | &amp;#x0155; | &#x0155; |
| R With Caron, Latin Small Letter | &amp;#x0159; | &#x0159; |
| R With Cedilla, Latin Small Letter | &amp;#x0157; | &#x0157; |
| R With Dot Above, Latin Small Letter | &amp;#x1E59; | &#x1E59; |
| R With Dot Below, Latin Small Letter | &amp;#x1E5B; | &#x1E5B; |
| R With Double Grave, Latin Small Letter | &amp;#x0211; | &#x0211; |
| R With Fishhook, Latin Small Letter | &amp;#x027E; | &#x027E; |
| R With Fishhook, Latin Small Letter Reversed | &amp;#x027F; | &#x027F; |
| R With Hook, Latin Small Letter Turned | &amp;#x027B; | &#x027B; |
| R With Inverted Breve, Latin Small Letter | &amp;#x0213; | &#x0213; |
| R With Line Below, Latin Small Letter | &amp;#x1E5F; | &#x1E5F; |
| R With Long Leg, Latin Small Letter | &amp;#x027C; | &#x027C; |
| R With Long Leg, Latin Small Letter Turned | &amp;#x027A; | &#x027A; |
| R With Stroke, Latin Capital Letter | &amp;#x024C; | &#x024C; |
| R With Stroke, Latin Small Letter | &amp;#x024D; | &#x024D; |
| R With Tail, Latin Small Letter | &amp;#x027D; | &#x027D; |
| R, Black-Letter Capital | &amp;#x211C; | &#x211C; |
| R, Combining Latin Small Letter | &amp;#x036C; | &#x036C; |
| R, Double-Struck Capital | &amp;#x211D; | &#x211D; |
| R, Latin Letter Small Capital | &amp;#x0280; | &#x0280; |
| R, Latin Letter Small Capital Inverted | &amp;#x0281; | &#x0281; |
| R, Latin Letter Small Capital Reversed | &amp;#x1D19; | &#x1D19; |
| R, Latin Letter Small Capital Turned | &amp;#x1D1A; | &#x1D1A; |
| R, Latin Small Letter Turned | &amp;#x0279; | &#x0279; |
| R, Latin Subscript Small Letter | &amp;#x1D63; | &#x1D63; |
| R, Modifier Letter Small | &amp;#x02B3; | &#x02B3; |
| R, Modifier Letter Small Capital Inverted | &amp;#x02B6; | &#x02B6; |
| R, Modifier Letter Small Turned | &amp;#x02B4; | &#x02B4; |
| R, Script Capital | &amp;#x211B; | &#x211B; |
| Radial Component | &amp;#x27DF; | &#x27DF; |
| Radical Sign | &amp;#x221A; | &#x221A; |
| Radicals Supplement, Cjk | &amp;#x2E80; | &#x2E80; |
| Radicals, Cjk Kangxi | &amp;#x2F00; | &#x2F00; |
| Radicals, Yi | &amp;#xA490; | &#xA490; |
| Radioactive Sign | &amp;#x2622; | &#x2622; |
| Rain Drops, Umbrella With | &amp;#x2614; | &#x2614; |
| Rainy Weather | &amp;#x2602; | &#x2602; |
| Rams Horn, Latin Small Letter | &amp;#x0264; | &#x0264; |
| Range Restriction | &amp;#x25B7; | &#x25B7; |
| Ratio | &amp;#x2236; | &#x2236; |
| Ratio, Cross | &amp;#x211E; | &#x211E; |
| Rational Numbers | &amp;#x211A; | &#x211A; |
| Reahmuk, Khmer Sign | &amp;#x17C7; | &#x17C7; |
| Real Number Symbol | &amp;#x210A; | &#x210A; |
| Real Numbers | &amp;#x211D; | &#x211D; |
| Real Part | &amp;#x211C; | &#x211C; |
| Recipe | &amp;#x211E; | &#x211E; |
| Record Separator | &amp;#x001E; | &#x001E; |
| Record Separator, Symbol For | &amp;#x241E; | &#x241E; |
| Recorder, Telephone | &amp;#x2315; | &#x2315; |
| Recording Copyright, Sound | &amp;#x2117; | &#x2117; |
| Rectangle Box, X In A | &amp;#x2327; | &#x2327; |
| Rectangles | &amp;#x25AC; | &#x25AC; |
| Recycled Paper Symbol | &amp;#x267C; | &#x267C; |
| Recycled Paper Symbol, Partially- | &amp;#x267D; | &#x267D; |
| Recycling Symbol, Universal | &amp;#x2672; | &#x2672; |
| Recycling Symbols | &amp;#x2672; | &#x2672; |
| Recycling Symbols, Plastics | &amp;#x2673; | &#x2673; |
| Reduces To | &amp;#x22A6; | &#x22A6; |
| Reducible | &amp;#x22A2; | &#x22A2; |
| Reference Mark | &amp;#x203B; | &#x203B; |
| Registered Sign | &amp;#x00AE; | &#x00AE; |
| Registered Trade Mark Sign | &amp;#x00AE; | &#x00AE; |
| Rejang | &amp;#xA930; | &#xA930; |
| Relation | &amp;#x2194; | &#x2194; |
| Relation, Finite | &amp;#x21FC; | &#x21FC; |
| Relation, Partial | &amp;#x21F9; | &#x21F9; |
| Relational Operators | &amp;#x29E3; | &#x29E3; |
| Relations, Subset And Superset | &amp;#x2ABD; | &#x2ABD; |
| Religious And Political Symbols | &amp;#x2626; | &#x2626; |
| Repeat Marks, Kana | &amp;#x3031; | &#x3031; |
| Replacement Character | &amp;#xFFFD; | &#xFFFD; |
| Replacement Character, Object | &amp;#xFFFC; | &#xFFFC; |
| Response | &amp;#x211F; | &#x211F; |
| Restriction, Domain | &amp;#x25C1; | &#x25C1; |
| Restriction, Range | &amp;#x25B7; | &#x25B7; |
| Results In | &amp;#x22A8; | &#x22A8; |
| Retroflex Click, Latin Letter | &amp;#x01C3; | &#x01C3; |
| Retroflex Hook Below, Combining | &amp;#x0322; | &#x0322; |
| Retroflex Hook, Latin Capital Letter T With | &amp;#x01AE; | &#x01AE; |
| Retroflex Hook, Latin Small Letter D | &amp;#x0256; | &#x0256; |
| Retroflex Hook, Latin Small Letter L With | &amp;#x026D; | &#x026D; |
| Retroflex Hook, Latin Small Letter N With | &amp;#x0273; | &#x0273; |
| Retroflex Hook, Latin Small Letter T With | &amp;#x0288; | &#x0288; |
| Retroflex Hook, Latin Small Letter Z With | &amp;#x0290; | &#x0290; |
| Return Symbol | &amp;#x23CE; | &#x23CE; |
| Return, Carriage | &amp;#x000D; | &#x000D; |
| Return, Symbol For Carriage | &amp;#x240D; | &#x240D; |
| Reverse Line Feed | &amp;#x008D; | &#x008D; |
| Reverse Solidus | &amp;#x005C; | &#x005C; |
| Reverse Solidus Operator | &amp;#x29F5; | &#x29F5; |
| Reverse Solidus Overlay, Combining | &amp;#x20E5; | &#x20E5; |
| Reverse Solidus, Big | &amp;#x29F9; | &#x29F9; |
| Reverse Turnstile | &amp;#x22A3; | &#x22A3; |
| Reversed C, Latin Small Letter | &amp;#x2184; | &#x2184; |
| Reversed Comma Above, Combining | &amp;#x0314; | &#x0314; |
| Reversed Comma Quotation Mark, Double | &amp;#x201F; | &#x201F; |
| Reversed Comma Quotation Mark, Single | &amp;#x201B; | &#x201B; |
| Reversed Comma, Modifier Letter | &amp;#x02BD; | &#x02BD; |
| Reversed Double Prime | &amp;#x2036; | &#x2036; |
| Reversed Double Prime Quotation Mark | &amp;#x301D; | &#x301D; |
| Reversed E, Latin Capital Letter | &amp;#x018E; | &#x018E; |
| Reversed E, Latin Small Letter | &amp;#x0258; | &#x0258; |
| Reversed Epsilon, Latin Small Letter Closed | &amp;#x025E; | &#x025E; |
| Reversed Esh Loop, Latin Letter | &amp;#x01AA; | &#x01AA; |
| Reversed Esh, Latin Small Letter Squat | &amp;#x0285; | &#x0285; |
| Reversed Glottal Stop, Latin Letter | &amp;#x0295; | &#x0295; |
| Reversed Glottal Stop, Modifier Letter | &amp;#x02C1; | &#x02C1; |
| Reversed Glottal Stop, Modifier Letter Small | &amp;#x02E4; | &#x02E4; |
| Reversed Lunate Epsilon Symbol, Greek | &amp;#x03F6; | &#x03F6; |
| Reversed N, Latin Letter Small Capital | &amp;#x1D0E; | &#x1D0E; |
| Reversed Not Sign | &amp;#x2310; | &#x2310; |
| Reversed Open E With Hook, Latin Small Letter | &amp;#x025D; | &#x025D; |
| Reversed Open E, Latin Small Letter | &amp;#x025C; | &#x025C; |
| Reversed Open E, Latin Small Letter Closed | &amp;#x025E; | &#x025E; |
| Reversed Pilcrow Sign | &amp;#x204B; | &#x204B; |
| Reversed Prime | &amp;#x2035; | &#x2035; |
| Reversed R With Fishhook, Latin Small Letter | &amp;#x027F; | &#x027F; |
| Reversed R, Latin Letter Small Capital | &amp;#x1D19; | &#x1D19; |
| Reversed Rotated Floral Heart Bullet | &amp;#x2619; | &#x2619; |
| Reversed Sans-Serif Capital L | &amp;#x2143; | &#x2143; |
| Reversed Semicolon | &amp;#x204F; | &#x204F; |
| Reversed Straight Epsilon | &amp;#x03F6; | &#x03F6; |
| Reversed Tilde | &amp;#x223D; | &#x223D; |
| Reversed Tilde Equals | &amp;#x22CD; | &#x22CD; |
| Reversed Triple Prime | &amp;#x2037; | &#x2037; |
| Reversed, Latin Small Letter Ezh | &amp;#x01B9; | &#x01B9; |
| Rgroup | &amp;#x27EF; | &#x27EF; |
| Rhotic Hook, Modifier Letter | &amp;#x02DE; | &#x02DE; |
| Rial Sign | &amp;#xFDFC; | &#xFDFC; |
| Riel, Khmer Currency Symbol | &amp;#x17DB; | &#x17DB; |
| Riemann Integral | &amp;#x211B; | &#x211B; |
| Right Abstract Syntax Bracket | &amp;#x301B; | &#x301B; |
| Right Angle | &amp;#x221F; | &#x221F; |
| Right Angle Bracket | &amp;#x3009; | &#x3009; |
| Right Angle Bracket, Mathematical | &amp;#x27E9; | &#x27E9; |
| Right Angle With Arc | &amp;#x22BE; | &#x22BE; |
| Right Arrow Above, Combining | &amp;#x20D7; | &#x20D7; |
| Right Arrow Above, Combining Left | &amp;#x20E1; | &#x20E1; |
| Right Arrow Below, Combining | &amp;#x20EF; | &#x20EF; |
| Right Arrow Below, Combining Left | &amp;#x034D; | &#x034D; |
| Right Arrow, Colon | &amp;#x29F4; | &#x29F4; |
| Right Arrowhead Above, Combining | &amp;#x0350; | &#x0350; |
| Right Arrowhead Below, Combining | &amp;#x0355; | &#x0355; |
| Right Bag Bracket | &amp;#x27E7; | &#x27E7; |
| Right Black Lenticular Bracket | &amp;#x3011; | &#x3011; |
| Right Ceiling | &amp;#x2309; | &#x2309; |
| Right Chevron Bracket | &amp;#x27EB; | &#x27EB; |
| Right Corner Bracket | &amp;#x300D; | &#x300D; |
| Right Curly Bracket | &amp;#x007D; | &#x007D; |
| Right Diagonal Ellipsis, Down | &amp;#x22F1; | &#x22F1; |
| Right Diagonal Ellipsis, Up | &amp;#x22F0; | &#x22F0; |
| Right Double Angle Bracket | &amp;#x300B; | &#x300B; |
| Right Double Angle Bracket, Mathematical | &amp;#x27EB; | &#x27EB; |
| Right Double Quotation Mark | &amp;#x201D; | &#x201D; |
| Right Floor | &amp;#x230B; | &#x230B; |
| Right Half Ring Above, Combining | &amp;#x0357; | &#x0357; |
| Right Half Ring Below, Combining | &amp;#x0339; | &#x0339; |
| Right Half Ring, Armenian Modifier Letter | &amp;#x055A; | &#x055A; |
| Right Harpoon Above, Combining | &amp;#x20D1; | &#x20D1; |
| Right Key, Delete To The | &amp;#x2326; | &#x2326; |
| Right Moustache | &amp;#x23B1; | &#x23B1; |
| Right Normal Factor Semidirect Product | &amp;#x22CA; | &#x22CA; |
| Right Parenthesis | &amp;#x0029; | &#x0029; |
| Right Parenthesis, Ornate | &amp;#xFD3F; | &#xFD3F; |
| Right Pencil, Lower | &amp;#x270E; | &#x270E; |
| Right Pencil, Upper | &amp;#x2710; | &#x2710; |
| Right Pointing Guillemet | &amp;#x00BB; | &#x00BB; |
| Right Pointing Index, Black | &amp;#x261B; | &#x261B; |
| Right Pointing Index, White | &amp;#x261E; | &#x261E; |
| Right Pointing Single Guillemet | &amp;#x203A; | &#x203A; |
| Right Semidirect Product | &amp;#x22CC; | &#x22CC; |
| Right Sequence Bracket | &amp;#x27E9; | &#x27E9; |
| Right Single Quotation Mark | &amp;#x2019; | &#x2019; |
| Right Square Bracket | &amp;#x005D; | &#x005D; |
| Right Square Bracket With Quill | &amp;#x2046; | &#x2046; |
| Right Tack | &amp;#x22A2; | &#x22A2; |
| Right Tack Below, Combining | &amp;#x0319; | &#x0319; |
| Right Tortoise Shell Bracket | &amp;#x3015; | &#x3015; |
| Right Triangle | &amp;#x22BF; | &#x22BF; |
| Right White Corner Bracket | &amp;#x300F; | &#x300F; |
| Right White Curly Bracket | &amp;#x2984; | &#x2984; |
| Right White Lenticular Bracket | &amp;#x3017; | &#x3017; |
| Right White Parenthesis | &amp;#x2986; | &#x2986; |
| Right White Square Bracket | &amp;#x301B; | &#x301B; |
| Right White Tortoise Shell Bracket | &amp;#x3019; | &#x3019; |
| Right, Combining Comma Above | &amp;#x0315; | &#x0315; |
| Right, Combining Dot Above | &amp;#x0358; | &#x0358; |
| Right, Erase To The | &amp;#x2326; | &#x2326; |
| Right, Fast Cursor | &amp;#x21A0; | &#x21A0; |
| Right-Pointing Angle Bracket | &amp;#x232A; | &#x232A; |
| Right-Pointing Angle Quotation Mark, Single | &amp;#x203A; | &#x203A; |
| Right-Pointing Double Angle Quotation Mark | &amp;#x00BB; | &#x00BB; |
| Right-To-Left Embedding | &amp;#x202B; | &#x202B; |
| Right-To-Left Mark | &amp;#x200F; | &#x200F; |
| Right-To-Left Override | &amp;#x202E; | &#x202E; |
| Righthand Interior Product | &amp;#x2A3D; | &#x2A3D; |
| Rightward Tab | &amp;#x21E5; | &#x21E5; |
| Rightwards Arrow | &amp;#x2192; | &#x2192; |
| Rightwards Arrow Below, Combining Double | &amp;#x0362; | &#x0362; |
| Rightwards Bullet, Black | &amp;#x204D; | &#x204D; |
| Rightwards Harpoon With Barb Downwards, Combining | &amp;#x20EC; | &#x20EC; |
| Ring Above | &amp;#x02DA; | &#x02DA; |
| Ring Above, Combining | &amp;#x030A; | &#x030A; |
| Ring Above, Combining Left Half | &amp;#x0351; | &#x0351; |
| Ring Above, Combining Right Half | &amp;#x0357; | &#x0357; |
| Ring Above, Latin Capital Letter A With | &amp;#x00C5; | &#x00C5; |
| Ring Above, Latin Small Letter A With | &amp;#x00E5; | &#x00E5; |
| Ring Below, Combining | &amp;#x0325; | &#x0325; |
| Ring Below, Combining Double | &amp;#x035A; | &#x035A; |
| Ring Below, Combining Left Half | &amp;#x031C; | &#x031C; |
| Ring Below, Combining Right Half | &amp;#x0339; | &#x0339; |
| Ring Below, Latin Small Letter A With | &amp;#x1E01; | &#x1E01; |
| Ring Equal To | &amp;#x2257; | &#x2257; |
| Ring In Equal To | &amp;#x2256; | &#x2256; |
| Ring Operator | &amp;#x2218; | &#x2218; |
| Ring Operator, Circled | &amp;#x229A; | &#x229A; |
| Ring Overlay, Combining | &amp;#x20D8; | &#x20D8; |
| Ring Overlay, Combining Anticlockwise | &amp;#x20DA; | &#x20DA; |
| Ring Overlay, Combining Clockwise | &amp;#x20D9; | &#x20D9; |
| Ring Overlay, Combining Counterclockwise | &amp;#x20DA; | &#x20DA; |
| Ring, Armenian Modifier Letter Left Half | &amp;#x0559; | &#x0559; |
| Ring, Armenian Modifier Letter Right Half | &amp;#x055A; | &#x055A; |
| Ring, Benzene | &amp;#x232C; | &#x232C; |
| Ring, Modifier Letter Centred Left Half | &amp;#x02D3; | &#x02D3; |
| Ring, Modifier Letter Left Half | &amp;#x02BF; | &#x02BF; |
| Rjes Su Nga Ro, Tibetan Sign | &amp;#x0F7E; | &#x0F7E; |
| Rnam Bcad, Tibetan Sign | &amp;#x0F7F; | &#x0F7F; |
| Roman Numerals | &amp;#x2160; | &#x2160; |
| Roman Numerals, Archaic | &amp;#x2185; | &#x2185; |
| Roman Symbols | &amp;#x10190; | &#x10190; |
| Root, Cube | &amp;#x221B; | &#x221B; |
| Root, Fourth | &amp;#x221C; | &#x221C; |
| Root, Square | &amp;#x221A; | &#x221A; |
| Rotated Capital Q | &amp;#x213A; | &#x213A; |
| Rough Breathing Mark, Greek | &amp;#x0314; | &#x0314; |
| Rule, Parted | &amp;#x00A6; | &#x00A6; |
| Rule-Delayed | &amp;#x29F4; | &#x29F4; |
| Runic | &amp;#x16A0; | &#x16A0; |
| Runic Golden Numbers | &amp;#x16EE; | &#x16EE; |
| Runic Punctuation | &amp;#x16EB; | &#x16EB; |
| Runout, Total | &amp;#x2330; | &#x2330; |
| Rupai, Tamil | &amp;#x0BF9; | &#x0BF9; |
| Rupee Mark, Bengali | &amp;#x09F2; | &#x09F2; |
| Rupee Sign | &amp;#x20A8; | &#x20A8; |
| Rupee Sign, Bengali | &amp;#x09F3; | &#x09F3; |
| Rupee Sign, Gujarati | &amp;#x0AF1; | &#x0AF1; |
| Rupee Sign, Tamil | &amp;#x0BF9; | &#x0BF9; |
| Russian Alphabet | &amp;#x0410; | &#x0410; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## S

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| S With Acute, Latin Small Letter | &amp;#x015B; | &#x015B; |
| S With Caron, Latin Small Letter | &amp;#x0161; | &#x0161; |
| S With Cedilla, Latin Small Letter | &amp;#x015F; | &#x015F; |
| S With Circumflex, Latin Small Letter | &amp;#x015D; | &#x015D; |
| S With Comma Below, Latin Small Letter | &amp;#x0219; | &#x0219; |
| S With Dot Above, Latin Small Letter | &amp;#x1E61; | &#x1E61; |
| S With Dot Above, Latin Small Letter Long | &amp;#x1E9B; | &#x1E9B; |
| S With Dot Below, Latin Small Letter | &amp;#x1E63; | &#x1E63; |
| S With Hook, Latin Small Letter | &amp;#x0282; | &#x0282; |
| S With Swash Tail, Latin Small Letter | &amp;#x023F; | &#x023F; |
| S, Inverted Lazy | &amp;#x223E; | &#x223E; |
| S, Latin Small Letter Long | &amp;#x017F; | &#x017F; |
| S, Latin Small Letter Sharp | &amp;#x00DF; | &#x00DF; |
| S, Lazy | &amp;#x223D; | &#x223D; |
| S, Modifier Letter Small | &amp;#x02E2; | &#x02E2; |
| Sagittarius | &amp;#x2650; | &#x2650; |
| Saltire | &amp;#x2613; | &#x2613; |
| Sam, Syriac | &amp;#x070F; | &#x070F; |
| Samaritan Source, Symbol For | &amp;#x214F; | &#x214F; |
| Sans-Serif Bold Digits | &amp;#x1D7EC; | &#x1D7EC; |
| Sans-Serif Bold Greek Mathematical Symbols | &amp;#x1D756; | &#x1D756; |
| Sans-Serif Bold Italic Greek Mathematical Symbols | &amp;#x1D790; | &#x1D790; |
| Sans-Serif Bold Italic Mathematical Symbols | &amp;#x1D63C; | &#x1D63C; |
| Sans-Serif Bold Mathematical Symbols | &amp;#x1D5D4; | &#x1D5D4; |
| Sans-Serif Capital G, Turned | &amp;#x2141; | &#x2141; |
| Sans-Serif Capital L, Reversed | &amp;#x2143; | &#x2143; |
| Sans-Serif Capital L, Turned | &amp;#x2142; | &#x2142; |
| Sans-Serif Capital Y, Turned | &amp;#x2144; | &#x2144; |
| Sans-Serif Digits | &amp;#x1D7E2; | &#x1D7E2; |
| Sans-Serif Italic Mathematical Symbols | &amp;#x1D608; | &#x1D608; |
| Sans-Serif Mathematical Symbols | &amp;#x1D5A0; | &#x1D5A0; |
| Satisfies | &amp;#x22A8; | &#x22A8; |
| Satisfies, Necessarily | &amp;#x2AF1; | &#x2AF1; |
| Satisfies, Ordinarily | &amp;#x2AE2; | &#x2AE2; |
| Saturating Subtraction | &amp;#x2238; | &#x2238; |
| Saturn | &amp;#x2644; | &#x2644; |
| Saurashtra | &amp;#xA880; | &#xA880; |
| Scales | &amp;#x2696; | &#x2696; |
| Scan Lines, Horizontal | &amp;#x23BA; | &#x23BA; |
| Schema Hiding | &amp;#x29F9; | &#x29F9; |
| Schwa, Latin Capital Letter | &amp;#x018F; | &#x018F; |
| Schwa, Latin Small Letter | &amp;#x0259; | &#x0259; |
| Scissors, Black | &amp;#x2702; | &#x2702; |
| Scissors, Upper Blade | &amp;#x2701; | &#x2701; |
| Scissors, White | &amp;#x2704; | &#x2704; |
| Scorpius | &amp;#x264F; | &#x264F; |
| Screen Symbol, Clear | &amp;#x239A; | &#x239A; |
| Screen Symbol, Print | &amp;#x2399; | &#x2399; |
| Screen, Combining Enclosing | &amp;#x20E2; | &#x20E2; |
| Script A, Latin Small Letter | &amp;#x0251; | &#x0251; |
| Script Capital B | &amp;#x212C; | &#x212C; |
| Script Capital E | &amp;#x2130; | &#x2130; |
| Script Capital F | &amp;#x2131; | &#x2131; |
| Script Capital H | &amp;#x210B; | &#x210B; |
| Script Capital I | &amp;#x2110; | &#x2110; |
| Script Capital L | &amp;#x2112; | &#x2112; |
| Script Capital M | &amp;#x2133; | &#x2133; |
| Script Capital P | &amp;#x2118; | &#x2118; |
| Script Capital R | &amp;#x211B; | &#x211B; |
| Script F, Latin Small Letter | &amp;#x0192; | &#x0192; |
| Script G, Latin Small Letter | &amp;#x0261; | &#x0261; |
| Script Mathematical Symbols | &amp;#x1D49C; | &#x1D49C; |
| Script Mathematical Symbols, Bold | &amp;#x1D4D0; | &#x1D4D0; |
| Script Small E | &amp;#x212F; | &#x212F; |
| Script Small G | &amp;#x210A; | &#x210A; |
| Script Small L | &amp;#x2113; | &#x2113; |
| Script Small O | &amp;#x2134; | &#x2134; |
| Script Theta | &amp;#x03D1; | &#x03D1; |
| Script V, Latin Capital Letter | &amp;#x01B2; | &#x01B2; |
| Script V, Latin Small Letter | &amp;#x028B; | &#x028B; |
| Scrolling | &amp;#x21F3; | &#x21F3; |
| Scruple | &amp;#x2108; | &#x2108; |
| Seagull Below, Combining | &amp;#x033C; | &#x033C; |
| Second Tone, Mandarin Chinese | &amp;#x02CA; | &#x02CA; |
| Seconds | &amp;#x2033; | &#x2033; |
| Section Sign | &amp;#x00A7; | &#x00A7; |
| Section Sign, European | &amp;#x00B6; | &#x00B6; |
| Sector | &amp;#x2314; | &#x2314; |
| Segment | &amp;#x2313; | &#x2313; |
| Selected Area, End Of | &amp;#x0087; | &#x0087; |
| Selected Area, Start Of | &amp;#x0086; | &#x0086; |
| Selectors Supplement, Variation | &amp;#xE0100; | &#xE0100; |
| Selectors, Variation | &amp;#xFE00; | &#xFE00; |
| Semicolon | &amp;#x003B; | &#x003B; |
| Semicolon, Arabic | &amp;#x061B; | &#x061B; |
| Semicolon, Ethiopic | &amp;#x1364; | &#x1364; |
| Semicolon, Reversed | &amp;#x204F; | &#x204F; |
| Semidirect Product, Left | &amp;#x22CB; | &#x22CB; |
| Semidirect Product, Left Normal Factor | &amp;#x22C9; | &#x22C9; |
| Semidirect Product, Right | &amp;#x22CC; | &#x22CC; |
| Semidirect Product, Right Normal Factor | &amp;#x22CA; | &#x22CA; |
| Separator Dot, Aegean Word | &amp;#x10101; | &#x10101; |
| Separator Key Symbol, Decimal | &amp;#x2396; | &#x2396; |
| Separator Line, Aegean Word | &amp;#x10100; | &#x10100; |
| Separator, Arabic Date | &amp;#x060D; | &#x060D; |
| Separator, Arabic Decimal | &amp;#x066B; | &#x066B; |
| Separator, Arabic Phrase | &amp;#x066C; | &#x066C; |
| Separator, Arabic Thousands | &amp;#x066C; | &#x066C; |
| Separator, Decimal | &amp;#x002C; | &#x002C; |
| Separator, Devanagari Phrase | &amp;#x0964; | &#x0964; |
| Separator, Ethiopic Paragraph | &amp;#x1368; | &#x1368; |
| Separator, File | &amp;#x001C; | &#x001C; |
| Separator, Georgian Paragraph | &amp;#x10FB; | &#x10FB; |
| Separator, Group | &amp;#x001D; | &#x001D; |
| Separator, Interlinear Annotation | &amp;#xFFFA; | &#xFFFA; |
| Separator, Invisible | &amp;#x2063; | &#x2063; |
| Separator, Line | &amp;#x2028; | &#x2028; |
| Separator, Mongolian Vowel | &amp;#x180E; | &#x180E; |
| Separator, Paragraph | &amp;#x2029; | &#x2029; |
| Separator, Record | &amp;#x001E; | &#x001E; |
| Separator, Unit | &amp;#x001F; | &#x001F; |
| Separator, Urdu Paragraph | &amp;#x203B; | &#x203B; |
| Septuagint | &amp;#x1D516; | &#x1D516; |
| Sequence Bracket, Left | &amp;#x27E8; | &#x27E8; |
| Sequence Bracket, Right | &amp;#x27E9; | &#x27E9; |
| Sequence Concatenation | &amp;#x2040; | &#x2040; |
| Sequence Introducer, Control | &amp;#x009B; | &#x009B; |
| Service Mark | &amp;#x2120; | &#x2120; |
| Sesame Dot | &amp;#xFE45; | &#xFE45; |
| Sesame Dot, White | &amp;#xFE46; | &#xFE46; |
| Set Membership Signs | &amp;#x2208; | &#x2208; |
| Set Minus | &amp;#x2216; | &#x2216; |
| Set Of Complex Numbers, The | &amp;#x2102; | &#x2102; |
| Set Of Integers, The | &amp;#x2124; | &#x2124; |
| Set Of Rational Numbers, The | &amp;#x211A; | &#x211A; |
| Set Of Real Numbers, The | &amp;#x211D; | &#x211D; |
| Set Transmit State | &amp;#x0093; | &#x0093; |
| Set, Empty | &amp;#x2205; | &#x2205; |
| Set, Included In | &amp;#x2282; | &#x2282; |
| Set, Includes In | &amp;#x2283; | &#x2283; |
| Set, Null | &amp;#x2205; | &#x2205; |
| Set, Power | &amp;#x1D4AB; | &#x1D4AB; |
| Sets, Empty | &amp;#x29B0; | &#x29B0; |
| Sextile | &amp;#x2736; | &#x2736; |
| Shade Characters | &amp;#x2591; | &#x2591; |
| Shadowed White Circle | &amp;#x274D; | &#x274D; |
| Shamrock | &amp;#x2618; | &#x2618; |
| Shamrock | &amp;#x2663; | &#x2663; |
| Shapes, Geometric | &amp;#x25A0; | &#x25A0; |
| Sharp S, Latin Small Letter | &amp;#x00DF; | &#x00DF; |
| Sharp Sign, Music | &amp;#x266F; | &#x266F; |
| Shavian | &amp;#x10450; | &#x10450; |
| Sheqel Sign, New | &amp;#x20AA; | &#x20AA; |
| Shesht, Armenian | &amp;#x055B; | &#x055B; |
| Shift | &amp;#x21E7; | &#x21E7; |
| Shift In | &amp;#x000F; | &#x000F; |
| Shift In, Symbol For | &amp;#x240F; | &#x240F; |
| Shift Out | &amp;#x000E; | &#x000E; |
| Shift Out, Symbol For | &amp;#x240E; | &#x240E; |
| Shogi Piece, Black | &amp;#x2617; | &#x2617; |
| Shogi Piece, White | &amp;#x2616; | &#x2616; |
| Short | &amp;#x0306; | &#x0306; |
| Short Slash Overlay | &amp;#x0337; | &#x0337; |
| Short Solidus Overlay, Combining | &amp;#x0337; | &#x0337; |
| Short Stroke Overlay, Combining | &amp;#x0335; | &#x0335; |
| Short Vertical Line Overlay, Combining | &amp;#x20D3; | &#x20D3; |
| Shouldered Open Box | &amp;#x237D; | &#x237D; |
| Showery Weather | &amp;#x2614; | &#x2614; |
| Shuffle Product | &amp;#x29E2; | &#x29E2; |
| Sibe Syllable Boundary Marker, Mongolian | &amp;#x1807; | &#x1807; |
| Sidelining Emphasis Marks | &amp;#xFE45; | &#xFE45; |
| Sideways Diaeresized U, Latin Small Letter | &amp;#x1D1E; | &#x1D1E; |
| Sideways O With Stroke, Latin Small Letter | &amp;#x1D13; | &#x1D13; |
| Sideways O, Latin Small Letter | &amp;#x1D11; | &#x1D11; |
| Sideways Open O, Latin Small Letter | &amp;#x1D12; | &#x1D12; |
| Sideways Turned M, Latin Small Letter | &amp;#x1D1F; | &#x1D1F; |
| Sideways U, Latin Small Letter | &amp;#x1D1D; | &#x1D1D; |
| Sigma Symbol, Greek Lunate | &amp;#x03F2; | &#x03F2; |
| Sigma, Greek Small Letter Lunate | &amp;#x03F2; | &#x03F2; |
| Signs, Warning | &amp;#x2620; | &#x2620; |
| Signs, Warning | &amp;#x26A0; | &#x26A0; |
| Similar To | &amp;#x223C; | &#x223C; |
| Sine Wave | &amp;#x223F; | &#x223F; |
| Single Character Introducer | &amp;#x009A; | &#x009A; |
| Single Comma Quotation Mark | &amp;#x2019; | &#x2019; |
| Single Comma Quotation Mark, Low | &amp;#x201A; | &#x201A; |
| Single Guillemet, Left Pointing | &amp;#x2039; | &#x2039; |
| Single Guillemet, Right Pointing | &amp;#x203A; | &#x203A; |
| Single High-Reversed-9 Quotation Mark | &amp;#x201B; | &#x201B; |
| Single Left-Pointing Angle Quotation Mark | &amp;#x2039; | &#x2039; |
| Single Low-9 Quotation Mark | &amp;#x201A; | &#x201A; |
| Single Punctuation, Philippine | &amp;#x1735; | &#x1735; |
| Single Quotation Mark, Left | &amp;#x2018; | &#x2018; |
| Single Quotation Mark, Neutral | &amp;#x0027; | &#x0027; |
| Single Quotation Mark, Right | &amp;#x2019; | &#x2019; |
| Single Reversed Comma Quotation Mark | &amp;#x201B; | &#x201B; |
| Single Right-Pointing Angle Quotation Mark | &amp;#x203A; | &#x203A; |
| Single Shift Three | &amp;#x008F; | &#x008F; |
| Single Shift Two | &amp;#x008E; | &#x008E; |
| Single Turned Comma Quotation Mark | &amp;#x2018; | &#x2018; |
| Sinhala | &amp;#x0D80; | &#x0D80; |
| Sinhala Consonants | &amp;#x0D9A; | &#x0D9A; |
| Sinhala Dependent Vowel Signs | &amp;#x0DCF; | &#x0DCF; |
| Sinhala Independent Vowels | &amp;#x0D85; | &#x0D85; |
| Sinhala Sign Al-Lakuna | &amp;#x0DCA; | &#x0DCA; |
| Sinhala Virama | &amp;#x0DCA; | &#x0DCA; |
| Six-Per-Em Space | &amp;#x2006; | &#x2006; |
| Sixteenth Notes, Beamed | &amp;#x266C; | &#x266C; |
| Sixths, Fractions | &amp;#x2159; | &#x2159; |
| Skull And Crossbones | &amp;#x2620; | &#x2620; |
| Slash | &amp;#x002F; | &#x002F; |
| Slash Overlay, Long | &amp;#x0338; | &#x0338; |
| Slash Overlay, Long Double | &amp;#x20EB; | &#x20EB; |
| Slash Overlay, Short | &amp;#x0337; | &#x0337; |
| Slash, Circled Division | &amp;#x2298; | &#x2298; |
| Slash, Division | &amp;#x2215; | &#x2215; |
| Slash, Fraction | &amp;#x2044; | &#x2044; |
| Slash, Latin Capital Letter O | &amp;#x00D8; | &#x00D8; |
| Slash, Latin Small Letter O | &amp;#x00F8; | &#x00F8; |
| Slope | &amp;#x2333; | &#x2333; |
| Small Capital Ae, Latin Letter | &amp;#x1D01; | &#x1D01; |
| Small Capital Eth, Latin Letter | &amp;#x1D06; | &#x1D06; |
| Small Capital Ezh, Latin Letter | &amp;#x1D23; | &#x1D23; |
| Small Capital Oe, Latin Letter | &amp;#x0276; | &#x0276; |
| Small Capital Ou, Latin Letter | &amp;#x1D15; | &#x1D15; |
| Small Circle, Black | &amp;#x2022; | &#x2022; |
| Small Contains As Member | &amp;#x220D; | &#x220D; |
| Small Element Of | &amp;#x220A; | &#x220A; |
| Small Form Variants | &amp;#xFE50; | &#xFE50; |
| Small Gamma, Double-Struck | &amp;#x213D; | &#x213D; |
| Small Gamma, Modifier Letter | &amp;#x02E0; | &#x02E0; |
| Small Ka, Hiragana Letter | &amp;#x3095; | &#x3095; |
| Small Ke, Hiragana Letter | &amp;#x3096; | &#x3096; |
| Small Letters, Armenian | &amp;#x0561; | &#x0561; |
| Small Letters, Combining Latin | &amp;#x0363; | &#x0363; |
| Small Letters, Cyrillic | &amp;#x0430; | &#x0430; |
| Small Letters, Georgian | &amp;#x10D0; | &#x10D0; |
| Small Letters, Greek | &amp;#x03B1; | &#x03B1; |
| Small Letters, Latin | &amp;#x0061; | &#x0061; |
| Small Ligature Ae, Latin | &amp;#x00E6; | &#x00E6; |
| Small Ligature Ij, Latin | &amp;#x0133; | &#x0133; |
| Small Ligature Oe, Latin | &amp;#x0153; | &#x0153; |
| Small Pi, Double-Struck | &amp;#x213C; | &#x213C; |
| Small Reversed Glottal Stop, Modifier Letter | &amp;#x02E4; | &#x02E4; |
| Small Square, Black Medium | &amp;#x25FE; | &#x25FE; |
| Small Tilde | &amp;#x02DC; | &#x02DC; |
| Small White Circle, Medium | &amp;#x26AC; | &#x26AC; |
| Smash Product | &amp;#x2A33; | &#x2A33; |
| Smile | &amp;#x2323; | &#x2323; |
| Smiling Face, Black | &amp;#x263B; | &#x263B; |
| Smiling Face, White | &amp;#x263A; | &#x263A; |
| Smirk | &amp;#x2368; | &#x2368; |
| Smooth Breathing Mark, Greek | &amp;#x0313; | &#x0313; |
| Snowflake Dingbats | &amp;#x2744; | &#x2744; |
| Snowflakes | &amp;#x2721; | &#x2721; |
| Snowman | &amp;#x2603; | &#x2603; |
| Snowy Weather | &amp;#x2603; | &#x2603; |
| Soft Hyphen | &amp;#x00AD; | &#x00AD; |
| Soft Hyphen, Mongolian Todo | &amp;#x1806; | &#x1806; |
| Software-Function Symbol | &amp;#x2394; | &#x2394; |
| Solid | &amp;#x2588; | &#x2588; |
| Solidus | &amp;#x002F; | &#x002F; |
| Solidus | &amp;#x2044; | &#x2044; |
| Solidus Operator, Double | &amp;#x2AFD; | &#x2AFD; |
| Solidus Operator, Reverse | &amp;#x29F5; | &#x29F5; |
| Solidus Overlay, Combining Long | &amp;#x0338; | &#x0338; |
| Solidus Overlay, Combining Long Double | &amp;#x20EB; | &#x20EB; |
| Solidus Overlay, Combining Reverse | &amp;#x20E5; | &#x20E5; |
| Solidus Overlay, Combining Short | &amp;#x0337; | &#x0337; |
| Solidus, Big | &amp;#x29F8; | &#x29F8; |
| Solidus, Big Reverse | &amp;#x29F9; | &#x29F9; |
| Solidus, Reverse | &amp;#x005C; | &#x005C; |
| Sound Recording Copyright | &amp;#x2117; | &#x2117; |
| Source, Information | &amp;#x2139; | &#x2139; |
| Space | &amp;#x0020; | &#x0020; |
| Space Mark, Ogham | &amp;#x1680; | &#x1680; |
| Space, Em | &amp;#x2003; | &#x2003; |
| Space, En | &amp;#x2002; | &#x2002; |
| Space, Figure | &amp;#x2007; | &#x2007; |
| Space, Four-Per-Em | &amp;#x2005; | &#x2005; |
| Space, Graphic For | &amp;#x2423; | &#x2423; |
| Space, Hair | &amp;#x200A; | &#x200A; |
| Space, Hilbert | &amp;#x210C; | &#x210C; |
| Space, Ideographic | &amp;#x3000; | &#x3000; |
| Space, Ideographic Half Fill | &amp;#x303F; | &#x303F; |
| Space, Keyboard Symbol For No Break | &amp;#x237D; | &#x237D; |
| Space, Medium Mathematical | &amp;#x205F; | &#x205F; |
| Space, Mid | &amp;#x2005; | &#x2005; |
| Space, Narrow No-Break | &amp;#x202F; | &#x202F; |
| Space, No-Break | &amp;#x00A0; | &#x00A0; |
| Space, Non-Breaking | &amp;#x00A0; | &#x00A0; |
| Space, Punctuation | &amp;#x2008; | &#x2008; |
| Space, Six-Per-Em | &amp;#x2006; | &#x2006; |
| Space, Symbol For | &amp;#x2420; | &#x2420; |
| Space, Thick | &amp;#x2004; | &#x2004; |
| Space, Thin | &amp;#x2009; | &#x2009; |
| Space, Three-Per-Em | &amp;#x2004; | &#x2004; |
| Space, Zero Width | &amp;#x200B; | &#x200B; |
| Space, Zero Width No-Break | &amp;#xFEFF; | &#xFEFF; |
| Spaces | &amp;#x2000; | &#x2000; |
| Spacing Acute Accent | &amp;#x00B4; | &#x00B4; |
| Spacing Cedilla | &amp;#x00B8; | &#x00B8; |
| Spacing Circumflex Accent | &amp;#x005E; | &#x005E; |
| Spacing Clones Of Diacritics | &amp;#x02D8; | &#x02D8; |
| Spacing Diaeresis | &amp;#x00A8; | &#x00A8; |
| Spacing Double Underscore | &amp;#x2017; | &#x2017; |
| Spacing Grave Accent | &amp;#x0060; | &#x0060; |
| Spacing Macron | &amp;#x00AF; | &#x00AF; |
| Spacing Modifier Letters | &amp;#x02B0; | &#x02B0; |
| Spacing Overscore | &amp;#x203E; | &#x203E; |
| Spacing Tilde | &amp;#x007E; | &#x007E; |
| Spacing Underscore | &amp;#x005F; | &#x005F; |
| Spanish Currency | &amp;#x20A7; | &#x20A7; |
| Sparkle | &amp;#x2747; | &#x2747; |
| Sparkle, Heavy | &amp;#x2748; | &#x2748; |
| Specials | &amp;#xFFF0; | &#xFFF0; |
| Specials Area, Compatibility And | &amp;#xF900; | &#xF900; |
| Spherical Angle | &amp;#x2222; | &#x2222; |
| Square Below, Combining | &amp;#x033B; | &#x033B; |
| Square Bracket With Quill, Left | &amp;#x2045; | &#x2045; |
| Square Bracket With Quill, Right | &amp;#x2046; | &#x2046; |
| Square Bracket, Closing | &amp;#x005D; | &#x005D; |
| Square Bracket, Left | &amp;#x005B; | &#x005B; |
| Square Bracket, Left White | &amp;#x301A; | &#x301A; |
| Square Bracket, Opening | &amp;#x005B; | &#x005B; |
| Square Bracket, Right | &amp;#x005D; | &#x005D; |
| Square Bracket, Right White | &amp;#x301B; | &#x301B; |
| Square Cap | &amp;#x2293; | &#x2293; |
| Square Cup | &amp;#x2294; | &#x2294; |
| Square Foot | &amp;#x23CD; | &#x23CD; |
| Square Image Of | &amp;#x228F; | &#x228F; |
| Square Lozenge | &amp;#x2311; | &#x2311; |
| Square Original Of | &amp;#x2290; | &#x2290; |
| Square Root | &amp;#x221A; | &#x221A; |
| Square Symbols | &amp;#x29C4; | &#x29C4; |
| Square, Black Medium | &amp;#x25FC; | &#x25FC; |
| Square, Black Medium Small | &amp;#x25FE; | &#x25FE; |
| Square, Combining Enclosing | &amp;#x20DE; | &#x20DE; |
| Square, Viewdata | &amp;#x2317; | &#x2317; |
| Squared | &amp;#x00B2; | &#x00B2; |
| Squared Dot Operator | &amp;#x22A1; | &#x22A1; |
| Squared Japanese Katakana Words | &amp;#x3300; | &#x3300; |
| Squared Latin Abbreviations | &amp;#x3371; | &#x3371; |
| Squared Minus | &amp;#x229F; | &#x229F; |
| Squared Plus | &amp;#x229E; | &#x229E; |
| Squared Times | &amp;#x22A0; | &#x22A0; |
| Squares | &amp;#x25A0; | &#x25A0; |
| Squares | &amp;#x2B1A; | &#x2B1A; |
| Squat Reversed Esh, Latin Small Letter | &amp;#x0285; | &#x0285; |
| Srak Ah, Khmer | &amp;#x17C7; | &#x17C7; |
| Srak Am, Khmer | &amp;#x17C6; | &#x17C6; |
| Srog Med, Tibetan | &amp;#x0F84; | &#x0F84; |
| St. Andrew's Cross | &amp;#x2613; | &#x2613; |
| Staff Of Aesculapius | &amp;#x2695; | &#x2695; |
| Staff Of Hermes | &amp;#x269A; | &#x269A; |
| Star | &amp;#x002A; | &#x002A; |
| Star And Crescent | &amp;#x262A; | &#x262A; |
| Star Dingbats | &amp;#x2726; | &#x2726; |
| Star Equals | &amp;#x225B; | &#x225B; |
| Star Of David | &amp;#x2721; | &#x2721; |
| Star Operator | &amp;#x22C6; | &#x22C6; |
| Star, Arabic Five Pointed | &amp;#x066D; | &#x066D; |
| Star, Black | &amp;#x2605; | &#x2605; |
| Star, White | &amp;#x2606; | &#x2606; |
| Starburst | &amp;#x273A; | &#x273A; |
| Stars | &amp;#x2721; | &#x2721; |
| Start Of Guarded Area | &amp;#x0096; | &#x0096; |
| Start Of Heading | &amp;#x0001; | &#x0001; |
| Start Of Heading, Symbol For | &amp;#x2401; | &#x2401; |
| Start Of Selected Area | &amp;#x0086; | &#x0086; |
| Start Of String | &amp;#x0098; | &#x0098; |
| Start Of Text | &amp;#x0002; | &#x0002; |
| Start Of Text, Symbol For | &amp;#x2402; | &#x2402; |
| Statement Is True | &amp;#x22A8; | &#x22A8; |
| Sterling, Pound | &amp;#x00A3; | &#x00A3; |
| Stile, Apl | &amp;#x2223; | &#x2223; |
| Straight Epsilon | &amp;#x03F5; | &#x03F5; |
| Straight Epsilon, Reversed | &amp;#x03F6; | &#x03F6; |
| Straightness | &amp;#x23E4; | &#x23E4; |
| Stress Mark | &amp;#x0301; | &#x0301; |
| Stretched C, Latin Letter | &amp;#x0297; | &#x0297; |
| Strictly Equivalent To | &amp;#x2263; | &#x2263; |
| String Terminator | &amp;#x009C; | &#x009C; |
| String, Device Control | &amp;#x0090; | &#x0090; |
| String, Start Of | &amp;#x0098; | &#x0098; |
| Stroke Overlay, Combining Double Vertical | &amp;#x20E6; | &#x20E6; |
| Stroke Overlay, Combining Long | &amp;#x0336; | &#x0336; |
| Stroke Overlay, Combining Short | &amp;#x0335; | &#x0335; |
| Stroke, Latin Capital Letter O With | &amp;#x00D8; | &#x00D8; |
| Stroke, Latin Small Letter O With | &amp;#x00F8; | &#x00F8; |
| Strokes, Cjk | &amp;#x31C0; | &#x31C0; |
| Subgroup Of, Normal | &amp;#x22B2; | &#x22B2; |
| Subgroup Signs, Normal | &amp;#x22EA; | &#x22EA; |
| Subgroup, Contains As Normal | &amp;#x22B3; | &#x22B3; |
| Subjoined Consonants, Tibetan | &amp;#x0F90; | &#x0F90; |
| Subscript Digits | &amp;#x2080; | &#x2080; |
| Subscript, Greek Iota | &amp;#x0345; | &#x0345; |
| Subscripts | &amp;#x2080; | &#x2080; |
| Subset And Superset Relations | &amp;#x2ABD; | &#x2ABD; |
| Subset Of | &amp;#x2282; | &#x2282; |
| Subset Of, Not A | &amp;#x2284; | &#x2284; |
| Subset Signs, Superset And | &amp;#x2282; | &#x2282; |
| Subset, Double | &amp;#x22D0; | &#x22D0; |
| Substitute | &amp;#x001A; | &#x001A; |
| Substitute Form Two, Symbol For | &amp;#x2426; | &#x2426; |
| Substitute, Symbol For | &amp;#x241A; | &#x241A; |
| Subtending Marks, Arabic | &amp;#x0600; | &#x0600; |
| Subtraction, Bag | &amp;#x2A41; | &#x2A41; |
| Subtraction, Saturating | &amp;#x2238; | &#x2238; |
| Succeeds | &amp;#x227B; | &#x227B; |
| Succeeds Under Relation | &amp;#x22B1; | &#x22B1; |
| Succeeds, Double | &amp;#x2ABC; | &#x2ABC; |
| Such That | &amp;#x220B; | &#x220B; |
| Such That | &amp;#x2223; | &#x2223; |
| Suits, Playing Card | &amp;#x2660; | &#x2660; |
| Sum Or Positive Difference | &amp;#x2A26; | &#x2A26; |
| Sum, Direct | &amp;#x2295; | &#x2295; |
| Sum, Positive Difference Or | &amp;#x2A24; | &#x2A24; |
| Summation Sign | &amp;#x2211; | &#x2211; |
| Summation Sign Parts | &amp;#x23B2; | &#x23B2; |
| Summation, Double-Struck N-Ary | &amp;#x2140; | &#x2140; |
| Summation, N-Ary | &amp;#x2211; | &#x2211; |
| Summations And Integrals | &amp;#x2A0A; | &#x2A0A; |
| Sun | &amp;#x2609; | &#x2609; |
| Sun With Rays, Black | &amp;#x2600; | &#x2600; |
| Sun With Rays, White | &amp;#x263C; | &#x263C; |
| Sundanese | &amp;#x1B80; | &#x1B80; |
| Sunna, Telugu | &amp;#x0C02; | &#x0C02; |
| Superscript Digits | &amp;#x2070; | &#x2070; |
| Superscript Letter Diacritics, Latin Medieval | &amp;#x1DD3; | &#x1DD3; |
| Superscript Letter Diacritics, Medieval | &amp;#x0363; | &#x0363; |
| Superscript Modifier Letters, Latin | &amp;#x02B0; | &#x02B0; |
| Superscript One | &amp;#x00B9; | &#x00B9; |
| Superscript Three | &amp;#x00B3; | &#x00B3; |
| Superscript Two | &amp;#x00B2; | &#x00B2; |
| Superscript Zero | &amp;#x2070; | &#x2070; |
| Superscripts | &amp;#x2070; | &#x2070; |
| Superset And Subset Signs | &amp;#x2282; | &#x2282; |
| Superset Of | &amp;#x2283; | &#x2283; |
| Superset Of, Not A | &amp;#x2285; | &#x2285; |
| Superset Relations, Subset And | &amp;#x2ABD; | &#x2ABD; |
| Superset, Double | &amp;#x22D1; | &#x22D1; |
| Supplemental Arrows-B | &amp;#x2900; | &#x2900; |
| Supplemental Mathematical Operators | &amp;#x2A00; | &#x2A00; |
| Supplemental Punctuation | &amp;#x2E00; | &#x2E00; |
| Supplementary Cjk Ideographs Area | &amp;#x20000; | &#x20000; |
| Supplementary General Scripts Area | &amp;#x10000; | &#x10000; |
| Supplementary Private Use Area-A | &amp;#xF0000; | &#xF0000; |
| Supplementary Private Use Area-B | &amp;#x100000; | &#x100000; |
| Surface Integral | &amp;#x222F; | &#x222F; |
| Surjection, Finite | &amp;#x2901; | &#x2901; |
| Surjection, Partial | &amp;#x2900; | &#x2900; |
| Surjection, Total | &amp;#x21A0; | &#x21A0; |
| Surjective Injection | &amp;#x2917; | &#x2917; |
| Surjective Injection, Finite | &amp;#x2918; | &#x2918; |
| Surrogates Area | &amp;#xD800; | &#xD800; |
| Surrogates, High | &amp;#xD800; | &#xD800; |
| Surrogates, Low | &amp;#xDC00; | &#xDC00; |
| Suzhou Numerals | &amp;#x3021; | &#x3021; |
| Swash Tail, Latin Small Letter S With | &amp;#x023F; | &#x023F; |
| Swash Tail, Latin Small Letter Z With | &amp;#x0240; | &#x0240; |
| Swedish Grave Accent | &amp;#x02DF; | &#x02DF; |
| Swords, Crossed | &amp;#x2694; | &#x2694; |
| Swung Dash | &amp;#x2053; | &#x2053; |
| Syllabary, Cypriot | &amp;#x10800; | &#x10800; |
| Syllabary, Linear B | &amp;#x10000; | &#x10000; |
| Syllabics Full Stop, Canadian | &amp;#x166E; | &#x166E; |
| Syllabics Punctuation, Canadian | &amp;#x166D; | &#x166D; |
| Syllabics, Unified Canadian Aboriginal | &amp;#x1400; | &#x1400; |
| Syllables, Cherokee | &amp;#x13A0; | &#x13A0; |
| Syllables, Circled Korean Hangul | &amp;#x326E; | &#x326E; |
| Syllables, Ethiopic | &amp;#x1200; | &#x1200; |
| Syllables, Korean Hangul | &amp;#xAC00; | &#xAC00; |
| Syllables, Parenthesized Korean Hangul | &amp;#x320E; | &#x320E; |
| Syllables, Yi | &amp;#xA000; | &#xA000; |
| Syloti Nagri | &amp;#xA800; | &#xA800; |
| Symbol Variants, Fullwidth | &amp;#xFFE0; | &#xFFE0; |
| Symbol Variants, Halfwidth | &amp;#xFFE8; | &#xFFE8; |
| Symbols And Punctuation, Cjk | &amp;#x3000; | &#x3000; |
| Symbols Area | &amp;#x2000; | &#x2000; |
| Symbols Area, Cjk Phonetics And | &amp;#x2E80; | &#x2E80; |
| Symbols For Days, Ideographic Telegraph | &amp;#x33E0; | &#x33E0; |
| Symbols For Divination, Khmer Numeric | &amp;#x17F0; | &#x17F0; |
| Symbols For Hours, Ideographic Telegraph | &amp;#x3358; | &#x3358; |
| Symbols For Months, Ideographic Telegraph | &amp;#x32C0; | &#x32C0; |
| Symbols, Ancient Greek Textual | &amp;#x2E0E; | &#x2E0E; |
| Symbols, Apl Functional | &amp;#x2336; | &#x2336; |
| Symbols, Ascii Punctuation And | &amp;#x0020; | &#x0020; |
| Symbols, Astrological | &amp;#x263D; | &#x263D; |
| Symbols, Balinese Musical | &amp;#x1B61; | &#x1B61; |
| Symbols, Basic Musical | &amp;#x2669; | &#x2669; |
| Symbols, Bowtie | &amp;#x29D1; | &#x29D1; |
| Symbols, Byzantine Musical | &amp;#x1D000; | &#x1D000; |
| Symbols, Chess | &amp;#x2654; | &#x2654; |
| Symbols, Circle | &amp;#x29B5; | &#x29B5; |
| Symbols, Combining Diacritical Marks For | &amp;#x20D0; | &#x20D0; |
| Symbols, Currency | &amp;#x20A0; | &#x20A0; |
| Symbols, Dentistry Notation | &amp;#x23BE; | &#x23BE; |
| Symbols, Diacritical Marks For | &amp;#x20D0; | &#x20D0; |
| Symbols, Dictionary And Map | &amp;#x2690; | &#x2690; |
| Symbols, Drafting | &amp;#x232D; | &#x232D; |
| Symbols, Electrotechnical | &amp;#x238D; | &#x238D; |
| Symbols, Error Bar | &amp;#x29EE; | &#x29EE; |
| Symbols, Gender | &amp;#x26A2; | &#x26A2; |
| Symbols, Genealogical | &amp;#x26AD; | &#x26AD; |
| Symbols, Greek Mathematical | &amp;#x1D6A8; | &#x1D6A8; |
| Symbols, Hebrew Letterlike Mathematical | &amp;#x2135; | &#x2135; |
| Symbols, I Ching / Yijing Hexagram | &amp;#x4DC0; | &#x4DC0; |
| Symbols, I Ching / Yijing Monogram And Digram | &amp;#x268A; | &#x268A; |
| Symbols, I Ching / Yijing Trigram | &amp;#x2630; | &#x2630; |
| Symbols, Japanese Chess | &amp;#x2616; | &#x2616; |
| Symbols, Keyboard | &amp;#x21E6; | &#x21E6; |
| Symbols, Keyboard | &amp;#x2324; | &#x2324; |
| Symbols, Keyboard | &amp;#x2380; | &#x2380; |
| Symbols, Keyboard | &amp;#x2396; | &#x2396; |
| Symbols, Khmer | &amp;#x19E0; | &#x19E0; |
| Symbols, Latin-1 Punctuation And | &amp;#x00A0; | &#x00A0; |
| Symbols, Letterlike | &amp;#x2100; | &#x2100; |
| Symbols, Mathematical | &amp;#x27C0; | &#x27C0; |
| Symbols, Mathematical | &amp;#x2980; | &#x2980; |
| Symbols, Mathematical Alphanumeric | &amp;#x1D400; | &#x1D400; |
| Symbols, Mathematical Digits | &amp;#x1D7CE; | &#x1D7CE; |
| Symbols, Metrical | &amp;#x23D1; | &#x23D1; |
| Symbols, Miscellaneous | &amp;#x2600; | &#x2600; |
| Symbols, Musical | &amp;#x1D100; | &#x1D100; |
| Symbols, New Testament Editorial | &amp;#x2E00; | &#x2E00; |
| Symbols, Planet | &amp;#x263F; | &#x263F; |
| Symbols, Plastics Recycling | &amp;#x2673; | &#x2673; |
| Symbols, Playing Card | &amp;#x2660; | &#x2660; |
| Symbols, Pointing Hand | &amp;#x261A; | &#x261A; |
| Symbols, Polygonal | &amp;#x2B12; | &#x2B12; |
| Symbols, Recycling | &amp;#x2672; | &#x2672; |
| Symbols, Religious And Political | &amp;#x2625; | &#x2625; |
| Symbols, Square | &amp;#x29C4; | &#x29C4; |
| Symbols, Tai Xuan Jing | &amp;#x1D300; | &#x1D300; |
| Symbols, Tamil | &amp;#x0BF3; | &#x0BF3; |
| Symbols, Tibetan | &amp;#x0FC4; | &#x0FC4; |
| Symbols, Triangle | &amp;#x29CA; | &#x29CA; |
| Symbols, Weather And Astrological | &amp;#x2600; | &#x2600; |
| Symbols, Yijing / I Ching Hexagram | &amp;#x4DC0; | &#x4DC0; |
| Symbols, Yijing / I Ching Monogram And Digram | &amp;#x268A; | &#x268A; |
| Symbols, Yijing / I Ching Trigram | &amp;#x2630; | &#x2630; |
| Symbols, Zodiacal | &amp;#x2648; | &#x2648; |
| Symbols-A, Miscellaneous Mathematical | &amp;#x27C0; | &#x27C0; |
| Symbols-B, Miscellaneous Mathematical | &amp;#x2980; | &#x2980; |
| Symmetric Difference | &amp;#x2206; | &#x2206; |
| Symmetric Difference | &amp;#x2238; | &#x2238; |
| Symmetric Difference | &amp;#x2296; | &#x2296; |
| Symmetry | &amp;#x232F; | &#x232F; |
| Synchronous Idle | &amp;#x0016; | &#x0016; |
| Synchronous Idle, Symbol For | &amp;#x2416; | &#x2416; |
| Syriac | &amp;#x0700; | &#x0700; |
| Syriac Cross, East | &amp;#x2671; | &#x2671; |
| Syriac Cross, West | &amp;#x2670; | &#x2670; |
| Syriac Letters | &amp;#x0710; | &#x0710; |
| Syriac Punctuation And Signs | &amp;#x0700; | &#x0700; |
| Syriac Sam | &amp;#x070F; | &#x070F; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## T

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| T With Caron, Latin Small Letter | &amp;#x0165; | &#x0165; |
| T With Cedilla, Latin Small Letter | &amp;#x0163; | &#x0163; |
| T With Circumflex Below, Latin Small Letter | &amp;#x1E71; | &#x1E71; |
| T With Comma Below, Latin Small Letter | &amp;#x021B; | &#x021B; |
| T With Curl, Latin Small Letter | &amp;#x0236; | &#x0236; |
| T With Diaeresis, Latin Small Letter | &amp;#x1E97; | &#x1E97; |
| T With Diagonal Stroke, Latin Capital Letter | &amp;#x023E; | &#x023E; |
| T With Dot Above, Latin Small Letter | &amp;#x1E6B; | &#x1E6B; |
| T With Dot Below, Latin Small Letter | &amp;#x1E6D; | &#x1E6D; |
| T With Hook, Latin Small Letter | &amp;#x01AD; | &#x01AD; |
| T With Line Below, Latin Small Letter | &amp;#x1E6F; | &#x1E6F; |
| T With Palatal Hook, Latin Small Letter | &amp;#x01AB; | &#x01AB; |
| T With Retroflex Hook, Latin Capital Letter | &amp;#x01AE; | &#x01AE; |
| T With Retroflex Hook, Latin Small Letter | &amp;#x0288; | &#x0288; |
| T With Stroke, Latin Small Letter | &amp;#x0167; | &#x0167; |
| T, Combining Latin Small Letter | &amp;#x036D; | &#x036D; |
| T, Latin Letter Small Capital | &amp;#x1D1B; | &#x1D1B; |
| T, Latin Small Letter Turned | &amp;#x0287; | &#x0287; |
| Tab | &amp;#x0009; | &#x0009; |
| Tab With Shift Tab | &amp;#x21B9; | &#x21B9; |
| Tab, Leftward | &amp;#x21E4; | &#x21E4; |
| Tab, Rightward | &amp;#x21E5; | &#x21E5; |
| Tabulation Set, Character | &amp;#x0088; | &#x0088; |
| Tabulation Set, Line | &amp;#x008A; | &#x008A; |
| Tabulation With Justification, Character | &amp;#x0089; | &#x0089; |
| Tabulation, Character | &amp;#x0009; | &#x0009; |
| Tabulation, Horizontal | &amp;#x0009; | &#x0009; |
| Tabulation, Line | &amp;#x000B; | &#x000B; |
| Tabulation, Symbol For Horizontal | &amp;#x2409; | &#x2409; |
| Tabulation, Symbol For Vertical | &amp;#x240B; | &#x240B; |
| Tabulation, Vertical | &amp;#x000B; | &#x000B; |
| Tack Below, Combining Down | &amp;#x031E; | &#x031E; |
| Tack Below, Combining Left | &amp;#x0318; | &#x0318; |
| Tack Below, Combining Right | &amp;#x0319; | &#x0319; |
| Tack Below, Combining Up | &amp;#x031D; | &#x031D; |
| Tack, Down | &amp;#x22A4; | &#x22A4; |
| Tack, Left | &amp;#x22A3; | &#x22A3; |
| Tack, Modifier Letter Up | &amp;#x02D4; | &#x02D4; |
| Tack, Right | &amp;#x22A2; | &#x22A2; |
| Tack, Up | &amp;#x22A5; | &#x22A5; |
| Tacks And Turnstiles | &amp;#x22A2; | &#x22A2; |
| Tacks And Turnstiles | &amp;#x27D8; | &#x27D8; |
| Tacks And Turnstiles | &amp;#x2ADE; | &#x2ADE; |
| Tagalog | &amp;#x1700; | &#x1700; |
| Tagalog Sign Virama | &amp;#x1714; | &#x1714; |
| Tagbanwa | &amp;#x1760; | &#x1760; |
| Tags | &amp;#xE0000; | &#xE0000; |
| Tai Le | &amp;#x1950; | &#x1950; |
| Tai Lue Digits, New | &amp;#x19D0; | &#x19D0; |
| Tai Lue, New | &amp;#x1980; | &#x1980; |
| Tai Xuan Jing Symbols | &amp;#x1D300; | &#x1D300; |
| Tails, Fish | &amp;#x297C; | &#x297C; |
| Tainome Japanese Bullet | &amp;#x25C9; | &#x25C9; |
| Take, Prescription | &amp;#x211E; | &#x211E; |
| Tamil | &amp;#x0B80; | &#x0B80; |
| Tamil As Above Sign | &amp;#x0BF8; | &#x0BF8; |
| Tamil Aytham | &amp;#x0B83; | &#x0B83; |
| Tamil Consonants | &amp;#x0B95; | &#x0B95; |
| Tamil Credit Sign | &amp;#x0BF7; | &#x0BF7; |
| Tamil Day Sign | &amp;#x0BF3; | &#x0BF3; |
| Tamil Debit Sign | &amp;#x0BF6; | &#x0BF6; |
| Tamil Dependent Vowel Signs | &amp;#x0BBE; | &#x0BBE; |
| Tamil Digits | &amp;#x0BE7; | &#x0BE7; |
| Tamil Enn | &amp;#x0BFA; | &#x0BFA; |
| Tamil Independent Vowels | &amp;#x0B85; | &#x0B85; |
| Tamil Maatham | &amp;#x0BF4; | &#x0BF4; |
| Tamil Merpadi | &amp;#x0BF8; | &#x0BF8; |
| Tamil Month Sign | &amp;#x0BF4; | &#x0BF4; |
| Tamil Naal | &amp;#x0BF3; | &#x0BF3; |
| Tamil Number Sign | &amp;#x0BFA; | &#x0BFA; |
| Tamil Numbers | &amp;#x0BE7; | &#x0BE7; |
| Tamil Patru | &amp;#x0BF6; | &#x0BF6; |
| Tamil Rupai | &amp;#x0BF9; | &#x0BF9; |
| Tamil Rupee Sign | &amp;#x0BF9; | &#x0BF9; |
| Tamil Sign Visarga | &amp;#x0B83; | &#x0B83; |
| Tamil Symbols | &amp;#x0BF3; | &#x0BF3; |
| Tamil Varavu | &amp;#x0BF7; | &#x0BF7; |
| Tamil Varudam | &amp;#x0BF5; | &#x0BF5; |
| Tamil Year Sign | &amp;#x0BF5; | &#x0BF5; |
| Tape Drive | &amp;#x2707; | &#x2707; |
| Taper, Conical | &amp;#x2332; | &#x2332; |
| Tatweel, Arabic | &amp;#x0640; | &#x0640; |
| Taurus | &amp;#x2649; | &#x2649; |
| Tautological Equivalent | &amp;#x29E6; | &#x29E6; |
| Tautology | &amp;#x22A8; | &#x22A8; |
| Tea, Cup Of | &amp;#x2615; | &#x2615; |
| Technical, Miscellaneous | &amp;#x2300; | &#x2300; |
| Telegraph Symbols For Days, Ideographic | &amp;#x33E0; | &#x33E0; |
| Telegraph Symbols For Hours, Ideographic | &amp;#x3358; | &#x3358; |
| Telegraph Symbols For Months, Ideographic | &amp;#x32C0; | &#x32C0; |
| Telephone Location Sign | &amp;#x2706; | &#x2706; |
| Telephone Recorder | &amp;#x2315; | &#x2315; |
| Telephone Sign | &amp;#x2121; | &#x2121; |
| Telephone, Black | &amp;#x260E; | &#x260E; |
| Telephone, White | &amp;#x260F; | &#x260F; |
| Telugu | &amp;#x0C00; | &#x0C00; |
| Telugu Consonants | &amp;#x0C15; | &#x0C15; |
| Telugu Dependent Vowel Signs | &amp;#x0C3E; | &#x0C3E; |
| Telugu Digits | &amp;#x0C66; | &#x0C66; |
| Telugu Independent Vowels | &amp;#x0C05; | &#x0C05; |
| Telugu Sign Anusvara | &amp;#x0C02; | &#x0C02; |
| Telugu Sunna | &amp;#x0C02; | &#x0C02; |
| Ten Thousand Sign, Per | &amp;#x2031; | &#x2031; |
| Tensor Product | &amp;#x2297; | &#x2297; |
| Terminal Graphic Characters | &amp;#x23B7; | &#x23B7; |
| Terminal Graphic Characters | &amp;#x2596; | &#x2596; |
| Terminator, Interlinear Annotation | &amp;#xFFFB; | &#xFFFB; |
| Terminator, String | &amp;#x009C; | &#x009C; |
| Text, End Of | &amp;#x0003; | &#x0003; |
| Text, Start Of | &amp;#x0002; | &#x0002; |
| Text, Symbol For End Of | &amp;#x2403; | &#x2403; |
| Text, Symbol For Start Of | &amp;#x2402; | &#x2402; |
| Thaana | &amp;#x0780; | &#x0780; |
| Thai | &amp;#x0E00; | &#x0E00; |
| Thai Character Angkhankhu | &amp;#x0E5A; | &#x0E5A; |
| Thai Character Fongman | &amp;#x0E4F; | &#x0E4F; |
| Thai Character Khomut | &amp;#x0E5B; | &#x0E5B; |
| Thai Character Nikhahit | &amp;#x0E4D; | &#x0E4D; |
| Thai Character Thanthakhat | &amp;#x0E4C; | &#x0E4C; |
| Thai Character Yamakkan | &amp;#x0E4E; | &#x0E4E; |
| Thai Consonants | &amp;#x0E01; | &#x0E01; |
| Thai Currency Symbol Baht | &amp;#x0E3F; | &#x0E3F; |
| Thai Digits | &amp;#x0E50; | &#x0E50; |
| Thai Marks And Signs | &amp;#x0E48; | &#x0E48; |
| Thai Vowels | &amp;#x0E30; | &#x0E30; |
| Thanthakhat, Thai Character | &amp;#x0E4C; | &#x0E4C; |
| There Does Not Exist | &amp;#x2204; | &#x2204; |
| There Exists | &amp;#x2203; | &#x2203; |
| Therefore | &amp;#x2234; | &#x2234; |
| Thermodynamic | &amp;#x29E7; | &#x29E7; |
| Theta Symbol, Greek | &amp;#x03D1; | &#x03D1; |
| Theta, Script | &amp;#x03D1; | &#x03D1; |
| Thick Space | &amp;#x2004; | &#x2004; |
| Thin Space | &amp;#x2009; | &#x2009; |
| Third Derivative | &amp;#x20DB; | &#x20DB; |
| Third Tone, Mandarin Chinese | &amp;#x02C7; | &#x02C7; |
| Thirds, Fractions | &amp;#x2153; | &#x2153; |
| Thorn, Latin Capital Letter | &amp;#x00DE; | &#x00DE; |
| Thorn, Latin Small Letter | &amp;#x00FE; | &#x00FE; |
| Thousands Separator, Arabic | &amp;#x066C; | &#x066C; |
| Three Dot Leader | &amp;#x2026; | &#x2026; |
| Three Dot Punctuation | &amp;#x2056; | &#x2056; |
| Three Dots Above, Combining | &amp;#x20DB; | &#x20DB; |
| Three Quarters, Vulgar Fraction | &amp;#x00BE; | &#x00BE; |
| Three, Superscript | &amp;#x00B3; | &#x00B3; |
| Three-Per-Em Space | &amp;#x2004; | &#x2004; |
| Thunderstorm | &amp;#x2608; | &#x2608; |
| Tibetan | &amp;#x0F00; | &#x0F00; |
| Tibetan Anusvara | &amp;#x0F7E; | &#x0F7E; |
| Tibetan Astrological Signs | &amp;#x0F15; | &#x0F15; |
| Tibetan Cantillation Signs | &amp;#x0FC0; | &#x0FC0; |
| Tibetan Consonants | &amp;#x0F40; | &#x0F40; |
| Tibetan Dependent Vowel Signs | &amp;#x0F71; | &#x0F71; |
| Tibetan Digits | &amp;#x0F20; | &#x0F20; |
| Tibetan Digits Minus Half | &amp;#x0F2A; | &#x0F2A; |
| Tibetan Head Marks | &amp;#x0F01; | &#x0F01; |
| Tibetan Ku Ru Kha | &amp;#x0FBE; | &#x0FBE; |
| Tibetan Ku Ru Kha Bzhi Mig Can | &amp;#x0FBF; | &#x0FBF; |
| Tibetan Mark Delimiter Tsheg Bstar | &amp;#x0F0C; | &#x0F0C; |
| Tibetan Mark Halanta | &amp;#x0F84; | &#x0F84; |
| Tibetan Mark Intersyllabic Tsheg | &amp;#x0F0B; | &#x0F0B; |
| Tibetan Mark Paluta | &amp;#x0F85; | &#x0F85; |
| Tibetan Marks And Signs | &amp;#x0F08; | &#x0F08; |
| Tibetan Marks And Signs | &amp;#x0F34; | &#x0F34; |
| Tibetan Marks And Signs | &amp;#x0F82; | &#x0F82; |
| Tibetan Marks And Signs | &amp;#x0FBE; | &#x0FBE; |
| Tibetan Sign Rjes Su Nga Ro | &amp;#x0F7E; | &#x0F7E; |
| Tibetan Sign Rnam Bcad | &amp;#x0F7F; | &#x0F7F; |
| Tibetan Srog Med | &amp;#x0F84; | &#x0F84; |
| Tibetan Subjoined Consonants | &amp;#x0F90; | &#x0F90; |
| Tibetan Syllable Om | &amp;#x0F00; | &#x0F00; |
| Tibetan Symbols | &amp;#x0FC4; | &#x0FC4; |
| Tibetan Visarga | &amp;#x0F7F; | &#x0F7F; |
| Tibetan Vocalic Modification | &amp;#x0F7E; | &#x0F7E; |
| Tie Below, Ligature | &amp;#x035C; | &#x035C; |
| Tie, Character | &amp;#x2040; | &#x2040; |
| Tie, Ligature | &amp;#x0361; | &#x0361; |
| Tifinagh | &amp;#x2D30; | &#x2D30; |
| Tilde | &amp;#x007E; | &#x007E; |
| Tilde Above, Combining Not | &amp;#x034A; | &#x034A; |
| Tilde Below, Combining | &amp;#x0330; | &#x0330; |
| Tilde Equals, Reversed | &amp;#x22CD; | &#x22CD; |
| Tilde Mathematical Operators | &amp;#x223B; | &#x223B; |
| Tilde Operator | &amp;#x223C; | &#x223C; |
| Tilde Overlay, Combining | &amp;#x0334; | &#x0334; |
| Tilde, Apl | &amp;#x223C; | &#x223C; |
| Tilde, Combining | &amp;#x0303; | &#x0303; |
| Tilde, Combining Double | &amp;#x0360; | &#x0360; |
| Tilde, Combining Vertical | &amp;#x033E; | &#x033E; |
| Tilde, Minus | &amp;#x2242; | &#x2242; |
| Tilde, Not | &amp;#x2241; | &#x2241; |
| Tilde, Reversed | &amp;#x223D; | &#x223D; |
| Tilde, Small | &amp;#x02DC; | &#x02DC; |
| Tilde, Spacing | &amp;#x007E; | &#x007E; |
| Tilde, Triple | &amp;#x224B; | &#x224B; |
| Tiles, Domino | &amp;#x1F030; | &#x1F030; |
| Tiles, Mahjong | &amp;#x1F000; | &#x1F000; |
| Times Operator, N-Ary | &amp;#x2A09; | &#x2A09; |
| Times, Circled | &amp;#x2297; | &#x2297; |
| Times, Division | &amp;#x22C7; | &#x22C7; |
| Times, Invisible | &amp;#x2062; | &#x2062; |
| Times, Squared | &amp;#x22A0; | &#x22A0; |
| Tiny | &amp;#x29FE; | &#x29FE; |
| Tippi, Gurmukhi | &amp;#x0A70; | &#x0A70; |
| Tironian Sign Et | &amp;#x204A; | &#x204A; |
| Todo Soft Hyphen, Mongolian | &amp;#x1806; | &#x1806; |
| Tone Letters | &amp;#x02E5; | &#x02E5; |
| Tone Letters, Modifier | &amp;#xA700; | &#xA700; |
| Tone Mark, Combining Acute | &amp;#x0341; | &#x0341; |
| Tone Mark, Combining Grave | &amp;#x0340; | &#x0340; |
| Tone Marks For Chinese, Corner | &amp;#xA700; | &#xA700; |
| Tone Marks, Contour | &amp;#x1DCB; | &#x1DCB; |
| Tone Marks, Ideographic | &amp;#x302A; | &#x302A; |
| Tone, Mandarin Chinese Fifth Or Neutral | &amp;#x02D9; | &#x02D9; |
| Tone, Mandarin Chinese First | &amp;#x02C9; | &#x02C9; |
| Tone, Mandarin Chinese Fourth | &amp;#x02CB; | &#x02CB; |
| Tone, Mandarin Chinese Second | &amp;#x02CA; | &#x02CA; |
| Tone, Mandarin Chinese Third | &amp;#x02C7; | &#x02C7; |
| Tonos, Combining Greek Dialytika | &amp;#x0344; | &#x0344; |
| Tonos, Greek | &amp;#x0301; | &#x0301; |
| Top | &amp;#x22A4; | &#x22A4; |
| Top Half Integral | &amp;#x2320; | &#x2320; |
| Tortoise Shell Bracket, Left | &amp;#x3014; | &#x3014; |
| Tortoise Shell Bracket, Left White | &amp;#x3018; | &#x3018; |
| Tortoise Shell Bracket, Right | &amp;#x3015; | &#x3015; |
| Tortoise Shell Bracket, Right White | &amp;#x3019; | &#x3019; |
| Total Function | &amp;#x2192; | &#x2192; |
| Total Injection | &amp;#x21A3; | &#x21A3; |
| Total Runout | &amp;#x2330; | &#x2330; |
| Total Surjection | &amp;#x21A0; | &#x21A0; |
| Trade Mark Sign | &amp;#x2122; | &#x2122; |
| Trade Mark Sign, Registered | &amp;#x00AE; | &#x00AE; |
| Transfinite Cardinal, First | &amp;#x2135; | &#x2135; |
| Transfinite Cardinal, Fourth | &amp;#x2138; | &#x2138; |
| Transfinite Cardinal, Second | &amp;#x2136; | &#x2136; |
| Transfinite Cardinal, Third | &amp;#x2137; | &#x2137; |
| Transform, Fourier | &amp;#x2131; | &#x2131; |
| Transmission Block, End Of | &amp;#x0017; | &#x0017; |
| Transmission Block, Symbol For End Of | &amp;#x2417; | &#x2417; |
| Transmission Symbol, End Of | &amp;#x2301; | &#x2301; |
| Transmission, End Of | &amp;#x0004; | &#x0004; |
| Transmission, Symbol For End Of | &amp;#x2404; | &#x2404; |
| Transmit State, Set | &amp;#x0093; | &#x0093; |
| Trapezium, White | &amp;#x23E2; | &#x23E2; |
| Triangle Symbols | &amp;#x29CA; | &#x29CA; |
| Triangle, Combining Enclosing Upward Pointing | &amp;#x20E4; | &#x20E4; |
| Triangle, Right | &amp;#x22BF; | &#x22BF; |
| Triangles | &amp;#x25B2; | &#x25B2; |
| Triangular Bullet | &amp;#x2023; | &#x2023; |
| Triangular Colon, Modifier Letter | &amp;#x02D0; | &#x02D0; |
| Triangular Colon, Modifier Letter Half | &amp;#x02D1; | &#x02D1; |
| Tricolon | &amp;#x205D; | &#x205D; |
| Trigram Symbols, Yijing / I Ching | &amp;#x2630; | &#x2630; |
| Trine | &amp;#x25B3; | &#x25B3; |
| Triple Integral | &amp;#x222D; | &#x222D; |
| Triple Plus | &amp;#x29FB; | &#x29FB; |
| Triple Prime | &amp;#x2034; | &#x2034; |
| Triple Prime, Reversed | &amp;#x2037; | &#x2037; |
| Triple Tilde | &amp;#x224B; | &#x224B; |
| Triple Underdot, Combining | &amp;#x20E8; | &#x20E8; |
| True | &amp;#x22A8; | &#x22A8; |
| Tsheg Bstar, Tibetan Mark Delimiter | &amp;#x0F0C; | &#x0F0C; |
| Tsheg, Tibetan Mark Intersyllabic | &amp;#x0F0B; | &#x0F0B; |
| Tugrik Sign | &amp;#x20AE; | &#x20AE; |
| Turbofan | &amp;#x274B; | &#x274B; |
| Turkish Currency | &amp;#x20A4; | &#x20A4; |
| Turkish Lira | &amp;#x00A3; | &#x00A3; |
| Turned A, Latin Small Letter | &amp;#x0250; | &#x0250; |
| Turned Ae, Latin Small Letter | &amp;#x1D02; | &#x1D02; |
| Turned Alpha, Latin Small Letter | &amp;#x0252; | &#x0252; |
| Turned Ampersand | &amp;#x214B; | &#x214B; |
| Turned Capital F | &amp;#x2132; | &#x2132; |
| Turned Comma Above, Combining | &amp;#x0312; | &#x0312; |
| Turned Comma Quotation Mark, Double | &amp;#x201C; | &#x201C; |
| Turned Comma Quotation Mark, Single | &amp;#x2018; | &#x2018; |
| Turned Comma, Modifier Letter | &amp;#x02BB; | &#x02BB; |
| Turned Delta, Latin Small Letter | &amp;#x018D; | &#x018D; |
| Turned E, Latin Capital Letter | &amp;#x018E; | &#x018E; |
| Turned E, Latin Small Letter | &amp;#x01DD; | &#x01DD; |
| Turned Greek Small Letter Iota | &amp;#x2129; | &#x2129; |
| Turned H With Fishhook, Latin Small Letter | &amp;#x02AE; | &#x02AE; |
| Turned H, Latin Small Letter | &amp;#x0265; | &#x0265; |
| Turned I, Latin Small Letter | &amp;#x1D09; | &#x1D09; |
| Turned K, Latin Small Letter | &amp;#x029E; | &#x029E; |
| Turned M With Long Leg, Latin Small Letter | &amp;#x0270; | &#x0270; |
| Turned M, Latin Capital Letter | &amp;#x019C; | &#x019C; |
| Turned M, Latin Small Letter | &amp;#x026F; | &#x026F; |
| Turned M, Latin Small Letter Sideways | &amp;#x1D1F; | &#x1D1F; |
| Turned Not Sign | &amp;#x2319; | &#x2319; |
| Turned Oe, Latin Small Letter | &amp;#x1D14; | &#x1D14; |
| Turned Open E, Latin Small Letter | &amp;#x1D08; | &#x1D08; |
| Turned Question Mark | &amp;#x00BF; | &#x00BF; |
| Turned R With Hook, Latin Small Letter | &amp;#x027B; | &#x027B; |
| Turned R With Long Leg, Latin Small Letter | &amp;#x027A; | &#x027A; |
| Turned R, Latin Letter Small Capital | &amp;#x1D1A; | &#x1D1A; |
| Turned R, Latin Small Letter | &amp;#x0279; | &#x0279; |
| Turned R, Modifier Letter Small | &amp;#x02B4; | &#x02B4; |
| Turned Sans-Serif Capital G | &amp;#x2141; | &#x2141; |
| Turned Sans-Serif Capital L | &amp;#x2142; | &#x2142; |
| Turned Sans-Serif Capital Y | &amp;#x2144; | &#x2144; |
| Turned Small F | &amp;#x214E; | &#x214E; |
| Turned T, Latin Small Letter | &amp;#x0287; | &#x0287; |
| Turned V, Latin Capital Letter | &amp;#x0245; | &#x0245; |
| Turned V, Latin Small Letter | &amp;#x028C; | &#x028C; |
| Turned W, Latin Small Letter | &amp;#x028D; | &#x028D; |
| Turned Y, Latin Small Letter | &amp;#x028E; | &#x028E; |
| Turnstile | &amp;#x22A2; | &#x22A2; |
| Turnstile, Reverse | &amp;#x22A3; | &#x22A3; |
| Turnstiles, Tacks And | &amp;#x22A2; | &#x22A2; |
| Turnstiles, Tacks And | &amp;#x27D8; | &#x27D8; |
| Turnstiles, Tacks And | &amp;#x2ADE; | &#x2ADE; |
| Two Asterisks Aligned Vertically | &amp;#x2051; | &#x2051; |
| Two Dot Leader | &amp;#x2025; | &#x2025; |
| Two Dot Punctuation | &amp;#x205A; | &#x205A; |
| Two, Superscript | &amp;#x00B2; | &#x00B2; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## U

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| U Bar, Latin Capital Letter | &amp;#x0244; | &#x0244; |
| U Bar, Latin Small Letter | &amp;#x0289; | &#x0289; |
| U With Acute, Latin Capital Letter | &amp;#x00DA; | &#x00DA; |
| U With Acute, Latin Small Letter | &amp;#x00FA; | &#x00FA; |
| U With Breve, Latin Small Letter | &amp;#x016D; | &#x016D; |
| U With Caron, Latin Small Letter | &amp;#x01D4; | &#x01D4; |
| U With Circumflex Below, Latin Small Letter | &amp;#x1E77; | &#x1E77; |
| U With Circumflex, Latin Capital Letter | &amp;#x00DB; | &#x00DB; |
| U With Circumflex, Latin Small Letter | &amp;#x00FB; | &#x00FB; |
| U With Diaeresis Below, Latin Small Letter | &amp;#x1E73; | &#x1E73; |
| U With Diaeresis, Latin Capital Letter | &amp;#x00DC; | &#x00DC; |
| U With Diaeresis, Latin Small Letter | &amp;#x00FC; | &#x00FC; |
| U With Dot Below, Latin Small Letter | &amp;#x1EE5; | &#x1EE5; |
| U With Double Acute, Latin Small Letter | &amp;#x0171; | &#x0171; |
| U With Double Grave, Latin Small Letter | &amp;#x0215; | &#x0215; |
| U With Grave, Latin Capital Letter | &amp;#x00D9; | &#x00D9; |
| U With Grave, Latin Small Letter | &amp;#x00F9; | &#x00F9; |
| U With Hook Above, Latin Small Letter | &amp;#x1EE7; | &#x1EE7; |
| U With Horn, Latin Small Letter | &amp;#x01B0; | &#x01B0; |
| U With Inverted Breve, Latin Small Letter | &amp;#x0217; | &#x0217; |
| U With Macron, Latin Small Letter | &amp;#x016B; | &#x016B; |
| U With Ogonek, Latin Small Letter | &amp;#x0173; | &#x0173; |
| U With Ring Above, Latin Small Letter | &amp;#x016F; | &#x016F; |
| U With Tilde Below, Latin Small Letter | &amp;#x1E75; | &#x1E75; |
| U With Tilde, Latin Small Letter | &amp;#x0169; | &#x0169; |
| U, Combining Latin Small Letter | &amp;#x0367; | &#x0367; |
| U, Latin Letter Small Capital | &amp;#x1D1C; | &#x1D1C; |
| U, Latin Small Letter Sideways | &amp;#x1D1D; | &#x1D1D; |
| U, Latin Small Letter Sideways Diaeresized | &amp;#x1D1E; | &#x1D1E; |
| U, Latin Subscript Small Letter | &amp;#x1D64; | &#x1D64; |
| Ugaritic | &amp;#x10380; | &#x10380; |
| Ukrainian Currency | &amp;#x20B4; | &#x20B4; |
| Umbrella | &amp;#x2602; | &#x2602; |
| Umbrella With Rain Drops | &amp;#x2614; | &#x2614; |
| Umlaut | &amp;#x0308; | &#x0308; |
| Unaspirated, Modifier Letter | &amp;#x02ED; | &#x02ED; |
| Underdot, Combining Triple | &amp;#x20E8; | &#x20E8; |
| Underline | &amp;#x0332; | &#x0332; |
| Underline Symbol, Continuous | &amp;#x2381; | &#x2381; |
| Underline Symbol, Discontinuous | &amp;#x2382; | &#x2382; |
| Underline, Double | &amp;#x0333; | &#x0333; |
| Underscore | &amp;#x0332; | &#x0332; |
| Underscore, Double | &amp;#x0333; | &#x0333; |
| Underscore, Spacing | &amp;#x005F; | &#x005F; |
| Underscore, Spacing Double | &amp;#x2017; | &#x2017; |
| Underscores, Overscores And | &amp;#xFE49; | &#xFE49; |
| Undertie | &amp;#x203F; | &#x203F; |
| Undertie, Inverted | &amp;#x2054; | &#x2054; |
| Undo Symbol | &amp;#x238C; | &#x238C; |
| Unified Canadian Aboriginal Syllabics | &amp;#x1400; | &#x1400; |
| Unified Ideographs Extension A, Cjk | &amp;#x3400; | &#x3400; |
| Unified Ideographs Extension B, Cjk | &amp;#x20000; | &#x20000; |
| Unified Ideographs, Cjk | &amp;#x4E00; | &#x4E00; |
| Union | &amp;#x222A; | &#x222A; |
| Union, Double | &amp;#x22D3; | &#x22D3; |
| Union, Generalized | &amp;#x22C3; | &#x22C3; |
| Union, Multiset | &amp;#x228E; | &#x228E; |
| Union, N-Ary | &amp;#x22C3; | &#x22C3; |
| Unions, Intersections And | &amp;#x2A40; | &#x2A40; |
| Unique Element | &amp;#x2129; | &#x2129; |
| Unit Separator | &amp;#x001F; | &#x001F; |
| Unit Separator, Symbol For | &amp;#x241F; | &#x241F; |
| Universal Quantifier | &amp;#x2200; | &#x2200; |
| Universal Recycling Symbol | &amp;#x2672; | &#x2672; |
| Unmarried Partnership Symbol | &amp;#x26AF; | &#x26AF; |
| Up Arrowhead | &amp;#x2303; | &#x2303; |
| Up Pointing Index, White | &amp;#x261D; | &#x261D; |
| Up Right Diagonal Ellipsis | &amp;#x22F0; | &#x22F0; |
| Up Tack | &amp;#x22A5; | &#x22A5; |
| Up Tack Below, Combining | &amp;#x031D; | &#x031D; |
| Up Tack, Modifier Letter | &amp;#x02D4; | &#x02D4; |
| Up, Close | &amp;#x2050; | &#x2050; |
| Up, Fast Cursor | &amp;#x219F; | &#x219F; |
| Up, Page | &amp;#x21DE; | &#x21DE; |
| Upa Modifiers | &amp;#x02EF; | &#x02EF; |
| Upper Blade Scissors | &amp;#x2701; | &#x2701; |
| Upper Integral | &amp;#x2A1B; | &#x2A1B; |
| Upper Right Pencil | &amp;#x2710; | &#x2710; |
| Uppercase Alphabet, Latin | &amp;#x0041; | &#x0041; |
| Upsilon, Latin Capital Letter | &amp;#x01B1; | &#x01B1; |
| Upsilon, Latin Small Letter | &amp;#x028A; | &#x028A; |
| Upstile, Apl | &amp;#x2308; | &#x2308; |
| Upward Pointing Triangle, Combining Enclosing | &amp;#x20E4; | &#x20E4; |
| Upwards Arrow | &amp;#x2191; | &#x2191; |
| Upwards Arrow Below, Combining | &amp;#x034E; | &#x034E; |
| Uralic Phonetic Alphabet, Diacritics For | &amp;#x0350; | &#x0350; |
| Uranus | &amp;#x2645; | &#x2645; |
| Urdu Paragraph Separator | &amp;#x203B; | &#x203B; |
| Urn, Funeral | &amp;#x26B1; | &#x26B1; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## V

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| V Above | &amp;#x030C; | &#x030C; |
| V With Dot Below, Latin Small Letter | &amp;#x1E7F; | &#x1E7F; |
| V With Hook, Latin Capital Letter | &amp;#x01B2; | &#x01B2; |
| V With Hook, Latin Small Letter | &amp;#x028B; | &#x028B; |
| V With Tilde, Latin Small Letter | &amp;#x1E7D; | &#x1E7D; |
| V, Combining Latin Small Letter | &amp;#x036E; | &#x036E; |
| V, Latin Capital Letter Script | &amp;#x01B2; | &#x01B2; |
| V, Latin Capital Letter Turned | &amp;#x0245; | &#x0245; |
| V, Latin Letter Small Capital | &amp;#x1D20; | &#x1D20; |
| V, Latin Small Letter Script | &amp;#x028B; | &#x028B; |
| V, Latin Small Letter Turned | &amp;#x028C; | &#x028C; |
| V, Latin Subscript Small Letter | &amp;#x1D65; | &#x1D65; |
| Vai | &amp;#xA500; | &#xA500; |
| Valentine | &amp;#x2665; | &#x2665; |
| Valid | &amp;#x22A8; | &#x22A8; |
| Varavu, Tamil | &amp;#x0BF7; | &#x0BF7; |
| Varia, Greek | &amp;#x0300; | &#x0300; |
| Variation Indicator, Ideographic | &amp;#x303E; | &#x303E; |
| Variation Selector One, Mongolian Free | &amp;#x180B; | &#x180B; |
| Variation Selector Three, Mongolian Free | &amp;#x180D; | &#x180D; |
| Variation Selector Two, Mongolian Free | &amp;#x180C; | &#x180C; |
| Variation Selector-1 | &amp;#xFE00; | &#xFE00; |
| Variation Selectors | &amp;#xFE00; | &#xFE00; |
| Variation Selectors Supplement | &amp;#xE0100; | &#xE0100; |
| Varies With | &amp;#x223C; | &#x223C; |
| Varudam, Tamil | &amp;#x0BF5; | &#x0BF5; |
| Vector | &amp;#x20D1; | &#x20D1; |
| Vector | &amp;#x20D7; | &#x20D7; |
| Vector Or Cross Product | &amp;#x2A2F; | &#x2A2F; |
| Vector Pointing Into Page | &amp;#x2295; | &#x2295; |
| Vector Pointing Into Page | &amp;#x2297; | &#x2297; |
| Vector Pointing Out Of Page | &amp;#x2299; | &#x2299; |
| Vee | &amp;#x2228; | &#x2228; |
| Venus | &amp;#x2640; | &#x2640; |
| Versicle | &amp;#x2123; | &#x2123; |
| Vertical Bar | &amp;#x007C; | &#x007C; |
| Vertical Bar Delimiter, Triple | &amp;#x2980; | &#x2980; |
| Vertical Bar Dingbats | &amp;#x2758; | &#x2758; |
| Vertical Bar, Broken | &amp;#x00A6; | &#x00A6; |
| Vertical Bar, N-Ary White | &amp;#x2AFF; | &#x2AFF; |
| Vertical Bar, White | &amp;#x2AFE; | &#x2AFE; |
| Vertical Bowtie | &amp;#x29D6; | &#x29D6; |
| Vertical Brackets | &amp;#x23B4; | &#x23B4; |
| Vertical Ellipsis | &amp;#x22EE; | &#x22EE; |
| Vertical Form Variants | &amp;#xFE30; | &#xFE30; |
| Vertical Four Dots | &amp;#x205E; | &#x205E; |
| Vertical Ideographic Iteration Mark | &amp;#x303B; | &#x303B; |
| Vertical Line | &amp;#x007C; | &#x007C; |
| Vertical Line Above, Combining | &amp;#x030D; | &#x030D; |
| Vertical Line Above, Combining Double | &amp;#x030E; | &#x030E; |
| Vertical Line Below, Combining | &amp;#x0329; | &#x0329; |
| Vertical Line Below, Combining Double | &amp;#x0348; | &#x0348; |
| Vertical Line Operators | &amp;#x2AEE; | &#x2AEE; |
| Vertical Line Overlay, Combining Long | &amp;#x20D2; | &#x20D2; |
| Vertical Line Overlay, Combining Short | &amp;#x20D3; | &#x20D3; |
| Vertical Line With Middle Dot | &amp;#x237F; | &#x237F; |
| Vertical Line, Double | &amp;#x2016; | &#x2016; |
| Vertical Line, Modifier Letter | &amp;#x02C8; | &#x02C8; |
| Vertical Line, Modifier Letter Low | &amp;#x02CC; | &#x02CC; |
| Vertical Lines | &amp;#x2223; | &#x2223; |
| Vertical Stroke Overlay, Combining Double | &amp;#x20E6; | &#x20E6; |
| Vertical Tabulation | &amp;#x000B; | &#x000B; |
| Vertical Tabulation, Symbol For | &amp;#x240B; | &#x240B; |
| Vertical Text, Bracket Variants For | &amp;#x23DC; | &#x23DC; |
| Vertical Text, Double Punctuation For | &amp;#x2047; | &#x2047; |
| Vertical Tilde, Combining | &amp;#x033E; | &#x033E; |
| Vertical Variants, Glyphs For | &amp;#xFE10; | &#xFE10; |
| Vertical Variants, Glyphs For | &amp;#xFE30; | &#xFE30; |
| Vertsaket, Armenian | &amp;#x0589; | &#x0589; |
| Very Much Greater-Than | &amp;#x22D9; | &#x22D9; |
| Very Much Less-Than | &amp;#x22D8; | &#x22D8; |
| Victory Hand | &amp;#x270C; | &#x270C; |
| Vietnamese Currency | &amp;#x20AB; | &#x20AB; |
| Viewdata Square | &amp;#x2317; | &#x2317; |
| Vinculum | &amp;#x0305; | &#x0305; |
| Viram, Devanagari Deergh | &amp;#x0965; | &#x0965; |
| Viram, Devanagari Purna | &amp;#x0964; | &#x0964; |
| Virama, Devanagari Sign | &amp;#x094D; | &#x094D; |
| Virama, Malayalam Sign | &amp;#x0D4D; | &#x0D4D; |
| Virama, Myanmar Sign | &amp;#x1039; | &#x1039; |
| Virama, Sinhala | &amp;#x0DCA; | &#x0DCA; |
| Virama, Tagalog Sign | &amp;#x1714; | &#x1714; |
| Virgo | &amp;#x264D; | &#x264D; |
| Virgule | &amp;#x002F; | &#x002F; |
| Visarga, Devanagari Sign | &amp;#x0903; | &#x0903; |
| Visarga, Khmer | &amp;#x17C7; | &#x17C7; |
| Visarga, Tamil Sign | &amp;#x0B83; | &#x0B83; |
| Visarga, Tibetan | &amp;#x0F7F; | &#x0F7F; |
| Voiced Fricative, Latin Letter Pharyngeal | &amp;#x0295; | &#x0295; |
| Voiced Iteration Mark, Hiragana | &amp;#x309E; | &#x309E; |
| Voiced Iteration Mark, Katakana | &amp;#x30FE; | &#x30FE; |
| Voicing, Modifier Letter | &amp;#x02EC; | &#x02EC; |
| Voltage Sign, High | &amp;#x26A1; | &#x26A1; |
| Volume Integral | &amp;#x2230; | &#x2230; |
| Vrachy, Greek | &amp;#x0306; | &#x0306; |
| Vs1 | &amp;#xFE00; | &#xFE00; |
| Vs17 | &amp;#xE0100; | &#xE0100; |
| Vt | &amp;#x000B; | &#x000B; |
| Vulgar Fraction One Half | &amp;#x00BD; | &#x00BD; |
| Vulgar Fraction One Quarter | &amp;#x00BC; | &#x00BC; |
| Vulgar Fraction Three Quarters | &amp;#x00BE; | &#x00BE; |
| Vulgar Fractions | &amp;#x2153; | &#x2153; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## W

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| W With Acute, Latin Small Letter | &amp;#x1E83; | &#x1E83; |
| W With Circumflex, Latin Small Letter | &amp;#x0175; | &#x0175; |
| W With Diaeresis, Latin Small Letter | &amp;#x1E85; | &#x1E85; |
| W With Dot Above, Latin Small Letter | &amp;#x1E87; | &#x1E87; |
| W With Dot Below, Latin Small Letter | &amp;#x1E89; | &#x1E89; |
| W With Grave, Latin Small Letter | &amp;#x1E81; | &#x1E81; |
| W With Ring Above, Latin Small Letter | &amp;#x1E98; | &#x1E98; |
| W, Latin Letter Small Capital | &amp;#x1D21; | &#x1D21; |
| W, Latin Small Letter Turned | &amp;#x028D; | &#x028D; |
| W, Modifier Letter Small | &amp;#x02B7; | &#x02B7; |
| Waiting, Message | &amp;#x0095; | &#x0095; |
| Warning Sign | &amp;#x26A0; | &#x26A0; |
| Warning Signs | &amp;#x2620; | &#x2620; |
| Watch | &amp;#x231A; | &#x231A; |
| Wave Dash | &amp;#x301C; | &#x301C; |
| Wave, Sine | &amp;#x223F; | &#x223F; |
| Wavy Dash | &amp;#x3030; | &#x3030; |
| Wavy Line | &amp;#x2307; | &#x2307; |
| Wavy Low Line | &amp;#xFE4F; | &#xFE4F; |
| Wavy Overline | &amp;#xFE4B; | &#xFE4B; |
| Wavy Overline, Double | &amp;#xFE4C; | &#xFE4C; |
| Weather And Astrological Symbols | &amp;#x2600; | &#x2600; |
| Weather, Clear | &amp;#x2600; | &#x2600; |
| Weather, Cloudy | &amp;#x2601; | &#x2601; |
| Weather, Rainy | &amp;#x2602; | &#x2602; |
| Weather, Showery | &amp;#x2614; | &#x2614; |
| Weather, Snowy | &amp;#x2603; | &#x2603; |
| Wedge | &amp;#x028C; | &#x028C; |
| Wedge | &amp;#x2227; | &#x2227; |
| Weierstrass Elliptic Function | &amp;#x2118; | &#x2118; |
| West Syriac Cross | &amp;#x2670; | &#x2670; |
| Wheel Of Dharma | &amp;#x2638; | &#x2638; |
| Wheelchair Symbol | &amp;#x267F; | &#x267F; |
| White Bullet | &amp;#x25E6; | &#x25E6; |
| White Circle | &amp;#x25CB; | &#x25CB; |
| White Circle, Medium | &amp;#x26AA; | &#x26AA; |
| White Circle, Medium Small | &amp;#x26AC; | &#x26AC; |
| White Circle, Shadowed | &amp;#x274D; | &#x274D; |
| White Corner Bracket, Left | &amp;#x300E; | &#x300E; |
| White Corner Bracket, Right | &amp;#x300F; | &#x300F; |
| White Curly Bracket, Left | &amp;#x2983; | &#x2983; |
| White Curly Bracket, Right | &amp;#x2984; | &#x2984; |
| White Down Pointing Index | &amp;#x261F; | &#x261F; |
| White Flag | &amp;#x2690; | &#x2690; |
| White Framus | &amp;#x29D6; | &#x29D6; |
| White Frowning Face | &amp;#x2639; | &#x2639; |
| White Left Pointing Index | &amp;#x261C; | &#x261C; |
| White Lenticular Bracket, Left | &amp;#x3016; | &#x3016; |
| White Lenticular Bracket, Right | &amp;#x3017; | &#x3017; |
| White Nib | &amp;#x2711; | &#x2711; |
| White On Black Circled Numbers | &amp;#x24EB; | &#x24EB; |
| White Parenthesis, Left | &amp;#x2985; | &#x2985; |
| White Parenthesis, Right | &amp;#x2986; | &#x2986; |
| White Right Pointing Index | &amp;#x261E; | &#x261E; |
| White Scissors | &amp;#x2704; | &#x2704; |
| White Sesame Dot | &amp;#xFE46; | &#xFE46; |
| White Shogi Piece | &amp;#x2616; | &#x2616; |
| White Smiling Face | &amp;#x263A; | &#x263A; |
| White Square Bracket, Left | &amp;#x301A; | &#x301A; |
| White Square Bracket, Right | &amp;#x301B; | &#x301B; |
| White Star | &amp;#x2606; | &#x2606; |
| White Sun With Rays | &amp;#x263C; | &#x263C; |
| White Telephone | &amp;#x260F; | &#x260F; |
| White Tortoise Shell Bracket, Left | &amp;#x3018; | &#x3018; |
| White Tortoise Shell Bracket, Right | &amp;#x3019; | &#x3019; |
| White Trapezium | &amp;#x23E2; | &#x23E2; |
| White Up Pointing Index | &amp;#x261D; | &#x261D; |
| White Vertical Bar | &amp;#x2AFE; | &#x2AFE; |
| White Vertical Bar, N-Ary | &amp;#x2AFF; | &#x2AFF; |
| Wide Bridge Above, Combining | &amp;#x20E9; | &#x20E9; |
| Wiggly Fences | &amp;#x29D8; | &#x29D8; |
| Wj | &amp;#x2060; | &#x2060; |
| Won Sign | &amp;#x20A9; | &#x20A9; |
| Word Joiner | &amp;#x2060; | &#x2060; |
| Word Separators, Aegean | &amp;#x10100; | &#x10100; |
| Words, Squared Katakana | &amp;#x3300; | &#x3300; |
| Wordspace, Ethiopic | &amp;#x1361; | &#x1361; |
| Working Day Symbol | &amp;#x2692; | &#x2692; |
| Wreath Product | &amp;#x2240; | &#x2240; |
| Writing Hand | &amp;#x270D; | &#x270D; |
| Wynn, Latin Capital Letter | &amp;#x01F7; | &#x01F7; |
| Wynn, Latin Letter | &amp;#x01BF; | &#x01BF; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## X

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| X Above, Combining | &amp;#x033D; | &#x033D; |
| X Below, Combining | &amp;#x0353; | &#x0353; |
| X In A Rectangle Box | &amp;#x2327; | &#x2327; |
| X With Diaeresis, Latin Small Letter | &amp;#x1E8D; | &#x1E8D; |
| X With Dot Above, Latin Small Letter | &amp;#x1E8B; | &#x1E8B; |
| X, Ballot | &amp;#x2717; | &#x2717; |
| X, Ballot Box With | &amp;#x2612; | &#x2612; |
| X, Combining Latin Small Letter | &amp;#x036F; | &#x036F; |
| X, Heavy Ballot | &amp;#x2718; | &#x2718; |
| X, Heavy Multiplication | &amp;#x2716; | &#x2716; |
| X, Modifier Letter Small | &amp;#x02E3; | &#x02E3; |
| X, Multiplication | &amp;#x2715; | &#x2715; |
| Xor | &amp;#x22BB; | &#x22BB; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Y

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| Y With Acute, Latin Capital Letter | &amp;#x00DD; | &#x00DD; |
| Y With Acute, Latin Small Letter | &amp;#x00FD; | &#x00FD; |
| Y With Circumflex, Latin Small Letter | &amp;#x0177; | &#x0177; |
| Y With Diaeresis, Latin Capital Letter | &amp;#x0178; | &#x0178; |
| Y With Diaeresis, Latin Small Letter | &amp;#x00FF; | &#x00FF; |
| Y With Dot Above, Latin Small Letter | &amp;#x1E8F; | &#x1E8F; |
| Y With Dot Below, Latin Small Letter | &amp;#x1EF5; | &#x1EF5; |
| Y With Grave, Latin Small Letter | &amp;#x1EF3; | &#x1EF3; |
| Y With Hook Above, Latin Small Letter | &amp;#x1EF7; | &#x1EF7; |
| Y With Hook, Latin Small Letter | &amp;#x01B4; | &#x01B4; |
| Y With Macron, Latin Small Letter | &amp;#x0233; | &#x0233; |
| Y With Ring Above, Latin Small Letter | &amp;#x1E99; | &#x1E99; |
| Y With Stroke, Latin Capital Letter | &amp;#x024E; | &#x024E; |
| Y With Stroke, Latin Small Letter | &amp;#x024F; | &#x024F; |
| Y With Tilde, Latin Small Letter | &amp;#x1EF9; | &#x1EF9; |
| Y, Latin Letter Small Capital | &amp;#x028F; | &#x028F; |
| Y, Latin Small Letter Turned | &amp;#x028E; | &#x028E; |
| Y, Modifier Letter Small | &amp;#x02B8; | &#x02B8; |
| Y, Turned Sans-Serif Capital | &amp;#x2144; | &#x2144; |
| Yamakkan, Thai Character | &amp;#x0E4E; | &#x0E4E; |
| Year Sign, Tamil | &amp;#x0BF5; | &#x0BF5; |
| Yen Sign | &amp;#x00A5; | &#x00A5; |
| Yentamna, Armenian | &amp;#x058A; | &#x058A; |
| Yi Radicals | &amp;#xA490; | &#xA490; |
| Yi Syllables | &amp;#xA000; | &#xA000; |
| Yiddish Digraphs | &amp;#x05F0; | &#x05F0; |
| Yield, Does Not | &amp;#x22A3; | &#x22A3; |
| Yields | &amp;#x22A2; | &#x22A2; |
| Yijing / I Ching Hexagram Symbols | &amp;#x4DC0; | &#x4DC0; |
| Yijing / I Ching Monogram And Digram Symbols | &amp;#x268A; | &#x268A; |
| Yijing / I Ching Trigram Symbols | &amp;#x2630; | &#x2630; |
| Yin Yang | &amp;#x262F; | &#x262F; |
| Yogh, Latin Small Letter | &amp;#x021D; | &#x021D; |
| Ypogegrammeni, Combining Greek | &amp;#x0345; | &#x0345; |
| Yr, Latin Letter | &amp;#x01A6; | &#x01A6; |
| Yuan Sign | &amp;#x00A5; | &#x00A5; |


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Z

| Description | Entity | Preview |
| ----------- | ------ | ------- |
| Z Bar, Latin Small Letter | &amp;#x01B6; | &#x01B6; |
| Z Notation Bag Membership | &amp;#x22FF; | &#x22FF; |
| Z Notation Spot | &amp;#x2981; | &#x2981; |
| Z Notation Type Colon | &amp;#x2982; | &#x2982; |
| Z With Acute, Latin Small Letter | &amp;#x017A; | &#x017A; |
| Z With Caron, Latin Small Letter | &amp;#x017E; | &#x017E; |
| Z With Circumflex, Latin Small Letter | &amp;#x1E91; | &#x1E91; |
| Z With Curl, Latin Small Letter | &amp;#x0291; | &#x0291; |
| Z With Dot Above, Latin Small Letter | &amp;#x017C; | &#x017C; |
| Z With Dot Below, Latin Small Letter | &amp;#x1E93; | &#x1E93; |
| Z With Hook, Latin Small Letter | &amp;#x0225; | &#x0225; |
| Z With Line Below, Latin Small Letter | &amp;#x1E95; | &#x1E95; |
| Z With Retroflex Hook, Latin Small Letter | &amp;#x0290; | &#x0290; |
| Z With Stroke, Latin Small Letter | &amp;#x01B6; | &#x01B6; |
| Z With Swash Tail, Latin Small Letter | &amp;#x0240; | &#x0240; |
| Z, Black-Letter Capital | &amp;#x2128; | &#x2128; |
| Z, Double-Struck Capital | &amp;#x2124; | &#x2124; |
| Z, Latin Letter Small Capital | &amp;#x1D22; | &#x1D22; |
| Zapf Dingbats Series 100, Itc | &amp;#x2700; | &#x2700; |
| Zero Width Joiner | &amp;#x200D; | &#x200D; |
| Zero Width No-Break Space | &amp;#xFEFF; | &#xFEFF; |
| Zero Width Non-Joiner | &amp;#x200C; | &#x200C; |
| Zero Width Space | &amp;#x200B; | &#x200B; |
| Zero, Circled Digit | &amp;#x24EA; | &#x24EA; |
| Zero, Ideographic Number | &amp;#x3007; | &#x3007; |
| Zero, Superscript | &amp;#x2070; | &#x2070; |
| Zigzag Above, Combining | &amp;#x035B; | &#x035B; |
| Zodiacal Symbols | &amp;#x2648; | &#x2648; |
