﻿---

# Справка по Database Browser

---

Утилита **Database Browser** в составе пакета **CRW-DAQ** - это средство для наблюдения
Баз Данных из **СУБД** и отладки выражений **SQL**. Важно то, что утилита реализована на
библиотеке **[DbApi](daqpascalapi.htm#db_connection)**, поэтому всё что работает в утилите,
будет работать и в **DaqPascal**.

Вам также пригодится **[справка по SQL](sql/)** и
**[шпаргалка](sql/01_sqltutorial.org_sql-cheat-sheet.pdf)**,
справки по
**[ADO](ado/)**,
**[SQLDB](sqldb/)**,
**[ZEOS](../../source/ccr/zeosdbo/)**,
**[ODBC](odbc/)**,
**[DbApi](daqpascalapi.htm#db_connection)**,
**[DbLibrary](daqpascalapi.htm#dblibrary)**,
**[сервер](../daqsite/fdbserver/)**
**[&FdbSrv](../daqsite/fdbserver/fdbsrv.htm)**,
**[примеры БД](../dbsamples/dbsamples.htm)**.

## Подготовка подключения

Для подключения к **БД** надо указать необходимые для подключения данные, т.е. грамотно составить
**`ConnectionString`**. Сначала на закладке **Engine** указывается движок (*Engine*), сейчас это
только **ADO**. Затем указывается провайдер (*Provider*) - рекомендуется **MSDASQL** (он умеет
работать с драйверами **ODBC**). Затем выбирается драйвер (*Driver*). Например, для **SQLite**
это **`SQLite3 ODBC Driver`**, а для **Firebird** - это **`Firebird/InterBase(r) driver`**.
На странице Учетной Записи (*Account*) указывается Логин/Пароль. На закладке Расположение
(*Location*) указывается Сервер (*Server*) и имя базы данных (*Database*). В зависимости
от типа и настройки **БД** это может быть имя файла или псевдоним. Также вожможно формирование
имени в виде **Server:Database**. Эти параметры и настройки имеют много вариаций, например,
в разных **БД** имя пользователя задается как **User ID**, **User**, или **UID**.
Программа формирования **ConnectionString** основана на шаблонах, прочитанных из **INI**
файла и учитывает много вариантов подстановок. В результате формируется нужная строка подключения.

> При формировании строки подключения будьте внимательны к "мелочам", которые очень важны.
> Например, если вы изменили драйвер (то есть тип **СУБД**), но не поменяли имя файла **БД**,
> у вас будет ошибка. Например, если драйверу **Firebird** подсунуть файл от **SQLite3**,
> то будет закономерная ошибка (*неверный тип файла*).

После формирования **ConnectionString** можно нжимать кнопку **Connect** для подключения к **БД**.
По результатам подключения отображается диагностика (в строке *StatusBar*), а также ведется
журнал событий (*Log*). Возникающие ошибки делятся на два виде - программные сбои (*Bugs*)
и ошибки (*Errors*), которые выдает провайдер. Сбои отображаются в виде исключений в окне
Главной Консоли пакета, а ошибки провайдера записываются в журнал (*Errors*) для последующего
анализа.

## Выполнение запросов SQL

После подключения становится доступна кнопка **Execute** для выполнения запросов **SQL**,
которые вводятся в окне на вкладке **SQL Request**. На другой вкладке **SQL Samples** есть
ряд примеров запросов, которые можно копировать и использовать как шаблоны для формирования
своих запросов.

Кроме того, ниже есть кнопка **Read Tables** для чтения списка доступных таблиц в подключенной
**БД**. Эта кнопка пока работает только для **SQLite3** и **Firebird**, для которых известны
соответствующие команды. После чтения списка таблиц при выборе таблицы формируется запрос типа
```
    select * from TABLE;
```
 с подстановкой имени таблицы вместо **TABLE**. Сформированный запрос записывается в окно
 **SQL Request** для последующего редактирования и выполнения кнопкой **Execute**.


## Наблюдение результатов запросов

Результаты запросов отображаются в журнале **Log** (это касается статуса выполнения), а данные
помещаются в таблицу на закладке **SQL Results**. В верхней части таблицы (первые две строки)
помещаются типы и имена полей, а в остальных полях помещаются извлеченные данные.

На панели инструментов (справа от таблицы результатов) есть команды выделения, очистки,
копирования данных в буфер обмена, их сохранения в файл, а также команда автоматичекого
выравнивания ширины столбцов для улучшения внешнего вида таблицы.

Данные времени (**Date**, **Time**, **TimeStamp**) можно отображать в пользовательском формате,
в том числе с отображением миллисекунд. Для это надо поставить галочки на закладке **Date\Time**
и выбрать формат, например, **yyyy.mm.dd-hh:nn:ss.zzz** (вида **2022.12.26-15:35:40.435**).

Также можно отображать время в виде вещественных чисел. В качестве единиц времени в этом случае
можно использовать время единицах **OLE** (в днях от **1899.12.30-00:00:00**), как принято в
**OLE**,**COM**,**ADO**,**Excel**,**Delphi**. Либо можно (установив галочку) перевести время
в миллисекунды от начала эры (**ms since Xmas**), как принято в пакете **CRW-DAQ**.

> Данные из таблицы результатов можно копировать в Буфер Обмена для использования в других приложениях,
> а также сохранять в файл для дальнейшей обработки.

---

Желаю успешного использования утилиты **Database Browser**.

---

> CRW-DAQ Copyright (c) 2001-2023 Alexey Kuryakin <kouriakine@mail.ru>

---
