---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Modbus

Протокол **Modbus** является простым и широко распространенным **семейством протоколов**
для обмена данными в промышленной автоматизации.  
Например, **SCADA** системы могут связываться с контроллерами через **Modbus**.

Протоколы семейства **Modbus** отличаются средой передачи - **COM**-порт или **Ethernet**.  
Однако на логическом уровне все протоколы **Modbus** имеют единую логику доступа.  
Они работают путем чтения/записи данных в **адресном пространстве** устройств.  
Это позволяет унифицировать программный интерфейс и облегчает доступ.  

Семейство протоколов **Modbus**:

| Протокол  | Краткое описание.                                                |
|-----------|------------------------------------------------------------------|
| **ascii** | Текстовый протокол в сети **RS-232/422/485**.                    |
| **rtu**   | Двоичный  протокол в сети **RS-232/422/485**.                    |
| **tcp**   | Двоичный  протокол в сети **Ethernet TCP**.                      |
| **udp**   | Двоичный  протокол в сети **Ethernet UDP**.                      |
| **enc**   | Encapsulated RTU over TCP. Протокол **RTU** через среду **TCP**. |

Пакет **crwdaq** содержит широкий набор средств для поддержки протокола **Modbus**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Modbus - Спецификации

Есть хорошо написанные спецификации **[Modbus](../tools/modbus/reference/modbus.htm)**.
В них содержится подробное описание семейства протоколов **Modbus**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Сервер ModbusSrv

Сервер **[ModbusSrv](../daqsite/modbusserver/modbussrv.htm)** служит в качестве
универсального **Modbus**-сервера, через который можно публиковать данные, доступные
по протоколу **Modbus**. Например, для передачи данных в другие **SCADA** системы.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Сервер ModbusProxy

Сервер **[ModbusProxy](../daqsite/modbusserver/modbusproxy.htm)** служит в качестве
универсального прокси-сервера, через который подключаются драйверы **Modbus** устройств.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Библиотека NetLibrary

Библиотека **[NetLibrary](../daqsite/stdlib/include/_man_netlibrary.htm)** служит для
разработки драйверов **Modbus** устройств с использованием **ModbusProxy**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Утилита ModPollGui

Утилита **[ModPollGui](../tools/modbus/modpoll/)** служит для проверки/настройки **Modbus** устройств
и отладки драйверов **Modbus**.  
Утилита позволяет подключаться к **Modbus** устройствам и читать/записывать
данные различных типов в адресном пространстве **Modbus**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

> CrwDaq Copyright © 2001-2026 Alexey Kuryakin <daqgroup@mail.ru>

---
