---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

<a name="crwdaq_about"></a>

# CrwDaq - расположение, вызов, аргументы, сеансы и окружение

Здесь содержится информация о пакете **[CrwDaq](crwdaq.htm)**, касающаяся:  
- **Расположения** пакета;  
- **Вызова** (запуска) пакета;  
- **Аргументов** командной строки;  
- **Сессий** (сеансов) работы экземпляров пакета;  
- **Окружения** - переменных среды окружения пакета.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="crwdaq_location"></a>

## Расположение пакета

Расположение пакета **CrwDaq** зависит от операционной системы.

Пакет **CrwDaq** под **Unix** имеет два расположения:  
- **Логическое** - в постоянной папке **`/opt/crwdaq`**, и  
- **Физическое** - в папке **`/opt/daqgroup/suite/crwdaq`**.

Пакет **CrwDaq** под **Windows** расположен (**физически**) в папке **`%SystemDrive%\opt\daqgroup\suite\crwdaq`**.  
**Логически** пакет должен быть расположен, соответственно, в папке **`%SystemDrive%\opt\crwdaq`**.  
Здесь **`%SystemDrive%`** - диск, на котором установлена система, например, **C:**.

Предполагается, что логическая папка - постоянная символическая ссылка на физическую (реальную) папку,
при этом положение символической ссылки постоянно и не будет меняться со временем.
Физическая папка при необходимости может быть расположена в другом месте.
Хотя изменение расположения физической папки сейчас не планируется,
такую возможность нельзя исключать в будущем.

Для поиска и вызова пакета лучше ориентироваться на логическое расположение
пакета, чтобы не пришлось изменять ссылки и пути файлов в будущем.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="crwdaq_launch"></a>

## Вызов пакета

Пакет **CrwDaq** является специализированным **ПО**, случайный вызов
которого нежелателен. Поэтому он не прописан в путях поиска **PATH**
и не доступен для вызова по короткому имени.

Вызов пакета **CrwDaq** под **Unix** можно выполнять двумя способами:
по полному (логическому) пути или через программу - обёртку
**[crwkit](../../../../suite/crwkit/add/man/crwkit.htm)**,
например:

``` bash
      /opt/crwdaq/crwdaq [options] [parameters]    - вызов по прямому пути
или   crwkit crwdaq [options] [parameters]         - вызов с помощью crwkit(1)
или   crwrun crwdaq [options] [parameters]         - вызов с помощью crwkit(2)
или   unix   crwdaq [options] [parameters]         - вызов с помощью crwkit(3)
```
При запуске из консоли рекомендуется также использовать команду **`grun`**,
например: **`unix grun crwdaq …`**

Это нужно для того, чтобы "отцепить" запущенную программу от терминала,
иначе при закрытии терминала (консольного окна) программа тоже завершится.

Вызов пакета **CrwDaq** под **Windows** выполняется по прямому пути.

``` bash
c:\opt\crwdaq\crwdaq.exe [options] [parameters]
```

Для облегчения вызова может использоваться ярлык **.lnk**.

При вызове программе **crwdaq** передаются **[аргументы](#cmdline_arguments)**,
включающие опции и параметры, как описано ниже.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="session_manager"></a>

## Менеджер сессий - _SessionManager_

Запуск пакета выполняется с помощью программного модуля - **Менеджера Сессий** (_Session Manager_),
который отвечает за бесконфликтное взаимодействие экземпляров программы.

Работа **Менеджера Сессий** основана на концепции именованной **сессии** (сеанса работы).
Сессия - это экземпляр работающей программы с заданным идентификатором (натуральным номером сессии)
и связанным с ним набором ресурсов - например, канала связи **IPC** для межпроцессного взаимодействия
и каталогов для хранения журналов и временных файлов.
Поскольку у каждой сессии свой номер, экземпляры программы могут работать без конфликта между собой,
т.к. все временные файлы разделены и расположены в разных каталогах.
В то же время менеджер сеансов следит, чтобы выполнялся только один экземпляр программы с данным
номером сессии - во избежание конфликтов между экземплярами программы в рамках одной сессии.

У каждой сессии также есть иконка (картинка) **`-icon`**, чтобы различать экземпляры программы визуально.
Иконка задается **[аргументом](#cmdline_arguments)** командной строки **`-icon=i`** (где **`i=0…6`**)
или (при отсутсвии аргумента) вычисляется как **`i=(n-1) % 6`**, где **i** - номер иконки,
**`n`** - номер сессии, **` % 6`** - операция "по модулю 6".  
Иконки **`i=0…6`** имеют вид:
0:![crwdaq_0](../icon/crwdaq_0.ico), 1:![crwdaq_1](../icon/crwdaq_1.ico), 2:![crwdaq_2](../icon/crwdaq_2.ico),
3:![crwdaq_3](../icon/crwdaq_3.ico), 4:![crwdaq_4](../icon/crwdaq_4.ico), 5:![crwdaq_5](../icon/crwdaq_5.ico).

По умолчанию запускается сессия номер **1** с картинкой (иконкой) номер **0**.

При запуске программы **SessionMagager** осуществляет поиск предыдущего экземпляра программы **crwdaq**
с тем же номером сессии, который задан явно (в командной строке) или неявно (по умолчанию).
Если такой экземпляр найден, программа передает ему сообщение с аргументами вызова и завершается.
Предыдущий (ранее запущенный) экземпляр программы получает сообщение и выполняет его.

Идентификатор сессии (номер сессии **n**) задается в аргументе командной строки
**`-session n`** или **`-number n`**. Если номер сессии не указан, по умолчанию
запускается сессия **1**.

При работе **SessionMagager** создает **[переменные окружения](#environment_variables)**,
а также служебные каталоги для расположения отладочных журналов и других временных файлов.
Прикладные программы и сценарии могут использовать эти переменные окружения и каталоги
для определения параметров, расположения файлов и выполения необходимой работы.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="cmdline_arguments"></a>

## Аргументы командной строки

Программа **crwdaq** может принимать аргументы - опции и параметры.

Все опции (_options_) и параметры (_parameters_) являются необязательными.

| Опция/Параметр      | Описание                                                                              |
|---------------------|---------------------------------------------------------------------------------------|
| **`-session n`**    | Запуск сессии (сеанса работы) номер **n** (натуральное число начиная с 1).            |
| **`-number n`**     | Синоним **--session n**, по умолчанию запуск с номером сеанса **n=1**.                |
| **`-icon=i`**       | Задает иконку (картинку) номер **i=0..6**, по умолчанию берется **i=n-1**.            |
| **`-r`**            | Опция указывает, что следующий за ней параметр (файл) надо запустить (_run_).         |
| **`-e`**            | Опция указывает, что следующий за ней параметр (файл) надо редактировать (_edit_).    |
| **`-d`**            | Опция указывает, что для следующего параметра (файла) нужен диалог выбора (_dialog_). |
| **`path/file.cfg`** | Параметр - файл. Загрузка и запуск **DAQ** конфигурации из файла **path/file.cfg**.   |

Например:

``` bash
unix grun crwdaq -session 2 -icon=3 -r /opt/crwdaq/demo/demo_fast_poll/fast_poll.cfg

# начинает сессию 2 с иконкой 3 и запускает конфигурацию fast_poll.cfg
```

По умолчанию запускается сессия номер **1** с картинкой (иконкой) номер **0**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="environment_variables"></a>

## Переменные окружения

**[Менеджер сессий](#session_manager)** создает при старте пакета следующие переменные окружения:

| Переменная | Описание                                                                              |
|------------|---------------------------------------------------------------------------------------|
| **<a name="crw_daq_sys_class">CRW_DAQ_SYS_CLASS</a>** | Имя класса окна главной формы **crwdaq**.  |
| **<a name="crw_daq_sys_exe_file">CRW_DAQ_SYS_EXE_FILE</a>** | Полный путь/имя исполняемого файла **crwdaq**.  |
| **<a name="crw_daq_sys_exe_pid">CRW_DAQ_SYS_EXE_PID</a>** | Идентификатор **PID** процесса **crwdaq**.  |
| **<a name="crw_daq_sys_exe_tid">CRW_DAQ_SYS_EXE_TID</a>** | Идентификатор основного потока **crwdaq**.  |
| **<a name="crw_daq_sys_handle">CRW_DAQ_SYS_HANDLE</a>** | Ссылка (_handle_) окна главной формы **crwdaq**.  |
| **<a name="crw_daq_sys_home_dir">CRW_DAQ_SYS_HOME_DIR</a>** | Каталог (физического) расположения исполняемого файла **crwdaq** .  |
| **<a name="crw_daq_sys_ini_file">CRW_DAQ_SYS_INI_FILE</a>** | Главный файл инициализации (задания параметров) **crwdaq**.  |
| **<a name="crw_daq_sys_init_path">CRW_DAQ_SYS_INIT_PATH</a>** | Начальное значение переменной окружения **PATH** при старте программы.  |
| **<a name="crw_daq_sys_lang">CRW_DAQ_SYS_LANG</a>** | языковые настройки.  |
| **<a name="crw_daq_sys_path">CRW_DAQ_SYS_PATH</a>** | дополнительный список путей для поиска файлов, который добавляется к переменной окружения **PATH**.  |
| **<a name="crw_daq_sys_session_id">CRW_DAQ_SYS_SESSION_ID</a>** | полный идентификатор сессии, типа **daqgroup_crwdaq_session_1**.  |
| **<a name="crw_daq_sys_session_nb">CRW_DAQ_SYS_SESSION_NB</a>** | идентификатор (номер) сессии.  |
| **<a name="crw_daq_sys_session_head">CRW_DAQ_SYS_SESSION_HEAD</a>** | заголовок сессии, типа **crwdaq_1**.  |
| **<a name="crw_daq_sys_title">CRW_DAQ_SYS_TITLE</a>** | заголовок главного окна **crwdaq**, составленный из имени программы, номера сессии, **PID** процесса, имени компьютера.  |
| **<a name="crw_daq_sys_tmp_dir">CRW_DAQ_SYS_TMP_DIR</a>** | каталог для размещения временных файлов с коротким временем  жизни (т.е. которые могут быть удалены при перезагрузке).  |
| **<a name="crw_daq_sys_version">CRW_DAQ_SYS_VERSION</a>** | страка с описанием версии работающего пакета.  |
| **<a name="crw_daq_sys_wnd">CRW_DAQ_SYS_WND</a>** | идентификатор окна (в десятичной нотации) главной формы **crwdaq**.  |
| **<a name="crw_daq_var_tmp_dir">CRW_DAQ_VAR_TMP_DIR</a>** | каталог для размещения журналов **`*.log`** и временных файлов с длинным временем  жизни (т.е. которые не удаляются при перезагрузке).  |
| **<a name="crwkit_root">CRWKIT_ROOT</a>** | Каталог расположения пакета **crwkit**.  |
| **<a name="crwtoolkit_root">CRWTOOLKIT_ROOT</a>** | Каталог расположения пакета **crwtoolkit**.  |
| **Дополнительные переменные** | **создаваемые при загрузке конфигурации DAQ системы**.  |
| **<a name="crw_daq_config_base_time">CRW_DAQ_CONFIG_BASE_TIME</a>** | Базовое время (начало отсчета) времени **DAQ** системы (функцмя _time_) в миллисекундах от Начала Эры **0001.01.01-00:00:00**.  |
| **<a name="crw_daq_config_data_path">CRW_DAQ_CONFIG_DATA_PATH</a>** | Каталог данных для текущей конфигурации **DAQ** системы.  |
| **<a name="crw_daq_config_file">CRW_DAQ_CONFIG_FILE</a>** | Главный конфигурационный файл текущей конфигурации **DAQ** системы.  |
| **<a name="crw_daq_config_home_dir">CRW_DAQ_CONFIG_HOME_DIR</a>** | Домашний каталог, где расположен главный конфигурационный файл текущей конфигурации **DAQ** системы.  |
| **<a name="crw_daq_config_load_time">CRW_DAQ_CONFIG_LOAD_TIME</a>** | Время загрузки текущей конфигурации **DAQ** системы в миллисекундах от Начала Эры **0001.01.01-00:00:00**.  |
| **<a name="crw_daq_config_path">CRW_DAQ_CONFIG_PATH</a>** | Список путей (каталогов) для поиска файлов в текущей конфигурации **DAQ** системы.  |
| **<a name="crw_daq_config_start_time">CRW_DAQ_CONFIG_START_TIME</a>** | Время запуска текущей конфигурации **DAQ** системы в миллисекундах от Начала Эры **0001.01.01-00:00:00**.  |
| **<a name="crw_daq_config_temp_path">CRW_DAQ_CONFIG_TEMP_PATH</a>** | Каталог для временных файлов текущей конфигурации **DAQ** системы.  |
| **<a name="crw_daq_config_time_units">CRW_DAQ_CONFIG_TIME_UNITS</a>** | Единицы измерения времени (функцмя _time_) в текущей конфигурации **DAQ** системы в миллисекундах.  |
| **<a name="crw_daq_include_path">CRW_DAQ_INCLUDE_PATH</a>** | Путь расположения включаемых файлов (_include_) стандартной библиотеки **DaqPascal**.  |

Ниже приведено типичное значение переменных окружения пакета:

``` bash
 #########################################################
 # Типичное значение переменных окружения пакета под Unix:
 #########################################################
 CRW_DAQ_SYS_CLASS=crwdaq.Crwdaq
 CRW_DAQ_SYS_EXE_FILE=/opt/daqgroup/suite/crwdaq/crwdaq
 CRW_DAQ_SYS_EXE_PID=3964
 CRW_DAQ_SYS_EXE_TID=139789671918016
 CRW_DAQ_SYS_HANDLE=48243712
 CRW_DAQ_SYS_HOME_DIR=/opt/daqgroup/suite/crwdaq
 CRW_DAQ_SYS_INI_FILE=/opt/daqgroup/suite/crwdaq/crwdaq.ini
 CRW_DAQ_SYS_INIT_PATH=/usr/local/bin:/usr/bin:/bin:/usr/local/games:/usr/games:/opt/crwkit:/opt/crwkit/bin:/opt/crwkit/add/bin
 CRW_DAQ_SYS_LANG=RUSSIAN,CP65001,CP65001,$419,$419,$419,$419
 CRW_DAQ_SYS_PATH=/opt/daqgroup/suite/crwdaq:/bin:/usr/local/bin:/opt/crwkit/add/bin:/usr/bin:/opt/daqgroup/suite/crwdaq/resource/tools/unitconverter:/opt/daqgroup/suite/crwdaq/resource/tools/bat:
 CRW_DAQ_SYS_SESSION_ID=daqgroup_crwdaq_session_1
 CRW_DAQ_SYS_SESSION_HEAD=crwdaq_1
 CRW_DAQ_SYS_SESSION_NB=1
 CRW_DAQ_SYS_TITLE=crwdaq#1/3964@crwbox
 CRW_DAQ_SYS_TMP_DIR=/tmp/user-alex/daqgroup/crwdaq/session_1
 CRW_DAQ_SYS_VERSION=CRW-DAQ ver 20240330 release 20240422 © 2001-2024 Alexey Kuryakin daqgroup@mail.ru
 CRW_DAQ_SYS_WND=75497599
 CRW_DAQ_VAR_TMP_DIR=/var/tmp/user-alex/daqgroup/crwdaq/session_1
 CRWKIT_ROOT=/opt/crwkit
 CRWTOOLKIT_ROOT=/opt/crwkit
 ###################################################################
 # Дополнительные переменные при загрузке DAQ конфигурации под Unix:
 ###################################################################
 CRW_DAQ_CONFIG_BASE_TIME=63849513600000
 CRW_DAQ_CONFIG_DATA_PATH=/mnt/data/home/alex/projects/daqgroup/suite/crwdaq/demo/demo_zupdc/data
 CRW_DAQ_CONFIG_FILE=/mnt/data/home/alex/projects/daqgroup/suite/crwdaq/demo/demo_zupdc/config/!zupdc.cfg
 CRW_DAQ_CONFIG_HOME_DIR=/mnt/data/home/alex/projects/daqgroup/suite/crwdaq/demo/demo_zupdc/config
 CRW_DAQ_CONFIG_LOAD_TIME=63849552150436
 CRW_DAQ_CONFIG_PATH=/mnt/data/home/alex/projects/daqgroup/suite/crwdaq/demo/demo_zupdc/config:/mnt/data/home/alex/projects/daqgroup/suite/crwdaq/demo/demo_zupdc/utility:/mnt/data/home/alex/projects/daqgroup/suite/crwdaq/demo/demo_zupdc/help:/opt/dim:/opt/daqgroup/suite/crwdaq/resource/dimsite/dim/bin
 CRW_DAQ_CONFIG_START_TIME=63849552157832
 CRW_DAQ_CONFIG_TEMP_PATH=/mnt/data/home/alex/projects/daqgroup/suite/crwdaq/demo/demo_zupdc/temp
 CRW_DAQ_CONFIG_TIME_UNITS=3600000
 CRW_DAQ_INCLUDE_PATH=/opt/daqgroup/suite/crwdaq/resource/daqsite/stdlib/include
 
 
 ############################################################
 # Типичное значение переменных окружения пакета под Windows:
 ############################################################
 CRW_DAQ_SYS_CLASS=Window
 CRW_DAQ_SYS_EXE_FILE=C:\opt\daqgroup\suite\crwdaq\crwdaq.exe
 CRW_DAQ_SYS_EXE_PID=1908
 CRW_DAQ_SYS_EXE_TID=4628
 CRW_DAQ_SYS_HANDLE=6359816
 CRW_DAQ_SYS_HOME_DIR=C:\opt\daqgroup\suite\crwdaq
 CRW_DAQ_SYS_INI_FILE=C:\opt\daqgroup\suite\crwdaq\crwdaq.ini
 CRW_DAQ_SYS_INIT_PATH=C:\Python\Scripts;C:\Python;C:\Program Files\Borland\Delphi5\Projects\Bpl;C:\Program Files\Borland\vbroker\jre\bin;C:\Program Files\Borland\vbroker\Bin;C:\Program Files\Borland\Delphi5\Bin;C:\root\bin;C:\Program Files\Windows Resource Kits\Tools;C:\Windows\System32;C:\Windows;C:\Windows\System32\wbem;C:\Windows\System32\WindowsPowerShell\v1.0;C:\Windows\System32\OpenSSH;C:\Program Files\UnixUtils\add\lua;C:\Program Files\UnixUtils\add\lua\clibs;C:\Users\main\AppData\Local\Microsoft\WindowsApps;C:\Tcl\bin
 CRW_DAQ_SYS_LANG=RUSSIAN,CP1251,CP866,$419,$419,$419,$419
 CRW_DAQ_SYS_PATH=C:\opt\daqgroup\suite\crwdaq;C:\opt\daqgroup\suite\crwdaq\resource\shell;C:\Program Files\UnixUtils\bin;C:\Program Files\UnixUtils\add\bin;C:\Program Files\UnixUtils\add\lua;C:\Program Files\UnixUtils\add\lua\clibs;C:\opt\daqgroup\suite\crwdaq\resource\dimsite\dim_cmd;C:\opt\daqgroup\suite\crwdaq\resource\dimsite\dim\bin;C:\opt\daqgroup\suite\crwdaq\resource\smisite\smi\bin;C:\opt\daqgroup\suite\crwdaq\resource\tools\bat;C:\opt\daqgroup\suite\crwdaq\resource\tools\gnuplot\bin;C:\opt\daqgroup\suite\crwdaq\packages\admilink;C:\opt\daqgroup\suite\crwdaq\packages\com0com\add\bin;C:\Programs\Portable\SoftwareOK.com\Q-Dir;C:\opt\daqgroup\suite\crwdaq\resource\tools\freecommander;C:\opt\daqgroup\suite\crwdaq\resource\tools\unitconverter;C:\opt\daqgroup\suite\crwdaq\packages\speechapi;C:\opt\daqgroup\suite\crwdaq\packages\winkeylock;
 CRW_DAQ_SYS_SESSION_ID=DaqGroup_crwdaq_session_1
 CRW_DAQ_SYS_SESSION_HEAD=crwdaq_1
 CRW_DAQ_SYS_SESSION_NB=1
 CRW_DAQ_SYS_TITLE=crwdaq#1/1908@ak-w10x32-vm
 CRW_DAQ_SYS_TMP_DIR=C:\Users\main\AppData\Local\Temp\DaqGroup\crwdaq\session_1
 CRW_DAQ_SYS_VERSION=CRW-DAQ ver 20240330 release 20240422 Вc 2001-2024 Alexey Kuryakin daqgroup@mail.ru
 CRW_DAQ_SYS_WND=6359816
 CRW_DAQ_VAR_TMP_DIR=C:\Users\main\AppData\Local\Temp\DaqGroup\crwdaq\session_1
 CRWTOOLKIT_ROOT=C:\Program Files\CrwToolkit
 ######################################################################
 # Дополнительные переменные при загрузке DAQ конфигурации под Windows:
 ######################################################################
 CRW_DAQ_CONFIG_BASE_TIME=63849513600000
 CRW_DAQ_CONFIG_DATA_PATH=C:\opt\daqgroup\suite\crwdaq\demo\demo_zupdc\data
 CRW_DAQ_CONFIG_FILE=C:\opt\daqgroup\suite\crwdaq\demo\demo_zupdc\config\!zupdc.cfg
 CRW_DAQ_CONFIG_HOME_DIR=C:\opt\daqgroup\suite\crwdaq\demo\demo_zupdc\config
 CRW_DAQ_CONFIG_LOAD_TIME=63849553891207
 CRW_DAQ_CONFIG_PATH=C:\opt\daqgroup\suite\crwdaq\demo\demo_zupdc\config;C:\opt\daqgroup\suite\crwdaq\demo\demo_zupdc\utility;C:\opt\daqgroup\suite\crwdaq\demo\demo_zupdc\help;C:\Program Files\Common Files\CRW-DAQ\Resource\DimSite\dim\bin;C:\opt\daqgroup\suite\crwdaq\resource\dimsite\dim\bin
 CRW_DAQ_CONFIG_START_TIME=63849553901113
 CRW_DAQ_CONFIG_TEMP_PATH=C:\opt\daqgroup\suite\crwdaq\demo\demo_zupdc\TEMP
 CRW_DAQ_CONFIG_TIME_UNITS=3600000
 CRW_DAQ_INCLUDE_PATH=C:\opt\daqgroup\suite\crwdaq\resource\daqsite\stdlib\include
```

Приведенные выше переменные окружения (значения которых могут меняться в зависимости от различных условий)
доступны в программах **DaqPascal** в командах **Главной Консоли**, а также (за счет наследования окружения)
в дочерних процессах, запускаемых из среды пакета. Поэтому, например, эти переменные могут быть использованы
в скриптах и программах, запускаемых из прикладных программ **DaqPascal** или из **Главной Консоли**.
Они могут использоваться, в том числе, для "обратной связи" запущенных дочерних процессов с основной
программой **crwdaq**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="environment_variables_dbapi"></a>

## Переменные окружения DBAPI

Программный интерфейс **[DbApi](daqpascalapi.htm#db_connection)** для **Баз Данных**
использует следующие (дополнительные) переменные окружения:

| Переменная          | Описание                                                                          |
|---------------------|-----------------------------------------------------------------------------------|
| **ISC_USER**        | Имя пользователя для провайдера **Interbase/Firebird**.                           |
| **ISC_PASSWORD**    | Пароль пользователя для провайдера **Interbase/Firebird**.                        |
| **ISC_HOST**        | Имя сервера для провайдера **Interbase/Firebird**.                                |
| **ISC_PORT**        | Номер порта для провайдера **Interbase/Firebird**.                                |
| **PGUSER**          | Имя пользователя для провайдера **PostgreSQL**.                                   |
| **PGPASSWORD**      | Пароль пользователя для провайдера **PostgreSQL**.                                |
| **PGHOST**          | Имя сервера для провайдера **PostgreSQL**.                                        |
| **PGPORT**          | Номер порта для провайдера **PostgreSQL**.                                        |
| **MYSQL_USER**      | Имя пользователя для провайдера **MySQL/MariaDB**.                                |
| **MYSQL_PASSWORD**  | Пароль пользователя для провайдера **MySQL/MariaDB**.                             |
| **MYSQL_HOST**      | Имя сервера для провайдера **MySQL/MariaDB**.                                     |
| **MYSQL_PORT**      | Номер порта для провайдера **MySQL/MariaDB**.                                     |
| **DBAPI_USER**      | Имя пользователя для любого провайдера **DbApi**.                                 |
| **DBAPI_PASSWORD**  | Пароль пользователя для любого провайдера **DbApi**.                              |
| **DBAPI_HOST**      | Имя сервера для любого провайдера **DbApi**.                                      |
| **DBAPI_PORT**      | Номер порта для любого провайдера **DbApi**.                                      |

При чтении параметров **DbApi** действуют такие правила:  

- Сначала параметр (например, **UserName**) читается из строки подключения.  
- Если его там нет, читается переменная окружения для конкретного провайдера.  
- Если её там нет, читается переменная окружения **DBAPI_XXX**.  
- Регистр имен переменных окружения играет роль (в **Unix**).  

Таким образом, переменные окружения определяют значения параметров подключения "**по умолчанию**",
если они не заданы явно в строке подключения. Причем переменные окружения для конкретного
провайдера имеют приоритет перед переменными окружения **DBAPI_XXX**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---
