#!/bin/bash
#########################################################################
# Copyright (c) 2021 Alexey Kuryakin akuryaki@cern.ch, kouriakine@mail.ru
# Script uses to make (compile and link) DIM from sources using bash
#########################################################################
# Usage: make_dim.sh [release]
#########################################################################

#########################################################################
# Some packages should be installed before compile (tested on AstraLinux)
# It's maybe system dependent (names of packages may vary)
#########################################################################
preinstall(){
 sudo apt-get install dos2unix ncurses-base ncurses-bin ncurses-term ncurses-doc libncurses5-dev libtinfo-dev libmotif-common libmotif-dev libmrm4 libxm4 libxmu-headers libxmu-dev libxpm-dev libjpeg-dev;
 sudo apt-get install make binutils build-essential gdb subversion zip unzip libx11-dev libgtk2.0-dev libgdk-pixbuf2.0-dev libcairo2-dev libpango1.0-dev;
}

################################################################################
# Some source files may be corrupted because Windows uses CRLF but Linix uses LF
# See https://superuser.com/questions/52044/convert-crlfs-to-line-feeds-on-linux
# Replace CRLF to LF in all text files, except ./bin/*, ./bin32/, ./Visual/*
################################################################################
adjust_line_ending(){
 find . -type f | xargs file | grep CRLF | grep -i -v ./bin/ |  grep -i -v ./bin32/ | grep -i -v ./Visual/ | cut -d: -f1 | xargs dos2unix
}

prepare(){
 adjust_line_ending;					# source files should be LF delimited on Linux
 local target_dir="$(uname | tr [:upper:] [:lower:])";	# target directory should be 'linux' for Linux
 [ "$1" != "release" ] && rm ./$target_dir/dimStat;	# uncomment this line while debug dimStat
}

####################################################
# On AstraLinux 'gmake' should be replaced to 'make'
####################################################
gmake(){
 make "$@"
};

compile(){
 export OS=$(uname);	# get OS name (looks POSIX compatible)
#export OS=Linux;	# get os name (fallback for Linux)
 source setup.sh;	# setup environment
 gmake all;		# make all taargets
}

##############################################
# Clear object and library files (for release)
##############################################
cleanup() {
 [ "$1" = "release" ] || return;			# only for release
 local target_dir="$(uname | tr [:upper:] [:lower:])";	# should be 'linux' for Linux
 rm ./$target_dir/*.o;					# clear temporary object  files
 rm ./$target_dir/*.a;					# clear temporaty library files
}

##############
# main program
##############

#preinstall;	# install packages (do it once)
prepare $1;	# remedy files to LF delimited
cleanup $1;	# delete temporary files (for release)
compile;	# compile and link sources
cleanup $1;	# delete temporary files (for release)

######
# done
######

