////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2020 Alexey Kuryakin kouriakine@mail.ru under LGPL license.  //
////////////////////////////////////////////////////////////////////////////////

unit dpAntiZombie; // Anti Zombie - check parent CRW-DAQ is still running.

interface

uses dpSystem,dpSysUtils,dpCrwDaqSys;

type
  TDataModuleAntiZombie = class(TDataModule)
    TimerCheckParentCrwDaq: TTimer;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
    procedure TimerCheckParentCrwDaqTimer(Sender: TObject);
  private
  protected
  public
  end;

var DataModuleAntiZombie: TDataModuleAntiZombie = nil;

procedure InitAntiZombie(Interval:Integer; Enabled:Boolean);

var AntiZombieTicks : Integer = 0;
var AntiZombieFlags : Integer = 1;
var AntiZombieLimit : Integer = MaxInt;

const az_LogFirst = 1;

implementation

procedure InitAntiZombie(Interval:Integer; Enabled:Boolean);
begin
 if (DataModuleAntiZombie=nil)
 then DataModuleAntiZombie:=TDataModuleAntiZombie.Create(Application);
 DataModuleAntiZombie.TimerCheckParentCrwDaq.Interval:=Interval;
 DataModuleAntiZombie.TimerCheckParentCrwDaq.Enabled:=Enabled;
 AntiZombieTicks:=0;
end;

procedure TDataModuleAntiZombie.DataModuleCreate(Sender: TObject);
begin
 if (DataModuleAntiZombie=nil) then DataModuleAntiZombie:=Self;
end;

procedure TDataModuleAntiZombie.DataModuleDestroy(Sender: TObject);
begin
 if (DataModuleAntiZombie=Self) then DataModuleAntiZombie:=nil;
end;

procedure TDataModuleAntiZombie.TimerCheckParentCrwDaqTimer(Sender: TObject);
begin
 if (CRW_DAQ_SYS_EXE_PID=0) then Exit;
 if not ParentCrwDaqIsRunning then Application.Terminate;
 if (AntiZombieTicks<AntiZombieLimit) then Inc(AntiZombieTicks);
 if (AntiZombieTicks=1) then begin
  OpenParentCrwDaqProcess;
  if HasFlags(AntiZombieFlags,az_LogFirst) then
  LogEvents(Now,FormatVar('Started AntiZombie Timer (%d ms) ',TimerCheckParentCrwDaq.Interval)
               +FormatVar('for Parent PID %d.',CRW_DAQ_SYS_EXE_PID));
 end;
end;

end.
