
---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Программа сбора данных E140

**[demo_e140](../../../../../demo/demo_e140/)** — демонстрационная конфигурация драйвера **LCARD E14-140**.

Документация: **[worksheet](worksheet/)**.

<img src="img/e14_140m.jpg" height="300">

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Назначение и краткое описание

<a name="about"></a>

Данная программа предназначена для создания измерительных систем в рамках пакета
**[crwdaq](../../../../../crwdaq.htm)** с использованием измерительной карты
**E14-140** производства **[LCARD](http://www.lcard.ru)**.

Преобразователь напряжения измерительный **E14-140** подключается к компьютеру через шину **USB-1.1**.
Он имеет **14**-битный **АЦП** с мультиплексором, позволяя выполнять измерения
в **16** дифференциальных каналах или в **32** каналах с общей землей с общей частотой опроса до **100 кГц**.
В каждом канале доступно **4** диапазона измерения: **±10000 mV**, **±2500 mV**, **±625 mV**, **±156.25 mV**.
При работе в дифференциальном режиме доступно также измерение "смещения нуля", при котором вход **АЦП**
закорачивается (закоротка выполняется схемой внутри устройства и не требует закоротки внешних входов **АЦП**).

Кроме того, **E14-140** имеет **16** цифровых вводов и **16** цифровых выводов, а также **2** канала **ЦАП**.
Следует отметить, что **ЦАП** устанавливается как опция, которая по в базовой комплектации отсутствует.

Устройство выполняет измерения произвольной длительности в непрерывном режиме, в отличие от цифровых осциллографов,
которые могут выполнять лишь "фотоснимок" конечной длины.
При этом программное обеспечение позволяет с помощью программных цифровых фильтров мгновенно менять частоту сбора данных
в широких пределах, позволяя регистрировать как медленно изменяющиеся, зашумленные сигналы, так и быстро протекающие процессы.
Возможность динамически изменять степень сглаживания и частоту сбора данных дает уникальные возможности для реализации
самых разнообразных систем на одной и той же аппаратуре, не требуя отдельных устройств для регистрации "быстрых" и "медленных" процессов.

При работе с устройством и программой сбора данных следует учитывать следующие обстоятельства и ограничения.

Во-первых, в силу особенностей **USB** данные поступают блоками размером от **32** до нескольких тысяч измерений,
в зависимости от заданной частоты **АЦП**. Программа сбора данных реализована таким образом, что независимо от частоты **АЦП** блоки данных поступают с частотой около **20 Гц**, то есть примерно каждые **50** миллисекунд.
Это несколько ограничивает применение данного устройства в системах управления реального времени, так как данные,
хотя и измеряются с высокой частотой, но поступают в компьютер с задержкой **50** миллисекунд и более.

Во-вторых, поскольку для тактирования **АЦП** используется кварцевый генератор,
частота которого может слегка отличаться от кварца, установленного в компьютере,
то время кривых **АЦП** может "уходить" по отношению к системным часам компьютера.
Уход часов составляет порядка секунды в сутки.
Кроме того, начальная синхронизация, то есть определение момента старта **АЦП**,
выполняется с точностью порядка **10**-**20** миллисукунд и более.
Таким образом, прикладное программное обеспечение должно учитывать возможность
смещения и ухода времени часов **АЦП**, особенно при длительных измерениях.

Для коррекции "ухода" часов **АЦП** есть процедура **[автокоррекции](#adc-clock-adjustment)**,
которая пытается программно "выправить" часы **АЦП**, рассчетно корректируя их частоту - так, чтобы
разница временн по часам компьютера и **АЦП** не увеличивалась, а оставалась близкой к нулю.
При этом расчетная частота **АЦП** будет слегка "гулять" из-за регулировки.
Эта коррекция может быть отключена указанием нулевого параметра коррекции,
если для данной задачи предпочтительнее иметь фиксированную частоту.

Далее, при работе **АЦП** с частотой регистрации выше **10 кГц** использование цифровых вводов и цифровых выводов,
а также **ЦАП** не рекомендуется, так как из-за ограниченной пропускной способности шины **USB-1.1** команды цифрового
ввода-вывода и **ЦАП** начинают мешать сбору данных **АЦП**, что приводит к аварийной остановке измерений
по ошибке ввода-вывода.
Специальные флаги в программе позволяют отключать работу цифрового ввода-вывода и **ЦАП**, чтобы гарантировать
безотказную работу **АЦП**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Структура и принципы работы программы сбора данных

<a name="structure"></a>

С формальной точки зрения программа сбора данных является устройством, имеющим:

- **32** аналоговых выхода, в которые записываются измеренные данные **АЦП**.
  В дифференциальном режиме на выходы **16**..**31** пишутся данные по "смещению нулей" **АЦП**.
  Данные выдаются в милливольтах. 

- **16** цифровых входов, из которых формируется **16**-битное слово для записи в цифровые выходы **E140**.

- **3** цифровых выхода.  
  - В **Digital Output 0** записывается состояние **16** цифровых входов **E140**.  
  - В **Digital Output 1** записывается разница времени по часам **E140** и системного времени компьютера.  
    Эта разница определяется следующим образом.
    При поступлении первой порции данных программа определяет и запоминает момент старта **АЦП**,
    отняв от текущего времени по часам компьютера время заполнения первого буфера, определяемое по размеру
    буфера и частоте опроса **АЦП**.
    При поступлении следующих порций данных разница времени находится как разность текущего времени
    по часам компьютера и времени по часам **АЦП**, определяемого как сумма запомненного начального
    времени и времени текущего измерения, рассчитанную по частоте опроса **АЦП**.
    На практике видно, что смещение (момент старта **АЦП**) определяется с точностью порядка **20** миллисекунд,
    а "уход" часов составляет порядка секунды в сутки. Кривая разницы времен позволяет контролировать этот "уход" часов
    и корректировать шкалу времени измеренных данных с учетом этой разницы.
    При использовании **[автокоррекции](#adc-clock-adjustment)** при помощи изменения (подстройки) используемой
    для расчетов частоты **АЦП** делается попытка удержать разницу времен по часам **АЦП** и компьютера
    в ограниченных пределах. Поэтому при режиме автокоррекции частоты разница времен должна колебаться
    в пределах секунды около нуля.  
  - В **Digital Output 2** записывается текущая расчетная частота опроса **E140**.
    Изначально **желаемая** частота опроса **АЦП** задается при указании **[параметров](#adc-mode-freq)** **АЦП**.
    После старта **АЦП** устройство возвращает реально установленную **номинальную** частоту **АЦП**,
    рассчитанную по номинальной частоте кварцевого генератора и коэффициенту деления в схеме тактового генератора.
    Однако, из-за отличия **реальной** частоты кварца от номинальной, время, рассчитанное по этой номинальной частоте,
    будет "дрейфовать" относительно часов компьютера. Для того, чтобы устранить этот эффект, есть процедура
    **[автокоррекции](#adc-clock-adjustment)** часов, которая пытается скорректировать расчетную
    частоту **АЦП** так, чтобы разница времен не возрастала. Эта расчетная частота и пишется в кривую.  
  - **2** аналоговых входа, через которые подаются данные для записи в каналы **ЦАП**-ов.
    Записываемые данные надо задавать в милливольтах.

Программа сбора данных выполнена как
**[отказоустойчивая высокоскоростная система сбора данных](robust_fast_daq.pdf)**
и имеет многокомпонентную структуру.
Три основные компоненты можно условно обозначить как:

1. **PAS** - прикладная программа, исполняемая в виртуальной машине **DAQ Pascal**,
   в контексте процесса **CRW-DAQ**.  

2. **DLL** - динамическая библиотека, загружаемая и вызываемая из программы **PAS**
   и работающая в рамках процесса **CRW-DAQ**.  

3. **EXE** - автономная программа, исполняемая в отдельном процессе, взаимодействующем
   с процессом **CRW-DAQ** с помощью общей памяти (**shared memory**)
   и анонимных каналов (**anonymous pipe**).

При этом программа **PAS** является ведущей, она отвечает за загрузку и освобождение библиотеки **DLL**,
а также за запуск и завершение процесса **EXE**.
Программа **PAS** взаимодействует с **EXE** через анонимные каналы ввода-вывода
(с помощью переназначения потоков стандартного ввода-вывода **StdIn**, **StdOut** в анонимные каналы).
При старте измерений она посылает в **StdIn** программы **EXE** команду старта, после чего **EXE** начинает сбор данных.
При этом по мере поступления данных **EXE** через свой **StdOut** посылает программе **PAS** сообщения,
уведомляющие о поступлении измеренных данных.
Уведомления не содержат самих данных, они дают лишь ссылку на буфер в общей памяти, где эти данные можно прочитать.
При поступлении сообщения с уведомлением программа **PAS** вызывает библиотеку **DLL**, которая считывает измеренные данные
из общей памяти с помощью ссылки, содержащейся в полученном сообщении. Использование **DLL** и общей памяти обеспечивает максимально
возможную скорость сбора данных. В то же время использование автономного процесса **EXE** для сбора данных обеспечивает отказоустойчивость,
так как при сбое в программе сбора данных "падает" только процесс **EXE**, в то время как программа **PAS** продолжает работу.
Увидев, что процесс **EXE** аварийно завершился, программа **PAS** перезапускает его и измерения продолжаются.
Таким образом, сочетание хорошо защищенной виртуальной машины **DAQ Pascal**, загружаемой библиотеки **DLL**,
автономнного процесса **EXE**, общей памяти и анонимных каналов обеспечивает все требуемые свойства - отказоустойчивость,
высокую скорость сбора данных и адаптивность (возможность легко модифицировать прикладную программу без потери надежности).
Конечно, это достигается усложнением структуры программы, однако в данном случае это оправдано резким повышением надежности
при сохранении высокой скорости сбора данных.

На следующем **[рисунке](img/e140_struct.svg)** отображается структура программы:

![структура драйвера e140](img/e140_struct.png)

На рисунке показано, что прикладная программа **[e140_drv.pas](../daqpas/e140_drv.pas)** работает в контексте процесса **CRW-DAQ**,
но при этом защищена средствами виртуальной машины **DAQ Pascal**, которая обеспечивает изоляцию адресного пространства и перехват ошибок
прикладной программы, что гарантирует отказоустойчивость системы по отношению к ошибкам и сбоям в коде прикладной программы
**[e140_drv.pas](../daqpas/e140_drv.pas)**.
Автономная программа **[e140_drv.exe](../daqpas/e140_drv/e140_drv.lpr)** защищена средствами **MMU** и операционной системы.
**M**emory **M**anagement **U**nit - это аппаратная защита памяти на физическом уровне, встроенная в процессор **x86**,
которую поддерживают все современные операционные системы, включая **Windows**. Эта защита обеспечивает отказоустойчивость системы
по отношению к ошибкам и сбоям в коде программы **[e140_drv.exe](../daqpas/e140_drv/e140_drv.lpr)**. При аварийном завершении
программы **[e140_drv.exe](../daqpas/e140_drv/e140_drv.lpr)** система продолжает работу, а прикладная программа
**[e140_drv.pas](../daqpas/e140_drv.pas)** перезапускает "упавший" процесс и система восстанавливает нормальную работу.
Единственным критическим с точки зрения защиты компонентом остается динамическая библиотека **[e140_dll.dll](../daqpas/e140_dll/e140_dll.lpr)**,
которая работает в адресном пространстве процесса **CRW-DAQ** и ничем не защищена. Однако размер кода этой библиотеки и его функции сведены до
минимального уровня, что резко снижает вероятность ошибок.

На рисунке также показано, как взаимодействуют компоненты программы.
Связь прикладной программы **[e140_drv.pas](../daqpas/e140_drv.pas)**,
динамической библиотеки **[e140_dll.dll](../daqpas/e140_dll/e140_dll.lpr)** и ядра пакета **CRW-DAQ** осуществляется
через программный интерфейс **CRW API**, который обеспечивает высокую скорость передачи и обработки данных.
Прикладная программа **[e140_drv.pas](../daqpas/e140_drv.pas)** посылает управляющие команды в поток **StdIn**
процесса **[e140_drv.exe](../daqpas/e140_drv/e140_drv.lpr)**, а в ответ получает сообщения, которые передаются через поток **StdOut**.
Объем передаваемых через каналы команд и сообщений невелики (порядка нескольких килоБайт в секунду), а частота сообщений при работе **АЦП**
составляет порядка **20** Герц (**50** миллисекунд).
Сообщения содержат лишь ссылки на блоки данных, которые фактически передаются через общую память. При этом передатчиком данных служит
процесс **[e140_drv.exe](../daqpas/e140_drv/e140_drv.lpr)**, который записывает данные в общую память, а приемником, читающим данные,
служит код динамически загружаемой библиотеки **[e140_dll.dll](../daqpas/e140_dll/e140_dll.lpr)**. Использование общей памяти позволяет
вообще избежать операции копирования данных, программа **[e140_dll.dll](../daqpas/e140_dll/e140_dll.lpr)** использует измеренные
данные для расчетов непосредственно из той же памяти, куда они были записаны драйвером аппаратуры **[lcomp.dll](/opt/daqgroup/suite/crwlib/_crw_lcard.pas)**,
работающим в контексте процессса **[e140_drv.exe](../daqpas/e140_drv/e140_drv.lpr)**. Данные после обработки поступают из кода библиотеки
**[e140_dll.dll](../daqpas/e140_dll/e140_dll.lpr)** в ядро пакета **CRW-DAQ** напрямую через программный интерфейс **CRW API**,
минуя прикладную программу **[e140_drv.pas](../daqpas/e140_drv.pas)**, что обеспечивает высокую скорость записи данных в кривые.
При этом для синхронизации передатчика и приемника данных используются сообщения, передаваемые по каналу связи.
Это гарантирует неразрушающее использование общей памяти передатчиком и приемником.
В целом получается система, обладающая свойствами отказоустойчивости и высокой скорости обмена данными, оставаясь при этом
достаточно высоко адаптивной, так как прикладные прогаммисты сравнительно легко могут менять код прикладной программы,
не подвергая систему серьезному риску из-за программных ошибок (за счет защиты, которую дает виртуальная машина **DAQ Pascal**).

Такова, вкратце, концепция измерительной программы и ее состав. Теперь перейдем к подробностям её конфигурации.

Конфигурационный файл **[!demo_e140.cfg](../config/!demo_e140.cfg)** является "заголовочным" и содержит ссылку на
основной конфигурационный файл **[e140_ctrl.cfg](../config/e140_ctrl.cfg)**, в котором описано устройство **&E140.CTRL**,
в контексте которого исполняется **PAS** программа драйвера **[e140_drv.pas](../daqpas/e140_drv.pas)** на языке **Daq Pascal**.
Эта программа запускает на исполнение автономную измерительную **EXE** программу **[e140_drv.exe](../daqpas/e140_drv/e140_drv.lpr)**,
исполняемую в отдельном процессе,
а также загружает динамическую **DLL** библиотеку **e140_dll.dll**, которая служит для связи этой программы с пакетом **CRW-DAQ**.
Связь **DLL** библиотеки и **EXE** программы осуществляется через общую память.
Связь **PAS** программы и **EXE** программы осуществляется через анонимные каналы.

Собственно сбором данных занята программа драйвера **[e140_drv.exe](../daqpas/e140_drv/e140_drv.lpr)**, код которой находится в файлах

1. **[e140_drv.lpr](../daqpas/e140_drv/e140_drv.lpr)** - основной текст программы драйвера, представляющей из себя отдельное консольное приложение,
   управляемое командами, поступающими из консоли стандартного ввода и выдающее в консоль стандартного вывода некоторые ответные сообщения.
   Программа драйвера всегда запускается из программы **[e140_drv.pas](../daqpas/e140_drv.pas)**, написанной на **DaqPascal**,
   которая с помощью переназначения стандартных потоков ввода-вывода посылает нужные команды и перехватывает ответные сообщения.
   Консольная программа также использует общую память для высокоскоростного обмена данными с пакетом **CRW-DAQ**
   через библиотеку **[e140_dll.lpr](../daqpas/e140_dll/e140_dll.lpr)**.
   При этом выделение измерительной программы в отдельный процесс обеспечивает отказоустойчивость системы,
   а обмен данными через общую память обеспечивает высокую скорость сбора данных.

2. **[e140_api.pas](../daqpas/e140_api/_crw_e140_api.pas)** - вспомогательная библиотека, содержащая класс **TE140**,
   облегчающий работу с устройством. Этот класс содержит внутри себя все специфические для данного **АЦП** вызовы,
   позволяя в основной программе сосредоточиться на логике работы, а не на деталях реализации работы с **АЦП**.

3. **[e140_shm.pas](../daqpas/e140_api/_crw_e140_shm.pas)** - вспомогательная библиотека, содержащая описание буфера общей памяти **TE140_SHARED_BUFFER**,
   который используется для обмена данными. Выделение описания общей памяти в отдельный модуль, который используется
   как в программе **[e140_dll.lpr](../daqpas/e140_drv/e140_drv.lpr)**, так и в библиотеке **[e140_dll.lpr](../daqpas/e140_dll/e140_dll.lpr)**
   гарантирует, что при внесении изменений в программу буферы приемника и передатчика будут одинаковы.

4. **[_crw_lcard.pas](/opt/daqgroup/suite/crwlib/_crw_lcard.pas)** - интерфейсная библиотека к **DLL** файлу **lcomp.dll**, 
   обеспечивающая доступ к **[драйверам](#drivers)** **E14-140** и поставляемая с устройством (слегка модифицирована мной).

Интерфейсная **DLL** библиотека **[e140_dll.lpr](../daqpas/e140_dll/e140_dll.lpr)** обеспечивает высокоскоростное считываение измеренных данных
из общей памяти и запись этих данных в кривые **CRW-DAQ**. Эта библиотека загружается/освобождается **PAS** программой при старте/завершении
с помощью функций **`DAQ_DLL_INIT`**, **`DAQ_DLL_FREE`**. При измерении очередной порции данных **EXE** программа посылает (через канал)
сообщение в консоль **PAS** программы, содержащее ссылку на буфер в общей памяти, где содержатся измеренные данные. При обработке этого
сообщения **PAS** программа записывает эти ссылки в тег **E140.OnReadout** и с помощью функции **`DAQ_DLL_CALL`** вызывает **DLL** программу.
Код  **DLL** программы, используя тег **E140.OnReadout**, дешифрует сообщение и считывает из общей памяти измеренные данные, на которые ссылается сообщение.
Затем с помошью интерфейса **CrwApi** программа **DLL** преобразует измеренные данные в нужные единицы и записывает их в кривые **CRW-DAQ**.
Надо заметить, что использование промежуточного тега **E140.OnReadout** для передачи сообщения в **DLL** программу необходими потому, что
**DLL** программа не имеет прямого доступа к переменным **PAS** программы и ее консоли. Поэтому консольные команды считываются в тег
 и только потом делается вызов **DLL** программы. Надо также заметить, что передаваемое в теге сообщение имеет примерно такой формат:

``` ini
@E140.OnReadout=e140_drv.exe_2440,64,24448,4032,63,191,12224
  @E140.OnReadout   - идентификатор сообщения
  e140_drv.exe_2440 - имя буфера общей памяти (здесь 2440 - идентификатор процесса e140_drv.exe)
  64                - размер измеренного блока данных в общей памяти, в 2-байтовых словах
  24448             - смещение блока данных относительно начала общей памяти в байтах
  4032              - индекс блока данных в массиве данных в общей памяти
  63                - номер запроса, меняется циклически от 0 до 63
  191               - счетчик общего числа прочитанных блоков данных от старта измерений
  12224             - счетчик общего числа прочитанных измерений (семплов)
```

Следует также заметить, что код **DLL** программы анализирует имя буфера общей памяти.
Если **DLL** программа еще не подключена к общей памяти или подключена к общей памяти с другим именем,
то предыдущее подключение к общей памяти закрывается и открывается новое.
Это гарантирует, что при неожиданном аварийном перезапуске процесса **e140_drv.exe** программа **DLL** прочитает
имеющийся до "падения" процесса буфер памяти, корректно его освободит, а затем подключится к новому буферу общей памяти.
Включение идентификатора процесса в имя буфера общей памяти гарантирует уникальность имени и его однозначную связь с **EXE** процессом.

Прикладная программа **[e140_drv.pas](../daqpas/e140_drv.pas)**, написанная на **DaqPascal**, обеспечивает запуск и завершение
измерительной **EXE** программы **E140_DRV.EXE** и взаимодействие с ней по анонимному каналу, загрузку и освобождение **DLL** библиотеки
**E140_DLL.DLL** и её своевременный вызов для чтения очередной порции данных из общей памяти.
Прикладная программа также обеспечивает работу интерфейса пользователя, включая мнемосхему **[E140.CTRL.GUI](#E140.CTRL.GUI)**
для управления устройством, диалог **[&E140.PRESET](#E140.PRESET)** для настройки параметров **АЦП**, загрузку и сохранение
этих параметров в **INI**-файле, отображение кривых в окне **E140.PLOT.GUI**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="config"></a>

## Конфигурирование e140

Теперь ряд комментариев к конфигурации устройства **&E140.CTRL**.

Переменная

``` ini
Simulation = 1 ; 0:Real work mode, 1:Simulation mode
```

задает режим симуляции.

- При значении **Simulation=0** измерения идут в нормальном режиме.  

- При значении **Simulation=1** включается режим программной симуляции.  
  Программная симуляция позволяет тестировать работу программы, не имея реальной аппаратуры.
  При этом происходит запуск измерительной программы, обмен данными через общую память,
  в общем практически все, кроме реальных измерений.
  Режим симуляции незаменим при отладке измерительных систем, при рабочих измерениях симулятор отключается.  
  При работе в режиме симуляции можно использовать консольную команду программы **e140_drv.pas**
  
``` ini
@E140.SimulateAdc=i,z,a,n
    
    i - номер канала 0..31
    z - постоянная, mV
    a - амплитуда "пилы" частотой около 50 Гц, mV
    n - уровень шума, mV
```

Эта команда посылается в консоль устройства **&E140.CTRL** и позволяет динамически
менять параметры симулятора во время отладки.

Переменные

``` ini
AnalogOutputs  = 32 ; Number of analog outputs
AnalogInputs   = 2  ; Number of analog inputs
DigitalOutputs = 2  ; Number of digital outputs
DigitalInputs  = 16 ; Number of digital inputs
```

задают число цифровых и аналоговых входов-выходов.
Эти числа фиксированы и не должны меняться, хотя не обязательно подключать кривые к всем входам и выходам.
Следует заметить, что в дифференциальном режиме **АЦП** в **Analog Output 0 .. 15** пишутся измеряемые сигналы с входов,
а в **Analog Output 16 .. 31** "смещения нулей". Кроме того, надо заметить, что в кривую **Digital Output 1** пишется
разница времен по часам **АЦП** и компьютера, для контроля "ухода часов".

Переменные

``` ini
StdInFifo  = 128 ; StdIn  Fifo size, kb
StdOutFifo = 128 ; StdOut Fifo size, kb
StdInPipe  = 128 ; StdIn  Pipe size, kb
StdOutPipe = 128 ; StdOut Pipe size, kb
```

задают размеры **FIFO** буферов и каналов ввода-вывода, которые используются для связи программы
**[e140_drv.pas](../daqpas/e140_drv.pas)** с программой **[e140_drv.exe](../daqpas/e140_drv/e140_drv.lpr)**.
Эти буферы должны быть достаточными для "прокачки" сообщений, иначе будут наблюдаться потери данных.
Поток сообщений при работе **АЦП** сотавляет порядка **4 kB** в секунду, при старте и остановке измерений
он может быть на порядок больше, поэтому запас в разумных пределах не помешает.
Выбор размера **128 kB** выглядит вполне разумным.

Переменные

``` ini
AnalogFifo       = 1000000       ; Analog events - fifo size
DispatcherFilter = -packx,-packy ; Switch off data packing
```

задают параметры очереди аналоговых событий - длину очереди и параметры фильтра для обработки данных.
Длина очереди событий должна быть достаточной для временного размещения порции данных, которые затем асинхронно записываются в кривые диспетчером событий.
Учитывая высокую частоту **АЦП** (до **100 kHz**) следует брать длину очереди не менее 100000 событий (запас около секунды), иначе может начаться потеря данных.
При этом также надо учитывать, что каждое событие "весит" **32** байта, поэтому длину надо выбирать также исходя из имеющихся ресурсов памяти.
Для исключения потери данных с одной стороны и переполнения памяти с другой необходимио также правильно выбирать параметры истории (**history**)
при подключении кривых, а также параметр **HistoryLimits** в секции **[DAQ]**, который позволяет ограничивать историю кривых на уровне всей конфигурации.
Если параметр истории указан неверно, кривые будут "терять" данные по мере накопления, так как параметр "истории" показывает, сколько точек кривая
должна гарантированно "удерживать" в памяти. При поступлении новых данных наиболее "старые" по времени данные будут "отбрасываться", чтобы кривая
не росла до бесконечности.  

**DispatcherFilter** задает параметры фильтра событий, чтобы исключить упаковку данных, которая в данном случае отключается,
чтобы данные шли по принципу "как есть", без сжатия.
В других случаях упаковка данных может оказаться полезной для сокращения объема данных хранимых, и тогда надо
использовать **DispatcherFilter=+packx,+packy**.


Переменные

``` ini
InquiryPeriod    = 1                 ; Polling time period, msec
DevicePolling    = 4, tpTimeCritical ; Polling thread timing and priority
```

обеспечивают опрос **PAS** программы с высоким приоритетом и частотой.
Это надо для своевременного считывания буферов из общей памяти.

Переменные

``` ini
ProgramSource = ..\daqpas\e140_drv.pas ; Program source file
DLL_FILE_PATH = ..\daqpas\e140_dll.dll ; DLL driver
EXE_FILE_PATH = ..\daqpas\e140_drv.exe ; EXE driver
INI_FILE_PATH = ..\data\e140_param.ini ; E140 INI file name
INI_FILE_SECT = [E140.PARAMETERS]      ; E140 INI file sect
```

описывают расположение файлов описанных выше компонентов программы (**PAS**, **EXE** и **DLL**),
а также имя файла и секции инициализационного **INI**-файла, содержащего настройки **АЦП**.
Этот **INI**-файл включается в конфигурацию выражением:

``` ini 
[ConfigFileList]
ConfigFile = ..\data\e140_param.ini
[]
```

Переменные

 ``` ini
AutoLoadIniFile  = 1 ; Auto Load INI file on Start
AutoSaveIniFile  = 0 ; Auto Save INI file on Exit
```

позволяют управлять автоматической загрузкой и сохранением параметров **АЦП** в **INI** файле.

Переменные

``` ini
StartupScript = [&E140.CTRL.OnStartup] ; Script on startup
ScriptOnStart = [&E140.CTRL.OnStart]   ; Script on Start pressed
ScriptOnStop  = [&E140.CTRL.OnStop]    ; Script on Stop  pressed
```

задают имена секций, в которые помещаются командные скрипты, исполняемые при загрузке программы, старте и остановке измерений.
Эти скрипты выглядят примерно так:

``` ini
[&E140.CTRL.OnStartup]
@WinShow E140.PLOT.GUI
@WinDraw E140.PLOT.GUI|Left=|Top=317|Width=800|Height=400
@WinDraw E140.PLOT.GUI|Options=-Min,-Max,+Close,+VScroll
@WinHide E140.PLOT.GUI
@WinShow E140.CTRL.GUI
@WinDraw E140.CTRL.GUI|Left=167|Top=0|Width=420|Height=360
@WinDraw E140.CTRL.GUI|Options=-Min,-Max,+Close,-VScroll,-HScroll
@WinSelect E140.CTRL.GUI
[]
[&E140.CTRL.OnStart]                ; Script to execute on E140_DRV.EXE start
@E140.ThreadPriority=tpTimeCritical ; Set ADC thread  priority
@E140.ProcessPriority=RealTime      ; Set ADC process priority
@E140.Errors=0                      ; Clear error counter
@E140.Memory                        ; Ask memory usage
@E140.DO=ON                         ; Enable digital outputs
@E140.DO=0                          ; Set value for digital outputs
@E140.AO=0,0                        ; Set value for DAC 0
@E140.AO=1,0                        ; Set value for DAC 1
@E140.Help                          ; Show help
[]
[&E140.CTRL.OnStop]                 ; Script to execute on E140_DRV.EXE stop
@E140.AO=0,0                        ; Set value for DAC 0
@E140.AO=1,0                        ; Set value for DAC 1
@E140.DO=0                          ; Set value for digital outputs
@E140.DO=OFF                        ; Disable digital outputs
@E140.Stop                          ; Stop device
@E140.Close                         ; Close device
[]
```

В данном случае загрузочный скрипт **E140.CTRL.OnStartup** задает размеры и свойства окон.
Стартовый скрипт **E140.CTRL.OnStart** задает высокий приритет измерительному потоку и процессу,
устанавливает некоторый начальный уровень на **ЦАП** и цифровых выходах.
Завершающий скрипт **E140.CTRL.OnStop** задает "конечный" уровень аналоговых и цифровых выходов
и завершает работу устройства.

Переменные

``` ini
winCtrl    = E140.CTRL.GUI  ; Window with control GUI
winPlot    = E140.PLOT.GUI  ; Window with ADC curves
devPreset  = &E140.PRESET   ; E140 preset dialog device
devSaveCrw = &E140.SAVE.CRW ; Device to save data to CRW file
tagReadout = E140.READOUT   ; Temporary data, OnReadout event
tagStart   = E140.START     ; START button
tagClear   = E140.CLEAR     ; CLEAR button
tagPreset  = E140.PRESET    ; PRESET button
tagNotify  = E140.NOTIFY    ; Dialog notification
tagDrum    = E140.DRUM      ; Drum, i.e. progress indicator
tagFreq    = E140.FREQ      ; ADC frequency, kHz
tagDiff    = E140.DIFF      ; ADC differential/single-ended mode
tagClkSrc  = E140.CLKSRC    ; 0=Int,1=Ext ADC clock source
tagClkOut  = E140.CLKOUT    ; 0=Dis,1=Enable ADC clock out
tagInpMod  = E140.INPMOD    ; ADC input mode
tagAdType  = E140.ADTYPE    ; ADC trigger type
tagAdMode  = E140.ADMODE    ; ADC trigger mode
tagAdChan  = E140.ADCHAN    ; ADC trigger channel
tagAdTrsh  = E140.ADTRSH    ; ADC trigger threshold
tagCadjP   = E140.CADJ.P    ; Clock adjustment period, sec
tagCadjC   = E140.CADJ.C    ; Clock adjustment coefficient
tagGateDi  = E140.GATE.DI   ; Gate for DIs
tagGateDo  = E140.GATE.DO   ; Gate for DOs
tagGateAo  = E140.GATE.AO   ; Gate for DACs
tagGate##  = E140.GATE.##   ; ADC gates
tagGain##  = E140.GAIN.##   ; ADC gains
tagFir##   = E140.FIR.##    ; ADC FIR filter
tagSaveCrw = E140.SAVE.CRW  ; Save to CRW button
tagSaveErr = E140.SAVE.ERR  ; Save errors counter
tagSaveIni = E140.SAVE.INI  ; Save to INI button
tagLoadIni = E140.LOAD.INI  ; Load from INI button
tagWinCap  = E140.WIN.CAP   ; Data window caption
tagWinTit  = E140.WIN.TIT   ; Data window title
tagWinLab  = E140.WIN.LAB   ; Data window lable
tagIErrors = E140.IERR      ; Error counter - I/O operations
tagTErrors = E140.TERR      ; Error counter - EXE terminated
tagSErrors = E140.SERR      ; Error counter - send commands
tagPErrors = E140.PERR      ; Error counter - DLL polling
```

задают имена тегов, устройств и окон, используемых программой сбора данных.
Это позволяет легко изменять наименование тегов, не изменяя программного кода.

Остальные параметры не имеют какой-то особенной специфики и используются так же,
как в большинстве других систем **CRW-DAQ**.


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Инсталляция драйверов от L-CARD

<a name="drivers"></a>

Программа рассчитана на работу с фирменными **драйверами**, поставляемыми **[изготовителем](http://www.lcard.ru)**.
Поэтому требуется предварительная инсталяция этих драйверов.

Драйверы под **Linux**:

- **[install-lcomp-dkms.deb](/srv/public/mirror/addons/daqgroupkit/install-lcomp-dkms.deb)** - драйверы ядра,  
- **[install-liblcomp1.deb](/srv/public/mirror/addons/daqgroupkit/install-liblcomp1.deb)** - библиотеки пользователя,  
- **[install-liblcomp1-dev.deb](/srv/public/mirror/addons/daqgroupkit/install-liblcomp1-dev.deb)** - библиотеки разработки,  
- **[install-daqgroup-lcard.deb](/srv/public/mirror/addons/daqgroupkit/install-daqgroup-lcard.deb)** - прикладное **API** и необходимые утилиты.  

Драйверы под **Windows**:
- **[lcomp.exe](/opt/daqgroup/share/lcard/lcomp/win/lcomp.exe)** - драйверы и библиотеки (инсталлятор).

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="e140-ctrl-gui"></a>
<a name="E140.CTRL.GUI"></a>

## Описание мнемосхемы E140.CTRL.GUI

![Мнемосхема драйвера e140.](../bitmaps/e140_ctrl.bmp)

Эта мнемосхема служит для управления измерительной картой **E14-140**,
а также для наблюдения её состояния.

В полях **00**&nbsp;![](../bitmaps/e140_led07g.bmp), **01**&nbsp;![](../bitmaps/e140_led07g.bmp) и т.д.
отображаются текущие измеренные значения в соответствующих каналах **АЦП**, выраженные в миллиВольтах.
В случае использования режима измерения сигналов с общей землей (**single ended**) все каналы
от **00** до **31** показывают сигнал, подключенный к соответствующим входам **АЦП**.
В случае дифференциального (**differential**) режима работы первые **16** каналов (от **00** до **15**) содержат значения измеренных
дифференциальных сигналов, подключенных к соответствующим входам **АЦП**, а остальные **16** каналов (от **16** до **31**)
содержат измерения "смещения нулей" **АЦП**, то есть измерений в тех же **16** каналах, но выполненных с короткозамкнутым входом.
Короткозамкнутый вход организован схемотехнически внутри самой измерительной карты и не требует замыкания входов на разъеме.
Программа чтения устроена так, что при дифференциальном включении  каналы **16**..**31** измеряют "смещение нуля"
каналов **00**..**15**.

В полях **AO**&nbsp;![](../bitmaps/e140_led07g.bmp),
**A1**&nbsp;![](../bitmaps/e140_led07g.bmp) отображаются текущие 
значения данных, которые посылаются в **ЦАП**, выраженные в миллиВольтах.

В полях **DI**&nbsp;![](../bitmaps/e140_led07g.bmp),
**dT**&nbsp;![](../bitmaps/e140_led07g.bmp) отображаются данные цифровых входов **DI**,
а также оценка **dT** "смещения времени", то есть разницы времени по часам **АЦП** и компьютера в **ms**.

В полях **IE**&nbsp;![](../bitmaps/e140_led07g.bmp),
 **TE**&nbsp;![](../bitmaps/e140_led07g.bmp)
 **SE**&nbsp;![](../bitmaps/e140_led07g.bmp),
 **PE**&nbsp;![](../bitmaps/e140_led07g.bmp)
отображаются счетчики ошибок.
**IE** - счетчик ошибок операций ввода-вывода,
**TE** - счетчик "падений" драйвера **E140_DRV.EXE**,
**SE** -  счетчик ошибок посылки команд в канал связи,
**PE** - счетчик критических сбоев при вызове **E140_DLL.DLL**.

![](../bitmaps/e140_start0.bmp) - кнопка выполняет **СТАРТ** и **СТОП** измерений.
Перед измерениями необходимо задать параметры нажатием кнопки **PRESET** <img src="../bitmaps/e140_preset0.bmp" width="24" height="24">.
Все параметры сбора данных (кроме **FIR** фильтров) должны задаваться перед стартом, так как после старта,
во время работы карты, их изменить нельзя. После старта также запрещено делать очистку и сохранение данных.
Эти функции доступны только после остановки измерений.

![](../bitmaps/e140_preset0.bmp) - кнопка вызова **[диалога настройки](#E140.PRESET)** свойств карты и параметров сбора данных. 
Все настройки делаются до старта измерений, в процессе измерений их менять нельзя, кроме **FIR** фильтров, которые можно изменять динамически.

![](../bitmaps/e140_clear0.bmp) - кнопка очистки измеренных кривых.  
Очистка делается до старта измерений, чтобы удалить данные предыдущей экспозиции.
Операция очистки необратима и если оператор забыл сохранить данные, они пропадут бесследно.
Поэтому перед очисткой выдается запрос на подтверждение очистки, чтобы случайно не удалить данные, которые не сохранены на диске.

![](../bitmaps/e140_save0.bmp) - кнопка сохранения измеренных кривых в **CRW** файл.  
Сохрание измеренных данных делается после остановки измерений, чтобы записать данные этой экспозиции на диск в файл формата ***.crw**.
Сохранение во время измерений запрещено. Имя файла генерируется по текущей дате и времени.
При записи файла в консольном окне **ГЛАВНАЯ КОНСОЛЬ** печатается сообщение о том, в какой файл были сохранены данные.
Поэтому после сохранения файла надо заглянуть в эту консоль убедиться, что запись прошла успешно.

![](../bitmaps/e140_drum0.bmp) - индикатор прогресса измерений.  
При начале измерения начинает циклически изменять состояние на:  

![](../bitmaps/e140_drum1.bmp)
![](../bitmaps/e140_drum2.bmp)
![](../bitmaps/e140_drum3.bmp)
![](../bitmaps/e140_drum4.bmp)

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="e140-preset"></a>
<a name="E140.PRESET"></a>

## Описание диалога E140.PRESET

![Диалог параметров e140.](../bitmaps/e140_preset.bmp)

Это диалог для задания параметров сбора данных измерительной карты **E14-140**.

Вызывается только перед стартом или после остановки измерений, **во время измерений параметры менять нельзя**.
Единственным исключением являются **FIR** фильтры, которые можно менять всегда.
Но они, строго говоря, к сбору данных не относятся, так как обработка (фильтрация) данных делается независимо от измерений.

Рассмотрим параметры сбора данных подробнее.

---

<a name="adc-mode-freq"></a>

![](../bitmaps/e140_pres01.bmp) - задает режим и частоту **АЦП**.

Режим (**Mode**) может принимать два значения: **Single[32]** и **Diff[16]**.

- В режиме **Single[32]** измерения идут по **32** каналам **00**..**31**, подключенным по схеме с "общей землей".

- В режиме **Diff[16]** измерения идут по **16** каналам **00**..**15**, подключенным по дифференциальной схеме.  
  При этом в каналах **16**..**31** в дифференциальном режиме записываются "смещения нулей", то есть измерения с короткозамкнутым входом.
  Короткозамкнутый вход организуется схемотехнически прямо на измерительной карте и не требует замыкания на разъемах **АЦП**.
  Дифференциальный режим является более предпочтительным для высокоточных измерений, так как он более устойчив к помехам.

Частота (**Frequency,kHz**) задает общую частоту опроса **АЦП** в килоГерцах и меняется в диапазоне от **1 kHz** до **200 kHz**.
Частота опроса на один канал получается делением общей частоты опроса на число активных каналов, так как **АЦП** работает в режиме мультиплексирования.

Сбор данных идет в непрерывном режиме, пока не будет нажата кнопка **СТОП**. Хотя в процессе измерений изменять частоту опроса **АЦП** нельзя,
но за счет **FIR** фильтров можно менять "эффективную" частоту опроса, так как **FIR** фильтр накапливает заданное число измерений **АЦП**
и записывает в кривые усредненное по этой порции значение, поэтому частота "выдачи" результатов измерений в кривые снижается в число раз, равное числу точек усреднения.

---

<a name="adc-ini-file"></a>

![](../bitmaps/e140_pres02.bmp) - служит для записи и чтения параметров в **INI** файле.

**INI** файл **[demo_e140_param.ini](../data/demo_e140_param.ini)** расположен в каталоге **[Data](../data/)**.
Он содержит значения параметров сбора данных **E140** (которые задаются в окне **[диалога настройки](#E140.PRESET)**).
**INI** файл загружается автоматически при запуске измерительной конфигурации, а также по требованию,
если поставить флажок "**Load INI**" в окне **[диалога настройки](#E140.PRESET)** и нажать **OK**.
Сохранение параметров в **INI** делается только по требованию, если поставить флажок "**Save INI**"
в окне **[диалога настройки](#E140.PRESET)** и нажать **OK**.
При этом текущие настройки сбора данных будут записаны в **INI** файл, а при следующем запуске
системы сбора данных они будут автоматически загружены.

---

<a name="adc-gate-gain"></a>

![](../bitmaps/e140_pres03.bmp) - служит для задания карты опроса каналов **АЦП**.

Флаг **Gate** разрешает (или запрещает) опрос данного канала.

В силу особенностей работы устройства (буферизация с выравниванием по **32** слова и очередь асинхронных операций чтения) программа требует,
чтобы число разрешенных каналов было степенью двойки (**1**,**2**,**4**,**8**,**16**,**32**).
Несоблюдение этого условия по числу каналов может привести к неверной работе программы сбора данных.
Поэтому, если задать карту разрешений, в которой разрешено "неправильное" число каналов,
то программа автоматически установит разрешения для каналов таким образом, чтобы удовлетворить указанному условию.
Это обстоятельство надо учитывать при выборе режимов работы, так как число разрешенных каналов опроса влияет на частоту опроса (в расчете на один канал).
Если, например, разрешить опрос **5** каналов, то система автоматически разрешит опрос **8** каналов,
то есть будет дополнительно разрешен опрос **3** "лишних" каналов.
Поэтому при задании карты опроса надо стремиться указывать либо число каналов, равное степени двойки, либо выбирать частоту опроса **АЦП**
с учетом того, что реальное число опрашиваемых каналов может отличаться от числа первоначально заданных каналов.
Также настоятельно рекомендуется закоротить все неиспользуемые каналы, чтобы "лишние" каналы, включенные в список опроса, не вносили помех.

Параметр **Gain** задает диапазон **АЦП** для данного канала опроса.  
Он может принимать **4** значения: **10000 mV**, **2500 mV**, **625 mV**, **156.25 mV**.

Параметр **Filter** задает сглаживающий **FIR** фильтр.<br>
**FIR**-фильтр переводится как "фильтр с конечной импульсной характеристикой" (**Finite Impulse Response**).
Или, другими словами, это нерекурсивный фильтр, который имеет конечную "память" на воздействия.
В данном случае реализован довольно простой фильтр, работающий следующим образом.

При значении **Filter = 0** данные, поступающие при сборе данных **АЦП**, игнорируются и в кривые не пишутся.
То есть, хотя сбор данных на аппаратном уровне продолжается, в прикладную программу данные не будут поступать.
Это позволяет использовать фильр как программный флаг разрешения сбора данных (подобно **Gate**).
Достоинство **Filter** состоит в том, что его значение можно менять мгновенно и в любое время,
в отличие от **Gate**, которое можно изменять только когда измерения остановлены.
Кроме того, изменение значения **Filter** не влияет на частоту опроса других каналов, что тоже хорошо.

При значении **Filter = 1** данные, поступающие при сборе данных **АЦП**, пишутся в кривые "как есть", без всякой фильтрации.
Это эквивалентно отключению фильтра и работе на максимальной скорости **АЦП**, что полезно при регистрации быстрых сигналов.
Важно, что этот режим можно мгновенно включать и отключать, что позволяет регистрировать медленно изменяющиеся сигналы с небольшой частотой,
мгновенно переходя на более высокую частоту регистрации при необходимости записи быстро протекающих процессов.

При значении **Filter = N**, где **N &gt; 1**, данные, поступающие при сборе данных **АЦП**, накапливаются в буфере
длиной **N** точек и записываются в кривые по заполнению буфера.
Это значит, что "эффективная" частота, то есть частота "выдачи" результатов измерений в кривые, падает в **N** раз, так как данные
на входе фильтра из **N** точек дают на выходе фильтра одну точку.
На самом деле в буфере накапливаются статистические суммы
**&sum;X<sub><i>i</i></sub>**, **&sum;Y<sub><i>i</i></sub>** и счетчик точек **n**.
По достижении числа точек **N** в качестве результата измерения выдается точка
**X=&sum;X<sub><i>i</i></sub>/N**, **Y=&sum;Y<sub><i>i</i></sub>/N**.
Здесь под **X** понимается время измерения, под **Y** - значение **АЦП** в милливольтах.

Таким образом, фильтр обеспечивает как "прореживание", так и "сглаживание" данных, что весьма удобно.
Следует также подчеркнуть, что значение фильтров можно менять мгновенно, что позволяет прямо "на ходу",
не прекращая измерений в других каналах, приостанавливать сбор данных, замедлять его или ускорять,
адаптируясь под характер сигнала.

При использовании параметра **Filter** следует учитывать, что фильтр применяется к буферу, а не к отдельному измерению.
Это значит, что значение фильтра считывается перед обработкой очередного буфера и не меняется в процессе его обработки.
То есть при изменении параметра **Filter** это изменение "почувствуется" только начиная со следующего буфера данных.
Надо напомнить, что буферы данных поступают с частотой около **20** Гц (раз в **50** миллисекунд).
Именно с такой задержкой и будет применяться изменение фильтра.

---

<a name="adc-clock"></a>

![](../bitmaps/e140_pres04.bmp) - задает параметры тактовых "часов" **АЦП**.

Параметр **Clock source** задает источник тактовых импульсов **АЦП** и может принимать два значения.
При значении **Internal quartz clock** для тактирования используется внутренний кварцевый генератор импульсов.
При значении **External clock (AI20)** для тактирования используется внешний сигнал, поступающий с аналогового разъема **INT**, пин **20**.
В настоящее время настоятельно рекомендуется использовать только внутренний генератор тактовых импульсов, так как при использовании
внешних тактовых импульсов привязка точек по времени может оказаться неверной (шкала времени может быть неверной).
При использовании внутреннего тактирования надо учитывать тот факт, что тактовый генератор на измерительной карте
может иметь слегка отличную частоту от частоты часов компьютера.
Это приведет к постепенному "уходу" часов **АЦП** от системных часов компьютера, который составляет порядка секунды в сутки.
Это означает, что кривые измерений **АЦП** могут при длительной работе слегка отставать или опережать по оси **X** кривые других сигналов,
которые регистрируются по часам компьютера. Это надо учитывать при дальнейшей обработке сигналов, которая должна предусматривать синхронизацию
шкалы времени (по каким-то характерным пикам сигнала, например).

Параметр **Clock output** позволяет разрешить (**Enable**) или запретить (**Disable**) трансляцию внутренних тактовых импульсов
на выход разъема **INT**, пин **20**. Разумеется, трансляция тактовых импульсов работает только если включен режим внутренних тактовых импульсов.
Наличие режима внешнего тактирования и трансляции внутренних тактовых импульсов позволяет организовывать системы синхронного сбора данных
на нескольких картах. При этом одна карта ("ведущая") работает на внутреннем тактировании и транслирует тактовые импульсы, а остальные
карты используют эти тактовые импульсы в режиме внешнего тактирования. При этом несколько **АЦП** будут иметь одинаковую шкалу времени и
фактически будут работать как одна большая карта с произвольно большим числом каналов (при добавлении новых карт).
Однако в настоящее время такой режим программно не поддерживается и поэтому использовать трансляцию тактовых импульсов нет смысла.
Возможно, в будущем это будет реализовано.

---

<a name="adc-dac-dio"></a>

![](../bitmaps/e140_pres05.bmp) - разрешает или запрещает **ЦАП** и цифровой ввод-вывод.

- Флажок **AO-s** разрешает использование **ЦАП** (доступно только при его наличии в карте).  
- Флажок **DO-s** разрешает использование цифровых выводов.  
- Флажок **DI-s** разрешает использование цифровых вводов.  

Надо иметь в виду, что разрешение любого из этих флажков резко снижает надежность сбора данных, особенно при частоте выше **10 kHz**.
Дело в том, что **АЦП**, **ЦАП** и цифровой ввод-вывод используют одну и ту же шину данных (**USB**).
При высокоскоростном сборе данных команды **ЦАП** и цифрового ввода-вывода начинают мешать вовремя скачивать данные **АЦП**,
что время от времени приводит к аварийной остановке работы программы сбора данных.
Поэтому рекомендуется по возможности либо не использовать **ЦАП** и цифровой ввод-вывод, либо сократить частоту его использования до минимума.
Для ответственных измерений использовать  **ЦАП** и цифровой ввод-вывод не рекомендуется.

---

<a name="adc-trigger"></a>

![](../bitmaps/e140_pres06.bmp) - задает параметры триггера на старт измерений.

Параметр **Start synchronization** задает способ синхронизации старта измерений **АЦП** и имеет **4** значения.

0. "**Start immediately, SOFT**" - измерения стартуют немедленно после нажатия кнопки **СТАРТ**,
   то есть момент старта не синхронизован с какими-либо внешними сигналами и определяется программным стартом.  
1. "**Start on TTL, AI pin 20**" старт синхронизуется подачей низкого уровня (замыканием на землю)
   на **TTL**-совместимый вход **INT** аналогового разъема, пин **20**.
   То есть после нажатия кнопки **СТАРТ** карта переходит в режим готовности и ждет сигнала.
   При появлении этого сигнала начинается сбор данных.  
2. "**Frame on TTL, do'nt use**" внешним сигналом синхронизуется каждый кадр.
   Этот режим в данной программе не поддерживается и его не надо включать.  
3. При значении "**Start on Analog trigger**" старт синхронизуется аналоговым сигналом.
   Способ синхронизации аналоговым сигналом описывают следующие **4** параметра.  

Параметр **AI trigger type**, имеющий смысл при синхронизации аналоговым сигналом,
задает тип синхронизации - по уровню сигнала "**by Level**" или по изменению (фронту)
сигнала "**by Front**".

Параметр "**AI trigger mode**", имеющий смысл при синхронизации аналоговым сигналом,
задает режим синхронизации. Он имеет два значения - "**HI**" - синхронизация по
верхнему уровню (при типе "**by Level**") или фронту возрастания (при типе "**by Front**"),
или "**LO**" - синхронизация по нижнему уровню (при типе "**by Level**") 
или фронту убывания (при типе "**by Front**").

Параметр **AI trigger channel** - это номер аналогового канала, по которому делается синхронизация,
от **0** до **15** или до **31**, в зависимости от режима **АЦП**.

Параметр **AI trigger threshold** задает порог аналогового триггера для запуска измерений **АЦП** в миллиВольтах.
То есть после старта измерений **АЦП** переходит в режим готовности и ждет, когда в заданом канале
уровень сигнала (или его фронт, в зависимости от типа триггера) превысит заданное пороговое значение,
и только после этого сбор данных начинается.
Это позволяет использовать карту для измерения однократных быстро протекающих процессов, с автоматическим
стартом по появлению сигнала выше заданного порога.

---

<a name="adc-clock-adjustment"></a>

![](../bitmaps/e140_pres07.bmp) - задает параметры автоматической коррекции шкалы времени.

Автоматическая коррекция времени пытается подстроить расчетную частоту **АЦП** - так, чтобы
сократить разницу времени по часам компьютера и **АЦП**.  
Надо иметь в виду, что

- При отсутствии коррекции частота **АЦП** постоянна, а разница времен по часам **АЦП** и компьютера
  меняется примерно линейно, возможно, со "ступеньками".  
- При включении коррекции частота **АЦП** и разница времен могут осциллировать в небольших пределах.  

Параметр "**Period, sec**" задает периодичность коррекции в секундах.
Если задать нулевой период коррекции, то коррекция шкалы времени отключается
и часы **АЦП** не подвергаются автоматической подстройке.
Рекомендуемое значение периода при коррекции - несколько минут.
Значение по умолчанию = **600** секунд (**10** минут).

Параметр "**Coefficient**" задает коэффициент коррекции в диапазоне **[0..1]**.
Если задать нулевой коэффициент коррекции, то коррекция шкалы времени отключается
и часы **АЦП** не подвергаются автоматической подстройке.
Рекомендуемое значение коэффициента при коррекции = **0.1**.
Значение по умолчанию = **0** (отключено).

---

<a name="adc-watchdog"></a>

![](../bitmaps/e140_pres08.bmp) - задает время сторожевого таймера в секундах.  
Сторожевой таймер включается после начала измерений и следит за поступлением данных **АЦП**.
Если данные не поступают в течение заданного времени, сторожевой таймер считает,
что драйвер **E140_DRV.EXE** "повис" и принудительно перезапускает его.
Для отключения сторожевого таймера надо задать нулевое время.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="files"></a>

## Вставка e140 в прикладные конфигурации

Основная часть файлов **e140** находится в папке **[resource/daqtool/lcard/e140](../)**.  
Для вставки  **e140** в прикладную конфигурацию нужно скопировать в папку этой конфигурации  
лишь небольшую часть файлов, список которых есть в файле **[e140min.sh](../e140min.sh)**,
а сами файлы упакованы в файле **[e140min.tgz](../e140min.tgz)**.

- **[circuits/e140_ctrl.crc](../circuits/e140_ctrl.crc)**
- **[config/e140_ctrl.cfg](../config/e140_ctrl.cfg)**
- **[config/e140_ctrl.gen](../config/e140_ctrl.gen)**
- **[config/e140_ctrl_crc.gen](../config/e140_ctrl_crc.gen)**
- **[config/e140_ctrl.cmd](../config/e140_ctrl.cmd)**
- **[config/e140_ctrl.sh](../config/e140_ctrl.sh)**
- **[help/e140.htm](../help/e140.htm)**


После копирования указанных файлов в папку прикладной конфигурации нужно отредактировать
там файлы сценариев-генераторов **`e140_ctrl.sh`**,  **`e140_ctrl.cmd`**, задав таблицу
подключения карт **e140** с указанием серийных номеров и т.д. Затем нужно запустить эти
сценарий-генератор, который сгенерирует конфигурацию для работы карт **e140**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

> CRW-DAQ Copyright (c) 2001-2026 Alexey Kuryakin <daqgroup@mail.ru>

---
