 {
 Standard routines for Texts:
 procedure ClearText(aText:Integer);
 function  StringToText(s:String):Integer;
 function  TextAppendText(t,s:Integer):Integer;
 function  TextAssignText(t,s:Integer):Integer;
 function  TextAppendString(t:Integer; s:String):Integer;
 function  TextAssignString(t:Integer; s:String):Integer;
 function  TextToString(aText:Integer;):String;
 function  GetTextLength(aText:Integer):Integer;
 function  IsEmptyText(aText:Integer):Boolean;
 function  GetStringVar(aText:Integer; aName:String; var aValue:String):Boolean;
 function  Text_StrReplace(txt:Integer; a,b:String; Flags:Integer):Integer;
 function  Text_IndexOf(txt:Integer; s:String):Integer;
 function  Text_Remove(txt:Integer; s:String):Integer;
 procedure ClearStdTexts;
 procedure InitStdTexts;
 procedure FreeStdTexts;
 procedure PollStdTexts;
 }
 {
 Clear text: remove all lines, but do not free text instance.
 }
 procedure ClearText(aText:Integer);
 var i,N:Integer;
 begin
  N:=text_NumLn(aText);
  for i:=N-1 downto 0 do bNul(text_DelLn(aText,i));
 end;
 {
 Append source text s to target text t.
 }
 function TextAppendText(t,s:Integer):Integer;
 var i:Integer;
 begin
  for i:=0 to text_NumLn(s)-1 do
  bNul(text_AddLn(t,text_GetLn(s,i)));
  TextAppendText:=t;
 end;
 {
 Assign source text s to target text t.
 }
 function TextAssignText(t,s:Integer):Integer;
 begin
  ClearText(t);
  TextAssignText:=TextAppendText(t,s);
 end;
 {
 Append string lines with EOL delimeters to text.
 }
 function TextAppendString(t:Integer; s:String):Integer;
 var i,p:Integer;
 begin
  if (t<>0) then begin
   i:=0; p:=1;
   repeat
    i:=PosEx(EOL,s,i+1);
    if (i>0) then begin
     bNul(text_AddLn(t,Copy(s,p,i-p)));
     p:=i+Length(EOL);
    end else begin
     if (p<=Length(s)) then
     bNul(text_AddLn(t,Copy(s,p,Length(s)-p+1)));
    end;
   until (i<=0);
  end;
  TextAppendString:=t;
 end;
 {
 Assign string lines with EOL delimeters to text.
 }
 function TextAssignString(t:Integer; s:String):Integer;
 begin
  ClearText(t);
  TextAssignString:=TextAppendString(t,s);
 end;
 {
 Convert string lines with EOL delimeters into text.
 }
 function StringToText(s:String):Integer;
 begin
  StringToText:=TextAppendString(text_new,s);
 end;
 {
 Convert text to string lines with EOL delimeters.
 }
 function TextToString(aText:Integer):String;
 begin
  TextToString:=Text_ToString(aText);
 end;
 {
 Get text full length, including EOL delimeters.
 }
 function GetTextLength(aText:Integer):Integer;
 var i,n,m:Integer;
 begin
  n:=0; m:=Length(EOL);
  for i:=0 to text_NumLn(aText)-1 do n:=n+Length(text_GetLn(aText,i))+m;
  GetTextLength:=n;
 end;
 {
 Check if text is empty (only spaces) or not.
 }
 function IsEmptyText(aText:Integer):Boolean;
 var i,Len:Integer;
 begin
  Len:=0;
  for i:=0 to Text_NumLn(aText)-1 do
  Len:=Len+Length(Trim(Text_GetLn(aText,i)));
  IsEmptyText:=(Len=0);
 end; 
 {
 Get string parameter by aName from aText list of "Name=Value" items.
 }
 function GetStringVar(aText:Integer; aName:String; var aValue:String):Boolean;
 var i,p,len,n:Integer; Line:String; Found:Boolean;
 begin
  Line:='';
  aValue:='';
  Found:=False;
  len:=Length(aName);
  if (len>0) then begin
   i:=0; n:=text_NumLn(aText);
   while (i<n) and not Found do begin
    Line:=text_GetLn(aText,i); p:=Pos('=',Line);
    if (p=len+1) then if IsSameText(aName,Copy(Line,1,p-1)) then begin
     aValue:=Copy(Line,p+1,MaxInt);
     Found:=True;
    end;
    i:=i+1;
   end;
  end;
  GetStringVar:=Found;
  Line:='';
 end;
 {
 Replace substring a to b in each text line.
 }
 function Text_StrReplace(txt:Integer; a,b:String; Flags:Integer):Integer;
 var i:Integer;
 begin
  Text_StrReplace:=txt;
  if Length(a)>0 then
  for i:=0 to Text_NumLn(txt)-1 do
  bNul(Text_PutLn(txt,i,StrReplace(Text_GetLn(txt,i),a,b,Flags)));
 end;
 {
 Find index of string line (s) in text (txt) or return -1 if one not found.
 }
 function Text_IndexOf(txt:Integer; s:String):Integer;
 var i,n,m:Integer;
 begin
  m:=-1; i:=0; n:=Text_NumLn(txt);
  while (i<n) and (m<0) do if IsSameText(Text_GetLn(txt,i),s) then m:=i else i:=i+1;
  Text_IndexOf:=m;
 end;
 {
 Remove string line (s) from text (txt). Return index of string or -1 if one not found.
 }
 function Text_Remove(txt:Integer; s:String):Integer;
 var m:Integer;
 begin
  m:=Text_IndexOf(txt,s);
  if (m>=0) then bNul(Text_DelLn(txt,m));
  Text_Remove:=m;
 end;
 {
 Clear standard Texts.
 }
 procedure ClearStdTexts;
 begin
 end;
 {
 Initialize standard Texts.
 }
 procedure InitStdTexts;
 begin
  ShouldPollStdTexts:=false;
 end;
 {
 Finalize standard Texts.
 }
 procedure FreeStdTexts;
 begin
 end;
 {
 Poll standard Texts.
 }
 procedure PollStdTexts;
 begin
 end;
