 {
 Standard routines for Pipes:
 function  Pipe_Readln(pip:Integer; var Line,Buff:String):Boolean;
 function  Com_Readln(var Line,Buff:String):Boolean;
 procedure Com_Writeln(Data:String);
 procedure PurgeComPort;
 procedure ClearStdPipes;
 procedure InitStdPipes;
 procedure FreeStdPipes;
 procedure PollStdPipes;
 }
 {
 Read line (Line) from pipe (pip) with CR or LF line terminator (EOL).
 Temporary buffer (Buff) should be global lifetime variable with startup initialization.
 }
 function Pipe_Readln(pip:Integer; var Line,Buff:String):Boolean;
 const MaxLeng = 16384;
 var p:Integer;
 begin
  Line:='';
  Pipe_Readln:=false;
  if (Pipe_Pid(pip)<>0) then begin
   if (Length(Buff)<MaxLeng) and (Pipe_RxCount(pip)>0)
   then Buff:=Buff+Pipe_Recv(pip,MaxLeng-Length(Buff));
   p:=PosEol(Buff,1,0);
   if (p>0) then begin
    Pipe_Readln:=True;
    if (p>1) then Line:=Copy(Buff,1,p-1);
    Buff:=Copy(Buff,PosEol(Buff,p,1),MaxInt);
   end else begin
    if (Length(Buff)>=MaxLeng) then begin
     Trouble('Received line is too long!');
     Buff:='';
    end;
   end;
  end;
 end;
 {
 Read line (Line) from port with CR or LF line terminator (EOL).
 Temporary buffer (Buff) should be global lifetime variable with startup initialization.
 }
 function Com_Readln(var Line,Buff:String):Boolean;
 const MaxLeng = 16384;
 var i,p,L:Integer;
 begin
  Line:='';
  Com_Readln:=false;
  if (ComCount>=0) then begin
   if (Length(Buff)<MaxLeng) and (ComCount>0)
   then Buff:=Buff+ComRead(MaxLeng-Length(Buff));
   p:=PosEol(Buff,1,0);
   if (p>0) then begin
    Com_Readln:=True;
    if (p>1) then Line:=Copy(Buff,1,p-1);
    Buff:=Copy(Buff,PosEol(Buff,p,1),MaxInt);
   end else begin
    if (Length(Buff)>=MaxLeng) then begin
     Trouble('Received line is too long!');
     Buff:='';
    end;
   end;
  end;
 end;
 {
 Send data with EOL delimeter to COM port.
 }
 procedure Com_Writeln(Data:String);
 begin
  if Length(Data)>0 then
  if ComSpace>Length(Data)+2 then begin
   if ComWrite(Data+CRLF)
   then ViewExp('COM: '+Data)
   else Trouble('COM: '+Data);
  end else begin
   Trouble('COM: FIFO OVERFLOW');
   bNul(ComClear);
  end;
 end;
 {
 Purge (clear) COM port.
 }
 procedure PurgeComPort;
 begin
  bNul(ComClear);
  while ComCount>0 do sNul(ComRead(255));
 end;
 {
 Clear standard Pipes.
 }
 procedure ClearStdPipes;
 begin
 end;
 {
 Initialize standard Pipes.
 }
 procedure InitStdPipes;
 begin
  ShouldPollStdPipes:=false;
 end;
 {
 Finalize standard Pipes.
 }
 procedure FreeStdPipes;
 begin
 end;
 {
 Poll standard Pipes.
 }
 procedure PollStdPipes;
 begin
 end;
