 {
 Standard routines for Devices:
 procedure InitDevice(var ref:Integer; name:String; typ:Integer);
 procedure DevSendCmd(devRef:Integer; Cmd:String);
 procedure DevPostCmd(devRef:Integer; Cmd:String);
 procedure DevSendCmdLocal(Cmd:String);
 procedure DevPostCmdLocal(Cmd:String);
 procedure Cron(msg:String);
 procedure Speak(msg:String);
 function  PlotSend(msg:String):Integer;
 function  VkbdSend(msg:String):Integer;
 procedure ClearStdDevices;
 procedure InitStdDevices;
 procedure FreeStdDevices;
 procedure PollStdDevices;
 }
 {
 Initialize and check device.
 typ=0:Silent, 1:Print, 2:Check.
 }
 procedure InitDevice(var ref:Integer; name:String; typ:Integer);
 begin
  ref:=RefFind('Device '+Name);
  if (typ>0) and (ref <> 0) then Success('Initialized device: '+name);
  if (typ>1) and (ref =  0) then Trouble('Could not init device: '+name);
 end;
 {
 Send device message with checking...
 }
 procedure DevSendCmd(devRef:Integer; Cmd:String);
 begin
  if (devRef<>0) then
  if (Length(Cmd)>0) then
  if (DevSend(devRef,Cmd+EOL)=0)
  then Trouble('DevSend fail to '+RefInfo(devRef,'Name'));
 end;
 {
 Post device message with checking...
 }
 procedure DevPostCmd(devRef:Integer; Cmd:String);
 begin
  if (devRef<>0) then
  if (Length(Cmd)>0) then
  if (DevPost(devRef,Cmd+EOL)=0)
  then Trouble('DevPost fail to '+RefInfo(devRef,'Name'));
 end;
 {
 Send device message to local (self) console...
 }
 procedure DevSendCmdLocal(Cmd:String);
 begin
  if (devMySelf<>0) then
  if (Length(Cmd)>0) then
  if (DevSend(devMySelf,Cmd+EOL)=0)
  then Trouble('DevSend fail to '+DevName);
 end;
 {
 Post device message to local (self) console...
 }
 procedure DevPostCmdLocal(Cmd:String);
 begin
  if (devMySelf<>0) then
  if (Length(Cmd)>0) then
  if (DevPost(devMySelf,Cmd+EOL)=0)
  then Trouble('DevPost fail to '+DevName);
 end;
 {
 Cron, i.e. post message to &CronSrv server.
 }
 procedure Cron(msg:String);
 begin
  DevPostCmd(devCronSrv,Trim(msg));
 end;
 {
 Speak, i.e. send message to speech server.
 }
 procedure Speak(msg:String);
 begin
  msg:=Trim(msg);
  if Length(msg)>0 then DevSendCmd(devSpeakSrv,'@Speak='+msg);
 end;
 {
 Send message to &PlotSrv server.
 }
 function PlotSend(msg:String):Integer;
 var dev:Integer;
 begin
  if Length(msg)>0 then dev:=devPlotSrv else dev:=0;
  if dev<>0 then PlotSend:=Round(DevSend(dev,msg)) else PlotSend:=0;
 end;
 {
 Send message to &VkbdSrv server.
 }
 function VkbdSend(msg:String):Integer;
 var dev:Integer;
 begin
  if Length(msg)>0 then dev:=devVkbdSrv else dev:=0;
  if dev<>0 then VkbdSend:=Round(DevSend(dev,msg)) else VkbdSend:=0;
 end;
 {
 Clear standard Devices.
 }
 procedure ClearStdDevices;
 begin
 end;
 {
 Initialize standard Devices.
 }
 procedure InitStdDevices;
 begin
  InitDevice(devMySelf,    DevName,   2);
  InitDevice(devDimSrv,    DimSrv,    1);
  InitDevice(devWebSrv,    WebSrv,    1);
  InitDevice(devDatSrv,    DatSrv,    1);
  InitDevice(devFdbSrv,    FdbSrv,    1);
  InitDevice(devCronSrv,   CronSrv,   1);
  InitDevice(devPlotSrv,   PlotSrv,   1);
  InitDevice(devVkbdSrv,   VkbdSrv,   1);
  InitDevice(devSpeakSrv,  SpeakSrv,  1);
  InitDevice(devEmlSrv,    EmlSrv,    1);
  InitDevice(devOpcCln,    OpcCln,    1);
  InitDevice(devModbusSrv, ModbusSrv, 1);
  ShouldPollStdDevices:=false;
 end;
 {
 Finalize standard Devices.
 }
 procedure FreeStdDevices;
 begin
 end;
 {
 Poll standard Devices.
 }
 procedure PollStdDevices;
 begin
 end;
