﻿---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Библиотечная программа _tag2crv.pas

## Назначение программы

**[_tag2crv.pas](_tag2crv.pas)** - библиотечная программа для копирования тегов в кривые и наоборот.
То есть для синхронизации (поддержания соответствия) между тегами и кривыми (обычно одноименными, но не обязательно).
Такая синхронизация бывает нужна, если требуется иметь пару (тег, кривая) с одинаковыми значениями.
Например, параметры управления и состояние управляющих элементов (кнопок) удобно хранить в тегах, но для сохранения
истории изменений этих параметров теги нужно копировать в кривые.
В других случаях кривые, генерируемые программами (например, драйверами аппаратуры) нужно использовать для оперативной
работы (например, использовать в расчетах или передавать по сети) - а для этого больше подходят теги.
Поэтому кривые бывает нужно копировать в теги или наоборот.

Напомним, что **тег** - это поименованная скалярная переменная общего доступа (целая, вещественная или строковая),
а **кривая** - массив значений некоторой переменной в зависимости от времени.
Теги обновляются мгновенно - в момент вызова функций **iSetTag**, **rSetTag**, но не помнят историю предыдущих состояний.
Кривые помнят историю предыдущих состояний, но не могут меняться мгновенно, т.к. их обновление буферизовано через **FIFO** очередь событий.
Это связано с тем, что обновление кривых может быть связано с копированием или распределением значительных объемов памяти.
Поэтому при вызове процедур обновления кривых **putao**, **putdo** данные (вместе с меткой времени) помещаются в очередь событий,
а потом копируются в кривые специальным высокоприоритетным диспетчерским потоком **Daq.Dispatcher**.
Такой способ обновления кривых позволяет избежать задержек ожидания дорогостоящих операций копирования/распределения
памяти в прикладных программах при вызове процедур обновления кривых.
Но при этом актуальное значение кривой (т.е. значение в последней добавленной точке) может несколько отставать по времени.
Соответственно теги и кривые используются в разных задачах.
Для оперативной работы больше подходят теги, для сохранения истории изменений нужны кривые.
Если нужно и то и другое, возникает необходимость синхронизации тегов и кривых.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Алгоритм работы программы

Синхронизация с помощью программы **`_tag2crv.pas`** происходит периодически, в цикле опроса,
частота которого зависит от значений **InquiryPeriod**, **DevicePolling**.
Программа в цикле опроса копирует теги в подключенные к аналоговым/цифровым выходам кривые **AnalogOutput**/**DigitalOutput**,
одноименные с этими кривыми, либо явно указанные в параметрах **tagAO#n**, **tagDO#n**.
Также программа копирует подключенные к аналоговым/цифровым входам кривые **AnalogInput**/**DigitalInput**
в теги - одноименные, либо явно указанные в параметрах **tagAI#n**, **tagDI#n**.
Здесь **n** обозначает номер входа/выхода устройства.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Подключение программы _tag2crv.pas

Для подключения **`_tag2crv.pas`** надо включить в конфигурацию примерно такой текст:

``` ini
[DeviceList]
&DEMO.TAG2CRV = device software program
[&DEMO.TAG2CRV]
Comment        = Tag(s) <==> curve(s) data copier.
InquiryPeriod  = 1
DevicePolling  = 100, tpNormal
ProgramSource  = ~~\resource\daqsite\stdlib\daqpas\_tag2crv.pas
OpenConsole    = 2
DebugFlags     = 3
AnalogFifo     = 1024
DigitalFifo    = 1024
DigitalOutputs = 2                                 ; 1) Копировать теги Demo1,Demo2 в кривые
tagDO#0        = Demo1                             ;    Можно указать имя копируемого тега явно
Link DigitalOutput 0 with curve Demo1 history 100  ;    Чтобы копировать указанный тег в подключенную кривую
Link DigitalOutput 1 with curve Demo2 history 100  ;    Можно копировать тег в одноименную ему подключенную кривую
AnalogInputs   = 2                                 ; 2) Копировать кривые Data1,Data2 в теги
tagAI#0        = Data1                             ;    Можно указать имя тега - приемника явно
Link AnalogInput 1 with curve Data1                ;    Чтобы копировать подключенную кривую в указанный тег
Link AnalogInput 1 with curve Data2 history 100    ;    Можно копировать подключенную кривую в одноименный тег
[]
[TagList]                                          ; Используемые теги
Demo1 = integer 0                                  ; Могут быть целыми
Demo2 = real    0                                  ; или вещеcтвенными
Data1 = real    0
Data2 = real    0
[]
[DataStorage]                                      ; Используемые кривые
Demo1 = Curve 0 100 Black 0 1
Demo2 = Curve 0 100 Black 0 1
Data1 = Curve 0 100 Black 0 1
Data2 = Curve 0 100 Black 0 1
[]
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

> Желаем успешного использования программы **`_tag2crv.pas`**!

---
