 {
 ***********************************************************************
 Daq Pascal application program EmlSrv.
 E-Mail server to send e-mails via SMPT.
 Uses free SENDEMAIL.EXE by Brandon Zehm,
 see http://caspian.dotconf.net/
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
 [@Help]
 |Command list: StdIn "@cmd=arg" or "@cmd arg"
 |******************************************************
 | @to a1,a2,a3   - Set list of destination addresses.
 | @cc a1,a2      - Set list of carbon copy addresses.
 | @bcc a1,a2     - Set list of blind carbon copy addresses.
 | @from s        - Set sender address s.
 | @server s      - Set SMTP server s.
 | @subject s     - Set subject "s".
 | @attachment f  - Attach file(s) f, space-separated list.
 | @username u    - Set user name u.
 | @password p    - Set user password p.
 | @timeout t     - Set timeout to send mail, ms.
 | @options s     - Set another cmd line options.
 | @> s           - Add line s to e-mail content.
 | @send          - Send email specified by above items.
 | @clear         - Clear buffers before new mail.
 | @test n        - Test mail sender.
 |******************************************************
 | Example:
 | [DAQ]
 | [DeviceList]
 | &EmlSrv = device software program
 | [&EmlSrv]
 | Comment       = E-Mail server to send e-mails via SMPT
 | InquiryPeriod = 1
 | DevicePolling = 1000, tpIdle
 | ProgramSource = ~~\resource\daqsite\emailserver\emlsrv.pas
 | OpenConsole   = 2
 | DebugFlags    = 15
 | [DAQ]
 | SearchPath = ~~\resource\tools\sendemail
 | []
 | ...
 | if DevSend(RefFind('Device &EmlSrv'),
 |    '@clear'+EOL
 |   +'@to kouriakine@mail.ru,yvinogra@mail.ru'+EOL
 |   +'@cc alexei.kuryakin@cern.ch'+EOL
 |   +'@bcc admilink@mail.ru'+EOL
 |   +'@from admilink@mail.ru'+EOL
 |   +'@subject Test message'+EOL
 |   +'@server smtp.mail.ru:25'+EOL
 |   +'@username admilink'+EOL
 |   +'@password YOUR_PASSWORD'+EOL
 |   +'@timeout 10000'+EOL
 |   +'@> That is test message.'+EOL
 |   +'@> Please don''t reply.'+EOL
 |   +'@send'+EOL+'@clear'+EOL)>0
 | then Success('Success!')
 | else Trouble('Failure!');
 |******************************************************
 []
 }
program EMLSRV;                  { E-Mail server to send e-mails    }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 DefaultTimeout    = 5000;       { Default timeout to send mail, ms }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 Mail_to           : String;     { Destination address list         }
 Mail_cc           : String;     { Carbon copy address list         }
 Mail_bcc          : String;     { Blind carbon address list        }
 Mail_from         : String;     { Sender address                   }
 Mail_exec         : String;     { Executable path                  }
 Mail_folder       : String;     { Mailbox directory                }
 Mail_server       : String;     { SMTP server                      }
 Mail_subject      : String;     { Subject                          }
 Mail_options      : String;     { Another  cmd line options        }
 Mail_attachment   : String;     { Attacment file(s), space-sep.list}
 Mail_content      : String;     { Text of e-mail, < 16 kBytes      }
 Mail_username     : String;     { User name                        }
 Mail_password     : String;     { User password                    }
 Mail_timeout      : Real;       { Timeout to send emails, ms       }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Clear Mail server.
 }
 procedure Mail_Clear(Mode:Integer);
 begin
  Mail_to:='';
  Mail_cc:='';
  Mail_bcc:='';
  Mail_from:='';
  Mail_timeout:=DefaultTimeout;
  if Mode>0 then Mail_exec:='';
  if Mode>0 then Mail_folder:='';
  Mail_server:='';
  Mail_subject:='';
  Mail_options:='';
  Mail_attachment:='';
  Mail_content:='';
  Mail_username:='';
  Mail_password:='';
 end;
 {
 Initialize Mail server.
 }
 procedure Mail_Init;
 var code:Integer;
 begin
  Mail_Clear(1);
  if IsWindows then Mail_exec:=ParamStr('FileSearch sendemail.exe');
  if IsUnix then Mail_exec:=RunSysCommandAsText('unix which sendemail','','',code,3000);
  if not FileExists(Mail_exec) then begin
   Trouble('Could not find mail sender '+Mail_exec);
   Mail_Clear(1);
  end else begin
   Success('Mail sender found: '+Mail_exec);
   Mail_folder:=AddBackSlash(ParamStr('DaqDataPath'))+AdaptFileName('MailBox');
   if not MkDir(Mail_folder) then begin 
    Trouble('Could not MkDir '+Mail_folder);
    Mail_Clear(1);
   end else begin
    Success('Mailbox: '+Mail_folder);
   end;
  end;
 end;
 {
 Free mail server.
 }
 procedure Mail_Free;
 begin
  Mail_Clear(1);
 end;
 {
 Send e-mail via sendemail.exe.
 }
 procedure Mail_Send;
 var i,tid,pid:Integer; log,txt,lin,tmp:String; ms:Real;
  function GetCmd(HidePassword:Boolean):String;
  var opt,psw:String; i:integer;
  begin
   opt:=''; psw:='';
   if HidePassword
   then for i:=1 to Length(Mail_password) do psw:=psw+'*'
   else psw:=Mail_password;
   if Length(Mail_to)>0       then opt:=opt+' -t '+Mail_to;
   if Length(Mail_cc)>0       then opt:=opt+' -cc '+Mail_cc;
   if Length(Mail_bcc)>0      then opt:=opt+' -bcc '+Mail_bcc;
   if Length(Mail_from)>0     then opt:=opt+' -f '+Mail_from;
   if Length(Mail_server)>0   then opt:=opt+' -s '+Mail_server;
   if Length(Mail_subject)>0  then opt:=opt+' -u "'+Mail_subject+'"';
   if Length(Mail_username)>0 then opt:=opt+' -xu '+Mail_username;
   if Length(Mail_password)>0 then opt:=opt+' -xp '+psw;
   if Length(Mail_options)>0  then opt:=opt+' '+Mail_options;
   if Length(Mail_attachment)>0 then opt:=opt+' -a '+Mail_attachment;
   opt:=opt+' -o timeout='+Str(Round(0.75*Mail_timeout/1000));
   opt:=opt+' -o message-file='+ExtractFileName(txt)+ExtractFileExt(txt);
   opt:=opt+' -l '+ExtractFileName(log)+ExtractFileExt(log);
   GetCmd:=Mail_exec+opt;
   opt:=''; psw:='';
  end;
 begin
  log:=''; txt:=''; lin:=''; tmp:='';
  if (Length(Mail_exec)>0) then begin
   if (Length(Mail_folder)>0) and MkDir(Mail_folder) then begin
    {
    Calculate name of uses files
    }
    ms:=mSecNow;
    pid:=Val(Trim(GetEnv('CRW_DAQ_SYS_EXE_PID')));
    txt:=AddBackSlash(Mail_folder)+Str(pid)+'.txt';
    log:=AddBackSlash(Mail_folder)+Copy(StrReplace(GetDateTime(ms),dump('.'),'',3),1,8)+'.log';
    {
    Write content to file.
    }
    if Rewrite(txt)=0 then Write(Mail_content) else Trouble('Could not rewrite '+txt);
    if Append('')<>0 then Trouble('Could not append console!');
    {
    Write log
    }
    if FileExists(log) then i:=Append(log) else i:=Rewrite(log);
    if i=0
    then Writeln(EOL,GetDateTime(ms),' -> ',GetCmd(True),EOL,Mail_content,'[END]')     
    else Trouble('Could not write to '+log);
    if Append('')<>0 then Trouble('Could not append console!');
    {
    Run sendemail.exe
    Wait for completion or Timeout
    }
    tid:=Task_Init('');
    sNul(Task_Ctrl(tid,'Display=0'));
    sNul(Task_Ctrl(tid,'HomeDir='+Mail_folder));
    sNul(Task_Ctrl(tid,'CmdLine='+GetCmd(False)));
    sNul(Task_Ctrl(tid,'StdInPipeSize='+Str(16*1024)));
    sNul(Task_Ctrl(tid,'StdOutPipeSize='+Str(24*1024)));
    if Task_Run(tid) then begin
     Success('PID '+Str(Task_Pid(tid))+' started by command:');
     Success(GetCmd(True));
     ms:=msecnow;
     while (msecnow<ms+Mail_timeout) and Task_Wait(tid,0) do begin
      while Task_Readln(tid,lin,tmp) do ViewExp(lin);
      rNul(wdt_Reset(true));
      bNul(Sleep(1));
     end;
     while Task_Readln(tid,lin,tmp) do ViewExp(lin);
     if Task_Wait(tid,0)
     then Trouble('Break by timeout '+Str(Int(msecnow-ms))+' ms')
     else Success('Exit '+Str(Task_Result(tid))+', '+Str(Int(msecnow-ms))+' ms');
    end else begin
     Trouble(Task_Ctrl(tid,'CmdLine'));
    end;
    bNul(Task_Free(tid));
    bNul(FileErase(txt));
   end else Trouble('Could not MkDir '+Mail_folder);
  end else Trouble('Could not send mail!');
  log:=''; txt:=''; lin:=''; tmp:='';
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  Mail_to:='';
  Mail_cc:='';
  Mail_bcc:='';
  Mail_from:='';
  Mail_exec:='';
  Mail_folder:='';
  Mail_server:='';
  Mail_subject:='';
  Mail_options:='';
  Mail_attachment:='';
  Mail_content:='';
  Mail_username:='';
  Mail_password:='';
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  Mail_Init;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  Mail_Free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; i,n:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {}
   if IsSameText(cmd,'@to') then begin
    Mail_to:='';
    n:=WordCount(arg);
    for i:=1 to n do
    if i=1 then Mail_to:=Mail_to+ExtractWord(i,arg)
           else Mail_to:=Mail_to+','+ExtractWord(i,arg);
    Success(cmd+'='+Mail_to);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@cc') then begin
    Mail_cc:='';
    n:=WordCount(arg);
    for i:=1 to n do
    if i=1 then Mail_cc:=Mail_cc+ExtractWord(i,arg)
           else Mail_cc:=Mail_cc+','+ExtractWord(i,arg);
    Success(cmd+'='+Mail_cc);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@bcc') then begin
    Mail_bcc:='';
    n:=WordCount(arg);
    for i:=1 to n do
    if i=1 then Mail_bcc:=Mail_bcc+ExtractWord(i,arg)
           else Mail_bcc:=Mail_bcc+','+ExtractWord(i,arg);
    Success(cmd+'='+Mail_bcc);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@from') then begin
    Mail_from:=ExtractWord(1,arg);
    Success(cmd+'='+Mail_from);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@subject') then begin
    Mail_subject:=Trim(arg);
    Success(cmd+'='+Mail_subject);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@options') then begin
    Mail_options:=Trim(arg);
    Success(cmd+'='+Mail_options);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@attachment') then begin
    Mail_attachment:=Trim(arg);
    Success(cmd+'='+Mail_attachment);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@username') then begin
    Mail_username:=Trim(arg);
    Success(cmd+'='+Mail_username);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@password') then begin
    Mail_password:=Trim(arg);
    Success(cmd+'='+Mail_password);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@server') then begin
    Mail_server:=ExtractWord(1,arg);
    Success(cmd+'='+Mail_server);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@>') then begin
    Mail_content:=Mail_Content+arg+EOL;
    Success(cmd+'='+arg);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@send') then begin
    Mail_Send;
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@clear') then begin
    Mail_Clear(0);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@timeout') then begin
    if not IsNan(rVal(arg)) and (rVal(arg)>0) then Mail_timeout:=rVal(arg);
    Success(cmd+'='+Str(Mail_timeout));
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@test') then begin
    n:=Val(Trim(arg));
    if(n=0) or (n=1) then
    if DevSend(RefFind('Device '+DevName),
       '@clear'+EOL
      +'@to kouriakine@mail.ru'+EOL
      +'@cc admilink@mail.ru'+EOL
      +'@bcc daqgroup@mail.ru'+EOL
      +'@from admilink@mail.ru'+EOL
      +'@subject Test message 1'+EOL
      +'@server smtp.mail.ru:25'+EOL
      +'@username admilink'+EOL
      +'@password '+base64_decode('QTdXc3F6QXRYSFhqV0gzRWFNcTU=')+EOL
      +'@timeout 10000'+EOL
      +'@> That is test message 1.'+EOL
      +'@> Please don''t reply.'+EOL
      +'@send'+EOL+'@clear'+EOL)>0
    then Success('Ok')
    else Trouble('??');
    if (n=2) then
    if DevSend(RefFind('Device '+DevName),
       '@clear'+EOL
      +'@to kouriakine@mail.ru'+EOL
      +'@from alexei.kuryakin@cern.ch'+EOL
      +'@username akuryaki'+EOL
      +'@password ***'+EOL
      +'@subject Test message 2'+EOL
      +'@server smtp.cern.ch:25'+EOL
      +'@timeout 10000'+EOL
      +'@> That is test message 2.'+EOL
      +'@> Please don''t reply.'+EOL
      +'@send'+EOL+'@clear'+EOL)>0
    then Success('Ok')
    else Trouble('??');
    if (n=3) then
    if DevSend(RefFind('Device '+DevName),
       '@clear'+EOL
      +'@to alexei.kuryakin@cern.ch'+EOL
      +'@from alexei.kuryakin@cern.ch'+EOL
      +'@subject Test message 3'+EOL
      +'@server cernmx.cern.ch:25'+EOL
      +'@timeout 10000'+EOL
      +'@> That is test message 3.'+EOL
      +'@> Please don''t reply.'+EOL
      +'@send'+EOL+'@clear'+EOL)>0
    then Success('Ok')
    else Trouble('??');
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
