@echo off
SetLocal EnableExtensions EnableDelayedExpansion

echo.
echo ****************************************************
echo CRW-DAQ Initialization script. Run on CRW-DAQ logon.
echo The script expected location is    crwdaq\resource\.
echo ****************************************************
echo.

chcp 65001

if "%CRW_DAQ_SYS_HOME_DIR%" == "" ( echo The script should be called from CRW-DAQ system only. & goto :EOF )
if "%CRW_DAQ_VAR_TMP_DIR%" == "" ( echo The script should be called from CRW-DAQ system only. & goto :EOF )

:Identification
set "scriptfile=%~f0"
set "scriptbase=%~n0"
set "scriptname=%~nx0"
for %%i in ( "%~dp0\." ) do set "scripthome=%%~fi"

set MySelf=%~f0

pushd "%~dp0.." && call :Logon %*
popd

goto :EOF

:Logon
call :EnterLogFile
call :ClearTempDir
call :CheckFpQuiEnv
call :SetFileAttrib +R Resource\DieselPascal\External\dp*.pas
call :SetFileAttrib +R Resource\DieselPascal\External\dp*.md
call :ValidateLinks
call :ValidateTools
call :ValidateUtils
call :ValidateShared
call :ValidateFolders
call :ValidateSysDlls
call :ValidateSQLook
call :ValidateLogRoll
call :ValidateLsCom
call :ValidatePyVenv
call :ValidateNppPluginsConfig
call :ValidateSendToCrwdaq
call :ValidateCrwPulser
call :ValidateDbSamples
call :ValidateKlogg
call :StartCrwdaqwatcher
call :VerifyIntegrity
call :VerifyAccessRights
call :LeaveLogFile
goto :EOF

:EnterLogFile
set "logFile=%CRW_DAQ_VAR_TMP_DIR%\%~n0.log"
echo %Date%-%Time%: >> "%logFile%"
echo Enter "%MySelf%" >> "%logFile%"
goto :EOF

:LeaveLogFile
echo %Date%-%Time%: >> "%logFile%"
echo Leave "%MySelf%" >> "%logFile%"
goto :EOF

:ClearTempDir
echo ClearTempDir: >> "%logFile%"
pushd "%CRW_DAQ_VAR_TMP_DIR%" && call :DoClearTempDir
popd
goto :EOF

:DoClearTempDir
del /F /S /Q *.lst >> "%logFile%"
del /F /S /Q *.tmp >> "%logFile%"
unix %scripthome%\crwdaqlogroll.cmd & goto :EOF & rem skip obsolete log files cleaner
set /a sizeKeep=1024*512
unix purger -ra !sizeKeep! *.* >> "%logFile%"
goto :EOF

:CheckFpQuiEnv
if exist "%ProgramFiles%\FP-QUI\FP-QUICore.exe" goto :EOF
if not exist "%CRW_DAQ_SYS_HOME_DIR%\Resource\CrwToolkit\add\fp-qui\FP-QUICore.exe" goto :EOF
set FPQUI_DIR=%CRW_DAQ_SYS_HOME_DIR%\Resource\CrwToolkit\add\fp-qui
set FPQUI_COREEXE=FP-QUICore.exe
set FPQUI_EXE=FP-QUI.exe
goto :EOF

:SetFileAttrib
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if not exist %2 goto :EOF
call attrib %1 %2
goto :EOF

:ValidateTools
echo ValidateTools: >> "%logFile%"
goto :EOF
for %%i in ( admirun.exe grun.exe specrun.exe saferun.exe unix.exe .crwtoolkit.cmd ) do (
 if not exist "%SystemRoot%\%%i" (
  cmd /C Packages\$$.cmd                            >> "%logFile%"
::cmd /C Packages\AdmiLink\InstallAdmiLink.cmd      >> "%logFile%"
  cmd /C Packages\CrwToolkit\InstallCrwToolkit.cmd  >> "%logFile%"
  goto :EOF
 )
)
goto :EOF

:ValidateShared
echo ValidateShared:                                        >> "%logFile%"
call :UpdateShared Resource\DimSite\dim\bin\*.dll           >> "%logFile%"
call :UpdateShared Resource\DimSite\dim\bin\*.manifest      >> "%logFile%"
call :UpdateShared Resource\SmiSite\smi\bin\*.dll           >> "%logFile%"
call :UpdateShared Resource\SmiSite\smi\bin\*.manifest      >> "%logFile%"
call :UpdateShared %windir%\system32\gds32.dll              >> "%logFile%"
call :UpdateShared %windir%\system32\fbclient.dll           >> "%logFile%"
goto :EOF

:UpdateShared
if "%~1" == "" goto :EOF
if exist %1 xcopy /d /v /c /i /r /f /y %1 Resource\Shared\
goto :EOF

:ValidateUtils
echo ValidateUtils: >> "%logFile%"
echo ValidateDim: >> "%logFile%"
cmd /c Resource\DimSite\dim_cmd\dim.cmd copy >> "%logFile%"
goto :EOF
echo ValidateWSO: >> "%logFile%"
unix wsoreg -i >> "%logFile%"
echo ValidateDWX: >> "%logFile%"
unix dwxreg -i >> "%logFile%"
goto :EOF

:CreateSymLinkToDir
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if exist "%~f1" == "" goto :EOF
if not exist "%~f2" == "" goto :EOF
echo Try mklink  %1  %2
mklink > nul && mklink /d %1 %2 >> "%logFile%"
if exist "%~f1" == "" goto :EOF
mklink > nul && mklink /j %1 %2 >> "%logFile%"
if exist "%~f1" == "" goto :EOF
unix junc %1 %2 >> "%logFile%"
goto :EOF

:ValidateLinks
echo ValidateLinks: >> "%logFile%"
for %%i in ( crwlib crwkit crwdaq ) do call :CreateSymLinkToDir %SystemDrive%\opt\%%i %SystemDrive%\opt\daqgroup\suite\%%i
goto :EOF

:ValidateFolders
echo ValidateFolders: >> "%logFile%"
call :MakeDirectory ..\..\works >> "%logFile%"
goto :EOF

:MakeDirectory
if "%~1" == "" goto :EOF
if exist "%~f1\" ( echo Directory exist: "%~f1" & goto :EOF )
mkdir "%~f1" &&  ( echo Make Directory: "%~f1" & goto :EOF )
echo Failed Directory: "%~f1"
goto :EOF

:ValidateSysDlls
echo ValidateSysDlls:                                       >> "%logFile%"
call :UpdateSysDlls Resource\Shared\pcrelib.dll             >> "%logFile%"
call :UpdateSysDlls Resource\Shared\borlndmm.dll            >> "%logFile%"
goto :EOF

:UpdateSysDlls
if "%~1" == "" goto :EOF
if exist %1 xcopy /d /v /c /i /r /f /y %1 %SystemRoot%\system32\
goto :EOF

:ValidateResourceShellTool
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
echo %~1 >> "%logFile%"
call :UpdateResourceShellTool %2 "%UnixRoot%\usr\local\bin\"                     >> "%logFile%"
call :UpdateResourceShellTool %2 "%CMDTOOLKIT_ROOT%\usr\local\bin\"              >> "%logFile%"
call :UpdateResourceShellTool %2 "%CRWTOOLKIT_ROOT%\usr\local\bin\"              >> "%logFile%"
call :UpdateResourceShellTool %2 "%ProgramFiles%\UnixUtils\usr\local\bin\"       >> "%logFile%"
call :UpdateResourceShellTool %2 "%ProgramFiles(x86)%\UnixUtils\usr\local\bin\"  >> "%logFile%"
call :UpdateResourceShellTool %2 "%ProgramFiles%\CmdToolkit\usr\local\bin\"      >> "%logFile%"
call :UpdateResourceShellTool %2 "%ProgramFiles(x86)%\CmdToolkit\usr\local\bin\" >> "%logFile%"
call :UpdateResourceShellTool %2 "%ProgramFiles%\CrwToolkit\usr\local\bin\"      >> "%logFile%"
call :UpdateResourceShellTool %2 "%ProgramFiles(x86)%\CrwToolkit\usr\local\bin\" >> "%logFile%"
goto :EOF

:UpdateResourceShellTool
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if exist %2 xcopy /d /v /c /i /r /f /y "%CRW_DAQ_SYS_HOME_DIR%\resource\shell\%~1" %2
goto :EOF

:ValidateSQLook
call :ValidateResourceShellTool ValidateSQLook: sqlook.cmd
goto :EOF

:ValidateLogRoll
call :ValidateResourceShellTool ValidateLogRoll: logroll.cmd
goto :EOF

:ValidateLsCom
call :ValidateResourceShellTool ValidateLsCom: lscom.cmd
goto :EOF

:ValidatePyVenv
if exist %SystemDrive%\opt\daqgroup\share\pylibs\pyvenv.cmd ( xcopy /d /v /c /i /r /f /y %SystemDrive%\opt\daqgroup\share\pylibs\pyvenv.cmd "%CRW_DAQ_SYS_HOME_DIR%\resource\shell\" )
call :ValidateResourceShellTool ValidatePyVenv: pyvenv.cmd
goto :EOF

:ValidateSendToCrwdaq
call :ValidateResourceShellTool ValidateSendToCrwdaq: sendtocrwdaq.exe
goto :EOF

:ValidateCrwPulser
call :ValidateResourceShellTool ValidateCrwPulser: crwpulser.exe
goto :EOF

:ValidateNppPluginsConfig
set "SourceNppDir=%CRW_DAQ_SYS_HOME_DIR%\resource\tools\notepad++\plugins\config"
set "TargetNppDir=%ProgramFiles%\Total Commander XP\AddOn\Alex\Notepad++\plugins\Config"
if not exist "%SourceNppDir%\" goto :EOF & if not exist "%TargetNppDir%\" goto :EOF
xcopy /d /v /c /i /r /f /y "%SourceNppDir%\*.*" "%TargetNppDir%\"
goto :EOF

:ValidateDbSamples
echo ValidateDbSamples:                                                 >> "%logFile%"
call :UpdateDbSamples "%CRW_DAQ_SYS_HOME_DIR%\demo\demo_data\*.db"      >> "%logFile%"
call :UpdateDbSamples "%CRW_DAQ_SYS_HOME_DIR%\demo\demo_data\*.fdb"     >> "%logFile%"
call :UpdateDbSamples "%CRW_DAQ_SYS_HOME_DIR%\Resource\DbSamples\*.db"  >> "%logFile%"
call :UpdateDbSamples "%CRW_DAQ_SYS_HOME_DIR%\Resource\DbSamples\*.fdb" >> "%logFile%"
goto :EOF

:UpdateDbSamples
if "%~1" == "" goto :EOF
if exist %1 xcopy /d /v /c /i /r /f /y %1 %SystemDrive%\opt\daqgroup\share\dbsamples\
goto :EOF

:ValidateKlogg
echo CheckInstalKlogg: >> "%logFile%"
set exe=%SystemDrive%\opt\daqgroup\share\klogg\klogg_portable.exe
if not exist %exe% ( call packages\klogg\installklogg.cmd >> "%logFile%" )
call :ValidateResourceShellTool ValidateKlogg: klogg.cmd
call :ValidateResourceShellTool ValidateWinTail: wintail.cmd
goto :EOF

:StartCrwdaqwatcher
set "started=Failed"
call resource\shell\grun.exe -h -c resource\crwdaqwatcher.cmd %CRW_DAQ_SYS_EXE_PID% %CRW_DAQ_SYS_SESSION_HEAD% && set "started=Succeed"
echo StartCrwdaqwatcher %CRW_DAQ_SYS_EXE_PID% %CRW_DAQ_SYS_SESSION_HEAD% = %started% >> "%logFile%"
goto :EOF

:VerifyIntegrity
call "%CRW_DAQ_SYS_HOME_DIR%\Resource\crwdaq.verify.cmd" >> "%logFile%"
goto :EOF

:VerifyAccessRights
unix -q 1>nul 2>nul && (
 unix ismemberof admins 1>nul 2>nul || ( call :AccessRightsFailure & goto :EOF )
 call :AccessRightsSuccess
 goto :EOF
)
net session 1>nul 2>nul || ( call :AccessRightsFailure & goto :EOF )
call :AccessRightsSuccess
goto :EOF
:AccessRightsSuccess
call :NotifySuccessUAC "crwdaq.exe: run as [%UserName%] with ADMIN rights."
goto :EOF
:AccessRightsFailure
call :NotifyFailureUAC "crwdaq.exe: run as [%UserName%] with USER rights, but ADMIN required."
goto :EOF

:NotifySuccess
if "%~1" == "" goto :EOF
call :Tooltip text "%~1" delay 15000    preset stdSuccess
goto :EOF
:NotifyFailure
if "%~1" == "" goto :EOF
call :Tooltip text "%~1" delay 86400000 preset stdSiren
goto :EOF

:NotifySuccessUAC
if "%~1" == "" goto :EOF
call :Tooltip text "%~1" delay 15000    preset stdSuccess ico uac.ico
goto :EOF
:NotifyFailureUAC
if "%~1" == "" goto :EOF
call :Tooltip text "%~1" delay 86400000 preset stdSiren   ico uac.ico
goto :EOF

:Tooltip
if "%~1" == "" goto :EOF
call "%CRW_DAQ_SYS_HOME_DIR%\Resource\Shell\tooltip.cmd" %*
goto :EOF
