 {
 Example for config\_timerp.cfg
 Config file interface:
 [program1]
 AnalogInputs = 0
 DigitalInputs = 0
 AnalogOutputs = 2
 DigitalOutputs = 0
 Calibrations = 0
 DebugMode = 3
 Link AnalogOutput 0 with curve event
 Link AnalogOutput 1 with curve interval
 ProgramSource = ..\DaqPas\_timerp
 }
program _timerp;
const
 voice0='бульк';
 voice1='чпок';
 voice2='чик';
var
 tm : real;    {timer reference}
 ev : boolean;
 b  : boolean;
 t  : real;
 n  : integer;
begin
 {start measure}
 if runcount=1 then begin
  n:=reset('');
  n:=rewrite('');
  writeln('Start timer & sound test program');
  tm:=tm_new;                      {create new timer}
  if not( tm_addint(tm,1000) and   {add interval 1 sec}
          tm_addint(tm,2000) and   {add interval 2 sec}
          tm_addint(tm,3000) and   {add interval 3 sec}
          tm_start(tm) )           {run timer}
  then begin
   writeln('Timer failure!');
   if tm_free(tm) then writeln('Timer free.');
   tm:=_nil;
  end;
 end else
 {stop measure}
 if isinf(runcount) then begin
  if tm_free(tm) then writeln('Timer free.');
  tm:=_nil;
  writeln('Stop  timer & sound test program');
 end else
 {measure cycle}
 if tm<>_nil then begin
  t:=time;               {DAQ time}
  ev:=tm_event(tm);      {event happened}
  n:=tm_curint(tm);      {number of current interval}
  b:=putao(0,t,ord(ev)); {remember event}
  b:=putao(1,t,n);       {remember interval}
  if ev then begin
   if n=0 then if voice(voice0) then writeln(voice0);
   if n=1 then if voice(voice1) then writeln(voice1);
   if n=2 then if voice(voice2) then writeln(voice2);
  end;
 end;
end.
