@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright (c) 2001-2021 Alexey Kuryakin kouriakine@mail.ru ::
:: Under MIT License, see https://opensource.org/licenses/MIT ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Utility to generate UniHeater`s simulator configuration.   ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:SetSelfInfo
set SelfArgs=%*
set "SelfExt=%~x0"
set "SelfBase=%~n0"
set "SelfFile=%~f0"
set "SelfName=%~nx0"
for %%i in (".") do set "HomeDir=%%~fi"
for %%i in ("%~dp0\.") do set "SelfDir=%%~fi"

:ParseOptions
if /i "%~1" == "/?"         goto :PrintHelp
if /i "%~1" == "-h"         goto :PrintHelp
if /i "%~1" == "--help"     goto :PrintHelp
if /i "%~1" == "--version"  goto :PrintVersion

:ParseArguments
call :RequiredParamInt UH_NumHeaters %1                     || exit /b 1    & rem Number of Unified Heaters, 1..32

:SetAddonVariables
call "%SelfDir%\demo_uniheater_init.cmd"                                    & rem Initialize environ
call :GetPrefixFile UH_PrefixFile %UH_PrefixName%                           & rem File name prefix
call :Define UH_PrefixFile %UH_PrefixName:.=_%                              & rem File name prefix

:CheckRequiredEntities
call :RequiredUnixUtils                                     || exit /b 1
call :RequiredAdminRights                                   || exit /b 1
call :RequiredParentCrwDaq                                  || exit /b 1
call :RequiredDefined UH_PrefixName                         || exit /b 1
call :RequiredDefined UH_PrefixFile                         || exit /b 1
call :RequiredDefined UH_NumHeaters                         || exit /b 1
call :RequiredDefined UH_TileNumber                         || exit /b 1
call :RequiredDefined UH_PrefixTSen                         || exit /b 1
call :RequiredDefined UH_PrefixPSen                         || exit /b 1
call :RequiredDefined UH_NumberTSen                         || exit /b 1
call :RequiredDefined UH_NumberPSen                         || exit /b 1
call :RequiredDefined UH_NickTSen                           || exit /b 1
call :RequiredDefined UH_NickPSen                           || exit /b 1
call :RequiredIntRange %UH_NumHeaters% 1 32                 || exit /b 1
call :RequiredIntRange %UH_TileNumber% 1 %UH_NumHeaters%    || exit /b 1

:Main
call :SetErrors 0
call :SetErrorLevel 0
call :SetAnsiCodePage
pushd "%SelfDir%" && call :MakeSim
popd
call :HasNoErrors || call :ErrorPrintLn "%errors% error(s) found in %SelfName%."
call :RestoreCodePage
exit /b %ERRORLEVEL%
goto :EOF

:PrintVersion
echo %SelfBase% version 1.0
goto :EOF

:PrintHelp
call :PrintVersion
echo Copyright ^(c^) 2001-2021 Alexey Kuryakin kouriakine@mail.ru
echo Utility to generate UniHeater`s simulator configuration.
echo Usage:
echo  %SelfBase% [Options] [Arguments]
echo Options:
echo  -h,--help  - print help
echo  --version  - print version
echo Arguments:
echo  UH_NumHeaters - Number of Unified Heaters, 1..32
echo Example:
echo  call %SelfBase% 16
goto :EOF

:MakeSim
call :SimEnviron
call :SimHead      >  duh_simulator.cfg
call :SimTags      >> duh_simulator.cfg
call :SimDatSrv    >> duh_simulator.cfg
call :SimMainCtrl  >> duh_simulator.cfg
call :SimScript    >> duh_simulator.cfg
call demo_uniheater_make.cmd
goto :EOF

:SimEnviron
rem   Define Name               Value               & rem Comment:
call :Define UH_PrefixName      DEMO                & rem Prefix for UniHeater
call :Define UH_NumHeaters      16                  & rem Number of Heaters
call :Define UH_TileNumber      8                   & rem Number of columns
call :Define UH_PrefixTSen      DUH.SIM.T           & rem Prefix for T sensors
call :Define UH_PrefixPSen      DUH.SIM.P           & rem Prefix for P sensors
call :Define UH_NumberTSen      16                  & rem Number of T sensors to bind
call :Define UH_NumberPSen      16                  & rem Number of P sensors to bind
call :Define UH_HistoryLen      5000                & rem History for curves
set "UH_PREF=%UH_PrefixName%.UNIHEATER"
goto :EOF

:SimHead
echo ;*****************************
echo ; Simulator for Demo_UniHeater
echo ;*****************************
echo.
goto :EOF


:SimTags
echo [DataStorage] ; Simulator curves T,P
for /l %%i in (1,1,%UH_NumberTSen%) do echo DUH.SIM.T%%i  = Curve 0 10 Black  15 1
for /l %%i in (1,1,%UH_NumberPSen%) do echo DUH.SIM.P%%i  = Curve 0 10 Black  15 1
echo []
echo.
goto :EOF


:SimDatSrv
echo [^&DATSRV] ; Data Saver
for /l %%i in (1,1,%UH_NumberTSen%) do echo CurveList = DUH.SIM.T%%i
for /l %%i in (1,1,%UH_NumberPSen%) do echo CurveList = DUH.SIM.P%%i
for /l %%i in (1,1,%UH_NumHeaters%) do echo CurveList = %UH_PREF%.TREAL_%%i
for /l %%i in (1,1,%UH_NumHeaters%) do echo CurveList = %UH_PREF%.PREAL_%%i
for /l %%i in (1,1,%UH_NumHeaters%) do echo CurveList = %UH_PREF%.GATE_%%i
for /l %%i in (1,1,%UH_NumHeaters%) do echo CurveList = %UH_PREF%.BLK_%%i
echo []
echo.
goto :EOF


:SimMainCtrl
echo [DUH.MAIN.CTRL] ; Add sensors to main control window
for /l %%i in (1,1,3) do (
echo Link sensor DEMO.UNIHEATER.BT_%%i    with tag   %UH_PREF%.ST_%%i    device ^&%UH_PREF%.CTRL
echo Link sensor DEMO.UNIHEATER.TGOAL_%%i with tag   %UH_PREF%.TGOAL_%%i device ^&%UH_PREF%.CTRL
echo Link sensor DEMO.UNIHEATER.TREAL_%%i with curve %UH_PREF%.TREAL_%%i device ^&%UH_PREF%.CTRL
echo Link sensor DEMO.UNIHEATER.GATE_%%i  with curve %UH_PREF%.GATE_%%i  device ^&%UH_PREF%.CTRL
echo Link sensor DEMO.UNIHEATER.TNAME_%%i with tag   %UH_PREF%.TNAME_%%i device ^&%UH_PREF%.CTRL
echo Link sensor DEMO.UNIHEATER.PNAME_%%i with tag   %UH_PREF%.PNAME_%%i device ^&%UH_PREF%.CTRL
echo Link sensor DEMO.UNIHEATER.PROP_%%i  with device ^&%UH_PREF%.CTRL
)
for /l %%i in (1,1,%UH_NumHeaters%) do (
if %%i LEQ 10 echo Link sensor DUH.T%%i with curve %UH_PREF%.TREAL_%%i device ^&%UH_PREF%.CTRL
if %%i LEQ 10 echo Link sensor DUH.P%%i with curve %UH_PREF%.PREAL_%%i device ^&%UH_PREF%.CTRL
)
echo Link sensor DEMO.UNIHEATER.MAKE.LM9 with device ^&%UH_PREF%.CTRL
echo []
echo.
echo [Windows]
echo DUH.T.PLOT = Curve_Window
echo [DUH.T.PLOT]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.05
echo AxisY = ^^CT_Sensors^^N^^L___{C}, 0, 1000
for /l %%i in (1,1,%UH_NumberTSen%) do echo CurveList = DUH.SIM.T%%i
echo []
echo.
echo [Windows]
echo DUH.P.PLOT = Curve_Window
echo [DUH.P.PLOT]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.05
echo AxisY = ^^CP_Sensors^^N^^L___{Bar}, 0, 2500
for /l %%i in (1,1,%UH_NumberTSen%) do echo CurveList = DUH.SIM.P%%i
echo []
echo.
goto :EOF



:SimScript
echo ;***********************************
echo ; Sumulator script to test UniHeater
echo ;***********************************
echo [DeviceList]
echo ^&DUH.SIM = device software script
echo [^&DUH.SIM]
echo Comment       = Simulator for UniHeater.
echo InquiryPeriod = 1
echo DevicePolling = 100, tpNormal
echo ScriptSection = ^&DUH.SIM.TEXT
call :LinkAI %UH_NumberTSen%
call :LinkAO %UH_NumberTSen% %UH_NumberPSen%
call :LinkDI %UH_NumberTSen%
call :SimScriptText %UH_NumberTSen%
goto :EOF
:LinkAI
echo AnalogInputs  = %1
for /L %%i in (1,1,%1) do call :LinkAIs %%i
goto :EOF
:LinkAIs
set /a ai=%1-1
echo Link AnalogInput %ai% with curve DUH.SIM.T%1
goto :EOF
:LinkAO
set /a numao=%1+%2
echo AnalogOutputs = %numao%
for /L %%i in (1,1,%1) do call :LinkAOsT %%i
for /L %%i in (1,1,%1) do call :LinkAOsP %%i %1
goto :EOF
:LinkAOsT
set /a ao=%1-1
echo Link AnalogOutput %ao% with curve DUH.SIM.T%1 history %UH_HistoryLen%
goto :EOF
:LinkAOsP
set /a ao=%1-1+%2
echo Link AnalogOutput %ao% with curve DUH.SIM.P%1 history %UH_HistoryLen%
goto :EOF
:LinkDI
set /a numdi=%1*2
echo DigitalInputs = %numdi%
for /L %%i in (1,1,%1) do call :LinkDIsBLK %%i
for /L %%i in (1,1,%1) do call :LinkDIsGAT %%i %1
goto :EOF
:LinkDIsBLK
set /a di=%1-1
if %1 GTR %UH_NumHeaters% goto :EOF
echo Link DigitalInput %di% with curve %UH_PREF%.BLK_%1  inverted bit 0 ; Heater%1  POWER
goto :EOF
:LinkDIsGAT
set /a di=%1-1+%2
if %1 GTR %UH_NumHeaters% goto :EOF
echo Link DigitalInput %di% with curve %UH_PREF%.GATE_%1          bit 0 ; Heater%1  SSR
goto :EOF
:SimScriptText
echo []
echo [^&DUH.SIM.TEXT]
echo var runcount
echo runcount=runcount+1
echo Noise=0.0
echo RoomTemp=20
echo HeatRate=1e-1
echo CoolRate=1e-4
echo nchan=NumAis()
echo i=0
echo modes=vnew(nchan)
for /l %%i in (1,1,%1) do echo var tagMode%%i
for /l %%i in (1,1,%1) do echo if not(tagMode%%i) then tagMode%%i=@findtag %UH_PREF%.MODE_%%i
for /l %%i in (1,1,%1) do echo vput(modes,%%i-1,iGetTag(tagMode%%i))
echo Loop:
echo  j=i+nchan
echo  pow=eq(getdi_yn(i),0)
echo  ssr=ne(getdi_yn(j),0)
echo  temp=getai_yn(i)+RoomTemp*eq(runcount,1)
echo  if eq(vget(modes,i),0) then temp=temp+pow*ssr*HeatRate-(temp-RoomTemp)*CoolRate
echo  if eq(vget(modes,i),1) then temp=temp-pow*ssr*HeatRate-(temp-RoomTemp)*CoolRate
echo  temp=temp+Noise*random(-1,1)
echo  pres=temp/2
echo  putao(i, time(), temp)
echo  putao(j, time(), pres)
echo  i=i+1
echo if lt(i,nchan) then goto Loop
echo vfree(modes)
echo []
echo.
echo ;**********************************
echo ;*** Speak server for UniHeater ***
echo ;**********************************
echo [^&%UH_PREF%.CTRL]
echo UsesSpeakSrv = 1
echo []
echo.
goto :EOF



::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Common library routines                                                    ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:Define
if "%~1" == "" goto :EOF & rem Environ Variable Name
if "%~2" == "" goto :EOF & rem Environ Variable Value
if not defined %~1 set "%~1=%~2"
goto :EOF

:exec
echo %*
call %*
goto :EOF

:GetPrefixFile
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
for /f "tokens=* delims=" %%i in ('echo %~2^|unix replacestr -l . _ 2^>nul') do set "%~1=%%i"
goto :EOF

:RequiredParamStr
if "%~1" == "" goto :EOF
if not "%~2" == "" set "%~1=%~2"
if defined %~1 exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : missed string param %~1. Call %SelfName% --help for details."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredParamInt
if "%~1" == "" goto :EOF
if not "%~2" == "" set /a "%~1=%~2"
if defined %~1 exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : missed integer param %~1. Call %SelfName% --help for details."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredAdminRights
net session 1>nul 2>nul && exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : Access denied. Admin rights required."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredUnixUtils
if defined UnixRoot call unix %* 1>nul 2>nul && exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : UnixUtils is not valid. Install UnixUtils first."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredParentCrwDaq
if not defined CRW_DAQ_SYS_EXE_PID  goto :FailureParentCrwDaq
if not defined CRW_DAQ_SYS_HOME_DIR goto :FailureParentCrwDaq
if not defined CRW_DAQ_SYS_EXE_FILE goto :FailureParentCrwDaq
if not exist %CRW_DAQ_SYS_HOME_DIR% goto :FailureParentCrwDaq
call :TaskExePidIsRunning "%CRW_DAQ_SYS_EXE_FILE%" "%CRW_DAQ_SYS_EXE_PID%" && exit /b 0
rem for %%i in ( %CRW_DAQ_SYS_EXE_FILE% ) do ( unix lsps --pid %CRW_DAQ_SYS_EXE_PID% --name %%~nxi --format pid,name 1>nul 2>nul && exit /b 0 )
:FailureParentCrwDaq
call :ErrorPrintLn "ERROR in %SelfName% : parent CRW-DAQ is not found. Run this script from CRW-DAQ."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredFile
if "%~1" == "" goto :EOF
if exist "%~f1" exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : not found %~f1."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredDefined
if not "%~1" == "" if defined %1 exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : undefined variable %~1. Call %SelfName% --help for details."
call :Sleep 5 . .
exit /b 1
goto :EOF

:RequiredIntRange
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if "%~3" == "" goto :EOF
if %1 GEQ %2 if %1 LEQ %3 exit /b 0
call :ErrorPrintLn "ERROR in %SelfName% : invalid value %~1 (not in %~2..%~3 range). Call %SelfName% --help for details."
call :Sleep 5 . .
exit /b 1
goto :EOF

:EnableCloseMenu
unix setclosemenu -e
goto :EOF

:DisableCloseMenu
unix setclosemenu -d
goto :EOF

:StartTimer
unix cltimer -start
goto :EOF

:StopTimer
unix cltimer -stop
goto :EOF

:SetAnsiCodePage
for /f "tokens=1* delims=:" %%i in ('chcp') do set /a "CodePage=%%j"
if "%CodePage%" == "866" chcp 1251 > nul & rem Set RU ANSI CodePage
goto :EOF

:RestoreCodePage
if defined CodePage chcp %CodePage% > nul
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift /1 & goto :DeleteFiles
goto :EOF

:TaskExePidIsRunning
if "%~1" == "" exit /b 1 & rem EXE name
if "%~2" == "" exit /b 1 & rem PID number
SetLocal EnableExtensions EnableDelayedExpansion
for /f "tokens=1,2*" %%i in ('tasklist /nh /fi "imagename eq %~nx1"') do if /i "%%i" == "%~nx1" if /i "%%j" == "%~2" exit /b 0
exit /b 1
goto :EOF

:Sleep
:: Usage = call :Sleep NumSeconds [StartMessage] [ProgressChar]
if "%~1" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
set /a "PingCount=%~1+1"
if not "%~2" == "" call :ErrorPrint %2
if not "%~3" == "" for /L %%i in (1,1,%1) do ( call ping -n 2 localhost 1>nul 2>nul & call :ErrorPrint %~3 )
if     "%~3" == "" call ping -n %PingCount% localhost 1>nul 2>nul
if not "%~2" == "" call :ErrorPrintLn
EndLocal
goto :EOF

:Print
if "%~1" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
if not "%~2" == "" <nul set /p "_=%~1 "
if     "%~2" == "" <nul set /p "_=%~1"
EndLocal & shift /1 & goto :Print
goto :EOF

:PrintLn
call :Print %*
echo.
goto :EOF

:ErrorPrint
1>&2 call :Print %*
goto :EOF

:ErrorPrintLn
1>&2 call :PrintLn %*
goto :EOF

:SetErrors
set /a "errors=%~1"
goto :EOF

:IncErrors
set /a "errors+=%~1"
goto :EOF

:HasNoErrors
if "%errors%" == "0" exit /b %ERRORLEVEL%
exit /b 1
goto :EOF

:SetErrorLevel
exit /b %1
goto :EOF

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: END OF FILE                                                                ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
