#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

################################################################
## Init UniHeater`s environment to make new configuration.    ##
################################################################

function fatal(){
 unix tooltip-notifier text "$scriptname: $2" preset stdError delay 60000;
 1>&2 echo -ne "\n$2\n\n";
 exit $1;
};
function call(){
 if [ $# -gt 0 ]; then
  eval "$@";
 fi;
};

source "$(dirname $(realpath ${BASH_SOURCE[0]}))/$(basename ${BASH_SOURCE[0]} | sed 's/_zero/_init/')";
if [ -z "$UH_PrefixName" ]; then fatal 1 "Error: not defined UH_PrefixName."; fi;

################################
# Current script identification.
################################
declare startupdir="$(pwd -LP)";
declare scriptfile="${BASH_SOURCE[0]}";
declare scriptname="$(basename $scriptfile)";
declare scriptbase="$(basename $scriptfile .sh)";
declare scripthome="$(dirname  $scriptfile)";
declare scriptFILE="$(realpath $scriptfile)";
declare scriptHOME="$(dirname  $scriptFILE)";

function ZeroUniHeater(){
 local FilePrefix="$(printenv UH_PrefixName | tr '.' '_')";
 FilePrefix="$(echo "$FilePrefix" | tr '[:upper:]' '[:lower:]')";
 call DeleteFiles ../config/${FilePrefix}_uniheater_bind.cfg;
 call DeleteFiles ../config/${FilePrefix}_uniheater_ctrl.cfg;
 call DeleteFiles ../config/${FilePrefix}_uniheater_dis.cfg;
 call DeleteFiles ../config/${FilePrefix}_uniheater_dic.cfg;
 call DeleteFiles ../bitmaps/barbmp_*_*_*_*.bmp;
 call DeleteFiles ../bitmaps/${FilePrefix}_uniheater_ctrl.bmp;
 call DeleteFiles ../bitmaps/${FilePrefix}_uniheater_settings.bmp;
 call DeleteFiles ../circuits/${FilePrefix}_uniheater_ctrl.crc;
 call DeleteFiles ../circuits/${FilePrefix}_uniheater_settings.crc;
};

function DeleteFiles(){
 while [ -n "$1" ]; do
  if [ -e "$1" ]; then
   rm -f "$1";
  fi;
  shift;
 done;
};

function uniheater_zero(){
 if pushd "$scriptHOME" >/dev/null 2>&1; then
  call ZeroUniHeater;
 fi;
 popd >/dev/null 2>&1;
};

uniheater_zero "$@";

##############
## END OF FILE
##############
